# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=3.2.0 --output=unicodedb_3_2_0

from rpython.rlib.rarithmetic import r_longlong


base_mod = None
version = '3.2.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x14 ABOVE LEFT TRIANGLE'
'\x14 ABOVE SLANTED EQUAL'
'\x04 ALL'
'\x05 ALLO'
'\x11 ALTERNATION MARK'
'\x05 AMPS'
'\x05 AND '
'\n AND ACUTE'
'\n AND BREVE'
'\x0e AND DIAERESIS'
'\x0e AND DOT ABOVE'
'\x10 AND HEAVY RIGHT'
'\t AND HOOK'
'\x10 AND LIGHT RIGHT'
'\x0f AND LOWER LEFT'
'\x10 AND LOWER RIGHT'
'\x0b AND MACRON'
'\x13 AND PROSGEGRAMMENI'
'\x06 AND S'
'\x15 AND SLANTED PARALLEL'
'\x0e AND SMALL TAH'
'\x12 AND SMASH PRODUCT'
'\x15 AND THREE DOTS ABOVE'
'\x12 AND YPOGEGRAMMENI'
'\x07 APLOUN'
'\t APODEXIA'
'\t ARCHAION'
'\r B BAR SYMBOL'
'\n BACKSLASH'
'\x06 BELOW'
'\x1c BETWEEN TWO HORIZONTAL BARS'
'\x06 BLOCK'
'\x07 BULLET'
'\r BZHI MIG CAN'
'\x04 C D'
'\x05 CAPO'
'\x06 CARET'
'\x05 CLEF'
'\x0f CORNER BRACKET'
'\x05 DEKA'
'\x0f DEYTEROU ICHOU'
'\r DIFFERENTIAL'
'\x0c DIMINUTION-'
'\r DIMINUTION-1'
'\x06 DIPLI'
'\x1b DIVIDED BY HORIZONTAL RULE'
'\x05 DOTS'
'\n ENCLOSURE'
'\t EQUAL TO'
'\x07 EQUALS'
'\x03 FA'
'\x05 FACE'
'\x07 FLEXUS'
'\t FORM TWO'
'\t FROM BAR'
'\n FROM WALL'
'\n FULL STOP'
'\t GARSHUNI'
'\x05 HAA '
'\x06 HANDS'
'\x03 HE'
'\r HEADED ARROW'
'\x08 HUNDRED'
'\x17 HUNDRED TWENTY-EIGHTH '
'\x07 HYPHEN'
'\x13 IN A RECTANGLE BOX'
'\x0c IN TRIANGLE'
'\x10 INSERTION POINT'
'\x0e ISOLATED FORM'
'\x02 K'
'\x07 KEFULA'
'\x05 LEFT'
'\x1a LESS THAN THE DENOMINATOR'
'\x05 LINE'
'\x0c LINE SYMBOL'
'\x05 MARK'
'\x05 MEGA'
'\x07 MUQDAM'
'\x1a NEGATED WITH VERTICAL BAR'
'\x04 NEO'
'\x04 NOT'
'\n NOTATION '
'\n NOTEHEAD '
'\x03 OF'
'\x04 OHM'
'\x0c ON PEDESTAL'
'\t OPENING '
'\t OPERATOR'
'\x0f OPERATOR WITH '
'\x04 OR '
'\x1a OR APPROXIMATELY EQUAL TO'
'\t OR EQUAL'
'\x0c OR EQUAL TO'
'\x10 OR THE IMAGE OF'
'\x08 OTTAVA '
'\x08 OVER KG'
'\x1d OVER RIGHTWARDS ARROW TO BAR'
'\x07 OVER S'
'\x18 OVER TOP SQUARE BRACKET'
'\x0c OVER TWO PI'
'\x02 P'
'\x0f PARESTIGMENON '
'\x0f POINTING INDEX'
'\x0b PROPORTION'
'\x0f QUOTATION MARK'
'\x05 REST'
'\n RESUPINUS'
'\n RGYA GRAM'
'\x06 RIGHT'
'\x0b SHOE STILE'
'\x05 SIGN'
'\x0c SKEWED LEFT'
'\r SKEWED RIGHT'
'\x07 SLOWLY'
'\x06 SMALL'
'\x08 SOLIDUS'
'\x10 SOLIDUS OVERLAY'
'\x08 SQUARED'
'\x07 STRIDE'
'\x03 SU'
'\x07 SYMBOL'
'\x05 TACK'
'\x0b TACK BELOW'
'\t THOUSAND'
'\x0f THROUGH CIRCLE'
'\x11 TO BLACK DIAMOND'
'\t TROMIKON'
'\t UNDERBAR'
'\x03 UP'
'\x0b UPPER HALF'
'\x06 WITH '
'\n WITH BASE'
'\x07 WITH C'
'\x0b WITH CARON'
'\x12 WITH CIRCLE ABOVE'
'\x12 WITH CIRCLE BELOW'
'\x10 WITH CIRCUMFLEX'
'\x17 WITH CIRCUMFLEX ACCENT'
'\n WITH CURL'
'\x07 WITH D'
'\x0c WITH DAGESH'
'\x0b WITH DASIA'
'\x0f WITH DESCENDER'
'\x0f WITH DIAERESIS'
'\t WITH DOT'
'\n WITH DOT '
'\x0f WITH DOT ABOVE'
'\x10 WITH DOT INSIDE'
'\x19 WITH DOUBLE GRAVE ACCENT'
'\x14 WITH FATHATAN ABOVE'
'\n WITH HOOK'
'\x0e WITH LONG LEG'
'\x0b WITH MAPIQ'
'\x11 WITH MIDDLE HOOK'
'\r WITH OVERBAR'
'\n WITH PLUS'
'\x1d WITH REVERSED NEGATION SLASH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\r WITH TEE TOP'
'\n WITH TICK'
'\x11 WITH TILDE ABOVE'
'\x0b WITH TITLO'
'\x0e WITH UNDERBAR'
'\x01-'
'\x11-9 QUOTATION MARK'
'\x02-A'
'\x05-ARY '
'\x05-BEAM'
'\x0c-BREAK SPACE'
'\x10-BREAKING HYPHEN'
'\x06-CREE '
'\x08-CREE RE'
'\x08-CREE TH'
'\x0e-CURRENCY SIGN'
'\x0c-DZUD RTAGS '
'\r-ESASA DOTTED'
'\x0b-FEATHERED '
'\x1b-FEATHERED RIGHTWARDS ARROW'
'\x08-HEADED '
'\x1f-HEADED ARROW FROM SMALL CIRCLE'
'\x18-HEADED RIGHTWARDS ARROW'
'\x06-HIEUH'
'\n-HIRAGANA '
'\x1e-HIRAGANA PROLONGED SOUND MARK'
'\x06-IEUNG'
'\r-INDIC DIGIT '
'\t-KHYUD PA'
'\x07-KIYEOK'
'\x0b-LINE STAFF'
'\x06-MINUS'
'\x0b-MINUS SIGN'
'\x04-ONE'
'\r-OR-PLUS SIGN'
'\r-PER-EM SPACE'
'\x06-PIEUP'
'\n-POINTING '
'\x10-POINTING ANGLE '
' -POINTING ANGLE BRACKET ORNAMENT'
'\x18-POINTING TRIANGLE WITH '
'\x15-ROUND NOTEHEAD DOWN '
'\x0c-SIMPLIFIED '
'\x05-SIOS'
'\t-STACCATO'
'\x05-TAIL'
'\x02-U'
'\x04-UM '
'\x02-W'
'\x010'
'\x011'
'\n1 PLASTICS'
'\x012'
'\n2 PLASTICS'
'\x022F'
'\x013'
'\n3 PLASTICS'
'\x014'
'\n4 PLASTICS'
'\x015'
'\n5 PLASTICS'
'\x016'
'\n6 PLASTICS'
'\x017'
'\n7 PLASTICS'
'\x018'
'\x019'
'\x01A'
'\x07A -PHRU'
'\x04A IE'
'\x05A UNA'
'\x02AA'
'\x05AADHU'
'\x04AAFU'
'\x04AAMU'
'\x08ABAAFILI'
'\x11ABBREVIATION MARK'
'\x04ABIC'
'\x04ABLE'
'\x08ABOAFILI'
'\x04ABOR'
'\x05ABOVE'
'\x06ABOVE '
'\x11ABOVE EQUALS SIGN'
'\x12ABOVE GREATER-THAN'
'&ABOVE LEFTWARDS HARPOON WITH BARB DOWN'
'\x0fABOVE LESS-THAN'
'\x16ABOVE RIGHTWARDS ARROW'
"'ABOVE RIGHTWARDS HARPOON WITH BARB DOWN"
'\x15ABOVE SHORT DOWN TACK'
'\tABOVE TO '
'\x02AC'
'\x05ACCAT'
'\x06ACCENT'
'\x07ACCENT '
'\tACE NOTE '
'\nACE SYMBOL'
'\x03ACH'
'\x0fACHES THE LIMIT'
'\x03ACK'
'\nACK CIRCLE'
'\x0bACKNOWLEDGE'
'\x08ACKSPACE'
'\x05ACRON'
'\x07ACTION '
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x15ACUTE AND HOOK SYMBOL'
'\x02AD'
'\x04ADDA'
'\nADDA WITH '
'\x05ADDAK'
'\x03ADE'
'\x04ADHE'
'\x04ADHU'
'\x10ADIAN SYLLABICS '
'\tADMA GDAN'
'\rADOWED WHITE '
'\nAEDA-PILLA'
'\nAELA-PILLA'
'\x06AESURA'
'\x02AF'
'\x08AF WITH '
'\x0eAFOREMENTIONED'
'\x03AG-'
'\x0bAGAZ DAEG D'
'\x05AGGER'
'\x03AGL'
'\x05AGMA '
'\x04AGON'
'\x06AGRANT'
'\x02AH'
'\x03AH '
'\x04AH I'
'\x08AH WITH '
'\x07AHAPAKH'
'\x02AI'
'\x0eAI LENGTH MARK'
'\x03AIL'
'\nAILED BIRD'
'\x0eAILLE PATTERN '
'\x04AILM'
'\x05AINS '
'\x08AIYANNOI'
'\x02AK'
'\x06AKABAT'
'\x03AKE'
'\x15AKIA TELOUS ICHIMATOS'
'\nAKKHANGYAO'
'\x02AL'
'\nAL BARLINE'
'\x07AL SIGN'
'\nAL SYMBOL '
'\x05AL TO'
'&AL WITH SUPERSCRIPT ALEF ISOLATED FORM'
'\x03ALA'
'\x04ALAI'
'\x05ALAPH'
'\rALATALIZATION'
'\x15ALATALIZED HOOK BELOW'
'\x05ALATH'
'\x03ALC'
'\x03ALE'
'\x08ALE SIGN'
'\x04ALEF'
'\x05ALEF '
'\nALEF LAMED'
'\rALEF MAKSURA '
'\x17ALEF MAKSURA FINAL FORM'
'\x1aALEF MAKSURA ISOLATED FORM'
'\x07ALESMA '
'\x0eALF TREE TRUNK'
'\x14ALF TRIANGULAR COLON'
'\x17ALGAMATION OR COPRODUCT'
'\tALI GALI '
'\x03ALK'
'\x03ALL'
'!ALL BUT UPPER LEFT QUADRANT BLACK'
'\nALL SQUARE'
'\x0eALLAJALALOUHOU'
'\x05ALLEY'
'\x05ALLI '
'\x08ALLIANCE'
'\x07ALLOT X'
'\x08ALLY EQU'
'\x0fALMOST EQUAL TO'
'\x05ALOG '
'\x05ALPHA'
'\x03ALT'
'\x04ALTA'
'\x0eALVEOLAR CLICK'
'\x02AM'
'\x07AM ALEF'
'\x10AM ISOLATED FORM'
'\x07AMAKKAN'
'\x05AMATS'
'\x11AMBDA WITH STROKE'
'\x05AMBOO'
'\x04AMDA'
'\x03AME'
'\x04AME '
'\x05AMED '
'\x05AMEKH'
'\x04AMIL'
'\x04AMMA'
'\x0eAMNUC PII KUUH'
'\x05AMOND'
'\x0fAMOUNT OF CHECK'
'\tAMPERSAND'
'\x04AMPI'
'\x08AMS HORN'
'\x02AN'
'\x07AN MARK'
'\x03ANA'
'\x04ANA '
'\x04ANCH'
'\x06ANCHOR'
'\x03AND'
'\x04AND '
'\tAND ACUTE'
'\x0cAND CRESCENT'
'\x1eAND JOINED BY DASH WITH SUBSET'
'\x14AND NORTH EAST ARROW'
'\x14AND NORTH WEST ARROW'
'\x0cAND OPERATOR'
'\x0fAND PARALLEL TO'
'\x14AND SOUTH EAST ARROW'
'\x14AND SOUTH WEST ARROW'
'\x04ANDA'
'\tANEROSIS '
'\x03ANG'
'\x17ANG DEPARTING TONE MARK'
'\x0cANG KHANG GY'
'\x14ANGE ANTIRESTRICTION'
'\nANGKHANKHU'
'\x05ANGLE'
'\rANGLE BRACKET'
'\x06ANGUL '
'\x07ANGULAR'
'\nANGULAR TO'
'\rANNED LEATHER'
'\x0bANNOTATION '
'\x03ANO'
'\nANO TELEIA'
'\nANS-SERIF '
'\x13ANS-SERIF CAPITAL L'
'\x06ANSIOS'
'\x04ANT '
'\x12ANTED EQUAL TO OR '
'\tANTHAKHAT'
'\x13ANTICLOCKWISE ARROW'
'\x06ANUARY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\tAOS ICHOS'
'\x02AP'
'"APANESE INDUSTRIAL STANDARD SYMBOL'
'\x06APISMA'
'\x06APITAL'
'\x08APITAL L'
'\x0eAPITAL LETTER '
'\x11APLI DYO DODEKATA'
'\x06APLI M'
'\x06APLOUN'
'\x04APON'
'\nAPOSTROPHE'
'\x04APPA'
'\x0bAPPROXIMATE'
'\x07APYEOUN'
'\x0cAPYEOUNPIEUP'
'\x02AR'
'\x03AR '
'\x04AR A'
'\x05AR AE'
'\x0cAR DIAERESIS'
'\x08AR TSHES'
'\x04ARA '
'\x13ARABIC FORM SHAPING'
'\x0bARACTER TIE'
'\x06ARADDO'
'\x12ARAGRAPH SEPARATOR'
'\nARAKALESMA'
'\x07ARALLEL'
'\x04ARB '
'\x06ARBUTA'
'\x03ARC'
'\x04ARC '
'\x17ARC ANTICLOCKWISE ARROW'
'\rARCHAIC KOPPA'
'\x08ARCHAION'
'\x07ARDROP-'
'\x13ARENTHESIS NOTEHEAD'
'\x05ARERU'
'\x05ARET '
'\x03ARG'
'\x04ARGA'
'\x04ARGI'
'\rARGOSYNTHETON'
'\x04ARIA'
'\x12ARIATION SELECTOR-'
'\x08ARISTERA'
'\tARISTERA '
'\x08ARKLEAN '
'\rARLAUG SYMBOL'
'\x04ARON'
'\x0eAROUND-PROFILE'
'\x04ARP '
'\x0bARPEGGIATO '
'\x07ARRED O'
'\x05ARROW'
'\x06ARROW '
'\x0bARROW ABOVE'
'\x1dARROW POINTING DIRECTLY RIGHT'
'\tARROWHEAD'
'\x06ARSEOS'
'\x08ARSI YEH'
'\x06ARTER '
'\x04ARTH'
'\x13ARTIAL DIFFERENTIAL'
'\x08ARTYRIA '
'\x03ARU'
'\x14ARXIS KAI FTHORA VOU'
'\x02AS'
'\x03AS '
'\tAS MEMBER'
'\x0bASE TO THE '
'\x05ASEIA'
'\x07ASES AS'
'\x03ASH'
'\x0bASHED ARROW'
'&ASHED TRIANGLE-HEADED RIGHTWARDS ARROW'
'\x04ASIA'
'\x04ASLA'
'\x13ASOUL ISOLATED FORM'
'\nASTERISCUS'
'\x08ASTERISK'
'\x1cASTERISKS ALIGNED VERTICALLY'
'\x12ASTROLOGICAL SIGN '
'\x03ASU'
'\x07ASURED '
'\x07ASUTORU'
'\x02AT'
'\x03AT '
'\x0fATA LINK ESCAPE'
'\x05ATAF '
'\x03ATE'
'\x04ATER'
'\nATER-THAN '
'\x03ATH'
'\x08ATH MARK'
'\x04ATHA'
'\x04ATIM'
'\x05ATIN '
'\x12ATIN SMALL LETTER '
'\x0bATION POINT'
'\nATRICHISMA'
'\x04ATTO'
'\x07ATURAL '
'\x02AU'
'\x0eAU LENGTH MARK'
'\x11AUKAZ LAGU LOGR L'
'\x05AUTHS'
'\x02AV'
'\x03AVA'
'\x03AVE'
'\nAVE ACCENT'
'\tAVE ARROW'
'\x07AVIYANI'
'\x05AVROS'
'\x04AVY '
'\x02AW'
'\x03AW '
'\x05AXIMA'
'\x07AXIMATA'
'\x02AY'
'\x03AY '
'\x07AYALAM '
'\x06AYANNA'
'\x03AYB'
'\x12AYHE ISOLATED FORM'
'\x04AYIN'
'\x01B'
'\x02BA'
'\x03BAA'
'\x05BAARU'
'\tBACKSLASH'
'\rBACKSLASH BAR'
'\x06BAFILI'
'\x0eBAG MEMBERSHIP'
'\x07BAIRKAN'
'\x17BALLOON-SPOKED ASTERISK'
'\x06BALUDA'
'\x03BAN'
'\x06BANWA '
'\x03BAR'
'\x04BAR '
'\x16BAR ABOVE INTERSECTION'
'\x0fBAR ABOVE UNION'
'\x05BARB '
'\x17BARBED RIGHTWARDS ARROW'
'\x07BARLINE'
'\x06BARREE'
'\x07BARREKH'
'\x04BASA'
'\x05BASA '
'\x05BASSA'
'\x07BAYANNA'
'\x10BBREVIATION MARK'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x07BE ROOT'
'\x04BEAM'
'\x03BEE'
'\x06BEFILI'
'\x03BEH'
'\tBEH WITH '
'\x05BEITH'
'\x0fBELGTHOR SYMBOL'
'\x05BELOW'
'\x06BELOW '
'\x0fBELOW LONG DASH'
'\x03BEN'
'\x04BEND'
'\x04BER '
'\x04BERD'
'\x18BERKANAN BEORC BJARKAN B'
'\x07BESIDE '
'#BESIDE AND JOINED WITH INTERSECTION'
'\x1cBESIDE AND JOINED WITH UNION'
'\x15BESIDE RIGHT TRIANGLE'
'\x03BET'
'\x04BETA'
'\x0bBETA SYMBOL'
'\x06BETAN '
'\x04BETH'
'\x03BHA'
'\x05BHADH'
'\x02BI'
'\x03BIE'
'\x07BIG YUS'
'\x0fBINARY RELATION'
'\x05BINDI'
'\x0fBINDING BRACKET'
'\x07BINING '
'\x04BIRD'
'\x05BIRGA'
'\x06BISHOP'
'\tBJARKAN B'
'\tBKHASIAN '
'\x03BLA'
'\x05BLACK'
'\x06BLACK '
'\x18BLACK LENTICULAR BRACKET'
'\x0cBLACK SQUARE'
'\nBLACK STAR'
'\x0eBLACK TRIANGLE'
'\x0eBLADE SCISSORS'
'\x05BLANK'
'\x03BLE'
'\x08BLINEAR '
'\x05BLOCK'
'\x02BO'
'\tBO BAIMAI'
'\tBO GYFU G'
'\x06BOFILI'
'\x08BOL FOR '
'\x05BOLD '
'\x04BORE'
'\x06BOTTOM'
'\x07BOTTOM '
'\rBOTTOM CORNER'
'\x10BOTTOM HALF RING'
'\x0bBOTTOM MARK'
'#BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD'
'\x05BOVE '
'\x06BOWTIE'
'\x03BOX'
'\x02BR'
'\x03BRA'
'\x07BRACKET'
'\x11BRACKET EXTENSION'
'\x10BRACKET ORNAMENT'
'\x05BREVE'
'\x0bBREVE BELOW'
'\x07BREVIS '
'\x05BREW '
'\nBROKEN BAR'
'\tBRUL SHAD'
'\x02BS'
'\x04BSET'
'\x07BSET OF'
'\x14BSET OF NOR EQUAL TO'
'\x06BULLET'
'\x0bBUMPY ABOVE'
'\x03BUT'
'\x19BUT NOT ACTUALLY EQUAL TO'
'\x0bBUT NOT EQU'
'\x15BUT NOT EQUIVALENT TO'
'\x02BY'
'\rBY DEFINITION'
'\x0bBZHI -KHYIL'
'\x0cBZHI MIG CAN'
'\x01C'
'\x03C A'
'\x06C CLEF'
'\x13C DIGRAPH WITH CURL'
'\x16C GREATER-THAN BRACKET'
'\x02CA'
'\x03CAL'
'\x11CAL SYMBOL BOTTOM'
'\x06CALATE'
'\x0bCAN RGYINGS'
'\x11CANCELLATION MARK'
'\x08CANDICUS'
'\x07CANDRA '
'\x0bCANDRABINDU'
'\tCANG TE-U'
'\x12CANTILLATION SIGN '
'\x08CAPITAL '
'\tCAPITAL D'
'\tCAPITAL F'
'\x12CAPITAL INVERTED R'
'\tCAPITAL L'
'\x0fCAPITAL LETTER '
'\tCAPITAL Q'
'\x0bCARET TILDE'
'\x05CARON'
'\x04CART'
'\x06CATAWA'
'\x05CAUSE'
'\x07CAYANNA'
'\x06CCEEDS'
'\x05CCENT'
'\x02CE'
'\x13CE OF INTEREST SIGN'
'\x05CEDES'
'\x0bCELANDIC-YR'
'\x07CELSIUS'
'\x0cCENDING NODE'
'\tCENT SIGN'
'\x07CENTRE '
'\x14CENTRE VERTICAL LINE'
'\x03CES'
'\x02CH'
'\x03CH '
'\x03CHA'
'\nCHAD RTAGS'
'\x05CHADA'
'\x06CHADIN'
'\x08CHATTAWA'
'\tCHAVIYANI'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\x05CHED '
'\x04CHEE'
'\x04CHEH'
'\x06CHEMA '
'\x03CHI'
'\x07CHIEUCH'
'\tCHMA SIGN'
'\x06CHO CH'
'\tCHOSEONG '
'\rCHROMA SYNAFI'
'\x07CHU CAN'
'\x05CHULA'
'\x04CHWA'
'\x05CIEUC'
'\x03CIG'
'\x1aCIMAL SEPARATOR KEY SYMBOL'
'\x06CIRCLE'
'\x07CIRCLE '
'\rCIRCLE INSIDE'
'\x1bCIRCLE WITH NORTHWEST ARROW'
'\x0cCIRCLED PLUS'
'\x13CIRCLED SANS-SERIF '
'\x0fCIRCUIT-OUTPUT '
'\nCIRCUMFLEX'
'\x17CIRCUMFLEX ACCENT ABOVE'
'\x07CISSORS'
'\x02CK'
'\x07CK MARK'
')CK-TILTED SHADOWED WHITE RIGHTWARDS ARROW'
'\x06CKNESS'
'\x07CKWISE '
'\x05CLICK'
'\x05CLIFF'
'\x1aCLOCKWISE ARROW WITH MINUS'
'\x0fCLOSED BY CURVE'
'\x07CLOSURE'
'\x14CLUB-SPOKED ASTERISK'
'\x02CO'
'\x05COLON'
'\x0eCOLON OPERATOR'
'\x05COMMA'
'\x0bCOMMA ABOVE'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\x18COMPATIBILITY IDEOGRAPH-'
'\tCOMPLETED'
'\x0bCOMPOSITION'
'\x04COND'
'\x05COND '
'\x18CONSECUTIVE EQUALS SIGNS'
'\x0bCONTAIN AS '
'\x1eCONTAINING BLACK SMALL DIAMOND'
'\x1dCONTAINING BLACK SMALL SQUARE'
'\x11CONTOURED OUTLINE'
'\x03COO'
'\x06CORNER'
'\x10CORNER DOWNWARDS'
'\x10CORNER LEFTWARDS'
'\x0fCORNER WITH DOT'
'\x08COUNT OF'
'\x03CR '
'\x05CREEN'
'\tCRESCENDO'
'\x04CRET'
'\x0eCRIFICIAL WINE'
'\x06CRIPT '
'\rCRIPTION TAKE'
'\x08CRO SIGN'
'\x04CRON'
'\x05CROSS'
'\x11CROSS PUNCTUATION'
'\tCROSSING '
'\x19CROSSING NORTH EAST ARROW'
'\x02CT'
'\x15CTOR OR CROSS PRODUCT'
'\nCTORY HAND'
'\x0bCTRIC ARROW'
'\x05CUBED'
'\x18CULINE ORDINAL INDICATOR'
'\rCURLY BRACKET'
'\x16CURLY BRACKET ORNAMENT'
'\tCURRENCY '
'\x14CURRENCY SYMBOL RIEL'
'\x07CURVED '
'\x14CURVED ANGLE BRACKET'
'\x05CUTE '
'\x0bCUTE ACCENT'
'\x02CW'
'\x03CWA'
'\x04CWAA'
'\x04CYCL'
'\x01D'
'\x02D '
'\rD COMMA ABOVE'
'\x05D OF '
'\nD OF PROOF'
'\x08D RIGHT '
'\x08D SYMBOL'
'\nD TONE BAR'
'\x07D WITH '
'\nD WITH DOT'
'\x02DA'
'\tDAD WITH '
'\x06DAGESH'
'\x0fDAGESH OR MAPIQ'
'\x04DAGS'
'\x04DAIR'
'\x04DAL '
'\x05DALET'
'\x05DAMMA'
'\x08DANTAJA '
'\x04DASH'
'\nDASH ARROW'
'(DASH FROM LEFT MEMBER OF DOUBLE VERTICAL'
'\x05DASIA'
'\x0eDASIA PNEUMATA'
'\x05DATUS'
'\x07DAYANNA'
'\x02DE'
'\x0cDE MARK SIGN'
'\x03DEE'
'\x03DEI'
'\x03DEK'
'\x04DEL '
'\tDELIMITER'
'\x15DELIMITER TSHEG BSTAR'
'\x05DELTA'
'\x13DENOMINATOR SIXTEEN'
'\x0cDENTAL CLICK'
'\x11DENTAL PERCUSSIVE'
'\x06DERBAR'
'\x06DERMA '
'\x03DES'
'\tDESCENDER'
'\x05DEXIA'
'\x0eDEYTEROS ICHOS'
'\x1bDGE-TAILED RIGHTWARDS ARROW'
'\x04DGER'
'\x03DHA'
'\x05DHADH'
'\x02DI'
'\tDIAERESIS'
'\x19DIAERESIS AND HOOK SYMBOL'
'\x18DIAGONAL CROSSHATCH FILL'
'\x13DIAGONAL HALF BLACK'
'\x05DIAL '
'\x0fDIALYTIKA TONOS'
'\x07DIAMOND'
'\x07DIARGON'
'\nDIATONIKI '
'\x0bDIATONON DI'
'\x06DICINE'
'\x06DIESIS'
'\x08DIFONIAS'
'\x05DIGA '
'\x0fDIGA AELA-PILLA'
'\x07DIGAMMA'
'\x06DIGIT '
'\x15DIGRAMMOS EX DODEKATA'
'\x07DIGRAPH'
'\x0cDIGRAPH KOTO'
'\x0cDIGRAPH YORI'
'\x05DILLA'
'\x05DIPLI'
'\x07DIPLOUN'
'!DIRECT PRODUCT WITH BOTTOM CLOSED'
'\x07DISIMOU'
'\x05DIUM '
'\x06DIVIDE'
'>DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR'
'\x05DKAR '
'\x07DLE DOT'
'\x03DMA'
'\x02DO'
'\x03DO '
'\x0bDOACHASHMEE'
'\x0eDOES NOT EXIST'
'\x07DOFONON'
'\x0bDOLLAR SIGN'
'\x16DOMAIN ANTIRESTRICTION'
'\x03DON'
'\x0bDONG TSHUGS'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\tDOT BELOW'
'\x17DOT BELOW AND DOT ABOVE'
'\nDOT LEADER'
'\x0cDOT OPERATOR'
'\x14DOTLESS HEAD OF KHAH'
'\x05DOTS-'
'\x06DOTTED'
'\rDOTTED ZLAMA '
'\x07DOUBLE '
'\x0bDOUBLE AND '
'\x14DOUBLE ANGLE BRACKET'
'\x1bDOUBLE ANGLE QUOTATION MARK'
'\x11DOUBLE ARCH BELOW'
'\x0cDOUBLE ARROW'
'\rDOUBLE CIRCLE'
'\x14DOUBLE DOT TONE MARK'
'\rDOUBLE HYPHEN'
'\x15DOUBLE LEFT TURNSTILE'
'\x1bDOUBLE PRIME QUOTATION MARK'
'\x12DOUBLE PUNCTUATION'
'\rDOUBLE STROKE'
'\x10DOUBLE TURNSTILE'
'\x16DOUBLE VERTICAL STROKE'
'$DOUBLE-LINE EQUAL ABOVE GREATER-THAN'
'!DOUBLE-LINE EQUAL ABOVE LESS-THAN'
'\x0eDOUBLE-STRUCK '
'\x04DOWN'
'\x05DOWN '
'\tDOWN AND '
'\x13DOWN AND HORIZONTAL'
'\nDOWN ARROW'
'\x0cDOWN HARPOON'
'\nDOWN HEAVY'
'\x1cDOWN HEAVY AND LEFT UP LIGHT'
'\x1dDOWN HEAVY AND RIGHT UP LIGHT'
'\x15DOWN HORIZONTAL HEAVY'
'\x15DOWN HORIZONTAL LIGHT'
'\nDOWN LIGHT'
'\x10DOWN RIGHT BARB '
'\tDOWN TACK'
'\x12DOWN-OUTPUT SYMBOL'
'\tDOWNWARDS'
'\x1eDOWNWARDS AND RIGHTWARDS ARROW'
'\x0fDOWNWARDS ARROW'
'!DOWNWARDS HARPOON WITH BARB RIGHT'
'\x17DOWNWARDS THEN CURVING '
'\x16DOWNWARDS ZIGZAG ARROW'
'\x02DR'
'\x06DRAGON'
'\x16DRESSED TO THE SUBJECT'
'\x07DRIL BU'
'\x1aDROP-SHADOWED WHITE SQUARE'
'\nDS-CREE TH'
'\x03DUR'
'\tDUS RTAGS'
'\x02DY'
'\x0bDYO CHRONON'
'\x03DZE'
'\x01E'
'\x02E '
'\x07E FACE-'
'\x0fE OVER INFINITY'
'\x06E SIGN'
'\tE TSA CAN'
'\x06E WAVE'
'\x02EA'
'\x03EAF'
'\x0cEAGULL BELOW'
'\x06EAHMUK'
'\x03EAN'
'\x11EAR SCREEN SYMBOL'
'\tEARDROP-S'
'\tEART SUIT'
'\x05EARTH'
'\nEARTH MARK'
'\x05EAST '
'\x03EAT'
'\x0fEATER-THAN SIGN'
'\x04EATH'
'\x0cEATH PRODUCT'
'\x06EATHER'
'\tEAVY DOWN'
'\x1bEAVY WHITE RIGHTWARDS ARROW'
'\x08EBEEFILI'
'\nEBENSTIMME'
'\x05ECEDE'
'\x06ECEDES'
'\x07ECEMBER'
'\x03ECH'
'\x08ECH YIWN'
'\x10ECIMAL SEPARATOR'
'\x08ECTANGLE'
'\x02ED'
'-ED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE'
'\x0bED EQUAL TO'
'\nED FIGURE-'
'\x0fED PAPER SYMBOL'
'\x1cEDGE-TAILED RIGHTWARDS ARROW'
'\nEDIAL FORM'
'\x06EDILLA'
'\x02EE'
'\x04EEK '
'\rEEL OF DHARMA'
'\x05EEM I'
'\tEEM WITH '
'\x03EEN'
'\tEEN WITH '
'\x06EENTH '
'\x04EENU'
'\x04EESU'
'\x04EETA'
'\x02EF'
'\x03EF '
'\tEF SYMBOL'
'\x03EFT'
'\x04EFT '
'\x1cEFT ARC GREATER-THAN BRACKET'
'\x0eEFT HALF BLACK'
'\x08EFT HOOK'
'\x15EFT OPEN BOX OPERATOR'
'\x0fEFT PARENTHESIS'
'\x0fEFT REPEAT SIGN'
'\x13EFT-POINTING ANGLE '
'!EFT-POINTING ANGLE QUOTATION MARK'
'\x1fEFTWARDS HARPOON WITH BARB DOWN'
'\x1dEFTWARDS HARPOON WITH BARB UP'
'\rEFTWARDS TICK'
'\x03EGA'
'\x05EGALI'
'\x05EGIN '
'\x05EGL H'
'\x04EGOL'
'\x08EGORIAN '
'\x02EH'
'\x03EH '
'\x0fEH INITIAL FORM'
'\x08EH WITH '
'&EH WITH SUPERSCRIPT ALEF ISOLATED FORM'
'\x04EHEH'
'\x03EHI'
'\x02EI'
'\x05EIGHT'
'\x06EIGHTH'
'\x0cEIGHTH BLOCK'
'\x0cEIGHTH NOTES'
'\x07EIGHTHS'
'\rEIGHTHS BLOCK'
'\x06EIGHTY'
'\x06EILING'
'\x04EIRT'
'\x03EIS'
'\x05EISMA'
'\x04EIWS'
'\x02EK'
'\x03EK '
'\x08EK ONKAR'
'\x04EKAA'
'\x0bEKFONITIKON'
'\x02EL'
'\x15ELATIONAL COMPOSITION'
'\x03ELD'
'\x03ELL'
'\x08ELLIPSIS'
'\x03ELS'
'\x03ELT'
'\nELT BUCKLE'
'\x04ELTA'
'\x04ELVE'
'\x17ELVE POINTED BLACK STAR'
'\x02EM'
'\x05EMALE'
'\x06EMASTI'
'\tEMBEDDING'
'\x1bEMICIRCULAR CLOCKWISE ARROW'
'\x08EMICOLON'
'\x11EMICOLON UNDERBAR'
'\x11EMIDIRECT PRODUCT'
'\x0cEMISOFT SIGN'
'\x06EMKATH'
'\x06EMOLO-'
'\tEMPTY SET'
'\x06EMPUS '
'\x02EN'
'\x06EN BOX'
'\x0cEN FULL STOP'
'\x06EN GHE'
'\x07EN SIGN'
'\x05ENANO'
'\x14ENARMONIOS ANTIFONIA'
'\x0fENCH FRANC SIGN'
'\x0eENDED MULTIMAP'
'\x0bENG DIGRAPH'
'\rENG WITH HOOK'
'\x06ENIKI '
'\x0cENOS CHRONOU'
'\x03ENT'
'\x08ENT SIGN'
'\x1bENTATION FORM FOR VERTICAL '
'\x12ENTERING TONE MARK'
'\x0bENTHESIZED '
'\x06ENTIMA'
'\x05ENTRE'
'\x10ENTRE WHITE STAR'
'\x07ENTRED '
'\x04ENTY'
'\x05ENUTO'
'\x02EO'
'\x05EO-EU'
'\nEONGCHIEUM'
'\x02EP'
'\x05EPEAT'
'\x07EPHONE '
'\x0eEPSILON SYMBOL'
'\x10EPSILON UNDERBAR'
'\x03EQU'
'\x05EQUAL'
'\x06EQUAL '
'\x08EQUAL TO'
'\x0cEQUAL TO OR '
'\x18EQUAL TO OR GREATER-THAN'
'\x15EQUAL TO OR LESS-THAN'
'\x06EQUALS'
'\x0bEQUALS SIGN'
'\x02ER'
'\x03ER '
'\x07ER THAN'
'\x0bERCENT SIGN'
'\x07ERCIAL '
'\tERCIAL AT'
'\x06ERESIS'
'\x05ERET '
'\nERISPOMENI'
'\x05ERKHA'
'\x06ERMATA'
'\x08ERO SIGN'
'\nERO WIDTH '
'\x0cERPENDICULAR'
'\x05ERSON'
'\x0cERTICAL LINE'
'\x05ERTIE'
'\tERTY LINE'
'\x03ERU'
'\x07ES NOT '
'\tESAME DOT'
'\x03ESC'
'\x08ESCENDER'
'\x07ESCENDO'
'\x03ESH'
'\x0bESH DIGRAPH'
'\x08ESH LOOP'
'\x03ESI'
'\x0fESIDE LESS-THAN'
'\x05ESIS '
'\x05ESO E'
'\x03ESS'
'\x17ESS OUTLINED WHITE STAR'
'\x08ESS-THAN'
'\x0fESSARON CHRONON'
'\x04EST '
'\x06ESTION'
'\x0bESTION MARK'
'\x07ESTIVAL'
'\x02ET'
'\x03ET '
'\x03ETA'
'\x08ETA SIGN'
'\x04ETAL'
' ETALLED BLACK AND WHITE FLORETTE'
'\x1fETALLED OUTLINED BLACK FLORETTE'
'\x0cETARTIMORION'
'\x08ETARTOS '
'\tETER SIGN'
'\x03ETH'
'\x07ETNAHTA'
'\x05ETORU'
'\tETRASIMOU'
'\nETTA-PILLA'
'\x06ETTER '
'\x05ETTI '
'\x02EU'
'\x04EUCH'
'\x04EUNG'
'\x03EVA'
'\x03EVE'
'\x04EVEN'
'\x08EVENTEEN'
'\x12EVENTEEN FULL STOP'
'\x06EVENTY'
'\x0eEVERSE SOLIDUS'
'\x08EVERSED '
'\tEVERSED E'
'\x14EVERSED GLOTTAL STOP'
'\x1dEVERSED LUNATE EPSILON SYMBOL'
'\nEVERSED PE'
'\x04EVMA'
'\x02EW'
'\rEWDATA SQUARE'
'\x10EXCLAMATION MARK'
'\x06EXISTS'
'\x03EXT'
'\tEXTENSION'
'\x06EXTRA-'
'\x06EYANNA'
'\x05EYYAL'
'\x03EZH'
'\x0bEZH DIGRAPH'
'\x03EZI'
'\x04EZZO'
'\x01F'
'\x06F CLEF'
'\x07F DAVID'
'\x0cF TREE TRUNK'
'\x07F WITH '
'\x02FA'
'\x05FAAFU'
'\nFAHRENHEIT'
'\x05FAIHU'
'\x10FALLING DIAGONAL'
'\x16FALLING DIAGONAL SLASH'
'\x0cFALLING DOTS'
'\x06FATHA '
'\x07FAYANNA'
'\x02FE'
'\x05FEARN'
'\x0cFEATHER MARK'
'\nFEATHERED '
'\x08FEBRUARY'
'\x03FEH'
'\tFEH WITH '
'\x0eFEHU FEOH FE F'
'\x03FEI'
'\x0cFEMININE DOT'
'\x05FENCE'
'\x0cFERENCE MARK'
'\x10FFERENCE BETWEEN'
'\x02FI'
'\x05FIFTH'
'\x06FIFTHS'
'\x06FILLER'
'\x03FIN'
'\x06FINAL '
'\nFINAL FORM'
'\rFINAL LETTER '
'\tFINAL MEM'
'\rFINAL SEMKATH'
'\x0bFINAL SIGMA'
'\x04FIRE'
'\tFISH TAIL'
'\x08FISHHOOK'
'\x05FISTO'
'\x04FITA'
'\x04FIVE'
'\x12FIVE EIGHTHS BLOCK'
'\x0bFIXED-FORM '
'\rFIXED-FORM RA'
'\x02FL'
'\x05FLAKE'
'\x04FLAT'
'\tFLAT SIGN'
'\nFLATTENED '
'\x13FLORAL HEART BULLET'
'\x02FO'
'\x03FO '
'\x06FONIAS'
'\x05FORCE'
'\x04FORE'
'\x04FORK'
'\x07FORKING'
'\x14FORMS LIGHT VERTICAL'
'\x04FOUR'
'\x1cFOUR BALLOON-SPOKED ASTERISK'
'\x0fFOUR DOTS ABOVE'
'\x08FRAKTUR '
'\x08FRICAN D'
'\x08FROM BAR'
'\x02FT'
'\x03FT '
'\x05FTEEN'
'\x1cFTING POINT RIGHTWARDS ARROW'
'\nFTOGGOS OU'
'\rFTWARDS ARROW'
'\x03FTY'
'\tFULL STOP'
'\rFULL SURROUND'
'\x04FWAA'
'\x01G'
'\x02G '
'\x02GA'
'\x05GADOL'
'\x04GAIN'
'\x05GALGA'
'\x05GALI '
'\x05GAMAL'
'\x05GAMMA'
'\x06GANGIA'
'\x13GAPPED CIRCLE ARROW'
'\nGAS BZUNG '
'\x03GAT'
'\x12GATIVE ACKNOWLEDGE'
'\x03GAY'
'\x07GAYANNA'
'\x0bGAYANUKITTA'
'\x06GEADAL'
'\x06GEDOLA'
'\x11GENERIC MATERIALS'
'\x08GENITIVE'
'\x03GER'
'\x0eGERED TREMOLO-'
'\x04GGER'
'\x04GGWS'
'\x03GHA'
'\x0bGHAIN WITH '
'\x03GHT'
'\x04GHT '
'\rGHT HALF RING'
'\x0cGHT OPEN BOX'
'\x15GHT OPEN BOX OPERATOR'
'\x0fGHT REPEAT SIGN'
'\x18GHT TRIFOLIATE SNOWFLAKE'
'\x06GHUNNA'
'\x04GIBA'
'\x06GICAL '
'\x05GIMEL'
'\x08GINAL OF'
'\rGISTERED SIGN'
'\x04GIT '
'\tGITTARIUS'
'\x06GLAZ H'
'\x04GLE '
'\x0bGLE BRACKET'
'\x0cGLOTTAL STOP'
'\x18GLOTTAL STOP WITH STROKE'
'\x05GMENT'
'\x02GN'
'\x03GNO'
'\x02GO'
'\x06GO NGU'
'\x04GOAL'
'\x05GOGI '
'\x07GOLIAN '
'\x05GONEK'
'\x04GORG'
'\x05GORGI'
'\x06GORGON'
'\x04GORT'
'\x02GR'
'\x14GRA GCAN -CHAR RTAGS'
'\x04GRAL'
'\tGRAM FOR '
'\x15GRAMMOS OKTO DODEKATA'
'\x0fGRAPH SEPARATOR'
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0cGREATER-THAN'
'$GREATER-THAN ABOVE DOUBLE-LINE EQUAL'
'\x1eGREATER-THAN ABOVE EQUALS SIGN'
'\x16GREATER-THAN DIAERESIS'
'\x11GREATER-THAN NOR '
'\x18GREATER-THAN OR EQUAL TO'
'\x11GREATER-THAN SIGN'
'\x05GREE '
'\nGREE SLASH'
'\x0bGREEK CROSS'
'\x17GREEK SMALL LETTER IOTA'
'\tGRIK SIGN'
'\x0fGROUP SEPARATOR'
'\x04GRU '
'\x15GRUENT WITH DOT ABOVE'
'\x02GS'
'\x0bGSUM -KHYIL'
'\rGTER TSHEG MA'
'\x06GURAMU'
'\x05GURE '
'\x0cGXI RADICAL '
'\rGYA GRAM SHAD'
'\x01H'
'\x02H '
'\x06H NOTE'
'\rH-TYPE SYMBOL'
'\x02HA'
'\x03HAA'
'\x05HAALU'
'\nHAAPRAANA '
'\x03HAD'
'\x05HADDA'
'\x1cHADED WHITE RIGHTWARDS ARROW'
'\x14HADOWED WHITE SQUARE'
'\x08HAGALL H'
'\x03HAH'
'\x04HAH '
'\x05HAH I'
'\x10HAH INITIAL FORM'
'\x11HAH ISOLATED FORM'
'\tHAH WITH '
'\x04HAIN'
'\x05HAINU'
'\x04HAIR'
'\rHAKASSIAN CHE'
'\x03HAL'
'\x05HALA '
'\x07HALANTA'
'\x04HALF'
'\x05HALF '
'\x07HALF BL'
'\nHALF BLACK'
'\x0fHALF FILL SPACE'
'\rHALF INTEGRAL'
'\tHALF RING'
'\tHALSHELET'
'\x04HAM '
'\x06HAMZA '
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x08HAN-AKAT'
'\x15HAND INTERIOR PRODUCT'
'\x07HANGUL '
'\x17HANKED RIGHTWARDS ARROW'
'\x03HAR'
'\tHARACTER '
'\x08HARMONIC'
'\x06HARP S'
'\x08HARPOON '
'\x12HARPOON WITH BARB '
'\x0cHASIS SYMBOL'
'\x04HAVE'
'\x08HAVIYANI'
'\x07HAYANNA'
'\x02HE'
'\x06HE MGO'
'\x04HEAD'
'\x07HEADING'
'\x05HEART'
'\x1fHEART EXCLAMATION MARK ORNAMENT'
'\x04HEAT'
'\x06HEAVEN'
'\x0bHEAVEN MARK'
'\x05HEAVY'
'\x06HEAVY '
'\nHEAVY AND '
'\x0fHEAVY AND LEFT '
'\x10HEAVY AND RIGHT '
'\nHEAVY BEAT'
'\x18HEAVY BLACK HEART BULLET'
'\x03HEE'
'\x04HEEN'
'\x04HEEP'
'\x08HEG SHAD'
'\x03HEH'
'\x0fHEH MEDIAL FORM'
'\x06HEISEI'
'\x04HELL'
'\rHERICAL ANGLE'
'\x05HESS '
'\x04HETA'
'\x0bHETA SYMBOL'
'\x03HHA'
'\x02HI'
'\x07HI SIGN'
'\tHI SYMBOL'
'\x06HIBIT '
'\x04HID '
'\x06HIEUCH'
'\x05HIEUH'
'\x06HIEUKH'
'\x06HIEUPH'
'\x06HIEUTH'
'\x05HIFT '
'\x05HIGH '
'\tHIGH STOP'
'\rHIGH TONE BAR'
'\x1eHIGH-REVERSED-9 QUOTATION MARK'
'\x04HILD'
'\nHILIPPINE '
'\x03HIN'
'\x07HIN DOT'
'\x03HIP'
'\x05HIRIQ'
'\x04HIRT'
'\x07HIRTEEN'
'\x11HIRTEEN FULL STOP'
'\x05HIRTY'
'\x05HISTI'
'\x05HITE '
'\nHITE ARROW'
'\x05HIUTH'
'\x02HK'
'\x02HM'
'\x07HM SIGN'
'\x05HMER '
'\x02HO'
'\x03HO '
'\tHO SYMBOL'
'\nHOGI PIECE'
'\x04HOKE'
'\x05HOLAM'
'\x05HOLAR'
'\x05HOLE '
'\x04HOOK'
'\nHOOK ABOVE'
'\x0bHOOK SYMBOL'
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x14HORIZONTAL BAR WITH '
'\x0fHORIZONTAL DASH'
'\x11HORIZONTAL DOUBLE'
'\x0fHORIZONTAL FILL'
'\x10HORIZONTAL HEAVY'
'\x10HORIZONTAL LIGHT'
'\x11HORIZONTAL SINGLE'
'\x11HORIZONTAL STROKE'
'\x15HORIZONTAL TABULATION'
'\x04HORN'
'\x05HORSE'
'\x05HORT '
'\nHORT-TWIG-'
'\x04HOST'
'\nHOTIC HOOK'
'\x05HOUR '
'\x12HOUSANDS SEPARATOR'
'\x05HREAD'
'\x04HREE'
'\x05HREE '
'\x0bHREE BALUDA'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x0fHREE DOTS BELOW'
'\x07HROUGH '
'\x08HROUGH X'
'\x03HSA'
'\x04HSDA'
'\x1aHTORA SKLIRON CHROMA VASIS'
'\x07HUNDRED'
'\x16HUNDRED THOUSANDS SIGN'
'\x06HUR PA'
'\x13HURISAZ THURS THORN'
'\x02HW'
'\x03HWA'
'\x04HWAA'
'\tHWAZ EH E'
'\x06HYPHEN'
'\x0cHYPHEN-MINUS'
'\x02HZ'
'\x01I'
'\x02I '
'\nI ARCHAION'
'\rI LENGTH MARK'
'\x06I MAIM'
'\x05I RHO'
'\x07I RTAGS'
'\x08I SHAKTI'
'\x08I SYMBOL'
'\x16I YFESIS TETARTIMORION'
'\x02IA'
'\x08IAERESIS'
'\x08IAGONAL '
'\x03IAL'
'\x08IALYTIKA'
'\tIALYTIKA '
'\x06IAMOND'
'\x0fIAMOND UNDERBAR'
'\x06IANGLE'
'\x04IANO'
'\x06IASMA '
'\x04IBE '
'\x07IBIFILI'
'\x0bIBLE-CREE Y'
'\nICAL TAPER'
'\x03ICE'
'\x05ICHON'
'\x05ICHOS'
'\x05ICRON'
'\x13ICTLY EQUIVALENT TO'
'\nIDDLE MARK'
'\x0bIDDLE TILDE'
'\x1bIDE ARC ANTICLOCKWISE ARROW'
'\x17IDE ARC CLOCKWISE ARROW'
'\x1bIDE-HEADED RIGHTWARDS ARROW'
'\x0cIDENTICAL TO'
'\nIDEOGRAPH '
'\x0cIDEOGRAPHIC '
'\x11IDEOGRAPHIC COMMA'
'\x1aIDEOGRAPHIC ITERATION MARK'
'\x05IDGE '
'\nIDGE BELOW'
'\x0fIDING ENCLOSURE'
'\x02IE'
'\x03IES'
'\x04IEUC'
'\x05IEUNG'
'\x04IEUP'
'\x03IFF'
'\rIFIER LETTER '
'\x03IFT'
'\x06IFTEEN'
'\x10IFTEEN FULL STOP'
'\x04IFTY'
'\x02IG'
'\x06IG YUS'
'\x06IGAMMA'
'\x08IGATURE '
'\x16IGEL LONG-BRANCH-SOL S'
'\x04IGER'
'\x0bIGGLY FENCE'
'\x03IGH'
'\tIGH HAMZA'
'\x0cIGH TONE BAR'
'\x04IGHT'
'\x05IGHT '
'\tIGHT DOWN'
'\x07IGHTEEN'
'\x11IGHTEEN FULL STOP'
'\x06IGHTH '
'\x0eIGHTWARDS TICK'
'\x0eIGHTWARDS VANE'
'"IGHUR KAZAKH KIRGHIZ ALEF MAKSURA '
'\x05IGIT '
'\x04IGMA'
'\x03IGN'
'\x04IGN '
'\x0bIGN SINDHI '
'\x02IH'
'\x03IHI'
'\x05IHVUS'
'\x04IITO'
'\x02IJ'
'\x04IK H'
'\x05IKEUT'
'\x07IKHAHIT'
'\x04IKRI'
'\nIKRON ISON'
'\x05IKURU'
'\x02IL'
'\x0bIL FRAGMENT'
'\x0bILCROW SIGN'
'\x04ILDE'
'\x03ILE'
'\rILE SEPARATOR'
'\tILE TILDE'
'\nILING FACE'
'\x03ILK'
'\x06ILLAGE'
'\x07ILLEANN'
'\x04ILUY'
'\x02IM'
'\x03IMA'
'\rIMAGE BRACKET'
'\x14IMAGE OF OR EQUAL TO'
'\x08IMANSIS '
'\x03IME'
'\x0bIMEL SYMBOL'
'\x04IMES'
'\x07IMILAR '
'\x0fIMISEOS CHRONOU'
'\x05IMMA '
'\nIMPERFECTA'
'\x0fIMPERFECTA REST'
'\x1bIMPERFECTUM CUM PROLATIONE '
'\x02IN'
'\x03IN '
'\x13IN CHEN SPUNGS SHAD'
'\x16IN DEPARTING TONE MARK'
'\x06IN DOT'
'\x0bIN EQUAL TO'
'\x08IN SPACE'
'\x0bIN TRIANGLE'
'\x08IN WITH '
'\x06INAGMA'
'\nINAL SIGMA'
'\x03IND'
'\x12INDEPENDENT VOWEL '
'\x0bINDICESIMA '
'\x03INE'
'\tINE BELOW'
'\x03ING'
'\nING LARGE '
'\x0cING OPERATOR'
'\x0fING SYMBOL FOR '
'\x06INGLE '
'\x14INGLE QUOTATION MARK'
'\x04INGU'
'\nINHERENT A'
'\x03INI'
'\x05INIMA'
'\x17ININE ORDINAL INDICATOR'
'\x0cINITIAL FORM'
'\x05INITY'
'\x04INOR'
'\x06INSIDE'
'\x04INTE'
'\x08INTEGRAL'
'\x11INTEGRAL OPERATOR'
'\x0bINTEGRATION'
'\x0cINTEGRATION '
'\x15INTERSECTING LOGICAL '
'\x0cINTERSECTION'
'\x15INTERSECTION OPERATOR'
'\x18INTERSECTION WITH SERIFS'
'\x05INTHU'
'\x04INTO'
'\x03INU'
'\x17INUOUS UNDERLINE SYMBOL'
'\x04INUS'
'\x0fINUS SIGN BELOW'
'\x14INVERSE WHITE CIRCLE'
'\tINVERTED '
'\x0eINVERTED BREVE'
'\rINVERTED FORK'
'\x15INVERTED GLOTTAL STOP'
'\rINVERTED TURN'
'\x03ION'
'\x08ION SIGN'
'\x0bIOR PRODUCT'
'\x03IOS'
'\x04IOTA'
'\x02IP'
'\x07IP SIGN'
'\x05IPEHA'
'\x05IPING'
'\x0bIPLE TONGUE'
'\x04IPOD'
'\x04IPT '
'\x02IR'
'\x08IR SPACE'
'\x08IRA SIGN'
'\x08IRAGANA '
'\x03IRC'
'\x05IRCLE'
'\x06IRCLE '
'\x10IRCLE X NOTEHEAD'
'\x07IRCLED '
'\tIRCUMFLEX'
'\x10IRCUMFLEX ACCENT'
'\x0fIRCUMFLEX BELOW'
'\x08IRD MARK'
'\x03IRE'
'\x04IRGA'
'\x07IRGHIZ '
'\x03IRI'
'\x06IRINGU'
'\x04IRIQ'
'\x04IRIT'
'\x03IRO'
'\x07IRPLANE'
'\tIRST MARK'
'\x03IRT'
'\x06IRTEEN'
'\x04IRTY'
'\x0cIRTY-SECOND '
'\x03IRU'
'\x02IS'
'\x08IS-PILLA'
'\x03ISH'
'\x08ISH TAIL'
'\x07ISIBLE '
'\rISOLATED FORM'
'\x06ISSHAR'
'\x06ISSIMO'
'\x05ISTLE'
'\x02IT'
'\x03ITA'
'\x06ITABLE'
'\x07ITALIC '
'\x03ITE'
'\x04ITEM'
'\x0eITERATION MARK'
'\x04ITH '
'\x0fITH FINGERNAILS'
'\x06ITHER '
'\x15ITIAL YIG MGO MDUN MA'
'\nITING HAND'
'\x0fITION INDICATOR'
'\tITTLE YUS'
'\x03ITU'
'\x03ITY'
'\nIVALENT TO'
'\x05IVATE'
'\x03IVE'
'\x04IVE '
'\x13IVE CIRCLED NUMBER '
'\x10IVE POINTED STAR'
'\tIVINATION'
'\x0eIWAZ TIR TYR T'
'\x03IWN'
'\x03IWR'
'\x02IX'
'\x06IXTEEN'
'\x04IXTY'
'\x06IYANNA'
'\x05IYEOK'
'\x01J'
'\rJ WITH STROKE'
'\x02JA'
'\x07JARATI '
'\x08JAVIYANI'
'\x07JAYANNA'
'\x02JE'
'\x1aJECT REPLACEMENT CHARACTER'
'\x07JECTIVE'
'\x03JEE'
'\x04JEEM'
'\x05JEEM '
'\x06JEEM I'
'\x11JEEM INITIAL FORM'
'\x12JEEM ISOLATED FORM'
'\x03JER'
'\x07JERAN J'
'\tJERUSALEM'
'\rJES SU NGA RO'
'\x03JHA'
'\x03JK '
'\x0eJOINED SQUARES'
'\x06JOINER'
'\x03JOT'
'\x04JOT '
'\x14JUDEO-SPANISH VARIKA'
'\x08JUNCTION'
'\x01K'
'\x02KA'
'\x10KA- SHOG YIG MGO'
'\x03KAF'
'\x0cKANA REPEAT '
'\x12KANTAJA NAASIKYAYA'
'\x04KAPH'
'\x05KAPPA'
'\x0cKAPPA SYMBOL'
'\x05KASRA'
'\x08KATAKANA'
'\tKATAKANA '
'\x12KATAKANA-HIRAGANA '
'\x04KATO'
'\x04KAUN'
'\x03KAY'
'\x07KAYANNA'
'\x12KBAR ISOLATED FORM'
'\x02KE'
'\x03KET'
'\x06KEYCAP'
'\nKFONITIKON'
'\x02KH'
'\x05KHAH '
'\x06KHAH I'
'\x11KHAH INITIAL FORM'
'\x04KHEI'
'\x07KHIEUKH'
'\x03KIN'
'\x04KING'
'\x06KIYEOK'
'\x06KLITON'
'\x05KNIFE'
'\x06KNIFE '
'\x05KO LA'
'\x07KOMBUVA'
'\x03KOO'
'\x05KOPPA'
'\x07KORONIS'
'\x08KOUFISMA'
'\x06KRISIS'
'\x02KS'
'\tKSTREPTON'
'\x06KTIKO '
'\tKU RU KHA'
'\x13KULL AND CROSSBONES'
'\x0bKUR YIG MGO'
'\x04KURO'
'\x05KURON'
'\x05KUSMA'
'\x07KUTAARU'
'\x02KW'
'\x04KWAA'
'\x07KYLISMA'
'\x01L'
'\x02L '
'\x14L FUNCTIONAL SYMBOL '
'\x07L SEGNO'
'\x05L TAG'
'\x08L-LAKUNA'
'\rL-TYPE SYMBOL'
'\x02LA'
'*LA USED AS KORANIC STOP SIGN ISOLATED FORM'
'\x07LABIAL '
'\x05LABOR'
'\x0eLACE OF SAJDAH'
'\x04LACK'
'\x05LACK '
'\x0cLACK DIAMOND'
'\tLACKFOOT '
'\x06LAFRON'
'\x07LAGIOS '
'\x05LAGUS'
'\x11LAH ISOLATED FORM'
'\x04LAKE'
'\x03LAM'
'\x04LAM '
'\tLAM WITH '
'\x06LAMADH'
'\tLAMATION '
'\x05LAMDA'
'\x05LAMED'
'3LANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL'
'0LANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL'
'\x11LAPPING LESS-THAN'
'\x03LAS'
'\x04LASH'
'\x08LASH BAR'
'\x05LASMA'
'\x06LASTON'
'\x04LAT '
'\rLATERAL CLICK'
'\x0bLATIN CROSS'
'\x13LATIN SMALL LETTER '
'\x0fLATION FUNCTION'
'\x07LAYANNA'
'\x06LAZY S'
'\x02LC'
'\nLCROW SIGN'
'\x02LD'
'\nLD ITALIC '
'\x03LDE'
'\x02LE'
'\nLE-DELAYED'
'\x03LEF'
'\x04LEF '
'\x04LEFT'
'\x05LEFT '
'\tLEFT AND '
'\x14LEFT AND LOWER RIGHT'
'\x10LEFT ARROW ABOVE'
'\x06LEFT C'
'\x0bLEFT DOUBLE'
'\x0fLEFT DOWN BARB '
'\tLEFT HALF'
'\x0fLEFT HALF BLACK'
'\x10LEFT HALF CIRCLE'
'\x0eLEFT HALF RING'
'\x0cLEFT HARPOON'
'\nLEFT HEAVY'
'\nLEFT LIGHT'
'\x10LEFT PARENTHESIS'
'\x19LEFT PARENTHESIS ORNAMENT'
'\rLEFT QUADRANT'
'\x0bLEFT SINGLE'
'\tLEFT TACK'
'\x08LEFT TO '
'\x13LEFT TO LOWER RIGHT'
'$LEFT TORTOISE SHELL BRACKET ORNAMENT'
'\rLEFT TRIANGLE'
'\x16LEFT TRIANGLE OPERATOR'
'\x0eLEFT TURNSTILE'
'\tLEFTWARDS'
'\x0fLEFTWARDS ARROW'
'\x19LEFTWARDS ARROW WITH HOOK'
'\x1cLEFTWARDS OF DOWNWARDS ARROW'
'\x1aLEFTWARDS OF UPWARDS ARROW'
'\x0eLEFTWARDS TICK'
'\rLEGETOS ICHOS'
'\x04LEIA'
'\x0bLEICH STARK'
'\x07LEK TOO'
'\x06LEMENT'
'\tLEMENT OF'
'\x12LENTICULAR BRACKET'
'\x0cLER CONSTANT'
'\tLESS-THAN'
'!LESS-THAN ABOVE DOUBLE-LINE EQUAL'
'\x1bLESS-THAN ABOVE EQUALS SIGN'
'\x0eLESS-THAN NOR '
'\x15LESS-THAN OR EQUAL TO'
'\nLET SYMBOL'
'\x04LETE'
'\x07LETTER '
'\x0fLETTER CAPITAL '
'\x0fLETTER PALOCHKA'
'\x0fLEVEL TONE MARK'
'\x05LEVEN'
'\x0fLEVEN FULL STOP'
'\x02LF'
'\x03LF '
'\rLF RING BELOW'
'\x08LFWIDTH '
'\nLGIZ EOLHX'
'\x02LH'
'\nLHAG RTAGS'
'\x02LI'
'\x08LI GALI '
'\x05LIDUS'
'\x04LIFI'
'\x04LIFU'
'\x05LIGHT'
'\nLIGHT AND '
'\x0fLIGHT AND LEFT '
'\x10LIGHT AND RIGHT '
'\nLIGHT BEAT'
'\x06LIGION'
'\x06LIGON '
'\nLINDRICITY'
'\x04LINE'
'\x05LINE '
'\nLINE BELOW'
'\x0eLINE EXTENSION'
'\tLINE FEED'
'\x1aLINE FEED SEPARATOR SYMBOL'
'\x18LINE HORIZONTAL ELLIPSIS'
'\nLINE STAFF'
'\x12LINEAR ANNOTATION '
'\x04LING'
'\x0cLINKING MARK'
'\x14LIQUE ANGLE OPENING '
'\x06LISHA '
'\tLISSANDO '
'\x06LITIKI'
'\x0eLITTLE SECTION'
'\nLITTLE YUS'
'\x04LIWN'
'\x03LJE'
'\x02LK'
'\x03LK '
'\x02LL'
'\x07LL SIGN'
'\tLL SYMBOL'
'\tLLABLE OM'
'\x16LLAHOU ALAYHE WASALLAM'
'\tLLAR SIGN'
'\x05LLEL '
'\x04LLET'
'\x07LLIANCE'
'\x18LLING DIAGONAL CROSSING '
'\x03LLO'
'\tLM SYMBOL'
'\x0eLMOST EQUAL TO'
'\x14LMOST EQUAL TO ABOVE'
'\x02LO'
'\x04LO L'
'\rLOCATION SIGN'
'\x08LOCATIVE'
'\tLOCKWISE '
'\x08LOGICAL '
'\x0bLOGICAL AND'
'\nLOGICAL OR'
'\x03LON'
'\x0bLON SKEWED '
'\x05LONG '
'\x08LONG BAR'
'\x16LONG HORIZONTAL STROKE'
'\x08LONG LEG'
'\x08LONG S T'
'\x0fLONG VOWEL SIGN'
'\x03LOO'
'\x04LOOP'
'\x04LOOR'
'\x03LOR'
'\x0bLORAL HEART'
'\x07LORETTE'
'\x08LORRAINE'
'\x06LOSED '
'\x12LOSED CIRCLE ARROW'
'\x0bLOSING MARK'
'\x16LOSING YIG MGO SGAB MA'
'\x07LOTTAL '
'\x0bLOTTAL STOP'
'\x05LOURE'
'\x03LOW'
'\x04LOW '
'\x08LOW LINE'
'\x08LOW STOP'
'\x0cLOW TONE BAR'
'\x06LOWER '
'\x0cLOWER CORNER'
'\x0eLOWER DIAGONAL'
'\nLOWER HALF'
'\nLOWER HOOK'
'+LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\nLPAPRAANA '
'\x04LPHA'
'\x02LT'
'\x0bLT OF CLOTH'
'\x0cLTA EQUAL TO'
'\x03LTI'
'\x05LTIRE'
'\x02LU'
'\x08LUB SUIT'
'\x03LUE'
'\x04LUIS'
'\x03LUS'
'\x0cLUS NOTEHEAD'
'\x08LUS SIGN'
'\x0eLUS SIGN BELOW'
'\x03LVE'
'\rLVE FULL STOP'
'\tLVIN SIGN'
'\x02LY'
'\x03LY '
'\x18LY-RECYCLED PAPER SYMBOL'
'\x07LYGISMA'
'\x01M'
'\x06M DASH'
'\x02MA'
'\x06MACRON'
'\x05MACUS'
'\x0bMADDA ABOVE'
'\x0cMADDA ABOVE '
'\x0cMADDAH ABOVE'
'\x06MADR M'
'\x07MAGE OF'
'\x05MAI K'
'\x07MAKSURA'
'\x08MAKSURA '
'\x15MAKSURA ISOLATED FORM'
'\x1eMAKSURA WITH SUPERSCRIPT ALEF '
'\x0fMAL SUBGROUP OF'
'\x0fMALAKON CHROMA '
'\x04MALL'
'\x05MALL '
'\rMALL CAPITAL '
'\x0bMALL CIRCLE'
'\x11MALL CIRCLE ABOVE'
'\x18MALL CIRCLE TO THE RIGHT'
'\rMALL LETTER J'
'\rMALL LETTER Z'
'\x0bMALL SQUARE'
'\x05MALON'
'\x03MAN'
'\x0cMAN NUMERAL '
'\x07MANCHU '
'\x05MANNA'
'\x0cMANNAZ MAN M'
'\x03MAP'
'\x05MAPIQ'
'\x05MAQAF'
'\x07MARCATO'
'\x04MARK'
'\x05MARK '
'\x04MARU'
'\rMASORA CIRCLE'
'\x12MATHEMATICAL SPACE'
'\x0bMBA BAYANNA'
'\x05MBOL '
'\x04MBOO'
'\x07MBRELLA'
'\tMBROIDERY'
'\x02ME'
'\x0bME LONG CAN'
'\x04MEAR'
'\x0bMED RGYINGS'
'\x0bMEDIAL FORM'
'\x06MEDIUM'
'\x08MEDIUM S'
'\x04MEEM'
'\x05MEEM '
'\x0fMEEM FINAL FORM'
'\x06MEEM I'
'\x11MEEM INITIAL FORM'
'\x05MEEMU'
'\x07MEETORU'
'\x04MEGA'
'\x05MEIZI'
'\x03MEM'
'\x06MEMBER'
'\x03MEN'
'\x04MEN '
'\x07MENIAN '
'\x0eMENSION ORIGIN'
'\x04MENT'
'\x07MENT OF'
'\tMES WITH '
'\x04MESO'
'\x0cMETA STAVROU'
'\x05METEG'
'\tMETOBELUS'
'\x06METRIC'
'\x05METRY'
'\x0cMFLEX ACCENT'
'\tMHANCHOLL'
'\x02MI'
'\x03MI '
'\x07MIDDLE '
'\x10MIDDLE AND BELOW'
'\x10MIDDLE AND RIGHT'
'\x0fMIDDLE DIAGONAL'
'\nMIDDLE DOT'
'\x0bMIDDLE HOOK'
'\x0cMIDDLE PIECE'
'\x0bMIDDLE STEM'
'\x10MIDIRECT PRODUCT'
'\x05MIEUM'
'\x04MIL '
'\x06MILAR '
'\nMILLE SIGN'
'\rMILLIONS SIGN'
'\x03MIM'
'\x12MINAL DIGIT SHAPES'
'\x04MINI'
'\x07MINIMA '
'\x05MINUS'
'\nMINUS SIGN'
'\rMINUS SIMILAR'
'\rMINUS WHITE X'
'\x02MM'
'\x03MMA'
'\x08MMATION '
'\x0fMMER AND SICKLE'
'\x02MO'
'\x1eMODIFIER LETTER LEFT HALF RING'
'\tMODYNAMIC'
'\x03MOI'
'\x08MON TIME'
'\nMONOFONIAS'
'\x1cMONOGRAMMOS TESSERA DODEKATA'
'\nMONOSPACE '
'\x03MOO'
'\x0bMOST EQUAL '
'\x08MOTHETIC'
'\x0eMOTHETIC ABOVE'
'\x08MOUNTAIN'
'\x0bMOVED BELOW'
'\x02MP'
'\x05MPARE'
'\x08MPERSAND'
'\x0cMPHASIS MARK'
'\tMPLIFIED '
'\x0cMPTY CENTRE '
'\x02MU'
'\x04MUIN'
'\x08MULTIMAP'
'\x14MULTIPLE PUNCTUATION'
'\x0eMULTIPLICATION'
'\x19MULTIPLICATION SIGN BELOW'
'\x10MULTIPLICATION X'
'\x05MUSIC'
'\x03MUT'
'\x0bMUUSIKATOAN'
'\x04MWAA'
'\x03MZA'
'\x0fMZA ABOVE WITH '
'\x01N'
'\x02N '
'\x06N DASH'
'\x0cN ELEMENT OF'
'\x06N SIGN'
'\x06N YANG'
'\x0fN-ARY SUMMATION'
'\x08N-JOINER'
'\x02NA'
'\nNAASIKYAYA'
'\x05NABLA'
'\x05NADA '
'\x05NAG G'
'\x04NAL '
'\x08NAM BCAD'
'\x04NANA'
'\x07NANCIAL'
'\nNANGMONTHO'
'\rNAP PIZZICATO'
'\x03NAR'
'\nNASPIRATED'
'\x05NATE '
'\x0cNATURAL SIGN'
'\x06NAUD N'
'\x11NAUDIZ NYD NAUD N'
'\x08NAVIYANI'
'\x07NAYANNA'
'\x08NCE SIGN'
'\x04NCEL'
'\x05NCHU '
'\x04NCIL'
'\x0cNCK CONSTANT'
'\tNCLOSING '
'\x12NCTION APPLICATION'
'\x02ND'
'\x03ND '
'\nND OF AYAH'
'\x0fND OF PARAGRAPH'
'\x16ND RECORDING COPYRIGHT'
'\x13ND SLANTED PARALLEL'
'\x13ND SOUTH EAST ARROW'
'\x13ND SOUTH WEST ARROW'
'\x03NDO'
'\x05NDRA '
'\tNDRABINDU'
'\x02NE'
'\x03NE '
'\rNE DOT LEADER'
'\x0fNE EIGHTH BLOCK'
'\x11NEGATIVE CIRCLED '
'\x03NEO'
'\x04NEO '
'\x07NESTED '
'\x04NET '
'\tNFORZANDO'
'\x02NG'
'\x03NG '
'\x08NG RTAGS'
'\x07NG SIGN'
'\x03NGA'
'\x06NGBAT '
'\x04NGLE'
'\x05NGLE '
'\x0cNGLE BARLINE'
'\x0cNGLE BRACKET'
'\x05NGMAN'
'\x0cNGRATULATION'
'\tNGTH MARK'
'\nNGUAGE TAG'
'\x04NGUE'
'\x02NI'
'\x03NIA'
'\x03NIB'
'\x04NIC '
'\x05NIEUN'
'\tNIGGAHITA'
'\x05NIGHT'
'\x03NII'
'\x07NIKAHIT'
'\x04NINE'
'\x08NINETEEN'
'\x12NINETEEN FULL STOP'
'\x06NINETY'
'\x04NING'
'\x04NION'
'\x06NIRUGU'
'\x06NISTER'
'\x12NITE PART INTEGRAL'
'\x0bNITIAL FORM'
'\x08NITIAL Z'
'\x19NIVERSAL RECYCLING SYMBOL'
'\x03NJE'
'\tNK SYMBOL'
'\x03NMA'
'\x02NN'
'\x0cNNED LEATHER'
'\x02NO'
'\x08NO SLASH'
'\x06NOKHUK'
'\x03NOO'
'\x04NOON'
'\x0fNOON FINAL FORM'
'\nNOON WITH '
'\x06NOR BU'
' NORMAL FACTOR SEMIDIRECT PRODUCT'
'\x0fNORMAL SUBGROUP'
'\x12NORMAL SUBGROUP OF'
'\x10NORTH EAST ARROW'
'\x10NORTH WEST ARROW'
'\x04NOT '
'\x0fNOT APPROXIMATE'
'\tNOT EQUAL'
'\x0cNOT EQUAL TO'
'\x16NOT INCLUDING THE POLE'
'\x08NOT SIGN'
'\x0fNOT TILDE ABOVE'
'\x04NOTE'
'\tNOTEHEAD '
'\x04NOUT'
'\x08NOVEMBER'
'\x03NOW'
'\x04NPEA'
'\x03NSU'
'\x06NSUZ A'
'\x15NSVERSAL INTERSECTION'
'\x05NSYON'
'\x02NT'
'\x10NT SCREEN SYMBOL'
')NT-TILTED SHADOWED WHITE RIGHTWARDS ARROW'
'\x07NTAINS '
'\tNTERPRISE'
'\x06NTEVMA'
'\x07NTICAL '
'"NTICLOCKWISE-ROTATED DIVISION SIGN'
'\x06NTIIMU'
'\x15NTISTRY SYMBOL LIGHT '
'\x04NTOC'
'\x06NTOGEN'
'\tNTRACTION'
'\x03NTY'
'\rNTY FULL STOP'
'\x02NU'
'\x0cNUITY SYMBOL'
'\x05NUKTA'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\nNUMBER TEN'
'\x0bNUMBER ZERO'
'\x08NUMERAL '
'\x0cNUMERAL SIGN'
'\nNUMERATOR '
'\rNUMERATOR ONE'
'\x03NUN'
'\x08NUS SIGN'
'\x07NUSVARA'
'\x0bNUSVARA ONE'
'\tNUSVARAYA'
'\tNVERTED R'
'\x0fNVERTED UBADAMA'
'\x02NW'
'\x04NWAA'
'\x0bNWHEEL STAR'
'\x02NY'
'\x07NYI ZLA'
'\x0eNYI ZLA NAA DA'
'\x04NYIS'
'\x0bNYIS -KHYIL'
'\x03NYO'
'\x12NYOOGA NAAKSIKYAYA'
'\x01O'
'\x02O '
'\x05O ANG'
'\x03O B'
'\x05O KAI'
'\x04O MA'
'\x03O N'
'\x05O PLA'
'\x05O RUA'
'\x06O SIGN'
'\x08O SYMBOL'
'\x03O Y'
'\x0cOACTIVE SIGN'
'\nOANDAKHIAT'
'\x04OBAT'
'\x06OBELUS'
'\rOBLIQUE LINE '
'\x08OBOOFILI'
'\x07OCALIC '
'\x08OCALIC R'
'\x06OCIETY'
'\x03OCK'
'\x07OCTOBER'
'\x06ODHADH'
'\x04ODO '
'\x02OE'
'\x03OE '
'\x03OEH'
'\x04OENG'
'\x02OF'
'\tOF STIMME'
'\x06OFOUND'
'\x08OFT SIGN'
'\x02OG'
'\x03OGH'
'\x06OGONEK'
'\rOGOTYPE SIGN '
'\tOGRAPHIC '
'\x02OH'
'\x15OHAMMAD ISOLATED FORM'
'\x0cOHAZARD SIGN'
'\x08OHM SIGN'
'\x06OICING'
'\x0cOID NOTEHEAD'
'\x03OIN'
'\x05OINT '
'\x07OINTED '
'\x11OINTED BLACK STAR'
'\x03OIX'
'\x02OK'
'\x08OK ABOVE'
'\x05OKEN '
'\tOKOUFISMA'
'\x02OL'
'\x04OLAM'
'\x03OLD'
'\x03OLE'
'\x06OLIDUS'
'\x0fOLIDUS OPERATOR'
'\x0eOLIDUS OVERLAY'
'\x03OLL'
'\nOLLAR SIGN'
'\x04OLON'
'\nOLON EQUAL'
'\x0eOLUME INTEGRAL'
'\x02OM'
'\rOMAN NUMERAL '
'\x04OMBU'
'\x05OMEGA'
'\x05OMIKO'
'\x04OMMA'
'\x05OMMA '
'\x08OMMA BAR'
'\nOMMA BELOW'
'\x10OMPLETE INFINITY'
'\x03OMU'
'\x02ON'
'\x03ON '
'\x0bON PEDESTAL'
'\x12ON-SPOKED ASTERISK'
'%ONCAVE-POINTED BLACK RIGHTWARDS ARROW'
'\x14ONCAVE-SIDED DIAMOND'
'\x0cOND OPERATOR'
'\x03ONE'
'\x04ONE '
'\x10ONE EIGHTH BLOCK'
'\x08ONE MARK'
'\x04ONEK'
'\x03ONG'
'\x04ONG '
'\x08ONG DASH'
'\x07ONG LEG'
'\rONG RIGHT LEG'
'\x05ONG S'
'\x0bONG-BRANCH-'
'\x04ONGA'
'\rONGRATULATION'
'\tONGSEONG '
'\x04ONON'
'\x04ONOS'
'\x0fONTOUR INTEGRAL'
'\x02OO'
'\x08OO TYPE '
'\x03OOD'
'\x03OOF'
'\x06OOMUUT'
'\x03OON'
'\rOON NOTEHEAD '
'\x04OONE'
'\x04OONU'
'\x03OOT'
'\x04OOTH'
'\x02OP'
'\x07OP MARK'
'\x05OPBAR'
'\x1eOPEN CENTRE EIGHT POINTED STAR'
'\x11OPEN CIRCLE ARROW'
'\x06OPEN E'
'\x11OPEN-HEADED ARROW'
'\x08OPENING '
'\x0cOPENING LEFT'
'\x08OPERATOR'
'\x03OPO'
'\x04OPPA'
'\x08OPRODUCT'
'\x02OR'
'\x03OR '
'\x06OR EQU'
'\x08OR EQUAL'
'\x0bOR EQUAL TO'
'#OR LOWER LEFT CURLY BRACKET SECTION'
'$OR LOWER RIGHT CURLY BRACKET SECTION'
'\x0bOR OPERATOR'
'\x07ORCULUS'
'\x15OREAN STANDARD SYMBOL'
'\x07OREVMA '
'\x05ORGON'
'\x17ORIGINAL OF OR EQUAL TO'
'\x04ORII'
'\tORINHIEUH'
'\tORIZONTAL'
'\x18ORIZONTAL BAR WITH NOTCH'
'\x0fORIZONTAL COLON'
'\x08ORM FEED'
'\x0fORMATION SOURCE'
'\x03ORN'
'\x05ORNER'
'\rORNER BRACKET'
'\x06ORONIS'
'\x06ORPIUS'
'\x04ORT '
'\x0bORT BARLINE'
'\x1aORTHOGONAL CROSSHATCH FILL'
'\x06ORTION'
'\x15ORTOISE SHELL BRACKET'
'\x04ORTY'
'\x03ORU'
'\x05ORUTO'
'\x0eOSITION SYMBOL'
'\x05OSS O'
'\x07OSS OF '
'\x0eOSTABLE SYMBOL'
'\nOSTAL MARK'
'\x08OSTROPHE'
'\x02OT'
'\x03OT '
'\x08OT ABOVE'
'\x0bOT OPERATOR'
'\x07OT SIGN'
'\x03OTA'
'\x0cOTATION MARK'
'\x04OTE '
'\rOTEHEAD BLACK'
'\x05OTERI'
'\x03OTH'
'\x05OTHAL'
'\x05OTHES'
'\rOTHIC LETTER '
'\x07OTLESS '
'\x12OTLESS DALATH RISH'
'\x06OTTED-'
'\x04OTTO'
'\x06OUBLE '
'\x0bOUBLE ACUTE'
'\x0bOUBLE ARROW'
'\x0fOUBLE BACKSLASH'
'\x0bOUBLE DANDA'
'\x04OUND'
'\tOUND SIGN'
'\x1cOUND-TIPPED RIGHTWARDS ARROW'
'\x0eOUNDED CORNERS'
'\x03OUR'
'\x08OUR DOTS'
'\nOUR FIFTHS'
'\x0cOUR INTEGRAL'
'\x10OUR POINTED STAR'
'\x05OURCE'
'\x08OURGLASS'
'\x07OURTEEN'
'\x11OURTEEN FULL STOP'
'\x03OUT'
'\x04OUT '
'\nOUTER JOIN'
'\x0fOUTH EAST ARROW'
'\x19OUTLINED RIGHTWARDS ARROW'
'\x03OVE'
'\x14OVER LEFTWARDS ARROW'
'\x16OVER LEFTWARDS HARPOON'
'\x15OVER RIGHTWARDS ARROW'
'\x17OVER RIGHTWARDS HARPOON'
'\x07OVERBAR'
'\x08OVERLAID'
'\x17OVERLAPPING LOGICAL AND'
'\x07OVERLAY'
'\x08OVERLINE'
'\x08OVERRIDE'
'\x02OW'
'\x03OW '
'\x07OW LINE'
'\x06OW TIE'
'\x13OW-9 QUOTATION MARK'
'\x04OWER'
'\x05OWER '
'\x0fOWER HALF BLACK'
'\tOWER LEFT'
'\x11OWER NUMERAL SIGN'
'\x1eOWER RIGHT DIAGONAL HALF BLACK'
'*OWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\x07OWILO S'
'\x03OWN'
'\x08OWN TACK'
'\rOWN-POINTING '
'\x04OXIA'
'\x06OYANNA'
'\x01P'
'\x02P '
'\x18P DIRECTIONAL FORMATTING'
'\x06P TACK'
'\x02PA'
'\tPAA-PILLA'
'\x05PAATO'
'\x04PACE'
'\tPADE SUIT'
'\rPAIRED ARROWS'
'\x08PAIRTHRA'
'\x0cPALATAL HOOK'
'\x06PALUTA'
'\x07PANSIOS'
'\x13PARAGRAPH SEPARATOR'
'\x0bPARAKALESMA'
'\x0bPARALLEL TO'
'\rPARALLELOGRAM'
'\x0bPARENTHESIS'
'\x14PARENTHESIS ORNAMENT'
'\x0ePARESTIGMENON '
'\x06PARKLE'
'\x11PARTING TONE MARK'
'\x05PASEQ'
'\x05PATAH'
'\x05PATAK'
'\x08PAVIYANI'
'\x04PAWN'
'\x07PAYANNA'
'\x02PE'
'\x08PE DRIVE'
'\x04PEAT'
'\x06PECIAL'
'\nPEDAL MARK'
'\x03PEE'
'\x08PEE SIGN'
'\x05PEECH'
'\x07PEGERMA'
'\x03PEH'
'\x05PEITH'
'\x04PEN '
'\x10PEN CENTRE CROSS'
'\x05PEN E'
'\x05PEN-P'
'\x06PENCIL'
'\x11PENDICULAR WITH S'
'\x04PER '
'\x0cPER-EM SPACE'
'\x07PERATOR'
'\nPERCUSSIVE'
'\x08PERFECTA'
'\rPERFECTA REST'
'\x19PERFECTUM CUM PROLATIONE '
'\x0bPERISPOMENI'
'\x04PERS'
'\x07PERSAND'
'\x06PERSET'
'\tPERSET OF'
'\x16PERSET OF NOR EQUAL TO'
'\x0fPERTHO PEORTH P'
'\x07PERVISE'
'\x02PH'
'\x1bPHARYNGEAL VOICED FRICATIVE'
'\x0cPHEME JOINER'
'\x04PHEN'
'\x07PHIEUPH'
'\x0bPHNAEK MUAN'
'\x06PHRASE'
'\x07PHUTHAO'
'\x05PIEUP'
'\x03PII'
'\x04PING'
'\x11PINWHEEL ASTERISK'
'\rPINWHEEL STAR'
'\x06PIRIT '
'\x13PLACEMENT CHARACTER'
'\x04PLE '
'\x03PLI'
'\nPLICATION '
'\x04PLUS'
'\nPLUS BELOW'
'\rPLUS OPERATOR'
'\tPLUS SIGN'
'\x0fPLUS SIGN BELOW'
'\x02PM'
'\x1ePOINTED RECTILINEAR BLACK STAR'
'\x07POINTER'
'\tPOINTING '
'\x06POKED '
'\x05POLI '
'\x07POMOFO '
'\x04POSE'
'\x08POSITION'
'\x10POSTPOSITION MEN'
'\tPOSTROPHE'
'\x03POT'
'\x03PPA'
'\nPPA SYMBOL'
'\x04PPER'
'"PPROXIMATELY NOR ACTUALLY EQUAL TO'
'\x02PR'
'\nPRALINEAR '
'\x16PRECEDED BY APOSTROPHE'
'\x08PRECEDES'
'\x10PRECHGESANG STEM'
'\x07PRESENT'
'\x07PRICORN'
'\x04PRIL'
'\x05PRIME'
'\x05PRINT'
'\x03PRO'
'\x07PRODUCT'
'\x14PROLONGED SOUND MARK'
'\x0cPROTOS ICHOS'
'\x05PSILI'
'\x06PSILON'
'\x07PTHAHA '
'\x05PTUNE'
'\x16PUNCTUATION KUNDDALIYA'
'\x03PWA'
'\x02PY'
'\x01Q'
'\x02QA'
'\x05QAAFU'
'\x03QAF'
'\x1eQAF WITH LAM WITH ALEF MAKSURA'
'\x08QAIRTHRA'
'\x06QAMATS'
'\x04QAPH'
'\x03QAR'
'\x05QATAN'
'\x04QEF '
'\x06QETANA'
'\x03QOF'
'\x03QOT'
'\x02QU'
'\x03QUA'
'\x04QUAD'
'\x15QUADRANT CIRCULAR ARC'
'\x0fQUADRUPLE ARROW'
'\x0fQUADRUPLE DASH '
'\nQUALS SIGN'
'\x10QUALS SIGN BELOW'
'\x05QUARE'
'\x06QUARE '
'\x0bQUARE BELOW'
'\rQUARE BRACKET'
'\x07QUARIUS'
'\x07QUARTER'
'\rQUARTER BLOCK'
'\x08QUARTERS'
'\x0eQUARTERS BLOCK'
'\x11QUAT REVERSED ESH'
'\x05QUEEN'
'\x08QUESTION'
'\rQUESTION MARK'
'\x13QUESTION MARK ABOVE'
'\x05QUILL'
'\x05QUIRY'
'\nQUISH QUAD'
'\x0eQUOTATION MARK'
'\x17QUOTATION MARK ORNAMENT'
'\tQUSHSHAYA'
'\x01R'
'\x02R '
'\x06R THAN'
'\x07R TSHES'
'\x0fR WITH FISHHOOK'
'\x02RA'
'\x08RA NAME '
'\x07RA SIGN'
'\x03RAA'
'\x05RACHY'
'\x08RADICAL '
'\x03RAE'
'\x04RAEA'
'\x04RAFE'
'\nRAGGISMATA'
'\x0cRAH BEN YOMO'
'\x05RAIDA'
'\x10RAIDO RAD REID R'
'\nRAINIAN IE'
'\x07RAKHANG'
'\x04RAMA'
'\x08RAMMA GG'
'\x03RAN'
'\x19RANCH BANK IDENTIFICATION'
'\x0bRANSMISSION'
'\x05RANUS'
'\x05RASS '
'\x0bRAVE ACCENT'
'\x07RAYANNA'
'\x14RC LESS-THAN BRACKET'
'\x03RCH'
'\x0cRCHAIC KOPPA'
'\x07RCHAION'
'\x05RCURY'
'\x02RD'
'\tRD JOINER'
'\x07RD SIGN'
'\x08RDEL NAG'
'\x07RDO RJE'
'\x02RE'
'\x10RECORD SEPARATOR'
'\x08RECORDER'
'\x1cRECT CURRENT SYMBOL FORM TWO'
'\tRECTANGLE'
'\x1cRECTANGULAR PATH AROUND POLE'
'\x16RECTILINEAR BLACK STAR'
'\x03REE'
'\x08REE MARK'
'\x17REE VARIATION SELECTOR '
'\x0eREE-LINE STAFF'
'\x0cREFACE COLON'
'\x03REH'
'\x04REH '
'\x0eREH FINAL FORM'
'\x04REIA'
'\nRENCY SIGN'
'\x04RESH'
'\x04REST'
'\x0eRETROFLEX HOOK'
'\x0cREVERSE MARK'
'\x0fREVERSE SOLIDUS'
'\x08REVERSED'
'\x15REVERSED FEATHER MARK'
'\nREVERSED I'
'\x14REVERSED ONE HUNDRED'
'\x0fREVERSED OPEN E'
'\x05REVIA'
'\x0eRFACE INTEGRAL'
'\x03RGE'
'\x06RGIAN '
'\x06RGLASS'
'\x03RGO'
'\x04RGON'
'\x03RHO'
'\nRHO SYMBOL'
'\x02RI'
'\x05RIAC '
'\x07RIANGLE'
'\x1bRIANGLE BESIDE VERTICAL BAR'
'\x0cRIANGLE DOWN'
'\x1fRIANGLE-HEADED RIGHTWARDS ARROW'
'\x0fRIANGULAR COLON'
'\x05RIEUL'
'\x05RIGHT'
'\x06RIGHT '
'\nRIGHT AND '
'\x14RIGHT ANGLE WITH DOT'
'\x1bRIGHT ARC LESS-THAN BRACKET'
'\x0cRIGHT ARROW '
'\x11RIGHT ARROW ABOVE'
'\x07RIGHT C'
'\x17RIGHT DIAGONAL ELLIPSIS'
'\x0cRIGHT DOUBLE'
'\x10RIGHT DOWN BARB '
'\nRIGHT HALF'
'\x10RIGHT HALF BLACK'
'\x11RIGHT HALF CIRCLE'
'\x0fRIGHT HALF RING'
'\rRIGHT HARPOON'
'\x0bRIGHT HEAVY'
'\x0bRIGHT LIGHT'
'\x11RIGHT PARENTHESIS'
'\x1aRIGHT PARENTHESIS ORNAMENT'
'\x0eRIGHT QUADRANT'
'\x14RIGHT QUADRANT BLACK'
'\x0cRIGHT SINGLE'
'\x13RIGHT TO LOWER LEFT'
'\x18RIGHT TO LOWER LEFT FILL'
'%RIGHT TORTOISE SHELL BRACKET ORNAMENT'
'\x0eRIGHT TRIANGLE'
'\x0fRIGHT TURNSTILE'
'#RIGHT-POINTING ANGLE QUOTATION MARK'
'\nRIGHTWARDS'
'\x10RIGHTWARDS ARROW'
'&RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW'
'\x16RIGHTWARDS ARROW BELOW'
'\x11RIGHTWARDS ARROWS'
'!RIGHTWARDS HARPOON WITH BARB DOWN'
'\x1fRIGHTWARDS HARPOON WITH BARB UP'
'\x18RIGHTWARDS THEN CURVING '
'\x0fRIGHTWARDS TICK'
'\nRIGINAL OF'
'\x06RIISAP'
'\x07RILLIC '
'\x04RIME'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\x0cRING OVERLAY'
'\x08RINHIEUH'
'\x0cRION CHRONON'
'\x03RIP'
'\x06RIPLE '
'\x0bRIPLE ARROW'
'\x0bRIPLE PRIME'
'\x0eRIPLE UNDERDOT'
'\x04RIPT'
'\x06RIPT G'
'\x07RISIMOU'
'\x0fRISING DIAGONAL'
'\x15RISING DIAGONAL SLASH'
'\x0bRISING DOTS'
'\x10RISING TONE MARK'
'\tRISPOMENI'
'\x08RIYOOSAN'
'\tRIZONTAL '
'\x02RK'
'\x08RK SHADE'
'\x04RKLE'
'\x03RMA'
'\x0fRMAN PENNY SIGN'
'\x18RMITIAN CONJUGATE MATRIX'
'\x07RMUKHI '
'\x02RN'
'\x0cRNAM BCAD MA'
'\x0fRNAMENT STROKE-'
'\x05RNED '
'\tRNEY PARA'
'\x02RO'
'\x04ROA '
'\x06ROBANG'
'\x03ROG'
'\tROJECTION'
'\rROKEE LETTER '
'\x03RON'
'\x0eRONIAN SIGN ET'
'\x05RONIS'
'\x0bRONTHISMATA'
'\x04ROOK'
'\x03ROP'
'\x0bROR-BARRED '
'\rROSGEGRAMMENI'
'\x04ROSS'
'\x0bROSS ACCENT'
'\x0bROSSED-TAIL'
'\x1bROTATED FLORAL HEART BULLET'
'\x04ROTO'
'\x16ROUND A POINT OPERATOR'
'\x0bROUND OMEGA'
'$ROUNDED HIGH STOP WITH FILLED CENTRE'
'\x0cROUNDED ZERO'
'\x04ROUT'
'\rROW POINTING '
'\tROW WITH '
'\x0cROWNING FACE'
'\x0bRPOON ABOVE'
'\tRPORATION'
'\x04RPSE'
'\x03RQA'
'\x02RR'
'\x05RRECT'
'\x07RRECTUS'
'\x06RRED O'
'\x0cRRESPONDS TO'
'\rRRIAGE RETURN'
'\x06RRIER '
'\x04RROI'
'\x04RROW'
'\nRROW ABOVE'
'\x13RROW NO-BREAK SPACE'
'\x16RROW WITH ROUNDED HEAD'
'\x08RSECTION'
'\nRSI SYMBOL'
'\x10RST QUARTER MOON'
'\x02RT'
'\x03RT '
'\x04RT T'
'\x04RTAR'
'\x03RTE'
'\tRTER NOTE'
'\x03RTH'
'\x03RTY'
'\x02RU'
'\x05RUDAA'
'\x03RUE'
'\x05RUHUA'
'\x04RUIS'
'\x04RUKU'
'\tRUM CLEF-'
'\x04RUNA'
'\x06RUPEE '
'\x05RUSH '
'\x04RUSI'
'\x04RUTU'
'\nRVICE MARK'
'\x02RY'
'\x08RYNGEAL '
'\x01S'
'\x02S '
'\tS DIGRAPH'
'\x07S ICHOS'
'\x08S INSIDE'
'\rS KAI APOTHES'
'\x03S O'
'\x0cS SUBPUNCTIS'
'\x02SA'
'\x1eSAD WITH LAM WITH ALEF MAKSURA'
'\x04SADI'
'\x08SAME DOT'
'\x07SAMPHAO'
'\rSAMYOK SANNYA'
'\x04SANG'
'\x08SANGSIOS'
'\x0bSANS-SERIF '
'\x13SANS-SERIF CAPITAL '
'\x08SANYAKA '
'\x05SARGA'
'\x05SASA '
'\x05SAUIL'
'\x07SAYANNA'
'\x0cSAZ IS ISS I'
'\nSBUB -CHAL'
'\nSCAN LINE-'
'\x05SCAPE'
'\x04SCES'
'\x1cSCONTINUOUS UNDERLINE SYMBOL'
'\x14SCRIPTION CHARACTER '
'\x02SE'
'\x03SE '
'\nSE-CREE SK'
'\x0bSECOND MARK'
'\x04SECT'
'\x07SECTION'
'\x04SEEN'
'\x05SEGOL'
'\x04SELF'
'\x16SEMI-VOICED SOUND MARK'
' SEMICIRCULAR ANTICLOCKWISE ARROW'
'\x1dSEMICIRCULAR PATH AROUND POLE'
'\tSEMICOLON'
'\x0fSEMIVOWEL SIGN '
'\x05SENTO'
'\tSEPARATOR'
'\tSEPTEMBER'
'\x10SERIFS AT BOTTOM'
'\x07SERTION'
'\x0eSERTION SYMBOL'
'\x03SET'
'\rSEVEN EIGHTHS'
'\x13SEVEN EIGHTHS BLOCK'
'\x04SEYE'
'\nSGOR RTAGS'
'\x02SH'
'\nSH PRODUCT'
'\x07SH TAIL'
'\x03SHA'
'\x04SHAD'
'\x05SHADE'
'\x15SHADOWED WHITE SQUARE'
'\x05SHARP'
'\nSHARP SIGN'
'\x06SHAYIM'
'\x03SHE'
'\x05SHED '
'\x0cSHED BARLINE'
'\x05SHEYE'
'\x08SHKIR KA'
'\x08SHOE JOT'
'\nSHOE STILE'
'\x06SHORT '
'\x17SHORT HORIZONTAL STROKE'
'\x15SHORT LEFTWARDS ARROW'
'\x16SHORT RIGHTWARDS ARROW'
'\x16SHORT VERTICAL STROKES'
'\x04SHTA'
'\x02SI'
'\x1dSIBE SYLLABLE BOUNDARY MARKER'
'\x03SIC'
'\x05SICLE'
'\x06SIEUNG'
'\x08SIFISTON'
'\x05SIGMA'
'\x0cSIGMA SYMBOL'
'\x04SIGN'
'\x05SIGN '
'\rSIGN PAMUDPOD'
'\x0bSIGN VIRAMA'
'\x04SILI'
'\rSILI PNEUMATA'
'\x17SING DIAGONAL CROSSING '
'\x0bSINGLE AND '
'\x14SINGLE DOT TONE MARK'
'\x12SINGLE PUNCTUATION'
'\x0cSINGLE-LINE '
'\x18SINGLE-LINE NOT EQUAL TO'
'\x04SINK'
'\x05SION '
'\x04SIOS'
'\x04SIS '
'\x03SIX'
'\x0fSIXTEENTH NOTES'
'\x05SIXTH'
'\x06SIXTHS'
'\x03SJE'
'\x06SKAPI '
'\x08SKLIRON '
'\x08SLANTED '
'\x10SLANTED EQUAL TO'
'\x05SLASH'
'\x04SLUR'
'\x03SMA'
'\x06SMALL '
'\x0cSMALL CIRCLE'
'\x12SMALL CIRCLE ABOVE'
'\x0bSMALL GAMMA'
'\x07SMALL L'
'\rSMALL LETTER '
'\x0eSMALL LETTER J'
'\x0eSMALL TRIANGLE'
'\x07SMALL V'
'\x08SNA LDAN'
'\x02SO'
'\x03SO '
'\tSOF PASUQ'
'\x05SOL S'
'\x0cSOLATED FORM'
'\x07SOLIDUS'
'\x17SOLIDUS BINARY RELATION'
'\x03SOO'
'\x10SOUTH EAST ARROW'
'\x05SPACE'
'\nSPACE MARK'
'\x06SPATHI'
'\x08SPECTIVE'
'\x0fSPOKED ASTERISK'
'\x06SPONSE'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x0eSQUIGGLE ARROW'
'\x02SS'
'\x07SS-THAN'
'\x08SS-THAN '
'\x0cSS-THAN SIGN'
'\x03SSA'
'\nSSANGARAEA'
'\x0bSSANGKIYEOK'
'\nSSANGPIEUP'
'\tSSANGSIOS'
'\x05SSERA'
'\x0bSSIVE-PULL-'
'\x02ST'
'\x0fST QUARTER MOON'
'\x0fST SYRIAC CROSS'
'\x08ST-CREE '
'\x04STAR'
'\x0fSTERESIS SYMBOL'
'\x07STERISK'
'\x10STERISK OPERATOR'
'\x05STILE'
'\x07STIMATE'
'\x06STOLI '
'\x04STOP'
'\x10STRING FRETBOARD'
'\x06STROFO'
'\x06STROKE'
'\x0fSTROKE NOT SIGN'
'\x0eSTROKE OVERLAY'
'\nSTROM SIGN'
'\x07STRUCK '
'\x02SU'
'\x06SUBSET'
'\x07SUCCEED'
'\x08SUCCEEDS'
'\x04SUIT'
'\x05SUKUN'
'\x07SUKUUDO'
'\x03SUM'
'\x04SUNG'
'\x1dSUPERSCRIPT ALEF INITIAL FORM'
'\x1eSUPERSCRIPT ALEF ISOLATED FORM'
'\x0eSURROUND FROM '
'\tSYLLABLE '
'\x0bSYMBOL FOR '
'\x12SYMMETRIC SWAPPING'
'\x16SYMPTOTICALLY EQUAL TO'
'\x07SYNAGMA'
'\rSYNDESMOS NEO'
'\tSYNTHETON'
'\x06SYOUWA'
'\x01T'
'\x02T '
'\x07T ABOVE'
'\x07T BELOW'
'\x18T BLACK RIGHTWARDS ARROW'
'\x07T MINUS'
'\x07T RIGHT'
'\tT SPRINGS'
'\x02TA'
'\x03TA '
'\x07TA MARK'
'\x03TAA'
'\x08TAALUJA '
'\x04TACK'
'\x05TACK '
'\nTACK BELOW'
'\x06TAIKHU'
'\x04TAIL'
'\x04TAIN'
'\x07TAISYOU'
'\x06TAKANA'
'\x03TAL'
'\x08TAL MARK'
'\nTAL RUNOUT'
'\x03TAM'
'\x03TAN'
'\x11TAN ISOLATED FORM'
'\x03TAO'
'\x03TAR'
'\x08TART OF '
'\x13TART OF RUB EL HIZB'
'\x03TAS'
'\x06TATED '
'\x03TAV'
'\x07TAYANNA'
'\x03TCH'
'\x07TCHFORK'
'\x02TE'
'\x06TE TSE'
'\x18TEARDROP-SPOKED ASTERISK'
'"TEARDROP-SPOKED PROPELLER ASTERISK'
'\x04TED '
'\x04TEEN'
'\x15TEEN POINTED ASTERISK'
'\x03TEH'
'\nTELEGRAPH '
'\tTELEPHONE'
'\x10TELOUS ICHIMATOS'
'\x03TEN'
'\x11TEN THOUSAND SIGN'
'\x1aTENDED ARABIC-INDIC DIGIT '
'\x04TENT'
'\x03TER'
'\x04TER '
'\nTER SYMBOL'
'\x05TERIS'
'\nTERMINATOR'
'\nTERNATIVE '
'\x14TERNATIVE KEY SYMBOL'
'\x19TERNION INTEGRAL OPERATOR'
'\x06TERON '
'\x11TERSYLLABIC TSHEG'
'\nTESE CROSS'
'\x0eTETARTOS ICHOS'
'\x0bTETRAFONIAS'
'\x04TEXT'
'\x02TH'
'\x03TH '
'\x07TH MARK'
'\x07TH ROOT'
'\x0eTHALAN ETHEL O'
'\x08THAMASAT'
'\nTHAPASCAN '
'\x05THEMA'
'\x0bTHEMATICAL '
'\x04THER'
'\x07THESEOS'
'\x0cTHETA SYMBOL'
'\x07THIEUTH'
'\x08THIOPIC '
'\x05THIRD'
'\x06THIRDS'
'\nTHMIKON N '
'\x0cTHODOX CROSS'
'\x04THOR'
'\x06THORA '
'\x08THOUSAND'
'\x0eTHOUSANDS SIGN'
'\x06THREE '
'\nTHREE DOTS'
'\x0bTHREE DOTS '
'\x10THREE DOTS ABOVE'
'\x1aTHREE DOTS ABOVE DOWNWARDS'
'\x10THREE DOTS BELOW'
'\x14THROUGH SMALL CIRCLE'
'\x07THUNDER'
'\x03THY'
'\x02TI'
'\x04TIC '
'\x06TICAL '
'\x08TICK IN '
'\x0cTICLOCKWISE '
'\x03TIE'
'\x07TIFIED '
'\x05TIGMA'
'\x06TIKENO'
'\x06TIKEUT'
'\x04TIKI'
'\x05TILDE'
'\x06TILDE '
'\x0fTILDE DIAERESIS'
'\x0eTILDE OPERATOR'
'\x05TIMES'
'\x0eTIMES OPERATOR'
'\nTIMES SIGN'
'\x08TIMORION'
'\x04TIN '
'\x08TINGUISH'
'\x05TINNE'
'\x03TIO'
'\x08TION KEY'
'\x13TIONAL DIGIT SHAPES'
'\x04TIP '
'\x05TIPPI'
'\x08TISMOS E'
'\x05TITLO'
'\x03TIV'
'\x07TIVATE '
'\x03TJE'
'\x03TLE'
'\x07TLINED '
'\x02TO'
'\x03TO '
'\x06TO BAR'
'\tTO CORNER'
'\x13TO LOWER RIGHT FILL'
'\x08TO-LEFT '
'\tTO-RIGHT '
'\x10TODO SOFT HYPHEN'
'\x03TON'
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\tTONE MARK'
'\x05TONOS'
'\x03TOO'
'\x03TOP'
'\x04TOP '
'\nTOP CORNER'
'\rTOP HALF RING'
'\x14TOP SEMICIRCLE ARROW'
' TOP-LIGHTED RIGHTWARDS ARROWHEAD'
'\x06TOPBAR'
'\x16TORTOISE SHELL BRACKET'
'\tTOS ICHOS'
'\x05TRAIF'
'\tTRAIGHT U'
'\x06TRAPLI'
'\x0bTRESS SIGN '
'\nTRETCHED C'
'\x03TRI'
'\x04TRIA'
'\x08TRIANGLE'
' TRIANGLE-HEADED RIGHTWARDS ARROW'
'\x0cTRIPLE DASH '
'\x11TRIPLE DASH ARROW'
'\x16TRIPLE RIGHT TURNSTILE'
'\x1cTRIPLE VERTICAL BAR OPERATOR'
'\x16TRIPLE VERTICAL STROKE'
'\rTROFLEX CLICK'
'\x12TROFLEX HOOK BELOW'
'\x05TROKE'
'\x0eTROKE NOT SIGN'
'\rTROKE OVERLAY'
'\x0bTRUNCATED A'
'\x02TS'
'\x05TSADI'
'\x05TSERE'
'\x05TSHEG'
'\nTSHEG SHAD'
'\x06TTAVA '
'\tTTED STEM'
'\x08TTENTION'
'\x04TTER'
'\x05TTER '
'\x08TTO MARK'
'\x05TTOM '
'\x05TTORU'
'\x02TU'
'\x05TUEUM'
'\x04TURN'
'\x0bTURN SYMBOL'
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\x08TURNED R'
'\x0fTVIMADUR SYMBOL'
'\x03TWA'
'\x04TWAA'
'\x05TWEEL'
'\x03TWO'
'\x0eTWO DOT LEADER'
'\x08TWO DOTS'
'\x0eTWO DOTS ABOVE'
'!TWO DOTS ABOVE AND TWO DOTS BELOW'
'\x16TWO HORIZONTAL STROKES'
'#TWO HORIZONTAL STROKES TO THE RIGHT'
'\x0eTWO WHITE DOTS'
'\x0fTWO WITH STROKE'
'\x02TY'
'\x06TY SET'
'\nTYPE COLON'
'\x05TYPE-'
'\x05TYR T'
'\x01U'
'\x02U '
'\rU LENGTH MARK'
'\x06U MARK'
'\x02UA'
'\x03UAN'
'\x03UAT'
'\x07UBADAMA'
'\x04UBED'
'\x05UBITO'
'\x10UBJOINED LETTER '
'\x04UBLE'
'\x05UBLE '
'\nUBLE DASH '
'\nUBLE GRAVE'
'\x0bUBLE TONGUE'
'\x14UBLE VERTICAL STROKE'
'\x06UBLE X'
'\x0cUBSCRIPT TWO'
'\tUBSTITUTE'
'\x07UBUFILI'
'\x05UBURU'
'\x05UBUTS'
'\x05UCEUS'
'\x02UD'
'\x06UDATTA'
'\x03UDY'
'\x02UE'
'\x03UEH'
'\rUFFLE PRODUCT'
'\x06UFISMA'
'\x0bUG RTAGS GY'
'\x0fUGMENTATION DOT'
'\x04UGU '
'\x05UGUST'
'6UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA '
'\x03UJA'
'\x07UKKAKHA'
'\x04UKUN'
'\x02UL'
'\x03UL '
'\x0bULAR BULLET'
'\x10ULDERED OPEN BOX'
'\x06ULDRON'
'\x0fULGAR FRACTION '
'\x03ULL'
'\x0cULL NOTEHEAD'
'\x08ULL STOP'
'\x0bULO TWO SUM'
'\tULTI REST'
')ULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT'
'\x02UM'
'\nUMBER SIGN'
'\x08UMMATION'
'\x02UN'
'\x0cUN WITH RAYS'
'\x04UNAH'
'\x06UNATE '
'\x04UNAV'
'\x0bUNCTUATION '
'\x10UNCTUATION SPACE'
'\x04UND '
'\x08UND SIGN'
'\x0eUNDER RELATION'
'\x08UNDERBAR'
'\nUNDERSTORM'
'\x03UNG'
'\tUNGSEONG '
'\x05UNION'
'\x0eUNION OPERATOR'
'\x11UNION WITH SERIFS'
'\x0eUNIT SEPARATOR'
'\x0bUNJO WYNN W'
'\x05UNOO '
'\x05UNTER'
'\x02UO'
'\x03UON'
'\x03UOP'
'\x02UP'
'\x03UP '
'\x07UP AND '
'\x11UP AND HORIZONTAL'
'\x06UP BOW'
'\nUP HARPOON'
'\x08UP HEAVY'
'\x1cUP HEAVY AND LEFT DOWN LIGHT'
'\x1dUP HEAVY AND RIGHT DOWN LIGHT'
'\x13UP HORIZONTAL HEAVY'
'\x13UP HORIZONTAL LIGHT'
'\x08UP LIGHT'
'\x07UP MARK'
'\x0eUP RIGHT BARB '
'\x07UP TACK'
'\x10UP-OUTPUT SYMBOL'
'\rUPERIMPOSED X'
'\x10UPERSCRIPT ALAPH'
'\x0fUPERSCRIPT ALEF'
'\x06UPITER'
'\x04UPLE'
'\x05UPLE '
'\x06UPPER '
'\x0cUPPER CORNER'
'\tUPPER DOT'
'\nUPPER HALF'
'\nUPPER HOOK'
'\x16UPPER RIGHT AND LOWER '
'+UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\x18UPRIGHT RECTANGULAR ZERO'
'\x07UPSILON'
'\rUPSILON WITH '
'\tUPTSTIMME'
'\x06UPTURN'
'\x18UPWARD POINTING TRIANGLE'
'\x07UPWARDS'
'\x1cUPWARDS AND RIGHTWARDS ARROW'
'\rUPWARDS ARROW'
'\x1fUPWARDS HARPOON WITH BARB RIGHT'
'\x02UR'
'\x03UR-'
'\x03URA'
'\x05URAMU'
'\x03URL'
'\x0cURLY BRACKET'
'\x03URN'
'\x06URNED '
'\x0bURNED COMMA'
'\x11URNED COMMA ABOVE'
'\x07URNED M'
'\x13URRENCY SYMBOL BAHT'
'\x06URTEEN'
'\x05URTLE'
'\x03URU'
'\x04URUS'
'\tURUZ UR U'
'\x02US'
'\x04USA '
'\x03USE'
"'USED AS KORANIC STOP SIGN ISOLATED FORM"
'\x03USH'
'\x07USSYERU'
'\x0fUSTER NOTEHEAD '
'\x16USTOMER ACCOUNT NUMBER'
'\x02UT'
'\x04UT H'
'\nUT NOT EQU'
'\x07UT TIME'
'\x03UTE'
'\x05UTE A'
'\tUTER JOIN'
'\x0cUTH-SLAVEY K'
'\nUTION SIGN'
'\x12UTLINED BLACK STAR'
'\tUURDHAJA '
'\x06UYANNA'
'\x06UZEIRO'
'\x0bUZEIRO SIGN'
'\x01V'
'\x02VA'
'\x05VAAVU'
'\x07VAGRAHA'
'\x0cVAKRAHASANYA'
'\x07VALENT '
'\tVANAGARI '
'\x05VARIA'
'\x13VARIANT WITH SQUARE'
'\x13VARIATION INDICATOR'
'\x0bVARYS ICHOS'
'\x03VAV'
'\x07VAV YOD'
'\x07VAYANNA'
'\x02VE'
'\x03VE '
'\x10VE EIGHTHS BLOCK'
'\rVE-LINE STAFF'
' VED STEM PARAGRAPH SIGN ORNAMENT'
'\x03VEE'
'\x11VEE WITH UNDERBAR'
'\x06VELOPE'
'\x03VEN'
'\x11VEN EIGHTHS BLOCK'
'\x03VER'
'\x0cVER EQUAL TO'
'\x05VER S'
'\x11VERAGE WITH SLASH'
'\x07VERLINE'
'\x17VERSAL RECYCLING SYMBOL'
'\x05VERSE'
'\x13VERSE FINAL BARLINE'
'\x07VERSED '
'\x08VERTICAL'
'\tVERTICAL '
'\x0cVERTICAL BAR'
'\rVERTICAL BAR '
'(VERTICAL BAR AT END OF HORIZONTAL STROKE'
'\x17VERTICAL BISECTING LINE'
'\x11VERTICAL BOX LINE'
'\rVERTICAL FILL'
'\x0eVERTICAL HEAVY'
'\x0eVERTICAL LIGHT'
'\rVERTICAL LINE'
'\x15VERTICAL LINE OVERLAY'
'\x12VERTICAL RECTANGLE'
'\x0fVERTICAL STROKE'
'\x13VERTICAL TABULATION'
'\x07VEW NOW'
'\x02VI'
'\rVICE CONTROL '
'\x04VIDE'
'\x06VILIAN'
'\x07VILIK B'
'\x03VIN'
'\x08VINATION'
'\nVIOUS PAGE'
'\x03VIR'
'\x06VIRAMA'
'\x06VIRIAM'
'\x03VIS'
'\x0bVISARGA ONE'
'\tVISARGAYA'
'\x08VISION S'
'\x06VIYANI'
'\x02VO'
'\x08VOCALIC '
'\tVOCALIC R'
'\x15VOICED ITERATION MARK'
'\x11VOICED SOUND MARK'
'\x03VOU'
'\x06VOWEL '
'\x0fVOWEL SEPARATOR'
'\x0bVOWEL SIGN '
'\x0eVRON SNOWFLAKE'
'\x02VU'
'\x01W'
'\x06W LINE'
'\rW SHEQEL SIGN'
'\x02WA'
'\x03WAA'
'\x05WAAVU'
'\x04WAHA'
'\x03WAI'
'\x04WAIR'
'\x05WARDS'
'\x06WARDS '
'\x0bWARDS ARROW'
'\x11WARDS ARROW BELOW'
'\x13WARDS ARROW OVERLAY'
'\x0cWARDS BULLET'
'\nWARDS VANE'
'\x14WARE-FUNCTION SYMBOL'
'\x16WASALLAM ISOLATED FORM'
'\x08WASH KAF'
'\x05WATTO'
'\x04WAVE'
'\nWAVE ARROW'
'\x0bWAVY HAMZA '
'\rWAVY LOW LINE'
'\rWAVY OVERLINE'
'\x03WAW'
'\x04WAW '
'\x03WAZ'
'\x07WAZ EOH'
'\x02WE'
'\x04WEEN'
'\x04WEET'
'\x05WENTY'
'\x06WEORTH'
'\x04WER '
'\x05WEST '
'\x05WHITE'
'\x06WHITE '
'\x0bWHITE ARROW'
'\x0cWHITE CIRCLE'
'\x14WHITE CORNER BRACKET'
'\x0fWHITE DOT RIGHT'
'\x11WHITE PARENTHESIS'
'\x14WHITE SQUARE BRACKET'
'\x12WHITE VERTICAL BAR'
'\x05WIDE '
'\x11WIDE BRIDGE ABOVE'
'\x06WIDTH '
'\x0cWIGGLY FENCE'
'\x04WIND'
'\x05WINJA'
'\x05WITH '
'\rWITH ASTERISK'
'\nWITH BARB '
'\nWITH CARON'
'\x10WITH CENTRED DOT'
'\x0eWITH DOT ABOVE'
'\x0eWITH DOT BELOW'
'\x0fWITH DOWN ARROW'
'\x0eWITH FATHATAN '
'\x14WITH FOUR DOTS ABOVE'
'\x10WITH HAMZA ABOVE'
'\tWITH HOOK'
'\x16WITH HORIZONTAL STROKE'
'\rWITH INTEGRAL'
'\x16WITH JEEM INITIAL FORM'
'\nWITH MEEM '
'\x11WITH NOT EQUAL TO'
"'WITH OPEN ARM ENDING IN ARROW POINTING "
'\x06WITH T'
'\x15WITH THREE DOTS ABOVE'
'\rWITH UNDERBAR'
'\x16WITH VOICED SOUND MARK'
'\x0eWITH YEH ABOVE'
'\x13WITH YEH FINAL FORM'
'\x05WLINE'
'\x02WN'
'\x03WN '
'\x08WN ARROW'
'\x06WN BOW'
'\x06WN BOX'
'\x07WN TACK'
'\rWN TACK BELOW'
'\x02WO'
'\x03WO '
'\rWO DOTS BELOW'
'\x16WO DOTS VERTICAL ABOVE'
'\x0fWO HEADED ARROW'
'\x07WO MARK'
'\x11WO VERTICAL DOTS '
'\x07WO WAEN'
'\rWO-LINE STAFF'
'\x08WON SIGN'
'\tWORDSPACE'
'\x04WTIE'
'\x02WU'
'\x04WYNN'
'\x01X'
'\x07X ABOVE'
'\x0bX DRAWINGS '
'\nX NOTEHEAD'
'\x03XAN'
'\x08XCELLENT'
'\x0fXCLAMATION MARK'
'\x18XCLAMATION MARK ORNAMENT'
'\x02XE'
'\x03XEH'
'\x04XEIA'
'\x02XI'
'\tXIMATELY '
'\x0cXIRON KLASMA'
'\x02XO'
'\x0eXO EKFONITIKON'
'\x06XO NEO'
'\x07XT PAGE'
'\x0fXTEEN FULL STOP'
'\x01Y'
'\x02Y '
'\x07Y MUCH '
'\tY-FOURTH '
'\x02YA'
'\x03YA '
'\x03YAA'
'\x05YAMOK'
'\x07YANMAR '
'\x05YANNA'
'\tYANUKITTA'
'\x07YAYANNA'
'\x08YBEYFILI'
'\x06YBOARD'
'\x02YE'
'\x03YEE'
'\x03YEH'
'\x04YEH '
'\x0eYEH FINAL FORM'
'\x11YEH ISOLATED FORM'
'\tYEH WITH '
'\x06YELLOW'
'\x17YELORUSSIAN-UKRAINIAN I'
'\x08YEN SIGN'
'\x0bYEORINHIEUH'
'\x06YFESIS'
'\x06YGISMA'
'\x02YI'
'\x08YIDDISH '
'\x08YIG MGO '
'\x14YIG MGO PHUR SHAD MA'
'\x15YIG MGO TSHEG SHAD MA'
'\x03YIN'
'\x04YIS '
'\x05YISI '
'\x06YLISMA'
'\x08YLLABLE '
'\x06YMBOL '
'\x15YMPTOTICALLY EQUAL TO'
'\x02YN'
'\x0fYNCHRONOUS IDLE'
'\x03YNN'
'\x02YO'
'\x03YOD'
'\rYOD YOD PATAH'
'\x03YOO'
'\x03YOT'
'\rYPOGEGRAMMENI'
'\x08YPORROON'
'\x02YR'
'\tYRANISMA '
'\x0bYRIGHT SIGN'
'\x08YRILLIC '
'\x02YT'
'\x02YU'
'\x04YUDH'
'\x05YURII'
'\rYUUKALEAPINTU'
'\x04YWAA'
'\x18YZANTINE MUSICAL SYMBOL '
'\x01Z'
'\tZ DIGRAPH'
'\x02ZA'
'\x0eZAH WITH MEEM '
'\x04ZAIN'
'\x0fZAIN FINAL FORM'
'\x05ZAYIN'
'\x02ZE'
'\tZENE RING'
'\x05ZENGE'
'\x03ZER'
'\x04ZERO'
'\x04ZETA'
'\x02ZH'
'\x03ZHA'
'\x06ZHITSA'
'\rZHOU NUMERAL '
'\x04ZIET'
'\x0cZIGZAG ARROW'
'\x0bZIGZAG LINE'
'\x05ZILDE'
'\x03ZJE'
'\x02ZO'
'\x07ZQAPHA '
'\x03ZUP'
'\x05ZYGOS'
)
_charnodes =[68490,
 -58550,
 -1,
 132218,
 18786,
 -1,
 197578,
 73524,
 -1,
 262727,
 133685,
 -1,
 327957,
 199291,
 -1,
 393238,
 275136,
 -1,
 -65529,
 340672,
 195071,
 -65528,
 403735,
 195070,
 -65527,
 467330,
 195069,
 -65526,
 531274,
 195068,
 -65525,
 595619,
 195067,
 -65524,
 658045,
 195066,
 -65523,
 723579,
 195065,
 -65522,
 789113,
 195064,
 -65521,
 854636,
 195063,
 -65520,
 920159,
 195062,
 -65519,
 985682,
 195061,
 -65518,
 1051205,
 195060,
 -65517,
 1116728,
 195059,
 -65516,
 1182248,
 195058,
 -65515,
 1247771,
 195057,
 -1,
 1313305,
 195056,
 1507367,
 338199,
 -1,
 -65512,
 1454784,
 195055,
 -65511,
 1517847,
 195054,
 -65510,
 1581442,
 195053,
 -65509,
 1645386,
 195052,
 -65508,
 1709731,
 195051,
 -65507,
 1772157,
 195050,
 -65506,
 1837691,
 195049,
 -65505,
 1903225,
 195048,
 -65504,
 1968748,
 195047,
 -65503,
 2034271,
 195046,
 -65502,
 2099794,
 195045,
 -65501,
 2165317,
 195044,
 -65500,
 2230840,
 195043,
 -65499,
 2296360,
 195042,
 -65498,
 2361883,
 195041,
 -1,
 2427417,
 195040,
 2621496,
 1450370,
 -1,
 -65495,
 2568896,
 195039,
 -65494,
 2631959,
 195038,
 -65493,
 2695554,
 195037,
 -65492,
 2759498,
 195036,
 -65491,
 2823843,
 195035,
 -65490,
 2886269,
 195034,
 -65489,
 2951803,
 195033,
 -65488,
 3017337,
 195032,
 -65487,
 3082860,
 195031,
 -65486,
 3148383,
 195030,
 -65485,
 3213906,
 195029,
 -65484,
 3279429,
 195028,
 -65483,
 3344952,
 195027,
 -65482,
 3410472,
 195026,
 -65481,
 3475995,
 195025,
 -1,
 3541529,
 195024,
 3735625,
 2562890,
 -1,
 -65478,
 3683008,
 195023,
 -65477,
 3746071,
 195022,
 -65476,
 3809666,
 195021,
 -65475,
 3873610,
 195020,
 -65474,
 3937955,
 195019,
 -65473,
 4000381,
 195018,
 -65472,
 4065915,
 195017,
 -65471,
 4131449,
 195016,
 -65470,
 4196972,
 195015,
 -65469,
 4262495,
 195014,
 -65468,
 4328018,
 195013,
 -65467,
 4393541,
 195012,
 -65466,
 4459064,
 195011,
 -65465,
 4524584,
 195010,
 -65464,
 4590107,
 195009,
 -1,
 4655641,
 195008,
 4849754,
 3675811,
 -1,
 -65461,
 4797120,
 195007,
 -65460,
 4860183,
 195006,
 -65459,
 4923778,
 195005,
 -65458,
 4987722,
 195004,
 -65457,
 5052067,
 195003,
 -65456,
 5114493,
 195002,
 -65455,
 5180027,
 195001,
 -65454,
 5245561,
 195000,
 -65453,
 5311084,
 194999,
 -65452,
 5376607,
 194998,
 -65451,
 5442130,
 194997,
 -65450,
 5507653,
 194996,
 -65449,
 5573176,
 194995,
 -65448,
 5638696,
 194994,
 -65447,
 5704219,
 194993,
 -1,
 5769753,
 194992,
 5963883,
 4786813,
 -1,
 -65444,
 5911232,
 194991,
 -65443,
 5974295,
 194990,
 -65442,
 6037890,
 194989,
 -65441,
 6101834,
 194988,
 -65440,
 6166179,
 194987,
 -65439,
 6228605,
 194986,
 -65438,
 6294139,
 194985,
 -65437,
 6359673,
 194984,
 -65436,
 6425196,
 194983,
 -65435,
 6490719,
 194982,
 -65434,
 6556242,
 194981,
 -65433,
 6621765,
 194980,
 -65432,
 6687288,
 194979,
 -65431,
 6752808,
 194978,
 -65430,
 6818331,
 194977,
 -1,
 6883865,
 194976,
 7078012,
 5900923,
 -1,
 -65427,
 7025344,
 194975,
 -65426,
 7088407,
 194974,
 -65425,
 7152002,
 194973,
 -65424,
 7215946,
 194972,
 -65423,
 7280291,
 194971,
 -65422,
 7342717,
 194970,
 -65421,
 7408251,
 194969,
 -65420,
 7473785,
 194968,
 -65419,
 7539308,
 194967,
 -65418,
 7604831,
 194966,
 -65417,
 7670354,
 194965,
 -65416,
 7735877,
 194964,
 -65415,
 7801400,
 194963,
 -65414,
 7866920,
 194962,
 -65413,
 7932443,
 194961,
 -1,
 7997977,
 194960,
 8192141,
 7015033,
 -1,
 -65410,
 8139456,
 194959,
 -65409,
 8202519,
 194958,
 -65408,
 8266114,
 194957,
 -65407,
 8330058,
 194956,
 -65406,
 8394403,
 194955,
 -65405,
 8456829,
 194954,
 -65404,
 8522363,
 194953,
 -65403,
 8587897,
 194952,
 -65402,
 8653420,
 194951,
 -65401,
 8718943,
 194950,
 -65400,
 8784466,
 194949,
 -65399,
 8849989,
 194948,
 -65398,
 8915512,
 194947,
 -65397,
 8981032,
 194946,
 -65396,
 9046555,
 194945,
 -1,
 9112089,
 194944,
 9306270,
 8129132,
 -1,
 -65393,
 9253568,
 194943,
 -65392,
 9316631,
 194942,
 -65391,
 9380226,
 194941,
 -65390,
 9444170,
 194940,
 -65389,
 9508515,
 194939,
 -65388,
 9570941,
 194938,
 -65387,
 9636475,
 194937,
 -65386,
 9702009,
 194936,
 -65385,
 9767532,
 194935,
 -65384,
 9833055,
 194934,
 -65383,
 9898578,
 194933,
 -65382,
 9964101,
 194932,
 -65381,
 10029624,
 194931,
 -65380,
 10095144,
 194930,
 -65379,
 10160667,
 194929,
 -1,
 10226201,
 194928,
 10420399,
 9243231,
 -1,
 -65376,
 10367680,
 194927,
 -65375,
 10430743,
 194926,
 -65374,
 10494338,
 194925,
 -65373,
 10558282,
 194924,
 -65372,
 10622627,
 194923,
 -65371,
 10685053,
 194922,
 -65370,
 10750587,
 194921,
 -65369,
 10816121,
 194920,
 -65368,
 10881644,
 194919,
 -65367,
 10947167,
 194918,
 -65366,
 11012690,
 194917,
 -65365,
 11078213,
 194916,
 -65364,
 11143736,
 194915,
 -65363,
 11209256,
 194914,
 -65362,
 11274779,
 194913,
 -1,
 11340313,
 194912,
 11534528,
 10357330,
 -1,
 -65359,
 11481792,
 194911,
 -65358,
 11544855,
 194910,
 -65357,
 11608450,
 194909,
 -65356,
 11672394,
 194908,
 -65355,
 11736739,
 194907,
 -65354,
 11799165,
 194906,
 -65353,
 11864699,
 194905,
 -65352,
 11930233,
 194904,
 -65351,
 11995756,
 194903,
 -65350,
 12061279,
 194902,
 -65349,
 12126802,
 194901,
 -65348,
 12192325,
 194900,
 -65347,
 12257848,
 194899,
 -65346,
 12323368,
 194898,
 -65345,
 12388891,
 194897,
 -1,
 12454425,
 194896,
 12648657,
 11471429,
 -1,
 -65342,
 12595904,
 194895,
 -65341,
 12658967,
 194894,
 -65340,
 12722562,
 194893,
 -65339,
 12786506,
 194892,
 -65338,
 12850851,
 194891,
 -65337,
 12913277,
 194890,
 -65336,
 12978811,
 194889,
 -65335,
 13044345,
 194888,
 -65334,
 13109868,
 194887,
 -65333,
 13175391,
 194886,
 -65332,
 13240914,
 194885,
 -65331,
 13306437,
 194884,
 -65330,
 13371960,
 194883,
 -65329,
 13437480,
 194882,
 -65328,
 13503003,
 194881,
 -1,
 13568537,
 194880,
 13762786,
 12585528,
 -1,
 -65325,
 13710016,
 194879,
 -65324,
 13773079,
 194878,
 -65323,
 13836674,
 194877,
 -65322,
 13900618,
 194876,
 -65321,
 13964963,
 194875,
 -65320,
 14027389,
 194874,
 -65319,
 14092923,
 194873,
 -65318,
 14158457,
 194872,
 -65317,
 14223980,
 194871,
 -65316,
 14289503,
 194870,
 -65315,
 14355026,
 194869,
 -65314,
 14420549,
 194868,
 -65313,
 14486072,
 194867,
 -65312,
 14551592,
 194866,
 -65311,
 14617115,
 194865,
 -1,
 14682649,
 194864,
 14876915,
 13699624,
 -1,
 -65308,
 14824128,
 194863,
 -65307,
 14887191,
 194862,
 -65306,
 14950786,
 194861,
 -65305,
 15014730,
 194860,
 -65304,
 15079075,
 194859,
 -65303,
 15141501,
 194858,
 -65302,
 15207035,
 194857,
 -65301,
 15272569,
 194856,
 -65300,
 15338092,
 194855,
 -65299,
 15403615,
 194854,
 -65298,
 15469138,
 194853,
 -65297,
 15534661,
 194852,
 -65296,
 15600184,
 194851,
 -65295,
 15665704,
 194850,
 -65294,
 15731227,
 194849,
 -1,
 15796761,
 194848,
 15991044,
 14813723,
 -1,
 -65291,
 15938240,
 194847,
 -65290,
 16001303,
 194846,
 -65289,
 16064898,
 194845,
 -65288,
 16128842,
 194844,
 -65287,
 16193187,
 194843,
 -65286,
 16255613,
 194842,
 -65285,
 16321147,
 194841,
 -65284,
 16386681,
 194840,
 -65283,
 16452204,
 194839,
 -65282,
 16517727,
 194838,
 -65281,
 16583250,
 194837,
 -65280,
 16648773,
 194836,
 -65279,
 16714296,
 194835,
 -65278,
 16779816,
 194834,
 -65277,
 16845339,
 194833,
 -1,
 16910873,
 194832,
 17170431,
 15927833,
 -1,
 -65274,
 17052352,
 194831,
 -65273,
 17115415,
 194830,
 -65272,
 17179010,
 194829,
 -65271,
 17242954,
 194828,
 -65270,
 17307299,
 194827,
 -65269,
 17369725,
 194826,
 -65268,
 17435259,
 194825,
 -65267,
 17500793,
 194824,
 -65266,
 17566316,
 194823,
 -65265,
 17631839,
 194822,
 -65264,
 17697362,
 194821,
 -65263,
 17762885,
 194820,
 -65262,
 17828408,
 194819,
 -65261,
 17893928,
 194818,
 -65260,
 17959451,
 194817,
 -1,
 18024985,
 194816,
 18219558,
 264825,
 -1,
 18284839,
 18166464,
 -1,
 -65256,
 18232000,
 194815,
 -65255,
 18295063,
 194814,
 -65254,
 18358658,
 194813,
 -65253,
 18422602,
 194812,
 -65252,
 18486947,
 194811,
 -65251,
 18549373,
 194810,
 -65250,
 18614907,
 194809,
 -65249,
 18680441,
 194808,
 -65248,
 18745964,
 194807,
 -65247,
 18811487,
 194806,
 -65246,
 18877010,
 194805,
 -65245,
 18942533,
 194804,
 -65244,
 19008056,
 194803,
 -65243,
 19073576,
 194802,
 -65242,
 19139099,
 194801,
 -1,
 19204633,
 194800,
 19398968,
 18229527,
 -1,
 -65239,
 19346112,
 194799,
 -65238,
 19409175,
 194798,
 -65237,
 19472770,
 194797,
 -65236,
 19536714,
 194796,
 -65235,
 19601059,
 194795,
 -65234,
 19663485,
 194794,
 -65233,
 19729019,
 194793,
 -65232,
 19794553,
 194792,
 -65231,
 19860076,
 194791,
 -65230,
 19925599,
 194790,
 -65229,
 19991122,
 194789,
 -65228,
 20056645,
 194788,
 -65227,
 20122168,
 194787,
 -65226,
 20187688,
 194786,
 -65225,
 20253211,
 194785,
 -1,
 20318745,
 194784,
 20513097,
 19341698,
 -1,
 -65222,
 20460224,
 194783,
 -65221,
 20523287,
 194782,
 -65220,
 20586882,
 194781,
 -65219,
 20650826,
 194780,
 -65218,
 20715171,
 194779,
 -65217,
 20777597,
 194778,
 -65216,
 20843131,
 194777,
 -65215,
 20908665,
 194776,
 -65214,
 20974188,
 194775,
 -65213,
 21039711,
 194774,
 -65212,
 21105234,
 194773,
 -65211,
 21170757,
 194772,
 -65210,
 21236280,
 194771,
 -65209,
 21301800,
 194770,
 -65208,
 21367323,
 194769,
 -1,
 21432857,
 194768,
 21627226,
 20454218,
 -1,
 -65205,
 21574336,
 194767,
 -65204,
 21637399,
 194766,
 -65203,
 21700994,
 194765,
 -65202,
 21764938,
 194764,
 -65201,
 21829283,
 194763,
 -65200,
 21891709,
 194762,
 -65199,
 21957243,
 194761,
 -65198,
 22022777,
 194760,
 -65197,
 22088300,
 194759,
 -65196,
 22153823,
 194758,
 -65195,
 22219346,
 194757,
 -65194,
 22284869,
 194756,
 -65193,
 22350392,
 194755,
 -65192,
 22415912,
 194754,
 -65191,
 22481435,
 194753,
 -1,
 22546969,
 194752,
 22741355,
 21567139,
 -1,
 -65188,
 22688448,
 194751,
 -65187,
 22751511,
 194750,
 -65186,
 22815106,
 194749,
 -65185,
 22879050,
 194748,
 -65184,
 22943395,
 194747,
 -65183,
 23005821,
 194746,
 -65182,
 23071355,
 194745,
 -65181,
 23136889,
 194744,
 -65180,
 23202412,
 194743,
 -65179,
 23267935,
 194742,
 -65178,
 23333458,
 194741,
 -65177,
 23398981,
 194740,
 -65176,
 23464504,
 194739,
 -65175,
 23530024,
 194738,
 -65174,
 23595547,
 194737,
 -1,
 23661081,
 194736,
 23855484,
 22678141,
 -1,
 -65171,
 23802560,
 194735,
 -65170,
 23865623,
 194734,
 -65169,
 23929218,
 194733,
 -65168,
 23993162,
 194732,
 -65167,
 24057507,
 194731,
 -65166,
 24119933,
 194730,
 -65165,
 24185467,
 194729,
 -65164,
 24251001,
 194728,
 -65163,
 24316524,
 194727,
 -65162,
 24382047,
 194726,
 -65161,
 24447570,
 194725,
 -65160,
 24513093,
 194724,
 -65159,
 24578616,
 194723,
 -65158,
 24644136,
 194722,
 -65157,
 24709659,
 194721,
 -1,
 24775193,
 194720,
 24969613,
 23792251,
 -1,
 -65154,
 24916672,
 194719,
 -65153,
 24979735,
 194718,
 -65152,
 25043330,
 194717,
 -65151,
 25107274,
 194716,
 -65150,
 25171619,
 194715,
 -65149,
 25234045,
 194714,
 -65148,
 25299579,
 194713,
 -65147,
 25365113,
 194712,
 -65146,
 25430636,
 194711,
 -65145,
 25496159,
 194710,
 -65144,
 25561682,
 194709,
 -65143,
 25627205,
 194708,
 -65142,
 25692728,
 194707,
 -65141,
 25758248,
 194706,
 -65140,
 25823771,
 194705,
 -1,
 25889305,
 194704,
 26083742,
 24906361,
 -1,
 -65137,
 26030784,
 194703,
 -65136,
 26093847,
 194702,
 -65135,
 26157442,
 194701,
 -65134,
 26221386,
 194700,
 -65133,
 26285731,
 194699,
 -65132,
 26348157,
 194698,
 -65131,
 26413691,
 194697,
 -65130,
 26479225,
 194696,
 -65129,
 26544748,
 194695,
 -65128,
 26610271,
 194694,
 -65127,
 26675794,
 194693,
 -65126,
 26741317,
 194692,
 -65125,
 26806840,
 194691,
 -65124,
 26872360,
 194690,
 -65123,
 26937883,
 194689,
 -1,
 27003417,
 194688,
 27197871,
 26020460,
 -1,
 -65120,
 27144896,
 194687,
 -65119,
 27207959,
 194686,
 -65118,
 27271554,
 194685,
 -65117,
 27335498,
 194684,
 -65116,
 27399843,
 194683,
 -65115,
 27462269,
 194682,
 -65114,
 27527803,
 194681,
 -65113,
 27593337,
 194680,
 -65112,
 27658860,
 194679,
 -65111,
 27724383,
 194678,
 -65110,
 27789906,
 194677,
 -65109,
 27855429,
 194676,
 -65108,
 27920952,
 194675,
 -65107,
 27986472,
 194674,
 -65106,
 28051995,
 194673,
 -1,
 28117529,
 194672,
 28312000,
 27134559,
 -1,
 -65103,
 28259008,
 194671,
 -65102,
 28322071,
 194670,
 -65101,
 28385666,
 194669,
 -65100,
 28449610,
 194668,
 -65099,
 28513955,
 194667,
 -65098,
 28576381,
 194666,
 -65097,
 28641915,
 194665,
 -65096,
 28707449,
 194664,
 -65095,
 28772972,
 194663,
 -65094,
 28838495,
 194662,
 -65093,
 28904018,
 194661,
 -65092,
 28969541,
 194660,
 -65091,
 29035064,
 194659,
 -65090,
 29100584,
 194658,
 -65089,
 29166107,
 194657,
 -1,
 29231641,
 194656,
 29426129,
 28248658,
 -1,
 -65086,
 29373120,
 194655,
 -65085,
 29436183,
 194654,
 -65084,
 29499778,
 194653,
 -65083,
 29563722,
 194652,
 -65082,
 29628067,
 194651,
 -65081,
 29690493,
 194650,
 -65080,
 29756027,
 194649,
 -65079,
 29821561,
 194648,
 -65078,
 29887084,
 194647,
 -65077,
 29952607,
 194646,
 -65076,
 30018130,
 194645,
 -65075,
 30083653,
 194644,
 -65074,
 30149176,
 194643,
 -65073,
 30214696,
 194642,
 -65072,
 30280219,
 194641,
 -1,
 30345753,
 194640,
 30540258,
 29362757,
 -1,
 -65069,
 30487232,
 194639,
 -65068,
 30550295,
 194638,
 -65067,
 30613890,
 194637,
 -65066,
 30677834,
 194636,
 -65065,
 30742179,
 194635,
 -65064,
 30804605,
 194634,
 -65063,
 30870139,
 194633,
 -65062,
 30935673,
 194632,
 -65061,
 31001196,
 194631,
 -65060,
 31066719,
 194630,
 -65059,
 31132242,
 194629,
 -65058,
 31197765,
 194628,
 -65057,
 31263288,
 194627,
 -65056,
 31328808,
 194626,
 -65055,
 31394331,
 194625,
 -1,
 31459865,
 194624,
 31654387,
 30476856,
 -1,
 -65052,
 31601344,
 194623,
 -65051,
 31664407,
 194622,
 -65050,
 31728002,
 194621,
 -65049,
 31791946,
 194620,
 -65048,
 31856291,
 194619,
 -65047,
 31918717,
 194618,
 -65046,
 31984251,
 194617,
 -65045,
 32049785,
 194616,
 -65044,
 32115308,
 194615,
 -65043,
 32180831,
 194614,
 -65042,
 32246354,
 194613,
 -65041,
 32311877,
 194612,
 -65040,
 32377400,
 194611,
 -65039,
 32442920,
 194610,
 -65038,
 32508443,
 194609,
 -1,
 32573977,
 194608,
 32768516,
 31590952,
 -1,
 -65035,
 32715456,
 194607,
 -65034,
 32778519,
 194606,
 -65033,
 32842114,
 194605,
 -65032,
 32906058,
 194604,
 -65031,
 32970403,
 194603,
 -65030,
 33032829,
 194602,
 -65029,
 33098363,
 194601,
 -65028,
 33163897,
 194600,
 -65027,
 33229420,
 194599,
 -65026,
 33294943,
 194598,
 -65025,
 33360466,
 194597,
 -65024,
 33425989,
 194596,
 -65023,
 33491512,
 194595,
 -65022,
 33557032,
 194594,
 -65021,
 33622555,
 194593,
 -1,
 33688089,
 194592,
 33882645,
 32705051,
 -1,
 -65018,
 33829568,
 194591,
 -65017,
 33892631,
 194590,
 -65016,
 33956226,
 194589,
 -65015,
 34020170,
 194588,
 -65014,
 34084515,
 194587,
 -65013,
 34146941,
 194586,
 -65012,
 34212475,
 194585,
 -65011,
 34278009,
 194584,
 -65010,
 34343532,
 194583,
 -65009,
 34409055,
 194582,
 -65008,
 34474578,
 194581,
 -65007,
 34540101,
 194580,
 -65006,
 34605624,
 194579,
 -65005,
 34671144,
 194578,
 -65004,
 34736667,
 194577,
 -1,
 34802201,
 194576,
 35061759,
 33819161,
 -1,
 -65001,
 34943680,
 194575,
 -65000,
 35006743,
 194574,
 -64999,
 35070338,
 194573,
 -64998,
 35134282,
 194572,
 -64997,
 35198627,
 194571,
 -64996,
 35261053,
 194570,
 -64995,
 35326587,
 194569,
 -64994,
 35392121,
 194568,
 -64993,
 35457644,
 194567,
 -64992,
 35523167,
 194566,
 -64991,
 35588690,
 194565,
 -64990,
 35654213,
 194564,
 -64989,
 35719736,
 194563,
 -64988,
 35785256,
 194562,
 -64987,
 35850779,
 194561,
 -1,
 35916313,
 194560,
 36175871,
 18156157,
 -1,
 36176440,
 36047385,
 -1,
 -64983,
 36123328,
 195087,
 -64982,
 36186391,
 195086,
 -64981,
 36249986,
 195085,
 -64980,
 36313930,
 195084,
 -64979,
 36378275,
 195083,
 -64978,
 36440701,
 195082,
 -64977,
 36506235,
 195081,
 -64976,
 36571769,
 195080,
 -64975,
 36637292,
 195079,
 -64974,
 36702815,
 195078,
 -64973,
 36768338,
 195077,
 -64972,
 36833861,
 195076,
 -64971,
 36899384,
 195075,
 -64970,
 36964904,
 195074,
 -64969,
 37030427,
 195073,
 -1,
 37095961,
 195072,
 37355519,
 36112923,
 -1,
 -64966,
 37233026,
 195101,
 -64965,
 37296970,
 195100,
 -64964,
 37361315,
 195099,
 -64963,
 37423741,
 195098,
 -64962,
 37489275,
 195097,
 -64961,
 37554809,
 195096,
 -64960,
 37620332,
 195095,
 -64959,
 37685855,
 195094,
 -64958,
 37751378,
 195093,
 -64957,
 37816901,
 195092,
 -64956,
 37882424,
 195091,
 -64955,
 37947944,
 195090,
 -64954,
 38013467,
 195089,
 -1,
 38079001,
 195088,
 38338559,
 209600,
 -1,
 38339417,
 38210171,
 -1,
 38404698,
 38286016,
 -1,
 -64949,
 38351552,
 63999,
 -64948,
 38414615,
 63998,
 -64947,
 38478210,
 63997,
 -64946,
 38542154,
 63996,
 -64945,
 38606499,
 63995,
 -64944,
 38668925,
 63994,
 -64943,
 38734459,
 63993,
 -64942,
 38799993,
 63992,
 -64941,
 38865516,
 63991,
 -64940,
 38931039,
 63990,
 -64939,
 38996562,
 63989,
 -64938,
 39062085,
 63988,
 -64937,
 39127608,
 63987,
 -64936,
 39193128,
 63986,
 -64935,
 39258651,
 63985,
 -1,
 39324185,
 63984,
 39518827,
 38349079,
 -1,
 -64932,
 39465664,
 63983,
 -64931,
 39528727,
 63982,
 -64930,
 39592322,
 63981,
 -64929,
 39656266,
 63980,
 -64928,
 39720611,
 63979,
 -64927,
 39783037,
 63978,
 -64926,
 39848571,
 63977,
 -64925,
 39914105,
 63976,
 -64924,
 39979628,
 63975,
 -64923,
 40045151,
 63974,
 -64922,
 40110674,
 63973,
 -64921,
 40176197,
 63972,
 -64920,
 40241720,
 63971,
 -64919,
 40307240,
 63970,
 -64918,
 40372763,
 63969,
 -1,
 40438297,
 63968,
 40632956,
 39461250,
 -1,
 -64915,
 40579776,
 63967,
 -64914,
 40642839,
 63966,
 -64913,
 40706434,
 63965,
 -64912,
 40770378,
 63964,
 -64911,
 40834723,
 63963,
 -64910,
 40897149,
 63962,
 -64909,
 40962683,
 63961,
 -64908,
 41028217,
 63960,
 -64907,
 41093740,
 63959,
 -64906,
 41159263,
 63958,
 -64905,
 41224786,
 63957,
 -64904,
 41290309,
 63956,
 -64903,
 41355832,
 63955,
 -64902,
 41421352,
 63954,
 -64901,
 41486875,
 63953,
 -1,
 41552409,
 63952,
 41747085,
 40573770,
 -1,
 -64898,
 41693888,
 63951,
 -64897,
 41756951,
 63950,
 -64896,
 41820546,
 63949,
 -64895,
 41884490,
 63948,
 -64894,
 41948835,
 63947,
 -64893,
 42011261,
 63946,
 -64892,
 42076795,
 63945,
 -64891,
 42142329,
 63944,
 -64890,
 42207852,
 63943,
 -64889,
 42273375,
 63942,
 -64888,
 42338898,
 63941,
 -64887,
 42404421,
 63940,
 -64886,
 42469944,
 63939,
 -64885,
 42535464,
 63938,
 -64884,
 42600987,
 63937,
 -1,
 42666521,
 63936,
 42861214,
 41686691,
 -1,
 -64881,
 42808000,
 63935,
 -64880,
 42871063,
 63934,
 -64879,
 42934658,
 63933,
 -64878,
 42998602,
 63932,
 -64877,
 43062947,
 63931,
 -64876,
 43125373,
 63930,
 -64875,
 43190907,
 63929,
 -64874,
 43256441,
 63928,
 -64873,
 43321964,
 63927,
 -64872,
 43387487,
 63926,
 -64871,
 43453010,
 63925,
 -64870,
 43518533,
 63924,
 -64869,
 43584056,
 63923,
 -64868,
 43649576,
 63922,
 -64867,
 43715099,
 63921,
 -1,
 43780633,
 63920,
 43975343,
 42797693,
 -1,
 -64864,
 43922112,
 63919,
 -64863,
 43985175,
 63918,
 -64862,
 44048770,
 63917,
 -64861,
 44112714,
 63916,
 -64860,
 44177059,
 63915,
 -64859,
 44239485,
 63914,
 -64858,
 44305019,
 63913,
 -64857,
 44370553,
 63912,
 -64856,
 44436076,
 63911,
 -64855,
 44501599,
 63910,
 -64854,
 44567122,
 63909,
 -64853,
 44632645,
 63908,
 -64852,
 44698168,
 63907,
 -64851,
 44763688,
 63906,
 -64850,
 44829211,
 63905,
 -1,
 44894745,
 63904,
 45089472,
 43911803,
 -1,
 -64847,
 45036224,
 63903,
 -64846,
 45099287,
 63902,
 -64845,
 45162882,
 63901,
 -64844,
 45226826,
 63900,
 -64843,
 45291171,
 63899,
 -64842,
 45353597,
 63898,
 -64841,
 45419131,
 63897,
 -64840,
 45484665,
 63896,
 -64839,
 45550188,
 63895,
 -64838,
 45615711,
 63894,
 -64837,
 45681234,
 63893,
 -64836,
 45746757,
 63892,
 -64835,
 45812280,
 63891,
 -64834,
 45877800,
 63890,
 -64833,
 45943323,
 63889,
 -1,
 46008857,
 63888,
 46203601,
 45025913,
 -1,
 -64830,
 46150336,
 63887,
 -64829,
 46213399,
 63886,
 -64828,
 46276994,
 63885,
 -64827,
 46340938,
 63884,
 -64826,
 46405283,
 63883,
 -64825,
 46467709,
 63882,
 -64824,
 46533243,
 63881,
 -64823,
 46598777,
 63880,
 -64822,
 46664300,
 63879,
 -64821,
 46729823,
 63878,
 -64820,
 46795346,
 63877,
 -64819,
 46860869,
 63876,
 -64818,
 46926392,
 63875,
 -64817,
 46991912,
 63874,
 -64816,
 47057435,
 63873,
 -1,
 47122969,
 63872,
 47317730,
 46140012,
 -1,
 -64813,
 47264448,
 63871,
 -64812,
 47327511,
 63870,
 -64811,
 47391106,
 63869,
 -64810,
 47455050,
 63868,
 -64809,
 47519395,
 63867,
 -64808,
 47581821,
 63866,
 -64807,
 47647355,
 63865,
 -64806,
 47712889,
 63864,
 -64805,
 47778412,
 63863,
 -64804,
 47843935,
 63862,
 -64803,
 47909458,
 63861,
 -64802,
 47974981,
 63860,
 -64801,
 48040504,
 63859,
 -64800,
 48106024,
 63858,
 -64799,
 48171547,
 63857,
 -1,
 48237081,
 63856,
 48431859,
 47254111,
 -1,
 -64796,
 48378560,
 63855,
 -64795,
 48441623,
 63854,
 -64794,
 48505218,
 63853,
 -64793,
 48569162,
 63852,
 -64792,
 48633507,
 63851,
 -64791,
 48695933,
 63850,
 -64790,
 48761467,
 63849,
 -64789,
 48827001,
 63848,
 -64788,
 48892524,
 63847,
 -64787,
 48958047,
 63846,
 -64786,
 49023570,
 63845,
 -64785,
 49089093,
 63844,
 -64784,
 49154616,
 63843,
 -64783,
 49220136,
 63842,
 -64782,
 49285659,
 63841,
 -1,
 49351193,
 63840,
 49545988,
 48368210,
 -1,
 -64779,
 49492672,
 63839,
 -64778,
 49555735,
 63838,
 -64777,
 49619330,
 63837,
 -64776,
 49683274,
 63836,
 -64775,
 49747619,
 63835,
 -64774,
 49810045,
 63834,
 -64773,
 49875579,
 63833,
 -64772,
 49941113,
 63832,
 -64771,
 50006636,
 63831,
 -64770,
 50072159,
 63830,
 -64769,
 50137682,
 63829,
 -64768,
 50203205,
 63828,
 -64767,
 50268728,
 63827,
 -64766,
 50334248,
 63826,
 -64765,
 50399771,
 63825,
 -1,
 50465305,
 63824,
 50660117,
 49482309,
 -1,
 -64762,
 50606784,
 63823,
 -64761,
 50669847,
 63822,
 -64760,
 50733442,
 63821,
 -64759,
 50797386,
 63820,
 -64758,
 50861731,
 63819,
 -64757,
 50924157,
 63818,
 -64756,
 50989691,
 63817,
 -64755,
 51055225,
 63816,
 -64754,
 51120748,
 63815,
 -64753,
 51186271,
 63814,
 -64752,
 51251794,
 63813,
 -64751,
 51317317,
 63812,
 -64750,
 51382840,
 63811,
 -64749,
 51448360,
 63810,
 -64748,
 51513883,
 63809,
 -1,
 51579417,
 63808,
 51774246,
 50596408,
 -1,
 -64745,
 51720896,
 63807,
 -64744,
 51783959,
 63806,
 -64743,
 51847554,
 63805,
 -64742,
 51911498,
 63804,
 -64741,
 51975843,
 63803,
 -64740,
 52038269,
 63802,
 -64739,
 52103803,
 63801,
 -64738,
 52169337,
 63800,
 -64737,
 52234860,
 63799,
 -64736,
 52300383,
 63798,
 -64735,
 52365906,
 63797,
 -64734,
 52431429,
 63796,
 -64733,
 52496952,
 63795,
 -64732,
 52562472,
 63794,
 -64731,
 52627995,
 63793,
 -1,
 52693529,
 63792,
 52888375,
 51710504,
 -1,
 -64728,
 52835008,
 63791,
 -64727,
 52898071,
 63790,
 -64726,
 52961666,
 63789,
 -64725,
 53025610,
 63788,
 -64724,
 53089955,
 63787,
 -64723,
 53152381,
 63786,
 -64722,
 53217915,
 63785,
 -64721,
 53283449,
 63784,
 -64720,
 53348972,
 63783,
 -64719,
 53414495,
 63782,
 -64718,
 53480018,
 63781,
 -64717,
 53545541,
 63780,
 -64716,
 53611064,
 63779,
 -64715,
 53676584,
 63778,
 -64714,
 53742107,
 63777,
 -1,
 53807641,
 63776,
 54002504,
 52824603,
 -1,
 -64711,
 53949120,
 63775,
 -64710,
 54012183,
 63774,
 -64709,
 54075778,
 63773,
 -64708,
 54139722,
 63772,
 -64707,
 54204067,
 63771,
 -64706,
 54266493,
 63770,
 -64705,
 54332027,
 63769,
 -64704,
 54397561,
 63768,
 -64703,
 54463084,
 63767,
 -64702,
 54528607,
 63766,
 -64701,
 54594130,
 63765,
 -64700,
 54659653,
 63764,
 -64699,
 54725176,
 63763,
 -64698,
 54790696,
 63762,
 -64697,
 54856219,
 63761,
 -1,
 54921753,
 63760,
 55181311,
 53938713,
 -1,
 -64694,
 55063232,
 63759,
 -64693,
 55126295,
 63758,
 -64692,
 55189890,
 63757,
 -64691,
 55253834,
 63756,
 -64690,
 55318179,
 63755,
 -64689,
 55380605,
 63754,
 -64688,
 55446139,
 63753,
 -64687,
 55511673,
 63752,
 -64686,
 55577196,
 63751,
 -64685,
 55642719,
 63750,
 -64684,
 55708242,
 63749,
 -64683,
 55773765,
 63748,
 -64682,
 55839288,
 63747,
 -64681,
 55904808,
 63746,
 -64680,
 55970331,
 63745,
 -1,
 56035865,
 63744,
 56295423,
 38275709,
 -1,
 56296299,
 56166994,
 -1,
 -64676,
 56242880,
 64095,
 -64675,
 56305943,
 64094,
 -64674,
 56369538,
 64093,
 -64673,
 56433482,
 64092,
 -64672,
 56497827,
 64091,
 -64671,
 56560253,
 64090,
 -64670,
 56625787,
 64089,
 -64669,
 56691321,
 64088,
 -64668,
 56756844,
 64087,
 -64667,
 56822367,
 64086,
 -64666,
 56887890,
 64085,
 -64665,
 56953413,
 64084,
 -64664,
 57018936,
 64083,
 -64663,
 57084456,
 64082,
 -64662,
 57149979,
 64081,
 -1,
 57215513,
 64080,
 57410428,
 56232517,
 -1,
 -64659,
 57356992,
 64079,
 -64658,
 57420055,
 64078,
 -64657,
 57483650,
 64077,
 -64656,
 57547594,
 64076,
 -64655,
 57611939,
 64075,
 -64654,
 57674365,
 64074,
 -64653,
 57739899,
 64073,
 -64652,
 57805433,
 64072,
 -64651,
 57870956,
 64071,
 -64650,
 57936479,
 64070,
 -64649,
 58002002,
 64069,
 -64648,
 58067525,
 64068,
 -64647,
 58133048,
 64067,
 -64646,
 58198568,
 64066,
 -64645,
 58264091,
 64065,
 -1,
 58329625,
 64064,
 58524557,
 57346616,
 -1,
 -64642,
 58471104,
 64063,
 -64641,
 58534167,
 64062,
 -64640,
 58597762,
 64061,
 -64639,
 58661706,
 64060,
 -64638,
 58726051,
 64059,
 -64637,
 58788477,
 64058,
 -64636,
 58854011,
 64057,
 -64635,
 58919545,
 64056,
 -64634,
 58985068,
 64055,
 -64633,
 59050591,
 64054,
 -64632,
 59116114,
 64053,
 -64631,
 59181637,
 64052,
 -64630,
 59247160,
 64051,
 -64629,
 59312680,
 64050,
 -64628,
 59378203,
 64049,
 -1,
 59443737,
 64048,
 59638686,
 58460699,
 -1,
 -64625,
 59585216,
 64031,
 -64624,
 59648279,
 64030,
 -64623,
 59711874,
 64029,
 -64622,
 59775818,
 64028,
 -64621,
 59840163,
 64027,
 -64620,
 59902589,
 64026,
 -64619,
 59968123,
 64025,
 -64618,
 60033657,
 64024,
 -64617,
 60099180,
 64023,
 -64616,
 60164703,
 64022,
 -64615,
 60230226,
 64021,
 -64614,
 60295749,
 64020,
 -64613,
 60361272,
 64019,
 -64612,
 60426792,
 64018,
 -64611,
 60492315,
 64017,
 -1,
 60557849,
 64016,
 60752815,
 59574809,
 -1,
 -64608,
 60699328,
 64015,
 -64607,
 60762391,
 64014,
 -64606,
 60825986,
 64013,
 -64605,
 60889930,
 64012,
 -64604,
 60954275,
 64011,
 -64603,
 61016701,
 64010,
 -64602,
 61082235,
 64009,
 -64601,
 61147769,
 64008,
 -64600,
 61213292,
 64007,
 -64599,
 61278815,
 64006,
 -64598,
 61344338,
 64005,
 -64597,
 61409861,
 64004,
 -64596,
 61475384,
 64003,
 -64595,
 61540904,
 64002,
 -64594,
 61606427,
 64001,
 -1,
 61671961,
 64000,
 61866942,
 60688936,
 -1,
 -64591,
 61809026,
 64045,
 -64590,
 61872970,
 64044,
 -64589,
 61937315,
 64043,
 -64588,
 61999741,
 64042,
 -64587,
 62065275,
 64041,
 -64586,
 62130809,
 64040,
 -64585,
 62196332,
 64039,
 -64584,
 62261855,
 64038,
 -64583,
 62327378,
 64037,
 -64582,
 62392901,
 64036,
 -64581,
 62458424,
 64035,
 -64580,
 62523944,
 64034,
 -64579,
 62589467,
 64033,
 -1,
 62655001,
 64032,
 62914559,
 61803103,
 -1,
 -64576,
 62786173,
 64106,
 -64575,
 62851707,
 64105,
 -64574,
 62917241,
 64104,
 -64573,
 62982764,
 64103,
 -64572,
 63048287,
 64102,
 -64571,
 63113810,
 64101,
 -64570,
 63179333,
 64100,
 -64569,
 63244856,
 64099,
 -64568,
 63310376,
 64098,
 -64567,
 63375899,
 64097,
 -1,
 63441433,
 64096,
 63700991,
 159923,
 -1,
 63702001,
 63576906,
 -1,
 63767529,
 63637995,
 -1,
 63833043,
 63732363,
 -1,
 -64561,
 63794026,
 11976,
 -64560,
 63849246,
 11952,
 -64559,
 63912983,
 11977,
 -64558,
 63974098,
 11973,
 -1,
 64032579,
 12007,
 64226263,
 63799948,
 -1,
 -64555,
 64196732,
 12019,
 -64554,
 64251022,
 12014,
 -1,
 64295252,
 11993,
 64488411,
 64172736,
 -1,
 -64551,
 64452651,
 12010,
 -64550,
 64509191,
 11996,
 -1,
 64571245,
 12005,
 64750558,
 64441165,
 -1,
 -64547,
 64709602,
 11987,
 -1,
 64760143,
 11994,
 64947169,
 64697751,
 -1,
 -64544,
 64905882,
 11984,
 -1,
 64951703,
 11988,
 65143780,
 64891159,
 -1,
 -64541,
 65114718,
 12012,
 -1,
 65148282,
 12000,
 -64539,
 65115846,
 11995,
 -64538,
 65289821,
 12002,
 -64537,
 65349802,
 12016,
 -64536,
 65412192,
 11979,
 -1,
 65476865,
 12006,
 65668076,
 63720269,
 -1,
 -64533,
 65627980,
 11970,
 -1,
 65683826,
 11905,
 65864687,
 65617793,
 -1,
 -64530,
 65836037,
 11936,
 -1,
 65899219,
 11983,
 -64528,
 65825083,
 11943,
 -1,
 66010467,
 11931,
 66192400,
 63666827,
 -1,
 66257916,
 66142081,
 -1,
 66323451,
 66214396,
 -1,
 66388983,
 66295007,
 -1,
 -64522,
 66337648,
 12008,
 -1,
 66391741,
 11980,
 66585594,
 66337096,
 -1,
 -64519,
 66545206,
 11974,
 -1,
 66588279,
 11942,
 -1,
 66558566,
 12009,
 -1,
 66277918,
 11951,
 66913283,
 66201879,
 -1,
 66978818,
 66854760,
 -1,
 67044353,
 66945676,
 -1,
 -64512,
 67016857,
 11907,
 -1,
 67059363,
 11908,
 -1,
 67003322,
 11906,
 -1,
 66915712,
 11915,
 67372040,
 66869922,
 -1,
 67437575,
 67332192,
 -1,
 -64506,
 67406380,
 11925,
 -1,
 67462074,
 11924,
 -1,
 67374427,
 11922,
 67699723,
 67333359,
 -1,
 -64502,
 67668524,
 11949,
 -1,
 67724218,
 11948,
 67896334,
 67655150,
 -1,
 -64499,
 67865132,
 11917,
 -1,
 67920826,
 11916,
 -64497,
 67865852,
 11932,
 -1,
 68041710,
 11958,
 68224027,
 66147631,
 -1,
 68289560,
 68182287,
 -1,
 68355093,
 68259130,
 -1,
 -64492,
 68323884,
 11990,
 -1,
 68379578,
 11989,
 -64490,
 68322645,
 11935,
 -64489,
 68516374,
 11965,
 -1,
 68576076,
 11933,
 68812799,
 68233495,
 -1,
 -64486,
 68713700,
 11957,
 -1,
 68752762,
 11964,
 68944933,
 68163235,
 -1,
 69010464,
 68903183,
 -1,
 -64482,
 68983077,
 11910,
 -64481,
 69033038,
 12003,
 -1,
 69096586,
 11946,
 69272611,
 68975204,
 -1,
 -64478,
 69241388,
 11963,
 -1,
 69297082,
 11962,
 -64476,
 69227705,
 11992,
 -1,
 69406615,
 11950,
 69600304,
 68916447,
 -1,
 69665837,
 69536381,
 -1,
 69731370,
 69633130,
 -1,
 -64471,
 69700140,
 11938,
 -1,
 69755834,
 11937,
 69992447,
 69685793,
 -1,
 -64468,
 69896748,
 11982,
 -1,
 69952442,
 11981,
 70189055,
 69611756,
 -1,
 -64465,
 70093356,
 11972,
 -1,
 70149050,
 11971,
 70321210,
 69552973,
 -1,
 70386743,
 70258598,
 -1,
 70452277,
 70353548,
 -1,
 -64460,
 70424729,
 11919,
 -1,
 70467235,
 11920,
 -64458,
 70411194,
 11918,
 -1,
 70595814,
 11921,
 70844415,
 70345702,
 -1,
 -64455,
 70748716,
 11986,
 -1,
 70804410,
 11985,
 70976578,
 70273197,
 -1,
 71042113,
 70912491,
 -1,
 71107647,
 71008908,
 -1,
 -64450,
 71078012,
 12018,
 -1,
 71132302,
 12013,
 -64448,
 71053775,
 12011,
 -1,
 71248042,
 12015,
 -1,
 70978645,
 11945,
 71500874,
 70924616,
 -1,
 71566408,
 71444812,
 -1,
 71631943,
 71531021,
 -1,
 -64442,
 71600684,
 11927,
 -1,
 71656378,
 11926,
 -1,
 71573890,
 12001,
 -64439,
 71525942,
 11975,
 -1,
 71831582,
 11928,
 72025170,
 71444759,
 -1,
 72090704,
 71964029,
 -1,
 72156239,
 72057484,
 -1,
 -64434,
 72128665,
 11998,
 -1,
 72171171,
 11999,
 -1,
 72115130,
 11997,
 -64431,
 72063531,
 11947,
 -1,
 72390128,
 11960,
 72549463,
 71991948,
 -1,
 -64428,
 72519804,
 12017,
 -64427,
 72565206,
 11969,
 -64426,
 72629917,
 11923,
 -1,
 72682181,
 11911,
 72877149,
 72511601,
 -1,
 72942684,
 72813181,
 -1,
 -64422,
 72903189,
 11929,
 -64421,
 72963375,
 11959,
 -1,
 73024467,
 11991,
 -1,
 72888102,
 11904,
 73270371,
 72834198,
 -1,
 73335905,
 73237132,
 -1,
 -64416,
 73308313,
 11954,
 -1,
 73350819,
 11955,
 -64414,
 73294778,
 11953,
 -1,
 73479398,
 11956,
 73663594,
 73217431,
 -1,
 73729129,
 73625930,
 -1,
 73794664,
 73695884,
 -1,
 -64409,
 73767065,
 11967,
 -1,
 73809571,
 11968,
 -1,
 73753530,
 11966,
 -1,
 73678452,
 12004,
 74122351,
 73624085,
 -1,
 74187886,
 74061407,
 -1,
 -64403,
 74156588,
 11941,
 -1,
 74212282,
 11940,
 -1,
 74133552,
 11909,
 74450035,
 74064258,
 -1,
 -64399,
 74408421,
 11944,
 -64398,
 74467440,
 11914,
 -1,
 74525116,
 11934,
 74712182,
 74402479,
 -1,
 -64395,
 74680876,
 11913,
 -1,
 74736570,
 11912,
 74908793,
 74658496,
 -1,
 -64392,
 74867850,
 11978,
 -1,
 74925828,
 11939,
 -1,
 74867354,
 11961,
 75171661,
 68221,
 -1,
 75237186,
 75127458,
 -1,
 75302719,
 75172963,
 -1,
 75367769,
 75242314,
 5281,
 75433291,
 75303549,
 5264,
 75498825,
 75397534,
 -1,
 75564203,
 75465356,
 -1,
 75629711,
 75530892,
 -1,
 75695241,
 75594379,
 -1,
 75760773,
 75639063,
 5737,
 -1,
 75704599,
 5738,
 -64378,
 75729652,
 5735,
 -64377,
 75849999,
 5736,
 -64376,
 75906945,
 5739,
 -1,
 75958909,
 5740,
 76153995,
 75639063,
 5604,
 -1,
 76097815,
 5605,
 -64372,
 76122868,
 5602,
 -64371,
 76243215,
 5603,
 -64370,
 76300161,
 5606,
 -1,
 76352125,
 5607,
 76547229,
 75582285,
 -1,
 76612759,
 76495176,
 -1,
 76678291,
 76556567,
 5686,
 -1,
 76622103,
 5687,
 -64364,
 76647156,
 5684,
 -64363,
 76767503,
 5685,
 -64362,
 76824449,
 5688,
 -1,
 76876413,
 5689,
 77071513,
 76556567,
 5692,
 -1,
 77015319,
 5693,
 -64358,
 77040372,
 5690,
 -64357,
 77160719,
 5691,
 -64356,
 77217665,
 5694,
 -1,
 77269629,
 5695,
 77464740,
 76511883,
 -1,
 77530272,
 77408535,
 5725,
 -1,
 77474071,
 5726,
 -64351,
 77499124,
 5723,
 -64350,
 77619471,
 5724,
 -64349,
 77676417,
 5727,
 -1,
 77728381,
 5728,
 77987839,
 77412680,
 -1,
 77989031,
 77867287,
 5598,
 -1,
 77932823,
 5599,
 -64344,
 77957876,
 5596,
 -64343,
 78078223,
 5597,
 -64342,
 78135169,
 5600,
 -1,
 78187133,
 5601,
 78382268,
 75506050,
 -1,
 78447795,
 78355406,
 -1,
 78513327,
 78391575,
 5706,
 -1,
 78457111,
 5707,
 -64336,
 78482164,
 5704,
 -64335,
 78602511,
 5705,
 -64334,
 78659457,
 5708,
 -1,
 78711421,
 5709,
 78906554,
 78400333,
 -1,
 78972086,
 78850327,
 5674,
 -1,
 78915863,
 5675,
 -64329,
 78940916,
 5672,
 -64328,
 79061263,
 5673,
 -64327,
 79118209,
 5676,
 -1,
 79170173,
 5677,
 -64325,
 78856065,
 5204,
 -1,
 79309522,
 5203,
 79496394,
 78346891,
 -1,
 79561924,
 79444296,
 5722,
 79627456,
 79505687,
 5718,
 -1,
 79571223,
 5719,
 -64319,
 79596276,
 5716,
 -64318,
 79716623,
 5717,
 -64317,
 79773569,
 5720,
 -1,
 79825533,
 5721,
 80020678,
 79505687,
 5712,
 -1,
 79964439,
 5713,
 -64313,
 79989492,
 5710,
 -64312,
 80109839,
 5711,
 -64311,
 80166785,
 5714,
 -1,
 80218749,
 5715,
 80413913,
 79448483,
 -1,
 80479442,
 80365987,
 5633,
 80544974,
 80423191,
 5629,
 -1,
 80488727,
 5630,
 -64305,
 80513780,
 5627,
 -64304,
 80634127,
 5628,
 -64303,
 80691073,
 5631,
 -1,
 80743037,
 5632,
 81002495,
 80427336,
 -1,
 81003733,
 80881943,
 5623,
 -1,
 80947479,
 5624,
 -64298,
 80972532,
 5621,
 -64297,
 81092879,
 5622,
 -64296,
 81149825,
 5625,
 -1,
 81201789,
 5626,
 81396967,
 80366413,
 -1,
 81462497,
 81344840,
 -1,
 81528029,
 81406231,
 5680,
 -1,
 81471767,
 5681,
 -64290,
 81496820,
 5678,
 -64289,
 81617167,
 5679,
 -64288,
 81674113,
 5682,
 -1,
 81726077,
 5683,
 81921251,
 81406231,
 5668,
 -1,
 81864983,
 5669,
 -64284,
 81890036,
 5666,
 -64283,
 82010383,
 5667,
 -64282,
 82067329,
 5670,
 -1,
 82119293,
 5671,
 82314485,
 81348781,
 -1,
 82380015,
 82266285,
 -1,
 82445547,
 82323735,
 5662,
 -1,
 82389271,
 5663,
 -64276,
 82414324,
 5660,
 -64275,
 82534671,
 5661,
 -64274,
 82591617,
 5664,
 -1,
 82643581,
 5665,
 82838769,
 82323735,
 5655,
 -1,
 82782487,
 5656,
 -64270,
 82807540,
 5652,
 -64269,
 82927887,
 5654,
 -64268,
 82984833,
 5657,
 -1,
 83036797,
 5659,
 83232003,
 82261399,
 -1,
 83297533,
 83179848,
 -1,
 83363065,
 83241239,
 5574,
 -1,
 83306775,
 5575,
 -64262,
 83331828,
 5572,
 -64261,
 83452175,
 5573,
 -64260,
 83509121,
 5576,
 -1,
 83561085,
 5577,
 83756287,
 83241239,
 5617,
 -1,
 83699991,
 5618,
 -64256,
 83725044,
 5615,
 -64255,
 83845391,
 5616,
 -64254,
 83902337,
 5619,
 -1,
 83954301,
 5620,
 84149517,
 83179848,
 5195,
 84215051,
 84120799,
 -1,
 84280583,
 84158743,
 5592,
 -1,
 84224279,
 5593,
 -64248,
 84249332,
 5590,
 -64247,
 84369679,
 5591,
 -64246,
 84426625,
 5594,
 -1,
 84478589,
 5595,
 -64244,
 84164481,
 5175,
 -1,
 84617938,
 5174,
 84804884,
 84122574,
 5702,
 84870416,
 84748567,
 5698,
 -1,
 84814103,
 5699,
 -64239,
 84839156,
 5696,
 -64238,
 84959503,
 5697,
 -64237,
 85016449,
 5700,
 -1,
 85068413,
 5701,
 85263643,
 84765205,
 5614,
 85329175,
 85207319,
 5610,
 -1,
 85272855,
 5611,
 -64232,
 85297908,
 5608,
 -64231,
 85418255,
 5609,
 -64230,
 85475201,
 5612,
 -1,
 85527165,
 5613,
 85722403,
 85220002,
 -1,
 85787934,
 85666071,
 5636,
 -1,
 85731607,
 5637,
 -64225,
 85756660,
 5634,
 -64224,
 85877007,
 5635,
 -64223,
 85933953,
 5638,
 -64222,
 85996951,
 5329,
 -1,
 86051453,
 5639,
 86246698,
 85694931,
 -1,
 86312230,
 86190359,
 5648,
 -1,
 86255895,
 5649,
 -64217,
 86280948,
 5646,
 -64216,
 86401295,
 5647,
 -64215,
 86458241,
 5650,
 -1,
 86510205,
 5651,
 86705457,
 86217951,
 -1,
 86770989,
 86649111,
 5586,
 -1,
 86714647,
 5587,
 -64210,
 86739700,
 5584,
 -64209,
 86860047,
 5585,
 -64208,
 86916993,
 5588,
 -1,
 86968957,
 5589,
 87164216,
 86667377,
 -1,
 87229748,
 87107863,
 5580,
 -1,
 87173399,
 5581,
 -64203,
 87198452,
 5578,
 -64202,
 87318799,
 5579,
 -64201,
 87375745,
 5582,
 -1,
 87427709,
 5583,
 87622975,
 87119151,
 -1,
 87688507,
 87566615,
 5642,
 -1,
 87632151,
 5643,
 -64196,
 87657204,
 5640,
 -64195,
 87777551,
 5641,
 -64194,
 87834497,
 5644,
 -1,
 87886461,
 5645,
 88081734,
 87563504,
 -1,
 88147266,
 88025367,
 5731,
 -1,
 88090903,
 5732,
 -64189,
 88115956,
 5729,
 -64188,
 88236303,
 5730,
 -64187,
 88293249,
 5733,
 -1,
 88345213,
 5734,
 88540488,
 88031105,
 5129,
 -1,
 88497579,
 5703,
 -1,
 88484562,
 5128,
 88801279,
 75434621,
 5265,
 -1,
 88686465,
 5258,
 88868179,
 75404511,
 -1,
 88933710,
 88826127,
 5272,
 -1,
 88891663,
 5274,
 89064784,
 88883073,
 5268,
 -1,
 89014145,
 5270,
 89195858,
 89000573,
 5276,
 -1,
 89131645,
 5278,
 -1,
 89139479,
 5266,
 89392469,
 88826127,
 5261,
 -1,
 89350415,
 5262,
 89523543,
 89341825,
 5259,
 -1,
 89472897,
 5260,
 -64168,
 89472072,
 5741,
 -1,
 89598231,
 5257,
 89785804,
 75338975,
 -1,
 89851329,
 89729303,
 5132,
 89980927,
 89817344,
 -1,
 89982317,
 89881227,
 -1,
 90047845,
 89953503,
 -1,
 90113376,
 90005775,
 5373,
 -1,
 90071311,
 5375,
 90244450,
 90062721,
 5369,
 -1,
 90193793,
 5371,
 90375524,
 90180221,
 5377,
 -1,
 90311293,
 5379,
 -1,
 90319127,
 5367,
 90636287,
 89997140,
 -1,
 90637672,
 90530063,
 5406,
 -1,
 90595599,
 5408,
 90768746,
 90587009,
 5402,
 -1,
 90718081,
 5404,
 90899820,
 90704509,
 5410,
 -1,
 90835581,
 5412,
 -1,
 90843415,
 5400,
 91096441,
 89934669,
 5355,
 91161974,
 91067615,
 -1,
 91227505,
 91119887,
 5347,
 -1,
 91185423,
 5349,
 91358579,
 91176833,
 5343,
 -1,
 91307905,
 5345,
 91489653,
 91294333,
 5351,
 -1,
 91425405,
 5353,
 -1,
 91433239,
 5341,
 -64137,
 91119887,
 5450,
 -64136,
 91629847,
 5444,
 -1,
 91687549,
 5453,
 91882882,
 91068883,
 5440,
 92012543,
 91854047,
 -1,
 92013949,
 91906319,
 5430,
 -1,
 91971855,
 5432,
 92145023,
 91963265,
 5426,
 -1,
 92094337,
 5428,
 92276097,
 92080765,
 5434,
 -1,
 92211837,
 5436,
 -1,
 92219671,
 5424,
 92472716,
 91849356,
 -1,
 92538251,
 92443871,
 -1,
 92603782,
 92496143,
 5214,
 -1,
 92561679,
 5216,
 92734856,
 92553089,
 5210,
 -1,
 92684161,
 5212,
 92865930,
 92670589,
 5218,
 -1,
 92801661,
 5220,
 -1,
 92809495,
 5208,
 -1,
 92487515,
 5481,
 93128085,
 92432917,
 5194,
 93257727,
 93099231,
 -1,
 93259152,
 93151503,
 5185,
 -1,
 93217039,
 5187,
 93390226,
 93208449,
 5181,
 -1,
 93339521,
 5183,
 93521300,
 93325949,
 5189,
 -1,
 93457021,
 5191,
 -1,
 93464855,
 5179,
 93717918,
 93082927,
 5308,
 93847551,
 93689055,
 -1,
 93848985,
 93741327,
 5299,
 -1,
 93806863,
 5301,
 93980059,
 93798273,
 5295,
 -1,
 93929345,
 5297,
 94111133,
 93915773,
 5303,
 -1,
 94046845,
 5305,
 -1,
 94054679,
 5293,
 94307750,
 93689055,
 -1,
 94373281,
 94265615,
 5139,
 -1,
 94331151,
 5141,
 94504355,
 94322561,
 5135,
 -1,
 94453633,
 5137,
 94635429,
 94440061,
 5144,
 -1,
 94571133,
 5146,
 -1,
 94578967,
 5133,
 94832046,
 94260029,
 -1,
 94897577,
 94789903,
 5243,
 -1,
 94855439,
 5245,
 95028651,
 94846849,
 5239,
 -1,
 94977921,
 5241,
 95159725,
 94964349,
 5247,
 -1,
 95095421,
 5249,
 -1,
 95103255,
 5237,
 95356342,
 94773617,
 -1,
 95421873,
 95314191,
 5273,
 -1,
 95379727,
 5275,
 95552947,
 95371137,
 5269,
 -1,
 95502209,
 5271,
 95684021,
 95488637,
 5277,
 -1,
 95619709,
 5279,
 -1,
 95627543,
 5267,
 95880636,
 95318129,
 5457,
 -64072,
 95851769,
 5455,
 -64071,
 95904015,
 5516,
 -64070,
 95960961,
 5515,
 -64069,
 96020759,
 5514,
 -1,
 96078461,
 5517,
 96273856,
 95838393,
 -1,
 96339391,
 96209533,
 5324,
 -1,
 96275069,
 5326,
 -1,
 96282903,
 5322,
 -1,
 96220562,
 5468,
 96601544,
 89809167,
 5138,
 96731135,
 96559375,
 5140,
 96796671,
 96610539,
 5535,
 -64059,
 96690447,
 5533,
 -64058,
 96747393,
 5532,
 -64057,
 96807191,
 5531,
 -1,
 96864893,
 5534,
 97060298,
 96550785,
 5134,
 -1,
 97009537,
 5136,
 97255423,
 96995965,
 5143,
 -1,
 97127037,
 5145,
 97322506,
 89741986,
 5328,
 97388002,
 97258109,
 5319,
 97453536,
 97353483,
 -1,
 97519063,
 97417867,
 -1,
 97584594,
 97471293,
 5386,
 -1,
 97520253,
 5390,
 -64045,
 97555705,
 5380,
 -64044,
 97683997,
 5389,
 -64043,
 97742531,
 5388,
 -64042,
 97788276,
 5391,
 -1,
 97847830,
 5387,
 98043354,
 97490143,
 -1,
 -64039,
 98002003,
 5142,
 -1,
 98044562,
 5147,
 -64037,
 98016176,
 5437,
 -64036,
 98208289,
 5221,
 -64035,
 98263228,
 5327,
 -64034,
 98327177,
 5306,
 -64033,
 98388800,
 5250,
 -1,
 98443640,
 5280,
 98697215,
 97389181,
 5320,
 -1,
 98582401,
 5313,
 98764268,
 97357080,
 -1,
 98829803,
 98714286,
 5499,
 98895334,
 98787599,
 5495,
 -1,
 98853135,
 5496,
 99026408,
 98844545,
 5493,
 -1,
 98975617,
 5494,
 99157482,
 98962045,
 5497,
 -1,
 99093117,
 5498,
 -1,
 99100951,
 5492,
 -1,
 98799871,
 5500,
 99419637,
 98710935,
 5525,
 99485169,
 99355261,
 5523,
 99550704,
 99420797,
 5524,
 -1,
 99499905,
 5518,
 -1,
 99499905,
 5744,
 99747315,
 99442959,
 5521,
 -1,
 99705103,
 5522,
 99942399,
 99696513,
 5519,
 -1,
 99827585,
 5520,
 100009468,
 99376293,
 5526,
 100075000,
 99967247,
 5747,
 -1,
 100032783,
 5748,
 100206074,
 100024193,
 5745,
 -1,
 100155265,
 5746,
 100401151,
 100141693,
 5749,
 -1,
 100272765,
 5750,
 100468224,
 99980511,
 -1,
 100533759,
 100403837,
 5323,
 -1,
 100469373,
 5325,
 -1,
 100477207,
 5321,
 100730372,
 100403267,
 -1,
 100795907,
 100679553,
 5473,
 -1,
 100745089,
 5475,
 -1,
 100739351,
 5471,
 100992518,
 100688143,
 5316,
 -1,
 100950287,
 5317,
 101123592,
 100941697,
 5314,
 -1,
 101072769,
 5315,
 -63991,
 101071176,
 5330,
 -1,
 101198103,
 5312,
 101385792,
 97288844,
 5222,
 101451292,
 101333320,
 5482,
 101516820,
 101386307,
 5550,
 101582351,
 101474575,
 5546,
 -1,
 101540111,
 5547,
 101713425,
 101531521,
 5544,
 -1,
 101662593,
 5545,
 101844499,
 101649021,
 5548,
 -1,
 101780093,
 5549,
 -1,
 101787927,
 5543,
 102041110,
 101474575,
 5476,
 -1,
 101998863,
 5477,
 102172184,
 101990273,
 5472,
 -1,
 102121345,
 5474,
 102303258,
 102107773,
 5478,
 -1,
 102238845,
 5479,
 -63973,
 102274297,
 5480,
 -1,
 102377751,
 5470,
 102565414,
 101417612,
 -1,
 102630946,
 102512968,
 5487,
 -63969,
 102588687,
 5485,
 -63968,
 102645633,
 5484,
 -63967,
 102705431,
 5483,
 -1,
 102763133,
 5486,
 -63965,
 102588687,
 5225,
 -63964,
 102907777,
 5224,
 -63963,
 102967575,
 5223,
 -1,
 103025277,
 5226,
 103220782,
 102536415,
 -1,
 103286313,
 103178511,
 5213,
 -1,
 103244047,
 5215,
 103417387,
 103235457,
 5209,
 -1,
 103366529,
 5211,
 103548461,
 103352957,
 5217,
 -1,
 103484029,
 5219,
 -1,
 103491863,
 5207,
 103745075,
 103193043,
 -1,
 -63952,
 103702799,
 5490,
 -63951,
 103759745,
 5489,
 -63950,
 103819543,
 5488,
 -1,
 103877245,
 5491,
 104072760,
 103698619,
 -1,
 -63947,
 104030479,
 5512,
 -63946,
 104087425,
 5511,
 -63945,
 104147223,
 5510,
 -1,
 104204925,
 5513,
 104400443,
 104008317,
 5205,
 104529919,
 104335997,
 5206,
 -1,
 104415105,
 5197,
 104597053,
 104358159,
 5200,
 -1,
 104554767,
 5201,
 104728127,
 104546177,
 5198,
 -1,
 104677249,
 5199,
 -1,
 104671511,
 5196,
 104924791,
 101350027,
 5381,
 104990293,
 104860285,
 5364,
 105055827,
 104962801,
 -1,
 105121352,
 105020644,
 -1,
 -63931,
 105079055,
 5529,
 -63930,
 105136001,
 5528,
 -63929,
 105195799,
 5527,
 -1,
 105253501,
 5530,
 105449037,
 105068872,
 -1,
 -63926,
 105406735,
 5570,
 -63925,
 105463681,
 5569,
 -63924,
 105523479,
 5568,
 -1,
 105581181,
 5571,
 105776720,
 105400493,
 -1,
 -63921,
 105745140,
 5653,
 -1,
 105791361,
 5658,
 -63919,
 105749160,
 5441,
 -63918,
 105940233,
 5282,
 -1,
 105993519,
 5311,
 106233855,
 104991357,
 5365,
 -1,
 106119041,
 5358,
 106301029,
 104937800,
 5413,
 106366558,
 106271967,
 -1,
 106432089,
 106324239,
 5405,
 -1,
 106389775,
 5407,
 106563163,
 106381185,
 5401,
 -1,
 106512257,
 5403,
 106694237,
 106498685,
 5409,
 -1,
 106629757,
 5411,
 -1,
 106637591,
 5399,
 106890848,
 106324239,
 5395,
 -1,
 106848527,
 5396,
 107021922,
 106839937,
 5393,
 -1,
 106971009,
 5394,
 107152996,
 106957437,
 5397,
 -1,
 107088509,
 5398,
 -1,
 107096343,
 5392,
 107349613,
 106271967,
 5383,
 107415144,
 107307279,
 5372,
 -1,
 107372815,
 5374,
 107546218,
 107364225,
 5368,
 -1,
 107495297,
 5370,
 107677292,
 107481725,
 5376,
 -1,
 107612797,
 5378,
 -1,
 107620631,
 5366,
 107873908,
 107307279,
 5361,
 107939443,
 107843883,
 -1,
 -63888,
 107897355,
 5255,
 -63887,
 107954841,
 5254,
 -63886,
 108014663,
 5253,
 -1,
 108072176,
 5256,
 -1,
 107897103,
 5362,
 108332662,
 107822977,
 5359,
 -1,
 108281729,
 5360,
 -1,
 108275991,
 5357,
 108529302,
 104896979,
 5438,
 108594822,
 108464179,
 -1,
 108660348,
 108554773,
 -1,
 -63877,
 108631289,
 5192,
 -1,
 108684371,
 5173,
 -63875,
 108632912,
 5420,
 -63874,
 108827871,
 5149,
 -63873,
 108890060,
 5202,
 -63872,
 108953600,
 5363,
 -63871,
 109012051,
 5127,
 -63870,
 109075971,
 5318,
 -63869,
 109140384,
 5289,
 -63868,
 109204324,
 5337,
 -63867,
 109267652,
 5233,
 -1,
 109322210,
 5263,
 109512334,
 108565727,
 -1,
 109577865,
 109469967,
 5429,
 -1,
 109535503,
 5431,
 109708939,
 109526913,
 5425,
 -1,
 109657985,
 5427,
 109840013,
 109644413,
 5433,
 -1,
 109775485,
 5435,
 -1,
 109783319,
 5423,
 110036625,
 109447805,
 5421,
 110166015,
 109972093,
 5422,
 -1,
 110051201,
 5415,
 110233235,
 109994255,
 5418,
 -1,
 110190863,
 5419,
 110364309,
 110182273,
 5416,
 -1,
 110313345,
 5417,
 -1,
 110307607,
 5414,
 110560942,
 108481357,
 5354,
 110626463,
 110531807,
 -1,
 110691994,
 110584079,
 5346,
 -1,
 110649615,
 5348,
 110823068,
 110641025,
 5342,
 -1,
 110772097,
 5344,
 110954142,
 110758525,
 5350,
 -1,
 110889597,
 5352,
 -1,
 110897431,
 5340,
 111150758,
 110573896,
 5542,
 111216290,
 111108367,
 5538,
 -1,
 111173903,
 5539,
 111347364,
 111165313,
 5536,
 -1,
 111296385,
 5537,
 111542271,
 111282813,
 5540,
 -1,
 111413885,
 5541,
 111609513,
 111086205,
 5338,
 111738879,
 111544957,
 5339,
 -1,
 111624065,
 5332,
 111806123,
 111567119,
 5335,
 -1,
 111763727,
 5336,
 111937197,
 111755137,
 5333,
 -1,
 111886209,
 5334,
 -1,
 111880471,
 5331,
 112133833,
 110506688,
 5469,
 112199361,
 112082817,
 5461,
 112264896,
 112155394,
 -1,
 112330422,
 112207089,
 -1,
 112395957,
 112298818,
 -1,
 -63820,
 112360893,
 5158,
 -1,
 112397331,
 5157,
 -1,
 112367747,
 5162,
 112658105,
 112292707,
 -1,
 -63816,
 112614565,
 5156,
 -1,
 112670326,
 5155,
 -63814,
 112625636,
 5154,
 -63813,
 112819576,
 5160,
 -63812,
 112880926,
 5161,
 -63811,
 112941143,
 5159,
 -63810,
 112998369,
 5152,
 -63809,
 113056239,
 5153,
 -1,
 113118227,
 5151,
 -1,
 112213889,
 5462,
 113379012,
 112134781,
 5465,
 113508351,
 113314429,
 5466,
 -1,
 113393537,
 5460,
 113575622,
 113336591,
 5463,
 -1,
 113533199,
 5464,
 -63801,
 113546489,
 5467,
 -63800,
 113675420,
 5742,
 -1,
 113715479,
 5459,
 113903327,
 112088367,
 5307,
 113968850,
 113874143,
 -1,
 114034381,
 113926415,
 5298,
 -1,
 113991951,
 5300,
 114165455,
 113983361,
 5294,
 -1,
 114114433,
 5296,
 114296529,
 114100861,
 5302,
 -1,
 114231933,
 5304,
 -1,
 114239767,
 5292,
 114493141,
 113926415,
 5287,
 114622463,
 114450703,
 5288,
 -1,
 114523080,
 5385,
 114689753,
 114436375,
 5283,
 114819071,
 114631588,
 -1,
 -63784,
 114716785,
 5458,
 -1,
 114772813,
 5356,
 114951900,
 114625149,
 5290,
 115081215,
 114887293,
 5291,
 -1,
 114966401,
 5284,
 115148510,
 114900865,
 5285,
 -1,
 115097473,
 5286,
 -1,
 115095880,
 5309,
 115345142,
 113841827,
 -1,
 115410677,
 115297263,
 -1,
 115476198,
 115381471,
 -1,
 -63773,
 115433743,
 5558,
 -63772,
 115490689,
 5557,
 -63771,
 115550487,
 5556,
 -1,
 115608189,
 5559,
 115803883,
 115432098,
 -1,
 -63768,
 115761423,
 5562,
 -63767,
 115818369,
 5561,
 -63766,
 115878167,
 5560,
 -1,
 115935869,
 5563,
 116131568,
 115755427,
 -1,
 -63763,
 116089103,
 5566,
 -63762,
 116146049,
 5565,
 -63761,
 116205847,
 5564,
 -1,
 116263549,
 5567,
 -63759,
 116095627,
 5384,
 -63758,
 116416783,
 5554,
 -63757,
 116473729,
 5553,
 -63756,
 116533527,
 5552,
 -1,
 116591229,
 5555,
 -1,
 115359808,
 5439,
 116852487,
 115296675,
 5251,
 116918015,
 116823263,
 5252,
 116983546,
 116875535,
 5242,
 -1,
 116941071,
 5244,
 117114620,
 116932481,
 5238,
 -1,
 117063553,
 5240,
 117245694,
 117049981,
 5246,
 -1,
 117181053,
 5248,
 -1,
 117188887,
 5236,
 117442306,
 116853373,
 5234,
 117571583,
 117377661,
 5235,
 -1,
 117456769,
 5228,
 117638916,
 117399823,
 5231,
 -1,
 117596431,
 5232,
 117769990,
 117587841,
 5229,
 -1,
 117718913,
 5230,
 -1,
 117713175,
 5227,
 117966616,
 116812309,
 5193,
 118032144,
 117937375,
 -1,
 118097675,
 117989647,
 5184,
 -1,
 118055183,
 5186,
 118228749,
 118046593,
 5180,
 -1,
 118177665,
 5182,
 118359823,
 118164093,
 5188,
 -1,
 118295165,
 5190,
 -1,
 118302999,
 5178,
 118556435,
 117967485,
 5176,
 118685695,
 118491773,
 5177,
 -1,
 118570881,
 5168,
 118753045,
 118513935,
 5171,
 -1,
 118710543,
 5172,
 118884119,
 118701953,
 5169,
 -1,
 118833025,
 5170,
 -1,
 118827287,
 5167,
 119080739,
 117928049,
 5456,
 119146268,
 119016061,
 5451,
 119275519,
 119081597,
 5452,
 -1,
 119160705,
 5445,
 119342878,
 119103759,
 5448,
 -1,
 119300367,
 5449,
 119473952,
 119291777,
 5446,
 -1,
 119422849,
 5447,
 -63711,
 119444729,
 5454,
 -63710,
 119548183,
 5442,
 -1,
 119605306,
 5443,
 119801644,
 119041738,
 5509,
 119867176,
 119736957,
 5507,
 119932711,
 119802493,
 5508,
 -1,
 119881601,
 5502,
 -1,
 119881601,
 5743,
 120129322,
 119824655,
 5505,
 -1,
 120086799,
 5506,
 120324095,
 120078209,
 5503,
 -1,
 120209281,
 5504,
 120391477,
 119736957,
 5130,
 120457008,
 120358200,
 -1,
 -63697,
 120421003,
 5382,
 -1,
 120476975,
 5310,
 120653618,
 120405889,
 5148,
 -1,
 120624140,
 5551,
 120784692,
 120588925,
 5131,
 -1,
 120733569,
 5122,
 -1,
 120740514,
 5166,
 120981304,
 120348943,
 5125,
 -63689,
 120938767,
 5126,
 -1,
 121002658,
 5165,
 121177915,
 120930177,
 5123,
 -63686,
 121133730,
 5164,
 -1,
 121192321,
 5124,
 121374525,
 121121047,
 5121,
 -1,
 121330338,
 5163,
 -63682,
 121322803,
 5501,
 -1,
 121452327,
 5150,
 121700351,
 75242631,
 -1,
 -63679,
 121598065,
 9803,
 -1,
 121654127,
 917631,
 121833288,
 75198577,
 -1,
 121898823,
 121776407,
 -1,
 121964358,
 121864844,
 8248,
 -1,
 121897786,
 8257,
 -1,
 121897960,
 8453,
 -1,
 121856844,
 711,
 122226507,
 121774466,
 -1,
 -63670,
 122194865,
 9764,
 -1,
 122227340,
 8454,
 -63668,
 122196280,
 9761,
 -1,
 122383946,
 9809,
 122554541,
 75122342,
 -1,
 122620074,
 122506589,
 -1,
 122685593,
 122560900,
 -1,
 122750857,
 122637133,
 -1,
 122816392,
 122688962,
 -1,
 122881901,
 122781567,
 -1,
 -63660,
 122854350,
 9449,
 -63659,
 122919379,
 9448,
 -63658,
 122984741,
 9447,
 -63657,
 123049183,
 9446,
 -63656,
 123113850,
 9445,
 -63655,
 123177716,
 9444,
 -63654,
 123241100,
 9443,
 -63653,
 123304587,
 9442,
 -63652,
 123367537,
 9441,
 -63651,
 123432650,
 9440,
 -63650,
 123496981,
 9439,
 -63649,
 123560207,
 9438,
 -63648,
 123624098,
 9437,
 -63647,
 123688239,
 9436,
 -63646,
 123751245,
 9435,
 -63645,
 123816355,
 9434,
 -63644,
 123881645,
 9433,
 -63643,
 123944833,
 9432,
 -63642,
 124008776,
 9431,
 -63641,
 124073367,
 9430,
 -63640,
 124138176,
 9429,
 -63639,
 124201239,
 9428,
 -63638,
 124264834,
 9427,
 -63637,
 124328778,
 9426,
 -63636,
 124393123,
 9425,
 -1,
 124455549,
 9424,
 124715007,
 122821684,
 -1,
 -63633,
 124623822,
 9423,
 -63632,
 124688851,
 9422,
 -63631,
 124754213,
 9421,
 -63630,
 124818655,
 9420,
 -63629,
 124883322,
 9419,
 -63628,
 124947188,
 9418,
 -63627,
 125010572,
 9417,
 -63626,
 125074059,
 9416,
 -63625,
 125137009,
 9415,
 -63624,
 125202122,
 9414,
 -63623,
 125266453,
 9413,
 -63622,
 125329679,
 9412,
 -63621,
 125393570,
 9411,
 -63620,
 125457711,
 9410,
 -63619,
 125520717,
 9409,
 -63618,
 125585827,
 9408,
 -63617,
 125651117,
 9407,
 -63616,
 125714305,
 9406,
 -63615,
 125778248,
 9405,
 -63614,
 125842839,
 9404,
 -63613,
 125907648,
 9403,
 -63612,
 125970711,
 9402,
 -63611,
 126034306,
 9401,
 -63610,
 126098250,
 9400,
 -63609,
 126162595,
 9399,
 -1,
 126225021,
 9398,
 -1,
 122761427,
 10688,
 126486480,
 122700021,
 -1,
 126551960,
 126450315,
 -1,
 126617487,
 126520052,
 -1,
 -63603,
 126577764,
 12972,
 -63602,
 126638754,
 12944,
 -1,
 126699435,
 12956,
 126879634,
 126583436,
 -1,
 -63599,
 126847937,
 12971,
 -1,
 126902688,
 12945,
 127076245,
 126822679,
 -1,
 -63596,
 127046238,
 12934,
 -1,
 127082556,
 12953,
 -63594,
 127036235,
 12949,
 -63593,
 127230361,
 12947,
 -1,
 127289489,
 12933,
 127469471,
 126497472,
 -1,
 127535005,
 127418241,
 -1,
 -63589,
 127504890,
 12932,
 -63588,
 127562174,
 12939,
 -1,
 127621909,
 12950,
 -63586,
 127494141,
 12931,
 -1,
 127741308,
 12955,
 127928230,
 127430769,
 -1,
 127993765,
 127871255,
 -1,
 128059300,
 127957643,
 -1,
 -63581,
 128025228,
 12961,
 -1,
 128084019,
 12974,
 -1,
 128012578,
 12970,
 -1,
 127943170,
 12968,
 128386988,
 127882543,
 -1,
 128452522,
 128330007,
 -1,
 -63575,
 128418598,
 12942,
 -1,
 128459745,
 12969,
 -63573,
 128410734,
 12938,
 -1,
 128585227,
 12954,
 128780209,
 128330007,
 -1,
 -63570,
 128751946,
 12957,
 -63569,
 128802691,
 12973,
 -63568,
 128860674,
 12935,
 -1,
 128914535,
 12943,
 129107895,
 128719690,
 -1,
 129173430,
 129065231,
 -1,
 -63564,
 129137006,
 12963,
 -63563,
 129199815,
 12962,
 -1,
 129260787,
 12951,
 -1,
 129117925,
 12965,
 129501115,
 129073804,
 -1,
 -63559,
 129472665,
 12929,
 -63558,
 129515171,
 12930,
 -1,
 129576456,
 12937,
 129763264,
 129456802,
 -1,
 129828799,
 129712001,
 -1,
 -63554,
 129784910,
 12936,
 -1,
 129840749,
 12976,
 -1,
 129765282,
 12948,
 130090948,
 129715021,
 -1,
 -63550,
 130050363,
 12966,
 -63549,
 130100013,
 12967,
 -1,
 130157267,
 12952,
 130353095,
 130061535,
 -1,
 -63546,
 130311263,
 12941,
 -1,
 130356635,
 12940,
 130549706,
 130300232,
 -1,
 -63543,
 130499047,
 12964,
 -1,
 130553392,
 12946,
 130746317,
 130484861,
 -1,
 -63540,
 130714012,
 12959,
 -1,
 130765424,
 12975,
 -63538,
 130707037,
 12958,
 -63537,
 130900922,
 12928,
 -1,
 130959294,
 12960,
 131139593,
 126437892,
 -1,
 131205079,
 131105420,
 -1,
 -63533,
 131173108,
 13025,
 -63532,
 131227919,
 13027,
 -63531,
 131284865,
 13024,
 -63530,
 131344663,
 13026,
 -1,
 131402365,
 13023,
 131598301,
 131168907,
 -1,
 -63527,
 131566324,
 13020,
 -63526,
 131621135,
 13022,
 -63525,
 131678081,
 13019,
 -63524,
 131737879,
 13021,
 -1,
 131795581,
 13018,
 131991523,
 131559537,
 -1,
 -63521,
 131959540,
 13048,
 -63520,
 132014351,
 13050,
 -63519,
 132071297,
 13047,
 -63518,
 132131095,
 13049,
 -1,
 132188797,
 13046,
 132384745,
 131947170,
 -1,
 -63515,
 132352756,
 13030,
 -63514,
 132407567,
 13032,
 -63513,
 132464513,
 13029,
 -63512,
 132524311,
 13031,
 -1,
 132582013,
 13028,
 132777967,
 132338991,
 -1,
 -63509,
 132745972,
 13040,
 -63508,
 132800783,
 13042,
 -63507,
 132857729,
 13039,
 -63506,
 132917527,
 13041,
 -1,
 132975229,
 13038,
 133171189,
 132729251,
 -1,
 -63503,
 133139188,
 13015,
 -63502,
 133193999,
 13017,
 -63501,
 133250945,
 13014,
 -63500,
 133310743,
 13016,
 -1,
 133368445,
 13013,
 133564411,
 133118280,
 -1,
 -63497,
 133532404,
 13035,
 -63496,
 133587215,
 13037,
 -63495,
 133644161,
 13034,
 -63494,
 133703959,
 13036,
 -1,
 133761661,
 13033,
 133957632,
 133534943,
 -1,
 -63491,
 133914895,
 13054,
 -63490,
 133971841,
 13052,
 -63489,
 134031639,
 13053,
 -1,
 134089341,
 13051,
 134285316,
 133929427,
 -1,
 -63486,
 134253300,
 13044,
 -63485,
 134308111,
 13045,
 -1,
 134351485,
 13043,
 -63483,
 134253300,
 13010,
 -63482,
 134504719,
 13012,
 -63481,
 134561665,
 13009,
 -63480,
 134621463,
 13011,
 -1,
 134679165,
 13008,
 134875207,
 131096602,
 -1,
 134940716,
 134840972,
 -1,
 135006235,
 134911472,
 -1,
 135071770,
 134963186,
 9331,
 135200767,
 135004160,
 -1,
 135202833,
 135103116,
 -1,
 -63472,
 135174297,
 12882,
 -1,
 135216803,
 12883,
 135399444,
 135166603,
 -1,
 -63469,
 135350417,
 12886,
 -1,
 135410127,
 12887,
 135596055,
 135344832,
 -1,
 -63466,
 135555069,
 12884,
 -1,
 135612482,
 12885,
 -63464,
 135553978,
 12881,
 -63463,
 135748940,
 12889,
 -1,
 135802010,
 12888,
 -1,
 135025899,
 9323,
 136054827,
 134954225,
 -1,
 136120362,
 136026579,
 12890,
 136249343,
 136052736,
 -1,
 136251425,
 136151692,
 -1,
 -63456,
 136222873,
 12892,
 -1,
 136265379,
 12893,
 136448036,
 136215179,
 -1,
 -63453,
 136398993,
 12977,
 -1,
 136458703,
 12978,
 136644647,
 136393408,
 -1,
 -63450,
 136603645,
 12894,
 -1,
 136661058,
 12895,
 -63448,
 136602554,
 12891,
 -63447,
 136797516,
 12980,
 -1,
 136850586,
 12979,
 -1,
 136063736,
 9324,
 -1,
 135998984,
 9321,
 137168960,
 134886080,
 -1,
 137234493,
 137126159,
 -1,
 137300028,
 137198125,
 12981,
 137428991,
 137232384,
 -1,
 137431091,
 137331340,
 -1,
 -63438,
 137402521,
 12983,
 -1,
 137445027,
 12984,
 137627702,
 137394827,
 -1,
 -63435,
 137578641,
 12987,
 -1,
 137638351,
 12988,
 137824313,
 137573056,
 -1,
 -63432,
 137783293,
 12985,
 -1,
 137840706,
 12986,
 -63430,
 137782202,
 12982,
 -63429,
 137977164,
 12990,
 -1,
 138030234,
 12989,
 -1,
 137269365,
 9325,
 138346495,
 137183620,
 -1,
 -63425,
 138254803,
 12991,
 -1,
 138291960,
 9326,
 138479683,
 137132683,
 -1,
 -63422,
 138430612,
 9327,
 -1,
 138490324,
 9328,
 138676294,
 138422551,
 -1,
 -63419,
 138629244,
 9322,
 -1,
 138691095,
 9329,
 -1,
 138632529,
 9330,
 138938475,
 134822216,
 -1,
 139004009,
 138875194,
 -1,
 139069518,
 138969740,
 -1,
 139135052,
 139018931,
 12898,
 -1,
 139067394,
 12912,
 139329535,
 139082881,
 12907,
 -1,
 139198466,
 12921,
 139397203,
 139029013,
 -1,
 139462737,
 139346285,
 12901,
 -1,
 139395074,
 12915,
 139657215,
 139410554,
 12908,
 -1,
 139526146,
 12922,
 139724888,
 139348387,
 -1,
 139790422,
 139675815,
 12896,
 -1,
 139722754,
 12910,
 139984895,
 139738227,
 12906,
 -1,
 139853826,
 12920,
 140052573,
 139664202,
 -1,
 140118107,
 140001634,
 12904,
 -1,
 140050434,
 12918,
 140312575,
 140065894,
 12905,
 -1,
 140181506,
 12919,
 140380255,
 140017372,
 12902,
 -1,
 140312578,
 12916,
 140511329,
 140342221,
 12899,
 -1,
 140443650,
 12913,
 140642403,
 140467498,
 12897,
 -1,
 140574722,
 12911,
 140773477,
 140597400,
 12900,
 -1,
 140705794,
 12914,
 140904551,
 140722535,
 12903,
 -1,
 140836866,
 12917,
 141099007,
 140852333,
 12909,
 -1,
 140967938,
 12923,
 -63382,
 138962420,
 9097,
 -1,
 141109727,
 10162,
 141297792,
 138879362,
 -1,
 141363326,
 141246337,
 -1,
 141428859,
 141309696,
 -1,
 141494385,
 141394572,
 -1,
 -63376,
 141465753,
 9313,
 -1,
 141508259,
 9314,
 141690996,
 141458059,
 -1,
 -63373,
 141641873,
 9317,
 -1,
 141701583,
 9318,
 141887607,
 141636288,
 -1,
 -63370,
 141846525,
 9315,
 -1,
 141903938,
 9316,
 -63368,
 141859870,
 9450,
 -63367,
 142042042,
 9312,
 -63366,
 142105932,
 9320,
 -1,
 142159002,
 9319,
 142409727,
 141399128,
 -1,
 -63363,
 142298320,
 8856,
 -1,
 142361220,
 10808,
 -63361,
 141321988,
 8857,
 -1,
 142480589,
 8861,
 142674053,
 141257237,
 -1,
 -63358,
 142632672,
 12342,
 -63357,
 142693570,
 8853,
 -63356,
 142749731,
 10681,
 -1,
 142807824,
 10679,
 143001736,
 142644763,
 -1,
 -63353,
 142967049,
 10026,
 -1,
 143006413,
 10686,
 143198347,
 142967436,
 -1,
 -63350,
 143160208,
 9098,
 -1,
 143213433,
 8855,
 143394958,
 143159409,
 -1,
 -63347,
 143344776,
 8858,
 -1,
 143405559,
 10680,
 143591569,
 143349039,
 -1,
 -63344,
 143559867,
 10806,
 -1,
 143607236,
 8854,
 143788180,
 143526525,
 -1,
 -63341,
 143753510,
 8859,
 -1,
 143810460,
 10684,
 -63339,
 143758066,
 10678,
 -63338,
 143942820,
 10050,
 -63337,
 143996916,
 10689,
 -63336,
 144060330,
 8860,
 -1,
 144120525,
 10687,
 144375807,
 122617856,
 -1,
 144378025,
 144283345,
 -1,
 144443550,
 144346859,
 -1,
 -63331,
 144405785,
 9684,
 -1,
 144456254,
 9683,
 144640161,
 144407179,
 -1,
 -63328,
 144608938,
 10683,
 -1,
 144660000,
 10690,
 144836772,
 144591693,
 -1,
 -63325,
 144796016,
 9682,
 -1,
 144845651,
 9680,
 -63323,
 144806752,
 9677,
 -63322,
 145001104,
 10691,
 -63321,
 145060996,
 9681,
 -63320,
 145112486,
 10677,
 -1,
 145166021,
 9685,
 -1,
 144319648,
 10682,
 145489919,
 122587892,
 -1,
 -63316,
 145381375,
 94,
 -1,
 145444126,
 10768,
 145623544,
 122526163,
 -1,
 145689079,
 145585850,
 -1,
 145754450,
 145653623,
 -1,
 145819982,
 145699245,
 -1,
 145885383,
 145770915,
 -1,
 145950910,
 145842447,
 -1,
 146016445,
 145905689,
 -1,
 146081976,
 145957250,
 -1,
 -63306,
 146054248,
 1287,
 -63305,
 146098393,
 1283,
 -1,
 146155799,
 1281,
 -63303,
 146054248,
 1285,
 -63302,
 146310975,
 1295,
 -63301,
 146374407,
 1293,
 -63300,
 146431438,
 1291,
 -1,
 146493978,
 1289,
 -1,
 145976780,
 1153,
 146737348,
 145885821,
 1082,
 146866175,
 146671103,
 -1,
 -63295,
 146772931,
 1181,
 -63294,
 146833769,
 1183,
 -63293,
 146881914,
 1220,
 -1,
 146940678,
 1179,
 -63291,
 146701785,
 1135,
 -63290,
 147081433,
 1116,
 -1,
 147143179,
 1228,
 147327191,
 145828119,
 1101,
 147392717,
 147282594,
 1085,
 147521535,
 147326463,
 -1,
 -63285,
 147424013,
 1226,
 -63284,
 147471738,
 1224,
 -1,
 147530502,
 1187,
 147720399,
 147356299,
 1089,
 -1,
 147654304,
 1195,
 147851473,
 147681393,
 1088,
 -1,
 147785658,
 1167,
 147982547,
 147805487,
 1084,
 -1,
 147916705,
 1230,
 148113621,
 147934029,
 1083,
 -1,
 148047777,
 1222,
 -63274,
 148058816,
 1092,
 -1,
 148178608,
 1261,
 148375783,
 147275649,
 1080,
 148441309,
 148332815,
 1105,
 148570111,
 148407918,
 -1,
 -63269,
 148460042,
 1129,
 -63268,
 148515095,
 1125,
 -1,
 148576459,
 1133,
 148768993,
 148384023,
 1077,
 148897791,
 148702719,
 -1,
 -63264,
 148781025,
 1104,
 -1,
 148839027,
 1239,
 149031141,
 148702719,
 -1,
 -63261,
 148985147,
 1251,
 -63260,
 149043169,
 1117,
 -1,
 149103443,
 1253,
 149356543,
 149003311,
 1141,
 -1,
 149227254,
 1143,
 149424374,
 148339339,
 -1,
 149489904,
 149371208,
 -1,
 149555437,
 149448284,
 -1,
 149620972,
 149503873,
 1081,
 -1,
 149555105,
 1163,
 -1,
 149588724,
 1118,
 -63250,
 149502306,
 1211,
 -63249,
 149757175,
 1097,
 -1,
 149817981,
 1096,
 150014194,
 149456982,
 1199,
 -1,
 149948308,
 1201,
 150145268,
 149953941,
 1241,
 -1,
 150079152,
 1243,
 -63243,
 150102492,
 1100,
 -1,
 150220252,
 1165,
 150407425,
 149396430,
 -1,
 150472957,
 150354739,
 1078,
 150601727,
 150406655,
 -1,
 150604028,
 150479234,
 -1,
 -63237,
 150552544,
 1245,
 -1,
 150614125,
 1175,
 -1,
 150542963,
 1218,
 150929407,
 150415639,
 1079,
 150994943,
 150799999,
 -1,
 -63232,
 150880224,
 1247,
 -1,
 150941805,
 1177,
 151128330,
 150342269,
 1072,
 151193863,
 151066909,
 -1,
 151259397,
 151133478,
 1213,
 -1,
 151193248,
 1215,
 -63226,
 151206242,
 1193,
 -1,
 151333139,
 1249,
 151584767,
 151127551,
 -1,
 -63223,
 151462739,
 1235,
 -1,
 151526003,
 1233,
 151718161,
 151099859,
 -1,
 151783693,
 151662675,
 1099,
 -1,
 151717552,
 1273,
 151914767,
 151718525,
 1103,
 -1,
 151880332,
 1123,
 -63216,
 151882484,
 1102,
 -1,
 151994241,
 1111,
 152176921,
 151685876,
 1091,
 152242455,
 152110591,
 -1,
 152307990,
 152183170,
 -1,
 -63211,
 152266638,
 1267,
 -1,
 152322016,
 1265,
 -1,
 152261947,
 1263,
 152633343,
 152193443,
 1145,
 -1,
 152531193,
 1108,
 152701217,
 152114851,
 -1,
 152766750,
 152636029,
 -1,
 152832285,
 152729980,
 1257,
 -1,
 152766128,
 1259,
 -1,
 152796500,
 1185,
 -63201,
 152738413,
 1110,
 -63200,
 152977832,
 1131,
 -1,
 153037079,
 1073,
 153225510,
 152658191,
 1086,
 153291044,
 153180035,
 1121,
 -1,
 153225175,
 1149,
 -63195,
 153256588,
 1151,
 -1,
 153355952,
 1255,
 153553197,
 153171351,
 -1,
 153618732,
 153500467,
 1075,
 153747455,
 153552383,
 -1,
 -63190,
 153653147,
 1169,
 -63189,
 153715049,
 1171,
 -1,
 153770082,
 1173,
 -1,
 153569497,
 1107,
 154011955,
 153518732,
 -1,
 154077489,
 153975435,
 -1,
 -63184,
 154024755,
 1115,
 -1,
 154085655,
 1094,
 154337279,
 154020119,
 1090,
 -1,
 154207904,
 1197,
 154405177,
 153952642,
 -1,
 154470711,
 154377166,
 -1,
 -63178,
 154417971,
 1119,
 -1,
 154478871,
 1109,
 -63176,
 154421465,
 1106,
 -1,
 154609943,
 1076,
 154798399,
 154344742,
 1095,
 154927103,
 154732031,
 -1,
 154929470,
 154804610,
 -1,
 -63171,
 154877920,
 1269,
 -1,
 154939501,
 1207,
 -1,
 154899395,
 1209,
 155191619,
 154757653,
 -1,
 155257154,
 155134231,
 1087,
 -1,
 155191115,
 1191,
 -1,
 155221465,
 1137,
 155453766,
 155138402,
 1093,
 -63163,
 155414949,
 1098,
 -1,
 155453088,
 1203,
 155650377,
 155405133,
 -1,
 -63160,
 155601113,
 1113,
 -1,
 155666463,
 1127,
 -63158,
 155619834,
 1074,
 -63157,
 155810020,
 1147,
 -63156,
 155868622,
 1114,
 -63155,
 155928793,
 1112,
 -1,
 155989053,
 1139,
 156237823,
 145768886,
 -1,
 -63152,
 156140451,
 1205,
 -63151,
 156184095,
 1189,
 -1,
 156240519,
 1237,
 156436981,
 145693738,
 -1,
 156502513,
 156381613,
 -1,
 156567914,
 156453283,
 -1,
 156633441,
 156524815,
 -1,
 156698976,
 156588057,
 -1,
 156764507,
 156639618,
 -1,
 -63143,
 156736616,
 1286,
 -63142,
 156780761,
 1282,
 -1,
 156838167,
 1280,
 -63140,
 156736616,
 1284,
 -63139,
 156993343,
 1294,
 -63138,
 157056775,
 1292,
 -63137,
 157113806,
 1290,
 -1,
 157176346,
 1288,
 -1,
 156659148,
 1152,
 157419879,
 156568189,
 1050,
 157548543,
 157353471,
 -1,
 -63132,
 157455299,
 1180,
 -63131,
 157516137,
 1182,
 -63130,
 157564282,
 1219,
 -1,
 157623046,
 1178,
 -63128,
 157384153,
 1134,
 -63127,
 157763801,
 1036,
 -1,
 157825547,
 1227,
 158009722,
 156510487,
 1069,
 158075248,
 157964962,
 1053,
 158203903,
 158008831,
 -1,
 -63122,
 158106381,
 1225,
 -63121,
 158154106,
 1223,
 -1,
 158212870,
 1186,
 158402930,
 158038667,
 1057,
 -1,
 158336672,
 1194,
 158534004,
 158363761,
 1056,
 -1,
 158468026,
 1166,
 158665078,
 158487855,
 1052,
 -1,
 158599073,
 1229,
 158796152,
 158616397,
 1051,
 -1,
 158730145,
 1221,
 -63111,
 158741184,
 1060,
 -1,
 158860976,
 1260,
 159058314,
 157958017,
 1048,
 159123840,
 159015183,
 1025,
 159252479,
 159090286,
 -1,
 -63106,
 159142410,
 1128,
 -63105,
 159197463,
 1124,
 -1,
 159258827,
 1132,
 159451524,
 159066391,
 1045,
 159580159,
 159385087,
 -1,
 -63101,
 159463393,
 1024,
 -1,
 159521395,
 1238,
 159713672,
 159385087,
 -1,
 -63098,
 159667515,
 1250,
 -63097,
 159725537,
 1037,
 -1,
 159785811,
 1252,
 160038911,
 159685679,
 1140,
 -1,
 159909622,
 1142,
 160106905,
 159021707,
 -1,
 160172435,
 160053576,
 -1,
 160237968,
 160130652,
 -1,
 160303503,
 160186241,
 1049,
 -1,
 160237473,
 1162,
 -1,
 160271092,
 1038,
 -63087,
 160184674,
 1210,
 -63086,
 160439543,
 1065,
 -1,
 160500349,
 1064,
 160696725,
 160139350,
 1198,
 -1,
 160630676,
 1200,
 160827799,
 160636309,
 1240,
 -1,
 160761520,
 1242,
 -63080,
 160784860,
 1068,
 -1,
 160902620,
 1164,
 161089956,
 160078798,
 -1,
 161155488,
 161037107,
 1046,
 161284095,
 161089023,
 -1,
 161286559,
 161161602,
 -1,
 -63074,
 161234912,
 1244,
 -1,
 161296493,
 1174,
 -1,
 161225331,
 1217,
 161611775,
 161098007,
 1047,
 161677311,
 161482367,
 -1,
 -63069,
 161562592,
 1246,
 -1,
 161624173,
 1176,
 161810861,
 161024637,
 1040,
 161876394,
 161749277,
 -1,
 161941928,
 161815846,
 1212,
 -1,
 161875616,
 1214,
 -63063,
 161888610,
 1192,
 -1,
 162015507,
 1248,
 162267135,
 161809919,
 -1,
 -63060,
 162145107,
 1234,
 -1,
 162208371,
 1232,
 162400692,
 161782227,
 -1,
 162466224,
 162345043,
 1067,
 -1,
 162399920,
 1272,
 162597298,
 162400893,
 1071,
 -1,
 162562700,
 1122,
 -63053,
 162564852,
 1070,
 -1,
 162676609,
 1031,
 162859452,
 162368244,
 1059,
 162924986,
 162792959,
 -1,
 162990521,
 162865538,
 -1,
 -63048,
 162949006,
 1266,
 -1,
 163004384,
 1264,
 -1,
 162944315,
 1262,
 163315711,
 162875811,
 1144,
 -1,
 163213561,
 1028,
 163383748,
 162797219,
 -1,
 163449281,
 163318397,
 -1,
 163514816,
 163412348,
 1256,
 -1,
 163448496,
 1258,
 -1,
 163478868,
 1184,
 -63038,
 163420781,
 1030,
 -63037,
 163660200,
 1130,
 -1,
 163719447,
 1041,
 163908041,
 163340559,
 1054,
 163973575,
 163862403,
 1120,
 -1,
 163907543,
 1148,
 -63032,
 163938956,
 1150,
 -1,
 164038320,
 1254,
 164235728,
 163853719,
 -1,
 164301263,
 164182835,
 1043,
 164429823,
 164234751,
 -1,
 -63027,
 164335515,
 1168,
 -63026,
 164397417,
 1170,
 -1,
 164452450,
 1172,
 -1,
 164251865,
 1027,
 164694486,
 164201100,
 -1,
 164760020,
 164657803,
 -1,
 -63021,
 164707123,
 1035,
 -1,
 164768023,
 1062,
 165019647,
 164702487,
 1058,
 -1,
 164890272,
 1196,
 165087708,
 164635010,
 -1,
 165153242,
 165059534,
 -1,
 -63015,
 165100339,
 1039,
 -1,
 165161239,
 1029,
 -63013,
 165103833,
 1026,
 -1,
 165292311,
 1044,
 165480930,
 165027110,
 1063,
 165609471,
 165414399,
 -1,
 165612001,
 165486978,
 -1,
 -63008,
 165560288,
 1268,
 -1,
 165621869,
 1206,
 -1,
 165581763,
 1208,
 165874150,
 165440021,
 -1,
 165939685,
 165816599,
 1055,
 -1,
 165873483,
 1190,
 -1,
 165903833,
 1136,
 166136297,
 165820770,
 1061,
 -63000,
 166097317,
 1066,
 -1,
 166135456,
 1202,
 166332908,
 166087501,
 -1,
 -62997,
 166283481,
 1033,
 -1,
 166348831,
 1126,
 -62995,
 166302202,
 1042,
 -62994,
 166492388,
 1146,
 -62993,
 166550990,
 1034,
 -62992,
 166611161,
 1032,
 -1,
 166671421,
 1138,
 166920191,
 156451254,
 -1,
 -62989,
 166822819,
 1204,
 -62988,
 166866463,
 1188,
 -1,
 166922887,
 1236,
 -62986,
 156403130,
 1154,
 -1,
 167071836,
 1216,
 -1,
 145641776,
 9005,
 167316212,
 145580303,
 -1,
 167381703,
 167269679,
 -1,
 167447230,
 167319801,
 -1,
 167512611,
 167398221,
 -1,
 167578122,
 167450056,
 -1,
 -62978,
 167549221,
 879,
 -62977,
 167612794,
 878,
 -62976,
 167676660,
 871,
 -62975,
 167740044,
 877,
 -62974,
 167800945,
 876,
 -62973,
 167862543,
 870,
 -62972,
 167925039,
 875,
 -62971,
 167985025,
 869,
 -62970,
 168048968,
 874,
 -62969,
 168110359,
 868,
 -62968,
 168173954,
 873,
 -62967,
 168237898,
 872,
 -1,
 168299133,
 867,
 168495641,
 167521069,
 -1,
 168561176,
 168427520,
 -1,
 168626705,
 168495741,
 -1,
 168692240,
 168582349,
 -1,
 -62961,
 168630257,
 841,
 -1,
 168692440,
 794,
 -1,
 168655279,
 8406,
 168954388,
 168588316,
 -1,
 -62957,
 168892401,
 845,
 -1,
 168954584,
 8417,
 169150999,
 168900962,
 -1,
 -62954,
 169113932,
 8400,
 -1,
 169169049,
 796,
 -1,
 169116411,
 792,
 -1,
 168531260,
 8426,
 169478688,
 168452367,
 -1,
 169544223,
 169434280,
 -1,
 169609758,
 169507467,
 -1,
 -62947,
 169576785,
 822,
 -1,
 169632441,
 824,
 -1,
 169579418,
 8402,
 -1,
 169514209,
 818,
 170000383,
 169427382,
 -1,
 -62942,
 169899129,
 65057,
 -1,
 169954770,
 65056,
 170134075,
 167453058,
 -1,
 170199609,
 170090767,
 -1,
 170265141,
 170167106,
 -1,
 170330667,
 170234600,
 -1,
 170396202,
 170283328,
 -1,
 -62935,
 170334193,
 840,
 -1,
 170396376,
 782,
 -1,
 170361216,
 8422,
 170658351,
 170296975,
 864,
 170786815,
 170590208,
 -1,
 -62930,
 170685561,
 65059,
 -1,
 170741202,
 65058,
 -62928,
 170620436,
 866,
 -62927,
 170879273,
 831,
 -62926,
 170939379,
 819,
 -62925,
 171001336,
 865,
 -62924,
 171063271,
 783,
 -1,
 171117593,
 779,
 171313720,
 170230414,
 -1,
 -62921,
 171251697,
 803,
 -1,
 171313880,
 775,
 -1,
 171284619,
 798,
 171638783,
 170147808,
 776,
 -1,
 171508125,
 804,
 171706962,
 170072906,
 -1,
 171772484,
 171678600,
 -1,
 171838016,
 171731477,
 -1,
 -62913,
 171802193,
 1158,
 -1,
 171838941,
 1156,
 -62911,
 171804461,
 1155,
 -62910,
 171989173,
 1161,
 -62909,
 172048162,
 1160,
 -1,
 172106333,
 1157,
 172296776,
 171729693,
 -1,
 172362311,
 172231384,
 787,
 -1,
 172295459,
 789,
 -1,
 172300273,
 806,
 172558924,
 172231293,
 -1,
 172624459,
 172521543,
 780,
 -1,
 172556701,
 812,
 -1,
 172579908,
 784,
 172821071,
 172511970,
 -1,
 -62898,
 172783325,
 8409,
 -1,
 172823580,
 8405,
 173017681,
 172771034,
 770,
 -1,
 172949917,
 813,
 -1,
 172960459,
 807,
 173214307,
 171667569,
 -1,
 173279838,
 173162369,
 -1,
 173345370,
 173225585,
 -1,
 173410904,
 173291874,
 -1,
 -62889,
 173373772,
 8401,
 -1,
 173428889,
 825,
 -62887,
 173376251,
 793,
 -1,
 173544476,
 8407,
 173801471,
 173300904,
 -1,
 -62884,
 173697313,
 8408,
 -62883,
 173742065,
 805,
 -1,
 173804248,
 778,
 174063615,
 173222167,
 -1,
 174066274,
 173970109,
 -1,
 -62879,
 174006663,
 788,
 -1,
 174065007,
 8421,
 -1,
 174033193,
 802,
 174328431,
 173160340,
 -1,
 174393961,
 174271189,
 -1,
 -62874,
 174365528,
 837,
 -62873,
 174418963,
 834,
 -62872,
 174475982,
 835,
 -1,
 174531498,
 836,
 174784511,
 174328445,
 -1,
 174787182,
 174690813,
 -1,
 174852717,
 174721961,
 768,
 -1,
 174784925,
 790,
 -1,
 174819260,
 832,
 -1,
 174746763,
 847,
 175114874,
 174270743,
 -1,
 175180409,
 175070120,
 -1,
 175245940,
 175143563,
 -1,
 -62861,
 175206281,
 8414,
 -1,
 175251500,
 8418,
 175442550,
 175185343,
 8413,
 -1,
 175374738,
 8416,
 -62857,
 175411106,
 8420,
 -62856,
 175524433,
 8419,
 -1,
 175580090,
 8415,
 -1,
 175140728,
 839,
 175835781,
 175049341,
 -1,
 175901312,
 175790754,
 -1,
 175966847,
 175867485,
 -1,
 -62850,
 175929053,
 8410,
 -1,
 175969308,
 8404,
 -1,
 175923207,
 8423,
 176228996,
 175841631,
 -1,
 176294531,
 176163753,
 769,
 -1,
 176226717,
 791,
 -1,
 176261052,
 833,
 -1,
 176181934,
 844,
 176556685,
 175800972,
 -1,
 176622218,
 176505586,
 771,
 176750591,
 176553984,
 -1,
 -62839,
 176646433,
 820,
 -1,
 176691185,
 816,
 -62837,
 176590919,
 786,
 -62836,
 176846627,
 8424,
 -1,
 176897733,
 8411,
 177080981,
 176519819,
 -1,
 177146515,
 177028707,
 -1,
 177212050,
 177109643,
 -1,
 -62831,
 177178961,
 821,
 -1,
 177234617,
 823,
 -1,
 177181594,
 8403,
 -62828,
 177106838,
 827,
 -1,
 177416531,
 828,
 177605275,
 177030638,
 -1,
 177670810,
 177543745,
 -1,
 177736345,
 177615307,
 785,
 -1,
 177668509,
 815,
 -1,
 177684800,
 826,
 -1,
 177612304,
 811,
 177998497,
 177543745,
 -1,
 178064031,
 177946938,
 -1,
 -62818,
 178001905,
 810,
 -1,
 178064088,
 838,
 178323455,
 178008523,
 774,
 -1,
 178192797,
 814,
 178391718,
 177967848,
 -1,
 178457253,
 178344256,
 -1,
 -62812,
 178395121,
 809,
 -1,
 178457304,
 781,
 -1,
 178423439,
 830,
 178719402,
 178345263,
 -1,
 178784937,
 178654213,
 772,
 -1,
 178717085,
 817,
 -1,
 178734537,
 800,
 178981550,
 178666823,
 -1,
 -62804,
 178943980,
 795,
 -62803,
 179004025,
 777,
 -1,
 179067321,
 843,
 179243697,
 178949586,
 -1,
 -62800,
 179213610,
 846,
 -1,
 179242403,
 797,
 179440308,
 179202581,
 -1,
 -62797,
 179393756,
 799,
 -1,
 179441131,
 801,
 179636919,
 179396879,
 -1,
 -62794,
 179606173,
 773,
 -1,
 179648375,
 808,
 179833530,
 179587598,
 -1,
 -62791,
 179803284,
 12441,
 -1,
 179862524,
 12442,
 -62789,
 179804455,
 829,
 -62788,
 180000416,
 8425,
 -62787,
 180051680,
 842,
 -1,
 180106504,
 8412,
 180292291,
 167400751,
 -1,
 180357826,
 180236248,
 -1,
 -62783,
 180312301,
 8274,
 -1,
 180360570,
 64,
 -1,
 180292221,
 44,
 180619974,
 180251157,
 -1,
 -62779,
 180577972,
 9092,
 -1,
 180637590,
 8705,
 -1,
 180564236,
 9732,
 180882140,
 167340565,
 -1,
 180947675,
 180848200,
 -1,
 181013202,
 180911999,
 -1,
 181078733,
 180976868,
 -1,
 -62772,
 181027641,
 1005,
 -1,
 181087383,
 995,
 -62770,
 181029509,
 999,
 -62769,
 181222806,
 1001,
 -62768,
 181286338,
 1003,
 -62767,
 181351307,
 997,
 -1,
 181412494,
 1007,
 181665791,
 180952116,
 -1,
 181668566,
 181566692,
 -1,
 -62763,
 181617465,
 1004,
 -1,
 181677207,
 994,
 -62761,
 181619333,
 998,
 -62760,
 181812630,
 1000,
 -62759,
 181876162,
 1002,
 -62758,
 181941131,
 996,
 -1,
 182002318,
 1006,
 -1,
 180919164,
 169,
 182258412,
 180837026,
 -1,
 182323945,
 182223500,
 -1,
 182389479,
 182259010,
 -1,
 182455011,
 182359761,
 -1,
 -62751,
 182424333,
 8955,
 -62750,
 182479096,
 8957,
 -1,
 182539051,
 8954,
 182779903,
 182391973,
 -1,
 182782694,
 182672975,
 8883,
 -1,
 182715468,
 8885,
 -1,
 182736786,
 8715,
 -62744,
 182347797,
 8750,
 -1,
 182928812,
 9089,
 -62742,
 182274458,
 9740,
 -62741,
 183058508,
 9010,
 -1,
 183122157,
 10861,
 183306992,
 182211340,
 58,
 183435263,
 183238656,
 -1,
 -62737,
 183336487,
 8353,
 -1,
 183381930,
 8788,
 183569139,
 183274945,
 -1,
 -62734,
 183533265,
 9013,
 -1,
 183572941,
 9012,
 -1,
 183531907,
 8792,
 183831387,
 167262536,
 -1,
 183896921,
 183773463,
 -1,
 183962456,
 183859257,
 -1,
 184027913,
 183927436,
 -1,
 184093439,
 183990923,
 -1,
 -62726,
 184062330,
 5096,
 -62725,
 184126196,
 5095,
 -62724,
 184181007,
 5094,
 -62723,
 184237953,
 5093,
 -62722,
 184297751,
 5092,
 -1,
 184355453,
 5091,
 184552198,
 184044365,
 -1,
 -62719,
 184521082,
 5090,
 -62718,
 184584948,
 5089,
 -62717,
 184639759,
 5088,
 -62716,
 184696705,
 5087,
 -62715,
 184756503,
 5086,
 -1,
 184814205,
 5085,
 -62713,
 184500097,
 5080,
 -62712,
 184953111,
 5078,
 -1,
 185010813,
 5076,
 185207568,
 183990923,
 5069,
 -62709,
 185176442,
 5074,
 -62708,
 185240308,
 5073,
 -62707,
 185295119,
 5072,
 -62706,
 185352065,
 5071,
 -62705,
 185411863,
 5070,
 -1,
 185469565,
 5068,
 185666328,
 185162402,
 -1,
 185731859,
 185600637,
 5054,
 -1,
 185678152,
 5056,
 -62700,
 185700730,
 5061,
 -62699,
 185830132,
 5060,
 -62698,
 185884943,
 5059,
 -62697,
 185941889,
 5058,
 -1,
 186001687,
 5057,
 186190624,
 185612616,
 -1,
 -62694,
 186159482,
 5042,
 -62693,
 186223348,
 5041,
 -62692,
 186278159,
 5040,
 -62691,
 186342114,
 5055,
 -62690,
 186400641,
 5039,
 -62689,
 186460439,
 5038,
 -1,
 186518141,
 5037,
 186714920,
 186130818,
 -1,
 -62686,
 186683770,
 5083,
 -62685,
 186747636,
 5082,
 -62684,
 186802447,
 5081,
 -62683,
 186862476,
 5084,
 -62682,
 186924929,
 5079,
 -62681,
 186984727,
 5077,
 -1,
 187042429,
 5075,
 187239215,
 186685907,
 -1,
 -62678,
 187208058,
 5108,
 -62677,
 187271924,
 5107,
 -62676,
 187326735,
 5106,
 -62675,
 187383681,
 5105,
 -62674,
 187443479,
 5104,
 -1,
 187501181,
 5103,
 187697974,
 187208927,
 -1,
 -62671,
 187666810,
 5102,
 -62670,
 187730676,
 5101,
 -62669,
 187785487,
 5100,
 -62668,
 187842433,
 5099,
 -62667,
 187902231,
 5098,
 -1,
 187959933,
 5097,
 188156733,
 187658027,
 -1,
 -62664,
 188125562,
 5067,
 -62663,
 188189428,
 5066,
 -62662,
 188244239,
 5065,
 -62661,
 188301185,
 5064,
 -62660,
 188360983,
 5063,
 -1,
 188418685,
 5062,
 188615492,
 188107597,
 -1,
 -62657,
 188584314,
 5048,
 -62656,
 188648180,
 5047,
 -62655,
 188702991,
 5046,
 -62654,
 188759937,
 5045,
 -62653,
 188819735,
 5044,
 -1,
 188877437,
 5043,
 189074251,
 188560791,
 -1,
 -62650,
 189043066,
 5036,
 -62649,
 189106932,
 5035,
 -62648,
 189161743,
 5034,
 -62647,
 189218689,
 5033,
 -62646,
 189278487,
 5032,
 -1,
 189336189,
 5030,
 189533009,
 189027631,
 -1,
 -62643,
 189500148,
 5053,
 -62642,
 189554959,
 5052,
 -62641,
 189611905,
 5051,
 -62640,
 189671703,
 5050,
 -1,
 189729405,
 5049,
 -62638,
 189501818,
 5029,
 -62637,
 189893364,
 5028,
 -62636,
 189948175,
 5027,
 -62635,
 190007717,
 5031,
 -62634,
 190070657,
 5026,
 -62633,
 190130455,
 5025,
 -1,
 190188157,
 5024,
 -1,
 183901783,
 10003,
 -62630,
 183844774,
 9767,
 -1,
 190386911,
 8256,
 190581618,
 183782221,
 -1,
 190647153,
 190537999,
 -1,
 190712680,
 190610369,
 -1,
 190778215,
 190652804,
 -1,
 190843748,
 190742946,
 -1,
 190909282,
 190802988,
 10960,
 -1,
 190841932,
 10962,
 191102975,
 190847659,
 10959,
 -1,
 190973004,
 10961,
 191171430,
 190811534,
 10828,
 -1,
 191103276,
 10832,
 -1,
 191120772,
 10829,
 -1,
 190711279,
 8272,
 191433584,
 190652048,
 -1,
 191499116,
 191372106,
 -1,
 -62613,
 191456323,
 8754,
 -1,
 191517594,
 10561,
 -62611,
 191465458,
 8631,
 -62610,
 191653059,
 8635,
 -62609,
 191710487,
 8753,
 -1,
 191772105,
 10227,
 -1,
 191400887,
 9729,
 -1,
 190589291,
 9114,
 192088956,
 190548724,
 -1,
 192154491,
 192049265,
 -1,
 192220025,
 192107786,
 -1,
 192285560,
 192172780,
 -1,
 -62601,
 192242975,
 8910,
 -1,
 192286750,
 8911,
 -1,
 192223824,
 9130,
 -62598,
 192188960,
 10081,
 -1,
 192508564,
 164,
 -1,
 192092085,
 8731,
 192744325,
 192030999,
 -1,
 192809860,
 192700221,
 -1,
 192875395,
 192770494,
 -1,
 192940930,
 192827712,
 -1,
 -62591,
 192899369,
 65098,
 -1,
 192959475,
 65102,
 -1,
 192873356,
 8452,
 -1,
 192808246,
 162,
 -1,
 192750677,
 184,
 193396735,
 192704625,
 -1,
 193399689,
 193291977,
 -1,
 -62584,
 193352586,
 9768,
 -1,
 193415494,
 9769,
 -1,
 193368430,
 8354,
 193663826,
 21807,
 -1,
 193728560,
 193596029,
 -1,
 193793984,
 193693001,
 -1,
 193858859,
 193755787,
 -1,
 193924352,
 193794429,
 -1,
 193989765,
 193862087,
 -1,
 194055172,
 193939378,
 -1,
 194120646,
 194019140,
 -1,
 194186134,
 194079253,
 120421,
 -62572,
 194149849,
 120769,
 -62571,
 194199425,
 120761,
 -1,
 194264133,
 120767,
 194448281,
 194151052,
 120425,
 -62568,
 194395184,
 120753,
 -1,
 194450943,
 120765,
 194644893,
 194404623,
 120420,
 194772991,
 194598191,
 -1,
 -62564,
 194658407,
 120760,
 -1,
 194718755,
 120770,
 194907040,
 194586903,
 120410,
 -62561,
 194872020,
 120752,
 -1,
 194932375,
 120750,
 195103650,
 194878414,
 120431,
 -1,
 195047699,
 120751,
 195234724,
 195074341,
 120429,
 -1,
 195182465,
 120759,
 195365798,
 195201780,
 120426,
 -1,
 195325591,
 120766,
 195496872,
 195328651,
 120424,
 -1,
 195445375,
 120764,
 195627946,
 195457137,
 120423,
 -1,
 195575111,
 120762,
 195759020,
 195582626,
 120419,
 -1,
 195726068,
 120758,
 195890094,
 195712303,
 120418,
 -1,
 195857140,
 120757,
 196021168,
 195840845,
 120417,
 -1,
 195956637,
 120756,
 196152242,
 195971491,
 120416,
 -1,
 196088440,
 120755,
 196283316,
 196099969,
 120414,
 -1,
 196241176,
 120754,
 196414390,
 196228503,
 120412,
 -1,
 196349884,
 120748,
 196545464,
 196358848,
 120411,
 -1,
 196494397,
 120763,
 196676538,
 196485506,
 120409,
 -1,
 196619607,
 120749,
 196807612,
 196614986,
 120408,
 -1,
 196754501,
 120768,
 196938686,
 196744867,
 120407,
 -1,
 196882707,
 120747,
 197069760,
 196872829,
 120406,
 -1,
 197022850,
 120746,
 -62527,
 197040595,
 120430,
 -62526,
 197170399,
 120428,
 -62525,
 197235066,
 120427,
 -62524,
 197291722,
 120422,
 -62523,
 197347501,
 120415,
 -1,
 197409096,
 120413,
 197594107,
 194059258,
 -1,
 197659595,
 197558924,
 120399,
 197725130,
 197606448,
 120727,
 -1,
 197658005,
 120737,
 -1,
 197662207,
 120739,
 197921743,
 197618197,
 120395,
 -62515,
 197885401,
 120743,
 -62514,
 197934977,
 120735,
 -1,
 197999685,
 120741,
 198183891,
 197878031,
 120394,
 198311935,
 198137135,
 -1,
 -62510,
 198197351,
 120734,
 -1,
 198257699,
 120744,
 198446038,
 198125847,
 120384,
 -62507,
 198410964,
 120726,
 -1,
 198471319,
 120724,
 198642648,
 198417358,
 120405,
 -1,
 198586643,
 120725,
 198773722,
 198613285,
 120403,
 -1,
 198721409,
 120733,
 198904796,
 198740724,
 120400,
 -1,
 198864535,
 120740,
 199035870,
 198867595,
 120398,
 -1,
 198984319,
 120738,
 199166944,
 198996081,
 120397,
 -1,
 199114055,
 120736,
 199298018,
 199121570,
 120393,
 -1,
 199265012,
 120732,
 199429092,
 199251247,
 120392,
 -1,
 199396084,
 120731,
 199560166,
 199379789,
 120391,
 -1,
 199495581,
 120730,
 199691240,
 199510435,
 120390,
 -1,
 199627384,
 120729,
 199822314,
 199638913,
 120388,
 -1,
 199780120,
 120728,
 199953388,
 199767447,
 120386,
 -1,
 199888828,
 120722,
 200084462,
 199893378,
 120383,
 -1,
 200027479,
 120723,
 200215536,
 200022858,
 120382,
 -1,
 200162373,
 120742,
 200346610,
 200152739,
 120381,
 -1,
 200290579,
 120721,
 200477684,
 200280701,
 120380,
 -1,
 200430722,
 120720,
 -62475,
 200448467,
 120404,
 -62474,
 200578271,
 120402,
 -62473,
 200642938,
 120401,
 -62472,
 200699594,
 120396,
 -62471,
 200755373,
 120389,
 -62470,
 200816968,
 120387,
 -1,
 200880832,
 120385,
 201067519,
 197552661,
 -1,
 -62467,
 201015229,
 120777,
 -62466,
 201079888,
 120775,
 -1,
 201135212,
 120771,
 -62464,
 201033058,
 120773,
 -62463,
 201290584,
 120776,
 -62462,
 201349872,
 120745,
 -62461,
 201411048,
 120774,
 -1,
 201469748,
 120772,
 201657401,
 194019140,
 -1,
 201722889,
 201615893,
 120317,
 -62457,
 201686489,
 120711,
 -62456,
 201736065,
 120703,
 -1,
 201800773,
 120709,
 201985036,
 201687692,
 120321,
 -62453,
 201931824,
 120695,
 -1,
 201987583,
 120707,
 202181648,
 201941263,
 120316,
 202309631,
 202134831,
 -1,
 -62449,
 202195047,
 120702,
 -1,
 202255395,
 120712,
 202443795,
 202123543,
 120306,
 -62446,
 202408660,
 120694,
 -1,
 202469015,
 120692,
 202640405,
 202415054,
 120327,
 -1,
 202584339,
 120693,
 202771479,
 202610981,
 120325,
 -1,
 202719105,
 120701,
 202902553,
 202738420,
 120322,
 -1,
 202862231,
 120708,
 203033627,
 202865291,
 120320,
 -1,
 202982015,
 120706,
 203164701,
 202993777,
 120319,
 -1,
 203111751,
 120704,
 203295775,
 203119266,
 120315,
 -1,
 203262708,
 120700,
 203426849,
 203248943,
 120314,
 -1,
 203393780,
 120699,
 203557923,
 203377485,
 120313,
 -1,
 203493277,
 120698,
 203688997,
 203508131,
 120312,
 -1,
 203625080,
 120697,
 203820071,
 203636609,
 120310,
 -1,
 203777816,
 120696,
 203951145,
 203765143,
 120308,
 -1,
 203886524,
 120690,
 204082219,
 203895488,
 120307,
 -1,
 204031037,
 120705,
 204213293,
 204022146,
 120305,
 -1,
 204156247,
 120691,
 204344367,
 204151626,
 120304,
 -1,
 204291141,
 120710,
 204475441,
 204281507,
 120303,
 -1,
 204419347,
 120689,
 204606515,
 204409469,
 120302,
 -1,
 204559490,
 120688,
 -62412,
 204577235,
 120326,
 -62411,
 204707039,
 120324,
 -62410,
 204771706,
 120323,
 -62409,
 204828362,
 120318,
 -62408,
 204884141,
 120311,
 -1,
 204945736,
 120309,
 205130862,
 201595898,
 -1,
 205196350,
 205095564,
 120295,
 205261885,
 205143088,
 120669,
 -1,
 205194645,
 120679,
 -1,
 205198847,
 120681,
 205458498,
 205154837,
 120291,
 -62400,
 205422041,
 120685,
 -62399,
 205471617,
 120677,
 -1,
 205536325,
 120683,
 205720646,
 205414671,
 120290,
 205848575,
 205673775,
 -1,
 -62395,
 205733991,
 120676,
 -1,
 205794339,
 120686,
 205982793,
 205662487,
 120280,
 -62392,
 205947604,
 120668,
 -1,
 206007959,
 120666,
 206179403,
 205953998,
 120301,
 -1,
 206123283,
 120667,
 206310477,
 206149925,
 120299,
 -1,
 206258049,
 120675,
 206441551,
 206277364,
 120296,
 -1,
 206401175,
 120682,
 206572625,
 206404235,
 120294,
 -1,
 206520959,
 120680,
 206703699,
 206532721,
 120293,
 -1,
 206650695,
 120678,
 206834773,
 206658210,
 120289,
 -1,
 206801652,
 120674,
 206965847,
 206787887,
 120288,
 -1,
 206932724,
 120673,
 207096921,
 206916429,
 120287,
 -1,
 207032221,
 120672,
 207227995,
 207047075,
 120286,
 -1,
 207164024,
 120671,
 207359069,
 207175553,
 120284,
 -1,
 207316760,
 120670,
 207490143,
 207304087,
 120282,
 -1,
 207425468,
 120664,
 207621217,
 207430018,
 120279,
 -1,
 207564119,
 120665,
 207752291,
 207559498,
 120278,
 -1,
 207699013,
 120684,
 207883365,
 207689379,
 120277,
 -1,
 207827219,
 120663,
 208014439,
 207817341,
 120276,
 -1,
 207967362,
 120662,
 -62360,
 207985107,
 120300,
 -62359,
 208114911,
 120298,
 -62358,
 208179578,
 120297,
 -62357,
 208236234,
 120292,
 -62356,
 208292013,
 120285,
 -62355,
 208353608,
 120283,
 -1,
 208417472,
 120281,
 208604284,
 205071382,
 -1,
 208669810,
 208568972,
 -1,
 -62351,
 208640153,
 120814,
 -1,
 208682659,
 120815,
 208866421,
 208632459,
 -1,
 -62348,
 208816273,
 120818,
 -1,
 208875983,
 120819,
 209063032,
 208810688,
 -1,
 -62345,
 209020925,
 120816,
 -1,
 209078338,
 120817,
 -62343,
 209034270,
 120812,
 -62342,
 209216442,
 120813,
 -62341,
 209280332,
 120821,
 -1,
 209333402,
 120820,
 209521792,
 208562709,
 -1,
 -62338,
 209469373,
 120719,
 -62337,
 209534032,
 120717,
 -1,
 209589356,
 120713,
 -62335,
 209487202,
 120715,
 -62334,
 209744728,
 120718,
 -62333,
 209804016,
 120687,
 -62332,
 209865192,
 120716,
 -1,
 209923892,
 120714,
 210111676,
 193939378,
 -1,
 210177185,
 210075460,
 -1,
 -62328,
 210148302,
 120379,
 -62327,
 210213331,
 120378,
 -62326,
 210278693,
 120377,
 -62325,
 210343135,
 120376,
 -62324,
 210407802,
 120375,
 -62323,
 210471668,
 120374,
 -62322,
 210535052,
 120373,
 -62321,
 210598539,
 120372,
 -62320,
 210661489,
 120371,
 -62319,
 210726602,
 120370,
 -62318,
 210790933,
 120369,
 -62317,
 210854159,
 120368,
 -62316,
 210918050,
 120367,
 -62315,
 210982191,
 120366,
 -62314,
 211045197,
 120365,
 -62313,
 211110307,
 120364,
 -62312,
 211175597,
 120363,
 -62311,
 211238785,
 120362,
 -62310,
 211302728,
 120361,
 -62309,
 211367319,
 120360,
 -62308,
 211432128,
 120359,
 -62307,
 211495191,
 120358,
 -62306,
 211558786,
 120357,
 -62305,
 211622730,
 120356,
 -62304,
 211687075,
 120355,
 -1,
 211749501,
 120354,
 212008959,
 210115578,
 -1,
 -62301,
 211917774,
 120353,
 -62300,
 211982803,
 120352,
 -62299,
 212048165,
 120351,
 -62298,
 212112607,
 120350,
 -62297,
 212177274,
 120349,
 -62296,
 212241140,
 120348,
 -62295,
 212304524,
 120347,
 -62294,
 212368011,
 120346,
 -62293,
 212430961,
 120345,
 -62292,
 212496074,
 120344,
 -62291,
 212560405,
 120343,
 -62290,
 212623631,
 120342,
 -62289,
 212687522,
 120341,
 -62288,
 212751663,
 120340,
 -62287,
 212814669,
 120339,
 -62286,
 212879779,
 120338,
 -62285,
 212945069,
 120337,
 -62284,
 213008257,
 120336,
 -62283,
 213072200,
 120335,
 -62282,
 213136791,
 120334,
 -62281,
 213201600,
 120333,
 -62280,
 213264663,
 120332,
 -62279,
 213328258,
 120331,
 -62278,
 213392202,
 120330,
 -62277,
 213456547,
 120329,
 -1,
 213518973,
 120328,
 213716183,
 210075460,
 -1,
 -62274,
 213687246,
 120275,
 -62273,
 213752275,
 120274,
 -62272,
 213817637,
 120273,
 -62271,
 213882079,
 120272,
 -62270,
 213946746,
 120271,
 -62269,
 214010612,
 120270,
 -62268,
 214073996,
 120269,
 -62267,
 214137483,
 120268,
 -62266,
 214200433,
 120267,
 -62265,
 214265546,
 120266,
 -62264,
 214329877,
 120265,
 -62263,
 214393103,
 120264,
 -62262,
 214456994,
 120263,
 -62261,
 214521135,
 120262,
 -62260,
 214584141,
 120261,
 -62259,
 214649251,
 120260,
 -62258,
 214714541,
 120259,
 -62257,
 214777729,
 120258,
 -62256,
 214841672,
 120257,
 -62255,
 214906263,
 120256,
 -62254,
 214971072,
 120255,
 -62253,
 215034135,
 120254,
 -62252,
 215097730,
 120253,
 -62251,
 215161674,
 120252,
 -62250,
 215226019,
 120251,
 -1,
 215288445,
 120250,
 215485682,
 213654522,
 -1,
 -62247,
 215456718,
 120249,
 -62246,
 215521747,
 120248,
 -62245,
 215587109,
 120247,
 -62244,
 215651551,
 120246,
 -62243,
 215716218,
 120245,
 -62242,
 215780084,
 120244,
 -62241,
 215843468,
 120243,
 -62240,
 215906955,
 120242,
 -62239,
 215969905,
 120241,
 -62238,
 216035018,
 120240,
 -62237,
 216099349,
 120239,
 -62236,
 216162575,
 120238,
 -62235,
 216226466,
 120237,
 -62234,
 216290607,
 120236,
 -62233,
 216353613,
 120235,
 -62232,
 216418723,
 120234,
 -62231,
 216484013,
 120233,
 -62230,
 216547201,
 120232,
 -62229,
 216611144,
 120231,
 -62228,
 216675735,
 120230,
 -62227,
 216740544,
 120229,
 -62226,
 216803607,
 120228,
 -62225,
 216867202,
 120227,
 -62224,
 216931146,
 120226,
 -62223,
 216995491,
 120225,
 -1,
 217057917,
 120224,
 217317375,
 215426070,
 -1,
 217320694,
 217219724,
 -1,
 -62219,
 217290905,
 120804,
 -1,
 217333411,
 120805,
 217517305,
 217283211,
 -1,
 -62216,
 217467025,
 120808,
 -1,
 217526735,
 120809,
 217713916,
 217461440,
 -1,
 -62213,
 217671677,
 120806,
 -1,
 217729090,
 120807,
 -62211,
 217685022,
 120802,
 -62210,
 217867194,
 120803,
 -62209,
 217931084,
 120811,
 -1,
 217984154,
 120810,
 218234879,
 193863760,
 -1,
 218238232,
 218136388,
 -1,
 -62205,
 218209230,
 120015,
 -62204,
 218274259,
 120014,
 -62203,
 218339621,
 120013,
 -62202,
 218404063,
 120012,
 -62201,
 218468730,
 120011,
 -62200,
 218532596,
 120010,
 -62199,
 218595980,
 120009,
 -62198,
 218659467,
 120008,
 -62197,
 218722417,
 120007,
 -62196,
 218787530,
 120006,
 -62195,
 218851861,
 120005,
 -62194,
 218913442,
 120003,
 -62193,
 218977583,
 120002,
 -62192,
 219040163,
 120000,
 -62191,
 219105453,
 119999,
 -62190,
 219168641,
 119998,
 -62189,
 219232584,
 119997,
 -62188,
 219296448,
 119995,
 -62187,
 219357570,
 119993,
 -62186,
 219421514,
 119992,
 -62185,
 219485859,
 119991,
 -1,
 219548285,
 119990,
 219807743,
 218176506,
 -1,
 -62182,
 219716558,
 119989,
 -62181,
 219781587,
 119988,
 -62180,
 219846949,
 119987,
 -62179,
 219911391,
 119986,
 -62178,
 219976058,
 119985,
 -62177,
 220039924,
 119984,
 -62176,
 220103308,
 119983,
 -62175,
 220166795,
 119982,
 -62174,
 220229322,
 119980,
 -62173,
 220293653,
 119979,
 -62172,
 220356879,
 119978,
 -62171,
 220420770,
 119977,
 -62170,
 220481955,
 119974,
 -62169,
 220547245,
 119973,
 -62168,
 220607895,
 119970,
 -62167,
 220668290,
 119967,
 -62166,
 220732234,
 119966,
 -1,
 220793469,
 119964,
 220991120,
 193796551,
 -1,
 221056416,
 220940210,
 -1,
 221121890,
 221019972,
 -1,
 221187378,
 221080085,
 119953,
 -62160,
 221150681,
 120653,
 -62159,
 221200257,
 120645,
 -1,
 221264965,
 120651,
 221449525,
 221151884,
 119957,
 -62156,
 221396016,
 120637,
 -1,
 221451775,
 120649,
 221646137,
 221405455,
 119952,
 221773823,
 221599023,
 -1,
 -62152,
 221659239,
 120644,
 -1,
 221719587,
 120654,
 221908284,
 221587735,
 119942,
 -62149,
 221872852,
 120636,
 -1,
 221933207,
 120634,
 222104894,
 221879246,
 119963,
 -1,
 222048531,
 120635,
 222235968,
 222075173,
 119961,
 -1,
 222183297,
 120643,
 222367042,
 222202612,
 119958,
 -1,
 222326423,
 120650,
 222498116,
 222329483,
 119956,
 -1,
 222446207,
 120648,
 222629190,
 222457969,
 119955,
 -1,
 222575943,
 120646,
 222760264,
 222583458,
 119951,
 -1,
 222726900,
 120642,
 222891338,
 222713135,
 119950,
 -1,
 222857972,
 120641,
 223022412,
 222841677,
 119949,
 -1,
 222957469,
 120640,
 223153486,
 222972323,
 119948,
 -1,
 223089272,
 120639,
 223284560,
 223100801,
 119946,
 -1,
 223242008,
 120638,
 223415634,
 223229335,
 119944,
 -1,
 223350716,
 120632,
 223546708,
 223359680,
 119943,
 -1,
 223495229,
 120647,
 223677782,
 223486338,
 119941,
 -1,
 223620439,
 120633,
 223808856,
 223615818,
 119940,
 -1,
 223755333,
 120652,
 223939930,
 223745699,
 119939,
 -1,
 223883539,
 120631,
 224071004,
 223873661,
 119938,
 -1,
 224023682,
 120630,
 -62115,
 224041427,
 119962,
 -62114,
 224171231,
 119960,
 -62113,
 224235898,
 119959,
 -62112,
 224292554,
 119954,
 -62111,
 224348333,
 119947,
 -1,
 224409928,
 119945,
 224595351,
 221060090,
 -1,
 224660839,
 224559756,
 119931,
 224726374,
 224607280,
 120611,
 -1,
 224658837,
 120621,
 -1,
 224663039,
 120623,
 224922987,
 224619029,
 119927,
 -62103,
 224886233,
 120627,
 -62102,
 224935809,
 120619,
 -1,
 225000517,
 120625,
 225185135,
 224878863,
 119926,
 225312767,
 225137967,
 -1,
 -62098,
 225198183,
 120618,
 -1,
 225258531,
 120628,
 225447282,
 225126679,
 119916,
 -62095,
 225411796,
 120610,
 -1,
 225472151,
 120608,
 225643892,
 225418190,
 119937,
 -1,
 225587475,
 120609,
 225774966,
 225614117,
 119935,
 -1,
 225722241,
 120617,
 225906040,
 225741556,
 119932,
 -1,
 225865367,
 120624,
 226037114,
 225868427,
 119930,
 -1,
 225985151,
 120622,
 226168188,
 225996913,
 119929,
 -1,
 226114887,
 120620,
 226299262,
 226122402,
 119925,
 -1,
 226265844,
 120616,
 226430336,
 226252079,
 119924,
 -1,
 226396916,
 120615,
 226561410,
 226380621,
 119923,
 -1,
 226496413,
 120614,
 226692484,
 226511267,
 119922,
 -1,
 226628216,
 120613,
 226823558,
 226639745,
 119920,
 -1,
 226780952,
 120612,
 226954632,
 226768279,
 119918,
 -1,
 226889660,
 120606,
 227085706,
 226894210,
 119915,
 -1,
 227028311,
 120607,
 227216780,
 227023690,
 119914,
 -1,
 227163205,
 120626,
 227347854,
 227153571,
 119913,
 -1,
 227291411,
 120605,
 227478928,
 227281533,
 119912,
 -1,
 227431554,
 120604,
 -62063,
 227449299,
 119936,
 -62062,
 227579103,
 119934,
 -62061,
 227643770,
 119933,
 -62060,
 227700426,
 119928,
 -62059,
 227756205,
 119921,
 -62058,
 227817800,
 119919,
 -1,
 227881664,
 119917,
 228068763,
 224553493,
 -1,
 -62055,
 228016061,
 120661,
 -62054,
 228080720,
 120659,
 -1,
 228136044,
 120655,
 -62052,
 228033890,
 120657,
 -62051,
 228291416,
 120660,
 -62050,
 228350704,
 120629,
 -62049,
 228411880,
 120658,
 -1,
 228470580,
 120656,
 228658701,
 221018763,
 -1,
 228724184,
 228597840,
 -1,
 228789693,
 228687684,
 -1,
 -62044,
 228760526,
 120067,
 -62043,
 228825555,
 120066,
 -62042,
 228890917,
 120065,
 -62041,
 228955359,
 120064,
 -62040,
 229020026,
 120063,
 -62039,
 229083892,
 120062,
 -62038,
 229147276,
 120061,
 -62037,
 229210763,
 120060,
 -62036,
 229273713,
 120059,
 -62035,
 229338826,
 120058,
 -62034,
 229403157,
 120057,
 -62033,
 229466383,
 120056,
 -62032,
 229530274,
 120055,
 -62031,
 229594415,
 120054,
 -62030,
 229657421,
 120053,
 -62029,
 229722531,
 120052,
 -62028,
 229787821,
 120051,
 -62027,
 229851009,
 120050,
 -62026,
 229914952,
 120049,
 -62025,
 229979543,
 120048,
 -62024,
 230044352,
 120047,
 -62023,
 230107415,
 120046,
 -62022,
 230171010,
 120045,
 -62021,
 230234954,
 120044,
 -62020,
 230299299,
 120043,
 -1,
 230361725,
 120042,
 230621183,
 228727802,
 -1,
 -62017,
 230529998,
 120041,
 -62016,
 230595027,
 120040,
 -62015,
 230660389,
 120039,
 -62014,
 230724831,
 120038,
 -62013,
 230789498,
 120037,
 -62012,
 230853364,
 120036,
 -62011,
 230916748,
 120035,
 -62010,
 230980235,
 120034,
 -62009,
 231043185,
 120033,
 -62008,
 231108298,
 120032,
 -62007,
 231172629,
 120031,
 -62006,
 231235855,
 120030,
 -62005,
 231299746,
 120029,
 -62004,
 231363887,
 120028,
 -62003,
 231426893,
 120027,
 -62002,
 231492003,
 120026,
 -62001,
 231557293,
 120025,
 -62000,
 231620481,
 120024,
 -61999,
 231684424,
 120023,
 -61998,
 231749015,
 120022,
 -61997,
 231813824,
 120021,
 -61996,
 231876887,
 120020,
 -61995,
 231940482,
 120019,
 -61994,
 232004426,
 120018,
 -61993,
 232068771,
 120017,
 -1,
 232131197,
 120016,
 232390655,
 228677102,
 -1,
 232394205,
 232286741,
 119849,
 -61989,
 232357337,
 120537,
 -61988,
 232406913,
 120529,
 -1,
 232471621,
 120535,
 232656352,
 232358540,
 119853,
 -61985,
 232602672,
 120521,
 -1,
 232658431,
 120533,
 232852964,
 232612111,
 119848,
 232980479,
 232805679,
 -1,
 -61981,
 232865895,
 120528,
 -1,
 232926243,
 120538,
 233115111,
 232794391,
 119838,
 -61978,
 233079508,
 120520,
 -1,
 233139863,
 120518,
 233311721,
 233085902,
 119859,
 -1,
 233255187,
 120519,
 233442795,
 233281829,
 119857,
 -1,
 233389953,
 120527,
 233573869,
 233409268,
 119854,
 -1,
 233533079,
 120534,
 233704943,
 233536139,
 119852,
 -1,
 233652863,
 120532,
 233836017,
 233664625,
 119851,
 -1,
 233782599,
 120530,
 233967091,
 233790114,
 119847,
 -1,
 233933556,
 120526,
 234098165,
 233919791,
 119846,
 -1,
 234064628,
 120525,
 234229239,
 234048333,
 119845,
 -1,
 234164125,
 120524,
 234360313,
 234178979,
 119844,
 -1,
 234295928,
 120523,
 234491387,
 234307457,
 119842,
 -1,
 234448664,
 120522,
 234622461,
 234435991,
 119840,
 -1,
 234557372,
 120516,
 234753535,
 234566336,
 119839,
 -1,
 234701885,
 120531,
 234884609,
 234692994,
 119837,
 -1,
 234827095,
 120517,
 235015683,
 234822474,
 119836,
 -1,
 234961989,
 120536,
 235146757,
 234952355,
 119835,
 -1,
 235090195,
 120515,
 235277831,
 235080317,
 119834,
 -1,
 235230338,
 120514,
 -61944,
 235248083,
 119858,
 -61943,
 235377887,
 119856,
 -61942,
 235442554,
 119855,
 -61941,
 235499210,
 119850,
 -61940,
 235554989,
 119843,
 -1,
 235616584,
 119841,
 235802180,
 228603160,
 -1,
 235867689,
 235765572,
 -1,
 -61936,
 235838414,
 120223,
 -61935,
 235903443,
 120222,
 -61934,
 235968805,
 120221,
 -61933,
 236033247,
 120220,
 -61932,
 236097914,
 120219,
 -61931,
 236161780,
 120218,
 -61930,
 236225164,
 120217,
 -61929,
 236288651,
 120216,
 -61928,
 236351601,
 120215,
 -61927,
 236416714,
 120214,
 -61926,
 236481045,
 120213,
 -61925,
 236544271,
 120212,
 -61924,
 236608162,
 120211,
 -61923,
 236672303,
 120210,
 -61922,
 236735309,
 120209,
 -61921,
 236800419,
 120208,
 -61920,
 236865709,
 120207,
 -61919,
 236928897,
 120206,
 -61918,
 236992840,
 120205,
 -61917,
 237057431,
 120204,
 -61916,
 237122240,
 120203,
 -61915,
 237185303,
 120202,
 -61914,
 237248898,
 120201,
 -61913,
 237312842,
 120200,
 -61912,
 237377187,
 120199,
 -1,
 237439613,
 120198,
 237699071,
 235805690,
 -1,
 -61909,
 237607886,
 120197,
 -61908,
 237672915,
 120196,
 -61907,
 237738277,
 120195,
 -61906,
 237802719,
 120194,
 -61905,
 237867386,
 120193,
 -61904,
 237931252,
 120192,
 -61903,
 237994636,
 120191,
 -61902,
 238058123,
 120190,
 -61901,
 238121073,
 120189,
 -61900,
 238186186,
 120188,
 -61899,
 238250517,
 120187,
 -61898,
 238313743,
 120186,
 -61897,
 238377634,
 120185,
 -61896,
 238441775,
 120184,
 -61895,
 238504781,
 120183,
 -61894,
 238569891,
 120182,
 -61893,
 238635181,
 120181,
 -61892,
 238698369,
 120180,
 -61891,
 238762312,
 120179,
 -61890,
 238826903,
 120178,
 -61889,
 238891712,
 120177,
 -61888,
 238954775,
 120176,
 -61887,
 239018370,
 120175,
 -61886,
 239082314,
 120174,
 -61885,
 239146659,
 120173,
 -1,
 239209085,
 120172,
 239406713,
 235740154,
 -1,
 239472201,
 239370892,
 119827,
 239537736,
 239418416,
 120495,
 -1,
 239469973,
 120505,
 -1,
 239474175,
 120507,
 239734349,
 239430165,
 119823,
 -61877,
 239697369,
 120511,
 -61876,
 239746945,
 120503,
 -1,
 239811653,
 120509,
 239996497,
 239689999,
 119822,
 240123903,
 239949103,
 -1,
 -61872,
 240009319,
 120502,
 -1,
 240069667,
 120512,
 240258644,
 239937815,
 119812,
 -61869,
 240222932,
 120494,
 -1,
 240283287,
 120492,
 240455254,
 240229326,
 119833,
 -1,
 240398611,
 120493,
 240586328,
 240425253,
 119831,
 -1,
 240533377,
 120501,
 240717402,
 240552692,
 119828,
 -1,
 240676503,
 120508,
 240848476,
 240679563,
 119826,
 -1,
 240796287,
 120506,
 240979550,
 240808049,
 119825,
 -1,
 240926023,
 120504,
 241110624,
 240933538,
 119821,
 -1,
 241076980,
 120500,
 241241698,
 241063215,
 119820,
 -1,
 241208052,
 120499,
 241372772,
 241191757,
 119819,
 -1,
 241307549,
 120498,
 241503846,
 241322403,
 119818,
 -1,
 241439352,
 120497,
 241634920,
 241450881,
 119816,
 -1,
 241592088,
 120496,
 241765994,
 241579415,
 119814,
 -1,
 241700796,
 120490,
 241897068,
 241705346,
 119811,
 -1,
 241839447,
 120491,
 242028142,
 241834826,
 119810,
 -1,
 241974341,
 120510,
 242159216,
 241964707,
 119809,
 -1,
 242102547,
 120489,
 242290290,
 242092669,
 119808,
 -1,
 242242690,
 120488,
 -61837,
 242260435,
 119832,
 -61836,
 242390239,
 119830,
 -61835,
 242454906,
 119829,
 -61834,
 242511562,
 119824,
 -61833,
 242567341,
 119817,
 -61832,
 242628936,
 119815,
 -1,
 242692800,
 119813,
 242880135,
 239346710,
 -1,
 242945661,
 242844300,
 -1,
 -61828,
 242915481,
 120784,
 -1,
 242957987,
 120785,
 243142272,
 242907787,
 -1,
 -61825,
 243091601,
 120788,
 -1,
 243151311,
 120789,
 243338883,
 243086016,
 -1,
 -61822,
 243296253,
 120786,
 -1,
 243353666,
 120787,
 -61820,
 243309598,
 120782,
 -61819,
 243491770,
 120783,
 -61818,
 243555660,
 120791,
 -1,
 243608730,
 120790,
 243797643,
 242838037,
 -1,
 -61815,
 243744701,
 120545,
 -61814,
 243809360,
 120543,
 -1,
 243864684,
 120539,
 -61812,
 243762530,
 120541,
 -61811,
 244020056,
 120544,
 -61810,
 244079344,
 120513,
 -61809,
 244140520,
 120542,
 -1,
 244199220,
 120540,
 244387587,
 220940210,
 -1,
 244453062,
 244325370,
 -1,
 244518550,
 244417164,
 119879,
 244584085,
 244464688,
 120553,
 -1,
 244516245,
 120563,
 -1,
 244520447,
 120565,
 244780698,
 244476437,
 119875,
 -61800,
 244743641,
 120569,
 -61799,
 244793217,
 120561,
 -1,
 244857925,
 120567,
 245042846,
 244736271,
 119874,
 245170175,
 244995375,
 -1,
 -61795,
 245055591,
 120560,
 -1,
 245115939,
 120570,
 245304993,
 244984087,
 119864,
 -61792,
 245269204,
 120552,
 -1,
 245329559,
 120550,
 245501603,
 245275598,
 119885,
 -1,
 245444883,
 120551,
 245632677,
 245471525,
 119883,
 -1,
 245579649,
 120559,
 245763751,
 245598964,
 119880,
 -1,
 245722775,
 120566,
 245894825,
 245725835,
 119878,
 -1,
 245842559,
 120564,
 246025899,
 245854321,
 119877,
 -1,
 245972295,
 120562,
 246156973,
 245979810,
 119873,
 -1,
 246123252,
 120558,
 246288047,
 246109487,
 119872,
 -1,
 246254324,
 120557,
 246419121,
 246238029,
 119871,
 -1,
 246353821,
 120556,
 246550195,
 246368675,
 119870,
 -1,
 246485624,
 120555,
 246681269,
 246497153,
 119868,
 -1,
 246638360,
 120554,
 246812343,
 246625687,
 119866,
 -1,
 246747068,
 120548,
 246943417,
 246751618,
 119863,
 -1,
 246885719,
 120549,
 247074491,
 246881098,
 119862,
 -1,
 247020613,
 120568,
 247205565,
 247010979,
 119861,
 -1,
 247148819,
 120547,
 247336639,
 247138941,
 119860,
 -1,
 247288962,
 120546,
 -61760,
 247306707,
 119884,
 -61759,
 247436511,
 119882,
 -61758,
 247501178,
 119881,
 -61757,
 247557834,
 119876,
 -61756,
 247613613,
 119869,
 -61755,
 247675208,
 119867,
 -1,
 247739072,
 119865,
 247926522,
 244416324,
 -1,
 247992011,
 247884309,
 119901,
 -61751,
 247954905,
 120595,
 -61750,
 248004481,
 120587,
 -1,
 248069189,
 120593,
 248254158,
 247956108,
 119905,
 -61747,
 248200240,
 120579,
 -1,
 248255999,
 120591,
 248450770,
 248209679,
 119900,
 248578047,
 248403247,
 -1,
 -61743,
 248463463,
 120586,
 -1,
 248523811,
 120596,
 248712917,
 248391959,
 119890,
 -61740,
 248677076,
 120578,
 -1,
 248737431,
 120576,
 248909527,
 248683470,
 119911,
 -1,
 248852755,
 120577,
 249040601,
 248879397,
 119909,
 -1,
 248987521,
 120585,
 249171675,
 249006836,
 119906,
 -1,
 249130647,
 120592,
 249302749,
 249133707,
 119904,
 -1,
 249250431,
 120590,
 249433823,
 249262193,
 119903,
 -1,
 249380167,
 120588,
 249564897,
 249387682,
 119899,
 -1,
 249531124,
 120584,
 249695971,
 249517359,
 119898,
 -1,
 249662196,
 120583,
 249827045,
 249645901,
 119897,
 -1,
 249761693,
 120582,
 249958119,
 249776547,
 119896,
 -1,
 249893496,
 120581,
 250089193,
 249905025,
 119894,
 -1,
 250046232,
 120580,
 250220267,
 250033559,
 119892,
 -1,
 250154940,
 120574,
 250351341,
 250163904,
 119891,
 -1,
 250299453,
 120589,
 250482415,
 250290562,
 119889,
 -1,
 250424663,
 120575,
 250613489,
 250420042,
 119888,
 -1,
 250559557,
 120594,
 250744563,
 250549923,
 119887,
 -1,
 250687763,
 120573,
 250875637,
 250677885,
 119886,
 -1,
 250827906,
 120572,
 -61706,
 250845651,
 119910,
 -61705,
 250975455,
 119908,
 -61704,
 251040122,
 119907,
 -61703,
 251096778,
 119902,
 -1,
 251152557,
 119895,
 251334398,
 247884309,
 -1,
 -61700,
 251281341,
 120603,
 -61699,
 251346000,
 120601,
 -1,
 251401324,
 120597,
 -61697,
 251299170,
 120599,
 -61696,
 251556696,
 120602,
 -61695,
 251615984,
 120571,
 -61694,
 251677160,
 120600,
 -1,
 251735860,
 120598,
 251924296,
 244341141,
 -1,
 251989791,
 251887428,
 -1,
 -61690,
 251960270,
 120483,
 -61689,
 252025299,
 120482,
 -61688,
 252090661,
 120481,
 -61687,
 252155103,
 120480,
 -61686,
 252219770,
 120479,
 -61685,
 252283636,
 120478,
 -61684,
 252347020,
 120477,
 -61683,
 252410507,
 120476,
 -61682,
 252473457,
 120475,
 -61681,
 252538570,
 120474,
 -61680,
 252602901,
 120473,
 -61679,
 252666127,
 120472,
 -61678,
 252730018,
 120471,
 -61677,
 252794159,
 120470,
 -61676,
 252857165,
 120469,
 -61675,
 252922275,
 120468,
 -61674,
 252987565,
 120467,
 -61673,
 253050753,
 120466,
 -61672,
 253114696,
 120465,
 -61671,
 253179287,
 120464,
 -61670,
 253244096,
 120463,
 -61669,
 253307159,
 120462,
 -61668,
 253370754,
 120461,
 -61667,
 253434698,
 120460,
 -61666,
 253499043,
 120459,
 -1,
 253561469,
 120458,
 253759290,
 251927546,
 -1,
 -61663,
 253729742,
 120457,
 -61662,
 253794771,
 120456,
 -61661,
 253860133,
 120455,
 -61660,
 253924575,
 120454,
 -61659,
 253989242,
 120453,
 -61658,
 254053108,
 120452,
 -61657,
 254116492,
 120451,
 -61656,
 254179979,
 120450,
 -61655,
 254242929,
 120449,
 -61654,
 254308042,
 120448,
 -61653,
 254372373,
 120447,
 -61652,
 254435599,
 120446,
 -61651,
 254499490,
 120445,
 -61650,
 254563631,
 120444,
 -61649,
 254626637,
 120443,
 -61648,
 254691747,
 120442,
 -61647,
 254757037,
 120441,
 -61646,
 254820225,
 120440,
 -61645,
 254884168,
 120439,
 -61644,
 254948759,
 120438,
 -61643,
 255013568,
 120437,
 -61642,
 255076631,
 120436,
 -61641,
 255140226,
 120435,
 -61640,
 255204170,
 120434,
 -61639,
 255268515,
 120433,
 -1,
 255330941,
 120432,
 255590399,
 253699094,
 -1,
 255594302,
 255492748,
 -1,
 -61635,
 255563929,
 120824,
 -1,
 255606435,
 120825,
 255790913,
 255556235,
 -1,
 -61632,
 255740049,
 120828,
 -1,
 255799759,
 120829,
 255987524,
 255734464,
 -1,
 -61629,
 255944701,
 120826,
 -1,
 256002114,
 120827,
 -61627,
 255958046,
 120822,
 -61626,
 256140218,
 120823,
 -61625,
 256204108,
 120831,
 -1,
 256257178,
 120830,
 256446342,
 251864866,
 -1,
 256511844,
 256409412,
 -1,
 -61621,
 256482254,
 120171,
 -61620,
 256547283,
 120170,
 -61619,
 256612645,
 120169,
 -61618,
 256677087,
 120168,
 -61617,
 256741754,
 120167,
 -61616,
 256805620,
 120166,
 -61615,
 256869004,
 120165,
 -61614,
 256932491,
 120164,
 -61613,
 256995441,
 120163,
 -61612,
 257060554,
 120162,
 -61611,
 257124885,
 120161,
 -61610,
 257188111,
 120160,
 -61609,
 257252002,
 120159,
 -61608,
 257316143,
 120158,
 -61607,
 257379149,
 120157,
 -61606,
 257444259,
 120156,
 -61605,
 257509549,
 120155,
 -61604,
 257572737,
 120154,
 -61603,
 257636680,
 120153,
 -61602,
 257701271,
 120152,
 -61601,
 257766080,
 120151,
 -61600,
 257829143,
 120150,
 -61599,
 257892738,
 120149,
 -61598,
 257956682,
 120148,
 -61597,
 258021027,
 120147,
 -1,
 258083453,
 120146,
 258281336,
 256449530,
 -1,
 -61594,
 258251219,
 120144,
 -61593,
 258316581,
 120143,
 -61592,
 258381023,
 120142,
 -61591,
 258445690,
 120141,
 -61590,
 258509556,
 120140,
 -61589,
 258572940,
 120139,
 -61588,
 258636427,
 120138,
 -61587,
 258695439,
 120134,
 -61586,
 258757935,
 120132,
 -61585,
 258820941,
 120131,
 -61584,
 258886051,
 120130,
 -61583,
 258951341,
 120129,
 -61582,
 259014529,
 120128,
 -61581,
 259077527,
 120126,
 -61580,
 259142336,
 120125,
 -61579,
 259205399,
 120124,
 -61578,
 259268994,
 120123,
 -61577,
 259331747,
 120121,
 -1,
 259394173,
 120120,
 259653631,
 258221078,
 -1,
 259657596,
 259555980,
 -1,
 -61573,
 259627161,
 120794,
 -1,
 259669667,
 120795,
 259854207,
 259619467,
 -1,
 -61570,
 259803281,
 120798,
 -1,
 259862991,
 120799,
 260050818,
 259797696,
 -1,
 -61567,
 260007933,
 120796,
 -1,
 260065346,
 120797,
 -61565,
 260021278,
 120792,
 -61564,
 260203450,
 120793,
 -61563,
 260267340,
 120801,
 -1,
 260320410,
 120800,
 260509624,
 256390424,
 -1,
 260575138,
 260472644,
 -1,
 -61559,
 260545486,
 120119,
 -61558,
 260610515,
 120118,
 -61557,
 260675877,
 120117,
 -61556,
 260740319,
 120116,
 -61555,
 260804986,
 120115,
 -61554,
 260868852,
 120114,
 -61553,
 260932236,
 120113,
 -61552,
 260995723,
 120112,
 -61551,
 261058673,
 120111,
 -61550,
 261123786,
 120110,
 -61549,
 261188117,
 120109,
 -61548,
 261251343,
 120108,
 -61547,
 261315234,
 120107,
 -61546,
 261379375,
 120106,
 -61545,
 261442381,
 120105,
 -61544,
 261507491,
 120104,
 -61543,
 261572781,
 120103,
 -61542,
 261635969,
 120102,
 -61541,
 261699912,
 120101,
 -61540,
 261764503,
 120100,
 -61539,
 261829312,
 120099,
 -61538,
 261892375,
 120098,
 -61537,
 261955970,
 120097,
 -61536,
 262019914,
 120096,
 -61535,
 262084259,
 120095,
 -1,
 262146685,
 120094,
 262406143,
 260512762,
 -1,
 -61532,
 262314451,
 120092,
 -61531,
 262379813,
 120091,
 -61530,
 262444255,
 120090,
 -61529,
 262508922,
 120089,
 -61528,
 262572788,
 120088,
 -61527,
 262636172,
 120087,
 -61526,
 262699659,
 120086,
 -61525,
 262762186,
 120084,
 -61524,
 262826517,
 120083,
 -61523,
 262889743,
 120082,
 -61522,
 262953634,
 120081,
 -61521,
 263017775,
 120080,
 -61520,
 263080781,
 120079,
 -61519,
 263145891,
 120078,
 -61518,
 263211181,
 120077,
 -61517,
 263271831,
 120074,
 -61516,
 263336640,
 120073,
 -61515,
 263399703,
 120072,
 -61514,
 263463298,
 120071,
 -61513,
 263526051,
 120069,
 -1,
 263588477,
 120068,
 263786428,
 260469721,
 -1,
 -61510,
 263755378,
 10215,
 -61509,
 263792095,
 10219,
 -1,
 263852332,
 10217,
 264110079,
 263736697,
 -1,
 -61506,
 264017522,
 10214,
 -61505,
 264054239,
 10218,
 -1,
 264114476,
 10216,
 264310828,
 193743693,
 -1,
 264376362,
 264246904,
 -1,
 264441864,
 264327236,
 -1,
 264507338,
 264409466,
 -1,
 264572873,
 264462728,
 -1,
 264638407,
 264532081,
 3339,
 -1,
 264597617,
 3424,
 264830975,
 264588109,
 3340,
 -1,
 264719181,
 3425,
 -1,
 264505981,
 3381,
 264966096,
 264471180,
 -1,
 265031630,
 264929932,
 -1,
 -61491,
 264976738,
 3360,
 -1,
 265030269,
 3359,
 -61489,
 264976738,
 3365,
 -1,
 265161341,
 3364,
 265359317,
 264919714,
 -1,
 -61486,
 265329130,
 3358,
 -61485,
 265378530,
 3363,
 -61484,
 265434524,
 3353,
 -1,
 265489021,
 3368,
 265687003,
 265298306,
 -1,
 265752537,
 265625986,
 -1,
 -61480,
 265697634,
 3362,
 -1,
 265751165,
 3361,
 -61478,
 265697634,
 3367,
 -1,
 265882237,
 3366,
 266080223,
 265620093,
 3333,
 -61475,
 266046196,
 3348,
 -61474,
 266092417,
 3344,
 -1,
 266144381,
 3334,
 266342371,
 266041995,
 -1,
 -61471,
 266304202,
 3383,
 -61470,
 266352994,
 3382,
 -1,
 266406525,
 3384,
 266604520,
 266292045,
 -1,
 266670055,
 266554189,
 -1,
 -61466,
 266619788,
 3380,
 -1,
 266668669,
 3379,
 -1,
 266603133,
 3378,
 266932202,
 266570484,
 3337,
 -1,
 266898164,
 3338,
 267063277,
 266891377,
 -1,
 -61460,
 267022485,
 3377,
 -1,
 267061885,
 3376,
 267259888,
 267020821,
 -1,
 -61457,
 267204962,
 3371,
 -1,
 267258493,
 3370,
 267456498,
 267215119,
 3346,
 -1,
 267411727,
 3347,
 267587573,
 267405731,
 -1,
 -61452,
 267532642,
 3350,
 -1,
 267586173,
 3349,
 267784184,
 267536557,
 -1,
 -61449,
 267729250,
 3357,
 -1,
 267782781,
 3356,
 267980794,
 267730817,
 3335,
 -1,
 267927425,
 3336,
 268111869,
 267924887,
 -1,
 -61444,
 268056930,
 3352,
 -1,
 268110461,
 3351,
 268308479,
 268052759,
 3342,
 -1,
 268249367,
 3343,
 268439554,
 268245834,
 -1,
 -61439,
 268384610,
 3355,
 -1,
 268438141,
 3354,
 268636165,
 268375715,
 -1,
 -61436,
 268581218,
 3373,
 -1,
 268634749,
 3372,
 -61434,
 268605930,
 3375,
 -61433,
 268784952,
 3374,
 -1,
 268843362,
 3385,
 269029398,
 264410305,
 -1,
 269094925,
 268962429,
 -1,
 -61429,
 269060852,
 3404,
 -61428,
 269107073,
 3400,
 -1,
 269159037,
 3390,
 269357071,
 269060852,
 3393,
 -1,
 269322996,
 3394,
 269488145,
 269312271,
 3402,
 -1,
 269443343,
 3403,
 269619219,
 269434753,
 3391,
 -1,
 269565825,
 3392,
 269750293,
 269560087,
 3398,
 -1,
 269691159,
 3399,
 -1,
 269718644,
 3395,
 269946916,
 268968982,
 -1,
 270012442,
 269910668,
 -1,
 -61415,
 269981849,
 3432,
 -1,
 270024355,
 3433,
 270209053,
 269974155,
 -1,
 -61412,
 270157969,
 3436,
 -1,
 270217679,
 3437,
 270405664,
 270152384,
 -1,
 -61409,
 270362621,
 3434,
 -1,
 270420034,
 3435,
 -61407,
 270375966,
 3430,
 -61406,
 270558138,
 3431,
 -61405,
 270622028,
 3439,
 -1,
 270675098,
 3438,
 270864425,
 269909548,
 -1,
 270929960,
 270832623,
 -1,
 -61401,
 270891847,
 3331,
 -1,
 270954764,
 3405,
 -1,
 270864873,
 3330,
 -1,
 270800386,
 3415,
 -61397,
 264340702,
 10016,
 -1,
 271198516,
 9794,
 271388719,
 264272523,
 -1,
 -61394,
 271354631,
 12348,
 -1,
 271392997,
 186,
 -1,
 271327342,
 175,
 271651220,
 193694452,
 -1,
 271716735,
 271613434,
 -1,
 271782267,
 271650198,
 -1,
 271847535,
 271719242,
 -1,
 271913057,
 271802639,
 -1,
 271978592,
 271865135,
 -1,
 272044127,
 271915257,
 -1,
 272109632,
 272005771,
 -1,
 272175165,
 272073356,
 -1,
 272240700,
 272108451,
 -1,
 -61381,
 272195855,
 119164,
 -1,
 272254871,
 119166,
 -1,
 272182649,
 119141,
 -61378,
 272133681,
 119142,
 -61377,
 272456488,
 119213,
 -1,
 272520980,
 119176,
 272699464,
 272053364,
 -1,
 272764999,
 272633028,
 -1,
 -61373,
 272697938,
 119154,
 -61372,
 272763461,
 119153,
 -61371,
 272828984,
 119152,
 -61370,
 272894504,
 119151,
 -1,
 272960027,
 119150,
 -1,
 272713307,
 119175,
 273223760,
 272663180,
 -1,
 273289295,
 273182833,
 -1,
 273354830,
 273231344,
 -1,
 -61364,
 273287736,
 119145,
 -61363,
 273353256,
 119144,
 -1,
 273418779,
 119143,
 -1,
 273303154,
 119179,
 -1,
 273231625,
 119165,
 273748052,
 273163505,
 -1,
 -61358,
 273717365,
 119210,
 -61357,
 273779550,
 119178,
 -1,
 273827748,
 119173,
 274010200,
 273681021,
 -1,
 274075735,
 273947777,
 119163,
 -1,
 274008574,
 119169,
 -1,
 274041837,
 119149,
 274272346,
 273962659,
 119167,
 -1,
 274205182,
 119168,
 -61349,
 274238963,
 119211,
 -61348,
 274364160,
 119174,
 -61347,
 274420708,
 119170,
 -61346,
 274479844,
 119212,
 -1,
 274536466,
 119177,
 -1,
 271997284,
 119092,
 -1,
 271917526,
 119052,
 274862184,
 271862605,
 -1,
 274927717,
 274829525,
 -1,
 -61340,
 274896405,
 119130,
 -1,
 274929963,
 119131,
 275185663,
 274874241,
 -1,
 -61337,
 275092542,
 119253,
 -1,
 275141954,
 119255,
 275320939,
 274821233,
 -1,
 -61334,
 275276402,
 119247,
 -1,
 275329142,
 119186,
 -61332,
 275288335,
 119093,
 -61331,
 275465911,
 119109,
 -61330,
 275516578,
 119059,
 -1,
 275579376,
 119073,
 275779741,
 271811212,
 -1,
 275845253,
 275738737,
 119190,
 275972095,
 275791904,
 -1,
 275976322,
 275842013,
 -1,
 276041849,
 275942869,
 -1,
 276107383,
 276001753,
 -1,
 -61322,
 276076053,
 119120,
 -1,
 276109611,
 119121,
 -61320,
 276076053,
 119112,
 -1,
 276240683,
 119113,
 276435068,
 276001753,
 -1,
 -61317,
 276403733,
 119116,
 -1,
 276437291,
 119117,
 276631679,
 276385145,
 -1,
 -61314,
 276600341,
 119114,
 -1,
 276633899,
 119115,
 276889599,
 276571958,
 -1,
 -61311,
 276796949,
 119118,
 -1,
 276830507,
 119119,
 277086207,
 275909077,
 -1,
 -61308,
 276993557,
 119124,
 -1,
 277027115,
 119125,
 277221521,
 275787265,
 -1,
 277287053,
 277169079,
 -1,
 277352588,
 277234588,
 119243,
 277479423,
 277283370,
 -1,
 -61302,
 277350968,
 119246,
 -61301,
 277416488,
 119245,
 -1,
 277482011,
 119244,
 -1,
 277310434,
 119242,
 277807103,
 277244921,
 -1,
 277811344,
 277703650,
 119239,
 -1,
 277742135,
 119241,
 -1,
 277758876,
 119240,
 278007957,
 277188656,
 119191,
 278134783,
 277938176,
 -1,
 -61292,
 278040018,
 119194,
 -1,
 278101813,
 119193,
 278270106,
 277952840,
 -1,
 278335641,
 278218576,
 -1,
 -61288,
 278295204,
 119104,
 -1,
 278355696,
 119138,
 -1,
 278295131,
 119064,
 278597788,
 278226327,
 119256,
 -1,
 278529293,
 119260,
 -1,
 278567159,
 119063,
 278794435,
 275741323,
 -1,
 278859947,
 278740865,
 -1,
 278925482,
 278829349,
 -1,
 278991015,
 278889100,
 -1,
 279056548,
 278960608,
 -1,
 -61277,
 279016100,
 119105,
 -1,
 279076592,
 119139,
 279314431,
 278997766,
 -1,
 -61274,
 279212708,
 119103,
 -1,
 279273200,
 119137,
 279511039,
 278923250,
 -1,
 -61271,
 279413073,
 119068,
 -1,
 279466398,
 119067,
 -1,
 278879443,
 119040,
 279711926,
 278800663,
 -1,
 279777461,
 279664662,
 -1,
 279842993,
 279730399,
 -1,
 -61265,
 279811605,
 119229,
 -61264,
 279868068,
 119238,
 -1,
 279910699,
 119230,
 280166399,
 279779973,
 -1,
 -61261,
 280073749,
 119225,
 -61260,
 280130212,
 119236,
 -1,
 280172843,
 119226,
 -1,
 279721814,
 119051,
 280432827,
 279670671,
 -1,
 280498362,
 280387317,
 -1,
 -61255,
 280466965,
 119110,
 -1,
 280500523,
 119111,
 -1,
 280434339,
 119250,
 280760512,
 280377672,
 -1,
 280826047,
 280695798,
 -1,
 -61250,
 280792530,
 119088,
 -1,
 280831793,
 119089,
 -1,
 280782433,
 119045,
 281088194,
 280697792,
 119254,
 -1,
 281019029,
 119259,
 -1,
 281053990,
 119181,
 281284829,
 278737600,
 -1,
 281350348,
 281231233,
 -1,
 281415883,
 281303714,
 -1,
 281481418,
 281359940,
 -1,
 -61240,
 281414200,
 119148,
 -61239,
 281479720,
 119147,
 -1,
 281545243,
 119146,
 -1,
 281415043,
 119042,
 -1,
 281383442,
 119066,
 281874641,
 281305359,
 -1,
 281940176,
 281841681,
 -1,
 -61233,
 281903441,
 119069,
 -1,
 281956766,
 119065,
 -1,
 281901595,
 119185,
 282202325,
 281805296,
 119074,
 282329087,
 282133610,
 -1,
 -61228,
 282204034,
 119076,
 -1,
 282267463,
 119075,
 282464472,
 282169496,
 -1,
 -61225,
 282433045,
 119231,
 -1,
 282466603,
 119232,
 282661083,
 282414315,
 -1,
 -61222,
 282627538,
 119084,
 -1,
 282666801,
 119085,
 282918911,
 282603528,
 119056,
 -1,
 282788253,
 119057,
 282988786,
 281239823,
 -1,
 283054314,
 282949628,
 -1,
 283119842,
 282987035,
 119195,
 -61215,
 283052571,
 119205,
 -1,
 283118105,
 119204,
 -61213,
 283052667,
 119203,
 -61212,
 283249273,
 119202,
 -61211,
 283314796,
 119201,
 -61210,
 283380319,
 119200,
 -61209,
 283445842,
 119199,
 -61208,
 283511365,
 119198,
 -61207,
 283576888,
 119197,
 -1,
 283642408,
 119196,
 283840751,
 283008078,
 -1,
 283906286,
 283771641,
 -1,
 -61203,
 283865764,
 119106,
 -1,
 283926256,
 119140,
 -1,
 283838776,
 119062,
 284229631,
 283806091,
 -1,
 -61199,
 284104578,
 119095,
 -1,
 284168007,
 119094,
 284365059,
 282927490,
 -1,
 284430585,
 284297853,
 -1,
 284496118,
 284383709,
 119220,
 -1,
 284426294,
 119221,
 -61193,
 284458305,
 119044,
 -61192,
 284576615,
 119049,
 -1,
 284623331,
 119050,
 284823805,
 284387207,
 -1,
 -61189,
 284785951,
 119082,
 -61188,
 284832893,
 119083,
 -1,
 284890976,
 119041,
 285085952,
 284785230,
 -1,
 -61185,
 285018664,
 119078,
 -1,
 285084187,
 119077,
 285343743,
 285026583,
 -1,
 -61182,
 285227167,
 119209,
 -1,
 285286450,
 119187,
 285479187,
 284300963,
 -1,
 285544718,
 285438065,
 -1,
 285610251,
 285485335,
 -1,
 285675786,
 285577594,
 -1,
 285741321,
 285624161,
 119224,
 -1,
 285672711,
 119235,
 -1,
 285681943,
 119132,
 -1,
 285611439,
 119058,
 286064639,
 285543328,
 -1,
 -61171,
 285952589,
 119061,
 -1,
 286009623,
 119060,
 286261247,
 285486125,
 -1,
 -61168,
 286164586,
 119157,
 -61167,
 286228283,
 119159,
 -61166,
 286289073,
 119161,
 -1,
 286332861,
 119155,
 286527776,
 285436437,
 -1,
 286593304,
 286482703,
 -1,
 286658839,
 286554484,
 119257,
 -1,
 286589589,
 119258,
 -1,
 286597740,
 119252,
 286855453,
 286533911,
 -1,
 286920988,
 286794244,
 -1,
 -61157,
 286887546,
 119215,
 -1,
 286938795,
 119214,
 -1,
 286882493,
 119261,
 -61154,
 286807238,
 119108,
 -61153,
 287129639,
 119183,
 -1,
 287183716,
 119126,
 287379759,
 286471575,
 -1,
 287445288,
 287338609,
 -1,
 287510821,
 287386686,
 -1,
 -61148,
 287453890,
 119249,
 -1,
 287513424,
 119248,
 287768575,
 287443896,
 -1,
 -61145,
 287670069,
 119188,
 -1,
 287727091,
 119189,
 287904044,
 287375856,
 119070,
 288030719,
 287835242,
 -1,
 -61141,
 287905666,
 119072,
 -1,
 287969095,
 119071,
 288227327,
 287855082,
 -1,
 -61138,
 288132562,
 119217,
 -1,
 288171825,
 119218,
 288362810,
 287331631,
 -1,
 288428340,
 288310485,
 119227,
 288555007,
 288358400,
 -1,
 -61133,
 288453284,
 119237,
 -1,
 288495915,
 119228,
 288690487,
 288384114,
 -1,
 -61130,
 288658965,
 119122,
 -1,
 288692523,
 119123,
 -61128,
 288656561,
 119098,
 -61127,
 288830139,
 119184,
 -1,
 288888419,
 119222,
 289083718,
 288321649,
 -1,
 289149251,
 289024279,
 -1,
 289214786,
 289106758,
 -1,
 289280321,
 289155720,
 -1,
 -61121,
 289212984,
 119055,
 -61120,
 289278504,
 119054,
 -1,
 289344027,
 119053,
 -1,
 289210984,
 119048,
 -1,
 289182403,
 119043,
 289734655,
 289095553,
 -1,
 -61115,
 289627291,
 119180,
 -1,
 289683111,
 119047,
 289870160,
 289024279,
 -1,
 289935693,
 289823688,
 -1,
 -61111,
 289900138,
 119158,
 -61110,
 289963835,
 119160,
 -61109,
 290024625,
 119162,
 -61108,
 290087371,
 119208,
 -1,
 290133949,
 119156,
 290390015,
 289882673,
 -1,
 -61105,
 290288292,
 119102,
 -1,
 290348784,
 119136,
 290525530,
 289828651,
 -1,
 290591063,
 290460768,
 -1,
 290656597,
 290555811,
 -1,
 -61100,
 290618655,
 119090,
 -1,
 290665597,
 119091,
 -61098,
 290615972,
 119101,
 -1,
 290807536,
 119135,
 291045375,
 290538591,
 -1,
 -61095,
 290920322,
 119097,
 -1,
 290983751,
 119096,
 291180897,
 290478754,
 -1,
 291246430,
 291116535,
 -1,
 -61091,
 291212754,
 119086,
 -1,
 291252017,
 119087,
 -61089,
 291212431,
 119129,
 -61088,
 291399470,
 119128,
 -1,
 291449348,
 119207,
 291639655,
 291130189,
 -1,
 291705190,
 291595292,
 119223,
 291831807,
 291635200,
 -1,
 -61083,
 291728363,
 119233,
 -1,
 291783591,
 119234,
 -1,
 291646353,
 119046,
 292032877,
 291584354,
 -1,
 292098412,
 291983509,
 -1,
 -61078,
 292057764,
 119100,
 -61077,
 292121426,
 119216,
 -1,
 292183792,
 119134,
 -1,
 292065169,
 119206,
 292426098,
 292000991,
 -1,
 292491633,
 292371828,
 -1,
 -61072,
 292450980,
 119099,
 -1,
 292511472,
 119133,
 -1,
 292440023,
 119219,
 292753781,
 292393338,
 -1,
 -61068,
 292708929,
 119127,
 -1,
 292767496,
 119251,
 292950392,
 292688891,
 -1,
 -61065,
 292916690,
 119171,
 -1,
 292955953,
 119172,
 -61063,
 292920270,
 119182,
 -61062,
 293116219,
 119107,
 -1,
 293160491,
 119192,
 293404671,
 271712256,
 -1,
 -61059,
 293305637,
 9839,
 -61058,
 293362507,
 9838,
 -1,
 293418114,
 9837,
 293605777,
 271668387,
 -1,
 293671308,
 293563667,
 -1,
 293736843,
 293633575,
 215,
 293863423,
 293666816,
 -1,
 293867912,
 293749718,
 -1,
 -61051,
 293832839,
 10811,
 -61050,
 293893269,
 10805,
 -61049,
 293948908,
 10804,
 -1,
 294004271,
 10807,
 294256639,
 293836497,
 -1,
 -61046,
 294161751,
 10801,
 -1,
 294200663,
 10800,
 -1,
 293706021,
 10005,
 294457744,
 293633198,
 8844,
 294584319,
 294387712,
 -1,
 -61041,
 294489465,
 8846,
 -1,
 294541881,
 8845,
 -1,
 294409875,
 8888,
 294846463,
 293543155,
 -1,
 -61037,
 294735815,
 8810,
 -1,
 294795252,
 8811,
 294982318,
 271606031,
 -1,
 295047770,
 294935202,
 -1,
 295113305,
 294991727,
 -1,
 295178807,
 295063620,
 -1,
 295244221,
 295142028,
 -1,
 295309755,
 295199155,
 -1,
 295375263,
 295242365,
 -1,
 295440798,
 295325900,
 -1,
 -61027,
 295410731,
 6297,
 -1,
 295469780,
 6296,
 -1,
 295394469,
 6218,
 295702945,
 295340788,
 6215,
 -1,
 295643415,
 6217,
 295834020,
 295666316,
 -1,
 -61021,
 295795402,
 6228,
 -1,
 295832189,
 6224,
 296030630,
 295788815,
 6214,
 -1,
 295971095,
 6216,
 296161705,
 295979181,
 -1,
 -61016,
 296107997,
 6234,
 -1,
 296159869,
 6227,
 296358315,
 296105372,
 6222,
 -1,
 296290941,
 6232,
 296489390,
 296296834,
 -1,
 -61011,
 296459226,
 6236,
 -1,
 296487549,
 6225,
 -61009,
 296458730,
 6229,
 -61008,
 296654070,
 6230,
 -61007,
 296709836,
 6221,
 -61006,
 296774202,
 6220,
 -61005,
 296836381,
 6235,
 -61004,
 296899896,
 6223,
 -61003,
 296964948,
 6211,
 -61002,
 297028005,
 6231,
 -61001,
 297090945,
 6213,
 -61000,
 297154917,
 6233,
 -60999,
 297216279,
 6212,
 -60998,
 297278711,
 6226,
 -1,
 297342629,
 6219,
 -60996,
 295271114,
 6204,
 -1,
 297470589,
 6194,
 297669090,
 295176829,
 6176,
 297734625,
 297619660,
 -1,
 297800133,
 297697932,
 -1,
 297865667,
 297763468,
 -1,
 -60990,
 297810274,
 6285,
 -1,
 297863805,
 6284,
 -60988,
 297811630,
 6278,
 -1,
 297994877,
 6288,
 298193354,
 297738626,
 -1,
 298258889,
 298125949,
 6289,
 -60984,
 298210998,
 6274,
 -1,
 298268074,
 6313,
 -1,
 298197462,
 6286,
 298521037,
 298125949,
 6279,
 -60980,
 298475657,
 6272,
 -1,
 298531144,
 6295,
 298717648,
 298490830,
 -1,
 -60977,
 298662242,
 6293,
 -1,
 298715773,
 6294,
 298914259,
 298674709,
 -1,
 -60974,
 298858850,
 6291,
 -1,
 298912381,
 6290,
 299110870,
 298867362,
 -1,
 -60971,
 299064034,
 6287,
 -1,
 299120028,
 6282,
 299307480,
 299057025,
 6280,
 -1,
 299262121,
 6276,
 299438555,
 299252272,
 -1,
 -60966,
 299407850,
 6311,
 -1,
 299469556,
 6310,
 -60964,
 299406402,
 6273,
 -60963,
 299600665,
 6275,
 -60962,
 299663515,
 6292,
 -60961,
 299714981,
 6281,
 -60960,
 299768706,
 6283,
 -1,
 299833088,
 6277,
 -1,
 297688229,
 6185,
 300093950,
 297630347,
 -1,
 300159484,
 300040243,
 -1,
 300224999,
 300129230,
 -1,
 -60954,
 300169570,
 6258,
 -1,
 300223101,
 6255,
 300421609,
 300190452,
 6241,
 -1,
 300362007,
 6240,
 300552684,
 300384908,
 -1,
 -60949,
 300513994,
 6254,
 -1,
 300550781,
 6248,
 300749294,
 300498817,
 6238,
 -1,
 300718547,
 6239,
 300880368,
 300693858,
 6245,
 -1,
 300812925,
 6253,
 301011442,
 300823964,
 6244,
 -1,
 300943997,
 6252,
 -60941,
 300973306,
 6247,
 -60940,
 301101225,
 6256,
 -60939,
 301165114,
 6246,
 -60938,
 301222309,
 6243,
 -60937,
 301287613,
 6250,
 -60936,
 301347558,
 6251,
 -60935,
 301410583,
 6237,
 -60934,
 301474262,
 6249,
 -60933,
 301538551,
 6257,
 -1,
 301600989,
 6242,
 -60931,
 300104034,
 6193,
 -1,
 301730429,
 6192,
 301928983,
 300045624,
 6190,
 302055423,
 301882256,
 -1,
 302060050,
 301928115,
 -1,
 302125572,
 302029774,
 -1,
 -60925,
 302070114,
 6308,
 -1,
 302123645,
 6309,
 302322183,
 302088844,
 -1,
 -60922,
 302285524,
 6302,
 -1,
 302320253,
 6304,
 302518794,
 302260610,
 -1,
 -60919,
 302463330,
 6305,
 -1,
 302523206,
 6303,
 302715405,
 302455626,
 -1,
 -60916,
 302684650,
 6307,
 -1,
 302713469,
 6300,
 -60914,
 302678171,
 6306,
 -60913,
 302865597,
 6299,
 -60912,
 302926174,
 6301,
 -60911,
 302986845,
 6298,
 -1,
 303044794,
 6312,
 -60909,
 302029867,
 6263,
 -60908,
 303198357,
 6261,
 -60907,
 303253925,
 6260,
 -60906,
 303316865,
 6259,
 -1,
 303379174,
 6262,
 303567387,
 301898702,
 -1,
 -60903,
 303526037,
 6207,
 -60902,
 303578181,
 6209,
 -1,
 303630973,
 6205,
 303829533,
 303532788,
 6180,
 -1,
 303769879,
 6182,
 303960607,
 303784207,
 6179,
 -1,
 303900951,
 6181,
 304091682,
 303909709,
 -1,
 -60895,
 304036194,
 6208,
 -1,
 304089725,
 6191,
 304288293,
 304040355,
 -1,
 -60892,
 304232802,
 6203,
 -1,
 304286333,
 6202,
 304484903,
 304228631,
 6177,
 -1,
 304425239,
 6183,
 304615978,
 304422128,
 -1,
 -60887,
 304562049,
 6210,
 -1,
 304614013,
 6196,
 -60885,
 304585194,
 6198,
 -60884,
 304780534,
 6200,
 -60883,
 304836757,
 6199,
 -60882,
 304901836,
 6188,
 -60881,
 304966202,
 6187,
 -60880,
 305027810,
 6184,
 -60879,
 305088701,
 6197,
 -60878,
 305151873,
 6178,
 -60877,
 305215845,
 6206,
 -60876,
 305280412,
 6189,
 -60875,
 305345254,
 6201,
 -60874,
 305406422,
 6195,
 -1,
 305469093,
 6186,
 305664581,
 295117846,
 -1,
 305730107,
 305627788,
 -1,
 -60870,
 305698969,
 6162,
 -1,
 305741475,
 6163,
 305926718,
 305691275,
 -1,
 -60867,
 305875089,
 6166,
 -1,
 305934799,
 6167,
 306123329,
 305869504,
 -1,
 -60864,
 306079741,
 6164,
 -1,
 306137154,
 6165,
 -60862,
 306093086,
 6160,
 -60861,
 306275258,
 6161,
 -60860,
 306339148,
 6169,
 -1,
 306392218,
 6168,
 306582093,
 305607360,
 -1,
 306647627,
 306541123,
 -1,
 306713162,
 306610828,
 -1,
 -60855,
 306682009,
 6156,
 -1,
 306724515,
 6157,
 -1,
 306668474,
 6155,
 -60852,
 306613404,
 6147,
 -1,
 306931713,
 6149,
 307106384,
 306534008,
 -1,
 -60849,
 307049850,
 6153,
 -1,
 307109636,
 6152,
 307302995,
 307044076,
 -1,
 -60846,
 307255575,
 6146,
 -1,
 307319564,
 6148,
 -60844,
 307270833,
 6158,
 -60843,
 307464078,
 6150,
 -60842,
 307527132,
 6151,
 -60841,
 307584382,
 6154,
 -60840,
 307637563,
 6145,
 -1,
 307697926,
 6144,
 -1,
 295069393,
 9101,
 308019199,
 294986114,
 -1,
 308023980,
 307904886,
 -1,
 308089451,
 307986244,
 -1,
 308154975,
 308054532,
 692,
 -1,
 308086565,
 693,
 308286049,
 308113521,
 691,
 -1,
 308228633,
 740,
 308417123,
 308230472,
 688,
 -1,
 308348709,
 689,
 -60828,
 308386259,
 696,
 -60827,
 308517157,
 739,
 -60826,
 308581599,
 695,
 -60825,
 308640395,
 738,
 -60824,
 308693837,
 737,
 -60823,
 308758701,
 690,
 -60822,
 308819388,
 736,
 -1,
 308878359,
 694,
 309072501,
 308038477,
 -1,
 309138034,
 309029182,
 -1,
 -60818,
 309105548,
 716,
 -60817,
 309168041,
 744,
 -60816,
 309220667,
 717,
 -60815,
 309278695,
 718,
 -1,
 309333017,
 719,
 309592063,
 309078833,
 -1,
 -60812,
 309475943,
 703,
 -1,
 309531718,
 706,
 309727869,
 309031025,
 -1,
 309793401,
 309674503,
 -1,
 -60808,
 309738087,
 702,
 -1,
 309793862,
 707,
 309990012,
 309735942,
 -1,
 -60805,
 309933863,
 705,
 -1,
 309993220,
 701,
 -1,
 309935737,
 734,
 310252164,
 309667057,
 -1,
 310317697,
 310220904,
 -1,
 -60800,
 310280944,
 725,
 -1,
 310318150,
 709,
 310575103,
 310283074,
 -1,
 -60797,
 310472279,
 698,
 -1,
 310514285,
 750,
 310710922,
 310188874,
 -1,
 310776456,
 310652668,
 -1,
 -60793,
 310736039,
 722,
 -1,
 310791677,
 723,
 -60791,
 310737044,
 735,
 -1,
 310920922,
 710,
 311104143,
 310676212,
 -1,
 311169678,
 311061015,
 -1,
 -60787,
 311132912,
 724,
 -1,
 311170118,
 708,
 -1,
 311122746,
 749,
 311431828,
 311055663,
 -1,
 311497363,
 311377793,
 -1,
 -60782,
 311451768,
 727,
 -1,
 311501240,
 743,
 -1,
 311430149,
 713,
 311759511,
 311400915,
 -1,
 -60778,
 311706606,
 746,
 -1,
 311759073,
 747,
 311956122,
 311726458,
 -1,
 -60775,
 311910970,
 748,
 -1,
 311963702,
 712,
 312152733,
 311919244,
 -1,
 -60772,
 312119355,
 699,
 -1,
 312177597,
 720,
 312349344,
 312109589,
 -1,
 -60769,
 312309442,
 697,
 -1,
 312366291,
 726,
 312545955,
 312293704,
 -1,
 -60766,
 312492533,
 742,
 -1,
 312544902,
 721,
 312742566,
 312489367,
 -1,
 -60763,
 312701264,
 715,
 -1,
 312759256,
 704,
 312939177,
 312685203,
 -1,
 -60760,
 312890373,
 745,
 -1,
 312949918,
 741,
 313196543,
 312871549,
 -1,
 -60757,
 313093566,
 700,
 -1,
 313139557,
 714,
 -60755,
 307989669,
 10762,
 -1,
 313273668,
 8871,
 313463576,
 294951419,
 -1,
 313529070,
 313413700,
 -1,
 313594551,
 313481890,
 -1,
 313660084,
 313547426,
 -1,
 -60749,
 313629162,
 4106,
 -1,
 313657981,
 4111,
 -60747,
 313629162,
 4105,
 -60746,
 313800092,
 4100,
 -1,
 313854589,
 4116,
 314053308,
 313562219,
 -1,
 314118842,
 314011761,
 4178,
 -1,
 314077297,
 4179,
 314310655,
 314067789,
 4180,
 -1,
 314198861,
 4181,
 314380994,
 314016396,
 -1,
 314446528,
 314344076,
 -1,
 -60737,
 314390882,
 4108,
 -1,
 314444413,
 4107,
 -60735,
 314390882,
 4113,
 -1,
 314575485,
 4112,
 314774216,
 314319234,
 -1,
 314839750,
 314712450,
 -1,
 -60731,
 314784098,
 4110,
 -1,
 314837629,
 4109,
 -60729,
 314784098,
 4115,
 -1,
 314968701,
 4114,
 315167436,
 314735243,
 -1,
 -60726,
 315128522,
 4177,
 -60725,
 315177314,
 4176,
 -1,
 315230845,
 4126,
 315429582,
 315132660,
 4133,
 -1,
 315394804,
 4134,
 315560657,
 315386389,
 -1,
 -60720,
 315504994,
 4118,
 -1,
 315558525,
 4117,
 315757268,
 315509581,
 -1,
 -60717,
 315706252,
 4128,
 -1,
 315755133,
 4124,
 315953879,
 315705763,
 -1,
 -60714,
 315898210,
 4097,
 -1,
 315951741,
 4096,
 316150490,
 315902125,
 -1,
 -60711,
 316094818,
 4104,
 -1,
 316148349,
 4103,
 316347100,
 316096385,
 4131,
 -1,
 316292993,
 4132,
 316478175,
 316290455,
 -1,
 -60706,
 316422498,
 4099,
 -1,
 316476029,
 4098,
 316674786,
 316414794,
 -1,
 -60703,
 316619106,
 4102,
 -1,
 316672637,
 4101,
 316871397,
 316610211,
 -1,
 -60700,
 316815714,
 4120,
 -1,
 316869245,
 4119,
 317068007,
 316803709,
 4129,
 -1,
 317033204,
 4138,
 -60696,
 317037034,
 4122,
 -60695,
 317166838,
 4125,
 -60694,
 317223061,
 4123,
 -60693,
 317284623,
 4137,
 -60692,
 317347128,
 4121,
 -60691,
 317405538,
 4127,
 -1,
 317466903,
 4135,
 317657852,
 313496769,
 -1,
 317723380,
 317625451,
 -1,
 317788914,
 317681777,
 4182,
 -1,
 317747313,
 4183,
 317980671,
 317737805,
 4184,
 -1,
 317868877,
 4185,
 318051062,
 317688564,
 4143,
 -1,
 318016244,
 4144,
 318182136,
 317996929,
 4141,
 -1,
 318128001,
 4142,
 318313211,
 318114429,
 -1,
 -60678,
 318259073,
 4146,
 -1,
 318311037,
 4140,
 -1,
 318253335,
 4145,
 318575370,
 317618827,
 -1,
 318640901,
 318521992,
 -1,
 318706433,
 318608367,
 -1,
 -60672,
 318667591,
 4152,
 -1,
 318730508,
 4153,
 -60670,
 318667748,
 4171,
 -60669,
 318853627,
 4170,
 -60668,
 318907745,
 4151,
 -1,
 318968297,
 4150,
 319225855,
 318610183,
 -1,
 -60665,
 319115993,
 4172,
 -60664,
 319174199,
 4175,
 -60663,
 319233869,
 4173,
 -1,
 319294645,
 4174,
 319553535,
 318514198,
 -1,
 319558414,
 319455884,
 -1,
 -60659,
 319527065,
 4162,
 -1,
 319569571,
 4163,
 319755025,
 319519371,
 -1,
 -60656,
 319703185,
 4166,
 -1,
 319762895,
 4167,
 319951636,
 319697600,
 -1,
 -60653,
 319907837,
 4164,
 -1,
 319965250,
 4165,
 -60651,
 319921182,
 4160,
 -60650,
 320103354,
 4161,
 -60649,
 320167244,
 4169,
 -1,
 320220314,
 4168,
 320410430,
 313403671,
 -1,
 320475948,
 320345450,
 -1,
 320541482,
 320409894,
 8737,
 320667647,
 320471040,
 -1,
 320672553,
 320575442,
 -1,
 320738080,
 320638425,
 -1,
 -60641,
 320697299,
 10664,
 -1,
 320753012,
 10665,
 320934691,
 320697312,
 -1,
 -60638,
 320900562,
 10668,
 -1,
 320939825,
 10670,
 321131302,
 320884095,
 -1,
 -60635,
 321097170,
 10669,
 -1,
 321136433,
 10671,
 321388543,
 321070908,
 -1,
 -60632,
 321287123,
 10666,
 -1,
 321342836,
 10667,
 -1,
 320627959,
 10651,
 -60629,
 320500715,
 10653,
 -1,
 321526560,
 8798,
 321721149,
 320414867,
 -1,
 321786674,
 321680339,
 -1,
 321852209,
 321716224,
 -1,
 -60624,
 321809109,
 10089,
 -1,
 321855756,
 10101,
 -1,
 321784219,
 10093,
 322114359,
 321736052,
 -1,
 322179894,
 322043904,
 -1,
 -60619,
 322136789,
 10088,
 -1,
 322183436,
 10100,
 -1,
 322111899,
 10092,
 322442042,
 322057356,
 -1,
 -60615,
 322401519,
 10091,
 -1,
 322457152,
 10090,
 -60613,
 322409202,
 10073,
 -60612,
 322600195,
 9618,
 -1,
 322655945,
 8287,
 -1,
 321679762,
 9791,
 322961407,
 320356225,
 -1,
 322966349,
 322853538,
 -1,
 323031884,
 322932885,
 -1,
 323097419,
 322961408,
 -1,
 323162954,
 323059239,
 8722,
 323289087,
 323092480,
 -1,
 323294025,
 323196625,
 -1,
 -60602,
 323254124,
 10796,
 -60601,
 323302184,
 10795,
 -60600,
 323364193,
 10794,
 -1,
 323428106,
 10793,
 -1,
 323240993,
 10810,
 -1,
 323126927,
 8770,
 -1,
 323029340,
 8723,
 -1,
 323000787,
 10751,
 323883856,
 322904450,
 -1,
 -60593,
 323834245,
 8943,
 -1,
 323888357,
 183,
 -60591,
 323834408,
 8357,
 -1,
 324018277,
 181,
 324212835,
 193632723,
 -1,
 324278370,
 324157313,
 -1,
 324343905,
 324206592,
 -1,
 324409363,
 324305445,
 -1,
 324473883,
 324360866,
 -1,
 324539253,
 324443086,
 -1,
 324604767,
 324504308,
 41727,
 324670299,
 324563057,
 41730,
 -1,
 324639013,
 41729,
 324801373,
 324624655,
 41721,
 -1,
 324770085,
 41720,
 -60578,
 324770085,
 41726,
 -1,
 324889109,
 41728,
 325063526,
 324550529,
 41711,
 325129059,
 325003543,
 41714,
 -60574,
 325097765,
 41713,
 -1,
 325151253,
 41715,
 -60572,
 325097765,
 41710,
 -60571,
 325288588,
 41709,
 -1,
 325347861,
 41712,
 325522284,
 325032403,
 41733,
 325587817,
 325480561,
 41736,
 -1,
 325556517,
 41735,
 -60566,
 325556517,
 41732,
 -60565,
 325681804,
 41731,
 -1,
 325741077,
 41734,
 325915504,
 325454461,
 41718,
 -60562,
 325884197,
 41717,
 -60561,
 325943948,
 41716,
 -1,
 326003221,
 41719,
 326177651,
 325869839,
 -1,
 -60558,
 326146341,
 41722,
 -1,
 326199829,
 41723,
 326434815,
 326117655,
 41725,
 -1,
 326342949,
 41724,
 326505361,
 324474531,
 -1,
 326570877,
 326451073,
 41080,
 326636410,
 326510871,
 41083,
 -60551,
 326605093,
 41082,
 -1,
 326658581,
 41084,
 -60549,
 326605093,
 41079,
 -60548,
 326795916,
 41078,
 -1,
 326855189,
 41081,
 327029635,
 326539731,
 41101,
 327095168,
 326987889,
 41104,
 -1,
 327063845,
 41103,
 -60543,
 327063845,
 41100,
 -60542,
 327189132,
 41099,
 -1,
 327248405,
 41102,
 327422857,
 326994676,
 41095,
 327488390,
 327381105,
 41098,
 -1,
 327457061,
 41097,
 -60537,
 327457061,
 41094,
 -60536,
 327582348,
 41093,
 -1,
 327641621,
 41096,
 327816077,
 327377167,
 41091,
 -60533,
 327784741,
 41090,
 -60532,
 327844492,
 41089,
 -1,
 327903765,
 41092,
 328138751,
 327748221,
 41087,
 -60529,
 328046885,
 41086,
 -60528,
 328106636,
 41085,
 -1,
 328165909,
 41088,
 328340395,
 326453421,
 -1,
 328405914,
 328286081,
 42035,
 328471447,
 328345879,
 42039,
 -60523,
 328440101,
 42038,
 -60522,
 328499852,
 42037,
 -1,
 328559125,
 42040,
 -60520,
 328440101,
 42034,
 -60519,
 328696460,
 42033,
 -1,
 328755733,
 42036,
 328930209,
 328370932,
 42048,
 328995741,
 328888433,
 42051,
 -1,
 328964389,
 42050,
 329126815,
 328950031,
 42042,
 -1,
 329095461,
 42041,
 -60512,
 329095461,
 42047,
 -1,
 329214485,
 42049,
 329388967,
 328899027,
 42054,
 329454500,
 329347185,
 42057,
 -1,
 329423141,
 42056,
 -60507,
 329423141,
 42053,
 -60506,
 329548428,
 42052,
 -1,
 329607701,
 42055,
 329842687,
 329343247,
 42045,
 -60503,
 329750821,
 42044,
 -60502,
 329810572,
 42043,
 -1,
 329869845,
 42046,
 330044355,
 328298609,
 -1,
 330109874,
 330013139,
 41895,
 330175407,
 330068081,
 41898,
 -1,
 330144037,
 41897,
 -60496,
 330144037,
 41894,
 -60495,
 330269324,
 41893,
 -1,
 330328597,
 41896,
 330503096,
 330074868,
 41889,
 330568629,
 330461297,
 41892,
 -1,
 330537253,
 41891,
 -60490,
 330537253,
 41888,
 -60489,
 330662540,
 41887,
 -1,
 330721813,
 41890,
 330896316,
 330443031,
 41885,
 -60486,
 330864933,
 41884,
 -60485,
 330924684,
 41883,
 -1,
 330983957,
 41886,
 331158464,
 330828413,
 41878,
 -60482,
 331127077,
 41877,
 -60481,
 331186828,
 41876,
 -1,
 331246101,
 41879,
 331481087,
 331112719,
 41881,
 -60478,
 331389221,
 41880,
 -1,
 331442709,
 41882,
 331617243,
 329982338,
 -1,
 331682762,
 331582196,
 41316,
 331748295,
 331640945,
 41319,
 -1,
 331716901,
 41318,
 -60472,
 331716901,
 41315,
 -60471,
 331842188,
 41314,
 -1,
 331901461,
 41317,
 332075984,
 331628417,
 41299,
 332141517,
 332015895,
 41302,
 -1,
 332110117,
 41301,
 -60466,
 332110117,
 41298,
 -60465,
 332235404,
 41297,
 -1,
 332294677,
 41300,
 332469204,
 332030223,
 41309,
 -60462,
 332437797,
 41308,
 -60461,
 332497548,
 41307,
 -1,
 332556821,
 41310,
 332731352,
 332401277,
 41305,
 -60458,
 332699941,
 41304,
 -60457,
 332759692,
 41303,
 -1,
 332818965,
 41306,
 333053951,
 332671255,
 41312,
 -60454,
 332962085,
 41311,
 -1,
 333015573,
 41313,
 333190127,
 331586003,
 -1,
 333255652,
 333135745,
 42060,
 333321185,
 333195543,
 42064,
 -60449,
 333289765,
 42063,
 -60448,
 333349516,
 42062,
 -1,
 333408789,
 42065,
 -60446,
 333289765,
 42059,
 -60445,
 333546124,
 42058,
 -1,
 333605397,
 42061,
 333779947,
 333220596,
 42075,
 333845480,
 333734159,
 42067,
 -60441,
 333814053,
 42066,
 -1,
 333867541,
 42068,
 -60439,
 333814053,
 42074,
 -60438,
 334004876,
 42073,
 -1,
 334064149,
 42076,
 334299135,
 333734159,
 42071,
 -60435,
 334207269,
 42070,
 -60434,
 334267020,
 42069,
 -1,
 334326293,
 42072,
 334500865,
 333133207,
 -1,
 334566388,
 334455055,
 41577,
 -60430,
 334534949,
 41576,
 -60429,
 334594700,
 41575,
 -1,
 334653973,
 41578,
 334828536,
 334498429,
 41570,
 -60426,
 334797093,
 41569,
 -60425,
 334856844,
 41568,
 -1,
 334916117,
 41571,
 335090683,
 334794183,
 41574,
 -60422,
 335059237,
 41573,
 -1,
 335118988,
 41572,
 335287294,
 335036763,
 41566,
 -60419,
 335255845,
 41565,
 -1,
 335309333,
 41567,
 335544319,
 335227159,
 41580,
 -60416,
 335452453,
 41579,
 -1,
 335505941,
 41581,
 335680522,
 334465780,
 41363,
 335746053,
 335634703,
 41352,
 -60412,
 335714597,
 41351,
 -1,
 335768085,
 41353,
 335942663,
 335704177,
 41366,
 -1,
 335911205,
 41365,
 -60408,
 335911205,
 41362,
 -60407,
 336036492,
 41361,
 -1,
 336095765,
 41364,
 336270353,
 335626113,
 41343,
 336335886,
 336210199,
 41346,
 -60403,
 336304421,
 41345,
 -1,
 336357909,
 41347,
 -60401,
 336304421,
 41342,
 -60400,
 336495244,
 41341,
 -1,
 336554517,
 41344,
 336729109,
 336224527,
 41356,
 -60397,
 336697637,
 41355,
 -60396,
 336757388,
 41354,
 -1,
 336816661,
 41357,
 336991256,
 336668951,
 41359,
 -60393,
 336959781,
 41358,
 -1,
 337013269,
 41360,
 337248255,
 336923261,
 41349,
 -60390,
 337156389,
 41348,
 -1,
 337209877,
 41350,
 337384606,
 324417864,
 -1,
 337450045,
 337333069,
 -1,
 337515558,
 337414900,
 41389,
 337581089,
 337469711,
 41379,
 -60384,
 337549605,
 41378,
 -1,
 337603093,
 41380,
 337777699,
 337539185,
 41392,
 -1,
 337746213,
 41391,
 -60380,
 337746213,
 41388,
 -60379,
 337871500,
 41387,
 -1,
 337930773,
 41390,
 338105389,
 337461121,
 41369,
 338170922,
 338045207,
 41372,
 -60375,
 338139429,
 41371,
 -1,
 338192917,
 41373,
 -60373,
 338139429,
 41368,
 -60372,
 338330252,
 41367,
 -1,
 338389525,
 41370,
 338564147,
 338074067,
 41395,
 338629680,
 338522225,
 41398,
 -1,
 338598181,
 41397,
 -60367,
 338598181,
 41394,
 -60366,
 338723468,
 41393,
 -1,
 338782741,
 41396,
 338957367,
 338496125,
 41376,
 -60363,
 338925861,
 41375,
 -60362,
 338985612,
 41374,
 -1,
 339044885,
 41377,
 339219514,
 338911503,
 41382,
 -60359,
 339188005,
 41381,
 -1,
 339241493,
 41383,
 339476479,
 339159319,
 41385,
 -60356,
 339384613,
 41384,
 -1,
 339438101,
 41386,
 339612763,
 337401135,
 -1,
 339678279,
 339577588,
 41125,
 339743810,
 339632399,
 41117,
 -60351,
 339712293,
 41116,
 -1,
 339765781,
 41118,
 339940420,
 339701873,
 41128,
 -1,
 339908901,
 41127,
 -60347,
 339908901,
 41124,
 -60346,
 340034188,
 41123,
 -1,
 340093461,
 41126,
 340268110,
 339623809,
 41107,
 340333643,
 340207895,
 41110,
 -60342,
 340302117,
 41109,
 -1,
 340355605,
 41111,
 -60340,
 340302117,
 41106,
 -60339,
 340492940,
 41105,
 -1,
 340552213,
 41108,
 340726867,
 340236755,
 41130,
 340792401,
 340684913,
 41133,
 -1,
 340760869,
 41132,
 -60334,
 340760869,
 41129,
 -1,
 340879893,
 41131,
 341054551,
 340680975,
 41121,
 -60331,
 341023013,
 41120,
 -60330,
 341082764,
 41119,
 -1,
 341142037,
 41122,
 341377023,
 340986493,
 41114,
 -60327,
 341285157,
 41113,
 -60326,
 341344908,
 41112,
 -1,
 341404181,
 41115,
 341578867,
 339581221,
 -1,
 341644388,
 341524353,
 41544,
 341709921,
 341584151,
 41548,
 -60321,
 341678373,
 41547,
 -60320,
 341738124,
 41546,
 -1,
 341797397,
 41549,
 -60318,
 341678373,
 41543,
 -60317,
 341934732,
 41542,
 -1,
 341994005,
 41545,
 342168680,
 341609927,
 41556,
 -60314,
 342137125,
 41555,
 -60313,
 342196876,
 41554,
 -1,
 342256149,
 41557,
 342430828,
 342122767,
 41560,
 -60310,
 342399269,
 41559,
 -60309,
 342459020,
 41558,
 -1,
 342518293,
 41561,
 342692976,
 342362749,
 41552,
 -60306,
 342661413,
 41551,
 -60305,
 342721164,
 41550,
 -1,
 342780437,
 41553,
 343015423,
 342632727,
 41563,
 -60302,
 342923557,
 41562,
 -1,
 342977045,
 41564,
 343151755,
 341531298,
 -1,
 343217276,
 343097217,
 41322,
 343282809,
 343157015,
 41326,
 -60297,
 343251237,
 41325,
 -60296,
 343310988,
 41324,
 -1,
 343370261,
 41327,
 -60294,
 343251237,
 41321,
 -60293,
 343507596,
 41320,
 -1,
 343566869,
 41323,
 343741568,
 343149181,
 41330,
 -60290,
 343709989,
 41329,
 -60289,
 343769740,
 41328,
 -1,
 343829013,
 41331,
 344003716,
 343706356,
 -1,
 344069251,
 343957775,
 41333,
 -1,
 344037669,
 41332,
 -1,
 344031884,
 41340,
 344265864,
 343957775,
 -1,
 -60282,
 344234277,
 41335,
 -60281,
 344294028,
 41334,
 -1,
 344353301,
 41336,
 344588287,
 344205591,
 41338,
 -60278,
 344496421,
 41337,
 -1,
 344549909,
 41339,
 344724623,
 343117255,
 41591,
 -60275,
 344693029,
 41590,
 -60274,
 344752780,
 41589,
 -1,
 344812053,
 41592,
 344986771,
 344678671,
 41595,
 -60271,
 344955173,
 41594,
 -60270,
 345014924,
 41593,
 -1,
 345074197,
 41596,
 345248919,
 344918653,
 41587,
 -60267,
 345217317,
 41586,
 -60266,
 345277068,
 41585,
 -1,
 345336341,
 41588,
 345511067,
 345194369,
 -1,
 345576602,
 345450775,
 41584,
 -1,
 345544997,
 41583,
 -1,
 345539212,
 41582,
 345833471,
 345450775,
 41598,
 -60259,
 345741605,
 41597,
 -1,
 345795093,
 41599,
 345969914,
 337353678,
 -1,
 346035389,
 345938894,
 -1,
 346100904,
 345980801,
 41682,
 346166437,
 346040599,
 41686,
 -60253,
 346134821,
 41685,
 -60252,
 346194572,
 41684,
 -1,
 346253845,
 41687,
 -60250,
 346134821,
 41681,
 -60249,
 346391180,
 41680,
 -1,
 346450453,
 41683,
 346625198,
 346069459,
 41705,
 346690731,
 346583153,
 41708,
 -1,
 346659109,
 41707,
 -60244,
 346659109,
 41704,
 -60243,
 346784396,
 41703,
 -1,
 346843669,
 41706,
 347018419,
 346589940,
 41699,
 347083953,
 346976369,
 41702,
 -1,
 347052325,
 41701,
 -60238,
 347052325,
 41698,
 -1,
 347171349,
 41700,
 347346103,
 346950269,
 41690,
 -60235,
 347314469,
 41689,
 -60234,
 347374220,
 41688,
 -1,
 347433493,
 41691,
 347608250,
 347300111,
 41693,
 -60231,
 347576613,
 41692,
 -1,
 347630101,
 41694,
 347865087,
 347547927,
 41696,
 -60228,
 347773221,
 41695,
 -1,
 347826709,
 41697,
 348001497,
 345979208,
 -1,
 348067015,
 347966196,
 41815,
 348132546,
 348021007,
 41803,
 -60223,
 348100901,
 41802,
 -1,
 348154389,
 41804,
 348329156,
 348090481,
 41818,
 -1,
 348297509,
 41817,
 -60219,
 348297509,
 41814,
 -60218,
 348422796,
 41813,
 -1,
 348482069,
 41816,
 348656845,
 348035539,
 41821,
 348722378,
 348614769,
 41824,
 -1,
 348690725,
 41823,
 -60213,
 348690725,
 41820,
 -60212,
 348816012,
 41819,
 -1,
 348875285,
 41822,
 349050065,
 348610831,
 41807,
 -60209,
 349018405,
 41806,
 -60208,
 349078156,
 41805,
 -1,
 349137429,
 41808,
 349312213,
 348989719,
 41811,
 -60205,
 349280549,
 41810,
 -60204,
 349340300,
 41809,
 -1,
 349399573,
 41812,
 349634559,
 349244029,
 41800,
 -60201,
 349542693,
 41799,
 -60200,
 349602444,
 41798,
 -1,
 349661717,
 41801,
 349836514,
 347966196,
 41636,
 349902045,
 349790479,
 41625,
 -60196,
 349870373,
 41624,
 -1,
 349923861,
 41626,
 350098655,
 349859953,
 41639,
 -1,
 350066981,
 41638,
 -60192,
 350066981,
 41635,
 -60191,
 350192268,
 41634,
 -1,
 350251541,
 41637,
 350426345,
 349781889,
 41615,
 350491878,
 350365975,
 41618,
 -60187,
 350460197,
 41617,
 -1,
 350513685,
 41619,
 -60185,
 350460197,
 41614,
 -60184,
 350651020,
 41613,
 -1,
 350710293,
 41616,
 350885103,
 350394835,
 41642,
 350950636,
 350842993,
 41645,
 -1,
 350918949,
 41644,
 -60179,
 350918949,
 41641,
 -60178,
 351044236,
 41640,
 -1,
 351103509,
 41643,
 351278323,
 350839055,
 41629,
 -60175,
 351246629,
 41628,
 -60174,
 351306380,
 41627,
 -1,
 351365653,
 41630,
 351540471,
 351210109,
 41622,
 -60171,
 351508773,
 41621,
 -60170,
 351568524,
 41620,
 -1,
 351627797,
 41623,
 351862783,
 351480087,
 41632,
 -60167,
 351770917,
 41631,
 -1,
 351824405,
 41633,
 351999317,
 345930379,
 -1,
 352064792,
 351959691,
 -1,
 352130307,
 352010113,
 41772,
 352195840,
 352069911,
 41775,
 -60161,
 352164133,
 41774,
 -1,
 352217621,
 41776,
 -60159,
 352164133,
 41771,
 -60158,
 352354956,
 41770,
 -1,
 352414229,
 41773,
 352589065,
 352098771,
 41794,
 352654598,
 352546929,
 41797,
 -1,
 352622885,
 41796,
 -60153,
 352622885,
 41793,
 -60152,
 352748172,
 41792,
 -1,
 352807445,
 41795,
 352982285,
 352553716,
 41790,
 -60149,
 352950565,
 41789,
 -60148,
 353010316,
 41788,
 -1,
 353069589,
 41791,
 353244433,
 352936207,
 41783,
 -60145,
 353212709,
 41782,
 -60144,
 353272460,
 41781,
 -1,
 353331733,
 41784,
 353506581,
 353176189,
 41779,
 -60141,
 353474853,
 41778,
 -60140,
 353534604,
 41777,
 -1,
 353593877,
 41780,
 353828863,
 353446167,
 41786,
 -60137,
 353736997,
 41785,
 -1,
 353790485,
 41787,
 353965364,
 352008520,
 -1,
 354030882,
 353929972,
 41916,
 354096413,
 353984783,
 41904,
 -60132,
 354064677,
 41903,
 -1,
 354118165,
 41905,
 354293023,
 354054257,
 41919,
 -1,
 354261285,
 41918,
 -60128,
 354261285,
 41915,
 -60127,
 354386572,
 41914,
 -1,
 354445845,
 41917,
 354620712,
 353999315,
 41922,
 354686245,
 354578545,
 41925,
 -1,
 354654501,
 41924,
 -60122,
 354654501,
 41921,
 -60121,
 354779788,
 41920,
 -1,
 354839061,
 41923,
 355013932,
 354574607,
 41908,
 -60118,
 354982181,
 41907,
 -60117,
 355041932,
 41906,
 -1,
 355101205,
 41909,
 355276080,
 354953495,
 41912,
 -60114,
 355244325,
 41911,
 -60113,
 355304076,
 41910,
 -1,
 355363349,
 41913,
 355598335,
 355207805,
 41901,
 -60110,
 355506469,
 41900,
 -60109,
 355566220,
 41899,
 -1,
 355625493,
 41902,
 355800381,
 353929972,
 41760,
 355865912,
 355754255,
 41749,
 -60105,
 355834149,
 41748,
 -1,
 355887637,
 41750,
 356062522,
 355823729,
 41763,
 -1,
 356030757,
 41762,
 -60101,
 356030757,
 41759,
 -60100,
 356156044,
 41758,
 -1,
 356215317,
 41761,
 356390212,
 355745665,
 41739,
 356455745,
 356329751,
 41742,
 -60096,
 356423973,
 41741,
 -1,
 356477461,
 41743,
 -60094,
 356423973,
 41738,
 -60093,
 356614796,
 41737,
 -1,
 356674069,
 41740,
 356848970,
 356358611,
 41766,
 356914503,
 356806769,
 41769,
 -1,
 356882725,
 41768,
 -60088,
 356882725,
 41765,
 -60087,
 357008012,
 41764,
 -1,
 357067285,
 41767,
 357242190,
 356802831,
 41753,
 -60084,
 357210405,
 41752,
 -60083,
 357270156,
 41751,
 -1,
 357329429,
 41754,
 357504338,
 357173885,
 41746,
 -60080,
 357472549,
 41745,
 -60079,
 357532300,
 41744,
 -1,
 357591573,
 41747,
 357826559,
 357443863,
 41756,
 -60076,
 357734693,
 41755,
 -1,
 357788181,
 41757,
 357963161,
 351934115,
 -1,
 358028663,
 357897891,
 -1,
 358094176,
 357993204,
 41070,
 358159707,
 358048015,
 41059,
 -60070,
 358127909,
 41058,
 -1,
 358181397,
 41060,
 358356317,
 358117489,
 41073,
 -1,
 358324517,
 41072,
 -60066,
 358324517,
 41069,
 -60065,
 358449804,
 41068,
 -1,
 358509077,
 41071,
 358684008,
 358039425,
 41048,
 358749541,
 358623511,
 41052,
 -60061,
 358717733,
 41051,
 -60060,
 358777484,
 41050,
 -1,
 358836757,
 41053,
 -60058,
 358717733,
 41047,
 -60057,
 358974092,
 41046,
 -1,
 359033365,
 41049,
 359208300,
 358652371,
 41076,
 -60054,
 359176485,
 41075,
 -60053,
 359236236,
 41074,
 -1,
 359295509,
 41077,
 359470448,
 359162127,
 41063,
 -60050,
 359438629,
 41062,
 -60049,
 359498380,
 41061,
 -1,
 359557653,
 41064,
 359732596,
 359402109,
 41056,
 -60046,
 359700773,
 41055,
 -60045,
 359760524,
 41054,
 -1,
 359819797,
 41057,
 360054783,
 359672087,
 41066,
 -60042,
 359962917,
 41065,
 -1,
 360016405,
 41067,
 360191360,
 357993204,
 41006,
 360256891,
 360145167,
 40995,
 -60038,
 360225061,
 40994,
 -1,
 360278549,
 40996,
 360453501,
 360214641,
 41009,
 -1,
 360421669,
 41008,
 -60034,
 360421669,
 41005,
 -60033,
 360546956,
 41004,
 -1,
 360606229,
 41007,
 360781192,
 360136577,
 40984,
 360846725,
 360720663,
 40988,
 -60029,
 360814885,
 40987,
 -60028,
 360874636,
 40986,
 -1,
 360933909,
 40989,
 -60026,
 360814885,
 40983,
 -60025,
 361071244,
 40982,
 -1,
 361130517,
 40985,
 361305486,
 360749523,
 41012,
 361371019,
 361263217,
 41015,
 -1,
 361339173,
 41014,
 -60020,
 361339173,
 41011,
 -60019,
 361464460,
 41010,
 -1,
 361523733,
 41013,
 361698706,
 361259279,
 40999,
 -60016,
 361666853,
 40998,
 -60015,
 361726604,
 40997,
 -1,
 361785877,
 41000,
 361960854,
 361630333,
 40992,
 -60012,
 361928997,
 40991,
 -60011,
 361988748,
 40990,
 -1,
 362048021,
 40993,
 362283007,
 361900311,
 41002,
 -60008,
 362191141,
 41001,
 -1,
 362244629,
 41003,
 362419672,
 357899082,
 -1,
 362485174,
 362363208,
 -1,
 362550692,
 362449652,
 41842,
 362616224,
 362504463,
 41831,
 -60002,
 362584357,
 41830,
 -60001,
 362644108,
 41829,
 -1,
 362703381,
 41832,
 362878370,
 362573937,
 41845,
 -1,
 362846501,
 41844,
 -59997,
 362846501,
 41841,
 -1,
 362965525,
 41843,
 363140522,
 362518995,
 41848,
 363206055,
 363098225,
 41851,
 -1,
 363174181,
 41850,
 -59992,
 363174181,
 41847,
 -59991,
 363299468,
 41846,
 -1,
 363358741,
 41849,
 363533742,
 363094287,
 41835,
 -59988,
 363501861,
 41834,
 -59987,
 363561612,
 41833,
 -1,
 363620885,
 41836,
 363795890,
 363473175,
 41839,
 -59984,
 363764005,
 41838,
 -59983,
 363823756,
 41837,
 -1,
 363883029,
 41840,
 364118015,
 363727485,
 41827,
 -59980,
 364026149,
 41826,
 -59979,
 364085900,
 41825,
 -1,
 364145173,
 41828,
 364320191,
 362449652,
 41670,
 364385722,
 364273935,
 41659,
 -59975,
 364353829,
 41658,
 -1,
 364407317,
 41660,
 364582332,
 364343409,
 41673,
 -1,
 364550437,
 41672,
 -59971,
 364550437,
 41669,
 -59970,
 364675724,
 41668,
 -1,
 364734997,
 41671,
 364910023,
 364265345,
 41648,
 364975556,
 364849431,
 41652,
 -59966,
 364943653,
 41651,
 -59965,
 365003404,
 41650,
 -1,
 365062677,
 41653,
 -59963,
 364943653,
 41647,
 -59962,
 365200012,
 41646,
 -1,
 365259285,
 41649,
 365434317,
 364878291,
 41676,
 365499850,
 365391985,
 41679,
 -1,
 365467941,
 41678,
 -59957,
 365467941,
 41675,
 -59956,
 365593228,
 41674,
 -1,
 365652501,
 41677,
 365827537,
 365388047,
 41663,
 -59953,
 365795621,
 41662,
 -59952,
 365855372,
 41661,
 -1,
 365914645,
 41664,
 366089685,
 365759101,
 41656,
 -59949,
 366057765,
 41655,
 -59948,
 366117516,
 41654,
 -1,
 366176789,
 41657,
 366411775,
 366029079,
 41666,
 -59945,
 366319909,
 41665,
 -1,
 366373397,
 41667,
 366548500,
 362362263,
 -1,
 366614006,
 366491031,
 -1,
 366679524,
 366578420,
 41516,
 366745055,
 366633231,
 41504,
 -59939,
 366713125,
 41503,
 -59938,
 366772876,
 41502,
 -1,
 366832149,
 41505,
 367007201,
 366702705,
 41519,
 -1,
 366975269,
 41518,
 -59934,
 366975269,
 41515,
 -59933,
 367100556,
 41514,
 -1,
 367159829,
 41517,
 367334890,
 366624641,
 41494,
 367400424,
 367274263,
 41496,
 -59929,
 367368485,
 41495,
 -1,
 367421973,
 41497,
 -59927,
 367368485,
 41493,
 -1,
 367559308,
 41492,
 367728110,
 367288591,
 41508,
 -59924,
 367696165,
 41507,
 -59923,
 367755916,
 41506,
 -1,
 367815189,
 41509,
 367990258,
 367667479,
 41512,
 -59920,
 367958309,
 41511,
 -59919,
 368018060,
 41510,
 -1,
 368077333,
 41513,
 368312319,
 367921789,
 41500,
 -59916,
 368220453,
 41499,
 -59915,
 368280204,
 41498,
 -1,
 368339477,
 41501,
 368514560,
 366578420,
 41460,
 368580091,
 368468239,
 41448,
 -59911,
 368548133,
 41447,
 -59910,
 368607884,
 41446,
 -1,
 368667157,
 41449,
 368842237,
 368537713,
 41463,
 -1,
 368810277,
 41462,
 -59906,
 368810277,
 41459,
 -59905,
 368935564,
 41458,
 -1,
 368994837,
 41461,
 369169928,
 368459649,
 41436,
 369235461,
 369109271,
 41440,
 -59901,
 369203493,
 41439,
 -59900,
 369263244,
 41438,
 -1,
 369322517,
 41441,
 -59898,
 369203493,
 41435,
 -59897,
 369459852,
 41434,
 -1,
 369519125,
 41437,
 369694220,
 369123599,
 41452,
 -59894,
 369662245,
 41451,
 -59893,
 369721996,
 41450,
 -1,
 369781269,
 41453,
 369956368,
 369633559,
 41456,
 -59890,
 369924389,
 41455,
 -59889,
 369984140,
 41454,
 -1,
 370043413,
 41457,
 370278399,
 369887869,
 41444,
 -59886,
 370186533,
 41443,
 -59885,
 370246284,
 41442,
 -1,
 370305557,
 41445,
 370480715,
 366499119,
 -1,
 370546220,
 370423191,
 -1,
 370611743,
 370510580,
 41538,
 370677274,
 370565391,
 41527,
 -59879,
 370645285,
 41526,
 -1,
 370698773,
 41528,
 370873884,
 370634865,
 41541,
 -1,
 370841893,
 41540,
 -59875,
 370841893,
 41537,
 -59874,
 370967180,
 41536,
 -1,
 371026453,
 41539,
 371201571,
 370565391,
 41531,
 -59871,
 371169573,
 41530,
 -59870,
 371229324,
 41529,
 -1,
 371288597,
 41532,
 371463719,
 371133053,
 41524,
 -59867,
 371431717,
 41523,
 -59866,
 371491468,
 41522,
 -1,
 371550741,
 41525,
 371725866,
 371403031,
 41534,
 -59863,
 371693861,
 41533,
 -1,
 371747349,
 41535,
 371982335,
 371671387,
 41521,
 -1,
 371890469,
 41520,
 372053558,
 370510580,
 41157,
 372119089,
 372007183,
 41147,
 -59857,
 372087077,
 41146,
 -59856,
 372146828,
 41145,
 -1,
 372206101,
 41148,
 372381235,
 372076657,
 41160,
 -1,
 372349221,
 41159,
 -59852,
 372349221,
 41156,
 -59851,
 372474508,
 41155,
 -1,
 372533781,
 41158,
 372708925,
 371998593,
 41136,
 372774458,
 372648215,
 41139,
 -59847,
 372742437,
 41138,
 -1,
 372795925,
 41140,
 -59845,
 372742437,
 41135,
 -59844,
 372933260,
 41134,
 -1,
 372992533,
 41137,
 373167681,
 372677075,
 41163,
 -59841,
 373135653,
 41162,
 -59840,
 373195404,
 41161,
 -1,
 373254677,
 41164,
 373429829,
 373121295,
 41151,
 -59837,
 373397797,
 41150,
 -59836,
 373457548,
 41149,
 -1,
 373516821,
 41152,
 373691977,
 373361277,
 41143,
 -59833,
 373659941,
 41142,
 -59832,
 373719692,
 41141,
 -1,
 373778965,
 41144,
 374013951,
 373631255,
 41154,
 -1,
 373922085,
 41153,
 374085250,
 370428077,
 -1,
 374150758,
 374032557,
 -1,
 374216278,
 374115060,
 42025,
 374281809,
 374169871,
 42017,
 -59824,
 374249765,
 42016,
 -1,
 374303253,
 42018,
 374478419,
 374239345,
 42028,
 -1,
 374446373,
 42027,
 -59820,
 374446373,
 42024,
 -59819,
 374571660,
 42023,
 -1,
 374630933,
 42026,
 374806110,
 374161281,
 42010,
 374871643,
 374745367,
 42014,
 -59815,
 374839589,
 42013,
 -59814,
 374899340,
 42012,
 -1,
 374958613,
 42015,
 -59812,
 374839589,
 42009,
 -59811,
 375095948,
 42008,
 -1,
 375155221,
 42011,
 375330402,
 374774227,
 42031,
 -59808,
 375298341,
 42030,
 -59807,
 375358092,
 42029,
 -1,
 375417365,
 42032,
 375652351,
 375283983,
 42021,
 -59804,
 375560485,
 42020,
 -59803,
 375620236,
 42019,
 -1,
 375679509,
 42022,
 375854704,
 374115060,
 41970,
 375920235,
 375808271,
 41962,
 -59799,
 375888165,
 41961,
 -59798,
 375947916,
 41960,
 -1,
 376007189,
 41963,
 376182381,
 375877745,
 41973,
 -1,
 376150309,
 41972,
 -59794,
 376150309,
 41969,
 -59793,
 376275596,
 41968,
 -1,
 376334869,
 41971,
 376510072,
 375799681,
 41954,
 376575605,
 376449303,
 41958,
 -59789,
 376543525,
 41957,
 -59788,
 376603276,
 41956,
 -1,
 376662549,
 41959,
 -59786,
 376543525,
 41953,
 -59785,
 376799884,
 41952,
 -1,
 376859157,
 41955,
 377034366,
 376478163,
 41976,
 377099899,
 376991857,
 41979,
 -1,
 377067813,
 41978,
 -59780,
 377067813,
 41975,
 -59779,
 377193100,
 41974,
 -1,
 377252373,
 41977,
 377487359,
 376987919,
 41966,
 -59776,
 377395493,
 41965,
 -59775,
 377455244,
 41964,
 -1,
 377514517,
 41967,
 377689785,
 374022530,
 -1,
 377755295,
 377627010,
 -1,
 377820813,
 377719540,
 41293,
 377886344,
 377774351,
 41282,
 -59769,
 377854245,
 41281,
 -1,
 377907733,
 41283,
 378082954,
 377843825,
 41296,
 -1,
 378050853,
 41295,
 -59765,
 378050853,
 41292,
 -59764,
 378176140,
 41291,
 -1,
 378235413,
 41294,
 378410644,
 377765761,
 41272,
 378476177,
 378349847,
 41275,
 -59760,
 378444069,
 41274,
 -1,
 378497557,
 41276,
 -59758,
 378444069,
 41271,
 -59757,
 378634892,
 41270,
 -1,
 378694165,
 41273,
 378869400,
 378364175,
 41286,
 -59754,
 378837285,
 41285,
 -59753,
 378897036,
 41284,
 -1,
 378956309,
 41287,
 379131548,
 378800765,
 41279,
 -59750,
 379099429,
 41278,
 -59749,
 379159180,
 41277,
 -1,
 379218453,
 41280,
 379453439,
 379070743,
 41289,
 -59746,
 379361573,
 41288,
 -1,
 379415061,
 41290,
 379590311,
 377719540,
 41238,
 379655842,
 379547761,
 41241,
 -1,
 379623717,
 41240,
 379786916,
 379609359,
 41228,
 -1,
 379754789,
 41227,
 -59739,
 379754789,
 41237,
 -59738,
 379880076,
 41236,
 -1,
 379939349,
 41239,
 380114606,
 379535233,
 41218,
 380180139,
 380053783,
 41221,
 -59734,
 380148005,
 41220,
 -1,
 380201493,
 41222,
 -59732,
 380148005,
 41217,
 -59731,
 380338828,
 41216,
 -1,
 380398101,
 41219,
 380573362,
 380068111,
 41231,
 -59728,
 380541221,
 41230,
 -59727,
 380600972,
 41229,
 -1,
 380660245,
 41232,
 380835510,
 380504701,
 41225,
 -59724,
 380803365,
 41224,
 -59723,
 380863116,
 41223,
 -1,
 380922389,
 41226,
 381157375,
 380774679,
 41234,
 -59720,
 381065509,
 41233,
 -1,
 381118997,
 41235,
 381294317,
 377647217,
 -1,
 381359827,
 381251697,
 -1,
 381425347,
 381324020,
 41866,
 381490878,
 381382769,
 41869,
 -1,
 381458725,
 41868,
 381621952,
 381444367,
 41855,
 -1,
 381589797,
 41854,
 -59711,
 381589797,
 41865,
 -59710,
 381715084,
 41864,
 -1,
 381774357,
 41867,
 381949641,
 381393363,
 41872,
 382015174,
 381907057,
 41875,
 -1,
 381983013,
 41874,
 -59705,
 381983013,
 41871,
 -59704,
 382108300,
 41870,
 -1,
 382167573,
 41873,
 382342861,
 381903119,
 41858,
 -59701,
 382310693,
 41857,
 -59700,
 382370444,
 41856,
 -1,
 382429717,
 41859,
 382605009,
 382282007,
 41862,
 -59697,
 382572837,
 41861,
 -59696,
 382632588,
 41860,
 -1,
 382691861,
 41863,
 382926847,
 382536317,
 41853,
 -1,
 382834981,
 41852,
 382998236,
 381324020,
 41942,
 383063767,
 382951695,
 41931,
 -59690,
 383031589,
 41930,
 -1,
 383085077,
 41932,
 383260377,
 383021169,
 41945,
 -1,
 383228197,
 41944,
 -59686,
 383228197,
 41941,
 -59685,
 383353484,
 41940,
 -1,
 383412757,
 41943,
 383588066,
 382966227,
 41948,
 383653599,
 383545457,
 41951,
 -1,
 383621413,
 41950,
 -59680,
 383621413,
 41947,
 -59679,
 383746700,
 41946,
 -1,
 383805973,
 41949,
 383981286,
 383541519,
 41935,
 -59676,
 383949093,
 41934,
 -59675,
 384008844,
 41933,
 -1,
 384068117,
 41936,
 384243434,
 383912573,
 41928,
 -59672,
 384211237,
 41927,
 -59671,
 384270988,
 41926,
 -1,
 384330261,
 41929,
 384565247,
 384182551,
 41938,
 -59668,
 384473381,
 41937,
 -1,
 384526869,
 41939,
 384702225,
 381242189,
 -1,
 384767736,
 384666356,
 41424,
 384833267,
 384721167,
 41413,
 -59663,
 384801061,
 41412,
 -59662,
 384860812,
 41411,
 -1,
 384920085,
 41414,
 385095413,
 384790641,
 41427,
 -1,
 385063205,
 41426,
 -59658,
 385063205,
 41423,
 -59657,
 385188492,
 41422,
 -1,
 385247765,
 41425,
 385423104,
 384712577,
 41401,
 385488637,
 385362199,
 41405,
 -59653,
 385456421,
 41404,
 -59652,
 385516172,
 41403,
 -1,
 385575445,
 41406,
 -59650,
 385456421,
 41400,
 -59649,
 385712780,
 41399,
 -1,
 385772053,
 41402,
 385947398,
 385391059,
 41430,
 386012931,
 385904753,
 41433,
 -1,
 385980709,
 41432,
 -59644,
 385980709,
 41429,
 -59643,
 386105996,
 41428,
 -1,
 386165269,
 41431,
 386340618,
 385900815,
 41417,
 -59640,
 386308389,
 41416,
 -59639,
 386368140,
 41415,
 -1,
 386427413,
 41418,
 386602766,
 386271869,
 41409,
 -59636,
 386570533,
 41408,
 -59635,
 386630284,
 41407,
 -1,
 386689557,
 41410,
 386924543,
 386541847,
 41420,
 -59632,
 386832677,
 41419,
 -1,
 386886165,
 41421,
 387061553,
 384668026,
 -1,
 387127066,
 387006337,
 41188,
 387192599,
 387066135,
 41192,
 -59627,
 387160357,
 41191,
 -59626,
 387220108,
 41190,
 -1,
 387279381,
 41193,
 -59624,
 387160357,
 41187,
 -59623,
 387416716,
 41186,
 -1,
 387475989,
 41189,
 387651360,
 387094995,
 41212,
 387716893,
 387608689,
 41215,
 -1,
 387684645,
 41214,
 -59618,
 387684645,
 41211,
 -59617,
 387809932,
 41210,
 -1,
 387869205,
 41213,
 388044582,
 387615476,
 41206,
 388110115,
 388001905,
 41209,
 -1,
 388077861,
 41208,
 -59612,
 388077861,
 41205,
 -59611,
 388203148,
 41204,
 -1,
 388262421,
 41207,
 388437802,
 387997967,
 41200,
 -59608,
 388405541,
 41199,
 -59607,
 388465292,
 41198,
 -1,
 388524565,
 41201,
 388699950,
 388369021,
 41196,
 -59604,
 388667685,
 41195,
 -59603,
 388727436,
 41194,
 -1,
 388786709,
 41197,
 389021695,
 388638999,
 -1,
 -59600,
 388929829,
 41202,
 -1,
 388983317,
 41203,
 389158736,
 387017237,
 -1,
 389224251,
 389122804,
 41036,
 389289782,
 389177615,
 41028,
 -59595,
 389257509,
 41027,
 -1,
 389310997,
 41029,
 389486392,
 389247089,
 41039,
 -1,
 389454117,
 41038,
 -59591,
 389454117,
 41035,
 -59590,
 389579404,
 41034,
 -1,
 389638677,
 41037,
 389814082,
 389169025,
 41018,
 389879615,
 389753111,
 41021,
 -59586,
 389847333,
 41020,
 -1,
 389900821,
 41022,
 -59584,
 389847333,
 41017,
 -59583,
 390038156,
 41016,
 -1,
 390097429,
 41019,
 390272840,
 389781971,
 41042,
 390338373,
 390230129,
 41045,
 -1,
 390306085,
 41044,
 -59578,
 390306085,
 41041,
 -59577,
 390431372,
 41040,
 -1,
 390490645,
 41043,
 390666060,
 390226191,
 41032,
 -59574,
 390633765,
 41031,
 -59573,
 390693516,
 41030,
 -1,
 390752789,
 41033,
 390987775,
 390597245,
 41025,
 -59570,
 390895909,
 41024,
 -59569,
 390955660,
 41023,
 -1,
 391014933,
 41026,
 391190381,
 389126611,
 -1,
 391255899,
 391154420,
 42115,
 391321430,
 391209231,
 42107,
 -59564,
 391289125,
 42106,
 -59563,
 391348876,
 42105,
 -1,
 391408149,
 42108,
 391583576,
 391278705,
 42118,
 -1,
 391551269,
 42117,
 -59559,
 391551269,
 42114,
 -59558,
 391676556,
 42113,
 -1,
 391735829,
 42116,
 391911267,
 391200641,
 42099,
 391976800,
 391850263,
 42103,
 -59554,
 391944485,
 42102,
 -59553,
 392004236,
 42101,
 -1,
 392063509,
 42104,
 -59551,
 391944485,
 42098,
 -59550,
 392200844,
 42097,
 -1,
 392260117,
 42100,
 392435561,
 391879123,
 42121,
 392501094,
 392392817,
 42124,
 -1,
 392468773,
 42123,
 -59545,
 392468773,
 42120,
 -59544,
 392594060,
 42119,
 -1,
 392653333,
 42122,
 392888319,
 392388879,
 42111,
 -59541,
 392796453,
 42110,
 -59540,
 392856204,
 42109,
 -1,
 392915477,
 42112,
 393090954,
 391152268,
 -1,
 393156472,
 393054964,
 41266,
 393222003,
 393109775,
 41255,
 -59535,
 393189669,
 41254,
 -59534,
 393249420,
 41253,
 -1,
 393308693,
 41256,
 393484149,
 393179249,
 41269,
 -1,
 393451813,
 41268,
 -59530,
 393451813,
 41265,
 -59529,
 393577100,
 41264,
 -1,
 393636373,
 41267,
 393811839,
 393101185,
 41244,
 393877372,
 393750807,
 41247,
 -59525,
 393845029,
 41246,
 -1,
 393898517,
 41248,
 -59523,
 393845029,
 41243,
 -59522,
 394035852,
 41242,
 -1,
 394095125,
 41245,
 394270595,
 393765135,
 41259,
 -59519,
 394238245,
 41258,
 -59518,
 394297996,
 41257,
 -1,
 394357269,
 41260,
 394532743,
 394201725,
 41251,
 -59515,
 394500389,
 41250,
 -59514,
 394560140,
 41249,
 -1,
 394619413,
 41252,
 394854399,
 394471703,
 41262,
 -59511,
 394762533,
 41261,
 -1,
 394816021,
 41263,
 394991527,
 393047754,
 -1,
 395057045,
 394955508,
 41998,
 395122576,
 395010319,
 41990,
 -59506,
 395090213,
 41989,
 -59505,
 395149964,
 41988,
 -1,
 395209237,
 41991,
 395384722,
 395079793,
 42001,
 -1,
 395352357,
 42000,
 -59501,
 395352357,
 41997,
 -59500,
 395477644,
 41996,
 -1,
 395536917,
 41999,
 395712413,
 395001729,
 41982,
 395777946,
 395651351,
 41986,
 -59496,
 395745573,
 41985,
 -59495,
 395805324,
 41984,
 -1,
 395864597,
 41987,
 -59493,
 395745573,
 41981,
 -59492,
 396001932,
 41980,
 -1,
 396061205,
 41983,
 396236707,
 395680211,
 42004,
 396302240,
 396193905,
 42007,
 -1,
 396269861,
 42006,
 -59487,
 396269861,
 42003,
 -59486,
 396395148,
 42002,
 -1,
 396454421,
 42005,
 396689407,
 396189967,
 41994,
 -59483,
 396597541,
 41993,
 -59482,
 396657292,
 41992,
 -1,
 396716565,
 41995,
 396892100,
 394938787,
 -1,
 396957617,
 396856052,
 41488,
 397023148,
 396910863,
 41476,
 -59477,
 396990757,
 41475,
 -1,
 397044245,
 41477,
 397219758,
 396980337,
 41491,
 -1,
 397187365,
 41490,
 -59473,
 397187365,
 41487,
 -59472,
 397312652,
 41486,
 -1,
 397371925,
 41489,
 397547448,
 396902273,
 41466,
 397612981,
 397486359,
 41469,
 -59468,
 397580581,
 41468,
 -1,
 397634069,
 41470,
 -59466,
 397580581,
 41465,
 -59465,
 397771404,
 41464,
 -1,
 397830677,
 41467,
 398006204,
 397500687,
 41480,
 -59462,
 397973797,
 41479,
 -59461,
 398033548,
 41478,
 -1,
 398092821,
 41481,
 398268352,
 397945111,
 41484,
 -59458,
 398235941,
 41483,
 -59457,
 398295692,
 41482,
 -1,
 398354965,
 41485,
 398589951,
 398199421,
 41473,
 -59454,
 398498085,
 41472,
 -59453,
 398557836,
 41471,
 -1,
 398617109,
 41474,
 398792666,
 396833472,
 -1,
 398858187,
 398756596,
 41178,
 398923720,
 398815345,
 41181,
 -1,
 398891301,
 41180,
 -59447,
 398891301,
 41177,
 -59446,
 399016588,
 41176,
 -1,
 399075861,
 41179,
 399251407,
 398825939,
 41184,
 -59443,
 399218981,
 41183,
 -59442,
 399278732,
 41182,
 -1,
 399338005,
 41185,
 399513555,
 399196033,
 41167,
 -59439,
 399481125,
 41166,
 -59438,
 399540876,
 41165,
 -1,
 399600149,
 41168,
 399775703,
 399444605,
 41171,
 -59435,
 399743269,
 41170,
 -59434,
 399803020,
 41169,
 -1,
 399862293,
 41172,
 400097279,
 399728911,
 41174,
 -59431,
 400005413,
 41173,
 -1,
 400058901,
 41175,
 400234479,
 398760229,
 -1,
 400300003,
 400179073,
 42079,
 400365536,
 400238871,
 42083,
 -59426,
 400333093,
 42082,
 -59425,
 400392844,
 42081,
 -1,
 400452117,
 42084,
 -59423,
 400333093,
 42078,
 -59422,
 400589452,
 42077,
 -1,
 400648725,
 42080,
 400824297,
 400267731,
 42093,
 400889830,
 400781425,
 42096,
 -1,
 400857381,
 42095,
 -59417,
 400857381,
 42092,
 -59416,
 400982668,
 42091,
 -1,
 401041941,
 42094,
 401217517,
 400777487,
 42089,
 -59413,
 401185061,
 42088,
 -59412,
 401244812,
 42087,
 -1,
 401304085,
 42090,
 401539071,
 401182151,
 42086,
 -1,
 401447205,
 42085,
 401610750,
 400200927,
 -1,
 401676276,
 401574644,
 40981,
 401801215,
 401629455,
 41605,
 -59405,
 401709349,
 41604,
 -1,
 401762837,
 41606,
 401938424,
 401607293,
 41602,
 -59402,
 401905957,
 41601,
 -59401,
 401965708,
 41600,
 -1,
 402024981,
 41603,
 402200571,
 401891599,
 41608,
 -59398,
 402168101,
 41607,
 -1,
 402221589,
 41609,
 402456575,
 402139415,
 41611,
 -59395,
 402364709,
 41610,
 -1,
 402418197,
 41612,
 402593798,
 401555329,
 40962,
 402659331,
 402532631,
 40966,
 -59391,
 402626853,
 40965,
 -59390,
 402686604,
 40964,
 -1,
 402745877,
 40967,
 -59388,
 402626853,
 40961,
 -59387,
 402883212,
 40960,
 -1,
 402942485,
 40963,
 403118090,
 402546959,
 40977,
 -59384,
 403085605,
 40976,
 -59383,
 403145356,
 40975,
 -1,
 403204629,
 40978,
 403380238,
 403049085,
 40970,
 -59380,
 403347749,
 40969,
 -59379,
 403407500,
 40968,
 -1,
 403466773,
 40971,
 403642385,
 403344839,
 40973,
 -59376,
 403609893,
 40972,
 -1,
 403663381,
 40974,
 403898367,
 403581207,
 40980,
 -1,
 403806501,
 40979,
 404029439,
 324366515,
 -1,
 404035611,
 403905354,
 -1,
 404101144,
 404003283,
 42172,
 -59369,
 404062860,
 42147,
 -1,
 404122133,
 42132,
 -59367,
 404065742,
 42173,
 -59366,
 404244059,
 42174,
 -1,
 404306739,
 42179,
 404494370,
 404003790,
 -1,
 404559903,
 404458228,
 -1,
 -59362,
 404516977,
 42177,
 -1,
 404580885,
 42146,
 -59360,
 404528196,
 42180,
 -59359,
 404711156,
 42155,
 -1,
 404753021,
 42162,
 404953129,
 404454027,
 -1,
 405018664,
 404896072,
 -1,
 -59355,
 404986323,
 42160,
 -59354,
 405049358,
 42170,
 -59353,
 405103763,
 42178,
 -1,
 405149050,
 42176,
 -1,
 404979161,
 42133,
 405411888,
 404895127,
 -1,
 405477421,
 405353879,
 -1,
 -59348,
 405441991,
 42150,
 -1,
 405496979,
 42134,
 -59346,
 405432052,
 42166,
 -59345,
 405614371,
 42135,
 -1,
 405670525,
 42145,
 405870646,
 405363362,
 -1,
 405936180,
 405838291,
 -1,
 -59341,
 405890195,
 42151,
 -1,
 405947995,
 42131,
 -59339,
 405904503,
 42164,
 -1,
 406067399,
 42181,
 406263868,
 405817517,
 -1,
 406329403,
 406210733,
 -1,
 -59335,
 406297043,
 42165,
 -59334,
 406360316,
 42154,
 -1,
 406405467,
 42167,
 -1,
 406282511,
 42163,
 406657090,
 406206792,
 -1,
 406722625,
 406624549,
 -1,
 -59329,
 406687175,
 42143,
 -59328,
 406742163,
 42175,
 -1,
 406800292,
 42137,
 -1,
 406673716,
 42157,
 407050310,
 406604621,
 -1,
 407115845,
 406994817,
 42129,
 -1,
 407054615,
 42171,
 -1,
 407083887,
 42138,
 407312457,
 407017939,
 -1,
 -59320,
 407265551,
 42141,
 -1,
 407324580,
 42158,
 407509068,
 407277946,
 -1,
 -59317,
 407474190,
 42159,
 -1,
 407514915,
 42161,
 407705679,
 407470732,
 -1,
 -59314,
 407669492,
 42152,
 -1,
 407704954,
 42144,
 407902290,
 407661077,
 -1,
 -59311,
 407870353,
 42156,
 -1,
 407933180,
 42142,
 408098901,
 407852335,
 -1,
 -59308,
 408052883,
 42140,
 -1,
 408108929,
 42136,
 408295512,
 408045987,
 -1,
 -59305,
 408242084,
 42130,
 -1,
 408299799,
 42182,
 408492123,
 408232322,
 -1,
 -59302,
 408455924,
 42169,
 -1,
 408496374,
 42148,
 408688734,
 408426147,
 -1,
 -59299,
 408653838,
 42149,
 -1,
 408689376,
 42139,
 -59297,
 408656025,
 42168,
 -59296,
 408842023,
 42128,
 -1,
 408904851,
 42153,
 -1,
 324295362,
 9775,
 -1,
 324218406,
 165,
 409214746,
 324143741,
 -1,
 409280122,
 409170033,
 -1,
 409345525,
 409209536,
 -1,
 409411047,
 409272320,
 -1,
 409476500,
 409357133,
 -1,
 409541486,
 409420214,
 -1,
 409606401,
 409500299,
 -1,
 409671853,
 409549128,
 -1,
 409737374,
 409611004,
 -1,
 409802875,
 409680200,
 -1,
 409868408,
 409734387,
 -1,
 409933939,
 409835217,
 -1,
 409999474,
 409884486,
 -1,
 -59279,
 409945331,
 64872,
 -1,
 410006498,
 64871,
 -1,
 409967163,
 64938,
 410261622,
 409878401,
 -1,
 -59275,
 410222547,
 64778,
 -1,
 410279327,
 64814,
 -59273,
 410212133,
 64824,
 -1,
 410399714,
 64806,
 410648575,
 409807946,
 -1,
 -59270,
 410539813,
 64746,
 -1,
 410600691,
 64818,
 410785928,
 409753414,
 -1,
 410851459,
 410752721,
 -1,
 410916992,
 410801990,
 -1,
 -59265,
 410862835,
 64877,
 -1,
 410924002,
 64876,
 411172863,
 410864230,
 -1,
 -59262,
 411059443,
 64875,
 -1,
 411120610,
 64874,
 411310214,
 410795905,
 -1,
 -59259,
 411271123,
 64780,
 -1,
 411327903,
 64816,
 -59257,
 411260709,
 64745,
 -1,
 411448290,
 64808,
 411637903,
 410732808,
 -1,
 411703436,
 411582337,
 -1,
 -59253,
 411664339,
 64777,
 -1,
 411721119,
 64813,
 -59251,
 411670603,
 64873,
 -59250,
 411850533,
 64823,
 -1,
 411907042,
 64805,
 412096661,
 411585126,
 -1,
 412162195,
 412041089,
 -1,
 -59246,
 412123091,
 64779,
 -1,
 412179871,
 64815,
 -59244,
 412112677,
 64825,
 -1,
 412300258,
 64807,
 412489880,
 412064310,
 -1,
 -59241,
 412436354,
 64766,
 -1,
 412496866,
 64794,
 412686491,
 412447355,
 -1,
 -59238,
 412632962,
 64781,
 -1,
 412693474,
 64809,
 412942335,
 412618286,
 -1,
 -59235,
 412829570,
 64765,
 -1,
 412890082,
 64793,
 413138943,
 409668676,
 -1,
 413145252,
 413026805,
 -1,
 413210787,
 413073408,
 -1,
 -59230,
 413161253,
 64756,
 -1,
 413222786,
 64610,
 -1,
 413172550,
 64607,
 413472937,
 413082127,
 -1,
 413538472,
 413401088,
 -1,
 -59225,
 413488933,
 64755,
 -1,
 413550466,
 64609,
 -1,
 413500230,
 64606,
 413800620,
 413414197,
 -1,
 -59221,
 413751077,
 64754,
 -1,
 413812610,
 64608,
 -1,
 413762039,
 64611,
 414062814,
 409611004,
 -1,
 414128315,
 414013254,
 -1,
 414193847,
 414095057,
 -1,
 414259379,
 414144326,
 -1,
 -59214,
 414205171,
 64867,
 -1,
 414266338,
 64866,
 414455990,
 414202307,
 -1,
 -59211,
 414401779,
 64864,
 -1,
 414462946,
 64863,
 -1,
 414402837,
 64865,
 414718138,
 414138241,
 -1,
 -59207,
 414678995,
 64543,
 -1,
 414735775,
 64688,
 -1,
 414668581,
 64743,
 414980293,
 414071112,
 -1,
 415045826,
 414911731,
 -1,
 415111360,
 414990209,
 -1,
 -59201,
 415072211,
 64541,
 -1,
 415128991,
 64686,
 -59199,
 415078302,
 64860,
 -1,
 415258405,
 64821,
 415498239,
 414985290,
 -1,
 -59196,
 415389477,
 64744,
 -1,
 415450355,
 64817,
 415635661,
 414927462,
 -1,
 415701193,
 415602385,
 -1,
 -59192,
 415668795,
 64966,
 -1,
 415698492,
 64936,
 415897804,
 415645569,
 -1,
 -59189,
 415858643,
 64542,
 -1,
 415915423,
 64687,
 -1,
 415848229,
 64822,
 416159957,
 415582472,
 -1,
 416225489,
 416126673,
 -1,
 -59184,
 416168398,
 64861,
 -1,
 416222780,
 64862,
 416422100,
 416169857,
 -1,
 -59181,
 416382931,
 64540,
 -1,
 416439711,
 64685,
 -1,
 416372517,
 64820,
 416684248,
 416127542,
 -1,
 -59177,
 416630658,
 64764,
 -1,
 416691170,
 64792,
 416880859,
 416641659,
 -1,
 -59174,
 416827266,
 64782,
 -1,
 416887778,
 64810,
 417136639,
 416812590,
 -1,
 -59171,
 417023874,
 64763,
 -1,
 417084386,
 64791,
 417333247,
 413993597,
 -1,
 417339642,
 417210819,
 -1,
 417405161,
 417282499,
 -1,
 417470694,
 417371857,
 -1,
 417536229,
 417413571,
 -1,
 -59164,
 417481971,
 64869,
 -1,
 417543138,
 64868,
 -1,
 417503803,
 64937,
 417857535,
 417415041,
 -1,
 -59160,
 417759187,
 64544,
 -1,
 417815967,
 64689,
 417994992,
 417355590,
 -1,
 418060525,
 417961909,
 -1,
 -59156,
 418006259,
 64965,
 -1,
 418067426,
 64870,
 418316287,
 418004865,
 -1,
 -59153,
 418217939,
 64545,
 -1,
 418274719,
 64691,
 418453747,
 417962550,
 -1,
 -59150,
 418400130,
 64774,
 -1,
 418460642,
 64802,
 418650358,
 418411131,
 -1,
 -59147,
 418596738,
 64783,
 -1,
 418657250,
 64811,
 418846969,
 418582062,
 -1,
 -59144,
 418793346,
 64773,
 -1,
 418853858,
 64801,
 -1,
 418794099,
 64690,
 419168255,
 417286989,
 -1,
 419174656,
 419056524,
 -1,
 419240191,
 419102720,
 -1,
 -59138,
 419205281,
 65008,
 -1,
 419252098,
 65017,
 -1,
 419189316,
 65018,
 -1,
 419106662,
 65013,
 419567966,
 409567884,
 -1,
 419633461,
 419507294,
 -1,
 419698959,
 419583814,
 -1,
 419764490,
 419665617,
 -1,
 -59130,
 419732027,
 64931,
 -59129,
 419777139,
 64855,
 -59128,
 419842325,
 64853,
 -59127,
 419903950,
 64854,
 -1,
 419958332,
 64932,
 420157709,
 419708801,
 -1,
 -59124,
 420118483,
 64526,
 -1,
 420175263,
 64676,
 -59122,
 420108069,
 64739,
 -1,
 420295650,
 64626,
 420485404,
 419641672,
 -1,
 420550937,
 420416755,
 -1,
 420616470,
 420517585,
 -1,
 420682005,
 420563208,
 -1,
 -59116,
 420627699,
 64850,
 -1,
 420688866,
 64849,
 -1,
 420632419,
 64851,
 421003263,
 420560769,
 -1,
 -59112,
 420904915,
 64524,
 -1,
 420961695,
 64674,
 421199871,
 420490314,
 -1,
 -59109,
 421091109,
 64740,
 -1,
 421151987,
 64677,
 421337380,
 420432486,
 -1,
 421402913,
 421304017,
 -1,
 -59105,
 421370427,
 64929,
 -59104,
 421418851,
 64852,
 -1,
 421465660,
 64930,
 421724159,
 421347201,
 -1,
 -59101,
 421625811,
 64525,
 -1,
 421682591,
 64675,
 421861676,
 421284104,
 -1,
 421927209,
 421828305,
 -1,
 -59097,
 421894715,
 64927,
 -59096,
 421943139,
 64848,
 -1,
 421989948,
 64928,
 422248447,
 421871489,
 -1,
 -59093,
 422150099,
 64523,
 -1,
 422206879,
 64673,
 422385967,
 421829174,
 -1,
 -59090,
 422332290,
 64528,
 -1,
 422392802,
 64629,
 422582578,
 422317614,
 -1,
 -59087,
 422528898,
 64527,
 -1,
 422589410,
 64628,
 -59085,
 422550513,
 64625,
 -59084,
 422736512,
 64624,
 -1,
 422796812,
 64627,
 422975817,
 419576136,
 -1,
 423041352,
 422915166,
 -1,
 423106877,
 422991686,
 -1,
 423172411,
 423051137,
 -1,
 -59078,
 423133139,
 64530,
 -1,
 423189919,
 64678,
 -59076,
 423122725,
 64741,
 -1,
 423310306,
 64632,
 423500096,
 423074358,
 -1,
 -59073,
 423446402,
 64532,
 -1,
 423506914,
 64635,
 423696707,
 423431726,
 -1,
 -59070,
 423643010,
 64531,
 -1,
 423703522,
 64634,
 -59068,
 423664625,
 64631,
 -59067,
 423850624,
 64630,
 -59066,
 423910924,
 64633,
 -59065,
 423971111,
 64529,
 -1,
 424033280,
 64742,
 -1,
 422972839,
 64603,
 424345599,
 422907132,
 -1,
 424352085,
 424236870,
 -1,
 424417617,
 424318673,
 -1,
 424483151,
 424360387,
 -1,
 -59058,
 424428787,
 64882,
 -1,
 424489954,
 64881,
 -59056,
 424450619,
 64884,
 -1,
 424630115,
 64883,
 424810836,
 424361857,
 -1,
 -59053,
 424771539,
 64551,
 -1,
 424828319,
 64819,
 -1,
 424761125,
 64826,
 425072984,
 424319542,
 -1,
 -59049,
 425019266,
 64758,
 -1,
 425079778,
 64786,
 425269595,
 425015752,
 -1,
 -59046,
 425230291,
 64550,
 -1,
 425287071,
 64696,
 425525247,
 425201198,
 -1,
 -59043,
 425412482,
 64757,
 -1,
 425472994,
 64785,
 425662905,
 419535452,
 -1,
 425728413,
 425605448,
 -1,
 425793946,
 425659005,
 -1,
 425859477,
 425745042,
 -1,
 425924972,
 425790077,
 -1,
 425990505,
 425872751,
 -1,
 426056039,
 425940363,
 -1,
 -59034,
 426002306,
 64515,
 -1,
 426062818,
 64616,
 -59032,
 426002306,
 64490,
 -1,
 426193890,
 64491,
 426442751,
 425928985,
 -1,
 -59029,
 426329986,
 64492,
 -1,
 426390498,
 64493,
 426580339,
 425892307,
 -1,
 426645872,
 426543862,
 -1,
 -59025,
 426592130,
 64500,
 -1,
 426652642,
 64501,
 426901503,
 426585162,
 -1,
 -59022,
 426788738,
 64516,
 -1,
 426849250,
 64617,
 427039097,
 426530630,
 -1,
 427104631,
 426983297,
 -1,
 -59018,
 427065299,
 64514,
 -1,
 427122079,
 64666,
 -59016,
 427054885,
 64735,
 -1,
 427242466,
 64614,
 427432320,
 426981704,
 -1,
 427497853,
 427371594,
 -1,
 -59012,
 427448101,
 64736,
 -1,
 427508979,
 64667,
 427753471,
 427429111,
 -1,
 -59009,
 427655123,
 64513,
 -1,
 427711903,
 64664,
 427891077,
 427370777,
 -1,
 427956612,
 427835265,
 -1,
 -59005,
 427917267,
 64502,
 -1,
 427974047,
 64504,
 -1,
 427897826,
 64503,
 428218760,
 427857375,
 -1,
 -59001,
 428164994,
 64494,
 -1,
 428225506,
 64495,
 428415371,
 428182262,
 -1,
 -58998,
 428361602,
 64496,
 -1,
 428422114,
 64497,
 428611982,
 428368315,
 -1,
 -58995,
 428558210,
 64498,
 -1,
 428618722,
 64499,
 428808593,
 428558606,
 -1,
 -58992,
 428769235,
 64512,
 -1,
 428826015,
 64663,
 -58990,
 428776433,
 64613,
 -58989,
 428962432,
 64612,
 -58988,
 429022732,
 64615,
 -1,
 429083251,
 64665,
 429326335,
 425802058,
 -1,
 429332889,
 429211521,
 -1,
 -58984,
 429293523,
 64598,
 -1,
 429350303,
 64731,
 -1,
 429299787,
 64942,
 429654015,
 425733194,
 -1,
 -58980,
 429545253,
 64753,
 -1,
 429606131,
 64734,
 429791656,
 425678662,
 -1,
 429857187,
 429758161,
 -1,
 429922722,
 429807430,
 -1,
 -58975,
 429868275,
 64925,
 -1,
 429929442,
 64924,
 -1,
 429890107,
 64944,
 430184870,
 429801345,
 -1,
 -58971,
 430145491,
 64600,
 -1,
 430202271,
 64733,
 -58969,
 430135077,
 64752,
 -1,
 430322658,
 64659,
 430512557,
 429738248,
 -1,
 430578092,
 430456705,
 -1,
 -58965,
 430538707,
 64597,
 -1,
 430595487,
 64730,
 -1,
 430544971,
 64943,
 430840240,
 430479926,
 -1,
 -58961,
 430786434,
 64602,
 -1,
 430846946,
 64662,
 431036851,
 430787180,
 -1,
 -58958,
 430997459,
 64599,
 -1,
 431054239,
 64732,
 431233462,
 430968366,
 -1,
 -58955,
 431179650,
 64601,
 -1,
 431240162,
 64661,
 -58953,
 431201265,
 64658,
 -58952,
 431387264,
 64657,
 -1,
 431447564,
 64660,
 431626744,
 425610286,
 -1,
 431692235,
 431558173,
 -1,
 431757766,
 431658705,
 -1,
 431823299,
 431700608,
 -1,
 431888832,
 431757303,
 -1,
 -58945,
 431835010,
 65273,
 -1,
 431895522,
 65274,
 432144383,
 431819486,
 -1,
 -58942,
 432031618,
 65271,
 -1,
 432092130,
 65272,
 432340991,
 431773012,
 -1,
 -58939,
 432228226,
 65269,
 -1,
 432288738,
 65270,
 432478665,
 431707531,
 -1,
 -58936,
 432424834,
 64579,
 -1,
 432485346,
 64646,
 -58934,
 432424834,
 65275,
 -1,
 432616418,
 65276,
 432806358,
 431642438,
 -1,
 432871889,
 432772817,
 -1,
 432937424,
 432814531,
 -1,
 -58929,
 432882931,
 64904,
 -1,
 432944098,
 64903,
 -1,
 432904763,
 64941,
 433199572,
 432816001,
 -1,
 -58925,
 433160147,
 64578,
 -1,
 433216927,
 64716,
 -58923,
 433149733,
 64749,
 -1,
 433337314,
 64645,
 433527266,
 432752904,
 -1,
 433592799,
 433493713,
 -1,
 433658331,
 433542982,
 -1,
 -58918,
 433603827,
 64954,
 -1,
 433664994,
 64956,
 433854942,
 433604872,
 -1,
 -58915,
 433800435,
 64899,
 -1,
 433861602,
 64900,
 -1,
 433822267,
 64940,
 434175999,
 433536897,
 -1,
 -58911,
 434077651,
 64575,
 -1,
 434134431,
 64713,
 434313710,
 433469768,
 -1,
 434379245,
 434244851,
 -1,
 434444778,
 434345681,
 -1,
 434510312,
 434394950,
 -1,
 -58905,
 434455795,
 64949,
 -1,
 434516962,
 64896,
 -58903,
 434477627,
 64897,
 -1,
 434638396,
 64898,
 434896895,
 434388865,
 -1,
 -58900,
 434798547,
 64576,
 -1,
 434855327,
 64714,
 -1,
 434318414,
 64717,
 435100149,
 434260582,
 -1,
 435165682,
 435066805,
 -1,
 -58895,
 435111155,
 64902,
 -1,
 435172322,
 64901,
 435421183,
 435109761,
 -1,
 -58892,
 435322835,
 64577,
 -1,
 435379615,
 64715,
 435617791,
 435067446,
 -1,
 -58889,
 435505026,
 64580,
 -1,
 435565538,
 64647,
 435755563,
 431573411,
 -1,
 435821085,
 435686572,
 -1,
 435886597,
 435771206,
 -1,
 435952128,
 435853009,
 -1,
 436017663,
 435902278,
 -1,
 -58882,
 435963123,
 64963,
 -1,
 436024290,
 64955,
 -1,
 435984955,
 64951,
 436279811,
 435896193,
 -1,
 -58878,
 436240339,
 64572,
 -1,
 436297119,
 64712,
 -58876,
 436229925,
 64748,
 -1,
 436417506,
 64642,
 436607499,
 435833897,
 -1,
 436673033,
 436551553,
 -1,
 -58872,
 436633555,
 64571,
 -1,
 436690335,
 64711,
 -58870,
 436623141,
 64747,
 -1,
 436810722,
 64641,
 437000721,
 436538909,
 -1,
 437066255,
 436950411,
 -1,
 -58866,
 437012354,
 64573,
 -1,
 437072866,
 64643,
 -58864,
 437012354,
 64567,
 -1,
 437203938,
 64640,
 437393940,
 436967990,
 -1,
 -58861,
 437340034,
 64574,
 -1,
 437400546,
 64644,
 437590551,
 437340780,
 -1,
 -58858,
 437551059,
 64570,
 -1,
 437607839,
 64710,
 437787162,
 437537038,
 -1,
 -58855,
 437747667,
 64568,
 -1,
 437804447,
 64708,
 438042623,
 437729736,
 -1,
 -58852,
 437944275,
 64569,
 -1,
 438001055,
 64709,
 438239231,
 435763697,
 -1,
 438245921,
 438147638,
 -1,
 -58848,
 438192002,
 64772,
 -1,
 438252514,
 64800,
 438442532,
 438196060,
 -1,
 -58845,
 438403027,
 64539,
 -1,
 438459807,
 64684,
 438639143,
 438389006,
 -1,
 -58842,
 438599635,
 64537,
 -1,
 438656415,
 64683,
 438835754,
 438570542,
 -1,
 -58839,
 438781826,
 64771,
 -1,
 438842338,
 64799,
 -1,
 438778335,
 64538,
 439097946,
 435707420,
 -1,
 439163449,
 439044360,
 -1,
 439228982,
 439129809,
 -1,
 439294513,
 439179078,
 -1,
 -58832,
 439239923,
 64920,
 -1,
 439301090,
 64919,
 439491124,
 439237059,
 -1,
 -58829,
 439436531,
 64952,
 -1,
 439497698,
 64957,
 -58827,
 439458363,
 64967,
 -1,
 439619132,
 64921,
 439877631,
 439172993,
 -1,
 -58824,
 439779283,
 64587,
 -1,
 439836063,
 64722,
 440015429,
 439105864,
 -1,
 440080962,
 439946483,
 -1,
 440146495,
 440047313,
 -1,
 -58819,
 440113723,
 64947,
 -58818,
 440162147,
 64917,
 -1,
 440208956,
 64918,
 440467455,
 440090497,
 -1,
 -58815,
 440369107,
 64588,
 -1,
 440425887,
 64723,
 440664063,
 440020042,
 -1,
 -58812,
 440555301,
 64751,
 -1,
 440616179,
 64726,
 440801870,
 439965510,
 -1,
 440867401,
 440768209,
 -1,
 -58808,
 440834619,
 64922,
 -1,
 440864316,
 64923,
 441064012,
 440811393,
 -1,
 -58805,
 441024467,
 64590,
 -1,
 441081247,
 64725,
 -58803,
 441014053,
 64750,
 -1,
 441201634,
 64652,
 441391697,
 440769078,
 -1,
 -58800,
 441337730,
 64592,
 -1,
 441398242,
 64655,
 441588308,
 441338476,
 -1,
 -58797,
 441548755,
 64589,
 -1,
 441605535,
 64724,
 441784919,
 441519662,
 -1,
 -58794,
 441730946,
 64591,
 -1,
 441791458,
 64654,
 -58792,
 441752561,
 64651,
 -58791,
 441938560,
 64650,
 -1,
 441998860,
 64653,
 442178176,
 439047471,
 -1,
 442243711,
 442116846,
 -1,
 442309221,
 442190088,
 -1,
 442374754,
 442275537,
 -1,
 -58785,
 442341947,
 64960,
 -58784,
 442390371,
 64909,
 -58783,
 442452595,
 64914,
 -1,
 442513870,
 64908,
 442761215,
 442318721,
 -1,
 -58780,
 442662867,
 64581,
 -1,
 442719647,
 64718,
 442899053,
 442255974,
 -1,
 442964586,
 442865361,
 -1,
 -58776,
 442931771,
 64953,
 -58775,
 442980195,
 64911,
 -1,
 443042069,
 64910,
 443285503,
 442908545,
 -1,
 -58772,
 443187155,
 64583,
 -1,
 443243935,
 64720,
 443423349,
 442841539,
 -1,
 443488882,
 443389649,
 -1,
 -58768,
 443456059,
 64907,
 -58767,
 443504483,
 64906,
 -1,
 443566357,
 64905,
 443809791,
 443432833,
 -1,
 -58764,
 443711443,
 64582,
 -1,
 443768223,
 64719,
 443947643,
 443373382,
 -1,
 444013177,
 443891585,
 -1,
 -58760,
 443973587,
 64584,
 -1,
 444030367,
 64721,
 -58758,
 443979851,
 64945,
 -1,
 444150754,
 64649,
 444340862,
 443878941,
 -1,
 -58755,
 444290452,
 64585,
 -1,
 444347362,
 64648,
 -1,
 444308042,
 64586,
 -1,
 442196494,
 65012,
 444668577,
 442111953,
 -1,
 444734090,
 444610888,
 -1,
 444799623,
 444665075,
 -1,
 444865158,
 444743553,
 -1,
 -58747,
 444825555,
 64518,
 -1,
 444882335,
 64669,
 -1,
 444831819,
 64962,
 445186047,
 444738634,
 -1,
 -58743,
 445077285,
 64738,
 -1,
 445138163,
 64672,
 445323920,
 444684102,
 -1,
 445389454,
 445267841,
 -1,
 -58739,
 445349843,
 64520,
 -1,
 445406623,
 64671,
 -58737,
 445339429,
 64737,
 -1,
 445527010,
 64620,
 445717141,
 445270630,
 -1,
 445782676,
 445661057,
 -1,
 -58733,
 445743059,
 64519,
 -1,
 445799839,
 64670,
 -1,
 445749323,
 64926,
 446044824,
 445684278,
 -1,
 -58729,
 445990786,
 64522,
 -1,
 446051298,
 64623,
 446241435,
 445991182,
 -1,
 -58726,
 446201811,
 64517,
 -1,
 446258591,
 64668,
 446438046,
 446172718,
 -1,
 -58723,
 446384002,
 64521,
 -1,
 446444514,
 64622,
 -58721,
 446405617,
 64619,
 -58720,
 446591616,
 64618,
 -1,
 446651916,
 64621,
 446831301,
 444598909,
 -1,
 446896826,
 446776365,
 -1,
 446962349,
 446846790,
 -1,
 447027882,
 446928593,
 -1,
 447093416,
 446977862,
 -1,
 -58713,
 447038707,
 64887,
 -1,
 447099874,
 64886,
 -58711,
 447060539,
 64950,
 -1,
 447221308,
 64888,
 447479807,
 446971777,
 -1,
 -58708,
 447381459,
 64554,
 -1,
 447438239,
 64699,
 447617716,
 446908680,
 -1,
 447683249,
 447584181,
 -1,
 -58704,
 447628531,
 64964,
 -1,
 447689698,
 64885,
 447938559,
 447627137,
 -1,
 -58701,
 447840211,
 64553,
 -1,
 447896991,
 64698,
 448076471,
 447584822,
 -1,
 -58698,
 448022402,
 64760,
 -1,
 448082914,
 64788,
 448331775,
 448007726,
 -1,
 -58695,
 448219010,
 64759,
 -1,
 448279522,
 64787,
 448469700,
 446843725,
 -1,
 448535234,
 448408351,
 -1,
 448600767,
 448501562,
 -1,
 -58690,
 448546690,
 64829,
 -1,
 448607202,
 64828,
 448856063,
 448550314,
 -1,
 -58687,
 448743298,
 64605,
 -1,
 448803810,
 64656,
 -58685,
 448482318,
 65010,
 -1,
 448927371,
 65015,
 -1,
 448416311,
 65011,
 449190631,
 446773576,
 -1,
 449256153,
 449121532,
 -1,
 449321678,
 449206086,
 -1,
 449387211,
 449287889,
 -1,
 -58678,
 449354299,
 64858,
 -1,
 449383996,
 64859,
 449642495,
 449331073,
 -1,
 -58675,
 449544147,
 64536,
 -1,
 449600927,
 64682,
 449780435,
 449267976,
 -1,
 449845970,
 449724289,
 -1,
 -58671,
 449806291,
 64535,
 -1,
 449863071,
 64681,
 -1,
 449812555,
 64959,
 450108118,
 449747510,
 -1,
 -58667,
 450054018,
 64768,
 -1,
 450114530,
 64796,
 450363391,
 450039342,
 -1,
 -58664,
 450250626,
 64767,
 -1,
 450311138,
 64795,
 450559999,
 449195102,
 -1,
 450566881,
 450451270,
 -1,
 450632414,
 450533073,
 -1,
 -58659,
 450582371,
 64916,
 -1,
 450644245,
 64915,
 450887679,
 450576257,
 -1,
 -58656,
 450789331,
 64594,
 -1,
 450846111,
 64728,
 451025636,
 450513166,
 -1,
 -58653,
 450985939,
 64593,
 -1,
 451042719,
 64727,
 -58651,
 450992714,
 64596,
 -58650,
 451183065,
 64729,
 -1,
 451219028,
 64595,
 451418885,
 449126873,
 -1,
 451484399,
 451365478,
 -1,
 451549932,
 451450805,
 -1,
 -58645,
 451495155,
 64880,
 -1,
 451556322,
 64879,
 451805183,
 451493761,
 -1,
 -58642,
 451706835,
 64548,
 -1,
 451763615,
 64694,
 451943158,
 451426755,
 -1,
 452008691,
 451909329,
 -1,
 -58638,
 451975739,
 64939,
 -1,
 452005436,
 64878,
 452263935,
 451952513,
 -1,
 -58635,
 452165587,
 64547,
 -1,
 452222367,
 64693,
 452401913,
 451910198,
 -1,
 -58632,
 452347778,
 64776,
 -1,
 452408290,
 64804,
 452598524,
 452358779,
 -1,
 -58629,
 452544386,
 64784,
 -1,
 452604898,
 64812,
 452795135,
 452548444,
 -1,
 -58626,
 452755411,
 64549,
 -1,
 452812191,
 64695,
 452991746,
 452741390,
 -1,
 -58623,
 452952019,
 64546,
 -1,
 453008799,
 64692,
 453246975,
 452922926,
 -1,
 -58620,
 453134210,
 64775,
 -1,
 453194722,
 64803,
 453384991,
 451365037,
 -1,
 453450526,
 453323502,
 -1,
 453516049,
 453400390,
 -1,
 453581582,
 453482193,
 -1,
 453647116,
 453523907,
 -1,
 -58613,
 453592307,
 64857,
 -1,
 453653474,
 64856,
 -58611,
 453614139,
 64933,
 -1,
 453774908,
 64935,
 454033407,
 453525377,
 -1,
 -58608,
 453935059,
 64534,
 -1,
 453991839,
 64680,
 454171416,
 453458371,
 -1,
 454236949,
 454137553,
 -1,
 -58604,
 454203963,
 64958,
 -1,
 454233660,
 64934,
 454492159,
 454180737,
 -1,
 -58601,
 454393811,
 64533,
 -1,
 454450591,
 64679,
 454630171,
 454138422,
 -1,
 -58598,
 454576002,
 64770,
 -1,
 454636514,
 64798,
 454885375,
 454561326,
 -1,
 -58595,
 454772610,
 64769,
 -1,
 454833122,
 64797,
 -1,
 453381874,
 65019,
 455088952,
 453325682,
 -1,
 455154471,
 455035494,
 -1,
 455220004,
 455120821,
 -1,
 -58589,
 455165171,
 64893,
 -1,
 455226338,
 64892,
 455475199,
 455163777,
 -1,
 -58586,
 455376851,
 64559,
 -1,
 455433631,
 64704,
 455613228,
 455104326,
 -1,
 455678763,
 455556993,
 -1,
 -58582,
 455638995,
 64560,
 -1,
 455695775,
 64705,
 -1,
 455645259,
 64961,
 455940911,
 455580214,
 -1,
 -58578,
 455886722,
 64562,
 -1,
 455947234,
 64637,
 456137522,
 455887118,
 -1,
 -58575,
 456097747,
 64557,
 -1,
 456154527,
 64702,
 456334133,
 456079816,
 -1,
 -58572,
 456294355,
 64558,
 -1,
 456351135,
 64703,
 456589311,
 456265262,
 -1,
 -58569,
 456476546,
 64561,
 -1,
 456537058,
 64636,
 456727374,
 455044812,
 -1,
 456792909,
 456667870,
 -1,
 456858436,
 456742726,
 -1,
 456923969,
 456824529,
 -1,
 456989503,
 456866243,
 -1,
 -58562,
 456934643,
 64948,
 -1,
 456995810,
 64894,
 -58560,
 456956475,
 64946,
 -1,
 457135948,
 64895,
 457375743,
 456867713,
 -1,
 -58557,
 457277395,
 64564,
 -1,
 457334175,
 64707,
 457513799,
 456825398,
 -1,
 -58554,
 457459586,
 64566,
 -1,
 457520098,
 64639,
 457710410,
 457456072,
 -1,
 -58551,
 457670611,
 64563,
 -1,
 457727391,
 64706,
 457965567,
 457641518,
 -1,
 -58548,
 457852802,
 64565,
 -1,
 457913314,
 64638,
 -1,
 456739727,
 65009,
 458169184,
 456668769,
 -1,
 458234711,
 458118982,
 -1,
 458300244,
 458200785,
 -1,
 -58542,
 458267195,
 64890,
 -58541,
 458315596,
 64889,
 -1,
 458362428,
 64891,
 458620927,
 458243969,
 -1,
 -58538,
 458522579,
 64556,
 -1,
 458579359,
 64701,
 458759002,
 458201654,
 -1,
 -58535,
 458704770,
 64762,
 -1,
 458765282,
 64790,
 458955613,
 458705166,
 -1,
 -58532,
 458915795,
 64555,
 -1,
 458972575,
 64700,
 459210751,
 458886702,
 -1,
 -58529,
 459097986,
 64761,
 -1,
 459158498,
 64789,
 459348837,
 458136541,
 -1,
 459414372,
 459292545,
 -1,
 -58525,
 459374547,
 64552,
 -1,
 459431327,
 64697,
 -1,
 459364133,
 64827,
 459676522,
 459312136,
 -1,
 459742057,
 459620225,
 -1,
 -58520,
 459702227,
 64505,
 -1,
 459759007,
 64507,
 -1,
 459682786,
 64506,
 460004205,
 459632753,
 -1,
 -58516,
 459943015,
 64604,
 -1,
 460002574,
 65014,
 -1,
 459969917,
 65016,
 460324863,
 409481645,
 -1,
 460331960,
 460227212,
 -1,
 460397447,
 460270663,
 1578,
 460462976,
 460324864,
 -1,
 460528505,
 460412207,
 -1,
 460594040,
 460460829,
 1577,
 460718079,
 460521472,
 -1,
 -58506,
 460605314,
 65171,
 -58505,
 460666724,
 1731,
 -1,
 460731362,
 65172,
 -1,
 460532416,
 65176,
 460987260,
 460494545,
 -1,
 -58501,
 460948984,
 1661,
 -1,
 461010631,
 1660,
 461183871,
 460930945,
 -1,
 -58498,
 461144019,
 65173,
 -1,
 461200799,
 65175,
 -1,
 461124578,
 65174,
 461504511,
 460401735,
 1663,
 461570047,
 461373440,
 -1,
 461577093,
 461455233,
 -1,
 -58492,
 461537235,
 64354,
 -1,
 461594015,
 64356,
 -58490,
 461526821,
 64357,
 -1,
 461714402,
 64355,
 461904790,
 460332358,
 1670,
 461970319,
 461843527,
 1671,
 462094335,
 461897728,
 -1,
 462101389,
 461979521,
 -1,
 -58484,
 462061523,
 64382,
 -1,
 462118303,
 64384,
 -58482,
 462051109,
 64385,
 -1,
 462238690,
 64383,
 462487551,
 461897728,
 -1,
 462494611,
 462372737,
 -1,
 -58478,
 462454739,
 64378,
 -1,
 462511519,
 64380,
 -58476,
 462460684,
 1727,
 -58475,
 462640933,
 64381,
 -1,
 462697442,
 64379,
 462887844,
 461865990,
 1657,
 462953374,
 462826567,
 1658,
 463077375,
 462880768,
 -1,
 463084444,
 462962561,
 -1,
 -58469,
 463044563,
 64350,
 -1,
 463101343,
 64352,
 -58467,
 463034149,
 64353,
 -1,
 463221730,
 64351,
 463470591,
 462880768,
 -1,
 463477666,
 463355777,
 -1,
 -58463,
 463437779,
 64358,
 -1,
 463494559,
 64360,
 -58461,
 463427365,
 64361,
 -1,
 463614946,
 64359,
 463805360,
 462829896,
 -1,
 463870892,
 463744071,
 1579,
 463994879,
 463798272,
 -1,
 464001962,
 463880065,
 -1,
 -58455,
 463962067,
 65177,
 -1,
 464018847,
 65179,
 -58453,
 463951653,
 65180,
 -1,
 464139234,
 65178,
 464388095,
 463801728,
 1584,
 464453631,
 464257024,
 -1,
 -58449,
 464340866,
 65195,
 -1,
 464401378,
 65196,
 464650239,
 463736048,
 1591,
 464715775,
 464519168,
 -1,
 464722869,
 464600961,
 -1,
 -58444,
 464682963,
 65217,
 -1,
 464739743,
 65219,
 -58442,
 464689153,
 1695,
 -58441,
 464869157,
 65220,
 -1,
 464925666,
 65218,
 465116136,
 460267906,
 -1,
 465181648,
 465046141,
 -1,
 465247172,
 465128269,
 1583,
 465371135,
 465174528,
 -1,
 465378242,
 465278673,
 -1,
 465443775,
 465315169,
 1674,
 -1,
 465371421,
 1675,
 -58432,
 465405432,
 1679,
 -58431,
 465532615,
 1673,
 -1,
 465581320,
 1680,
 -58429,
 465323906,
 65193,
 -1,
 465712098,
 65194,
 465902540,
 465183106,
 1590,
 466026495,
 465829888,
 -1,
 466033609,
 465911681,
 -1,
 -58424,
 465993683,
 65213,
 -1,
 466050463,
 65215,
 -58422,
 465999643,
 1787,
 -58421,
 466179877,
 65216,
 -1,
 466236386,
 65214,
 466485247,
 465844761,
 1676,
 466550783,
 466354176,
 -1,
 -58417,
 466438018,
 64388,
 -1,
 466498530,
 64389,
 466688985,
 465117654,
 -1,
 466754517,
 466635597,
 1672,
 466878463,
 466681856,
 -1,
 -58412,
 466765698,
 64392,
 -1,
 466826210,
 64393,
 467075071,
 466696729,
 1677,
 467140607,
 466944000,
 -1,
 -58408,
 467027842,
 64386,
 -1,
 467088354,
 64387,
 467278816,
 466655794,
 1668,
 467402751,
 467206144,
 -1,
 467409886,
 467287937,
 -1,
 -58403,
 467369939,
 64370,
 -1,
 467426719,
 64372,
 -58401,
 467359525,
 64373,
 -1,
 467547106,
 64371,
 467737572,
 467242064,
 1678,
 467861503,
 467664896,
 -1,
 -58397,
 467748738,
 64390,
 -1,
 467809250,
 64391,
 468058111,
 467691360,
 -1,
 -58394,
 467955413,
 1647,
 -58393,
 468005742,
 1697,
 -1,
 468064205,
 1646,
 468261911,
 465058120,
 -1,
 468327427,
 468200519,
 1607,
 468451327,
 468254720,
 -1,
 468458483,
 468334436,
 1729,
 468582399,
 468385792,
 -1,
 468589552,
 468467585,
 -1,
 -58385,
 468549587,
 64422,
 -1,
 468606367,
 64424,
 -58383,
 468555614,
 1730,
 -58382,
 468735781,
 64425,
 -1,
 468792290,
 64423,
 468982778,
 468395256,
 1726,
 469106687,
 468910080,
 -1,
 469113848,
 468991873,
 -1,
 -58377,
 469073875,
 64426,
 -1,
 469130655,
 64428,
 -58375,
 469063461,
 64429,
 -1,
 469251042,
 64427,
 469441534,
 468949052,
 1728,
 469565439,
 469368832,
 -1,
 -58371,
 469452674,
 64420,
 -1,
 469513186,
 64421,
 469703681,
 469385089,
 -1,
 -58368,
 469663699,
 65257,
 -1,
 469720479,
 65259,
 -58366,
 469653285,
 65260,
 -1,
 469840866,
 65258,
 470031378,
 468257405,
 -1,
 470096912,
 469973320,
 1581,
 470220799,
 470024192,
 -1,
 470227979,
 470128337,
 -1,
 470293514,
 470188684,
 -1,
 -58359,
 470259886,
 1666,
 -1,
 470302405,
 1669,
 -1,
 470235783,
 1665,
 470555662,
 470171521,
 -1,
 -58355,
 470515667,
 65185,
 -1,
 470572447,
 65187,
 -58353,
 470505253,
 65188,
 -1,
 470692834,
 65186,
 470941695,
 470047374,
 1569,
 -1,
 470811467,
 65152,
 471072767,
 469975531,
 1652,
 471138303,
 470941696,
 -1,
 -58347,
 471046706,
 1656,
 -58346,
 471111131,
 1654,
 -1,
 471141912,
 1653,
 471342143,
 468191869,
 -1,
 471407670,
 471289195,
 1575,
 471531519,
 471334912,
 -1,
 471538736,
 471438559,
 -1,
 471604268,
 471484370,
 -1,
 471669797,
 471546496,
 -1,
 471735329,
 471603185,
 1573,
 471859199,
 471662592,
 -1,
 -58336,
 471746434,
 65159,
 -1,
 471806946,
 65160,
 472055807,
 471665368,
 1571,
 472121343,
 471924736,
 -1,
 -58332,
 472008578,
 65155,
 -1,
 472069090,
 65156,
 472259625,
 471618888,
 1570,
 472383487,
 472186880,
 -1,
 -58328,
 472270722,
 65153,
 -1,
 472331234,
 65154,
 472580095,
 472225203,
 -1,
 -58325,
 472455153,
 1651,
 -1,
 472517336,
 1650,
 472776703,
 471536905,
 1649,
 472842239,
 472645632,
 -1,
 -58321,
 472729474,
 64336,
 -1,
 472789986,
 64337,
 472980532,
 471487875,
 1609,
 473104383,
 472907776,
 -1,
 -58317,
 472991618,
 65263,
 -1,
 473052130,
 65264,
 -58315,
 472926082,
 65165,
 -1,
 473183202,
 65166,
 473373758,
 471352275,
 1593,
 473497599,
 473300992,
 -1,
 473504827,
 473382785,
 -1,
 -58310,
 473464787,
 65225,
 -1,
 473521567,
 65227,
 -58308,
 473470977,
 1696,
 -58307,
 473650981,
 65228,
 -1,
 473707490,
 65226,
 -1,
 473311511,
 1749,
 473963620,
 471292578,
 -1,
 474029135,
 473916526,
 1606,
 474152959,
 473956352,
 -1,
 474160198,
 474060497,
 -1,
 -58300,
 474121703,
 1725,
 -58299,
 474183367,
 1724,
 -1,
 474228065,
 1721,
 474422346,
 474101456,
 1722,
 474546175,
 474349568,
 -1,
 -58295,
 474433410,
 64414,
 -1,
 474493922,
 64415,
 474684493,
 474365825,
 -1,
 -58292,
 474644435,
 65253,
 -1,
 474701215,
 65255,
 -58290,
 474634021,
 65256,
 -1,
 474821602,
 65254,
 475012189,
 473970071,
 1709,
 475077719,
 474964415,
 1713,
 475201535,
 475004928,
 -1,
 475208789,
 475086721,
 -1,
 -58284,
 475168723,
 64410,
 -1,
 475225503,
 64412,
 -58282,
 475158309,
 64413,
 -1,
 475345890,
 64411,
 475594751,
 475004928,
 -1,
 475602011,
 475479937,
 -1,
 -58278,
 475561939,
 64467,
 -1,
 475618719,
 64469,
 -58276,
 475551525,
 64470,
 -1,
 475739106,
 64468,
 475987967,
 474978866,
 1667,
 476053503,
 475856896,
 -1,
 476060770,
 475938689,
 -1,
 -58271,
 476020691,
 64374,
 -1,
 476077471,
 64376,
 -58269,
 476010277,
 64377,
 -1,
 476197858,
 64375,
 476388487,
 473909667,
 -1,
 476454000,
 476318889,
 1603,
 476577791,
 476381184,
 -1,
 476585067,
 476485329,
 -1,
 -58263,
 476546579,
 1710,
 -58262,
 476608199,
 1707,
 -1,
 476652887,
 1708,
 476847214,
 476528513,
 -1,
 -58259,
 476807123,
 65241,
 -1,
 476863903,
 65243,
 -58257,
 476796709,
 65244,
 -1,
 476984290,
 65242,
 477174905,
 476399373,
 -1,
 477240437,
 477141908,
 1737,
 477364223,
 477167616,
 -1,
 -58252,
 477251458,
 64482,
 -1,
 477311970,
 64483,
 477560831,
 477192632,
 1733,
 477626367,
 477429760,
 -1,
 -58248,
 477513602,
 64480,
 -1,
 477574114,
 64481,
 477764736,
 477116863,
 1582,
 477888511,
 477691904,
 -1,
 477895806,
 477773697,
 -1,
 -58243,
 477855699,
 65189,
 -1,
 477912479,
 65191,
 -58241,
 477845285,
 65192,
 -1,
 478032866,
 65190,
 478281727,
 477703310,
 1705,
 478347263,
 478150656,
 -1,
 478354565,
 478232449,
 -1,
 -58236,
 478314451,
 64398,
 -1,
 478371231,
 64400,
 -58234,
 478304037,
 64401,
 -1,
 478491618,
 64399,
 478682279,
 476347019,
 -1,
 478747795,
 478620408,
 1587,
 478871551,
 478674944,
 -1,
 478878862,
 478779089,
 -1,
 478944397,
 478840339,
 1691,
 -1,
 478871871,
 1692,
 -1,
 478881131,
 1690,
 479141009,
 478822273,
 -1,
 -58224,
 479100883,
 65201,
 -1,
 479157663,
 65203,
 -58222,
 479090469,
 65204,
 -1,
 479278050,
 65202,
 479468701,
 478678076,
 1589,
 479592447,
 479395840,
 -1,
 479599768,
 479500282,
 -1,
 -58217,
 479565984,
 1693,
 -1,
 479608517,
 1694,
 479796379,
 479543169,
 -1,
 -58214,
 479756243,
 65209,
 -1,
 479813023,
 65211,
 -58212,
 479745829,
 65212,
 -1,
 479933410,
 65210,
 480124069,
 479411177,
 1588,
 480247807,
 480051200,
 -1,
 480255138,
 480132993,
 -1,
 -58207,
 480214995,
 65205,
 -1,
 480271775,
 65207,
 -58205,
 480220955,
 1786,
 -58204,
 480401189,
 65208,
 -1,
 480457698,
 65206,
 -58202,
 480089492,
 1706,
 -1,
 480612041,
 1648,
 480779463,
 478648787,
 -1,
 480844995,
 480717895,
 1610,
 480968703,
 480772096,
 -1,
 480976054,
 480876241,
 -1,
 481041586,
 480918151,
 1574,
 481165311,
 480968704,
 -1,
 481172656,
 481050497,
 -1,
 -58193,
 481132499,
 65161,
 -1,
 481189279,
 65163,
 -58191,
 481122085,
 65164,
 -1,
 481309666,
 65162,
 481500341,
 481002124,
 -1,
 -58188,
 481443541,
 1745,
 -1,
 481496351,
 1741,
 -1,
 481460139,
 1742,
 481762494,
 480909160,
 1746,
 481886207,
 481689600,
 -1,
 481893564,
 481793886,
 1747,
 482017279,
 481820672,
 -1,
 -58181,
 481904514,
 64432,
 -1,
 481965026,
 64433,
 -58179,
 481838978,
 64430,
 -1,
 482096098,
 64431,
 482286785,
 481705857,
 -1,
 -58176,
 482246611,
 65265,
 -1,
 482303391,
 65267,
 -58174,
 482236197,
 65268,
 -1,
 482423778,
 65266,
 482672639,
 480807668,
 1736,
 482738175,
 482541568,
 -1,
 -58170,
 482625410,
 64475,
 -1,
 482685922,
 64476,
 482876643,
 480720279,
 -1,
 482942164,
 482806953,
 1711,
 483065855,
 482869248,
 -1,
 483073231,
 482973393,
 -1,
 483138766,
 483033740,
 -1,
 -58163,
 483104928,
 1714,
 -1,
 483147461,
 1716,
 -1,
 483096263,
 1712,
 483400914,
 483016577,
 -1,
 -58159,
 483360723,
 64402,
 -1,
 483417503,
 64404,
 -58157,
 483350309,
 64405,
 -1,
 483537890,
 64403,
 483728604,
 482884091,
 1594,
 483852287,
 483655680,
 -1,
 483859673,
 483737473,
 -1,
 -58152,
 483819475,
 65229,
 -1,
 483876255,
 65231,
 -58150,
 483825435,
 1788,
 -58149,
 484005669,
 65232,
 -1,
 484062178,
 65230,
 484311039,
 483691464,
 1715,
 484376575,
 484179968,
 -1,
 484383969,
 484261761,
 -1,
 -58144,
 484343763,
 64406,
 -1,
 484400543,
 64408,
 -58142,
 484333349,
 64409,
 -1,
 484520930,
 64407,
 484711675,
 482832497,
 -1,
 484777200,
 484650055,
 1585,
 484900863,
 484704256,
 -1,
 484908270,
 484808401,
 -1,
 484973801,
 484868011,
 1682,
 -1,
 484901277,
 1685,
 485104875,
 484910433,
 1684,
 -1,
 485032068,
 1686,
 -58132,
 485067336,
 1687,
 -58131,
 485193415,
 1683,
 -1,
 485242120,
 1689,
 -58129,
 484853634,
 65197,
 -1,
 485372898,
 65198,
 485563639,
 484728327,
 1723,
 485687295,
 485490688,
 -1,
 485694709,
 485572481,
 -1,
 -58124,
 485654483,
 64416,
 -1,
 485711263,
 64418,
 -58122,
 485644069,
 64419,
 -1,
 485831650,
 64417,
 486080511,
 485519991,
 1681,
 486146047,
 485949440,
 -1,
 -58118,
 486033282,
 64396,
 -1,
 486093794,
 64397,
 486284561,
 484644786,
 -1,
 486350090,
 486226248,
 1576,
 486415620,
 486288455,
 1664,
 486539263,
 486342656,
 -1,
 486546690,
 486424449,
 -1,
 -58111,
 486506451,
 64346,
 -1,
 486563231,
 64348,
 -58109,
 486496037,
 64349,
 -1,
 486683618,
 64347,
 486932479,
 486342656,
 -1,
 486939912,
 486817665,
 -1,
 -58105,
 486899667,
 65167,
 -1,
 486956447,
 65169,
 -58103,
 486889253,
 65170,
 -1,
 487076834,
 65168,
 487325695,
 486288455,
 1659,
 487391231,
 487194624,
 -1,
 487398671,
 487276417,
 -1,
 -58098,
 487358419,
 64338,
 -1,
 487415199,
 64340,
 -58096,
 487348005,
 64341,
 -1,
 487535586,
 64339,
 487726373,
 486224576,
 -1,
 487791902,
 487664711,
 1601,
 487915519,
 487718912,
 -1,
 487922969,
 487823057,
 -1,
 487988504,
 487859538,
 -1,
 -58089,
 487938513,
 1698,
 -1,
 487987185,
 1699,
 -1,
 487949843,
 1701,
 488250652,
 487866241,
 -1,
 -58085,
 488210387,
 65233,
 -1,
 488267167,
 65235,
 -58083,
 488199973,
 65236,
 -1,
 488387554,
 65234,
 488636415,
 487724119,
 1740,
 488701951,
 488505344,
 -1,
 488709411,
 488587137,
 -1,
 -58078,
 488669139,
 64508,
 -1,
 488725919,
 64510,
 -58076,
 488658725,
 64511,
 -1,
 488846306,
 64509,
 489037107,
 487680888,
 1662,
 489102637,
 488975431,
 1702,
 489226239,
 489029632,
 -1,
 489233707,
 489111425,
 -1,
 -58070,
 489193427,
 64366,
 -1,
 489250207,
 64368,
 -58068,
 489183013,
 64369,
 -1,
 489370594,
 64367,
 489619455,
 489029632,
 -1,
 489626929,
 489504641,
 -1,
 -58064,
 489586643,
 64342,
 -1,
 489643423,
 64344,
 -58062,
 489576229,
 64345,
 -1,
 489763810,
 64343,
 489954623,
 489002459,
 1608,
 490078207,
 489881600,
 -1,
 490085693,
 489985745,
 -1,
 490151226,
 490027655,
 1572,
 490274815,
 490078208,
 -1,
 -58055,
 490162050,
 65157,
 -1,
 490222562,
 65158,
 -58053,
 490113608,
 1738,
 -58052,
 490370759,
 1732,
 -1,
 490415447,
 1743,
 -58050,
 490030978,
 65261,
 -1,
 490550242,
 65262,
 490741068,
 489901093,
 1604,
 490864639,
 490668032,
 -1,
 490872135,
 490772177,
 -1,
 490937669,
 490833371,
 -1,
 -58044,
 490870769,
 1720,
 -1,
 490932952,
 1719,
 -58042,
 490897323,
 1717,
 -1,
 491070807,
 1718,
 491265354,
 490815361,
 -1,
 -58039,
 491225043,
 65245,
 -1,
 491281823,
 65247,
 -58037,
 491214629,
 65248,
 -1,
 491402210,
 65246,
 491593048,
 490707930,
 -1,
 491658580,
 491534664,
 1592,
 491782143,
 491585536,
 -1,
 491789650,
 491667329,
 -1,
 -58031,
 491749331,
 65221,
 -1,
 491806111,
 65223,
 -58029,
 491738917,
 65224,
 -1,
 491926498,
 65222,
 492175359,
 491602899,
 1586,
 492240895,
 492044288,
 -1,
 -58025,
 492128130,
 65199,
 -1,
 492188642,
 65200,
 492379491,
 491557370,
 1739,
 492445024,
 492321096,
 1700,
 492568575,
 492371968,
 -1,
 492576094,
 492453761,
 -1,
 -58019,
 492535763,
 64362,
 -1,
 492592543,
 64364,
 -58017,
 492525349,
 64365,
 -1,
 492712930,
 64363,
 492961791,
 492371968,
 -1,
 -58014,
 492849026,
 64478,
 -1,
 492909538,
 64479,
 493100399,
 492325081,
 -1,
 493165931,
 493038969,
 1580,
 493289471,
 493092864,
 -1,
 493297001,
 493174657,
 -1,
 -58008,
 493256659,
 65181,
 -1,
 493313439,
 65183,
 -58006,
 493246245,
 65184,
 -1,
 493433826,
 65182,
 493682687,
 493107528,
 1688,
 493748223,
 493551616,
 -1,
 -58002,
 493635458,
 64394,
 -1,
 493695970,
 64395,
 493886840,
 493062900,
 1735,
 493952373,
 493813760,
 -1,
 494017907,
 493918046,
 1655,
 -1,
 493945675,
 64477,
 -57996,
 493963138,
 64471,
 -1,
 494089186,
 64472,
 494338047,
 493896278,
 -1,
 -57993,
 494229285,
 64489,
 -1,
 494290163,
 64488,
 494476674,
 493842133,
 1602,
 494600191,
 494403584,
 -1,
 494607741,
 494507729,
 -1,
 -57988,
 494568935,
 1704,
 -1,
 494609751,
 1703,
 494804352,
 494550913,
 -1,
 -57985,
 494763987,
 65237,
 -1,
 494820767,
 65239,
 -57983,
 494753573,
 65240,
 -1,
 494941154,
 65238,
 495132041,
 494425921,
 1605,
 495255551,
 495058944,
 -1,
 495263111,
 495140737,
 -1,
 -57978,
 495222739,
 65249,
 -1,
 495279519,
 65251,
 -57976,
 495212325,
 65252,
 -1,
 495399906,
 65250,
 495590800,
 495069463,
 1744,
 495714303,
 495517696,
 -1,
 495721870,
 495599489,
 -1,
 -57971,
 495681491,
 64484,
 -1,
 495738271,
 64486,
 -57969,
 495671077,
 64487,
 -1,
 495858658,
 64485,
 496107519,
 495542712,
 1734,
 496173055,
 495976448,
 -1,
 -57965,
 496060290,
 64473,
 -1,
 496120802,
 64474,
 496311739,
 409434763,
 -1,
 496377262,
 496260590,
 -1,
 496442793,
 496319630,
 -1,
 496508316,
 496391471,
 -1,
 496573851,
 496446184,
 -1,
 -57958,
 496533459,
 1762,
 -1,
 496590239,
 1752,
 -1,
 496503871,
 1764,
 496836001,
 496454477,
 -1,
 496901536,
 496779702,
 -1,
 -57953,
 496859853,
 1750,
 -1,
 496922329,
 1751,
 -1,
 496832350,
 1753,
 -57950,
 496802354,
 1767,
 -57949,
 497127266,
 1760,
 -57948,
 497190352,
 1755,
 -57947,
 497253356,
 1756,
 -57946,
 497318165,
 1759,
 -57945,
 497376775,
 1768,
 -57944,
 497436931,
 1754,
 -1,
 497493403,
 1761,
 497687980,
 496391150,
 -1,
 -57941,
 497646572,
 1763,
 -1,
 497702721,
 1773,
 -57939,
 497654322,
 1766,
 -1,
 497849819,
 1765,
 498015666,
 496340043,
 1618,
 498139135,
 497942528,
 -1,
 -57935,
 498030373,
 65151,
 -1,
 498091906,
 65150,
 498277814,
 497957246,
 1617,
 498401279,
 498204672,
 -1,
 -57931,
 498292517,
 65149,
 -1,
 498354050,
 65148,
 498539961,
 498221709,
 -1,
 -57928,
 498494893,
 1790,
 -1,
 498536422,
 1789,
 -57926,
 498500457,
 1758,
 -1,
 498675119,
 1563,
 498867652,
 496251584,
 -1,
 498933186,
 498800056,
 1614,
 498998719,
 498893634,
 1611,
 -1,
 498926411,
 65136,
 499187711,
 498925568,
 -1,
 -57919,
 499078949,
 65143,
 -1,
 499140482,
 65142,
 -57917,
 498896028,
 1748,
 -1,
 499271775,
 1645,
 499457484,
 498803074,
 -1,
 499523019,
 499388348,
 1615,
 499588552,
 499483458,
 1612,
 -1,
 499516235,
 65138,
 499777535,
 499515392,
 -1,
 -57910,
 499668773,
 65145,
 -1,
 499730306,
 65144,
 -1,
 499460657,
 1643,
 499981778,
 499403253,
 1616,
 500047311,
 499942210,
 1613,
 -1,
 499974987,
 65140,
 500236287,
 499974144,
 -1,
 -57903,
 500127525,
 65147,
 -1,
 500189058,
 65146,
 500375000,
 499942028,
 -1,
 500440535,
 500304509,
 -1,
 500506070,
 500402726,
 1600,
 -1,
 500434704,
 65137,
 -1,
 500450010,
 65139,
 -1,
 500383370,
 1644,
 500768221,
 500312343,
 -1,
 500833756,
 500718086,
 -1,
 -57893,
 500782076,
 1770,
 -1,
 500841620,
 1771,
 -1,
 500784076,
 1757,
 501095904,
 500722197,
 -1,
 -57889,
 501042120,
 1769,
 -1,
 501100492,
 1642,
 501292515,
 501037696,
 -1,
 -57886,
 501225457,
 1621,
 -1,
 501287640,
 1620,
 -57884,
 501250288,
 1772,
 -57883,
 501444615,
 1567,
 -57882,
 501503329,
 1619,
 -1,
 501554948,
 1548,
 501809151,
 409340184,
 -1,
 501816811,
 501711500,
 -1,
 -57878,
 501782681,
 1634,
 -1,
 501825187,
 1635,
 502013422,
 501774987,
 -1,
 -57875,
 501958801,
 1638,
 -1,
 502018511,
 1639,
 502210033,
 501953216,
 -1,
 -57872,
 502163453,
 1636,
 -1,
 502220866,
 1637,
 -57870,
 502176798,
 1632,
 -57869,
 502358970,
 1633,
 -57868,
 502422860,
 1641,
 -1,
 502475930,
 1640,
 502668913,
 409294754,
 -1,
 502734386,
 502628215,
 -1,
 502799914,
 502673837,
 -1,
 502865406,
 502733642,
 -1,
 502930940,
 502806856,
 -1,
 -57861,
 502869063,
 1395,
 -1,
 502925949,
 1401,
 -57859,
 502882575,
 1409,
 -1,
 503057021,
 1390,
 503258626,
 502802711,
 -1,
 -57856,
 503218828,
 1384,
 -57855,
 503265608,
 1383,
 -1,
 503323888,
 1381,
 503520773,
 503225294,
 -1,
 -57852,
 503462707,
 1386,
 -1,
 503515773,
 1382,
 503717383,
 503487144,
 1397,
 -1,
 503683173,
 1410,
 503848458,
 503681402,
 -1,
 -57847,
 503800079,
 1400,
 -1,
 503853660,
 1406,
 504045069,
 503808652,
 -1,
 -57844,
 503996687,
 1385,
 -1,
 504055945,
 1407,
 504241680,
 504003211,
 -1,
 -57841,
 504183138,
 1399,
 -1,
 504245319,
 1405,
 504438291,
 504197233,
 -1,
 -57838,
 504376391,
 1408,
 -1,
 504433277,
 1404,
 504634902,
 504392213,
 -1,
 -57835,
 504580237,
 1411,
 -1,
 504638535,
 1402,
 504831513,
 504580682,
 -1,
 -57832,
 504781474,
 1391,
 -1,
 504838472,
 1412,
 505028124,
 504776877,
 -1,
 -57829,
 504970236,
 1403,
 -1,
 505023101,
 1393,
 505224735,
 504968599,
 -1,
 -57826,
 505168694,
 1379,
 -1,
 505231738,
 1394,
 -57824,
 505190783,
 1389,
 -57823,
 505373195,
 1413,
 -57822,
 505437965,
 1398,
 -57821,
 505501593,
 1396,
 -57820,
 505565717,
 1388,
 -57819,
 505627857,
 1387,
 -57818,
 505691463,
 1392,
 -57817,
 505754478,
 1414,
 -57816,
 505815510,
 1380,
 -57815,
 505878542,
 1378,
 -1,
 505943687,
 1377,
 506200063,
 502743478,
 -1,
 506207792,
 506091421,
 -1,
 -57811,
 506173823,
 64279,
 -57810,
 506224397,
 64275,
 -57809,
 506283217,
 64277,
 -1,
 506341924,
 64276,
 -57807,
 506172391,
 64278,
 -1,
 506473000,
 1415,
 506666599,
 502668106,
 -1,
 506732134,
 506597945,
 -1,
 506797626,
 506665802,
 -1,
 506863160,
 506739016,
 -1,
 -57801,
 506801223,
 1347,
 -1,
 506858109,
 1353,
 -57799,
 506814735,
 1361,
 -1,
 506989181,
 1342,
 507190846,
 506734871,
 -1,
 -57796,
 507150988,
 1336,
 -57795,
 507197768,
 1335,
 -1,
 507256048,
 1333,
 507452993,
 507157454,
 -1,
 -57792,
 507394867,
 1338,
 -1,
 507447933,
 1334,
 507649603,
 507419304,
 1349,
 -1,
 507615333,
 1362,
 507780678,
 507613562,
 -1,
 -57787,
 507732239,
 1352,
 -1,
 507785820,
 1358,
 507977289,
 507740812,
 -1,
 -57784,
 507928847,
 1337,
 -1,
 507988105,
 1359,
 508173900,
 507935371,
 -1,
 -57781,
 508115298,
 1351,
 -1,
 508177479,
 1357,
 508370511,
 508129393,
 -1,
 -57778,
 508308551,
 1360,
 -1,
 508365437,
 1356,
 508567122,
 508324373,
 -1,
 -57775,
 508512397,
 1363,
 -1,
 508570695,
 1354,
 508763733,
 508512842,
 -1,
 -57772,
 508713634,
 1343,
 -1,
 508770632,
 1364,
 508960344,
 508709037,
 -1,
 -57769,
 508902396,
 1355,
 -1,
 508955261,
 1345,
 509156955,
 508900759,
 -1,
 -57766,
 509100854,
 1331,
 -1,
 509163898,
 1346,
 -57764,
 509122943,
 1341,
 -57763,
 509305355,
 1365,
 -57762,
 509370125,
 1350,
 -57761,
 509433753,
 1348,
 -57760,
 509497877,
 1340,
 -57759,
 509560017,
 1339,
 -57758,
 509623623,
 1344,
 -57757,
 509686638,
 1366,
 -57756,
 509747670,
 1332,
 -57755,
 509810702,
 1330,
 -1,
 509875847,
 1329,
 -1,
 506684184,
 1373,
 510140010,
 506603799,
 -1,
 -57751,
 510105939,
 1372,
 -1,
 510155247,
 1371,
 510336621,
 510069373,
 -1,
 -57748,
 510291390,
 1370,
 -1,
 510334864,
 1375,
 -57746,
 510291975,
 1374,
 -57745,
 510482743,
 1369,
 -57744,
 510541674,
 1418,
 -1,
 510604666,
 1417,
 510795384,
 502626599,
 -1,
 510860917,
 510752383,
 -1,
 -57740,
 510824379,
 10548,
 -1,
 510863389,
 10549,
 511115263,
 510797944,
 -1,
 -57737,
 511014353,
 10551,
 -1,
 511069940,
 10550,
 -57735,
 510738782,
 9800,
 -1,
 511187786,
 8978,
 511385319,
 409233941,
 -1,
 511450846,
 511331154,
 -1,
 511516316,
 511405867,
 -1,
 511581849,
 511446076,
 9109,
 511705087,
 511508480,
 -1,
 511712904,
 511582594,
 -1,
 511778435,
 511666670,
 -1,
 -57726,
 511743262,
 9047,
 -1,
 511771113,
 9036,
 511975046,
 511721345,
 -1,
 -57723,
 511939584,
 9017,
 -1,
 511971280,
 9018,
 512229375,
 511913242,
 9044,
 -1,
 512131796,
 9037,
 512302731,
 511675858,
 -1,
 -57718,
 512267550,
 9040,
 -1,
 512295401,
 9043,
 512499342,
 512249181,
 -1,
 -57715,
 512458877,
 9027,
 -1,
 512505192,
 9031,
 512695953,
 512432970,
 -1,
 -57712,
 512647895,
 9056,
 -1,
 512706218,
 9020,
 -57710,
 512655157,
 9025,
 -57709,
 512849372,
 9032,
 -57708,
 512913406,
 9072,
 -57707,
 512974505,
 9071,
 -57706,
 513034620,
 9019,
 -57705,
 513095668,
 9028,
 -57704,
 513159000,
 9016,
 -1,
 513218226,
 9026,
 513474559,
 511534889,
 -1,
 -57701,
 513379671,
 9048,
 -1,
 513437490,
 9054,
 513613486,
 511451522,
 -1,
 513679013,
 513567214,
 -1,
 513744548,
 513605632,
 -1,
 513810082,
 513704693,
 -1,
 -57695,
 513772887,
 9034,
 -1,
 513821052,
 9038,
 -57693,
 513768806,
 9062,
 -1,
 513940558,
 9073,
 -1,
 513709405,
 9046,
 514203309,
 513617178,
 -1,
 514268842,
 514129920,
 -1,
 -57688,
 514229903,
 9067,
 -57687,
 514294071,
 9042,
 -1,
 514335571,
 9058,
 514588671,
 514228951,
 -1,
 -57684,
 514493783,
 9049,
 -1,
 514556215,
 9035,
 -1,
 514146320,
 9050,
 514793144,
 513547082,
 -1,
 514858679,
 514737840,
 -1,
 514924211,
 514818269,
 -1,
 -57678,
 514867959,
 9021,
 -1,
 514921118,
 9055,
 -57676,
 514886999,
 9052,
 -57675,
 515066236,
 9022,
 -57674,
 515122003,
 9061,
 -1,
 515184306,
 9033,
 -1,
 514810659,
 9066,
 515448513,
 514756050,
 -1,
 515514048,
 515375104,
 -1,
 515579582,
 515474165,
 -1,
 -57668,
 515533048,
 9041,
 -57667,
 515590524,
 9045,
 -1,
 515646291,
 9057,
 -57665,
 515538269,
 9053,
 -1,
 515775566,
 9074,
 -1,
 515478877,
 9039,
 516038344,
 515406475,
 -1,
 516103877,
 515998348,
 -1,
 -57660,
 516047625,
 9069,
 -1,
 516100784,
 9059,
 -57658,
 516059189,
 9015,
 -57657,
 516246741,
 9023,
 -1,
 516304312,
 9070,
 516497100,
 515981185,
 -1,
 516562635,
 516450072,
 9075,
 -1,
 516490725,
 9080,
 -1,
 516491279,
 9014,
 516759247,
 516452465,
 -1,
 -57650,
 516702791,
 9030,
 -1,
 516767047,
 9076,
 516955857,
 516711180,
 9077,
 -1,
 516883941,
 9081,
 517086932,
 516902260,
 -1,
 -57645,
 517051741,
 9029,
 -1,
 517080362,
 9063,
 517283543,
 517032320,
 -1,
 -57642,
 517246295,
 9051,
 -1,
 517284691,
 9060,
 517480153,
 517214013,
 9082,
 -1,
 517408229,
 9078,
 -57638,
 517446754,
 9068,
 -57637,
 517572252,
 9064,
 -57636,
 517617733,
 9065,
 -57635,
 517680963,
 9079,
 -1,
 517740220,
 9024,
 517938918,
 511405667,
 -1,
 518004453,
 517904779,
 -1,
 518069988,
 517943134,
 -1,
 518135523,
 518031183,
 8773,
 -1,
 518063193,
 8786,
 -1,
 518087990,
 10864,
 -1,
 518003428,
 8774,
 -1,
 517934033,
 8784,
 -1,
 517891819,
 39,
 518528760,
 511335074,
 -1,
 518594288,
 518489693,
 -1,
 518659820,
 518527818,
 -1,
 -57621,
 518612035,
 8755,
 -1,
 518673306,
 10560,
 -57619,
 518621170,
 8630,
 -57618,
 518808771,
 8634,
 -57617,
 518866226,
 10769,
 -1,
 518927817,
 10226,
 519118582,
 518534551,
 -1,
 519184117,
 519064925,
 8736,
 519307263,
 519112191,
 -1,
 -57612,
 519212375,
 10660,
 -1,
 519273122,
 10654,
 -1,
 519143823,
 8491,
 -57609,
 519064163,
 9765,
 -1,
 519446987,
 10193,
 519642882,
 518474573,
 -1,
 519708413,
 519592356,
 -1,
 519773948,
 519669583,
 8776,
 -1,
 519702108,
 10863,
 -1,
 519726390,
 8778,
 519970560,
 519654223,
 -1,
 -57601,
 519909221,
 8780,
 -1,
 519967719,
 9006,
 -57599,
 519931030,
 9095,
 -1,
 520104739,
 8501,
 520298250,
 519600779,
 -1,
 520363783,
 520258682,
 -1,
 520429318,
 520309155,
 42,
 -1,
 520356872,
 8727,
 -1,
 520377647,
 8258,
 -57592,
 520329998,
 8771,
 -57591,
 520584343,
 8870,
 -1,
 520625336,
 9738,
 520822546,
 520231754,
 -1,
 520888078,
 520786203,
 -1,
 -57587,
 520838344,
 10655,
 -1,
 520887425,
 180,
 521084689,
 520849207,
 -1,
 -57584,
 521044539,
 8299,
 -1,
 521081547,
 8301,
 -1,
 521019423,
 8448,
 521346837,
 520770863,
 -1,
 -57580,
 521301028,
 38,
 -1,
 521342619,
 10815,
 521543448,
 521281922,
 -1,
 -57577,
 521486260,
 9772,
 -1,
 521545905,
 8449,
 -57575,
 521498544,
 9810,
 -1,
 521684782,
 9992,
 521872538,
 409160525,
 -1,
 521937757,
 521800317,
 -1,
 522003194,
 521897700,
 -1,
 522068262,
 521961335,
 -1,
 522133787,
 522006957,
 -1,
 522198868,
 522084623,
 111,
 522264399,
 522126847,
 -1,
 522329898,
 522206535,
 -1,
 522395433,
 522287084,
 417,
 522518527,
 522322009,
 -1,
 -57563,
 522421903,
 7905,
 -57562,
 522468735,
 7903,
 -57561,
 522532833,
 7901,
 -57560,
 522593633,
 7907,
 -1,
 522652691,
 7899,
 -1,
 522347129,
 7887,
 522919733,
 522264962,
 -1,
 522985267,
 522871055,
 -1,
 523050800,
 522945166,
 -1,
 523116335,
 522980056,
 559,
 -1,
 523043040,
 561,
 -1,
 523048945,
 7885,
 523370495,
 523012930,
 -1,
 -57550,
 523253729,
 525,
 -1,
 523308051,
 337,
 523567103,
 522928096,
 246,
 -1,
 523436256,
 555,
 523640638,
 522853194,
 -1,
 523706173,
 523585232,
 244,
 523829247,
 523632729,
 -1,
 -57543,
 523732623,
 7895,
 -57542,
 523779455,
 7893,
 -57541,
 523843553,
 7891,
 -57540,
 523904353,
 7897,
 -1,
 523963411,
 7889,
 -1,
 523637730,
 466,
 524230467,
 523601551,
 245,
 524353535,
 524157017,
 -1,
 -57535,
 524244283,
 557,
 -57534,
 524297043,
 7759,
 -1,
 524356627,
 7757,
 524558151,
 524178747,
 333,
 524681215,
 524484697,
 -1,
 -57530,
 524564449,
 7761,
 -1,
 524618771,
 7763,
 524820297,
 524517737,
 248,
 -1,
 524746847,
 511,
 524951371,
 524771820,
 491,
 -1,
 524878048,
 493,
 -57524,
 524895736,
 527,
 -57523,
 525023201,
 242,
 -57522,
 525081203,
 335,
 -1,
 525143059,
 243,
 525344594,
 522218370,
 -1,
 -57519,
 525295887,
 596,
 -1,
 525347095,
 603,
 -57517,
 525306612,
 547,
 -1,
 525483905,
 419,
 525672318,
 522158732,
 116,
 525737830,
 525635636,
 -1,
 525803354,
 525693041,
 633,
 525926399,
 525731327,
 -1,
 -57511,
 525816642,
 634,
 -1,
 525876602,
 635,
 526065500,
 525751599,
 623,
 -1,
 525993776,
 624,
 526196574,
 525994621,
 592,
 -1,
 526144642,
 594,
 -57505,
 526162387,
 654,
 -57504,
 526292191,
 653,
 -57503,
 526356858,
 652,
 -57502,
 526418572,
 647,
 -57501,
 526469539,
 670,
 -57500,
 526530888,
 613,
 -57499,
 526592279,
 477,
 -1,
 526656187,
 397,
 526851958,
 525665791,
 -1,
 526917484,
 526785354,
 -1,
 -57495,
 526869292,
 539,
 -57494,
 526927595,
 7793,
 -57493,
 526985931,
 355,
 -1,
 527045602,
 357,
 527245169,
 526852482,
 -1,
 527310704,
 527197943,
 -1,
 -57489,
 527243249,
 7789,
 -1,
 527305432,
 7787,
 -1,
 527253472,
 7831,
 -57486,
 527204713,
 359,
 -57485,
 527528617,
 648,
 -57484,
 527592051,
 427,
 -57483,
 527651142,
 7791,
 -1,
 527711610,
 429,
 527900538,
 526803902,
 -1,
 -57480,
 527862316,
 424,
 -57479,
 527924966,
 389,
 -1,
 527971394,
 445,
 -57477,
 527858320,
 678,
 -57476,
 528105048,
 254,
 -57475,
 528167042,
 679,
 -1,
 528227159,
 680,
 528424876,
 525609239,
 101,
 528490400,
 528352767,
 -1,
 528555917,
 528423754,
 -1,
 528621450,
 528500432,
 234,
 528744447,
 528547840,
 -1,
 528752521,
 528617506,
 -1,
 -57467,
 528713359,
 7877,
 -57466,
 528760191,
 7875,
 -57465,
 528824289,
 7873,
 -57464,
 528885089,
 7879,
 -1,
 528944147,
 7871,
 -1,
 528685041,
 7705,
 529211276,
 528558795,
 553,
 -1,
 529137770,
 7709,
 -1,
 529142754,
 283,
 529407892,
 528490882,
 -1,
 529473427,
 529359119,
 -1,
 529538962,
 529433230,
 -1,
 -57455,
 529471473,
 7865,
 -1,
 529533656,
 279,
 -1,
 529501011,
 517,
 -1,
 529416160,
 235,
 529866648,
 529356091,
 275,
 529989631,
 529793113,
 -1,
 -57449,
 529872865,
 7701,
 -1,
 529927187,
 7703,
 530128794,
 529827471,
 7869,
 -1,
 530055581,
 7707,
 -57445,
 530080236,
 281,
 -57444,
 530204152,
 519,
 -57443,
 530267519,
 7867,
 -57442,
 530331617,
 232,
 -57441,
 530389619,
 277,
 -1,
 530451475,
 233,
 530653096,
 528456744,
 658,
 530776063,
 530579456,
 -1,
 530784167,
 530683601,
 -1,
 530849702,
 530717514,
 -1,
 -57435,
 530812959,
 659,
 -1,
 530846690,
 495,
 -1,
 530809613,
 442,
 -1,
 530739925,
 441,
 531177386,
 530611428,
 643,
 -1,
 531105396,
 646,
 -57429,
 531137801,
 240,
 -1,
 531258533,
 331,
 531439577,
 528353917,
 97,
 531505108,
 531367423,
 -1,
 531570615,
 531438410,
 -1,
 531636150,
 531515088,
 226,
 531759103,
 531562585,
 -1,
 -57422,
 531662479,
 7851,
 -57421,
 531709311,
 7849,
 -57420,
 531773409,
 7847,
 -57419,
 531834209,
 7853,
 -1,
 531893267,
 7845,
 -1,
 531567586,
 462,
 532160448,
 531505538,
 -1,
 532225982,
 532111631,
 -1,
 532291517,
 532185742,
 -1,
 532357052,
 532220632,
 551,
 -1,
 532283616,
 481,
 -1,
 532289521,
 7841,
 -1,
 532253523,
 513,
 532676607,
 532168672,
 228,
 -1,
 532545760,
 479,
 532750279,
 532093555,
 259,
 532873215,
 532676697,
 -1,
 -57405,
 532776591,
 7861,
 -57404,
 532823423,
 7859,
 -57403,
 532887521,
 7857,
 -57402,
 532948321,
 7863,
 -1,
 533007379,
 7855,
 533209037,
 532706147,
 -1,
 533274572,
 533159080,
 -1,
 533340107,
 533203672,
 229,
 -1,
 533266527,
 507,
 -1,
 533272561,
 7681,
 -1,
 533214838,
 7834,
 -57394,
 533169807,
 227,
 -57393,
 533553644,
 261,
 -57392,
 533615931,
 257,
 -57391,
 533677560,
 515,
 -57390,
 533740927,
 7843,
 -57389,
 533805025,
 224,
 -1,
 533859347,
 225,
 534061016,
 531441943,
 230,
 534183935,
 533988863,
 -1,
 -57385,
 534074683,
 483,
 -1,
 534121491,
 509,
 -1,
 534008962,
 593,
 534388741,
 531401460,
 117,
 534454276,
 534315008,
 -1,
 534519811,
 534419153,
 -1,
 534585322,
 534454658,
 -1,
 534650853,
 534527968,
 252,
 534773759,
 534577152,
 -1,
 534781924,
 534646818,
 -1,
 -57375,
 534730043,
 470,
 -57374,
 534788065,
 476,
 -57373,
 534846554,
 474,
 -1,
 534907923,
 472,
 -1,
 534714353,
 7795,
 535232511,
 534601999,
 -1,
 535240681,
 535137090,
 -1,
 -57368,
 535181281,
 533,
 -1,
 535235603,
 369,
 -1,
 535200409,
 7909,
 535502835,
 534527303,
 -1,
 535568370,
 535459820,
 432,
 535691263,
 535494745,
 -1,
 -57362,
 535594639,
 7919,
 -57361,
 535641471,
 7917,
 -57360,
 535705569,
 7915,
 -57359,
 535766369,
 7921,
 -1,
 535825427,
 7913,
 -1,
 535519865,
 7911,
 536092663,
 535463567,
 361,
 536215551,
 536018944,
 -1,
 -57354,
 536090609,
 7797,
 -1,
 536154151,
 7801,
 536354811,
 536025930,
 -1,
 536420346,
 536299216,
 251,
 -1,
 536347037,
 7799,
 -1,
 536351714,
 468,
 536616957,
 536302907,
 363,
 -1,
 536543349,
 7803,
 -57346,
 536573650,
 367,
 -57345,
 536699372,
 371,
 -57344,
 536757752,
 535,
 -57343,
 536819681,
 249,
 -57342,
 536877683,
 365,
 -1,
 536939539,
 250,
 -1,
 534451986,
 649,
 -1,
 534408855,
 650,
 537272350,
 534334285,
 108,
 537337879,
 537200127,
 -1,
 537403403,
 537271114,
 -1,
 -57335,
 537347819,
 7741,
 -57334,
 537406155,
 316,
 -1,
 537465826,
 318,
 537665550,
 537352221,
 -1,
 -57331,
 537626255,
 619,
 -1,
 537666894,
 320,
 537862160,
 537601377,
 7735,
 -1,
 537788640,
 7737,
 537993235,
 537794211,
 -1,
 -57326,
 537931080,
 620,
 -1,
 537989790,
 410,
 -57324,
 537952617,
 322,
 -57323,
 538145449,
 621,
 -57322,
 538202438,
 7739,
 -1,
 538250259,
 314,
 538451993,
 537289738,
 383,
 -1,
 538379989,
 7835,
 -57318,
 538418128,
 683,
 -57317,
 538540688,
 682,
 -57316,
 538593453,
 457,
 -57315,
 538653351,
 622,
 -1,
 538709893,
 411,
 538910775,
 537207170,
 100,
 538976301,
 538838527,
 -1,
 539041828,
 538909514,
 -1,
 -57310,
 538986219,
 7699,
 -57309,
 539044555,
 7697,
 -1,
 539104226,
 271,
 539303975,
 539001484,
 -1,
 -57306,
 539255966,
 396,
 -1,
 539299103,
 598,
 539500586,
 539239762,
 -1,
 -57303,
 539432945,
 7693,
 -1,
 539495128,
 7691,
 -57301,
 539459945,
 273,
 -57300,
 539644230,
 7695,
 -1,
 539704698,
 599,
 539893810,
 538942414,
 499,
 540016639,
 539820032,
 -1,
 540024881,
 539894835,
 675,
 -1,
 539952756,
 677,
 -1,
 539989744,
 454,
 540221494,
 539846496,
 -1,
 540287029,
 540166319,
 607,
 -1,
 540213412,
 644,
 -1,
 540229505,
 305,
 -1,
 540160683,
 676,
 540549199,
 538865777,
 114,
 540614729,
 540476927,
 -1,
 540680255,
 540550385,
 -1,
 540745790,
 540639886,
 -1,
 540811325,
 540678129,
 7771,
 -1,
 540737760,
 7773,
 -1,
 540740312,
 7769,
 -1,
 540707667,
 529,
 541073474,
 540625741,
 -1,
 -57279,
 541025268,
 636,
 -1,
 541082735,
 7775,
 541270085,
 541006666,
 -1,
 -57276,
 541207243,
 343,
 -1,
 541266914,
 345,
 -57274,
 541229837,
 637,
 -57273,
 541410808,
 531,
 -57272,
 541471790,
 638,
 -1,
 541527059,
 341,
 541728846,
 540553734,
 -1,
 541794380,
 541680853,
 604,
 -1,
 541722405,
 605,
 -57267,
 541749381,
 639,
 -1,
 541862167,
 600,
 -1,
 541659125,
 612,
 542122085,
 540491649,
 105,
 542187620,
 542049791,
 -1,
 542253143,
 542122370,
 -1,
 542318677,
 542204175,
 -1,
 -57260,
 542280531,
 521,
 -1,
 542343833,
 7883,
 542572543,
 542261216,
 239,
 -1,
 542441567,
 7727,
 542646361,
 542213775,
 297,
 -1,
 542572957,
 7725,
 542777436,
 542579530,
 -1,
 -57253,
 542721744,
 238,
 -1,
 542774242,
 464,
 -57251,
 542736745,
 616,
 -57250,
 542925292,
 303,
 -57249,
 542987579,
 299,
 -57248,
 543049208,
 523,
 -57247,
 543112575,
 7881,
 -57246,
 543176673,
 236,
 -57245,
 543234675,
 301,
 -1,
 543296531,
 237,
 -1,
 542140184,
 617,
 543563898,
 542079627,
 115,
 543629428,
 543491583,
 -1,
 543694957,
 543562570,
 -1,
 543760490,
 543626210,
 353,
 -1,
 543686788,
 7783,
 -57237,
 543712044,
 537,
 -57236,
 543835856,
 349,
 -1,
 543894219,
 351,
 544088177,
 543630674,
 -1,
 544153712,
 544020465,
 7779,
 -1,
 544080004,
 7785,
 -1,
 544082648,
 7777,
 544350323,
 544017427,
 347,
 -1,
 544276612,
 7781,
 -1,
 544292218,
 642,
 544546936,
 543562570,
 -1,
 544612471,
 544489303,
 601,
 -1,
 544540453,
 602,
 -1,
 544569143,
 609,
 -57223,
 544501734,
 645,
 -1,
 544750317,
 223,
 544940174,
 543513250,
 110,
 545005709,
 544866304,
 -1,
 545071244,
 544970449,
 -1,
 545136769,
 545016653,
 -1,
 -57217,
 545088508,
 414,
 -57216,
 545145967,
 7753,
 -1,
 545205090,
 626,
 545398917,
 545069898,
 -1,
 -57213,
 545343211,
 7755,
 -57212,
 545401547,
 326,
 -1,
 545461218,
 328,
 545661064,
 545334610,
 -1,
 -57209,
 545593329,
 7751,
 -1,
 545655512,
 7749,
 -57207,
 545621647,
 241,
 -57206,
 545813161,
 627,
 -57205,
 545863649,
 505,
 -1,
 545917971,
 324,
 -1,
 545025553,
 329,
 -1,
 544950445,
 460,
 546250910,
 544905683,
 121,
 546316445,
 546178559,
 -1,
 546381973,
 546251138,
 -1,
 546447508,
 546334455,
 -1,
 -57197,
 546379761,
 7925,
 -1,
 546441944,
 7823,
 -1,
 546389984,
 255,
 546709655,
 546323834,
 436,
 -1,
 546635781,
 7927,
 -57192,
 546670223,
 7929,
 -57191,
 546797266,
 7833,
 -57190,
 546854203,
 563,
 -57189,
 546912225,
 7923,
 -57188,
 546971177,
 375,
 -1,
 547032083,
 253,
 -1,
 546267624,
 541,
 547299503,
 546191688,
 104,
 547365037,
 547227135,
 -1,
 547430565,
 547299714,
 -1,
 547496100,
 547383031,
 -1,
 -57181,
 547428337,
 7717,
 -1,
 547490520,
 7715,
 -1,
 547438560,
 7719,
 547758249,
 547363658,
 -1,
 -57177,
 547702480,
 293,
 -57176,
 547760843,
 7721,
 -1,
 547820514,
 543,
 -57174,
 547717481,
 295,
 -57173,
 547967302,
 7830,
 -57172,
 548027770,
 614,
 -1,
 548084345,
 7723,
 -57170,
 547328378,
 405,
 -1,
 548220532,
 615,
 548413631,
 547232586,
 99,
 548479162,
 548341247,
 -1,
 548544695,
 548412234,
 -1,
 548610228,
 548481739,
 231,
 -1,
 548536415,
 7689,
 -57163,
 548573215,
 597,
 -57162,
 548685520,
 265,
 -1,
 548738018,
 269,
 -57160,
 548486522,
 392,
 -57159,
 548873559,
 267,
 -1,
 548932627,
 263,
 549191679,
 548426643,
 -1,
 549200062,
 549085455,
 -1,
 -57155,
 549153688,
 666,
 -1,
 549214083,
 631,
 -1,
 549155604,
 606,
 549462221,
 548379598,
 122,
 549584895,
 549389823,
 -1,
 549593285,
 549460810,
 -1,
 -57149,
 549556255,
 657,
 -57148,
 549603024,
 7825,
 -1,
 549655522,
 382,
 549855432,
 549528914,
 -1,
 -57145,
 549787633,
 7827,
 -1,
 549849816,
 380,
 -57143,
 549814633,
 438,
 -57142,
 550007465,
 656,
 -57141,
 550064454,
 7829,
 -57140,
 550124922,
 549,
 -1,
 550177811,
 378,
 550379738,
 549402007,
 103,
 550445273,
 550307327,
 -1,
 550510803,
 550378314,
 -1,
 -57135,
 550454992,
 285,
 -57134,
 550513355,
 291,
 -1,
 550573026,
 487,
 -57132,
 550469993,
 485,
 -57131,
 550720827,
 7713,
 -57130,
 550780282,
 608,
 -57129,
 550839639,
 289,
 -57128,
 550902387,
 287,
 -1,
 550964243,
 501,
 -1,
 550375356,
 611,
 551231717,
 550343903,
 119,
 551354367,
 551159295,
 -1,
 551362785,
 551231874,
 -1,
 551428320,
 551315191,
 -1,
 -57121,
 551360497,
 7817,
 -1,
 551422680,
 7815,
 -1,
 551370720,
 7813,
 -57118,
 551319250,
 7832,
 -57117,
 551630817,
 7809,
 -57116,
 551689769,
 373,
 -1,
 551750675,
 7811,
 551952623,
 551176611,
 107,
 552018158,
 551880191,
 -1,
 552083690,
 551951178,
 -1,
 -57111,
 552020683,
 311,
 -1,
 552080354,
 489,
 -57109,
 552030534,
 7733,
 -57108,
 552222074,
 409,
 -57107,
 552281441,
 7731,
 -1,
 552340499,
 7729,
 -1,
 551973013,
 312,
 552607993,
 551884451,
 98,
 552673528,
 552535551,
 -1,
 552739060,
 552609106,
 -1,
 -57101,
 552671217,
 7685,
 -1,
 552733400,
 7683,
 -57099,
 552699944,
 387,
 -57098,
 552894825,
 384,
 -57097,
 552948038,
 7687,
 -1,
 553008506,
 595,
 -1,
 552604679,
 629,
 553263359,
 552561173,
 112,
 553328894,
 553190911,
 -1,
 -57092,
 553270650,
 421,
 -57091,
 553330007,
 7767,
 -1,
 553389075,
 7765,
 -1,
 553270341,
 632,
 553656582,
 553211183,
 109,
 553779199,
 553584127,
 -1,
 553787652,
 553657682,
 -1,
 -57085,
 553719793,
 7747,
 -1,
 553781976,
 7745,
 -57083,
 553729402,
 625,
 -1,
 553913363,
 7743,
 554115339,
 553619834,
 118,
 554237951,
 554042879,
 -1,
 -57079,
 554141327,
 7805,
 -57078,
 554188154,
 651,
 -1,
 554247521,
 7807,
 554443024,
 554059949,
 106,
 554565631,
 554370577,
 -1,
 -57074,
 554465440,
 669,
 -57073,
 554518224,
 309,
 -1,
 554570722,
 496,
 554770709,
 554382016,
 102,
 554836244,
 554698239,
 -1,
 -57069,
 554777978,
 402,
 -1,
 554837335,
 7711,
 -1,
 554774120,
 681,
 555098393,
 554735909,
 120,
 555220991,
 555026047,
 -1,
 -57064,
 555116283,
 7819,
 -1,
 555171808,
 7821,
 555417599,
 555052746,
 113,
 -1,
 555288357,
 672,
 555548671,
 522076598,
 -1,
 555557154,
 555430592,
 -1,
 555622688,
 555496128,
 64256,
 -57057,
 555567949,
 64260,
 -1,
 555630465,
 64259,
 -57055,
 555567949,
 64258,
 -1,
 555761537,
 64257,
 -57053,
 555516125,
 64262,
 -57052,
 555901368,
 339,
 -57051,
 555963211,
 64261,
 -1,
 556024491,
 307,
 556212950,
 522001226,
 -1,
 556278485,
 556143152,
 -1,
 556344018,
 556216749,
 -1,
 556409184,
 556294415,
 79,
 556474715,
 556336639,
 -1,
 556540212,
 556416327,
 -1,
 556605747,
 556496876,
 416,
 556728319,
 556531801,
 -1,
 -57041,
 556631695,
 7904,
 -57040,
 556678527,
 7902,
 -57039,
 556742625,
 7900,
 -57038,
 556803425,
 7906,
 -1,
 556862483,
 7898,
 -1,
 556556921,
 7886,
 557130047,
 556474754,
 -1,
 557195581,
 557080847,
 -1,
 557261114,
 557154958,
 -1,
 557326649,
 557189848,
 558,
 -1,
 557252832,
 560,
 -1,
 557258737,
 7884,
 557580287,
 557222722,
 -1,
 -57028,
 557463521,
 524,
 -1,
 557517843,
 336,
 557776895,
 557137888,
 214,
 -1,
 557646048,
 554,
 557850952,
 557062986,
 -1,
 557916487,
 557795024,
 212,
 558039039,
 557842521,
 -1,
 -57021,
 557942415,
 7894,
 -57020,
 557989247,
 7892,
 -57019,
 558053345,
 7890,
 -57018,
 558114145,
 7896,
 -1,
 558173203,
 7888,
 -1,
 557847522,
 465,
 558440781,
 557811343,
 213,
 558563327,
 558366809,
 -1,
 -57013,
 558454075,
 556,
 -57012,
 558506835,
 7758,
 -1,
 558566419,
 7756,
 558768467,
 558388527,
 -1,
 558834002,
 558697477,
 332,
 558956543,
 558760025,
 -1,
 -57007,
 558839777,
 7760,
 -1,
 558894099,
 7762,
 -1,
 558776460,
 415,
 559161685,
 558727529,
 216,
 -1,
 559087711,
 510,
 559292759,
 559112684,
 490,
 -1,
 559218912,
 492,
 -57000,
 559236600,
 526,
 -56999,
 559364065,
 210,
 -56998,
 559422067,
 334,
 -1,
 559483923,
 211,
 559685982,
 556428162,
 -1,
 -56995,
 559636751,
 390,
 -1,
 559687959,
 400,
 -56993,
 559647476,
 546,
 -1,
 559824769,
 418,
 560013707,
 556337789,
 65,
 560079238,
 559941119,
 -1,
 560144747,
 560012106,
 -1,
 560210282,
 560088784,
 194,
 560332799,
 560136281,
 -1,
 -56986,
 560236175,
 7850,
 -56985,
 560283007,
 7848,
 -56984,
 560347105,
 7846,
 -56983,
 560407905,
 7852,
 -1,
 560466963,
 7844,
 -1,
 560141282,
 461,
 560734580,
 560079234,
 -1,
 560800114,
 560685327,
 -1,
 560865649,
 560759438,
 -1,
 560931184,
 560794328,
 550,
 -1,
 560857312,
 480,
 -1,
 560863217,
 7840,
 -1,
 560827219,
 512,
 561250303,
 560742368,
 196,
 -1,
 561119456,
 478,
 561324411,
 560667251,
 258,
 561446911,
 561250393,
 -1,
 -56969,
 561350287,
 7860,
 -56968,
 561397119,
 7858,
 -56967,
 561461217,
 7856,
 -56966,
 561522017,
 7862,
 -1,
 561581075,
 7854,
 561783167,
 561280716,
 -1,
 561848702,
 561711832,
 197,
 -1,
 561774687,
 506,
 -1,
 561780721,
 7680,
 -56960,
 561743503,
 195,
 -56959,
 561996268,
 260,
 -56958,
 562058555,
 256,
 -56957,
 562120184,
 514,
 -56956,
 562183551,
 7842,
 -56955,
 562247649,
 192,
 -1,
 562301971,
 193,
 562504074,
 560015639,
 198,
 562626559,
 562431487,
 -1,
 -56951,
 562517307,
 482,
 -1,
 562564115,
 508,
 -1,
 562443553,
 393,
 562831797,
 559975156,
 85,
 562897332,
 562759167,
 -1,
 562962843,
 562831746,
 -1,
 563028374,
 562905056,
 220,
 563150847,
 562954240,
 -1,
 563159445,
 563023906,
 -1,
 -56942,
 563107131,
 469,
 -56941,
 563165153,
 475,
 -56940,
 563223642,
 473,
 -1,
 563285011,
 471,
 -1,
 563091441,
 7794,
 563609599,
 562979087,
 -1,
 563618202,
 563514178,
 -1,
 -56935,
 563558369,
 532,
 -1,
 563612691,
 368,
 -1,
 563577497,
 7908,
 563880356,
 562904391,
 -1,
 563945891,
 563836908,
 431,
 564068351,
 563871833,
 -1,
 -56929,
 563971727,
 7918,
 -56928,
 564018559,
 7916,
 -56927,
 564082657,
 7914,
 -56926,
 564143457,
 7920,
 -1,
 564202515,
 7912,
 -1,
 563896953,
 7910,
 564470184,
 563840655,
 360,
 564592639,
 564396032,
 -1,
 -56921,
 564467697,
 7796,
 -1,
 564531239,
 7800,
 564732332,
 564403018,
 -1,
 564797867,
 564676304,
 219,
 -1,
 564724125,
 7798,
 -1,
 564728802,
 467,
 564994478,
 564679995,
 362,
 -1,
 564920437,
 7802,
 -56913,
 564950738,
 366,
 -56912,
 565076460,
 370,
 -56911,
 565134840,
 534,
 -56910,
 565196769,
 217,
 -56909,
 565254771,
 364,
 -1,
 565316627,
 218,
 -1,
 562851479,
 433,
 565584350,
 562768151,
 69,
 565649879,
 565511679,
 -1,
 565715396,
 565582666,
 -1,
 565780929,
 565659344,
 202,
 565903359,
 565706752,
 -1,
 565912000,
 565776418,
 -1,
 -56900,
 565872271,
 7876,
 -56899,
 565919103,
 7874,
 -56898,
 565983201,
 7872,
 -56897,
 566044001,
 7878,
 -1,
 566103059,
 7870,
 -1,
 565843953,
 7704,
 566370755,
 565717707,
 552,
 -1,
 566296682,
 7708,
 -1,
 566301666,
 282,
 566567371,
 565649794,
 -1,
 566632906,
 566518031,
 -1,
 566698441,
 566592142,
 -1,
 -56888,
 566630385,
 7864,
 -1,
 566692568,
 278,
 -1,
 566659923,
 516,
 -1,
 566575072,
 203,
 567026127,
 566515003,
 274,
 567148543,
 566952025,
 -1,
 -56882,
 567031777,
 7700,
 -1,
 567086099,
 7702,
 567288273,
 566986383,
 7868,
 -1,
 567214493,
 7706,
 -56878,
 567239148,
 280,
 -56877,
 567363064,
 518,
 -56876,
 567426431,
 7866,
 -56875,
 567490529,
 200,
 -56874,
 567548531,
 276,
 -1,
 567610387,
 201,
 567812571,
 565615656,
 439,
 567934975,
 567738368,
 -1,
 -56870,
 567842544,
 494,
 -1,
 567898837,
 440,
 -56868,
 567772425,
 208,
 -56867,
 568032484,
 425,
 -1,
 568089765,
 330,
 568271350,
 565526401,
 73,
 568336885,
 568198655,
 -1,
 568402408,
 568271234,
 -1,
 568467942,
 568353039,
 -1,
 568533477,
 568427150,
 -1,
 -56860,
 568465393,
 7882,
 -1,
 568527576,
 304,
 -1,
 568494931,
 520,
 568852479,
 568410080,
 207,
 -1,
 568721503,
 7726,
 568926698,
 568362639,
 296,
 -1,
 568852893,
 7724,
 569057773,
 568859466,
 -1,
 -56852,
 569001680,
 206,
 -1,
 569054178,
 463,
 -56850,
 569016681,
 407,
 -56849,
 569205228,
 302,
 -56848,
 569267515,
 298,
 -56847,
 569329144,
 522,
 -56846,
 569392511,
 7880,
 -56845,
 569456609,
 204,
 -56844,
 569514611,
 300,
 -1,
 569576467,
 205,
 -1,
 568289048,
 406,
 569844234,
 568230540,
 84,
 569909764,
 569771519,
 -1,
 569975293,
 569842506,
 -1,
 -56838,
 569926444,
 538,
 -56837,
 569984747,
 7792,
 -56836,
 570043083,
 354,
 -1,
 570102754,
 356,
 570302976,
 569910610,
 -1,
 -56833,
 570234865,
 7788,
 -1,
 570297048,
 7786,
 -56831,
 570261865,
 358,
 -56830,
 570454697,
 430,
 -56829,
 570511686,
 7790,
 -1,
 570572154,
 428,
 570761736,
 569861054,
 -1,
 -56826,
 570722860,
 423,
 -56825,
 570785510,
 388,
 -1,
 570831938,
 444,
 -56823,
 570724441,
 412,
 -1,
 570965592,
 222,
 571154972,
 569793186,
 78,
 571220507,
 571082239,
 -1,
 571286032,
 571165517,
 -1,
 -56818,
 571237372,
 544,
 -56817,
 571294831,
 7752,
 -1,
 571353954,
 413,
 571548180,
 571218762,
 -1,
 -56814,
 571492075,
 7754,
 -56813,
 571550411,
 325,
 -1,
 571610082,
 327,
 571810327,
 571483474,
 -1,
 -56810,
 571742193,
 7750,
 -1,
 571804376,
 7748,
 -56808,
 571770511,
 209,
 -56807,
 571965325,
 459,
 -56806,
 572012513,
 504,
 -1,
 572066835,
 323,
 -1,
 571164845,
 458,
 572334638,
 571089282,
 68,
 572400172,
 572261887,
 -1,
 572465698,
 572357259,
 -1,
 572531233,
 572413511,
 498,
 -1,
 572458521,
 453,
 -1,
 572492092,
 272,
 572727846,
 572398410,
 -1,
 -56796,
 572671723,
 7698,
 -56795,
 572730059,
 7696,
 -1,
 572789730,
 270,
 572989993,
 572663122,
 -1,
 -56792,
 572921841,
 7692,
 -1,
 572984024,
 7690,
 -56790,
 572950568,
 395,
 -56789,
 573133126,
 7694,
 -1,
 573193594,
 394,
 573439999,
 572365774,
 497,
 -1,
 573310489,
 452,
 573514301,
 572299731,
 89,
 573579836,
 573441535,
 -1,
 573645365,
 573514114,
 -1,
 573710900,
 573597431,
 -1,
 -56781,
 573642737,
 7924,
 -1,
 573704920,
 7822,
 -1,
 573652960,
 376,
 573973047,
 573586810,
 435,
 -1,
 573898757,
 7926,
 -56776,
 573933199,
 7928,
 -56775,
 574051643,
 562,
 -56774,
 574109665,
 7922,
 -56773,
 574168617,
 374,
 -1,
 574229523,
 221,
 -1,
 573530600,
 540,
 574497356,
 573471371,
 83,
 574562891,
 574424575,
 -1,
 574628421,
 574495562,
 -1,
 574693954,
 574559202,
 352,
 -1,
 574619780,
 7782,
 -56765,
 574645036,
 536,
 -56764,
 574768848,
 348,
 -1,
 574827211,
 350,
 575021641,
 574563666,
 -1,
 575087176,
 574953457,
 7778,
 -1,
 575012996,
 7784,
 -1,
 575015640,
 7776,
 575340543,
 574950419,
 346,
 -1,
 575209604,
 7780,
 -1,
 574496149,
 399,
 575480411,
 574442317,
 76,
 575545946,
 575407615,
 -1,
 575611474,
 575478602,
 -1,
 -56752,
 575555307,
 7740,
 -56751,
 575613643,
 315,
 -1,
 575673314,
 317,
 575873621,
 575568523,
 -1,
 -56748,
 575834428,
 321,
 -1,
 575886905,
 456,
 576070231,
 575808865,
 7734,
 -1,
 575996128,
 7736,
 -56744,
 576018519,
 319,
 -56743,
 576147782,
 7738,
 -1,
 576195603,
 313,
 -1,
 575490221,
 455,
 576463466,
 575434865,
 82,
 576529001,
 576390655,
 -1,
 576594531,
 576464113,
 -1,
 576660066,
 576553614,
 -1,
 576725601,
 576591857,
 7770,
 -1,
 576651488,
 7772,
 -1,
 576654040,
 7768,
 -1,
 576621395,
 528,
 576987750,
 576527178,
 -1,
 -56731,
 576924363,
 342,
 -1,
 576984034,
 344,
 -56729,
 576934214,
 7774,
 -56728,
 577127928,
 530,
 -1,
 577178643,
 340,
 -1,
 576467471,
 398,
 577446519,
 576402839,
 71,
 577512054,
 577373695,
 -1,
 577577584,
 577444682,
 -1,
 -56722,
 577521360,
 284,
 -56721,
 577579723,
 290,
 -1,
 577639394,
 486,
 -56719,
 577536361,
 484,
 -56718,
 577787195,
 7712,
 -56717,
 577846650,
 403,
 -56716,
 577906007,
 288,
 -56715,
 577968755,
 286,
 -1,
 578030611,
 500,
 -1,
 577441724,
 404,
 578298501,
 577386824,
 72,
 578364036,
 578225663,
 -1,
 578429566,
 578298242,
 -1,
 578495101,
 578381559,
 -1,
 -56708,
 578426865,
 7716,
 -1,
 578489048,
 7714,
 -1,
 578437088,
 7718,
 578757250,
 578362186,
 -1,
 -56704,
 578701008,
 292,
 -56703,
 578759371,
 7720,
 -1,
 578819042,
 542,
 -56701,
 578716009,
 294,
 -1,
 578951801,
 7722,
 -1,
 578327820,
 502,
 579216017,
 578264014,
 90,
 579338239,
 579143167,
 -1,
 579347082,
 579216722,
 -1,
 -56695,
 579278833,
 7826,
 -1,
 579341016,
 379,
 579543693,
 579279690,
 -1,
 -56692,
 579487440,
 7824,
 -1,
 579539938,
 381,
 -56690,
 579502441,
 437,
 -56689,
 579686726,
 7828,
 -56688,
 579747194,
 548,
 -1,
 579800083,
 377,
 580002460,
 579179743,
 87,
 580067995,
 579929599,
 -1,
 580133528,
 580002178,
 -1,
 580199063,
 580085495,
 -1,
 -56682,
 580130801,
 7816,
 -1,
 580192984,
 7814,
 -1,
 580141024,
 7812,
 -56679,
 580073441,
 7808,
 -56678,
 580394537,
 372,
 -1,
 580455443,
 7810,
 -1,
 580033335,
 503,
 580723366,
 579935050,
 67,
 580845567,
 580650495,
 -1,
 580854435,
 580721482,
 -1,
 580919969,
 580790987,
 199,
 -1,
 580845663,
 7688,
 -56670,
 580863696,
 264,
 -1,
 580981730,
 268,
 -56668,
 580795770,
 391,
 -56667,
 581117271,
 266,
 -1,
 581176339,
 262,
 581378735,
 580667811,
 75,
 581500927,
 581305855,
 -1,
 581509803,
 581376842,
 -1,
 -56662,
 581446347,
 310,
 -1,
 581506018,
 488,
 -56660,
 581456198,
 7732,
 -56659,
 581647738,
 408,
 -56658,
 581707105,
 7730,
 -1,
 581766163,
 7728,
 581968567,
 581310115,
 66,
 582090751,
 581895679,
 -1,
 582099636,
 581969234,
 -1,
 -56653,
 582031345,
 7684,
 -1,
 582093528,
 7682,
 -56651,
 582060072,
 386,
 -56650,
 582242630,
 7686,
 -1,
 582303098,
 385,
 582492860,
 581931386,
 86,
 582615039,
 582419967,
 -1,
 -56646,
 582518415,
 7804,
 -56645,
 582565242,
 434,
 -1,
 582624609,
 7806,
 582820545,
 582445589,
 80,
 582942719,
 582747647,
 -1,
 -56641,
 582827386,
 420,
 -56640,
 582886743,
 7766,
 -1,
 582945811,
 7764,
 583148231,
 582767919,
 77,
 583270399,
 583075327,
 -1,
 583279302,
 583148882,
 -1,
 -56635,
 583210993,
 7746,
 -1,
 583273176,
 7744,
 -1,
 583207955,
 7742,
 583541451,
 583112997,
 88,
 583663615,
 583468671,
 -1,
 -56630,
 583558907,
 7818,
 -1,
 583614432,
 7820,
 583803599,
 583480000,
 70,
 583925759,
 583730687,
 -1,
 -56626,
 583810426,
 401,
 -1,
 583869783,
 7710,
 584065745,
 583747757,
 74,
 -1,
 583992907,
 308,
 -1,
 584019658,
 81,
 584318975,
 556286390,
 -1,
 -56620,
 584212920,
 338,
 -1,
 584270507,
 306,
 -1,
 556234895,
 10013,
 584581119,
 556159044,
 -1,
 584590053,
 584481419,
 -1,
 584655588,
 584537588,
 -1,
 584721115,
 584597377,
 618,
 -1,
 584671391,
 641,
 584852189,
 584660375,
 610,
 -1,
 584779557,
 667,
 -56610,
 584817107,
 655,
 -56609,
 584937585,
 640,
 -56608,
 584999352,
 630,
 -56607,
 585063074,
 628,
 -56606,
 585124685,
 671,
 -56605,
 585185608,
 668,
 -1,
 585242275,
 665,
 -1,
 584616051,
 663,
 585507562,
 584544702,
 -1,
 585573097,
 585470679,
 -1,
 -56600,
 585512756,
 674,
 -1,
 585576590,
 426,
 -1,
 585533723,
 451,
 585835247,
 585439428,
 -1,
 585900782,
 585780154,
 -1,
 -56595,
 585853911,
 684,
 -1,
 585899672,
 664,
 -1,
 585835234,
 685,
 586162929,
 585778709,
 662,
 -1,
 586090388,
 446,
 586294003,
 586102567,
 660,
 -1,
 586221460,
 673,
 -56588,
 586259311,
 422,
 -56587,
 586389792,
 447,
 -56586,
 586451651,
 443,
 -56585,
 586509423,
 661,
 -56584,
 586566896,
 449,
 -56583,
 586621653,
 448,
 -1,
 586682188,
 450,
 586883922,
 521953553,
 -1,
 586949410,
 586829892,
 -1,
 587014913,
 586908300,
 -1,
 587080448,
 586956106,
 -1,
 -56577,
 587039550,
 3735,
 -1,
 587104724,
 3734,
 -1,
 587030799,
 3733,
 587342598,
 586967573,
 -1,
 587408133,
 587283786,
 -1,
 -56572,
 587367230,
 3742,
 -1,
 587432404,
 3740,
 -1,
 587358479,
 3739,
 587670282,
 587291298,
 -1,
 -56568,
 587635515,
 3725,
 -56567,
 587686159,
 3737,
 -1,
 587741018,
 3719,
 587932431,
 587614627,
 -1,
 587997966,
 587873610,
 -1,
 -56563,
 587957054,
 3716,
 -1,
 588022228,
 3714,
 -1,
 587948303,
 3713,
 588260114,
 587890623,
 -1,
 -56559,
 588219198,
 3722,
 -1,
 588284372,
 3754,
 588456725,
 588206790,
 -1,
 -56556,
 588407946,
 3749,
 -1,
 588465273,
 3747,
 588653336,
 588397898,
 -1,
 -56553,
 588612414,
 3758,
 -1,
 588677588,
 3755,
 588849947,
 588592302,
 -1,
 -56550,
 588809022,
 3741,
 -1,
 588874196,
 3743,
 -56548,
 588815163,
 3746,
 -56547,
 589011097,
 3751,
 -56546,
 589062415,
 3757,
 -56545,
 589125940,
 3745,
 -56544,
 589178097,
 3732,
 -56543,
 589242092,
 3720,
 -1,
 589306272,
 3738,
 589505332,
 586912961,
 -1,
 589570856,
 589433469,
 3760,
 -56539,
 589535699,
 3779,
 -56538,
 589583663,
 3763,
 -56537,
 589643649,
 3780,
 -1,
 589695613,
 3762,
 589898538,
 589535699,
 3766,
 -1,
 589863379,
 3767,
 590029612,
 589859572,
 3768,
 -1,
 589990644,
 3769,
 590160687,
 589976957,
 -1,
 -56530,
 590111564,
 3771,
 -1,
 590155774,
 3761,
 590357297,
 590102401,
 3764,
 -1,
 590299009,
 3765,
 590488371,
 590293271,
 3776,
 -1,
 590430081,
 3777,
 -1,
 590438671,
 3778,
 590684994,
 589440022,
 -1,
 590750520,
 590643852,
 -1,
 -56521,
 590715033,
 3794,
 -1,
 590757539,
 3795,
 590947131,
 590707339,
 -1,
 -56518,
 590891153,
 3798,
 -1,
 590950863,
 3799,
 591143742,
 590885568,
 -1,
 -56515,
 591095805,
 3796,
 -1,
 591153218,
 3797,
 -56513,
 591109150,
 3792,
 -56512,
 591291322,
 3793,
 -56511,
 591355212,
 3801,
 -1,
 591408282,
 3800,
 591602504,
 590645170,
 -1,
 591668038,
 591561356,
 -1,
 -56507,
 591609729,
 3786,
 -1,
 591674695,
 3785,
 -56505,
 591604985,
 3784,
 -1,
 591797349,
 3787,
 591995723,
 591559772,
 -1,
 -56502,
 591945976,
 3773,
 -1,
 592007875,
 3772,
 592192334,
 591936842,
 -1,
 -56499,
 592141808,
 3804,
 -1,
 592206132,
 3805,
 -56497,
 592141616,
 3789,
 -56496,
 592333494,
 3782,
 -56495,
 592391483,
 3759,
 -1,
 592452526,
 3788,
 592651099,
 586838841,
 -1,
 592716633,
 592576512,
 -1,
 -56491,
 592678545,
 10200,
 -56490,
 592742631,
 11004,
 -56489,
 592793294,
 10782,
 -56488,
 592848896,
 10201,
 -1,
 592911807,
 9711,
 593166335,
 592670838,
 10923,
 -1,
 593036364,
 10925,
 -56484,
 592609504,
 9790,
 -1,
 593190154,
 917505,
 593372218,
 521873687,
 -1,
 593437715,
 593311027,
 -1,
 593503171,
 593362944,
 -1,
 593568624,
 593459851,
 -1,
 593634156,
 593522594,
 91,
 593756159,
 593559552,
 -1,
 593765225,
 593663697,
 -1,
 593830759,
 593725012,
 -1,
 -56474,
 593790937,
 10637,
 -1,
 593828321,
 10639,
 -56472,
 593792343,
 10635,
 -1,
 593981481,
 8261,
 -56470,
 593727218,
 9121,
 -56469,
 594105369,
 9123,
 -1,
 594162313,
 9122,
 594355055,
 593570071,
 -1,
 -56466,
 594317922,
 9609,
 -1,
 594368647,
 8907,
 -1,
 594298028,
 8216,
 594617214,
 593523673,
 -1,
 594682744,
 594547727,
 8596,
 594804735,
 594608128,
 -1,
 594813815,
 594712273,
 -1,
 -56459,
 594777027,
 8697,
 -56458,
 594837865,
 8622,
 -1,
 594880196,
 8700,
 -1,
 594773540,
 10568,
 595141500,
 594617890,
 8660,
 595263487,
 595068415,
 -1,
 -56453,
 595170243,
 10500,
 -1,
 595231081,
 8654,
 -56451,
 595105192,
 8621,
 -1,
 595354844,
 8703,
 595534728,
 594580703,
 -1,
 595600263,
 595475740,
 -1,
 595665795,
 595532618,
 -1,
 -56446,
 595628067,
 10627,
 -1,
 595682880,
 12302,
 -56444,
 595626031,
 12312,
 -56443,
 595820628,
 12314,
 -56442,
 595880649,
 10629,
 -1,
 595939239,
 12310,
 -1,
 595542491,
 10712,
 596190096,
 595467082,
 -1,
 596255630,
 596152355,
 123,
 596377599,
 596180992,
 -1,
 -56436,
 596283156,
 9127,
 -56435,
 596334702,
 9128,
 -1,
 596399168,
 9129,
 -56433,
 596207168,
 12300,
 -1,
 596520158,
 8968,
 596714395,
 596121251,
 -1,
 596779928,
 596644632,
 -1,
 596845461,
 596741762,
 -1,
 -56428,
 596807162,
 10574,
 -1,
 596846437,
 10570,
 597098495,
 596781039,
 -1,
 -56425,
 597003770,
 10571,
 -1,
 597043045,
 10576,
 597295103,
 596724700,
 -1,
 -56422,
 597198895,
 10647,
 -1,
 597249959,
 12304,
 597435298,
 596673164,
 -1,
 597500831,
 597376680,
 -1,
 -56418,
 597454807,
 9610,
 -1,
 597503177,
 9613,
 -56416,
 597455732,
 10703,
 -56415,
 597649039,
 12308,
 -1,
 597691361,
 8867,
 597894058,
 597363325,
 -1,
 597959593,
 597842594,
 -1,
 598025126,
 597899035,
 12296,
 -1,
 597952192,
 10641,
 598212607,
 597959078,
 -1,
 -56408,
 598115056,
 10203,
 -1,
 598156979,
 10202,
 -1,
 597913956,
 10643,
 598418351,
 597846729,
 40,
 598540287,
 598343680,
 -1,
 -56403,
 598445844,
 9115,
 -56402,
 598496320,
 9117,
 -1,
 598553225,
 9116,
 598746036,
 598368527,
 -1,
 598811571,
 598694993,
 -1,
 -56398,
 598765504,
 9614,
 -1,
 598813863,
 9615,
 -1,
 598774049,
 10197,
 599073721,
 598684352,
 -1,
 599139256,
 599015297,
 -1,
 -56393,
 599101953,
 9611,
 -1,
 599162098,
 10620,
 -1,
 599085933,
 8970,
 599401405,
 599008715,
 -1,
 -56389,
 599365305,
 10714,
 -56388,
 599420992,
 8220,
 -1,
 599462188,
 12298,
 599663552,
 599341622,
 -1,
 -56385,
 599613856,
 9612,
 -1,
 599657445,
 9686,
 -56383,
 599626574,
 9144,
 -56382,
 599809582,
 8905,
 -1,
 599874075,
 10204,
 600056839,
 593466647,
 -1,
 600122333,
 599987215,
 8592,
 600187868,
 600047616,
 -1,
 600253390,
 600151761,
 -1,
 -56376,
 600216515,
 8695,
 -56375,
 600277773,
 8610,
 -56374,
 600342889,
 8602,
 -56373,
 600403235,
 10566,
 -56372,
 600462184,
 8619,
 -56371,
 600522106,
 8617,
 -1,
 600581828,
 8698,
 600777686,
 600212108,
 -1,
 600843219,
 600727834,
 -1,
 600908754,
 600773278,
 8676,
 -1,
 600835196,
 8633,
 -1,
 600853474,
 10525,
 601161727,
 600784613,
 -1,
 -56363,
 601063845,
 10618,
 -1,
 601116615,
 10615,
 601301976,
 600716586,
 8612,
 -1,
 601228745,
 10527,
 601433051,
 601230046,
 -1,
 -56358,
 601392812,
 10611,
 -1,
 601456038,
 10563,
 -1,
 601385162,
 8646,
 -1,
 600115720,
 10521,
 601760753,
 600062708,
 -1,
 601826288,
 601724645,
 -1,
 601891817,
 601787858,
 -1,
 601957352,
 601817088,
 -1,
 602022886,
 601885406,
 -1,
 602088421,
 601967437,
 -1,
 -56348,
 602039275,
 10602,
 -1,
 602090455,
 10594,
 -1,
 602043999,
 10598,
 -56345,
 601982806,
 10578,
 -1,
 602289450,
 10586,
 -1,
 601920785,
 8636,
 602603519,
 601827121,
 -1,
 602612719,
 602472448,
 -1,
 -56340,
 602572630,
 10582,
 -56339,
 602617130,
 10590,
 -56338,
 602675198,
 10603,
 -1,
 602737496,
 10599,
 -1,
 602576145,
 8637,
 -1,
 601778400,
 8651,
 603071484,
 601694594,
 -1,
 603137019,
 603023239,
 -1,
 603202554,
 603067407,
 8656,
 603268089,
 603127808,
 -1,
 603333624,
 603231953,
 -1,
 -56329,
 603296707,
 10498,
 -1,
 603357545,
 8653,
 -1,
 603272490,
 10502,
 -1,
 603195912,
 10523,
 -1,
 603136547,
 10508,
 -1,
 603067601,
 8672,
 603792385,
 603030156,
 -1,
 603857920,
 603748100,
 -1,
 -56321,
 603791907,
 10510,
 -1,
 603853839,
 8666,
 -1,
 603822277,
 8606,
 604120068,
 603755743,
 -1,
 -56317,
 604060962,
 8678,
 -1,
 604116543,
 8604,
 -56315,
 604078187,
 8668,
 -56314,
 604269148,
 8647,
 -1,
 604333276,
 8701,
 604569599,
 599984114,
 -1,
 604578828,
 604473220,
 -1,
 -56310,
 604530994,
 8237,
 -56309,
 604591787,
 8206,
 -1,
 604646793,
 8234,
 604840976,
 604532096,
 -1,
 -56306,
 604775924,
 171,
 -56305,
 604840266,
 10748,
 -1,
 604901676,
 9001,
 605159423,
 604797579,
 -1,
 -56302,
 605044888,
 10553,
 -1,
 605108612,
 10154,
 605299769,
 593395845,
 -1,
 605365281,
 605249807,
 -1,
 605430816,
 605319283,
 -1,
 605496347,
 605388580,
 10877,
 605618175,
 605423306,
 -1,
 605627418,
 605489880,
 10881,
 -1,
 605553955,
 10883,
 -1,
 605570315,
 10879,
 605824030,
 605433684,
 -1,
 -56291,
 605767729,
 8818,
 -1,
 605818273,
 8804,
 -56289,
 605763572,
 8822,
 -1,
 605950589,
 10885,
 -1,
 605393528,
 8806,
 606217262,
 605293181,
 -1,
 606282795,
 606149168,
 -1,
 606348328,
 606239371,
 -1,
 606413863,
 606290814,
 -1,
 -56282,
 606364973,
 10893,
 -1,
 606407415,
 10895,
 -1,
 606358613,
 10899,
 -56279,
 606293758,
 10614,
 -56278,
 606615553,
 10897,
 -1,
 606676699,
 10891,
 606928895,
 606231496,
 -1,
 -56275,
 606830264,
 10887,
 -1,
 606887577,
 10889,
 607069234,
 606181073,
 -1,
 -56272,
 607023125,
 10875,
 -56271,
 607069518,
 8918,
 -1,
 607133134,
 10873,
 607331380,
 607002303,
 10918,
 -1,
 607256609,
 10920,
 607462455,
 607263486,
 -1,
 -56266,
 607406129,
 8934,
 -1,
 607456673,
 8808,
 -56264,
 607419943,
 60,
 -1,
 607596411,
 8922,
 -1,
 605249807,
 9804,
 607855752,
 593322255,
 -1,
 607921243,
 607818975,
 -1,
 607986775,
 607858624,
 -1,
 608052294,
 607941593,
 -1,
 608117825,
 608008843,
 -1,
 -56256,
 608057761,
 10065,
 -1,
 608120211,
 10558,
 -56254,
 608077959,
 9727,
 -56253,
 608268087,
 9694,
 -56252,
 608332708,
 9998,
 -56251,
 608381136,
 10063,
 -1,
 608444431,
 10195,
 608642122,
 607997305,
 -1,
 -56248,
 608602247,
 9722,
 -56247,
 608664595,
 10559,
 -1,
 608726839,
 9695,
 608904270,
 608582192,
 -1,
 -56244,
 608847321,
 9691,
 -56243,
 608902591,
 9697,
 -1,
 608967066,
 9604,
 609166417,
 608863689,
 -1,
 -56240,
 609120215,
 9606,
 -1,
 609168585,
 9603,
 609363028,
 609117118,
 -1,
 -56237,
 609316800,
 9602,
 -1,
 609365159,
 9601,
 -56235,
 609320128,
 9607,
 -56234,
 609498183,
 9605,
 -1,
 609556856,
 9987,
 609812479,
 607911936,
 -1,
 -56231,
 609702203,
 95,
 -56230,
 609756790,
 12319,
 -1,
 609817901,
 8270,
 610018416,
 607870120,
 -1,
 610083943,
 609963380,
 -1,
 610149474,
 610047255,
 -1,
 610215008,
 610084386,
 10232,
 -1,
 610140839,
 10237,
 610402303,
 610145295,
 10229,
 -1,
 610271911,
 10235,
 610533375,
 610074624,
 -1,
 610542694,
 610431961,
 -1,
 -56219,
 610477602,
 10234,
 -1,
 610538511,
 10231,
 -1,
 610501360,
 10206,
 610804847,
 610038739,
 -1,
 610870382,
 610768151,
 -1,
 610935915,
 610805282,
 10233,
 -1,
 610861735,
 10238,
 611066989,
 610866191,
 10230,
 -1,
 610992807,
 10236,
 -1,
 611025003,
 10239,
 -1,
 610796957,
 10205,
 -1,
 610738734,
 10982,
 611394694,
 609957596,
 -1,
 611460220,
 611345695,
 8744,
 611581951,
 611385344,
 -1,
 611591291,
 611489489,
 -1,
 611656825,
 611525873,
 -1,
 611722360,
 611617602,
 -1,
 -56201,
 611683671,
 10851,
 -1,
 611739896,
 10850,
 -1,
 611680913,
 10834,
 -56198,
 611604603,
 10843,
 -1,
 611925450,
 10845,
 -1,
 611543305,
 10841,
 612237311,
 611389470,
 8743,
 612302847,
 612107775,
 -1,
 612312195,
 612181233,
 -1,
 612377730,
 612272962,
 -1,
 -56191,
 612339031,
 10848,
 -1,
 612395256,
 10846,
 -1,
 612336273,
 10833,
 -56188,
 612273495,
 10847,
 -56187,
 612587643,
 10842,
 -1,
 612646346,
 10844,
 612892671,
 611359764,
 9674,
 -1,
 612762188,
 10208,
 612967577,
 607797121,
 -1,
 613033104,
 612906605,
 -1,
 613098639,
 612958208,
 -1,
 -56180,
 613061362,
 10072,
 -56179,
 613121283,
 9617,
 -56178,
 613184872,
 10099,
 -1,
 613240475,
 10098,
 -1,
 613047668,
 9735,
 613491863,
 612981841,
 -1,
 613557398,
 613434686,
 -1,
 613622933,
 613521105,
 -1,
 -56172,
 613579828,
 10771,
 -1,
 613642754,
 10770,
 -1,
 613572288,
 10772,
 -1,
 613514354,
 8232,
 -56168,
 613445793,
 8356,
 -1,
 613882436,
 9806,
 -1,
 612893060,
 8468,
 614148419,
 521803427,
 -1,
 614213026,
 614101105,
 -1,
 614278558,
 614141230,
 -1,
 614344093,
 614213040,
 -1,
 614409502,
 614271515,
 10241,
 614474975,
 614337064,
 10243,
 614540480,
 614402616,
 10247,
 614606001,
 614468165,
 10255,
 614671530,
 614533714,
 10271,
 614737063,
 614599263,
 10303,
 614802598,
 614664812,
 10367,
 -1,
 614730361,
 10495,
 -1,
 614730361,
 10431,
 614999209,
 614664812,
 10335,
 -1,
 614926969,
 10463,
 -1,
 614926969,
 10399,
 615195822,
 614599263,
 10287,
 615261357,
 615123564,
 10351,
 -1,
 615189113,
 10479,
 -1,
 615189113,
 10415,
 615457968,
 615123564,
 10319,
 -1,
 615385721,
 10447,
 -1,
 615385721,
 10383,
 615654585,
 614533714,
 10263,
 615720118,
 615582303,
 10295,
 615785653,
 615647852,
 10359,
 -1,
 615713401,
 10487,
 -1,
 615713401,
 10423,
 615982264,
 615647852,
 10327,
 -1,
 615910009,
 10455,
 -1,
 615910009,
 10391,
 616178877,
 615582303,
 10279,
 616244412,
 616106604,
 10343,
 -1,
 616172153,
 10471,
 -1,
 616172153,
 10407,
 616441023,
 616106604,
 10311,
 -1,
 616368761,
 10439,
 -1,
 616368761,
 10375,
 616637648,
 614468165,
 10251,
 616703177,
 616565330,
 10267,
 616768710,
 616630879,
 10299,
 616834245,
 616696428,
 10363,
 -1,
 616761977,
 10491,
 -1,
 616761977,
 10427,
 617030856,
 616696428,
 10331,
 -1,
 616958585,
 10459,
 -1,
 616958585,
 10395,
 617227469,
 616630879,
 10283,
 617293004,
 617155180,
 10347,
 -1,
 617220729,
 10475,
 -1,
 617220729,
 10411,
 617489615,
 617155180,
 10315,
 -1,
 617417337,
 10443,
 -1,
 617417337,
 10379,
 617686232,
 616565330,
 10259,
 617751765,
 617613919,
 10291,
 617817300,
 617679468,
 10355,
 -1,
 617745017,
 10483,
 -1,
 617745017,
 10419,
 618013911,
 617679468,
 10323,
 -1,
 617941625,
 10451,
 -1,
 617941625,
 10387,
 618210524,
 617613919,
 10275,
 618276059,
 618138220,
 10339,
 -1,
 618203769,
 10467,
 -1,
 618203769,
 10403,
 618472670,
 618138220,
 10307,
 -1,
 618400377,
 10435,
 -1,
 618400377,
 10371,
 618669311,
 614402616,
 10245,
 618734832,
 618596933,
 10253,
 618800361,
 618662482,
 10269,
 618865894,
 618728031,
 10301,
 618931429,
 618793580,
 10365,
 -1,
 618859129,
 10493,
 -1,
 618859129,
 10429,
 619128040,
 618793580,
 10333,
 -1,
 619055737,
 10461,
 -1,
 619055737,
 10397,
 619324653,
 618728031,
 10285,
 619390188,
 619252332,
 10349,
 -1,
 619317881,
 10477,
 -1,
 619317881,
 10413,
 619586799,
 619252332,
 10317,
 -1,
 619514489,
 10445,
 -1,
 619514489,
 10381,
 619783416,
 618662482,
 10261,
 619848949,
 619711071,
 10293,
 619914484,
 619776620,
 10357,
 -1,
 619842169,
 10485,
 -1,
 619842169,
 10421,
 620111095,
 619776620,
 10325,
 -1,
 620038777,
 10453,
 -1,
 620038777,
 10389,
 620307708,
 619711071,
 10277,
 620373243,
 620235372,
 10341,
 -1,
 620300921,
 10469,
 -1,
 620300921,
 10405,
 620569854,
 620235372,
 10309,
 -1,
 620497529,
 10437,
 -1,
 620497529,
 10373,
 620766479,
 618596933,
 10249,
 620832008,
 620694098,
 10265,
 620897541,
 620759647,
 10297,
 620963076,
 620825196,
 10361,
 -1,
 620890745,
 10489,
 -1,
 620890745,
 10425,
 621159687,
 620825196,
 10329,
 -1,
 621087353,
 10457,
 -1,
 621087353,
 10393,
 621356300,
 620759647,
 10281,
 621421835,
 621283948,
 10345,
 -1,
 621349497,
 10473,
 -1,
 621349497,
 10409,
 621618446,
 621283948,
 10313,
 -1,
 621546105,
 10441,
 -1,
 621546105,
 10377,
 621815063,
 620694098,
 10257,
 621880596,
 621742687,
 10289,
 621946131,
 621808236,
 10353,
 -1,
 621873785,
 10481,
 -1,
 621873785,
 10417,
 622142742,
 621808236,
 10321,
 -1,
 622070393,
 10449,
 -1,
 622070393,
 10385,
 622339355,
 621742687,
 10273,
 622404890,
 622266988,
 10337,
 -1,
 622332537,
 10465,
 -1,
 622332537,
 10401,
 622601501,
 622266988,
 10305,
 -1,
 622529145,
 10433,
 -1,
 622529145,
 10369,
 622798174,
 614337064,
 10242,
 622863679,
 622725688,
 10246,
 622929200,
 622791237,
 10254,
 622994729,
 622856786,
 10270,
 623060262,
 622922335,
 10302,
 623125797,
 622987884,
 10366,
 -1,
 623053433,
 10494,
 -1,
 623053433,
 10430,
 623322408,
 622987884,
 10334,
 -1,
 623250041,
 10462,
 -1,
 623250041,
 10398,
 623519021,
 622922335,
 10286,
 623584556,
 623446636,
 10350,
 -1,
 623512185,
 10478,
 -1,
 623512185,
 10414,
 623781167,
 623446636,
 10318,
 -1,
 623708793,
 10446,
 -1,
 623708793,
 10382,
 623977784,
 622856786,
 10262,
 624043317,
 623905375,
 10294,
 624108852,
 623970924,
 10358,
 -1,
 624036473,
 10486,
 -1,
 624036473,
 10422,
 624305463,
 623970924,
 10326,
 -1,
 624233081,
 10454,
 -1,
 624233081,
 10390,
 624502076,
 623905375,
 10278,
 624567611,
 624429676,
 10342,
 -1,
 624495225,
 10470,
 -1,
 624495225,
 10406,
 624764222,
 624429676,
 10310,
 -1,
 624691833,
 10438,
 -1,
 624691833,
 10374,
 624960847,
 622791237,
 10250,
 625026376,
 624888402,
 10266,
 625091909,
 624953951,
 10298,
 625157444,
 625019500,
 10362,
 -1,
 625085049,
 10490,
 -1,
 625085049,
 10426,
 625354055,
 625019500,
 10330,
 -1,
 625281657,
 10458,
 -1,
 625281657,
 10394,
 625550668,
 624953951,
 10282,
 625616203,
 625478252,
 10346,
 -1,
 625543801,
 10474,
 -1,
 625543801,
 10410,
 625812814,
 625478252,
 10314,
 -1,
 625740409,
 10442,
 -1,
 625740409,
 10378,
 626009431,
 624888402,
 10258,
 626074964,
 625936991,
 10290,
 626140499,
 626002540,
 10354,
 -1,
 626068089,
 10482,
 -1,
 626068089,
 10418,
 626337110,
 626002540,
 10322,
 -1,
 626264697,
 10450,
 -1,
 626264697,
 10386,
 626533723,
 625936991,
 10274,
 626599258,
 626461292,
 10338,
 -1,
 626526841,
 10466,
 -1,
 626526841,
 10402,
 626795869,
 626461292,
 10306,
 -1,
 626723449,
 10434,
 -1,
 626723449,
 10370,
 626992510,
 622725688,
 10244,
 627058031,
 626920005,
 10252,
 627123560,
 626985554,
 10268,
 627189093,
 627051103,
 10300,
 627254628,
 627116652,
 10364,
 -1,
 627182201,
 10492,
 -1,
 627182201,
 10428,
 627451239,
 627116652,
 10332,
 -1,
 627378809,
 10460,
 -1,
 627378809,
 10396,
 627647852,
 627051103,
 10284,
 627713387,
 627575404,
 10348,
 -1,
 627640953,
 10476,
 -1,
 627640953,
 10412,
 627909998,
 627575404,
 10316,
 -1,
 627837561,
 10444,
 -1,
 627837561,
 10380,
 628106615,
 626985554,
 10260,
 628172148,
 628034143,
 10292,
 628237683,
 628099692,
 10356,
 -1,
 628165241,
 10484,
 -1,
 628165241,
 10420,
 628434294,
 628099692,
 10324,
 -1,
 628361849,
 10452,
 -1,
 628361849,
 10388,
 628630907,
 628034143,
 10276,
 628696442,
 628558444,
 10340,
 -1,
 628623993,
 10468,
 -1,
 628623993,
 10404,
 628893053,
 628558444,
 10308,
 -1,
 628820601,
 10436,
 -1,
 628820601,
 10372,
 629089678,
 626920005,
 10248,
 629155207,
 629017170,
 10264,
 629220740,
 629082719,
 10296,
 629286275,
 629148268,
 10360,
 -1,
 629213817,
 10488,
 -1,
 629213817,
 10424,
 629482886,
 629148268,
 10328,
 -1,
 629410425,
 10456,
 -1,
 629410425,
 10392,
 629679499,
 629082719,
 10280,
 629745034,
 629607020,
 10344,
 -1,
 629672569,
 10472,
 -1,
 629672569,
 10408,
 629941645,
 629607020,
 10312,
 -1,
 629869177,
 10440,
 -1,
 629869177,
 10376,
 630138262,
 629017170,
 10256,
 630203795,
 630065759,
 10288,
 630269330,
 630131308,
 10352,
 -1,
 630196857,
 10480,
 -1,
 630196857,
 10416,
 630465941,
 630131308,
 10320,
 -1,
 630393465,
 10448,
 -1,
 630393465,
 10384,
 630662554,
 630065759,
 10272,
 630728089,
 630590060,
 10336,
 -1,
 630655609,
 10464,
 -1,
 630655609,
 10400,
 630924700,
 630590060,
 10304,
 -1,
 630852217,
 10432,
 -1,
 630852217,
 10368,
 -1,
 614275463,
 10240,
 631186849,
 614228610,
 -1,
 -55904,
 631119324,
 9099,
 -1,
 631183122,
 166,
 -1,
 631124427,
 728,
 631449378,
 614177717,
 -1,
 631514580,
 631376509,
 -1,
 631580086,
 631466517,
 -1,
 631645618,
 631529743,
 -1,
 631711150,
 631603554,
 -1,
 631776683,
 631667339,
 118801,
 631898111,
 631701504,
 -1,
 -55894,
 631790725,
 118865,
 -1,
 631841883,
 118802,
 632094719,
 631717763,
 -1,
 -55891,
 631997471,
 118957,
 -1,
 632062573,
 118866,
 632235441,
 631644923,
 -1,
 -55888,
 632183941,
 118916,
 -1,
 632230739,
 118818,
 -1,
 632194371,
 118819,
 632497589,
 631582897,
 -1,
 -55884,
 632461748,
 118835,
 -1,
 632506968,
 118797,
 -1,
 632443081,
 118917,
 632759746,
 631533681,
 -1,
 632825279,
 632703731,
 -1,
 -55879,
 632790124,
 119022,
 -55878,
 632853670,
 119018,
 -55877,
 632908346,
 119017,
 -55876,
 632970522,
 119023,
 -55875,
 633031242,
 119021,
 -55874,
 633091484,
 119019,
 -1,
 633152336,
 119020,
 633405439,
 632764250,
 -1,
 -55871,
 633307771,
 118899,
 -1,
 633363106,
 118935,
 633546191,
 632698729,
 -1,
 633611718,
 633499025,
 -1,
 -55867,
 633550722,
 118945,
 -1,
 633607053,
 118938,
 633808329,
 633558789,
 -1,
 -55864,
 633768066,
 118941,
 -1,
 633830873,
 118942,
 634004940,
 633747325,
 -1,
 -55861,
 633956156,
 118944,
 -1,
 634011521,
 118943,
 634257407,
 633934724,
 -1,
 -55858,
 634152764,
 118939,
 -1,
 634208129,
 118940,
 634454015,
 633494178,
 -1,
 634463699,
 634357372,
 -1,
 -55854,
 634410296,
 118876,
 -1,
 634473285,
 118882,
 -1,
 634394087,
 118824,
 634725887,
 631458211,
 -1,
 634791395,
 634662622,
 -1,
 634856925,
 634749652,
 118800,
 634978303,
 634781696,
 -1,
 634987996,
 634870921,
 -1,
 -55846,
 634935248,
 119024,
 -55845,
 634997281,
 119026,
 -1,
 635048302,
 118862,
 -1,
 634917715,
 118812,
 635371519,
 634781696,
 -1,
 635381218,
 635264137,
 -1,
 -55840,
 635328464,
 119025,
 -55839,
 635390497,
 119027,
 -1,
 635441518,
 118863,
 -1,
 635310931,
 118811,
 635708912,
 634744945,
 -1,
 635774447,
 635639229,
 -1,
 635839980,
 635701885,
 -1,
 635905515,
 635764736,
 -1,
 635971050,
 635832957,
 -1,
 -55831,
 635924874,
 118913,
 -1,
 635982481,
 118914,
 -1,
 635919493,
 118915,
 -1,
 635863764,
 118834,
 636354559,
 635789583,
 -1,
 -55826,
 636263270,
 118868,
 -1,
 636308182,
 118860,
 -1,
 635710850,
 118796,
 636560885,
 635658511,
 -1,
 636626419,
 636510093,
 118842,
 -1,
 636551227,
 118850,
 -55820,
 636586970,
 118858,
 -1,
 636713050,
 118921,
 636888569,
 636505310,
 118820,
 637009919,
 636813312,
 -1,
 -55816,
 636897825,
 119028,
 -1,
 636948846,
 118911,
 637150718,
 636818810,
 -1,
 637216253,
 637081132,
 -1,
 -55812,
 637173568,
 118906,
 -1,
 637208027,
 118839,
 -1,
 637156630,
 118791,
 -1,
 637115127,
 118881,
 637543966,
 634681995,
 -1,
 637609485,
 637485920,
 -1,
 637675015,
 637568346,
 119006,
 637796351,
 637599744,
 -1,
 637806086,
 637698700,
 -1,
 -55803,
 637761342,
 119008,
 -1,
 637809048,
 119009,
 -1,
 637740171,
 119007,
 638124031,
 637604944,
 119010,
 638189567,
 637992960,
 -1,
 638199308,
 638091916,
 -1,
 -55797,
 638154558,
 119012,
 -1,
 638202264,
 119013,
 -1,
 638133387,
 119011,
 638461462,
 637573587,
 -1,
 638526996,
 638409378,
 -1,
 638592531,
 638455006,
 -1,
 -55791,
 638540933,
 118885,
 -55790,
 638605269,
 118827,
 -1,
 638653267,
 118826,
 -1,
 638530135,
 118803,
 638975999,
 638482359,
 118886,
 -1,
 638879370,
 118792,
 639051291,
 638419596,
 -1,
 639116825,
 638981713,
 118910,
 -1,
 639041904,
 118815,
 -55782,
 639070410,
 118852,
 -1,
 639189631,
 119016,
 639378973,
 638987502,
 118825,
 -1,
 639304648,
 118889,
 -1,
 639309417,
 118813,
 639575615,
 637495829,
 -1,
 639641129,
 639532505,
 -1,
 639706662,
 639579191,
 -1,
 639772195,
 639654562,
 118841,
 -1,
 639697864,
 118874,
 -55772,
 639730277,
 118897,
 -55771,
 639855267,
 118895,
 -1,
 639915303,
 118892,
 640155647,
 639650637,
 -1,
 -55768,
 640049996,
 118807,
 -1,
 640106369,
 118784,
 640296498,
 639576343,
 -1,
 640362031,
 640254845,
 -1,
 640427566,
 640320140,
 -1,
 -55763,
 640377480,
 118859,
 -1,
 640434049,
 118857,
 -1,
 640374072,
 118849,
 640689713,
 640306404,
 118840,
 -1,
 640615368,
 118861,
 -1,
 640645001,
 118786,
 640886332,
 640225950,
 -1,
 640951867,
 640814417,
 -1,
 641017400,
 640897524,
 118793,
 641138687,
 640942080,
 -1,
 -55753,
 641031301,
 118878,
 -1,
 641078099,
 118846,
 641335295,
 640945775,
 -1,
 -55750,
 641227909,
 118879,
 -1,
 641274707,
 118845,
 -1,
 640893019,
 118814,
 641597439,
 640827436,
 -1,
 -55746,
 641490053,
 118873,
 -1,
 641536851,
 118822,
 641738333,
 639513280,
 -1,
 641803864,
 641697194,
 -1,
 641869387,
 641737674,
 -1,
 641934919,
 641817250,
 -1,
 642000454,
 641875843,
 -1,
 -55739,
 641944097,
 118977,
 -1,
 641995118,
 118978,
 -1,
 641929225,
 118971,
 -55736,
 641899628,
 118976,
 -55735,
 642214458,
 118970,
 -55734,
 642271818,
 118975,
 -1,
 642327376,
 118973,
 642524750,
 641826578,
 -1,
 -55731,
 642458581,
 118974,
 -1,
 642522489,
 118982,
 642721361,
 642472610,
 -1,
 -55728,
 642657838,
 118983,
 -1,
 642716146,
 118972,
 642917972,
 642667993,
 -1,
 -55725,
 642865517,
 118980,
 -1,
 642917359,
 118979,
 643114582,
 642847571,
 118836,
 -1,
 643039756,
 118969,
 -55721,
 643055558,
 118987,
 -1,
 643182132,
 118988,
 643376732,
 641732819,
 -1,
 -55718,
 643335416,
 118958,
 -55717,
 643389805,
 118959,
 -1,
 643441647,
 118960,
 -1,
 643317503,
 118981,
 643704445,
 641671554,
 -1,
 643769979,
 643645313,
 -1,
 643835496,
 643707051,
 -1,
 643901029,
 643793548,
 -1,
 643966564,
 643855203,
 -1,
 -55709,
 643925723,
 118990,
 -1,
 643971003,
 118995,
 -1,
 643903846,
 118991,
 -55706,
 643848568,
 118993,
 -55705,
 644162589,
 118994,
 -1,
 644223560,
 118992,
 644425328,
 643773847,
 -1,
 644490863,
 644375997,
 118930,
 644612095,
 644416715,
 -1,
 644621934,
 644486081,
 -1,
 -55699,
 644565537,
 118931,
 -1,
 644616558,
 118932,
 -1,
 644555536,
 118933,
 -1,
 644444433,
 119014,
 644949624,
 644352637,
 -1,
 645015159,
 644907333,
 -1,
 645080693,
 644944474,
 -1,
 -55692,
 645022401,
 119002,
 -1,
 645082151,
 119003,
 -55690,
 645039450,
 119005,
 -1,
 645211227,
 119004,
 -1,
 644969295,
 118937,
 645473914,
 644902159,
 118918,
 -1,
 645398906,
 118912,
 -1,
 645412189,
 119015,
 -55684,
 643734331,
 118831,
 -1,
 645600447,
 118785,
 645801628,
 643662476,
 -1,
 645867150,
 645754993,
 -1,
 645932682,
 645817106,
 -1,
 645998213,
 645880484,
 -1,
 646063748,
 645925501,
 -1,
 -55677,
 646017418,
 118838,
 -1,
 646075025,
 118851,
 -1,
 646012037,
 118883,
 646325896,
 645949973,
 -1,
 -55673,
 646282763,
 118891,
 -1,
 646320901,
 118894,
 -55671,
 646283877,
 118896,
 -1,
 646468903,
 118893,
 646709247,
 645873537,
 -1,
 -55668,
 646606095,
 118919,
 -55667,
 646657928,
 118934,
 -1,
 646711933,
 118832,
 646915735,
 645806408,
 -1,
 646981270,
 646850839,
 -1,
 647046805,
 646927672,
 118829,
 647112340,
 647005988,
 -1,
 -55661,
 647076258,
 118903,
 -1,
 647135164,
 118902,
 -1,
 647037288,
 118904,
 -1,
 647002795,
 118905,
 -1,
 646924199,
 118804,
 647505563,
 646850839,
 -1,
 -55655,
 647465056,
 118920,
 -55654,
 647528651,
 118833,
 -1,
 647581565,
 118799,
 -1,
 647447606,
 118823,
 647833267,
 645748015,
 -1,
 647898802,
 647763072,
 -1,
 647964325,
 647856780,
 -1,
 648029858,
 647918435,
 -1,
 -55647,
 647989318,
 118950,
 -1,
 648033458,
 118951,
 648282111,
 647967091,
 -1,
 -55644,
 648171375,
 118953,
 -1,
 648233057,
 118952,
 648423084,
 647916053,
 -1,
 648488617,
 648378568,
 -1,
 -55640,
 648450522,
 118962,
 -1,
 648510106,
 118946,
 648740863,
 648432640,
 -1,
 -55637,
 648643817,
 118963,
 -1,
 648691809,
 118955,
 648881839,
 648351495,
 -1,
 -55634,
 648834692,
 118947,
 -1,
 648880918,
 118949,
 -55632,
 648843738,
 118961,
 -55631,
 649023343,
 118954,
 -1,
 649077526,
 118948,
 -1,
 647840454,
 118871,
 649340613,
 647797203,
 -1,
 649406143,
 649278276,
 -1,
 649471676,
 649363169,
 -1,
 649537209,
 649431166,
 -1,
 -55624,
 649496283,
 118989,
 -1,
 649541563,
 118999,
 -55622,
 649484664,
 118997,
 -55621,
 649667613,
 118998,
 -1,
 649728584,
 118996,
 649986047,
 649419428,
 -1,
 -55618,
 649873953,
 118908,
 -1,
 649924974,
 118909,
 650182655,
 649357845,
 -1,
 650192580,
 650076431,
 -1,
 650258115,
 650136287,
 118794,
 -1,
 650183237,
 118795,
 -1,
 650213797,
 118867,
 -1,
 650149452,
 118864,
 650520280,
 649278871,
 -1,
 650585812,
 650470687,
 -1,
 650651345,
 650524506,
 -1,
 650716880,
 650599076,
 -1,
 650782412,
 650668778,
 -1,
 -55605,
 650715920,
 118929,
 -1,
 650777528,
 118928,
 650979023,
 650730633,
 -1,
 -55602,
 650922529,
 119029,
 -1,
 650973550,
 118927,
 -1,
 650908499,
 118806,
 -1,
 650674811,
 118898,
 651362303,
 650610061,
 -1,
 -55597,
 651240545,
 118965,
 -1,
 651301473,
 118964,
 651503319,
 650522242,
 -1,
 -55594,
 651467418,
 119001,
 -1,
 651502568,
 119000,
 -1,
 651458656,
 118853,
 651765478,
 650469647,
 -1,
 651831007,
 651729283,
 -1,
 651896542,
 651755520,
 -1,
 -55588,
 651844741,
 118856,
 -55587,
 651898126,
 118787,
 -1,
 651961435,
 118788,
 -1,
 651837318,
 118816,
 652224226,
 651795314,
 -1,
 -55583,
 652172421,
 118901,
 -1,
 652219219,
 118828,
 652420837,
 652169513,
 -1,
 -55580,
 652369029,
 118855,
 -1,
 652415827,
 118805,
 -1,
 652367457,
 118875,
 652682996,
 651706241,
 -1,
 652748526,
 652630038,
 -1,
 652814061,
 652686016,
 -1,
 652879596,
 652772773,
 -1,
 -55573,
 652829516,
 118968,
 -1,
 652872317,
 118837,
 -1,
 652829753,
 118967,
 -1,
 652747714,
 118936,
 653207283,
 652704395,
 -1,
 653272818,
 653157199,
 -1,
 -55567,
 653220997,
 118854,
 -1,
 653267795,
 118810,
 -1,
 653200735,
 118956,
 -1,
 653139212,
 118847,
 653600511,
 652618007,
 -1,
 653666040,
 653558981,
 -1,
 -55561,
 653617827,
 118880,
 -1,
 653661074,
 118900,
 653862651,
 653613730,
 -1,
 -55558,
 653796627,
 118907,
 -1,
 653857933,
 118966,
 -55556,
 653826469,
 118798,
 -55555,
 654011248,
 118888,
 -55554,
 654068729,
 118869,
 -1,
 654133993,
 118884,
 654321418,
 653544269,
 -1,
 654386953,
 654256407,
 -1,
 654452488,
 654328726,
 -1,
 654518021,
 654410380,
 -1,
 -55548,
 654472947,
 118924,
 -1,
 654520540,
 118925,
 -55546,
 654459782,
 118926,
 -55545,
 654651017,
 118922,
 -1,
 654715143,
 118923,
 -1,
 654399840,
 118830,
 -1,
 654351009,
 118877,
 655042325,
 654253296,
 -1,
 655107855,
 654997535,
 -1,
 -55539,
 655072379,
 118984,
 -55538,
 655130662,
 118986,
 -1,
 655182498,
 118985,
 655370002,
 655058357,
 -1,
 -55535,
 655318149,
 118887,
 -1,
 655364947,
 118843,
 655622143,
 655298487,
 -1,
 -55532,
 655516492,
 118808,
 -1,
 655572865,
 118870,
 655763229,
 655004028,
 -1,
 655828764,
 655717007,
 -1,
 655894299,
 655753216,
 -1,
 -55527,
 655842437,
 118872,
 -55526,
 655895822,
 118789,
 -1,
 655959131,
 118790,
 -1,
 655835014,
 118817,
 -1,
 655787585,
 118809,
 656287520,
 655716465,
 -1,
 -55521,
 656224855,
 118821,
 -1,
 656282146,
 118844,
 -55519,
 656251285,
 118890,
 -1,
 656431888,
 118848,
 656615474,
 631398671,
 -1,
 656680927,
 656578863,
 -1,
 656746333,
 656624461,
 -1,
 656811858,
 656687623,
 -1,
 656877365,
 656744834,
 -1,
 656942896,
 656826639,
 -1,
 657008429,
 656906341,
 9591,
 657129471,
 656932953,
 -1,
 -55509,
 657028051,
 9484,
 -55508,
 657083764,
 9488,
 -1,
 657145243,
 9516,
 657391615,
 656968520,
 -1,
 -55505,
 657298143,
 9550,
 -1,
 657341851,
 9548,
 657588223,
 656883689,
 -1,
 657598260,
 657493739,
 -1,
 -55501,
 657552699,
 9585,
 -1,
 657608327,
 9586,
 -1,
 657530995,
 9587,
 657860412,
 656838098,
 9589,
 657981439,
 657784921,
 -1,
 657991482,
 657865032,
 -1,
 -55495,
 657941994,
 9524,
 -1,
 657992149,
 9597,
 -55493,
 657945555,
 9492,
 -1,
 658132340,
 9496,
 658319169,
 657822431,
 9474,
 658440191,
 658243673,
 -1,
 -55489,
 658338771,
 9500,
 -55488,
 658394484,
 9508,
 -1,
 658455963,
 9532,
 658646856,
 658248488,
 -1,
 658712389,
 658607577,
 -1,
 -55484,
 658666451,
 9584,
 -1,
 658722164,
 9583,
 658964479,
 658646844,
 -1,
 -55481,
 658863059,
 9581,
 -1,
 658918772,
 9582,
 659105611,
 658606257,
 -1,
 -55478,
 659067615,
 9478,
 -1,
 659111323,
 9476,
 659302222,
 659058525,
 -1,
 -55475,
 659264223,
 9482,
 -1,
 659307931,
 9480,
 659498832,
 659246452,
 9588,
 -1,
 659423379,
 9596,
 -55471,
 659452883,
 9590,
 -1,
 659570075,
 9472,
 659816447,
 656747313,
 -1,
 659826519,
 659706118,
 -1,
 -55467,
 659788654,
 9546,
 -55466,
 659852805,
 9530,
 -1,
 659892082,
 9522,
 660088667,
 659766192,
 -1,
 -55463,
 660050813,
 9533,
 -55462,
 660115057,
 9525,
 -1,
 660154340,
 9517,
 -55460,
 660049451,
 9539,
 -1,
 660285338,
 9541,
 660481928,
 656680177,
 -1,
 660547449,
 660445288,
 -1,
 660612968,
 660492523,
 -1,
 660678499,
 660567001,
 -1,
 -55454,
 660639237,
 9505,
 -1,
 660683656,
 9485,
 660875110,
 660622713,
 -1,
 -55451,
 660835845,
 9513,
 -1,
 660880264,
 9489,
 -55449,
 660835913,
 9543,
 -1,
 661011964,
 9519,
 661202801,
 660552597,
 -1,
 661268332,
 661156825,
 -1,
 -55445,
 661229169,
 9503,
 -1,
 661278949,
 9486,
 661464943,
 661212537,
 -1,
 -55442,
 661425777,
 9511,
 -1,
 661475557,
 9490,
 -55440,
 661425757,
 9537,
 -1,
 661601805,
 9520,
 661792629,
 661159543,
 -1,
 -55437,
 661746779,
 9554,
 -55436,
 661802422,
 9557,
 -1,
 661863898,
 9572,
 662110207,
 661726675,
 -1,
 -55433,
 662009134,
 9555,
 -55432,
 662064744,
 9558,
 -1,
 662126110,
 9573,
 662372351,
 660507458,
 -1,
 662382463,
 662278879,
 9553,
 662503423,
 662306905,
 -1,
 -55427,
 662402003,
 9568,
 -55426,
 662457716,
 9571,
 -1,
 662519195,
 9580,
 662710147,
 662343129,
 -1,
 -55423,
 662664147,
 9562,
 -55422,
 662719860,
 9565,
 -1,
 662781339,
 9577,
 662972295,
 662644540,
 -1,
 -55419,
 662926291,
 9556,
 -55418,
 662982004,
 9559,
 -1,
 663043483,
 9574,
 -1,
 662912411,
 9552,
 663300008,
 660421518,
 -1,
 663365522,
 663233777,
 -1,
 663431055,
 663328869,
 9595,
 663551999,
 663355481,
 -1,
 -55411,
 663450579,
 9487,
 -55410,
 663506292,
 9491,
 -1,
 663567771,
 9523,
 663814143,
 663391048,
 -1,
 -55407,
 663720671,
 9551,
 -1,
 663764379,
 9549,
 663955353,
 663326162,
 9593,
 664076287,
 663879769,
 -1,
 664086423,
 663964493,
 -1,
 -55402,
 664027661,
 9599,
 -1,
 664087341,
 9499,
 -55400,
 664040403,
 9495,
 -1,
 664223131,
 9531,
 664414110,
 663917279,
 9475,
 664535039,
 664338521,
 -1,
 -55396,
 664433619,
 9507,
 -55395,
 664489332,
 9515,
 -1,
 664550811,
 9547,
 664741793,
 664373425,
 -1,
 -55392,
 664703711,
 9479,
 -1,
 664747419,
 9477,
 664938404,
 664694621,
 -1,
 -55389,
 664900319,
 9483,
 -1,
 664944027,
 9481,
 665135014,
 664882548,
 9592,
 -1,
 665059502,
 9598,
 -55385,
 665088979,
 9594,
 -1,
 665206171,
 9473,
 665397187,
 663260629,
 -1,
 665462706,
 665342187,
 -1,
 665528237,
 665416665,
 -1,
 -55380,
 665467784,
 9493,
 -1,
 665528178,
 9506,
 665724848,
 665472377,
 -1,
 -55377,
 665664392,
 9497,
 -1,
 665724786,
 9514,
 -55375,
 665665020,
 9527,
 -1,
 665855928,
 9544,
 666052539,
 665402261,
 -1,
 666118070,
 666006489,
 -1,
 -55371,
 666063077,
 9494,
 -1,
 666118116,
 9502,
 666314681,
 666062201,
 -1,
 -55368,
 666259685,
 9498,
 -1,
 666314724,
 9510,
 -55366,
 666254861,
 9528,
 -1,
 666445774,
 9536,
 666642367,
 666009207,
 -1,
 -55363,
 666596443,
 9560,
 -55362,
 666652086,
 9563,
 -1,
 666713562,
 9575,
 666959871,
 666576339,
 -1,
 -55359,
 666858798,
 9561,
 -55358,
 666914408,
 9564,
 -1,
 666975774,
 9576,
 667166676,
 665359080,
 -1,
 667232200,
 667123319,
 -1,
 -55354,
 667186267,
 9566,
 -55353,
 667241910,
 9569,
 -1,
 667303386,
 9578,
 667494348,
 667177195,
 -1,
 -55350,
 667448517,
 9501,
 -55349,
 667504153,
 9509,
 -1,
 667565564,
 9535,
 667756496,
 667433877,
 -1,
 -55346,
 667710673,
 9504,
 -55345,
 667766308,
 9512,
 -1,
 667827725,
 9538,
 668073983,
 667690451,
 -1,
 -55342,
 667972910,
 9567,
 -55341,
 668028520,
 9570,
 -1,
 668089886,
 9579,
 668336127,
 667120601,
 -1,
 668346329,
 668225782,
 -1,
 -55337,
 668308334,
 9545,
 -55336,
 668372485,
 9529,
 -1,
 668411762,
 9521,
 668608477,
 668285856,
 -1,
 -55333,
 668570493,
 9534,
 -55332,
 668634737,
 9526,
 -1,
 668674020,
 9518,
 -55330,
 668569102,
 9540,
 -1,
 668804989,
 9542,
 669001763,
 656633239,
 -1,
 669067294,
 668946500,
 -1,
 669132778,
 668994173,
 12570,
 669198309,
 669080226,
 12578,
 -55324,
 669145762,
 12713,
 -1,
 669201815,
 12580,
 669394919,
 669158132,
 12576,
 -1,
 669343200,
 12719,
 669525993,
 669335425,
 12574,
 -1,
 669474272,
 12718,
 -1,
 669472047,
 12720,
 669722610,
 669067543,
 12572,
 669788142,
 669670050,
 12579,
 -55315,
 669735586,
 12709,
 -1,
 669791639,
 12581,
 -55313,
 669741169,
 12582,
 -55312,
 669925249,
 12575,
 -55311,
 669989192,
 12573,
 -1,
 670050583,
 12708,
 670246905,
 669671695,
 12571,
 670312438,
 670194338,
 -1,
 -55307,
 670259874,
 12711,
 -1,
 670315927,
 12722,
 -55305,
 670272244,
 12577,
 -55304,
 670458127,
 12710,
 -1,
 670520623,
 12721,
 670705663,
 670187393,
 12583,
 670771196,
 670653920,
 12714,
 -1,
 670718626,
 12723,
 -55299,
 670730996,
 12585,
 -55298,
 670855281,
 12712,
 -1,
 670913839,
 12716,
 671098882,
 670669774,
 12567,
 -55295,
 671039361,
 12705,
 -1,
 671103304,
 12563,
 671295493,
 671046306,
 12555,
 671416319,
 671233431,
 12587,
 -1,
 671298967,
 12717,
 671492104,
 671233431,
 12557,
 -55289,
 671451892,
 12707,
 -1,
 671505058,
 12588,
 671688714,
 671451892,
 12584,
 -1,
 671636960,
 12715,
 671819788,
 671644299,
 12569,
 -1,
 671758664,
 12565,
 671950862,
 671762605,
 12560,
 -1,
 671891329,
 12706,
 672081936,
 671882058,
 12568,
 -1,
 672020808,
 12564,
 672213010,
 672011939,
 12549,
 -1,
 672172788,
 12704,
 -55277,
 672176421,
 12562,
 -55276,
 672305530,
 12586,
 -55275,
 672367244,
 12554,
 -55274,
 672428145,
 12566,
 -55273,
 672493258,
 12561,
 -55272,
 672557589,
 12550,
 -55271,
 672617775,
 12551,
 -55270,
 672680781,
 12556,
 -55269,
 672745891,
 12558,
 -55268,
 672807240,
 12559,
 -55267,
 672871104,
 12552,
 -1,
 672932226,
 12553,
 673185791,
 669004781,
 -1,
 -55264,
 673088140,
 12725,
 -55263,
 673147413,
 12724,
 -55262,
 673204643,
 12726,
 -1,
 673265992,
 12727,
 673458222,
 668961209,
 -1,
 673523750,
 673415252,
 9141,
 -1,
 673449122,
 9142,
 673654825,
 673477691,
 -1,
 -55256,
 673609841,
 8972,
 -1,
 673670714,
 8991,
 673851436,
 673598895,
 -1,
 -55253,
 673806449,
 8973,
 -1,
 673867322,
 8990,
 -55251,
 673790553,
 8993,
 -1,
 673977133,
 10555,
 674234367,
 673421592,
 8904,
 674299903,
 674104831,
 -1,
 -55247,
 674198660,
 10706,
 -1,
 674254300,
 10705,
 674441397,
 656550167,
 -1,
 674506925,
 674388642,
 -1,
 674572460,
 674444720,
 -1,
 674637945,
 674517060,
 -1,
 674703421,
 674590833,
 -1,
 674768955,
 674630269,
 2480,
 674889727,
 674694655,
 -1,
 -55238,
 674781255,
 2544,
 -1,
 674845734,
 2545,
 -55236,
 674721941,
 2524,
 -1,
 674969954,
 2525,
 675162178,
 674665579,
 -1,
 675227712,
 675115121,
 2443,
 -1,
 675180657,
 2528,
 675414015,
 675171149,
 2444,
 -1,
 675302221,
 2529,
 675489864,
 675119756,
 -1,
 675555398,
 675447436,
 -1,
 -55227,
 675494242,
 2464,
 -1,
 675547773,
 2463,
 -55225,
 675494242,
 2469,
 -1,
 675678845,
 2468,
 675883085,
 675437218,
 -1,
 -55222,
 675846634,
 2462,
 -55221,
 675896034,
 2467,
 -55220,
 675952028,
 2457,
 -1,
 676006525,
 2472,
 676210771,
 675815810,
 -1,
 676276305,
 676143490,
 -1,
 -55216,
 676215138,
 2466,
 -1,
 676268669,
 2465,
 -55214,
 676215138,
 2471,
 -1,
 676399741,
 2470,
 676603991,
 676137597,
 2437,
 -55211,
 676563700,
 2452,
 -55210,
 676609921,
 2448,
 -1,
 676661885,
 2438,
 676866139,
 676559499,
 -1,
 -55207,
 676821706,
 2487,
 -55206,
 676870498,
 2486,
 -1,
 676924029,
 2488,
 677128286,
 676829651,
 -1,
 -55203,
 677091818,
 2527,
 -1,
 677120637,
 2479,
 677324896,
 677087988,
 2441,
 -1,
 677284596,
 2442,
 677455971,
 677276181,
 -1,
 -55198,
 677394786,
 2475,
 -1,
 677448317,
 2474,
 677652582,
 677398947,
 -1,
 -55195,
 677591394,
 2454,
 -1,
 677644925,
 2453,
 677849193,
 677595309,
 -1,
 -55192,
 677788002,
 2461,
 -1,
 677841533,
 2460,
 678045803,
 677789569,
 2439,
 -1,
 677986177,
 2440,
 678176878,
 677983639,
 -1,
 -55187,
 678115682,
 2456,
 -1,
 678169213,
 2455,
 678373489,
 678107978,
 -1,
 -55184,
 678312290,
 2459,
 -1,
 678365821,
 2458,
 678570100,
 678303395,
 -1,
 -55181,
 678508898,
 2477,
 -1,
 678562429,
 2476,
 -55179,
 678519055,
 2451,
 -55178,
 678712632,
 2478,
 -55177,
 678775692,
 2482,
 -55176,
 678836578,
 2489,
 -1,
 678897943,
 2447,
 679094409,
 674600129,
 -1,
 679159935,
 679056491,
 -1,
 679225469,
 679112817,
 2499,
 -1,
 679178353,
 2500,
 679411711,
 679168845,
 2530,
 -1,
 679299917,
 2531,
 679487619,
 679086717,
 -1,
 -55167,
 679447284,
 2508,
 -55166,
 679493505,
 2504,
 -1,
 679545469,
 2494,
 679749765,
 679447284,
 2497,
 -1,
 679709428,
 2498,
 679880839,
 679690113,
 2495,
 -1,
 679821185,
 2496,
 -55160,
 679829775,
 2507,
 -1,
 679946519,
 2503,
 680142999,
 679027734,
 -1,
 680208525,
 680100492,
 -1,
 -55156,
 680171673,
 2536,
 -1,
 680214179,
 2537,
 680405136,
 680163979,
 -1,
 -55153,
 680347793,
 2540,
 -1,
 680407503,
 2541,
 680601747,
 680342208,
 -1,
 -55150,
 680552445,
 2538,
 -1,
 680609858,
 2539,
 -55148,
 680565790,
 2534,
 -55147,
 680747962,
 2535,
 -55146,
 680811852,
 2543,
 -1,
 680864922,
 2542,
 681060512,
 680075555,
 -1,
 681126047,
 681009243,
 -1,
 681191580,
 681083532,
 -1,
 -55141,
 681154713,
 2549,
 -1,
 681197219,
 2550,
 681388190,
 681141178,
 2548,
 -1,
 681313131,
 2552,
 -1,
 681325798,
 2551,
 -1,
 681059009,
 2553,
 681650343,
 681016876,
 -1,
 681715876,
 681612271,
 -1,
 -55133,
 681671495,
 2435,
 -1,
 681734412,
 2509,
 -55131,
 681664532,
 2492,
 -55130,
 681843665,
 2433,
 -1,
 681906665,
 2434,
 682109098,
 681605725,
 -1,
 -55127,
 682065447,
 2547,
 -1,
 682120875,
 2546,
 -55125,
 682051472,
 2554,
 -1,
 682235394,
 2519,
 -1,
 674536458,
 9004,
 682502320,
 674464396,
 -1,
 -55121,
 682464755,
 8812,
 -1,
 682493333,
 8502,
 682698931,
 682430379,
 -1,
 -55118,
 682655466,
 9836,
 -1,
 682699956,
 9835,
 -55116,
 682644016,
 9086,
 -1,
 682826860,
 8757,
 683026711,
 674384780,
 -1,
 683092246,
 682958420,
 -1,
 683157771,
 683016192,
 -1,
 683223240,
 683088714,
 -1,
 683288769,
 683162666,
 -1,
 683354301,
 683231651,
 -1,
 -55108,
 683302202,
 9822,
 -1,
 683361401,
 9818,
 -55106,
 683309164,
 9820,
 -55105,
 683503608,
 9819,
 -55104,
 683567917,
 9823,
 -1,
 683612428,
 9821,
 683813062,
 683230890,
 9679,
 683933695,
 683738623,
 -1,
 -55100,
 683841104,
 9864,
 -55099,
 683903668,
 9865,
 -1,
 683943770,
 10733,
 -55097,
 683758768,
 9827,
 -1,
 684076779,
 10028,
 684271826,
 683178635,
 -1,
 684337356,
 684217647,
 -1,
 -55093,
 684278547,
 9787,
 -1,
 684330727,
 9642,
 -55091,
 684297471,
 9728,
 -55090,
 684491612,
 9733,
 -55089,
 684552073,
 9632,
 -55088,
 684616274,
 9824,
 -55087,
 684670296,
 9751,
 -1,
 684727884,
 9986,
 684927198,
 684224625,
 -1,
 684992733,
 684868098,
 -1,
 685058264,
 684954903,
 -1,
 685123799,
 684987407,
 10145,
 -1,
 685062973,
 10148,
 -1,
 685054669,
 8269,
 685320412,
 684984703,
 -1,
 -55078,
 685279367,
 9654,
 -55077,
 685342620,
 9656,
 -1,
 685403512,
 9658,
 -1,
 685245659,
 9755,
 -1,
 684927554,
 9644,
 685713643,
 684870477,
 -1,
 685779174,
 685648685,
 -1,
 685844708,
 685705599,
 -1,
 -55070,
 685803655,
 9664,
 -55069,
 685866908,
 9666,
 -1,
 685927800,
 9668,
 -55067,
 685806928,
 8268,
 -1,
 686032091,
 9754,
 686292991,
 685728015,
 -1,
 686303466,
 686200330,
 -1,
 -55063,
 686257550,
 9698,
 -1,
 686313152,
 9699,
 -1,
 686267412,
 10731,
 686565620,
 685646210,
 -1,
 686631153,
 686505993,
 9670,
 686751743,
 686555136,
 -1,
 -55057,
 686659370,
 10730,
 -55056,
 686719421,
 9830,
 -1,
 686774534,
 10070,
 687013887,
 686582267,
 -1,
 -55053,
 686917767,
 9660,
 -1,
 686981020,
 9662,
 687155453,
 686525172,
 -1,
 687220988,
 687106581,
 -1,
 687286521,
 687172541,
 -1,
 -55048,
 687240590,
 9701,
 -1,
 687296192,
 9700,
 687538175,
 687212927,
 -1,
 -55045,
 687442055,
 9650,
 -1,
 687505308,
 9652,
 -1,
 687168948,
 9851,
 687745280,
 687101752,
 -1,
 -55041,
 687697801,
 9724,
 -1,
 687756885,
 9726,
 687941891,
 687683912,
 -1,
 -55038,
 687892537,
 10711,
 -1,
 687942023,
 9829,
 688138502,
 687878848,
 -1,
 -55035,
 688089122,
 10022,
 -1,
 688149378,
 10047,
 -55033,
 688100272,
 9646,
 -55032,
 688292885,
 9742,
 -55031,
 688351931,
 9648,
 -55030,
 688413985,
 10002,
 -1,
 688462390,
 10707,
 688717823,
 683083762,
 -1,
 688728338,
 688607308,
 -1,
 -55026,
 688692174,
 8488,
 -55025,
 688746609,
 8476,
 -55024,
 688799617,
 8465,
 -55023,
 688863560,
 8460,
 -1,
 688921418,
 8493,
 689176575,
 688665434,
 -1,
 -55020,
 689078276,
 10164,
 -55019,
 689141212,
 10165,
 -1,
 689200754,
 10166,
 -1,
 683040210,
 9250,
 689449268,
 682986228,
 -1,
 689514800,
 689388641,
 -1,
 689580333,
 689459268,
 -1,
 689645853,
 689527458,
 -1,
 -55012,
 689583516,
 5957,
 -1,
 689638013,
 5960,
 -55010,
 689609194,
 5964,
 -55009,
 689804534,
 5967,
 -55008,
 689867508,
 5954,
 -55007,
 689930964,
 5958,
 -55006,
 689994442,
 5968,
 -55005,
 690057365,
 5965,
 -55004,
 690121274,
 5961,
 -55003,
 690181432,
 5963,
 -55002,
 690244492,
 5966,
 -55001,
 690309541,
 5955,
 -55000,
 690372481,
 5953,
 -54999,
 690436450,
 5969,
 -54998,
 690501020,
 5956,
 -54997,
 690561494,
 5959,
 -54996,
 690624165,
 5962,
 -1,
 690686589,
 5952,
 690946047,
 689542337,
 -1,
 -54993,
 690850548,
 5971,
 -1,
 690896769,
 5970,
 691142655,
 689459749,
 -1,
 691153203,
 691024140,
 8226,
 -1,
 691078152,
 8729,
 -1,
 691109076,
 9678,
 691349822,
 689375869,
 -1,
 691415357,
 691294865,
 -1,
 691480892,
 691372686,
 -1,
 691546427,
 691411517,
 9744,
 691666943,
 691471871,
 -1,
 -54982,
 691575077,
 9746,
 -1,
 691608874,
 9745,
 -1,
 691509541,
 10007,
 -1,
 691430239,
 10057,
 -1,
 691347039,
 10155,
 692060159,
 691289985,
 -1,
 692070722,
 691942809,
 -1,
 -54975,
 692027360,
 10744,
 -1,
 692089541,
 10745,
 -1,
 692019748,
 9763,
 692333883,
 614086984,
 -1,
 692399047,
 692259453,
 -1,
 692464429,
 692345506,
 -1,
 692529940,
 692401559,
 -1,
 692595458,
 692489299,
 -1,
 692660747,
 692537517,
 -1,
 692726201,
 692610095,
 -1,
 692791654,
 692679629,
 4527,
 692912127,
 692717554,
 -1,
 692922707,
 692808213,
 -1,
 692988241,
 692863341,
 4530,
 693108735,
 692914162,
 -1,
 -54960,
 693010140,
 4563,
 -1,
 693058669,
 4564,
 -54958,
 692927610,
 4533,
 -1,
 693178780,
 4567,
 693381464,
 692865443,
 -1,
 693446998,
 693323943,
 4528,
 -1,
 693373432,
 4556,
 -54953,
 693386355,
 4568,
 -1,
 693506705,
 4565,
 693709148,
 693338764,
 -1,
 693774683,
 693650099,
 4558,
 -1,
 693700832,
 4559,
 -1,
 693714049,
 4532,
 693971296,
 693655704,
 4529,
 694091775,
 693897202,
 -1,
 -54945,
 693993180,
 4562,
 -1,
 694045339,
 4561,
 694233443,
 693926539,
 -1,
 -54942,
 694188821,
 4566,
 -1,
 694240850,
 4531,
 -54940,
 694196878,
 4569,
 -54939,
 694377770,
 4557,
 -1,
 694434925,
 4534,
 694626674,
 692746891,
 -1,
 694692205,
 694568530,
 4538,
 694812671,
 694618098,
 -1,
 -54934,
 694716035,
 4584,
 -54933,
 694776781,
 4585,
 -54932,
 694840512,
 4586,
 -1,
 694897307,
 4583,
 695140351,
 694647568,
 -1,
 -54929,
 695041756,
 4539,
 -54928,
 695104461,
 4560,
 -54927,
 695159451,
 4521,
 -1,
 695222631,
 4590,
 695413118,
 694573208,
 4535,
 695533567,
 695338994,
 -1,
 695544183,
 695433867,
 -1,
 -54922,
 695499541,
 4574,
 -1,
 695551570,
 4573,
 695740794,
 695495189,
 -1,
 -54919,
 695681389,
 4572,
 -1,
 695734684,
 4575,
 -54917,
 695694285,
 4571,
 -54916,
 695880347,
 4570,
 -54915,
 695942253,
 4577,
 -1,
 695999830,
 4576,
 696199560,
 695364117,
 -1,
 696265093,
 696140141,
 4536,
 696385535,
 696190962,
 -1,
 -54910,
 696286940,
 4537,
 -54909,
 696349645,
 4579,
 -54908,
 696413341,
 4580,
 -1,
 696466541,
 4581,
 696658311,
 696204410,
 4545,
 -1,
 696584568,
 4595,
 -1,
 696586652,
 4587,
 696854930,
 696147242,
 4523,
 696975359,
 696780786,
 -1,
 696985997,
 696877708,
 -1,
 -54900,
 696926899,
 4550,
 -1,
 696990849,
 4553,
 -54898,
 696942300,
 4551,
 -54897,
 697133703,
 4552,
 -54896,
 697191067,
 4549,
 -54895,
 697252973,
 4525,
 -1,
 697310618,
 4524,
 697510302,
 696797603,
 -1,
 697575832,
 697452711,
 4520,
 697696255,
 697501682,
 -1,
 697706903,
 697597660,
 4522,
 -1,
 697633072,
 4548,
 -1,
 697660365,
 4547,
 697903517,
 697504393,
 -1,
 697969052,
 697854485,
 -1,
 -54885,
 697909613,
 4582,
 -1,
 697973882,
 4596,
 -1,
 697915544,
 4578,
 -1,
 697842803,
 4543,
 698296740,
 697449581,
 4546,
 698417151,
 698222578,
 -1,
 -54879,
 698315725,
 4598,
 -54878,
 698379456,
 4600,
 -54877,
 698441002,
 4597,
 -1,
 698505368,
 4599,
 698689962,
 698260011,
 -1,
 698755497,
 698646020,
 4592,
 698875903,
 698681330,
 -1,
 -54872,
 698777308,
 4593,
 -1,
 698837639,
 4594,
 -1,
 698705376,
 4601,
 699083184,
 698647180,
 -1,
 699148719,
 699024051,
 4526,
 699269119,
 699074546,
 -1,
 -54866,
 699167693,
 4555,
 -1,
 699222683,
 4554,
 -1,
 699088001,
 4544,
 699476406,
 699023719,
 4540,
 699596799,
 699402226,
 -1,
 699607477,
 699484579,
 -1,
 -54860,
 699549863,
 4588,
 -1,
 699612275,
 4591,
 -1,
 699564202,
 4589,
 699924479,
 699407178,
 -1,
 -54856,
 699810146,
 4541,
 -1,
 699874406,
 4542,
 700121087,
 692686191,
 -1,
 700131800,
 700029395,
 -1,
 700197316,
 700091124,
 4466,
 700317695,
 700123122,
 -1,
 700328383,
 700226091,
 4498,
 -1,
 700277007,
 4497,
 700459457,
 700262679,
 4496,
 -1,
 700408079,
 4495,
 -54846,
 700418804,
 4499,
 -54845,
 700530561,
 4500,
 -1,
 700582525,
 4494,
 700787148,
 700145935,
 4461,
 700907519,
 700712946,
 -1,
 700918218,
 700815827,
 -1,
 700983753,
 700844669,
 4484,
 -1,
 700918039,
 4485,
 -1,
 700919567,
 4486,
 -54837,
 700866831,
 4487,
 -1,
 701120385,
 4488,
 701311441,
 700721431,
 4456,
 701431807,
 701260047,
 4455,
 701497343,
 701302770,
 -1,
 -54832,
 701401844,
 4478,
 -1,
 701456655,
 4477,
 701639126,
 701237885,
 4451,
 701704661,
 701564914,
 -1,
 -54828,
 701668155,
 4473,
 -1,
 701718799,
 4472,
 -1,
 701638935,
 4452,
 702021631,
 701579137,
 4468,
 -1,
 701893134,
 4503,
 702097890,
 700066071,
 4454,
 702163422,
 702046479,
 4453,
 702283775,
 702089202,
 -1,
 -54820,
 702188276,
 4475,
 -54819,
 702243087,
 4474,
 -1,
 702296506,
 4476,
 702545919,
 702122740,
 4467,
 702611455,
 702416882,
 -1,
 -54815,
 702515956,
 4501,
 -1,
 702558650,
 4502,
 702753260,
 702024317,
 4449,
 702818792,
 702705856,
 4510,
 702939135,
 702744562,
 -1,
 -54810,
 702843636,
 4512,
 -54809,
 702889857,
 4513,
 -1,
 702951183,
 4511,
 703146475,
 702744562,
 -1,
 -54806,
 703105780,
 4471,
 -1,
 703160591,
 4470,
 -1,
 703080727,
 4450,
 703408628,
 702701839,
 4457,
 703474163,
 703334386,
 -1,
 703539696,
 703408407,
 4480,
 -1,
 703488271,
 4479,
 -54799,
 703502891,
 4481,
 -54798,
 703630068,
 4483,
 -1,
 703684879,
 4482,
 -1,
 703408407,
 4460,
 703932924,
 703348609,
 4469,
 704053247,
 703858674,
 -1,
 704063992,
 703924861,
 4504,
 -1,
 704016576,
 4509,
 -54791,
 704027114,
 4505,
 -54790,
 704154356,
 4507,
 -54789,
 704209167,
 4506,
 -1,
 704262586,
 4508,
 704457219,
 703892212,
 4462,
 704577535,
 704382962,
 -1,
 704588288,
 704449149,
 4489,
 -1,
 704522519,
 4490,
 -54783,
 704551467,
 4492,
 -54782,
 704678644,
 4493,
 -1,
 704720658,
 4491,
 704915977,
 704419039,
 -1,
 704981510,
 704850199,
 4464,
 -1,
 704930063,
 4463,
 705112584,
 704907901,
 4458,
 -1,
 705046807,
 4459,
 -1,
 705052545,
 4465,
 -54774,
 704872607,
 4514,
 -1,
 705246160,
 4448,
 705440384,
 692604996,
 -1,
 705505825,
 705403347,
 -1,
 705571348,
 705440023,
 12630,
 705636882,
 705527300,
 12673,
 705757183,
 705562610,
 -1,
 -54767,
 705658588,
 12674,
 -1,
 705718919,
 12675,
 705953791,
 705585423,
 12629,
 -1,
 705853162,
 12678,
 706030105,
 705530612,
 12640,
 706150399,
 705955826,
 -1,
 706161176,
 706058795,
 12683,
 -1,
 706109711,
 12682,
 -1,
 706101121,
 12684,
 706357790,
 705978639,
 12635,
 706478079,
 706283506,
 -1,
 706488861,
 706386410,
 12679,
 -1,
 706423063,
 12680,
 -1,
 706428801,
 12681,
 706685472,
 706284157,
 12625,
 -1,
 706619671,
 12626,
 -1,
 706625409,
 12642,
 706882098,
 705460875,
 -1,
 706947627,
 706837264,
 -1,
 -54748,
 706905731,
 12600,
 -54747,
 706969308,
 12614,
 -54746,
 707030208,
 12611,
 -54745,
 707091754,
 12645,
 -54744,
 707152539,
 12594,
 -54743,
 707215719,
 12672,
 -54742,
 707279981,
 12677,
 -1,
 707337626,
 12617,
 707592191,
 706889298,
 12613,
 707657727,
 707463154,
 -1,
 -54738,
 707561091,
 12668,
 -54737,
 707620032,
 12669,
 -54736,
 707681578,
 12667,
 -54735,
 707742363,
 12666,
 -1,
 707796378,
 12670,
 707996226,
 706835405,
 12601,
 708116479,
 707921906,
 -1,
 708127289,
 708012565,
 -1,
 708192823,
 708067693,
 12604,
 -1,
 708119032,
 12651,
 -54728,
 708131962,
 12607,
 -1,
 708252060,
 12652,
 708454972,
 708084364,
 -1,
 -54725,
 708395699,
 12650,
 -1,
 708459649,
 12606,
 708651582,
 708397723,
 12602,
 -1,
 708577784,
 12649,
 -54721,
 708614798,
 12653,
 -54720,
 708738780,
 12605,
 -54719,
 708794520,
 12603,
 -1,
 708852845,
 12608,
 709044816,
 707947029,
 -1,
 709110350,
 708985197,
 12610,
 709230591,
 709036018,
 -1,
 709241417,
 709131996,
 12612,
 709361663,
 709167090,
 -1,
 -54712,
 709265027,
 12661,
 -1,
 709315227,
 12660,
 709503564,
 709198476,
 -1,
 -54709,
 709444275,
 12659,
 -1,
 709508225,
 12663,
 -54707,
 709446299,
 12658,
 -1,
 709631386,
 12662,
 -54705,
 709049466,
 12621,
 -1,
 709759388,
 12671,
 709962330,
 708987299,
 -1,
 710027863,
 709890697,
 -1,
 710093397,
 709978645,
 -1,
 -54700,
 710033773,
 12664,
 -1,
 710098042,
 12676,
 -54698,
 710049974,
 12665,
 -1,
 710236312,
 12657,
 710421081,
 709970087,
 12593,
 -1,
 710347256,
 12595,
 -1,
 710360179,
 12619,
 710617697,
 709909802,
 12596,
 710737919,
 710543346,
 -1,
 -54691,
 710641283,
 12646,
 -54690,
 710704860,
 12647,
 -54689,
 710765191,
 12648,
 -54688,
 710818925,
 12598,
 -1,
 710876570,
 12597,
 711076455,
 710579423,
 -1,
 711141988,
 711010583,
 12638,
 -1,
 711090447,
 12637,
 711273062,
 711068285,
 12632,
 -1,
 711207191,
 12633,
 -1,
 711212929,
 12639,
 711469677,
 711022744,
 12609,
 711589887,
 711395314,
 -1,
 711600748,
 711485973,
 -1,
 -54677,
 711541101,
 12654,
 -1,
 711594396,
 12656,
 -1,
 711556828,
 12655,
 711862897,
 711395965,
 12623,
 711928432,
 711815360,
 12685,
 -1,
 711862551,
 12686,
 -1,
 711862551,
 12624,
 712125044,
 711797015,
 12628,
 -54669,
 712084212,
 12641,
 -1,
 712139023,
 12627,
 712321655,
 712082060,
 -1,
 -54666,
 712262323,
 12599,
 -1,
 712326273,
 12620,
 712518265,
 712270095,
 12631,
 -1,
 712452375,
 12634,
 712649339,
 712458113,
 12643,
 -1,
 712585666,
 12615,
 712780414,
 712579914,
 -1,
 -54659,
 712720738,
 12616,
 -1,
 712784998,
 12618,
 -54657,
 712739572,
 12636,
 -1,
 712916077,
 12622,
 713108223,
 705371503,
 -1,
 713173665,
 713063051,
 -1,
 713239191,
 713115218,
 4361,
 713359359,
 713164786,
 -1,
 713370248,
 713255445,
 -1,
 713435783,
 713310573,
 4402,
 -1,
 713361712,
 4403,
 -1,
 713374842,
 4410,
 713632395,
 713327244,
 -1,
 -54646,
 713573043,
 4399,
 -1,
 713636993,
 4409,
 713829006,
 713574819,
 -1,
 -54643,
 713771175,
 4397,
 -1,
 713833587,
 4408,
 714025617,
 713759562,
 -1,
 -54640,
 713965922,
 4406,
 -1,
 714030182,
 4407,
 -54638,
 713982145,
 4404,
 -54637,
 714175437,
 4400,
 -54636,
 714235178,
 4398,
 -54635,
 714299544,
 4401,
 -54634,
 714359143,
 4405,
 -1,
 714423405,
 4411,
 714670079,
 713194256,
 -1,
 -54631,
 714573443,
 4356,
 -54630,
 714637020,
 4362,
 -54629,
 714699725,
 4377,
 -54628,
 714763456,
 4360,
 -54627,
 714825002,
 4372,
 -54626,
 714885787,
 4353,
 -54625,
 714948967,
 4423,
 -54624,
 715013229,
 4440,
 -1,
 715070874,
 4365,
 715270840,
 713124373,
 -1,
 715336373,
 715211117,
 4359,
 715456511,
 715261938,
 -1,
 715467436,
 715356811,
 -1,
 715532971,
 715408978,
 4385,
 715653119,
 715458546,
 -1,
 -54616,
 715556483,
 4387,
 -54615,
 715615424,
 4388,
 -54614,
 715672219,
 4386,
 -1,
 715726234,
 4390,
 -1,
 715488021,
 4389,
 715991727,
 715424396,
 -1,
 -54610,
 715932339,
 4384,
 -1,
 715996289,
 4393,
 716188338,
 715922250,
 -1,
 -54607,
 716128610,
 4391,
 -1,
 716192870,
 4392,
 -54605,
 716139677,
 4394,
 -54604,
 716332330,
 4383,
 -1,
 716393115,
 4382,
 716581559,
 715275386,
 4369,
 -1,
 716507512,
 4438,
 -1,
 716509596,
 4416,
 716778194,
 715201354,
 -1,
 716843719,
 716717125,
 -1,
 716909251,
 716802504,
 -1,
 716974784,
 716864139,
 -1,
 717040319,
 716929808,
 -1,
 -54594,
 716996316,
 4413,
 -1,
 717036954,
 4431,
 -1,
 716981842,
 4412,
 717357055,
 716905290,
 -1,
 -54590,
 717242722,
 4430,
 -1,
 717306982,
 4436,
 717553663,
 716845501,
 4366,
 717619199,
 717424626,
 -1,
 -54586,
 717507210,
 4434,
 -1,
 717569133,
 4435,
 717761232,
 716779288,
 -1,
 717826765,
 717716107,
 -1,
 717892300,
 717781776,
 -1,
 -54581,
 717848284,
 4415,
 -1,
 717888922,
 4433,
 -1,
 717833810,
 4414,
 718209023,
 717757258,
 -1,
 -54577,
 718094690,
 4432,
 -1,
 718158950,
 4437,
 718405631,
 717701474,
 4364,
 -1,
 718276881,
 4429,
 718482145,
 716718439,
 4363,
 718602239,
 718407666,
 -1,
 718613208,
 718498325,
 -1,
 -54570,
 718553453,
 4420,
 -54569,
 718617722,
 4427,
 -1,
 718672284,
 4422,
 718875355,
 718570124,
 -1,
 -54566,
 718815923,
 4418,
 -1,
 718879873,
 4426,
 719071966,
 718805834,
 -1,
 -54563,
 719012194,
 4424,
 -1,
 719076454,
 4425,
 -54561,
 719027932,
 4421,
 -54560,
 719214744,
 4419,
 -1,
 719276699,
 4417,
 719465195,
 718424483,
 -1,
 719530729,
 719393417,
 -1,
 719596262,
 719481365,
 -1,
 -54555,
 719536493,
 4395,
 -1,
 719600762,
 4439,
 -54553,
 719552694,
 4396,
 -54552,
 719745997,
 4379,
 -1,
 719804568,
 4381,
 -54550,
 719472807,
 4352,
 -1,
 719928435,
 4367,
 720120560,
 719412522,
 4354,
 720240639,
 720046066,
 -1,
 -54546,
 720144003,
 4373,
 -54545,
 720202944,
 4374,
 -1,
 720259739,
 4371,
 720448244,
 720077452,
 -1,
 720513779,
 720388787,
 4355,
 -1,
 720439600,
 4375,
 -1,
 720452737,
 4368,
 720710392,
 720401357,
 4357,
 720830463,
 720635890,
 -1,
 -54537,
 720723242,
 4376,
 -1,
 720780397,
 4378,
 720972539,
 720673323,
 -1,
 -54534,
 720928260,
 4428,
 -1,
 720987616,
 4441,
 721169149,
 720918680,
 4358,
 -1,
 721095032,
 4380,
 -54530,
 721108077,
 4370,
 -1,
 721236944,
 4447,
 -54528,
 713064067,
 12334,
 -54527,
 721368016,
 12644,
 -1,
 721430077,
 12335,
 721682431,
 692558902,
 -1,
 721693451,
 721584780,
 -1,
 721758983,
 721655007,
 -1,
 -54522,
 721707279,
 12322,
 -1,
 721760004,
 12345,
 721955594,
 721697096,
 -1,
 -54519,
 721908278,
 12323,
 -1,
 721962827,
 12346,
 -1,
 721890824,
 12344,
 722217742,
 721648267,
 -1,
 -54515,
 722159761,
 12326,
 -1,
 722219471,
 12327,
 722414353,
 722154176,
 -1,
 -54512,
 722364413,
 12324,
 -1,
 722421826,
 12325,
 -54510,
 722363322,
 12321,
 -54509,
 722558284,
 12329,
 -1,
 722611354,
 12328,
 722862079,
 692489659,
 -1,
 722873129,
 722751556,
 -1,
 722938649,
 722819746,
 -1,
 -54504,
 722875804,
 5925,
 -1,
 722930301,
 5928,
 -54502,
 722901482,
 5932,
 -54501,
 723096822,
 5935,
 -54500,
 723159796,
 5922,
 -54499,
 723223252,
 5926,
 -54498,
 723286730,
 5936,
 -54497,
 723349653,
 5933,
 -54496,
 723413562,
 5929,
 -54495,
 723473720,
 5931,
 -54494,
 723536780,
 5934,
 -54493,
 723601829,
 5923,
 -54492,
 723664769,
 5921,
 -54491,
 723728738,
 5937,
 -54490,
 723793308,
 5924,
 -54489,
 723853782,
 5927,
 -54488,
 723916453,
 5930,
 -1,
 723978877,
 5920,
 724183852,
 722834625,
 -1,
 -54485,
 724142836,
 5939,
 -1,
 724189057,
 5938,
 -1,
 724139570,
 5940,
 724446149,
 692408487,
 -1,
 724511606,
 724388347,
 -1,
 724577141,
 724434944,
 -1,
 724642674,
 724521028,
 -1,
 724708162,
 724597387,
 -1,
 724773693,
 724653550,
 -1,
 724839223,
 724736467,
 -1,
 -54475,
 724798196,
 65389,
 -54474,
 724853007,
 65390,
 -1,
 724896381,
 65388,
 -54472,
 724798196,
 65385,
 -54471,
 725060037,
 65391,
 -54470,
 725115151,
 65387,
 -54469,
 725172097,
 65384,
 -54468,
 725231895,
 65386,
 -1,
 725289597,
 65383,
 -54466,
 724732660,
 65405,
 -54465,
 725442831,
 65407,
 -54464,
 725499777,
 65404,
 -54463,
 725559575,
 65406,
 -1,
 725617277,
 65403,
 725822280,
 724654754,
 65437,
 -54460,
 725781236,
 65415,
 -54459,
 725836047,
 65417,
 -54458,
 725892993,
 65414,
 -54457,
 725952791,
 65416,
 -1,
 726010493,
 65413,
 726215502,
 725779084,
 -1,
 -54454,
 726174452,
 65410,
 -54453,
 726229263,
 65412,
 -54452,
 726286209,
 65409,
 -54451,
 726346007,
 65411,
 -1,
 726403709,
 65408,
 726608724,
 726167665,
 -1,
 -54448,
 726567668,
 65433,
 -54447,
 726622479,
 65435,
 -54446,
 726679425,
 65432,
 -54445,
 726739223,
 65434,
 -1,
 726796925,
 65431,
 727001946,
 726553903,
 -1,
 -54442,
 726960884,
 65425,
 -54441,
 727015695,
 65427,
 -54440,
 727072641,
 65424,
 -54439,
 727132439,
 65426,
 -1,
 727190141,
 65423,
 727395168,
 726944163,
 -1,
 -54436,
 727354100,
 65400,
 -54435,
 727408911,
 65402,
 -54434,
 727465857,
 65399,
 -54433,
 727525655,
 65401,
 -1,
 727583357,
 65398,
 727788390,
 727333192,
 -1,
 -54430,
 727747316,
 65420,
 -54429,
 727802127,
 65422,
 -54428,
 727859073,
 65419,
 -54427,
 727918871,
 65421,
 -1,
 727976573,
 65418,
 728181610,
 727751123,
 -1,
 -54424,
 728140532,
 65429,
 -54423,
 728195343,
 65430,
 -1,
 728238717,
 65428,
 728443757,
 728143071,
 -1,
 -54420,
 728391951,
 65382,
 -1,
 728435325,
 65436,
 -54418,
 728402676,
 65395,
 -54417,
 728588559,
 65397,
 -54416,
 728645505,
 65394,
 -54415,
 728705303,
 65396,
 -1,
 728763005,
 65393,
 -54413,
 724604052,
 65438,
 -54412,
 728923132,
 65439,
 -1,
 728979543,
 65381,
 -1,
 724502770,
 65392,
 729230263,
 724449974,
 -1,
 729295798,
 729174084,
 -1,
 729361282,
 729248717,
 65449,
 729481215,
 729286642,
 -1,
 729492349,
 729377301,
 -1,
 -54404,
 729432429,
 65452,
 -1,
 729496698,
 65455,
 -54402,
 729449839,
 65454,
 -54401,
 729644764,
 65453,
 -54400,
 729700504,
 65451,
 -54399,
 729762459,
 65450,
 -1,
 729824365,
 65456,
 730016650,
 729323987,
 -1,
 730082181,
 729950487,
 65483,
 -1,
 730030351,
 65482,
 730213255,
 730008189,
 65476,
 -1,
 730147095,
 65477,
 -54392,
 730172148,
 65495,
 -54391,
 730292495,
 65490,
 -1,
 730349441,
 65499,
 730540946,
 729971339,
 -1,
 730606481,
 730495760,
 -1,
 -54387,
 730564227,
 65448,
 -54386,
 730627804,
 65462,
 -54385,
 730688704,
 65459,
 -54384,
 730745499,
 65442,
 -1,
 730799514,
 65465,
 -1,
 730547794,
 65461,
 731065240,
 730502367,
 -1,
 731130773,
 730999063,
 65493,
 -1,
 731078927,
 65492,
 731261847,
 731056765,
 65485,
 -1,
 731195671,
 65486,
 -1,
 731201409,
 65494,
 731458460,
 731015701,
 -1,
 731523995,
 731398509,
 65458,
 -1,
 731449848,
 65460,
 -1,
 731462778,
 65469,
 731720608,
 731405610,
 65444,
 731840511,
 731645938,
 -1,
 -54369,
 731724909,
 65446,
 -1,
 731782554,
 65445,
 731982756,
 731662755,
 -1,
 732048291,
 731924647,
 65441,
 -1,
 731974136,
 65443,
 -1,
 731987059,
 65467,
 732244903,
 731916567,
 65479,
 -54362,
 732203764,
 65498,
 -1,
 732258575,
 65478,
 732441514,
 732201612,
 -1,
 -54359,
 732381875,
 65447,
 -1,
 732445825,
 65468,
 732638124,
 732389647,
 65484,
 -1,
 732571927,
 65487,
 732769198,
 732577665,
 65500,
 -1,
 732705218,
 65463,
 732900273,
 732699466,
 -1,
 -54352,
 732840290,
 65464,
 -1,
 732904550,
 65466,
 733096883,
 732826237,
 65474,
 -1,
 733030679,
 65475,
 -54348,
 733055732,
 65491,
 -54347,
 733173912,
 65457,
 -1,
 733232237,
 65470,
 -1,
 729232336,
 65440,
 733490106,
 729183187,
 -1,
 -54343,
 733451550,
 65515,
 -1,
 733479414,
 65379,
 733686717,
 733433204,
 -1,
 -54340,
 733648158,
 65513,
 -1,
 733676022,
 65378,
 733883328,
 733626624,
 -1,
 -54337,
 733820282,
 65377,
 -1,
 733880068,
 65380,
 -54335,
 733845038,
 65518,
 -54334,
 734040032,
 65514,
 -54333,
 734082257,
 65512,
 -54332,
 734144582,
 65516,
 -1,
 734206289,
 65517,
 -54330,
 724392228,
 9773,
 -1,
 734348939,
 8202,
 734538939,
 692332823,
 -1,
 734604406,
 734468749,
 -1,
 734669865,
 734546765,
 -1,
 734735393,
 734605741,
 -1,
 734800852,
 734697114,
 -1,
 -54323,
 734757768,
 64296,
 -54322,
 734818975,
 64295,
 -54321,
 734874703,
 64293,
 -54320,
 734939577,
 64292,
 -54319,
 735001395,
 64291,
 -54318,
 735065083,
 64294,
 -54317,
 735126025,
 64290,
 -1,
 735186456,
 64289,
 735390688,
 734755467,
 -1,
 735456222,
 735329499,
 1513,
 735576063,
 735380991,
 -1,
 735587291,
 735453667,
 64329,
 735707135,
 735510784,
 -1,
 -54310,
 735593477,
 64301,
 -1,
 735657183,
 64300,
 735903743,
 735541899,
 -1,
 -54307,
 735790085,
 64299,
 -1,
 735853791,
 64298,
 736100351,
 735383473,
 1505,
 -1,
 735970951,
 64321,
 736177128,
 735327195,
 -1,
 736242659,
 736127802,
 1507,
 -1,
 736167559,
 64323,
 736373733,
 736184761,
 1498,
 -1,
 736298631,
 64314,
 -54298,
 736332142,
 1509,
 -54297,
 736452724,
 1503,
 -1,
 736515982,
 1501,
 736701427,
 736103037,
 -1,
 736766962,
 736643917,
 -1,
 736832495,
 736701212,
 1488,
 736952319,
 736757247,
 -1,
 -54291,
 736849665,
 64303,
 -54290,
 736914200,
 64302,
 -1,
 736974487,
 64304,
 737214463,
 736789643,
 -1,
 -54287,
 737111356,
 64297,
 -1,
 737154718,
 64288,
 -1,
 736729832,
 1506,
 737422330,
 736658060,
 -1,
 737487862,
 737377004,
 1510,
 -1,
 737412743,
 64326,
 737618936,
 737423628,
 1496,
 -1,
 737543815,
 64312,
 737804287,
 737547817,
 1514,
 -1,
 737674887,
 64330,
 737881086,
 737385278,
 1497,
 738000895,
 737805823,
 -1,
 -54275,
 737885419,
 64285,
 -1,
 737944035,
 64313,
 738143234,
 737841638,
 1493,
 738263039,
 738067967,
 -1,
 -54271,
 738147688,
 64331,
 -1,
 738206179,
 64309,
 738405382,
 738093882,
 1508,
 738525183,
 738330111,
 -1,
 -54267,
 738422981,
 64334,
 -1,
 738468323,
 64324,
 738667530,
 738347449,
 1499,
 738787327,
 738592255,
 -1,
 -54263,
 738685125,
 64333,
 -1,
 738730467,
 64315,
 738929677,
 738605875,
 1492,
 -54260,
 738886284,
 1495,
 -1,
 738920255,
 64308,
 739126289,
 738859161,
 1489,
 739246079,
 739051007,
 -1,
 -54256,
 739143877,
 64332,
 -1,
 739189219,
 64305,
 739388435,
 739089409,
 1494,
 -1,
 739313287,
 64310,
 739519509,
 739340959,
 1512,
 -1,
 739444359,
 64328,
 739650583,
 739471139,
 1511,
 -1,
 739575431,
 64327,
 739781657,
 739598452,
 1504,
 -1,
 739706503,
 64320,
 739912731,
 739727246,
 1502,
 -1,
 739837575,
 64318,
 740043805,
 739855439,
 1500,
 -1,
 739968647,
 64316,
 740174879,
 739981027,
 1490,
 -1,
 740099719,
 64306,
 740360191,
 740106761,
 1491,
 -1,
 740230791,
 64307,
 740491263,
 734675382,
 -1,
 740502568,
 740399787,
 -1,
 740568102,
 740435403,
 -1,
 -54235,
 740531006,
 1522,
 -1,
 740594150,
 1520,
 -54233,
 740531010,
 64287,
 -1,
 740725226,
 1521,
 -1,
 740429347,
 64335,
 740961364,
 734596016,
 -1,
 741026865,
 740924366,
 -1,
 741092400,
 740952701,
 -1,
 741157935,
 741043991,
 -1,
 -54226,
 741109521,
 1428,
 -1,
 741160351,
 1429,
 -1,
 741112167,
 1432,
 -1,
 741033222,
 1454,
 741485624,
 740983436,
 -1,
 741551159,
 741419287,
 -1,
 741616694,
 741495267,
 -1,
 -54219,
 741568284,
 1449,
 -1,
 741619230,
 1440,
 -1,
 741577772,
 1435,
 -1,
 741492326,
 1430,
 741944381,
 741430575,
 -1,
 742009915,
 741879810,
 1445,
 -1,
 741933917,
 1446,
 -54212,
 741969164,
 1443,
 -1,
 742067461,
 1444,
 742272065,
 741881408,
 -1,
 742337600,
 742207614,
 1436,
 -1,
 742261669,
 1437,
 -1,
 742292784,
 1438,
 742534212,
 742234667,
 -1,
 -54205,
 742491955,
 1434,
 -1,
 742551765,
 1450,
 742730823,
 742488715,
 -1,
 -54202,
 742668913,
 1427,
 -1,
 742730809,
 1426,
 742927434,
 742682316,
 -1,
 -54199,
 742881298,
 1439,
 -1,
 742925549,
 1448,
 743124045,
 742877754,
 -1,
 -54196,
 743087130,
 1441,
 -1,
 743144916,
 1433,
 743320656,
 743055746,
 -1,
 -54193,
 743255187,
 1453,
 -1,
 743314312,
 1447,
 -54191,
 743273252,
 1431,
 -54190,
 743465630,
 1451,
 -54189,
 743523121,
 1452,
 -1,
 743584138,
 1425,
 743779443,
 740911637,
 -1,
 743844972,
 743727698,
 -1,
 743910493,
 743782728,
 -1,
 743976027,
 743839121,
 -1,
 -54183,
 743930865,
 1457,
 -54182,
 743993089,
 1459,
 -1,
 744057624,
 1458,
 -54180,
 743924373,
 1465,
 -1,
 744179488,
 1460,
 744369251,
 743864971,
 -1,
 744434785,
 744307016,
 -1,
 -54176,
 744375301,
 1473,
 -1,
 744436167,
 1456,
 -54174,
 744375301,
 1474,
 -1,
 744565817,
 1462,
 744762470,
 744320714,
 -1,
 -54171,
 744721323,
 1467,
 -1,
 744755071,
 1464,
 -54169,
 744720756,
 1461,
 -54168,
 744911045,
 1471,
 -54167,
 744975128,
 1463,
 -54166,
 745035746,
 1469,
 -54165,
 745097605,
 64286,
 -1,
 745153002,
 1468,
 745406463,
 743804189,
 -1,
 745417840,
 745289280,
 -1,
 -54161,
 745372976,
 1524,
 -1,
 745418878,
 1523,
 -54159,
 745373635,
 1475,
 -54158,
 745564946,
 1472,
 -1,
 745625245,
 1470,
 745865215,
 743724720,
 -1,
 -54155,
 745770751,
 1476,
 -1,
 745821883,
 1455,
 746007737,
 734533207,
 -1,
 746073219,
 745936547,
 -1,
 746138754,
 746015703,
 -1,
 746204285,
 746063990,
 -1,
 -54149,
 746160132,
 10167,
 -54148,
 746223068,
 10168,
 -1,
 746282610,
 10169,
 746520575,
 746127360,
 -1,
 746531969,
 746398018,
 -1,
 -54144,
 746491843,
 10150,
 -1,
 746530855,
 10149,
 -1,
 746470218,
 10084,
 -1,
 746065686,
 10008,
 746859658,
 746029708,
 -1,
 746925193,
 746793341,
 -1,
 746990728,
 746876298,
 -1,
 -54137,
 746941647,
 10051,
 -1,
 746984749,
 10045,
 -1,
 746928830,
 10171,
 -1,
 746877853,
 10142,
 747318416,
 746814091,
 -1,
 747383950,
 747259045,
 -1,
 -54131,
 747342303,
 10075,
 -1,
 747380502,
 10076,
 -54129,
 747334393,
 10056,
 -1,
 747530352,
 10136,
 747711639,
 747270257,
 -1,
 747777174,
 747651586,
 -1,
 747842709,
 747702666,
 -1,
 -54124,
 747794511,
 10095,
 -1,
 747838050,
 10097,
 -1,
 747803934,
 10137,
 -1,
 747726801,
 10140,
 748170396,
 747653965,
 -1,
 748235931,
 748104609,
 -1,
 -54118,
 748187727,
 10094,
 -1,
 748231266,
 10096,
 -1,
 748186043,
 10157,
 748498081,
 748103959,
 -1,
 748563616,
 748438023,
 -1,
 -54113,
 748520387,
 10059,
 -1,
 748580185,
 10040,
 -1,
 748525923,
 10082,
 748825766,
 748429698,
 -1,
 748891301,
 748775303,
 -1,
 -54108,
 748849631,
 10077,
 -1,
 748887830,
 10078,
 -1,
 748819677,
 10144,
 749153451,
 748755786,
 -1,
 749218986,
 749091635,
 -1,
 -54103,
 749180109,
 10054,
 -1,
 749215319,
 10004,
 -1,
 749167474,
 10152,
 749481134,
 749114591,
 -1,
 -54099,
 749420748,
 10132,
 -1,
 749480611,
 10173,
 749677745,
 749429007,
 -1,
 -54096,
 749637955,
 10030,
 -1,
 749693831,
 10012,
 -54094,
 749638386,
 10074,
 -54093,
 749834038,
 10158,
 -54092,
 749887090,
 10138,
 -54091,
 749951586,
 10006,
 -54090,
 750009168,
 10083,
 -54089,
 750074026,
 10010,
 -54088,
 750138603,
 10020,
 -1,
 750196013,
 10033,
 -54086,
 745961419,
 8889,
 -1,
 750342805,
 9096,
 750529830,
 734480029,
 -1,
 750595363,
 750473284,
 -1,
 750660818,
 750549643,
 -1,
 750726349,
 750605806,
 -1,
 750791875,
 750688723,
 -1,
 -54079,
 750750452,
 12421,
 -54078,
 750805263,
 12423,
 -1,
 750848637,
 12419,
 751054022,
 750733731,
 -1,
 -54075,
 750987543,
 12438,
 -1,
 751045245,
 12437,
 -54073,
 751015158,
 12430,
 -54072,
 751209204,
 12357,
 -54071,
 751274437,
 12387,
 -54070,
 751329551,
 12361,
 -54069,
 751386497,
 12355,
 -54068,
 751446295,
 12359,
 -1,
 751503997,
 12353,
 -54066,
 750684916,
 12377,
 -54065,
 751657231,
 12381,
 -54064,
 751714177,
 12375,
 -54063,
 751773975,
 12379,
 -1,
 751831677,
 12373,
 752037080,
 750607010,
 12435,
 -54060,
 751995636,
 12396,
 -54059,
 752050447,
 12398,
 -54058,
 752107393,
 12395,
 -54057,
 752167191,
 12397,
 -1,
 752224893,
 12394,
 752430302,
 751999950,
 -1,
 -54054,
 752388852,
 12378,
 -54053,
 752443663,
 12382,
 -54052,
 752500609,
 12376,
 -54051,
 752560407,
 12380,
 -1,
 752618109,
 12374,
 752823524,
 752386700,
 -1,
 -54048,
 752782068,
 12388,
 -54047,
 752836879,
 12392,
 -54046,
 752893825,
 12385,
 -54045,
 752953623,
 12390,
 -1,
 753011325,
 12383,
 753216746,
 752775281,
 -1,
 -54042,
 753175284,
 12427,
 -54041,
 753230095,
 12429,
 -54040,
 753287041,
 12426,
 -54039,
 753346839,
 12428,
 -1,
 753404541,
 12425,
 753609968,
 753166869,
 -1,
 -54036,
 753568500,
 12407,
 -54035,
 753623311,
 12413,
 -54034,
 753680257,
 12404,
 -54033,
 753740055,
 12410,
 -1,
 753797757,
 12401,
 754003190,
 753554735,
 -1,
 -54030,
 753961716,
 12416,
 -54029,
 754016527,
 12418,
 -54028,
 754073473,
 12415,
 -54027,
 754133271,
 12417,
 -1,
 754190973,
 12414,
 754396412,
 753944995,
 -1,
 -54024,
 754354932,
 12367,
 -54023,
 754409743,
 12371,
 -54022,
 754466689,
 12365,
 -54021,
 754526487,
 12369,
 -1,
 754584189,
 12363,
 754789634,
 754334024,
 -1,
 -54018,
 754748148,
 12405,
 -54017,
 754802959,
 12411,
 -54016,
 754859905,
 12402,
 -54015,
 754919703,
 12408,
 -1,
 754977405,
 12399,
 755182856,
 754726295,
 -1,
 -54012,
 755141364,
 12368,
 -54011,
 755196175,
 12372,
 -54010,
 755253121,
 12366,
 -54009,
 755312919,
 12370,
 -1,
 755370621,
 12364,
 755576078,
 755114370,
 -1,
 -54006,
 755534580,
 12389,
 -54005,
 755589391,
 12393,
 -54004,
 755646337,
 12386,
 -54003,
 755706135,
 12391,
 -1,
 755763837,
 12384,
 755969300,
 755504803,
 -1,
 -54000,
 755927796,
 12406,
 -53999,
 755982607,
 12412,
 -53998,
 756039553,
 12403,
 -53997,
 756099351,
 12409,
 -1,
 756157053,
 12400,
 756362521,
 755930335,
 -1,
 -53994,
 756310287,
 12434,
 -53993,
 756367233,
 12432,
 -53992,
 756427031,
 12433,
 -1,
 756484733,
 12431,
 756690205,
 756324819,
 -1,
 -53989,
 756648692,
 12422,
 -53988,
 756703503,
 12424,
 -1,
 756746877,
 12420,
 -53986,
 756651228,
 12436,
 -53985,
 756910836,
 12358,
 -53984,
 756965647,
 12362,
 -53983,
 757022593,
 12356,
 -53982,
 757082391,
 12360,
 -1,
 757140093,
 12354,
 -53980,
 750556286,
 12446,
 -53979,
 757286851,
 12445,
 -1,
 757343304,
 12447,
 757542197,
 750477583,
 -1,
 757607728,
 757495708,
 -1,
 757673261,
 757562233,
 -1,
 -53974,
 757598843,
 9149,
 -53973,
 757664364,
 9148,
 -53972,
 757729848,
 9147,
 -1,
 757795355,
 9146,
 -53970,
 757616977,
 9135,
 -53969,
 757935419,
 8230,
 -1,
 757995282,
 8213,
 758197555,
 757566196,
 -1,
 -53966,
 758152129,
 8962,
 -1,
 758215492,
 8987,
 -53964,
 758153930,
 9832,
 -1,
 758340016,
 8763,
 758579199,
 757504467,
 -1,
 758590778,
 758475928,
 8208,
 -53960,
 758519259,
 8231,
 -53959,
 758581572,
 45,
 -1,
 758645192,
 8259,
 -1,
 758546702,
 9102,
 758919413,
 692290188,
 -1,
 758984285,
 758857601,
 -1,
 759049807,
 758913198,
 -1,
 759115174,
 759003787,
 -1,
 759180667,
 759073580,
 -1,
 759246153,
 759136908,
 -1,
 759311684,
 759202444,
 -1,
 -53949,
 759249250,
 3995,
 -1,
 759302781,
 3994,
 759508295,
 759265931,
 -1,
 -53946,
 759445858,
 4010,
 -1,
 759499389,
 4009,
 -53944,
 759445858,
 4000,
 -1,
 759630461,
 3999,
 759835986,
 759177602,
 -1,
 759901517,
 759798734,
 -1,
 -53940,
 759839074,
 4012,
 -1,
 759892605,
 4011,
 760098128,
 759832962,
 -1,
 -53937,
 760035682,
 3997,
 -1,
 760089213,
 3996,
 -53935,
 760035682,
 4002,
 -1,
 760220285,
 4001,
 760425815,
 759782050,
 -1,
 -53932,
 760388074,
 3993,
 -53931,
 760437474,
 3998,
 -53930,
 760493468,
 3988,
 -1,
 760547965,
 4003,
 760753499,
 760380043,
 -1,
 -53927,
 760707786,
 4021,
 -53926,
 760756578,
 4020,
 -1,
 760810109,
 4022,
 761015647,
 760695203,
 -1,
 -53923,
 760971419,
 4025,
 -53922,
 761018722,
 3985,
 -1,
 761072253,
 3984,
 761277795,
 760951898,
 -1,
 -53919,
 761240042,
 4027,
 -53918,
 761304310,
 4026,
 -1,
 761360533,
 4028,
 761539942,
 761240526,
 -1,
 -53915,
 761477474,
 4014,
 -1,
 761531005,
 4015,
 761736553,
 761489941,
 -1,
 -53912,
 761674082,
 4005,
 -1,
 761727613,
 4004,
 761933164,
 761673111,
 -1,
 -53909,
 761870690,
 3987,
 -1,
 761924221,
 3986,
 762129775,
 761862986,
 -1,
 -53906,
 762067298,
 3990,
 -1,
 762120829,
 3989,
 762326386,
 762058403,
 -1,
 -53903,
 762263906,
 4007,
 -1,
 762317437,
 4006,
 -53901,
 762288618,
 4017,
 -53900,
 762483958,
 4013,
 -53899,
 762540181,
 4018,
 -53898,
 762598712,
 4008,
 -53897,
 762661772,
 4019,
 -53896,
 762726589,
 3991,
 -53895,
 762788194,
 4023,
 -53894,
 762841725,
 4024,
 -1,
 762906630,
 4016,
 763112856,
 759120520,
 -1,
 763178378,
 763064433,
 -1,
 763243912,
 763110038,
 -1,
 763309444,
 763176159,
 -1,
 763374979,
 763245975,
 -1,
 -53887,
 763331024,
 3868,
 -53886,
 763388135,
 3867,
 -1,
 763436448,
 3866,
 -1,
 763326893,
 3871,
 763756543,
 763255548,
 -1,
 -53882,
 763658704,
 4047,
 -53881,
 763715815,
 3870,
 -1,
 763764128,
 3869,
 -53879,
 763190023,
 3967,
 -1,
 763906384,
 3966,
 764095885,
 763140586,
 -1,
 -53876,
 764047485,
 3902,
 -1,
 764107948,
 3975,
 764292496,
 764040495,
 -1,
 -53873,
 764222855,
 3977,
 -1,
 764285629,
 3903,
 764489107,
 764235069,
 -1,
 -53870,
 764428204,
 3974,
 -1,
 764487995,
 3976,
 764685718,
 764426472,
 -1,
 -53867,
 764630809,
 3979,
 -1,
 764681122,
 3978,
 -53865,
 764641203,
 3971,
 -1,
 764829912,
 3970,
 765067263,
 763075027,
 -1,
 765078949,
 764958440,
 -1,
 765144479,
 765025831,
 4041,
 765263871,
 765067264,
 -1,
 -53859,
 765157612,
 4042,
 -53858,
 765212934,
 4043,
 -1,
 765270833,
 4044,
 765472161,
 765096374,
 4037,
 -1,
 765396248,
 4039,
 765603236,
 765422101,
 -1,
 -53853,
 765542201,
 4040,
 -1,
 765594740,
 4038,
 -1,
 765536456,
 4036,
 -1,
 765022778,
 3840,
 765930979,
 759057229,
 -1,
 765996512,
 765866413,
 -1,
 766062001,
 765952652,
 -1,
 766127532,
 766018188,
 -1,
 -53845,
 766064994,
 3915,
 -1,
 766118525,
 3914,
 766324143,
 766081675,
 -1,
 -53842,
 766261602,
 3930,
 -1,
 766315133,
 3929,
 -53840,
 766261602,
 3920,
 -1,
 766446205,
 3919,
 766651834,
 765993346,
 -1,
 766717365,
 766614478,
 -1,
 -53836,
 766654818,
 3932,
 -1,
 766708349,
 3931,
 766913976,
 766648706,
 -1,
 -53833,
 766851426,
 3917,
 -1,
 766904957,
 3916,
 -53831,
 766851426,
 3922,
 -1,
 767036029,
 3921,
 767241663,
 766597794,
 -1,
 -53828,
 767203818,
 3913,
 -53827,
 767253218,
 3918,
 -53826,
 767309212,
 3908,
 -1,
 767363709,
 3923,
 767569347,
 767195787,
 -1,
 -53823,
 767523530,
 3941,
 -53822,
 767572322,
 3940,
 -1,
 767625853,
 3942,
 767831495,
 767510947,
 -1,
 -53819,
 767787163,
 3945,
 -53818,
 767834466,
 3905,
 -1,
 767887997,
 3904,
 768093642,
 767794126,
 -1,
 -53815,
 768031074,
 3934,
 -1,
 768084605,
 3935,
 768290253,
 768043541,
 -1,
 -53812,
 768227682,
 3925,
 -1,
 768281213,
 3924,
 768486864,
 768226711,
 -1,
 -53809,
 768424290,
 3907,
 -1,
 768477821,
 3906,
 768683475,
 768416586,
 -1,
 -53806,
 768620898,
 3910,
 -1,
 768674429,
 3909,
 768880086,
 768612003,
 -1,
 -53803,
 768817506,
 3927,
 -1,
 768871037,
 3926,
 -53801,
 768842218,
 3937,
 -53800,
 769037558,
 3933,
 -53799,
 769093781,
 3938,
 -53798,
 769152312,
 3928,
 -53797,
 769215372,
 3939,
 -53796,
 769280189,
 3911,
 -53795,
 769341794,
 3943,
 -53794,
 769406054,
 3946,
 -53793,
 769460861,
 3944,
 -1,
 769525766,
 3936,
 769785855,
 765944307,
 -1,
 -53790,
 769675454,
 3862,
 -1,
 769727739,
 3861,
 769928726,
 765875888,
 -1,
 769994223,
 769865111,
 -1,
 770059756,
 769950826,
 -1,
 770125291,
 770022068,
 -1,
 770190826,
 770050577,
 -1,
 -53783,
 770144239,
 3842,
 -1,
 770193682,
 3843,
 -1,
 770148703,
 3841,
 -1,
 770083194,
 3860,
 770572287,
 770018273,
 -1,
 -53778,
 770466636,
 3898,
 -1,
 770512034,
 3899,
 770715127,
 769923914,
 -1,
 770780661,
 770642814,
 -1,
 770846196,
 770705499,
 -1,
 -53773,
 770791176,
 3859,
 -1,
 770841405,
 3894,
 -1,
 770808509,
 3846,
 -53770,
 770724793,
 3845,
 -1,
 771046198,
 3896,
 771239422,
 770661026,
 -1,
 771304955,
 771201772,
 -1,
 -53766,
 771262848,
 3856,
 -1,
 771325182,
 3854,
 771555327,
 771241437,
 -1,
 -53763,
 771456217,
 3895,
 -1,
 771514576,
 3893,
 771698179,
 771167907,
 -1,
 771763714,
 771652235,
 -1,
 -53759,
 771705624,
 3849,
 -1,
 771762426,
 3892,
 -1,
 771705256,
 3850,
 772025862,
 771656043,
 -1,
 -53755,
 771963891,
 3855,
 -1,
 772016767,
 3897,
 772222473,
 771979915,
 -1,
 -53752,
 772159866,
 3853,
 -1,
 772217502,
 3848,
 772419084,
 772173937,
 -1,
 -53749,
 772359130,
 3857,
 -1,
 772421946,
 3858,
 772615695,
 772359123,
 -1,
 -53746,
 772572364,
 3851,
 -1,
 772622318,
 3844,
 772812306,
 772542713,
 -1,
 -53743,
 772760396,
 3900,
 -1,
 772805794,
 3901,
 -53741,
 772774610,
 3847,
 -53740,
 772958848,
 3973,
 -53739,
 773012003,
 3972,
 -1,
 773071525,
 3852,
 773271090,
 769860630,
 -1,
 773336613,
 773208624,
 -1,
 773402139,
 773292684,
 -1,
 -53734,
 773363865,
 3883,
 -1,
 773406371,
 3884,
 773598750,
 773356171,
 -1,
 -53731,
 773539985,
 3887,
 -1,
 773599695,
 3888,
 773795361,
 773534400,
 -1,
 -53728,
 773744637,
 3885,
 -1,
 773802050,
 3886,
 -53726,
 773757982,
 3891,
 -53725,
 773940154,
 3882,
 -53724,
 774004044,
 3890,
 -1,
 774057114,
 3889,
 774254120,
 773292684,
 -1,
 -53721,
 774215833,
 3874,
 -1,
 774258339,
 3875,
 774450731,
 774208139,
 -1,
 -53718,
 774391953,
 3878,
 -1,
 774451663,
 3879,
 774647342,
 774386368,
 -1,
 -53715,
 774596605,
 3876,
 -1,
 774654018,
 3877,
 -53713,
 774609950,
 3872,
 -53712,
 774792122,
 3873,
 -53711,
 774856012,
 3881,
 -1,
 774909082,
 3880,
 775106115,
 773231809,
 -1,
 775171640,
 775066731,
 -1,
 775237174,
 775123057,
 3958,
 -1,
 775188593,
 3959,
 775421951,
 775179085,
 3960,
 -1,
 775310157,
 3961,
 775499322,
 775129844,
 3956,
 -1,
 775457524,
 3957,
 775630396,
 775451380,
 3968,
 -1,
 775569281,
 3969,
 775761470,
 775577871,
 3964,
 -1,
 775708943,
 3965,
 775892544,
 775700353,
 3954,
 -1,
 775831425,
 3955,
 776023618,
 775825687,
 3962,
 -1,
 775956759,
 3963,
 -1,
 775948946,
 3953,
 776220232,
 775035879,
 -1,
 -53691,
 776174446,
 4035,
 -53690,
 776229143,
 4033,
 -53689,
 776289217,
 4032,
 -1,
 776346589,
 4034,
 776547917,
 776148307,
 -1,
 776613452,
 776501899,
 -1,
 -53685,
 776550295,
 3863,
 -1,
 776611138,
 3865,
 -1,
 776538406,
 3864,
 776929279,
 776489722,
 4030,
 -1,
 776798672,
 4031,
 777006678,
 758992217,
 126,
 777125887,
 776930312,
 8764,
 777191423,
 776994816,
 -1,
 777203285,
 777098961,
 -1,
 -53676,
 777156460,
 10859,
 -1,
 777200983,
 10858,
 -1,
 777128769,
 10610,
 777465433,
 776951750,
 -1,
 -53672,
 777417860,
 10709,
 -1,
 777473500,
 10708,
 -53670,
 777418827,
 8266,
 -53669,
 777609421,
 10750,
 -53668,
 777664183,
 10053,
 -1,
 777726244,
 10717,
 777924437,
 758909565,
 -1,
 777989891,
 777860503,
 -1,
 778055381,
 777912320,
 -1,
 778120863,
 777997133,
 -1,
 778186392,
 778048962,
 -1,
 778251901,
 778141567,
 -1,
 -53660,
 778214350,
 917626,
 -53659,
 778279379,
 917625,
 -53658,
 778344741,
 917624,
 -53657,
 778409183,
 917623,
 -53656,
 778473850,
 917622,
 -53655,
 778537716,
 917621,
 -53654,
 778601100,
 917620,
 -53653,
 778664587,
 917619,
 -53652,
 778727537,
 917618,
 -53651,
 778792650,
 917617,
 -53650,
 778856981,
 917616,
 -53649,
 778920207,
 917615,
 -53648,
 778984098,
 917614,
 -53647,
 779048239,
 917613,
 -53646,
 779111245,
 917612,
 -53645,
 779176355,
 917611,
 -53644,
 779241645,
 917610,
 -53643,
 779304833,
 917609,
 -53642,
 779368776,
 917608,
 -53641,
 779433367,
 917607,
 -53640,
 779498176,
 917606,
 -53639,
 779561239,
 917605,
 -53638,
 779624834,
 917604,
 -53637,
 779688778,
 917603,
 -53636,
 779753123,
 917602,
 -1,
 779815549,
 917601,
 780075007,
 778181684,
 -1,
 -53633,
 779983822,
 917594,
 -53632,
 780048851,
 917593,
 -53631,
 780114213,
 917592,
 -53630,
 780178655,
 917591,
 -53629,
 780243322,
 917590,
 -53628,
 780307188,
 917589,
 -53627,
 780370572,
 917588,
 -53626,
 780434059,
 917587,
 -53625,
 780497009,
 917586,
 -53624,
 780562122,
 917585,
 -53623,
 780626453,
 917584,
 -53622,
 780689679,
 917583,
 -53621,
 780753570,
 917582,
 -53620,
 780817711,
 917581,
 -53619,
 780880717,
 917580,
 -53618,
 780945827,
 917579,
 -53617,
 781011117,
 917578,
 -53616,
 781074305,
 917577,
 -53615,
 781138248,
 917576,
 -53614,
 781202839,
 917575,
 -53613,
 781267648,
 917574,
 -53612,
 781330711,
 917573,
 -53611,
 781394306,
 917572,
 -53610,
 781458250,
 917571,
 -53609,
 781522595,
 917570,
 -1,
 781585021,
 917569,
 781790878,
 778119447,
 -1,
 781856413,
 781727030,
 -1,
 -53605,
 781811796,
 917595,
 -53604,
 781871817,
 917544,
 -1,
 781918462,
 917627,
 -1,
 781811854,
 917564,
 -1,
 781740354,
 917599,
 782249647,
 778051970,
 -1,
 782315182,
 782189177,
 -1,
 782380708,
 782271116,
 -1,
 -53597,
 782342297,
 917554,
 -1,
 782384803,
 917555,
 782577319,
 782334603,
 -1,
 -53594,
 782518417,
 917558,
 -1,
 782578127,
 917559,
 782773930,
 782512832,
 -1,
 -53591,
 782723069,
 917556,
 -1,
 782780482,
 917557,
 -53589,
 782736414,
 917552,
 -53588,
 782918586,
 917553,
 -53587,
 782982476,
 917561,
 -1,
 783035546,
 917560,
 -1,
 782262988,
 917540,
 783298229,
 782200945,
 -1,
 783363764,
 783237639,
 -1,
 -53582,
 783319124,
 917597,
 -53581,
 783379145,
 917545,
 -1,
 783425790,
 917629,
 -1,
 783299063,
 917596,
 783691452,
 783227722,
 -1,
 783756987,
 783638799,
 -1,
 783822522,
 783702292,
 -1,
 -53575,
 783757280,
 917568,
 -1,
 783813245,
 917548,
 -1,
 783766284,
 917562,
 -1,
 783697626,
 917598,
 784150208,
 783645323,
 -1,
 -53570,
 784099917,
 917536,
 -53569,
 784163490,
 917551,
 -1,
 784215471,
 917563,
 784412356,
 784075389,
 -1,
 -53566,
 784367902,
 917546,
 -53565,
 784428478,
 917543,
 -1,
 784488934,
 917542,
 784674503,
 784363307,
 -1,
 -53562,
 784623388,
 917538,
 -1,
 784675064,
 917567,
 784871114,
 784624149,
 -1,
 -53559,
 784815315,
 917547,
 -1,
 784871372,
 917541,
 785067725,
 784807828,
 -1,
 -53556,
 785000876,
 917566,
 -1,
 785061428,
 917600,
 785264336,
 785000727,
 -1,
 -53553,
 785226067,
 917537,
 -1,
 785280877,
 917565,
 -53551,
 785224588,
 917628,
 -53550,
 785417871,
 917630,
 -53549,
 785473570,
 917539,
 -53548,
 785530737,
 917549,
 -1,
 785593722,
 917550,
 785788653,
 777981751,
 -1,
 785854185,
 785731652,
 -1,
 785919706,
 785799842,
 -1,
 -53543,
 785855900,
 5893,
 -1,
 785910397,
 5896,
 -53541,
 785881578,
 5900,
 -53540,
 786076918,
 5903,
 -53539,
 786139892,
 5890,
 -53538,
 786203348,
 5894,
 -53537,
 786266826,
 5904,
 -53536,
 786328122,
 5897,
 -53535,
 786388280,
 5899,
 -53534,
 786451340,
 5902,
 -53533,
 786516389,
 5891,
 -53532,
 786579329,
 5889,
 -53531,
 786643298,
 5905,
 -53530,
 786707868,
 5892,
 -53529,
 786768342,
 5895,
 -53528,
 786831013,
 5898,
 -1,
 786893437,
 5888,
 787099372,
 785814721,
 -1,
 -53525,
 787057396,
 5907,
 -1,
 787103617,
 5906,
 -1,
 787054144,
 5908,
 787415039,
 785717003,
 -1,
 787427072,
 787304516,
 -1,
 787492594,
 787372706,
 -1,
 -53519,
 787428764,
 5989,
 -1,
 787483261,
 5992,
 -53517,
 787454442,
 5996,
 -53516,
 787649782,
 5999,
 -53515,
 787712756,
 5986,
 -53514,
 787776212,
 5990,
 -53513,
 787839690,
 6000,
 -53512,
 787900986,
 5993,
 -53511,
 787961144,
 5995,
 -53510,
 788024204,
 5998,
 -53509,
 788089253,
 5987,
 -53508,
 788152193,
 5985,
 -53507,
 788215196,
 5988,
 -53506,
 788275670,
 5991,
 -53505,
 788338341,
 5994,
 -1,
 788400765,
 5984,
 788660223,
 787387585,
 -1,
 -53502,
 788564724,
 6003,
 -1,
 788610945,
 6002,
 788803411,
 777935006,
 -1,
 788868910,
 788746308,
 -1,
 788934412,
 788814498,
 -1,
 788999945,
 788880034,
 -1,
 -53496,
 788945634,
 2985,
 -1,
 788990589,
 2979,
 -53494,
 788961770,
 2974,
 -53493,
 789132700,
 2969,
 -1,
 789187197,
 2984,
 789393168,
 788859517,
 2949,
 -53490,
 789351156,
 2964,
 -53489,
 789397377,
 2960,
 -1,
 789449341,
 2950,
 789655317,
 789334861,
 -1,
 789720852,
 789597005,
 -1,
 -53485,
 789662604,
 2996,
 -1,
 789711485,
 2995,
 -1,
 789645949,
 2994,
 789982999,
 789613300,
 2953,
 -1,
 789940980,
 2954,
 790114074,
 789938828,
 -1,
 -53479,
 790069972,
 2975,
 -1,
 790104701,
 2980,
 790310685,
 790067851,
 -1,
 -53476,
 790264522,
 2999,
 -1,
 790301309,
 3000,
 790507296,
 790261873,
 -1,
 -53473,
 790458517,
 2993,
 -1,
 790497917,
 2992,
 790703906,
 790454543,
 2962,
 -1,
 790651151,
 2963,
 790834980,
 790642561,
 2951,
 -1,
 790773633,
 2952,
 790966054,
 790767895,
 2958,
 -1,
 790898967,
 2959,
 -53465,
 790927850,
 2991,
 -53464,
 791056764,
 2997,
 -53463,
 791112250,
 2986,
 -53462,
 791172408,
 2990,
 -53461,
 791234981,
 2965,
 -53460,
 791300285,
 2972,
 -53459,
 791361890,
 3001,
 -1,
 791419778,
 2970,
 791621435,
 788829377,
 -1,
 791686963,
 791546493,
 -1,
 -53455,
 791644916,
 3020,
 -53454,
 791691137,
 3016,
 -1,
 791743101,
 3006,
 791949109,
 791644916,
 3009,
 -1,
 791907060,
 3010,
 792080183,
 791896335,
 3018,
 -1,
 792027407,
 3019,
 792211257,
 792018817,
 3007,
 -1,
 792149889,
 3008,
 792395775,
 792144151,
 3014,
 -1,
 792275223,
 3015,
 792473416,
 791553046,
 -1,
 792538943,
 792429196,
 -1,
 -53442,
 792500377,
 3048,
 -1,
 792542883,
 3049,
 792735554,
 792492683,
 -1,
 -53439,
 792676497,
 3052,
 -1,
 792736207,
 3053,
 792932165,
 792670912,
 -1,
 -53436,
 792881149,
 3050,
 -1,
 792938562,
 3051,
 -53434,
 792880058,
 3047,
 -53433,
 793075020,
 3055,
 -1,
 793128090,
 3054,
 793325389,
 792428076,
 -1,
 793390924,
 793285615,
 -1,
 -53429,
 793344839,
 2947,
 -1,
 793407756,
 3021,
 -1,
 793317865,
 2946,
 793653074,
 793272346,
 -1,
 793718609,
 793600958,
 -1,
 -53424,
 793675185,
 3058,
 -1,
 793722650,
 3057,
 -1,
 793674800,
 3056,
 -1,
 793581058,
 3031,
 -53420,
 788762758,
 9801,
 -1,
 793996093,
 9991,
 794177581,
 777861448,
 -1,
 794243099,
 794102397,
 -1,
 794308567,
 794181507,
 -1,
 794374089,
 794237770,
 -1,
 794439624,
 794311386,
 -1,
 794505073,
 794393227,
 -1,
 794570603,
 794432198,
 -1,
 794636131,
 794495613,
 3632,
 794701664,
 794574751,
 -1,
 -53409,
 794659601,
 3651,
 -1,
 794693074,
 3652,
 -53407,
 794645807,
 3635,
 -53406,
 794831127,
 3649,
 -1,
 794888829,
 3634,
 795094887,
 794594036,
 3640,
 795160422,
 795027735,
 3638,
 -1,
 795093271,
 3639,
 -1,
 795118324,
 3641,
 795357033,
 795033473,
 3636,
 -1,
 795295617,
 3637,
 -53398,
 795304207,
 3650,
 -1,
 795420951,
 3648,
 795672575,
 794517777,
 -1,
 795684720,
 795572875,
 -1,
 -53394,
 795642638,
 3626,
 -53393,
 795697423,
 3595,
 -1,
 795741646,
 3624,
 -1,
 795638378,
 3625,
 796012416,
 794460812,
 -1,
 796077949,
 795949384,
 -1,
 796143484,
 796025105,
 -1,
 796209018,
 796099849,
 -1,
 796274552,
 796134013,
 -1,
 -53385,
 796220066,
 3600,
 -1,
 796277395,
 3607,
 -53383,
 796233067,
 3606,
 -1,
 796419042,
 3608,
 -53381,
 796159160,
 3602,
 -1,
 796547869,
 3601,
 -1,
 796070331,
 3660,
 796852223,
 796025105,
 -1,
 -53377,
 796754776,
 3605,
 -1,
 796814110,
 3599,
 796995468,
 795956527,
 -1,
 797061003,
 796921101,
 -1,
 797126537,
 796983296,
 -1,
 797192070,
 797082252,
 -1,
 -53371,
 797143907,
 3658,
 -1,
 797195591,
 3657,
 -53369,
 797129367,
 3633,
 -53368,
 797322489,
 3656,
 -1,
 797383955,
 3659,
 -53366,
 797088245,
 3654,
 -1,
 797541126,
 3655,
 -1,
 797008164,
 3617,
 797781911,
 796936611,
 -1,
 797847446,
 797719879,
 -1,
 797912981,
 797769728,
 -1,
 797978516,
 797854307,
 -1,
 -53359,
 797938952,
 3588,
 -53358,
 798001941,
 3587,
 -53357,
 798057292,
 3589,
 -1,
 798100749,
 3586,
 -1,
 797929732,
 3590,
 -1,
 797858425,
 3675,
 -1,
 797794590,
 3585,
 798502817,
 797731349,
 -1,
 798568351,
 798439752,
 -1,
 798633886,
 798515473,
 -1,
 798699421,
 798583916,
 -1,
 -53348,
 798657899,
 3612,
 -1,
 798691326,
 3614,
 -1,
 798653178,
 3616,
 -1,
 798573981,
 3642,
 -53344,
 798515501,
 3611,
 -1,
 798952776,
 3631,
 799158183,
 798448290,
 -1,
 799223717,
 799105321,
 -1,
 -53340,
 799181556,
 3609,
 -1,
 799223304,
 3603,
 -53338,
 799163065,
 3661,
 -1,
 799356765,
 3591,
 799551405,
 799099725,
 -1,
 799616939,
 799498513,
 -1,
 -53334,
 799560124,
 3621,
 -1,
 799612303,
 3628,
 -53332,
 799574772,
 3622,
 -1,
 799739253,
 3653,
 799944626,
 799481192,
 -1,
 800010160,
 799870974,
 3592,
 -1,
 799946135,
 3594,
 -53327,
 799957432,
 3596,
 -1,
 800081017,
 3593,
 800272311,
 799906259,
 -1,
 800337846,
 800219465,
 -1,
 -53323,
 800277625,
 3597,
 -1,
 800329041,
 3618,
 -1,
 800264055,
 3662,
 800599995,
 800208043,
 -1,
 800665530,
 800522891,
 3613,
 -1,
 800610978,
 3615,
 -1,
 800611565,
 3663,
 800862142,
 800551025,
 -1,
 -53315,
 800819956,
 3620,
 -1,
 800874803,
 3619,
 801058753,
 800800074,
 -1,
 -53312,
 801005052,
 3630,
 -1,
 801062119,
 3627,
 801255364,
 800990452,
 -1,
 -53309,
 801186450,
 3604,
 -1,
 801250566,
 3598,
 -53307,
 801216751,
 3623,
 -53306,
 801399060,
 3629,
 -53305,
 801446307,
 3610,
 -1,
 801509659,
 3674,
 -1,
 794398817,
 3647,
 801832959,
 794305558,
 -1,
 801845197,
 801735308,
 -1,
 -53300,
 801806489,
 3666,
 -1,
 801848995,
 3667,
 802041808,
 801798795,
 -1,
 -53297,
 801982609,
 3670,
 -1,
 802042319,
 3671,
 802238419,
 801977024,
 -1,
 -53294,
 802187261,
 3668,
 -1,
 802244674,
 3669,
 -53292,
 802200606,
 3664,
 -53291,
 802382778,
 3665,
 -53290,
 802446668,
 3673,
 -1,
 802499738,
 3672,
 802750463,
 794234893,
 -1,
 802762765,
 802639940,
 -1,
 802828255,
 802718348,
 -1,
 802893788,
 802765157,
 1932,
 -1,
 802837677,
 1947,
 -53283,
 802849507,
 1944,
 -53282,
 802971919,
 1952,
 -1,
 803018313,
 1939,
 803221477,
 802781835,
 -1,
 803287011,
 803158344,
 -1,
 -53278,
 803220237,
 1949,
 -1,
 803280457,
 1921,
 -53276,
 803220237,
 1936,
 -1,
 803408533,
 1950,
 803614698,
 803183566,
 -1,
 803680233,
 803539581,
 -1,
 -53272,
 803640417,
 1938,
 -1,
 803670653,
 1948,
 -1,
 803627279,
 1953,
 803942382,
 803550615,
 -1,
 -53268,
 803887985,
 1935,
 -53267,
 803944960,
 1955,
 -1,
 803998363,
 1934,
 804204531,
 803873154,
 -1,
 804270066,
 804129405,
 -1,
 -53263,
 804230241,
 1937,
 -1,
 804260958,
 1951,
 -1,
 804206953,
 1931,
 804532214,
 804149922,
 -1,
 -53259,
 804480133,
 1922,
 -1,
 804522642,
 1969,
 804728825,
 804473677,
 -1,
 -53256,
 804666146,
 1925,
 -1,
 804719264,
 1933,
 804925436,
 804669859,
 -1,
 -53253,
 804862309,
 1946,
 -1,
 804915867,
 1926,
 805122047,
 804862280,
 -1,
 -53250,
 805058917,
 1945,
 -1,
 805112466,
 1920,
 805318658,
 805046909,
 -1,
 -53247,
 805261536,
 1927,
 -1,
 805324200,
 1954,
 -53245,
 805280241,
 1940,
 -53244,
 805475581,
 1957,
 -53243,
 805540223,
 1928,
 -53242,
 805597353,
 1923,
 -53241,
 805662415,
 1956,
 -53240,
 805727012,
 1941,
 -53239,
 805787509,
 1929,
 -53238,
 805849288,
 1942,
 -53237,
 805909225,
 1930,
 -53236,
 805969180,
 1943,
 -1,
 806033064,
 1924,
 806236177,
 802709775,
 -1,
 -53233,
 806183295,
 1963,
 -53232,
 806230455,
 1966,
 -1,
 806292170,
 1967,
 806498325,
 806168855,
 -1,
 -53229,
 806459931,
 1965,
 -53228,
 806496763,
 1961,
 -1,
 806557638,
 1964,
 806760472,
 806423165,
 -1,
 -53225,
 806688458,
 1958,
 -1,
 806750885,
 1959,
 -53223,
 806718365,
 1962,
 -53222,
 806912450,
 1968,
 -1,
 806961208,
 1960,
 807153700,
 794194486,
 -1,
 807219233,
 807077874,
 -1,
 807284768,
 807149956,
 -1,
 -53217,
 807241735,
 10146,
 -1,
 807279116,
 10147,
 -1,
 807234498,
 8196,
 807600127,
 807141376,
 -1,
 -53213,
 807499307,
 8694,
 -1,
 807542638,
 10870,
 807743531,
 807088061,
 -1,
 807809066,
 807676183,
 -1,
 807874601,
 807731200,
 -1,
 -53208,
 807809662,
 8707,
 -1,
 807871748,
 8708,
 -1,
 807810239,
 8756,
 -1,
 807754070,
 10727,
 -53204,
 807701856,
 9736,
 -1,
 808141848,
 8201,
 808333473,
 794110231,
 -1,
 808399006,
 808274765,
 -1,
 808464538,
 808356861,
 -1,
 808530038,
 808406365,
 -1,
 808595573,
 808487338,
 -1,
 808661049,
 808554874,
 -1,
 808726584,
 808608136,
 -1,
 808792118,
 808677489,
 3083,
 -1,
 808743025,
 3168,
 808976383,
 808733517,
 3084,
 -1,
 808864589,
 3169,
 -1,
 808651389,
 3125,
 809119807,
 808616588,
 -1,
 809185341,
 809075340,
 -1,
 -53188,
 809122146,
 3104,
 -1,
 809175677,
 3103,
 -53186,
 809122146,
 3109,
 -1,
 809306749,
 3108,
 809513028,
 809065122,
 -1,
 -53183,
 809474538,
 3102,
 -53182,
 809523938,
 3107,
 -53181,
 809579932,
 3097,
 -1,
 809634429,
 3112,
 809840714,
 809443714,
 -1,
 809906248,
 809771394,
 -1,
 -53177,
 809843042,
 3106,
 -1,
 809896573,
 3105,
 -53175,
 809843042,
 3111,
 -1,
 810027645,
 3110,
 810233934,
 809765501,
 3077,
 -53172,
 810191604,
 3092,
 -53171,
 810237825,
 3088,
 -1,
 810289789,
 3078,
 810496082,
 810187403,
 -1,
 -53168,
 810449610,
 3127,
 -53167,
 810498402,
 3126,
 -1,
 810551933,
 3128,
 810758228,
 810453748,
 3081,
 -1,
 810715892,
 3082,
 810889303,
 810709105,
 -1,
 -53162,
 810840213,
 3121,
 -1,
 810879613,
 3120,
 811085914,
 810838549,
 -1,
 -53159,
 811022690,
 3115,
 -1,
 811076221,
 3114,
 811282524,
 811032847,
 3090,
 -1,
 811229455,
 3091,
 811413599,
 811223885,
 -1,
 -53154,
 811355020,
 3123,
 -1,
 811403901,
 3122,
 811610210,
 811354531,
 -1,
 -53151,
 811546978,
 3094,
 -1,
 811600509,
 3093,
 811806821,
 811550893,
 -1,
 -53148,
 811743586,
 3101,
 -1,
 811797117,
 3100,
 812003431,
 811745153,
 3079,
 -1,
 811941761,
 3080,
 812134506,
 811939223,
 -1,
 -53143,
 812071266,
 3096,
 -1,
 812124797,
 3095,
 812331116,
 812067095,
 3086,
 -1,
 812263703,
 3087,
 812462191,
 812260170,
 -1,
 -53138,
 812398946,
 3099,
 -1,
 812452477,
 3098,
 812658802,
 812390051,
 -1,
 -53135,
 812595554,
 3117,
 -1,
 812649085,
 3116,
 -53133,
 812620266,
 3119,
 -53132,
 812799288,
 3118,
 -1,
 812857698,
 3129,
 -1,
 808541440,
 3157,
 813117573,
 808490177,
 -1,
 813183099,
 813042301,
 -1,
 -53127,
 813140724,
 3148,
 -53126,
 813186945,
 3144,
 -1,
 813238909,
 3134,
 813445245,
 813143156,
 3139,
 -1,
 813396081,
 3140,
 813576319,
 813402868,
 3137,
 -1,
 813533940,
 3138,
 813707393,
 813523215,
 3146,
 -1,
 813654287,
 3147,
 813838467,
 813645697,
 3135,
 -1,
 813776769,
 3136,
 814022655,
 813771031,
 3142,
 -1,
 813902103,
 3143,
 814100627,
 813048854,
 -1,
 814166153,
 814056076,
 -1,
 -53112,
 814127257,
 3176,
 -1,
 814169763,
 3177,
 814362764,
 814119563,
 -1,
 -53109,
 814303377,
 3180,
 -1,
 814363087,
 3181,
 814559375,
 814297792,
 -1,
 -53106,
 814508029,
 3178,
 -1,
 814565442,
 3179,
 -53104,
 814521374,
 3174,
 -53103,
 814703546,
 3175,
 -53102,
 814767436,
 3183,
 -1,
 814820506,
 3182,
 815018137,
 814054956,
 -1,
 815083671,
 814978031,
 -1,
 -53098,
 815037255,
 3075,
 -1,
 815100172,
 3149,
 -53096,
 815012817,
 3073,
 -1,
 815206889,
 3074,
 -1,
 814943504,
 3158,
 815529983,
 808398636,
 -1,
 -53092,
 815431207,
 8481,
 -53091,
 815493586,
 8981,
 -1,
 815551179,
 9990,
 815792127,
 808325980,
 -1,
 -53088,
 815693878,
 10043,
 -1,
 815732552,
 10170,
 815935692,
 808284273,
 -1,
 816001224,
 815873921,
 -1,
 816066742,
 815951114,
 -1,
 816132265,
 816026367,
 -1,
 -53082,
 816093049,
 10997,
 -53081,
 816149917,
 8874,
 -53080,
 816194203,
 10624,
 -1,
 816257235,
 10996,
 816459948,
 816081429,
 -1,
 -53077,
 816412354,
 8244,
 -1,
 816469186,
 10747,
 816656559,
 816405646,
 -1,
 -53074,
 816598983,
 10999,
 -1,
 816658420,
 11000,
 816853170,
 816594357,
 -1,
 -53071,
 816810244,
 10857,
 -1,
 816850628,
 10856,
 -53069,
 816809615,
 8779,
 -53068,
 817004520,
 11003,
 -53067,
 817054999,
 8749,
 -1,
 817110773,
 10998,
 817311936,
 816002993,
 -1,
 817377466,
 817272031,
 -1,
 -53063,
 817316936,
 9780,
 -1,
 817370523,
 9781,
 -53061,
 817333817,
 9779,
 -53060,
 817519048,
 9782,
 -53059,
 817581088,
 9777,
 -53058,
 817642357,
 9776,
 -53057,
 817706015,
 9778,
 -1,
 817768849,
 9783,
 818020351,
 817238237,
 -1,
 818032839,
 817909085,
 -1,
 818098374,
 817956351,
 -1,
 -53052,
 818056535,
 10699,
 -53051,
 818117766,
 10701,
 -1,
 818160983,
 10698,
 -1,
 818022599,
 10141,
 -1,
 817990743,
 8227,
 818491595,
 815925885,
 -1,
 -53046,
 818437921,
 10971,
 -1,
 818487933,
 8482,
 -1,
 818449349,
 8872,
 818753755,
 815882511,
 -1,
 818819290,
 818702871,
 -1,
 818884818,
 818746152,
 -1,
 818950353,
 818811333,
 10554,
 -1,
 818874219,
 10557,
 -1,
 818880164,
 10556,
 819146965,
 818836539,
 -1,
 -53036,
 819099761,
 8974,
 -1,
 819160634,
 8989,
 819343576,
 819088815,
 -1,
 -53033,
 819296369,
 8975,
 -1,
 819357242,
 8988,
 -53031,
 819298388,
 9140,
 -1,
 819477081,
 8992,
 -1,
 818774835,
 9008,
 819736808,
 818713823,
 -1,
 819802343,
 819683601,
 -1,
 819867872,
 819745516,
 -1,
 -53025,
 819815819,
 10760,
 -1,
 819859591,
 10759,
 820064483,
 819807563,
 -1,
 -53022,
 820012319,
 10838,
 -1,
 820056094,
 10837,
 -53020,
 820005222,
 10697,
 -53019,
 820192643,
 8229,
 -53018,
 820256622,
 10869,
 -1,
 820319542,
 8273,
 -1,
 819735905,
 10041,
 820641791,
 819694324,
 -1,
 820654324,
 820541452,
 -1,
 820719854,
 820607786,
 -1,
 -53012,
 820681171,
 8516,
 -53011,
 820726605,
 8514,
 -1,
 820786583,
 8513,
 820982001,
 820644477,
 -1,
 -53008,
 820927688,
 10658,
 -1,
 820992486,
 8523,
 -53006,
 820928215,
 8985,
 -53005,
 821115062,
 8489,
 -1,
 821173261,
 8498,
 -1,
 820590798,
 8366,
 821441641,
 758872715,
 -1,
 821506587,
 821391150,
 -1,
 821572122,
 821457342,
 -1,
 821637647,
 821493760,
 -1,
 821702954,
 821581103,
 -1,
 821768451,
 821660406,
 -1,
 -52996,
 821728479,
 13244,
 -52995,
 821793146,
 13238,
 -52994,
 821852811,
 13234,
 -52993,
 821908783,
 13211,
 -52992,
 821971789,
 13205,
 -52991,
 822031767,
 13197,
 -52990,
 822096576,
 13196,
 -1,
 822151805,
 13186,
 822358282,
 821693053,
 13187,
 822423815,
 822296449,
 -1,
 -52986,
 822377009,
 13124,
 -1,
 822430500,
 13123,
 -52984,
 822377033,
 13126,
 -52983,
 822566711,
 13127,
 -1,
 822623297,
 13125,
 822817041,
 822280192,
 -1,
 822882575,
 822763791,
 -1,
 822948110,
 822841989,
 13223,
 -1,
 822871424,
 13224,
 -1,
 822885686,
 13249,
 -52976,
 822837347,
 13217,
 -1,
 823075039,
 13221,
 823275798,
 822755201,
 -1,
 823341332,
 823227235,
 13129,
 -1,
 823269036,
 13130,
 -52971,
 823282509,
 13269,
 -1,
 823413545,
 13128,
 823603482,
 823219503,
 13212,
 823721983,
 823525376,
 -1,
 -52967,
 823623779,
 13215,
 -1,
 823664863,
 13219,
 823865630,
 823535895,
 -1,
 823931165,
 823801244,
 13131,
 -1,
 823887775,
 13132,
 -1,
 823865746,
 13133,
 824127776,
 823825631,
 13245,
 -1,
 824050591,
 13247,
 824258850,
 824086906,
 13239,
 -1,
 824181663,
 13241,
 824389924,
 824186531,
 13190,
 -1,
 824313183,
 13268,
 -52955,
 824343179,
 13235,
 -52954,
 824470074,
 13227,
 -52953,
 824533650,
 13270,
 -52952,
 824593229,
 13206,
 -52951,
 824655742,
 13202,
 -1,
 824718743,
 13198,
 824914253,
 821643683,
 -1,
 824979761,
 824857903,
 13214,
 825098239,
 824901632,
 -1,
 825110832,
 824974154,
 -1,
 -52945,
 825068321,
 13222,
 -1,
 825102889,
 13262,
 -1,
 825065571,
 13218,
 825372981,
 824919850,
 13076,
 -52941,
 825333149,
 13079,
 -52940,
 825382779,
 13078,
 -1,
 825440544,
 13077,
 825635130,
 825297533,
 13188,
 825700665,
 825585777,
 -1,
 -52936,
 825648603,
 13069,
 -1,
 825693682,
 13068,
 -1,
 825640725,
 13067,
 825962813,
 825593870,
 -1,
 -52932,
 825921895,
 13082,
 -1,
 825975936,
 13083,
 826159424,
 825909519,
 -1,
 -52929,
 826112600,
 13085,
 -1,
 826172685,
 13086,
 -52927,
 826121116,
 13074,
 -52926,
 826315999,
 13246,
 -52925,
 826380666,
 13240,
 -52924,
 826442380,
 13263,
 -52923,
 826501690,
 13226,
 -52922,
 826559309,
 13208,
 -52921,
 826624419,
 13261,
 -52920,
 826687358,
 13201,
 -52919,
 826750359,
 13199,
 -52918,
 826813202,
 13084,
 -52917,
 826874757,
 13193,
 -52916,
 826939043,
 13189,
 -1,
 826999788,
 13248,
 827208042,
 824863253,
 -1,
 827273556,
 827140375,
 -1,
 827339090,
 827218594,
 -1,
 -52911,
 827294114,
 13114,
 -1,
 827343516,
 13112,
 -52909,
 827293628,
 13111,
 -1,
 827470519,
 13115,
 827666777,
 827198077,
 13225,
 827732312,
 827591293,
 -1,
 -52905,
 827689413,
 13100,
 -1,
 827751532,
 13099,
 -1,
 827654227,
 13184,
 827994462,
 827604865,
 -1,
 828059997,
 827935139,
 -1,
 -52900,
 828018818,
 13103,
 -1,
 828072207,
 13104,
 -1,
 827987314,
 13102,
 828322145,
 827941135,
 -1,
 -52896,
 828267578,
 13120,
 -1,
 828327331,
 13117,
 -52894,
 828282079,
 13242,
 -52893,
 828477818,
 13236,
 -52892,
 828537483,
 13232,
 -52891,
 828600433,
 13274,
 -52890,
 828665174,
 13273,
 -52889,
 828724527,
 13272,
 -52888,
 828782920,
 13271,
 -52887,
 828846784,
 13194,
 -1,
 828906314,
 13174,
 829108604,
 827167967,
 -1,
 829174138,
 829048786,
 -1,
 829239665,
 829132523,
 -1,
 829305200,
 829181305,
 -1,
 -52881,
 829261671,
 9639,
 -1,
 829301648,
 9705,
 -1,
 829257039,
 9640,
 829567348,
 829180749,
 -1,
 -52877,
 829516188,
 9706,
 -1,
 829565779,
 9703,
 -52875,
 829526880,
 9637,
 -52874,
 829715588,
 9704,
 -52873,
 829777517,
 9638,
 -52872,
 829832684,
 9636,
 -52871,
 829891447,
 9641,
 -1,
 829956048,
 10720,
 -52869,
 829101731,
 13277,
 -1,
 830084594,
 13143,
 830288270,
 829045064,
 -1,
 830353793,
 830245620,
 -1,
 -52865,
 830304538,
 13109,
 -52864,
 830358182,
 13107,
 -1,
 830411499,
 13106,
 830615942,
 830300431,
 -1,
 830681477,
 830562575,
 -1,
 -52860,
 830634545,
 13121,
 -1,
 830692002,
 13122,
 -1,
 830626466,
 13119,
 830943624,
 830564885,
 13259,
 -1,
 830868093,
 13169,
 831074699,
 830875927,
 -1,
 -52854,
 831027823,
 13113,
 -1,
 831081269,
 13110,
 831271309,
 830999165,
 13258,
 -1,
 831211561,
 13098,
 -1,
 831232974,
 13200,
 831467933,
 830238833,
 -1,
 831533459,
 831405953,
 -1,
 -52847,
 831490495,
 13137,
 -52846,
 831549589,
 13138,
 -1,
 831600273,
 10958,
 831795606,
 831458364,
 13229,
 831913983,
 831718554,
 13230,
 -1,
 831784320,
 13231,
 831992217,
 831752948,
 -1,
 -52840,
 831949733,
 13140,
 -1,
 832007366,
 13139,
 832188828,
 831924503,
 -1,
 -52837,
 832135137,
 13142,
 -1,
 832199187,
 13141,
 -1,
 832136330,
 8730,
 832450987,
 831403415,
 -1,
 832516514,
 832388993,
 -1,
 -52832,
 832469556,
 13075,
 -52831,
 832527680,
 13073,
 -1,
 832583068,
 13072,
 832778660,
 832475161,
 13080,
 -1,
 832735135,
 13081,
 832909735,
 832703101,
 -1,
 -52826,
 832862279,
 13070,
 -1,
 832921052,
 13071,
 -52824,
 832870867,
 13257,
 -52823,
 833055290,
 13228,
 -52822,
 833109886,
 13203,
 -1,
 833164963,
 13191,
 833368505,
 832379722,
 -1,
 833434032,
 833312047,
 13213,
 833552383,
 833355776,
 -1,
 -52817,
 833454179,
 13216,
 -1,
 833495263,
 13220,
 833696178,
 833380623,
 13255,
 -1,
 833648984,
 13183,
 833827253,
 833620605,
 -1,
 -52812,
 833776149,
 8851,
 -1,
 833833805,
 13192,
 -52810,
 833785298,
 8852,
 -52809,
 833954178,
 13253,
 -52808,
 834018122,
 13252,
 -1,
 834077811,
 13254,
 834286018,
 833313442,
 -1,
 834351548,
 834210429,
 13185,
 -1,
 834297328,
 13096,
 -52803,
 834311391,
 13243,
 -52802,
 834441594,
 13237,
 -52801,
 834501259,
 13233,
 -52800,
 834561922,
 13097,
 -52799,
 834622767,
 13210,
 -1,
 834679488,
 13195,
 834875852,
 834239115,
 -1,
 834941382,
 834809494,
 -1,
 -52795,
 834887951,
 13091,
 -1,
 834944897,
 13090,
 835137993,
 834865789,
 -1,
 -52792,
 835084223,
 13088,
 -1,
 835142353,
 13087,
 -52790,
 835096954,
 13276,
 -52789,
 835285105,
 13275,
 -1,
 835340057,
 13089,
 835531221,
 834803363,
 -1,
 835596752,
 835455613,
 -1,
 -52785,
 835547249,
 13172,
 -1,
 835588984,
 13101,
 -52783,
 835555533,
 13108,
 -52782,
 835743434,
 13251,
 -52781,
 835806894,
 13118,
 -52780,
 835864413,
 13105,
 -1,
 835922711,
 13116,
 836121053,
 835477775,
 -1,
 836186586,
 836073128,
 8848,
 836304895,
 836109346,
 -1,
 -52775,
 836198067,
 8933,
 -1,
 836251493,
 8850,
 -52773,
 836145530,
 13173,
 -52772,
 836395848,
 13066,
 -1,
 836460310,
 13065,
 836645349,
 836062029,
 -1,
 836710881,
 836591887,
 -1,
 -52768,
 836672532,
 8977,
 -1,
 836711831,
 13266,
 -52766,
 836671781,
 13267,
 -52765,
 836852386,
 13265,
 -52764,
 836916527,
 13264,
 -1,
 836971371,
 10957,
 837169645,
 836583297,
 -1,
 837235177,
 837114530,
 13260,
 -52760,
 837191237,
 13061,
 -1,
 837240001,
 13060,
 837484543,
 837178741,
 8847,
 837550079,
 837354530,
 -1,
 -52756,
 837443251,
 8932,
 -1,
 837496677,
 8849,
 837693941,
 837101847,
 -1,
 837759475,
 837644440,
 -1,
 -52752,
 837714711,
 13181,
 -52751,
 837780101,
 13180,
 -52750,
 837834632,
 13182,
 -1,
 837893136,
 13179,
 -52748,
 837714376,
 13063,
 -1,
 838020361,
 13064,
 838218236,
 837624194,
 -1,
 838283768,
 838142589,
 13170,
 -1,
 838210918,
 13092,
 -52743,
 838231722,
 13094,
 -52742,
 838355789,
 13207,
 -52741,
 838414487,
 13093,
 -1,
 838473379,
 13256,
 838676995,
 838142589,
 -1,
 -52738,
 838634228,
 13171,
 -52737,
 838695486,
 13057,
 -52736,
 838756935,
 13056,
 -52735,
 838819601,
 13058,
 -52734,
 838882607,
 13250,
 -1,
 838931593,
 13059,
 839135752,
 838638035,
 -1,
 839201287,
 839060114,
 -1,
 -52730,
 839154225,
 13135,
 -1,
 839197937,
 13134,
 -1,
 839158545,
 13136,
 839463435,
 839090828,
 -1,
 -52726,
 839410508,
 13095,
 -1,
 839466878,
 13204,
 839660046,
 839398080,
 -1,
 -52723,
 839607434,
 9165,
 -1,
 839669039,
 13209,
 -1,
 839617994,
 13062,
 839974911,
 821567876,
 -1,
 839987731,
 839875211,
 -1,
 -52718,
 839937929,
 10696,
 -1,
 839996930,
 10695,
 -52716,
 839943867,
 8864,
 -52715,
 840136534,
 10692,
 -52714,
 840199454,
 8862,
 -52713,
 840259815,
 8863,
 -52712,
 840315665,
 10693,
 -52711,
 840377742,
 8865,
 -1,
 840439085,
 10694,
 -1,
 821527201,
 10151,
 840708789,
 821467603,
 -1,
 840774269,
 840659814,
 -1,
 840839743,
 840716356,
 -1,
 840905251,
 840792715,
 -1,
 -52704,
 840863416,
 1809,
 -52703,
 840907995,
 1835,
 -52702,
 840969705,
 1827,
 -1,
 841026649,
 1832,
 841232935,
 840860300,
 -1,
 841298470,
 841167238,
 1819,
 -1,
 841220807,
 1820,
 -1,
 841225820,
 1836,
 841495081,
 841194391,
 1821,
 -1,
 841417438,
 1822,
 841626156,
 841445489,
 -1,
 -52693,
 841566061,
 1834,
 -1,
 841626188,
 1831,
 841822766,
 841562931,
 1815,
 -1,
 841778441,
 1818,
 841953840,
 841758134,
 1811,
 -1,
 841876167,
 1812,
 842084915,
 841884034,
 -1,
 -52686,
 842033000,
 1814,
 -1,
 842075649,
 1813,
 -52684,
 842046444,
 1817,
 -52683,
 842241499,
 1816,
 -52682,
 842297096,
 1833,
 -52681,
 842361658,
 1830,
 -52680,
 842424436,
 1826,
 -52679,
 842488003,
 1825,
 -52678,
 842550328,
 1824,
 -52677,
 842615261,
 1823,
 -52676,
 842675205,
 1828,
 -52675,
 842737943,
 1829,
 -52674,
 842799285,
 1810,
 -1,
 842862039,
 1808,
 843067978,
 840776008,
 -1,
 843133509,
 842995575,
 -1,
 843199044,
 843055104,
 -1,
 -52669,
 843126769,
 1851,
 -1,
 843188952,
 1850,
 -1,
 843122792,
 1852,
 843461193,
 843060171,
 -1,
 -52665,
 843407722,
 1803,
 -52664,
 843470824,
 1804,
 -1,
 843519266,
 1805,
 -1,
 843408909,
 1797,
 843788883,
 843022754,
 -1,
 843854415,
 843738630,
 -1,
 843919950,
 843783919,
 1795,
 -1,
 843842876,
 1800,
 -1,
 843855226,
 1793,
 844169215,
 843782545,
 -1,
 844182098,
 844046063,
 1796,
 -1,
 844105033,
 1801,
 -1,
 844117370,
 1794,
 844378714,
 843743884,
 -1,
 844444247,
 844339421,
 -1,
 -52650,
 844371953,
 1860,
 -1,
 844434136,
 1859,
 844693503,
 844381882,
 -1,
 -52647,
 844568561,
 1862,
 -1,
 844630744,
 1861,
 844837472,
 844329073,
 -1,
 844903006,
 844765052,
 -1,
 -52643,
 844830705,
 1847,
 -1,
 844892888,
 1846,
 -52641,
 844862723,
 1855,
 -1,
 845057091,
 1858,
 845230692,
 844799087,
 -1,
 -52638,
 845161910,
 1845,
 -52637,
 845223921,
 1844,
 -1,
 845286104,
 1843,
 845492840,
 845180574,
 -1,
 -52634,
 845424054,
 1842,
 -52633,
 845486065,
 1841,
 -1,
 845548248,
 1840,
 845754989,
 845424919,
 -1,
 845820524,
 845708109,
 -1,
 -52629,
 845748209,
 1854,
 -1,
 845810392,
 1853,
 -1,
 845765591,
 1792,
 846082674,
 845684460,
 -1,
 846148209,
 846025488,
 -1,
 -52624,
 846099411,
 1799,
 -1,
 846155124,
 1798,
 -1,
 846094312,
 1802,
 846410357,
 846029169,
 -1,
 -52620,
 846338033,
 1864,
 -1,
 846400216,
 1863,
 846606968,
 846341565,
 -1,
 -52617,
 846544283,
 1848,
 -1,
 846598465,
 1849,
 -52615,
 846557287,
 1857,
 -52614,
 846748275,
 1865,
 -52613,
 846803855,
 1856,
 -52612,
 846862191,
 1866,
 -1,
 846924462,
 1807,
 847183871,
 840717615,
 -1,
 847196852,
 847059390,
 -1,
 847262346,
 847149707,
 -1,
 847327874,
 847219603,
 9242,
 -1,
 847250077,
 9254,
 847458949,
 847283040,
 -1,
 -52604,
 847414532,
 9218,
 -1,
 847461186,
 9217,
 847655560,
 847395976,
 -1,
 -52601,
 847603804,
 9230,
 -1,
 847659987,
 9231,
 -52599,
 847616807,
 9238,
 -1,
 847800909,
 9248,
 847983253,
 847192450,
 -1,
 848048788,
 847915287,
 -1,
 848114322,
 848008178,
 -1,
 848179856,
 848069260,
 -1,
 -52593,
 848140441,
 9234,
 -1,
 848182947,
 9235,
 -52591,
 848126906,
 9233,
 -1,
 848311526,
 9236,
 848560127,
 848056383,
 9249,
 -1,
 848429725,
 9253,
 -1,
 847975809,
 9232,
 848704159,
 847915287,
 -1,
 848769694,
 848648866,
 -1,
 848835229,
 848699797,
 -1,
 848900764,
 848790156,
 -1,
 848966299,
 848851256,
 9220,
 -1,
 848888257,
 9239,
 -1,
 848900741,
 9219,
 -1,
 848844593,
 9241,
 -1,
 848785455,
 9221,
 -1,
 848722820,
 9243,
 849359524,
 848648866,
 -1,
 849425059,
 849291543,
 -1,
 -52574,
 849385567,
 9252,
 -1,
 849425900,
 9237,
 -1,
 849382539,
 9216,
 849687207,
 849294016,
 -1,
 -52570,
 849634845,
 9228,
 -1,
 849691387,
 9244,
 849883818,
 849615746,
 -1,
 -52567,
 849836432,
 9229,
 -1,
 849894283,
 9240,
 850080429,
 849811107,
 -1,
 -52564,
 850013495,
 9223,
 -1,
 850070524,
 9224,
 -52562,
 850039763,
 9227,
 -52561,
 850234784,
 9247,
 -52560,
 850293185,
 9246,
 -52559,
 850350432,
 9226,
 -52558,
 850411074,
 9225,
 -52557,
 850475224,
 9245,
 -1,
 850529264,
 9222,
 -1,
 847140857,
 9007,
 850801470,
 840646529,
 -1,
 850866992,
 850746018,
 -1,
 850932521,
 850803229,
 -1,
 850998026,
 850874436,
 -1,
 851063503,
 850922109,
 -1,
 851129031,
 851006583,
 -1,
 851194558,
 851083916,
 -1,
 -52547,
 851149708,
 3495,
 -1,
 851187328,
 3501,
 851391169,
 851124610,
 -1,
 -52544,
 851321458,
 3497,
 -1,
 851383936,
 3503,
 -52542,
 851340082,
 3508,
 -52541,
 851528239,
 3482,
 -52540,
 851593425,
 3490,
 -52539,
 851654147,
 3484,
 -52538,
 851713138,
 3488,
 -1,
 851777416,
 3510,
 851981002,
 851061015,
 -1,
 -52535,
 851941891,
 3463,
 -1,
 851980954,
 3464,
 -52533,
 851941891,
 3461,
 -52532,
 852136288,
 3478,
 -52531,
 852186844,
 3513,
 -52530,
 852248736,
 3475,
 -1,
 852301440,
 3462,
 852505315,
 851006767,
 -1,
 852570847,
 852429437,
 -1,
 852636382,
 852506991,
 -1,
 852701909,
 852591244,
 -1,
 -52524,
 852657036,
 3496,
 -1,
 852694656,
 3502,
 852898520,
 852631938,
 -1,
 -52521,
 852828786,
 3498,
 -1,
 852891264,
 3504,
 -52519,
 852847410,
 3509,
 -52518,
 853035567,
 3483,
 -52517,
 853100753,
 3491,
 -52516,
 853161475,
 3485,
 -52515,
 853220466,
 3489,
 -1,
 853284744,
 3511,
 -1,
 852597251,
 3512,
 853606399,
 852529494,
 -1,
 -52511,
 853506905,
 3522,
 -52510,
 853564282,
 3499,
 -1,
 853626158,
 3525,
 853816044,
 852443009,
 -1,
 853881575,
 853768753,
 -1,
 -52506,
 853842435,
 3469,
 -1,
 853905760,
 3470,
 854078186,
 853824685,
 -1,
 -52503,
 854039043,
 3471,
 -1,
 854102368,
 3472,
 -52501,
 854039043,
 3465,
 -1,
 854214816,
 3466,
 854405874,
 853769022,
 -1,
 854471408,
 854335874,
 -1,
 -52497,
 854401650,
 3500,
 -1,
 854464128,
 3507,
 -52495,
 854411473,
 3494,
 -1,
 854603267,
 3487,
 854799095,
 854360807,
 -1,
 854864630,
 854751946,
 -1,
 -52491,
 854825475,
 3521,
 -1,
 854876412,
 3493,
 -1,
 854809317,
 3492,
 855126779,
 854729237,
 -1,
 -52487,
 855079769,
 3523,
 -52486,
 855137146,
 3505,
 -1,
 855199022,
 3517,
 855388926,
 855083764,
 -1,
 -52483,
 855349763,
 3467,
 -1,
 855413088,
 3468,
 855585537,
 855335183,
 -1,
 -52480,
 855546371,
 3476,
 -1,
 855599630,
 3477,
 855782148,
 855517463,
 -1,
 -52477,
 855742979,
 3473,
 -1,
 855782042,
 3474,
 -52475,
 855742995,
 3514,
 -52474,
 855937522,
 3520,
 -52473,
 855994716,
 3515,
 -52472,
 856050122,
 3486,
 -52471,
 856111915,
 3524,
 -1,
 856175420,
 3526,
 856372003,
 850957505,
 -1,
 856437527,
 856312227,
 -1,
 856503059,
 856384263,
 -1,
 856568594,
 856461692,
 3545,
 856686591,
 856490705,
 -1,
 -52464,
 856569355,
 3550,
 -52463,
 856630270,
 3549,
 -1,
 856689815,
 3548,
 -1,
 856490502,
 3547,
 857014271,
 856437172,
 -1,
 -52459,
 856910397,
 3540,
 -52458,
 856967012,
 3538,
 -1,
 857017484,
 3536,
 857223967,
 856368120,
 -1,
 857289499,
 857159068,
 -1,
 -52454,
 857250313,
 3571,
 -1,
 857289122,
 3570,
 -52452,
 857238077,
 3542,
 -52451,
 857426620,
 3546,
 -52450,
 857491300,
 3539,
 -1,
 857541772,
 3537,
 857748258,
 857159068,
 -1,
 -52447,
 857709065,
 3551,
 -1,
 857747874,
 3544,
 -1,
 857672855,
 3535,
 858010408,
 856325676,
 -1,
 858075943,
 857934461,
 -1,
 -52442,
 858022037,
 3458,
 -1,
 858082165,
 3530,
 -1,
 858035278,
 3459,
 -1,
 857960108,
 3572,
 858403631,
 850867990,
 -1,
 858469165,
 858344269,
 -1,
 -52436,
 858417489,
 8218,
 -1,
 858467253,
 8249,
 -52434,
 858420653,
 8250,
 -1,
 858602668,
 8219,
 -1,
 858335557,
 8767,
 858862392,
 850811043,
 -1,
 858927924,
 858809634,
 -1,
 -52429,
 858869703,
 10909,
 -1,
 858929140,
 10910,
 859124535,
 858852062,
 -1,
 -52426,
 859066355,
 10911,
 -1,
 859125798,
 10912,
 -1,
 859068664,
 10860,
 859439103,
 858822949,
 -1,
 859452220,
 859309256,
 -1,
 -52421,
 859398752,
 10038,
 -1,
 859451685,
 10046,
 -52419,
 859407344,
 10042,
 -1,
 859572586,
 8198,
 859780014,
 850758388,
 -1,
 859845487,
 859728927,
 -1,
 859911000,
 859775056,
 -1,
 859976518,
 859851597,
 -1,
 860042053,
 859903432,
 -1,
 -52412,
 859986594,
 8319,
 -1,
 860045185,
 8305,
 -1,
 859974529,
 8317,
 860304201,
 859931276,
 -1,
 -52408,
 860264601,
 178,
 -1,
 860307107,
 179,
 860500812,
 860256907,
 -1,
 -52405,
 860440721,
 8310,
 -1,
 860500431,
 8311,
 860697423,
 860435136,
 -1,
 -52402,
 860645373,
 8308,
 -1,
 860702786,
 8309,
 860894034,
 860629271,
 -1,
 -52399,
 860843885,
 8316,
 -1,
 860897794,
 8312,
 -52397,
 860855326,
 8304,
 -52396,
 861041885,
 8318,
 -52395,
 861105468,
 8314,
 -52394,
 861168570,
 185,
 -52393,
 861232460,
 8313,
 -1,
 861296871,
 8315,
 861536255,
 859844879,
 -1,
 861549411,
 861430216,
 8835,
 861667327,
 861470720,
 -1,
 861680480,
 861539038,
 -1,
 -52387,
 861636268,
 10952,
 -52386,
 861691571,
 10956,
 -52385,
 861745073,
 10950,
 -1,
 861802279,
 10954,
 862008162,
 861627702,
 8839,
 -1,
 861931221,
 10948,
 -1,
 861968320,
 8843,
 862204775,
 861509329,
 -1,
 -52379,
 862154054,
 10944,
 -52378,
 862214728,
 10946,
 -1,
 862266702,
 10942,
 862466924,
 862128862,
 -1,
 862532459,
 862421410,
 -1,
 -52374,
 862481452,
 10966,
 -1,
 862526123,
 10964,
 -1,
 862473982,
 10619,
 862846975,
 862394426,
 -1,
 -52370,
 862749093,
 10967,
 -1,
 862785598,
 10968,
 862991256,
 859773608,
 -1,
 863056772,
 862920784,
 -1,
 863122292,
 863011468,
 -1,
 -52365,
 863082649,
 8322,
 -1,
 863125155,
 8323,
 863318903,
 863074955,
 -1,
 -52362,
 863258769,
 8326,
 -1,
 863318479,
 8327,
 863515514,
 863253184,
 -1,
 -52359,
 863463421,
 8324,
 -1,
 863520834,
 8325,
 863712125,
 863447319,
 -1,
 -52356,
 863661933,
 8332,
 -1,
 863715842,
 8328,
 -52354,
 863673374,
 8320,
 -52353,
 863859933,
 8334,
 -52352,
 863923516,
 8330,
 -52351,
 863986618,
 8321,
 -52350,
 864050508,
 8329,
 -52349,
 864114919,
 8331,
 -1,
 864177711,
 8333,
 864419839,
 862990607,
 -1,
 864433039,
 864313800,
 8834,
 864550911,
 864354304,
 -1,
 864564108,
 864422622,
 -1,
 -52343,
 864519852,
 10951,
 -52342,
 864575155,
 10955,
 -52341,
 864628657,
 10949,
 -1,
 864685863,
 10953,
 864891790,
 864511286,
 8838,
 -1,
 864814805,
 10947,
 -1,
 864851904,
 8842,
 865088403,
 864392913,
 -1,
 -52335,
 865037638,
 10943,
 -52334,
 865098312,
 10945,
 -1,
 865150286,
 10941,
 865402879,
 865012446,
 -1,
 865416087,
 865304994,
 -1,
 -52330,
 865365036,
 10963,
 -1,
 865409707,
 10965,
 -1,
 865367516,
 10617,
 865678248,
 862919802,
 8827,
 865796095,
 865599488,
 -1,
 865809315,
 865667806,
 -1,
 865874846,
 865762987,
 -1,
 -52323,
 865820339,
 10930,
 -1,
 865873841,
 10928,
 866071457,
 865820308,
 -1,
 -52320,
 866004837,
 10934,
 -1,
 866062119,
 10938,
 -52318,
 866004913,
 10932,
 -1,
 866193191,
 10936,
 866399142,
 865756454,
 -1,
 -52315,
 866338865,
 8831,
 -1,
 866389409,
 8829,
 -52313,
 866356552,
 8881,
 -1,
 866523914,
 8937,
 866726828,
 865622299,
 -1,
 -52310,
 866686864,
 10763,
 -52309,
 866748368,
 9138,
 -1,
 866785746,
 9139,
 -52307,
 866677546,
 8751,
 -1,
 866933410,
 9737,
 867120124,
 859723055,
 -1,
 867185659,
 867043965,
 -1,
 867251194,
 867127845,
 -1,
 867316728,
 867172352,
 -1,
 867382224,
 867266673,
 -1,
 867447755,
 867328761,
 -1,
 867513274,
 867402380,
 -1,
 867578808,
 867472607,
 -1,
 -52297,
 867524879,
 8561,
 -1,
 867577180,
 8571,
 -52295,
 867516067,
 8562,
 -1,
 867708424,
 8569,
 867906496,
 867447488,
 -1,
 867972031,
 867843969,
 -1,
 868037566,
 867930618,
 8564,
 -1,
 867959536,
 8574,
 -1,
 867972470,
 8572,
 -1,
 867919869,
 8563,
 868299716,
 867853242,
 8560,
 868417535,
 868220928,
 -1,
 -52285,
 868320689,
 8575,
 -1,
 868368154,
 8573,
 868561863,
 868252299,
 -1,
 -52282,
 868501649,
 8565,
 -1,
 868561359,
 8566,
 868758474,
 868493591,
 -1,
 -52279,
 868700284,
 8570,
 -1,
 868762114,
 8567,
 -1,
 868703564,
 8568,
 869020623,
 867385863,
 -1,
 -52275,
 868976687,
 65118,
 -52274,
 869034697,
 65114,
 -1,
 869081342,
 65116,
 -1,
 868954615,
 65128,
 869348312,
 867313943,
 -1,
 869413845,
 869289885,
 8714,
 869531647,
 869336575,
 -1,
 -52268,
 869438221,
 8948,
 -1,
 869492984,
 8951,
 -52266,
 869374291,
 65111,
 -52265,
 869625709,
 65126,
 -1,
 869684529,
 65112,
 869872610,
 869277420,
 -1,
 869938142,
 869818235,
 -1,
 870003677,
 869897937,
 -1,
 -52260,
 869962509,
 8956,
 -1,
 870017272,
 8958,
 -1,
 869930153,
 8717,
 870265825,
 869882132,
 -1,
 -52256,
 870199264,
 65131,
 -1,
 870255229,
 65104,
 -1,
 870208268,
 65109,
 870527976,
 869813597,
 -1,
 870593511,
 870462774,
 -1,
 -52251,
 870549551,
 65117,
 -52250,
 870607561,
 65113,
 -1,
 870654206,
 65115,
 -1,
 870547598,
 65124,
 870921195,
 870476309,
 -1,
 -52246,
 870864083,
 65122,
 -1,
 870920140,
 65130,
 871117806,
 870845053,
 -1,
 -52243,
 871072030,
 65121,
 -1,
 871127526,
 65120,
 -52241,
 871076421,
 10849,
 -52240,
 871270031,
 732,
 -52239,
 871332946,
 65108,
 -52238,
 871395335,
 65110,
 -52237,
 871456802,
 65119,
 -52236,
 871514381,
 65105,
 -52235,
 871579505,
 65123,
 -52234,
 871643271,
 65125,
 -52233,
 871708026,
 65106,
 -1,
 871769371,
 65129,
 872022015,
 867250116,
 10922,
 -1,
 871892044,
 10924,
 -1,
 867204327,
 10803,
 -1,
 867123959,
 8995,
 872231955,
 867066127,
 -1,
 872297486,
 872188660,
 -1,
 872363021,
 872252684,
 -1,
 872428551,
 872294818,
 -1,
 872494086,
 872354831,
 8600,
 872611839,
 872415232,
 -1,
 -52221,
 872519535,
 10533,
 -52220,
 872580957,
 8690,
 -52219,
 872620181,
 10541,
 -1,
 872681657,
 10537,
 -1,
 872424994,
 8664,
 873005055,
 872388111,
 -1,
 873018380,
 872879119,
 8601,
 873136127,
 872939520,
 -1,
 -52213,
 873043823,
 10534,
 -1,
 873074802,
 10538,
 -1,
 872949282,
 8665,
 -1,
 872307687,
 8471,
 873411600,
 872239317,
 47,
 -1,
 873334621,
 10742,
 873594879,
 873346355,
 -1,
 -52206,
 873502056,
 9108,
 -1,
 873530129,
 173,
 873739303,
 872160074,
 -1,
 873804838,
 873689201,
 -1,
 873870373,
 873744003,
 -1,
 873935904,
 873798650,
 -1,
 -52200,
 873885809,
 8475,
 -52199,
 873949717,
 8472,
 -52198,
 874009903,
 8499,
 -52197,
 874072909,
 8466,
 -52196,
 874135425,
 8464,
 -52195,
 874199368,
 8459,
 -52194,
 874263232,
 8497,
 -52193,
 874326295,
 8496,
 -1,
 874387107,
 8492,
 874643455,
 873889604,
 -1,
 -52190,
 874537231,
 8500,
 -52189,
 874597197,
 8467,
 -52188,
 874657175,
 8458,
 -1,
 874719511,
 8495,
 -1,
 873828064,
 8456,
 -1,
 873752149,
 9807,
 875050040,
 873675080,
 -1,
 875115571,
 874995983,
 -1,
 875181106,
 875067917,
 -1,
 875246638,
 875138705,
 10976,
 875364351,
 875167744,
 -1,
 -52179,
 875272215,
 10984,
 -1,
 875301760,
 10985,
 875508784,
 875177984,
 10975,
 -1,
 875431773,
 10983,
 -52175,
 875460077,
 10564,
 -1,
 875581044,
 10974,
 -1,
 875138147,
 9085,
 875836471,
 875039870,
 -1,
 -52171,
 875790601,
 10032,
 -52170,
 875842814,
 10014,
 -1,
 875896255,
 10061,
 -1,
 875793356,
 10722,
 876164163,
 874981655,
 -1,
 876229692,
 876107798,
 -1,
 -52165,
 876160105,
 10802,
 -1,
 876224239,
 59,
 876426303,
 876159151,
 -1,
 -52162,
 876373279,
 8980,
 -1,
 876430909,
 167,
 -52160,
 876380858,
 8726,
 -52159,
 876575473,
 65093,
 -52158,
 876640884,
 8480,
 -1,
 876689229,
 8979,
 876885070,
 876104525,
 -1,
 876950601,
 876810664,
 -1,
 877016135,
 876892103,
 10901,
 -1,
 876938981,
 10903,
 877199359,
 876951540,
 10902,
 -1,
 877070053,
 10904,
 877330431,
 876897427,
 -1,
 877343821,
 877216893,
 -1,
 -52148,
 877290783,
 10839,
 -1,
 877334558,
 10840,
 -1,
 877275415,
 9011,
 877605976,
 876839564,
 -1,
 877671509,
 877531809,
 -1,
 877737043,
 877617423,
 -1,
 -52142,
 877685711,
 8902,
 -1,
 877736649,
 10017,
 -52140,
 877670314,
 8795,
 -1,
 877858865,
 9770,
 878116863,
 877621361,
 -1,
 -52137,
 878002285,
 8803,
 -1,
 878063803,
 10025,
 878261344,
 877554197,
 -1,
 878326877,
 878197788,
 8738,
 878444543,
 878248958,
 -1,
 -52132,
 878349778,
 10657,
 -1,
 878398836,
 10656,
 878641151,
 878250621,
 -1,
 -52129,
 878540722,
 10055,
 -1,
 878582919,
 32,
 878785636,
 878185085,
 -1,
 -52126,
 878741966,
 9796,
 -52125,
 878793895,
 9747,
 -1,
 878851845,
 9808,
 879047783,
 878731021,
 -1,
 -52122,
 878990951,
 9731,
 -1,
 879047799,
 10052,
 -52120,
 878988036,
 9760,
 -1,
 879166253,
 10700,
 879376303,
 821376407,
 -1,
 879441480,
 879325297,
 -1,
 879507015,
 879372567,
 -1,
 879572509,
 879439100,
 -1,
 879637818,
 879525759,
 -1,
 879703193,
 879583990,
 -1,
 879768716,
 879635491,
 969,
 879886335,
 879691263,
 -1,
 879899773,
 879782421,
 -1,
 879965307,
 879853132,
 8032,
 880082943,
 879886425,
 -1,
 880096374,
 879989164,
 8034,
 -1,
 880017749,
 8098,
 880227448,
 880045075,
 8038,
 -1,
 880148821,
 8102,
 880358522,
 880175625,
 8036,
 -1,
 880279893,
 8100,
 -1,
 880319320,
 8096,
 880607231,
 879898615,
 8182,
 -1,
 880476501,
 8183,
 880686214,
 879829591,
 8033,
 880803839,
 880607321,
 -1,
 880817281,
 880710060,
 8035,
 -1,
 880738645,
 8099,
 880948355,
 880765971,
 8039,
 -1,
 880869717,
 8103,
 881079429,
 880896521,
 8037,
 -1,
 881000789,
 8101,
 -1,
 881040216,
 8097,
 881276040,
 880644524,
 8060,
 -1,
 881197397,
 8178,
 881407114,
 881224201,
 8061,
 -1,
 881328469,
 8180,
 -52085,
 881367896,
 8179,
 -1,
 881493958,
 974,
 881721343,
 879706215,
 959,
 881786879,
 881591807,
 -1,
 881800338,
 881684113,
 8000,
 881917951,
 881721433,
 -1,
 -52079,
 881824172,
 8002,
 -1,
 881879561,
 8004,
 882062486,
 881730135,
 8001,
 882180095,
 881983577,
 -1,
 -52075,
 882086316,
 8003,
 -1,
 882141705,
 8005,
 -52073,
 882020780,
 8056,
 -52072,
 882280390,
 972,
 -1,
 882338313,
 8057,
 882521284,
 879634711,
 -1,
 882586807,
 882475732,
 951,
 882704383,
 882509311,
 -1,
 882717864,
 882600469,
 -1,
 882783398,
 882671180,
 7968,
 882900991,
 882704473,
 -1,
 882914465,
 882807212,
 7970,
 -1,
 882835797,
 8082,
 883045539,
 882863123,
 7974,
 -1,
 882966869,
 8086,
 883176613,
 882993673,
 7972,
 -1,
 883097941,
 8084,
 -1,
 883137368,
 8080,
 883425279,
 882716663,
 8134,
 -1,
 883294549,
 8135,
 883504305,
 882647639,
 7969,
 883621887,
 883425369,
 -1,
 883635372,
 883528108,
 7971,
 -1,
 883556693,
 8083,
 883766446,
 883584019,
 7975,
 -1,
 883687765,
 8087,
 883897520,
 883714569,
 7973,
 -1,
 883818837,
 8085,
 -1,
 883858264,
 8081,
 884094131,
 883462572,
 8052,
 -1,
 884015445,
 8130,
 884225205,
 884042249,
 8053,
 -1,
 884146517,
 8132,
 -52042,
 884185944,
 8131,
 -1,
 884312006,
 942,
 884539391,
 882536087,
 949,
 884604927,
 884409855,
 -1,
 884618429,
 884502161,
 7952,
 884735999,
 884539481,
 -1,
 -52036,
 884642220,
 7954,
 -1,
 884697609,
 7956,
 884880577,
 884548183,
 7953,
 884998143,
 884801625,
 -1,
 -52032,
 884904364,
 7955,
 -1,
 884959753,
 7957,
 -52030,
 884838828,
 8050,
 -52029,
 885098438,
 941,
 -1,
 885156361,
 8051,
 885339366,
 882444925,
 -1,
 885404901,
 885281922,
 945,
 885522431,
 885327359,
 -1,
 885535955,
 885418517,
 -1,
 885601489,
 885489228,
 7936,
 885719039,
 885522521,
 -1,
 885732556,
 885625260,
 7938,
 -1,
 885653845,
 8066,
 885863630,
 885681171,
 7942,
 -1,
 885784917,
 8070,
 885994704,
 885811721,
 7940,
 -1,
 885915989,
 8068,
 -1,
 885955416,
 8064,
 886243327,
 885534711,
 8118,
 -1,
 886112597,
 8119,
 886322396,
 885465687,
 7937,
 886439935,
 886243417,
 -1,
 886453463,
 886346156,
 7939,
 -1,
 886374741,
 8067,
 886584537,
 886402067,
 7943,
 -1,
 886505813,
 8071,
 886715611,
 886532617,
 7941,
 -1,
 886636885,
 8069,
 -1,
 886676312,
 8065,
 886912224,
 886280570,
 -1,
 886977759,
 886838176,
 8048,
 -1,
 886899029,
 8114,
 -1,
 886927533,
 8112,
 887174370,
 886860297,
 8049,
 -1,
 887095637,
 8116,
 -51997,
 887135064,
 8115,
 -51996,
 887261126,
 940,
 -1,
 887313723,
 8113,
 -1,
 885354877,
 985,
 887567617,
 885297019,
 965,
 887685119,
 887490047,
 -1,
 887698676,
 887562626,
 -1,
 887764207,
 887635958,
 971,
 887881727,
 887685209,
 -1,
 -51988,
 887787948,
 8162,
 -51987,
 887850950,
 944,
 -51986,
 887909395,
 8167,
 -1,
 887974409,
 8163,
 888209407,
 887690500,
 8017,
 888274943,
 888078425,
 -1,
 -51982,
 888181164,
 8019,
 -51981,
 888237075,
 8023,
 -1,
 888302089,
 8021,
 888485115,
 887646741,
 -1,
 888550650,
 888438348,
 8016,
 888668159,
 888471641,
 -1,
 -51976,
 888574380,
 8018,
 -51975,
 888630291,
 8022,
 -1,
 888695305,
 8020,
 -1,
 888483831,
 8166,
 888943870,
 888443258,
 -1,
 -51971,
 888893613,
 8160,
 -1,
 888935328,
 8058,
 -51969,
 888899526,
 973,
 -51968,
 889088521,
 8059,
 -1,
 889148731,
 8161,
 889337116,
 887506518,
 953,
 889454591,
 889259519,
 -1,
 889468175,
 889332098,
 -1,
 889533706,
 889405430,
 970,
 889651199,
 889454681,
 -1,
 -51961,
 889557420,
 8146,
 -51960,
 889620422,
 912,
 -51959,
 889678867,
 8151,
 -1,
 889743881,
 8147,
 889978879,
 889459972,
 7985,
 890044415,
 889847897,
 -1,
 -51955,
 889950636,
 7987,
 -51954,
 890006547,
 7991,
 -1,
 890071561,
 7989,
 890254614,
 889416213,
 -1,
 890320149,
 890207820,
 7984,
 890437631,
 890241113,
 -1,
 -51949,
 890343852,
 7986,
 -51948,
 890399763,
 7990,
 -1,
 890464777,
 7988,
 -1,
 890253303,
 8150,
 890713369,
 890212730,
 -1,
 -51944,
 890663085,
 8144,
 -1,
 890704800,
 8054,
 -51942,
 890668998,
 943,
 -51941,
 890857993,
 8055,
 -1,
 890918203,
 8145,
 891106592,
 889289355,
 -1,
 -51938,
 891061878,
 987,
 -51937,
 891110015,
 963,
 -1,
 891162608,
 993,
 891368740,
 891056980,
 961,
 891486207,
 891291135,
 -1,
 -51933,
 891383441,
 8164,
 -1,
 891429463,
 8165,
 891630888,
 891316757,
 -1,
 -51930,
 891583961,
 968,
 -51929,
 891633537,
 960,
 -1,
 891698245,
 966,
 891893035,
 891585164,
 -1,
 -51926,
 891829296,
 952,
 -1,
 891885055,
 964,
 892089646,
 891832739,
 -1,
 -51923,
 892036369,
 991,
 -1,
 892080760,
 954,
 892286257,
 892019074,
 -1,
 -51920,
 892223919,
 989,
 -1,
 892284247,
 948,
 -51918,
 892247075,
 950,
 -51917,
 892443016,
 958,
 -51916,
 892493828,
 957,
 -51915,
 892557843,
 956,
 -51914,
 892619849,
 955,
 -51913,
 892679612,
 947,
 -51912,
 892744723,
 962,
 -51911,
 892804434,
 967,
 -1,
 892868765,
 946,
 893072868,
 879565818,
 -1,
 893138403,
 893014084,
 -1,
 893203813,
 893084406,
 -1,
 893269336,
 893135907,
 937,
 893386751,
 893191679,
 -1,
 893400395,
 893282837,
 -1,
 893465930,
 893353548,
 8040,
 893583359,
 893386841,
 -1,
 893596998,
 893479445,
 -1,
 893662533,
 893530103,
 8046,
 -1,
 893583596,
 8110,
 -1,
 893614209,
 8104,
 893859144,
 893555116,
 8042,
 -1,
 893780204,
 8106,
 894042111,
 893807113,
 8044,
 -1,
 893911276,
 8108,
 -1,
 893417601,
 8188,
 894186837,
 893330007,
 8041,
 894304255,
 894107737,
 -1,
 894317905,
 894200341,
 -1,
 894383440,
 894250999,
 8047,
 -1,
 894304492,
 8111,
 -1,
 894335105,
 8105,
 894580051,
 894276012,
 8043,
 -1,
 894501100,
 8107,
 894763007,
 894528009,
 8045,
 -1,
 894632172,
 8109,
 -51882,
 894144940,
 8186,
 -51881,
 894797766,
 911,
 -1,
 894855689,
 8187,
 895090687,
 893206631,
 927,
 895156223,
 894961151,
 -1,
 895169886,
 895053457,
 8008,
 895287295,
 895090777,
 -1,
 -51875,
 895193516,
 8010,
 -1,
 895248905,
 8012,
 895432034,
 895099479,
 8009,
 895549439,
 895352921,
 -1,
 -51871,
 895455660,
 8011,
 -1,
 895511049,
 8013,
 -51869,
 895390124,
 8184,
 -51868,
 895649734,
 908,
 -1,
 895707657,
 8185,
 895890830,
 893135127,
 -1,
 895956353,
 895845076,
 919,
 896073727,
 895878655,
 -1,
 896087412,
 895969813,
 -1,
 896152947,
 896040524,
 7976,
 896270335,
 896073817,
 -1,
 896284015,
 896166421,
 -1,
 896349550,
 896217079,
 7982,
 -1,
 896270572,
 8094,
 -1,
 896301185,
 8088,
 896546161,
 896242092,
 7978,
 -1,
 896467180,
 8090,
 896729087,
 896494089,
 7980,
 -1,
 896598252,
 8092,
 -1,
 896104577,
 8140,
 896873854,
 896016983,
 7977,
 896991231,
 896794713,
 -1,
 897004922,
 896887317,
 -1,
 897070457,
 896937975,
 7983,
 -1,
 896991468,
 8095,
 -1,
 897022081,
 8089,
 897267068,
 896962988,
 7979,
 -1,
 897188076,
 8091,
 897449983,
 897214985,
 7981,
 -1,
 897319148,
 8093,
 -51841,
 896831916,
 8138,
 -51840,
 897484742,
 905,
 -1,
 897542665,
 8139,
 897777663,
 895905431,
 917,
 897843199,
 897648127,
 -1,
 897856903,
 897740433,
 7960,
 897974271,
 897777753,
 -1,
 -51834,
 897880492,
 7962,
 -1,
 897935881,
 7964,
 898119051,
 897786455,
 7961,
 898236415,
 898039897,
 -1,
 -51830,
 898142636,
 7963,
 -1,
 898198025,
 7965,
 -51828,
 898077100,
 8136,
 -51827,
 898336710,
 904,
 -1,
 898394633,
 8137,
 898577836,
 895815485,
 913,
 898695167,
 898500095,
 -1,
 898708892,
 898591253,
 -1,
 898774427,
 898661964,
 7944,
 898891775,
 898695257,
 -1,
 898905495,
 898787861,
 -1,
 898971030,
 898838519,
 7950,
 -1,
 898892012,
 8078,
 -1,
 898922625,
 8072,
 899167641,
 898863532,
 7946,
 -1,
 899088620,
 8074,
 899350527,
 899115529,
 7948,
 -1,
 899219692,
 8076,
 -1,
 898726017,
 8124,
 899495334,
 898638423,
 7945,
 899612671,
 899416153,
 -1,
 899626402,
 899508757,
 -1,
 899691937,
 899559415,
 7951,
 -1,
 899612908,
 8079,
 -1,
 899643521,
 8073,
 899888548,
 899584428,
 7947,
 -1,
 899809516,
 8075,
 900071423,
 899836425,
 7949,
 -1,
 899940588,
 8077,
 900150697,
 899453306,
 -1,
 -51800,
 900100269,
 8120,
 -1,
 900141984,
 8122,
 -51798,
 900106182,
 902,
 -51797,
 900295177,
 8123,
 -1,
 900355387,
 8121,
 900543936,
 898516566,
 921,
 900661247,
 900466175,
 -1,
 900674997,
 900538754,
 -1,
 900740532,
 900601092,
 7993,
 900857855,
 900661337,
 -1,
 -51790,
 900764076,
 7995,
 -51789,
 900819987,
 7999,
 -1,
 900885001,
 7997,
 -1,
 900677622,
 938,
 901133754,
 900624017,
 7992,
 901251071,
 901054553,
 -1,
 -51784,
 901157292,
 7994,
 -51783,
 901213203,
 7998,
 -1,
 901278217,
 7996,
 901461437,
 901091706,
 -1,
 -51780,
 901410989,
 8152,
 -1,
 901452704,
 8154,
 -51778,
 901416902,
 906,
 -51777,
 901605897,
 8155,
 -1,
 901666107,
 8153,
 901854671,
 900501371,
 933,
 901971967,
 901776895,
 -1,
 901985737,
 901849474,
 -1,
 902051272,
 901911812,
 8025,
 902168575,
 901972057,
 -1,
 -51770,
 902074796,
 8027,
 -51769,
 902130707,
 8031,
 -1,
 902195721,
 8029,
 -1,
 901988342,
 939,
 902444492,
 901943674,
 -1,
 -51765,
 902394029,
 8168,
 -1,
 902435744,
 8170,
 -51763,
 902399942,
 910,
 -51762,
 902588937,
 8171,
 -1,
 902649147,
 8169,
 902837715,
 901802517,
 -1,
 -51759,
 902790617,
 936,
 -51758,
 902840193,
 928,
 -1,
 902904901,
 934,
 903099862,
 902791820,
 -1,
 -51755,
 903035952,
 920,
 -1,
 903091711,
 932,
 903296472,
 903050068,
 929,
 -1,
 903218836,
 8172,
 -51751,
 903257123,
 918,
 -51750,
 903387528,
 926,
 -51749,
 903446036,
 931,
 -51748,
 903503876,
 925,
 -51747,
 903567891,
 924,
 -51746,
 903629897,
 923,
 -51745,
 903694818,
 922,
 -51744,
 903755196,
 915,
 -51743,
 903815867,
 916,
 -51742,
 903880018,
 935,
 -1,
 903944349,
 914,
 -1,
 893093218,
 1012,
 904214001,
 893012813,
 -1,
 904279533,
 904147373,
 -1,
 904345065,
 904231563,
 -1,
 -51736,
 904300150,
 986,
 -1,
 904335344,
 992,
 -51734,
 904305492,
 1011,
 -51733,
 904481480,
 990,
 -51732,
 904537102,
 988,
 -1,
 904598341,
 984,
 904803824,
 904236305,
 -1,
 -51729,
 904756762,
 1010,
 -1,
 904802100,
 1013,
 -1,
 904751498,
 885,
 905065979,
 904161813,
 -1,
 905131511,
 905018956,
 8127,
 905248767,
 905052249,
 -1,
 -51723,
 905154988,
 8141,
 -51722,
 905210899,
 8143,
 -1,
 905275913,
 8142,
 -51720,
 905083009,
 8126,
 -51719,
 905396157,
 982,
 -51718,
 905460816,
 981,
 -1,
 905523191,
 8128,
 905721351,
 904995202,
 -1,
 905786882,
 905658367,
 -1,
 905852417,
 905711650,
 -1,
 -51713,
 905810348,
 8173,
 -51712,
 905866259,
 8129,
 -1,
 905931273,
 8174,
 -1,
 905807814,
 901,
 906231807,
 905712900,
 8190,
 906297343,
 906100825,
 -1,
 -51707,
 906203564,
 8157,
 -51706,
 906259475,
 8159,
 -1,
 906324489,
 8158,
 906507787,
 905678723,
 -1,
 -51703,
 906444170,
 978,
 -51702,
 906503005,
 980,
 -1,
 906562598,
 979,
 906769936,
 906447267,
 -1,
 906835471,
 906693245,
 -1,
 -51698,
 906784208,
 1008,
 -1,
 906837949,
 983,
 -1,
 906782286,
 8125,
 907097619,
 906723980,
 -1,
 -51694,
 907043902,
 900,
 -1,
 907099189,
 977,
 907294230,
 907047025,
 -1,
 -51691,
 907230542,
 1009,
 -1,
 907293230,
 1014,
 -51689,
 907254616,
 890,
 -51688,
 907448748,
 8175,
 -51687,
 907505671,
 894,
 -51686,
 907569673,
 8189,
 -51685,
 907632718,
 884,
 -51684,
 907679906,
 976,
 -1,
 907743602,
 903,
 908001279,
 879498656,
 -1,
 908015149,
 907895055,
 -1,
 908080682,
 907964531,
 -1,
 908146213,
 908033828,
 10878,
 908263423,
 908068554,
 -1,
 908277284,
 908135128,
 10882,
 -1,
 908198757,
 10884,
 -1,
 908215563,
 10880,
 908473896,
 908078932,
 -1,
 -51673,
 908412977,
 8819,
 -1,
 908463521,
 8805,
 -51671,
 908414919,
 8823,
 -1,
 908595837,
 10886,
 908853247,
 908038772,
 -1,
 -51668,
 908741818,
 10916,
 -1,
 908788345,
 8807,
 908998202,
 907938429,
 -1,
 909063735,
 908925488,
 -1,
 909129268,
 909015691,
 -1,
 909194803,
 909067134,
 -1,
 -51662,
 909141293,
 10894,
 -1,
 909183793,
 10896,
 -1,
 909134985,
 10900,
 -51659,
 909080028,
 10616,
 -51658,
 909397969,
 10898,
 -1,
 909453056,
 10892,
 909705215,
 909007816,
 -1,
 -51655,
 909606584,
 10888,
 -1,
 909663897,
 10890,
 909850174,
 908957393,
 -1,
 -51652,
 909799445,
 10876,
 -51651,
 909845838,
 8919,
 -1,
 909909454,
 10874,
 910112323,
 909776547,
 -1,
 910177858,
 910070020,
 -1,
 -51647,
 910116913,
 8935,
 -1,
 910167457,
 8809,
 -1,
 910110875,
 10917,
 910440005,
 910040767,
 10919,
 -1,
 910360609,
 10921,
 -51642,
 910392871,
 62,
 -1,
 910503828,
 8923,
 -1,
 879433268,
 96,
 910767895,
 879397620,
 -1,
 910833331,
 910706880,
 -1,
 910898823,
 910774340,
 -1,
 910964305,
 910852748,
 -1,
 911029839,
 910918284,
 -1,
 -51634,
 910965090,
 2720,
 -1,
 911018621,
 2719,
 -51632,
 910965090,
 2725,
 -1,
 911149693,
 2724,
 911357526,
 910908066,
 -1,
 -51629,
 911317482,
 2718,
 -51628,
 911366882,
 2723,
 -51627,
 911422876,
 2713,
 -1,
 911477373,
 2728,
 911685212,
 911286658,
 -1,
 911750746,
 911614338,
 -1,
 -51623,
 911685986,
 2722,
 -1,
 911739517,
 2721,
 -51621,
 911685986,
 2727,
 -1,
 911870589,
 2726,
 912078432,
 911608445,
 2693,
 -51618,
 912034548,
 2708,
 -51617,
 912080769,
 2704,
 -1,
 912132733,
 2694,
 912340580,
 912036218,
 -1,
 912406115,
 912286096,
 2699,
 -1,
 912355441,
 2784,
 -1,
 912329341,
 2741,
 912602728,
 912292491,
 -1,
 -51610,
 912554698,
 2743,
 -51609,
 912603490,
 2742,
 -1,
 912657021,
 2744,
 912864874,
 912558836,
 2697,
 -1,
 912820980,
 2698,
 912995949,
 912812565,
 -1,
 -51604,
 912931170,
 2731,
 -1,
 912984701,
 2730,
 913192560,
 912935757,
 -1,
 -51601,
 913132428,
 2739,
 -1,
 913181309,
 2738,
 913389171,
 913131939,
 -1,
 -51598,
 913324386,
 2710,
 -1,
 913377917,
 2709,
 913585782,
 913328301,
 -1,
 -51595,
 913520994,
 2717,
 -1,
 913574525,
 2716,
 913782392,
 913522561,
 2695,
 -1,
 913719169,
 2696,
 913913467,
 913716631,
 -1,
 -51590,
 913848674,
 2712,
 -1,
 913902205,
 2711,
 914110078,
 913840970,
 -1,
 -51587,
 914045282,
 2715,
 -1,
 914098813,
 2714,
 914306689,
 914036387,
 -1,
 -51584,
 914241890,
 2733,
 -1,
 914295421,
 2732,
 -51582,
 914266602,
 2735,
 -51581,
 914452629,
 2736,
 -51580,
 914514191,
 2707,
 -51579,
 914576696,
 2734,
 -51578,
 914635106,
 2745,
 -1,
 914696471,
 2703,
 914896539,
 910857386,
 -1,
 914962072,
 914849324,
 -1,
 915027597,
 914885245,
 -1,
 -51573,
 914983668,
 2764,
 -51572,
 915029889,
 2760,
 -1,
 915081853,
 2750,
 915289743,
 914986100,
 2755,
 -1,
 915239025,
 2756,
 915420817,
 915245812,
 2753,
 -1,
 915376884,
 2754,
 915551891,
 915357569,
 2751,
 -1,
 915488641,
 2752,
 915682966,
 915479497,
 -1,
 -51563,
 915628303,
 2761,
 -1,
 915679511,
 2757,
 -51561,
 915628303,
 2763,
 -1,
 915810583,
 2759,
 916062207,
 914889673,
 -1,
 -51558,
 915955983,
 2705,
 -1,
 916007191,
 2701,
 916207273,
 914826262,
 -1,
 916272799,
 916161164,
 -1,
 -51554,
 916232345,
 2792,
 -1,
 916274851,
 2793,
 916469410,
 916224651,
 -1,
 -51551,
 916408465,
 2796,
 -1,
 916468175,
 2797,
 916666021,
 916402880,
 -1,
 -51548,
 916613117,
 2794,
 -1,
 916670530,
 2795,
 -51546,
 916626462,
 2790,
 -51545,
 916808634,
 2791,
 -51544,
 916872524,
 2799,
 -1,
 916925594,
 2798,
 917124786,
 916160044,
 -1,
 917190317,
 917083119,
 -1,
 -51540,
 917142343,
 2691,
 -1,
 917205260,
 2765,
 917386928,
 917113469,
 -1,
 -51537,
 917344645,
 2749,
 -1,
 917397633,
 2690,
 -51535,
 917331988,
 2748,
 -1,
 917511121,
 2689,
 -1,
 917070582,
 2768,
 917831679,
 910784484,
 -1,
 917845749,
 917721156,
 -1,
 917911227,
 917799564,
 -1,
 917976761,
 917865100,
 -1,
 -51528,
 917911906,
 2592,
 -1,
 917965437,
 2591,
 -51526,
 917911906,
 2597,
 -1,
 918096509,
 2596,
 918304448,
 917854882,
 -1,
 -51523,
 918264298,
 2590,
 -51522,
 918313698,
 2595,
 -51521,
 918369692,
 2585,
 -1,
 918424189,
 2600,
 918632134,
 918233474,
 -1,
 918697668,
 918561154,
 -1,
 -51517,
 918632802,
 2594,
 -1,
 918686333,
 2593,
 -51515,
 918632802,
 2599,
 -1,
 918817405,
 2598,
 919025354,
 918555261,
 2565,
 -51512,
 918981364,
 2580,
 -51511,
 919027585,
 2576,
 -1,
 919079549,
 2566,
 919287503,
 918964643,
 -1,
 919353038,
 919222600,
 -1,
 -51507,
 919288162,
 2649,
 -1,
 919341693,
 2582,
 -1,
 919276157,
 2581,
 919615188,
 919221655,
 -1,
 919680723,
 919550280,
 -1,
 -51502,
 919615842,
 2650,
 -1,
 919669373,
 2584,
 -1,
 919603837,
 2583,
 919942870,
 919571188,
 2569,
 -1,
 919898868,
 2570,
 920073945,
 919894667,
 -1,
 -51496,
 920009058,
 2614,
 -1,
 920062589,
 2616,
 920270556,
 920023153,
 -1,
 -51493,
 920219797,
 2652,
 -1,
 920259197,
 2608,
 920467167,
 920218133,
 -1,
 -51490,
 920402274,
 2603,
 -1,
 920455805,
 2602,
 920663778,
 920406861,
 -1,
 -51487,
 920603532,
 2611,
 -1,
 920652413,
 2610,
 920860389,
 920602797,
 -1,
 -51484,
 920795490,
 2589,
 -1,
 920849021,
 2588,
 921056999,
 920797057,
 2567,
 -1,
 920993665,
 2568,
 921188074,
 920984394,
 -1,
 -51479,
 921123170,
 2587,
 -1,
 921176701,
 2586,
 921384685,
 921114275,
 -1,
 -51476,
 921319778,
 2605,
 -1,
 921373309,
 2604,
 -51474,
 921344986,
 2651,
 -51473,
 921541098,
 2607,
 -51472,
 921604476,
 2613,
 -51471,
 921658451,
 2579,
 -51470,
 921720120,
 2606,
 -51469,
 921778530,
 2617,
 -51468,
 921842406,
 2654,
 -1,
 921905874,
 2575,
 922105603,
 917775382,
 -1,
 922171129,
 922059404,
 -1,
 -51464,
 922130585,
 2664,
 -1,
 922173091,
 2665,
 922367740,
 922122891,
 -1,
 -51461,
 922306705,
 2668,
 -1,
 922366415,
 2669,
 922564351,
 922301120,
 -1,
 -51458,
 922511357,
 2666,
 -1,
 922568770,
 2667,
 -51456,
 922524702,
 2662,
 -51455,
 922706874,
 2663,
 -51454,
 922770764,
 2671,
 -1,
 922823834,
 2670,
 923023118,
 922064065,
 -1,
 923088648,
 922946173,
 -1,
 -51450,
 923044596,
 2636,
 -51449,
 923090817,
 2632,
 -1,
 923142781,
 2622,
 923350794,
 923044596,
 2625,
 -1,
 923306740,
 2626,
 923481868,
 923287425,
 2623,
 -1,
 923418497,
 2624,
 -51443,
 923427923,
 2635,
 -1,
 923544274,
 2631,
 923744018,
 922975788,
 -1,
 -51440,
 923702320,
 2637,
 -51439,
 923754516,
 2620,
 -1,
 923801827,
 2562,
 -51437,
 923701269,
 2675,
 -51436,
 923961118,
 2672,
 -51435,
 924010261,
 2674,
 -51434,
 924069120,
 2676,
 -1,
 924126287,
 2673,
 924333963,
 910698775,
 -1,
 924399496,
 924279055,
 -1,
 924465027,
 924349245,
 -1,
 924530512,
 924405828,
 -1,
 924596002,
 924465480,
 -1,
 924661535,
 924519037,
 -1,
 -51426,
 924610673,
 4340,
 -1,
 924657943,
 4336,
 -51424,
 924606904,
 4341,
 -51423,
 924795227,
 4338,
 -1,
 924854551,
 4337,
 925054760,
 924523338,
 -1,
 925120294,
 924989768,
 -1,
 -51419,
 925058003,
 4329,
 -1,
 925110942,
 4333,
 -51417,
 925057751,
 4332,
 -1,
 925241342,
 4330,
 925447979,
 925014990,
 -1,
 -51414,
 925383382,
 4319,
 -1,
 925445640,
 4310,
 925644590,
 925401812,
 -1,
 -51411,
 925593713,
 4322,
 -1,
 925653666,
 4311,
 925841201,
 925596299,
 -1,
 -51408,
 925777115,
 4328,
 -1,
 925831166,
 4321,
 926037812,
 925788693,
 -1,
 -51405,
 925973206,
 4324,
 -1,
 926028446,
 4318,
 926234423,
 925976995,
 -1,
 -51402,
 926169814,
 4325,
 -1,
 926224382,
 4313,
 926431034,
 926173357,
 -1,
 -51399,
 926368471,
 4331,
 -1,
 926431891,
 4335,
 926627645,
 926365079,
 -1,
 -51396,
 926562963,
 4326,
 -1,
 926617598,
 4306,
 926824256,
 926558487,
 -1,
 -51393,
 926767778,
 4308,
 -1,
 926830811,
 4344,
 -51391,
 926784292,
 4343,
 -51390,
 926980422,
 4334,
 -51389,
 927045104,
 4339,
 -51388,
 927110164,
 4309,
 -51387,
 927173884,
 4323,
 -51386,
 927232188,
 4320,
 -51385,
 927297293,
 4327,
 -51384,
 927359820,
 4317,
 -51383,
 927423286,
 4316,
 -51382,
 927487591,
 4315,
 -51381,
 927550668,
 4314,
 -51380,
 927613907,
 4312,
 -51379,
 927675328,
 4342,
 -51378,
 927737150,
 4307,
 -51377,
 927799047,
 4305,
 -1,
 927862782,
 4304,
 928069506,
 924458036,
 -1,
 928135000,
 928004424,
 -1,
 928200533,
 928057981,
 -1,
 -51372,
 928149617,
 4292,
 -1,
 928196887,
 4288,
 -51370,
 928145848,
 4293,
 -51369,
 928334171,
 4290,
 -1,
 928393495,
 4289,
 928593758,
 928062282,
 -1,
 928659292,
 928528712,
 -1,
 -51365,
 928596947,
 4281,
 -1,
 928649886,
 4285,
 -51363,
 928596695,
 4284,
 -1,
 928780286,
 4282,
 928986977,
 928553934,
 -1,
 -51360,
 928922326,
 4271,
 -1,
 928984584,
 4262,
 929183588,
 928940756,
 -1,
 -51357,
 929132657,
 4274,
 -1,
 929192610,
 4263,
 929380199,
 929135243,
 -1,
 -51354,
 929316059,
 4280,
 -1,
 929370110,
 4273,
 929576810,
 929327637,
 -1,
 -51351,
 929512150,
 4276,
 -1,
 929567390,
 4270,
 929773421,
 929515939,
 -1,
 -51348,
 929708758,
 4277,
 -1,
 929763326,
 4265,
 929970032,
 929712301,
 -1,
 -51345,
 929907415,
 4283,
 -1,
 929970835,
 4287,
 930166643,
 929904023,
 -1,
 -51342,
 930101907,
 4278,
 -1,
 930156542,
 4258,
 -51340,
 930126150,
 4286,
 -51339,
 930321904,
 4291,
 -51338,
 930386964,
 4261,
 -51337,
 930450684,
 4275,
 -51336,
 930508988,
 4272,
 -51335,
 930574093,
 4279,
 -51334,
 930636620,
 4269,
 -51333,
 930700086,
 4268,
 -51332,
 930764391,
 4267,
 -51331,
 930827468,
 4266,
 -51330,
 930890707,
 4264,
 -51329,
 930950664,
 4260,
 -51328,
 931013950,
 4259,
 -51327,
 931075847,
 4257,
 -1,
 931139582,
 4256,
 -1,
 928017039,
 4347,
 931463167,
 924407794,
 -1,
 931477383,
 931335966,
 -1,
 -51322,
 931416113,
 8782,
 -1,
 931466657,
 8785,
 -1,
 931398891,
 8762,
 -51319,
 924353243,
 12307,
 -51318,
 931690427,
 8368,
 -1,
 931748058,
 9802,
 931936173,
 924280658,
 -1,
 932001681,
 931879586,
 -1,
 932067216,
 931939435,
 -1,
 -51313,
 932022995,
 66369,
 -1,
 932053744,
 66378,
 -1,
 931993123,
 66365,
 932329364,
 931955340,
 -1,
 -51309,
 932265261,
 66360,
 -1,
 932326644,
 66372,
 932525975,
 932265857,
 -1,
 -51306,
 932482111,
 66358,
 -1,
 932525656,
 66375,
 932722586,
 932460872,
 -1,
 -51303,
 932680972,
 66376,
 -1,
 932711642,
 66359,
 932919197,
 932645501,
 -1,
 -51300,
 932856480,
 66356,
 -1,
 932921078,
 66352,
 -51298,
 932878027,
 66373,
 -51297,
 933073030,
 66367,
 -51296,
 933133139,
 66371,
 -51295,
 933196002,
 66370,
 -51294,
 933261048,
 66357,
 -51293,
 933325418,
 66368,
 -51292,
 933390150,
 66377,
 -51291,
 933451392,
 66364,
 -51290,
 933514248,
 66363,
 -51289,
 933579567,
 66362,
 -51288,
 933644602,
 66366,
 -51287,
 933705431,
 66354,
 -51286,
 933769978,
 66374,
 -51285,
 933833962,
 66361,
 -51284,
 933896698,
 66355,
 -1,
 933959392,
 66353,
 -51282,
 931876738,
 10726,
 -1,
 934101869,
 8503,
 934296170,
 879315363,
 -1,
 934361562,
 934218365,
 -1,
 934426959,
 934304418,
 -1,
 934492388,
 934361389,
 -1,
 934557672,
 934443659,
 -1,
 934623165,
 934511244,
 -1,
 934688697,
 934568207,
 -1,
 934754232,
 934636053,
 12108,
 -1,
 934702282,
 12169,
 -1,
 934698062,
 12143,
 934950844,
 934619415,
 -1,
 -51269,
 934898197,
 12091,
 -1,
 934940507,
 12115,
 -1,
 934875166,
 12148,
 935212996,
 934570517,
 -1,
 935278529,
 935143703,
 -1,
 -51264,
 935209508,
 12180,
 -1,
 935269022,
 12141,
 -51262,
 935229730,
 12076,
 -51261,
 935421038,
 12052,
 -1,
 935479077,
 12144,
 935671757,
 935147848,
 -1,
 935737290,
 935616783,
 -1,
 935802825,
 935688721,
 -1,
 -51256,
 935739037,
 12083,
 -1,
 935791907,
 12203,
 -1,
 935749364,
 12087,
 936116223,
 935667991,
 -1,
 -51252,
 936006181,
 12185,
 -1,
 936062755,
 12154,
 936261586,
 935602455,
 -1,
 -51249,
 936202386,
 12163,
 -51248,
 936257815,
 12178,
 -51247,
 936320867,
 12036,
 -1,
 936381824,
 12057,
 936589271,
 936201037,
 -1,
 936654806,
 936512125,
 -1,
 -51243,
 936612346,
 12202,
 -1,
 936672484,
 12035,
 -1,
 936591447,
 12122,
 936916955,
 936512125,
 -1,
 -51239,
 936876499,
 12104,
 -51238,
 936924295,
 12228,
 -1,
 936976449,
 12223,
 937179102,
 936853377,
 -1,
 -51235,
 937120286,
 12151,
 -1,
 937172617,
 12135,
 937375713,
 937106250,
 -1,
 -51232,
 937326386,
 12098,
 -1,
 937377134,
 12064,
 -51230,
 937334264,
 12130,
 -51229,
 937528572,
 12103,
 -51228,
 937586569,
 12101,
 -51227,
 937650114,
 12211,
 -51226,
 937713407,
 12089,
 -51225,
 937776617,
 12073,
 -1,
 937839250,
 12138,
 938031104,
 934486402,
 -1,
 938096627,
 937976079,
 -1,
 938162158,
 938050188,
 12034,
 938278911,
 938116070,
 -1,
 -51219,
 938181729,
 12136,
 -1,
 938221214,
 12084,
 -51217,
 938121340,
 12044,
 -51216,
 938380159,
 12120,
 -51215,
 938435871,
 12094,
 -51214,
 938489239,
 12125,
 -1,
 938542029,
 12111,
 938751993,
 938033025,
 -1,
 938817527,
 938703499,
 -1,
 -51210,
 938772201,
 12196,
 -1,
 938817864,
 12139,
 -51208,
 938775576,
 12056,
 -1,
 938962395,
 12099,
 939145213,
 938700913,
 -1,
 -51205,
 939104723,
 12082,
 -51204,
 939166949,
 12238,
 -1,
 939199716,
 12243,
 939458559,
 939075863,
 -1,
 -51201,
 939339709,
 12229,
 -1,
 939398571,
 12109,
 939603991,
 937957027,
 -1,
 939669511,
 939548943,
 -1,
 -51197,
 939627743,
 12088,
 -51196,
 939678798,
 12219,
 -51195,
 939742346,
 12134,
 -51194,
 939796740,
 12189,
 -1,
 939857274,
 12168,
 940062731,
 939618417,
 -1,
 -51191,
 940019913,
 12160,
 -51190,
 940066718,
 12090,
 -1,
 940118034,
 12096,
 940324879,
 940002125,
 -1,
 -51187,
 940280773,
 12205,
 -51186,
 940336223,
 12174,
 -1,
 940379105,
 12234,
 940587027,
 940261249,
 -1,
 -51183,
 940542373,
 12191,
 -51182,
 940601752,
 12227,
 -1,
 940651927,
 12068,
 940849174,
 940509821,
 -1,
 -51179,
 940791534,
 12149,
 -1,
 940843841,
 12184,
 -1,
 940779879,
 12182,
 941111340,
 939557516,
 -1,
 941176860,
 941060209,
 -1,
 -51174,
 941115006,
 12237,
 -51173,
 941173458,
 12106,
 -1,
 941231073,
 12145,
 941439008,
 941099645,
 -1,
 -51170,
 941383139,
 12209,
 -51169,
 941445669,
 12220,
 -1,
 941496717,
 12047,
 941701154,
 941398169,
 12038,
 -1,
 941621975,
 12086,
 941832229,
 941658126,
 -1,
 -51164,
 941786947,
 12244,
 -1,
 941823751,
 12081,
 942028840,
 941777167,
 -1,
 -51161,
 941975362,
 12242,
 -1,
 942038293,
 12166,
 942225451,
 941965185,
 -1,
 -51158,
 942165341,
 12129,
 -1,
 942224960,
 12172,
 -1,
 942157320,
 12055,
 942487615,
 941044416,
 -1,
 942553138,
 942423937,
 -1,
 -51153,
 942505188,
 12226,
 -51152,
 942567870,
 12117,
 -51151,
 942618221,
 12222,
 -1,
 942681395,
 12133,
 942880822,
 942475901,
 -1,
 -51148,
 942835029,
 12119,
 -51147,
 942890149,
 12123,
 -1,
 942939271,
 12207,
 943142969,
 942829681,
 -1,
 -51144,
 943088101,
 12236,
 -1,
 943131881,
 12217,
 943339580,
 943082317,
 -1,
 -51141,
 943299027,
 12214,
 -1,
 943362327,
 12245,
 -51139,
 943296526,
 12113,
 -51138,
 943481994,
 12188,
 -1,
 943532494,
 12155,
 943732818,
 942414666,
 -1,
 943798342,
 943677711,
 -1,
 -51134,
 943756511,
 12124,
 -51133,
 943821428,
 12045,
 -51132,
 943880546,
 12075,
 -51131,
 943938016,
 12112,
 -1,
 944001906,
 12170,
 944191564,
 943737677,
 -1,
 944257098,
 944114301,
 -1,
 -51127,
 944215263,
 12118,
 -1,
 944265890,
 12114,
 -51125,
 944203596,
 12176,
 -1,
 944390514,
 12058,
 944584784,
 944114301,
 -1,
 -51122,
 944542202,
 12147,
 -51121,
 944606324,
 12224,
 -1,
 944667146,
 12190,
 -51119,
 944523309,
 12194,
 -1,
 944782539,
 12070,
 944978022,
 943690975,
 -1,
 945043543,
 944900733,
 -1,
 945109078,
 944984606,
 12193,
 -1,
 945029742,
 12175,
 -1,
 945063014,
 12116,
 945305690,
 944992369,
 -1,
 -51111,
 945251298,
 12206,
 -1,
 945295868,
 12051,
 945502301,
 945250575,
 -1,
 -51108,
 945452966,
 12079,
 -1,
 945509991,
 12069,
 945698912,
 945439699,
 -1,
 -51105,
 945629463,
 12195,
 -1,
 945693058,
 12213,
 945895523,
 945633608,
 -1,
 -51102,
 945833914,
 12137,
 -1,
 945891752,
 12230,
 946143231,
 945826071,
 -1,
 -51099,
 946045149,
 12177,
 -1,
 946082408,
 12110,
 946288760,
 944919855,
 -1,
 946354289,
 946233615,
 -1,
 946419821,
 946309876,
 -1,
 946485356,
 946363042,
 -1,
 -51093,
 946438930,
 12077,
 -1,
 946479490,
 12201,
 -1,
 946439433,
 12061,
 946747504,
 946368625,
 -1,
 -51089,
 946701148,
 12165,
 -1,
 946756980,
 12192,
 -1,
 946692940,
 12105,
 947009652,
 946290561,
 -1,
 -51085,
 946953605,
 12162,
 -1,
 947016299,
 12233,
 947206263,
 946940183,
 -1,
 -51082,
 947147532,
 12128,
 -1,
 947197306,
 12161,
 -1,
 947130366,
 12040,
 947468424,
 946228045,
 -1,
 947533951,
 947398935,
 -1,
 947599485,
 947456637,
 -1,
 -51076,
 947553621,
 12208,
 -1,
 947598016,
 12212,
 -51074,
 947534083,
 12041,
 -1,
 947727609,
 12210,
 947927171,
 947470209,
 -1,
 -51071,
 947870798,
 12033,
 -51070,
 947925828,
 12131,
 -1,
 947986818,
 12039,
 948189317,
 947872738,
 12199,
 -1,
 948110729,
 12085,
 948371455,
 948111997,
 -1,
 -51065,
 948262661,
 12074,
 -1,
 948313684,
 12107,
 948517018,
 947403080,
 -1,
 948582543,
 948439677,
 -1,
 948648077,
 948521805,
 -1,
 -51060,
 948581073,
 12121,
 -1,
 948639772,
 12093,
 -51058,
 948591557,
 12095,
 -1,
 948782728,
 12221,
 948975764,
 948527375,
 -1,
 949041299,
 948924529,
 -1,
 -51054,
 948992961,
 12218,
 -1,
 949050018,
 12179,
 -1,
 948986486,
 12037,
 949303449,
 948906263,
 -1,
 949368984,
 949226109,
 -1,
 -51049,
 949320202,
 12092,
 -1,
 949363074,
 12216,
 -1,
 949311965,
 12231,
 -1,
 949240139,
 12054,
 949696679,
 948447511,
 -1,
 949762207,
 949619325,
 -1,
 949827742,
 949710961,
 12159,
 -1,
 949781769,
 12063,
 -1,
 949781132,
 12215,
 950024353,
 949719646,
 12241,
 -1,
 949961849,
 12067,
 950155428,
 949967522,
 -1,
 -51037,
 950109286,
 12042,
 -1,
 950148815,
 12062,
 -51035,
 950114859,
 12140,
 -51034,
 950294267,
 12235,
 -1,
 950354434,
 12043,
 950548659,
 949645425,
 -1,
 950614188,
 950484865,
 -1,
 -51030,
 950571636,
 12078,
 -51029,
 950613636,
 12053,
 -1,
 950672519,
 12150,
 950876336,
 950536829,
 -1,
 -51026,
 950829708,
 12239,
 -51025,
 950888981,
 12097,
 -1,
 950944723,
 12204,
 -51023,
 950832380,
 12187,
 -51022,
 951084131,
 12071,
 -1,
 951134795,
 12186,
 951335100,
 950482327,
 -1,
 951400631,
 951279887,
 12065,
 -51018,
 951340363,
 12198,
 -1,
 951387479,
 12066,
 951597242,
 951349397,
 -1,
 -51015,
 951550074,
 12171,
 -1,
 951600083,
 12146,
 -51013,
 951533172,
 12225,
 -1,
 951719319,
 12200,
 951924931,
 951282197,
 -1,
 951990464,
 951873649,
 -1,
 -51009,
 951935445,
 12126,
 -1,
 951994428,
 12059,
 -51007,
 951937381,
 12050,
 -51006,
 952128490,
 12158,
 -1,
 952189349,
 12183,
 952383690,
 951869711,
 -1,
 952449223,
 952330773,
 -1,
 -51002,
 952397215,
 12167,
 -1,
 952446475,
 12048,
 952645833,
 952392782,
 12032,
 -1,
 952597495,
 12080,
 -1,
 952585547,
 12156,
 952842449,
 952306301,
 -1,
 952907982,
 952793451,
 -1,
 -50995,
 952854843,
 12142,
 -1,
 952911938,
 12164,
 -50993,
 952867196,
 12100,
 -50992,
 953048005,
 12157,
 -1,
 953103781,
 12060,
 953301206,
 952785570,
 -1,
 953366741,
 953245967,
 -1,
 -50988,
 953320076,
 12102,
 -1,
 953383873,
 12240,
 -1,
 953299212,
 12153,
 953628891,
 953237377,
 -1,
 953694426,
 953572002,
 -1,
 -50983,
 953646047,
 12173,
 -1,
 953687280,
 12072,
 -1,
 953621639,
 12046,
 953956574,
 953586042,
 -1,
 -50979,
 953893666,
 12197,
 -1,
 953945857,
 12181,
 954153185,
 953895101,
 -1,
 -50976,
 954101873,
 12152,
 -1,
 954147450,
 12127,
 -50974,
 954112614,
 12232,
 -50973,
 954306717,
 12132,
 -1,
 954354345,
 12049,
 954597375,
 934435574,
 -1,
 954612012,
 954486109,
 -1,
 954677547,
 954567082,
 -1,
 954743022,
 954634618,
 -1,
 954808557,
 954687880,
 -1,
 954874091,
 954757233,
 3211,
 -1,
 954822769,
 3296,
 955056127,
 954813261,
 3212,
 -1,
 954944333,
 3297,
 -1,
 954731133,
 3253,
 955201780,
 954696332,
 -1,
 955267314,
 955155084,
 -1,
 -50959,
 955201890,
 3232,
 -1,
 955255421,
 3231,
 -50957,
 955201890,
 3237,
 -1,
 955386493,
 3236,
 955595001,
 955144866,
 -1,
 -50954,
 955554282,
 3230,
 -50953,
 955603682,
 3235,
 -50952,
 955659676,
 3225,
 -1,
 955714173,
 3240,
 955922687,
 955523458,
 -1,
 955988221,
 955851138,
 -1,
 -50948,
 955922786,
 3234,
 -1,
 955976317,
 3233,
 -50946,
 955922786,
 3239,
 -1,
 956107389,
 3238,
 956315907,
 955845245,
 3205,
 -50943,
 956271348,
 3220,
 -50942,
 956317569,
 3216,
 -1,
 956369533,
 3206,
 956578055,
 956267147,
 -1,
 -50939,
 956529354,
 3255,
 -50938,
 956578146,
 3254,
 -1,
 956631677,
 3256,
 956840201,
 956533492,
 3209,
 -1,
 956795636,
 3210,
 956971276,
 956788849,
 -1,
 -50933,
 956919957,
 3249,
 -1,
 956959357,
 3248,
 957167887,
 956918293,
 -1,
 -50930,
 957102434,
 3243,
 -1,
 957155965,
 3242,
 957364497,
 957112591,
 3218,
 -1,
 957309199,
 3219,
 957495572,
 957303629,
 -1,
 -50925,
 957434764,
 3251,
 -1,
 957483645,
 3250,
 957692183,
 957434275,
 -1,
 -50922,
 957626722,
 3222,
 -1,
 957680253,
 3221,
 957888794,
 957630637,
 -1,
 -50919,
 957823330,
 3229,
 -1,
 957876861,
 3228,
 958085404,
 957824897,
 3207,
 -1,
 958021505,
 3208,
 958216479,
 958018967,
 -1,
 -50914,
 958151010,
 3224,
 -1,
 958204541,
 3223,
 958413089,
 958146839,
 3214,
 -1,
 958343447,
 3215,
 958544164,
 958339914,
 -1,
 -50909,
 958478690,
 3227,
 -1,
 958532221,
 3226,
 958740775,
 958469795,
 -1,
 -50906,
 958675298,
 3245,
 -1,
 958728829,
 3244,
 -50904,
 958700010,
 3247,
 -50903,
 958879032,
 3246,
 -50902,
 958937442,
 3257,
 -1,
 959001318,
 3294,
 -1,
 954621184,
 3285,
 959265083,
 954569921,
 -1,
 959330609,
 959187581,
 -1,
 -50897,
 959286004,
 3276,
 -50896,
 959332225,
 3272,
 -1,
 959384189,
 3262,
 959592755,
 959288436,
 3267,
 -1,
 959541361,
 3268,
 959723829,
 959548148,
 3265,
 -1,
 959679220,
 3266,
 959854903,
 959668495,
 3274,
 -1,
 959799567,
 3275,
 959985977,
 959790977,
 3263,
 -1,
 959922049,
 3264,
 960167935,
 959916311,
 3270,
 -1,
 960047383,
 3271,
 960248137,
 959194134,
 -1,
 960313663,
 960201356,
 -1,
 -50882,
 960272537,
 3304,
 -1,
 960315043,
 3305,
 960510274,
 960264843,
 -1,
 -50879,
 960448657,
 3308,
 -1,
 960508367,
 3309,
 960706885,
 960443072,
 -1,
 -50876,
 960653309,
 3306,
 -1,
 960710722,
 3307,
 -50874,
 960666654,
 3302,
 -50873,
 960848826,
 3303,
 -50872,
 960912716,
 3311,
 -1,
 960965786,
 3310,
 961165646,
 960200236,
 -1,
 961231181,
 961123311,
 -1,
 -50868,
 961182535,
 3203,
 -1,
 961245452,
 3277,
 -1,
 961155561,
 3202,
 -1,
 961088784,
 3286,
 961609727,
 934380319,
 -1,
 961624533,
 961478656,
 -1,
 961690065,
 961564740,
 -1,
 961755515,
 961641099,
 -1,
 961821046,
 961697262,
 -1,
 961886554,
 961769585,
 -1,
 -50858,
 961841908,
 12797,
 -50857,
 961896719,
 12799,
 -50856,
 961953665,
 12796,
 -50855,
 962013463,
 12798,
 -1,
 962071165,
 12795,
 962279776,
 961821000,
 -1,
 -50852,
 962235124,
 12791,
 -50851,
 962289935,
 12793,
 -50850,
 962346881,
 12790,
 -50849,
 962406679,
 12792,
 -1,
 962464381,
 12789,
 962672996,
 962238931,
 -1,
 -50846,
 962628340,
 12517,
 -50845,
 962683151,
 12519,
 -1,
 962726525,
 12515,
 962935144,
 962611619,
 -1,
 -50842,
 962890484,
 12784,
 -50841,
 962930967,
 12534,
 -1,
 962988669,
 12533,
 963197291,
 962888332,
 -1,
 -50838,
 963152628,
 12483,
 -1,
 963207439,
 12787,
 963393902,
 963148427,
 -1,
 -50835,
 963349236,
 12786,
 -1,
 963395457,
 12785,
 -50833,
 963351798,
 12526,
 -50832,
 963545844,
 12453,
 -50831,
 963600655,
 12457,
 -50830,
 963665924,
 12788,
 -50829,
 963729939,
 12794,
 -50828,
 963788673,
 12451,
 -50827,
 963848471,
 12455,
 -1,
 963906173,
 12449,
 -50825,
 961776372,
 12473,
 -50824,
 964059407,
 12477,
 -50823,
 964116353,
 12471,
 -50822,
 964176151,
 12475,
 -1,
 964233853,
 12469,
 964442497,
 961698466,
 12531,
 -50819,
 964397812,
 12492,
 -50818,
 964452623,
 12494,
 -50817,
 964509569,
 12491,
 -50816,
 964569367,
 12493,
 -1,
 964627069,
 12490,
 964835719,
 964402126,
 -1,
 -50813,
 964791028,
 12474,
 -50812,
 964845839,
 12478,
 -50811,
 964902785,
 12472,
 -50810,
 964962583,
 12476,
 -1,
 965020285,
 12470,
 965228941,
 964792698,
 -1,
 -50807,
 965184244,
 12532,
 -50806,
 965239055,
 12538,
 -50805,
 965296001,
 12536,
 -50804,
 965355799,
 12537,
 -1,
 965413501,
 12535,
 965622163,
 965182092,
 -1,
 -50801,
 965577460,
 12484,
 -50800,
 965632271,
 12488,
 -50799,
 965689217,
 12481,
 -50798,
 965749015,
 12486,
 -1,
 965806717,
 12479,
 966015385,
 965570673,
 -1,
 -50795,
 965970676,
 12523,
 -50794,
 966025487,
 12525,
 -50793,
 966082433,
 12522,
 -50792,
 966142231,
 12524,
 -1,
 966199933,
 12521,
 966408607,
 965962261,
 -1,
 -50789,
 966363892,
 12503,
 -50788,
 966418703,
 12509,
 -50787,
 966475649,
 12500,
 -50786,
 966535447,
 12506,
 -1,
 966593149,
 12497,
 966801829,
 966350127,
 -1,
 -50783,
 966757108,
 12512,
 -50782,
 966811919,
 12514,
 -50781,
 966868865,
 12511,
 -50780,
 966928663,
 12513,
 -1,
 966986365,
 12510,
 967195051,
 966740387,
 -1,
 -50777,
 967150324,
 12463,
 -50776,
 967205135,
 12467,
 -50775,
 967262081,
 12461,
 -50774,
 967321879,
 12465,
 -1,
 967379581,
 12459,
 967588273,
 967129416,
 -1,
 -50771,
 967543540,
 12501,
 -50770,
 967598351,
 12507,
 -50769,
 967655297,
 12498,
 -50768,
 967715095,
 12504,
 -1,
 967772797,
 12495,
 967981495,
 967521687,
 -1,
 -50765,
 967936756,
 12464,
 -50764,
 967991567,
 12468,
 -50763,
 968048513,
 12462,
 -50762,
 968108311,
 12466,
 -1,
 968166013,
 12460,
 968374717,
 967909762,
 -1,
 -50759,
 968329972,
 12485,
 -50758,
 968384783,
 12489,
 -50757,
 968441729,
 12482,
 -50756,
 968501527,
 12487,
 -1,
 968559229,
 12480,
 968767939,
 968300195,
 -1,
 -50753,
 968723188,
 12502,
 -50752,
 968777999,
 12508,
 -50751,
 968834945,
 12499,
 -50750,
 968894743,
 12505,
 -1,
 968952445,
 12496,
 969161160,
 968725727,
 -1,
 -50747,
 969105679,
 12530,
 -50746,
 969162625,
 12528,
 -50745,
 969222423,
 12529,
 -1,
 969280125,
 12527,
 969488844,
 969120211,
 -1,
 -50742,
 969444084,
 12518,
 -50741,
 969498895,
 12520,
 -1,
 969542269,
 12516,
 -50739,
 969444084,
 12454,
 -50738,
 969695503,
 12458,
 -50737,
 969752449,
 12452,
 -50736,
 969812247,
 12456,
 -1,
 969869949,
 12450,
 -50734,
 961647742,
 12542,
 -50733,
 970020951,
 12539,
 -50732,
 970082243,
 12541,
 -1,
 970138683,
 12543,
 970391551,
 961546471,
 -1,
 -50729,
 970298516,
 12443,
 -50728,
 970357756,
 12444,
 -50727,
 970419823,
 12540,
 -1,
 970466898,
 12448,
 970668645,
 934296897,
 -1,
 970734092,
 970608708,
 -1,
 970799589,
 970687116,
 -1,
 970865120,
 970753289,
 -1,
 -50721,
 970809615,
 6029,
 -1,
 970852989,
 6027,
 971061731,
 970799432,
 -1,
 -50718,
 971006223,
 6034,
 -1,
 971049597,
 6032,
 -50716,
 971006223,
 6033,
 -1,
 971180669,
 6031,
 971389418,
 970742434,
 -1,
 -50713,
 971348795,
 6025,
 -50712,
 971399439,
 6035,
 -50711,
 971464176,
 6030,
 -1,
 971519834,
 6020,
 971717104,
 971327907,
 -1,
 971782638,
 971651400,
 -1,
 -50707,
 971727119,
 6019,
 -1,
 971770493,
 6017,
 -50705,
 971727119,
 6018,
 -1,
 971901565,
 6016,
 972110326,
 971643722,
 -1,
 972175860,
 972044616,
 -1,
 -50701,
 972120335,
 6024,
 -1,
 972163709,
 6022,
 -50699,
 972120335,
 6023,
 -1,
 972294781,
 6021,
 972503546,
 972061323,
 -1,
 -50696,
 972455868,
 6046,
 -50695,
 972503394,
 6045,
 -1,
 972556925,
 6047,
 972765695,
 972450325,
 -1,
 972831230,
 972699976,
 -1,
 -50691,
 972775695,
 6039,
 -1,
 972819069,
 6037,
 -1,
 972775695,
 6038,
 973093378,
 972704589,
 -1,
 -50687,
 973037839,
 6043,
 -1,
 973081213,
 6049,
 973289989,
 973021570,
 -1,
 -50684,
 973234447,
 6028,
 -1,
 973277821,
 6026,
 -50682,
 973249339,
 6041,
 -50681,
 973444200,
 6044,
 -50680,
 973502492,
 6042,
 -50679,
 973565644,
 6050,
 -50678,
 973625652,
 6040,
 -50677,
 973683042,
 6048,
 -1,
 973739685,
 6036,
 973945386,
 970685996,
 -1,
 974010899,
 973870755,
 -1,
 974076434,
 973933181,
 -1,
 -50672,
 974030127,
 6099,
 -50671,
 974092179,
 6101,
 -1,
 974151644,
 6091,
 -1,
 974008993,
 6104,
 974404119,
 973949347,
 -1,
 -50667,
 974349415,
 6106,
 -50666,
 974404243,
 6100,
 -1,
 974458196,
 6094,
 974666266,
 974357132,
 -1,
 -50663,
 974616243,
 6090,
 -1,
 974676314,
 6093,
 974862877,
 974614641,
 -1,
 -50660,
 974807397,
 6092,
 -1,
 974858592,
 6087,
 975059488,
 974789450,
 -1,
 -50657,
 975004099,
 6098,
 -1,
 975048641,
 6102,
 975256099,
 974981757,
 -1,
 -50654,
 975212941,
 6108,
 -1,
 975257338,
 6095,
 -50652,
 975215522,
 6088,
 -50651,
 975410231,
 6097,
 -50650,
 975469314,
 6096,
 -50649,
 975531173,
 6105,
 -50648,
 975592772,
 6086,
 -50647,
 975657597,
 6089,
 -1,
 975720334,
 6103,
 975911489,
 973903018,
 -1,
 975977022,
 975863340,
 -1,
 976042545,
 975899261,
 -1,
 -50642,
 975997684,
 6085,
 -50641,
 976043905,
 6083,
 -50640,
 976103703,
 6082,
 -1,
 976161405,
 6070,
 976370228,
 976001491,
 6073,
 -50637,
 976329171,
 6074,
 -1,
 976358013,
 6079,
 976566839,
 976325364,
 6075,
 -50634,
 976521972,
 6076,
 -1,
 976554621,
 6077,
 976763450,
 976502657,
 6071,
 -50631,
 976699265,
 6072,
 -1,
 976759063,
 6080,
 976960061,
 976707855,
 -1,
 -50628,
 976904463,
 6084,
 -1,
 976955671,
 6078,
 -1,
 976890135,
 6081,
 977272831,
 975914182,
 -1,
 -50624,
 977170122,
 6068,
 -1,
 977209981,
 6069,
 977418838,
 975848524,
 -1,
 977484370,
 977366730,
 -1,
 977549895,
 977439476,
 6055,
 977615430,
 977505012,
 6057,
 -1,
 977572218,
 6058,
 -1,
 977553827,
 6056,
 977812044,
 977472125,
 -1,
 -50615,
 977767156,
 6067,
 -50614,
 977825482,
 6051,
 -50613,
 977878913,
 6064,
 -1,
 977930877,
 6052,
 978139727,
 977757270,
 -1,
 -50610,
 978094636,
 6066,
 -1,
 978150330,
 6065,
 978336337,
 978075521,
 6053,
 -1,
 978272129,
 6054,
 -1,
 978266391,
 6063,
 978532948,
 977435263,
 6059,
 -1,
 978491859,
 6060,
 978714623,
 978474247,
 6061,
 -1,
 978622931,
 6062,
 978795108,
 977347606,
 -1,
 978860634,
 978748044,
 -1,
 -50599,
 978819225,
 6114,
 -1,
 978861731,
 6115,
 979057245,
 978811531,
 -1,
 -50596,
 978995345,
 6118,
 -1,
 979055055,
 6119,
 979253856,
 978989760,
 -1,
 -50593,
 979199997,
 6116,
 -1,
 979257410,
 6117,
 -50591,
 979213342,
 6112,
 -50590,
 979395514,
 6113,
 -50589,
 979459404,
 6121,
 -1,
 979512474,
 6120,
 -1,
 978723117,
 6107,
 979778152,
 970598679,
 -1,
 -50585,
 979737124,
 9000,
 -1,
 979784957,
 8490,
 -50583,
 979723679,
 12927,
 -1,
 979912286,
 8365,
 980106358,
 934226199,
 -1,
 980171772,
 980059511,
 -1,
 980237271,
 980122251,
 -1,
 980302806,
 980196094,
 -1,
 980368017,
 980255372,
 -1,
 980433528,
 980318859,
 -1,
 980499058,
 980363543,
 4925,
 -1,
 980429079,
 4924,
 980630132,
 980421245,
 4920,
 -1,
 980552317,
 4923,
 -50571,
 980587766,
 4927,
 -50570,
 980716276,
 4921,
 -50569,
 980771087,
 4926,
 -1,
 980828033,
 4922,
 981023361,
 980367688,
 -1,
 981088891,
 980953367,
 4901,
 -1,
 981018903,
 4900,
 981219965,
 981011069,
 4896,
 -1,
 981142141,
 4899,
 -50562,
 981177590,
 4903,
 -50561,
 981306100,
 4897,
 -50560,
 981360911,
 4902,
 -1,
 981417857,
 4898,
 981613193,
 980982734,
 -1,
 981678724,
 981543191,
 4933,
 -1,
 981608727,
 4932,
 981809798,
 981600893,
 4928,
 -1,
 981731965,
 4931,
 -50553,
 981764852,
 4929,
 -50552,
 981885199,
 4934,
 -1,
 981942145,
 4930,
 982137483,
 981543191,
 4725,
 -1,
 982067479,
 4724,
 982268557,
 982059645,
 4720,
 -1,
 982190717,
 4723,
 -50546,
 982226166,
 4727,
 -50545,
 982354676,
 4721,
 -50544,
 982409487,
 4726,
 -1,
 982466433,
 4722,
 982661808,
 980301207,
 -1,
 982727323,
 982602704,
 -1,
 982792853,
 982657303,
 4773,
 -1,
 982722839,
 4772,
 982923927,
 982715005,
 4768,
 -1,
 982846077,
 4771,
 -50536,
 982881526,
 4775,
 -50535,
 983010036,
 4769,
 -50534,
 983064847,
 4774,
 -1,
 983121793,
 4770,
 983317155,
 982660503,
 -1,
 983382686,
 983247127,
 4893,
 -1,
 983312663,
 4892,
 983513760,
 983304829,
 4888,
 -1,
 983435901,
 4891,
 -50527,
 983468788,
 4889,
 -50526,
 983589135,
 4894,
 -1,
 983646081,
 4890,
 983841449,
 983274719,
 -1,
 983906982,
 983771415,
 4885,
 -1,
 983836951,
 4884,
 984038056,
 983829117,
 4880,
 -1,
 983960189,
 4883,
 -1,
 983973761,
 4882,
 984234667,
 983771415,
 4877,
 -1,
 984164631,
 4876,
 984365741,
 984156797,
 4872,
 -1,
 984287869,
 4875,
 -50514,
 984320756,
 4873,
 -50513,
 984441103,
 4878,
 -1,
 984498049,
 4874,
 984693451,
 982612619,
 -1,
 984758970,
 984652750,
 -1,
 984824500,
 984688919,
 4645,
 -1,
 984754455,
 4644,
 984955574,
 984746621,
 4640,
 -1,
 984877693,
 4643,
 -50505,
 984913142,
 4647,
 -50504,
 985041652,
 4641,
 -50503,
 985096463,
 4646,
 -1,
 985153409,
 4642,
 985348803,
 984693064,
 -1,
 985414333,
 985278743,
 4669,
 -1,
 985344279,
 4668,
 985545407,
 985336445,
 4664,
 -1,
 985467517,
 4667,
 -50496,
 985502966,
 4671,
 -50495,
 985631476,
 4665,
 -50494,
 985686287,
 4670,
 -1,
 985743233,
 4666,
 985938629,
 985278743,
 4661,
 -1,
 985868567,
 4660,
 986069703,
 985860733,
 4656,
 -1,
 985991805,
 4659,
 -50488,
 986027254,
 4663,
 -50487,
 986155764,
 4657,
 -50486,
 986210575,
 4662,
 -1,
 986267521,
 4658,
 986462951,
 984641226,
 -1,
 986528474,
 986397000,
 -1,
 986594003,
 986485983,
 -1,
 986659536,
 986523927,
 4701,
 -1,
 986589463,
 4700,
 986790610,
 986581629,
 4696,
 -1,
 986712701,
 4699,
 -1,
 986726273,
 4698,
 986987221,
 986523927,
 4693,
 -1,
 986917143,
 4692,
 987118295,
 986909309,
 4688,
 -1,
 987040381,
 4691,
 -50472,
 987073268,
 4689,
 -50471,
 987193615,
 4694,
 -1,
 987250561,
 4690,
 987445984,
 986485983,
 -1,
 987511517,
 987375895,
 4685,
 -1,
 987441431,
 4684,
 987642591,
 987433597,
 4680,
 -1,
 987564669,
 4683,
 -1,
 987578241,
 4682,
 987839202,
 987375895,
 4677,
 -1,
 987769111,
 4676,
 987970276,
 987761277,
 4672,
 -1,
 987892349,
 4675,
 -50459,
 987925236,
 4673,
 -50458,
 988045583,
 4678,
 -1,
 988102529,
 4674,
 988297987,
 986401187,
 -1,
 988363510,
 988256549,
 -1,
 988429039,
 988320991,
 -1,
 988494572,
 988358935,
 4805,
 -1,
 988424471,
 4804,
 988625646,
 988416637,
 4800,
 -1,
 988547709,
 4803,
 -1,
 988561281,
 4802,
 988822257,
 988358935,
 4797,
 -1,
 988752151,
 4796,
 988953331,
 988744317,
 4792,
 -1,
 988875389,
 4795,
 -50444,
 988908276,
 4793,
 -50443,
 989028623,
 4798,
 -1,
 989085569,
 4794,
 989281020,
 988320991,
 -1,
 989346553,
 989210903,
 4789,
 -1,
 989276439,
 4788,
 989477627,
 989268605,
 4784,
 -1,
 989399677,
 4787,
 -1,
 989413249,
 4786,
 989674238,
 989210903,
 4781,
 -1,
 989604119,
 4780,
 989805312,
 989596285,
 4776,
 -1,
 989727357,
 4779,
 -50431,
 989760244,
 4777,
 -50430,
 989880591,
 4782,
 -1,
 989937537,
 4778,
 990133021,
 988244501,
 -1,
 990198549,
 990067016,
 -1,
 990264079,
 990120573,
 4912,
 990329614,
 990214786,
 -1,
 990395145,
 990259479,
 4821,
 -1,
 990325015,
 4820,
 990526219,
 990317181,
 4816,
 -1,
 990448253,
 4819,
 -50420,
 990481140,
 4817,
 -50419,
 990601487,
 4822,
 -1,
 990658433,
 4818,
 -1,
 990251645,
 4915,
 990919441,
 990193943,
 4917,
 -1,
 990849303,
 4916,
 -50414,
 990876918,
 4919,
 -50413,
 991005428,
 4913,
 -50412,
 991060239,
 4918,
 -1,
 991117185,
 4914,
 991312663,
 990128407,
 4949,
 -1,
 991242519,
 4948,
 991443737,
 991234685,
 4944,
 -1,
 991365757,
 4947,
 -50406,
 991401206,
 4951,
 -50405,
 991529716,
 4945,
 -50404,
 991584527,
 4950,
 -1,
 991641473,
 4946,
 991836975,
 990092238,
 -1,
 991902503,
 991770952,
 -1,
 991968033,
 991832343,
 4837,
 -1,
 991897879,
 4836,
 992099107,
 991890045,
 4832,
 -1,
 992021117,
 4835,
 -50396,
 992056566,
 4839,
 -50395,
 992185076,
 4833,
 -50394,
 992239887,
 4838,
 -1,
 992296833,
 4834,
 992492329,
 991832343,
 4829,
 -1,
 992422167,
 4828,
 992623403,
 992414333,
 4824,
 -1,
 992545405,
 4827,
 -50388,
 992580854,
 4831,
 -50387,
 992709364,
 4825,
 -50386,
 992764175,
 4830,
 -1,
 992821121,
 4826,
 993016641,
 991779490,
 -1,
 993082169,
 992975315,
 -1,
 993147699,
 993011991,
 4765,
 -1,
 993077527,
 4764,
 993278773,
 993069693,
 4760,
 -1,
 993200765,
 4763,
 -50378,
 993236214,
 4767,
 -50377,
 993364724,
 4761,
 -50376,
 993419535,
 4766,
 -1,
 993476481,
 4762,
 993671995,
 993011991,
 4757,
 -1,
 993601815,
 4756,
 993803069,
 993593981,
 4752,
 -1,
 993725053,
 4755,
 -50370,
 993760502,
 4759,
 -50369,
 993889012,
 4753,
 -50368,
 993943823,
 4758,
 -1,
 994000769,
 4754,
 994196307,
 992944514,
 -1,
 994261835,
 994124162,
 -1,
 994327365,
 994191639,
 4861,
 -1,
 994257175,
 4860,
 994458439,
 994249341,
 4856,
 -1,
 994380413,
 4859,
 -50360,
 994415862,
 4863,
 -50359,
 994544372,
 4857,
 -50358,
 994599183,
 4862,
 -1,
 994656129,
 4858,
 994851661,
 994191639,
 4853,
 -1,
 994781463,
 4852,
 994982735,
 994773629,
 4848,
 -1,
 994904701,
 4851,
 -50352,
 994940150,
 4855,
 -50351,
 995068660,
 4849,
 -50350,
 995123471,
 4854,
 -1,
 995180417,
 4850,
 995375973,
 994122570,
 -1,
 995441501,
 995309896,
 -1,
 995507031,
 995371287,
 4909,
 -1,
 995436823,
 4908,
 995638105,
 995428989,
 4904,
 -1,
 995560061,
 4907,
 -50342,
 995595510,
 4911,
 -50341,
 995724020,
 4905,
 -50340,
 995778831,
 4910,
 -1,
 995835777,
 4906,
 996031327,
 995371287,
 4733,
 -1,
 995961111,
 4732,
 996162401,
 995953277,
 4728,
 -1,
 996084349,
 4731,
 -50334,
 996119798,
 4735,
 -50333,
 996248308,
 4729,
 -50332,
 996303119,
 4734,
 -1,
 996360065,
 4730,
 996555638,
 995309896,
 -1,
 996621167,
 996489544,
 -1,
 996686697,
 996550935,
 4629,
 -1,
 996616471,
 4628,
 996817771,
 996608637,
 4624,
 -1,
 996739709,
 4627,
 -50324,
 996775158,
 4631,
 -50323,
 996903668,
 4625,
 -50322,
 996958479,
 4630,
 -1,
 997015425,
 4626,
 997210993,
 996550935,
 4613,
 -1,
 997140759,
 4612,
 997342067,
 997132925,
 4608,
 -1,
 997263997,
 4611,
 -50316,
 997296884,
 4609,
 -50315,
 997417231,
 4614,
 -1,
 997474177,
 4610,
 997669764,
 996514085,
 -1,
 997735293,
 997627103,
 -1,
 997800826,
 997665047,
 4749,
 -1,
 997730583,
 4748,
 997931900,
 997722749,
 4744,
 -1,
 997853821,
 4747,
 -1,
 997867393,
 4746,
 998128511,
 997665047,
 4741,
 -1,
 998058263,
 4740,
 998259585,
 998050429,
 4736,
 -1,
 998181501,
 4739,
 -50302,
 998214388,
 4737,
 -50301,
 998334735,
 4742,
 -1,
 998391681,
 4738,
 998587278,
 997617777,
 -1,
 998652807,
 998517015,
 4653,
 -1,
 998582551,
 4652,
 998783881,
 998574717,
 4648,
 -1,
 998705789,
 4651,
 -50294,
 998742506,
 4952,
 -50293,
 998872310,
 4655,
 -50292,
 998935284,
 4649,
 -50291,
 998990095,
 4654,
 -1,
 999047041,
 4650,
 999242648,
 998528303,
 -1,
 999308177,
 999172375,
 4637,
 -1,
 999237911,
 4636,
 999439251,
 999230077,
 4632,
 -1,
 999361149,
 4635,
 -50284,
 999397866,
 4953,
 -50283,
 999527670,
 4639,
 -50282,
 999590644,
 4633,
 -50281,
 999645455,
 4638,
 -1,
 999702401,
 4634,
 999898018,
 999174848,
 -1,
 999963547,
 999827735,
 4941,
 -1,
 999893271,
 4940,
 1000094621,
 999885437,
 4936,
 -1,
 1000016509,
 4939,
 -50274,
 1000053226,
 4954,
 -50273,
 1000183030,
 4943,
 -50272,
 1000246004,
 4937,
 -50271,
 1000300815,
 4942,
 -1,
 1000357761,
 4938,
 1000553387,
 999854458,
 -1,
 1000618917,
 1000483095,
 4717,
 -1,
 1000548631,
 4716,
 1000749991,
 1000540797,
 4712,
 -1,
 1000671869,
 4715,
 -50264,
 1000707318,
 4719,
 -50263,
 1000835828,
 4713,
 -50262,
 1000890639,
 4718,
 -1,
 1000947585,
 4714,
 1001143220,
 1000491853,
 -1,
 1001208750,
 1001072919,
 4621,
 -1,
 1001138455,
 4620,
 1001339824,
 1001130621,
 4616,
 -1,
 1001261693,
 4619,
 -50255,
 1001297142,
 4623,
 -50254,
 1001425652,
 4617,
 -50253,
 1001480463,
 4622,
 -1,
 1001537409,
 4618,
 1001733053,
 1001081005,
 -1,
 1001798583,
 1001662743,
 4869,
 -1,
 1001728279,
 4868,
 1001929657,
 1001720445,
 4864,
 -1,
 1001851517,
 4867,
 -50246,
 1001886966,
 4871,
 -50245,
 1002015476,
 4865,
 -50244,
 1002070287,
 4870,
 -1,
 1002127233,
 4866,
 1002322886,
 1001658019,
 -1,
 1002388416,
 1002252567,
 4709,
 -1,
 1002318103,
 4708,
 1002519490,
 1002310269,
 4704,
 -1,
 1002441341,
 4707,
 -50237,
 1002476790,
 4711,
 -50236,
 1002605300,
 4705,
 -50235,
 1002660111,
 4710,
 -1,
 1002717057,
 4706,
 1002912718,
 1002281427,
 -1,
 1002978249,
 1002842391,
 4845,
 -1,
 1002907927,
 4844,
 1003109323,
 1002900093,
 4840,
 -1,
 1003031165,
 4843,
 -50228,
 1003064052,
 4841,
 -50227,
 1003184399,
 4846,
 -1,
 1003241345,
 4842,
 1003487231,
 1002869983,
 -1,
 1003502545,
 1003366679,
 4813,
 -1,
 1003432215,
 4812,
 1003633619,
 1003424381,
 4808,
 -1,
 1003555453,
 4811,
 -50220,
 1003588340,
 4809,
 -50219,
 1003708687,
 4814,
 -1,
 1003765633,
 4810,
 -1,
 980233647,
 4964,
 1004026854,
 980181018,
 -1,
 1004092381,
 1003979404,
 -1,
 1004157915,
 1004023304,
 4978,
 -1,
 1004078511,
 4988,
 -50212,
 1004115453,
 4979,
 -1,
 1004223760,
 4980,
 1004420064,
 1004042891,
 -1,
 -50209,
 1004357787,
 4983,
 -1,
 1004417520,
 4984,
 1004616675,
 1004352192,
 -1,
 -50206,
 1004562085,
 4981,
 -1,
 1004618144,
 4982,
 -50204,
 1004559725,
 4986,
 -50203,
 1004748570,
 4987,
 -1,
 1004809431,
 4985,
 1005009907,
 1003955222,
 -1,
 1005075434,
 1004962444,
 -1,
 -50199,
 1005033625,
 4970,
 -1,
 1005076131,
 4971,
 1005272045,
 1005025931,
 -1,
 -50196,
 1005209745,
 4974,
 -1,
 1005269455,
 4975,
 1005468656,
 1005204160,
 -1,
 -50193,
 1005414397,
 4972,
 -1,
 1005471810,
 4973,
 -50191,
 1005413306,
 4969,
 -50190,
 1005608268,
 4977,
 -1,
 1005661338,
 4976,
 1005861878,
 1004956181,
 -1,
 -50187,
 1005810282,
 4966,
 -1,
 1005851378,
 4968,
 1006058489,
 1005788908,
 -1,
 -50184,
 1006000407,
 4963,
 -1,
 1006064396,
 4965,
 -50182,
 1006016782,
 4961,
 -50181,
 1006202887,
 4967,
 -1,
 1006253434,
 4962,
 1006451740,
 980119339,
 -1,
 1006517271,
 1006374272,
 -1,
 1006582798,
 1006467725,
 -1,
 1006648332,
 1006534183,
 61,
 1006764031,
 1006567424,
 -1,
 1006779400,
 1006635645,
 -1,
 1006844934,
 1006705200,
 -1,
 -50172,
 1006798508,
 10867,
 -50171,
 1006859740,
 10609,
 -1,
 1006923068,
 10865,
 1007157247,
 1006787582,
 10723,
 -1,
 1007028165,
 10724,
 1007288319,
 1006737105,
 -1,
 -50166,
 1007192663,
 10871,
 -50165,
 1007232353,
 10854,
 -1,
 1007295188,
 10926,
 -50163,
 1006606039,
 10862,
 -1,
 1007427311,
 8789,
 1007681535,
 1006501888,
 -1,
 1007696918,
 1007585106,
 -1,
 1007762453,
 1007641890,
 -1,
 -50158,
 1007714740,
 8927,
 -50157,
 1007775272,
 8926,
 -50156,
 1007833031,
 8924,
 -1,
 1007892468,
 8925,
 -1,
 1007688483,
 8797,
 -1,
 1007620244,
 8917,
 1008271359,
 1006452609,
 -1,
 1008286747,
 1008177562,
 -1,
 -50150,
 1008244553,
 10872,
 -1,
 1008305999,
 8781,
 -1,
 1008210249,
 8794,
 1008548912,
 1006410021,
 -1,
 1008614443,
 1008501830,
 -1,
 1008679969,
 1008566924,
 -1,
 -50144,
 1008638105,
 1778,
 -1,
 1008680611,
 1779,
 1008876580,
 1008630411,
 -1,
 -50141,
 1008814225,
 1782,
 -1,
 1008873935,
 1783,
 1009073191,
 1008808640,
 -1,
 -50138,
 1009018877,
 1780,
 -1,
 1009076290,
 1781,
 -50136,
 1009032222,
 1776,
 -50135,
 1009214394,
 1777,
 -50134,
 1009278284,
 1785,
 -1,
 1009331354,
 1784,
 1009582079,
 1008540490,
 -1,
 1009597487,
 1009470527,
 -1,
 -50130,
 1009545223,
 8265,
 -1,
 1009604267,
 33,
 -1,
 1009529015,
 8761,
 1009859646,
 1008487773,
 -1,
 1009925181,
 1009801150,
 8712,
 1010040831,
 1009844224,
 -1,
 1010056250,
 1009948369,
 -1,
 -50123,
 1010012941,
 8947,
 -50122,
 1010077015,
 8952,
 -50121,
 1010141817,
 8953,
 -50120,
 1010198776,
 8950,
 -50119,
 1010258731,
 8946,
 -1,
 1010312535,
 8949,
 1010565119,
 1010001134,
 -1,
 -50116,
 1010470843,
 10194,
 -1,
 1010509853,
 10969,
 -1,
 1009852627,
 8961,
 1010777163,
 1009800495,
 -1,
 1010842695,
 1010723349,
 -1,
 1010908230,
 1010797270,
 8709,
 1011023871,
 1010828799,
 -1,
 -50109,
 1010925400,
 10674,
 -50108,
 1010988073,
 10675,
 -50107,
 1011050744,
 10673,
 -1,
 1011109278,
 10676,
 -1,
 1010842384,
 9091,
 1011417087,
 1010761728,
 -1,
 -50103,
 1011318805,
 8195,
 -50102,
 1011380018,
 8193,
 -1,
 1011425822,
 8212,
 1011629144,
 1010724977,
 -1,
 1011694677,
 1011578997,
 -1,
 1011760209,
 1011652123,
 -1,
 -50097,
 1011712077,
 10734,
 -50096,
 1011753914,
 10736,
 -1,
 1011817919,
 10738,
 1012072447,
 1011685681,
 -1,
 -50093,
 1011974221,
 10735,
 -50092,
 1012016058,
 10737,
 -1,
 1012080063,
 10739,
 1012334591,
 1011618995,
 -1,
 -50089,
 1012233171,
 8998,
 -1,
 1012288884,
 9003,
 1012481123,
 1011565058,
 -1,
 1012546658,
 1012400128,
 -1,
 1012612192,
 1012492821,
 -1,
 1012677727,
 1012556376,
 -1,
 -50083,
 1012625951,
 10039,
 -50082,
 1012690145,
 10037,
 -1,
 1012734302,
 10036,
 -1,
 1012609350,
 10049,
 -50079,
 1012564931,
 10058,
 -1,
 1012957238,
 10035,
 -1,
 1012480333,
 9834,
 1013202027,
 1012423330,
 -1,
 1013267560,
 1013121024,
 -1,
 -50074,
 1013219349,
 8194,
 -50073,
 1013280562,
 8192,
 -1,
 1013326366,
 8211,
 -50071,
 1013224023,
 9993,
 -50070,
 1013482607,
 9094,
 -1,
 1013522843,
 8718,
 1013726320,
 1013156596,
 -1,
 1013791855,
 1013676060,
 -1,
 -50066,
 1013712972,
 8352,
 -1,
 1013777718,
 8364,
 -1,
 1013731258,
 8455,
 1014054003,
 1013678397,
 -1,
 -50062,
 1014004363,
 8793,
 -1,
 1014047151,
 8494,
 1014300671,
 1013975677,
 -1,
 -50059,
 1014202608,
 9841,
 -1,
 1014266409,
 9793,
 1014447770,
 980033922,
 -1,
 1014513026,
 1014376727,
 -1,
 1014578442,
 1014469026,
 -1,
 1014643921,
 1014517828,
 -1,
 1014709377,
 1014600058,
 -1,
 1014774912,
 1014653320,
 -1,
 1014840446,
 1014722673,
 2315,
 -1,
 1014788209,
 2400,
 1015021567,
 1014778701,
 2316,
 -1,
 1014909773,
 2401,
 -1,
 1014696573,
 2357,
 1015168137,
 1014659723,
 -1,
 1015233671,
 1015101768,
 -1,
 1015299206,
 1015178844,
 -1,
 -50043,
 1015243023,
 2322,
 -1,
 1015294231,
 2318,
 -1,
 1015220861,
 2358,
 -50040,
 1015184074,
 2359,
 -1,
 1015483005,
 2360,
 1015692432,
 1015110306,
 -1,
 1015757965,
 1015634594,
 -1,
 -50036,
 1015700194,
 2345,
 -1,
 1015745149,
 2339,
 -50034,
 1015716330,
 2334,
 -50033,
 1015887260,
 2329,
 -1,
 1015941757,
 2344,
 1016151191,
 1015619970,
 -1,
 1016216725,
 1016078722,
 -1,
 -50029,
 1016150370,
 2338,
 -50028,
 1016210246,
 2396,
 -1,
 1016269437,
 2337,
 -50026,
 1016150370,
 2343,
 -1,
 1016400509,
 2342,
 1016609949,
 1016103564,
 -1,
 1016675483,
 1016562316,
 -1,
 -50022,
 1016609122,
 2336,
 -1,
 1016662653,
 2335,
 -50020,
 1016609122,
 2341,
 -1,
 1016793725,
 2340,
 1017003171,
 1016535882,
 -1,
 1017068706,
 1016924797,
 2330,
 1017184255,
 1017011262,
 -1,
 -50015,
 1017078031,
 2321,
 -1,
 1017129239,
 2317,
 -1,
 1017002338,
 2331,
 1017396391,
 1016924797,
 2309,
 -50011,
 1017350900,
 2324,
 -50010,
 1017397121,
 2320,
 -1,
 1017449085,
 2310,
 1017658539,
 1017344113,
 -1,
 -50007,
 1017606293,
 2353,
 -50006,
 1017657698,
 2397,
 -1,
 1017711229,
 2352,
 1017920688,
 1017596749,
 -1,
 1017986223,
 1017858893,
 -1,
 -50002,
 1017924492,
 2356,
 -1,
 1017973373,
 2355,
 -1,
 1017907837,
 2354,
 1018248373,
 1017858467,
 -1,
 1018313908,
 1018181960,
 -1,
 -49997,
 1018247522,
 2393,
 -1,
 1018301053,
 2326,
 -1,
 1018235517,
 2325,
 1018576058,
 1018181015,
 -1,
 1018641593,
 1018509640,
 -1,
 -49992,
 1018575202,
 2394,
 -1,
 1018628733,
 2328,
 -1,
 1018563197,
 2327,
 1018903741,
 1018534355,
 -1,
 -49988,
 1018862058,
 2399,
 -1,
 1018890877,
 2351,
 1019100351,
 1018858228,
 2313,
 -1,
 1019054836,
 2314,
 1019231426,
 1019046421,
 -1,
 -49983,
 1019165026,
 2347,
 -1,
 1019218557,
 2346,
 1019428037,
 1019168941,
 -1,
 -49980,
 1019361634,
 2333,
 -1,
 1019415165,
 2332,
 1019624647,
 1019363201,
 2311,
 -1,
 1019559809,
 2312,
 1019755722,
 1019549347,
 -1,
 -49975,
 1019689314,
 2349,
 -1,
 1019742845,
 2348,
 -49973,
 1019714522,
 2395,
 -49972,
 1019899596,
 2392,
 -49971,
 1019961615,
 2323,
 -49970,
 1020024120,
 2350,
 -49969,
 1020082530,
 2361,
 -49968,
 1020146406,
 2398,
 -1,
 1020209431,
 2319,
 1020411111,
 1014600897,
 -1,
 1020476631,
 1020367979,
 -1,
 1020542165,
 1020424305,
 2371,
 -1,
 1020489841,
 2372,
 1020723199,
 1020480333,
 2402,
 -1,
 1020611405,
 2403,
 1020804315,
 1020398205,
 -1,
 -49959,
 1020758772,
 2380,
 -49958,
 1020804993,
 2376,
 -1,
 1020856957,
 2366,
 1021066461,
 1020758772,
 2369,
 -1,
 1021020916,
 2370,
 1021197536,
 1021017457,
 -1,
 -49953,
 1021141263,
 2378,
 -1,
 1021192471,
 2374,
 1021394146,
 1021132673,
 2367,
 -1,
 1021329281,
 2368,
 1021525221,
 1021320137,
 -1,
 -49948,
 1021468943,
 2377,
 -1,
 1021520151,
 2373,
 -49946,
 1021468943,
 2379,
 -1,
 1021651223,
 2375,
 1021852920,
 1020338562,
 -1,
 1021918454,
 1021788793,
 -1,
 1021983980,
 1021870732,
 -1,
 -49941,
 1021941913,
 2408,
 -1,
 1021984419,
 2409,
 1022180591,
 1021934219,
 -1,
 -49938,
 1022118033,
 2412,
 -1,
 1022177743,
 2413,
 1022377202,
 1022112448,
 -1,
 -49935,
 1022322685,
 2410,
 -1,
 1022380098,
 2411,
 -49933,
 1022336030,
 2406,
 -49932,
 1022518202,
 2407,
 -49931,
 1022582092,
 2415,
 -1,
 1022635162,
 2414,
 -49929,
 1021863862,
 2405,
 -1,
 1022759118,
 2404,
 1022967045,
 1021803147,
 -1,
 1023032578,
 1022902920,
 -1,
 1023098109,
 1022989295,
 -1,
 -49924,
 1023048519,
 2307,
 -1,
 1023111436,
 2381,
 1023294720,
 1023019645,
 -1,
 -49921,
 1023250821,
 2365,
 -1,
 1023303809,
 2306,
 -49919,
 1023238164,
 2364,
 -1,
 1023417297,
 2305,
 1023672319,
 1022986343,
 -1,
 -49916,
 1023577018,
 2385,
 -1,
 1023611360,
 2386,
 1023819016,
 1022888573,
 -1,
 -49913,
 1023746405,
 2388,
 -1,
 1023809441,
 2416,
 -49911,
 1023763190,
 2384,
 -1,
 1023948775,
 2387,
 1024146789,
 1014528651,
 -1,
 1024212324,
 1024077809,
 -1,
 1024277816,
 1024163711,
 -1,
 1024343319,
 1024207127,
 -1,
 1024408848,
 1024293515,
 66629,
 -1,
 1024342344,
 66631,
 1024539922,
 1024350882,
 66636,
 -1,
 1024472471,
 66637,
 -49901,
 1024492809,
 66627,
 -49900,
 1024618609,
 66633,
 -49899,
 1024677167,
 66635,
 -49898,
 1024740173,
 66634,
 -1,
 1024799424,
 66625,
 1024998686,
 1024294257,
 -1,
 1025064218,
 1024942351,
 66610,
 -1,
 1025007887,
 66611,
 1025195292,
 1024985725,
 66608,
 -1,
 1025128776,
 66609,
 -49891,
 1025130369,
 66606,
 -1,
 1025255703,
 66607,
 1025457445,
 1024938780,
 -1,
 1025522977,
 1025401103,
 66604,
 -1,
 1025466639,
 66605,
 1025654051,
 1025444477,
 66602,
 -1,
 1025587528,
 66603,
 -49884,
 1025589121,
 66600,
 -1,
 1025714455,
 66601,
 1025916200,
 1025416142,
 -1,
 -49881,
 1025850341,
 66632,
 -1,
 1025911506,
 66630,
 1026112811,
 1025868428,
 -1,
 -49878,
 1026046949,
 66628,
 -1,
 1026108114,
 66619,
 -49876,
 1026071086,
 66615,
 -49875,
 1026267421,
 66614,
 -49874,
 1026331201,
 66626,
 -49873,
 1026386781,
 66617,
 -49872,
 1026451771,
 66613,
 -49871,
 1026509355,
 66623,
 -49870,
 1026574591,
 66622,
 -49869,
 1026636104,
 66616,
 -49868,
 1026700799,
 66624,
 -49867,
 1026761354,
 66620,
 -49866,
 1026825537,
 66621,
 -49865,
 1026889666,
 66618,
 -1,
 1026954865,
 66612,
 1027211263,
 1024203828,
 -1,
 1027226947,
 1027090711,
 -1,
 1027292476,
 1027177099,
 66589,
 -1,
 1027225928,
 66591,
 1027423550,
 1027234466,
 66596,
 -1,
 1027356055,
 66597,
 -49857,
 1027376393,
 66587,
 -49856,
 1027502193,
 66593,
 -49855,
 1027560751,
 66595,
 -49854,
 1027623757,
 66594,
 -1,
 1027683008,
 66585,
 1027882314,
 1027177841,
 -1,
 1027947846,
 1027825935,
 66570,
 -1,
 1027891471,
 66571,
 1028078920,
 1027869309,
 66568,
 -1,
 1028012360,
 66569,
 -49847,
 1028013953,
 66566,
 -1,
 1028139287,
 66567,
 1028341073,
 1027822364,
 -1,
 1028406605,
 1028284687,
 66564,
 -1,
 1028350223,
 66565,
 1028537679,
 1028328061,
 66562,
 -1,
 1028471112,
 66563,
 -49840,
 1028472705,
 66560,
 -1,
 1028598039,
 66561,
 1028799828,
 1028299726,
 -1,
 -49837,
 1028733925,
 66592,
 -1,
 1028795090,
 66590,
 1028996439,
 1028752012,
 -1,
 -49834,
 1028930533,
 66588,
 -1,
 1028991698,
 66579,
 -49832,
 1028954670,
 66575,
 -49831,
 1029151005,
 66574,
 -49830,
 1029214785,
 66586,
 -49829,
 1029270365,
 66577,
 -49828,
 1029335355,
 66573,
 -49827,
 1029392939,
 66583,
 -49826,
 1029458175,
 66582,
 -49825,
 1029519688,
 66576,
 -49824,
 1029584383,
 66584,
 -49823,
 1029644938,
 66580,
 -49822,
 1029709121,
 66581,
 -49821,
 1029773250,
 66578,
 -1,
 1029838449,
 66572,
 -1,
 1024138424,
 9739,
 1030110588,
 1024090054,
 -1,
 1030176114,
 1030066920,
 -1,
 1030241647,
 1030098978,
 -1,
 1030307179,
 1030195156,
 -1,
 -49814,
 1030255571,
 9150,
 -1,
 1030311284,
 9163,
 1030503790,
 1030232537,
 -1,
 -49811,
 1030452179,
 9151,
 -1,
 1030507892,
 9164,
 -1,
 1030460835,
 9158,
 1030815743,
 1030198993,
 -1,
 -49807,
 1030719623,
 9155,
 -1,
 1030757823,
 9152,
 1030962551,
 1030131169,
 9162,
 1031077887,
 1030882815,
 -1,
 -49803,
 1030985123,
 9160,
 -49802,
 1031047303,
 9157,
 -1,
 1031085503,
 9154,
 1031340031,
 1030891334,
 9161,
 1031405567,
 1031210495,
 -1,
 -49798,
 1031312803,
 9159,
 -49797,
 1031374983,
 9156,
 -1,
 1031413183,
 9153,
 1031617920,
 1030043801,
 -1,
 -49794,
 1031568935,
 176,
 -49793,
 1031615215,
 8457,
 -1,
 1031675056,
 8451,
 -49791,
 1031558294,
 8796,
 -1,
 1031806372,
 9110,
 1032011313,
 1014456591,
 -1,
 1032076777,
 1031965501,
 -1,
 1032142281,
 1031995392,
 -1,
 1032207766,
 1032067914,
 -1,
 1032273301,
 1032144584,
 -1,
 1032338836,
 1032201238,
 -1,
 1032404363,
 1032290956,
 -1,
 -49782,
 1032362137,
 9462,
 -1,
 1032404643,
 9463,
 1032600974,
 1032354443,
 -1,
 -49779,
 1032538257,
 9466,
 -1,
 1032597967,
 9467,
 1032797585,
 1032532672,
 -1,
 -49776,
 1032742909,
 9464,
 -1,
 1032800322,
 9465,
 -49774,
 1032741818,
 9461,
 -49773,
 1032936780,
 9469,
 -1,
 1032989850,
 9468,
 -1,
 1032282158,
 9470,
 -1,
 1032217308,
 10868,
 1033321888,
 1032157835,
 -1,
 1033387419,
 1033276148,
 -1,
 -49767,
 1033333804,
 8913,
 -49766,
 1033378938,
 10940,
 -1,
 1033444011,
 8912,
 1033649566,
 1033334671,
 -1,
 -49763,
 1033604473,
 10831,
 -1,
 1033651553,
 10830,
 -49761,
 1033603394,
 10988,
 -1,
 1033790121,
 11005,
 1033977257,
 1033259853,
 -1,
 1034042792,
 1033920783,
 -1,
 1034108325,
 1033999583,
 -1,
 -49756,
 1034029044,
 8222,
 -1,
 1034093446,
 8215,
 1034354687,
 1034041052,
 -1,
 -49753,
 1034249503,
 10836,
 -1,
 1034293278,
 10835,
 -1,
 1033972534,
 10645,
 1034567088,
 1033933544,
 -1,
 1034632623,
 1034491670,
 -1,
 1034698158,
 1034560971,
 -1,
 -49747,
 1034646941,
 8875,
 -1,
 1034702565,
 10981,
 -1,
 1034637029,
 10979,
 -1,
 1034572091,
 8214,
 1035025846,
 1034512917,
 -1,
 1035091381,
 1034973297,
 -1,
 1035156916,
 1035027305,
 8243,
 -1,
 1035076855,
 12318,
 -1,
 1035086357,
 10939,
 -1,
 1035031746,
 10746,
 1035419066,
 1034968206,
 -1,
 1035484601,
 1035358151,
 10913,
 -1,
 1035405283,
 10915,
 -1,
 1035417588,
 10914,
 1035681213,
 1035373300,
 -1,
 -49732,
 1035627059,
 10987,
 -1,
 1035689337,
 8915,
 1035877824,
 1035617554,
 -1,
 -49729,
 1035827685,
 8914,
 -1,
 1035876268,
 8748,
 1036074435,
 1035805058,
 -1,
 -49726,
 1036020210,
 10986,
 -1,
 1036061908,
 8225,
 -49724,
 1036031437,
 65100,
 -49723,
 1036219392,
 10646,
 -49722,
 1036283911,
 8263,
 -49721,
 1036336300,
 8223,
 -49720,
 1036399213,
 8252,
 -1,
 1036454937,
 733,
 1036713983,
 1032062962,
 -1,
 1036729822,
 1036616090,
 -1,
 1036795349,
 1036655610,
 -1,
 1036860878,
 1036741141,
 8473,
 -1,
 1036795777,
 8511,
 -49713,
 1036819406,
 8484,
 -49712,
 1036939377,
 8477,
 -49711,
 1037004490,
 8474,
 -49710,
 1037064866,
 8469,
 -49709,
 1037121864,
 8461,
 -49708,
 1037186492,
 8510,
 -1,
 1037245258,
 8450,
 1037450716,
 1036732338,
 -1,
 1037516251,
 1037401924,
 -1,
 -49704,
 1037453485,
 8521,
 -49703,
 1037516673,
 8520,
 -49702,
 1037576471,
 8519,
 -1,
 1037640066,
 8518,
 -1,
 1037442051,
 8517,
 -49699,
 1037401963,
 8509,
 -1,
 1037851337,
 8512,
 1038040552,
 1036669248,
 -1,
 1038106085,
 1037991707,
 -1,
 1038171619,
 1038036846,
 -1,
 -49694,
 1038110663,
 10907,
 -1,
 1038170100,
 10908,
 -49692,
 1038110750,
 11001,
 -1,
 1038301294,
 11002,
 1038548991,
 1038036846,
 -1,
 -49689,
 1038438343,
 10905,
 -1,
 1038497780,
 10906,
 -1,
 1037971033,
 10719,
 1038761496,
 1032034405,
 -1,
 1038827023,
 1038718231,
 -1,
 1038892535,
 1038750735,
 8595,
 1039007743,
 1038811136,
 -1,
 1039023604,
 1038915281,
 -1,
 1039089137,
 1038976793,
 -1,
 -49680,
 1039037905,
 8627,
 -1,
 1039093492,
 8626,
 -49678,
 1039023664,
 10504,
 -49677,
 1039214245,
 8671,
 -1,
 1039278078,
 8629,
 -49675,
 1038976854,
 10515,
 -49674,
 1039421253,
 8693,
 -1,
 1039480106,
 8615,
 1039678981,
 1038826237,
 -1,
 1039744512,
 1039617396,
 -1,
 1039810047,
 1039663104,
 -1,
 1039875581,
 1039734842,
 -1,
 -49668,
 1039831022,
 10607,
 -1,
 1039870038,
 10597,
 -49666,
 1039828822,
 10585,
 -1,
 1040004394,
 10593,
 -1,
 1039766801,
 8643,
 1040318463,
 1039692755,
 -1,
 1040334340,
 1040187392,
 -1,
 -49661,
 1040287574,
 10581,
 -1,
 1040332074,
 10589,
 -1,
 1040291089,
 8642,
 1040596488,
 1039630988,
 -1,
 -49657,
 1040554181,
 8609,
 -1,
 1040611083,
 10507,
 1040793099,
 1040523650,
 -1,
 -49654,
 1040738202,
 8659,
 -1,
 1040782545,
 8675,
 -49652,
 1040751689,
 8623,
 -49651,
 1040946722,
 8681,
 -49650,
 1041002317,
 10225,
 -1,
 1041066588,
 8650,
 1041251861,
 1038745600,
 -1,
 1041317394,
 1041203952,
 8868,
 -1,
 1041237560,
 10993,
 -49645,
 1041265731,
 8945,
 -49644,
 1041380388,
 10623,
 -1,
 1041437766,
 8964,
 1041694719,
 1041172924,
 -1,
 -49641,
 1041593476,
 10729,
 -1,
 1041649116,
 10728,
 1041841702,
 1038692439,
 -1,
 1041907229,
 1041788419,
 -1,
 1041972764,
 1041836559,
 8832,
 -1,
 1041892418,
 8928,
 -1,
 1041918106,
 8876,
 1042169377,
 1041833863,
 -1,
 1042234912,
 1042112079,
 8939,
 -1,
 1042154562,
 8941,
 -1,
 1042175890,
 8716,
 1042431523,
 1042121132,
 8833,
 -1,
 1042351170,
 8929,
 1042562597,
 1042359449,
 8740,
 -1,
 1042483062,
 10990,
 -1,
 1042494649,
 8878,
 1042759215,
 1041793676,
 -1,
 1042824748,
 1042677760,
 -1,
 -49623,
 1042771230,
 8724,
 -49622,
 1042834692,
 8901,
 -49621,
 1042897127,
 8760,
 -1,
 1042942680,
 729,
 1043202047,
 1042777062,
 -1,
 -49618,
 1043084188,
 10649,
 -1,
 1043144127,
 9676,
 -49616,
 1042701493,
 8363,
 -1,
 1043288667,
 36,
 1043480207,
 1031946113,
 -1,
 1043545696,
 1043422401,
 -1,
 1043611217,
 1043487859,
 -1,
 1043676739,
 1043561246,
 -1,
 1043742274,
 1043604502,
 -1,
 1043807801,
 1043694220,
 -1,
 -49608,
 1043765401,
 10123,
 -1,
 1043807907,
 10124,
 1044004412,
 1043757707,
 -1,
 -49605,
 1043941521,
 10127,
 -1,
 1044001231,
 10128,
 1044201023,
 1043935936,
 -1,
 -49602,
 1044146173,
 10125,
 -1,
 1044203586,
 10126,
 -49600,
 1044145082,
 10122,
 -49599,
 1044340044,
 10130,
 -1,
 1044393114,
 10129,
 -1,
 1043685422,
 10131,
 1044659792,
 1043604502,
 -1,
 1044725319,
 1044611724,
 -1,
 -49594,
 1044682905,
 10103,
 -1,
 1044725411,
 10104,
 1044921930,
 1044675211,
 -1,
 -49591,
 1044859025,
 10107,
 -1,
 1044918735,
 10108,
 1045118541,
 1044853440,
 -1,
 -49588,
 1045063677,
 10105,
 -1,
 1045121090,
 10106,
 -49586,
 1045062586,
 10102,
 -49585,
 1045257548,
 10110,
 -1,
 1045310618,
 10109,
 -1,
 1044602926,
 10111,
 1045626879,
 1043537413,
 -1,
 1045642847,
 1045505046,
 -1,
 1045708374,
 1045594764,
 -1,
 -49579,
 1045665945,
 10113,
 -1,
 1045708451,
 10114,
 1045904985,
 1045658251,
 -1,
 -49576,
 1045842065,
 10117,
 -1,
 1045901775,
 10118,
 1046101596,
 1045836480,
 -1,
 -49573,
 1046046717,
 10115,
 -1,
 1046104130,
 10116,
 -49571,
 1046045626,
 10112,
 -49570,
 1046240588,
 10120,
 -1,
 1046293658,
 10119,
 -1,
 1045585966,
 10121,
 1046560375,
 1043478272,
 -1,
 1046625894,
 1046512268,
 -1,
 1046691428,
 1046583449,
 50,
 -1,
 1046610620,
 9353,
 1046872063,
 1046625955,
 51,
 -1,
 1046741692,
 9354,
 1046953579,
 1046575755,
 -1,
 1047019113,
 1046890641,
 54,
 -1,
 1046938300,
 9357,
 1047199743,
 1046950351,
 55,
 -1,
 1047069372,
 9358,
 1047281264,
 1046885056,
 -1,
 1047346798,
 1047226365,
 52,
 -1,
 1047265980,
 9355,
 1047527423,
 1047283778,
 53,
 -1,
 1047397052,
 9356,
 1047608946,
 1047225274,
 49,
 -1,
 1047528124,
 9352,
 1047740020,
 1047551308,
 57,
 -1,
 1047659196,
 9360,
 1047871094,
 1047669914,
 56,
 -1,
 1047790268,
 9359,
 -1,
 1047829534,
 48,
 1048067710,
 1046489372,
 -1,
 -49543,
 1047988831,
 9861,
 -49542,
 1048054354,
 9860,
 -49541,
 1048119877,
 9859,
 -49540,
 1048185400,
 9858,
 -49539,
 1048250920,
 9857,
 -1,
 1048316443,
 9856,
 1048526469,
 1048024047,
 -1,
 1048592004,
 1048477398,
 -1,
 1048657539,
 1048541835,
 -1,
 -49534,
 1048595664,
 8725,
 -1,
 1048658564,
 247,
 -1,
 1048610491,
 8903,
 -1,
 1048519426,
 8739,
 1048985226,
 1048447613,
 -1,
 1049050761,
 1048925487,
 -1,
 -49528,
 1048994733,
 8900,
 -1,
 1049047420,
 8960,
 -1,
 1048981482,
 168,
 -49525,
 1048938928,
 12291,
 -49524,
 1049262991,
 9090,
 -49523,
 1049326043,
 9107,
 -49522,
 1049384874,
 9009,
 -1,
 1049441199,
 8783,
 1049640599,
 1043401341,
 -1,
 1049706132,
 1049591099,
 -1,
 -49518,
 1049659536,
 10143,
 -49517,
 1049717033,
 65097,
 -1,
 1049777139,
 65101,
 -49515,
 1049655209,
 9619,
 -49514,
 1049907252,
 8504,
 -1,
 1049966163,
 8224,
 1050214399,
 1049587861,
 -1,
 -49511,
 1050096960,
 10139,
 -1,
 1050156382,
 8367,
 1050361865,
 1014394993,
 -1,
 1050427221,
 1050296193,
 -1,
 1050492748,
 1050359405,
 -1,
 1050558194,
 1050449175,
 -1,
 1050623675,
 1050481679,
 8594,
 1050689210,
 1050542080,
 -1,
 1050754734,
 1050646225,
 -1,
 1050820261,
 1050706701,
 8611,
 1050935295,
 1050740223,
 -1,
 -49500,
 1050842051,
 10516,
 -1,
 1050879684,
 10517,
 1051082408,
 1050748145,
 -1,
 -49497,
 1051036522,
 8699,
 -1,
 1051101586,
 10513,
 -49495,
 1051038659,
 8696,
 -49494,
 1051230569,
 8603,
 -49493,
 1051290915,
 10565,
 -49492,
 1051349864,
 8620,
 -49491,
 1051409786,
 8618,
 -1,
 1051467757,
 8628,
 1051672243,
 1050706572,
 -1,
 1051737778,
 1051615514,
 -1,
 -49487,
 1051675618,
 10526,
 -1,
 1051726494,
 8677,
 -1,
 1051672301,
 10567,
 1051999927,
 1051593438,
 -1,
 -49483,
 1051952812,
 10612,
 -49482,
 1052016016,
 10562,
 -1,
 1052053287,
 10613,
 1052262073,
 1051931946,
 8614,
 -1,
 1052181961,
 10528,
 -1,
 1052207262,
 8644,
 -1,
 1050610184,
 10522,
 1052524239,
 1050557172,
 -1,
 1052589774,
 1052481253,
 -1,
 1052655303,
 1052544466,
 -1,
 1052720838,
 1052573696,
 -1,
 1052786372,
 1052642014,
 -1,
 1052851907,
 1052724045,
 -1,
 -49470,
 1052795883,
 10604,
 -1,
 1052847095,
 10600,
 -1,
 1052800573,
 10596,
 -49467,
 1052739414,
 10579,
 -1,
 1053046058,
 10587,
 -1,
 1052677393,
 8640,
 1053360127,
 1052583729,
 -1,
 1053376205,
 1053229056,
 -1,
 -49462,
 1053329238,
 10583,
 -49461,
 1053373738,
 10591,
 -49460,
 1053431806,
 10605,
 -1,
 1053494026,
 10601,
 -1,
 1053332753,
 8641,
 -1,
 1052534963,
 8652,
 1053834976,
 1052476044,
 -1,
 1053900509,
 1053792409,
 -1,
 1053966044,
 1053821086,
 -1,
 1054031579,
 1053889557,
 -1,
 1054097114,
 1053988561,
 -1,
 1054162648,
 1054049037,
 10518,
 1054277631,
 1054082559,
 -1,
 -49449,
 1054184387,
 10519,
 -1,
 1054222020,
 10520,
 -49447,
 1054118851,
 10496,
 -1,
 1054353092,
 10497,
 -1,
 1054029098,
 10501,
 -1,
 1053984958,
 10512,
 -1,
 1053885154,
 8608,
 1054801919,
 1053849348,
 -1,
 -49441,
 1054679587,
 10511,
 -1,
 1054741519,
 8667,
 1054949099,
 1053761922,
 -1,
 1055014634,
 1054893959,
 -1,
 1055080169,
 1054938127,
 8658,
 1055145704,
 1054998528,
 -1,
 1055211239,
 1055102673,
 -1,
 -49434,
 1055167427,
 10499,
 -1,
 1055228265,
 8655,
 -1,
 1055143210,
 10503,
 -1,
 1055066632,
 10524,
 -1,
 1055007267,
 10509,
 -1,
 1054938321,
 8674,
 1055669999,
 1054905567,
 -1,
 1055735534,
 1055604002,
 8680,
 -1,
 1055654577,
 8688,
 -1,
 1055659583,
 8605,
 -49424,
 1055621227,
 8669,
 -49423,
 1055877724,
 8649,
 -1,
 1055941852,
 8702,
 1056128831,
 1050476544,
 -1,
 1056194305,
 1056078475,
 -1,
 1056259839,
 1056141218,
 93,
 1056374783,
 1056178176,
 -1,
 1056390908,
 1056282321,
 -1,
 1056456442,
 1056343636,
 -1,
 -49415,
 1056409561,
 10640,
 -1,
 1056446945,
 10638,
 -49413,
 1056410967,
 10636,
 -1,
 1056600105,
 8262,
 -49411,
 1056345842,
 9124,
 -49410,
 1056723993,
 9126,
 -1,
 1056780937,
 9125,
 -49408,
 1056195756,
 8217,
 -1,
 1056910794,
 8908,
 1057111823,
 1056115325,
 -1,
 1057177354,
 1057053896,
 8735,
 1057292287,
 1057095680,
 -1,
 1057308423,
 1057199825,
 -1,
 -49402,
 1057237136,
 9084,
 -1,
 1057297188,
 8894,
 1057505033,
 1057233480,
 12297,
 -1,
 1057425088,
 10642,
 -1,
 1057460658,
 10652,
 1057751039,
 1057124465,
 -1,
 1057767182,
 1057650997,
 -1,
 -49395,
 1057718091,
 8692,
 -1,
 1057758712,
 10228,
 -1,
 1057692523,
 10644,
 1058029337,
 1057068255,
 -1,
 1058094872,
 1057963292,
 -1,
 1058160404,
 1058020170,
 -1,
 -49389,
 1058115619,
 10628,
 -1,
 1058170432,
 12303,
 -49387,
 1058113583,
 12313,
 -49386,
 1058308180,
 12315,
 -49385,
 1058368201,
 10630,
 -1,
 1058426791,
 12311,
 -1,
 1058030043,
 10713,
 1058684705,
 1057954634,
 -1,
 1058750239,
 1058639907,
 125,
 1058865151,
 1058668544,
 -1,
 -49379,
 1058770708,
 9131,
 -49378,
 1058822254,
 9132,
 -1,
 1058886720,
 9133,
 -49376,
 1058694720,
 12301,
 -1,
 1059007710,
 8969,
 1059208998,
 1058636428,
 -1,
 1059274532,
 1059156844,
 8895,
 -1,
 1059192844,
 10702,
 -49371,
 1059219087,
 12309,
 -1,
 1059326945,
 8866,
 1059536683,
 1059154633,
 41,
 1059651583,
 1059454976,
 -1,
 -49367,
 1059557140,
 9118,
 -49366,
 1059607616,
 9120,
 -1,
 1059664521,
 9119,
 1059864369,
 1059464651,
 -1,
 1059929903,
 1059785341,
 -1,
 -49362,
 1059879374,
 10608,
 -1,
 1059937504,
 12299,
 -49360,
 1059886777,
 10715,
 -1,
 1060073536,
 8221,
 1060257588,
 1059807503,
 -1,
 -49357,
 1060213025,
 10198,
 -1,
 1060265059,
 9621,
 1060454199,
 1060190774,
 -1,
 -49354,
 1060397472,
 9616,
 -1,
 1060441061,
 9687,
 1060650810,
 1060385472,
 -1,
 -49351,
 1060590445,
 8971,
 -1,
 1060652913,
 10621,
 1060847421,
 1060575537,
 -1,
 -49348,
 1060800559,
 10648,
 -1,
 1060851623,
 12305,
 -49346,
 1060803406,
 9145,
 -1,
 1060986414,
 8906,
 1061175115,
 1056049138,
 -1,
 1061240644,
 1061128059,
 -1,
 -49342,
 1061185842,
 8238,
 -49341,
 1061246635,
 8207,
 -1,
 1061301641,
 8235,
 1061502792,
 1061186944,
 -1,
 -49338,
 1061430772,
 187,
 -49337,
 1061495114,
 10749,
 -1,
 1061556524,
 9002,
 1061814271,
 1061452427,
 -1,
 -49334,
 1061699764,
 10552,
 -1,
 1061763460,
 10153,
 -1,
 1061108384,
 10813,
 1062027089,
 1050434728,
 -1,
 -49330,
 1061971204,
 8728,
 -49329,
 1062028300,
 8790,
 -49328,
 1062088549,
 8791,
 -1,
 1062144728,
 730,
 1062354772,
 1061977695,
 -1,
 -49325,
 1062305796,
 10544,
 -1,
 1062351616,
 10539,
 -1,
 1062276494,
 65020,
 1062617015,
 1050381044,
 -1,
 1062682549,
 1062559013,
 -1,
 1062748079,
 1062621252,
 -1,
 1062813542,
 1062697611,
 -1,
 1062879075,
 1062747753,
 -1,
 -49317,
 1062837103,
 5863,
 -49316,
 1062898414,
 5840,
 -49315,
 1062961101,
 5836,
 -49314,
 1063020227,
 5805,
 -49313,
 1063082840,
 5823,
 -49312,
 1063146862,
 5849,
 -49311,
 1063205302,
 5821,
 -49310,
 1063262483,
 5843,
 -1,
 1063326373,
 5830,
 -49308,
 1062830914,
 5861,
 -49307,
 1063479782,
 5834,
 -1,
 1063535039,
 5835,
 1063731052,
 1062756623,
 5806,
 -49304,
 1063683360,
 5855,
 -49303,
 1063746233,
 5801,
 -49302,
 1063807902,
 5845,
 -49301,
 1063869090,
 5808,
 -1,
 1063921943,
 5807,
 1064124276,
 1063668557,
 -1,
 1064189811,
 1064068112,
 -1,
 -49297,
 1064147823,
 5862,
 -49296,
 1064199875,
 5804,
 -49295,
 1064260974,
 5848,
 -49294,
 1064319414,
 5820,
 -1,
 1064374954,
 5829,
 -1,
 1064113681,
 5850,
 1064648571,
 1064058753,
 -1,
 1064714103,
 1064590501,
 5853,
 -1,
 1064670692,
 5852,
 -49288,
 1064670696,
 5831,
 -49287,
 1064794977,
 5825,
 -49286,
 1064854815,
 5857,
 -1,
 1064901796,
 5864,
 1065107328,
 1064577303,
 5826,
 -49283,
 1065059593,
 5799,
 -49282,
 1065114789,
 5814,
 -49281,
 1065172832,
 5846,
 -1,
 1065226910,
 5856,
 1065435014,
 1065034114,
 5841,
 1065500549,
 1065379707,
 -1,
 -49277,
 1065445909,
 5844,
 -49276,
 1065507490,
 5824,
 -1,
 1065569101,
 5851,
 -1,
 1065422024,
 5854,
 1065828236,
 1065360202,
 5837,
 1065893770,
 1065756951,
 -1,
 -49271,
 1065835170,
 5811,
 -1,
 1065881095,
 5860,
 -49269,
 1065850371,
 5858,
 -1,
 1066012167,
 5859,
 1066221457,
 1065760151,
 5813,
 1066286992,
 1066150167,
 -1,
 -49265,
 1066233969,
 5828,
 -1,
 1066277293,
 5815,
 -1,
 1066209950,
 5816,
 1066549142,
 1066142333,
 -1,
 -49261,
 1066491674,
 5800,
 -49260,
 1066553520,
 5833,
 -49259,
 1066610793,
 5803,
 -1,
 1066670924,
 5802,
 1066876824,
 1066506707,
 5796,
 -1,
 1066823793,
 5795,
 1067007898,
 1066833119,
 5797,
 -1,
 1066962351,
 5817,
 1067138973,
 1066959500,
 -1,
 -49252,
 1067075706,
 5839,
 -1,
 1067138880,
 5798,
 1067335584,
 1067076134,
 -1,
 -49249,
 1067256445,
 5810,
 -1,
 1067320154,
 5812,
 1067532195,
 1067268450,
 -1,
 -49246,
 1067464463,
 5818,
 -1,
 1067527219,
 5819,
 -49244,
 1067490254,
 5838,
 -49243,
 1067686181,
 5866,
 -49242,
 1067749754,
 5793,
 -49241,
 1067815051,
 5794,
 -49240,
 1067872488,
 5809,
 -49239,
 1067937482,
 5865,
 -49238,
 1068002388,
 5832,
 -49237,
 1068063583,
 5822,
 -49236,
 1068127878,
 5847,
 -49235,
 1068190014,
 5827,
 -49234,
 1068249980,
 5792,
 -1,
 1068308513,
 5842,
 -49232,
 1062701581,
 5871,
 -49231,
 1068465816,
 5867,
 -49230,
 1068522020,
 5868,
 -49229,
 1068572793,
 5869,
 -49228,
 1068636129,
 5872,
 -1,
 1068700628,
 5870,
 -49226,
 1062628193,
 8360,
 -1,
 1068846432,
 10740,
 1069039586,
 1062545687,
 -1,
 1069105105,
 1068995261,
 -1,
 1069170637,
 1069031812,
 -1,
 1069236158,
 1069122188,
 -1,
 1069301693,
 1069171442,
 8765,
 -1,
 1069220483,
 8909,
 -1,
 1069250327,
 8247,
 1069498306,
 1069163979,
 -1,
 1069563841,
 1069444695,
 8246,
 -1,
 1069483255,
 12317,
 -1,
 1069515120,
 10989,
 1069760453,
 1069447819,
 -1,
 -49212,
 1069690287,
 8271,
 -1,
 1069748616,
 8515,
 1069957064,
 1069705749,
 -1,
 -49209,
 1069905602,
 8245,
 -1,
 1069957862,
 8267,
 1070153674,
 1069879590,
 10659,
 -1,
 1070073827,
 10661,
 -49205,
 1070102700,
 9753,
 -49204,
 1070227159,
 8976,
 -1,
 1070280183,
 10672,
 1070530559,
 1069090150,
 92,
 1070596095,
 1070399488,
 -1,
 -49200,
 1070503801,
 10743,
 -1,
 1070556420,
 10741,
 1070743517,
 1069031805,
 -1,
 1070809052,
 1070679189,
 -1,
 1070874587,
 1070762728,
 -1,
 -49195,
 1070795374,
 9849,
 -49194,
 1070860897,
 9848,
 -49193,
 1070926420,
 9847,
 -49192,
 1070991943,
 9846,
 -49191,
 1071057466,
 9845,
 -49190,
 1071122986,
 9844,
 -1,
 1071188509,
 9843,
 -1,
 1070806565,
 9850,
 -1,
 1070738067,
 9852,
 -49186,
 1070696915,
 9166,
 -49185,
 1071480902,
 8479,
 -49184,
 1071541494,
 65533,
 -49183,
 1071593202,
 174,
 -1,
 1071657890,
 8251,
 1071857668,
 1068982543,
 -1,
 1071923200,
 1071797867,
 -1,
 1071988715,
 1071874700,
 -1,
 1072054248,
 1071944927,
 -1,
 -49177,
 1071997199,
 8545,
 -1,
 1072049500,
 8555,
 1072250858,
 1071984136,
 8553,
 -1,
 1072170415,
 8578,
 -1,
 1072184995,
 8546,
 1072447475,
 1071919808,
 -1,
 1072513010,
 1072381825,
 -1,
 1072578545,
 1072468474,
 8548,
 1072693247,
 1072496640,
 -1,
 -49168,
 1072596401,
 8577,
 -1,
 1072643866,
 8558,
 -1,
 1072510326,
 8556,
 -1,
 1072457725,
 8547,
 1072971768,
 1072391098,
 8544,
 1073086463,
 1072889856,
 -1,
 1073102839,
 1072989617,
 8559,
 -1,
 1073021406,
 8576,
 -1,
 1073037082,
 8557,
 1073299451,
 1072921227,
 -1,
 -49158,
 1073236113,
 8549,
 -1,
 1073295823,
 8550,
 1073496062,
 1073228055,
 -1,
 -49155,
 1073434748,
 8554,
 -1,
 1073496578,
 8551,
 -49153,
 1073443583,
 8579,
 -1,
 1073634636,
 8552,
 1073872895,
 1071874945,
 -1,
 -49150,
 1073757132,
 10085,
 -49149,
 1073820823,
 10087,
 -1,
 1073880132,
 8506,
 1074135039,
 1071778429,
 -1,
 1074151432,
 1074013008,
 -1,
 -49145,
 1074094413,
 9762,
 -1,
 1074142089,
 9143,
 -1,
 1074104056,
 8758,
 1074413853,
 1050307093,
 -1,
 1074479275,
 1074334333,
 -1,
 1074544808,
 1074425969,
 -1,
 1074610332,
 1074474706,
 -1,
 1074675776,
 1074544885,
 -1,
 1074741275,
 1074625163,
 -1,
 1074806802,
 1074694900,
 -1,
 -49135,
 1074752612,
 12860,
 -1,
 1074813602,
 12848,
 1075003413,
 1074758284,
 -1,
 -49132,
 1074957249,
 12859,
 -1,
 1075012000,
 12849,
 1075200024,
 1074931991,
 -1,
 -49129,
 1075155550,
 12838,
 -1,
 1075204242,
 12866,
 -49127,
 1075145547,
 12853,
 -49126,
 1075339673,
 12851,
 -1,
 1075398801,
 12837,
 1075593250,
 1074672320,
 -1,
 1075658784,
 1075527553,
 -1,
 -49122,
 1075614202,
 12836,
 -49121,
 1075671486,
 12843,
 -1,
 1075731221,
 12854,
 -49119,
 1075603453,
 12835,
 -1,
 1075851524,
 12864,
 1076052008,
 1075540414,
 -1,
 1076117542,
 1076001419,
 -1,
 -49115,
 1076069004,
 12865,
 -1,
 1076127795,
 12862,
 -49113,
 1076063810,
 12857,
 -1,
 1076235213,
 12867,
 1076445228,
 1076003468,
 -1,
 -49110,
 1076402329,
 12833,
 -49109,
 1076444835,
 12834,
 -1,
 1076506120,
 12841,
 1076707376,
 1076373783,
 -1,
 -49106,
 1076649859,
 12861,
 -49105,
 1076707842,
 12839,
 -1,
 1076761703,
 12847,
 1076969523,
 1076663519,
 -1,
 -49102,
 1076913247,
 12845,
 -1,
 1076958619,
 12844,
 1077166134,
 1076910754,
 -1,
 -49099,
 1077101675,
 12840,
 -1,
 1077153698,
 12852,
 1077362745,
 1077105967,
 -1,
 -49096,
 1077306478,
 12842,
 -1,
 1077358880,
 12846,
 1077559356,
 1077287754,
 -1,
 -49093,
 1077503009,
 12855,
 -1,
 1077546689,
 12858,
 -49091,
 1077502906,
 12832,
 -49090,
 1077693378,
 12856,
 -49089,
 1077754653,
 12850,
 -1,
 1077808909,
 12863,
 1078018147,
 1074608822,
 -1,
 1078083656,
 1077943114,
 -1,
 1078149190,
 1078018402,
 12808,
 1078263807,
 1078067200,
 -1,
 -49083,
 1078168308,
 12828,
 -1,
 1078200957,
 12822,
 1078460415,
 1078082662,
 12809,
 -1,
 1078329346,
 12823,
 1078542413,
 1078035084,
 -1,
 1078607947,
 1078477491,
 12802,
 -1,
 1078525954,
 12816,
 1078788095,
 1078541441,
 12811,
 -1,
 1078657026,
 12825,
 1078870098,
 1078487573,
 -1,
 1078935632,
 1078804845,
 12805,
 -1,
 1078853634,
 12819,
 1079115775,
 1078869114,
 12812,
 -1,
 1078984706,
 12826,
 1079197783,
 1078806947,
 -1,
 1079263317,
 1079134375,
 12800,
 -1,
 1079181314,
 12814,
 1079443455,
 1079196787,
 12810,
 -1,
 1079312386,
 12824,
 1079525465,
 1079148252,
 12806,
 -1,
 1079443458,
 12820,
 1079656539,
 1079473101,
 12803,
 -1,
 1079574530,
 12817,
 1079787613,
 1079598378,
 12801,
 -1,
 1079705602,
 12815,
 1079918687,
 1079728280,
 12804,
 -1,
 1079836674,
 12818,
 1080049761,
 1079853415,
 12807,
 -1,
 1079967746,
 12821,
 1080229887,
 1079983213,
 12813,
 -1,
 1080098818,
 12827,
 1080311934,
 1077955850,
 -1,
 -49051,
 1080269774,
 9397,
 -49050,
 1080334803,
 9396,
 -49049,
 1080400165,
 9395,
 -49048,
 1080464607,
 9394,
 -49047,
 1080529274,
 9393,
 -49046,
 1080593140,
 9392,
 -49045,
 1080656524,
 9391,
 -49044,
 1080720011,
 9390,
 -49043,
 1080782961,
 9389,
 -49042,
 1080848074,
 9388,
 -49041,
 1080912405,
 9387,
 -49040,
 1080975631,
 9386,
 -49039,
 1081039522,
 9385,
 -49038,
 1081103663,
 9384,
 -49037,
 1081166669,
 9383,
 -49036,
 1081231779,
 9382,
 -49035,
 1081297069,
 9381,
 -49034,
 1081360257,
 9380,
 -49033,
 1081424200,
 9379,
 -49032,
 1081488791,
 9378,
 -49031,
 1081553600,
 9377,
 -49030,
 1081616663,
 9376,
 -49029,
 1081680258,
 9375,
 -49028,
 1081744202,
 9374,
 -49027,
 1081808547,
 9373,
 -1,
 1081870973,
 9372,
 1082081423,
 1080254490,
 -1,
 1082146949,
 1082032780,
 -1,
 1082212483,
 1082103280,
 -1,
 -49022,
 1082154994,
 9351,
 -1,
 1082217707,
 9343,
 -49020,
 1082146038,
 9344,
 -1,
 1082338824,
 9341,
 1082540168,
 1082096267,
 -1,
 -49017,
 1082476692,
 9347,
 -1,
 1082536404,
 9348,
 1082736779,
 1082471104,
 -1,
 -49014,
 1082681410,
 9345,
 -1,
 1082737032,
 9346,
 1082933390,
 1082665239,
 -1,
 -49011,
 1082871932,
 9342,
 -1,
 1082933783,
 9349,
 -1,
 1082875217,
 9350,
 1083244543,
 1082008598,
 -1,
 1083261075,
 1083146892,
 -1,
 -49006,
 1083218073,
 9333,
 -1,
 1083260579,
 9334,
 1083457686,
 1083210379,
 -1,
 -49003,
 1083394193,
 9337,
 -1,
 1083453903,
 9338,
 1083654297,
 1083388608,
 -1,
 -49000,
 1083598845,
 9335,
 -1,
 1083656258,
 9336,
 -48998,
 1083597754,
 9332,
 -48997,
 1083792716,
 9340,
 -1,
 1083845786,
 9339,
 1084047523,
 1074530941,
 -1,
 1084113058,
 1083986533,
 -1,
 1084178593,
 1084069585,
 -1,
 -48992,
 1084130988,
 10995,
 -1,
 1084177968,
 10994,
 -1,
 1084131151,
 8741,
 -1,
 1084045265,
 8233,
 1084555263,
 1083998860,
 -1,
 1084571815,
 1084440562,
 -1,
 -48986,
 1084511502,
 9853,
 -1,
 1084555804,
 8706,
 -1,
 1084489793,
 12349,
 1084882943,
 1074495697,
 -1,
 -48982,
 1084788377,
 9106,
 -1,
 1084827658,
 9105,
 1085030629,
 1074425969,
 -1,
 1085096156,
 1084958999,
 -1,
 1085161675,
 1085045387,
 -1,
 1085227210,
 1085091491,
 -1,
 1085292731,
 1085164365,
 -1,
 1085358266,
 1085221681,
 -1,
 1085423796,
 1085283146,
 -1,
 -48973,
 1085378595,
 65079,
 -1,
 1085433408,
 65089,
 -48971,
 1085380155,
 65091,
 -48970,
 1085573167,
 65081,
 -48969,
 1085631177,
 65077,
 -48968,
 1085679071,
 65085,
 -48967,
 1085741368,
 65083,
 -1,
 1085804844,
 65087,
 -1,
 1085303106,
 65075,
 1086079173,
 1085240281,
 -1,
 1086144703,
 1086004042,
 -1,
 -48962,
 1086099491,
 65080,
 -1,
 1086154304,
 65090,
 -48960,
 1086101051,
 65092,
 -48959,
 1086294063,
 65082,
 -48958,
 1086352073,
 65078,
 -48957,
 1086399967,
 65086,
 -48956,
 1086462264,
 65084,
 -1,
 1086525740,
 65088,
 1086734536,
 1086007575,
 -1,
 -48953,
 1086675623,
 65074,
 -1,
 1086739761,
 65073,
 -48951,
 1086690751,
 65076,
 -1,
 1086884400,
 65072,
 -1,
 1085153367,
 8478,
 1087127771,
 1085086878,
 8826,
 1087242239,
 1087045632,
 -1,
 1087258838,
 1087113950,
 -1,
 1087324369,
 1087209131,
 -1,
 -48944,
 1087266483,
 10929,
 -1,
 1087319985,
 10927,
 1087520980,
 1087266452,
 -1,
 -48941,
 1087450981,
 10933,
 -1,
 1087508263,
 10937,
 -48939,
 1087451057,
 10931,
 -1,
 1087639335,
 10935,
 1087848665,
 1087202598,
 -1,
 -48936,
 1087785009,
 8830,
 -1,
 1087835553,
 8828,
 -48934,
 1087802696,
 8880,
 -1,
 1087970058,
 8936,
 -1,
 1087083553,
 9111,
 1088241890,
 1085038863,
 -1,
 1088307425,
 1088186901,
 -1,
 1088372960,
 1088251528,
 8759,
 -1,
 1088294305,
 8733,
 -1,
 1088303177,
 8522,
 -1,
 1088243959,
 8965,
 1088684031,
 1088176001,
 -1,
 -48924,
 1088577344,
 9113,
 -1,
 1088640773,
 8242,
 1088831743,
 1084967757,
 -1,
 1088897275,
 1088785140,
 -1,
 1088962810,
 1088846475,
 -1,
 1089028345,
 1088881974,
 43,
 1089142783,
 1088946176,
 -1,
 1089159412,
 1089050321,
 -1,
 1089224942,
 1089111701,
 -1,
 -48915,
 1089148913,
 10790,
 -1,
 1089211096,
 10788,
 1089421553,
 1089174155,
 -1,
 -48912,
 1089375110,
 10791,
 -1,
 1089426958,
 10786,
 -48910,
 1089348961,
 10789,
 -48909,
 1089543732,
 10787,
 -1,
 1089608041,
 10792,
 1089814776,
 1089094614,
 -1,
 -48906,
 1089767559,
 10809,
 -48905,
 1089827989,
 10798,
 -1,
 1089883628,
 10797,
 -1,
 1089735397,
 10866,
 -1,
 1088948555,
 177,
 -1,
 1088915279,
 9799,
 1090322431,
 1088817789,
 -1,
 1090339070,
 1090214811,
 8462,
 -1,
 1090258107,
 8463,
 -1,
 1090264202,
 8984,
 1090535692,
 1088760087,
 -1,
 1090601223,
 1090482289,
 -1,
 1090666756,
 1090519040,
 -1,
 -48893,
 1090618420,
 8241,
 -1,
 1090672810,
 8240,
 -48891,
 1090617389,
 8966,
 -48890,
 1090808747,
 10977,
 -1,
 1090854085,
 37,
 1091059978,
 1090550411,
 -1,
 -48887,
 1091002681,
 8369,
 -1,
 1091055895,
 8359,
 -48885,
 1091001238,
 9999,
 -1,
 1091177410,
 9774,
 1091387667,
 1090478351,
 -1,
 1091453201,
 1091336843,
 -1,
 1091518736,
 1091404586,
 12306,
 -1,
 1091437199,
 12320,
 -1,
 1091454991,
 8982,
 -48878,
 1091407167,
 163,
 -1,
 1091660314,
 8236,
 1091846425,
 1091321729,
 -1,
 1091911958,
 1091797912,
 8916,
 -1,
 1091831724,
 10970,
 -48873,
 1091861386,
 9811,
 -48872,
 1091985601,
 10031,
 -1,
 1092046144,
 182,
 1092239644,
 1091779792,
 -1,
 -48869,
 1092189848,
 5941,
 -1,
 1092232850,
 5942,
 -1,
 1092193577,
 8200,
 1092502031,
 1074356495,
 -1,
 1092567440,
 1092448369,
 -1,
 1092632972,
 1092501377,
 -1,
 1092698507,
 1092590061,
 -1,
 1092764004,
 1092636740,
 -1,
 1092829479,
 1092719723,
 -1,
 1092895013,
 1092776049,
 2827,
 -1,
 1092841585,
 2912,
 1093074943,
 1092832077,
 2828,
 -1,
 1092963149,
 2913,
 1093157165,
 1092780684,
 -1,
 1093222699,
 1093108364,
 -1,
 -48854,
 1093155170,
 2848,
 -1,
 1093208701,
 2847,
 -48852,
 1093155170,
 2853,
 -1,
 1093339773,
 2852,
 1093550386,
 1093098146,
 -1,
 -48849,
 1093507562,
 2846,
 -48848,
 1093556962,
 2851,
 -48847,
 1093612956,
 2841,
 -1,
 1093667453,
 2856,
 1093878072,
 1093476738,
 -1,
 1093943606,
 1093804418,
 -1,
 -48843,
 1093876066,
 2850,
 -1,
 1093929597,
 2849,
 -48841,
 1093876066,
 2855,
 -1,
 1094060669,
 2854,
 1094271292,
 1093798525,
 2821,
 -48838,
 1094224628,
 2836,
 -48837,
 1094270849,
 2832,
 -1,
 1094322813,
 2822,
 1094533440,
 1094220427,
 -1,
 -48834,
 1094482634,
 2871,
 -48833,
 1094531426,
 2870,
 -1,
 1094584957,
 2872,
 1094795588,
 1094479985,
 -1,
 -48830,
 1094742165,
 2908,
 -48829,
 1094793570,
 2909,
 -1,
 1094847101,
 2864,
 1095057735,
 1094752723,
 -1,
 -48826,
 1095014890,
 2911,
 -1,
 1095043709,
 2863,
 1095254345,
 1095011060,
 2825,
 -1,
 1095207668,
 2826,
 1095385420,
 1095199253,
 -1,
 -48821,
 1095317858,
 2859,
 -1,
 1095371389,
 2858,
 1095582031,
 1095322445,
 -1,
 -48818,
 1095519116,
 2867,
 -1,
 1095567997,
 2866,
 1095778642,
 1095518627,
 -1,
 -48815,
 1095711074,
 2838,
 -1,
 1095764605,
 2837,
 1095975253,
 1095714989,
 -1,
 -48812,
 1095907682,
 2845,
 -1,
 1095961213,
 2844,
 1096171863,
 1095909249,
 2823,
 -1,
 1096105857,
 2824,
 1096302938,
 1096103319,
 -1,
 -48807,
 1096235362,
 2840,
 -1,
 1096288893,
 2839,
 1096499549,
 1096227658,
 -1,
 -48804,
 1096431970,
 2843,
 -1,
 1096485501,
 2842,
 1096696160,
 1096423075,
 -1,
 -48801,
 1096628578,
 2861,
 -1,
 1096682109,
 2860,
 -48799,
 1096638735,
 2835,
 -48798,
 1096832312,
 2862,
 -48797,
 1096890722,
 2873,
 -1,
 1096952087,
 2831,
 1097154928,
 1092719809,
 -1,
 1097220457,
 1097075325,
 -1,
 -48793,
 1097173748,
 2892,
 -48792,
 1097219969,
 2888,
 -1,
 1097271933,
 2878,
 1097482603,
 1097173748,
 2881,
 -1,
 1097435892,
 2882,
 1097613677,
 1097416577,
 2879,
 -1,
 1097547649,
 2880,
 -48786,
 1097569396,
 2883,
 -48785,
 1097687311,
 2891,
 -1,
 1097738519,
 2887,
 1097941374,
 1097081878,
 -1,
 1098006900,
 1097892492,
 -1,
 -48781,
 1097963673,
 2920,
 -1,
 1098006179,
 2921,
 1098203511,
 1097955979,
 -1,
 -48778,
 1098139793,
 2924,
 -1,
 1098199503,
 2925,
 1098400122,
 1098134208,
 -1,
 -48775,
 1098344445,
 2922,
 -1,
 1098401858,
 2923,
 -48773,
 1098357790,
 2918,
 -48772,
 1098539962,
 2919,
 -48771,
 1098603852,
 2927,
 -1,
 1098656922,
 2926,
 1098858887,
 1097891372,
 -1,
 1098924418,
 1098814447,
 -1,
 -48767,
 1098873671,
 2819,
 -1,
 1098936588,
 2893,
 1099121029,
 1098844797,
 -1,
 -48764,
 1099075973,
 2877,
 -1,
 1099128961,
 2818,
 -48762,
 1099063316,
 2876,
 -1,
 1099242449,
 2817,
 1099448714,
 1098779261,
 -1,
 -48759,
 1099401977,
 2903,
 -1,
 1099448209,
 2902,
 -1,
 1099384720,
 2928,
 -1,
 1092630249,
 8886,
 1099776399,
 1092574021,
 -1,
 -48754,
 1099723997,
 64831,
 -1,
 1099779631,
 64830,
 -1,
 1099728280,
 9766,
 1100038586,
 1092504910,
 -1,
 1100104116,
 1099976772,
 -1,
 1100169628,
 1100032279,
 66308,
 1100235157,
 1100118667,
 66324,
 -1,
 1100167496,
 66318,
 1100366231,
 1100181617,
 66323,
 -1,
 1100315275,
 66331,
 -48744,
 1100307106,
 66317,
 -48743,
 1100436783,
 66316,
 -48742,
 1100499789,
 66315,
 -48741,
 1100565222,
 66327,
 -1,
 1100624576,
 66330,
 1100824993,
 1100106147,
 -1,
 -48738,
 1100778228,
 66322,
 -48737,
 1100823347,
 66329,
 -48736,
 1100884247,
 66306,
 -1,
 1100941949,
 66314,
 1101152675,
 1100778228,
 66326,
 -1,
 1101105908,
 66334,
 1101283750,
 1101103756,
 -1,
 -48731,
 1101216563,
 66312,
 -1,
 1101277463,
 66325,
 1101480361,
 1101228565,
 -1,
 -48728,
 1101413171,
 66328,
 -1,
 1101474071,
 66320,
 1101676971,
 1101414273,
 66313,
 -1,
 1101610881,
 66333,
 -48724,
 1101634567,
 66310,
 -48723,
 1101763066,
 66309,
 -48722,
 1101823287,
 66321,
 -48721,
 1101881615,
 66319,
 -48720,
 1101937459,
 66311,
 -48719,
 1101996666,
 66307,
 -48718,
 1102060838,
 66332,
 -48717,
 1102124978,
 66305,
 -1,
 1102187133,
 66304,
 1102446591,
 1100046405,
 -1,
 1102463416,
 1102328768,
 -1,
 -48713,
 1102418426,
 66337,
 -1,
 1102460278,
 66339,
 -48711,
 1102414896,
 66338,
 -1,
 1102603194,
 66336,
 1102791138,
 1099969943,
 -1,
 1102856673,
 1102723707,
 -1,
 1102922206,
 1102794820,
 -1,
 1102987713,
 1102875380,
 -1,
 -48705,
 1102934129,
 5778,
 -48704,
 1102988073,
 5783,
 -1,
 1103041963,
 5766,
 1103249861,
 1102915916,
 -1,
 -48701,
 1103190028,
 5785,
 -48700,
 1103242058,
 5779,
 -1,
 1103304894,
 5781,
 1103512008,
 1103198859,
 -1,
 -48697,
 1103464528,
 5774,
 -1,
 1103498527,
 5764,
 1103708619,
 1103454479,
 -1,
 -48694,
 1103655025,
 5782,
 -1,
 1103715808,
 5777,
 1103905230,
 1103649442,
 -1,
 -48691,
 1103840825,
 5765,
 -1,
 1103902231,
 5773,
 1104101841,
 1103839105,
 -1,
 -48688,
 1104044460,
 5780,
 -1,
 1104098263,
 5784,
 1104298452,
 1104026442,
 -1,
 -48685,
 1104241352,
 5769,
 -1,
 1104293093,
 5770,
 -48683,
 1104250610,
 5768,
 -48682,
 1104443972,
 5775,
 -48681,
 1104505724,
 5786,
 -48680,
 1104566806,
 5771,
 -48679,
 1104630973,
 5762,
 -48678,
 1104689039,
 5772,
 -48677,
 1104753479,
 5763,
 -48676,
 1104814591,
 5767,
 -48675,
 1104877531,
 5761,
 -1,
 1104940349,
 5776,
 -48673,
 1102872603,
 5760,
 -48672,
 1105097438,
 5788,
 -1,
 1105146701,
 5787,
 -1,
 1102799837,
 731,
 1105412593,
 1102716968,
 -1,
 1105478119,
 1105335971,
 -1,
 -48667,
 1105424670,
 9286,
 -48666,
 1105488202,
 9285,
 -1,
 1105538380,
 9284,
 1105740266,
 1105404290,
 -1,
 -48663,
 1105684390,
 9290,
 -1,
 1105728717,
 9288,
 1105936877,
 1105664842,
 -1,
 -48660,
 1105891557,
 9289,
 -1,
 1105934854,
 9281,
 -48658,
 1105872391,
 9283,
 -48657,
 1106066810,
 9280,
 -48656,
 1106130116,
 9282,
 -1,
 1106186198,
 9287,
 1106395649,
 1105357333,
 -1,
 1106461183,
 1106325000,
 -1,
 1106526714,
 1106378752,
 -1,
 1106592249,
 1106451663,
 -1,
 -48650,
 1106543530,
 10044,
 -48649,
 1106583667,
 10011,
 -48648,
 1106647390,
 10027,
 -1,
 1106711853,
 10034,
 -1,
 1106516541,
 9251,
 1107034111,
 1106446322,
 -1,
 1107051006,
 1106910745,
 -1,
 -48643,
 1106987902,
 9104,
 -1,
 1107048788,
 9103,
 -1,
 1106995328,
 10174,
 -48640,
 1106413308,
 8997,
 -1,
 1107258788,
 9741,
 1107444231,
 1106348788,
 -1,
 1107509766,
 1107396423,
 -1,
 -48636,
 1107447038,
 10015,
 -48635,
 1107507370,
 10009,
 -1,
 1107564894,
 10029,
 -1,
 1107450754,
 8485,
 1107837452,
 1107367587,
 -1,
 1107902987,
 1107775950,
 -1,
 -48630,
 1107856850,
 10662,
 -1,
 1107896113,
 10663,
 -1,
 1107839196,
 65532,
 -48627,
 1107792541,
 8254,
 -48626,
 1108106325,
 8228,
 -1,
 1108163897,
 8486,
 1108361968,
 1092435841,
 -1,
 1108427441,
 1108288122,
 -1,
 1108492973,
 1108369921,
 -1,
 1108558455,
 1108444170,
 -1,
 1108623990,
 1108509231,
 -1,
 1108689475,
 1108550018,
 -1,
 1108755010,
 1108612724,
 -1,
 1108820528,
 1108705932,
 -1,
 1108886057,
 1108776159,
 -1,
 1108951592,
 1108814103,
 -1,
 1109017127,
 1108893682,
 13299,
 1109131263,
 1108936690,
 -1,
 1109148190,
 1109033612,
 -1,
 -48611,
 1109104793,
 13301,
 -1,
 1109147299,
 13302,
 1109344801,
 1109097099,
 -1,
 -48608,
 1109280913,
 13305,
 -1,
 1109340623,
 13306,
 1109541412,
 1109275328,
 -1,
 -48605,
 1109485565,
 13303,
 -1,
 1109542978,
 13304,
 -48603,
 1109484474,
 13300,
 -48602,
 1109679436,
 13308,
 -1,
 1109732506,
 13307,
 -1,
 1108956395,
 13291,
 -1,
 1108893967,
 13281,
 1110065711,
 1108818248,
 -1,
 1110131246,
 1110001472,
 -1,
 1110196781,
 1110088147,
 13309,
 -1,
 1110116695,
 13310,
 -1,
 1110125304,
 13292,
 -1,
 1110078006,
 13282,
 -1,
 1109995016,
 13289,
 1110524469,
 1108769419,
 -1,
 1110590003,
 1110460561,
 13285,
 -1,
 1110541291,
 13295,
 1110769663,
 1110520271,
 13286,
 -1,
 1110672363,
 13296,
 1110852155,
 1110454976,
 -1,
 1110917688,
 1110796285,
 13283,
 -1,
 1110868971,
 13293,
 1111097343,
 1110851457,
 -1,
 -48582,
 1111003642,
 13284,
 -1,
 1111045434,
 13294,
 1111245375,
 1110780183,
 -1,
 1111310910,
 1111179778,
 13287,
 -1,
 1111239416,
 13297,
 -1,
 1111249020,
 13290,
 1111507521,
 1111186764,
 13288,
 -1,
 1111458795,
 13298,
 -1,
 1111450554,
 13280,
 -1,
 1108683292,
 13003,
 1111769703,
 1108622980,
 -1,
 1111835220,
 1111720588,
 -1,
 1111900752,
 1111790815,
 -1,
 1111966287,
 1111828759,
 -1,
 1112031822,
 1111908338,
 13164,
 1112145919,
 1111951346,
 -1,
 1112162892,
 1112048268,
 -1,
 -48565,
 1112119449,
 13166,
 -1,
 1112161955,
 13167,
 -48563,
 1112105914,
 13165,
 -1,
 1112290534,
 13168,
 -1,
 1111971051,
 13156,
 -1,
 1111908623,
 13146,
 1112621651,
 1111832904,
 -1,
 -48558,
 1112568374,
 13147,
 -1,
 1112622916,
 13157,
 -1,
 1112550920,
 13154,
 1112883801,
 1111784075,
 -1,
 1112949335,
 1112819857,
 13150,
 -1,
 1112900587,
 13160,
 1113128959,
 1112879567,
 13151,
 -1,
 1113031659,
 13161,
 1113211487,
 1112814272,
 -1,
 1113277020,
 1113155581,
 13148,
 -1,
 1113228267,
 13158,
 1113456639,
 1113210753,
 -1,
 -48546,
 1113362938,
 13149,
 -1,
 1113404730,
 13159,
 1113604707,
 1113139479,
 -1,
 1113670242,
 1113539074,
 13152,
 -1,
 1113598712,
 13162,
 -1,
 1113608316,
 13155,
 1113866853,
 1113546060,
 13153,
 -1,
 1113818091,
 13163,
 -48538,
 1113824286,
 13144,
 -1,
 1113940922,
 13145,
 1114129004,
 1111705773,
 -1,
 1114194539,
 1114082036,
 -1,
 -48534,
 1114135630,
 12997,
 -1,
 1114199303,
 12998,
 -1,
 1114116569,
 12992,
 1114456687,
 1114068280,
 -1,
 -48530,
 1114413523,
 12996,
 -1,
 1114468729,
 12994,
 1114653298,
 1114376829,
 -1,
 -48527,
 1114606594,
 12999,
 -1,
 1114664530,
 12995,
 -48525,
 1114602620,
 13000,
 -48524,
 1114792356,
 13001,
 -48523,
 1114857220,
 13002,
 -1,
 1114911589,
 12993,
 -1,
 1108562282,
 12343,
 1115177613,
 1108480354,
 -1,
 1115243134,
 1115128460,
 -1,
 1115308668,
 1115175240,
 -1,
 -48517,
 1115255354,
 12692,
 -1,
 1115309819,
 12699,
 -48515,
 1115265237,
 12691,
 -1,
 1115448470,
 12694,
 1115636355,
 1115173568,
 -1,
 1115701890,
 1115580413,
 -1,
 -48511,
 1115653392,
 12700,
 -1,
 1115685785,
 12693,
 -1,
 1115637558,
 12697,
 1115964038,
 1115575599,
 -1,
 -48507,
 1115897985,
 12695,
 -1,
 1115951105,
 12703,
 -48505,
 1115913171,
 12698,
 -48504,
 1116107448,
 12689,
 -48503,
 1116169172,
 12690,
 -48502,
 1116230081,
 12688,
 -48501,
 1116289916,
 12701,
 -48500,
 1116350871,
 12702,
 -1,
 1116412416,
 12696,
 1116619425,
 1115103866,
 -1,
 1116684960,
 1116568492,
 -1,
 1116750488,
 1116635670,
 -1,
 1116816019,
 1116704491,
 -1,
 -48494,
 1116763091,
 12281,
 -1,
 1116818804,
 12280,
 1117012630,
 1116752717,
 -1,
 -48491,
 1116957056,
 12282,
 -1,
 1117006637,
 12279,
 -48489,
 1116936177,
 12278,
 -1,
 1117129432,
 12277,
 1117340315,
 1116687998,
 -1,
 -48486,
 1117287379,
 12272,
 -1,
 1117345846,
 12274,
 1117536926,
 1117260694,
 -1,
 -48483,
 1117476901,
 12275,
 -1,
 1117526001,
 12273,
 -48481,
 1117481216,
 12283,
 -1,
 1117664644,
 12276,
 -1,
 1116629760,
 12332,
 1117930148,
 1116543818,
 -1,
 -48477,
 1117872920,
 12289,
 -1,
 1117934509,
 12294,
 -48475,
 1117884870,
 12350,
 -48474,
 1118076949,
 12288,
 -48473,
 1118140280,
 12331,
 -48472,
 1118199865,
 12295,
 -48471,
 1118261356,
 12330,
 -48470,
 1118324675,
 12293,
 -48469,
 1118386761,
 12351,
 -48468,
 1118451066,
 12290,
 -1,
 1118514879,
 12333,
 1118765055,
 1108434836,
 -1,
 1118782128,
 1118668623,
 8801,
 -1,
 1118699783,
 10725,
 -1,
 1118738188,
 10855,
 1118978798,
 1108368034,
 -1,
 1119044308,
 1118929824,
 -1,
 1119109829,
 1118990449,
 -1,
 1119175358,
 1119058916,
 8745,
 1119289343,
 1119092736,
 -1,
 1119306426,
 1119196881,
 -1,
 -48456,
 1119250680,
 10819,
 -48455,
 1119310581,
 10820,
 -1,
 1119364430,
 10816,
 1119568573,
 1119226590,
 -1,
 -48452,
 1119522169,
 10823,
 -1,
 1119557426,
 10825,
 -1,
 1119492162,
 10827,
 1119830722,
 1119113641,
 -1,
 -48448,
 1119782016,
 65531,
 -48447,
 1119845490,
 65530,
 -1,
 1119883287,
 65529,
 -48445,
 1119778852,
 8253,
 -48444,
 1120028230,
 10812,
 -1,
 1120082843,
 8890,
 1120337919,
 1119041452,
 8747,
 1120403455,
 1120206848,
 -1,
 1120420560,
 1120310993,
 -1,
 1120486091,
 1120374012,
 -1,
 -48438,
 1120421433,
 10778,
 -1,
 1120477940,
 10780,
 -48436,
 1120437968,
 10776,
 -48435,
 1120626936,
 10779,
 -48434,
 1120685838,
 10775,
 -48433,
 1120748897,
 10777,
 -1,
 1120806565,
 10766,
 1121010387,
 1120340605,
 -1,
 -48430,
 1120965259,
 10767,
 -1,
 1121024205,
 10773,
 -1,
 1120940681,
 9134,
 1121272545,
 1118998906,
 -1,
 1121338078,
 1121202109,
 -1,
 1121403611,
 1121289190,
 -1,
 -48424,
 1121349639,
 191,
 -48423,
 1121411633,
 8487,
 -48422,
 1121471798,
 8766,
 -1,
 1121530477,
 161,
 1121779711,
 1121352644,
 -1,
 -48419,
 1121687086,
 9689,
 -1,
 1121721037,
 9688,
 1121976319,
 1121273722,
 -1,
 -48416,
 1121879739,
 8290,
 -1,
 1121942642,
 8291,
 1122124517,
 1121202880,
 -1,
 1122190052,
 1122059520,
 8734,
 -1,
 1122108333,
 10718,
 -1,
 1122133542,
 8505,
 1122386666,
 1122048842,
 -1,
 1122452201,
 1122333118,
 -1,
 -48408,
 1122391993,
 8710,
 -1,
 1122440389,
 10721,
 -1,
 1122394935,
 10716,
 1122714349,
 1122319450,
 -1,
 -48404,
 1122665019,
 8298,
 -1,
 1122702027,
 8300,
 -1,
 1122663583,
 9088,
 1123024895,
 1118918005,
 8887,
 -1,
 1122894887,
 8787,
 1123107739,
 1108292288,
 -1,
 1123173239,
 1123060468,
 -1,
 1123238774,
 1123111461,
 -1,
 1123304306,
 1123194546,
 -1,
 1123369780,
 1123240781,
 -1,
 1123435308,
 1123292610,
 -1,
 1123500817,
 1123385215,
 -1,
 -48392,
 1123457998,
 65370,
 -48391,
 1123523027,
 65369,
 -48390,
 1123588389,
 65368,
 -48389,
 1123652831,
 65367,
 -48388,
 1123717498,
 65366,
 -48387,
 1123781364,
 65365,
 -48386,
 1123844748,
 65364,
 -48385,
 1123908235,
 65363,
 -48384,
 1123971185,
 65362,
 -48383,
 1124036298,
 65361,
 -48382,
 1124100629,
 65360,
 -48381,
 1124163855,
 65359,
 -48380,
 1124227746,
 65358,
 -48379,
 1124291887,
 65357,
 -48378,
 1124354893,
 65356,
 -48377,
 1124420003,
 65355,
 -48376,
 1124485293,
 65354,
 -48375,
 1124548481,
 65353,
 -48374,
 1124612424,
 65352,
 -48373,
 1124677015,
 65351,
 -48372,
 1124741824,
 65350,
 -48371,
 1124804887,
 65349,
 -48370,
 1124868482,
 65348,
 -48369,
 1124932426,
 65347,
 -48368,
 1124996771,
 65346,
 -1,
 1125059197,
 65345,
 1125318655,
 1123425332,
 -1,
 -48365,
 1125227470,
 65338,
 -48364,
 1125292499,
 65337,
 -48363,
 1125357861,
 65336,
 -48362,
 1125422303,
 65335,
 -48361,
 1125486970,
 65334,
 -48360,
 1125550836,
 65333,
 -48359,
 1125614220,
 65332,
 -48358,
 1125677707,
 65331,
 -48357,
 1125740657,
 65330,
 -48356,
 1125805770,
 65329,
 -48355,
 1125870101,
 65328,
 -48354,
 1125933327,
 65327,
 -48353,
 1125997218,
 65326,
 -48352,
 1126061359,
 65325,
 -48351,
 1126124365,
 65324,
 -48350,
 1126189475,
 65323,
 -48349,
 1126254765,
 65322,
 -48348,
 1126317953,
 65321,
 -48347,
 1126381896,
 65320,
 -48346,
 1126446487,
 65319,
 -48345,
 1126511296,
 65318,
 -48344,
 1126574359,
 65317,
 -48343,
 1126637954,
 65316,
 -48342,
 1126701898,
 65315,
 -48341,
 1126766243,
 65314,
 -1,
 1126828669,
 65313,
 1127039795,
 1123363095,
 -1,
 1127105330,
 1126970678,
 -1,
 -48337,
 1127061088,
 65375,
 -48336,
 1127120980,
 65339,
 -48335,
 1127181001,
 65288,
 -1,
 1127227646,
 65371,
 -1,
 1127055502,
 65308,
 -1,
 1126984002,
 65343,
 1127564100,
 1123295618,
 -1,
 1127629635,
 1127498361,
 -1,
 1127695161,
 1127580300,
 -1,
 -48328,
 1127651481,
 65298,
 -1,
 1127693987,
 65299,
 1127891772,
 1127643787,
 -1,
 -48325,
 1127827601,
 65302,
 -1,
 1127887311,
 65303,
 1128088383,
 1127822016,
 -1,
 -48322,
 1128032253,
 65300,
 -1,
 1128089666,
 65301,
 -48320,
 1128045598,
 65296,
 -48319,
 1128227770,
 65297,
 -48318,
 1128291660,
 65305,
 -1,
 1128344730,
 65304,
 -1,
 1127572172,
 65284,
 1128612683,
 1127510129,
 -1,
 1128678218,
 1128546823,
 -1,
 -48313,
 1128633952,
 65376,
 -48312,
 1128693844,
 65341,
 -48311,
 1128753865,
 65289,
 -1,
 1128800510,
 65373,
 -1,
 1128608247,
 65340,
 1129071443,
 1128536906,
 -1,
 1129136977,
 1129013519,
 -1,
 1129202512,
 1129077012,
 -1,
 -48305,
 1129132000,
 65312,
 -1,
 1129187965,
 65292,
 -1,
 1129141004,
 65306,
 -48302,
 1129072346,
 65342,
 -1,
 1129393818,
 65504,
 1129595735,
 1129015829,
 -1,
 -48299,
 1129539527,
 65505,
 -48298,
 1129600211,
 65291,
 -1,
 1129656268,
 65285,
 1129857883,
 1129515645,
 -1,
 -48295,
 1129808158,
 65290,
 -48294,
 1129868734,
 65287,
 -1,
 1129929190,
 65286,
 1130120030,
 1129806475,
 -1,
 -48291,
 1130062498,
 65295,
 -1,
 1130114479,
 65307,
 1130316641,
 1130065707,
 -1,
 -48288,
 1130260252,
 65282,
 -1,
 1130311928,
 65311,
 1130513252,
 1130257058,
 -1,
 -48285,
 1130466536,
 65283,
 -1,
 1130522384,
 65506,
 1130709863,
 1130444692,
 -1,
 -48282,
 1130637740,
 65310,
 -1,
 1130698292,
 65344,
 1130906474,
 1130637591,
 -1,
 -48279,
 1130862931,
 65281,
 -1,
 1130917741,
 65309,
 -48277,
 1130863237,
 65509,
 -48276,
 1131059461,
 65510,
 -48275,
 1131123596,
 65372,
 -48274,
 1131185807,
 65374,
 -48273,
 1131238715,
 65507,
 -48272,
 1131298673,
 65293,
 -48271,
 1131361658,
 65294,
 -1,
 1131420307,
 65508,
 1131675647,
 1123221504,
 -1,
 -48268,
 1131577676,
 46,
 -48267,
 1131636837,
 10199,
 -1,
 1131682202,
 9608,
 -1,
 1123179442,
 8289,
 1131955075,
 1123115279,
 -1,
 1132020607,
 1131909134,
 -1,
 1132086141,
 1131937792,
 -1,
 -48261,
 1132037034,
 10018,
 -48260,
 1132076759,
 10021,
 -1,
 1132140264,
 10019,
 -48258,
 1132037400,
 8732,
 -1,
 1132267882,
 8197,
 1132527615,
 1131966577,
 -1,
 -48255,
 1132415638,
 10972,
 -48254,
 1132469484,
 8873,
 -1,
 1132527670,
 8704,
 1132741515,
 1131901041,
 -1,
 1132807047,
 1132683535,
 -1,
 -48250,
 1132763237,
 8994,
 -1,
 1132814161,
 10156,
 1133003658,
 1132727307,
 -1,
 -48247,
 1132953397,
 8260,
 -1,
 1133011046,
 8543,
 -1,
 1132932681,
 8355,
 1133265810,
 1132674945,
 -1,
 1133331343,
 1133197607,
 -1,
 -48242,
 1133281301,
 8199,
 -1,
 1133322782,
 8210,
 -48240,
 1133280590,
 9673,
 -48239,
 1133476345,
 9789,
 -1,
 1133534604,
 10765,
 1133724567,
 1133185661,
 -1,
 1133790102,
 1133662840,
 -1,
 -48235,
 1133737798,
 10540,
 -1,
 1133796978,
 10543,
 -1,
 1133738478,
 9771,
 1134052250,
 1133653369,
 -1,
 -48231,
 1133987035,
 170,
 -1,
 1134038543,
 9792,
 -1,
 1133990774,
 10086,
 1134314547,
 1123048098,
 -1,
 1134379995,
 1134256399,
 -1,
 1134445499,
 1134330508,
 -1,
 1134511032,
 1134362624,
 -1,
 1134576550,
 1134430845,
 -1,
 1134642083,
 1134495121,
 -1,
 -48222,
 1134586931,
 8837,
 -1,
 1134631600,
 8836,
 -48220,
 1134592590,
 8772,
 -48219,
 1134779054,
 8713,
 -1,
 1134842527,
 8777,
 1135035307,
 1134525067,
 -1,
 1135100842,
 1134981007,
 -1,
 -48215,
 1135044035,
 8931,
 -1,
 1135100747,
 8930,
 -1,
 1135035012,
 172,
 1135362990,
 1134985868,
 -1,
 -48211,
 1135311418,
 8877,
 -1,
 1135362802,
 8769,
 1135559600,
 1135304287,
 8938,
 -1,
 1135477836,
 8940,
 1135690675,
 1135488852,
 -1,
 -48206,
 1135626289,
 8813,
 -1,
 1135676833,
 8800,
 -48204,
 1135635119,
 8742,
 -48203,
 1135824839,
 8814,
 -48202,
 1135886568,
 8802,
 -48201,
 1135949812,
 8815,
 -1,
 1136008496,
 9083,
 1136263167,
 1134435643,
 -1,
 -48198,
 1136168758,
 10161,
 -1,
 1136219211,
 10159,
 1136411606,
 1134391409,
 8893,
 1136477140,
 1136362764,
 -1,
 1136542665,
 1136432655,
 -1,
 1136608200,
 1136462461,
 -1,
 1136673735,
 1136556458,
 8598,
 1136787455,
 1136590848,
 -1,
 1136804804,
 1136691026,
 -1,
 -48189,
 1136743202,
 8632,
 -1,
 1136795622,
 8689,
 -48187,
 1136760687,
 10531,
 -48186,
 1136926869,
 10546,
 -1,
 1136988253,
 10535,
 -1,
 1136614418,
 10529,
 -1,
 1136535074,
 8662,
 1137377279,
 1136470434,
 -1,
 1137394643,
 1137248893,
 -1,
 1137460178,
 1137342890,
 8599,
 1137573887,
 1137377280,
 -1,
 1137591248,
 1137451147,
 -1,
 -48177,
 1137541124,
 10542,
 -1,
 1137598083,
 10545,
 -48175,
 1137547119,
 10532,
 -1,
 1137709220,
 10536,
 -1,
 1137400870,
 10530,
 -1,
 1137321506,
 8663,
 1138098175,
 1136416201,
 8882,
 -1,
 1137968204,
 8884,
 1138181081,
 1136351906,
 -1,
 -48168,
 1138111689,
 10973,
 -1,
 1138165794,
 8209,
 -48166,
 1138120903,
 8303,
 -1,
 1138296853,
 160,
 1138508801,
 1134307607,
 -1,
 1138574318,
 1138439656,
 -1,
 1138639853,
 1138509899,
 -1,
 1138705379,
 1138590348,
 -1,
 1138770914,
 1138660848,
 -1,
 -48159,
 1138712562,
 9460,
 -1,
 1138775275,
 9452,
 -1,
 1138703606,
 9453,
 1139033062,
 1138653835,
 -1,
 -48155,
 1138968724,
 9456,
 -1,
 1139028436,
 9457,
 1139229673,
 1138963136,
 -1,
 -48152,
 1139173442,
 9454,
 -1,
 1139229064,
 9455,
 1139426284,
 1139157271,
 -1,
 -48149,
 1139363964,
 9451,
 -1,
 1139425815,
 9458,
 -1,
 1139367249,
 9459,
 -1,
 1138567758,
 8879,
 1139753982,
 1138509799,
 -1,
 1139819508,
 1139691535,
 -1,
 1139885043,
 1139748692,
 -1,
 -48142,
 1139820593,
 8820,
 -1,
 1139871137,
 8816,
 -1,
 1139816436,
 8824,
 1140147193,
 1139751004,
 -1,
 1140212728,
 1140076372,
 -1,
 -48137,
 1140148273,
 8821,
 -1,
 1140198817,
 8817,
 -1,
 1140150215,
 8825,
 1140523007,
 1140066941,
 -1,
 1140540413,
 1140393361,
 -1,
 -48132,
 1140485181,
 8841,
 -1,
 1140529848,
 8840,
 -1,
 1140485600,
 8775,
 -48129,
 1139710395,
 9112,
 -48128,
 1140757736,
 8362,
 -1,
 1140813478,
 9798,
 1140999192,
 1138427913,
 -1,
 1141064712,
 1140923210,
 -1,
 1141130247,
 1140999880,
 -1,
 -48123,
 1141081793,
 10754,
 -48122,
 1141140782,
 10753,
 -1,
 1141187982,
 10752,
 -1,
 1141073174,
 8720,
 1141457932,
 1141017977,
 8899,
 1141571583,
 1141376018,
 -1,
 -48117,
 1141468446,
 10756,
 -1,
 1141515598,
 10755,
 1141720081,
 1141406347,
 -1,
 1141785616,
 1141665679,
 -1,
 -48113,
 1141738879,
 10758,
 -1,
 1141785966,
 10757,
 -1,
 1141738739,
 8721,
 1142047764,
 1141658348,
 -1,
 -48109,
 1141990687,
 8897,
 -1,
 1142034462,
 8896,
 -48107,
 1142003335,
 11007,
 -48106,
 1142195905,
 10761,
 -48105,
 1142255207,
 8719,
 -1,
 1142310241,
 8898,
 1142506541,
 1140952293,
 -1,
 1142572076,
 1142429719,
 -1,
 1142637600,
 1142522508,
 -1,
 1142703134,
 1142593008,
 -1,
 -48099,
 1142644726,
 9371,
 -1,
 1142707439,
 9363,
 -48097,
 1142635774,
 9364,
 -1,
 1142828562,
 9361,
 1143030821,
 1142585995,
 -1,
 1143096356,
 1142964097,
 -1,
 -48093,
 1143052739,
 9367,
 -1,
 1143093075,
 35,
 -1,
 1143026141,
 9368,
 1143358504,
 1142960832,
 -1,
 -48089,
 1143302218,
 9365,
 -1,
 1143357839,
 9366,
 1143555115,
 1143286039,
 -1,
 -48086,
 1143492738,
 9362,
 -1,
 1143554591,
 9369,
 -1,
 1143496026,
 9370,
 -1,
 1142501391,
 8470,
 1143930879,
 1142426237,
 -1,
 -48081,
 1143834373,
 8302,
 -48080,
 1143896506,
 8239,
 -48079,
 1143954373,
 8892,
 -48078,
 1144014484,
 8358,
 -1,
 1144068391,
 8711,
 1144276147,
 1134269663,
 -1,
 1144341662,
 1144207688,
 -1,
 1144407197,
 1144276922,
 -1,
 1144472732,
 1144324096,
 -1,
 1144538194,
 1144421003,
 -1,
 1144603721,
 1144483721,
 9633,
 1144717311,
 1144520704,
 -1,
 1144734792,
 1144624849,
 -1,
 1144800320,
 1144671053,
 -1,
 1144865855,
 1144744298,
 -1,
 -48066,
 1144812810,
 9714,
 -1,
 1144868442,
 9713,
 -1,
 1144794133,
 10212,
 1145128003,
 1144753899,
 -1,
 -48062,
 1145074954,
 9715,
 -1,
 1145130586,
 9712,
 1145324614,
 1145073777,
 -1,
 -48059,
 1145268206,
 9634,
 -1,
 1145324088,
 10213,
 -48057,
 1145279286,
 9707,
 -1,
 1145445591,
 9093,
 -1,
 1144659890,
 9635,
 1145717836,
 1144542511,
 -1,
 -48053,
 1145651987,
 9786,
 -1,
 1145704167,
 9643,
 -48051,
 1145670911,
 9788,
 -48050,
 1145865052,
 9734,
 -48049,
 1145924178,
 9828,
 -48048,
 1145978200,
 9750,
 -48047,
 1146040415,
 65094,
 -1,
 1146101324,
 9988,
 1146307692,
 1144462154,
 -1,
 1146373215,
 1146242730,
 9675,
 1146486783,
 1146291711,
 -1,
 1146504280,
 1146392299,
 -1,
 -48041,
 1146451210,
 9719,
 -1,
 1146506842,
 9716,
 1146700891,
 1146442770,
 -1,
 -48038,
 1146647818,
 9718,
 -1,
 1146703450,
 9717,
 1146897502,
 1146627313,
 -1,
 -48035,
 1146853484,
 10732,
 -1,
 1146913474,
 9862,
 -1,
 1146849855,
 9863,
 1147159655,
 1146305578,
 -1,
 1147225187,
 1147095459,
 -1,
 -48030,
 1147166010,
 9816,
 -1,
 1147225209,
 9812,
 -48028,
 1147172972,
 9814,
 -48027,
 1147367416,
 9813,
 -48026,
 1147431725,
 9817,
 -1,
 1147476236,
 9815,
 1147683947,
 1147102104,
 10209,
 1147797503,
 1147602431,
 -1,
 -48022,
 1147696792,
 10211,
 -1,
 1147752288,
 10210,
 -1,
 1147622576,
 9831,
 1148011639,
 1146233218,
 -1,
 1148077170,
 1147944969,
 9671,
 1148190719,
 1147994112,
 -1,
 -48016,
 1148098299,
 10192,
 -48015,
 1148158397,
 9826,
 -1,
 1148198803,
 9672,
 1148452863,
 1148021230,
 -1,
 1148470390,
 1148324223,
 -1,
 -48011,
 1148422279,
 9661,
 -1,
 1148485532,
 9663,
 -1,
 1148388571,
 9759,
 1148732543,
 1147957361,
 -1,
 1148798078,
 1148666370,
 -1,
 1148863613,
 1148717439,
 -1,
 -48005,
 1148815495,
 9655,
 -48004,
 1148878748,
 9657,
 -1,
 1148939640,
 9659,
 -1,
 1148781787,
 9758,
 -1,
 1148725826,
 9645,
 1149256837,
 1148685778,
 -1,
 1149322372,
 1149176191,
 -1,
 1149387907,
 1149274247,
 9651,
 -1,
 1149306560,
 9708,
 -1,
 1149337500,
 9653,
 -1,
 1149240539,
 9757,
 1149650059,
 1149193588,
 -1,
 1149715594,
 1149569407,
 -1,
 -47992,
 1149667463,
 9665,
 -47991,
 1149730716,
 9667,
 -1,
 1149791608,
 9669,
 -1,
 1149633755,
 9756,
 1150043279,
 1149579968,
 -1,
 -47987,
 1149991231,
 9785,
 -47986,
 1150052386,
 10023,
 -1,
 1150112642,
 10048,
 1150305426,
 1149997800,
 -1,
 -47983,
 1150251512,
 9647,
 -1,
 1150293778,
 11006,
 1150502037,
 1150244664,
 -1,
 -47980,
 1150447497,
 9723,
 -1,
 1150506581,
 9725,
 1150698648,
 1150433608,
 -1,
 -47977,
 1150642233,
 10710,
 -1,
 1150691719,
 9825,
 -47975,
 1150649365,
 9743,
 -47974,
 1150839483,
 9649,
 -47973,
 1150901537,
 10001,
 -1,
 1150950093,
 9702,
 -1,
 1144391810,
 10163,
 -1,
 1144335066,
 9784,
 1151288490,
 1144261245,
 -1,
 1151354025,
 1151242618,
 -1,
 1151419558,
 1151310293,
 -1,
 1151485092,
 1151355725,
 -1,
 -47965,
 1151428930,
 65103,
 -1,
 1151485035,
 8967,
 -47963,
 1151428905,
 65099,
 -1,
 1151607326,
 12336,
 1151860735,
 1151346969,
 -1,
 -47960,
 1151738398,
 12316,
 -1,
 1151800360,
 10547,
 -1,
 1151304596,
 8986,
 1152074925,
 1151234161,
 -1,
 -47956,
 1152010244,
 9997,
 -1,
 1152068033,
 8768,
 1152271536,
 1152016655,
 -1,
 -47953,
 1152217499,
 8288,
 -1,
 1152277179,
 8361,
 1152516095,
 1152198935,
 -1,
 -47950,
 1152418032,
 9840,
 -1,
 1152459557,
 10172,
 1152664864,
 1144228596,
 -1,
 1152730382,
 1152608789,
 -1,
 1152795875,
 1152685335,
 -1,
 1152861380,
 1152727805,
 -1,
 1152926911,
 1152798068,
 -1,
 1152992446,
 1152843776,
 -1,
 1153057980,
 1152915514,
 -1,
 -47941,
 1153011694,
 10595,
 -1,
 1153050710,
 10606,
 -47939,
 1153009494,
 10584,
 -1,
 1153185066,
 10592,
 -1,
 1152947473,
 8639,
 1153499135,
 1152873427,
 -1,
 1153516739,
 1153368064,
 -1,
 -47934,
 1153468246,
 10580,
 -1,
 1153512746,
 10588,
 -1,
 1153471761,
 8638,
 1153778895,
 1152783375,
 8593,
 1153892351,
 1153695744,
 -1,
 1153909964,
 1153799889,
 -1,
 1153975498,
 1153861401,
 -1,
 -47927,
 1153922513,
 8625,
 -1,
 1153978100,
 8624,
 -47925,
 1153908272,
 10505,
 -1,
 1154098853,
 8670,
 -47923,
 1153861462,
 10514,
 -47922,
 1154240296,
 8645,
 -1,
 1154299178,
 8613,
 1154499801,
 1153734171,
 -1,
 1154565335,
 1154421775,
 8679,
 1154678783,
 1154482176,
 -1,
 1154696406,
 1154573139,
 8683,
 1154809855,
 1154614783,
 -1,
 -47915,
 1154716402,
 8685,
 -1,
 1154760102,
 8684,
 -1,
 1154626858,
 8682,
 1155071999,
 1154491938,
 8686,
 -1,
 1154941937,
 8687,
 1155155166,
 1154450060,
 -1,
 1155220701,
 1155111065,
 -1,
 -47908,
 1155139751,
 10569,
 -1,
 1155203810,
 8607,
 -1,
 1155168011,
 10506,
 1155482849,
 1155080578,
 -1,
 -47904,
 1155426202,
 8657,
 -1,
 1155470545,
 8673,
 -47902,
 1155428173,
 10224,
 -1,
 1155623516,
 8648,
 1155810550,
 1152740285,
 -1,
 1155876075,
 1155757017,
 -1,
 -47898,
 1155827847,
 9721,
 -47897,
 1155890441,
 10066,
 -47896,
 1155952439,
 9693,
 -47895,
 1156017060,
 10000,
 -47894,
 1156080962,
 9137,
 -1,
 1156131024,
 10064,
 1156334832,
 1155812729,
 -1,
 -47891,
 1156286599,
 9720,
 -47890,
 1156345655,
 9692,
 -47889,
 1156408678,
 9136,
 -1,
 1156456463,
 10196,
 1156662516,
 1156266544,
 -1,
 -47886,
 1156597209,
 9690,
 -47885,
 1156652479,
 9696,
 -1,
 1156716954,
 9600,
 -47883,
 1156604867,
 9620,
 -1,
 1156847992,
 9985,
 1157055755,
 1155727360,
 -1,
 1157121276,
 1156982582,
 -1,
 1157186810,
 1157043215,
 8597,
 -1,
 1157105158,
 8616,
 -47877,
 1157142050,
 8691,
 -1,
 1157244450,
 8661,
 1157448963,
 1157044034,
 -1,
 1157514496,
 1157395560,
 -1,
 -47873,
 1157461175,
 10575,
 -1,
 1157516812,
 10572,
 1157758975,
 1157451202,
 -1,
 -47870,
 1157657783,
 10573,
 -1,
 1157713420,
 10577,
 1157907719,
 1157370895,
 -1,
 1157973254,
 1157839677,
 8963,
 -1,
 1157890468,
 8996,
 -1,
 1157891513,
 10685,
 1158169865,
 1157858032,
 8869,
 -1,
 1158088229,
 10207,
 -47862,
 1158116419,
 8944,
 -1,
 1158231076,
 10622,
 1158479871,
 1156975036,
 -1,
 -47859,
 1158378628,
 9710,
 -1,
 1158434268,
 9709,
 1158628638,
 1152670370,
 -1,
 1158694171,
 1158561665,
 -1,
 1158759706,
 1158636364,
 8746,
 1158873087,
 1158676480,
 -1,
 1158890774,
 1158780625,
 -1,
 -47852,
 1158834424,
 10818,
 -47851,
 1158895853,
 10817,
 -1,
 1158959873,
 10821,
 1159152921,
 1158810334,
 -1,
 -47848,
 1159087457,
 10822,
 -1,
 1159141147,
 10824,
 -1,
 1159075942,
 10826,
 -1,
 1158714021,
 9842,
 1159528447,
 1158619522,
 -1,
 -47843,
 1159422272,
 9100,
 -1,
 1159475267,
 8255,
 -47841,
 1158574404,
 9797,
 -1,
 1159616243,
 9730,
 1159808361,
 1152618874,
 -1,
 1159873853,
 1159735575,
 -1,
 1159939388,
 1159819377,
 -1,
 1160004920,
 1159890509,
 -1,
 1160070443,
 1159940541,
 -1,
 1160135977,
 1160009387,
 12337,
 1160249343,
 1160052736,
 -1,
 -47832,
 1160154889,
 12339,
 -1,
 1160205365,
 12341,
 1160445951,
 1160091685,
 12338,
 -1,
 1160316403,
 12340,
 1160529201,
 1160007995,
 124,
 1160642559,
 1160447487,
 -1,
 1160660272,
 1160519110,
 -1,
 -47825,
 1160583153,
 10992,
 -1,
 1160645336,
 10991,
 -1,
 1160599639,
 9087,
 1160922421,
 1160451862,
 -1,
 -47821,
 1160874192,
 10978,
 -47820,
 1160914528,
 10980,
 -1,
 1160976515,
 10704,
 -47818,
 1160879190,
 10650,
 -47817,
 1161117983,
 12347,
 -1,
 1161178427,
 8942,
 1161381179,
 1159961048,
 -1,
 -47814,
 1161318343,
 8920,
 -1,
 1161377780,
 8921,
 -1,
 1161330174,
 8483,
 -1,
 1159864498,
 10799,
 1161708878,
 1159795621,
 -1,
 1161774406,
 1161628187,
 65024,
 -47808,
 1161693791,
 65039,
 -47807,
 1161759314,
 65038,
 -47806,
 1161824837,
 65037,
 -47805,
 1161890360,
 65036,
 -47804,
 1161955880,
 65035,
 -47803,
 1162021403,
 65034,
 -1,
 1162086937,
 65033,
 -47801,
 1161693819,
 65032,
 -47800,
 1162218105,
 65031,
 -47799,
 1162283628,
 65030,
 -47798,
 1162349151,
 65029,
 -47797,
 1162414674,
 65028,
 -47796,
 1162480197,
 65027,
 -47795,
 1162545720,
 65026,
 -1,
 1162611240,
 65025,
 1162823012,
 1161661563,
 -1,
 1162888534,
 1162765246,
 -1,
 -47791,
 1162839424,
 8531,
 -47790,
 1162903290,
 8537,
 -47789,
 1162964920,
 188,
 -47788,
 1163016747,
 189,
 -47787,
 1163080643,
 8533,
 -1,
 1163144352,
 8539,
 1163347294,
 1162838668,
 -1,
 1163412827,
 1163280040,
 -1,
 -47783,
 1163358158,
 190,
 -47782,
 1163408329,
 8535,
 -1,
 1163472065,
 8540,
 1163722751,
 1163368604,
 -1,
 -47779,
 1163625862,
 8532,
 -1,
 1163670473,
 8534,
 1163871587,
 1163276992,
 -1,
 1163937122,
 1163806790,
 -1,
 -47775,
 1163886336,
 8538,
 -1,
 1163930817,
 8541,
 -1,
 1163880458,
 8536,
 -1,
 1163820210,
 8542,
 1164264808,
 1162755969,
 -1,
 -47770,
 1164211019,
 9805,
 -47769,
 1164259935,
 8983,
 -1,
 1164320968,
 9996,
 -1,
 1164206823,
 8752,
 1164592519,
 1159753515,
 -1,
 1164658049,
 1164511869,
 -1,
 1164723583,
 1164585127,
 -1,
 1164789116,
 1164644771,
 -1,
 1164854649,
 1164742379,
 -1,
 1164920182,
 1164791156,
 9624,
 1165033471,
 1164836953,
 -1,
 1165051251,
 1164939039,
 -1,
 -47758,
 1164997587,
 9628,
 -1,
 1165053300,
 9627,
 1165295615,
 1164989458,
 -1,
 -47755,
 1165194195,
 9626,
 -1,
 1165249929,
 9625,
 1165492223,
 1164866515,
 9629,
 1165557759,
 1165361343,
 9630,
 -1,
 1165426895,
 9631,
 1165688831,
 1164792850,
 -1,
 -47749,
 1165587411,
 9623,
 -1,
 1165643124,
 9622,
 1165885439,
 1164742373,
 -1,
 -47746,
 1165782615,
 8279,
 -1,
 1165837600,
 10764,
 -47744,
 1164674219,
 10774,
 -1,
 1165982239,
 9833,
 1166165382,
 1164587249,
 -1,
 1166230917,
 1166082048,
 -1,
 -47740,
 1166169771,
 63,
 -1,
 1166226029,
 8264,
 -1,
 1166158460,
 8799,
 -1,
 1166108444,
 34,
 1166558626,
 1164549070,
 -1,
 1166624156,
 1166476242,
 -1,
 1166689680,
 1166572171,
 -1,
 1166755215,
 1166613835,
 -1,
 1166820750,
 1166699029,
 -1,
 -47731,
 1166768175,
 10785,
 -1,
 1166820972,
 10784,
 -1,
 1166745431,
 10783,
 -1,
 1166699976,
 10625,
 1167148438,
 1166635121,
 -1,
 1167213972,
 1167081991,
 -1,
 -47725,
 1167147837,
 10632,
 -1,
 1167202537,
 10634,
 -47723,
 1167142173,
 10814,
 -1,
 1167331590,
 10853,
 1167541657,
 1167084921,
 -1,
 -47720,
 1167475517,
 10631,
 -1,
 1167530217,
 10633,
 -47718,
 1167493853,
 10626,
 -47717,
 1167664423,
 10852,
 -1,
 1167726289,
 8959,
 1167982591,
 1166553112,
 -1,
 1168000416,
 1167875568,
 -1,
 -47713,
 1167940313,
 8204,
 -1,
 1167984661,
 65279,
 -47711,
 1167949845,
 8203,
 -1,
 1168132469,
 8205,
 1168328102,
 1166493869,
 -1,
 -47708,
 1168281305,
 9795,
 -47707,
 1168335438,
 10781,
 -1,
 1168380415,
 12292,
 1168637951,
 1168283941,
 -1,
 -47704,
 1168532767,
 8891,
 -1,
 1168573209,
 8999]
_charnames_32 = [
13407,
15406,
17798,
17443,
15920,
16646,
7955,
7910,
9130,
16166,
7940,
16616,
2754,
11576,
17267,
13326,
15990,
15984,
15970,
15972,
15980,
15982,
15975,
15977,
15988,
15986,
2796,
13371,
9271,
15359,
13893,
17795,
2753,
8544,
8879,
8860,
8732,
8629,
8907,
8810,
8823,
8670,
8911,
8870,
8780,
8897,
8714,
8489,
8892,
8913,
8795,
8765,
8694,
8587,
8887,
8849,
8903,
8750,
8837,
9057,
16333,
16116,
2219,
9304,
13895,
8108,
8431,
8367,
8222,
8062,
8464,
8397,
8350,
8271,
8459,
8421,
8197,
8447,
8314,
7967,
8441,
8473,
8247,
8293,
8020,
8153,
8454,
8410,
8469,
8334,
8383,
9097,
17707,
16154,
11855,
]

_charnames_160 = [
17370,
17114,
2947,
16657,
2938,
6242,
9632,
13374,
16009,
2779,
17304,
9229,
17322,
13330,
16352,
4143,
15741,
16633,
13127,
13128,
7949,
4945,
16664,
4943,
2948,
13141,
4142,
16197,
17746,
17747,
17752,
17111,
8580,
8581,
8547,
8575,
8562,
8572,
8582,
8863,
8660,
8662,
8632,
8650,
8690,
8692,
8683,
8678,
8667,
8727,
8536,
8538,
8512,
8520,
8509,
4481,
8531,
8625,
8627,
8617,
8590,
8763,
8713,
8313,
8146,
8147,
8111,
8141,
8126,
8137,
8148,
8370,
8093,
8095,
8065,
8083,
8289,
8291,
8282,
8277,
8106,
8328,
8012,
8014,
7990,
7998,
7987,
16002,
8007,
8192,
8194,
8184,
8157,
8348,
8059,
8340,
8577,
8143,
8564,
8128,
8576,
8142,
8869,
8377,
8865,
8373,
8868,
8376,
8866,
8374,
8741,
8227,
8737,
8234,
8651,
8084,
8661,
8094,
8648,
8081,
8657,
8090,
8643,
8076,
8813,
8400,
8820,
8407,
8819,
8406,
8814,
8401,
8831,
8358,
8834,
8361,
8680,
8279,
8687,
8286,
8691,
8290,
8686,
8285,
8676,
8245,
8916,
8485,
8912,
8462,
8873,
8424,
8430,
8793,
8214,
8784,
8201,
8785,
8202,
8791,
8205,
8787,
8211,
8730,
8331,
8722,
8323,
8723,
8324,
8332,
8669,
8107,
8526,
8003,
8537,
8013,
8508,
7986,
8915,
8483,
8808,
8264,
8804,
8259,
8805,
8260,
8777,
8305,
8771,
8299,
8772,
8300,
8768,
8296,
8699,
8042,
8700,
8043,
8704,
8049,
8612,
8179,
8620,
8187,
8626,
8193,
8622,
8189,
8601,
8168,
8623,
8190,
8857,
8419,
8762,
8347,
8756,
8848,
8396,
8841,
8391,
8844,
8388,
8215,
8437,
8886,
8884,
8436,
8710,
8056,
8540,
8867,
8375,
8586,
8747,
8745,
8229,
8037,
8809,
8779,
8541,
8909,
8466,
8818,
8822,
8365,
8693,
8685,
8876,
8427,
8210,
8221,
8712,
8719,
8318,
8530,
8492,
7970,
8543,
8019,
8894,
8443,
8947,
8709,
8055,
8668,
8936,
8051,
8707,
8053,
8705,
8604,
8171,
8628,
8890,
8757,
8341,
8845,
8392,
8663,
8666,
8103,
8102,
8949,
8711,
8057,
8944,
8948,
8952,
8951,
8953,
8937,
8749,
8736,
8241,
8794,
8788,
8219,
8731,
8728,
8333,
8554,
8118,
8684,
8283,
8519,
7997,
8619,
8186,
8593,
8160,
8596,
8163,
8595,
8162,
8594,
8161,
8036,
8563,
8127,
8559,
8123,
8584,
8150,
8816,
8403,
8815,
8402,
8874,
8425,
8533,
8009,
8534,
8010,
8665,
8101,
8463,
8748,
8735,
8237,
8821,
8408,
8836,
8859,
8729,
8330,
8573,
8138,
8585,
8151,
8532,
8008,
8561,
8125,
8578,
8144,
8649,
8082,
8658,
8091,
8677,
8275,
8688,
8287,
8507,
7985,
8535,
8011,
8802,
8254,
8807,
8262,
8600,
8167,
8624,
8191,
8770,
8298,
8697,
8040,
8764,
8349,
8833,
8360,
8717,
-1,
8542,
8018,
8847,
8395,
8558,
8122,
8641,
8074,
8510,
7988,
8522,
8000,
8503,
7981,
8504,
7982,
8760,
8345,
]

_charnames_592 = [
8028,
8152,
8029,
8439,
8016,
8372,
8230,
8236,
8269,
8309,
8310,
8017,
8266,
8267,
8382,
8243,
8405,
8311,
8923,
8409,
8270,
8035,
8363,
8366,
8284,
8292,
8921,
8204,
8209,
8212,
8220,
8026,
8027,
8452,
8320,
8329,
8928,
8440,
8927,
8381,
8446,
8022,
8024,
8025,
8256,
8261,
8263,
8268,
8926,
8922,
8307,
8104,
8244,
8312,
8105,
8033,
8050,
8195,
8196,
8457,
8032,
8031,
8030,
8925,
8393,
8386,
8096,
8100,
8945,
8950,
8943,
8932,
8941,
8931,
8380,
8924,
8930,
8461,
8034,
8929,
8474,
8946,
8935,
8239,
8246,
8240,
8058,
8060,
8061,
8468,
8218,
8217,
8940,
8942,
-1,
-1,
4705,
4706,
4712,
4703,
4701,
4702,
4714,
4709,
4707,
4766,
4738,
4763,
4778,
4731,
4727,
4723,
4773,
4730,
4724,
4728,
4749,
4736,
4745,
1863,
4761,
4755,
4779,
4772,
4717,
4719,
4720,
4721,
4764,
4770,
4742,
4743,
4748,
4735,
4767,
4753,
9633,
15915,
16208,
16865,
13295,
15816,
4732,
4744,
4713,
4711,
4710,
4708,
4704,
4776,
4769,
4754,
4718,
4775,
4757,
4758,
4760,
4750,
4739,
]

_charnames_768 = [
2667,
2689,
2639,
2694,
2727,
2741,
2719,
2615,
2617,
2732,
2653,
2612,
2633,
2724,
2601,
2611,
2635,
2711,
2698,
2629,
2656,
2630,
2668,
2690,
2583,
2648,
2575,
2731,
2582,
2736,
2616,
2738,
2729,
2739,
2658,
2614,
2618,
2652,
2631,
2641,
2742,
2723,
2717,
2714,
2634,
2640,
2720,
2712,
2697,
2728,
2591,
2609,
2696,
2704,
2588,
2705,
2589,
2647,
2713,
2707,
2708,
2746,
2725,
2608,
2669,
2691,
2662,
2663,
2664,
2661,
2718,
2681,
2600,
2574,
2748,
2733,
2692,
2578,
2735,
2670,
]

_charnames_864 = [
2603,
2610,
2607,
2569,
2566,
2564,
2562,
2559,
2568,
2567,
2565,
2563,
2561,
2560,
2558,
2557,
-1,
-1,
-1,
-1,
13850,
13808,
-1,
-1,
-1,
-1,
13846,
-1,
-1,
-1,
13848,
-1,
-1,
-1,
-1,
-1,
13841,
13825,
13737,
13852,
13708,
13695,
13757,
-1,
13667,
-1,
13772,
13654,
13575,
13710,
13794,
13791,
13792,
13697,
13784,
13670,
13780,
13740,
13790,
13789,
13788,
13787,
13785,
13656,
13777,
13782,
-1,
13786,
13781,
13760,
13778,
13793,
13776,
13629,
13748,
13768,
13539,
13506,
13494,
13593,
13548,
13509,
13625,
13622,
13616,
13495,
13617,
13466,
13609,
13569,
13613,
13621,
13620,
13619,
13618,
13452,
13606,
13600,
13623,
13598,
13610,
13542,
13607,
13624,
13605,
13423,
13572,
13545,
13463,
13566,
13451,
-1,
13851,
13842,
13832,
13834,
13833,
13817,
13816,
13838,
13804,
13541,
13799,
13597,
13803,
13615,
13802,
13612,
13800,
13599,
2773,
2764,
2777,
2768,
2774,
2765,
2775,
2766,
2776,
2767,
2772,
2763,
2778,
2769,
13837,
13844,
13806,
13801,
13795,
13807,
13845,
]

_charnames_1024 = [
2434,
2427,
2522,
2511,
2491,
2521,
2497,
2483,
2543,
2538,
2542,
2514,
2408,
2438,
2447,
2520,
2468,
2499,
2540,
2506,
2523,
2432,
2458,
2464,
2426,
2445,
2401,
2422,
2420,
2411,
2500,
2531,
2418,
2416,
2516,
2484,
2424,
2534,
2515,
2524,
2450,
2449,
2535,
2478,
2455,
2410,
2482,
2480,
2305,
2336,
2377,
2343,
2360,
2269,
2295,
2301,
2263,
2282,
2238,
2259,
2257,
2248,
2337,
2368,
2255,
2253,
2353,
2321,
2261,
2371,
2352,
2361,
2287,
2286,
2372,
2315,
2292,
2247,
2319,
2317,
2271,
2264,
2359,
2348,
2328,
2358,
2334,
2320,
2380,
2375,
2379,
2351,
2245,
2275,
2284,
2357,
2501,
2338,
2481,
2318,
2430,
2267,
2539,
2376,
2429,
2266,
2498,
2335,
2431,
2268,
2407,
2244,
2533,
2370,
2544,
2381,
2440,
2277,
2441,
2278,
2490,
2327,
2541,
2378,
2502,
2339,
2503,
2340,
2400,
2237,
2549,
2624,
2623,
2627,
2622,
-1,
2626,
2625,
2446,
2283,
2456,
2293,
2419,
2256,
2508,
2345,
2509,
2346,
2510,
2347,
2462,
2299,
2467,
2304,
2406,
2243,
2403,
2240,
2404,
2241,
2496,
2333,
2415,
2252,
2547,
2384,
2532,
2369,
2472,
2309,
2417,
2254,
2517,
2354,
2451,
2288,
2452,
2289,
2536,
2373,
2546,
2383,
2528,
2365,
2529,
2366,
2448,
2285,
2470,
2307,
2471,
2308,
2550,
2463,
2300,
2405,
2242,
2423,
2260,
2414,
2251,
2413,
2250,
2409,
2246,
2421,
2258,
-1,
2476,
2313,
2475,
2312,
2548,
2385,
2435,
2272,
2453,
2290,
2454,
2291,
2461,
2298,
2466,
2303,
2473,
2310,
2437,
2274,
2439,
2276,
2504,
2341,
2494,
2331,
2495,
2332,
2425,
2262,
2489,
2326,
2488,
2325,
2487,
2324,
2527,
2364,
-1,
-1,
2479,
2316,
-1,
-1,
-1,
-1,
-1,
-1,
2394,
2231,
2393,
2230,
2395,
2232,
2392,
2229,
2399,
2236,
2398,
2235,
2397,
2234,
2396,
2233,
]

_charnames_1329 = [
7781,
7780,
7769,
7779,
7741,
7744,
7740,
7739,
7751,
7743,
7776,
7775,
7771,
7737,
7763,
7777,
7767,
7770,
7734,
7774,
7745,
7773,
7754,
7748,
7735,
7761,
7766,
7758,
7755,
7749,
7752,
7757,
7736,
7746,
7760,
7764,
7772,
7778,
-1,
-1,
7790,
7787,
7785,
7784,
7782,
7789,
7788,
-1,
7721,
7720,
7709,
7719,
7681,
7684,
7680,
7679,
7691,
7683,
7716,
7715,
7711,
7677,
7703,
7717,
7707,
7710,
7674,
7714,
7685,
7713,
7694,
7688,
7675,
7701,
7706,
7698,
7695,
7689,
7692,
7697,
7676,
7686,
7700,
7704,
7712,
7718,
7729,
-1,
7792,
7791,
-1,
-1,
-1,
-1,
-1,
-1,
11347,
11334,
11333,
11309,
11310,
11319,
11344,
11311,
11340,
11330,
11318,
11326,
11327,
11328,
11336,
11317,
11339,
-1,
11323,
11324,
11321,
11322,
11343,
11337,
11316,
11331,
11345,
11346,
11342,
11312,
11381,
11360,
11352,
11354,
11353,
11356,
11366,
11362,
11368,
11365,
11355,
-1,
11364,
11371,
11369,
11378,
11367,
11377,
11359,
11361,
11376,
11380,
]

_charnames_1488 = [
11242,
11277,
11293,
11295,
11274,
11262,
11281,
11275,
11254,
11258,
11235,
11270,
11291,
11239,
11289,
11238,
11287,
11230,
11250,
11233,
11266,
11237,
11252,
11285,
11283,
11221,
11256,
-1,
-1,
-1,
-1,
-1,
11301,
11303,
11300,
11375,
11374,
]

_charnames_1563 = [
7610,
-1,
-1,
-1,
7652,
-1,
7184,
7205,
7201,
7478,
7197,
7339,
7192,
7420,
7027,
7024,
7077,
7524,
7172,
7289,
7098,
7084,
7396,
7508,
7304,
7325,
7315,
7108,
7088,
7501,
7222,
7380,
-1,
-1,
-1,
-1,
-1,
7636,
7442,
7544,
7269,
7487,
7554,
7232,
7145,
7475,
7216,
7336,
7613,
7622,
7629,
7612,
7621,
7628,
7602,
7598,
7653,
7650,
7649,
]

_charnames_1632 = [
7665,
7666,
7657,
7658,
7663,
7664,
7660,
7661,
7668,
7667,
7647,
7627,
7639,
7619,
7143,
7141,
7334,
7212,
7211,
7210,
7186,
7190,
7189,
7537,
7188,
7062,
7063,
7434,
7035,
7034,
7461,
7040,
7421,
7178,
7176,
7261,
7129,
7177,
7047,
7048,
7121,
7104,
7101,
7102,
7116,
7125,
7136,
7103,
7105,
7415,
7399,
7404,
7401,
7400,
7402,
7403,
7531,
7405,
7309,
7307,
7308,
7318,
7319,
7093,
7227,
7142,
7446,
7447,
7513,
7448,
7462,
7548,
7547,
7296,
7333,
7273,
7274,
7247,
7272,
7368,
7374,
7248,
7372,
7388,
7373,
7493,
7494,
7492,
7491,
7237,
7238,
7408,
7236,
7235,
7155,
7059,
7162,
7147,
7152,
7030,
7483,
7285,
7568,
7535,
7363,
7281,
7482,
7512,
7454,
7348,
7349,
7484,
7561,
7347,
7350,
7352,
7618,
7230,
7582,
7583,
7578,
7584,
7591,
7587,
7588,
7644,
7609,
7589,
7586,
7592,
7577,
7594,
7579,
7597,
7596,
7585,
7590,
7646,
7642,
7643,
7651,
7595,
-1,
-1,
15399,
15400,
15391,
15392,
15397,
15398,
15394,
15395,
15402,
15401,
7330,
7113,
7385,
7608,
7607,
-1,
12908,
12878,
12882,
12876,
12880,
12873,
12912,
12911,
12877,
12881,
12913,
12870,
12871,
12872,
-1,
12924,
12862,
12831,
12861,
12846,
12847,
12850,
12849,
12844,
12852,
12851,
12845,
12836,
12837,
12839,
12840,
12858,
12857,
12856,
12855,
12833,
12859,
12860,
12854,
12843,
12834,
12853,
12842,
12832,
12838,
-1,
-1,
-1,
12903,
12902,
12901,
12899,
12898,
12897,
12893,
12892,
12918,
12919,
12867,
12866,
12868,
12907,
12906,
12894,
12922,
12920,
12895,
12886,
12885,
12889,
12888,
12916,
12915,
12921,
12923,
]

_charnames_1920 = [
12286,
12258,
12276,
12293,
12300,
12279,
12283,
12288,
12292,
12296,
12298,
12274,
12250,
12280,
12269,
12267,
12259,
12272,
12263,
12254,
12290,
12295,
12297,
12299,
12252,
12285,
12282,
12251,
12264,
12257,
12260,
12273,
12253,
12265,
12289,
12268,
12294,
12291,
12310,
12311,
12314,
12307,
12312,
12302,
12308,
12306,
12303,
12304,
12313,
12277,
]

_charnames_2305 = [
15617,
15615,
15611,
-1,
15523,
15526,
15557,
15558,
15549,
15550,
15484,
15486,
15521,
15493,
15568,
15525,
15520,
15492,
15564,
15524,
15540,
15539,
15545,
15544,
15502,
15518,
15522,
15556,
15555,
15501,
15514,
15513,
15508,
15506,
15500,
15516,
15515,
15510,
15509,
15503,
15499,
15553,
15552,
15561,
15560,
15565,
15548,
15530,
15528,
15535,
15534,
15533,
15488,
15494,
15495,
15496,
15566,
-1,
-1,
15616,
15614,
15578,
15584,
15585,
15579,
15580,
15571,
15572,
15588,
15583,
15590,
15577,
15587,
15582,
15589,
15576,
15612,
-1,
-1,
15624,
15619,
15620,
15625,
15622,
-1,
-1,
-1,
15563,
15538,
15543,
15562,
15507,
15529,
15567,
15547,
15485,
15487,
15573,
15574,
15607,
15606,
15602,
15603,
15594,
15595,
15600,
15601,
15597,
15598,
15605,
15604,
15623,
]

_charnames_2433 = [
10405,
10406,
10402,
-1,
10323,
10326,
10345,
10346,
10334,
10335,
10302,
10304,
-1,
-1,
10360,
10325,
-1,
-1,
10356,
10324,
10341,
10340,
10349,
10348,
10315,
10352,
10351,
10344,
10343,
10313,
10309,
10308,
10320,
10319,
10314,
10311,
10310,
10322,
10321,
10316,
-1,
10338,
10337,
10355,
10354,
10357,
10333,
10295,
-1,
10358,
-1,
-1,
-1,
10329,
10328,
10330,
10359,
-1,
-1,
10404,
-1,
10370,
10373,
10374,
10371,
10372,
10363,
10364,
-1,
-1,
10376,
10369,
-1,
-1,
10375,
10368,
10403,
]

_charnames_2519 = [
10411,
-1,
-1,
-1,
-1,
10299,
10300,
-1,
10332,
10303,
10305,
10365,
10366,
-1,
-1,
10387,
10388,
10379,
10380,
10385,
10386,
10382,
10383,
10390,
10389,
10297,
10298,
10409,
10408,
10396,
10394,
10395,
10398,
10397,
10399,
10410,
]

_charnames_2562 = [
14097,
-1,
-1,
14022,
14025,
14053,
14054,
14036,
14037,
-1,
-1,
-1,
-1,
14068,
14024,
-1,
-1,
14064,
14023,
14030,
14029,
14035,
14034,
14014,
14057,
14056,
14052,
14051,
14012,
14008,
14007,
14019,
14018,
14013,
14010,
14009,
14021,
14020,
14015,
-1,
14046,
14045,
14060,
14059,
14065,
14062,
14043,
-1,
14049,
14048,
-1,
14063,
14039,
-1,
14040,
14066,
-1,
-1,
14096,
-1,
14087,
14090,
14091,
14088,
14089,
-1,
-1,
-1,
-1,
14093,
14086,
-1,
-1,
14092,
14085,
14095,
]

_charnames_2662 = [
14079,
14080,
14071,
14072,
14077,
14078,
14074,
14075,
14082,
14081,
14099,
14102,
14100,
14098,
14101,
]

_charnames_2689 = [
14001,
13999,
13995,
-1,
13916,
13919,
13942,
13943,
13928,
13929,
13921,
-1,
13978,
-1,
13958,
13918,
13977,
-1,
13955,
13917,
13938,
13937,
13946,
13945,
13908,
13949,
13948,
13941,
13940,
13906,
13902,
13901,
13913,
13912,
13907,
13904,
13903,
13915,
13914,
13909,
-1,
13932,
13931,
13952,
13951,
13956,
13953,
13954,
-1,
13935,
13934,
-1,
13923,
13926,
13925,
13927,
13957,
-1,
-1,
14000,
13998,
13964,
13969,
13970,
13967,
13968,
13965,
13966,
13973,
-1,
13975,
13963,
13972,
-1,
13974,
13962,
13996,
-1,
-1,
14002,
]

_charnames_2784 = [
13922,
-1,
-1,
-1,
-1,
-1,
13989,
13990,
13981,
13982,
13987,
13988,
13984,
13985,
13992,
13991,
]

_charnames_2817 = [
16774,
16772,
16768,
-1,
16696,
16699,
16725,
16726,
16711,
16712,
16675,
16677,
-1,
-1,
16739,
16698,
-1,
-1,
16736,
16697,
16721,
16720,
16729,
16728,
16688,
16732,
16731,
16724,
16723,
16686,
16682,
16681,
16693,
16692,
16687,
16684,
16683,
16695,
16694,
16689,
-1,
16715,
16714,
16735,
16734,
16737,
16710,
16707,
-1,
16718,
16717,
-1,
-1,
16702,
16701,
16703,
16738,
-1,
-1,
16773,
16771,
16744,
16747,
16748,
16745,
16746,
16749,
-1,
-1,
-1,
16751,
16743,
-1,
-1,
16750,
16742,
16769,
]

_charnames_2902 = [
16777,
16776,
-1,
-1,
-1,
-1,
16705,
16706,
-1,
16709,
16676,
16678,
-1,
-1,
-1,
-1,
16762,
16763,
16754,
16755,
16760,
16761,
16757,
16758,
16765,
16764,
16778,
]

_charnames_2946 = [
12108,
12106,
-1,
12044,
12047,
12066,
12067,
12053,
12054,
-1,
-1,
-1,
12068,
12069,
12046,
-1,
12064,
12065,
12045,
12074,
-1,
-1,
-1,
12042,
12077,
-1,
12075,
-1,
12041,
12056,
-1,
-1,
-1,
12040,
12057,
-1,
-1,
-1,
12043,
12039,
12072,
-1,
-1,
-1,
12073,
12070,
12063,
12062,
12052,
12051,
12050,
12071,
-1,
12059,
12060,
12076,
-1,
-1,
-1,
-1,
12082,
12087,
12088,
12083,
12084,
-1,
-1,
-1,
12089,
12090,
12081,
-1,
12085,
12086,
12080,
12107,
]

_charnames_3047 = [
12101,
12093,
12094,
12099,
12100,
12096,
12097,
12103,
12102,
12113,
12112,
12111,
]

_charnames_3073 = [
12439,
12440,
12437,
-1,
12362,
12365,
12389,
12390,
12370,
12371,
12340,
12342,
-1,
12394,
12395,
12364,
-1,
12378,
12379,
12363,
12385,
12384,
12393,
12392,
12354,
12398,
12397,
12388,
12387,
12352,
12348,
12347,
12359,
12358,
12353,
12350,
12349,
12361,
12360,
12355,
-1,
12377,
12376,
12401,
12400,
12403,
12402,
12374,
12373,
12382,
12381,
-1,
12344,
12368,
12367,
12369,
12404,
-1,
-1,
-1,
-1,
12410,
12417,
12418,
12413,
12414,
12411,
12412,
-1,
12419,
12420,
12409,
-1,
12415,
12416,
12408,
12438,
]

_charnames_3168 = [
12341,
12343,
-1,
-1,
-1,
-1,
12431,
12432,
12423,
12424,
12429,
12430,
12426,
12427,
12434,
12433,
]

_charnames_3202 = [
14669,
14667,
-1,
14591,
14594,
14618,
14619,
14599,
14600,
14569,
14571,
-1,
14623,
14624,
14593,
-1,
14607,
14608,
14592,
14614,
14613,
14622,
14621,
14583,
14627,
14626,
14617,
14616,
14581,
14577,
14576,
14588,
14587,
14582,
14579,
14578,
14590,
14589,
14584,
-1,
14606,
14605,
14630,
14629,
14632,
14631,
14603,
14602,
14611,
14610,
-1,
14573,
14597,
14596,
14598,
14633,
-1,
-1,
-1,
-1,
14640,
14647,
14648,
14643,
14644,
14641,
14642,
-1,
14649,
14650,
14639,
-1,
14645,
14646,
14638,
14668,
]

_charnames_3294 = [
14634,
-1,
14570,
14572,
-1,
-1,
-1,
-1,
14661,
14662,
14653,
14654,
14659,
14660,
14656,
14657,
14664,
14663,
]

_charnames_3330 = [
4136,
4134,
-1,
4059,
4062,
4088,
4089,
4072,
4073,
4037,
4039,
-1,
4093,
4094,
4061,
-1,
4080,
4081,
4060,
4084,
4083,
4092,
4091,
4051,
4097,
4096,
4087,
4086,
4049,
4045,
4044,
4056,
4055,
4050,
4047,
4046,
4058,
4057,
4052,
-1,
4079,
4078,
4100,
4099,
4102,
4101,
4076,
4075,
4071,
4070,
4069,
4041,
4065,
4064,
4066,
4103,
-1,
-1,
-1,
-1,
4108,
4113,
4114,
4109,
4110,
4117,
-1,
-1,
4115,
4116,
4107,
-1,
4111,
4112,
4106,
4135,
]

_charnames_3424 = [
4038,
4040,
-1,
-1,
-1,
-1,
4128,
4129,
4120,
4121,
4126,
4127,
4123,
4124,
4131,
4130,
]

_charnames_3458 = [
13093,
13095,
-1,
13002,
13006,
13000,
13001,
13034,
13035,
13052,
13053,
13029,
13030,
13032,
13033,
13058,
13059,
13005,
13055,
13056,
13003,
-1,
-1,
-1,
12994,
13017,
12996,
13019,
13063,
13041,
12997,
13020,
12995,
13018,
13046,
13045,
13040,
12988,
13011,
12991,
13014,
13025,
13038,
12989,
13012,
12992,
13015,
13049,
-1,
13039,
12993,
13016,
12998,
13021,
13022,
13004,
13060,
13062,
-1,
13050,
-1,
-1,
13061,
13044,
13024,
13048,
13064,
13026,
13065,
-1,
-1,
-1,
13094,
-1,
-1,
-1,
-1,
13090,
13078,
13086,
13077,
13085,
13076,
-1,
13083,
-1,
13089,
13069,
13084,
13074,
13073,
13072,
13071,
13088,
]

_charnames_3585 = [
12182,
12179,
12177,
12176,
12178,
12180,
12198,
12206,
12209,
12207,
12142,
12208,
12212,
12227,
12159,
12150,
12155,
12154,
12196,
12226,
12158,
12152,
12151,
12153,
12195,
12230,
12191,
12187,
12216,
12188,
12217,
12189,
12171,
12213,
12221,
12220,
12201,
12203,
12228,
12143,
12144,
12141,
12224,
12202,
12229,
12223,
12192,
12124,
12166,
12130,
12128,
12135,
12136,
12132,
12133,
12131,
12134,
12190,
-1,
-1,
-1,
-1,
12232,
12138,
12129,
12137,
12126,
12127,
12204,
12169,
12170,
12167,
12165,
12164,
12168,
12156,
12197,
12214,
12218,
12243,
12244,
12235,
12236,
12241,
12242,
12238,
12239,
12246,
12245,
12231,
12181,
]

_charnames_3713 = [
8974,
8973,
-1,
8972,
-1,
-1,
8969,
8992,
-1,
8976,
-1,
-1,
8967,
-1,
-1,
-1,
-1,
-1,
-1,
8991,
8960,
8959,
8958,
-1,
8968,
8993,
8965,
8964,
8985,
8963,
8986,
-1,
8990,
8987,
8980,
-1,
8979,
-1,
8988,
-1,
-1,
8977,
8983,
-1,
8989,
8982,
9040,
8995,
9006,
8999,
8997,
9007,
9008,
9000,
9001,
9002,
9003,
-1,
9005,
9034,
9033,
-1,
-1,
9009,
9010,
9011,
8996,
8998,
-1,
9039,
-1,
9030,
9029,
9028,
9031,
9041,
9038,
-1,
-1,
9022,
9023,
9014,
9015,
9020,
9021,
9017,
9018,
9025,
9024,
-1,
-1,
9036,
9037,
]

_charnames_3840 = [
11685,
11754,
11752,
11753,
11790,
11765,
11764,
11794,
11784,
11776,
11778,
11789,
11797,
11783,
11770,
11780,
11769,
11786,
11787,
11762,
11755,
11746,
11745,
11850,
11852,
11851,
11650,
11649,
11648,
11655,
11654,
11651,
11822,
11823,
11814,
11815,
11820,
11821,
11817,
11818,
11825,
11824,
11810,
11801,
11802,
11807,
11808,
11804,
11805,
11812,
11811,
11809,
11777,
11773,
11763,
11772,
11766,
11781,
11757,
11758,
11792,
11793,
11659,
11663,
11718,
11717,
11727,
11726,
11709,
11730,
11729,
11739,
-1,
11707,
11691,
11690,
11703,
11702,
11708,
11696,
11695,
11705,
11704,
11710,
11724,
11723,
11733,
11732,
11737,
11694,
11693,
11700,
11699,
11735,
11720,
11721,
11743,
11734,
11736,
11738,
11713,
11712,
11714,
11740,
11742,
11716,
11741,
-1,
-1,
-1,
-1,
-1,
-1,
11842,
11838,
11839,
11832,
11833,
11828,
11829,
11830,
11831,
11840,
11841,
11836,
11837,
11657,
11656,
11834,
11835,
11671,
11670,
11796,
11795,
11665,
11660,
11666,
11662,
11669,
11668,
-1,
-1,
-1,
-1,
11614,
11613,
11627,
11626,
11605,
11630,
11629,
11639,
-1,
11603,
11587,
11586,
11599,
11598,
11604,
11592,
11591,
11601,
11600,
11606,
11624,
11623,
11633,
11632,
11637,
11590,
11589,
11596,
11595,
11635,
11620,
11621,
11642,
11634,
11636,
11638,
11609,
11608,
11610,
11640,
11641,
11612,
11617,
11616,
11618,
-1,
11853,
11854,
11846,
11845,
11847,
11844,
11684,
11679,
11683,
11680,
11682,
11674,
11676,
11677,
11678,
-1,
-1,
11653,
]

_charnames_4096 = [
4822,
4821,
4830,
4829,
4789,
4833,
4832,
4825,
4824,
4788,
4786,
4799,
4798,
4805,
4804,
4787,
4801,
4800,
4807,
4806,
4790,
4816,
4815,
4836,
4835,
4843,
4839,
4841,
4819,
4840,
4811,
4844,
4818,
4837,
-1,
4826,
4827,
4812,
4813,
4845,
-1,
4842,
4838,
-1,
4858,
4854,
4855,
4852,
4853,
4859,
4857,
-1,
-1,
-1,
4868,
4867,
4863,
4864,
-1,
-1,
-1,
-1,
-1,
-1,
4884,
4885,
4876,
4877,
4882,
4883,
4879,
4880,
4887,
4886,
4866,
4865,
4870,
4872,
4873,
4871,
4810,
4809,
4792,
4793,
4794,
4795,
4848,
4849,
4850,
4851,
]

_charnames_4256 = [
14209,
14208,
14194,
14207,
14206,
14197,
14176,
14179,
14205,
14188,
14204,
14203,
14202,
14201,
14185,
14175,
14199,
14182,
14178,
14198,
14184,
14187,
14193,
14200,
14181,
14170,
14173,
14190,
14172,
14171,
14195,
14191,
14164,
14167,
14166,
14196,
14163,
14165,
]

_charnames_4304 = [
14159,
14158,
14140,
14157,
14142,
14147,
14122,
14125,
14155,
14134,
14154,
14153,
14152,
14151,
14131,
14121,
14149,
14128,
14124,
14148,
14130,
14133,
14139,
14150,
14127,
14116,
14119,
14136,
14118,
14117,
14145,
14137,
14110,
14113,
14112,
14146,
14109,
14111,
14156,
14144,
14143,
-1,
-1,
14210,
-1,
-1,
-1,
-1,
10985,
10909,
10987,
10993,
10904,
10996,
11003,
10914,
10907,
10882,
10905,
10962,
10960,
10912,
10947,
10986,
10995,
10933,
11005,
10991,
10908,
10989,
10990,
10994,
10998,
10906,
10999,
10983,
11004,
10984,
10932,
10931,
10925,
10917,
10921,
10919,
10920,
10923,
10922,
10928,
10929,
10926,
10930,
10980,
10982,
10892,
10899,
10889,
10898,
10900,
10885,
10886,
10897,
10901,
10895,
10896,
10893,
10890,
10887,
10902,
10943,
10941,
10956,
10954,
10935,
10976,
10969,
10975,
10965,
10974,
10967,
10910,
10972,
10973,
10970,
10966,
11001,
10961,
10945,
10942,
10958,
10955,
10949,
10950,
10946,
10959,
10934,
10981,
10911,
11002,
-1,
-1,
-1,
-1,
-1,
11006,
10762,
10722,
10731,
10705,
10709,
10713,
10712,
10701,
10700,
10732,
10758,
10759,
10739,
10692,
10748,
10757,
10756,
10760,
10683,
10718,
10710,
10740,
10730,
10729,
10708,
10707,
10716,
10715,
10717,
10704,
10703,
10735,
10734,
10736,
10738,
10737,
10695,
10696,
10697,
10698,
10699,
10750,
10751,
10754,
10752,
10753,
10691,
10688,
10687,
10686,
10685,
10689,
10690,
10720,
10721,
10711,
10742,
10744,
10746,
10745,
10747,
10743,
10723,
10727,
10725,
10726,
10761,
-1,
-1,
-1,
-1,
-1,
10643,
10608,
10645,
10632,
10641,
10640,
10667,
10570,
10580,
10588,
10573,
10594,
10587,
10577,
10597,
10610,
10623,
10625,
10599,
10606,
10672,
10679,
10680,
10653,
10671,
10629,
10654,
10647,
10646,
10639,
10635,
10637,
10638,
10636,
10670,
10669,
10581,
10596,
10585,
10586,
10607,
10591,
10590,
10575,
10576,
10583,
10593,
10578,
10582,
10595,
10619,
10618,
10616,
10614,
10613,
10617,
10621,
10620,
10652,
10626,
10627,
10628,
10650,
10604,
10601,
10602,
10603,
10631,
10675,
10677,
10609,
10676,
10661,
10663,
10664,
10630,
10651,
10658,
10656,
10659,
10657,
10665,
-1,
-1,
-1,
-1,
-1,
-1,
15217,
15219,
15221,
15218,
15216,
15215,
15220,
-1,
15278,
15281,
15283,
15279,
15277,
15276,
15282,
15280,
15209,
15212,
15214,
15210,
15208,
15207,
15213,
15211,
15249,
15253,
15255,
15250,
15248,
15247,
15254,
15252,
15028,
15031,
15033,
15029,
15027,
15026,
15032,
15030,
15239,
15243,
15245,
15240,
15238,
15237,
15244,
15242,
15045,
15048,
15050,
15046,
15044,
15043,
15049,
15047,
15037,
15040,
15042,
15038,
15036,
15035,
15041,
15039,
15074,
15076,
15078,
15075,
15073,
15072,
15077,
-1,
15069,
-1,
15071,
15070,
15068,
15067,
-1,
-1,
15061,
15063,
15065,
15062,
15060,
15059,
15064,
-1,
15056,
-1,
15058,
15057,
15055,
15054,
-1,
-1,
15296,
15299,
15301,
15297,
15295,
15294,
15300,
15298,
15269,
15272,
15274,
15270,
15268,
15267,
15273,
15271,
14987,
14990,
14992,
14988,
14986,
14985,
14991,
14989,
15199,
15202,
15204,
15200,
15198,
15197,
15203,
15201,
15231,
15233,
15235,
15232,
15230,
15229,
15234,
-1,
15226,
-1,
15228,
15227,
15225,
15224,
-1,
-1,
15163,
15166,
15168,
15164,
15162,
15161,
15167,
15165,
15155,
15158,
15160,
15156,
15154,
15153,
15159,
15157,
14997,
15000,
15002,
14998,
14996,
14995,
15001,
14999,
15102,
15104,
15106,
15103,
15101,
15100,
15105,
-1,
15097,
-1,
15099,
15098,
15096,
15095,
-1,
-1,
15089,
15091,
15093,
15090,
15088,
15087,
15092,
-1,
15084,
-1,
15086,
15085,
15083,
15082,
-1,
-1,
15313,
15315,
15317,
15314,
15312,
15311,
15316,
-1,
15113,
15115,
15117,
15114,
15112,
15111,
15116,
-1,
15145,
15148,
15150,
15146,
15144,
15143,
15149,
15147,
15137,
15140,
15142,
15138,
15136,
15135,
15141,
15139,
15305,
15307,
15309,
15306,
15304,
15303,
15308,
-1,
15181,
15184,
15186,
15182,
15180,
15179,
15185,
15183,
15173,
15176,
15178,
15174,
15172,
15171,
15177,
15175,
15287,
15290,
15292,
15288,
15286,
15285,
15291,
15289,
15019,
15021,
15023,
15020,
15018,
15017,
15022,
-1,
15014,
-1,
15016,
15015,
15013,
15012,
-1,
-1,
15006,
15008,
15010,
15007,
15005,
15004,
15009,
-1,
14971,
14974,
14976,
14972,
14970,
14969,
14975,
14973,
15191,
15194,
15196,
15192,
15190,
15189,
15195,
15193,
15109,
15122,
15124,
15118,
15120,
15119,
15123,
15121,
14962,
14965,
14967,
14963,
14961,
14960,
14966,
14964,
14980,
14982,
14984,
14981,
14979,
14978,
14983,
-1,
15259,
15263,
15265,
15260,
15258,
15257,
15264,
15262,
15127,
15130,
15132,
15128,
15126,
15125,
15131,
15129,
15241,
15251,
15261,
-1,
-1,
-1,
-1,
-1,
-1,
15353,
15355,
15351,
15318,
15352,
15348,
15354,
15349,
15344,
15336,
15337,
15342,
15343,
15339,
15340,
15346,
15345,
15321,
15323,
15324,
15329,
15330,
15326,
15327,
15333,
15331,
15332,
15322,
]

_charnames_5024 = [
2903,
2902,
2901,
2899,
2898,
2897,
2890,
2900,
2889,
2888,
2887,
2886,
2885,
2847,
2846,
2845,
2843,
2842,
2841,
2883,
2882,
2881,
2880,
2879,
2878,
2896,
2895,
2894,
2893,
2892,
2833,
2844,
2834,
2839,
2838,
2837,
2836,
2835,
2876,
2875,
2874,
2873,
2872,
2871,
2831,
2825,
2830,
2829,
2828,
2827,
2826,
2855,
2824,
2854,
2823,
2853,
2822,
2851,
2850,
2849,
2852,
2821,
2820,
2819,
2818,
2817,
2816,
2814,
2813,
2812,
2811,
2810,
2809,
2869,
2868,
2867,
2866,
2865,
2864,
2862,
2861,
2860,
2859,
2858,
2857,
]

_charnames_5121 = [
1851,
1843,
1848,
1850,
1845,
1846,
1664,
1352,
1350,
1836,
1842,
1370,
1445,
1480,
1441,
1481,
1442,
1473,
1439,
1474,
1440,
1496,
1482,
1443,
1483,
1444,
1497,
1840,
1661,
1854,
1727,
1725,
1726,
1721,
1720,
1719,
1716,
1715,
1724,
1722,
1723,
1717,
1852,
1849,
1847,
1844,
1815,
1810,
1813,
1814,
1811,
1812,
1659,
1292,
1291,
1808,
1809,
1807,
1428,
1803,
1424,
1804,
1425,
1801,
1422,
1802,
1423,
1805,
1426,
1806,
1427,
1658,
1799,
1420,
1283,
1599,
1594,
1597,
1598,
1595,
1596,
1662,
1211,
1210,
1592,
1593,
1581,
1418,
1577,
1414,
1578,
1415,
1575,
1412,
1576,
1413,
1579,
1416,
1580,
1417,
1499,
1546,
1572,
1571,
1570,
1573,
1798,
1793,
1796,
1797,
1794,
1795,
1668,
1791,
1792,
1790,
1453,
1786,
1449,
1787,
1450,
1784,
1447,
1785,
1448,
1788,
1451,
1789,
1452,
1502,
1782,
1783,
1649,
1648,
1647,
1650,
1368,
1354,
1365,
1366,
1363,
1364,
1669,
1150,
1353,
1362,
1461,
1358,
1457,
1359,
1458,
1356,
1455,
1357,
1456,
1360,
1459,
1361,
1460,
1503,
1149,
1617,
1749,
1755,
1756,
1757,
1746,
1747,
1666,
1753,
1754,
1745,
1437,
1741,
1433,
1742,
1434,
1739,
1431,
1740,
1432,
1743,
1435,
1744,
1436,
1501,
1737,
1429,
1758,
1839,
1618,
1545,
1505,
1542,
1543,
1540,
1541,
1665,
1485,
1504,
1535,
1471,
1533,
1469,
1534,
1470,
1500,
1484,
1313,
1544,
1709,
1704,
1707,
1708,
1705,
1706,
1667,
1702,
1703,
1694,
1397,
1690,
1393,
1691,
1394,
1688,
1391,
1689,
1392,
1692,
1395,
1693,
1396,
1686,
1389,
1752,
1654,
1620,
1652,
1653,
1645,
1651,
1663,
1601,
1619,
1644,
1380,
1640,
1376,
1641,
1377,
1638,
1374,
1639,
1375,
1642,
1378,
1643,
1379,
1490,
1600,
1838,
1637,
1776,
1748,
1488,
1494,
1492,
1491,
1489,
1493,
1636,
1632,
1633,
1630,
1631,
1634,
1635,
1629,
1388,
1625,
1384,
1626,
1385,
1623,
1382,
1624,
1383,
1627,
1386,
1628,
1387,
1621,
1685,
1680,
1683,
1684,
1681,
1682,
1660,
1678,
1679,
1677,
1409,
1673,
1405,
1674,
1406,
1671,
1403,
1672,
1404,
1675,
1407,
1676,
1408,
1498,
1655,
1781,
1401,
1616,
1825,
1826,
1399,
1819,
1822,
1823,
1820,
1821,
1398,
1817,
1818,
1400,
1824,
1463,
1816,
1462,
1751,
1736,
1731,
1711,
1728,
1732,
1733,
1729,
1730,
1734,
1472,
1710,
1563,
1539,
1558,
1537,
1559,
1538,
1556,
1557,
1560,
1561,
1562,
1419,
1547,
1568,
1567,
1566,
1569,
1565,
1585,
1584,
1583,
1586,
1514,
1510,
1511,
1508,
1509,
1512,
1513,
1507,
1515,
1853,
1830,
1834,
1835,
1832,
1833,
1828,
1829,
1827,
1590,
1589,
1588,
1591,
1466,
1465,
1464,
1467,
1519,
1523,
1524,
1521,
1522,
1517,
1518,
1516,
1525,
1606,
1605,
1604,
1607,
1478,
1477,
1476,
1479,
1475,
1698,
1699,
1696,
1697,
1700,
1701,
1695,
1555,
1551,
1552,
1549,
1550,
1553,
1554,
1548,
1841,
1779,
1778,
1777,
1780,
1764,
1763,
1762,
1765,
1769,
1768,
1767,
1770,
1774,
1773,
1772,
1775,
1611,
1610,
1609,
1612,
1273,
1274,
1271,
1272,
1275,
1276,
1332,
1333,
1330,
1331,
1334,
1335,
1325,
1326,
1323,
1324,
1327,
1328,
1287,
1288,
1285,
1286,
1289,
1290,
1191,
1192,
1189,
1190,
1193,
1194,
1163,
1164,
1161,
1162,
1165,
1166,
1303,
1304,
1301,
1302,
1305,
1306,
1300,
1279,
1280,
1277,
1278,
1281,
1282,
1237,
1238,
1235,
1236,
1239,
1240,
1230,
1231,
1228,
1229,
1232,
1233,
1227,
1310,
1311,
1308,
1309,
1312,
1314,
1339,
1340,
1337,
1338,
1341,
1342,
1318,
1319,
1316,
1317,
1320,
1321,
1265,
1614,
1266,
1263,
1264,
1267,
1615,
1268,
1259,
1260,
1257,
1258,
1261,
1262,
1251,
1252,
1249,
1250,
1253,
1254,
1206,
1207,
1204,
1205,
1208,
1209,
1245,
1246,
1243,
1244,
1247,
1248,
1171,
1172,
1169,
1170,
1173,
1174,
1177,
1178,
1175,
1176,
1179,
1180,
1296,
1297,
1294,
1295,
1298,
1299,
1293,
1351,
1199,
1200,
1197,
1198,
1201,
1202,
1222,
1223,
1220,
1221,
1224,
1225,
1216,
1217,
1214,
1215,
1218,
1219,
1213,
1184,
1185,
1182,
1183,
1186,
1187,
1346,
1347,
1344,
1345,
1348,
1349,
1157,
1158,
1155,
1156,
1159,
1160,
1367,
1735,
1831,
1520,
1528,
1529,
1526,
1527,
1530,
1531,
]

_charnames_5760 = [
16862,
16860,
16856,
16858,
16839,
16844,
16832,
16859,
16852,
16850,
16851,
16855,
16857,
16845,
16838,
16853,
16861,
16842,
16830,
16835,
16847,
16836,
16841,
16831,
16848,
16834,
16854,
16864,
16863,
-1,
-1,
-1,
16301,
16293,
16294,
16279,
16278,
16280,
16284,
16252,
16274,
16232,
16277,
16276,
16239,
16221,
16230,
16235,
16234,
16295,
16286,
16264,
16287,
16268,
16253,
16271,
16272,
16281,
16289,
16290,
16241,
16224,
16298,
16222,
16259,
16248,
16251,
16300,
16270,
16242,
16226,
16247,
16297,
16275,
16228,
16229,
16220,
16262,
16291,
16283,
16219,
16256,
16302,
16225,
16258,
16233,
16254,
16299,
16240,
16223,
16243,
16260,
16246,
16245,
16261,
16231,
16255,
16249,
16266,
16267,
16265,
16227,
16238,
16218,
16250,
16296,
16292,
16304,
16305,
16306,
16308,
16303,
16307,
]

_charnames_5888 = [
12008,
12003,
11996,
12002,
12005,
11992,
11997,
12006,
11993,
11999,
12007,
12000,
11994,
-1,
12001,
11995,
11998,
12004,
12011,
12010,
12012,
]

_charnames_5920 = [
11048,
11043,
11035,
11042,
11045,
11031,
11036,
11046,
11032,
11039,
11047,
11040,
11033,
11038,
11041,
11034,
11037,
11044,
11051,
11050,
11052,
16666,
16667,
]

_charnames_5952 = [
10540,
10535,
10527,
10534,
10537,
10523,
10528,
10538,
10524,
10531,
10539,
10532,
10525,
10530,
10533,
10526,
10529,
10536,
10543,
10542,
]

_charnames_5984 = [
12031,
12027,
12020,
12026,
12028,
12016,
12021,
12029,
12017,
12023,
12030,
12024,
12018,
-1,
12025,
12019,
12022,
-1,
12034,
12033,
]

_charnames_6016 = [
14831,
14829,
14830,
14828,
14825,
14837,
14835,
14836,
14834,
14822,
14852,
14815,
14851,
14814,
14824,
14820,
14818,
14819,
14817,
14823,
14859,
14845,
14846,
14844,
14857,
14853,
14855,
14848,
14854,
14840,
14839,
14841,
14858,
14849,
14856,
14921,
14923,
14927,
14928,
14915,
14918,
14916,
14917,
14930,
14931,
14932,
14933,
14929,
14922,
14926,
14925,
14920,
14911,
14912,
14896,
14903,
14904,
14897,
14898,
14900,
14901,
14902,
14908,
14899,
14905,
14909,
14895,
14894,
14907,
14893,
14887,
14876,
14883,
14888,
14872,
14865,
14875,
14873,
14870,
14882,
14885,
14884,
14878,
14863,
14869,
14864,
14879,
14889,
14866,
14886,
14868,
14948,
14881,
-1,
-1,
-1,
14944,
14945,
14936,
14937,
14942,
14943,
14939,
14940,
14947,
14946,
]

_charnames_6144 = [
4696,
4695,
4689,
4683,
4690,
4684,
4692,
4693,
4687,
4686,
4694,
4682,
4680,
4681,
4691,
-1,
4673,
4674,
4665,
4666,
4671,
4672,
4668,
4669,
4676,
4675,
-1,
-1,
-1,
-1,
-1,
-1,
4541,
4645,
4657,
4637,
4635,
4638,
4636,
4646,
4655,
4577,
4662,
4654,
4653,
4659,
4606,
4641,
4605,
4604,
4540,
4661,
4649,
4656,
4650,
4652,
4651,
4660,
4644,
4643,
4539,
4634,
4658,
4632,
4640,
4633,
4648,
4532,
4536,
4534,
4516,
4511,
4517,
4512,
4510,
4538,
4529,
4528,
4521,
4531,
4515,
4525,
4537,
4520,
4514,
4526,
4527,
4533,
4522,
4535,
4519,
4530,
4524,
4600,
4588,
4589,
4584,
4583,
4603,
4597,
4592,
4590,
4596,
4594,
4587,
4601,
4598,
4599,
4593,
4591,
4586,
4582,
4595,
4602,
4581,
4629,
4628,
4627,
4630,
4626,
]

_charnames_6272 = [
4555,
4571,
4551,
4572,
4567,
4576,
4547,
4554,
4566,
4574,
4565,
4575,
4546,
4545,
4553,
4564,
4548,
4550,
4562,
4561,
4573,
4558,
4559,
4556,
4509,
4508,
4624,
4622,
4620,
4623,
4613,
4617,
4614,
4616,
4621,
4619,
4610,
4611,
4570,
4569,
4625,
4552,
]

_charnames_7680 = [
8574,
8139,
8883,
8435,
8882,
8434,
8885,
8438,
8864,
8371,
8744,
8233,
8743,
8232,
8746,
8235,
8740,
8226,
8739,
8225,
8653,
8086,
8654,
8087,
8640,
8073,
8656,
8089,
8642,
8075,
8910,
8467,
8817,
8404,
8828,
8355,
8827,
8354,
8829,
8356,
8832,
8359,
8835,
8364,
8681,
8280,
8679,
8278,
8878,
8429,
8877,
8428,
8875,
8426,
8789,
8206,
8790,
8207,
8792,
8213,
8783,
8200,
8902,
8453,
8901,
8451,
8900,
8450,
8726,
8327,
8725,
8326,
8718,
8319,
8721,
8322,
8524,
8002,
8523,
8001,
8528,
8005,
8529,
8006,
8896,
8445,
8895,
8444,
8801,
8253,
8799,
8251,
8800,
8252,
8806,
8257,
8776,
8304,
8774,
8302,
8778,
8306,
8769,
8297,
8775,
8303,
8703,
8047,
8702,
8046,
8706,
8052,
8698,
8041,
8597,
8164,
8614,
8181,
8618,
8185,
8615,
8182,
8621,
8188,
8889,
8456,
8891,
8458,
8856,
8418,
8858,
8420,
8855,
8416,
8854,
8415,
8853,
8414,
8905,
8471,
8906,
8472,
8755,
8339,
8843,
8387,
8840,
8390,
8846,
8394,
8362,
8048,
8417,
8344,
8140,
8216,
-1,
-1,
-1,
-1,
8560,
8124,
8579,
8145,
8553,
8117,
8551,
8115,
8550,
8114,
8549,
8113,
8552,
8116,
8570,
8134,
8568,
8132,
8567,
8131,
8566,
8130,
8569,
8133,
8647,
8080,
8659,
8092,
8655,
8088,
8639,
8072,
8637,
8070,
8636,
8069,
8635,
8068,
8638,
8071,
8689,
8288,
8675,
8276,
8505,
7983,
8499,
7977,
8518,
7996,
8516,
7994,
8515,
7993,
8514,
7992,
8517,
7995,
8498,
7976,
8496,
7974,
8495,
7973,
8494,
7972,
8497,
7975,
8602,
8169,
8611,
8178,
8610,
8177,
8608,
8175,
8607,
8174,
8606,
8173,
8609,
8176,
8761,
8346,
8754,
8338,
8758,
8342,
8759,
8343,
-1,
-1,
-1,
-1,
-1,
-1,
13512,
13523,
13514,
13525,
13518,
13529,
13516,
13527,
13713,
13724,
13719,
13730,
13721,
13732,
13716,
13727,
13497,
13501,
13499,
13503,
13500,
13504,
-1,
-1,
13699,
13703,
13701,
13705,
13702,
13706,
-1,
-1,
13469,
13480,
13471,
13482,
13475,
13486,
13473,
13484,
13673,
13684,
13679,
13690,
13681,
13692,
13676,
13687,
13584,
13578,
13586,
13580,
13588,
13582,
13587,
13581,
13749,
13743,
13751,
13745,
13753,
13747,
13752,
13746,
13454,
13458,
13456,
13460,
13457,
13461,
-1,
-1,
13658,
13662,
13660,
13664,
13661,
13665,
-1,
-1,
13557,
13551,
13559,
13553,
13561,
13555,
13560,
13554,
-1,
13763,
-1,
13765,
-1,
13767,
-1,
13766,
13426,
13437,
13428,
13439,
13432,
13443,
13430,
13441,
13632,
13643,
13638,
13649,
13640,
13651,
13635,
13646,
13533,
13536,
13505,
13507,
13489,
13491,
13592,
13594,
13462,
13464,
13565,
13567,
13446,
13448,
-1,
-1,
13520,
13531,
13515,
13526,
13519,
13530,
13517,
13528,
13718,
13729,
13720,
13731,
13722,
13733,
13717,
13728,
13477,
13488,
13472,
13483,
13476,
13487,
13474,
13485,
13678,
13689,
13680,
13691,
13682,
13693,
13677,
13688,
13434,
13445,
13429,
13440,
13433,
13444,
13431,
13442,
13637,
13648,
13639,
13650,
13641,
13652,
13636,
13647,
13535,
13540,
13534,
13538,
13537,
-1,
13521,
13522,
13735,
13739,
13736,
13738,
13723,
13839,
13815,
13810,
13818,
13823,
13490,
13493,
13492,
-1,
13478,
13479,
13707,
13709,
13694,
13696,
13683,
13812,
13814,
13813,
13591,
13595,
13574,
13577,
-1,
-1,
13589,
13576,
13755,
13759,
13756,
13758,
-1,
13828,
13830,
13829,
13564,
13568,
13547,
13550,
13602,
13603,
13562,
13549,
13770,
13774,
13771,
13773,
13783,
13822,
13824,
13847,
-1,
-1,
13447,
13450,
13449,
-1,
13435,
13436,
13666,
13668,
13653,
13655,
13642,
13849,
13826,
-1,
15462,
15433,
15461,
15432,
12320,
17278,
13117,
17293,
16668,
12332,
11206,
17824,
17822,
17825,
9226,
16194,
11574,
17368,
17294,
15463,
15434,
11567,
15791,
15780,
9071,
16127,
13099,
13102,
9147,
16176,
15779,
15814,
16022,
15810,
10545,
12487,
16909,
12516,
11566,
11575,
9366,
16546,
9227,
16195,
16658,
9225,
16193,
17455,
16643,
16642,
16612,
15794,
12458,
16326,
16319,
16317,
1860,
13100,
13101,
16353,
15815,
17090,
16908,
17693,
2906,
1861,
7942,
11577,
17288,
9064,
16123,
15813,
17796,
15405,
11865,
16327,
10468,
10455,
9306,
16323,
2919,
12518,
2752,
-1,
-1,
-1,
-1,
17789,
]

_charnames_8287 = [
4924,
17582,
17270,
17119,
17120,
-1,
-1,
-1,
-1,
-1,
-1,
17131,
7951,
17132,
7952,
17454,
17369,
13138,
13124,
-1,
-1,
13133,
13134,
13130,
13131,
13137,
13142,
13140,
13143,
13136,
13125,
13139,
13123,
13181,
13184,
13170,
13171,
13176,
13177,
13173,
13174,
13180,
13185,
13183,
13186,
13179,
13187,
13182,
]

_charnames_8352 = [
15469,
2798,
2953,
17290,
9367,
4944,
17457,
16649,
16309,
17583,
17407,
15919,
15470,
14953,
12532,
16025,
14217,
16648,
]

_charnames_8400 = [
2581,
2646,
2590,
2706,
2686,
2638,
2576,
2649,
2651,
2637,
2685,
2700,
2749,
2676,
2674,
2680,
2677,
2579,
2675,
2679,
2678,
2657,
2602,
2687,
2699,
2747,
2584,
]

_charnames_8448 = [
7953,
7959,
15828,
15743,
2946,
1862,
1866,
15471,
13349,
15742,
13347,
13340,
10512,
15826,
16636,
16637,
13339,
10511,
13338,
13346,
9369,
15825,
17452,
13325,
13336,
15820,
15824,
13335,
10510,
15823,
16586,
16350,
13377,
12443,
12490,
17723,
15822,
16902,
16910,
17112,
10509,
12530,
14951,
7925,
13343,
10513,
15474,
13348,
13342,
13341,
12531,
13337,
13345,
7937,
10415,
14254,
16021,
17124,
16387,
-1,
-1,
15836,
15827,
15821,
15837,
12525,
12524,
16324,
12523,
15835,
15834,
15833,
15832,
15831,
16608,
12528,
]

_charnames_8531 = [
17744,
17756,
17748,
17757,
17753,
17762,
17745,
17760,
17749,
17754,
17761,
17763,
17289,
16371,
16358,
16362,
16370,
16365,
16377,
16378,
16381,
16383,
16360,
16380,
16359,
16369,
16375,
16368,
16373,
13248,
13238,
13240,
13247,
13244,
13253,
13254,
13257,
13258,
13241,
13256,
13239,
13246,
13251,
13245,
13250,
16374,
16367,
16361,
16382,
]

_charnames_8592 = [
9156,
17604,
16030,
15851,
9073,
17656,
17343,
17355,
13312,
13320,
9161,
16041,
9219,
16110,
9216,
17628,
16092,
15878,
9160,
16033,
9174,
17614,
16055,
15862,
17657,
9164,
16044,
9163,
16043,
9084,
9077,
15883,
17609,
17608,
15856,
15855,
16045,
15859,
7916,
2924,
17346,
9169,
7917,
2925,
9192,
9199,
17603,
17598,
16070,
16077,
15876,
15871,
16057,
17613,
9179,
9221,
17634,
16112,
15886,
9200,
16078,
9207,
9083,
16102,
9203,
17631,
16098,
15881,
9080,
17659,
17352,
17363,
13318,
13324,
9215,
16095,
9220,
16111,
17611,
15858,
9211,
17632,
16106,
15882,
9168,
16049,
9218,
17616,
16108,
15884,
17622,
17618,
17621,
17620,
17623,
17624,
16109,
17347,
13315,
17658,
16140,
15861,
12322,
9159,
16040,
9076,
9165,
16038,
9078,
9222,
16113,
9085,
17282,
2757,
16550,
12327,
12328,
15424,
17127,
17458,
15409,
17316,
13265,
2790,
15904,
13277,
15466,
17430,
17415,
17424,
4930,
4939,
15912,
16001,
13375,
7941,
16205,
10546,
12700,
2939,
17277,
16607,
17122,
16130,
7921,
4890,
13401,
16004,
15907,
16545,
17331,
9340,
9329,
17076,
17680,
17093,
15807,
12468,
2791,
13228,
17768,
2926,
2922,
7914,
12329,
10420,
16392,
16606,
15914,
15407,
14215,
11572,
11856,
16315,
17113,
13103,
17580,
17325,
4938,
7943,
17315,
7905,
7908,
17405,
7930,
17317,
7932,
12466,
7934,
15386,
14213,
16014,
7909,
14214,
7906,
17135,
2799,
15373,
16206,
16207,
2803,
15473,
15387,
13395,
15744,
15381,
4907,
17797,
17330,
17070,
17333,
13398,
9245,
13863,
9248,
13868,
9270,
13889,
4498,
4499,
10414,
17329,
17332,
17334,
17394,
17399,
9244,
13862,
17393,
17398,
9246,
13864,
17395,
17400,
16587,
13208,
16600,
13221,
16599,
13220,
15898,
15905,
13189,
13145,
17314,
17313,
13196,
13152,
17404,
17403,
13198,
13154,
4492,
4495,
4494,
12777,
12758,
12780,
12761,
12723,
12725,
2178,
2192,
2186,
2172,
2174,
2188,
2194,
2199,
2175,
12821,
12822,
12819,
12824,
16165,
9121,
15888,
17671,
7944,
4781,
12491,
17281,
12454,
15788,
15900,
17324,
15909,
17389,
16601,
13222,
17364,
2788,
17365,
2789,
16779,
17134,
4496,
11449,
17092,
17831,
17456,
17339,
16134,
16162,
17427,
17426,
17431,
17416,
16007,
15913,
13393,
16003,
10286,
9153,
16190,
9070,
16128,
16316,
2934,
2935,
15770,
15768,
15806,
15804,
16660,
15382,
9264,
13884,
17721,
17722,
9272,
13894,
15379,
15380,
15378,
15377,
15899,
15906,
17321,
17320,
12779,
12760,
9269,
13888,
16602,
13223,
17326,
15902,
17327,
15903,
17719,
4942,
17673,
15890,
15416,
15412,
13267,
15417,
15415,
13268,
15413,
15414,
2786,
2784,
13275,
2785,
13276,
17819,
16008,
15421,
11569,
17668,
15892,
16609,
16644,
17571,
9103,
16160,
9144,
16184,
10279,
10282,
12499,
12502,
16331,
12767,
7801,
13378,
13373,
12444,
16656,
17766,
16638,
12529,
17577,
11570,
12503,
12500,
10283,
10280,
12505,
10284,
17285,
13307,
17669,
16895,
15446,
17832,
14950,
9231,
16199,
15447,
10412,
2551,
7935,
12980,
12506,
16013,
2794,
13389,
2802,
2801,
7883,
7877,
7831,
7812,
7813,
7829,
7824,
7857,
7860,
7878,
7901,
7825,
7832,
7820,
7830,
7890,
7885,
7821,
7826,
7862,
7840,
7852,
7810,
7815,
7841,
7872,
7817,
7867,
7848,
7818,
7814,
7868,
7844,
7809,
7834,
7851,
7853,
7893,
7859,
7870,
7835,
7858,
7823,
7869,
7849,
7876,
7894,
7861,
7842,
7891,
7898,
7899,
7863,
7847,
7897,
7875,
7879,
7828,
7827,
7843,
7871,
7881,
7886,
7887,
7896,
7900,
7882,
7888,
7895,
17335,
16133,
13362,
10419,
17712,
17133,
2792,
16011,
15430,
2756,
17479,
15465,
7936,
11450,
2153,
2185,
9631,
17692,
4697,
11578,
16893,
16892,
16554,
16553,
16012,
13329,
7805,
15745,
16603,
17406,
16611,
2929,
9132,
9134,
9133,
16168,
16170,
16169,
9065,
9067,
9066,
16124,
16126,
16125,
9099,
9100,
9101,
2936,
16156,
16157,
16158,
17107,
11565,
17646,
17641,
13226,
13227,
12504,
10276,
10277,
16391,
9152,
16189,
11564,
11563,
11562,
11561,
15721,
15724,
15729,
15739,
15734,
15728,
15738,
15733,
15726,
15737,
15732,
15735,
15730,
15722,
15725,
12812,
16349,
]

_charnames_9216 = [
12963,
12932,
12931,
12955,
12953,
12957,
12979,
12971,
12972,
12977,
12976,
12973,
12965,
12968,
12934,
12935,
12948,
12944,
12942,
12943,
12945,
12962,
12936,
12954,
12969,
12956,
12928,
12958,
12966,
12978,
12975,
12974,
12937,
12946,
10518,
16889,
12961,
12947,
12929,
]

_charnames_9280 = [
16878,
16876,
16879,
16877,
16870,
16869,
16868,
16880,
16873,
16875,
16872,
]

_charnames_9312 = [
2168,
2159,
2160,
2165,
2166,
2162,
2163,
2170,
2169,
2091,
2116,
2074,
2090,
2108,
2111,
2113,
2114,
2117,
2118,
2060,
16537,
16529,
16530,
16535,
16536,
16532,
16533,
16539,
16538,
16516,
16524,
16514,
16515,
16521,
16522,
16518,
16519,
16525,
16526,
16513,
15985,
15971,
15973,
15981,
15983,
15976,
15978,
15989,
15987,
17439,
17449,
17437,
17438,
17446,
17447,
17442,
17444,
17450,
17451,
17436,
16509,
16508,
16507,
16506,
16505,
16504,
16503,
16502,
16501,
16500,
16499,
16498,
16497,
16496,
16495,
16494,
16493,
16492,
16491,
16490,
16489,
16488,
16487,
16486,
16485,
16484,
1927,
1926,
1925,
1924,
1923,
1922,
1921,
1920,
1919,
1918,
1917,
1916,
1915,
1914,
1913,
1912,
1911,
1910,
1909,
1908,
1907,
1906,
1905,
1904,
1903,
1902,
1900,
1899,
1898,
1897,
1896,
1895,
1894,
1893,
1892,
1891,
1890,
1889,
1888,
1887,
1886,
1885,
1884,
1883,
1882,
1881,
1880,
1879,
1878,
1877,
1876,
1875,
2167,
17386,
17377,
17378,
17383,
17384,
17380,
17381,
17387,
17388,
17376,
15761,
15753,
15754,
15759,
15760,
15756,
15757,
15763,
15762,
15764,
-1,
10065,
10151,
10044,
10137,
10058,
10144,
10057,
10143,
10061,
10147,
10060,
10146,
10026,
10082,
10091,
10124,
10027,
10085,
10094,
10125,
10042,
10155,
10164,
10135,
10043,
10158,
10167,
10134,
10046,
10185,
10165,
10090,
10189,
10081,
10156,
10139,
10047,
10186,
10168,
10093,
10190,
10084,
10159,
10140,
10028,
10074,
10204,
10087,
10096,
10200,
10070,
10126,
10040,
10073,
10203,
10160,
10169,
10199,
10069,
10136,
10048,
10072,
10202,
10187,
10170,
10095,
10191,
10075,
10205,
10076,
10206,
10086,
10161,
10198,
10068,
10141,
10031,
10129,
10030,
10128,
10119,
10106,
10098,
10102,
10116,
10099,
10103,
10117,
10172,
10176,
10112,
10173,
10177,
10113,
10181,
10193,
10108,
10182,
10194,
10109,
10100,
10104,
10118,
10174,
10178,
10114,
10183,
10195,
10110,
10054,
10055,
10052,
10051,
10034,
10035,
10036,
10062,
10037,
10064,
10024,
10148,
10130,
10150,
10122,
10063,
10041,
10149,
10133,
17651,
9299,
9298,
9296,
9293,
9301,
9295,
9300,
17269,
9069,
9117,
9142,
9150,
9118,
9137,
9138,
16181,
9356,
4923,
16020,
17652,
16179,
17787,
17786,
17774,
17781,
17780,
17778,
17777,
17782,
17783,
17784,
10446,
17464,
17476,
17480,
12663,
12660,
12662,
12654,
12656,
12664,
10443,
17483,
10461,
17534,
10502,
17552,
10504,
17561,
10490,
17537,
10491,
17539,
10457,
17530,
10458,
17531,
10459,
17532,
10482,
17524,
10483,
17525,
10465,
17543,
10466,
17544,
10467,
17545,
10476,
17517,
17521,
17295,
9350,
17491,
15918,
2212,
10547,
10433,
2211,
2214,
2210,
2205,
2204,
2216,
9151,
16182,
17117,
17116,
17649,
9291,
17645,
17639,
9282,
9289,
17650,
9292,
10472,
10473,
10488,
10487,
17563,
12659,
12661,
12655,
12658,
17478,
17538,
17677,
17676,
9048,
17474,
17470,
17469,
17473,
17495,
17498,
17497,
17494,
17644,
17637,
9287,
17555,
10494,
17556,
10495,
9281,
10444,
2928,
17695,
13413,
2758,
10445,
17485,
9359,
12331,
13229,
7945,
15716,
2793,
16896,
10503,
17560,
10551,
10554,
10553,
13410,
-1,
-1,
17487,
10448,
-1,
16330,
10469,
10460,
17546,
17540,
17533,
17526,
13415,
1867,
16390,
10562,
1865,
7926,
16783,
2905,
2951,
2952,
13396,
17302,
7958,
11205,
16651,
6241,
12477,
12476,
12478,
12474,
12472,
12473,
12475,
12479,
17565,
17548,
17482,
10442,
17484,
17296,
9051,
4925,
17305,
15477,
4139,
17827,
13409,
17694,
17408,
16634,
7800,
12115,
14218,
1856,
9273,
17765,
9368,
13350,
13411,
1868,
7960,
16662,
17506,
17508,
17507,
17510,
17505,
17509,
10428,
10430,
10429,
10432,
10427,
10431,
10447,
17559,
17520,
10438,
17486,
10498,
10479,
17515,
11571,
17792,
15458,
10418,
10417,
4478,
4477,
4476,
17585,
15476,
17690,
16346,
16345,
16344,
16343,
16342,
16341,
16340,
16347,
10492,
16348,
16549,
-1,
-1,
15997,
15996,
15995,
15994,
15993,
15992,
17501,
17502,
10435,
10436,
]

_charnames_9985 = [
17653,
10449,
9302,
17489,
-1,
12445,
12116,
7961,
15464,
-1,
-1,
17767,
17579,
9283,
16650,
17640,
17562,
10505,
2904,
11433,
4491,
11444,
10555,
11394,
16900,
11446,
16886,
11440,
8917,
13365,
16899,
4138,
13394,
17274,
17276,
11447,
17275,
10500,
17549,
-1,
13399,
2182,
16887,
10439,
16901,
11439,
16663,
13364,
11448,
16888,
15457,
15454,
15453,
13114,
15452,
11423,
12519,
13116,
12447,
16885,
11399,
13115,
10501,
17550,
15455,
2197,
11398,
13414,
11867,
11432,
13406,
11406,
10556,
15456,
11422,
-1,
13366,
-1,
9284,
17642,
9279,
17638,
-1,
-1,
-1,
10480,
-1,
9355,
4922,
11441,
11404,
11405,
11427,
11428,
-1,
-1,
2937,
11424,
11445,
11393,
16385,
17306,
16386,
4916,
4911,
4921,
4920,
4918,
4913,
11417,
11411,
11418,
11412,
9358,
9357,
4917,
4912,
15949,
15941,
15942,
15947,
15948,
15944,
15945,
15951,
15950,
15952,
15964,
15956,
15957,
15962,
15963,
15959,
15960,
15966,
15965,
15967,
15935,
15927,
15928,
15933,
15934,
15930,
15931,
15937,
15936,
15938,
11436,
-1,
-1,
-1,
11407,
11413,
11443,
16024,
11414,
12486,
11401,
16017,
11429,
10453,
12318,
12319,
10454,
11392,
11391,
12826,
11434,
16202,
9234,
10557,
17286,
11419,
11442,
17338,
-1,
17337,
2154,
17564,
10515,
10516,
10517,
11386,
11387,
11388,
12448,
11400,
17586,
11437,
16894,
]

_charnames_10192 = [
17519,
7927,
15419,
9285,
17647,
9139,
16178,
17268,
9044,
9047,
9128,
9127,
9154,
9326,
9318,
17672,
9351,
17511,
17514,
17513,
17471,
17477,
4029,
4025,
4031,
4027,
4030,
4026,
-1,
-1,
-1,
-1,
17633,
15885,
7919,
2927,
16141,
9312,
9323,
9317,
9310,
9321,
9316,
9313,
9324,
9311,
9322,
9325,
9629,
9374,
9502,
9375,
9566,
9439,
9503,
9376,
9598,
9471,
9535,
9408,
9567,
9440,
9504,
9377,
9614,
9487,
9551,
9424,
9583,
9456,
9520,
9393,
9599,
9472,
9536,
9409,
9568,
9441,
9505,
9378,
9622,
9495,
9559,
9432,
9591,
9464,
9528,
9401,
9607,
9480,
9544,
9417,
9576,
9449,
9513,
9386,
9615,
9488,
9552,
9425,
9584,
9457,
9521,
9394,
9600,
9473,
9537,
9410,
9569,
9442,
9506,
9379,
9626,
9499,
9563,
9436,
9595,
9468,
9532,
9405,
9611,
9484,
9548,
9421,
9580,
9453,
9517,
9390,
9619,
9492,
9556,
9429,
9588,
9461,
9525,
9398,
9604,
9477,
9541,
9414,
9573,
9446,
9510,
9383,
9623,
9496,
9560,
9433,
9592,
9465,
9529,
9402,
9608,
9481,
9545,
9418,
9577,
9450,
9514,
9387,
9616,
9489,
9553,
9426,
9585,
9458,
9522,
9395,
9601,
9474,
9538,
9411,
9570,
9443,
9507,
9380,
9628,
9501,
9565,
9438,
9597,
9470,
9534,
9407,
9613,
9486,
9550,
9423,
9582,
9455,
9519,
9392,
9621,
9494,
9558,
9431,
9590,
9463,
9527,
9400,
9606,
9479,
9543,
9416,
9575,
9448,
9512,
9385,
9625,
9498,
9562,
9435,
9594,
9467,
9531,
9404,
9610,
9483,
9547,
9420,
9579,
9452,
9516,
9389,
9618,
9491,
9555,
9428,
9587,
9460,
9524,
9397,
9603,
9476,
9540,
9413,
9572,
9445,
9509,
9382,
9627,
9500,
9564,
9437,
9596,
9469,
9533,
9406,
9612,
9485,
9549,
9422,
9581,
9454,
9518,
9391,
9620,
9493,
9557,
9430,
9589,
9462,
9526,
9399,
9605,
9478,
9542,
9415,
9574,
9447,
9511,
9384,
9624,
9497,
9561,
9434,
9593,
9466,
9530,
9403,
9609,
9482,
9546,
9419,
9578,
9451,
9515,
9388,
9617,
9490,
9554,
9427,
9586,
9459,
9523,
9396,
9602,
9475,
9539,
9412,
9571,
9444,
9508,
9381,
16088,
16089,
9206,
16101,
9082,
16090,
9208,
16103,
15857,
17610,
17629,
15879,
9210,
16105,
9214,
16094,
16091,
16039,
17612,
15860,
16035,
16036,
16084,
16086,
16087,
9180,
16058,
9209,
16104,
9170,
16048,
9175,
16056,
17351,
17362,
17348,
17360,
13314,
13322,
17350,
17361,
13317,
13323,
16211,
17300,
13316,
17358,
17301,
16210,
17359,
17349,
17576,
7795,
7796,
7799,
7798,
16201,
9233,
12495,
10285,
12497,
12496,
9280,
9288,
7915,
2923,
16053,
9178,
13360,
16042,
9162,
16050,
9079,
17627,
9108,
9110,
17663,
17665,
9107,
17662,
9111,
17666,
9190,
16068,
17601,
15874,
9195,
16073,
17596,
15869,
9191,
16069,
17602,
15875,
9196,
16074,
17597,
15870,
9188,
17594,
16067,
15868,
9189,
9198,
16066,
16076,
9187,
9197,
16065,
16075,
17595,
15867,
16173,
15364,
11861,
9177,
16052,
16054,
9256,
9173,
13876,
13207,
9172,
13163,
9143,
16185,
17674,
15891,
12455,
17807,
17817,
9089,
16146,
9093,
16150,
17815,
17810,
17816,
17811,
9063,
16122,
9061,
16121,
9062,
16120,
9125,
16136,
9129,
16142,
15784,
15812,
9113,
16187,
15917,
17717,
4905,
16137,
4906,
7924,
7948,
13404,
13403,
12527,
16328,
7923,
16329,
16905,
16906,
4894,
4895,
4903,
4904,
4897,
4900,
4898,
4901,
16332,
15428,
15426,
15427,
15429,
2215,
2196,
2180,
2189,
2179,
2217,
2207,
2195,
17670,
2183,
2200,
1928,
2198,
2208,
2213,
12820,
12823,
12825,
12818,
12817,
12515,
12485,
12483,
13416,
12484,
16163,
9119,
17716,
10289,
10288,
10506,
11864,
11863,
17558,
10497,
9095,
16152,
9146,
16175,
17129,
11868,
17123,
15848,
12665,
17128,
13367,
15366,
15367,
17071,
14253,
12330,
15895,
15894,
10478,
10474,
17500,
10437,
15438,
15442,
15439,
15443,
15440,
15444,
16310,
16336,
13327,
16335,
10560,
10561,
15797,
12459,
9230,
16198,
11866,
4940,
17414,
17413,
17412,
17419,
17418,
17423,
17422,
12511,
12510,
17429,
4780,
13225,
17790,
17297,
17103,
17105,
2220,
7918,
9364,
9363,
9365,
17106,
17791,
17101,
17099,
17102,
17097,
17100,
17098,
17828,
9046,
17806,
17805,
17804,
16624,
16626,
16621,
16625,
16620,
16623,
16627,
4936,
4935,
4934,
4933,
16631,
16630,
17724,
4490,
4489,
13370,
13306,
4486,
4485,
2191,
4487,
2173,
16629,
4937,
4484,
17091,
16203,
17812,
7956,
17081,
17684,
17683,
17079,
17080,
17685,
17687,
17083,
17688,
17084,
17689,
17085,
2916,
2918,
15773,
15772,
2917,
9346,
9336,
15783,
15782,
12514,
12513,
13387,
13388,
9339,
9348,
9337,
9349,
9338,
9345,
9347,
9344,
13294,
9335,
9334,
17818,
17813,
15370,
17072,
12465,
12464,
11860,
11859,
13111,
2795,
15372,
7931,
7907,
15365,
16632,
15363,
15765,
12517,
12323,
15369,
15385,
9265,
13885,
9263,
13883,
9238,
13856,
9242,
13860,
9240,
13858,
9241,
13859,
9247,
13865,
9260,
13880,
9261,
13881,
9258,
13878,
9253,
13873,
9254,
13874,
9257,
13877,
9255,
13875,
13381,
13383,
13382,
13384,
15846,
15847,
15841,
15842,
13106,
13107,
13109,
13110,
15799,
15801,
15800,
13867,
13890,
9266,
13891,
9267,
13892,
13304,
9049,
13305,
9050,
15371,
16592,
13213,
16591,
13212,
16596,
13217,
16594,
13215,
16597,
13218,
16595,
13216,
15796,
15769,
13202,
13158,
13200,
13156,
13201,
13157,
13197,
13153,
13194,
13150,
13192,
13148,
13195,
13151,
13193,
13149,
12772,
12690,
2914,
2912,
2915,
2913,
13205,
13162,
13206,
13161,
13165,
13166,
15420,
16661,
12489,
17280,
17367,
13361,
13358,
13354,
16645,
17714,
15790,
17715,
15789,
9327,
13359,
13356,
13357,
15809,
15803,
15774,
16321,
15908,
17711,
17710,
15889,
16544,
16543,
12456,
12453,
12469,
12461,
12462,
15843,
15844,
12467,
9045,
15775,
17553,
17428,
]

_charnames_11904 = [
1116,
1003,
1025,
1023,
1024,
1134,
1053,
1110,
1141,
1140,
1137,
1026,
1037,
1036,
1077,
1075,
1076,
1078,
1031,
1109,
1030,
1029,
1094,
1093,
1097,
1113,
-1,
1008,
1038,
1047,
1138,
1045,
1005,
1065,
1064,
1144,
1133,
1132,
1017,
1007,
1136,
1089,
1055,
1104,
1034,
1033,
1060,
1019,
975,
1121,
1119,
1120,
1122,
1049,
1039,
1114,
1105,
1145,
1058,
1057,
1050,
1046,
1128,
1126,
1127,
1108,
1002,
1071,
1070,
977,
1016,
1096,
974,
976,
1143,
999,
1014,
1068,
1067,
1006,
991,
1081,
1080,
988,
992,
1044,
1043,
1115,
1059,
982,
989,
996,
985,
1103,
1101,
1102,
995,
1095,
997,
1054,
1129,
986,
1000,
978,
1013,
1018,
984,
1087,
994,
1086,
981,
1088,
998,
1107,
1085,
980,
]

_charnames_12032 = [
14535,
14464,
14314,
14293,
14288,
14483,
14368,
14466,
14455,
14461,
14498,
14502,
14318,
14402,
14554,
14367,
14534,
14563,
14528,
14425,
14274,
14506,
14489,
14379,
14327,
14289,
14411,
14527,
14544,
14444,
14499,
14493,
14304,
14516,
14518,
14496,
14354,
14428,
14417,
14513,
14553,
14310,
14470,
14403,
14273,
14442,
14505,
14427,
14536,
14372,
14330,
14279,
14317,
14468,
14369,
14281,
14338,
14309,
14345,
14266,
14486,
14476,
14320,
14477,
14346,
14510,
14303,
14328,
14542,
14307,
14547,
14306,
14296,
14448,
14362,
14471,
14262,
14335,
14437,
14322,
14404,
14396,
14409,
14267,
14422,
14383,
14408,
14387,
14319,
14475,
14294,
14388,
14401,
14321,
14526,
14560,
14453,
14377,
14305,
14465,
14562,
14385,
14340,
14301,
14316,
14433,
14311,
14326,
14500,
14272,
14540,
14264,
14275,
14363,
14521,
14413,
14268,
14356,
14507,
14300,
14559,
14549,
14284,
14398,
14537,
14543,
14529,
14492,
14344,
14454,
14450,
14286,
14541,
14446,
14375,
14533,
14342,
14263,
14405,
14520,
14378,
14552,
14349,
14421,
14410,
14436,
14287,
14482,
14271,
14557,
14358,
14530,
14357,
14283,
14514,
14512,
14397,
14341,
14415,
14352,
14447,
14420,
14416,
14430,
14325,
14556,
14517,
14467,
14523,
14443,
14292,
14280,
14511,
14348,
14424,
14389,
14459,
14365,
14462,
14308,
14460,
14431,
14394,
14494,
14487,
14392,
14481,
14339,
14366,
14478,
14384,
14298,
14414,
14522,
14382,
14353,
14297,
14334,
14434,
14488,
14561,
14451,
14350,
14501,
14391,
14361,
14331,
14509,
14548,
14495,
14374,
14332,
14371,
14395,
]

_charnames_12272 = [
17049,
17053,
17050,
17052,
17055,
17047,
17046,
17045,
17042,
17041,
17044,
17054,
-1,
-1,
-1,
-1,
17061,
17058,
17067,
16010,
17829,
17065,
17059,
17063,
9124,
16135,
9148,
16174,
9102,
16159,
9090,
16147,
9114,
16188,
16654,
14216,
9120,
16164,
9094,
16151,
9091,
16148,
9092,
16149,
17575,
16320,
15795,
9305,
16655,
11025,
11013,
11016,
11023,
11024,
11020,
11021,
11027,
11026,
17064,
17062,
17056,
17068,
11007,
11009,
17573,
17701,
17705,
17703,
17706,
17704,
2177,
17014,
11018,
11014,
11017,
17718,
4141,
16551,
17060,
17066,
-1,
11468,
11554,
11466,
11552,
11463,
11550,
11467,
11553,
11465,
11551,
11515,
11527,
11513,
11525,
11511,
11523,
11514,
11526,
11512,
11524,
11473,
11485,
11471,
11483,
11469,
11481,
11472,
11484,
11470,
11482,
11491,
11533,
11489,
11531,
11464,
11487,
11529,
11490,
11532,
11488,
11530,
11479,
11477,
11475,
11478,
11476,
11521,
11539,
11503,
11519,
11537,
11501,
11517,
11535,
11499,
11520,
11538,
11502,
11518,
11536,
11500,
11509,
11507,
11505,
11508,
11506,
11458,
11548,
11456,
11546,
11457,
11547,
11497,
11495,
11493,
11496,
11494,
11462,
11544,
11542,
11543,
11541,
11474,
11549,
11461,
11460,
-1,
-1,
2744,
2745,
14806,
14807,
11556,
11555,
11557,
14809,
14709,
14800,
14707,
14798,
14703,
14796,
14708,
14799,
14704,
14797,
14762,
14774,
14760,
14772,
14758,
14770,
14761,
14773,
14759,
14771,
14714,
14726,
14712,
14724,
14710,
14722,
14713,
14725,
14711,
14723,
14738,
14780,
14736,
14778,
14697,
14734,
14776,
14737,
14779,
14735,
14777,
14720,
14718,
14716,
14719,
14717,
14768,
14786,
14750,
14766,
14784,
14748,
14764,
14782,
14746,
14767,
14785,
14749,
14765,
14783,
14747,
14756,
14754,
14752,
14755,
14753,
14691,
14795,
14689,
14793,
14690,
14794,
14744,
14742,
14740,
14743,
14741,
14702,
14791,
14789,
14790,
14788,
14715,
14728,
14695,
14694,
14732,
14730,
14731,
14729,
14802,
14808,
14803,
14801,
14804,
-1,
-1,
-1,
-1,
-1,
10256,
10263,
10264,
10268,
10269,
10260,
10242,
10265,
10245,
10266,
10267,
10252,
10262,
10258,
10241,
10255,
10251,
10261,
10239,
10254,
10250,
10209,
10226,
10218,
10224,
10215,
10223,
10213,
10230,
10210,
10219,
10212,
10221,
10222,
10233,
10248,
10236,
10259,
10243,
10247,
-1,
-1,
-1,
-1,
10839,
10791,
10840,
10842,
10848,
10847,
10869,
10787,
10802,
10812,
10816,
10805,
10815,
10811,
10807,
10817,
10855,
10819,
10789,
10821,
10795,
10788,
10874,
10876,
10794,
10877,
10841,
10870,
10830,
10879,
10861,
10864,
10782,
10783,
10867,
10865,
10770,
10765,
10871,
10852,
10853,
10872,
10777,
10878,
10851,
10850,
10854,
10772,
10866,
10784,
10873,
11008,
10790,
10844,
10845,
10846,
10813,
10810,
10806,
10808,
10814,
10858,
10860,
10859,
10838,
10828,
10826,
10824,
10823,
10829,
10827,
10835,
10837,
10800,
10799,
10797,
10798,
10801,
10831,
10792,
10766,
10768,
10769,
10836,
10793,
10771,
10779,
10780,
10781,
10775,
10774,
10776,
10862,
10863,
-1,
17033,
17031,
17032,
17020,
17018,
17025,
17021,
17028,
17036,
17026,
17030,
17019,
17024,
17034,
17035,
17029,
10257,
10240,
10253,
10246,
10225,
10220,
10231,
10228,
10237,
10211,
10234,
10249,
10238,
10244,
10216,
10214,
10217,
10232,
10229,
10235,
10272,
10271,
10273,
10274,
]

_charnames_12784 = [
14693,
14701,
14700,
14698,
14705,
14687,
14685,
14683,
14686,
14684,
14706,
14681,
14679,
14677,
14680,
14678,
16467,
16475,
16457,
16473,
16477,
16462,
16471,
16479,
16450,
16454,
16469,
16459,
16464,
16481,
16468,
16476,
16458,
16474,
16478,
16463,
16472,
16480,
16453,
16455,
16470,
16460,
16465,
16482,
16452,
-1,
-1,
-1,
16444,
16425,
16426,
16416,
16413,
16410,
16406,
16430,
16436,
16427,
16439,
16414,
16434,
16433,
16440,
16431,
16401,
16404,
16446,
16409,
16437,
16408,
16415,
16442,
16445,
16422,
16443,
16403,
16400,
16429,
16421,
16447,
16417,
16420,
16407,
16423,
]

_charnames_12881 = [
2071,
2063,
2064,
2069,
2070,
2066,
2067,
2073,
2072,
2076,
2087,
2079,
2080,
2085,
2086,
2132,
2145,
2122,
2143,
2147,
2127,
2141,
2149,
2137,
2139,
2134,
2124,
2129,
2151,
2133,
2146,
2123,
2144,
2148,
2128,
2142,
2150,
2138,
2140,
2135,
2125,
2130,
2152,
-1,
-1,
-1,
14952,
1998,
1976,
1977,
1949,
1946,
1943,
1939,
1967,
1981,
1978,
1962,
1947,
1990,
1989,
1960,
1968,
1933,
1937,
1993,
1942,
1983,
1941,
1948,
1973,
1987,
1940,
1963,
1950,
1934,
1965,
1997,
1995,
1999,
1954,
1972,
1971,
1992,
1974,
1985,
1986,
1957,
1961,
1956,
1936,
1932,
1966,
1955,
1996,
1982,
2082,
2083,
2089,
2088,
2094,
2105,
2097,
2098,
2103,
2104,
2100,
2101,
2107,
2106,
2110,
17003,
17013,
17006,
17009,
17005,
17001,
17002,
17008,
17010,
17011,
17012,
16962,
-1,
-1,
-1,
-1,
2056,
2054,
2052,
2055,
2053,
2036,
2034,
2032,
2035,
2033,
2012,
2010,
2008,
2011,
2009,
2006,
2004,
2002,
2005,
2003,
2024,
2022,
2020,
2023,
2021,
2042,
2040,
2038,
2041,
2039,
2030,
2028,
2026,
2029,
2027,
2051,
2049,
2050,
2018,
2016,
2014,
2017,
2015,
2047,
2045,
2046,
2044,
-1,
12799,
12798,
12800,
12802,
12776,
12775,
12814,
12787,
12788,
12764,
12763,
12601,
12600,
12599,
12709,
12710,
12705,
12704,
12608,
12703,
12593,
12596,
12595,
12594,
12706,
12707,
12603,
12604,
12617,
12606,
12607,
12744,
12743,
12747,
12741,
12740,
12791,
12794,
12792,
12809,
12731,
12735,
12684,
12631,
12630,
12751,
12637,
12635,
12636,
12755,
12672,
12671,
12752,
12670,
12682,
12626,
12625,
12681,
12624,
12627,
12756,
12640,
12754,
12677,
12639,
12675,
12676,
12550,
12549,
12553,
12551,
12552,
12565,
12562,
12563,
12571,
12572,
12573,
12806,
12805,
12807,
12688,
12689,
12696,
12695,
12699,
12698,
12667,
16997,
16998,
16975,
16977,
16986,
16989,
16981,
16983,
16992,
16995,
16979,
16994,
16974,
16978,
16987,
16990,
16982,
16984,
16993,
16996,
16967,
16972,
16970,
16971,
16973,
12679,
12790,
12797,
12750,
12762,
12649,
-1,
-1,
-1,
-1,
12786,
12784,
12783,
12785,
12721,
12632,
12730,
12546,
12547,
12597,
12619,
12578,
12714,
12724,
12618,
12648,
12737,
12545,
12544,
12585,
12616,
12685,
12615,
12584,
12713,
12810,
12543,
12583,
12793,
12613,
12813,
12736,
12542,
12566,
12716,
12587,
12568,
12718,
12559,
12592,
12569,
12719,
12560,
12590,
12556,
12557,
12628,
12612,
12581,
12712,
12691,
12692,
12693,
12643,
12734,
12541,
12580,
12642,
12733,
12540,
12576,
12610,
12577,
12641,
12732,
12539,
12574,
12609,
12575,
12620,
12558,
12801,
12753,
12727,
12726,
12728,
12720,
12795,
12711,
12683,
12678,
12774,
12614,
12591,
12611,
12771,
12770,
12768,
12769,
12579,
12564,
12582,
12647,
12646,
12645,
12644,
12746,
12745,
12666,
-1,
-1,
16961,
16936,
16942,
16950,
16953,
16945,
16947,
16956,
16959,
16943,
16958,
16935,
16941,
16951,
16954,
16946,
16948,
16957,
16960,
16921,
16932,
16924,
16925,
16930,
16931,
16927,
16928,
16934,
16933,
16939,
16940,
]

_charnames_40960 = [
6148,
6147,
6142,
6149,
6145,
6144,
6143,
6146,
6156,
6155,
6154,
6157,
6159,
6158,
6160,
6152,
6151,
6150,
6153,
6162,
6161,
6128,
5510,
5509,
5504,
5511,
5507,
5506,
5505,
5508,
5524,
5523,
5522,
5525,
5497,
5496,
5498,
5520,
5519,
5518,
5521,
5527,
5526,
5528,
5502,
5501,
5495,
5503,
5500,
5499,
5516,
5515,
5512,
5517,
5514,
5513,
5952,
5951,
5947,
5953,
5949,
5948,
5950,
5966,
5965,
5964,
5967,
5940,
5939,
5941,
5962,
5961,
5960,
5963,
5945,
5944,
5938,
5946,
5943,
5942,
5958,
5957,
5954,
5959,
5956,
5955,
5478,
5477,
5472,
5479,
5475,
5474,
5473,
5476,
5490,
5489,
5488,
5491,
5465,
5464,
5466,
5486,
5485,
5484,
5487,
5493,
5492,
5494,
5470,
5469,
5463,
5471,
5468,
5467,
5482,
5481,
5480,
5483,
4987,
4986,
4982,
4988,
4984,
4983,
4985,
5007,
5006,
5005,
5008,
5003,
5002,
5001,
5004,
4999,
4998,
4995,
5000,
4997,
4996,
4993,
4992,
4989,
4994,
4991,
4990,
5196,
5195,
5191,
5197,
5193,
5192,
5194,
5209,
5208,
5207,
5210,
5184,
5183,
5185,
5205,
5204,
5203,
5206,
5189,
5188,
5182,
5190,
5187,
5186,
5201,
5198,
5202,
5200,
5199,
5691,
5690,
5686,
5692,
5688,
5687,
5689,
5703,
5702,
5701,
5704,
5679,
5678,
5677,
5680,
5699,
5698,
5697,
5700,
5706,
5705,
5684,
5683,
5676,
5685,
5682,
5681,
5695,
5694,
5693,
5696,
6097,
6096,
6095,
6098,
6101,
6100,
6099,
6102,
6104,
6103,
6105,
6089,
6088,
6085,
6090,
6087,
6086,
6093,
6092,
6091,
6094,
5912,
5911,
5906,
5913,
5909,
5908,
5907,
5910,
5932,
5931,
5930,
5933,
5928,
5927,
5926,
5929,
5935,
5936,
5924,
5923,
5920,
5925,
5922,
5921,
5918,
5917,
5914,
5919,
5916,
5915,
5804,
5803,
5799,
5805,
5801,
5800,
5802,
5812,
5811,
5810,
5813,
5795,
5794,
5808,
5807,
5806,
5809,
5815,
5814,
5816,
5797,
5796,
5791,
5798,
5793,
5792,
6013,
6012,
6008,
6014,
6010,
6009,
6011,
6021,
6020,
6019,
6022,
6001,
6000,
5999,
6002,
6017,
6016,
6015,
6018,
6024,
6023,
6025,
6006,
6005,
5998,
6007,
6004,
6003,
5778,
5777,
5773,
5779,
5775,
5774,
5776,
5786,
5785,
5784,
5787,
5766,
5765,
5767,
5782,
5781,
5780,
5783,
5789,
5788,
5790,
5771,
5770,
5764,
5772,
5769,
5768,
5070,
5069,
5066,
5071,
5068,
5067,
5078,
5077,
5076,
5079,
5074,
5073,
5072,
5075,
5081,
5080,
5082,
5064,
5063,
5060,
5065,
5062,
5061,
5242,
5241,
5236,
5243,
5239,
5238,
5237,
5240,
5246,
5245,
5244,
5247,
5250,
5249,
5254,
5253,
5255,
5257,
5256,
5258,
5251,
5135,
5134,
5130,
5136,
5132,
5131,
5133,
5145,
5144,
5146,
5123,
5122,
5124,
5139,
5138,
5137,
5140,
5142,
5141,
5143,
5128,
5127,
5121,
5129,
5126,
5125,
5163,
5162,
5158,
5164,
5160,
5159,
5161,
5173,
5172,
5171,
5174,
5151,
5150,
5152,
5176,
5175,
5177,
5179,
5178,
5180,
5156,
5155,
5149,
5157,
5154,
5153,
5169,
5168,
5165,
5170,
5167,
5166,
5886,
5885,
5880,
5887,
5883,
5882,
5881,
5884,
5900,
5899,
5898,
5901,
5873,
5872,
5871,
5874,
5896,
5895,
5894,
5897,
5903,
5902,
5904,
5878,
5877,
5870,
5879,
5876,
5875,
5892,
5891,
5888,
5893,
5890,
5889,
5638,
5637,
5632,
5639,
5635,
5634,
5633,
5636,
5650,
5649,
5648,
5651,
5625,
5624,
5623,
5626,
5642,
5641,
5640,
5643,
5646,
5645,
5644,
5647,
5630,
5629,
5622,
5631,
5628,
5627,
6070,
6069,
6065,
6071,
6067,
6066,
6068,
6082,
6081,
6080,
6083,
6058,
6057,
6059,
6074,
6073,
6072,
6075,
6078,
6077,
6076,
6079,
6063,
6062,
6056,
6064,
6061,
6060,
5609,
5608,
5604,
5606,
5605,
5607,
5620,
5619,
5618,
5621,
5597,
5596,
5595,
5598,
5612,
5611,
5610,
5613,
5616,
5615,
5614,
5617,
5602,
5601,
5594,
5603,
5600,
5599,
5675,
5674,
5669,
5668,
5667,
5670,
5656,
5655,
5657,
5665,
5664,
5663,
5666,
5672,
5671,
5673,
5661,
5660,
5654,
5662,
5659,
5658,
5218,
5217,
5212,
5219,
5215,
5214,
5213,
5216,
5230,
5229,
5228,
5231,
5222,
5221,
5220,
5223,
5226,
5225,
5224,
5227,
5233,
5232,
5234,
5116,
5115,
5117,
5110,
5109,
5108,
5111,
5114,
5113,
5112,
5106,
5105,
5104,
5107,
5119,
5118,
5120,
5274,
5273,
5272,
5269,
5268,
5267,
5270,
5261,
5260,
5259,
5262,
5265,
5264,
5263,
5266,
5276,
5275,
5277,
6134,
6133,
6132,
6135,
6130,
6129,
6131,
6137,
6136,
6138,
6140,
6139,
6141,
5351,
5350,
5346,
5352,
5348,
5347,
5349,
5365,
5364,
5363,
5366,
5339,
5338,
5340,
5361,
5360,
5359,
5362,
5368,
5367,
5369,
5344,
5343,
5337,
5345,
5342,
5341,
5357,
5356,
5353,
5358,
5355,
5354,
5573,
5572,
5567,
5574,
5570,
5569,
5568,
5571,
5587,
5586,
5585,
5588,
5560,
5559,
5561,
5583,
5582,
5581,
5584,
5590,
5589,
5591,
5565,
5564,
5558,
5566,
5563,
5562,
5579,
5578,
5575,
5580,
5577,
5576,
5286,
5285,
5280,
5287,
5283,
5282,
5281,
5284,
5301,
5300,
5299,
5302,
5304,
5303,
5305,
5307,
5306,
5308,
5297,
5294,
5298,
5296,
5295,
5292,
5291,
5288,
5293,
5290,
5289,
4964,
4963,
4959,
4965,
4961,
4960,
4962,
4974,
4973,
4972,
4975,
4956,
4955,
4977,
4978,
4980,
4979,
4957,
4952,
4958,
4954,
4953,
4970,
4969,
4966,
4971,
4968,
4967,
5442,
5441,
5437,
5443,
5439,
5438,
5440,
5456,
5455,
5454,
5457,
5430,
5429,
5431,
5452,
5451,
5450,
5453,
5459,
5458,
5460,
5435,
5434,
5428,
5436,
5433,
5432,
5448,
5447,
5444,
5449,
5446,
5445,
5377,
5376,
5372,
5378,
5374,
5373,
5375,
5395,
5394,
5393,
5396,
5391,
5390,
5389,
5392,
5398,
5397,
5399,
5387,
5386,
5385,
5388,
5383,
5382,
5379,
5384,
5381,
5380,
5335,
5334,
5333,
5336,
5312,
5311,
5313,
5327,
5326,
5325,
5328,
5331,
5330,
5329,
5332,
5317,
5316,
5310,
5318,
5315,
5314,
5323,
5322,
5319,
5324,
5321,
5320,
5556,
5555,
5554,
5557,
5534,
5533,
5532,
5535,
5548,
5547,
5546,
5549,
5552,
5551,
5550,
5553,
5538,
5531,
5539,
5537,
5536,
5544,
5543,
5540,
5545,
5542,
5541,
5842,
5841,
5823,
5822,
5835,
5834,
5833,
5836,
5839,
5838,
5837,
5840,
5825,
5824,
5819,
5826,
5821,
5820,
5831,
5830,
5827,
5832,
5829,
5828,
5054,
5053,
5052,
5055,
5057,
5056,
5058,
5050,
5049,
5048,
5051,
5046,
5045,
5042,
5047,
5044,
5043,
5040,
5039,
5036,
5041,
5038,
5037,
5426,
5425,
5424,
5427,
5403,
5402,
5404,
5418,
5417,
5416,
5419,
5422,
5421,
5420,
5423,
5408,
5407,
5401,
5409,
5406,
5405,
5414,
5413,
5410,
5415,
5412,
5411,
5864,
5863,
5862,
5865,
5845,
5844,
5846,
5860,
5859,
5858,
5861,
5867,
5866,
5868,
5850,
5849,
5843,
5851,
5848,
5847,
5856,
5855,
5852,
5857,
5854,
5853,
5750,
5749,
5744,
5751,
5747,
5746,
5745,
5748,
5737,
5736,
5735,
5738,
5760,
5759,
5758,
5761,
5742,
5741,
5734,
5743,
5740,
5739,
5756,
5755,
5752,
5757,
5754,
5753,
6043,
6042,
6037,
6044,
6040,
6039,
6038,
6041,
6030,
6029,
6028,
6031,
6053,
6052,
6051,
6054,
6035,
6034,
6027,
6036,
6033,
6032,
6049,
6048,
6045,
6050,
6047,
6046,
5724,
5723,
5718,
5725,
5721,
5720,
5719,
5722,
5711,
5710,
5712,
5732,
5731,
5730,
5733,
5716,
5715,
5709,
5717,
5714,
5713,
5728,
5727,
5726,
5729,
5016,
5015,
5010,
5017,
5013,
5012,
5011,
5014,
5022,
5021,
5033,
5032,
5031,
5034,
5023,
5018,
5024,
5020,
5019,
5029,
5028,
5025,
5030,
5027,
5026,
5090,
5089,
5084,
5091,
5087,
5086,
5085,
5088,
5094,
5093,
5095,
5101,
5100,
5099,
5102,
5097,
5096,
5092,
5098,
6113,
6112,
6107,
6114,
6110,
6109,
6108,
6111,
6126,
6125,
6123,
6122,
6121,
6124,
6119,
6118,
6115,
6120,
6117,
6116,
5985,
5984,
5979,
5986,
5982,
5981,
5980,
5983,
5972,
5971,
5970,
5973,
5995,
5994,
5993,
5996,
5977,
5976,
5969,
5978,
5975,
5974,
5991,
5990,
5987,
5992,
5989,
5988,
-1,
-1,
-1,
6239,
6211,
6230,
6195,
6167,
6184,
6188,
6190,
6228,
6208,
6213,
6237,
6227,
6215,
6225,
6206,
6222,
6191,
6174,
6166,
6234,
6236,
6187,
6194,
6221,
6240,
6201,
6176,
6224,
6209,
6216,
6218,
6180,
6219,
6177,
6203,
6196,
6200,
6189,
6202,
6238,
6233,
6181,
6212,
6165,
6168,
6169,
6207,
6183,
6173,
6182,
6170,
6175,
6197,
6231,
]

_charnames_63744 = [
856,
855,
854,
853,
852,
851,
850,
849,
848,
847,
846,
845,
844,
843,
842,
841,
839,
838,
837,
836,
835,
834,
833,
832,
831,
830,
829,
828,
827,
826,
825,
824,
822,
821,
820,
819,
818,
817,
816,
815,
814,
813,
812,
811,
810,
809,
808,
807,
805,
804,
803,
802,
801,
800,
799,
798,
797,
796,
795,
794,
793,
792,
791,
790,
788,
787,
786,
785,
784,
783,
782,
781,
780,
779,
778,
777,
776,
775,
774,
773,
771,
770,
769,
768,
767,
766,
765,
764,
763,
762,
761,
760,
759,
758,
757,
756,
754,
753,
752,
751,
750,
749,
748,
747,
746,
745,
744,
743,
742,
741,
740,
739,
737,
736,
735,
734,
733,
732,
731,
730,
729,
728,
727,
726,
725,
724,
723,
722,
720,
719,
718,
717,
716,
715,
714,
713,
712,
711,
710,
709,
708,
707,
706,
705,
703,
702,
701,
700,
699,
698,
697,
696,
695,
694,
693,
692,
691,
690,
689,
688,
686,
685,
684,
683,
682,
681,
680,
679,
678,
677,
676,
675,
674,
673,
672,
671,
669,
668,
667,
666,
665,
664,
663,
662,
661,
660,
659,
658,
657,
656,
655,
654,
652,
651,
650,
649,
648,
647,
646,
645,
644,
643,
642,
641,
640,
639,
638,
637,
635,
634,
633,
632,
631,
630,
629,
628,
627,
626,
625,
624,
623,
622,
621,
620,
618,
617,
616,
615,
614,
613,
612,
611,
610,
609,
608,
607,
606,
605,
604,
603,
601,
600,
599,
598,
597,
596,
595,
594,
593,
592,
591,
590,
589,
588,
587,
586,
942,
941,
940,
939,
938,
937,
936,
935,
934,
933,
932,
931,
930,
929,
928,
927,
925,
924,
923,
922,
921,
920,
919,
918,
917,
916,
915,
914,
913,
912,
911,
910,
957,
956,
955,
954,
953,
952,
951,
950,
949,
948,
947,
946,
945,
944,
-1,
-1,
908,
907,
906,
905,
904,
903,
902,
901,
900,
899,
898,
897,
896,
895,
894,
893,
891,
890,
889,
888,
887,
886,
885,
884,
883,
882,
881,
880,
879,
878,
877,
876,
874,
873,
872,
871,
870,
869,
868,
867,
866,
865,
864,
863,
862,
861,
860,
859,
969,
968,
967,
966,
965,
964,
963,
962,
961,
960,
959,
]

_charnames_64256 = [
8477,
8481,
8480,
8479,
8478,
8484,
8482,
]

_charnames_64275 = [
7725,
7727,
7726,
7728,
7724,
-1,
-1,
-1,
-1,
-1,
11260,
11370,
11302,
11249,
11219,
11218,
11216,
11215,
11214,
11217,
11213,
11212,
11248,
11229,
11228,
11226,
11225,
11245,
11244,
11246,
11280,
11294,
11296,
11276,
11265,
11282,
-1,
11255,
11261,
11236,
11273,
11292,
-1,
11290,
-1,
11288,
11231,
-1,
11234,
11269,
-1,
11253,
11286,
11284,
11223,
11257,
11264,
11279,
11272,
11268,
11304,
7214,
7215,
7437,
7440,
7438,
7439,
7471,
7474,
7472,
7473,
7424,
7427,
7425,
7426,
7066,
7069,
7067,
7068,
7043,
7046,
7044,
7045,
7072,
7075,
7073,
7074,
7516,
7519,
7517,
7518,
7465,
7468,
7466,
7467,
7132,
7135,
7133,
7134,
7264,
7267,
7265,
7266,
7057,
7061,
7058,
7060,
7051,
7054,
7052,
7053,
7127,
7128,
7118,
7119,
7138,
7139,
7123,
7124,
7533,
7534,
7417,
7418,
7299,
7302,
7300,
7301,
7376,
7379,
7377,
7378,
7391,
7394,
7392,
7393,
7251,
7254,
7252,
7253,
7240,
7241,
7411,
7414,
7412,
7413,
7164,
7165,
7150,
7154,
7151,
7153,
7158,
7161,
7159,
7160,
7356,
7357,
7354,
7355,
]

_charnames_64467 = [
7257,
7260,
7258,
7259,
7539,
7540,
7570,
7571,
7365,
7366,
7538,
7521,
7522,
7287,
7288,
7283,
7284,
7564,
7567,
7565,
7566,
7543,
7542,
6503,
6504,
6506,
6507,
6534,
6535,
6537,
6538,
6540,
6541,
6510,
6511,
6530,
6532,
6531,
7015,
7017,
7016,
7457,
7460,
7458,
7459,
6543,
6526,
6517,
6501,
6513,
6809,
6788,
6802,
6796,
6812,
6806,
6442,
6423,
6434,
6411,
6448,
6445,
6470,
6457,
6465,
6462,
6934,
6927,
6864,
6860,
6693,
6698,
6690,
6354,
6334,
6346,
6328,
6375,
6382,
6912,
6900,
6893,
6909,
6489,
6482,
7010,
6834,
6827,
7003,
6997,
6960,
6963,
6949,
6953,
6966,
6957,
6984,
6978,
6987,
6981,
6671,
6680,
6683,
6677,
6663,
6657,
6669,
6674,
6624,
6635,
6643,
6610,
6599,
6646,
6755,
6771,
6763,
6775,
6780,
6782,
6711,
6720,
6738,
6730,
6741,
6735,
6882,
6879,
6886,
6884,
6570,
6551,
6577,
6564,
6580,
6574,
6472,
7019,
6848,
6312,
6307,
6315,
6311,
6306,
6316,
6546,
6545,
6520,
6547,
6502,
6514,
6815,
6814,
6799,
6816,
6813,
6807,
6451,
6450,
6414,
6452,
6449,
6446,
6468,
6467,
6460,
6469,
6466,
6463,
6967,
6958,
6988,
6982,
6672,
6666,
6660,
6670,
6675,
6613,
6600,
6647,
6781,
6778,
6744,
6743,
6733,
6745,
6742,
6736,
6849,
6583,
6582,
6567,
6584,
6581,
6575,
6544,
6527,
6548,
6518,
6524,
6810,
6789,
6803,
6797,
6793,
6443,
6424,
6435,
6412,
6427,
6458,
6935,
6928,
6865,
6861,
6694,
6691,
6355,
6335,
6347,
6329,
6376,
6393,
6383,
6913,
6901,
6894,
6910,
6490,
7011,
6835,
6828,
7004,
6998,
6961,
6964,
6950,
6954,
6985,
6979,
6681,
6684,
6678,
6664,
6658,
6625,
6636,
6644,
6611,
6637,
6756,
6772,
6764,
6776,
6712,
6721,
6739,
6731,
6724,
6883,
6880,
6885,
6571,
6552,
6578,
6565,
6556,
6519,
6523,
6798,
6792,
6413,
6426,
6459,
6471,
6330,
6339,
6278,
6265,
6665,
6659,
6612,
6732,
6723,
6566,
6555,
6314,
6310,
6305,
6492,
6486,
6840,
6837,
7006,
7000,
6364,
6358,
6300,
6294,
6871,
6868,
6940,
6937,
6696,
6687,
6391,
6385,
6915,
6903,
6282,
6260,
6289,
6276,
6297,
6361,
6388,
6906,
6493,
6487,
6841,
6838,
7007,
7001,
6365,
6359,
6301,
6295,
6872,
6869,
6941,
6938,
6697,
6688,
6392,
6386,
6916,
6904,
6286,
6263,
6292,
6279,
6298,
6362,
6389,
6907,
6283,
6261,
6290,
6277,
6340,
6266,
6483,
6356,
6337,
6348,
6285,
6262,
6291,
6484,
7012,
6846,
6845,
16782,
16781,
]

_charnames_64848 = [
6439,
6420,
6419,
6421,
6431,
6407,
6408,
6406,
6923,
6922,
6857,
6858,
6336,
6351,
6352,
6325,
6324,
6326,
6322,
6321,
6372,
6371,
6380,
6257,
6256,
6284,
6274,
6273,
6271,
6270,
6898,
6891,
6890,
6478,
6477,
6480,
6479,
6832,
6823,
6822,
6825,
6994,
6993,
6995,
6947,
6946,
6974,
6976,
6631,
6632,
6633,
6620,
6621,
6641,
6640,
6607,
6606,
6769,
6768,
6767,
6753,
6751,
6761,
6760,
-1,
-1,
6752,
6877,
6876,
6717,
6718,
6704,
6703,
6709,
6727,
6728,
6561,
6560,
6804,
6438,
6440,
6430,
6432,
6405,
6409,
6924,
6932,
6925,
6344,
6373,
6258,
6897,
6622,
6608,
6553,
6572,
6562,
6777,
6975,
6716,
6973,
6630,
6824,
6655,
6706,
6759,
6617,
6654,
6618,
6707,
6931,
6866,
6750,
6955,
6790,
6653,
6831,
6379,
6343,
6708,
]

_charnames_65008 = [
6397,
6989,
6850,
6852,
6783,
6400,
7020,
6851,
7021,
6398,
6399,
6942,
16212,
-1,
-1,
-1,
17726,
17741,
17740,
17739,
17738,
17737,
17736,
17735,
17734,
17733,
17732,
17731,
17730,
17729,
17728,
17727,
]

_charnames_65072 = [
16585,
16583,
16582,
16570,
16584,
16566,
16577,
16562,
16573,
16565,
16576,
16568,
16579,
16567,
16578,
16569,
16580,
16563,
16574,
16564,
16575,
13376,
17488,
-1,
-1,
16018,
2944,
17572,
15811,
16019,
2945,
17570,
13280,
13299,
13302,
-1,
13296,
13281,
13297,
13269,
13271,
13285,
13261,
13286,
13262,
13284,
13260,
13298,
13293,
13292,
13289,
13300,
13287,
13301,
13270,
-1,
13263,
13303,
13290,
13279,
-1,
-1,
-1,
-1,
7614,
7637,
7623,
7638,
7630,
-1,
7617,
7616,
7626,
7625,
7633,
7632,
7605,
7604,
7601,
7600,
7185,
7207,
7208,
7203,
7204,
7480,
7481,
7199,
7200,
7342,
7345,
7343,
7344,
7220,
7221,
7430,
7433,
7431,
7432,
7029,
7031,
7037,
7039,
7038,
7032,
7080,
7083,
7081,
7082,
7527,
7530,
7528,
7529,
7180,
7183,
7181,
7182,
7292,
7295,
7293,
7294,
7106,
7107,
7086,
7087,
7406,
7407,
7510,
7511,
7311,
7314,
7312,
7313,
7328,
7332,
7329,
7331,
7321,
7324,
7322,
7323,
7111,
7115,
7112,
7114,
7091,
7095,
7092,
7094,
7504,
7507,
7505,
7506,
7225,
7229,
7226,
7228,
7383,
7387,
7384,
7386,
7450,
7453,
7451,
7452,
7550,
7553,
7551,
7552,
7276,
7279,
7277,
7278,
7496,
7499,
7497,
7498,
7557,
7560,
7558,
7559,
7243,
7246,
7244,
7245,
7167,
7170,
7168,
7169,
7485,
7486,
7218,
7219,
7359,
7362,
7360,
7361,
6596,
6597,
6593,
6594,
6590,
6591,
6601,
6602,
-1,
-1,
17823,
-1,
17256,
17247,
17250,
17219,
17238,
17242,
17241,
17200,
17224,
17240,
17237,
17231,
17263,
17264,
17244,
17215,
17216,
17207,
17208,
17213,
17214,
17210,
17211,
17218,
17217,
17232,
17245,
17202,
17257,
17253,
17248,
17230,
17195,
17194,
17193,
17192,
17191,
17190,
17189,
17188,
17187,
17186,
17185,
17184,
17183,
17182,
17181,
17180,
17179,
17178,
17177,
17176,
17175,
17174,
17173,
17172,
17171,
17170,
17199,
17226,
17223,
17233,
17203,
17254,
17168,
17167,
17166,
17165,
17164,
17163,
17162,
17161,
17160,
17159,
17158,
17157,
17156,
17155,
17154,
17153,
17152,
17151,
17150,
17149,
17148,
17147,
17146,
17145,
17144,
17143,
17201,
17260,
17225,
17261,
17198,
17222,
11198,
11196,
11193,
11199,
11124,
11115,
11068,
11066,
11063,
11067,
11065,
11062,
11060,
11061,
11064,
11125,
11121,
11119,
11117,
11120,
11118,
11103,
11101,
11099,
11102,
11100,
11073,
11071,
11069,
11072,
11070,
11085,
11083,
11081,
11084,
11082,
11079,
11077,
11075,
11078,
11076,
11109,
11107,
11105,
11108,
11106,
11097,
11095,
11093,
11096,
11094,
11113,
11111,
11112,
11091,
11089,
11087,
11090,
11088,
11116,
11074,
11122,
11123,
11190,
11169,
11151,
11170,
11164,
11167,
11166,
11176,
11148,
11128,
11136,
11135,
11131,
11134,
11133,
11132,
11137,
11188,
11161,
11150,
11162,
11153,
11149,
11181,
11183,
11152,
11184,
11171,
11177,
11163,
11189,
-1,
-1,
-1,
11185,
11186,
11141,
11142,
11174,
11172,
-1,
-1,
11140,
11139,
11178,
11157,
11158,
11179,
-1,
-1,
11144,
11187,
11156,
11155,
11159,
11143,
-1,
-1,
11173,
11145,
11180,
-1,
-1,
-1,
17234,
17236,
17251,
17262,
17265,
17258,
17259,
-1,
11202,
11195,
11201,
11192,
11203,
11204,
11200,
]

_charnames_66304 = [
16819,
16818,
16799,
16816,
16786,
16812,
16811,
16815,
16804,
16809,
16800,
16793,
16792,
16791,
16788,
16814,
16808,
16813,
16797,
16789,
16787,
16805,
16801,
16794,
16807,
16798,
16795,
16790,
16817,
16810,
16802,
-1,
16825,
16822,
16824,
16823,
]

_charnames_66352 = [
14236,
14252,
14248,
14251,
14235,
14241,
14229,
14233,
14226,
14250,
14246,
14245,
14244,
14224,
14247,
14238,
14242,
14222,
14240,
14239,
14227,
14237,
14249,
14230,
14232,
14243,
14223,
]

_charnames_66560 = [
15695,
15696,
15693,
15694,
15691,
15692,
15688,
15689,
15686,
15687,
15684,
15685,
15715,
15707,
15704,
15703,
15710,
15706,
15714,
15702,
15712,
15713,
15709,
15708,
15711,
15682,
15705,
15678,
15701,
15674,
15699,
15675,
15698,
15679,
15681,
15680,
15676,
15677,
-1,
-1,
15651,
15652,
15649,
15650,
15647,
15648,
15644,
15645,
15642,
15643,
15640,
15641,
15671,
15663,
15660,
15659,
15666,
15662,
15670,
15658,
15668,
15669,
15665,
15664,
15667,
15638,
15661,
15634,
15657,
15630,
15655,
15631,
15654,
15635,
15637,
15636,
15632,
15633,
]

_charnames_118784 = [
9768,
9852,
9777,
9948,
9949,
10009,
10010,
9725,
9749,
9780,
9921,
9922,
9711,
9652,
9979,
9882,
9686,
9639,
9642,
9747,
9878,
9956,
9935,
9767,
10003,
10012,
9969,
9698,
9692,
9757,
9787,
9752,
9950,
10011,
9648,
9649,
9717,
10014,
9790,
9883,
9683,
9755,
9746,
9745,
9953,
9872,
9992,
9851,
9869,
9881,
9707,
9651,
9812,
9963,
9858,
9724,
9775,
9761,
9713,
10001,
10015,
9786,
9783,
9971,
10017,
9774,
9714,
9859,
9753,
9943,
9968,
9955,
9947,
9773,
9715,
9772,
9710,
9776,
9691,
9697,
9924,
9641,
9645,
9923,
9709,
9981,
10004,
9906,
10008,
9789,
9762,
9957,
9681,
9993,
9782,
9785,
9974,
9726,
9682,
9860,
9982,
9744,
9748,
10000,
9980,
9756,
10016,
9862,
9765,
9865,
9863,
9764,
9864,
9763,
9936,
9664,
9975,
9952,
9875,
9874,
9876,
9877,
9723,
9977,
9917,
9918,
9751,
9720,
9849,
9704,
9705,
9706,
9647,
9653,
9848,
9867,
9880,
9716,
9990,
9991,
9987,
9988,
9989,
9934,
9931,
9930,
9833,
9836,
9837,
9838,
9868,
9665,
9965,
9847,
9669,
9677,
9678,
9671,
9672,
9675,
9674,
9668,
9896,
9901,
9905,
9902,
9888,
9889,
9892,
9891,
9904,
9899,
9970,
9644,
9817,
9818,
9819,
9903,
9895,
9898,
9939,
9938,
9978,
9964,
9962,
9813,
9800,
9798,
9808,
9802,
9804,
9801,
9799,
9796,
9797,
9811,
9810,
9820,
9805,
9807,
9996,
9998,
9997,
9814,
9815,
9911,
9826,
9828,
9831,
9829,
9830,
9827,
9915,
9913,
9914,
9912,
9942,
9941,
9843,
9844,
9846,
9845,
9729,
9734,
9732,
9733,
9735,
9740,
9738,
9739,
9839,
9850,
9754,
9658,
9657,
9661,
9662,
9660,
9656,
9659,
9689,
9695,
9690,
9696,
9719,
9933,
]

_charnames_119040 = [
4266,
4348,
4298,
4418,
4342,
4287,
4454,
4421,
4417,
4343,
4344,
4277,
4192,
4416,
4415,
4414,
4315,
4316,
4362,
4205,
4365,
4364,
4334,
4252,
4249,
4303,
4299,
4265,
4264,
4302,
4392,
4395,
4394,
4206,
4305,
4308,
4307,
4351,
4350,
-1,
-1,
-1,
4346,
4347,
4313,
4314,
4444,
4445,
4285,
4286,
4435,
4436,
4191,
4203,
4337,
4336,
4441,
4440,
4407,
4463,
4457,
4437,
4430,
4261,
4247,
4258,
4332,
4473,
4381,
4204,
4280,
4281,
4215,
4216,
4221,
4222,
4218,
4219,
4224,
4225,
4213,
4214,
4405,
4406,
4227,
4228,
4383,
4467,
4447,
4446,
4195,
4196,
4361,
4464,
4459,
4438,
4431,
4262,
4248,
4259,
4333,
4156,
4157,
4173,
4172,
4171,
4297,
4296,
4295,
4183,
4166,
4165,
4164,
4163,
4162,
4370,
4428,
4367,
4424,
4368,
4425,
4369,
4426,
4181,
4154,
4175,
4155,
4184,
4185,
4182,
4188,
4470,
4471,
4179,
4187,
4167,
4159,
4190,
4178,
4174,
4420,
4290,
4472,
4382,
4408,
4304,
4202,
4354,
4390,
4391,
4208,
4241,
4474,
4244,
4243,
4319,
4329,
4328,
4327,
4326,
4325,
4324,
4323,
4322,
4321,
4320,
4460,
4448,
4427,
4353,
4177,
4186,
4189,
4158,
4379,
4378,
4458,
4397,
4398,
4465,
4340,
4341,
4409,
4450,
4359,
4274,
4276,
4400,
4403,
4270,
4272,
4310,
4311,
4452,
4453,
4360,
4275,
4402,
4271,
4238,
4240,
4239,
4236,
4231,
4235,
4234,
4233,
4201,
4388,
4387,
4282,
4468,
4375,
4198,
4288,
4199,
4250,
4373,
4374,
4289,
4251,
4380,
]

_charnames_119808 = [
3696,
3694,
3692,
3690,
3665,
3704,
3688,
3703,
3686,
3702,
3684,
3682,
3680,
3678,
3661,
3657,
3701,
3676,
3674,
3653,
3672,
3700,
3699,
3670,
3698,
3668,
3589,
3587,
3585,
3583,
3556,
3581,
3579,
3596,
3577,
3595,
3575,
3573,
3571,
3569,
3552,
3545,
3594,
3567,
3565,
3549,
3563,
3593,
3592,
3561,
3591,
3559,
3773,
3771,
3769,
3767,
3742,
3781,
3765,
3780,
3763,
3779,
3761,
3759,
3757,
3755,
3738,
3734,
3778,
3753,
3751,
3730,
3749,
3777,
3776,
3747,
3775,
3745,
3827,
3825,
3823,
3821,
3794,
3819,
3817,
-1,
3815,
3833,
3813,
3811,
3809,
3807,
3790,
3783,
3832,
3805,
3803,
3787,
3801,
3831,
3830,
3799,
3829,
3797,
3470,
3468,
3466,
3464,
3439,
3478,
3462,
3477,
3460,
3476,
3458,
3456,
3454,
3452,
3435,
3431,
3475,
3450,
3448,
3427,
3446,
3474,
3473,
3444,
3472,
3442,
3418,
3416,
3414,
3412,
3385,
3410,
3408,
3425,
3406,
3424,
3404,
3402,
3400,
3398,
3381,
3374,
3423,
3396,
3394,
3378,
3392,
3422,
3421,
3390,
3420,
3388,
3370,
-1,
3369,
3368,
-1,
-1,
3367,
-1,
-1,
3366,
3365,
-1,
-1,
3364,
3363,
3362,
3361,
-1,
3360,
3359,
3358,
3357,
3356,
3355,
3354,
3353,
3351,
3350,
3349,
3348,
-1,
3347,
-1,
3346,
3345,
3344,
3343,
-1,
3342,
3341,
-1,
3340,
3339,
3338,
3337,
3336,
3335,
3334,
3333,
3332,
3331,
3330,
3543,
3542,
3541,
3540,
3539,
3538,
3537,
3536,
3535,
3534,
3533,
3532,
3531,
3530,
3529,
3528,
3527,
3526,
3525,
3524,
3523,
3522,
3521,
3520,
3519,
3518,
3516,
3515,
3514,
3513,
3512,
3511,
3510,
3509,
3508,
3507,
3506,
3505,
3504,
3503,
3502,
3501,
3500,
3499,
3498,
3497,
3496,
3495,
3494,
3493,
3492,
3491,
4023,
4022,
-1,
4021,
4020,
4019,
4018,
-1,
-1,
4017,
4016,
4015,
4014,
4013,
4012,
4011,
4010,
-1,
4009,
4008,
4007,
4006,
4005,
4004,
4003,
-1,
4001,
4000,
3999,
3998,
3997,
3996,
3995,
3994,
3993,
3992,
3991,
3990,
3989,
3988,
3987,
3986,
3985,
3984,
3983,
3982,
3981,
3980,
3979,
3978,
3977,
3976,
3959,
3958,
-1,
3957,
3956,
3955,
3954,
-1,
3953,
3952,
3951,
3950,
3949,
-1,
3948,
-1,
-1,
-1,
3947,
3946,
3945,
3944,
3943,
3942,
3941,
-1,
3939,
3938,
3937,
3936,
3935,
3934,
3933,
3932,
3931,
3930,
3929,
3928,
3927,
3926,
3925,
3924,
3923,
3922,
3921,
3920,
3919,
3918,
3917,
3916,
3915,
3914,
3651,
3650,
3649,
3648,
3647,
3646,
3645,
3644,
3643,
3642,
3641,
3640,
3639,
3638,
3637,
3636,
3635,
3634,
3633,
3632,
3631,
3630,
3629,
3628,
3627,
3626,
3624,
3623,
3622,
3621,
3620,
3619,
3618,
3617,
3616,
3615,
3614,
3613,
3612,
3611,
3610,
3609,
3608,
3607,
3606,
3605,
3604,
3603,
3602,
3601,
3600,
3599,
3313,
3312,
3311,
3310,
3309,
3308,
3307,
3306,
3305,
3304,
3303,
3302,
3301,
3300,
3299,
3298,
3297,
3296,
3295,
3294,
3293,
3292,
3291,
3290,
3289,
3288,
3286,
3285,
3284,
3283,
3282,
3281,
3280,
3279,
3278,
3277,
3276,
3275,
3274,
3273,
3272,
3271,
3270,
3269,
3268,
3267,
3266,
3265,
3264,
3263,
3262,
3261,
3173,
3171,
3169,
3167,
3142,
3181,
3165,
3180,
3163,
3179,
3161,
3159,
3157,
3155,
3138,
3134,
3178,
3153,
3151,
3130,
3149,
3177,
3176,
3147,
3175,
3145,
3121,
3119,
3117,
3115,
3088,
3113,
3111,
3128,
3109,
3127,
3107,
3105,
3103,
3101,
3084,
3077,
3126,
3099,
3097,
3081,
3095,
3125,
3124,
3093,
3123,
3091,
3259,
3258,
3257,
3256,
3255,
3254,
3253,
3252,
3251,
3250,
3249,
3248,
3247,
3246,
3245,
3244,
3243,
3242,
3241,
3240,
3239,
3238,
3237,
3236,
3235,
3234,
3232,
3231,
3230,
3229,
3228,
3227,
3226,
3225,
3224,
3223,
3222,
3221,
3220,
3219,
3218,
3217,
3216,
3215,
3214,
3213,
3212,
3211,
3210,
3209,
3208,
3207,
3058,
3056,
3054,
3052,
3027,
3066,
3050,
3065,
3048,
3064,
3046,
3044,
3042,
3040,
3023,
3019,
3063,
3038,
3036,
3015,
3034,
3062,
3061,
3032,
3060,
3030,
3006,
3004,
3002,
3000,
2973,
2998,
2996,
3013,
2994,
3012,
2992,
2990,
2988,
2986,
2969,
2962,
3011,
2984,
2982,
2966,
2980,
3010,
3009,
2978,
3008,
2976,
3897,
3896,
3895,
3894,
3893,
3892,
3891,
3890,
3889,
3888,
3887,
3886,
3885,
3884,
3883,
3882,
3881,
3880,
3879,
3878,
3877,
3876,
3875,
3874,
3873,
3872,
3870,
3869,
3868,
3867,
3866,
3865,
3864,
3863,
3862,
3861,
3860,
3859,
3858,
3857,
3856,
3855,
3854,
3853,
3852,
3851,
3850,
3849,
3848,
3847,
3846,
3845,
-1,
-1,
-1,
-1,
3697,
3695,
3689,
3691,
3667,
3669,
3666,
3654,
3687,
3685,
3683,
3681,
3679,
3671,
3663,
3659,
3677,
3655,
3675,
3656,
3673,
3660,
3693,
3658,
3664,
3725,
3590,
3588,
3580,
3584,
3558,
3560,
3557,
3550,
3578,
3576,
3574,
3572,
3570,
3562,
3554,
3547,
3568,
3582,
3566,
3551,
3564,
3548,
3586,
3546,
3555,
3722,
3727,
3723,
3726,
3721,
3724,
3720,
3774,
3772,
3766,
3768,
3744,
3746,
3743,
3731,
3764,
3762,
3760,
3758,
3756,
3748,
3740,
3736,
3754,
3732,
3752,
3733,
3750,
3737,
3770,
3735,
3741,
3840,
3828,
3826,
3818,
3822,
3796,
3798,
3795,
3788,
3816,
3814,
3812,
3810,
3808,
3800,
3792,
3785,
3806,
3820,
3804,
3789,
3802,
3786,
3824,
3784,
3793,
3837,
3842,
3838,
3841,
3836,
3839,
3835,
3471,
3469,
3463,
3465,
3441,
3443,
3440,
3428,
3461,
3459,
3457,
3455,
3453,
3445,
3437,
3433,
3451,
3429,
3449,
3430,
3447,
3434,
3467,
3432,
3438,
3485,
3419,
3417,
3409,
3413,
3387,
3389,
3386,
3379,
3407,
3405,
3403,
3401,
3399,
3391,
3383,
3376,
3397,
3411,
3395,
3380,
3393,
3377,
3415,
3375,
3384,
3482,
3487,
3483,
3486,
3481,
3484,
3480,
3174,
3172,
3166,
3168,
3144,
3146,
3143,
3131,
3164,
3162,
3160,
3158,
3156,
3148,
3140,
3136,
3154,
3132,
3152,
3133,
3150,
3137,
3170,
3135,
3141,
3202,
3122,
3120,
3112,
3116,
3090,
3092,
3089,
3082,
3110,
3108,
3106,
3104,
3102,
3094,
3086,
3079,
3100,
3114,
3098,
3083,
3096,
3080,
3118,
3078,
3087,
3199,
3204,
3200,
3203,
3198,
3201,
3197,
3059,
3057,
3051,
3053,
3029,
3031,
3028,
3016,
3049,
3047,
3045,
3043,
3041,
3033,
3025,
3021,
3039,
3017,
3037,
3018,
3035,
3022,
3055,
3020,
3026,
3073,
3007,
3005,
2997,
3001,
2975,
2977,
2974,
2967,
2995,
2993,
2991,
2989,
2987,
2979,
2971,
2964,
2985,
2999,
2983,
2968,
2981,
2965,
3003,
2963,
2972,
3070,
3075,
3071,
3074,
3069,
3072,
3068,
-1,
-1,
-1,
-1,
3715,
3716,
3707,
3708,
3713,
3714,
3710,
3711,
3718,
3717,
3970,
3971,
3962,
3963,
3968,
3969,
3965,
3966,
3973,
3972,
3324,
3325,
3316,
3317,
3322,
3323,
3319,
3320,
3327,
3326,
3192,
3193,
3184,
3185,
3190,
3191,
3187,
3188,
3195,
3194,
3908,
3909,
3900,
3901,
3906,
3907,
3903,
3904,
3911,
3910,
]

_charnames_194560 = [
549,
548,
547,
546,
545,
544,
543,
542,
541,
540,
539,
538,
537,
536,
535,
534,
532,
531,
530,
529,
528,
527,
526,
525,
524,
523,
522,
521,
520,
519,
518,
517,
515,
514,
513,
512,
511,
510,
509,
508,
507,
506,
505,
504,
503,
502,
501,
500,
498,
497,
496,
495,
494,
493,
492,
491,
490,
489,
488,
487,
486,
485,
484,
483,
481,
480,
479,
478,
477,
476,
475,
474,
473,
472,
471,
470,
469,
468,
467,
466,
464,
463,
462,
461,
460,
459,
458,
457,
456,
455,
454,
453,
452,
451,
450,
449,
447,
446,
445,
444,
443,
442,
441,
440,
439,
438,
437,
436,
435,
434,
433,
432,
430,
429,
428,
427,
426,
425,
424,
423,
422,
421,
420,
419,
418,
417,
416,
415,
413,
412,
411,
410,
409,
408,
407,
406,
405,
404,
403,
402,
401,
400,
399,
398,
396,
395,
394,
393,
392,
391,
390,
389,
388,
387,
386,
385,
384,
383,
382,
381,
379,
378,
377,
376,
375,
374,
373,
372,
371,
370,
369,
368,
367,
366,
365,
364,
362,
361,
360,
359,
358,
357,
356,
355,
354,
353,
352,
351,
350,
349,
348,
347,
345,
344,
343,
342,
341,
340,
339,
338,
337,
336,
335,
334,
333,
332,
331,
330,
328,
327,
326,
325,
324,
323,
322,
321,
320,
319,
318,
317,
316,
315,
314,
313,
311,
310,
309,
308,
307,
306,
305,
304,
303,
302,
301,
300,
299,
298,
297,
296,
294,
293,
292,
291,
290,
289,
288,
287,
286,
285,
284,
283,
282,
281,
280,
279,
276,
275,
274,
273,
272,
271,
270,
269,
268,
267,
266,
265,
264,
263,
262,
261,
259,
258,
257,
256,
255,
254,
253,
252,
251,
250,
249,
248,
247,
246,
245,
244,
242,
241,
240,
239,
238,
237,
236,
235,
234,
233,
232,
231,
230,
229,
228,
227,
225,
224,
223,
222,
221,
220,
219,
218,
217,
216,
215,
214,
213,
212,
211,
210,
208,
207,
206,
205,
204,
203,
202,
201,
200,
199,
198,
197,
196,
195,
194,
193,
191,
190,
189,
188,
187,
186,
185,
184,
183,
182,
181,
180,
179,
178,
177,
176,
174,
173,
172,
171,
170,
169,
168,
167,
166,
165,
164,
163,
162,
161,
160,
159,
157,
156,
155,
154,
153,
152,
151,
150,
149,
148,
147,
146,
145,
144,
143,
142,
140,
139,
138,
137,
136,
135,
134,
133,
132,
131,
130,
129,
128,
127,
126,
125,
123,
122,
121,
120,
119,
118,
117,
116,
115,
114,
113,
112,
111,
110,
109,
108,
106,
105,
104,
103,
102,
101,
100,
99,
98,
97,
96,
95,
94,
93,
92,
91,
89,
88,
87,
86,
85,
84,
83,
82,
81,
80,
79,
78,
77,
76,
75,
74,
72,
71,
70,
69,
68,
67,
66,
65,
64,
63,
62,
61,
60,
59,
58,
57,
55,
54,
53,
52,
51,
50,
49,
48,
47,
46,
45,
44,
43,
42,
41,
40,
38,
37,
36,
35,
34,
33,
32,
31,
30,
29,
28,
27,
26,
25,
24,
23,
21,
20,
19,
18,
17,
16,
15,
14,
13,
12,
11,
10,
9,
8,
7,
6,
567,
566,
565,
564,
563,
562,
561,
560,
559,
558,
557,
556,
555,
554,
553,
552,
582,
581,
580,
579,
578,
577,
576,
575,
574,
573,
572,
571,
570,
569,
]

_charnames_917536 = [
11965,
11982,
11973,
11986,
11950,
11977,
11971,
11970,
11931,
11954,
11969,
11976,
11961,
11987,
11988,
11966,
11946,
11947,
11938,
11939,
11944,
11945,
11941,
11942,
11949,
11948,
11962,
11967,
11933,
11983,
11979,
11974,
11960,
11927,
11926,
11925,
11924,
11923,
11922,
11921,
11920,
11919,
11918,
11917,
11916,
11915,
11914,
11913,
11912,
11911,
11910,
11909,
11908,
11907,
11906,
11905,
11904,
11903,
11902,
11930,
11956,
11953,
11963,
11934,
11980,
11900,
11899,
11898,
11897,
11896,
11895,
11894,
11893,
11892,
11891,
11890,
11889,
11888,
11887,
11886,
11885,
11884,
11883,
11882,
11881,
11880,
11879,
11878,
11877,
11876,
11875,
11932,
11984,
11955,
11985,
1857,
]

def lookup_charcode(code):
    res = -1
    if 32 <= code <= 126: res = _charnames_32[code-32]
    elif 160 <= code <= 563: res = _charnames_160[code-160]
    elif 592 <= code <= 750: res = _charnames_592[code-592]
    elif 768 <= code <= 847: res = _charnames_768[code-768]
    elif 864 <= code <= 1014: res = _charnames_864[code-864]
    elif 1024 <= code <= 1295: res = _charnames_1024[code-1024]
    elif 1329 <= code <= 1476: res = _charnames_1329[code-1329]
    elif 1488 <= code <= 1524: res = _charnames_1488[code-1488]
    elif code == 1548: res = 7654
    elif 1563 <= code <= 1621: res = _charnames_1563[code-1563]
    elif 1632 <= code <= 1866: res = _charnames_1632[code-1632]
    elif 1920 <= code <= 1969: res = _charnames_1920[code-1920]
    elif 2305 <= code <= 2416: res = _charnames_2305[code-2305]
    elif 2433 <= code <= 2509: res = _charnames_2433[code-2433]
    elif 2519 <= code <= 2554: res = _charnames_2519[code-2519]
    elif 2562 <= code <= 2637: res = _charnames_2562[code-2562]
    elif code == 2649: res = 14028
    elif code == 2650: res = 14033
    elif code == 2651: res = 14061
    elif code == 2652: res = 14042
    elif code == 2654: res = 14067
    elif 2662 <= code <= 2676: res = _charnames_2662[code-2662]
    elif 2689 <= code <= 2768: res = _charnames_2689[code-2689]
    elif 2784 <= code <= 2799: res = _charnames_2784[code-2784]
    elif 2817 <= code <= 2893: res = _charnames_2817[code-2817]
    elif 2902 <= code <= 2928: res = _charnames_2902[code-2902]
    elif 2946 <= code <= 3021: res = _charnames_2946[code-2946]
    elif code == 3031: res = 12114
    elif 3047 <= code <= 3058: res = _charnames_3047[code-3047]
    elif 3073 <= code <= 3149: res = _charnames_3073[code-3073]
    elif code == 3157: res = 12405
    elif code == 3158: res = 12441
    elif 3168 <= code <= 3183: res = _charnames_3168[code-3168]
    elif 3202 <= code <= 3277: res = _charnames_3202[code-3202]
    elif code == 3285: res = 14635
    elif code == 3286: res = 14670
    elif 3294 <= code <= 3311: res = _charnames_3294[code-3294]
    elif 3330 <= code <= 3405: res = _charnames_3330[code-3330]
    elif code == 3415: res = 4137
    elif 3424 <= code <= 3439: res = _charnames_3424[code-3424]
    elif 3458 <= code <= 3551: res = _charnames_3458[code-3458]
    elif code == 3570: res = 13082
    elif code == 3571: res = 13081
    elif code == 3572: res = 13096
    elif 3585 <= code <= 3675: res = _charnames_3585[code-3585]
    elif 3713 <= code <= 3805: res = _charnames_3713[code-3713]
    elif 3840 <= code <= 4047: res = _charnames_3840[code-3840]
    elif 4096 <= code <= 4185: res = _charnames_4096[code-4096]
    elif 4256 <= code <= 4293: res = _charnames_4256[code-4256]
    elif 4304 <= code <= 4988: res = _charnames_4304[code-4304]
    elif 5024 <= code <= 5108: res = _charnames_5024[code-5024]
    elif 5121 <= code <= 5750: res = _charnames_5121[code-5121]
    elif 5760 <= code <= 5872: res = _charnames_5760[code-5760]
    elif 5888 <= code <= 5908: res = _charnames_5888[code-5888]
    elif 5920 <= code <= 5942: res = _charnames_5920[code-5920]
    elif 5952 <= code <= 5971: res = _charnames_5952[code-5952]
    elif 5984 <= code <= 6003: res = _charnames_5984[code-5984]
    elif 6016 <= code <= 6121: res = _charnames_6016[code-6016]
    elif 6144 <= code <= 6263: res = _charnames_6144[code-6144]
    elif 6272 <= code <= 6313: res = _charnames_6272[code-6272]
    elif 7680 <= code <= 8279: res = _charnames_7680[code-7680]
    elif 8287 <= code <= 8334: res = _charnames_8287[code-8287]
    elif 8352 <= code <= 8369: res = _charnames_8352[code-8352]
    elif 8400 <= code <= 8426: res = _charnames_8400[code-8400]
    elif 8448 <= code <= 8523: res = _charnames_8448[code-8448]
    elif 8531 <= code <= 8579: res = _charnames_8531[code-8531]
    elif 8592 <= code <= 9166: res = _charnames_8592[code-8592]
    elif 9216 <= code <= 9254: res = _charnames_9216[code-9216]
    elif 9280 <= code <= 9290: res = _charnames_9280[code-9280]
    elif 9312 <= code <= 9865: res = _charnames_9312[code-9312]
    elif 9985 <= code <= 10174: res = _charnames_9985[code-9985]
    elif 10192 <= code <= 11007: res = _charnames_10192[code-10192]
    elif 11904 <= code <= 12019: res = _charnames_11904[code-11904]
    elif 12032 <= code <= 12245: res = _charnames_12032[code-12032]
    elif 12272 <= code <= 12727: res = _charnames_12272[code-12272]
    elif 12784 <= code <= 12867: res = _charnames_12784[code-12784]
    elif 12881 <= code <= 13310: res = _charnames_12881[code-12881]
    elif 40960 <= code <= 42182: res = _charnames_40960[code-40960]
    elif 63744 <= code <= 64106: res = _charnames_63744[code-63744]
    elif 64256 <= code <= 64262: res = _charnames_64256[code-64256]
    elif 64275 <= code <= 64433: res = _charnames_64275[code-64275]
    elif 64467 <= code <= 64831: res = _charnames_64467[code-64467]
    elif 64848 <= code <= 64967: res = _charnames_64848[code-64848]
    elif 65008 <= code <= 65039: res = _charnames_65008[code-65008]
    elif code == 65056: res = 2594
    elif code == 65057: res = 2593
    elif code == 65058: res = 2606
    elif code == 65059: res = 2605
    elif 65072 <= code <= 65518: res = _charnames_65072[code-65072]
    elif code == 65529: res = 17089
    elif code == 65530: res = 17088
    elif code == 65531: res = 17087
    elif code == 65532: res = 16907
    elif code == 65533: res = 16351
    elif 66304 <= code <= 66339: res = _charnames_66304[code-66304]
    elif 66352 <= code <= 66378: res = _charnames_66352[code-66352]
    elif 66560 <= code <= 66637: res = _charnames_66560[code-66560]
    elif 118784 <= code <= 119029: res = _charnames_118784[code-118784]
    elif 119040 <= code <= 119261: res = _charnames_119040[code-119040]
    elif 119808 <= code <= 120831: res = _charnames_119808[code-119808]
    elif 194560 <= code <= 195101: res = _charnames_194560[code-194560]
    elif code == 917505: res = 9052
    elif 917536 <= code <= 917631: res = _charnames_917536[code-917536]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
# the following dictionary is used by modules that take this as a base
# only used by generate_unicodedb, not after translation
_orig_names = {
'ACCOUNT OF': 8448,
'ACTIVATE ARABIC FORM SHAPING': 8301,
'ACTIVATE SYMMETRIC SWAPPING': 8299,
'ACUTE ACCENT': 180,
'ACUTE ANGLE': 10655,
'ADDRESSED TO THE SUBJECT': 8449,
'ADI SHAKTI': 9772,
'AIRPLANE': 9992,
'ALEF SYMBOL': 8501,
'ALL AROUND-PROFILE': 9006,
'ALL EQUAL TO': 8780,
'ALMOST EQUAL OR EQUAL TO': 8778,
'ALMOST EQUAL TO': 8776,
'ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT': 10863,
'ALTERNATIVE KEY SYMBOL': 9095,
'AMALGAMATION OR COPRODUCT': 10815,
'AMPERSAND': 38,
'AND WITH DOT': 10193,
'ANGLE': 8736,
'ANGLE WITH S INSIDE': 10654,
'ANGLE WITH UNDERBAR': 10660,
'ANGSTROM SIGN': 8491,
'ANKH': 9765,
'ANTICLOCKWISE CLOSED CIRCLE ARROW': 10560,
'ANTICLOCKWISE CONTOUR INTEGRAL': 8755,
'ANTICLOCKWISE GAPPED CIRCLE ARROW': 10226,
'ANTICLOCKWISE INTEGRATION': 10769,
'ANTICLOCKWISE OPEN CIRCLE ARROW': 8634,
'ANTICLOCKWISE TOP SEMICIRCLE ARROW': 8630,
'APL FUNCTIONAL SYMBOL ALPHA': 9082,
'APL FUNCTIONAL SYMBOL ALPHA UNDERBAR': 9078,
'APL FUNCTIONAL SYMBOL BACKSLASH BAR': 9024,
'APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH': 9033,
'APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS': 9061,
'APL FUNCTIONAL SYMBOL CIRCLE JOT': 9022,
'APL FUNCTIONAL SYMBOL CIRCLE STAR': 9055,
'APL FUNCTIONAL SYMBOL CIRCLE STILE': 9021,
'APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR': 9052,
'APL FUNCTIONAL SYMBOL COMMA BAR': 9066,
'APL FUNCTIONAL SYMBOL DEL DIAERESIS': 9058,
'APL FUNCTIONAL SYMBOL DEL STILE': 9042,
'APL FUNCTIONAL SYMBOL DEL TILDE': 9067,
'APL FUNCTIONAL SYMBOL DELTA STILE': 9035,
'APL FUNCTIONAL SYMBOL DELTA UNDERBAR': 9049,
'APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR': 9050,
'APL FUNCTIONAL SYMBOL DOWN CARET TILDE': 9073,
'APL FUNCTIONAL SYMBOL DOWN SHOE STILE': 9062,
'APL FUNCTIONAL SYMBOL DOWN TACK JOT': 9038,
'APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR': 9034,
'APL FUNCTIONAL SYMBOL DOWNWARDS VANE': 9046,
'APL FUNCTIONAL SYMBOL EPSILON UNDERBAR': 9079,
'APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS': 9065,
'APL FUNCTIONAL SYMBOL I-BEAM': 9014,
'APL FUNCTIONAL SYMBOL IOTA': 9075,
'APL FUNCTIONAL SYMBOL IOTA UNDERBAR': 9080,
'APL FUNCTIONAL SYMBOL JOT DIAERESIS': 9060,
'APL FUNCTIONAL SYMBOL JOT UNDERBAR': 9051,
'APL FUNCTIONAL SYMBOL LEFT SHOE STILE': 9063,
'APL FUNCTIONAL SYMBOL LEFTWARDS VANE': 9029,
'APL FUNCTIONAL SYMBOL OMEGA': 9077,
'APL FUNCTIONAL SYMBOL OMEGA UNDERBAR': 9081,
'APL FUNCTIONAL SYMBOL QUAD': 9109,
'APL FUNCTIONAL SYMBOL QUAD BACKSLASH': 9026,
'APL FUNCTIONAL SYMBOL QUAD CIRCLE': 9020,
'APL FUNCTIONAL SYMBOL QUAD COLON': 9056,
'APL FUNCTIONAL SYMBOL QUAD DEL': 9044,
'APL FUNCTIONAL SYMBOL QUAD DELTA': 9037,
'APL FUNCTIONAL SYMBOL QUAD DIAMOND': 9018,
'APL FUNCTIONAL SYMBOL QUAD DIVIDE': 9017,
'APL FUNCTIONAL SYMBOL QUAD DOWN CARET': 9036,
'APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW': 9047,
'APL FUNCTIONAL SYMBOL QUAD EQUAL': 9016,
'APL FUNCTIONAL SYMBOL QUAD GREATER-THAN': 9028,
'APL FUNCTIONAL SYMBOL QUAD JOT': 9019,
'APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW': 9031,
'APL FUNCTIONAL SYMBOL QUAD LESS-THAN': 9027,
'APL FUNCTIONAL SYMBOL QUAD NOT EQUAL': 9071,
'APL FUNCTIONAL SYMBOL QUAD QUESTION': 9072,
'APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW': 9032,
'APL FUNCTIONAL SYMBOL QUAD SLASH': 9025,
'APL FUNCTIONAL SYMBOL QUAD UP CARET': 9043,
'APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW': 9040,
'APL FUNCTIONAL SYMBOL QUOTE QUAD': 9054,
'APL FUNCTIONAL SYMBOL QUOTE UNDERBAR': 9048,
'APL FUNCTIONAL SYMBOL RHO': 9076,
'APL FUNCTIONAL SYMBOL RIGHTWARDS VANE': 9030,
'APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR': 9070,
'APL FUNCTIONAL SYMBOL SLASH BAR': 9023,
'APL FUNCTIONAL SYMBOL SQUISH QUAD': 9015,
'APL FUNCTIONAL SYMBOL STAR DIAERESIS': 9059,
'APL FUNCTIONAL SYMBOL STILE TILDE': 9069,
'APL FUNCTIONAL SYMBOL TILDE DIAERESIS': 9064,
'APL FUNCTIONAL SYMBOL UP CARET TILDE': 9074,
'APL FUNCTIONAL SYMBOL UP SHOE JOT': 9053,
'APL FUNCTIONAL SYMBOL UP TACK DIAERESIS': 9057,
'APL FUNCTIONAL SYMBOL UP TACK JOT': 9045,
'APL FUNCTIONAL SYMBOL UP TACK OVERBAR': 9041,
'APL FUNCTIONAL SYMBOL UPWARDS VANE': 9039,
'APL FUNCTIONAL SYMBOL ZILDE': 9068,
'APOSTROPHE': 39,
'APPROACHES THE LIMIT': 8784,
'APPROXIMATELY BUT NOT ACTUALLY EQUAL TO': 8774,
'APPROXIMATELY EQUAL OR EQUAL TO': 10864,
'APPROXIMATELY EQUAL TO': 8773,
'APPROXIMATELY EQUAL TO OR THE IMAGE OF': 8786,
'AQUARIUS': 9810,
'ARABIC COMMA': 1548,
'ARABIC DAMMA': 1615,
'ARABIC DAMMA ISOLATED FORM': 65144,
'ARABIC DAMMA MEDIAL FORM': 65145,
'ARABIC DAMMATAN': 1612,
'ARABIC DAMMATAN ISOLATED FORM': 65138,
'ARABIC DECIMAL SEPARATOR': 1643,
'ARABIC EMPTY CENTRE HIGH STOP': 1771,
'ARABIC EMPTY CENTRE LOW STOP': 1770,
'ARABIC END OF AYAH': 1757,
'ARABIC FATHA': 1614,
'ARABIC FATHA ISOLATED FORM': 65142,
'ARABIC FATHA MEDIAL FORM': 65143,
'ARABIC FATHATAN': 1611,
'ARABIC FATHATAN ISOLATED FORM': 65136,
'ARABIC FIVE POINTED STAR': 1645,
'ARABIC FULL STOP': 1748,
'ARABIC HAMZA ABOVE': 1620,
'ARABIC HAMZA BELOW': 1621,
'ARABIC KASRA': 1616,
'ARABIC KASRA ISOLATED FORM': 65146,
'ARABIC KASRA MEDIAL FORM': 65147,
'ARABIC KASRATAN': 1613,
'ARABIC KASRATAN ISOLATED FORM': 65140,
'ARABIC LETTER AE': 1749,
'ARABIC LETTER AIN': 1593,
'ARABIC LETTER AIN FINAL FORM': 65226,
'ARABIC LETTER AIN INITIAL FORM': 65227,
'ARABIC LETTER AIN ISOLATED FORM': 65225,
'ARABIC LETTER AIN MEDIAL FORM': 65228,
'ARABIC LETTER AIN WITH THREE DOTS ABOVE': 1696,
'ARABIC LETTER ALEF': 1575,
'ARABIC LETTER ALEF FINAL FORM': 65166,
'ARABIC LETTER ALEF ISOLATED FORM': 65165,
'ARABIC LETTER ALEF MAKSURA': 1609,
'ARABIC LETTER ALEF MAKSURA FINAL FORM': 65264,
'ARABIC LETTER ALEF MAKSURA ISOLATED FORM': 65263,
'ARABIC LETTER ALEF WASLA': 1649,
'ARABIC LETTER ALEF WASLA FINAL FORM': 64337,
'ARABIC LETTER ALEF WASLA ISOLATED FORM': 64336,
'ARABIC LETTER ALEF WITH HAMZA ABOVE': 1571,
'ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM': 65156,
'ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM': 65155,
'ARABIC LETTER ALEF WITH HAMZA BELOW': 1573,
'ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM': 65160,
'ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM': 65159,
'ARABIC LETTER ALEF WITH MADDA ABOVE': 1570,
'ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM': 65154,
'ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM': 65153,
'ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE': 1650,
'ARABIC LETTER ALEF WITH WAVY HAMZA BELOW': 1651,
'ARABIC LETTER BEEH': 1659,
'ARABIC LETTER BEEH FINAL FORM': 64339,
'ARABIC LETTER BEEH INITIAL FORM': 64340,
'ARABIC LETTER BEEH ISOLATED FORM': 64338,
'ARABIC LETTER BEEH MEDIAL FORM': 64341,
'ARABIC LETTER BEH': 1576,
'ARABIC LETTER BEH FINAL FORM': 65168,
'ARABIC LETTER BEH INITIAL FORM': 65169,
'ARABIC LETTER BEH ISOLATED FORM': 65167,
'ARABIC LETTER BEH MEDIAL FORM': 65170,
'ARABIC LETTER BEHEH': 1664,
'ARABIC LETTER BEHEH FINAL FORM': 64347,
'ARABIC LETTER BEHEH INITIAL FORM': 64348,
'ARABIC LETTER BEHEH ISOLATED FORM': 64346,
'ARABIC LETTER BEHEH MEDIAL FORM': 64349,
'ARABIC LETTER DAD': 1590,
'ARABIC LETTER DAD FINAL FORM': 65214,
'ARABIC LETTER DAD INITIAL FORM': 65215,
'ARABIC LETTER DAD ISOLATED FORM': 65213,
'ARABIC LETTER DAD MEDIAL FORM': 65216,
'ARABIC LETTER DAD WITH DOT BELOW': 1787,
'ARABIC LETTER DAHAL': 1676,
'ARABIC LETTER DAHAL FINAL FORM': 64389,
'ARABIC LETTER DAHAL ISOLATED FORM': 64388,
'ARABIC LETTER DAL': 1583,
'ARABIC LETTER DAL FINAL FORM': 65194,
'ARABIC LETTER DAL ISOLATED FORM': 65193,
'ARABIC LETTER DAL WITH DOT BELOW': 1674,
'ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH': 1675,
'ARABIC LETTER DAL WITH FOUR DOTS ABOVE': 1680,
'ARABIC LETTER DAL WITH RING': 1673,
'ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS': 1679,
'ARABIC LETTER DDAHAL': 1677,
'ARABIC LETTER DDAHAL FINAL FORM': 64387,
'ARABIC LETTER DDAHAL ISOLATED FORM': 64386,
'ARABIC LETTER DDAL': 1672,
'ARABIC LETTER DDAL FINAL FORM': 64393,
'ARABIC LETTER DDAL ISOLATED FORM': 64392,
'ARABIC LETTER DOTLESS BEH': 1646,
'ARABIC LETTER DOTLESS FEH': 1697,
'ARABIC LETTER DOTLESS QAF': 1647,
'ARABIC LETTER DUL': 1678,
'ARABIC LETTER DUL FINAL FORM': 64391,
'ARABIC LETTER DUL ISOLATED FORM': 64390,
'ARABIC LETTER DYEH': 1668,
'ARABIC LETTER DYEH FINAL FORM': 64371,
'ARABIC LETTER DYEH INITIAL FORM': 64372,
'ARABIC LETTER DYEH ISOLATED FORM': 64370,
'ARABIC LETTER DYEH MEDIAL FORM': 64373,
'ARABIC LETTER E': 1744,
'ARABIC LETTER E FINAL FORM': 64485,
'ARABIC LETTER E INITIAL FORM': 64486,
'ARABIC LETTER E ISOLATED FORM': 64484,
'ARABIC LETTER E MEDIAL FORM': 64487,
'ARABIC LETTER FARSI YEH': 1740,
'ARABIC LETTER FARSI YEH FINAL FORM': 64509,
'ARABIC LETTER FARSI YEH INITIAL FORM': 64510,
'ARABIC LETTER FARSI YEH ISOLATED FORM': 64508,
'ARABIC LETTER FARSI YEH MEDIAL FORM': 64511,
'ARABIC LETTER FEH': 1601,
'ARABIC LETTER FEH FINAL FORM': 65234,
'ARABIC LETTER FEH INITIAL FORM': 65235,
'ARABIC LETTER FEH ISOLATED FORM': 65233,
'ARABIC LETTER FEH MEDIAL FORM': 65236,
'ARABIC LETTER FEH WITH DOT BELOW': 1699,
'ARABIC LETTER FEH WITH DOT MOVED BELOW': 1698,
'ARABIC LETTER FEH WITH THREE DOTS BELOW': 1701,
'ARABIC LETTER GAF': 1711,
'ARABIC LETTER GAF FINAL FORM': 64403,
'ARABIC LETTER GAF INITIAL FORM': 64404,
'ARABIC LETTER GAF ISOLATED FORM': 64402,
'ARABIC LETTER GAF MEDIAL FORM': 64405,
'ARABIC LETTER GAF WITH RING': 1712,
'ARABIC LETTER GAF WITH THREE DOTS ABOVE': 1716,
'ARABIC LETTER GAF WITH TWO DOTS BELOW': 1714,
'ARABIC LETTER GHAIN': 1594,
'ARABIC LETTER GHAIN FINAL FORM': 65230,
'ARABIC LETTER GHAIN INITIAL FORM': 65231,
'ARABIC LETTER GHAIN ISOLATED FORM': 65229,
'ARABIC LETTER GHAIN MEDIAL FORM': 65232,
'ARABIC LETTER GHAIN WITH DOT BELOW': 1788,
'ARABIC LETTER GUEH': 1715,
'ARABIC LETTER GUEH FINAL FORM': 64407,
'ARABIC LETTER GUEH INITIAL FORM': 64408,
'ARABIC LETTER GUEH ISOLATED FORM': 64406,
'ARABIC LETTER GUEH MEDIAL FORM': 64409,
'ARABIC LETTER HAH': 1581,
'ARABIC LETTER HAH FINAL FORM': 65186,
'ARABIC LETTER HAH INITIAL FORM': 65187,
'ARABIC LETTER HAH ISOLATED FORM': 65185,
'ARABIC LETTER HAH MEDIAL FORM': 65188,
'ARABIC LETTER HAH WITH HAMZA ABOVE': 1665,
'ARABIC LETTER HAH WITH THREE DOTS ABOVE': 1669,
'ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE': 1666,
'ARABIC LETTER HAMZA': 1569,
'ARABIC LETTER HAMZA ISOLATED FORM': 65152,
'ARABIC LETTER HEH': 1607,
'ARABIC LETTER HEH DOACHASHMEE': 1726,
'ARABIC LETTER HEH DOACHASHMEE FINAL FORM': 64427,
'ARABIC LETTER HEH DOACHASHMEE INITIAL FORM': 64428,
'ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM': 64426,
'ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM': 64429,
'ARABIC LETTER HEH FINAL FORM': 65258,
'ARABIC LETTER HEH GOAL': 1729,
'ARABIC LETTER HEH GOAL FINAL FORM': 64423,
'ARABIC LETTER HEH GOAL INITIAL FORM': 64424,
'ARABIC LETTER HEH GOAL ISOLATED FORM': 64422,
'ARABIC LETTER HEH GOAL MEDIAL FORM': 64425,
'ARABIC LETTER HEH GOAL WITH HAMZA ABOVE': 1730,
'ARABIC LETTER HEH INITIAL FORM': 65259,
'ARABIC LETTER HEH ISOLATED FORM': 65257,
'ARABIC LETTER HEH MEDIAL FORM': 65260,
'ARABIC LETTER HEH WITH YEH ABOVE': 1728,
'ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM': 64421,
'ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM': 64420,
'ARABIC LETTER HIGH HAMZA': 1652,
'ARABIC LETTER HIGH HAMZA ALEF': 1653,
'ARABIC LETTER HIGH HAMZA WAW': 1654,
'ARABIC LETTER HIGH HAMZA YEH': 1656,
'ARABIC LETTER JEEM': 1580,
'ARABIC LETTER JEEM FINAL FORM': 65182,
'ARABIC LETTER JEEM INITIAL FORM': 65183,
'ARABIC LETTER JEEM ISOLATED FORM': 65181,
'ARABIC LETTER JEEM MEDIAL FORM': 65184,
'ARABIC LETTER JEH': 1688,
'ARABIC LETTER JEH FINAL FORM': 64395,
'ARABIC LETTER JEH ISOLATED FORM': 64394,
'ARABIC LETTER KAF': 1603,
'ARABIC LETTER KAF FINAL FORM': 65242,
'ARABIC LETTER KAF INITIAL FORM': 65243,
'ARABIC LETTER KAF ISOLATED FORM': 65241,
'ARABIC LETTER KAF MEDIAL FORM': 65244,
'ARABIC LETTER KAF WITH DOT ABOVE': 1708,
'ARABIC LETTER KAF WITH RING': 1707,
'ARABIC LETTER KAF WITH THREE DOTS BELOW': 1710,
'ARABIC LETTER KEHEH': 1705,
'ARABIC LETTER KEHEH FINAL FORM': 64399,
'ARABIC LETTER KEHEH INITIAL FORM': 64400,
'ARABIC LETTER KEHEH ISOLATED FORM': 64398,
'ARABIC LETTER KEHEH MEDIAL FORM': 64401,
'ARABIC LETTER KHAH': 1582,
'ARABIC LETTER KHAH FINAL FORM': 65190,
'ARABIC LETTER KHAH INITIAL FORM': 65191,
'ARABIC LETTER KHAH ISOLATED FORM': 65189,
'ARABIC LETTER KHAH MEDIAL FORM': 65192,
'ARABIC LETTER KIRGHIZ OE': 1733,
'ARABIC LETTER KIRGHIZ OE FINAL FORM': 64481,
'ARABIC LETTER KIRGHIZ OE ISOLATED FORM': 64480,
'ARABIC LETTER KIRGHIZ YU': 1737,
'ARABIC LETTER KIRGHIZ YU FINAL FORM': 64483,
'ARABIC LETTER KIRGHIZ YU ISOLATED FORM': 64482,
'ARABIC LETTER LAM': 1604,
'ARABIC LETTER LAM FINAL FORM': 65246,
'ARABIC LETTER LAM INITIAL FORM': 65247,
'ARABIC LETTER LAM ISOLATED FORM': 65245,
'ARABIC LETTER LAM MEDIAL FORM': 65248,
'ARABIC LETTER LAM WITH DOT ABOVE': 1718,
'ARABIC LETTER LAM WITH SMALL V': 1717,
'ARABIC LETTER LAM WITH THREE DOTS ABOVE': 1719,
'ARABIC LETTER LAM WITH THREE DOTS BELOW': 1720,
'ARABIC LETTER MEEM': 1605,
'ARABIC LETTER MEEM FINAL FORM': 65250,
'ARABIC LETTER MEEM INITIAL FORM': 65251,
'ARABIC LETTER MEEM ISOLATED FORM': 65249,
'ARABIC LETTER MEEM MEDIAL FORM': 65252,
'ARABIC LETTER NG': 1709,
'ARABIC LETTER NG FINAL FORM': 64468,
'ARABIC LETTER NG INITIAL FORM': 64469,
'ARABIC LETTER NG ISOLATED FORM': 64467,
'ARABIC LETTER NG MEDIAL FORM': 64470,
'ARABIC LETTER NGOEH': 1713,
'ARABIC LETTER NGOEH FINAL FORM': 64411,
'ARABIC LETTER NGOEH INITIAL FORM': 64412,
'ARABIC LETTER NGOEH ISOLATED FORM': 64410,
'ARABIC LETTER NGOEH MEDIAL FORM': 64413,
'ARABIC LETTER NOON': 1606,
'ARABIC LETTER NOON FINAL FORM': 65254,
'ARABIC LETTER NOON GHUNNA': 1722,
'ARABIC LETTER NOON GHUNNA FINAL FORM': 64415,
'ARABIC LETTER NOON GHUNNA ISOLATED FORM': 64414,
'ARABIC LETTER NOON INITIAL FORM': 65255,
'ARABIC LETTER NOON ISOLATED FORM': 65253,
'ARABIC LETTER NOON MEDIAL FORM': 65256,
'ARABIC LETTER NOON WITH DOT BELOW': 1721,
'ARABIC LETTER NOON WITH RING': 1724,
'ARABIC LETTER NOON WITH THREE DOTS ABOVE': 1725,
'ARABIC LETTER NYEH': 1667,
'ARABIC LETTER NYEH FINAL FORM': 64375,
'ARABIC LETTER NYEH INITIAL FORM': 64376,
'ARABIC LETTER NYEH ISOLATED FORM': 64374,
'ARABIC LETTER NYEH MEDIAL FORM': 64377,
'ARABIC LETTER OE': 1734,
'ARABIC LETTER OE FINAL FORM': 64474,
'ARABIC LETTER OE ISOLATED FORM': 64473,
'ARABIC LETTER PEH': 1662,
'ARABIC LETTER PEH FINAL FORM': 64343,
'ARABIC LETTER PEH INITIAL FORM': 64344,
'ARABIC LETTER PEH ISOLATED FORM': 64342,
'ARABIC LETTER PEH MEDIAL FORM': 64345,
'ARABIC LETTER PEHEH': 1702,
'ARABIC LETTER PEHEH FINAL FORM': 64367,
'ARABIC LETTER PEHEH INITIAL FORM': 64368,
'ARABIC LETTER PEHEH ISOLATED FORM': 64366,
'ARABIC LETTER PEHEH MEDIAL FORM': 64369,
'ARABIC LETTER QAF': 1602,
'ARABIC LETTER QAF FINAL FORM': 65238,
'ARABIC LETTER QAF INITIAL FORM': 65239,
'ARABIC LETTER QAF ISOLATED FORM': 65237,
'ARABIC LETTER QAF MEDIAL FORM': 65240,
'ARABIC LETTER QAF WITH DOT ABOVE': 1703,
'ARABIC LETTER QAF WITH THREE DOTS ABOVE': 1704,
'ARABIC LETTER REH': 1585,
'ARABIC LETTER REH FINAL FORM': 65198,
'ARABIC LETTER REH ISOLATED FORM': 65197,
'ARABIC LETTER REH WITH DOT BELOW': 1684,
'ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE': 1686,
'ARABIC LETTER REH WITH FOUR DOTS ABOVE': 1689,
'ARABIC LETTER REH WITH RING': 1683,
'ARABIC LETTER REH WITH SMALL V': 1682,
'ARABIC LETTER REH WITH SMALL V BELOW': 1685,
'ARABIC LETTER REH WITH TWO DOTS ABOVE': 1687,
'ARABIC LETTER RNOON': 1723,
'ARABIC LETTER RNOON FINAL FORM': 64417,
'ARABIC LETTER RNOON INITIAL FORM': 64418,
'ARABIC LETTER RNOON ISOLATED FORM': 64416,
'ARABIC LETTER RNOON MEDIAL FORM': 64419,
'ARABIC LETTER RREH': 1681,
'ARABIC LETTER RREH FINAL FORM': 64397,
'ARABIC LETTER RREH ISOLATED FORM': 64396,
'ARABIC LETTER SAD': 1589,
'ARABIC LETTER SAD FINAL FORM': 65210,
'ARABIC LETTER SAD INITIAL FORM': 65211,
'ARABIC LETTER SAD ISOLATED FORM': 65209,
'ARABIC LETTER SAD MEDIAL FORM': 65212,
'ARABIC LETTER SAD WITH THREE DOTS ABOVE': 1694,
'ARABIC LETTER SAD WITH TWO DOTS BELOW': 1693,
'ARABIC LETTER SEEN': 1587,
'ARABIC LETTER SEEN FINAL FORM': 65202,
'ARABIC LETTER SEEN INITIAL FORM': 65203,
'ARABIC LETTER SEEN ISOLATED FORM': 65201,
'ARABIC LETTER SEEN MEDIAL FORM': 65204,
'ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE': 1690,
'ARABIC LETTER SEEN WITH THREE DOTS BELOW': 1691,
'ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE': 1692,
'ARABIC LETTER SHEEN': 1588,
'ARABIC LETTER SHEEN FINAL FORM': 65206,
'ARABIC LETTER SHEEN INITIAL FORM': 65207,
'ARABIC LETTER SHEEN ISOLATED FORM': 65205,
'ARABIC LETTER SHEEN MEDIAL FORM': 65208,
'ARABIC LETTER SHEEN WITH DOT BELOW': 1786,
'ARABIC LETTER SUPERSCRIPT ALEF': 1648,
'ARABIC LETTER SWASH KAF': 1706,
'ARABIC LETTER TAH': 1591,
'ARABIC LETTER TAH FINAL FORM': 65218,
'ARABIC LETTER TAH INITIAL FORM': 65219,
'ARABIC LETTER TAH ISOLATED FORM': 65217,
'ARABIC LETTER TAH MEDIAL FORM': 65220,
'ARABIC LETTER TAH WITH THREE DOTS ABOVE': 1695,
'ARABIC LETTER TCHEH': 1670,
'ARABIC LETTER TCHEH FINAL FORM': 64379,
'ARABIC LETTER TCHEH INITIAL FORM': 64380,
'ARABIC LETTER TCHEH ISOLATED FORM': 64378,
'ARABIC LETTER TCHEH MEDIAL FORM': 64381,
'ARABIC LETTER TCHEH WITH DOT ABOVE': 1727,
'ARABIC LETTER TCHEHEH': 1671,
'ARABIC LETTER TCHEHEH FINAL FORM': 64383,
'ARABIC LETTER TCHEHEH INITIAL FORM': 64384,
'ARABIC LETTER TCHEHEH ISOLATED FORM': 64382,
'ARABIC LETTER TCHEHEH MEDIAL FORM': 64385,
'ARABIC LETTER TEH': 1578,
'ARABIC LETTER TEH FINAL FORM': 65174,
'ARABIC LETTER TEH INITIAL FORM': 65175,
'ARABIC LETTER TEH ISOLATED FORM': 65173,
'ARABIC LETTER TEH MARBUTA': 1577,
'ARABIC LETTER TEH MARBUTA FINAL FORM': 65172,
'ARABIC LETTER TEH MARBUTA GOAL': 1731,
'ARABIC LETTER TEH MARBUTA ISOLATED FORM': 65171,
'ARABIC LETTER TEH MEDIAL FORM': 65176,
'ARABIC LETTER TEH WITH RING': 1660,
'ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS': 1661,
'ARABIC LETTER TEHEH': 1663,
'ARABIC LETTER TEHEH FINAL FORM': 64355,
'ARABIC LETTER TEHEH INITIAL FORM': 64356,
'ARABIC LETTER TEHEH ISOLATED FORM': 64354,
'ARABIC LETTER TEHEH MEDIAL FORM': 64357,
'ARABIC LETTER THAL': 1584,
'ARABIC LETTER THAL FINAL FORM': 65196,
'ARABIC LETTER THAL ISOLATED FORM': 65195,
'ARABIC LETTER THEH': 1579,
'ARABIC LETTER THEH FINAL FORM': 65178,
'ARABIC LETTER THEH INITIAL FORM': 65179,
'ARABIC LETTER THEH ISOLATED FORM': 65177,
'ARABIC LETTER THEH MEDIAL FORM': 65180,
'ARABIC LETTER TTEH': 1657,
'ARABIC LETTER TTEH FINAL FORM': 64359,
'ARABIC LETTER TTEH INITIAL FORM': 64360,
'ARABIC LETTER TTEH ISOLATED FORM': 64358,
'ARABIC LETTER TTEH MEDIAL FORM': 64361,
'ARABIC LETTER TTEHEH': 1658,
'ARABIC LETTER TTEHEH FINAL FORM': 64351,
'ARABIC LETTER TTEHEH INITIAL FORM': 64352,
'ARABIC LETTER TTEHEH ISOLATED FORM': 64350,
'ARABIC LETTER TTEHEH MEDIAL FORM': 64353,
'ARABIC LETTER U': 1735,
'ARABIC LETTER U FINAL FORM': 64472,
'ARABIC LETTER U ISOLATED FORM': 64471,
'ARABIC LETTER U WITH HAMZA ABOVE': 1655,
'ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM': 64477,
'ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM': 64488,
'ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM': 64489,
'ARABIC LETTER VE': 1739,
'ARABIC LETTER VE FINAL FORM': 64479,
'ARABIC LETTER VE ISOLATED FORM': 64478,
'ARABIC LETTER VEH': 1700,
'ARABIC LETTER VEH FINAL FORM': 64363,
'ARABIC LETTER VEH INITIAL FORM': 64364,
'ARABIC LETTER VEH ISOLATED FORM': 64362,
'ARABIC LETTER VEH MEDIAL FORM': 64365,
'ARABIC LETTER WAW': 1608,
'ARABIC LETTER WAW FINAL FORM': 65262,
'ARABIC LETTER WAW ISOLATED FORM': 65261,
'ARABIC LETTER WAW WITH DOT ABOVE': 1743,
'ARABIC LETTER WAW WITH HAMZA ABOVE': 1572,
'ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM': 65158,
'ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM': 65157,
'ARABIC LETTER WAW WITH RING': 1732,
'ARABIC LETTER WAW WITH TWO DOTS ABOVE': 1738,
'ARABIC LETTER YEH': 1610,
'ARABIC LETTER YEH BARREE': 1746,
'ARABIC LETTER YEH BARREE FINAL FORM': 64431,
'ARABIC LETTER YEH BARREE ISOLATED FORM': 64430,
'ARABIC LETTER YEH BARREE WITH HAMZA ABOVE': 1747,
'ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM': 64433,
'ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM': 64432,
'ARABIC LETTER YEH FINAL FORM': 65266,
'ARABIC LETTER YEH INITIAL FORM': 65267,
'ARABIC LETTER YEH ISOLATED FORM': 65265,
'ARABIC LETTER YEH MEDIAL FORM': 65268,
'ARABIC LETTER YEH WITH HAMZA ABOVE': 1574,
'ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM': 65162,
'ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM': 65163,
'ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM': 65161,
'ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM': 65164,
'ARABIC LETTER YEH WITH SMALL V': 1742,
'ARABIC LETTER YEH WITH TAIL': 1741,
'ARABIC LETTER YEH WITH THREE DOTS BELOW': 1745,
'ARABIC LETTER YU': 1736,
'ARABIC LETTER YU FINAL FORM': 64476,
'ARABIC LETTER YU ISOLATED FORM': 64475,
'ARABIC LETTER ZAH': 1592,
'ARABIC LETTER ZAH FINAL FORM': 65222,
'ARABIC LETTER ZAH INITIAL FORM': 65223,
'ARABIC LETTER ZAH ISOLATED FORM': 65221,
'ARABIC LETTER ZAH MEDIAL FORM': 65224,
'ARABIC LETTER ZAIN': 1586,
'ARABIC LETTER ZAIN FINAL FORM': 65200,
'ARABIC LETTER ZAIN ISOLATED FORM': 65199,
'ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM': 64787,
'ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM': 64759,
'ARABIC LIGATURE AIN WITH JEEM INITIAL FORM': 64698,
'ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM': 64553,
'ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM': 64885,
'ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM': 64964,
'ARABIC LIGATURE AIN WITH MEEM INITIAL FORM': 64699,
'ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM': 64554,
'ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM': 64888,
'ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM': 64886,
'ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM': 64887,
'ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM': 64950,
'ARABIC LIGATURE AIN WITH YEH FINAL FORM': 64788,
'ARABIC LIGATURE AIN WITH YEH ISOLATED FORM': 64760,
'ARABIC LIGATURE AKBAR ISOLATED FORM': 65011,
'ARABIC LIGATURE ALAYHE ISOLATED FORM': 65015,
'ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM': 64656,
'ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM': 64605,
'ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM': 64828,
'ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM': 64829,
'ARABIC LIGATURE ALLAH ISOLATED FORM': 65010,
'ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM': 64622,
'ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM': 64521,
'ARABIC LIGATURE BEH WITH HAH INITIAL FORM': 64669,
'ARABIC LIGATURE BEH WITH HAH ISOLATED FORM': 64518,
'ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM': 64962,
'ARABIC LIGATURE BEH WITH HEH INITIAL FORM': 64672,
'ARABIC LIGATURE BEH WITH HEH MEDIAL FORM': 64738,
'ARABIC LIGATURE BEH WITH JEEM INITIAL FORM': 64668,
'ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM': 64517,
'ARABIC LIGATURE BEH WITH KHAH INITIAL FORM': 64670,
'ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM': 64519,
'ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM': 64926,
'ARABIC LIGATURE BEH WITH MEEM FINAL FORM': 64620,
'ARABIC LIGATURE BEH WITH MEEM INITIAL FORM': 64671,
'ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM': 64520,
'ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM': 64737,
'ARABIC LIGATURE BEH WITH NOON FINAL FORM': 64621,
'ARABIC LIGATURE BEH WITH REH FINAL FORM': 64618,
'ARABIC LIGATURE BEH WITH YEH FINAL FORM': 64623,
'ARABIC LIGATURE BEH WITH YEH ISOLATED FORM': 64522,
'ARABIC LIGATURE BEH WITH ZAIN FINAL FORM': 64619,
'ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM': 64803,
'ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM': 64775,
'ARABIC LIGATURE DAD WITH HAH INITIAL FORM': 64693,
'ARABIC LIGATURE DAD WITH HAH ISOLATED FORM': 64547,
'ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM': 64878,
'ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM': 64939,
'ARABIC LIGATURE DAD WITH JEEM INITIAL FORM': 64692,
'ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM': 64546,
'ARABIC LIGATURE DAD WITH KHAH INITIAL FORM': 64694,
'ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM': 64548,
'ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM': 64879,
'ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM': 64880,
'ARABIC LIGATURE DAD WITH MEEM INITIAL FORM': 64695,
'ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM': 64549,
'ARABIC LIGATURE DAD WITH REH FINAL FORM': 64812,
'ARABIC LIGATURE DAD WITH REH ISOLATED FORM': 64784,
'ARABIC LIGATURE DAD WITH YEH FINAL FORM': 64804,
'ARABIC LIGATURE DAD WITH YEH ISOLATED FORM': 64776,
'ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM': 64636,
'ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM': 64561,
'ARABIC LIGATURE FEH WITH HAH INITIAL FORM': 64703,
'ARABIC LIGATURE FEH WITH HAH ISOLATED FORM': 64558,
'ARABIC LIGATURE FEH WITH JEEM INITIAL FORM': 64702,
'ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM': 64557,
'ARABIC LIGATURE FEH WITH KHAH INITIAL FORM': 64704,
'ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM': 64559,
'ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM': 64892,
'ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM': 64893,
'ARABIC LIGATURE FEH WITH MEEM INITIAL FORM': 64705,
'ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM': 64560,
'ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM': 64961,
'ARABIC LIGATURE FEH WITH YEH FINAL FORM': 64637,
'ARABIC LIGATURE FEH WITH YEH ISOLATED FORM': 64562,
'ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM': 64789,
'ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM': 64761,
'ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM': 64700,
'ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM': 64555,
'ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM': 64701,
'ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM': 64556,
'ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM': 64891,
'ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM': 64889,
'ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM': 64890,
'ARABIC LIGATURE GHAIN WITH YEH FINAL FORM': 64790,
'ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM': 64762,
'ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM': 64795,
'ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM': 64767,
'ARABIC LIGATURE HAH WITH JEEM INITIAL FORM': 64681,
'ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM': 64535,
'ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM': 64959,
'ARABIC LIGATURE HAH WITH MEEM INITIAL FORM': 64682,
'ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM': 64536,
'ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM': 64859,
'ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM': 64858,
'ARABIC LIGATURE HAH WITH YEH FINAL FORM': 64796,
'ARABIC LIGATURE HAH WITH YEH ISOLATED FORM': 64768,
'ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM': 64595,
'ARABIC LIGATURE HEH WITH JEEM INITIAL FORM': 64727,
'ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM': 64593,
'ARABIC LIGATURE HEH WITH MEEM INITIAL FORM': 64728,
'ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM': 64594,
'ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM': 64915,
'ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM': 64916,
'ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM': 64729,
'ARABIC LIGATURE HEH WITH YEH ISOLATED FORM': 64596,
'ARABIC LIGATURE JALLAJALALOUHOU': 65019,
'ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM': 64797,
'ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM': 64769,
'ARABIC LIGATURE JEEM WITH HAH INITIAL FORM': 64679,
'ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM': 64533,
'ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM': 64934,
'ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM': 64958,
'ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM': 64680,
'ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM': 64534,
'ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM': 64935,
'ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM': 64856,
'ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM': 64857,
'ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM': 64933,
'ARABIC LIGATURE JEEM WITH YEH FINAL FORM': 64798,
'ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM': 64770,
'ARABIC LIGATURE KAF WITH ALEF FINAL FORM': 64640,
'ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM': 64567,
'ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM': 64643,
'ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM': 64573,
'ARABIC LIGATURE KAF WITH HAH INITIAL FORM': 64709,
'ARABIC LIGATURE KAF WITH HAH ISOLATED FORM': 64569,
'ARABIC LIGATURE KAF WITH JEEM INITIAL FORM': 64708,
'ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM': 64568,
'ARABIC LIGATURE KAF WITH KHAH INITIAL FORM': 64710,
'ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM': 64570,
'ARABIC LIGATURE KAF WITH LAM FINAL FORM': 64641,
'ARABIC LIGATURE KAF WITH LAM INITIAL FORM': 64711,
'ARABIC LIGATURE KAF WITH LAM ISOLATED FORM': 64571,
'ARABIC LIGATURE KAF WITH LAM MEDIAL FORM': 64747,
'ARABIC LIGATURE KAF WITH MEEM FINAL FORM': 64642,
'ARABIC LIGATURE KAF WITH MEEM INITIAL FORM': 64712,
'ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM': 64572,
'ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM': 64748,
'ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM': 64955,
'ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM': 64963,
'ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM': 64951,
'ARABIC LIGATURE KAF WITH YEH FINAL FORM': 64644,
'ARABIC LIGATURE KAF WITH YEH ISOLATED FORM': 64574,
'ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM': 64799,
'ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM': 64771,
'ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM': 64538,
'ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM': 64683,
'ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM': 64537,
'ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM': 64684,
'ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM': 64539,
'ARABIC LIGATURE KHAH WITH YEH FINAL FORM': 64800,
'ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM': 64772,
'ARABIC LIGATURE LAM WITH ALEF FINAL FORM': 65276,
'ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM': 65275,
'ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM': 64646,
'ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM': 64579,
'ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM': 65272,
'ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM': 65271,
'ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM': 65274,
'ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM': 65273,
'ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM': 65270,
'ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM': 65269,
'ARABIC LIGATURE LAM WITH HAH INITIAL FORM': 64714,
'ARABIC LIGATURE LAM WITH HAH ISOLATED FORM': 64576,
'ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM': 64898,
'ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM': 64896,
'ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM': 64949,
'ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM': 64897,
'ARABIC LIGATURE LAM WITH HEH INITIAL FORM': 64717,
'ARABIC LIGATURE LAM WITH JEEM INITIAL FORM': 64713,
'ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM': 64575,
'ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM': 64900,
'ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM': 64899,
'ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM': 64956,
'ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM': 64954,
'ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM': 64940,
'ARABIC LIGATURE LAM WITH KHAH INITIAL FORM': 64715,
'ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM': 64577,
'ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM': 64901,
'ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM': 64902,
'ARABIC LIGATURE LAM WITH MEEM FINAL FORM': 64645,
'ARABIC LIGATURE LAM WITH MEEM INITIAL FORM': 64716,
'ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM': 64578,
'ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM': 64749,
'ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM': 64903,
'ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM': 64904,
'ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM': 64941,
'ARABIC LIGATURE LAM WITH YEH FINAL FORM': 64647,
'ARABIC LIGATURE LAM WITH YEH ISOLATED FORM': 64580,
'ARABIC LIGATURE MEEM WITH ALEF FINAL FORM': 64648,
'ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM': 64585,
'ARABIC LIGATURE MEEM WITH HAH INITIAL FORM': 64719,
'ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM': 64582,
'ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM': 64905,
'ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM': 64906,
'ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM': 64907,
'ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM': 64718,
'ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM': 64581,
'ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM': 64908,
'ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM': 64914,
'ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM': 64909,
'ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM': 64960,
'ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM': 64720,
'ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM': 64583,
'ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM': 64910,
'ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM': 64911,
'ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM': 64953,
'ARABIC LIGATURE MEEM WITH MEEM FINAL FORM': 64649,
'ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM': 64721,
'ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM': 64584,
'ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM': 64945,
'ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM': 64586,
'ARABIC LIGATURE MOHAMMAD ISOLATED FORM': 65012,
'ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM': 64654,
'ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM': 64591,
'ARABIC LIGATURE NOON WITH HAH INITIAL FORM': 64723,
'ARABIC LIGATURE NOON WITH HAH ISOLATED FORM': 64588,
'ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM': 64918,
'ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM': 64917,
'ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM': 64947,
'ARABIC LIGATURE NOON WITH HEH INITIAL FORM': 64726,
'ARABIC LIGATURE NOON WITH HEH MEDIAL FORM': 64751,
'ARABIC LIGATURE NOON WITH JEEM INITIAL FORM': 64722,
'ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM': 64587,
'ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM': 64921,
'ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM': 64957,
'ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM': 64952,
'ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM': 64919,
'ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM': 64920,
'ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM': 64967,
'ARABIC LIGATURE NOON WITH KHAH INITIAL FORM': 64724,
'ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM': 64589,
'ARABIC LIGATURE NOON WITH MEEM FINAL FORM': 64652,
'ARABIC LIGATURE NOON WITH MEEM INITIAL FORM': 64725,
'ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM': 64590,
'ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM': 64750,
'ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM': 64923,
'ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM': 64922,
'ARABIC LIGATURE NOON WITH NOON FINAL FORM': 64653,
'ARABIC LIGATURE NOON WITH REH FINAL FORM': 64650,
'ARABIC LIGATURE NOON WITH YEH FINAL FORM': 64655,
'ARABIC LIGATURE NOON WITH YEH ISOLATED FORM': 64592,
'ARABIC LIGATURE NOON WITH ZAIN FINAL FORM': 64651,
'ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM': 64638,
'ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM': 64565,
'ARABIC LIGATURE QAF WITH HAH INITIAL FORM': 64706,
'ARABIC LIGATURE QAF WITH HAH ISOLATED FORM': 64563,
'ARABIC LIGATURE QAF WITH MEEM INITIAL FORM': 64707,
'ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM': 64564,
'ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM': 64894,
'ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM': 64948,
'ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM': 64895,
'ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM': 64946,
'ARABIC LIGATURE QAF WITH YEH FINAL FORM': 64639,
'ARABIC LIGATURE QAF WITH YEH ISOLATED FORM': 64566,
'ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM': 65009,
'ARABIC LIGATURE RASOUL ISOLATED FORM': 65014,
'ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM': 64604,
'ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM': 64801,
'ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM': 64773,
'ARABIC LIGATURE SAD WITH HAH INITIAL FORM': 64689,
'ARABIC LIGATURE SAD WITH HAH ISOLATED FORM': 64544,
'ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM': 64868,
'ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM': 64869,
'ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM': 64937,
'ARABIC LIGATURE SAD WITH KHAH INITIAL FORM': 64690,
'ARABIC LIGATURE SAD WITH MEEM INITIAL FORM': 64691,
'ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM': 64545,
'ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM': 64870,
'ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM': 64965,
'ARABIC LIGATURE SAD WITH REH FINAL FORM': 64811,
'ARABIC LIGATURE SAD WITH REH ISOLATED FORM': 64783,
'ARABIC LIGATURE SAD WITH YEH FINAL FORM': 64802,
'ARABIC LIGATURE SAD WITH YEH ISOLATED FORM': 64774,
'ARABIC LIGATURE SALAM ISOLATED FORM': 65013,
'ARABIC LIGATURE SALLA ISOLATED FORM': 65017,
'ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM': 65008,
'ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM': 65018,
'ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM': 64791,
'ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM': 64763,
'ARABIC LIGATURE SEEN WITH HAH INITIAL FORM': 64686,
'ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM': 64541,
'ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM': 64821,
'ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM': 64860,
'ARABIC LIGATURE SEEN WITH HEH INITIAL FORM': 64817,
'ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM': 64744,
'ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM': 64685,
'ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM': 64540,
'ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM': 64820,
'ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM': 64862,
'ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM': 64861,
'ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM': 64687,
'ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM': 64542,
'ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM': 64822,
'ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM': 64936,
'ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM': 64966,
'ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM': 64688,
'ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM': 64543,
'ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM': 64743,
'ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM': 64863,
'ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM': 64864,
'ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM': 64865,
'ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM': 64866,
'ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM': 64867,
'ARABIC LIGATURE SEEN WITH REH FINAL FORM': 64810,
'ARABIC LIGATURE SEEN WITH REH ISOLATED FORM': 64782,
'ARABIC LIGATURE SEEN WITH YEH FINAL FORM': 64792,
'ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM': 64764,
'ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM': 64609,
'ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM': 64755,
'ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM': 64606,
'ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM': 64608,
'ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM': 64754,
'ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM': 64610,
'ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM': 64756,
'ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM': 64607,
'ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM': 64611,
'ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM': 64793,
'ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM': 64765,
'ARABIC LIGATURE SHEEN WITH HAH FINAL FORM': 64806,
'ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM': 64814,
'ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM': 64778,
'ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM': 64824,
'ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM': 64871,
'ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM': 64872,
'ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM': 64938,
'ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM': 64818,
'ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM': 64746,
'ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM': 64805,
'ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM': 64813,
'ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM': 64777,
'ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM': 64823,
'ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM': 64873,
'ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM': 64807,
'ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM': 64815,
'ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM': 64779,
'ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM': 64825,
'ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM': 64808,
'ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM': 64816,
'ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM': 64780,
'ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM': 64745,
'ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM': 64874,
'ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM': 64875,
'ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM': 64876,
'ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM': 64877,
'ARABIC LIGATURE SHEEN WITH REH FINAL FORM': 64809,
'ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM': 64781,
'ARABIC LIGATURE SHEEN WITH YEH FINAL FORM': 64794,
'ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM': 64766,
'ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM': 64785,
'ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM': 64757,
'ARABIC LIGATURE TAH WITH HAH INITIAL FORM': 64696,
'ARABIC LIGATURE TAH WITH HAH ISOLATED FORM': 64550,
'ARABIC LIGATURE TAH WITH MEEM INITIAL FORM': 64819,
'ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM': 64551,
'ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM': 64826,
'ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM': 64881,
'ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM': 64882,
'ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM': 64883,
'ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM': 64884,
'ARABIC LIGATURE TAH WITH YEH FINAL FORM': 64786,
'ARABIC LIGATURE TAH WITH YEH ISOLATED FORM': 64758,
'ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM': 64628,
'ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM': 64527,
'ARABIC LIGATURE TEH WITH HAH INITIAL FORM': 64674,
'ARABIC LIGATURE TEH WITH HAH ISOLATED FORM': 64524,
'ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM': 64849,
'ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM': 64850,
'ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM': 64851,
'ARABIC LIGATURE TEH WITH HEH INITIAL FORM': 64677,
'ARABIC LIGATURE TEH WITH HEH MEDIAL FORM': 64740,
'ARABIC LIGATURE TEH WITH JEEM INITIAL FORM': 64673,
'ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM': 64523,
'ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM': 64928,
'ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM': 64848,
'ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM': 64927,
'ARABIC LIGATURE TEH WITH KHAH INITIAL FORM': 64675,
'ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM': 64525,
'ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM': 64930,
'ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM': 64852,
'ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM': 64929,
'ARABIC LIGATURE TEH WITH MEEM FINAL FORM': 64626,
'ARABIC LIGATURE TEH WITH MEEM INITIAL FORM': 64676,
'ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM': 64526,
'ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM': 64739,
'ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM': 64932,
'ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM': 64854,
'ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM': 64853,
'ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM': 64855,
'ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM': 64931,
'ARABIC LIGATURE TEH WITH NOON FINAL FORM': 64627,
'ARABIC LIGATURE TEH WITH REH FINAL FORM': 64624,
'ARABIC LIGATURE TEH WITH YEH FINAL FORM': 64629,
'ARABIC LIGATURE TEH WITH YEH ISOLATED FORM': 64528,
'ARABIC LIGATURE TEH WITH ZAIN FINAL FORM': 64625,
'ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM': 64603,
'ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM': 64634,
'ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM': 64531,
'ARABIC LIGATURE THEH WITH HEH MEDIAL FORM': 64742,
'ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM': 64529,
'ARABIC LIGATURE THEH WITH MEEM FINAL FORM': 64632,
'ARABIC LIGATURE THEH WITH MEEM INITIAL FORM': 64678,
'ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM': 64530,
'ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM': 64741,
'ARABIC LIGATURE THEH WITH NOON FINAL FORM': 64633,
'ARABIC LIGATURE THEH WITH REH FINAL FORM': 64630,
'ARABIC LIGATURE THEH WITH YEH FINAL FORM': 64635,
'ARABIC LIGATURE THEH WITH YEH ISOLATED FORM': 64532,
'ARABIC LIGATURE THEH WITH ZAIN FINAL FORM': 64631,
'ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM': 64506,
'ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM': 64507,
'ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM': 64505,
'ARABIC LIGATURE WASALLAM ISOLATED FORM': 65016,
'ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM': 64661,
'ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM': 64601,
'ARABIC LIGATURE YEH WITH HAH INITIAL FORM': 64731,
'ARABIC LIGATURE YEH WITH HAH ISOLATED FORM': 64598,
'ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM': 64942,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM': 64493,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM': 64492,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM': 64491,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM': 64490,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM': 64616,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM': 64515,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM': 64503,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM': 64504,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM': 64502,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM': 64664,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM': 64513,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM': 64667,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM': 64736,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM': 64663,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM': 64512,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM': 64665,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM': 64614,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM': 64666,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM': 64514,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM': 64735,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM': 64615,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM': 64499,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM': 64498,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM': 64612,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM': 64497,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM': 64496,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM': 64495,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM': 64494,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM': 64617,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM': 64516,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM': 64501,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM': 64500,
'ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM': 64613,
'ARABIC LIGATURE YEH WITH HEH INITIAL FORM': 64734,
'ARABIC LIGATURE YEH WITH HEH MEDIAL FORM': 64753,
'ARABIC LIGATURE YEH WITH JEEM INITIAL FORM': 64730,
'ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM': 64597,
'ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM': 64943,
'ARABIC LIGATURE YEH WITH KHAH INITIAL FORM': 64732,
'ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM': 64599,
'ARABIC LIGATURE YEH WITH MEEM FINAL FORM': 64659,
'ARABIC LIGATURE YEH WITH MEEM INITIAL FORM': 64733,
'ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM': 64600,
'ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM': 64752,
'ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM': 64924,
'ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM': 64925,
'ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM': 64944,
'ARABIC LIGATURE YEH WITH NOON FINAL FORM': 64660,
'ARABIC LIGATURE YEH WITH REH FINAL FORM': 64657,
'ARABIC LIGATURE YEH WITH YEH FINAL FORM': 64662,
'ARABIC LIGATURE YEH WITH YEH ISOLATED FORM': 64602,
'ARABIC LIGATURE YEH WITH ZAIN FINAL FORM': 64658,
'ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM': 64697,
'ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM': 64552,
'ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM': 64827,
'ARABIC MADDAH ABOVE': 1619,
'ARABIC PERCENT SIGN': 1642,
'ARABIC PLACE OF SAJDAH': 1769,
'ARABIC QUESTION MARK': 1567,
'ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE': 1772,
'ARABIC SEMICOLON': 1563,
'ARABIC SHADDA': 1617,
'ARABIC SHADDA ISOLATED FORM': 65148,
'ARABIC SHADDA MEDIAL FORM': 65149,
'ARABIC SIGN SINDHI AMPERSAND': 1789,
'ARABIC SIGN SINDHI POSTPOSITION MEN': 1790,
'ARABIC SMALL HIGH DOTLESS HEAD OF KHAH': 1761,
'ARABIC SMALL HIGH JEEM': 1754,
'ARABIC SMALL HIGH LAM ALEF': 1753,
'ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA': 1751,
'ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA': 1750,
'ARABIC SMALL HIGH MADDA': 1764,
'ARABIC SMALL HIGH MEEM INITIAL FORM': 1752,
'ARABIC SMALL HIGH MEEM ISOLATED FORM': 1762,
'ARABIC SMALL HIGH NOON': 1768,
'ARABIC SMALL HIGH ROUNDED ZERO': 1759,
'ARABIC SMALL HIGH SEEN': 1756,
'ARABIC SMALL HIGH THREE DOTS': 1755,
'ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO': 1760,
'ARABIC SMALL HIGH YEH': 1767,
'ARABIC SMALL LOW MEEM': 1773,
'ARABIC SMALL LOW SEEN': 1763,
'ARABIC SMALL WAW': 1765,
'ARABIC SMALL YEH': 1766,
'ARABIC START OF RUB EL HIZB': 1758,
'ARABIC SUKUN': 1618,
'ARABIC SUKUN ISOLATED FORM': 65150,
'ARABIC SUKUN MEDIAL FORM': 65151,
'ARABIC TAIL FRAGMENT': 65139,
'ARABIC TATWEEL': 1600,
'ARABIC TATWEEL WITH FATHATAN ABOVE': 65137,
'ARABIC THOUSANDS SEPARATOR': 1644,
'ARABIC-INDIC DIGIT EIGHT': 1640,
'ARABIC-INDIC DIGIT FIVE': 1637,
'ARABIC-INDIC DIGIT FOUR': 1636,
'ARABIC-INDIC DIGIT NINE': 1641,
'ARABIC-INDIC DIGIT ONE': 1633,
'ARABIC-INDIC DIGIT SEVEN': 1639,
'ARABIC-INDIC DIGIT SIX': 1638,
'ARABIC-INDIC DIGIT THREE': 1635,
'ARABIC-INDIC DIGIT TWO': 1634,
'ARABIC-INDIC DIGIT ZERO': 1632,
'ARC': 8978,
'ARIES': 9800,
'ARMENIAN ABBREVIATION MARK': 1375,
'ARMENIAN APOSTROPHE': 1370,
'ARMENIAN CAPITAL LETTER AYB': 1329,
'ARMENIAN CAPITAL LETTER BEN': 1330,
'ARMENIAN CAPITAL LETTER CA': 1342,
'ARMENIAN CAPITAL LETTER CHA': 1353,
'ARMENIAN CAPITAL LETTER CHEH': 1347,
'ARMENIAN CAPITAL LETTER CO': 1361,
'ARMENIAN CAPITAL LETTER DA': 1332,
'ARMENIAN CAPITAL LETTER ECH': 1333,
'ARMENIAN CAPITAL LETTER EH': 1335,
'ARMENIAN CAPITAL LETTER ET': 1336,
'ARMENIAN CAPITAL LETTER FEH': 1366,
'ARMENIAN CAPITAL LETTER GHAD': 1346,
'ARMENIAN CAPITAL LETTER GIM': 1331,
'ARMENIAN CAPITAL LETTER HO': 1344,
'ARMENIAN CAPITAL LETTER INI': 1339,
'ARMENIAN CAPITAL LETTER JA': 1345,
'ARMENIAN CAPITAL LETTER JHEH': 1355,
'ARMENIAN CAPITAL LETTER KEH': 1364,
'ARMENIAN CAPITAL LETTER KEN': 1343,
'ARMENIAN CAPITAL LETTER LIWN': 1340,
'ARMENIAN CAPITAL LETTER MEN': 1348,
'ARMENIAN CAPITAL LETTER NOW': 1350,
'ARMENIAN CAPITAL LETTER OH': 1365,
'ARMENIAN CAPITAL LETTER PEH': 1354,
'ARMENIAN CAPITAL LETTER PIWR': 1363,
'ARMENIAN CAPITAL LETTER RA': 1356,
'ARMENIAN CAPITAL LETTER REH': 1360,
'ARMENIAN CAPITAL LETTER SEH': 1357,
'ARMENIAN CAPITAL LETTER SHA': 1351,
'ARMENIAN CAPITAL LETTER TIWN': 1359,
'ARMENIAN CAPITAL LETTER TO': 1337,
'ARMENIAN CAPITAL LETTER VEW': 1358,
'ARMENIAN CAPITAL LETTER VO': 1352,
'ARMENIAN CAPITAL LETTER XEH': 1341,
'ARMENIAN CAPITAL LETTER YI': 1349,
'ARMENIAN CAPITAL LETTER YIWN': 1362,
'ARMENIAN CAPITAL LETTER ZA': 1334,
'ARMENIAN CAPITAL LETTER ZHE': 1338,
'ARMENIAN COMMA': 1373,
'ARMENIAN EMPHASIS MARK': 1371,
'ARMENIAN EXCLAMATION MARK': 1372,
'ARMENIAN FULL STOP': 1417,
'ARMENIAN HYPHEN': 1418,
'ARMENIAN MODIFIER LETTER LEFT HALF RING': 1369,
'ARMENIAN QUESTION MARK': 1374,
'ARMENIAN SMALL LETTER AYB': 1377,
'ARMENIAN SMALL LETTER BEN': 1378,
'ARMENIAN SMALL LETTER CA': 1390,
'ARMENIAN SMALL LETTER CHA': 1401,
'ARMENIAN SMALL LETTER CHEH': 1395,
'ARMENIAN SMALL LETTER CO': 1409,
'ARMENIAN SMALL LETTER DA': 1380,
'ARMENIAN SMALL LETTER ECH': 1381,
'ARMENIAN SMALL LETTER EH': 1383,
'ARMENIAN SMALL LETTER ET': 1384,
'ARMENIAN SMALL LETTER FEH': 1414,
'ARMENIAN SMALL LETTER GHAD': 1394,
'ARMENIAN SMALL LETTER GIM': 1379,
'ARMENIAN SMALL LETTER HO': 1392,
'ARMENIAN SMALL LETTER INI': 1387,
'ARMENIAN SMALL LETTER JA': 1393,
'ARMENIAN SMALL LETTER JHEH': 1403,
'ARMENIAN SMALL LETTER KEH': 1412,
'ARMENIAN SMALL LETTER KEN': 1391,
'ARMENIAN SMALL LETTER LIWN': 1388,
'ARMENIAN SMALL LETTER MEN': 1396,
'ARMENIAN SMALL LETTER NOW': 1398,
'ARMENIAN SMALL LETTER OH': 1413,
'ARMENIAN SMALL LETTER PEH': 1402,
'ARMENIAN SMALL LETTER PIWR': 1411,
'ARMENIAN SMALL LETTER RA': 1404,
'ARMENIAN SMALL LETTER REH': 1408,
'ARMENIAN SMALL LETTER SEH': 1405,
'ARMENIAN SMALL LETTER SHA': 1399,
'ARMENIAN SMALL LETTER TIWN': 1407,
'ARMENIAN SMALL LETTER TO': 1385,
'ARMENIAN SMALL LETTER VEW': 1406,
'ARMENIAN SMALL LETTER VO': 1400,
'ARMENIAN SMALL LETTER XEH': 1389,
'ARMENIAN SMALL LETTER YI': 1397,
'ARMENIAN SMALL LETTER YIWN': 1410,
'ARMENIAN SMALL LETTER ZA': 1382,
'ARMENIAN SMALL LETTER ZHE': 1386,
'ARMENIAN SMALL LIGATURE ECH YIWN': 1415,
'ARMENIAN SMALL LIGATURE MEN ECH': 64276,
'ARMENIAN SMALL LIGATURE MEN INI': 64277,
'ARMENIAN SMALL LIGATURE MEN NOW': 64275,
'ARMENIAN SMALL LIGATURE MEN XEH': 64279,
'ARMENIAN SMALL LIGATURE VEW NOW': 64278,
'ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS': 10550,
'ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS': 10551,
'ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS': 10549,
'ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS': 10548,
'ASCENDING NODE': 9738,
'ASSERTION': 8870,
'ASTERISK': 42,
'ASTERISK OPERATOR': 8727,
'ASTERISM': 8258,
'ASYMPTOTICALLY EQUAL TO': 8771,
'BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW': 10155,
'BALLOON-SPOKED ASTERISK': 10057,
'BALLOT BOX': 9744,
'BALLOT BOX WITH CHECK': 9745,
'BALLOT BOX WITH X': 9746,
'BALLOT X': 10007,
'BEAMED EIGHTH NOTES': 9835,
'BEAMED SIXTEENTH NOTES': 9836,
'BECAUSE': 8757,
'BELL SYMBOL': 9086,
'BENGALI AU LENGTH MARK': 2519,
'BENGALI CURRENCY DENOMINATOR SIXTEEN': 2553,
'BENGALI CURRENCY NUMERATOR FOUR': 2551,
'BENGALI CURRENCY NUMERATOR ONE': 2548,
'BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR': 2552,
'BENGALI CURRENCY NUMERATOR THREE': 2550,
'BENGALI CURRENCY NUMERATOR TWO': 2549,
'BENGALI DIGIT EIGHT': 2542,
'BENGALI DIGIT FIVE': 2539,
'BENGALI DIGIT FOUR': 2538,
'BENGALI DIGIT NINE': 2543,
'BENGALI DIGIT ONE': 2535,
'BENGALI DIGIT SEVEN': 2541,
'BENGALI DIGIT SIX': 2540,
'BENGALI DIGIT THREE': 2537,
'BENGALI DIGIT TWO': 2536,
'BENGALI DIGIT ZERO': 2534,
'BENGALI ISSHAR': 2554,
'BENGALI LETTER A': 2437,
'BENGALI LETTER AA': 2438,
'BENGALI LETTER AI': 2448,
'BENGALI LETTER AU': 2452,
'BENGALI LETTER BA': 2476,
'BENGALI LETTER BHA': 2477,
'BENGALI LETTER CA': 2458,
'BENGALI LETTER CHA': 2459,
'BENGALI LETTER DA': 2470,
'BENGALI LETTER DDA': 2465,
'BENGALI LETTER DDHA': 2466,
'BENGALI LETTER DHA': 2471,
'BENGALI LETTER E': 2447,
'BENGALI LETTER GA': 2455,
'BENGALI LETTER GHA': 2456,
'BENGALI LETTER HA': 2489,
'BENGALI LETTER I': 2439,
'BENGALI LETTER II': 2440,
'BENGALI LETTER JA': 2460,
'BENGALI LETTER JHA': 2461,
'BENGALI LETTER KA': 2453,
'BENGALI LETTER KHA': 2454,
'BENGALI LETTER LA': 2482,
'BENGALI LETTER MA': 2478,
'BENGALI LETTER NA': 2472,
'BENGALI LETTER NGA': 2457,
'BENGALI LETTER NNA': 2467,
'BENGALI LETTER NYA': 2462,
'BENGALI LETTER O': 2451,
'BENGALI LETTER PA': 2474,
'BENGALI LETTER PHA': 2475,
'BENGALI LETTER RA': 2480,
'BENGALI LETTER RA WITH LOWER DIAGONAL': 2545,
'BENGALI LETTER RA WITH MIDDLE DIAGONAL': 2544,
'BENGALI LETTER RHA': 2525,
'BENGALI LETTER RRA': 2524,
'BENGALI LETTER SA': 2488,
'BENGALI LETTER SHA': 2486,
'BENGALI LETTER SSA': 2487,
'BENGALI LETTER TA': 2468,
'BENGALI LETTER THA': 2469,
'BENGALI LETTER TTA': 2463,
'BENGALI LETTER TTHA': 2464,
'BENGALI LETTER U': 2441,
'BENGALI LETTER UU': 2442,
'BENGALI LETTER VOCALIC L': 2444,
'BENGALI LETTER VOCALIC LL': 2529,
'BENGALI LETTER VOCALIC R': 2443,
'BENGALI LETTER VOCALIC RR': 2528,
'BENGALI LETTER YA': 2479,
'BENGALI LETTER YYA': 2527,
'BENGALI RUPEE MARK': 2546,
'BENGALI RUPEE SIGN': 2547,
'BENGALI SIGN ANUSVARA': 2434,
'BENGALI SIGN CANDRABINDU': 2433,
'BENGALI SIGN NUKTA': 2492,
'BENGALI SIGN VIRAMA': 2509,
'BENGALI SIGN VISARGA': 2435,
'BENGALI VOWEL SIGN AA': 2494,
'BENGALI VOWEL SIGN AI': 2504,
'BENGALI VOWEL SIGN AU': 2508,
'BENGALI VOWEL SIGN E': 2503,
'BENGALI VOWEL SIGN I': 2495,
'BENGALI VOWEL SIGN II': 2496,
'BENGALI VOWEL SIGN O': 2507,
'BENGALI VOWEL SIGN U': 2497,
'BENGALI VOWEL SIGN UU': 2498,
'BENGALI VOWEL SIGN VOCALIC L': 2530,
'BENGALI VOWEL SIGN VOCALIC LL': 2531,
'BENGALI VOWEL SIGN VOCALIC R': 2499,
'BENGALI VOWEL SIGN VOCALIC RR': 2500,
'BENZENE RING': 9004,
'BET SYMBOL': 8502,
'BETWEEN': 8812,
'BIG REVERSE SOLIDUS': 10745,
'BIG SOLIDUS': 10744,
'BIOHAZARD SIGN': 9763,
'BLACK BOWTIE': 10707,
'BLACK CENTRE WHITE STAR': 10028,
'BLACK CHESS BISHOP': 9821,
'BLACK CHESS KING': 9818,
'BLACK CHESS KNIGHT': 9822,
'BLACK CHESS PAWN': 9823,
'BLACK CHESS QUEEN': 9819,
'BLACK CHESS ROOK': 9820,
'BLACK CIRCLE': 9679,
'BLACK CIRCLE WITH DOWN ARROW': 10733,
'BLACK CIRCLE WITH TWO WHITE DOTS': 9865,
'BLACK CIRCLE WITH WHITE DOT RIGHT': 9864,
'BLACK CLUB SUIT': 9827,
'BLACK DIAMOND': 9670,
'BLACK DIAMOND MINUS WHITE X': 10070,
'BLACK DIAMOND SUIT': 9830,
'BLACK DIAMOND WITH DOWN ARROW': 10730,
'BLACK DOWN-POINTING SMALL TRIANGLE': 9662,
'BLACK DOWN-POINTING TRIANGLE': 9660,
'BLACK FLORETTE': 10047,
'BLACK FOUR POINTED STAR': 10022,
'BLACK HEART SUIT': 9829,
'BLACK HOURGLASS': 10711,
'BLACK LEFT POINTING INDEX': 9754,
'BLACK LEFT-POINTING POINTER': 9668,
'BLACK LEFT-POINTING SMALL TRIANGLE': 9666,
'BLACK LEFT-POINTING TRIANGLE': 9664,
'BLACK LEFTWARDS BULLET': 8268,
'BLACK LOWER LEFT TRIANGLE': 9699,
'BLACK LOWER RIGHT TRIANGLE': 9698,
'BLACK LOZENGE': 10731,
'BLACK MEDIUM SMALL SQUARE': 9726,
'BLACK MEDIUM SQUARE': 9724,
'BLACK NIB': 10002,
'BLACK PARALLELOGRAM': 9648,
'BLACK RECTANGLE': 9644,
'BLACK RIGHT POINTING INDEX': 9755,
'BLACK RIGHT-POINTING POINTER': 9658,
'BLACK RIGHT-POINTING SMALL TRIANGLE': 9656,
'BLACK RIGHT-POINTING TRIANGLE': 9654,
'BLACK RIGHTWARDS ARROW': 10145,
'BLACK RIGHTWARDS ARROWHEAD': 10148,
'BLACK RIGHTWARDS BULLET': 8269,
'BLACK SCISSORS': 9986,
'BLACK SHOGI PIECE': 9751,
'BLACK SMALL SQUARE': 9642,
'BLACK SMILING FACE': 9787,
'BLACK SPADE SUIT': 9824,
'BLACK SQUARE': 9632,
'BLACK STAR': 9733,
'BLACK SUN WITH RAYS': 9728,
'BLACK TELEPHONE': 9742,
'BLACK UNIVERSAL RECYCLING SYMBOL': 9851,
'BLACK UP-POINTING SMALL TRIANGLE': 9652,
'BLACK UP-POINTING TRIANGLE': 9650,
'BLACK UPPER LEFT TRIANGLE': 9700,
'BLACK UPPER RIGHT TRIANGLE': 9701,
'BLACK VERTICAL RECTANGLE': 9646,
'BLACK-FEATHERED NORTH EAST ARROW': 10166,
'BLACK-FEATHERED RIGHTWARDS ARROW': 10165,
'BLACK-FEATHERED SOUTH EAST ARROW': 10164,
'BLACK-LETTER CAPITAL C': 8493,
'BLACK-LETTER CAPITAL H': 8460,
'BLACK-LETTER CAPITAL I': 8465,
'BLACK-LETTER CAPITAL R': 8476,
'BLACK-LETTER CAPITAL Z': 8488,
'BLANK SYMBOL': 9250,
'BOPOMOFO FINAL LETTER H': 12727,
'BOPOMOFO FINAL LETTER K': 12726,
'BOPOMOFO FINAL LETTER P': 12724,
'BOPOMOFO FINAL LETTER T': 12725,
'BOPOMOFO LETTER A': 12570,
'BOPOMOFO LETTER AI': 12574,
'BOPOMOFO LETTER AINN': 12718,
'BOPOMOFO LETTER AM': 12720,
'BOPOMOFO LETTER AN': 12578,
'BOPOMOFO LETTER ANG': 12580,
'BOPOMOFO LETTER ANN': 12713,
'BOPOMOFO LETTER AU': 12576,
'BOPOMOFO LETTER AUNN': 12719,
'BOPOMOFO LETTER B': 12549,
'BOPOMOFO LETTER BU': 12704,
'BOPOMOFO LETTER C': 12568,
'BOPOMOFO LETTER CH': 12564,
'BOPOMOFO LETTER D': 12553,
'BOPOMOFO LETTER E': 12572,
'BOPOMOFO LETTER EE': 12708,
'BOPOMOFO LETTER EH': 12573,
'BOPOMOFO LETTER EI': 12575,
'BOPOMOFO LETTER EN': 12579,
'BOPOMOFO LETTER ENG': 12581,
'BOPOMOFO LETTER ENN': 12709,
'BOPOMOFO LETTER ER': 12582,
'BOPOMOFO LETTER F': 12552,
'BOPOMOFO LETTER G': 12557,
'BOPOMOFO LETTER GN': 12588,
'BOPOMOFO LETTER GU': 12707,
'BOPOMOFO LETTER H': 12559,
'BOPOMOFO LETTER I': 12583,
'BOPOMOFO LETTER IM': 12716,
'BOPOMOFO LETTER INN': 12714,
'BOPOMOFO LETTER INNN': 12723,
'BOPOMOFO LETTER IR': 12712,
'BOPOMOFO LETTER IU': 12585,
'BOPOMOFO LETTER J': 12560,
'BOPOMOFO LETTER JI': 12706,
'BOPOMOFO LETTER K': 12558,
'BOPOMOFO LETTER L': 12556,
'BOPOMOFO LETTER M': 12551,
'BOPOMOFO LETTER N': 12555,
'BOPOMOFO LETTER NG': 12587,
'BOPOMOFO LETTER NGG': 12717,
'BOPOMOFO LETTER O': 12571,
'BOPOMOFO LETTER OM': 12721,
'BOPOMOFO LETTER ONG': 12722,
'BOPOMOFO LETTER ONN': 12711,
'BOPOMOFO LETTER OO': 12710,
'BOPOMOFO LETTER OU': 12577,
'BOPOMOFO LETTER P': 12550,
'BOPOMOFO LETTER Q': 12561,
'BOPOMOFO LETTER R': 12566,
'BOPOMOFO LETTER S': 12569,
'BOPOMOFO LETTER SH': 12565,
'BOPOMOFO LETTER T': 12554,
'BOPOMOFO LETTER U': 12584,
'BOPOMOFO LETTER UNN': 12715,
'BOPOMOFO LETTER V': 12586,
'BOPOMOFO LETTER X': 12562,
'BOPOMOFO LETTER Z': 12567,
'BOPOMOFO LETTER ZH': 12563,
'BOPOMOFO LETTER ZI': 12705,
'BOTTOM ARC ANTICLOCKWISE ARROW': 10555,
'BOTTOM HALF INTEGRAL': 8993,
'BOTTOM LEFT CORNER': 8990,
'BOTTOM LEFT CROP': 8973,
'BOTTOM RIGHT CORNER': 8991,
'BOTTOM RIGHT CROP': 8972,
'BOTTOM SQUARE BRACKET': 9141,
'BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET': 9142,
'BOWTIE': 8904,
'BOWTIE WITH LEFT HALF BLACK': 10705,
'BOWTIE WITH RIGHT HALF BLACK': 10706,
'BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL': 9574,
'BOX DRAWINGS DOUBLE DOWN AND LEFT': 9559,
'BOX DRAWINGS DOUBLE DOWN AND RIGHT': 9556,
'BOX DRAWINGS DOUBLE HORIZONTAL': 9552,
'BOX DRAWINGS DOUBLE UP AND HORIZONTAL': 9577,
'BOX DRAWINGS DOUBLE UP AND LEFT': 9565,
'BOX DRAWINGS DOUBLE UP AND RIGHT': 9562,
'BOX DRAWINGS DOUBLE VERTICAL': 9553,
'BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL': 9580,
'BOX DRAWINGS DOUBLE VERTICAL AND LEFT': 9571,
'BOX DRAWINGS DOUBLE VERTICAL AND RIGHT': 9568,
'BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE': 9573,
'BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE': 9558,
'BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE': 9555,
'BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT': 9520,
'BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT': 9490,
'BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT': 9511,
'BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT': 9486,
'BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT': 9503,
'BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT': 9537,
'BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY': 9519,
'BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY': 9489,
'BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY': 9513,
'BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY': 9485,
'BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY': 9505,
'BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY': 9543,
'BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE': 9572,
'BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE': 9557,
'BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE': 9554,
'BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL': 9549,
'BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL': 9551,
'BOX DRAWINGS HEAVY DOWN': 9595,
'BOX DRAWINGS HEAVY DOWN AND HORIZONTAL': 9523,
'BOX DRAWINGS HEAVY DOWN AND LEFT': 9491,
'BOX DRAWINGS HEAVY DOWN AND RIGHT': 9487,
'BOX DRAWINGS HEAVY HORIZONTAL': 9473,
'BOX DRAWINGS HEAVY LEFT': 9592,
'BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT': 9598,
'BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL': 9481,
'BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL': 9483,
'BOX DRAWINGS HEAVY RIGHT': 9594,
'BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL': 9477,
'BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL': 9479,
'BOX DRAWINGS HEAVY UP': 9593,
'BOX DRAWINGS HEAVY UP AND HORIZONTAL': 9531,
'BOX DRAWINGS HEAVY UP AND LEFT': 9499,
'BOX DRAWINGS HEAVY UP AND LIGHT DOWN': 9599,
'BOX DRAWINGS HEAVY UP AND RIGHT': 9495,
'BOX DRAWINGS HEAVY VERTICAL': 9475,
'BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL': 9547,
'BOX DRAWINGS HEAVY VERTICAL AND LEFT': 9515,
'BOX DRAWINGS HEAVY VERTICAL AND RIGHT': 9507,
'BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT': 9541,
'BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT': 9517,
'BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT': 9525,
'BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT': 9533,
'BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY': 9522,
'BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY': 9530,
'BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY': 9546,
'BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT': 9539,
'BOX DRAWINGS LIGHT ARC DOWN AND LEFT': 9582,
'BOX DRAWINGS LIGHT ARC DOWN AND RIGHT': 9581,
'BOX DRAWINGS LIGHT ARC UP AND LEFT': 9583,
'BOX DRAWINGS LIGHT ARC UP AND RIGHT': 9584,
'BOX DRAWINGS LIGHT DIAGONAL CROSS': 9587,
'BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT': 9586,
'BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT': 9585,
'BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL': 9548,
'BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL': 9550,
'BOX DRAWINGS LIGHT DOWN': 9591,
'BOX DRAWINGS LIGHT DOWN AND HORIZONTAL': 9516,
'BOX DRAWINGS LIGHT DOWN AND LEFT': 9488,
'BOX DRAWINGS LIGHT DOWN AND RIGHT': 9484,
'BOX DRAWINGS LIGHT HORIZONTAL': 9472,
'BOX DRAWINGS LIGHT LEFT': 9588,
'BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT': 9596,
'BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL': 9480,
'BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL': 9482,
'BOX DRAWINGS LIGHT RIGHT': 9590,
'BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL': 9476,
'BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL': 9478,
'BOX DRAWINGS LIGHT UP': 9589,
'BOX DRAWINGS LIGHT UP AND HEAVY DOWN': 9597,
'BOX DRAWINGS LIGHT UP AND HORIZONTAL': 9524,
'BOX DRAWINGS LIGHT UP AND LEFT': 9496,
'BOX DRAWINGS LIGHT UP AND RIGHT': 9492,
'BOX DRAWINGS LIGHT VERTICAL': 9474,
'BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL': 9532,
'BOX DRAWINGS LIGHT VERTICAL AND LEFT': 9508,
'BOX DRAWINGS LIGHT VERTICAL AND RIGHT': 9500,
'BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT': 9542,
'BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT': 9518,
'BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT': 9526,
'BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT': 9534,
'BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY': 9521,
'BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY': 9529,
'BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY': 9545,
'BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT': 9540,
'BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE': 9576,
'BOX DRAWINGS UP DOUBLE AND LEFT SINGLE': 9564,
'BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE': 9561,
'BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT': 9536,
'BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT': 9528,
'BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT': 9510,
'BOX DRAWINGS UP HEAVY AND LEFT LIGHT': 9498,
'BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT': 9502,
'BOX DRAWINGS UP HEAVY AND RIGHT LIGHT': 9494,
'BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY': 9544,
'BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY': 9527,
'BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY': 9514,
'BOX DRAWINGS UP LIGHT AND LEFT HEAVY': 9497,
'BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY': 9506,
'BOX DRAWINGS UP LIGHT AND RIGHT HEAVY': 9493,
'BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE': 9575,
'BOX DRAWINGS UP SINGLE AND LEFT DOUBLE': 9563,
'BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE': 9560,
'BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE': 9579,
'BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE': 9570,
'BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE': 9567,
'BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT': 9538,
'BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT': 9512,
'BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT': 9504,
'BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY': 9535,
'BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY': 9509,
'BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY': 9501,
'BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE': 9578,
'BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE': 9569,
'BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE': 9566,
'BRAILLE PATTERN BLANK': 10240,
'BRAILLE PATTERN DOTS-1': 10241,
'BRAILLE PATTERN DOTS-12': 10243,
'BRAILLE PATTERN DOTS-123': 10247,
'BRAILLE PATTERN DOTS-1234': 10255,
'BRAILLE PATTERN DOTS-12345': 10271,
'BRAILLE PATTERN DOTS-123456': 10303,
'BRAILLE PATTERN DOTS-1234567': 10367,
'BRAILLE PATTERN DOTS-12345678': 10495,
'BRAILLE PATTERN DOTS-1234568': 10431,
'BRAILLE PATTERN DOTS-123457': 10335,
'BRAILLE PATTERN DOTS-1234578': 10463,
'BRAILLE PATTERN DOTS-123458': 10399,
'BRAILLE PATTERN DOTS-12346': 10287,
'BRAILLE PATTERN DOTS-123467': 10351,
'BRAILLE PATTERN DOTS-1234678': 10479,
'BRAILLE PATTERN DOTS-123468': 10415,
'BRAILLE PATTERN DOTS-12347': 10319,
'BRAILLE PATTERN DOTS-123478': 10447,
'BRAILLE PATTERN DOTS-12348': 10383,
'BRAILLE PATTERN DOTS-1235': 10263,
'BRAILLE PATTERN DOTS-12356': 10295,
'BRAILLE PATTERN DOTS-123567': 10359,
'BRAILLE PATTERN DOTS-1235678': 10487,
'BRAILLE PATTERN DOTS-123568': 10423,
'BRAILLE PATTERN DOTS-12357': 10327,
'BRAILLE PATTERN DOTS-123578': 10455,
'BRAILLE PATTERN DOTS-12358': 10391,
'BRAILLE PATTERN DOTS-1236': 10279,
'BRAILLE PATTERN DOTS-12367': 10343,
'BRAILLE PATTERN DOTS-123678': 10471,
'BRAILLE PATTERN DOTS-12368': 10407,
'BRAILLE PATTERN DOTS-1237': 10311,
'BRAILLE PATTERN DOTS-12378': 10439,
'BRAILLE PATTERN DOTS-1238': 10375,
'BRAILLE PATTERN DOTS-124': 10251,
'BRAILLE PATTERN DOTS-1245': 10267,
'BRAILLE PATTERN DOTS-12456': 10299,
'BRAILLE PATTERN DOTS-124567': 10363,
'BRAILLE PATTERN DOTS-1245678': 10491,
'BRAILLE PATTERN DOTS-124568': 10427,
'BRAILLE PATTERN DOTS-12457': 10331,
'BRAILLE PATTERN DOTS-124578': 10459,
'BRAILLE PATTERN DOTS-12458': 10395,
'BRAILLE PATTERN DOTS-1246': 10283,
'BRAILLE PATTERN DOTS-12467': 10347,
'BRAILLE PATTERN DOTS-124678': 10475,
'BRAILLE PATTERN DOTS-12468': 10411,
'BRAILLE PATTERN DOTS-1247': 10315,
'BRAILLE PATTERN DOTS-12478': 10443,
'BRAILLE PATTERN DOTS-1248': 10379,
'BRAILLE PATTERN DOTS-125': 10259,
'BRAILLE PATTERN DOTS-1256': 10291,
'BRAILLE PATTERN DOTS-12567': 10355,
'BRAILLE PATTERN DOTS-125678': 10483,
'BRAILLE PATTERN DOTS-12568': 10419,
'BRAILLE PATTERN DOTS-1257': 10323,
'BRAILLE PATTERN DOTS-12578': 10451,
'BRAILLE PATTERN DOTS-1258': 10387,
'BRAILLE PATTERN DOTS-126': 10275,
'BRAILLE PATTERN DOTS-1267': 10339,
'BRAILLE PATTERN DOTS-12678': 10467,
'BRAILLE PATTERN DOTS-1268': 10403,
'BRAILLE PATTERN DOTS-127': 10307,
'BRAILLE PATTERN DOTS-1278': 10435,
'BRAILLE PATTERN DOTS-128': 10371,
'BRAILLE PATTERN DOTS-13': 10245,
'BRAILLE PATTERN DOTS-134': 10253,
'BRAILLE PATTERN DOTS-1345': 10269,
'BRAILLE PATTERN DOTS-13456': 10301,
'BRAILLE PATTERN DOTS-134567': 10365,
'BRAILLE PATTERN DOTS-1345678': 10493,
'BRAILLE PATTERN DOTS-134568': 10429,
'BRAILLE PATTERN DOTS-13457': 10333,
'BRAILLE PATTERN DOTS-134578': 10461,
'BRAILLE PATTERN DOTS-13458': 10397,
'BRAILLE PATTERN DOTS-1346': 10285,
'BRAILLE PATTERN DOTS-13467': 10349,
'BRAILLE PATTERN DOTS-134678': 10477,
'BRAILLE PATTERN DOTS-13468': 10413,
'BRAILLE PATTERN DOTS-1347': 10317,
'BRAILLE PATTERN DOTS-13478': 10445,
'BRAILLE PATTERN DOTS-1348': 10381,
'BRAILLE PATTERN DOTS-135': 10261,
'BRAILLE PATTERN DOTS-1356': 10293,
'BRAILLE PATTERN DOTS-13567': 10357,
'BRAILLE PATTERN DOTS-135678': 10485,
'BRAILLE PATTERN DOTS-13568': 10421,
'BRAILLE PATTERN DOTS-1357': 10325,
'BRAILLE PATTERN DOTS-13578': 10453,
'BRAILLE PATTERN DOTS-1358': 10389,
'BRAILLE PATTERN DOTS-136': 10277,
'BRAILLE PATTERN DOTS-1367': 10341,
'BRAILLE PATTERN DOTS-13678': 10469,
'BRAILLE PATTERN DOTS-1368': 10405,
'BRAILLE PATTERN DOTS-137': 10309,
'BRAILLE PATTERN DOTS-1378': 10437,
'BRAILLE PATTERN DOTS-138': 10373,
'BRAILLE PATTERN DOTS-14': 10249,
'BRAILLE PATTERN DOTS-145': 10265,
'BRAILLE PATTERN DOTS-1456': 10297,
'BRAILLE PATTERN DOTS-14567': 10361,
'BRAILLE PATTERN DOTS-145678': 10489,
'BRAILLE PATTERN DOTS-14568': 10425,
'BRAILLE PATTERN DOTS-1457': 10329,
'BRAILLE PATTERN DOTS-14578': 10457,
'BRAILLE PATTERN DOTS-1458': 10393,
'BRAILLE PATTERN DOTS-146': 10281,
'BRAILLE PATTERN DOTS-1467': 10345,
'BRAILLE PATTERN DOTS-14678': 10473,
'BRAILLE PATTERN DOTS-1468': 10409,
'BRAILLE PATTERN DOTS-147': 10313,
'BRAILLE PATTERN DOTS-1478': 10441,
'BRAILLE PATTERN DOTS-148': 10377,
'BRAILLE PATTERN DOTS-15': 10257,
'BRAILLE PATTERN DOTS-156': 10289,
'BRAILLE PATTERN DOTS-1567': 10353,
'BRAILLE PATTERN DOTS-15678': 10481,
'BRAILLE PATTERN DOTS-1568': 10417,
'BRAILLE PATTERN DOTS-157': 10321,
'BRAILLE PATTERN DOTS-1578': 10449,
'BRAILLE PATTERN DOTS-158': 10385,
'BRAILLE PATTERN DOTS-16': 10273,
'BRAILLE PATTERN DOTS-167': 10337,
'BRAILLE PATTERN DOTS-1678': 10465,
'BRAILLE PATTERN DOTS-168': 10401,
'BRAILLE PATTERN DOTS-17': 10305,
'BRAILLE PATTERN DOTS-178': 10433,
'BRAILLE PATTERN DOTS-18': 10369,
'BRAILLE PATTERN DOTS-2': 10242,
'BRAILLE PATTERN DOTS-23': 10246,
'BRAILLE PATTERN DOTS-234': 10254,
'BRAILLE PATTERN DOTS-2345': 10270,
'BRAILLE PATTERN DOTS-23456': 10302,
'BRAILLE PATTERN DOTS-234567': 10366,
'BRAILLE PATTERN DOTS-2345678': 10494,
'BRAILLE PATTERN DOTS-234568': 10430,
'BRAILLE PATTERN DOTS-23457': 10334,
'BRAILLE PATTERN DOTS-234578': 10462,
'BRAILLE PATTERN DOTS-23458': 10398,
'BRAILLE PATTERN DOTS-2346': 10286,
'BRAILLE PATTERN DOTS-23467': 10350,
'BRAILLE PATTERN DOTS-234678': 10478,
'BRAILLE PATTERN DOTS-23468': 10414,
'BRAILLE PATTERN DOTS-2347': 10318,
'BRAILLE PATTERN DOTS-23478': 10446,
'BRAILLE PATTERN DOTS-2348': 10382,
'BRAILLE PATTERN DOTS-235': 10262,
'BRAILLE PATTERN DOTS-2356': 10294,
'BRAILLE PATTERN DOTS-23567': 10358,
'BRAILLE PATTERN DOTS-235678': 10486,
'BRAILLE PATTERN DOTS-23568': 10422,
'BRAILLE PATTERN DOTS-2357': 10326,
'BRAILLE PATTERN DOTS-23578': 10454,
'BRAILLE PATTERN DOTS-2358': 10390,
'BRAILLE PATTERN DOTS-236': 10278,
'BRAILLE PATTERN DOTS-2367': 10342,
'BRAILLE PATTERN DOTS-23678': 10470,
'BRAILLE PATTERN DOTS-2368': 10406,
'BRAILLE PATTERN DOTS-237': 10310,
'BRAILLE PATTERN DOTS-2378': 10438,
'BRAILLE PATTERN DOTS-238': 10374,
'BRAILLE PATTERN DOTS-24': 10250,
'BRAILLE PATTERN DOTS-245': 10266,
'BRAILLE PATTERN DOTS-2456': 10298,
'BRAILLE PATTERN DOTS-24567': 10362,
'BRAILLE PATTERN DOTS-245678': 10490,
'BRAILLE PATTERN DOTS-24568': 10426,
'BRAILLE PATTERN DOTS-2457': 10330,
'BRAILLE PATTERN DOTS-24578': 10458,
'BRAILLE PATTERN DOTS-2458': 10394,
'BRAILLE PATTERN DOTS-246': 10282,
'BRAILLE PATTERN DOTS-2467': 10346,
'BRAILLE PATTERN DOTS-24678': 10474,
'BRAILLE PATTERN DOTS-2468': 10410,
'BRAILLE PATTERN DOTS-247': 10314,
'BRAILLE PATTERN DOTS-2478': 10442,
'BRAILLE PATTERN DOTS-248': 10378,
'BRAILLE PATTERN DOTS-25': 10258,
'BRAILLE PATTERN DOTS-256': 10290,
'BRAILLE PATTERN DOTS-2567': 10354,
'BRAILLE PATTERN DOTS-25678': 10482,
'BRAILLE PATTERN DOTS-2568': 10418,
'BRAILLE PATTERN DOTS-257': 10322,
'BRAILLE PATTERN DOTS-2578': 10450,
'BRAILLE PATTERN DOTS-258': 10386,
'BRAILLE PATTERN DOTS-26': 10274,
'BRAILLE PATTERN DOTS-267': 10338,
'BRAILLE PATTERN DOTS-2678': 10466,
'BRAILLE PATTERN DOTS-268': 10402,
'BRAILLE PATTERN DOTS-27': 10306,
'BRAILLE PATTERN DOTS-278': 10434,
'BRAILLE PATTERN DOTS-28': 10370,
'BRAILLE PATTERN DOTS-3': 10244,
'BRAILLE PATTERN DOTS-34': 10252,
'BRAILLE PATTERN DOTS-345': 10268,
'BRAILLE PATTERN DOTS-3456': 10300,
'BRAILLE PATTERN DOTS-34567': 10364,
'BRAILLE PATTERN DOTS-345678': 10492,
'BRAILLE PATTERN DOTS-34568': 10428,
'BRAILLE PATTERN DOTS-3457': 10332,
'BRAILLE PATTERN DOTS-34578': 10460,
'BRAILLE PATTERN DOTS-3458': 10396,
'BRAILLE PATTERN DOTS-346': 10284,
'BRAILLE PATTERN DOTS-3467': 10348,
'BRAILLE PATTERN DOTS-34678': 10476,
'BRAILLE PATTERN DOTS-3468': 10412,
'BRAILLE PATTERN DOTS-347': 10316,
'BRAILLE PATTERN DOTS-3478': 10444,
'BRAILLE PATTERN DOTS-348': 10380,
'BRAILLE PATTERN DOTS-35': 10260,
'BRAILLE PATTERN DOTS-356': 10292,
'BRAILLE PATTERN DOTS-3567': 10356,
'BRAILLE PATTERN DOTS-35678': 10484,
'BRAILLE PATTERN DOTS-3568': 10420,
'BRAILLE PATTERN DOTS-357': 10324,
'BRAILLE PATTERN DOTS-3578': 10452,
'BRAILLE PATTERN DOTS-358': 10388,
'BRAILLE PATTERN DOTS-36': 10276,
'BRAILLE PATTERN DOTS-367': 10340,
'BRAILLE PATTERN DOTS-3678': 10468,
'BRAILLE PATTERN DOTS-368': 10404,
'BRAILLE PATTERN DOTS-37': 10308,
'BRAILLE PATTERN DOTS-378': 10436,
'BRAILLE PATTERN DOTS-38': 10372,
'BRAILLE PATTERN DOTS-4': 10248,
'BRAILLE PATTERN DOTS-45': 10264,
'BRAILLE PATTERN DOTS-456': 10296,
'BRAILLE PATTERN DOTS-4567': 10360,
'BRAILLE PATTERN DOTS-45678': 10488,
'BRAILLE PATTERN DOTS-4568': 10424,
'BRAILLE PATTERN DOTS-457': 10328,
'BRAILLE PATTERN DOTS-4578': 10456,
'BRAILLE PATTERN DOTS-458': 10392,
'BRAILLE PATTERN DOTS-46': 10280,
'BRAILLE PATTERN DOTS-467': 10344,
'BRAILLE PATTERN DOTS-4678': 10472,
'BRAILLE PATTERN DOTS-468': 10408,
'BRAILLE PATTERN DOTS-47': 10312,
'BRAILLE PATTERN DOTS-478': 10440,
'BRAILLE PATTERN DOTS-48': 10376,
'BRAILLE PATTERN DOTS-5': 10256,
'BRAILLE PATTERN DOTS-56': 10288,
'BRAILLE PATTERN DOTS-567': 10352,
'BRAILLE PATTERN DOTS-5678': 10480,
'BRAILLE PATTERN DOTS-568': 10416,
'BRAILLE PATTERN DOTS-57': 10320,
'BRAILLE PATTERN DOTS-578': 10448,
'BRAILLE PATTERN DOTS-58': 10384,
'BRAILLE PATTERN DOTS-6': 10272,
'BRAILLE PATTERN DOTS-67': 10336,
'BRAILLE PATTERN DOTS-678': 10464,
'BRAILLE PATTERN DOTS-68': 10400,
'BRAILLE PATTERN DOTS-7': 10304,
'BRAILLE PATTERN DOTS-78': 10432,
'BRAILLE PATTERN DOTS-8': 10368,
'BREVE': 728,
'BROKEN BAR': 166,
'BROKEN CIRCLE WITH NORTHWEST ARROW': 9099,
'BUHID LETTER A': 5952,
'BUHID LETTER BA': 5962,
'BUHID LETTER DA': 5959,
'BUHID LETTER GA': 5956,
'BUHID LETTER HA': 5969,
'BUHID LETTER I': 5953,
'BUHID LETTER KA': 5955,
'BUHID LETTER LA': 5966,
'BUHID LETTER MA': 5963,
'BUHID LETTER NA': 5960,
'BUHID LETTER NGA': 5957,
'BUHID LETTER PA': 5961,
'BUHID LETTER RA': 5965,
'BUHID LETTER SA': 5968,
'BUHID LETTER TA': 5958,
'BUHID LETTER U': 5954,
'BUHID LETTER WA': 5967,
'BUHID LETTER YA': 5964,
'BUHID VOWEL SIGN I': 5970,
'BUHID VOWEL SIGN U': 5971,
'BULLET': 8226,
'BULLET OPERATOR': 8729,
'BULLSEYE': 9678,
'BYZANTINE MUSICAL SYMBOL AGOGI ARGI': 118940,
'BYZANTINE MUSICAL SYMBOL AGOGI ARGOTERI': 118939,
'BYZANTINE MUSICAL SYMBOL AGOGI GORGI': 118943,
'BYZANTINE MUSICAL SYMBOL AGOGI GORGOTERI': 118944,
'BYZANTINE MUSICAL SYMBOL AGOGI MESI': 118942,
'BYZANTINE MUSICAL SYMBOL AGOGI METRIA': 118941,
'BYZANTINE MUSICAL SYMBOL AGOGI POLI ARGI': 118938,
'BYZANTINE MUSICAL SYMBOL AGOGI POLI GORGI': 118945,
'BYZANTINE MUSICAL SYMBOL ANATRICHISMA': 118824,
'BYZANTINE MUSICAL SYMBOL ANTIKENOKYLISMA': 118882,
'BYZANTINE MUSICAL SYMBOL ANTIKENOMA': 118876,
'BYZANTINE MUSICAL SYMBOL APESO EKFONITIKON': 118797,
'BYZANTINE MUSICAL SYMBOL APESO EXO NEO': 118835,
'BYZANTINE MUSICAL SYMBOL APLI': 118917,
'BYZANTINE MUSICAL SYMBOL APODERMA ARCHAION': 118818,
'BYZANTINE MUSICAL SYMBOL APODERMA NEO': 118916,
'BYZANTINE MUSICAL SYMBOL APOSTROFOI SYNDESMOS NEO': 118866,
'BYZANTINE MUSICAL SYMBOL APOSTROFOI TELOUS ICHIMATOS': 118957,
'BYZANTINE MUSICAL SYMBOL APOSTROFOS': 118801,
'BYZANTINE MUSICAL SYMBOL APOSTROFOS DIPLI': 118802,
'BYZANTINE MUSICAL SYMBOL APOSTROFOS NEO': 118865,
'BYZANTINE MUSICAL SYMBOL APOTHEMA': 118819,
'BYZANTINE MUSICAL SYMBOL ARGON': 118935,
'BYZANTINE MUSICAL SYMBOL ARGOSYNTHETON': 118899,
'BYZANTINE MUSICAL SYMBOL ARKTIKO DI': 119020,
'BYZANTINE MUSICAL SYMBOL ARKTIKO GA': 119019,
'BYZANTINE MUSICAL SYMBOL ARKTIKO KE': 119021,
'BYZANTINE MUSICAL SYMBOL ARKTIKO NI': 119023,
'BYZANTINE MUSICAL SYMBOL ARKTIKO PA': 119017,
'BYZANTINE MUSICAL SYMBOL ARKTIKO VOU': 119018,
'BYZANTINE MUSICAL SYMBOL ARKTIKO ZO': 119022,
'BYZANTINE MUSICAL SYMBOL CHAMILI': 118870,
'BYZANTINE MUSICAL SYMBOL CHAMILON': 118808,
'BYZANTINE MUSICAL SYMBOL CHOREVMA ARCHAION': 118843,
'BYZANTINE MUSICAL SYMBOL CHOREVMA NEO': 118887,
'BYZANTINE MUSICAL SYMBOL CHROA KLITON': 118985,
'BYZANTINE MUSICAL SYMBOL CHROA SPATHI': 118986,
'BYZANTINE MUSICAL SYMBOL CHROA ZYGOS': 118984,
'BYZANTINE MUSICAL SYMBOL DASEIA': 118785,
'BYZANTINE MUSICAL SYMBOL DIARGON': 118937,
'BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MEGALI': 119003,
'BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MIKRI': 119002,
'BYZANTINE MUSICAL SYMBOL DIASTOLI DIPLI': 119004,
'BYZANTINE MUSICAL SYMBOL DIASTOLI THESEOS': 119005,
'BYZANTINE MUSICAL SYMBOL DIESIS APLI DYO DODEKATA': 118992,
'BYZANTINE MUSICAL SYMBOL DIESIS DIGRAMMOS EX DODEKATA': 118994,
'BYZANTINE MUSICAL SYMBOL DIESIS MONOGRAMMOS TESSERA DODEKATA': 118993,
'BYZANTINE MUSICAL SYMBOL DIESIS TETARTIMORION': 118991,
'BYZANTINE MUSICAL SYMBOL DIESIS TRIGRAMMOS OKTO DODEKATA': 118995,
'BYZANTINE MUSICAL SYMBOL DIESIS TRITIMORION': 118990,
'BYZANTINE MUSICAL SYMBOL DIFTOGGOS OU': 119015,
'BYZANTINE MUSICAL SYMBOL DIGORGON': 118930,
'BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA ANO': 118932,
'BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA KATO': 118931,
'BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON DEXIA': 118933,
'BYZANTINE MUSICAL SYMBOL DIGRAMMA GG': 119014,
'BYZANTINE MUSICAL SYMBOL DIPLI': 118918,
'BYZANTINE MUSICAL SYMBOL DIPLI ARCHAION': 118912,
'BYZANTINE MUSICAL SYMBOL DYO': 118831,
'BYZANTINE MUSICAL SYMBOL EKSTREPTON': 118884,
'BYZANTINE MUSICAL SYMBOL ELAFRON': 118869,
'BYZANTINE MUSICAL SYMBOL ENARXIS KAI FTHORA VOU': 118966,
'BYZANTINE MUSICAL SYMBOL ENDOFONON': 118907,
'BYZANTINE MUSICAL SYMBOL EPEGERMA': 118888,
'BYZANTINE MUSICAL SYMBOL ETERON ARGOSYNTHETON': 118900,
'BYZANTINE MUSICAL SYMBOL ETERON PARAKALESMA': 118880,
'BYZANTINE MUSICAL SYMBOL EXO EKFONITIKON': 118798,
'BYZANTINE MUSICAL SYMBOL FANEROSIS DIFONIAS': 118960,
'BYZANTINE MUSICAL SYMBOL FANEROSIS MONOFONIAS': 118959,
'BYZANTINE MUSICAL SYMBOL FANEROSIS TETRAFONIAS': 118958,
'BYZANTINE MUSICAL SYMBOL FHTORA SKLIRON CHROMA VASIS': 118981,
'BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION': 118836,
'BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION DEYTEROU ICHOU': 118969,
'BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI DI': 118973,
'BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI KE': 118975,
'BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NANA': 118971,
'BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI ANO': 118978,
'BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI KATO': 118977,
'BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI PA': 118970,
'BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI ZO': 118976,
'BYZANTINE MUSICAL SYMBOL FTHORA ENARMONIOS ANTIFONIA': 118988,
'BYZANTINE MUSICAL SYMBOL FTHORA I YFESIS TETARTIMORION': 118987,
'BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA DIFONIAS': 118979,
'BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA MONOFONIAS': 118980,
'BYZANTINE MUSICAL SYMBOL FTHORA NAOS ICHOS': 118972,
'BYZANTINE MUSICAL SYMBOL FTHORA NENANO': 118983,
'BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA SYNAFI': 118982,
'BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON DIATONON DI': 118974,
'BYZANTINE MUSICAL SYMBOL GENIKI DIESIS': 119000,
'BYZANTINE MUSICAL SYMBOL GENIKI YFESIS': 119001,
'BYZANTINE MUSICAL SYMBOL GORGON ARCHAION': 118806,
'BYZANTINE MUSICAL SYMBOL GORGON NEO ANO': 118927,
'BYZANTINE MUSICAL SYMBOL GORGON NEO KATO': 119029,
'BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON ARISTERA': 118928,
'BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON DEXIA': 118929,
'BYZANTINE MUSICAL SYMBOL GORGOSYNTHETON': 118898,
'BYZANTINE MUSICAL SYMBOL GORTHMIKON N APLOUN': 118964,
'BYZANTINE MUSICAL SYMBOL GORTHMIKON N DIPLOUN': 118965,
'BYZANTINE MUSICAL SYMBOL GRONTHISMATA': 118853,
'BYZANTINE MUSICAL SYMBOL ICHADIN': 118847,
'BYZANTINE MUSICAL SYMBOL IMIDIARGON': 118936,
'BYZANTINE MUSICAL SYMBOL IMIFONON': 118967,
'BYZANTINE MUSICAL SYMBOL IMIFTHORA': 118837,
'BYZANTINE MUSICAL SYMBOL IMIFTHORON': 118968,
'BYZANTINE MUSICAL SYMBOL ISAKIA TELOUS ICHIMATOS': 118956,
'BYZANTINE MUSICAL SYMBOL ISON ARCHAION': 118810,
'BYZANTINE MUSICAL SYMBOL ISON NEO': 118854,
'BYZANTINE MUSICAL SYMBOL KATAVA TROMIKON': 118839,
'BYZANTINE MUSICAL SYMBOL KATAVASMA': 118906,
'BYZANTINE MUSICAL SYMBOL KATHISTI': 118791,
'BYZANTINE MUSICAL SYMBOL KENTIMA ARCHAION': 118811,
'BYZANTINE MUSICAL SYMBOL KENTIMA NEO ANO': 118863,
'BYZANTINE MUSICAL SYMBOL KENTIMA NEO KATO': 119027,
'BYZANTINE MUSICAL SYMBOL KENTIMA NEO MESO': 119025,
'BYZANTINE MUSICAL SYMBOL KENTIMATA': 118800,
'BYZANTINE MUSICAL SYMBOL KENTIMATA ARCHAION': 118812,
'BYZANTINE MUSICAL SYMBOL KENTIMATA NEO ANO': 118862,
'BYZANTINE MUSICAL SYMBOL KENTIMATA NEO KATO': 119026,
'BYZANTINE MUSICAL SYMBOL KENTIMATA NEO MESO': 119024,
'BYZANTINE MUSICAL SYMBOL KLASMA': 118820,
'BYZANTINE MUSICAL SYMBOL KLASMA ANO': 118911,
'BYZANTINE MUSICAL SYMBOL KLASMA KATO': 119028,
'BYZANTINE MUSICAL SYMBOL KONTEVMA': 118842,
'BYZANTINE MUSICAL SYMBOL KONTEVMA ALLO': 118850,
'BYZANTINE MUSICAL SYMBOL KORONIS': 118921,
'BYZANTINE MUSICAL SYMBOL KOUFISMA': 118858,
'BYZANTINE MUSICAL SYMBOL KRATIMA ALLO': 118914,
'BYZANTINE MUSICAL SYMBOL KRATIMA ARCHAION': 118913,
'BYZANTINE MUSICAL SYMBOL KRATIMA NEO': 118915,
'BYZANTINE MUSICAL SYMBOL KRATIMATA': 118834,
'BYZANTINE MUSICAL SYMBOL KRATIMOKOUFISMA': 118860,
'BYZANTINE MUSICAL SYMBOL KRATIMOYPORROON': 118868,
'BYZANTINE MUSICAL SYMBOL KREMASTI': 118796,
'BYZANTINE MUSICAL SYMBOL KYLISMA': 118881,
'BYZANTINE MUSICAL SYMBOL LEIMMA DYO CHRONON': 118923,
'BYZANTINE MUSICAL SYMBOL LEIMMA ENOS CHRONOU': 118922,
'BYZANTINE MUSICAL SYMBOL LEIMMA IMISEOS CHRONOU': 118926,
'BYZANTINE MUSICAL SYMBOL LEIMMA TESSARON CHRONON': 118925,
'BYZANTINE MUSICAL SYMBOL LEIMMA TRION CHRONON': 118924,
'BYZANTINE MUSICAL SYMBOL LEMOI': 118830,
'BYZANTINE MUSICAL SYMBOL LYGISMA': 118877,
'BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI DEYTEROS ICHOS': 118949,
'BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI PROTOS ICHOS': 118947,
'BYZANTINE MUSICAL SYMBOL MARTYRIA DEYTEROS ICHOS': 118948,
'BYZANTINE MUSICAL SYMBOL MARTYRIA LEGETOS ICHOS': 118954,
'BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS ICHOS': 118955,
'BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS TETARTOS ICHOS': 118963,
'BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOS ICHOS': 118946,
'BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOVARYS ICHOS': 118962,
'BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS ICHOS': 118952,
'BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS LEGETOS ICHOS': 118953,
'BYZANTINE MUSICAL SYMBOL MARTYRIA TRIFONIAS': 118951,
'BYZANTINE MUSICAL SYMBOL MARTYRIA TRITOS ICHOS': 118950,
'BYZANTINE MUSICAL SYMBOL MARTYRIA VARYS ICHOS': 118961,
'BYZANTINE MUSICAL SYMBOL MIKRON ISON': 118871,
'BYZANTINE MUSICAL SYMBOL NANA': 118848,
'BYZANTINE MUSICAL SYMBOL OLIGON ARCHAION': 118805,
'BYZANTINE MUSICAL SYMBOL OLIGON NEO': 118855,
'BYZANTINE MUSICAL SYMBOL OMALON': 118875,
'BYZANTINE MUSICAL SYMBOL OXEIA DIPLI': 118788,
'BYZANTINE MUSICAL SYMBOL OXEIA EKFONITIKON': 118787,
'BYZANTINE MUSICAL SYMBOL OXEIA NEO': 118856,
'BYZANTINE MUSICAL SYMBOL OXEIAI ARCHAION': 118816,
'BYZANTINE MUSICAL SYMBOL OYRANISMA ARCHAION': 118828,
'BYZANTINE MUSICAL SYMBOL OYRANISMA NEO': 118901,
'BYZANTINE MUSICAL SYMBOL PARAKALESMA ARCHAION': 118845,
'BYZANTINE MUSICAL SYMBOL PARAKALESMA NEO': 118879,
'BYZANTINE MUSICAL SYMBOL PARAKLITIKI': 118793,
'BYZANTINE MUSICAL SYMBOL PARAKLITIKI ARCHAION': 118846,
'BYZANTINE MUSICAL SYMBOL PARAKLITIKI NEO': 118878,
'BYZANTINE MUSICAL SYMBOL PARICHON': 118814,
'BYZANTINE MUSICAL SYMBOL PELASTON': 118840,
'BYZANTINE MUSICAL SYMBOL PELASTON NEO': 118861,
'BYZANTINE MUSICAL SYMBOL PERISPOMENI': 118786,
'BYZANTINE MUSICAL SYMBOL PETASMA': 118849,
'BYZANTINE MUSICAL SYMBOL PETASTI': 118857,
'BYZANTINE MUSICAL SYMBOL PETASTOKOUFISMA': 118859,
'BYZANTINE MUSICAL SYMBOL PIASMA ARCHAION': 118822,
'BYZANTINE MUSICAL SYMBOL PIASMA NEO': 118873,
'BYZANTINE MUSICAL SYMBOL PSIFISTOLYGISMA': 118892,
'BYZANTINE MUSICAL SYMBOL PSIFISTON': 118841,
'BYZANTINE MUSICAL SYMBOL PSIFISTON NEO': 118874,
'BYZANTINE MUSICAL SYMBOL PSIFISTOPARAKALESMA': 118895,
'BYZANTINE MUSICAL SYMBOL PSIFISTOSYNAGMA': 118897,
'BYZANTINE MUSICAL SYMBOL PSILI': 118784,
'BYZANTINE MUSICAL SYMBOL PSILON': 118807,
'BYZANTINE MUSICAL SYMBOL RAPISMA': 118844,
'BYZANTINE MUSICAL SYMBOL REVMA': 118821,
'BYZANTINE MUSICAL SYMBOL SAXIMATA': 118813,
'BYZANTINE MUSICAL SYMBOL SEISMA': 118825,
'BYZANTINE MUSICAL SYMBOL SEISMA NEO': 118889,
'BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS': 119010,
'BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS DISIMOU': 119011,
'BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TETRASIMOU': 119013,
'BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TRISIMOU': 119012,
'BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS': 119006,
'BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS DISIMOU': 119007,
'BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TETRASIMOU': 119009,
'BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TRISIMOU': 119008,
'BYZANTINE MUSICAL SYMBOL STAVROS': 118910,
'BYZANTINE MUSICAL SYMBOL STAVROS APODEXIA': 118815,
'BYZANTINE MUSICAL SYMBOL STIGMA': 119016,
'BYZANTINE MUSICAL SYMBOL STRAGGISMATA': 118852,
'BYZANTINE MUSICAL SYMBOL SYNAGMA ARCHAION': 118826,
'BYZANTINE MUSICAL SYMBOL SYNAGMA META STAVROU': 118827,
'BYZANTINE MUSICAL SYMBOL SYNAGMA NEO': 118885,
'BYZANTINE MUSICAL SYMBOL SYNEVMA': 118803,
'BYZANTINE MUSICAL SYMBOL SYRMA': 118886,
'BYZANTINE MUSICAL SYMBOL SYRMATIKI': 118792,
'BYZANTINE MUSICAL SYMBOL TELEIA': 118799,
'BYZANTINE MUSICAL SYMBOL TESSERA': 118833,
'BYZANTINE MUSICAL SYMBOL TETRAPLI': 118920,
'BYZANTINE MUSICAL SYMBOL THEMA': 118829,
'BYZANTINE MUSICAL SYMBOL THEMA APLOUN': 118904,
'BYZANTINE MUSICAL SYMBOL THEMATISMOS ESO': 118902,
'BYZANTINE MUSICAL SYMBOL THEMATISMOS EXO': 118903,
'BYZANTINE MUSICAL SYMBOL THES KAI APOTHES': 118905,
'BYZANTINE MUSICAL SYMBOL THITA': 118804,
'BYZANTINE MUSICAL SYMBOL TINAGMA': 118823,
'BYZANTINE MUSICAL SYMBOL TRIA': 118832,
'BYZANTINE MUSICAL SYMBOL TRIGORGON': 118934,
'BYZANTINE MUSICAL SYMBOL TRIPLI': 118919,
'BYZANTINE MUSICAL SYMBOL TROMIKOLYGISMA': 118893,
'BYZANTINE MUSICAL SYMBOL TROMIKON ALLO': 118851,
'BYZANTINE MUSICAL SYMBOL TROMIKON ARCHAION': 118838,
'BYZANTINE MUSICAL SYMBOL TROMIKON NEO': 118883,
'BYZANTINE MUSICAL SYMBOL TROMIKOPARAKALESMA': 118894,
'BYZANTINE MUSICAL SYMBOL TROMIKOPSIFISTON': 118891,
'BYZANTINE MUSICAL SYMBOL TROMIKOSYNAGMA': 118896,
'BYZANTINE MUSICAL SYMBOL VAREIA DIPLI': 118790,
'BYZANTINE MUSICAL SYMBOL VAREIA EKFONITIKON': 118789,
'BYZANTINE MUSICAL SYMBOL VAREIA NEO': 118872,
'BYZANTINE MUSICAL SYMBOL VAREIAI ARCHAION': 118817,
'BYZANTINE MUSICAL SYMBOL VATHY': 118809,
'BYZANTINE MUSICAL SYMBOL XIRON KLASMA': 118890,
'BYZANTINE MUSICAL SYMBOL YFEN ANO': 118909,
'BYZANTINE MUSICAL SYMBOL YFEN KATO': 118908,
'BYZANTINE MUSICAL SYMBOL YFESIS APLI DYO DODEKATA': 118996,
'BYZANTINE MUSICAL SYMBOL YFESIS DIGRAMMOS EX DODEKATA': 118998,
'BYZANTINE MUSICAL SYMBOL YFESIS MONOGRAMMOS TESSERA DODEKATA': 118997,
'BYZANTINE MUSICAL SYMBOL YFESIS TRIGRAMMOS OKTO DODEKATA': 118999,
'BYZANTINE MUSICAL SYMBOL YFESIS TRITIMORION': 118989,
'BYZANTINE MUSICAL SYMBOL YPOKRISIS': 118794,
'BYZANTINE MUSICAL SYMBOL YPOKRISIS DIPLI': 118795,
'BYZANTINE MUSICAL SYMBOL YPORROI': 118867,
'BYZANTINE MUSICAL SYMBOL YPSILI': 118864,
'CADA UNA': 8454,
'CADUCEUS': 9764,
'CANADIAN SYLLABICS A': 5130,
'CANADIAN SYLLABICS AA': 5131,
'CANADIAN SYLLABICS AAI': 5122,
'CANADIAN SYLLABICS AI': 5148,
'CANADIAN SYLLABICS AIVILIK B': 5551,
'CANADIAN SYLLABICS AN': 5166,
'CANADIAN SYLLABICS ATHAPASCAN M': 5310,
'CANADIAN SYLLABICS ATHAPASCAN S': 5382,
'CANADIAN SYLLABICS BIBLE-CREE Y': 5439,
'CANADIAN SYLLABICS BLACKFOOT A': 5555,
'CANADIAN SYLLABICS BLACKFOOT E': 5552,
'CANADIAN SYLLABICS BLACKFOOT I': 5553,
'CANADIAN SYLLABICS BLACKFOOT KA': 5567,
'CANADIAN SYLLABICS BLACKFOOT KE': 5564,
'CANADIAN SYLLABICS BLACKFOOT KI': 5565,
'CANADIAN SYLLABICS BLACKFOOT KO': 5566,
'CANADIAN SYLLABICS BLACKFOOT NA': 5563,
'CANADIAN SYLLABICS BLACKFOOT NE': 5560,
'CANADIAN SYLLABICS BLACKFOOT NI': 5561,
'CANADIAN SYLLABICS BLACKFOOT NO': 5562,
'CANADIAN SYLLABICS BLACKFOOT O': 5554,
'CANADIAN SYLLABICS BLACKFOOT S': 5384,
'CANADIAN SYLLABICS BLACKFOOT WA': 5559,
'CANADIAN SYLLABICS BLACKFOOT WE': 5556,
'CANADIAN SYLLABICS BLACKFOOT WI': 5557,
'CANADIAN SYLLABICS BLACKFOOT WO': 5558,
'CANADIAN SYLLABICS C': 5281,
'CANADIAN SYLLABICS CA': 5264,
'CANADIAN SYLLABICS CAA': 5265,
'CANADIAN SYLLABICS CAAI': 5258,
'CANADIAN SYLLABICS CARRIER CHA': 5734,
'CANADIAN SYLLABICS CARRIER CHE': 5731,
'CANADIAN SYLLABICS CARRIER CHEE': 5732,
'CANADIAN SYLLABICS CARRIER CHI': 5733,
'CANADIAN SYLLABICS CARRIER CHO': 5730,
'CANADIAN SYLLABICS CARRIER CHU': 5729,
'CANADIAN SYLLABICS CARRIER DEE': 5203,
'CANADIAN SYLLABICS CARRIER DI': 5204,
'CANADIAN SYLLABICS CARRIER DLA': 5677,
'CANADIAN SYLLABICS CARRIER DLE': 5674,
'CANADIAN SYLLABICS CARRIER DLEE': 5675,
'CANADIAN SYLLABICS CARRIER DLI': 5676,
'CANADIAN SYLLABICS CARRIER DLO': 5673,
'CANADIAN SYLLABICS CARRIER DLU': 5672,
'CANADIAN SYLLABICS CARRIER DZA': 5709,
'CANADIAN SYLLABICS CARRIER DZE': 5706,
'CANADIAN SYLLABICS CARRIER DZEE': 5707,
'CANADIAN SYLLABICS CARRIER DZI': 5708,
'CANADIAN SYLLABICS CARRIER DZO': 5705,
'CANADIAN SYLLABICS CARRIER DZU': 5704,
'CANADIAN SYLLABICS CARRIER EE': 5128,
'CANADIAN SYLLABICS CARRIER GA': 5620,
'CANADIAN SYLLABICS CARRIER GE': 5617,
'CANADIAN SYLLABICS CARRIER GEE': 5618,
'CANADIAN SYLLABICS CARRIER GHA': 5577,
'CANADIAN SYLLABICS CARRIER GHE': 5574,
'CANADIAN SYLLABICS CARRIER GHEE': 5575,
'CANADIAN SYLLABICS CARRIER GHI': 5576,
'CANADIAN SYLLABICS CARRIER GHO': 5573,
'CANADIAN SYLLABICS CARRIER GHU': 5572,
'CANADIAN SYLLABICS CARRIER GI': 5619,
'CANADIAN SYLLABICS CARRIER GO': 5616,
'CANADIAN SYLLABICS CARRIER GU': 5615,
'CANADIAN SYLLABICS CARRIER H': 5195,
'CANADIAN SYLLABICS CARRIER HEE': 5174,
'CANADIAN SYLLABICS CARRIER HI': 5175,
'CANADIAN SYLLABICS CARRIER HWA': 5595,
'CANADIAN SYLLABICS CARRIER HWE': 5592,
'CANADIAN SYLLABICS CARRIER HWEE': 5593,
'CANADIAN SYLLABICS CARRIER HWI': 5594,
'CANADIAN SYLLABICS CARRIER HWO': 5591,
'CANADIAN SYLLABICS CARRIER HWU': 5590,
'CANADIAN SYLLABICS CARRIER I': 5129,
'CANADIAN SYLLABICS CARRIER INITIAL Z': 5703,
'CANADIAN SYLLABICS CARRIER JA': 5659,
'CANADIAN SYLLABICS CARRIER JE': 5655,
'CANADIAN SYLLABICS CARRIER JEE': 5656,
'CANADIAN SYLLABICS CARRIER JI': 5657,
'CANADIAN SYLLABICS CARRIER JJA': 5665,
'CANADIAN SYLLABICS CARRIER JJE': 5662,
'CANADIAN SYLLABICS CARRIER JJEE': 5663,
'CANADIAN SYLLABICS CARRIER JJI': 5664,
'CANADIAN SYLLABICS CARRIER JJO': 5661,
'CANADIAN SYLLABICS CARRIER JJU': 5660,
'CANADIAN SYLLABICS CARRIER JO': 5654,
'CANADIAN SYLLABICS CARRIER JU': 5652,
'CANADIAN SYLLABICS CARRIER KHA': 5626,
'CANADIAN SYLLABICS CARRIER KHE': 5623,
'CANADIAN SYLLABICS CARRIER KHEE': 5624,
'CANADIAN SYLLABICS CARRIER KHI': 5625,
'CANADIAN SYLLABICS CARRIER KHO': 5622,
'CANADIAN SYLLABICS CARRIER KHU': 5621,
'CANADIAN SYLLABICS CARRIER KK': 5633,
'CANADIAN SYLLABICS CARRIER KKA': 5632,
'CANADIAN SYLLABICS CARRIER KKE': 5629,
'CANADIAN SYLLABICS CARRIER KKEE': 5630,
'CANADIAN SYLLABICS CARRIER KKI': 5631,
'CANADIAN SYLLABICS CARRIER KKO': 5628,
'CANADIAN SYLLABICS CARRIER KKU': 5627,
'CANADIAN SYLLABICS CARRIER LA': 5671,
'CANADIAN SYLLABICS CARRIER LE': 5668,
'CANADIAN SYLLABICS CARRIER LEE': 5669,
'CANADIAN SYLLABICS CARRIER LHA': 5683,
'CANADIAN SYLLABICS CARRIER LHE': 5680,
'CANADIAN SYLLABICS CARRIER LHEE': 5681,
'CANADIAN SYLLABICS CARRIER LHI': 5682,
'CANADIAN SYLLABICS CARRIER LHO': 5679,
'CANADIAN SYLLABICS CARRIER LHU': 5678,
'CANADIAN SYLLABICS CARRIER LI': 5670,
'CANADIAN SYLLABICS CARRIER LO': 5667,
'CANADIAN SYLLABICS CARRIER LU': 5666,
'CANADIAN SYLLABICS CARRIER MA': 5645,
'CANADIAN SYLLABICS CARRIER ME': 5642,
'CANADIAN SYLLABICS CARRIER MEE': 5643,
'CANADIAN SYLLABICS CARRIER MI': 5644,
'CANADIAN SYLLABICS CARRIER MO': 5641,
'CANADIAN SYLLABICS CARRIER MU': 5640,
'CANADIAN SYLLABICS CARRIER NA': 5639,
'CANADIAN SYLLABICS CARRIER NE': 5636,
'CANADIAN SYLLABICS CARRIER NEE': 5637,
'CANADIAN SYLLABICS CARRIER NG': 5329,
'CANADIAN SYLLABICS CARRIER NI': 5638,
'CANADIAN SYLLABICS CARRIER NO': 5635,
'CANADIAN SYLLABICS CARRIER NU': 5634,
'CANADIAN SYLLABICS CARRIER P': 5614,
'CANADIAN SYLLABICS CARRIER PA': 5613,
'CANADIAN SYLLABICS CARRIER PE': 5610,
'CANADIAN SYLLABICS CARRIER PEE': 5611,
'CANADIAN SYLLABICS CARRIER PI': 5612,
'CANADIAN SYLLABICS CARRIER PO': 5609,
'CANADIAN SYLLABICS CARRIER PU': 5608,
'CANADIAN SYLLABICS CARRIER RA': 5583,
'CANADIAN SYLLABICS CARRIER RE': 5580,
'CANADIAN SYLLABICS CARRIER REE': 5581,
'CANADIAN SYLLABICS CARRIER RI': 5582,
'CANADIAN SYLLABICS CARRIER RO': 5579,
'CANADIAN SYLLABICS CARRIER RU': 5578,
'CANADIAN SYLLABICS CARRIER SA': 5715,
'CANADIAN SYLLABICS CARRIER SE': 5712,
'CANADIAN SYLLABICS CARRIER SEE': 5713,
'CANADIAN SYLLABICS CARRIER SH': 5722,
'CANADIAN SYLLABICS CARRIER SHA': 5721,
'CANADIAN SYLLABICS CARRIER SHE': 5718,
'CANADIAN SYLLABICS CARRIER SHEE': 5719,
'CANADIAN SYLLABICS CARRIER SHI': 5720,
'CANADIAN SYLLABICS CARRIER SHO': 5717,
'CANADIAN SYLLABICS CARRIER SHU': 5716,
'CANADIAN SYLLABICS CARRIER SI': 5714,
'CANADIAN SYLLABICS CARRIER SO': 5711,
'CANADIAN SYLLABICS CARRIER SU': 5710,
'CANADIAN SYLLABICS CARRIER THA': 5601,
'CANADIAN SYLLABICS CARRIER THE': 5598,
'CANADIAN SYLLABICS CARRIER THEE': 5599,
'CANADIAN SYLLABICS CARRIER THI': 5600,
'CANADIAN SYLLABICS CARRIER THO': 5597,
'CANADIAN SYLLABICS CARRIER THU': 5596,
'CANADIAN SYLLABICS CARRIER TLA': 5695,
'CANADIAN SYLLABICS CARRIER TLE': 5692,
'CANADIAN SYLLABICS CARRIER TLEE': 5693,
'CANADIAN SYLLABICS CARRIER TLHA': 5689,
'CANADIAN SYLLABICS CARRIER TLHE': 5686,
'CANADIAN SYLLABICS CARRIER TLHEE': 5687,
'CANADIAN SYLLABICS CARRIER TLHI': 5688,
'CANADIAN SYLLABICS CARRIER TLHO': 5685,
'CANADIAN SYLLABICS CARRIER TLHU': 5684,
'CANADIAN SYLLABICS CARRIER TLI': 5694,
'CANADIAN SYLLABICS CARRIER TLO': 5691,
'CANADIAN SYLLABICS CARRIER TLU': 5690,
'CANADIAN SYLLABICS CARRIER TSA': 5728,
'CANADIAN SYLLABICS CARRIER TSE': 5725,
'CANADIAN SYLLABICS CARRIER TSEE': 5726,
'CANADIAN SYLLABICS CARRIER TSI': 5727,
'CANADIAN SYLLABICS CARRIER TSO': 5724,
'CANADIAN SYLLABICS CARRIER TSU': 5723,
'CANADIAN SYLLABICS CARRIER TTA': 5607,
'CANADIAN SYLLABICS CARRIER TTE': 5604,
'CANADIAN SYLLABICS CARRIER TTEE': 5605,
'CANADIAN SYLLABICS CARRIER TTI': 5606,
'CANADIAN SYLLABICS CARRIER TTO': 5603,
'CANADIAN SYLLABICS CARRIER TTSA': 5740,
'CANADIAN SYLLABICS CARRIER TTSE': 5737,
'CANADIAN SYLLABICS CARRIER TTSEE': 5738,
'CANADIAN SYLLABICS CARRIER TTSI': 5739,
'CANADIAN SYLLABICS CARRIER TTSO': 5736,
'CANADIAN SYLLABICS CARRIER TTSU': 5735,
'CANADIAN SYLLABICS CARRIER TTU': 5602,
'CANADIAN SYLLABICS CARRIER WA': 5589,
'CANADIAN SYLLABICS CARRIER WE': 5586,
'CANADIAN SYLLABICS CARRIER WEE': 5587,
'CANADIAN SYLLABICS CARRIER WI': 5588,
'CANADIAN SYLLABICS CARRIER WO': 5585,
'CANADIAN SYLLABICS CARRIER WU': 5584,
'CANADIAN SYLLABICS CARRIER YA': 5651,
'CANADIAN SYLLABICS CARRIER YE': 5648,
'CANADIAN SYLLABICS CARRIER YEE': 5649,
'CANADIAN SYLLABICS CARRIER YI': 5650,
'CANADIAN SYLLABICS CARRIER YO': 5647,
'CANADIAN SYLLABICS CARRIER YU': 5646,
'CANADIAN SYLLABICS CARRIER Z': 5702,
'CANADIAN SYLLABICS CARRIER ZA': 5701,
'CANADIAN SYLLABICS CARRIER ZE': 5698,
'CANADIAN SYLLABICS CARRIER ZEE': 5699,
'CANADIAN SYLLABICS CARRIER ZI': 5700,
'CANADIAN SYLLABICS CARRIER ZO': 5697,
'CANADIAN SYLLABICS CARRIER ZU': 5696,
'CANADIAN SYLLABICS CE': 5257,
'CANADIAN SYLLABICS CHI SIGN': 5741,
'CANADIAN SYLLABICS CI': 5259,
'CANADIAN SYLLABICS CII': 5260,
'CANADIAN SYLLABICS CO': 5261,
'CANADIAN SYLLABICS COO': 5262,
'CANADIAN SYLLABICS CWA': 5276,
'CANADIAN SYLLABICS CWAA': 5278,
'CANADIAN SYLLABICS CWE': 5266,
'CANADIAN SYLLABICS CWI': 5268,
'CANADIAN SYLLABICS CWII': 5270,
'CANADIAN SYLLABICS CWO': 5272,
'CANADIAN SYLLABICS CWOO': 5274,
'CANADIAN SYLLABICS E': 5121,
'CANADIAN SYLLABICS EN': 5163,
'CANADIAN SYLLABICS F': 5469,
'CANADIAN SYLLABICS FA': 5465,
'CANADIAN SYLLABICS FAA': 5466,
'CANADIAN SYLLABICS FAAI': 5460,
'CANADIAN SYLLABICS FE': 5459,
'CANADIAN SYLLABICS FI': 5461,
'CANADIAN SYLLABICS FII': 5462,
'CANADIAN SYLLABICS FINAL ACUTE': 5151,
'CANADIAN SYLLABICS FINAL BOTTOM HALF RING': 5153,
'CANADIAN SYLLABICS FINAL DOUBLE ACUTE': 5157,
'CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES': 5158,
'CANADIAN SYLLABICS FINAL DOWN TACK': 5162,
'CANADIAN SYLLABICS FINAL GRAVE': 5152,
'CANADIAN SYLLABICS FINAL MIDDLE DOT': 5159,
'CANADIAN SYLLABICS FINAL PLUS': 5161,
'CANADIAN SYLLABICS FINAL RIGHT HALF RING': 5155,
'CANADIAN SYLLABICS FINAL RING': 5156,
'CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE': 5160,
'CANADIAN SYLLABICS FINAL TOP HALF RING': 5154,
'CANADIAN SYLLABICS FO': 5463,
'CANADIAN SYLLABICS FOO': 5464,
'CANADIAN SYLLABICS FULL STOP': 5742,
'CANADIAN SYLLABICS FWAA': 5467,
'CANADIAN SYLLABICS GLOTTAL STOP': 5150,
'CANADIAN SYLLABICS HK': 5501,
'CANADIAN SYLLABICS I': 5123,
'CANADIAN SYLLABICS II': 5124,
'CANADIAN SYLLABICS IN': 5164,
'CANADIAN SYLLABICS K': 5251,
'CANADIAN SYLLABICS KA': 5234,
'CANADIAN SYLLABICS KAA': 5235,
'CANADIAN SYLLABICS KAAI': 5228,
'CANADIAN SYLLABICS KE': 5227,
'CANADIAN SYLLABICS KI': 5229,
'CANADIAN SYLLABICS KII': 5230,
'CANADIAN SYLLABICS KO': 5231,
'CANADIAN SYLLABICS KOO': 5232,
'CANADIAN SYLLABICS KW': 5252,
'CANADIAN SYLLABICS KWA': 5246,
'CANADIAN SYLLABICS KWAA': 5248,
'CANADIAN SYLLABICS KWE': 5236,
'CANADIAN SYLLABICS KWI': 5238,
'CANADIAN SYLLABICS KWII': 5240,
'CANADIAN SYLLABICS KWO': 5242,
'CANADIAN SYLLABICS KWOO': 5244,
'CANADIAN SYLLABICS L': 5354,
'CANADIAN SYLLABICS LA': 5338,
'CANADIAN SYLLABICS LAA': 5339,
'CANADIAN SYLLABICS LAAI': 5332,
'CANADIAN SYLLABICS LE': 5331,
'CANADIAN SYLLABICS LH': 5542,
'CANADIAN SYLLABICS LHA': 5540,
'CANADIAN SYLLABICS LHAA': 5541,
'CANADIAN SYLLABICS LHI': 5536,
'CANADIAN SYLLABICS LHII': 5537,
'CANADIAN SYLLABICS LHO': 5538,
'CANADIAN SYLLABICS LHOO': 5539,
'CANADIAN SYLLABICS LI': 5333,
'CANADIAN SYLLABICS LII': 5334,
'CANADIAN SYLLABICS LO': 5335,
'CANADIAN SYLLABICS LOO': 5336,
'CANADIAN SYLLABICS LWA': 5350,
'CANADIAN SYLLABICS LWAA': 5352,
'CANADIAN SYLLABICS LWE': 5340,
'CANADIAN SYLLABICS LWI': 5342,
'CANADIAN SYLLABICS LWII': 5344,
'CANADIAN SYLLABICS LWO': 5346,
'CANADIAN SYLLABICS LWOO': 5348,
'CANADIAN SYLLABICS M': 5307,
'CANADIAN SYLLABICS MA': 5290,
'CANADIAN SYLLABICS MAA': 5291,
'CANADIAN SYLLABICS MAAI': 5284,
'CANADIAN SYLLABICS ME': 5283,
'CANADIAN SYLLABICS MEDIAL L': 5356,
'CANADIAN SYLLABICS MEDIAL R': 5458,
'CANADIAN SYLLABICS MH': 5309,
'CANADIAN SYLLABICS MI': 5285,
'CANADIAN SYLLABICS MII': 5286,
'CANADIAN SYLLABICS MO': 5287,
'CANADIAN SYLLABICS MOO': 5288,
'CANADIAN SYLLABICS MOOSE-CREE SK': 5385,
'CANADIAN SYLLABICS MWA': 5302,
'CANADIAN SYLLABICS MWAA': 5304,
'CANADIAN SYLLABICS MWE': 5292,
'CANADIAN SYLLABICS MWI': 5294,
'CANADIAN SYLLABICS MWII': 5296,
'CANADIAN SYLLABICS MWO': 5298,
'CANADIAN SYLLABICS MWOO': 5300,
'CANADIAN SYLLABICS N': 5328,
'CANADIAN SYLLABICS N-CREE THE': 5471,
'CANADIAN SYLLABICS N-CREE THI': 5473,
'CANADIAN SYLLABICS N-CREE THII': 5475,
'CANADIAN SYLLABICS NA': 5319,
'CANADIAN SYLLABICS NAA': 5320,
'CANADIAN SYLLABICS NAAI': 5313,
'CANADIAN SYLLABICS NASKAPI CWAA': 5280,
'CANADIAN SYLLABICS NASKAPI KWAA': 5250,
'CANADIAN SYLLABICS NASKAPI MWAA': 5306,
'CANADIAN SYLLABICS NASKAPI NWAA': 5327,
'CANADIAN SYLLABICS NASKAPI S-W': 5387,
'CANADIAN SYLLABICS NASKAPI SCWA': 5391,
'CANADIAN SYLLABICS NASKAPI SKW': 5386,
'CANADIAN SYLLABICS NASKAPI SKWA': 5390,
'CANADIAN SYLLABICS NASKAPI SPWA': 5388,
'CANADIAN SYLLABICS NASKAPI STWA': 5389,
'CANADIAN SYLLABICS NASKAPI SWAA': 5380,
'CANADIAN SYLLABICS NASKAPI TWAA': 5221,
'CANADIAN SYLLABICS NASKAPI WAA': 5147,
'CANADIAN SYLLABICS NASKAPI WOO': 5142,
'CANADIAN SYLLABICS NASKAPI YWAA': 5437,
'CANADIAN SYLLABICS NE': 5312,
'CANADIAN SYLLABICS NG': 5525,
'CANADIAN SYLLABICS NGA': 5523,
'CANADIAN SYLLABICS NGAA': 5524,
'CANADIAN SYLLABICS NGAAI': 5518,
'CANADIAN SYLLABICS NGAI': 5744,
'CANADIAN SYLLABICS NGI': 5519,
'CANADIAN SYLLABICS NGII': 5520,
'CANADIAN SYLLABICS NGO': 5521,
'CANADIAN SYLLABICS NGOO': 5522,
'CANADIAN SYLLABICS NH': 5330,
'CANADIAN SYLLABICS NI': 5314,
'CANADIAN SYLLABICS NII': 5315,
'CANADIAN SYLLABICS NNG': 5526,
'CANADIAN SYLLABICS NNGA': 5749,
'CANADIAN SYLLABICS NNGAA': 5750,
'CANADIAN SYLLABICS NNGI': 5745,
'CANADIAN SYLLABICS NNGII': 5746,
'CANADIAN SYLLABICS NNGO': 5747,
'CANADIAN SYLLABICS NNGOO': 5748,
'CANADIAN SYLLABICS NO': 5316,
'CANADIAN SYLLABICS NOO': 5317,
'CANADIAN SYLLABICS NUNAVIK H': 5499,
'CANADIAN SYLLABICS NUNAVIK HA': 5497,
'CANADIAN SYLLABICS NUNAVIK HAA': 5498,
'CANADIAN SYLLABICS NUNAVIK HE': 5492,
'CANADIAN SYLLABICS NUNAVIK HI': 5493,
'CANADIAN SYLLABICS NUNAVIK HII': 5494,
'CANADIAN SYLLABICS NUNAVIK HO': 5495,
'CANADIAN SYLLABICS NUNAVIK HOO': 5496,
'CANADIAN SYLLABICS NUNAVUT H': 5500,
'CANADIAN SYLLABICS NWA': 5323,
'CANADIAN SYLLABICS NWAA': 5325,
'CANADIAN SYLLABICS NWE': 5321,
'CANADIAN SYLLABICS O': 5125,
'CANADIAN SYLLABICS ON': 5165,
'CANADIAN SYLLABICS OO': 5126,
'CANADIAN SYLLABICS P': 5193,
'CANADIAN SYLLABICS PA': 5176,
'CANADIAN SYLLABICS PAA': 5177,
'CANADIAN SYLLABICS PAAI': 5168,
'CANADIAN SYLLABICS PE': 5167,
'CANADIAN SYLLABICS PI': 5169,
'CANADIAN SYLLABICS PII': 5170,
'CANADIAN SYLLABICS PO': 5171,
'CANADIAN SYLLABICS POO': 5172,
'CANADIAN SYLLABICS PWA': 5188,
'CANADIAN SYLLABICS PWAA': 5190,
'CANADIAN SYLLABICS PWE': 5178,
'CANADIAN SYLLABICS PWI': 5180,
'CANADIAN SYLLABICS PWII': 5182,
'CANADIAN SYLLABICS PWO': 5184,
'CANADIAN SYLLABICS PWOO': 5186,
'CANADIAN SYLLABICS Q': 5509,
'CANADIAN SYLLABICS QA': 5507,
'CANADIAN SYLLABICS QAA': 5508,
'CANADIAN SYLLABICS QAAI': 5502,
'CANADIAN SYLLABICS QAI': 5743,
'CANADIAN SYLLABICS QI': 5503,
'CANADIAN SYLLABICS QII': 5504,
'CANADIAN SYLLABICS QO': 5505,
'CANADIAN SYLLABICS QOO': 5506,
'CANADIAN SYLLABICS R': 5456,
'CANADIAN SYLLABICS R-CREE RE': 5443,
'CANADIAN SYLLABICS RA': 5451,
'CANADIAN SYLLABICS RAA': 5452,
'CANADIAN SYLLABICS RAAI': 5445,
'CANADIAN SYLLABICS RE': 5442,
'CANADIAN SYLLABICS RI': 5446,
'CANADIAN SYLLABICS RII': 5447,
'CANADIAN SYLLABICS RO': 5448,
'CANADIAN SYLLABICS ROO': 5449,
'CANADIAN SYLLABICS RWAA': 5454,
'CANADIAN SYLLABICS S': 5381,
'CANADIAN SYLLABICS SA': 5364,
'CANADIAN SYLLABICS SAA': 5365,
'CANADIAN SYLLABICS SAAI': 5358,
'CANADIAN SYLLABICS SAYISI HA': 5571,
'CANADIAN SYLLABICS SAYISI HE': 5568,
'CANADIAN SYLLABICS SAYISI HI': 5569,
'CANADIAN SYLLABICS SAYISI HO': 5570,
'CANADIAN SYLLABICS SAYISI JI': 5658,
'CANADIAN SYLLABICS SAYISI JU': 5653,
'CANADIAN SYLLABICS SAYISI M': 5311,
'CANADIAN SYLLABICS SAYISI SHA': 5530,
'CANADIAN SYLLABICS SAYISI SHE': 5527,
'CANADIAN SYLLABICS SAYISI SHI': 5528,
'CANADIAN SYLLABICS SAYISI SHO': 5529,
'CANADIAN SYLLABICS SAYISI TH': 5282,
'CANADIAN SYLLABICS SAYISI YI': 5441,
'CANADIAN SYLLABICS SE': 5357,
'CANADIAN SYLLABICS SH': 5413,
'CANADIAN SYLLABICS SHA': 5397,
'CANADIAN SYLLABICS SHAA': 5398,
'CANADIAN SYLLABICS SHE': 5392,
'CANADIAN SYLLABICS SHI': 5393,
'CANADIAN SYLLABICS SHII': 5394,
'CANADIAN SYLLABICS SHO': 5395,
'CANADIAN SYLLABICS SHOO': 5396,
'CANADIAN SYLLABICS SHWA': 5409,
'CANADIAN SYLLABICS SHWAA': 5411,
'CANADIAN SYLLABICS SHWE': 5399,
'CANADIAN SYLLABICS SHWI': 5401,
'CANADIAN SYLLABICS SHWII': 5403,
'CANADIAN SYLLABICS SHWO': 5405,
'CANADIAN SYLLABICS SHWOO': 5407,
'CANADIAN SYLLABICS SI': 5359,
'CANADIAN SYLLABICS SII': 5360,
'CANADIAN SYLLABICS SO': 5361,
'CANADIAN SYLLABICS SOO': 5362,
'CANADIAN SYLLABICS SOUTH-SLAVEY KAH': 5256,
'CANADIAN SYLLABICS SOUTH-SLAVEY KEH': 5253,
'CANADIAN SYLLABICS SOUTH-SLAVEY KIH': 5254,
'CANADIAN SYLLABICS SOUTH-SLAVEY KOH': 5255,
'CANADIAN SYLLABICS SW': 5383,
'CANADIAN SYLLABICS SWA': 5376,
'CANADIAN SYLLABICS SWAA': 5378,
'CANADIAN SYLLABICS SWE': 5366,
'CANADIAN SYLLABICS SWI': 5368,
'CANADIAN SYLLABICS SWII': 5370,
'CANADIAN SYLLABICS SWO': 5372,
'CANADIAN SYLLABICS SWOO': 5374,
'CANADIAN SYLLABICS T': 5222,
'CANADIAN SYLLABICS TA': 5205,
'CANADIAN SYLLABICS TAA': 5206,
'CANADIAN SYLLABICS TAAI': 5197,
'CANADIAN SYLLABICS TE': 5196,
'CANADIAN SYLLABICS TH': 5482,
'CANADIAN SYLLABICS TH-CREE TH': 5550,
'CANADIAN SYLLABICS TH-CREE THA': 5548,
'CANADIAN SYLLABICS TH-CREE THAA': 5549,
'CANADIAN SYLLABICS TH-CREE THE': 5543,
'CANADIAN SYLLABICS TH-CREE THI': 5544,
'CANADIAN SYLLABICS TH-CREE THII': 5545,
'CANADIAN SYLLABICS TH-CREE THO': 5546,
'CANADIAN SYLLABICS TH-CREE THOO': 5547,
'CANADIAN SYLLABICS THA': 5478,
'CANADIAN SYLLABICS THAA': 5479,
'CANADIAN SYLLABICS THE': 5470,
'CANADIAN SYLLABICS THI': 5472,
'CANADIAN SYLLABICS THII': 5474,
'CANADIAN SYLLABICS THO': 5476,
'CANADIAN SYLLABICS THOO': 5477,
'CANADIAN SYLLABICS THWAA': 5480,
'CANADIAN SYLLABICS TI': 5198,
'CANADIAN SYLLABICS TII': 5199,
'CANADIAN SYLLABICS TLHA': 5513,
'CANADIAN SYLLABICS TLHE': 5510,
'CANADIAN SYLLABICS TLHI': 5511,
'CANADIAN SYLLABICS TLHO': 5512,
'CANADIAN SYLLABICS TO': 5200,
'CANADIAN SYLLABICS TOO': 5201,
'CANADIAN SYLLABICS TTA': 5226,
'CANADIAN SYLLABICS TTE': 5223,
'CANADIAN SYLLABICS TTH': 5487,
'CANADIAN SYLLABICS TTHA': 5486,
'CANADIAN SYLLABICS TTHE': 5483,
'CANADIAN SYLLABICS TTHI': 5484,
'CANADIAN SYLLABICS TTHO': 5485,
'CANADIAN SYLLABICS TTI': 5224,
'CANADIAN SYLLABICS TTO': 5225,
'CANADIAN SYLLABICS TWA': 5217,
'CANADIAN SYLLABICS TWAA': 5219,
'CANADIAN SYLLABICS TWE': 5207,
'CANADIAN SYLLABICS TWI': 5209,
'CANADIAN SYLLABICS TWII': 5211,
'CANADIAN SYLLABICS TWO': 5213,
'CANADIAN SYLLABICS TWOO': 5215,
'CANADIAN SYLLABICS TYA': 5491,
'CANADIAN SYLLABICS TYE': 5488,
'CANADIAN SYLLABICS TYI': 5489,
'CANADIAN SYLLABICS TYO': 5490,
'CANADIAN SYLLABICS WA': 5143,
'CANADIAN SYLLABICS WAA': 5145,
'CANADIAN SYLLABICS WE': 5132,
'CANADIAN SYLLABICS WEST-CREE CWA': 5277,
'CANADIAN SYLLABICS WEST-CREE CWAA': 5279,
'CANADIAN SYLLABICS WEST-CREE CWE': 5267,
'CANADIAN SYLLABICS WEST-CREE CWI': 5269,
'CANADIAN SYLLABICS WEST-CREE CWII': 5271,
'CANADIAN SYLLABICS WEST-CREE CWO': 5273,
'CANADIAN SYLLABICS WEST-CREE CWOO': 5275,
'CANADIAN SYLLABICS WEST-CREE FWAA': 5468,
'CANADIAN SYLLABICS WEST-CREE KWA': 5247,
'CANADIAN SYLLABICS WEST-CREE KWAA': 5249,
'CANADIAN SYLLABICS WEST-CREE KWE': 5237,
'CANADIAN SYLLABICS WEST-CREE KWI': 5239,
'CANADIAN SYLLABICS WEST-CREE KWII': 5241,
'CANADIAN SYLLABICS WEST-CREE KWO': 5243,
'CANADIAN SYLLABICS WEST-CREE KWOO': 5245,
'CANADIAN SYLLABICS WEST-CREE L': 5355,
'CANADIAN SYLLABICS WEST-CREE LA': 5453,
'CANADIAN SYLLABICS WEST-CREE LE': 5444,
'CANADIAN SYLLABICS WEST-CREE LO': 5450,
'CANADIAN SYLLABICS WEST-CREE LWA': 5351,
'CANADIAN SYLLABICS WEST-CREE LWAA': 5353,
'CANADIAN SYLLABICS WEST-CREE LWE': 5341,
'CANADIAN SYLLABICS WEST-CREE LWI': 5343,
'CANADIAN SYLLABICS WEST-CREE LWII': 5345,
'CANADIAN SYLLABICS WEST-CREE LWO': 5347,
'CANADIAN SYLLABICS WEST-CREE LWOO': 5349,
'CANADIAN SYLLABICS WEST-CREE M': 5308,
'CANADIAN SYLLABICS WEST-CREE MWA': 5303,
'CANADIAN SYLLABICS WEST-CREE MWAA': 5305,
'CANADIAN SYLLABICS WEST-CREE MWE': 5293,
'CANADIAN SYLLABICS WEST-CREE MWI': 5295,
'CANADIAN SYLLABICS WEST-CREE MWII': 5297,
'CANADIAN SYLLABICS WEST-CREE MWO': 5299,
'CANADIAN SYLLABICS WEST-CREE MWOO': 5301,
'CANADIAN SYLLABICS WEST-CREE NWA': 5324,
'CANADIAN SYLLABICS WEST-CREE NWAA': 5326,
'CANADIAN SYLLABICS WEST-CREE NWE': 5322,
'CANADIAN SYLLABICS WEST-CREE P': 5194,
'CANADIAN SYLLABICS WEST-CREE PWA': 5189,
'CANADIAN SYLLABICS WEST-CREE PWAA': 5191,
'CANADIAN SYLLABICS WEST-CREE PWE': 5179,
'CANADIAN SYLLABICS WEST-CREE PWI': 5181,
'CANADIAN SYLLABICS WEST-CREE PWII': 5183,
'CANADIAN SYLLABICS WEST-CREE PWO': 5185,
'CANADIAN SYLLABICS WEST-CREE PWOO': 5187,
'CANADIAN SYLLABICS WEST-CREE R': 5457,
'CANADIAN SYLLABICS WEST-CREE RA': 5517,
'CANADIAN SYLLABICS WEST-CREE RE': 5514,
'CANADIAN SYLLABICS WEST-CREE RI': 5515,
'CANADIAN SYLLABICS WEST-CREE RO': 5516,
'CANADIAN SYLLABICS WEST-CREE RWAA': 5455,
'CANADIAN SYLLABICS WEST-CREE SHWA': 5410,
'CANADIAN SYLLABICS WEST-CREE SHWAA': 5412,
'CANADIAN SYLLABICS WEST-CREE SHWE': 5400,
'CANADIAN SYLLABICS WEST-CREE SHWI': 5402,
'CANADIAN SYLLABICS WEST-CREE SHWII': 5404,
'CANADIAN SYLLABICS WEST-CREE SHWO': 5406,
'CANADIAN SYLLABICS WEST-CREE SHWOO': 5408,
'CANADIAN SYLLABICS WEST-CREE SWA': 5377,
'CANADIAN SYLLABICS WEST-CREE SWAA': 5379,
'CANADIAN SYLLABICS WEST-CREE SWE': 5367,
'CANADIAN SYLLABICS WEST-CREE SWI': 5369,
'CANADIAN SYLLABICS WEST-CREE SWII': 5371,
'CANADIAN SYLLABICS WEST-CREE SWO': 5373,
'CANADIAN SYLLABICS WEST-CREE SWOO': 5375,
'CANADIAN SYLLABICS WEST-CREE THWAA': 5481,
'CANADIAN SYLLABICS WEST-CREE TWA': 5218,
'CANADIAN SYLLABICS WEST-CREE TWAA': 5220,
'CANADIAN SYLLABICS WEST-CREE TWE': 5208,
'CANADIAN SYLLABICS WEST-CREE TWI': 5210,
'CANADIAN SYLLABICS WEST-CREE TWII': 5212,
'CANADIAN SYLLABICS WEST-CREE TWO': 5214,
'CANADIAN SYLLABICS WEST-CREE TWOO': 5216,
'CANADIAN SYLLABICS WEST-CREE WA': 5144,
'CANADIAN SYLLABICS WEST-CREE WAA': 5146,
'CANADIAN SYLLABICS WEST-CREE WE': 5133,
'CANADIAN SYLLABICS WEST-CREE WI': 5135,
'CANADIAN SYLLABICS WEST-CREE WII': 5137,
'CANADIAN SYLLABICS WEST-CREE WO': 5139,
'CANADIAN SYLLABICS WEST-CREE WOO': 5141,
'CANADIAN SYLLABICS WEST-CREE Y': 5440,
'CANADIAN SYLLABICS WEST-CREE YWA': 5434,
'CANADIAN SYLLABICS WEST-CREE YWAA': 5436,
'CANADIAN SYLLABICS WEST-CREE YWE': 5424,
'CANADIAN SYLLABICS WEST-CREE YWI': 5426,
'CANADIAN SYLLABICS WEST-CREE YWII': 5428,
'CANADIAN SYLLABICS WEST-CREE YWO': 5430,
'CANADIAN SYLLABICS WEST-CREE YWOO': 5432,
'CANADIAN SYLLABICS WI': 5134,
'CANADIAN SYLLABICS WII': 5136,
'CANADIAN SYLLABICS WO': 5138,
'CANADIAN SYLLABICS WOO': 5140,
'CANADIAN SYLLABICS WOODS-CREE TH': 5535,
'CANADIAN SYLLABICS WOODS-CREE THA': 5534,
'CANADIAN SYLLABICS WOODS-CREE THE': 5531,
'CANADIAN SYLLABICS WOODS-CREE THI': 5532,
'CANADIAN SYLLABICS WOODS-CREE THO': 5533,
'CANADIAN SYLLABICS Y': 5438,
'CANADIAN SYLLABICS Y-CREE COO': 5263,
'CANADIAN SYLLABICS Y-CREE KOO': 5233,
'CANADIAN SYLLABICS Y-CREE LOO': 5337,
'CANADIAN SYLLABICS Y-CREE MOO': 5289,
'CANADIAN SYLLABICS Y-CREE NOO': 5318,
'CANADIAN SYLLABICS Y-CREE OO': 5127,
'CANADIAN SYLLABICS Y-CREE POO': 5173,
'CANADIAN SYLLABICS Y-CREE PWAA': 5192,
'CANADIAN SYLLABICS Y-CREE SOO': 5363,
'CANADIAN SYLLABICS Y-CREE TOO': 5202,
'CANADIAN SYLLABICS Y-CREE W': 5149,
'CANADIAN SYLLABICS Y-CREE YOO': 5420,
'CANADIAN SYLLABICS YA': 5421,
'CANADIAN SYLLABICS YAA': 5422,
'CANADIAN SYLLABICS YAAI': 5415,
'CANADIAN SYLLABICS YE': 5414,
'CANADIAN SYLLABICS YI': 5416,
'CANADIAN SYLLABICS YII': 5417,
'CANADIAN SYLLABICS YO': 5418,
'CANADIAN SYLLABICS YOO': 5419,
'CANADIAN SYLLABICS YWA': 5433,
'CANADIAN SYLLABICS YWAA': 5435,
'CANADIAN SYLLABICS YWE': 5423,
'CANADIAN SYLLABICS YWI': 5425,
'CANADIAN SYLLABICS YWII': 5427,
'CANADIAN SYLLABICS YWO': 5429,
'CANADIAN SYLLABICS YWOO': 5431,
'CANCEL TAG': 917631,
'CANCER': 9803,
'CAPRICORN': 9809,
'CARE OF': 8453,
'CARET': 8248,
'CARET INSERTION POINT': 8257,
'CARON': 711,
'CAUTION SIGN': 9761,
'CEDILLA': 184,
'CENT SIGN': 162,
'CENTRE LINE SYMBOL': 8452,
'CENTRELINE LOW LINE': 65102,
'CENTRELINE OVERLINE': 65098,
'CHARACTER TIE': 8256,
'CHECK MARK': 10003,
'CHEROKEE LETTER A': 5024,
'CHEROKEE LETTER DA': 5075,
'CHEROKEE LETTER DE': 5077,
'CHEROKEE LETTER DI': 5079,
'CHEROKEE LETTER DLA': 5084,
'CHEROKEE LETTER DO': 5081,
'CHEROKEE LETTER DU': 5082,
'CHEROKEE LETTER DV': 5083,
'CHEROKEE LETTER E': 5025,
'CHEROKEE LETTER GA': 5030,
'CHEROKEE LETTER GE': 5032,
'CHEROKEE LETTER GI': 5033,
'CHEROKEE LETTER GO': 5034,
'CHEROKEE LETTER GU': 5035,
'CHEROKEE LETTER GV': 5036,
'CHEROKEE LETTER HA': 5037,
'CHEROKEE LETTER HE': 5038,
'CHEROKEE LETTER HI': 5039,
'CHEROKEE LETTER HNA': 5055,
'CHEROKEE LETTER HO': 5040,
'CHEROKEE LETTER HU': 5041,
'CHEROKEE LETTER HV': 5042,
'CHEROKEE LETTER I': 5026,
'CHEROKEE LETTER KA': 5031,
'CHEROKEE LETTER LA': 5043,
'CHEROKEE LETTER LE': 5044,
'CHEROKEE LETTER LI': 5045,
'CHEROKEE LETTER LO': 5046,
'CHEROKEE LETTER LU': 5047,
'CHEROKEE LETTER LV': 5048,
'CHEROKEE LETTER MA': 5049,
'CHEROKEE LETTER ME': 5050,
'CHEROKEE LETTER MI': 5051,
'CHEROKEE LETTER MO': 5052,
'CHEROKEE LETTER MU': 5053,
'CHEROKEE LETTER NA': 5054,
'CHEROKEE LETTER NAH': 5056,
'CHEROKEE LETTER NE': 5057,
'CHEROKEE LETTER NI': 5058,
'CHEROKEE LETTER NO': 5059,
'CHEROKEE LETTER NU': 5060,
'CHEROKEE LETTER NV': 5061,
'CHEROKEE LETTER O': 5027,
'CHEROKEE LETTER QUA': 5062,
'CHEROKEE LETTER QUE': 5063,
'CHEROKEE LETTER QUI': 5064,
'CHEROKEE LETTER QUO': 5065,
'CHEROKEE LETTER QUU': 5066,
'CHEROKEE LETTER QUV': 5067,
'CHEROKEE LETTER S': 5069,
'CHEROKEE LETTER SA': 5068,
'CHEROKEE LETTER SE': 5070,
'CHEROKEE LETTER SI': 5071,
'CHEROKEE LETTER SO': 5072,
'CHEROKEE LETTER SU': 5073,
'CHEROKEE LETTER SV': 5074,
'CHEROKEE LETTER TA': 5076,
'CHEROKEE LETTER TE': 5078,
'CHEROKEE LETTER TI': 5080,
'CHEROKEE LETTER TLA': 5085,
'CHEROKEE LETTER TLE': 5086,
'CHEROKEE LETTER TLI': 5087,
'CHEROKEE LETTER TLO': 5088,
'CHEROKEE LETTER TLU': 5089,
'CHEROKEE LETTER TLV': 5090,
'CHEROKEE LETTER TSA': 5091,
'CHEROKEE LETTER TSE': 5092,
'CHEROKEE LETTER TSI': 5093,
'CHEROKEE LETTER TSO': 5094,
'CHEROKEE LETTER TSU': 5095,
'CHEROKEE LETTER TSV': 5096,
'CHEROKEE LETTER U': 5028,
'CHEROKEE LETTER V': 5029,
'CHEROKEE LETTER WA': 5097,
'CHEROKEE LETTER WE': 5098,
'CHEROKEE LETTER WI': 5099,
'CHEROKEE LETTER WO': 5100,
'CHEROKEE LETTER WU': 5101,
'CHEROKEE LETTER WV': 5102,
'CHEROKEE LETTER YA': 5103,
'CHEROKEE LETTER YE': 5104,
'CHEROKEE LETTER YI': 5105,
'CHEROKEE LETTER YO': 5106,
'CHEROKEE LETTER YU': 5107,
'CHEROKEE LETTER YV': 5108,
'CHI RHO': 9767,
'CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR': 10682,
'CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK': 9685,
'CIRCLE WITH HORIZONTAL BAR': 10677,
'CIRCLE WITH LEFT HALF BLACK': 9680,
'CIRCLE WITH LOWER HALF BLACK': 9682,
'CIRCLE WITH RIGHT HALF BLACK': 9681,
'CIRCLE WITH SMALL CIRCLE TO THE RIGHT': 10690,
'CIRCLE WITH SUPERIMPOSED X': 10683,
'CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT': 10691,
'CIRCLE WITH UPPER HALF BLACK': 9683,
'CIRCLE WITH UPPER RIGHT QUADRANT BLACK': 9684,
'CIRCLE WITH VERTICAL FILL': 9677,
'CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN': 10684,
'CIRCLED ASTERISK OPERATOR': 8859,
'CIRCLED BULLET': 10687,
'CIRCLED DASH': 8861,
'CIRCLED DIGIT EIGHT': 9319,
'CIRCLED DIGIT FIVE': 9316,
'CIRCLED DIGIT FOUR': 9315,
'CIRCLED DIGIT NINE': 9320,
'CIRCLED DIGIT ONE': 9312,
'CIRCLED DIGIT SEVEN': 9318,
'CIRCLED DIGIT SIX': 9317,
'CIRCLED DIGIT THREE': 9314,
'CIRCLED DIGIT TWO': 9313,
'CIRCLED DIGIT ZERO': 9450,
'CIRCLED DIVISION SIGN': 10808,
'CIRCLED DIVISION SLASH': 8856,
'CIRCLED DOT OPERATOR': 8857,
'CIRCLED EQUALS': 8860,
'CIRCLED GREATER-THAN': 10689,
'CIRCLED HANGUL CHIEUCH': 12905,
'CIRCLED HANGUL CHIEUCH A': 12919,
'CIRCLED HANGUL CIEUC': 12904,
'CIRCLED HANGUL CIEUC A': 12918,
'CIRCLED HANGUL HIEUH': 12909,
'CIRCLED HANGUL HIEUH A': 12923,
'CIRCLED HANGUL IEUNG': 12903,
'CIRCLED HANGUL IEUNG A': 12917,
'CIRCLED HANGUL KHIEUKH': 12906,
'CIRCLED HANGUL KHIEUKH A': 12920,
'CIRCLED HANGUL KIYEOK': 12896,
'CIRCLED HANGUL KIYEOK A': 12910,
'CIRCLED HANGUL MIEUM': 12900,
'CIRCLED HANGUL MIEUM A': 12914,
'CIRCLED HANGUL NIEUN': 12897,
'CIRCLED HANGUL NIEUN A': 12911,
'CIRCLED HANGUL PHIEUPH': 12908,
'CIRCLED HANGUL PHIEUPH A': 12922,
'CIRCLED HANGUL PIEUP': 12901,
'CIRCLED HANGUL PIEUP A': 12915,
'CIRCLED HANGUL RIEUL': 12899,
'CIRCLED HANGUL RIEUL A': 12913,
'CIRCLED HANGUL SIOS': 12902,
'CIRCLED HANGUL SIOS A': 12916,
'CIRCLED HANGUL THIEUTH': 12907,
'CIRCLED HANGUL THIEUTH A': 12921,
'CIRCLED HANGUL TIKEUT': 12898,
'CIRCLED HANGUL TIKEUT A': 12912,
'CIRCLED HEAVY WHITE RIGHTWARDS ARROW': 10162,
'CIRCLED HORIZONTAL BAR WITH NOTCH': 9097,
'CIRCLED IDEOGRAPH ALLIANCE': 12975,
'CIRCLED IDEOGRAPH ATTENTION': 12959,
'CIRCLED IDEOGRAPH CENTRE': 12965,
'CIRCLED IDEOGRAPH CONGRATULATION': 12951,
'CIRCLED IDEOGRAPH COPY': 12962,
'CIRCLED IDEOGRAPH CORRECT': 12963,
'CIRCLED IDEOGRAPH EARTH': 12943,
'CIRCLED IDEOGRAPH EIGHT': 12935,
'CIRCLED IDEOGRAPH ENTERPRISE': 12973,
'CIRCLED IDEOGRAPH EXCELLENT': 12957,
'CIRCLED IDEOGRAPH FEMALE': 12955,
'CIRCLED IDEOGRAPH FINANCIAL': 12950,
'CIRCLED IDEOGRAPH FIRE': 12939,
'CIRCLED IDEOGRAPH FIVE': 12932,
'CIRCLED IDEOGRAPH FOUR': 12931,
'CIRCLED IDEOGRAPH HAVE': 12946,
'CIRCLED IDEOGRAPH HIGH': 12964,
'CIRCLED IDEOGRAPH ITEM': 12960,
'CIRCLED IDEOGRAPH LABOR': 12952,
'CIRCLED IDEOGRAPH LEFT': 12967,
'CIRCLED IDEOGRAPH LOW': 12966,
'CIRCLED IDEOGRAPH MALE': 12954,
'CIRCLED IDEOGRAPH MEDICINE': 12969,
'CIRCLED IDEOGRAPH METAL': 12942,
'CIRCLED IDEOGRAPH MOON': 12938,
'CIRCLED IDEOGRAPH NAME': 12948,
'CIRCLED IDEOGRAPH NIGHT': 12976,
'CIRCLED IDEOGRAPH NINE': 12936,
'CIRCLED IDEOGRAPH ONE': 12928,
'CIRCLED IDEOGRAPH PRINT': 12958,
'CIRCLED IDEOGRAPH RELIGION': 12970,
'CIRCLED IDEOGRAPH RESOURCE': 12974,
'CIRCLED IDEOGRAPH REST': 12961,
'CIRCLED IDEOGRAPH RIGHT': 12968,
'CIRCLED IDEOGRAPH SECRET': 12953,
'CIRCLED IDEOGRAPH SEVEN': 12934,
'CIRCLED IDEOGRAPH SIX': 12933,
'CIRCLED IDEOGRAPH SOCIETY': 12947,
'CIRCLED IDEOGRAPH SPECIAL': 12949,
'CIRCLED IDEOGRAPH STOCK': 12945,
'CIRCLED IDEOGRAPH STUDY': 12971,
'CIRCLED IDEOGRAPH SUITABLE': 12956,
'CIRCLED IDEOGRAPH SUN': 12944,
'CIRCLED IDEOGRAPH SUPERVISE': 12972,
'CIRCLED IDEOGRAPH TEN': 12937,
'CIRCLED IDEOGRAPH THREE': 12930,
'CIRCLED IDEOGRAPH TWO': 12929,
'CIRCLED IDEOGRAPH WATER': 12940,
'CIRCLED IDEOGRAPH WOOD': 12941,
'CIRCLED KATAKANA A': 13008,
'CIRCLED KATAKANA E': 13011,
'CIRCLED KATAKANA HA': 13033,
'CIRCLED KATAKANA HE': 13036,
'CIRCLED KATAKANA HI': 13034,
'CIRCLED KATAKANA HO': 13037,
'CIRCLED KATAKANA HU': 13035,
'CIRCLED KATAKANA I': 13009,
'CIRCLED KATAKANA KA': 13013,
'CIRCLED KATAKANA KE': 13016,
'CIRCLED KATAKANA KI': 13014,
'CIRCLED KATAKANA KO': 13017,
'CIRCLED KATAKANA KU': 13015,
'CIRCLED KATAKANA MA': 13038,
'CIRCLED KATAKANA ME': 13041,
'CIRCLED KATAKANA MI': 13039,
'CIRCLED KATAKANA MO': 13042,
'CIRCLED KATAKANA MU': 13040,
'CIRCLED KATAKANA NA': 13028,
'CIRCLED KATAKANA NE': 13031,
'CIRCLED KATAKANA NI': 13029,
'CIRCLED KATAKANA NO': 13032,
'CIRCLED KATAKANA NU': 13030,
'CIRCLED KATAKANA O': 13012,
'CIRCLED KATAKANA RA': 13046,
'CIRCLED KATAKANA RE': 13049,
'CIRCLED KATAKANA RI': 13047,
'CIRCLED KATAKANA RO': 13050,
'CIRCLED KATAKANA RU': 13048,
'CIRCLED KATAKANA SA': 13018,
'CIRCLED KATAKANA SE': 13021,
'CIRCLED KATAKANA SI': 13019,
'CIRCLED KATAKANA SO': 13022,
'CIRCLED KATAKANA SU': 13020,
'CIRCLED KATAKANA TA': 13023,
'CIRCLED KATAKANA TE': 13026,
'CIRCLED KATAKANA TI': 13024,
'CIRCLED KATAKANA TO': 13027,
'CIRCLED KATAKANA TU': 13025,
'CIRCLED KATAKANA U': 13010,
'CIRCLED KATAKANA WA': 13051,
'CIRCLED KATAKANA WE': 13053,
'CIRCLED KATAKANA WI': 13052,
'CIRCLED KATAKANA WO': 13054,
'CIRCLED KATAKANA YA': 13043,
'CIRCLED KATAKANA YO': 13045,
'CIRCLED KATAKANA YU': 13044,
'CIRCLED LATIN CAPITAL LETTER A': 9398,
'CIRCLED LATIN CAPITAL LETTER B': 9399,
'CIRCLED LATIN CAPITAL LETTER C': 9400,
'CIRCLED LATIN CAPITAL LETTER D': 9401,
'CIRCLED LATIN CAPITAL LETTER E': 9402,
'CIRCLED LATIN CAPITAL LETTER F': 9403,
'CIRCLED LATIN CAPITAL LETTER G': 9404,
'CIRCLED LATIN CAPITAL LETTER H': 9405,
'CIRCLED LATIN CAPITAL LETTER I': 9406,
'CIRCLED LATIN CAPITAL LETTER J': 9407,
'CIRCLED LATIN CAPITAL LETTER K': 9408,
'CIRCLED LATIN CAPITAL LETTER L': 9409,
'CIRCLED LATIN CAPITAL LETTER M': 9410,
'CIRCLED LATIN CAPITAL LETTER N': 9411,
'CIRCLED LATIN CAPITAL LETTER O': 9412,
'CIRCLED LATIN CAPITAL LETTER P': 9413,
'CIRCLED LATIN CAPITAL LETTER Q': 9414,
'CIRCLED LATIN CAPITAL LETTER R': 9415,
'CIRCLED LATIN CAPITAL LETTER S': 9416,
'CIRCLED LATIN CAPITAL LETTER T': 9417,
'CIRCLED LATIN CAPITAL LETTER U': 9418,
'CIRCLED LATIN CAPITAL LETTER V': 9419,
'CIRCLED LATIN CAPITAL LETTER W': 9420,
'CIRCLED LATIN CAPITAL LETTER X': 9421,
'CIRCLED LATIN CAPITAL LETTER Y': 9422,
'CIRCLED LATIN CAPITAL LETTER Z': 9423,
'CIRCLED LATIN SMALL LETTER A': 9424,
'CIRCLED LATIN SMALL LETTER B': 9425,
'CIRCLED LATIN SMALL LETTER C': 9426,
'CIRCLED LATIN SMALL LETTER D': 9427,
'CIRCLED LATIN SMALL LETTER E': 9428,
'CIRCLED LATIN SMALL LETTER F': 9429,
'CIRCLED LATIN SMALL LETTER G': 9430,
'CIRCLED LATIN SMALL LETTER H': 9431,
'CIRCLED LATIN SMALL LETTER I': 9432,
'CIRCLED LATIN SMALL LETTER J': 9433,
'CIRCLED LATIN SMALL LETTER K': 9434,
'CIRCLED LATIN SMALL LETTER L': 9435,
'CIRCLED LATIN SMALL LETTER M': 9436,
'CIRCLED LATIN SMALL LETTER N': 9437,
'CIRCLED LATIN SMALL LETTER O': 9438,
'CIRCLED LATIN SMALL LETTER P': 9439,
'CIRCLED LATIN SMALL LETTER Q': 9440,
'CIRCLED LATIN SMALL LETTER R': 9441,
'CIRCLED LATIN SMALL LETTER S': 9442,
'CIRCLED LATIN SMALL LETTER T': 9443,
'CIRCLED LATIN SMALL LETTER U': 9444,
'CIRCLED LATIN SMALL LETTER V': 9445,
'CIRCLED LATIN SMALL LETTER W': 9446,
'CIRCLED LATIN SMALL LETTER X': 9447,
'CIRCLED LATIN SMALL LETTER Y': 9448,
'CIRCLED LATIN SMALL LETTER Z': 9449,
'CIRCLED LESS-THAN': 10688,
'CIRCLED MINUS': 8854,
'CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT': 10806,
'CIRCLED NUMBER EIGHTEEN': 9329,
'CIRCLED NUMBER ELEVEN': 9322,
'CIRCLED NUMBER FIFTEEN': 9326,
'CIRCLED NUMBER FIFTY': 12991,
'CIRCLED NUMBER FORTY': 12981,
'CIRCLED NUMBER FORTY EIGHT': 12989,
'CIRCLED NUMBER FORTY FIVE': 12986,
'CIRCLED NUMBER FORTY FOUR': 12985,
'CIRCLED NUMBER FORTY NINE': 12990,
'CIRCLED NUMBER FORTY ONE': 12982,
'CIRCLED NUMBER FORTY SEVEN': 12988,
'CIRCLED NUMBER FORTY SIX': 12987,
'CIRCLED NUMBER FORTY THREE': 12984,
'CIRCLED NUMBER FORTY TWO': 12983,
'CIRCLED NUMBER FOURTEEN': 9325,
'CIRCLED NUMBER NINETEEN': 9330,
'CIRCLED NUMBER SEVENTEEN': 9328,
'CIRCLED NUMBER SIXTEEN': 9327,
'CIRCLED NUMBER TEN': 9321,
'CIRCLED NUMBER THIRTEEN': 9324,
'CIRCLED NUMBER THIRTY': 12890,
'CIRCLED NUMBER THIRTY EIGHT': 12979,
'CIRCLED NUMBER THIRTY FIVE': 12895,
'CIRCLED NUMBER THIRTY FOUR': 12894,
'CIRCLED NUMBER THIRTY NINE': 12980,
'CIRCLED NUMBER THIRTY ONE': 12891,
'CIRCLED NUMBER THIRTY SEVEN': 12978,
'CIRCLED NUMBER THIRTY SIX': 12977,
'CIRCLED NUMBER THIRTY THREE': 12893,
'CIRCLED NUMBER THIRTY TWO': 12892,
'CIRCLED NUMBER TWELVE': 9323,
'CIRCLED NUMBER TWENTY': 9331,
'CIRCLED NUMBER TWENTY EIGHT': 12888,
'CIRCLED NUMBER TWENTY FIVE': 12885,
'CIRCLED NUMBER TWENTY FOUR': 12884,
'CIRCLED NUMBER TWENTY NINE': 12889,
'CIRCLED NUMBER TWENTY ONE': 12881,
'CIRCLED NUMBER TWENTY SEVEN': 12887,
'CIRCLED NUMBER TWENTY SIX': 12886,
'CIRCLED NUMBER TWENTY THREE': 12883,
'CIRCLED NUMBER TWENTY TWO': 12882,
'CIRCLED OPEN CENTRE EIGHT POINTED STAR': 10050,
'CIRCLED PARALLEL': 10679,
'CIRCLED PERPENDICULAR': 10681,
'CIRCLED PLUS': 8853,
'CIRCLED POSTAL MARK': 12342,
'CIRCLED REVERSE SOLIDUS': 10680,
'CIRCLED RING OPERATOR': 8858,
'CIRCLED TIMES': 8855,
'CIRCLED TRIANGLE DOWN': 9098,
'CIRCLED VERTICAL BAR': 10678,
'CIRCLED WHITE BULLET': 10686,
'CIRCLED WHITE STAR': 10026,
'CIRCULATION FUNCTION': 10768,
'CIRCUMFLEX ACCENT': 94,
'CJK COMPATIBILITY IDEOGRAPH-2F800': 194560,
'CJK COMPATIBILITY IDEOGRAPH-2F801': 194561,
'CJK COMPATIBILITY IDEOGRAPH-2F802': 194562,
'CJK COMPATIBILITY IDEOGRAPH-2F803': 194563,
'CJK COMPATIBILITY IDEOGRAPH-2F804': 194564,
'CJK COMPATIBILITY IDEOGRAPH-2F805': 194565,
'CJK COMPATIBILITY IDEOGRAPH-2F806': 194566,
'CJK COMPATIBILITY IDEOGRAPH-2F807': 194567,
'CJK COMPATIBILITY IDEOGRAPH-2F808': 194568,
'CJK COMPATIBILITY IDEOGRAPH-2F809': 194569,
'CJK COMPATIBILITY IDEOGRAPH-2F80A': 194570,
'CJK COMPATIBILITY IDEOGRAPH-2F80B': 194571,
'CJK COMPATIBILITY IDEOGRAPH-2F80C': 194572,
'CJK COMPATIBILITY IDEOGRAPH-2F80D': 194573,
'CJK COMPATIBILITY IDEOGRAPH-2F80E': 194574,
'CJK COMPATIBILITY IDEOGRAPH-2F80F': 194575,
'CJK COMPATIBILITY IDEOGRAPH-2F810': 194576,
'CJK COMPATIBILITY IDEOGRAPH-2F811': 194577,
'CJK COMPATIBILITY IDEOGRAPH-2F812': 194578,
'CJK COMPATIBILITY IDEOGRAPH-2F813': 194579,
'CJK COMPATIBILITY IDEOGRAPH-2F814': 194580,
'CJK COMPATIBILITY IDEOGRAPH-2F815': 194581,
'CJK COMPATIBILITY IDEOGRAPH-2F816': 194582,
'CJK COMPATIBILITY IDEOGRAPH-2F817': 194583,
'CJK COMPATIBILITY IDEOGRAPH-2F818': 194584,
'CJK COMPATIBILITY IDEOGRAPH-2F819': 194585,
'CJK COMPATIBILITY IDEOGRAPH-2F81A': 194586,
'CJK COMPATIBILITY IDEOGRAPH-2F81B': 194587,
'CJK COMPATIBILITY IDEOGRAPH-2F81C': 194588,
'CJK COMPATIBILITY IDEOGRAPH-2F81D': 194589,
'CJK COMPATIBILITY IDEOGRAPH-2F81E': 194590,
'CJK COMPATIBILITY IDEOGRAPH-2F81F': 194591,
'CJK COMPATIBILITY IDEOGRAPH-2F820': 194592,
'CJK COMPATIBILITY IDEOGRAPH-2F821': 194593,
'CJK COMPATIBILITY IDEOGRAPH-2F822': 194594,
'CJK COMPATIBILITY IDEOGRAPH-2F823': 194595,
'CJK COMPATIBILITY IDEOGRAPH-2F824': 194596,
'CJK COMPATIBILITY IDEOGRAPH-2F825': 194597,
'CJK COMPATIBILITY IDEOGRAPH-2F826': 194598,
'CJK COMPATIBILITY IDEOGRAPH-2F827': 194599,
'CJK COMPATIBILITY IDEOGRAPH-2F828': 194600,
'CJK COMPATIBILITY IDEOGRAPH-2F829': 194601,
'CJK COMPATIBILITY IDEOGRAPH-2F82A': 194602,
'CJK COMPATIBILITY IDEOGRAPH-2F82B': 194603,
'CJK COMPATIBILITY IDEOGRAPH-2F82C': 194604,
'CJK COMPATIBILITY IDEOGRAPH-2F82D': 194605,
'CJK COMPATIBILITY IDEOGRAPH-2F82E': 194606,
'CJK COMPATIBILITY IDEOGRAPH-2F82F': 194607,
'CJK COMPATIBILITY IDEOGRAPH-2F830': 194608,
'CJK COMPATIBILITY IDEOGRAPH-2F831': 194609,
'CJK COMPATIBILITY IDEOGRAPH-2F832': 194610,
'CJK COMPATIBILITY IDEOGRAPH-2F833': 194611,
'CJK COMPATIBILITY IDEOGRAPH-2F834': 194612,
'CJK COMPATIBILITY IDEOGRAPH-2F835': 194613,
'CJK COMPATIBILITY IDEOGRAPH-2F836': 194614,
'CJK COMPATIBILITY IDEOGRAPH-2F837': 194615,
'CJK COMPATIBILITY IDEOGRAPH-2F838': 194616,
'CJK COMPATIBILITY IDEOGRAPH-2F839': 194617,
'CJK COMPATIBILITY IDEOGRAPH-2F83A': 194618,
'CJK COMPATIBILITY IDEOGRAPH-2F83B': 194619,
'CJK COMPATIBILITY IDEOGRAPH-2F83C': 194620,
'CJK COMPATIBILITY IDEOGRAPH-2F83D': 194621,
'CJK COMPATIBILITY IDEOGRAPH-2F83E': 194622,
'CJK COMPATIBILITY IDEOGRAPH-2F83F': 194623,
'CJK COMPATIBILITY IDEOGRAPH-2F840': 194624,
'CJK COMPATIBILITY IDEOGRAPH-2F841': 194625,
'CJK COMPATIBILITY IDEOGRAPH-2F842': 194626,
'CJK COMPATIBILITY IDEOGRAPH-2F843': 194627,
'CJK COMPATIBILITY IDEOGRAPH-2F844': 194628,
'CJK COMPATIBILITY IDEOGRAPH-2F845': 194629,
'CJK COMPATIBILITY IDEOGRAPH-2F846': 194630,
'CJK COMPATIBILITY IDEOGRAPH-2F847': 194631,
'CJK COMPATIBILITY IDEOGRAPH-2F848': 194632,
'CJK COMPATIBILITY IDEOGRAPH-2F849': 194633,
'CJK COMPATIBILITY IDEOGRAPH-2F84A': 194634,
'CJK COMPATIBILITY IDEOGRAPH-2F84B': 194635,
'CJK COMPATIBILITY IDEOGRAPH-2F84C': 194636,
'CJK COMPATIBILITY IDEOGRAPH-2F84D': 194637,
'CJK COMPATIBILITY IDEOGRAPH-2F84E': 194638,
'CJK COMPATIBILITY IDEOGRAPH-2F84F': 194639,
'CJK COMPATIBILITY IDEOGRAPH-2F850': 194640,
'CJK COMPATIBILITY IDEOGRAPH-2F851': 194641,
'CJK COMPATIBILITY IDEOGRAPH-2F852': 194642,
'CJK COMPATIBILITY IDEOGRAPH-2F853': 194643,
'CJK COMPATIBILITY IDEOGRAPH-2F854': 194644,
'CJK COMPATIBILITY IDEOGRAPH-2F855': 194645,
'CJK COMPATIBILITY IDEOGRAPH-2F856': 194646,
'CJK COMPATIBILITY IDEOGRAPH-2F857': 194647,
'CJK COMPATIBILITY IDEOGRAPH-2F858': 194648,
'CJK COMPATIBILITY IDEOGRAPH-2F859': 194649,
'CJK COMPATIBILITY IDEOGRAPH-2F85A': 194650,
'CJK COMPATIBILITY IDEOGRAPH-2F85B': 194651,
'CJK COMPATIBILITY IDEOGRAPH-2F85C': 194652,
'CJK COMPATIBILITY IDEOGRAPH-2F85D': 194653,
'CJK COMPATIBILITY IDEOGRAPH-2F85E': 194654,
'CJK COMPATIBILITY IDEOGRAPH-2F85F': 194655,
'CJK COMPATIBILITY IDEOGRAPH-2F860': 194656,
'CJK COMPATIBILITY IDEOGRAPH-2F861': 194657,
'CJK COMPATIBILITY IDEOGRAPH-2F862': 194658,
'CJK COMPATIBILITY IDEOGRAPH-2F863': 194659,
'CJK COMPATIBILITY IDEOGRAPH-2F864': 194660,
'CJK COMPATIBILITY IDEOGRAPH-2F865': 194661,
'CJK COMPATIBILITY IDEOGRAPH-2F866': 194662,
'CJK COMPATIBILITY IDEOGRAPH-2F867': 194663,
'CJK COMPATIBILITY IDEOGRAPH-2F868': 194664,
'CJK COMPATIBILITY IDEOGRAPH-2F869': 194665,
'CJK COMPATIBILITY IDEOGRAPH-2F86A': 194666,
'CJK COMPATIBILITY IDEOGRAPH-2F86B': 194667,
'CJK COMPATIBILITY IDEOGRAPH-2F86C': 194668,
'CJK COMPATIBILITY IDEOGRAPH-2F86D': 194669,
'CJK COMPATIBILITY IDEOGRAPH-2F86E': 194670,
'CJK COMPATIBILITY IDEOGRAPH-2F86F': 194671,
'CJK COMPATIBILITY IDEOGRAPH-2F870': 194672,
'CJK COMPATIBILITY IDEOGRAPH-2F871': 194673,
'CJK COMPATIBILITY IDEOGRAPH-2F872': 194674,
'CJK COMPATIBILITY IDEOGRAPH-2F873': 194675,
'CJK COMPATIBILITY IDEOGRAPH-2F874': 194676,
'CJK COMPATIBILITY IDEOGRAPH-2F875': 194677,
'CJK COMPATIBILITY IDEOGRAPH-2F876': 194678,
'CJK COMPATIBILITY IDEOGRAPH-2F877': 194679,
'CJK COMPATIBILITY IDEOGRAPH-2F878': 194680,
'CJK COMPATIBILITY IDEOGRAPH-2F879': 194681,
'CJK COMPATIBILITY IDEOGRAPH-2F87A': 194682,
'CJK COMPATIBILITY IDEOGRAPH-2F87B': 194683,
'CJK COMPATIBILITY IDEOGRAPH-2F87C': 194684,
'CJK COMPATIBILITY IDEOGRAPH-2F87D': 194685,
'CJK COMPATIBILITY IDEOGRAPH-2F87E': 194686,
'CJK COMPATIBILITY IDEOGRAPH-2F87F': 194687,
'CJK COMPATIBILITY IDEOGRAPH-2F880': 194688,
'CJK COMPATIBILITY IDEOGRAPH-2F881': 194689,
'CJK COMPATIBILITY IDEOGRAPH-2F882': 194690,
'CJK COMPATIBILITY IDEOGRAPH-2F883': 194691,
'CJK COMPATIBILITY IDEOGRAPH-2F884': 194692,
'CJK COMPATIBILITY IDEOGRAPH-2F885': 194693,
'CJK COMPATIBILITY IDEOGRAPH-2F886': 194694,
'CJK COMPATIBILITY IDEOGRAPH-2F887': 194695,
'CJK COMPATIBILITY IDEOGRAPH-2F888': 194696,
'CJK COMPATIBILITY IDEOGRAPH-2F889': 194697,
'CJK COMPATIBILITY IDEOGRAPH-2F88A': 194698,
'CJK COMPATIBILITY IDEOGRAPH-2F88B': 194699,
'CJK COMPATIBILITY IDEOGRAPH-2F88C': 194700,
'CJK COMPATIBILITY IDEOGRAPH-2F88D': 194701,
'CJK COMPATIBILITY IDEOGRAPH-2F88E': 194702,
'CJK COMPATIBILITY IDEOGRAPH-2F88F': 194703,
'CJK COMPATIBILITY IDEOGRAPH-2F890': 194704,
'CJK COMPATIBILITY IDEOGRAPH-2F891': 194705,
'CJK COMPATIBILITY IDEOGRAPH-2F892': 194706,
'CJK COMPATIBILITY IDEOGRAPH-2F893': 194707,
'CJK COMPATIBILITY IDEOGRAPH-2F894': 194708,
'CJK COMPATIBILITY IDEOGRAPH-2F895': 194709,
'CJK COMPATIBILITY IDEOGRAPH-2F896': 194710,
'CJK COMPATIBILITY IDEOGRAPH-2F897': 194711,
'CJK COMPATIBILITY IDEOGRAPH-2F898': 194712,
'CJK COMPATIBILITY IDEOGRAPH-2F899': 194713,
'CJK COMPATIBILITY IDEOGRAPH-2F89A': 194714,
'CJK COMPATIBILITY IDEOGRAPH-2F89B': 194715,
'CJK COMPATIBILITY IDEOGRAPH-2F89C': 194716,
'CJK COMPATIBILITY IDEOGRAPH-2F89D': 194717,
'CJK COMPATIBILITY IDEOGRAPH-2F89E': 194718,
'CJK COMPATIBILITY IDEOGRAPH-2F89F': 194719,
'CJK COMPATIBILITY IDEOGRAPH-2F8A0': 194720,
'CJK COMPATIBILITY IDEOGRAPH-2F8A1': 194721,
'CJK COMPATIBILITY IDEOGRAPH-2F8A2': 194722,
'CJK COMPATIBILITY IDEOGRAPH-2F8A3': 194723,
'CJK COMPATIBILITY IDEOGRAPH-2F8A4': 194724,
'CJK COMPATIBILITY IDEOGRAPH-2F8A5': 194725,
'CJK COMPATIBILITY IDEOGRAPH-2F8A6': 194726,
'CJK COMPATIBILITY IDEOGRAPH-2F8A7': 194727,
'CJK COMPATIBILITY IDEOGRAPH-2F8A8': 194728,
'CJK COMPATIBILITY IDEOGRAPH-2F8A9': 194729,
'CJK COMPATIBILITY IDEOGRAPH-2F8AA': 194730,
'CJK COMPATIBILITY IDEOGRAPH-2F8AB': 194731,
'CJK COMPATIBILITY IDEOGRAPH-2F8AC': 194732,
'CJK COMPATIBILITY IDEOGRAPH-2F8AD': 194733,
'CJK COMPATIBILITY IDEOGRAPH-2F8AE': 194734,
'CJK COMPATIBILITY IDEOGRAPH-2F8AF': 194735,
'CJK COMPATIBILITY IDEOGRAPH-2F8B0': 194736,
'CJK COMPATIBILITY IDEOGRAPH-2F8B1': 194737,
'CJK COMPATIBILITY IDEOGRAPH-2F8B2': 194738,
'CJK COMPATIBILITY IDEOGRAPH-2F8B3': 194739,
'CJK COMPATIBILITY IDEOGRAPH-2F8B4': 194740,
'CJK COMPATIBILITY IDEOGRAPH-2F8B5': 194741,
'CJK COMPATIBILITY IDEOGRAPH-2F8B6': 194742,
'CJK COMPATIBILITY IDEOGRAPH-2F8B7': 194743,
'CJK COMPATIBILITY IDEOGRAPH-2F8B8': 194744,
'CJK COMPATIBILITY IDEOGRAPH-2F8B9': 194745,
'CJK COMPATIBILITY IDEOGRAPH-2F8BA': 194746,
'CJK COMPATIBILITY IDEOGRAPH-2F8BB': 194747,
'CJK COMPATIBILITY IDEOGRAPH-2F8BC': 194748,
'CJK COMPATIBILITY IDEOGRAPH-2F8BD': 194749,
'CJK COMPATIBILITY IDEOGRAPH-2F8BE': 194750,
'CJK COMPATIBILITY IDEOGRAPH-2F8BF': 194751,
'CJK COMPATIBILITY IDEOGRAPH-2F8C0': 194752,
'CJK COMPATIBILITY IDEOGRAPH-2F8C1': 194753,
'CJK COMPATIBILITY IDEOGRAPH-2F8C2': 194754,
'CJK COMPATIBILITY IDEOGRAPH-2F8C3': 194755,
'CJK COMPATIBILITY IDEOGRAPH-2F8C4': 194756,
'CJK COMPATIBILITY IDEOGRAPH-2F8C5': 194757,
'CJK COMPATIBILITY IDEOGRAPH-2F8C6': 194758,
'CJK COMPATIBILITY IDEOGRAPH-2F8C7': 194759,
'CJK COMPATIBILITY IDEOGRAPH-2F8C8': 194760,
'CJK COMPATIBILITY IDEOGRAPH-2F8C9': 194761,
'CJK COMPATIBILITY IDEOGRAPH-2F8CA': 194762,
'CJK COMPATIBILITY IDEOGRAPH-2F8CB': 194763,
'CJK COMPATIBILITY IDEOGRAPH-2F8CC': 194764,
'CJK COMPATIBILITY IDEOGRAPH-2F8CD': 194765,
'CJK COMPATIBILITY IDEOGRAPH-2F8CE': 194766,
'CJK COMPATIBILITY IDEOGRAPH-2F8CF': 194767,
'CJK COMPATIBILITY IDEOGRAPH-2F8D0': 194768,
'CJK COMPATIBILITY IDEOGRAPH-2F8D1': 194769,
'CJK COMPATIBILITY IDEOGRAPH-2F8D2': 194770,
'CJK COMPATIBILITY IDEOGRAPH-2F8D3': 194771,
'CJK COMPATIBILITY IDEOGRAPH-2F8D4': 194772,
'CJK COMPATIBILITY IDEOGRAPH-2F8D5': 194773,
'CJK COMPATIBILITY IDEOGRAPH-2F8D6': 194774,
'CJK COMPATIBILITY IDEOGRAPH-2F8D7': 194775,
'CJK COMPATIBILITY IDEOGRAPH-2F8D8': 194776,
'CJK COMPATIBILITY IDEOGRAPH-2F8D9': 194777,
'CJK COMPATIBILITY IDEOGRAPH-2F8DA': 194778,
'CJK COMPATIBILITY IDEOGRAPH-2F8DB': 194779,
'CJK COMPATIBILITY IDEOGRAPH-2F8DC': 194780,
'CJK COMPATIBILITY IDEOGRAPH-2F8DD': 194781,
'CJK COMPATIBILITY IDEOGRAPH-2F8DE': 194782,
'CJK COMPATIBILITY IDEOGRAPH-2F8DF': 194783,
'CJK COMPATIBILITY IDEOGRAPH-2F8E0': 194784,
'CJK COMPATIBILITY IDEOGRAPH-2F8E1': 194785,
'CJK COMPATIBILITY IDEOGRAPH-2F8E2': 194786,
'CJK COMPATIBILITY IDEOGRAPH-2F8E3': 194787,
'CJK COMPATIBILITY IDEOGRAPH-2F8E4': 194788,
'CJK COMPATIBILITY IDEOGRAPH-2F8E5': 194789,
'CJK COMPATIBILITY IDEOGRAPH-2F8E6': 194790,
'CJK COMPATIBILITY IDEOGRAPH-2F8E7': 194791,
'CJK COMPATIBILITY IDEOGRAPH-2F8E8': 194792,
'CJK COMPATIBILITY IDEOGRAPH-2F8E9': 194793,
'CJK COMPATIBILITY IDEOGRAPH-2F8EA': 194794,
'CJK COMPATIBILITY IDEOGRAPH-2F8EB': 194795,
'CJK COMPATIBILITY IDEOGRAPH-2F8EC': 194796,
'CJK COMPATIBILITY IDEOGRAPH-2F8ED': 194797,
'CJK COMPATIBILITY IDEOGRAPH-2F8EE': 194798,
'CJK COMPATIBILITY IDEOGRAPH-2F8EF': 194799,
'CJK COMPATIBILITY IDEOGRAPH-2F8F0': 194800,
'CJK COMPATIBILITY IDEOGRAPH-2F8F1': 194801,
'CJK COMPATIBILITY IDEOGRAPH-2F8F2': 194802,
'CJK COMPATIBILITY IDEOGRAPH-2F8F3': 194803,
'CJK COMPATIBILITY IDEOGRAPH-2F8F4': 194804,
'CJK COMPATIBILITY IDEOGRAPH-2F8F5': 194805,
'CJK COMPATIBILITY IDEOGRAPH-2F8F6': 194806,
'CJK COMPATIBILITY IDEOGRAPH-2F8F7': 194807,
'CJK COMPATIBILITY IDEOGRAPH-2F8F8': 194808,
'CJK COMPATIBILITY IDEOGRAPH-2F8F9': 194809,
'CJK COMPATIBILITY IDEOGRAPH-2F8FA': 194810,
'CJK COMPATIBILITY IDEOGRAPH-2F8FB': 194811,
'CJK COMPATIBILITY IDEOGRAPH-2F8FC': 194812,
'CJK COMPATIBILITY IDEOGRAPH-2F8FD': 194813,
'CJK COMPATIBILITY IDEOGRAPH-2F8FE': 194814,
'CJK COMPATIBILITY IDEOGRAPH-2F8FF': 194815,
'CJK COMPATIBILITY IDEOGRAPH-2F900': 194816,
'CJK COMPATIBILITY IDEOGRAPH-2F901': 194817,
'CJK COMPATIBILITY IDEOGRAPH-2F902': 194818,
'CJK COMPATIBILITY IDEOGRAPH-2F903': 194819,
'CJK COMPATIBILITY IDEOGRAPH-2F904': 194820,
'CJK COMPATIBILITY IDEOGRAPH-2F905': 194821,
'CJK COMPATIBILITY IDEOGRAPH-2F906': 194822,
'CJK COMPATIBILITY IDEOGRAPH-2F907': 194823,
'CJK COMPATIBILITY IDEOGRAPH-2F908': 194824,
'CJK COMPATIBILITY IDEOGRAPH-2F909': 194825,
'CJK COMPATIBILITY IDEOGRAPH-2F90A': 194826,
'CJK COMPATIBILITY IDEOGRAPH-2F90B': 194827,
'CJK COMPATIBILITY IDEOGRAPH-2F90C': 194828,
'CJK COMPATIBILITY IDEOGRAPH-2F90D': 194829,
'CJK COMPATIBILITY IDEOGRAPH-2F90E': 194830,
'CJK COMPATIBILITY IDEOGRAPH-2F90F': 194831,
'CJK COMPATIBILITY IDEOGRAPH-2F910': 194832,
'CJK COMPATIBILITY IDEOGRAPH-2F911': 194833,
'CJK COMPATIBILITY IDEOGRAPH-2F912': 194834,
'CJK COMPATIBILITY IDEOGRAPH-2F913': 194835,
'CJK COMPATIBILITY IDEOGRAPH-2F914': 194836,
'CJK COMPATIBILITY IDEOGRAPH-2F915': 194837,
'CJK COMPATIBILITY IDEOGRAPH-2F916': 194838,
'CJK COMPATIBILITY IDEOGRAPH-2F917': 194839,
'CJK COMPATIBILITY IDEOGRAPH-2F918': 194840,
'CJK COMPATIBILITY IDEOGRAPH-2F919': 194841,
'CJK COMPATIBILITY IDEOGRAPH-2F91A': 194842,
'CJK COMPATIBILITY IDEOGRAPH-2F91B': 194843,
'CJK COMPATIBILITY IDEOGRAPH-2F91C': 194844,
'CJK COMPATIBILITY IDEOGRAPH-2F91D': 194845,
'CJK COMPATIBILITY IDEOGRAPH-2F91E': 194846,
'CJK COMPATIBILITY IDEOGRAPH-2F91F': 194847,
'CJK COMPATIBILITY IDEOGRAPH-2F920': 194848,
'CJK COMPATIBILITY IDEOGRAPH-2F921': 194849,
'CJK COMPATIBILITY IDEOGRAPH-2F922': 194850,
'CJK COMPATIBILITY IDEOGRAPH-2F923': 194851,
'CJK COMPATIBILITY IDEOGRAPH-2F924': 194852,
'CJK COMPATIBILITY IDEOGRAPH-2F925': 194853,
'CJK COMPATIBILITY IDEOGRAPH-2F926': 194854,
'CJK COMPATIBILITY IDEOGRAPH-2F927': 194855,
'CJK COMPATIBILITY IDEOGRAPH-2F928': 194856,
'CJK COMPATIBILITY IDEOGRAPH-2F929': 194857,
'CJK COMPATIBILITY IDEOGRAPH-2F92A': 194858,
'CJK COMPATIBILITY IDEOGRAPH-2F92B': 194859,
'CJK COMPATIBILITY IDEOGRAPH-2F92C': 194860,
'CJK COMPATIBILITY IDEOGRAPH-2F92D': 194861,
'CJK COMPATIBILITY IDEOGRAPH-2F92E': 194862,
'CJK COMPATIBILITY IDEOGRAPH-2F92F': 194863,
'CJK COMPATIBILITY IDEOGRAPH-2F930': 194864,
'CJK COMPATIBILITY IDEOGRAPH-2F931': 194865,
'CJK COMPATIBILITY IDEOGRAPH-2F932': 194866,
'CJK COMPATIBILITY IDEOGRAPH-2F933': 194867,
'CJK COMPATIBILITY IDEOGRAPH-2F934': 194868,
'CJK COMPATIBILITY IDEOGRAPH-2F935': 194869,
'CJK COMPATIBILITY IDEOGRAPH-2F936': 194870,
'CJK COMPATIBILITY IDEOGRAPH-2F937': 194871,
'CJK COMPATIBILITY IDEOGRAPH-2F938': 194872,
'CJK COMPATIBILITY IDEOGRAPH-2F939': 194873,
'CJK COMPATIBILITY IDEOGRAPH-2F93A': 194874,
'CJK COMPATIBILITY IDEOGRAPH-2F93B': 194875,
'CJK COMPATIBILITY IDEOGRAPH-2F93C': 194876,
'CJK COMPATIBILITY IDEOGRAPH-2F93D': 194877,
'CJK COMPATIBILITY IDEOGRAPH-2F93E': 194878,
'CJK COMPATIBILITY IDEOGRAPH-2F93F': 194879,
'CJK COMPATIBILITY IDEOGRAPH-2F940': 194880,
'CJK COMPATIBILITY IDEOGRAPH-2F941': 194881,
'CJK COMPATIBILITY IDEOGRAPH-2F942': 194882,
'CJK COMPATIBILITY IDEOGRAPH-2F943': 194883,
'CJK COMPATIBILITY IDEOGRAPH-2F944': 194884,
'CJK COMPATIBILITY IDEOGRAPH-2F945': 194885,
'CJK COMPATIBILITY IDEOGRAPH-2F946': 194886,
'CJK COMPATIBILITY IDEOGRAPH-2F947': 194887,
'CJK COMPATIBILITY IDEOGRAPH-2F948': 194888,
'CJK COMPATIBILITY IDEOGRAPH-2F949': 194889,
'CJK COMPATIBILITY IDEOGRAPH-2F94A': 194890,
'CJK COMPATIBILITY IDEOGRAPH-2F94B': 194891,
'CJK COMPATIBILITY IDEOGRAPH-2F94C': 194892,
'CJK COMPATIBILITY IDEOGRAPH-2F94D': 194893,
'CJK COMPATIBILITY IDEOGRAPH-2F94E': 194894,
'CJK COMPATIBILITY IDEOGRAPH-2F94F': 194895,
'CJK COMPATIBILITY IDEOGRAPH-2F950': 194896,
'CJK COMPATIBILITY IDEOGRAPH-2F951': 194897,
'CJK COMPATIBILITY IDEOGRAPH-2F952': 194898,
'CJK COMPATIBILITY IDEOGRAPH-2F953': 194899,
'CJK COMPATIBILITY IDEOGRAPH-2F954': 194900,
'CJK COMPATIBILITY IDEOGRAPH-2F955': 194901,
'CJK COMPATIBILITY IDEOGRAPH-2F956': 194902,
'CJK COMPATIBILITY IDEOGRAPH-2F957': 194903,
'CJK COMPATIBILITY IDEOGRAPH-2F958': 194904,
'CJK COMPATIBILITY IDEOGRAPH-2F959': 194905,
'CJK COMPATIBILITY IDEOGRAPH-2F95A': 194906,
'CJK COMPATIBILITY IDEOGRAPH-2F95B': 194907,
'CJK COMPATIBILITY IDEOGRAPH-2F95C': 194908,
'CJK COMPATIBILITY IDEOGRAPH-2F95D': 194909,
'CJK COMPATIBILITY IDEOGRAPH-2F95E': 194910,
'CJK COMPATIBILITY IDEOGRAPH-2F95F': 194911,
'CJK COMPATIBILITY IDEOGRAPH-2F960': 194912,
'CJK COMPATIBILITY IDEOGRAPH-2F961': 194913,
'CJK COMPATIBILITY IDEOGRAPH-2F962': 194914,
'CJK COMPATIBILITY IDEOGRAPH-2F963': 194915,
'CJK COMPATIBILITY IDEOGRAPH-2F964': 194916,
'CJK COMPATIBILITY IDEOGRAPH-2F965': 194917,
'CJK COMPATIBILITY IDEOGRAPH-2F966': 194918,
'CJK COMPATIBILITY IDEOGRAPH-2F967': 194919,
'CJK COMPATIBILITY IDEOGRAPH-2F968': 194920,
'CJK COMPATIBILITY IDEOGRAPH-2F969': 194921,
'CJK COMPATIBILITY IDEOGRAPH-2F96A': 194922,
'CJK COMPATIBILITY IDEOGRAPH-2F96B': 194923,
'CJK COMPATIBILITY IDEOGRAPH-2F96C': 194924,
'CJK COMPATIBILITY IDEOGRAPH-2F96D': 194925,
'CJK COMPATIBILITY IDEOGRAPH-2F96E': 194926,
'CJK COMPATIBILITY IDEOGRAPH-2F96F': 194927,
'CJK COMPATIBILITY IDEOGRAPH-2F970': 194928,
'CJK COMPATIBILITY IDEOGRAPH-2F971': 194929,
'CJK COMPATIBILITY IDEOGRAPH-2F972': 194930,
'CJK COMPATIBILITY IDEOGRAPH-2F973': 194931,
'CJK COMPATIBILITY IDEOGRAPH-2F974': 194932,
'CJK COMPATIBILITY IDEOGRAPH-2F975': 194933,
'CJK COMPATIBILITY IDEOGRAPH-2F976': 194934,
'CJK COMPATIBILITY IDEOGRAPH-2F977': 194935,
'CJK COMPATIBILITY IDEOGRAPH-2F978': 194936,
'CJK COMPATIBILITY IDEOGRAPH-2F979': 194937,
'CJK COMPATIBILITY IDEOGRAPH-2F97A': 194938,
'CJK COMPATIBILITY IDEOGRAPH-2F97B': 194939,
'CJK COMPATIBILITY IDEOGRAPH-2F97C': 194940,
'CJK COMPATIBILITY IDEOGRAPH-2F97D': 194941,
'CJK COMPATIBILITY IDEOGRAPH-2F97E': 194942,
'CJK COMPATIBILITY IDEOGRAPH-2F97F': 194943,
'CJK COMPATIBILITY IDEOGRAPH-2F980': 194944,
'CJK COMPATIBILITY IDEOGRAPH-2F981': 194945,
'CJK COMPATIBILITY IDEOGRAPH-2F982': 194946,
'CJK COMPATIBILITY IDEOGRAPH-2F983': 194947,
'CJK COMPATIBILITY IDEOGRAPH-2F984': 194948,
'CJK COMPATIBILITY IDEOGRAPH-2F985': 194949,
'CJK COMPATIBILITY IDEOGRAPH-2F986': 194950,
'CJK COMPATIBILITY IDEOGRAPH-2F987': 194951,
'CJK COMPATIBILITY IDEOGRAPH-2F988': 194952,
'CJK COMPATIBILITY IDEOGRAPH-2F989': 194953,
'CJK COMPATIBILITY IDEOGRAPH-2F98A': 194954,
'CJK COMPATIBILITY IDEOGRAPH-2F98B': 194955,
'CJK COMPATIBILITY IDEOGRAPH-2F98C': 194956,
'CJK COMPATIBILITY IDEOGRAPH-2F98D': 194957,
'CJK COMPATIBILITY IDEOGRAPH-2F98E': 194958,
'CJK COMPATIBILITY IDEOGRAPH-2F98F': 194959,
'CJK COMPATIBILITY IDEOGRAPH-2F990': 194960,
'CJK COMPATIBILITY IDEOGRAPH-2F991': 194961,
'CJK COMPATIBILITY IDEOGRAPH-2F992': 194962,
'CJK COMPATIBILITY IDEOGRAPH-2F993': 194963,
'CJK COMPATIBILITY IDEOGRAPH-2F994': 194964,
'CJK COMPATIBILITY IDEOGRAPH-2F995': 194965,
'CJK COMPATIBILITY IDEOGRAPH-2F996': 194966,
'CJK COMPATIBILITY IDEOGRAPH-2F997': 194967,
'CJK COMPATIBILITY IDEOGRAPH-2F998': 194968,
'CJK COMPATIBILITY IDEOGRAPH-2F999': 194969,
'CJK COMPATIBILITY IDEOGRAPH-2F99A': 194970,
'CJK COMPATIBILITY IDEOGRAPH-2F99B': 194971,
'CJK COMPATIBILITY IDEOGRAPH-2F99C': 194972,
'CJK COMPATIBILITY IDEOGRAPH-2F99D': 194973,
'CJK COMPATIBILITY IDEOGRAPH-2F99E': 194974,
'CJK COMPATIBILITY IDEOGRAPH-2F99F': 194975,
'CJK COMPATIBILITY IDEOGRAPH-2F9A0': 194976,
'CJK COMPATIBILITY IDEOGRAPH-2F9A1': 194977,
'CJK COMPATIBILITY IDEOGRAPH-2F9A2': 194978,
'CJK COMPATIBILITY IDEOGRAPH-2F9A3': 194979,
'CJK COMPATIBILITY IDEOGRAPH-2F9A4': 194980,
'CJK COMPATIBILITY IDEOGRAPH-2F9A5': 194981,
'CJK COMPATIBILITY IDEOGRAPH-2F9A6': 194982,
'CJK COMPATIBILITY IDEOGRAPH-2F9A7': 194983,
'CJK COMPATIBILITY IDEOGRAPH-2F9A8': 194984,
'CJK COMPATIBILITY IDEOGRAPH-2F9A9': 194985,
'CJK COMPATIBILITY IDEOGRAPH-2F9AA': 194986,
'CJK COMPATIBILITY IDEOGRAPH-2F9AB': 194987,
'CJK COMPATIBILITY IDEOGRAPH-2F9AC': 194988,
'CJK COMPATIBILITY IDEOGRAPH-2F9AD': 194989,
'CJK COMPATIBILITY IDEOGRAPH-2F9AE': 194990,
'CJK COMPATIBILITY IDEOGRAPH-2F9AF': 194991,
'CJK COMPATIBILITY IDEOGRAPH-2F9B0': 194992,
'CJK COMPATIBILITY IDEOGRAPH-2F9B1': 194993,
'CJK COMPATIBILITY IDEOGRAPH-2F9B2': 194994,
'CJK COMPATIBILITY IDEOGRAPH-2F9B3': 194995,
'CJK COMPATIBILITY IDEOGRAPH-2F9B4': 194996,
'CJK COMPATIBILITY IDEOGRAPH-2F9B5': 194997,
'CJK COMPATIBILITY IDEOGRAPH-2F9B6': 194998,
'CJK COMPATIBILITY IDEOGRAPH-2F9B7': 194999,
'CJK COMPATIBILITY IDEOGRAPH-2F9B8': 195000,
'CJK COMPATIBILITY IDEOGRAPH-2F9B9': 195001,
'CJK COMPATIBILITY IDEOGRAPH-2F9BA': 195002,
'CJK COMPATIBILITY IDEOGRAPH-2F9BB': 195003,
'CJK COMPATIBILITY IDEOGRAPH-2F9BC': 195004,
'CJK COMPATIBILITY IDEOGRAPH-2F9BD': 195005,
'CJK COMPATIBILITY IDEOGRAPH-2F9BE': 195006,
'CJK COMPATIBILITY IDEOGRAPH-2F9BF': 195007,
'CJK COMPATIBILITY IDEOGRAPH-2F9C0': 195008,
'CJK COMPATIBILITY IDEOGRAPH-2F9C1': 195009,
'CJK COMPATIBILITY IDEOGRAPH-2F9C2': 195010,
'CJK COMPATIBILITY IDEOGRAPH-2F9C3': 195011,
'CJK COMPATIBILITY IDEOGRAPH-2F9C4': 195012,
'CJK COMPATIBILITY IDEOGRAPH-2F9C5': 195013,
'CJK COMPATIBILITY IDEOGRAPH-2F9C6': 195014,
'CJK COMPATIBILITY IDEOGRAPH-2F9C7': 195015,
'CJK COMPATIBILITY IDEOGRAPH-2F9C8': 195016,
'CJK COMPATIBILITY IDEOGRAPH-2F9C9': 195017,
'CJK COMPATIBILITY IDEOGRAPH-2F9CA': 195018,
'CJK COMPATIBILITY IDEOGRAPH-2F9CB': 195019,
'CJK COMPATIBILITY IDEOGRAPH-2F9CC': 195020,
'CJK COMPATIBILITY IDEOGRAPH-2F9CD': 195021,
'CJK COMPATIBILITY IDEOGRAPH-2F9CE': 195022,
'CJK COMPATIBILITY IDEOGRAPH-2F9CF': 195023,
'CJK COMPATIBILITY IDEOGRAPH-2F9D0': 195024,
'CJK COMPATIBILITY IDEOGRAPH-2F9D1': 195025,
'CJK COMPATIBILITY IDEOGRAPH-2F9D2': 195026,
'CJK COMPATIBILITY IDEOGRAPH-2F9D3': 195027,
'CJK COMPATIBILITY IDEOGRAPH-2F9D4': 195028,
'CJK COMPATIBILITY IDEOGRAPH-2F9D5': 195029,
'CJK COMPATIBILITY IDEOGRAPH-2F9D6': 195030,
'CJK COMPATIBILITY IDEOGRAPH-2F9D7': 195031,
'CJK COMPATIBILITY IDEOGRAPH-2F9D8': 195032,
'CJK COMPATIBILITY IDEOGRAPH-2F9D9': 195033,
'CJK COMPATIBILITY IDEOGRAPH-2F9DA': 195034,
'CJK COMPATIBILITY IDEOGRAPH-2F9DB': 195035,
'CJK COMPATIBILITY IDEOGRAPH-2F9DC': 195036,
'CJK COMPATIBILITY IDEOGRAPH-2F9DD': 195037,
'CJK COMPATIBILITY IDEOGRAPH-2F9DE': 195038,
'CJK COMPATIBILITY IDEOGRAPH-2F9DF': 195039,
'CJK COMPATIBILITY IDEOGRAPH-2F9E0': 195040,
'CJK COMPATIBILITY IDEOGRAPH-2F9E1': 195041,
'CJK COMPATIBILITY IDEOGRAPH-2F9E2': 195042,
'CJK COMPATIBILITY IDEOGRAPH-2F9E3': 195043,
'CJK COMPATIBILITY IDEOGRAPH-2F9E4': 195044,
'CJK COMPATIBILITY IDEOGRAPH-2F9E5': 195045,
'CJK COMPATIBILITY IDEOGRAPH-2F9E6': 195046,
'CJK COMPATIBILITY IDEOGRAPH-2F9E7': 195047,
'CJK COMPATIBILITY IDEOGRAPH-2F9E8': 195048,
'CJK COMPATIBILITY IDEOGRAPH-2F9E9': 195049,
'CJK COMPATIBILITY IDEOGRAPH-2F9EA': 195050,
'CJK COMPATIBILITY IDEOGRAPH-2F9EB': 195051,
'CJK COMPATIBILITY IDEOGRAPH-2F9EC': 195052,
'CJK COMPATIBILITY IDEOGRAPH-2F9ED': 195053,
'CJK COMPATIBILITY IDEOGRAPH-2F9EE': 195054,
'CJK COMPATIBILITY IDEOGRAPH-2F9EF': 195055,
'CJK COMPATIBILITY IDEOGRAPH-2F9F0': 195056,
'CJK COMPATIBILITY IDEOGRAPH-2F9F1': 195057,
'CJK COMPATIBILITY IDEOGRAPH-2F9F2': 195058,
'CJK COMPATIBILITY IDEOGRAPH-2F9F3': 195059,
'CJK COMPATIBILITY IDEOGRAPH-2F9F4': 195060,
'CJK COMPATIBILITY IDEOGRAPH-2F9F5': 195061,
'CJK COMPATIBILITY IDEOGRAPH-2F9F6': 195062,
'CJK COMPATIBILITY IDEOGRAPH-2F9F7': 195063,
'CJK COMPATIBILITY IDEOGRAPH-2F9F8': 195064,
'CJK COMPATIBILITY IDEOGRAPH-2F9F9': 195065,
'CJK COMPATIBILITY IDEOGRAPH-2F9FA': 195066,
'CJK COMPATIBILITY IDEOGRAPH-2F9FB': 195067,
'CJK COMPATIBILITY IDEOGRAPH-2F9FC': 195068,
'CJK COMPATIBILITY IDEOGRAPH-2F9FD': 195069,
'CJK COMPATIBILITY IDEOGRAPH-2F9FE': 195070,
'CJK COMPATIBILITY IDEOGRAPH-2F9FF': 195071,
'CJK COMPATIBILITY IDEOGRAPH-2FA00': 195072,
'CJK COMPATIBILITY IDEOGRAPH-2FA01': 195073,
'CJK COMPATIBILITY IDEOGRAPH-2FA02': 195074,
'CJK COMPATIBILITY IDEOGRAPH-2FA03': 195075,
'CJK COMPATIBILITY IDEOGRAPH-2FA04': 195076,
'CJK COMPATIBILITY IDEOGRAPH-2FA05': 195077,
'CJK COMPATIBILITY IDEOGRAPH-2FA06': 195078,
'CJK COMPATIBILITY IDEOGRAPH-2FA07': 195079,
'CJK COMPATIBILITY IDEOGRAPH-2FA08': 195080,
'CJK COMPATIBILITY IDEOGRAPH-2FA09': 195081,
'CJK COMPATIBILITY IDEOGRAPH-2FA0A': 195082,
'CJK COMPATIBILITY IDEOGRAPH-2FA0B': 195083,
'CJK COMPATIBILITY IDEOGRAPH-2FA0C': 195084,
'CJK COMPATIBILITY IDEOGRAPH-2FA0D': 195085,
'CJK COMPATIBILITY IDEOGRAPH-2FA0E': 195086,
'CJK COMPATIBILITY IDEOGRAPH-2FA0F': 195087,
'CJK COMPATIBILITY IDEOGRAPH-2FA10': 195088,
'CJK COMPATIBILITY IDEOGRAPH-2FA11': 195089,
'CJK COMPATIBILITY IDEOGRAPH-2FA12': 195090,
'CJK COMPATIBILITY IDEOGRAPH-2FA13': 195091,
'CJK COMPATIBILITY IDEOGRAPH-2FA14': 195092,
'CJK COMPATIBILITY IDEOGRAPH-2FA15': 195093,
'CJK COMPATIBILITY IDEOGRAPH-2FA16': 195094,
'CJK COMPATIBILITY IDEOGRAPH-2FA17': 195095,
'CJK COMPATIBILITY IDEOGRAPH-2FA18': 195096,
'CJK COMPATIBILITY IDEOGRAPH-2FA19': 195097,
'CJK COMPATIBILITY IDEOGRAPH-2FA1A': 195098,
'CJK COMPATIBILITY IDEOGRAPH-2FA1B': 195099,
'CJK COMPATIBILITY IDEOGRAPH-2FA1C': 195100,
'CJK COMPATIBILITY IDEOGRAPH-2FA1D': 195101,
'CJK COMPATIBILITY IDEOGRAPH-F900': 63744,
'CJK COMPATIBILITY IDEOGRAPH-F901': 63745,
'CJK COMPATIBILITY IDEOGRAPH-F902': 63746,
'CJK COMPATIBILITY IDEOGRAPH-F903': 63747,
'CJK COMPATIBILITY IDEOGRAPH-F904': 63748,
'CJK COMPATIBILITY IDEOGRAPH-F905': 63749,
'CJK COMPATIBILITY IDEOGRAPH-F906': 63750,
'CJK COMPATIBILITY IDEOGRAPH-F907': 63751,
'CJK COMPATIBILITY IDEOGRAPH-F908': 63752,
'CJK COMPATIBILITY IDEOGRAPH-F909': 63753,
'CJK COMPATIBILITY IDEOGRAPH-F90A': 63754,
'CJK COMPATIBILITY IDEOGRAPH-F90B': 63755,
'CJK COMPATIBILITY IDEOGRAPH-F90C': 63756,
'CJK COMPATIBILITY IDEOGRAPH-F90D': 63757,
'CJK COMPATIBILITY IDEOGRAPH-F90E': 63758,
'CJK COMPATIBILITY IDEOGRAPH-F90F': 63759,
'CJK COMPATIBILITY IDEOGRAPH-F910': 63760,
'CJK COMPATIBILITY IDEOGRAPH-F911': 63761,
'CJK COMPATIBILITY IDEOGRAPH-F912': 63762,
'CJK COMPATIBILITY IDEOGRAPH-F913': 63763,
'CJK COMPATIBILITY IDEOGRAPH-F914': 63764,
'CJK COMPATIBILITY IDEOGRAPH-F915': 63765,
'CJK COMPATIBILITY IDEOGRAPH-F916': 63766,
'CJK COMPATIBILITY IDEOGRAPH-F917': 63767,
'CJK COMPATIBILITY IDEOGRAPH-F918': 63768,
'CJK COMPATIBILITY IDEOGRAPH-F919': 63769,
'CJK COMPATIBILITY IDEOGRAPH-F91A': 63770,
'CJK COMPATIBILITY IDEOGRAPH-F91B': 63771,
'CJK COMPATIBILITY IDEOGRAPH-F91C': 63772,
'CJK COMPATIBILITY IDEOGRAPH-F91D': 63773,
'CJK COMPATIBILITY IDEOGRAPH-F91E': 63774,
'CJK COMPATIBILITY IDEOGRAPH-F91F': 63775,
'CJK COMPATIBILITY IDEOGRAPH-F920': 63776,
'CJK COMPATIBILITY IDEOGRAPH-F921': 63777,
'CJK COMPATIBILITY IDEOGRAPH-F922': 63778,
'CJK COMPATIBILITY IDEOGRAPH-F923': 63779,
'CJK COMPATIBILITY IDEOGRAPH-F924': 63780,
'CJK COMPATIBILITY IDEOGRAPH-F925': 63781,
'CJK COMPATIBILITY IDEOGRAPH-F926': 63782,
'CJK COMPATIBILITY IDEOGRAPH-F927': 63783,
'CJK COMPATIBILITY IDEOGRAPH-F928': 63784,
'CJK COMPATIBILITY IDEOGRAPH-F929': 63785,
'CJK COMPATIBILITY IDEOGRAPH-F92A': 63786,
'CJK COMPATIBILITY IDEOGRAPH-F92B': 63787,
'CJK COMPATIBILITY IDEOGRAPH-F92C': 63788,
'CJK COMPATIBILITY IDEOGRAPH-F92D': 63789,
'CJK COMPATIBILITY IDEOGRAPH-F92E': 63790,
'CJK COMPATIBILITY IDEOGRAPH-F92F': 63791,
'CJK COMPATIBILITY IDEOGRAPH-F930': 63792,
'CJK COMPATIBILITY IDEOGRAPH-F931': 63793,
'CJK COMPATIBILITY IDEOGRAPH-F932': 63794,
'CJK COMPATIBILITY IDEOGRAPH-F933': 63795,
'CJK COMPATIBILITY IDEOGRAPH-F934': 63796,
'CJK COMPATIBILITY IDEOGRAPH-F935': 63797,
'CJK COMPATIBILITY IDEOGRAPH-F936': 63798,
'CJK COMPATIBILITY IDEOGRAPH-F937': 63799,
'CJK COMPATIBILITY IDEOGRAPH-F938': 63800,
'CJK COMPATIBILITY IDEOGRAPH-F939': 63801,
'CJK COMPATIBILITY IDEOGRAPH-F93A': 63802,
'CJK COMPATIBILITY IDEOGRAPH-F93B': 63803,
'CJK COMPATIBILITY IDEOGRAPH-F93C': 63804,
'CJK COMPATIBILITY IDEOGRAPH-F93D': 63805,
'CJK COMPATIBILITY IDEOGRAPH-F93E': 63806,
'CJK COMPATIBILITY IDEOGRAPH-F93F': 63807,
'CJK COMPATIBILITY IDEOGRAPH-F940': 63808,
'CJK COMPATIBILITY IDEOGRAPH-F941': 63809,
'CJK COMPATIBILITY IDEOGRAPH-F942': 63810,
'CJK COMPATIBILITY IDEOGRAPH-F943': 63811,
'CJK COMPATIBILITY IDEOGRAPH-F944': 63812,
'CJK COMPATIBILITY IDEOGRAPH-F945': 63813,
'CJK COMPATIBILITY IDEOGRAPH-F946': 63814,
'CJK COMPATIBILITY IDEOGRAPH-F947': 63815,
'CJK COMPATIBILITY IDEOGRAPH-F948': 63816,
'CJK COMPATIBILITY IDEOGRAPH-F949': 63817,
'CJK COMPATIBILITY IDEOGRAPH-F94A': 63818,
'CJK COMPATIBILITY IDEOGRAPH-F94B': 63819,
'CJK COMPATIBILITY IDEOGRAPH-F94C': 63820,
'CJK COMPATIBILITY IDEOGRAPH-F94D': 63821,
'CJK COMPATIBILITY IDEOGRAPH-F94E': 63822,
'CJK COMPATIBILITY IDEOGRAPH-F94F': 63823,
'CJK COMPATIBILITY IDEOGRAPH-F950': 63824,
'CJK COMPATIBILITY IDEOGRAPH-F951': 63825,
'CJK COMPATIBILITY IDEOGRAPH-F952': 63826,
'CJK COMPATIBILITY IDEOGRAPH-F953': 63827,
'CJK COMPATIBILITY IDEOGRAPH-F954': 63828,
'CJK COMPATIBILITY IDEOGRAPH-F955': 63829,
'CJK COMPATIBILITY IDEOGRAPH-F956': 63830,
'CJK COMPATIBILITY IDEOGRAPH-F957': 63831,
'CJK COMPATIBILITY IDEOGRAPH-F958': 63832,
'CJK COMPATIBILITY IDEOGRAPH-F959': 63833,
'CJK COMPATIBILITY IDEOGRAPH-F95A': 63834,
'CJK COMPATIBILITY IDEOGRAPH-F95B': 63835,
'CJK COMPATIBILITY IDEOGRAPH-F95C': 63836,
'CJK COMPATIBILITY IDEOGRAPH-F95D': 63837,
'CJK COMPATIBILITY IDEOGRAPH-F95E': 63838,
'CJK COMPATIBILITY IDEOGRAPH-F95F': 63839,
'CJK COMPATIBILITY IDEOGRAPH-F960': 63840,
'CJK COMPATIBILITY IDEOGRAPH-F961': 63841,
'CJK COMPATIBILITY IDEOGRAPH-F962': 63842,
'CJK COMPATIBILITY IDEOGRAPH-F963': 63843,
'CJK COMPATIBILITY IDEOGRAPH-F964': 63844,
'CJK COMPATIBILITY IDEOGRAPH-F965': 63845,
'CJK COMPATIBILITY IDEOGRAPH-F966': 63846,
'CJK COMPATIBILITY IDEOGRAPH-F967': 63847,
'CJK COMPATIBILITY IDEOGRAPH-F968': 63848,
'CJK COMPATIBILITY IDEOGRAPH-F969': 63849,
'CJK COMPATIBILITY IDEOGRAPH-F96A': 63850,
'CJK COMPATIBILITY IDEOGRAPH-F96B': 63851,
'CJK COMPATIBILITY IDEOGRAPH-F96C': 63852,
'CJK COMPATIBILITY IDEOGRAPH-F96D': 63853,
'CJK COMPATIBILITY IDEOGRAPH-F96E': 63854,
'CJK COMPATIBILITY IDEOGRAPH-F96F': 63855,
'CJK COMPATIBILITY IDEOGRAPH-F970': 63856,
'CJK COMPATIBILITY IDEOGRAPH-F971': 63857,
'CJK COMPATIBILITY IDEOGRAPH-F972': 63858,
'CJK COMPATIBILITY IDEOGRAPH-F973': 63859,
'CJK COMPATIBILITY IDEOGRAPH-F974': 63860,
'CJK COMPATIBILITY IDEOGRAPH-F975': 63861,
'CJK COMPATIBILITY IDEOGRAPH-F976': 63862,
'CJK COMPATIBILITY IDEOGRAPH-F977': 63863,
'CJK COMPATIBILITY IDEOGRAPH-F978': 63864,
'CJK COMPATIBILITY IDEOGRAPH-F979': 63865,
'CJK COMPATIBILITY IDEOGRAPH-F97A': 63866,
'CJK COMPATIBILITY IDEOGRAPH-F97B': 63867,
'CJK COMPATIBILITY IDEOGRAPH-F97C': 63868,
'CJK COMPATIBILITY IDEOGRAPH-F97D': 63869,
'CJK COMPATIBILITY IDEOGRAPH-F97E': 63870,
'CJK COMPATIBILITY IDEOGRAPH-F97F': 63871,
'CJK COMPATIBILITY IDEOGRAPH-F980': 63872,
'CJK COMPATIBILITY IDEOGRAPH-F981': 63873,
'CJK COMPATIBILITY IDEOGRAPH-F982': 63874,
'CJK COMPATIBILITY IDEOGRAPH-F983': 63875,
'CJK COMPATIBILITY IDEOGRAPH-F984': 63876,
'CJK COMPATIBILITY IDEOGRAPH-F985': 63877,
'CJK COMPATIBILITY IDEOGRAPH-F986': 63878,
'CJK COMPATIBILITY IDEOGRAPH-F987': 63879,
'CJK COMPATIBILITY IDEOGRAPH-F988': 63880,
'CJK COMPATIBILITY IDEOGRAPH-F989': 63881,
'CJK COMPATIBILITY IDEOGRAPH-F98A': 63882,
'CJK COMPATIBILITY IDEOGRAPH-F98B': 63883,
'CJK COMPATIBILITY IDEOGRAPH-F98C': 63884,
'CJK COMPATIBILITY IDEOGRAPH-F98D': 63885,
'CJK COMPATIBILITY IDEOGRAPH-F98E': 63886,
'CJK COMPATIBILITY IDEOGRAPH-F98F': 63887,
'CJK COMPATIBILITY IDEOGRAPH-F990': 63888,
'CJK COMPATIBILITY IDEOGRAPH-F991': 63889,
'CJK COMPATIBILITY IDEOGRAPH-F992': 63890,
'CJK COMPATIBILITY IDEOGRAPH-F993': 63891,
'CJK COMPATIBILITY IDEOGRAPH-F994': 63892,
'CJK COMPATIBILITY IDEOGRAPH-F995': 63893,
'CJK COMPATIBILITY IDEOGRAPH-F996': 63894,
'CJK COMPATIBILITY IDEOGRAPH-F997': 63895,
'CJK COMPATIBILITY IDEOGRAPH-F998': 63896,
'CJK COMPATIBILITY IDEOGRAPH-F999': 63897,
'CJK COMPATIBILITY IDEOGRAPH-F99A': 63898,
'CJK COMPATIBILITY IDEOGRAPH-F99B': 63899,
'CJK COMPATIBILITY IDEOGRAPH-F99C': 63900,
'CJK COMPATIBILITY IDEOGRAPH-F99D': 63901,
'CJK COMPATIBILITY IDEOGRAPH-F99E': 63902,
'CJK COMPATIBILITY IDEOGRAPH-F99F': 63903,
'CJK COMPATIBILITY IDEOGRAPH-F9A0': 63904,
'CJK COMPATIBILITY IDEOGRAPH-F9A1': 63905,
'CJK COMPATIBILITY IDEOGRAPH-F9A2': 63906,
'CJK COMPATIBILITY IDEOGRAPH-F9A3': 63907,
'CJK COMPATIBILITY IDEOGRAPH-F9A4': 63908,
'CJK COMPATIBILITY IDEOGRAPH-F9A5': 63909,
'CJK COMPATIBILITY IDEOGRAPH-F9A6': 63910,
'CJK COMPATIBILITY IDEOGRAPH-F9A7': 63911,
'CJK COMPATIBILITY IDEOGRAPH-F9A8': 63912,
'CJK COMPATIBILITY IDEOGRAPH-F9A9': 63913,
'CJK COMPATIBILITY IDEOGRAPH-F9AA': 63914,
'CJK COMPATIBILITY IDEOGRAPH-F9AB': 63915,
'CJK COMPATIBILITY IDEOGRAPH-F9AC': 63916,
'CJK COMPATIBILITY IDEOGRAPH-F9AD': 63917,
'CJK COMPATIBILITY IDEOGRAPH-F9AE': 63918,
'CJK COMPATIBILITY IDEOGRAPH-F9AF': 63919,
'CJK COMPATIBILITY IDEOGRAPH-F9B0': 63920,
'CJK COMPATIBILITY IDEOGRAPH-F9B1': 63921,
'CJK COMPATIBILITY IDEOGRAPH-F9B2': 63922,
'CJK COMPATIBILITY IDEOGRAPH-F9B3': 63923,
'CJK COMPATIBILITY IDEOGRAPH-F9B4': 63924,
'CJK COMPATIBILITY IDEOGRAPH-F9B5': 63925,
'CJK COMPATIBILITY IDEOGRAPH-F9B6': 63926,
'CJK COMPATIBILITY IDEOGRAPH-F9B7': 63927,
'CJK COMPATIBILITY IDEOGRAPH-F9B8': 63928,
'CJK COMPATIBILITY IDEOGRAPH-F9B9': 63929,
'CJK COMPATIBILITY IDEOGRAPH-F9BA': 63930,
'CJK COMPATIBILITY IDEOGRAPH-F9BB': 63931,
'CJK COMPATIBILITY IDEOGRAPH-F9BC': 63932,
'CJK COMPATIBILITY IDEOGRAPH-F9BD': 63933,
'CJK COMPATIBILITY IDEOGRAPH-F9BE': 63934,
'CJK COMPATIBILITY IDEOGRAPH-F9BF': 63935,
'CJK COMPATIBILITY IDEOGRAPH-F9C0': 63936,
'CJK COMPATIBILITY IDEOGRAPH-F9C1': 63937,
'CJK COMPATIBILITY IDEOGRAPH-F9C2': 63938,
'CJK COMPATIBILITY IDEOGRAPH-F9C3': 63939,
'CJK COMPATIBILITY IDEOGRAPH-F9C4': 63940,
'CJK COMPATIBILITY IDEOGRAPH-F9C5': 63941,
'CJK COMPATIBILITY IDEOGRAPH-F9C6': 63942,
'CJK COMPATIBILITY IDEOGRAPH-F9C7': 63943,
'CJK COMPATIBILITY IDEOGRAPH-F9C8': 63944,
'CJK COMPATIBILITY IDEOGRAPH-F9C9': 63945,
'CJK COMPATIBILITY IDEOGRAPH-F9CA': 63946,
'CJK COMPATIBILITY IDEOGRAPH-F9CB': 63947,
'CJK COMPATIBILITY IDEOGRAPH-F9CC': 63948,
'CJK COMPATIBILITY IDEOGRAPH-F9CD': 63949,
'CJK COMPATIBILITY IDEOGRAPH-F9CE': 63950,
'CJK COMPATIBILITY IDEOGRAPH-F9CF': 63951,
'CJK COMPATIBILITY IDEOGRAPH-F9D0': 63952,
'CJK COMPATIBILITY IDEOGRAPH-F9D1': 63953,
'CJK COMPATIBILITY IDEOGRAPH-F9D2': 63954,
'CJK COMPATIBILITY IDEOGRAPH-F9D3': 63955,
'CJK COMPATIBILITY IDEOGRAPH-F9D4': 63956,
'CJK COMPATIBILITY IDEOGRAPH-F9D5': 63957,
'CJK COMPATIBILITY IDEOGRAPH-F9D6': 63958,
'CJK COMPATIBILITY IDEOGRAPH-F9D7': 63959,
'CJK COMPATIBILITY IDEOGRAPH-F9D8': 63960,
'CJK COMPATIBILITY IDEOGRAPH-F9D9': 63961,
'CJK COMPATIBILITY IDEOGRAPH-F9DA': 63962,
'CJK COMPATIBILITY IDEOGRAPH-F9DB': 63963,
'CJK COMPATIBILITY IDEOGRAPH-F9DC': 63964,
'CJK COMPATIBILITY IDEOGRAPH-F9DD': 63965,
'CJK COMPATIBILITY IDEOGRAPH-F9DE': 63966,
'CJK COMPATIBILITY IDEOGRAPH-F9DF': 63967,
'CJK COMPATIBILITY IDEOGRAPH-F9E0': 63968,
'CJK COMPATIBILITY IDEOGRAPH-F9E1': 63969,
'CJK COMPATIBILITY IDEOGRAPH-F9E2': 63970,
'CJK COMPATIBILITY IDEOGRAPH-F9E3': 63971,
'CJK COMPATIBILITY IDEOGRAPH-F9E4': 63972,
'CJK COMPATIBILITY IDEOGRAPH-F9E5': 63973,
'CJK COMPATIBILITY IDEOGRAPH-F9E6': 63974,
'CJK COMPATIBILITY IDEOGRAPH-F9E7': 63975,
'CJK COMPATIBILITY IDEOGRAPH-F9E8': 63976,
'CJK COMPATIBILITY IDEOGRAPH-F9E9': 63977,
'CJK COMPATIBILITY IDEOGRAPH-F9EA': 63978,
'CJK COMPATIBILITY IDEOGRAPH-F9EB': 63979,
'CJK COMPATIBILITY IDEOGRAPH-F9EC': 63980,
'CJK COMPATIBILITY IDEOGRAPH-F9ED': 63981,
'CJK COMPATIBILITY IDEOGRAPH-F9EE': 63982,
'CJK COMPATIBILITY IDEOGRAPH-F9EF': 63983,
'CJK COMPATIBILITY IDEOGRAPH-F9F0': 63984,
'CJK COMPATIBILITY IDEOGRAPH-F9F1': 63985,
'CJK COMPATIBILITY IDEOGRAPH-F9F2': 63986,
'CJK COMPATIBILITY IDEOGRAPH-F9F3': 63987,
'CJK COMPATIBILITY IDEOGRAPH-F9F4': 63988,
'CJK COMPATIBILITY IDEOGRAPH-F9F5': 63989,
'CJK COMPATIBILITY IDEOGRAPH-F9F6': 63990,
'CJK COMPATIBILITY IDEOGRAPH-F9F7': 63991,
'CJK COMPATIBILITY IDEOGRAPH-F9F8': 63992,
'CJK COMPATIBILITY IDEOGRAPH-F9F9': 63993,
'CJK COMPATIBILITY IDEOGRAPH-F9FA': 63994,
'CJK COMPATIBILITY IDEOGRAPH-F9FB': 63995,
'CJK COMPATIBILITY IDEOGRAPH-F9FC': 63996,
'CJK COMPATIBILITY IDEOGRAPH-F9FD': 63997,
'CJK COMPATIBILITY IDEOGRAPH-F9FE': 63998,
'CJK COMPATIBILITY IDEOGRAPH-F9FF': 63999,
'CJK COMPATIBILITY IDEOGRAPH-FA00': 64000,
'CJK COMPATIBILITY IDEOGRAPH-FA01': 64001,
'CJK COMPATIBILITY IDEOGRAPH-FA02': 64002,
'CJK COMPATIBILITY IDEOGRAPH-FA03': 64003,
'CJK COMPATIBILITY IDEOGRAPH-FA04': 64004,
'CJK COMPATIBILITY IDEOGRAPH-FA05': 64005,
'CJK COMPATIBILITY IDEOGRAPH-FA06': 64006,
'CJK COMPATIBILITY IDEOGRAPH-FA07': 64007,
'CJK COMPATIBILITY IDEOGRAPH-FA08': 64008,
'CJK COMPATIBILITY IDEOGRAPH-FA09': 64009,
'CJK COMPATIBILITY IDEOGRAPH-FA0A': 64010,
'CJK COMPATIBILITY IDEOGRAPH-FA0B': 64011,
'CJK COMPATIBILITY IDEOGRAPH-FA0C': 64012,
'CJK COMPATIBILITY IDEOGRAPH-FA0D': 64013,
'CJK COMPATIBILITY IDEOGRAPH-FA0E': 64014,
'CJK COMPATIBILITY IDEOGRAPH-FA0F': 64015,
'CJK COMPATIBILITY IDEOGRAPH-FA10': 64016,
'CJK COMPATIBILITY IDEOGRAPH-FA11': 64017,
'CJK COMPATIBILITY IDEOGRAPH-FA12': 64018,
'CJK COMPATIBILITY IDEOGRAPH-FA13': 64019,
'CJK COMPATIBILITY IDEOGRAPH-FA14': 64020,
'CJK COMPATIBILITY IDEOGRAPH-FA15': 64021,
'CJK COMPATIBILITY IDEOGRAPH-FA16': 64022,
'CJK COMPATIBILITY IDEOGRAPH-FA17': 64023,
'CJK COMPATIBILITY IDEOGRAPH-FA18': 64024,
'CJK COMPATIBILITY IDEOGRAPH-FA19': 64025,
'CJK COMPATIBILITY IDEOGRAPH-FA1A': 64026,
'CJK COMPATIBILITY IDEOGRAPH-FA1B': 64027,
'CJK COMPATIBILITY IDEOGRAPH-FA1C': 64028,
'CJK COMPATIBILITY IDEOGRAPH-FA1D': 64029,
'CJK COMPATIBILITY IDEOGRAPH-FA1E': 64030,
'CJK COMPATIBILITY IDEOGRAPH-FA1F': 64031,
'CJK COMPATIBILITY IDEOGRAPH-FA20': 64032,
'CJK COMPATIBILITY IDEOGRAPH-FA21': 64033,
'CJK COMPATIBILITY IDEOGRAPH-FA22': 64034,
'CJK COMPATIBILITY IDEOGRAPH-FA23': 64035,
'CJK COMPATIBILITY IDEOGRAPH-FA24': 64036,
'CJK COMPATIBILITY IDEOGRAPH-FA25': 64037,
'CJK COMPATIBILITY IDEOGRAPH-FA26': 64038,
'CJK COMPATIBILITY IDEOGRAPH-FA27': 64039,
'CJK COMPATIBILITY IDEOGRAPH-FA28': 64040,
'CJK COMPATIBILITY IDEOGRAPH-FA29': 64041,
'CJK COMPATIBILITY IDEOGRAPH-FA2A': 64042,
'CJK COMPATIBILITY IDEOGRAPH-FA2B': 64043,
'CJK COMPATIBILITY IDEOGRAPH-FA2C': 64044,
'CJK COMPATIBILITY IDEOGRAPH-FA2D': 64045,
'CJK COMPATIBILITY IDEOGRAPH-FA30': 64048,
'CJK COMPATIBILITY IDEOGRAPH-FA31': 64049,
'CJK COMPATIBILITY IDEOGRAPH-FA32': 64050,
'CJK COMPATIBILITY IDEOGRAPH-FA33': 64051,
'CJK COMPATIBILITY IDEOGRAPH-FA34': 64052,
'CJK COMPATIBILITY IDEOGRAPH-FA35': 64053,
'CJK COMPATIBILITY IDEOGRAPH-FA36': 64054,
'CJK COMPATIBILITY IDEOGRAPH-FA37': 64055,
'CJK COMPATIBILITY IDEOGRAPH-FA38': 64056,
'CJK COMPATIBILITY IDEOGRAPH-FA39': 64057,
'CJK COMPATIBILITY IDEOGRAPH-FA3A': 64058,
'CJK COMPATIBILITY IDEOGRAPH-FA3B': 64059,
'CJK COMPATIBILITY IDEOGRAPH-FA3C': 64060,
'CJK COMPATIBILITY IDEOGRAPH-FA3D': 64061,
'CJK COMPATIBILITY IDEOGRAPH-FA3E': 64062,
'CJK COMPATIBILITY IDEOGRAPH-FA3F': 64063,
'CJK COMPATIBILITY IDEOGRAPH-FA40': 64064,
'CJK COMPATIBILITY IDEOGRAPH-FA41': 64065,
'CJK COMPATIBILITY IDEOGRAPH-FA42': 64066,
'CJK COMPATIBILITY IDEOGRAPH-FA43': 64067,
'CJK COMPATIBILITY IDEOGRAPH-FA44': 64068,
'CJK COMPATIBILITY IDEOGRAPH-FA45': 64069,
'CJK COMPATIBILITY IDEOGRAPH-FA46': 64070,
'CJK COMPATIBILITY IDEOGRAPH-FA47': 64071,
'CJK COMPATIBILITY IDEOGRAPH-FA48': 64072,
'CJK COMPATIBILITY IDEOGRAPH-FA49': 64073,
'CJK COMPATIBILITY IDEOGRAPH-FA4A': 64074,
'CJK COMPATIBILITY IDEOGRAPH-FA4B': 64075,
'CJK COMPATIBILITY IDEOGRAPH-FA4C': 64076,
'CJK COMPATIBILITY IDEOGRAPH-FA4D': 64077,
'CJK COMPATIBILITY IDEOGRAPH-FA4E': 64078,
'CJK COMPATIBILITY IDEOGRAPH-FA4F': 64079,
'CJK COMPATIBILITY IDEOGRAPH-FA50': 64080,
'CJK COMPATIBILITY IDEOGRAPH-FA51': 64081,
'CJK COMPATIBILITY IDEOGRAPH-FA52': 64082,
'CJK COMPATIBILITY IDEOGRAPH-FA53': 64083,
'CJK COMPATIBILITY IDEOGRAPH-FA54': 64084,
'CJK COMPATIBILITY IDEOGRAPH-FA55': 64085,
'CJK COMPATIBILITY IDEOGRAPH-FA56': 64086,
'CJK COMPATIBILITY IDEOGRAPH-FA57': 64087,
'CJK COMPATIBILITY IDEOGRAPH-FA58': 64088,
'CJK COMPATIBILITY IDEOGRAPH-FA59': 64089,
'CJK COMPATIBILITY IDEOGRAPH-FA5A': 64090,
'CJK COMPATIBILITY IDEOGRAPH-FA5B': 64091,
'CJK COMPATIBILITY IDEOGRAPH-FA5C': 64092,
'CJK COMPATIBILITY IDEOGRAPH-FA5D': 64093,
'CJK COMPATIBILITY IDEOGRAPH-FA5E': 64094,
'CJK COMPATIBILITY IDEOGRAPH-FA5F': 64095,
'CJK COMPATIBILITY IDEOGRAPH-FA60': 64096,
'CJK COMPATIBILITY IDEOGRAPH-FA61': 64097,
'CJK COMPATIBILITY IDEOGRAPH-FA62': 64098,
'CJK COMPATIBILITY IDEOGRAPH-FA63': 64099,
'CJK COMPATIBILITY IDEOGRAPH-FA64': 64100,
'CJK COMPATIBILITY IDEOGRAPH-FA65': 64101,
'CJK COMPATIBILITY IDEOGRAPH-FA66': 64102,
'CJK COMPATIBILITY IDEOGRAPH-FA67': 64103,
'CJK COMPATIBILITY IDEOGRAPH-FA68': 64104,
'CJK COMPATIBILITY IDEOGRAPH-FA69': 64105,
'CJK COMPATIBILITY IDEOGRAPH-FA6A': 64106,
'CJK RADICAL BAMBOO': 11950,
'CJK RADICAL BLUE': 11992,
'CJK RADICAL BOLT OF CLOTH': 11946,
'CJK RADICAL BONE': 12003,
'CJK RADICAL BOX': 11910,
'CJK RADICAL BRUSH ONE': 11962,
'CJK RADICAL BRUSH TWO': 11963,
'CJK RADICAL C-SIMPLIFIED BIRD': 12006,
'CJK RADICAL C-SIMPLIFIED CART': 11979,
'CJK RADICAL C-SIMPLIFIED DRAGON': 12016,
'CJK RADICAL C-SIMPLIFIED EAT': 12000,
'CJK RADICAL C-SIMPLIFIED EVEN': 12012,
'CJK RADICAL C-SIMPLIFIED FISH': 12005,
'CJK RADICAL C-SIMPLIFIED FLY': 11996,
'CJK RADICAL C-SIMPLIFIED FROG': 12010,
'CJK RADICAL C-SIMPLIFIED GATE': 11988,
'CJK RADICAL C-SIMPLIFIED GOLD': 11984,
'CJK RADICAL C-SIMPLIFIED HORSE': 12002,
'CJK RADICAL C-SIMPLIFIED LEAF': 11994,
'CJK RADICAL C-SIMPLIFIED LONG': 11987,
'CJK RADICAL C-SIMPLIFIED SALT': 12007,
'CJK RADICAL C-SIMPLIFIED SEE': 11973,
'CJK RADICAL C-SIMPLIFIED SHELL': 11977,
'CJK RADICAL C-SIMPLIFIED SILK': 11952,
'CJK RADICAL C-SIMPLIFIED SPEECH': 11976,
'CJK RADICAL C-SIMPLIFIED TANNED LEATHER': 11993,
'CJK RADICAL C-SIMPLIFIED TOOTH': 12014,
'CJK RADICAL C-SIMPLIFIED TURTLE': 12019,
'CJK RADICAL C-SIMPLIFIED WIND': 11995,
'CJK RADICAL CHOKE': 11931,
'CJK RADICAL CITY': 11983,
'CJK RADICAL CIVILIAN': 11936,
'CJK RADICAL CLIFF': 11905,
'CJK RADICAL CLOTHES': 11970,
'CJK RADICAL COW': 11943,
'CJK RADICAL DEATH': 11934,
'CJK RADICAL DIVINATION': 11914,
'CJK RADICAL DOG': 11944,
'CJK RADICAL EAT ONE': 11997,
'CJK RADICAL EAT THREE': 11999,
'CJK RADICAL EAT TWO': 11998,
'CJK RADICAL EWE': 11960,
'CJK RADICAL EYE': 11947,
'CJK RADICAL FIRE': 11939,
'CJK RADICAL FOOT': 11978,
'CJK RADICAL GHOST': 12004,
'CJK RADICAL GRASS ONE': 11966,
'CJK RADICAL GRASS THREE': 11968,
'CJK RADICAL GRASS TWO': 11967,
'CJK RADICAL HAND': 11928,
'CJK RADICAL HEAD': 12001,
'CJK RADICAL HEART ONE': 11926,
'CJK RADICAL HEART TWO': 11927,
'CJK RADICAL HORN': 11975,
'CJK RADICAL J-SIMPLIFIED DRAGON': 12015,
'CJK RADICAL J-SIMPLIFIED EVEN': 12011,
'CJK RADICAL J-SIMPLIFIED TOOTH': 12013,
'CJK RADICAL J-SIMPLIFIED TURTLE': 12018,
'CJK RADICAL JADE': 11945,
'CJK RADICAL KNIFE ONE': 11912,
'CJK RADICAL KNIFE TWO': 11913,
'CJK RADICAL LAME FOUR': 11921,
'CJK RADICAL LAME ONE': 11918,
'CJK RADICAL LAME THREE': 11920,
'CJK RADICAL LAME TWO': 11919,
'CJK RADICAL LONG ONE': 11985,
'CJK RADICAL LONG TWO': 11986,
'CJK RADICAL MEAT': 11964,
'CJK RADICAL MESH': 11957,
'CJK RADICAL MOON': 11933,
'CJK RADICAL MORTAR': 11965,
'CJK RADICAL MOTHER': 11935,
'CJK RADICAL MOUND ONE': 11989,
'CJK RADICAL MOUND TWO': 11990,
'CJK RADICAL NET FOUR': 11956,
'CJK RADICAL NET ONE': 11953,
'CJK RADICAL NET THREE': 11955,
'CJK RADICAL NET TWO': 11954,
'CJK RADICAL OLD': 11961,
'CJK RADICAL PAW ONE': 11940,
'CJK RADICAL PAW TWO': 11941,
'CJK RADICAL PERSON': 11909,
'CJK RADICAL RAIN': 11991,
'CJK RADICAL RAM': 11959,
'CJK RADICAL RAP': 11929,
'CJK RADICAL REPEAT': 11904,
'CJK RADICAL SEAL': 11915,
'CJK RADICAL SECOND ONE': 11906,
'CJK RADICAL SECOND THREE': 11908,
'CJK RADICAL SECOND TWO': 11907,
'CJK RADICAL SHEEP': 11958,
'CJK RADICAL SILK': 11951,
'CJK RADICAL SIMPLIFIED HALF TREE TRUNK': 11942,
'CJK RADICAL SIMPLIFIED HORN': 11974,
'CJK RADICAL SIMPLIFIED WALK': 11980,
'CJK RADICAL SIMPLIFIED WHEAT': 12008,
'CJK RADICAL SIMPLIFIED YELLOW': 12009,
'CJK RADICAL SMALL ONE': 11916,
'CJK RADICAL SMALL TWO': 11917,
'CJK RADICAL SNAKE': 11922,
'CJK RADICAL SNOUT ONE': 11924,
'CJK RADICAL SNOUT TWO': 11925,
'CJK RADICAL SPIRIT ONE': 11948,
'CJK RADICAL SPIRIT TWO': 11949,
'CJK RADICAL SUN': 11932,
'CJK RADICAL TABLE': 11911,
'CJK RADICAL THREAD': 11923,
'CJK RADICAL TIGER': 11969,
'CJK RADICAL TURTLE': 12017,
'CJK RADICAL WALK ONE': 11981,
'CJK RADICAL WALK TWO': 11982,
'CJK RADICAL WATER ONE': 11937,
'CJK RADICAL WATER TWO': 11938,
'CJK RADICAL WEST ONE': 11971,
'CJK RADICAL WEST TWO': 11972,
'CLEAR SCREEN SYMBOL': 9114,
'CLOCKWISE CLOSED CIRCLE ARROW': 10561,
'CLOCKWISE CONTOUR INTEGRAL': 8754,
'CLOCKWISE GAPPED CIRCLE ARROW': 10227,
'CLOCKWISE INTEGRAL': 8753,
'CLOCKWISE OPEN CIRCLE ARROW': 8635,
'CLOCKWISE TOP SEMICIRCLE ARROW': 8631,
'CLOSE UP': 8272,
'CLOSED INTERSECTION WITH SERIFS': 10829,
'CLOSED SUBSET': 10959,
'CLOSED SUBSET OR EQUAL TO': 10961,
'CLOSED SUPERSET': 10960,
'CLOSED SUPERSET OR EQUAL TO': 10962,
'CLOSED UNION WITH SERIFS': 10828,
'CLOSED UNION WITH SERIFS AND SMASH PRODUCT': 10832,
'CLOUD': 9729,
'COLON': 58,
'COLON EQUALS': 8788,
'COLON SIGN': 8353,
'COMBINING ACUTE ACCENT': 769,
'COMBINING ACUTE ACCENT BELOW': 791,
'COMBINING ACUTE TONE MARK': 833,
'COMBINING ALMOST EQUAL TO ABOVE': 844,
'COMBINING ANNUITY SYMBOL': 8423,
'COMBINING ANTICLOCKWISE ARROW ABOVE': 8404,
'COMBINING ANTICLOCKWISE RING OVERLAY': 8410,
'COMBINING BREVE': 774,
'COMBINING BREVE BELOW': 814,
'COMBINING BRIDGE ABOVE': 838,
'COMBINING BRIDGE BELOW': 810,
'COMBINING CANDRABINDU': 784,
'COMBINING CARON': 780,
'COMBINING CARON BELOW': 812,
'COMBINING CEDILLA': 807,
'COMBINING CIRCUMFLEX ACCENT': 770,
'COMBINING CIRCUMFLEX ACCENT BELOW': 813,
'COMBINING CLOCKWISE ARROW ABOVE': 8405,
'COMBINING CLOCKWISE RING OVERLAY': 8409,
'COMBINING COMMA ABOVE': 787,
'COMBINING COMMA ABOVE RIGHT': 789,
'COMBINING COMMA BELOW': 806,
'COMBINING CYRILLIC DASIA PNEUMATA': 1157,
'COMBINING CYRILLIC HUNDRED THOUSANDS SIGN': 1160,
'COMBINING CYRILLIC MILLIONS SIGN': 1161,
'COMBINING CYRILLIC PALATALIZATION': 1156,
'COMBINING CYRILLIC PSILI PNEUMATA': 1158,
'COMBINING CYRILLIC TITLO': 1155,
'COMBINING DIAERESIS': 776,
'COMBINING DIAERESIS BELOW': 804,
'COMBINING DOT ABOVE': 775,
'COMBINING DOT BELOW': 803,
'COMBINING DOUBLE ACUTE ACCENT': 779,
'COMBINING DOUBLE GRAVE ACCENT': 783,
'COMBINING DOUBLE INVERTED BREVE': 865,
'COMBINING DOUBLE LOW LINE': 819,
'COMBINING DOUBLE OVERLINE': 831,
'COMBINING DOUBLE RIGHTWARDS ARROW BELOW': 866,
'COMBINING DOUBLE TILDE': 864,
'COMBINING DOUBLE TILDE LEFT HALF': 65058,
'COMBINING DOUBLE TILDE RIGHT HALF': 65059,
'COMBINING DOUBLE VERTICAL LINE ABOVE': 782,
'COMBINING DOUBLE VERTICAL LINE BELOW': 840,
'COMBINING DOUBLE VERTICAL STROKE OVERLAY': 8422,
'COMBINING DOWN TACK BELOW': 798,
'COMBINING ENCLOSING CIRCLE': 8413,
'COMBINING ENCLOSING CIRCLE BACKSLASH': 8416,
'COMBINING ENCLOSING DIAMOND': 8415,
'COMBINING ENCLOSING KEYCAP': 8419,
'COMBINING ENCLOSING SCREEN': 8418,
'COMBINING ENCLOSING SQUARE': 8414,
'COMBINING ENCLOSING UPWARD POINTING TRIANGLE': 8420,
'COMBINING EQUALS SIGN BELOW': 839,
'COMBINING FOUR DOTS ABOVE': 8412,
'COMBINING GRAPHEME JOINER': 847,
'COMBINING GRAVE ACCENT': 768,
'COMBINING GRAVE ACCENT BELOW': 790,
'COMBINING GRAVE TONE MARK': 832,
'COMBINING GREEK DIALYTIKA TONOS': 836,
'COMBINING GREEK KORONIS': 835,
'COMBINING GREEK PERISPOMENI': 834,
'COMBINING GREEK YPOGEGRAMMENI': 837,
'COMBINING HOMOTHETIC ABOVE': 843,
'COMBINING HOOK ABOVE': 777,
'COMBINING HORN': 795,
'COMBINING INVERTED BREVE': 785,
'COMBINING INVERTED BREVE BELOW': 815,
'COMBINING INVERTED BRIDGE BELOW': 826,
'COMBINING INVERTED DOUBLE ARCH BELOW': 811,
'COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK': 12442,
'COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK': 12441,
'COMBINING LATIN SMALL LETTER A': 867,
'COMBINING LATIN SMALL LETTER C': 872,
'COMBINING LATIN SMALL LETTER D': 873,
'COMBINING LATIN SMALL LETTER E': 868,
'COMBINING LATIN SMALL LETTER H': 874,
'COMBINING LATIN SMALL LETTER I': 869,
'COMBINING LATIN SMALL LETTER M': 875,
'COMBINING LATIN SMALL LETTER O': 870,
'COMBINING LATIN SMALL LETTER R': 876,
'COMBINING LATIN SMALL LETTER T': 877,
'COMBINING LATIN SMALL LETTER U': 871,
'COMBINING LATIN SMALL LETTER V': 878,
'COMBINING LATIN SMALL LETTER X': 879,
'COMBINING LEFT ANGLE ABOVE': 794,
'COMBINING LEFT ANGLE BELOW': 841,
'COMBINING LEFT ARROW ABOVE': 8406,
'COMBINING LEFT HALF RING BELOW': 796,
'COMBINING LEFT HARPOON ABOVE': 8400,
'COMBINING LEFT RIGHT ARROW ABOVE': 8417,
'COMBINING LEFT RIGHT ARROW BELOW': 845,
'COMBINING LEFT TACK BELOW': 792,
'COMBINING LEFTWARDS ARROW OVERLAY': 8426,
'COMBINING LIGATURE LEFT HALF': 65056,
'COMBINING LIGATURE RIGHT HALF': 65057,
'COMBINING LONG SOLIDUS OVERLAY': 824,
'COMBINING LONG STROKE OVERLAY': 822,
'COMBINING LONG VERTICAL LINE OVERLAY': 8402,
'COMBINING LOW LINE': 818,
'COMBINING MACRON': 772,
'COMBINING MACRON BELOW': 817,
'COMBINING MINUS SIGN BELOW': 800,
'COMBINING NOT TILDE ABOVE': 842,
'COMBINING OGONEK': 808,
'COMBINING OVERLINE': 773,
'COMBINING PALATALIZED HOOK BELOW': 801,
'COMBINING PLUS SIGN BELOW': 799,
'COMBINING RETROFLEX HOOK BELOW': 802,
'COMBINING REVERSE SOLIDUS OVERLAY': 8421,
'COMBINING REVERSED COMMA ABOVE': 788,
'COMBINING RIGHT ARROW ABOVE': 8407,
'COMBINING RIGHT HALF RING BELOW': 825,
'COMBINING RIGHT HARPOON ABOVE': 8401,
'COMBINING RIGHT TACK BELOW': 793,
'COMBINING RING ABOVE': 778,
'COMBINING RING BELOW': 805,
'COMBINING RING OVERLAY': 8408,
'COMBINING SEAGULL BELOW': 828,
'COMBINING SHORT SOLIDUS OVERLAY': 823,
'COMBINING SHORT STROKE OVERLAY': 821,
'COMBINING SHORT VERTICAL LINE OVERLAY': 8403,
'COMBINING SQUARE BELOW': 827,
'COMBINING THREE DOTS ABOVE': 8411,
'COMBINING TILDE': 771,
'COMBINING TILDE BELOW': 816,
'COMBINING TILDE OVERLAY': 820,
'COMBINING TRIPLE UNDERDOT': 8424,
'COMBINING TURNED COMMA ABOVE': 786,
'COMBINING UP TACK BELOW': 797,
'COMBINING UPWARDS ARROW BELOW': 846,
'COMBINING VERTICAL LINE ABOVE': 781,
'COMBINING VERTICAL LINE BELOW': 809,
'COMBINING VERTICAL TILDE': 830,
'COMBINING WIDE BRIDGE ABOVE': 8425,
'COMBINING X ABOVE': 829,
'COMET': 9732,
'COMMA': 44,
'COMMERCIAL AT': 64,
'COMMERCIAL MINUS SIGN': 8274,
'COMPLEMENT': 8705,
'COMPOSITION SYMBOL': 9092,
'CONGRUENT WITH DOT ABOVE': 10861,
'CONICAL TAPER': 9010,
'CONJUNCTION': 9740,
'CONTAINS AS MEMBER': 8715,
'CONTAINS AS NORMAL SUBGROUP': 8883,
'CONTAINS AS NORMAL SUBGROUP OR EQUAL TO': 8885,
'CONTAINS WITH LONG HORIZONTAL STROKE': 8954,
'CONTAINS WITH OVERBAR': 8957,
'CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE': 8955,
'CONTINUOUS UNDERLINE SYMBOL': 9089,
'CONTOUR INTEGRAL': 8750,
'COPTIC CAPITAL LETTER DEI': 1006,
'COPTIC CAPITAL LETTER FEI': 996,
'COPTIC CAPITAL LETTER GANGIA': 1002,
'COPTIC CAPITAL LETTER HORI': 1000,
'COPTIC CAPITAL LETTER KHEI': 998,
'COPTIC CAPITAL LETTER SHEI': 994,
'COPTIC CAPITAL LETTER SHIMA': 1004,
'COPTIC SMALL LETTER DEI': 1007,
'COPTIC SMALL LETTER FEI': 997,
'COPTIC SMALL LETTER GANGIA': 1003,
'COPTIC SMALL LETTER HORI': 1001,
'COPTIC SMALL LETTER KHEI': 999,
'COPTIC SMALL LETTER SHEI': 995,
'COPTIC SMALL LETTER SHIMA': 1005,
'COPYRIGHT SIGN': 169,
'CORRESPONDS TO': 8792,
'COUNTERBORE': 9012,
'COUNTERSINK': 9013,
'CROSS OF JERUSALEM': 9769,
'CROSS OF LORRAINE': 9768,
'CRUZEIRO SIGN': 8354,
'CUBE ROOT': 8731,
'CURLY BRACKET EXTENSION': 9130,
'CURLY LOGICAL AND': 8911,
'CURLY LOGICAL OR': 8910,
'CURRENCY SIGN': 164,
'CURVED STEM PARAGRAPH SIGN ORNAMENT': 10081,
'CYLINDRICITY': 9005,
'CYRILLIC CAPITAL LETTER A': 1040,
'CYRILLIC CAPITAL LETTER A WITH BREVE': 1232,
'CYRILLIC CAPITAL LETTER A WITH DIAERESIS': 1234,
'CYRILLIC CAPITAL LETTER ABKHASIAN CHE': 1212,
'CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER': 1214,
'CYRILLIC CAPITAL LETTER ABKHASIAN DZE': 1248,
'CYRILLIC CAPITAL LETTER ABKHASIAN HA': 1192,
'CYRILLIC CAPITAL LETTER BARRED O': 1256,
'CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS': 1258,
'CYRILLIC CAPITAL LETTER BASHKIR KA': 1184,
'CYRILLIC CAPITAL LETTER BE': 1041,
'CYRILLIC CAPITAL LETTER BIG YUS': 1130,
'CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I': 1030,
'CYRILLIC CAPITAL LETTER CHE': 1063,
'CYRILLIC CAPITAL LETTER CHE WITH DESCENDER': 1206,
'CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS': 1268,
'CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE': 1208,
'CYRILLIC CAPITAL LETTER DE': 1044,
'CYRILLIC CAPITAL LETTER DJE': 1026,
'CYRILLIC CAPITAL LETTER DZE': 1029,
'CYRILLIC CAPITAL LETTER DZHE': 1039,
'CYRILLIC CAPITAL LETTER E': 1069,
'CYRILLIC CAPITAL LETTER E WITH DIAERESIS': 1260,
'CYRILLIC CAPITAL LETTER EF': 1060,
'CYRILLIC CAPITAL LETTER EL': 1051,
'CYRILLIC CAPITAL LETTER EL WITH TAIL': 1221,
'CYRILLIC CAPITAL LETTER EM': 1052,
'CYRILLIC CAPITAL LETTER EM WITH TAIL': 1229,
'CYRILLIC CAPITAL LETTER EN': 1053,
'CYRILLIC CAPITAL LETTER EN WITH DESCENDER': 1186,
'CYRILLIC CAPITAL LETTER EN WITH HOOK': 1223,
'CYRILLIC CAPITAL LETTER EN WITH TAIL': 1225,
'CYRILLIC CAPITAL LETTER ER': 1056,
'CYRILLIC CAPITAL LETTER ER WITH TICK': 1166,
'CYRILLIC CAPITAL LETTER ES': 1057,
'CYRILLIC CAPITAL LETTER ES WITH DESCENDER': 1194,
'CYRILLIC CAPITAL LETTER FITA': 1138,
'CYRILLIC CAPITAL LETTER GHE': 1043,
'CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK': 1172,
'CYRILLIC CAPITAL LETTER GHE WITH STROKE': 1170,
'CYRILLIC CAPITAL LETTER GHE WITH UPTURN': 1168,
'CYRILLIC CAPITAL LETTER GJE': 1027,
'CYRILLIC CAPITAL LETTER HA': 1061,
'CYRILLIC CAPITAL LETTER HA WITH DESCENDER': 1202,
'CYRILLIC CAPITAL LETTER HARD SIGN': 1066,
'CYRILLIC CAPITAL LETTER I': 1048,
'CYRILLIC CAPITAL LETTER I WITH DIAERESIS': 1252,
'CYRILLIC CAPITAL LETTER I WITH GRAVE': 1037,
'CYRILLIC CAPITAL LETTER I WITH MACRON': 1250,
'CYRILLIC CAPITAL LETTER IE': 1045,
'CYRILLIC CAPITAL LETTER IE WITH BREVE': 1238,
'CYRILLIC CAPITAL LETTER IE WITH GRAVE': 1024,
'CYRILLIC CAPITAL LETTER IO': 1025,
'CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS': 1132,
'CYRILLIC CAPITAL LETTER IOTIFIED E': 1124,
'CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS': 1128,
'CYRILLIC CAPITAL LETTER IZHITSA': 1140,
'CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT': 1142,
'CYRILLIC CAPITAL LETTER JE': 1032,
'CYRILLIC CAPITAL LETTER KA': 1050,
'CYRILLIC CAPITAL LETTER KA WITH DESCENDER': 1178,
'CYRILLIC CAPITAL LETTER KA WITH HOOK': 1219,
'CYRILLIC CAPITAL LETTER KA WITH STROKE': 1182,
'CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE': 1180,
'CYRILLIC CAPITAL LETTER KHAKASSIAN CHE': 1227,
'CYRILLIC CAPITAL LETTER KJE': 1036,
'CYRILLIC CAPITAL LETTER KOMI DE': 1280,
'CYRILLIC CAPITAL LETTER KOMI DJE': 1282,
'CYRILLIC CAPITAL LETTER KOMI DZJE': 1286,
'CYRILLIC CAPITAL LETTER KOMI LJE': 1288,
'CYRILLIC CAPITAL LETTER KOMI NJE': 1290,
'CYRILLIC CAPITAL LETTER KOMI SJE': 1292,
'CYRILLIC CAPITAL LETTER KOMI TJE': 1294,
'CYRILLIC CAPITAL LETTER KOMI ZJE': 1284,
'CYRILLIC CAPITAL LETTER KOPPA': 1152,
'CYRILLIC CAPITAL LETTER KSI': 1134,
'CYRILLIC CAPITAL LETTER LITTLE YUS': 1126,
'CYRILLIC CAPITAL LETTER LJE': 1033,
'CYRILLIC CAPITAL LETTER NJE': 1034,
'CYRILLIC CAPITAL LETTER O': 1054,
'CYRILLIC CAPITAL LETTER O WITH DIAERESIS': 1254,
'CYRILLIC CAPITAL LETTER OMEGA': 1120,
'CYRILLIC CAPITAL LETTER OMEGA WITH TITLO': 1148,
'CYRILLIC CAPITAL LETTER OT': 1150,
'CYRILLIC CAPITAL LETTER PE': 1055,
'CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK': 1190,
'CYRILLIC CAPITAL LETTER PSI': 1136,
'CYRILLIC CAPITAL LETTER ROUND OMEGA': 1146,
'CYRILLIC CAPITAL LETTER SCHWA': 1240,
'CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS': 1242,
'CYRILLIC CAPITAL LETTER SEMISOFT SIGN': 1164,
'CYRILLIC CAPITAL LETTER SHA': 1064,
'CYRILLIC CAPITAL LETTER SHCHA': 1065,
'CYRILLIC CAPITAL LETTER SHHA': 1210,
'CYRILLIC CAPITAL LETTER SHORT I': 1049,
'CYRILLIC CAPITAL LETTER SHORT I WITH TAIL': 1162,
'CYRILLIC CAPITAL LETTER SHORT U': 1038,
'CYRILLIC CAPITAL LETTER SOFT SIGN': 1068,
'CYRILLIC CAPITAL LETTER STRAIGHT U': 1198,
'CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE': 1200,
'CYRILLIC CAPITAL LETTER TE': 1058,
'CYRILLIC CAPITAL LETTER TE WITH DESCENDER': 1196,
'CYRILLIC CAPITAL LETTER TSE': 1062,
'CYRILLIC CAPITAL LETTER TSHE': 1035,
'CYRILLIC CAPITAL LETTER U': 1059,
'CYRILLIC CAPITAL LETTER U WITH DIAERESIS': 1264,
'CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE': 1266,
'CYRILLIC CAPITAL LETTER U WITH MACRON': 1262,
'CYRILLIC CAPITAL LETTER UK': 1144,
'CYRILLIC CAPITAL LETTER UKRAINIAN IE': 1028,
'CYRILLIC CAPITAL LETTER VE': 1042,
'CYRILLIC CAPITAL LETTER YA': 1071,
'CYRILLIC CAPITAL LETTER YAT': 1122,
'CYRILLIC CAPITAL LETTER YERU': 1067,
'CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS': 1272,
'CYRILLIC CAPITAL LETTER YI': 1031,
'CYRILLIC CAPITAL LETTER YU': 1070,
'CYRILLIC CAPITAL LETTER ZE': 1047,
'CYRILLIC CAPITAL LETTER ZE WITH DESCENDER': 1176,
'CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS': 1246,
'CYRILLIC CAPITAL LETTER ZHE': 1046,
'CYRILLIC CAPITAL LETTER ZHE WITH BREVE': 1217,
'CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER': 1174,
'CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS': 1244,
'CYRILLIC CAPITAL LIGATURE A IE': 1236,
'CYRILLIC CAPITAL LIGATURE EN GHE': 1188,
'CYRILLIC CAPITAL LIGATURE TE TSE': 1204,
'CYRILLIC LETTER PALOCHKA': 1216,
'CYRILLIC SMALL LETTER A': 1072,
'CYRILLIC SMALL LETTER A WITH BREVE': 1233,
'CYRILLIC SMALL LETTER A WITH DIAERESIS': 1235,
'CYRILLIC SMALL LETTER ABKHASIAN CHE': 1213,
'CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER': 1215,
'CYRILLIC SMALL LETTER ABKHASIAN DZE': 1249,
'CYRILLIC SMALL LETTER ABKHASIAN HA': 1193,
'CYRILLIC SMALL LETTER BARRED O': 1257,
'CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS': 1259,
'CYRILLIC SMALL LETTER BASHKIR KA': 1185,
'CYRILLIC SMALL LETTER BE': 1073,
'CYRILLIC SMALL LETTER BIG YUS': 1131,
'CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I': 1110,
'CYRILLIC SMALL LETTER CHE': 1095,
'CYRILLIC SMALL LETTER CHE WITH DESCENDER': 1207,
'CYRILLIC SMALL LETTER CHE WITH DIAERESIS': 1269,
'CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE': 1209,
'CYRILLIC SMALL LETTER DE': 1076,
'CYRILLIC SMALL LETTER DJE': 1106,
'CYRILLIC SMALL LETTER DZE': 1109,
'CYRILLIC SMALL LETTER DZHE': 1119,
'CYRILLIC SMALL LETTER E': 1101,
'CYRILLIC SMALL LETTER E WITH DIAERESIS': 1261,
'CYRILLIC SMALL LETTER EF': 1092,
'CYRILLIC SMALL LETTER EL': 1083,
'CYRILLIC SMALL LETTER EL WITH TAIL': 1222,
'CYRILLIC SMALL LETTER EM': 1084,
'CYRILLIC SMALL LETTER EM WITH TAIL': 1230,
'CYRILLIC SMALL LETTER EN': 1085,
'CYRILLIC SMALL LETTER EN WITH DESCENDER': 1187,
'CYRILLIC SMALL LETTER EN WITH HOOK': 1224,
'CYRILLIC SMALL LETTER EN WITH TAIL': 1226,
'CYRILLIC SMALL LETTER ER': 1088,
'CYRILLIC SMALL LETTER ER WITH TICK': 1167,
'CYRILLIC SMALL LETTER ES': 1089,
'CYRILLIC SMALL LETTER ES WITH DESCENDER': 1195,
'CYRILLIC SMALL LETTER FITA': 1139,
'CYRILLIC SMALL LETTER GHE': 1075,
'CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK': 1173,
'CYRILLIC SMALL LETTER GHE WITH STROKE': 1171,
'CYRILLIC SMALL LETTER GHE WITH UPTURN': 1169,
'CYRILLIC SMALL LETTER GJE': 1107,
'CYRILLIC SMALL LETTER HA': 1093,
'CYRILLIC SMALL LETTER HA WITH DESCENDER': 1203,
'CYRILLIC SMALL LETTER HARD SIGN': 1098,
'CYRILLIC SMALL LETTER I': 1080,
'CYRILLIC SMALL LETTER I WITH DIAERESIS': 1253,
'CYRILLIC SMALL LETTER I WITH GRAVE': 1117,
'CYRILLIC SMALL LETTER I WITH MACRON': 1251,
'CYRILLIC SMALL LETTER IE': 1077,
'CYRILLIC SMALL LETTER IE WITH BREVE': 1239,
'CYRILLIC SMALL LETTER IE WITH GRAVE': 1104,
'CYRILLIC SMALL LETTER IO': 1105,
'CYRILLIC SMALL LETTER IOTIFIED BIG YUS': 1133,
'CYRILLIC SMALL LETTER IOTIFIED E': 1125,
'CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS': 1129,
'CYRILLIC SMALL LETTER IZHITSA': 1141,
'CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT': 1143,
'CYRILLIC SMALL LETTER JE': 1112,
'CYRILLIC SMALL LETTER KA': 1082,
'CYRILLIC SMALL LETTER KA WITH DESCENDER': 1179,
'CYRILLIC SMALL LETTER KA WITH HOOK': 1220,
'CYRILLIC SMALL LETTER KA WITH STROKE': 1183,
'CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE': 1181,
'CYRILLIC SMALL LETTER KHAKASSIAN CHE': 1228,
'CYRILLIC SMALL LETTER KJE': 1116,
'CYRILLIC SMALL LETTER KOMI DE': 1281,
'CYRILLIC SMALL LETTER KOMI DJE': 1283,
'CYRILLIC SMALL LETTER KOMI DZJE': 1287,
'CYRILLIC SMALL LETTER KOMI LJE': 1289,
'CYRILLIC SMALL LETTER KOMI NJE': 1291,
'CYRILLIC SMALL LETTER KOMI SJE': 1293,
'CYRILLIC SMALL LETTER KOMI TJE': 1295,
'CYRILLIC SMALL LETTER KOMI ZJE': 1285,
'CYRILLIC SMALL LETTER KOPPA': 1153,
'CYRILLIC SMALL LETTER KSI': 1135,
'CYRILLIC SMALL LETTER LITTLE YUS': 1127,
'CYRILLIC SMALL LETTER LJE': 1113,
'CYRILLIC SMALL LETTER NJE': 1114,
'CYRILLIC SMALL LETTER O': 1086,
'CYRILLIC SMALL LETTER O WITH DIAERESIS': 1255,
'CYRILLIC SMALL LETTER OMEGA': 1121,
'CYRILLIC SMALL LETTER OMEGA WITH TITLO': 1149,
'CYRILLIC SMALL LETTER OT': 1151,
'CYRILLIC SMALL LETTER PE': 1087,
'CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK': 1191,
'CYRILLIC SMALL LETTER PSI': 1137,
'CYRILLIC SMALL LETTER ROUND OMEGA': 1147,
'CYRILLIC SMALL LETTER SCHWA': 1241,
'CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS': 1243,
'CYRILLIC SMALL LETTER SEMISOFT SIGN': 1165,
'CYRILLIC SMALL LETTER SHA': 1096,
'CYRILLIC SMALL LETTER SHCHA': 1097,
'CYRILLIC SMALL LETTER SHHA': 1211,
'CYRILLIC SMALL LETTER SHORT I': 1081,
'CYRILLIC SMALL LETTER SHORT I WITH TAIL': 1163,
'CYRILLIC SMALL LETTER SHORT U': 1118,
'CYRILLIC SMALL LETTER SOFT SIGN': 1100,
'CYRILLIC SMALL LETTER STRAIGHT U': 1199,
'CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE': 1201,
'CYRILLIC SMALL LETTER TE': 1090,
'CYRILLIC SMALL LETTER TE WITH DESCENDER': 1197,
'CYRILLIC SMALL LETTER TSE': 1094,
'CYRILLIC SMALL LETTER TSHE': 1115,
'CYRILLIC SMALL LETTER U': 1091,
'CYRILLIC SMALL LETTER U WITH DIAERESIS': 1265,
'CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE': 1267,
'CYRILLIC SMALL LETTER U WITH MACRON': 1263,
'CYRILLIC SMALL LETTER UK': 1145,
'CYRILLIC SMALL LETTER UKRAINIAN IE': 1108,
'CYRILLIC SMALL LETTER VE': 1074,
'CYRILLIC SMALL LETTER YA': 1103,
'CYRILLIC SMALL LETTER YAT': 1123,
'CYRILLIC SMALL LETTER YERU': 1099,
'CYRILLIC SMALL LETTER YERU WITH DIAERESIS': 1273,
'CYRILLIC SMALL LETTER YI': 1111,
'CYRILLIC SMALL LETTER YU': 1102,
'CYRILLIC SMALL LETTER ZE': 1079,
'CYRILLIC SMALL LETTER ZE WITH DESCENDER': 1177,
'CYRILLIC SMALL LETTER ZE WITH DIAERESIS': 1247,
'CYRILLIC SMALL LETTER ZHE': 1078,
'CYRILLIC SMALL LETTER ZHE WITH BREVE': 1218,
'CYRILLIC SMALL LETTER ZHE WITH DESCENDER': 1175,
'CYRILLIC SMALL LETTER ZHE WITH DIAERESIS': 1245,
'CYRILLIC SMALL LIGATURE A IE': 1237,
'CYRILLIC SMALL LIGATURE EN GHE': 1189,
'CYRILLIC SMALL LIGATURE TE TSE': 1205,
'CYRILLIC THOUSANDS SIGN': 1154,
'DAGGER': 8224,
'DALET SYMBOL': 8504,
'DARK SHADE': 9619,
'DASHED LOW LINE': 65101,
'DASHED OVERLINE': 65097,
'DASHED TRIANGLE-HEADED RIGHTWARDS ARROW': 10143,
'DECIMAL SEPARATOR KEY SYMBOL': 9110,
'DEGREE CELSIUS': 8451,
'DEGREE FAHRENHEIT': 8457,
'DEGREE SIGN': 176,
'DELTA EQUAL TO': 8796,
'DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL': 9161,
'DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE': 9153,
'DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE': 9156,
'DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE': 9159,
'DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL': 9162,
'DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE': 9154,
'DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE': 9157,
'DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE': 9160,
'DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT': 9164,
'DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT': 9151,
'DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT': 9163,
'DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT': 9150,
'DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE': 9158,
'DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE': 9152,
'DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE': 9155,
'DESCENDING NODE': 9739,
'DESERET CAPITAL LETTER AY': 66572,
'DESERET CAPITAL LETTER BEE': 66578,
'DESERET CAPITAL LETTER CHEE': 66581,
'DESERET CAPITAL LETTER DEE': 66580,
'DESERET CAPITAL LETTER EF': 66585,
'DESERET CAPITAL LETTER EL': 66594,
'DESERET CAPITAL LETTER EM': 66595,
'DESERET CAPITAL LETTER EN': 66596,
'DESERET CAPITAL LETTER ENG': 66597,
'DESERET CAPITAL LETTER ER': 66593,
'DESERET CAPITAL LETTER ES': 66589,
'DESERET CAPITAL LETTER ESH': 66591,
'DESERET CAPITAL LETTER ETH': 66587,
'DESERET CAPITAL LETTER GAY': 66584,
'DESERET CAPITAL LETTER H': 66576,
'DESERET CAPITAL LETTER JEE': 66582,
'DESERET CAPITAL LETTER KAY': 66583,
'DESERET CAPITAL LETTER LONG A': 66562,
'DESERET CAPITAL LETTER LONG AH': 66563,
'DESERET CAPITAL LETTER LONG E': 66561,
'DESERET CAPITAL LETTER LONG I': 66560,
'DESERET CAPITAL LETTER LONG O': 66564,
'DESERET CAPITAL LETTER LONG OO': 66565,
'DESERET CAPITAL LETTER OW': 66573,
'DESERET CAPITAL LETTER PEE': 66577,
'DESERET CAPITAL LETTER SHORT A': 66568,
'DESERET CAPITAL LETTER SHORT AH': 66569,
'DESERET CAPITAL LETTER SHORT E': 66567,
'DESERET CAPITAL LETTER SHORT I': 66566,
'DESERET CAPITAL LETTER SHORT O': 66570,
'DESERET CAPITAL LETTER SHORT OO': 66571,
'DESERET CAPITAL LETTER TEE': 66579,
'DESERET CAPITAL LETTER THEE': 66588,
'DESERET CAPITAL LETTER VEE': 66586,
'DESERET CAPITAL LETTER WU': 66574,
'DESERET CAPITAL LETTER YEE': 66575,
'DESERET CAPITAL LETTER ZEE': 66590,
'DESERET CAPITAL LETTER ZHEE': 66592,
'DESERET SMALL LETTER AY': 66612,
'DESERET SMALL LETTER BEE': 66618,
'DESERET SMALL LETTER CHEE': 66621,
'DESERET SMALL LETTER DEE': 66620,
'DESERET SMALL LETTER EF': 66625,
'DESERET SMALL LETTER EL': 66634,
'DESERET SMALL LETTER EM': 66635,
'DESERET SMALL LETTER EN': 66636,
'DESERET SMALL LETTER ENG': 66637,
'DESERET SMALL LETTER ER': 66633,
'DESERET SMALL LETTER ES': 66629,
'DESERET SMALL LETTER ESH': 66631,
'DESERET SMALL LETTER ETH': 66627,
'DESERET SMALL LETTER GAY': 66624,
'DESERET SMALL LETTER H': 66616,
'DESERET SMALL LETTER JEE': 66622,
'DESERET SMALL LETTER KAY': 66623,
'DESERET SMALL LETTER LONG A': 66602,
'DESERET SMALL LETTER LONG AH': 66603,
'DESERET SMALL LETTER LONG E': 66601,
'DESERET SMALL LETTER LONG I': 66600,
'DESERET SMALL LETTER LONG O': 66604,
'DESERET SMALL LETTER LONG OO': 66605,
'DESERET SMALL LETTER OW': 66613,
'DESERET SMALL LETTER PEE': 66617,
'DESERET SMALL LETTER SHORT A': 66608,
'DESERET SMALL LETTER SHORT AH': 66609,
'DESERET SMALL LETTER SHORT E': 66607,
'DESERET SMALL LETTER SHORT I': 66606,
'DESERET SMALL LETTER SHORT O': 66610,
'DESERET SMALL LETTER SHORT OO': 66611,
'DESERET SMALL LETTER TEE': 66619,
'DESERET SMALL LETTER THEE': 66628,
'DESERET SMALL LETTER VEE': 66626,
'DESERET SMALL LETTER WU': 66614,
'DESERET SMALL LETTER YEE': 66615,
'DESERET SMALL LETTER ZEE': 66630,
'DESERET SMALL LETTER ZHEE': 66632,
'DEVANAGARI ABBREVIATION SIGN': 2416,
'DEVANAGARI ACUTE ACCENT': 2388,
'DEVANAGARI DANDA': 2404,
'DEVANAGARI DIGIT EIGHT': 2414,
'DEVANAGARI DIGIT FIVE': 2411,
'DEVANAGARI DIGIT FOUR': 2410,
'DEVANAGARI DIGIT NINE': 2415,
'DEVANAGARI DIGIT ONE': 2407,
'DEVANAGARI DIGIT SEVEN': 2413,
'DEVANAGARI DIGIT SIX': 2412,
'DEVANAGARI DIGIT THREE': 2409,
'DEVANAGARI DIGIT TWO': 2408,
'DEVANAGARI DIGIT ZERO': 2406,
'DEVANAGARI DOUBLE DANDA': 2405,
'DEVANAGARI GRAVE ACCENT': 2387,
'DEVANAGARI LETTER A': 2309,
'DEVANAGARI LETTER AA': 2310,
'DEVANAGARI LETTER AI': 2320,
'DEVANAGARI LETTER AU': 2324,
'DEVANAGARI LETTER BA': 2348,
'DEVANAGARI LETTER BHA': 2349,
'DEVANAGARI LETTER CA': 2330,
'DEVANAGARI LETTER CANDRA E': 2317,
'DEVANAGARI LETTER CANDRA O': 2321,
'DEVANAGARI LETTER CHA': 2331,
'DEVANAGARI LETTER DA': 2342,
'DEVANAGARI LETTER DDA': 2337,
'DEVANAGARI LETTER DDDHA': 2396,
'DEVANAGARI LETTER DDHA': 2338,
'DEVANAGARI LETTER DHA': 2343,
'DEVANAGARI LETTER E': 2319,
'DEVANAGARI LETTER FA': 2398,
'DEVANAGARI LETTER GA': 2327,
'DEVANAGARI LETTER GHA': 2328,
'DEVANAGARI LETTER GHHA': 2394,
'DEVANAGARI LETTER HA': 2361,
'DEVANAGARI LETTER I': 2311,
'DEVANAGARI LETTER II': 2312,
'DEVANAGARI LETTER JA': 2332,
'DEVANAGARI LETTER JHA': 2333,
'DEVANAGARI LETTER KA': 2325,
'DEVANAGARI LETTER KHA': 2326,
'DEVANAGARI LETTER KHHA': 2393,
'DEVANAGARI LETTER LA': 2354,
'DEVANAGARI LETTER LLA': 2355,
'DEVANAGARI LETTER LLLA': 2356,
'DEVANAGARI LETTER MA': 2350,
'DEVANAGARI LETTER NA': 2344,
'DEVANAGARI LETTER NGA': 2329,
'DEVANAGARI LETTER NNA': 2339,
'DEVANAGARI LETTER NNNA': 2345,
'DEVANAGARI LETTER NYA': 2334,
'DEVANAGARI LETTER O': 2323,
'DEVANAGARI LETTER PA': 2346,
'DEVANAGARI LETTER PHA': 2347,
'DEVANAGARI LETTER QA': 2392,
'DEVANAGARI LETTER RA': 2352,
'DEVANAGARI LETTER RHA': 2397,
'DEVANAGARI LETTER RRA': 2353,
'DEVANAGARI LETTER SA': 2360,
'DEVANAGARI LETTER SHA': 2358,
'DEVANAGARI LETTER SHORT E': 2318,
'DEVANAGARI LETTER SHORT O': 2322,
'DEVANAGARI LETTER SSA': 2359,
'DEVANAGARI LETTER TA': 2340,
'DEVANAGARI LETTER THA': 2341,
'DEVANAGARI LETTER TTA': 2335,
'DEVANAGARI LETTER TTHA': 2336,
'DEVANAGARI LETTER U': 2313,
'DEVANAGARI LETTER UU': 2314,
'DEVANAGARI LETTER VA': 2357,
'DEVANAGARI LETTER VOCALIC L': 2316,
'DEVANAGARI LETTER VOCALIC LL': 2401,
'DEVANAGARI LETTER VOCALIC R': 2315,
'DEVANAGARI LETTER VOCALIC RR': 2400,
'DEVANAGARI LETTER YA': 2351,
'DEVANAGARI LETTER YYA': 2399,
'DEVANAGARI LETTER ZA': 2395,
'DEVANAGARI OM': 2384,
'DEVANAGARI SIGN ANUSVARA': 2306,
'DEVANAGARI SIGN AVAGRAHA': 2365,
'DEVANAGARI SIGN CANDRABINDU': 2305,
'DEVANAGARI SIGN NUKTA': 2364,
'DEVANAGARI SIGN VIRAMA': 2381,
'DEVANAGARI SIGN VISARGA': 2307,
'DEVANAGARI STRESS SIGN ANUDATTA': 2386,
'DEVANAGARI STRESS SIGN UDATTA': 2385,
'DEVANAGARI VOWEL SIGN AA': 2366,
'DEVANAGARI VOWEL SIGN AI': 2376,
'DEVANAGARI VOWEL SIGN AU': 2380,
'DEVANAGARI VOWEL SIGN CANDRA E': 2373,
'DEVANAGARI VOWEL SIGN CANDRA O': 2377,
'DEVANAGARI VOWEL SIGN E': 2375,
'DEVANAGARI VOWEL SIGN I': 2367,
'DEVANAGARI VOWEL SIGN II': 2368,
'DEVANAGARI VOWEL SIGN O': 2379,
'DEVANAGARI VOWEL SIGN SHORT E': 2374,
'DEVANAGARI VOWEL SIGN SHORT O': 2378,
'DEVANAGARI VOWEL SIGN U': 2369,
'DEVANAGARI VOWEL SIGN UU': 2370,
'DEVANAGARI VOWEL SIGN VOCALIC L': 2402,
'DEVANAGARI VOWEL SIGN VOCALIC LL': 2403,
'DEVANAGARI VOWEL SIGN VOCALIC R': 2371,
'DEVANAGARI VOWEL SIGN VOCALIC RR': 2372,
'DIAERESIS': 168,
'DIAMETER SIGN': 8960,
'DIAMOND OPERATOR': 8900,
'DIE FACE-1': 9856,
'DIE FACE-2': 9857,
'DIE FACE-3': 9858,
'DIE FACE-4': 9859,
'DIE FACE-5': 9860,
'DIE FACE-6': 9861,
'DIFFERENCE BETWEEN': 8783,
'DIGIT EIGHT': 56,
'DIGIT EIGHT FULL STOP': 9359,
'DIGIT FIVE': 53,
'DIGIT FIVE FULL STOP': 9356,
'DIGIT FOUR': 52,
'DIGIT FOUR FULL STOP': 9355,
'DIGIT NINE': 57,
'DIGIT NINE FULL STOP': 9360,
'DIGIT ONE': 49,
'DIGIT ONE FULL STOP': 9352,
'DIGIT SEVEN': 55,
'DIGIT SEVEN FULL STOP': 9358,
'DIGIT SIX': 54,
'DIGIT SIX FULL STOP': 9357,
'DIGIT THREE': 51,
'DIGIT THREE FULL STOP': 9354,
'DIGIT TWO': 50,
'DIGIT TWO FULL STOP': 9353,
'DIGIT ZERO': 48,
'DIMENSION ORIGIN': 9009,
'DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT': 10119,
'DINGBAT CIRCLED SANS-SERIF DIGIT FIVE': 10116,
'DINGBAT CIRCLED SANS-SERIF DIGIT FOUR': 10115,
'DINGBAT CIRCLED SANS-SERIF DIGIT NINE': 10120,
'DINGBAT CIRCLED SANS-SERIF DIGIT ONE': 10112,
'DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN': 10118,
'DINGBAT CIRCLED SANS-SERIF DIGIT SIX': 10117,
'DINGBAT CIRCLED SANS-SERIF DIGIT THREE': 10114,
'DINGBAT CIRCLED SANS-SERIF DIGIT TWO': 10113,
'DINGBAT CIRCLED SANS-SERIF NUMBER TEN': 10121,
'DINGBAT NEGATIVE CIRCLED DIGIT EIGHT': 10109,
'DINGBAT NEGATIVE CIRCLED DIGIT FIVE': 10106,
'DINGBAT NEGATIVE CIRCLED DIGIT FOUR': 10105,
'DINGBAT NEGATIVE CIRCLED DIGIT NINE': 10110,
'DINGBAT NEGATIVE CIRCLED DIGIT ONE': 10102,
'DINGBAT NEGATIVE CIRCLED DIGIT SEVEN': 10108,
'DINGBAT NEGATIVE CIRCLED DIGIT SIX': 10107,
'DINGBAT NEGATIVE CIRCLED DIGIT THREE': 10104,
'DINGBAT NEGATIVE CIRCLED DIGIT TWO': 10103,
'DINGBAT NEGATIVE CIRCLED NUMBER TEN': 10111,
'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT': 10129,
'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE': 10126,
'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR': 10125,
'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE': 10130,
'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE': 10122,
'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN': 10128,
'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX': 10127,
'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE': 10124,
'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO': 10123,
'DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN': 10131,
'DIRECT CURRENT SYMBOL FORM TWO': 9107,
'DISCONTINUOUS UNDERLINE SYMBOL': 9090,
'DITTO MARK': 12291,
'DIVIDES': 8739,
'DIVISION SIGN': 247,
'DIVISION SLASH': 8725,
'DIVISION TIMES': 8903,
'DOES NOT CONTAIN AS MEMBER': 8716,
'DOES NOT CONTAIN AS NORMAL SUBGROUP': 8939,
'DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL': 8941,
'DOES NOT DIVIDE': 8740,
'DOES NOT DIVIDE WITH REVERSED NEGATION SLASH': 10990,
'DOES NOT FORCE': 8878,
'DOES NOT PRECEDE': 8832,
'DOES NOT PRECEDE OR EQUAL': 8928,
'DOES NOT PROVE': 8876,
'DOES NOT SUCCEED': 8833,
'DOES NOT SUCCEED OR EQUAL': 8929,
'DOLLAR SIGN': 36,
'DONG SIGN': 8363,
'DOT ABOVE': 729,
'DOT MINUS': 8760,
'DOT OPERATOR': 8901,
'DOT PLUS': 8724,
'DOTTED CIRCLE': 9676,
'DOTTED FENCE': 10649,
'DOUBLE ACUTE ACCENT': 733,
'DOUBLE CIRCLED DIGIT EIGHT': 9468,
'DOUBLE CIRCLED DIGIT FIVE': 9465,
'DOUBLE CIRCLED DIGIT FOUR': 9464,
'DOUBLE CIRCLED DIGIT NINE': 9469,
'DOUBLE CIRCLED DIGIT ONE': 9461,
'DOUBLE CIRCLED DIGIT SEVEN': 9467,
'DOUBLE CIRCLED DIGIT SIX': 9466,
'DOUBLE CIRCLED DIGIT THREE': 9463,
'DOUBLE CIRCLED DIGIT TWO': 9462,
'DOUBLE CIRCLED NUMBER TEN': 9470,
'DOUBLE COLON EQUAL': 10868,
'DOUBLE DAGGER': 8225,
'DOUBLE DOWN TACK': 10986,
'DOUBLE EXCLAMATION MARK': 8252,
'DOUBLE HIGH-REVERSED-9 QUOTATION MARK': 8223,
'DOUBLE INTEGRAL': 8748,
'DOUBLE INTERSECTION': 8914,
'DOUBLE LEFT ARC GREATER-THAN BRACKET': 10645,
'DOUBLE LOGICAL AND': 10835,
'DOUBLE LOGICAL OR': 10836,
'DOUBLE LOW LINE': 8215,
'DOUBLE LOW-9 QUOTATION MARK': 8222,
'DOUBLE NESTED GREATER-THAN': 10914,
'DOUBLE NESTED LESS-THAN': 10913,
'DOUBLE NESTED LESS-THAN WITH UNDERBAR': 10915,
'DOUBLE PLUS': 10746,
'DOUBLE PRECEDES': 10939,
'DOUBLE PRIME': 8243,
'DOUBLE PRIME QUOTATION MARK': 12318,
'DOUBLE QUESTION MARK': 8263,
'DOUBLE RIGHT ARC LESS-THAN BRACKET': 10646,
'DOUBLE SOLIDUS OPERATOR': 11005,
'DOUBLE SQUARE INTERSECTION': 10830,
'DOUBLE SQUARE UNION': 10831,
'DOUBLE STROKE NOT SIGN': 10988,
'DOUBLE SUBSET': 8912,
'DOUBLE SUCCEEDS': 10940,
'DOUBLE SUPERSET': 8913,
'DOUBLE UNION': 8915,
'DOUBLE UP TACK': 10987,
'DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE': 10981,
'DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE': 8875,
'DOUBLE VERTICAL BAR LEFT TURNSTILE': 10979,
'DOUBLE VERTICAL LINE': 8214,
'DOUBLE WAVY OVERLINE': 65100,
'DOUBLE-ENDED MULTIMAP': 10719,
'DOUBLE-LINE EQUAL TO OR GREATER-THAN': 10906,
'DOUBLE-LINE EQUAL TO OR LESS-THAN': 10905,
'DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN': 10908,
'DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN': 10907,
'DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO': 11002,
'DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO': 11001,
'DOUBLE-STRUCK CAPITAL C': 8450,
'DOUBLE-STRUCK CAPITAL GAMMA': 8510,
'DOUBLE-STRUCK CAPITAL H': 8461,
'DOUBLE-STRUCK CAPITAL N': 8469,
'DOUBLE-STRUCK CAPITAL P': 8473,
'DOUBLE-STRUCK CAPITAL PI': 8511,
'DOUBLE-STRUCK CAPITAL Q': 8474,
'DOUBLE-STRUCK CAPITAL R': 8477,
'DOUBLE-STRUCK CAPITAL Z': 8484,
'DOUBLE-STRUCK ITALIC CAPITAL D': 8517,
'DOUBLE-STRUCK ITALIC SMALL D': 8518,
'DOUBLE-STRUCK ITALIC SMALL E': 8519,
'DOUBLE-STRUCK ITALIC SMALL I': 8520,
'DOUBLE-STRUCK ITALIC SMALL J': 8521,
'DOUBLE-STRUCK N-ARY SUMMATION': 8512,
'DOUBLE-STRUCK SMALL GAMMA': 8509,
'DOWN ARROWHEAD': 8964,
'DOWN FISH TAIL': 10623,
'DOWN RIGHT DIAGONAL ELLIPSIS': 8945,
'DOWN TACK': 8868,
'DOWN TACK WITH CIRCLE BELOW': 10993,
'DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK': 10728,
'DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK': 10729,
'DOWNWARDS ARROW': 8595,
'DOWNWARDS ARROW FROM BAR': 8615,
'DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW': 8693,
'DOWNWARDS ARROW TO BAR': 10515,
'DOWNWARDS ARROW WITH CORNER LEFTWARDS': 8629,
'DOWNWARDS ARROW WITH DOUBLE STROKE': 8671,
'DOWNWARDS ARROW WITH HORIZONTAL STROKE': 10504,
'DOWNWARDS ARROW WITH TIP LEFTWARDS': 8626,
'DOWNWARDS ARROW WITH TIP RIGHTWARDS': 8627,
'DOWNWARDS DASHED ARROW': 8675,
'DOWNWARDS DOUBLE ARROW': 8659,
'DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT': 10597,
'DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT': 10607,
'DOWNWARDS HARPOON WITH BARB LEFT FROM BAR': 10593,
'DOWNWARDS HARPOON WITH BARB LEFT TO BAR': 10585,
'DOWNWARDS HARPOON WITH BARB LEFTWARDS': 8643,
'DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR': 10589,
'DOWNWARDS HARPOON WITH BARB RIGHT TO BAR': 10581,
'DOWNWARDS HARPOON WITH BARB RIGHTWARDS': 8642,
'DOWNWARDS PAIRED ARROWS': 8650,
'DOWNWARDS QUADRUPLE ARROW': 10225,
'DOWNWARDS TRIPLE ARROW': 10507,
'DOWNWARDS TWO HEADED ARROW': 8609,
'DOWNWARDS WHITE ARROW': 8681,
'DOWNWARDS ZIGZAG ARROW': 8623,
'DRACHMA SIGN': 8367,
'DRAFTING POINT RIGHTWARDS ARROW': 10139,
'EARTH': 9793,
'EAST SYRIAC CROSS': 9841,
'EIGHT PETALLED OUTLINED BLACK FLORETTE': 10049,
'EIGHT POINTED BLACK STAR': 10036,
'EIGHT POINTED PINWHEEL STAR': 10037,
'EIGHT POINTED RECTILINEAR BLACK STAR': 10039,
'EIGHT SPOKED ASTERISK': 10035,
'EIGHT TEARDROP-SPOKED PROPELLER ASTERISK': 10058,
'EIGHTH NOTE': 9834,
'ELECTRIC ARROW': 8961,
'ELEMENT OF': 8712,
'ELEMENT OF OPENING DOWNWARDS': 10969,
'ELEMENT OF OPENING UPWARDS': 10194,
'ELEMENT OF WITH DOT ABOVE': 8949,
'ELEMENT OF WITH LONG HORIZONTAL STROKE': 8946,
'ELEMENT OF WITH OVERBAR': 8950,
'ELEMENT OF WITH TWO HORIZONTAL STROKES': 8953,
'ELEMENT OF WITH UNDERBAR': 8952,
'ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE': 8947,
'EM DASH': 8212,
'EM QUAD': 8193,
'EM SPACE': 8195,
'EMPHASIS SYMBOL': 9091,
'EMPTY SET': 8709,
'EMPTY SET WITH LEFT ARROW ABOVE': 10676,
'EMPTY SET WITH OVERBAR': 10673,
'EMPTY SET WITH RIGHT ARROW ABOVE': 10675,
'EMPTY SET WITH SMALL CIRCLE ABOVE': 10674,
'EN DASH': 8211,
'EN QUAD': 8192,
'EN SPACE': 8194,
'END OF PROOF': 8718,
'ENTER SYMBOL': 9094,
'ENVELOPE': 9993,
'EQUAL AND PARALLEL TO': 8917,
'EQUAL TO BY DEFINITION': 8797,
'EQUAL TO OR GREATER-THAN': 8925,
'EQUAL TO OR LESS-THAN': 8924,
'EQUAL TO OR PRECEDES': 8926,
'EQUAL TO OR SUCCEEDS': 8927,
'EQUALS COLON': 8789,
'EQUALS SIGN': 61,
'EQUALS SIGN ABOVE PLUS SIGN': 10865,
'EQUALS SIGN ABOVE RIGHTWARDS ARROW': 10609,
'EQUALS SIGN ABOVE TILDE OPERATOR': 10867,
'EQUALS SIGN AND SLANTED PARALLEL': 10723,
'EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE': 10724,
'EQUALS SIGN WITH BUMPY ABOVE': 10926,
'EQUALS SIGN WITH DOT BELOW': 10854,
'EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW': 10871,
'EQUALS WITH ASTERISK': 10862,
'EQUIANGULAR TO': 8794,
'EQUIVALENT TO': 8781,
'EQUIVALENT WITH FOUR DOTS ABOVE': 10872,
'ERASE TO THE LEFT': 9003,
'ERASE TO THE RIGHT': 8998,
'ERROR-BARRED BLACK CIRCLE': 10739,
'ERROR-BARRED BLACK DIAMOND': 10737,
'ERROR-BARRED BLACK SQUARE': 10735,
'ERROR-BARRED WHITE CIRCLE': 10738,
'ERROR-BARRED WHITE DIAMOND': 10736,
'ERROR-BARRED WHITE SQUARE': 10734,
'ESTIMATED SYMBOL': 8494,
'ESTIMATES': 8793,
'ETHIOPIC COLON': 4965,
'ETHIOPIC COMMA': 4963,
'ETHIOPIC DIGIT EIGHT': 4976,
'ETHIOPIC DIGIT FIVE': 4973,
'ETHIOPIC DIGIT FOUR': 4972,
'ETHIOPIC DIGIT NINE': 4977,
'ETHIOPIC DIGIT ONE': 4969,
'ETHIOPIC DIGIT SEVEN': 4975,
'ETHIOPIC DIGIT SIX': 4974,
'ETHIOPIC DIGIT THREE': 4971,
'ETHIOPIC DIGIT TWO': 4970,
'ETHIOPIC FULL STOP': 4962,
'ETHIOPIC NUMBER EIGHTY': 4985,
'ETHIOPIC NUMBER FIFTY': 4982,
'ETHIOPIC NUMBER FORTY': 4981,
'ETHIOPIC NUMBER HUNDRED': 4987,
'ETHIOPIC NUMBER NINETY': 4986,
'ETHIOPIC NUMBER SEVENTY': 4984,
'ETHIOPIC NUMBER SIXTY': 4983,
'ETHIOPIC NUMBER TEN': 4978,
'ETHIOPIC NUMBER TEN THOUSAND': 4988,
'ETHIOPIC NUMBER THIRTY': 4980,
'ETHIOPIC NUMBER TWENTY': 4979,
'ETHIOPIC PARAGRAPH SEPARATOR': 4968,
'ETHIOPIC PREFACE COLON': 4966,
'ETHIOPIC QUESTION MARK': 4967,
'ETHIOPIC SEMICOLON': 4964,
'ETHIOPIC SYLLABLE BA': 4704,
'ETHIOPIC SYLLABLE BAA': 4707,
'ETHIOPIC SYLLABLE BE': 4709,
'ETHIOPIC SYLLABLE BEE': 4708,
'ETHIOPIC SYLLABLE BI': 4706,
'ETHIOPIC SYLLABLE BO': 4710,
'ETHIOPIC SYLLABLE BU': 4705,
'ETHIOPIC SYLLABLE BWA': 4711,
'ETHIOPIC SYLLABLE CA': 4728,
'ETHIOPIC SYLLABLE CAA': 4731,
'ETHIOPIC SYLLABLE CE': 4733,
'ETHIOPIC SYLLABLE CEE': 4732,
'ETHIOPIC SYLLABLE CHA': 4904,
'ETHIOPIC SYLLABLE CHAA': 4907,
'ETHIOPIC SYLLABLE CHE': 4909,
'ETHIOPIC SYLLABLE CHEE': 4908,
'ETHIOPIC SYLLABLE CHI': 4906,
'ETHIOPIC SYLLABLE CHO': 4910,
'ETHIOPIC SYLLABLE CHU': 4905,
'ETHIOPIC SYLLABLE CHWA': 4911,
'ETHIOPIC SYLLABLE CI': 4730,
'ETHIOPIC SYLLABLE CO': 4734,
'ETHIOPIC SYLLABLE CU': 4729,
'ETHIOPIC SYLLABLE CWA': 4735,
'ETHIOPIC SYLLABLE DA': 4848,
'ETHIOPIC SYLLABLE DAA': 4851,
'ETHIOPIC SYLLABLE DDA': 4856,
'ETHIOPIC SYLLABLE DDAA': 4859,
'ETHIOPIC SYLLABLE DDE': 4861,
'ETHIOPIC SYLLABLE DDEE': 4860,
'ETHIOPIC SYLLABLE DDI': 4858,
'ETHIOPIC SYLLABLE DDO': 4862,
'ETHIOPIC SYLLABLE DDU': 4857,
'ETHIOPIC SYLLABLE DDWA': 4863,
'ETHIOPIC SYLLABLE DE': 4853,
'ETHIOPIC SYLLABLE DEE': 4852,
'ETHIOPIC SYLLABLE DI': 4850,
'ETHIOPIC SYLLABLE DO': 4854,
'ETHIOPIC SYLLABLE DU': 4849,
'ETHIOPIC SYLLABLE DWA': 4855,
'ETHIOPIC SYLLABLE FA': 4936,
'ETHIOPIC SYLLABLE FAA': 4939,
'ETHIOPIC SYLLABLE FE': 4941,
'ETHIOPIC SYLLABLE FEE': 4940,
'ETHIOPIC SYLLABLE FI': 4938,
'ETHIOPIC SYLLABLE FO': 4942,
'ETHIOPIC SYLLABLE FU': 4937,
'ETHIOPIC SYLLABLE FWA': 4943,
'ETHIOPIC SYLLABLE FYA': 4954,
'ETHIOPIC SYLLABLE GA': 4872,
'ETHIOPIC SYLLABLE GAA': 4875,
'ETHIOPIC SYLLABLE GE': 4877,
'ETHIOPIC SYLLABLE GEE': 4876,
'ETHIOPIC SYLLABLE GGA': 4888,
'ETHIOPIC SYLLABLE GGAA': 4891,
'ETHIOPIC SYLLABLE GGE': 4893,
'ETHIOPIC SYLLABLE GGEE': 4892,
'ETHIOPIC SYLLABLE GGI': 4890,
'ETHIOPIC SYLLABLE GGO': 4894,
'ETHIOPIC SYLLABLE GGU': 4889,
'ETHIOPIC SYLLABLE GI': 4874,
'ETHIOPIC SYLLABLE GLOTTAL A': 4768,
'ETHIOPIC SYLLABLE GLOTTAL AA': 4771,
'ETHIOPIC SYLLABLE GLOTTAL E': 4773,
'ETHIOPIC SYLLABLE GLOTTAL EE': 4772,
'ETHIOPIC SYLLABLE GLOTTAL I': 4770,
'ETHIOPIC SYLLABLE GLOTTAL O': 4774,
'ETHIOPIC SYLLABLE GLOTTAL U': 4769,
'ETHIOPIC SYLLABLE GLOTTAL WA': 4775,
'ETHIOPIC SYLLABLE GO': 4878,
'ETHIOPIC SYLLABLE GU': 4873,
'ETHIOPIC SYLLABLE GWA': 4880,
'ETHIOPIC SYLLABLE GWAA': 4883,
'ETHIOPIC SYLLABLE GWE': 4885,
'ETHIOPIC SYLLABLE GWEE': 4884,
'ETHIOPIC SYLLABLE GWI': 4882,
'ETHIOPIC SYLLABLE HA': 4608,
'ETHIOPIC SYLLABLE HAA': 4611,
'ETHIOPIC SYLLABLE HE': 4613,
'ETHIOPIC SYLLABLE HEE': 4612,
'ETHIOPIC SYLLABLE HHA': 4624,
'ETHIOPIC SYLLABLE HHAA': 4627,
'ETHIOPIC SYLLABLE HHE': 4629,
'ETHIOPIC SYLLABLE HHEE': 4628,
'ETHIOPIC SYLLABLE HHI': 4626,
'ETHIOPIC SYLLABLE HHO': 4630,
'ETHIOPIC SYLLABLE HHU': 4625,
'ETHIOPIC SYLLABLE HHWA': 4631,
'ETHIOPIC SYLLABLE HI': 4610,
'ETHIOPIC SYLLABLE HO': 4614,
'ETHIOPIC SYLLABLE HU': 4609,
'ETHIOPIC SYLLABLE JA': 4864,
'ETHIOPIC SYLLABLE JAA': 4867,
'ETHIOPIC SYLLABLE JE': 4869,
'ETHIOPIC SYLLABLE JEE': 4868,
'ETHIOPIC SYLLABLE JI': 4866,
'ETHIOPIC SYLLABLE JO': 4870,
'ETHIOPIC SYLLABLE JU': 4865,
'ETHIOPIC SYLLABLE JWA': 4871,
'ETHIOPIC SYLLABLE KA': 4776,
'ETHIOPIC SYLLABLE KAA': 4779,
'ETHIOPIC SYLLABLE KE': 4781,
'ETHIOPIC SYLLABLE KEE': 4780,
'ETHIOPIC SYLLABLE KI': 4778,
'ETHIOPIC SYLLABLE KO': 4782,
'ETHIOPIC SYLLABLE KU': 4777,
'ETHIOPIC SYLLABLE KWA': 4784,
'ETHIOPIC SYLLABLE KWAA': 4787,
'ETHIOPIC SYLLABLE KWE': 4789,
'ETHIOPIC SYLLABLE KWEE': 4788,
'ETHIOPIC SYLLABLE KWI': 4786,
'ETHIOPIC SYLLABLE KXA': 4792,
'ETHIOPIC SYLLABLE KXAA': 4795,
'ETHIOPIC SYLLABLE KXE': 4797,
'ETHIOPIC SYLLABLE KXEE': 4796,
'ETHIOPIC SYLLABLE KXI': 4794,
'ETHIOPIC SYLLABLE KXO': 4798,
'ETHIOPIC SYLLABLE KXU': 4793,
'ETHIOPIC SYLLABLE KXWA': 4800,
'ETHIOPIC SYLLABLE KXWAA': 4803,
'ETHIOPIC SYLLABLE KXWE': 4805,
'ETHIOPIC SYLLABLE KXWEE': 4804,
'ETHIOPIC SYLLABLE KXWI': 4802,
'ETHIOPIC SYLLABLE LA': 4616,
'ETHIOPIC SYLLABLE LAA': 4619,
'ETHIOPIC SYLLABLE LE': 4621,
'ETHIOPIC SYLLABLE LEE': 4620,
'ETHIOPIC SYLLABLE LI': 4618,
'ETHIOPIC SYLLABLE LO': 4622,
'ETHIOPIC SYLLABLE LU': 4617,
'ETHIOPIC SYLLABLE LWA': 4623,
'ETHIOPIC SYLLABLE MA': 4632,
'ETHIOPIC SYLLABLE MAA': 4635,
'ETHIOPIC SYLLABLE ME': 4637,
'ETHIOPIC SYLLABLE MEE': 4636,
'ETHIOPIC SYLLABLE MI': 4634,
'ETHIOPIC SYLLABLE MO': 4638,
'ETHIOPIC SYLLABLE MU': 4633,
'ETHIOPIC SYLLABLE MWA': 4639,
'ETHIOPIC SYLLABLE MYA': 4953,
'ETHIOPIC SYLLABLE NA': 4752,
'ETHIOPIC SYLLABLE NAA': 4755,
'ETHIOPIC SYLLABLE NE': 4757,
'ETHIOPIC SYLLABLE NEE': 4756,
'ETHIOPIC SYLLABLE NI': 4754,
'ETHIOPIC SYLLABLE NO': 4758,
'ETHIOPIC SYLLABLE NU': 4753,
'ETHIOPIC SYLLABLE NWA': 4759,
'ETHIOPIC SYLLABLE NYA': 4760,
'ETHIOPIC SYLLABLE NYAA': 4763,
'ETHIOPIC SYLLABLE NYE': 4765,
'ETHIOPIC SYLLABLE NYEE': 4764,
'ETHIOPIC SYLLABLE NYI': 4762,
'ETHIOPIC SYLLABLE NYO': 4766,
'ETHIOPIC SYLLABLE NYU': 4761,
'ETHIOPIC SYLLABLE NYWA': 4767,
'ETHIOPIC SYLLABLE PA': 4944,
'ETHIOPIC SYLLABLE PAA': 4947,
'ETHIOPIC SYLLABLE PE': 4949,
'ETHIOPIC SYLLABLE PEE': 4948,
'ETHIOPIC SYLLABLE PHA': 4912,
'ETHIOPIC SYLLABLE PHAA': 4915,
'ETHIOPIC SYLLABLE PHARYNGEAL A': 4816,
'ETHIOPIC SYLLABLE PHARYNGEAL AA': 4819,
'ETHIOPIC SYLLABLE PHARYNGEAL E': 4821,
'ETHIOPIC SYLLABLE PHARYNGEAL EE': 4820,
'ETHIOPIC SYLLABLE PHARYNGEAL I': 4818,
'ETHIOPIC SYLLABLE PHARYNGEAL O': 4822,
'ETHIOPIC SYLLABLE PHARYNGEAL U': 4817,
'ETHIOPIC SYLLABLE PHE': 4917,
'ETHIOPIC SYLLABLE PHEE': 4916,
'ETHIOPIC SYLLABLE PHI': 4914,
'ETHIOPIC SYLLABLE PHO': 4918,
'ETHIOPIC SYLLABLE PHU': 4913,
'ETHIOPIC SYLLABLE PHWA': 4919,
'ETHIOPIC SYLLABLE PI': 4946,
'ETHIOPIC SYLLABLE PO': 4950,
'ETHIOPIC SYLLABLE PU': 4945,
'ETHIOPIC SYLLABLE PWA': 4951,
'ETHIOPIC SYLLABLE QA': 4672,
'ETHIOPIC SYLLABLE QAA': 4675,
'ETHIOPIC SYLLABLE QE': 4677,
'ETHIOPIC SYLLABLE QEE': 4676,
'ETHIOPIC SYLLABLE QHA': 4688,
'ETHIOPIC SYLLABLE QHAA': 4691,
'ETHIOPIC SYLLABLE QHE': 4693,
'ETHIOPIC SYLLABLE QHEE': 4692,
'ETHIOPIC SYLLABLE QHI': 4690,
'ETHIOPIC SYLLABLE QHO': 4694,
'ETHIOPIC SYLLABLE QHU': 4689,
'ETHIOPIC SYLLABLE QHWA': 4696,
'ETHIOPIC SYLLABLE QHWAA': 4699,
'ETHIOPIC SYLLABLE QHWE': 4701,
'ETHIOPIC SYLLABLE QHWEE': 4700,
'ETHIOPIC SYLLABLE QHWI': 4698,
'ETHIOPIC SYLLABLE QI': 4674,
'ETHIOPIC SYLLABLE QO': 4678,
'ETHIOPIC SYLLABLE QU': 4673,
'ETHIOPIC SYLLABLE QWA': 4680,
'ETHIOPIC SYLLABLE QWAA': 4683,
'ETHIOPIC SYLLABLE QWE': 4685,
'ETHIOPIC SYLLABLE QWEE': 4684,
'ETHIOPIC SYLLABLE QWI': 4682,
'ETHIOPIC SYLLABLE RA': 4648,
'ETHIOPIC SYLLABLE RAA': 4651,
'ETHIOPIC SYLLABLE RE': 4653,
'ETHIOPIC SYLLABLE REE': 4652,
'ETHIOPIC SYLLABLE RI': 4650,
'ETHIOPIC SYLLABLE RO': 4654,
'ETHIOPIC SYLLABLE RU': 4649,
'ETHIOPIC SYLLABLE RWA': 4655,
'ETHIOPIC SYLLABLE RYA': 4952,
'ETHIOPIC SYLLABLE SA': 4656,
'ETHIOPIC SYLLABLE SAA': 4659,
'ETHIOPIC SYLLABLE SE': 4661,
'ETHIOPIC SYLLABLE SEE': 4660,
'ETHIOPIC SYLLABLE SHA': 4664,
'ETHIOPIC SYLLABLE SHAA': 4667,
'ETHIOPIC SYLLABLE SHE': 4669,
'ETHIOPIC SYLLABLE SHEE': 4668,
'ETHIOPIC SYLLABLE SHI': 4666,
'ETHIOPIC SYLLABLE SHO': 4670,
'ETHIOPIC SYLLABLE SHU': 4665,
'ETHIOPIC SYLLABLE SHWA': 4671,
'ETHIOPIC SYLLABLE SI': 4658,
'ETHIOPIC SYLLABLE SO': 4662,
'ETHIOPIC SYLLABLE SU': 4657,
'ETHIOPIC SYLLABLE SWA': 4663,
'ETHIOPIC SYLLABLE SZA': 4640,
'ETHIOPIC SYLLABLE SZAA': 4643,
'ETHIOPIC SYLLABLE SZE': 4645,
'ETHIOPIC SYLLABLE SZEE': 4644,
'ETHIOPIC SYLLABLE SZI': 4642,
'ETHIOPIC SYLLABLE SZO': 4646,
'ETHIOPIC SYLLABLE SZU': 4641,
'ETHIOPIC SYLLABLE SZWA': 4647,
'ETHIOPIC SYLLABLE TA': 4720,
'ETHIOPIC SYLLABLE TAA': 4723,
'ETHIOPIC SYLLABLE TE': 4725,
'ETHIOPIC SYLLABLE TEE': 4724,
'ETHIOPIC SYLLABLE THA': 4896,
'ETHIOPIC SYLLABLE THAA': 4899,
'ETHIOPIC SYLLABLE THE': 4901,
'ETHIOPIC SYLLABLE THEE': 4900,
'ETHIOPIC SYLLABLE THI': 4898,
'ETHIOPIC SYLLABLE THO': 4902,
'ETHIOPIC SYLLABLE THU': 4897,
'ETHIOPIC SYLLABLE THWA': 4903,
'ETHIOPIC SYLLABLE TI': 4722,
'ETHIOPIC SYLLABLE TO': 4726,
'ETHIOPIC SYLLABLE TSA': 4920,
'ETHIOPIC SYLLABLE TSAA': 4923,
'ETHIOPIC SYLLABLE TSE': 4925,
'ETHIOPIC SYLLABLE TSEE': 4924,
'ETHIOPIC SYLLABLE TSI': 4922,
'ETHIOPIC SYLLABLE TSO': 4926,
'ETHIOPIC SYLLABLE TSU': 4921,
'ETHIOPIC SYLLABLE TSWA': 4927,
'ETHIOPIC SYLLABLE TU': 4721,
'ETHIOPIC SYLLABLE TWA': 4727,
'ETHIOPIC SYLLABLE TZA': 4928,
'ETHIOPIC SYLLABLE TZAA': 4931,
'ETHIOPIC SYLLABLE TZE': 4933,
'ETHIOPIC SYLLABLE TZEE': 4932,
'ETHIOPIC SYLLABLE TZI': 4930,
'ETHIOPIC SYLLABLE TZO': 4934,
'ETHIOPIC SYLLABLE TZU': 4929,
'ETHIOPIC SYLLABLE VA': 4712,
'ETHIOPIC SYLLABLE VAA': 4715,
'ETHIOPIC SYLLABLE VE': 4717,
'ETHIOPIC SYLLABLE VEE': 4716,
'ETHIOPIC SYLLABLE VI': 4714,
'ETHIOPIC SYLLABLE VO': 4718,
'ETHIOPIC SYLLABLE VU': 4713,
'ETHIOPIC SYLLABLE VWA': 4719,
'ETHIOPIC SYLLABLE WA': 4808,
'ETHIOPIC SYLLABLE WAA': 4811,
'ETHIOPIC SYLLABLE WE': 4813,
'ETHIOPIC SYLLABLE WEE': 4812,
'ETHIOPIC SYLLABLE WI': 4810,
'ETHIOPIC SYLLABLE WO': 4814,
'ETHIOPIC SYLLABLE WU': 4809,
'ETHIOPIC SYLLABLE XA': 4736,
'ETHIOPIC SYLLABLE XAA': 4739,
'ETHIOPIC SYLLABLE XE': 4741,
'ETHIOPIC SYLLABLE XEE': 4740,
'ETHIOPIC SYLLABLE XI': 4738,
'ETHIOPIC SYLLABLE XO': 4742,
'ETHIOPIC SYLLABLE XU': 4737,
'ETHIOPIC SYLLABLE XWA': 4744,
'ETHIOPIC SYLLABLE XWAA': 4747,
'ETHIOPIC SYLLABLE XWE': 4749,
'ETHIOPIC SYLLABLE XWEE': 4748,
'ETHIOPIC SYLLABLE XWI': 4746,
'ETHIOPIC SYLLABLE YA': 4840,
'ETHIOPIC SYLLABLE YAA': 4843,
'ETHIOPIC SYLLABLE YE': 4845,
'ETHIOPIC SYLLABLE YEE': 4844,
'ETHIOPIC SYLLABLE YI': 4842,
'ETHIOPIC SYLLABLE YO': 4846,
'ETHIOPIC SYLLABLE YU': 4841,
'ETHIOPIC SYLLABLE ZA': 4824,
'ETHIOPIC SYLLABLE ZAA': 4827,
'ETHIOPIC SYLLABLE ZE': 4829,
'ETHIOPIC SYLLABLE ZEE': 4828,
'ETHIOPIC SYLLABLE ZHA': 4832,
'ETHIOPIC SYLLABLE ZHAA': 4835,
'ETHIOPIC SYLLABLE ZHE': 4837,
'ETHIOPIC SYLLABLE ZHEE': 4836,
'ETHIOPIC SYLLABLE ZHI': 4834,
'ETHIOPIC SYLLABLE ZHO': 4838,
'ETHIOPIC SYLLABLE ZHU': 4833,
'ETHIOPIC SYLLABLE ZHWA': 4839,
'ETHIOPIC SYLLABLE ZI': 4826,
'ETHIOPIC SYLLABLE ZO': 4830,
'ETHIOPIC SYLLABLE ZU': 4825,
'ETHIOPIC SYLLABLE ZWA': 4831,
'ETHIOPIC WORDSPACE': 4961,
'EULER CONSTANT': 8455,
'EURO SIGN': 8364,
'EURO-CURRENCY SIGN': 8352,
'EXCESS': 8761,
'EXCLAMATION MARK': 33,
'EXCLAMATION QUESTION MARK': 8265,
'EXTENDED ARABIC-INDIC DIGIT EIGHT': 1784,
'EXTENDED ARABIC-INDIC DIGIT FIVE': 1781,
'EXTENDED ARABIC-INDIC DIGIT FOUR': 1780,
'EXTENDED ARABIC-INDIC DIGIT NINE': 1785,
'EXTENDED ARABIC-INDIC DIGIT ONE': 1777,
'EXTENDED ARABIC-INDIC DIGIT SEVEN': 1783,
'EXTENDED ARABIC-INDIC DIGIT SIX': 1782,
'EXTENDED ARABIC-INDIC DIGIT THREE': 1779,
'EXTENDED ARABIC-INDIC DIGIT TWO': 1778,
'EXTENDED ARABIC-INDIC DIGIT ZERO': 1776,
'FALLING DIAGONAL CROSSING NORTH EAST ARROW': 10543,
'FALLING DIAGONAL CROSSING RISING DIAGONAL': 10540,
'FARSI SYMBOL': 9771,
'FEMALE SIGN': 9792,
'FEMININE ORDINAL INDICATOR': 170,
'FIGURE DASH': 8210,
'FIGURE SPACE': 8199,
'FINITE PART INTEGRAL': 10765,
'FIRST QUARTER MOON': 9789,
'FISHEYE': 9673,
'FLORAL HEART': 10086,
'FOR ALL': 8704,
'FORCES': 8873,
'FORKING': 10972,
'FOUR BALLOON-SPOKED ASTERISK': 10019,
'FOUR CLUB-SPOKED ASTERISK': 10021,
'FOUR TEARDROP-SPOKED ASTERISK': 10018,
'FOUR-PER-EM SPACE': 8197,
'FOURTH ROOT': 8732,
'FRACTION NUMERATOR ONE': 8543,
'FRACTION SLASH': 8260,
'FRENCH FRANC SIGN': 8355,
'FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW': 10156,
'FROWN': 8994,
'FULL BLOCK': 9608,
'FULL OUTER JOIN': 10199,
'FULL STOP': 46,
'FULLWIDTH AMPERSAND': 65286,
'FULLWIDTH APOSTROPHE': 65287,
'FULLWIDTH ASTERISK': 65290,
'FULLWIDTH BROKEN BAR': 65508,
'FULLWIDTH CENT SIGN': 65504,
'FULLWIDTH CIRCUMFLEX ACCENT': 65342,
'FULLWIDTH COLON': 65306,
'FULLWIDTH COMMA': 65292,
'FULLWIDTH COMMERCIAL AT': 65312,
'FULLWIDTH DIGIT EIGHT': 65304,
'FULLWIDTH DIGIT FIVE': 65301,
'FULLWIDTH DIGIT FOUR': 65300,
'FULLWIDTH DIGIT NINE': 65305,
'FULLWIDTH DIGIT ONE': 65297,
'FULLWIDTH DIGIT SEVEN': 65303,
'FULLWIDTH DIGIT SIX': 65302,
'FULLWIDTH DIGIT THREE': 65299,
'FULLWIDTH DIGIT TWO': 65298,
'FULLWIDTH DIGIT ZERO': 65296,
'FULLWIDTH DOLLAR SIGN': 65284,
'FULLWIDTH EQUALS SIGN': 65309,
'FULLWIDTH EXCLAMATION MARK': 65281,
'FULLWIDTH FULL STOP': 65294,
'FULLWIDTH GRAVE ACCENT': 65344,
'FULLWIDTH GREATER-THAN SIGN': 65310,
'FULLWIDTH HYPHEN-MINUS': 65293,
'FULLWIDTH LATIN CAPITAL LETTER A': 65313,
'FULLWIDTH LATIN CAPITAL LETTER B': 65314,
'FULLWIDTH LATIN CAPITAL LETTER C': 65315,
'FULLWIDTH LATIN CAPITAL LETTER D': 65316,
'FULLWIDTH LATIN CAPITAL LETTER E': 65317,
'FULLWIDTH LATIN CAPITAL LETTER F': 65318,
'FULLWIDTH LATIN CAPITAL LETTER G': 65319,
'FULLWIDTH LATIN CAPITAL LETTER H': 65320,
'FULLWIDTH LATIN CAPITAL LETTER I': 65321,
'FULLWIDTH LATIN CAPITAL LETTER J': 65322,
'FULLWIDTH LATIN CAPITAL LETTER K': 65323,
'FULLWIDTH LATIN CAPITAL LETTER L': 65324,
'FULLWIDTH LATIN CAPITAL LETTER M': 65325,
'FULLWIDTH LATIN CAPITAL LETTER N': 65326,
'FULLWIDTH LATIN CAPITAL LETTER O': 65327,
'FULLWIDTH LATIN CAPITAL LETTER P': 65328,
'FULLWIDTH LATIN CAPITAL LETTER Q': 65329,
'FULLWIDTH LATIN CAPITAL LETTER R': 65330,
'FULLWIDTH LATIN CAPITAL LETTER S': 65331,
'FULLWIDTH LATIN CAPITAL LETTER T': 65332,
'FULLWIDTH LATIN CAPITAL LETTER U': 65333,
'FULLWIDTH LATIN CAPITAL LETTER V': 65334,
'FULLWIDTH LATIN CAPITAL LETTER W': 65335,
'FULLWIDTH LATIN CAPITAL LETTER X': 65336,
'FULLWIDTH LATIN CAPITAL LETTER Y': 65337,
'FULLWIDTH LATIN CAPITAL LETTER Z': 65338,
'FULLWIDTH LATIN SMALL LETTER A': 65345,
'FULLWIDTH LATIN SMALL LETTER B': 65346,
'FULLWIDTH LATIN SMALL LETTER C': 65347,
'FULLWIDTH LATIN SMALL LETTER D': 65348,
'FULLWIDTH LATIN SMALL LETTER E': 65349,
'FULLWIDTH LATIN SMALL LETTER F': 65350,
'FULLWIDTH LATIN SMALL LETTER G': 65351,
'FULLWIDTH LATIN SMALL LETTER H': 65352,
'FULLWIDTH LATIN SMALL LETTER I': 65353,
'FULLWIDTH LATIN SMALL LETTER J': 65354,
'FULLWIDTH LATIN SMALL LETTER K': 65355,
'FULLWIDTH LATIN SMALL LETTER L': 65356,
'FULLWIDTH LATIN SMALL LETTER M': 65357,
'FULLWIDTH LATIN SMALL LETTER N': 65358,
'FULLWIDTH LATIN SMALL LETTER O': 65359,
'FULLWIDTH LATIN SMALL LETTER P': 65360,
'FULLWIDTH LATIN SMALL LETTER Q': 65361,
'FULLWIDTH LATIN SMALL LETTER R': 65362,
'FULLWIDTH LATIN SMALL LETTER S': 65363,
'FULLWIDTH LATIN SMALL LETTER T': 65364,
'FULLWIDTH LATIN SMALL LETTER U': 65365,
'FULLWIDTH LATIN SMALL LETTER V': 65366,
'FULLWIDTH LATIN SMALL LETTER W': 65367,
'FULLWIDTH LATIN SMALL LETTER X': 65368,
'FULLWIDTH LATIN SMALL LETTER Y': 65369,
'FULLWIDTH LATIN SMALL LETTER Z': 65370,
'FULLWIDTH LEFT CURLY BRACKET': 65371,
'FULLWIDTH LEFT PARENTHESIS': 65288,
'FULLWIDTH LEFT SQUARE BRACKET': 65339,
'FULLWIDTH LEFT WHITE PARENTHESIS': 65375,
'FULLWIDTH LESS-THAN SIGN': 65308,
'FULLWIDTH LOW LINE': 65343,
'FULLWIDTH MACRON': 65507,
'FULLWIDTH NOT SIGN': 65506,
'FULLWIDTH NUMBER SIGN': 65283,
'FULLWIDTH PERCENT SIGN': 65285,
'FULLWIDTH PLUS SIGN': 65291,
'FULLWIDTH POUND SIGN': 65505,
'FULLWIDTH QUESTION MARK': 65311,
'FULLWIDTH QUOTATION MARK': 65282,
'FULLWIDTH REVERSE SOLIDUS': 65340,
'FULLWIDTH RIGHT CURLY BRACKET': 65373,
'FULLWIDTH RIGHT PARENTHESIS': 65289,
'FULLWIDTH RIGHT SQUARE BRACKET': 65341,
'FULLWIDTH RIGHT WHITE PARENTHESIS': 65376,
'FULLWIDTH SEMICOLON': 65307,
'FULLWIDTH SOLIDUS': 65295,
'FULLWIDTH TILDE': 65374,
'FULLWIDTH VERTICAL LINE': 65372,
'FULLWIDTH WON SIGN': 65510,
'FULLWIDTH YEN SIGN': 65509,
'FUNCTION APPLICATION': 8289,
'GEMINI': 9802,
'GEOMETRIC PROPORTION': 8762,
'GEOMETRICALLY EQUAL TO': 8785,
'GEOMETRICALLY EQUIVALENT TO': 8782,
'GEORGIAN CAPITAL LETTER AN': 4256,
'GEORGIAN CAPITAL LETTER BAN': 4257,
'GEORGIAN CAPITAL LETTER CAN': 4282,
'GEORGIAN CAPITAL LETTER CHAR': 4285,
'GEORGIAN CAPITAL LETTER CHIN': 4281,
'GEORGIAN CAPITAL LETTER CIL': 4284,
'GEORGIAN CAPITAL LETTER DON': 4259,
'GEORGIAN CAPITAL LETTER EN': 4260,
'GEORGIAN CAPITAL LETTER GAN': 4258,
'GEORGIAN CAPITAL LETTER GHAN': 4278,
'GEORGIAN CAPITAL LETTER HAE': 4288,
'GEORGIAN CAPITAL LETTER HAR': 4292,
'GEORGIAN CAPITAL LETTER HE': 4289,
'GEORGIAN CAPITAL LETTER HIE': 4290,
'GEORGIAN CAPITAL LETTER HOE': 4293,
'GEORGIAN CAPITAL LETTER IN': 4264,
'GEORGIAN CAPITAL LETTER JHAN': 4287,
'GEORGIAN CAPITAL LETTER JIL': 4283,
'GEORGIAN CAPITAL LETTER KAN': 4265,
'GEORGIAN CAPITAL LETTER KHAR': 4277,
'GEORGIAN CAPITAL LETTER LAS': 4266,
'GEORGIAN CAPITAL LETTER MAN': 4267,
'GEORGIAN CAPITAL LETTER NAR': 4268,
'GEORGIAN CAPITAL LETTER ON': 4269,
'GEORGIAN CAPITAL LETTER PAR': 4270,
'GEORGIAN CAPITAL LETTER PHAR': 4276,
'GEORGIAN CAPITAL LETTER QAR': 4279,
'GEORGIAN CAPITAL LETTER RAE': 4272,
'GEORGIAN CAPITAL LETTER SAN': 4273,
'GEORGIAN CAPITAL LETTER SHIN': 4280,
'GEORGIAN CAPITAL LETTER TAN': 4263,
'GEORGIAN CAPITAL LETTER TAR': 4274,
'GEORGIAN CAPITAL LETTER UN': 4275,
'GEORGIAN CAPITAL LETTER VIN': 4261,
'GEORGIAN CAPITAL LETTER WE': 4291,
'GEORGIAN CAPITAL LETTER XAN': 4286,
'GEORGIAN CAPITAL LETTER ZEN': 4262,
'GEORGIAN CAPITAL LETTER ZHAR': 4271,
'GEORGIAN LETTER AN': 4304,
'GEORGIAN LETTER BAN': 4305,
'GEORGIAN LETTER CAN': 4330,
'GEORGIAN LETTER CHAR': 4333,
'GEORGIAN LETTER CHIN': 4329,
'GEORGIAN LETTER CIL': 4332,
'GEORGIAN LETTER DON': 4307,
'GEORGIAN LETTER ELIFI': 4344,
'GEORGIAN LETTER EN': 4308,
'GEORGIAN LETTER FI': 4342,
'GEORGIAN LETTER GAN': 4306,
'GEORGIAN LETTER GHAN': 4326,
'GEORGIAN LETTER HAE': 4336,
'GEORGIAN LETTER HAR': 4340,
'GEORGIAN LETTER HE': 4337,
'GEORGIAN LETTER HIE': 4338,
'GEORGIAN LETTER HOE': 4341,
'GEORGIAN LETTER IN': 4312,
'GEORGIAN LETTER JHAN': 4335,
'GEORGIAN LETTER JIL': 4331,
'GEORGIAN LETTER KAN': 4313,
'GEORGIAN LETTER KHAR': 4325,
'GEORGIAN LETTER LAS': 4314,
'GEORGIAN LETTER MAN': 4315,
'GEORGIAN LETTER NAR': 4316,
'GEORGIAN LETTER ON': 4317,
'GEORGIAN LETTER PAR': 4318,
'GEORGIAN LETTER PHAR': 4324,
'GEORGIAN LETTER QAR': 4327,
'GEORGIAN LETTER RAE': 4320,
'GEORGIAN LETTER SAN': 4321,
'GEORGIAN LETTER SHIN': 4328,
'GEORGIAN LETTER TAN': 4311,
'GEORGIAN LETTER TAR': 4322,
'GEORGIAN LETTER UN': 4323,
'GEORGIAN LETTER VIN': 4309,
'GEORGIAN LETTER WE': 4339,
'GEORGIAN LETTER XAN': 4334,
'GEORGIAN LETTER YN': 4343,
'GEORGIAN LETTER ZEN': 4310,
'GEORGIAN LETTER ZHAR': 4319,
'GEORGIAN PARAGRAPH SEPARATOR': 4347,
'GERMAN PENNY SIGN': 8368,
'GETA MARK': 12307,
'GIMEL SYMBOL': 8503,
'GLEICH STARK': 10726,
'GOTHIC LETTER AHSA': 66352,
'GOTHIC LETTER AIHVUS': 66356,
'GOTHIC LETTER BAIRKAN': 66353,
'GOTHIC LETTER DAGS': 66355,
'GOTHIC LETTER EIS': 66361,
'GOTHIC LETTER FAIHU': 66374,
'GOTHIC LETTER GIBA': 66354,
'GOTHIC LETTER HAGL': 66359,
'GOTHIC LETTER HWAIR': 66376,
'GOTHIC LETTER IGGWS': 66375,
'GOTHIC LETTER IUJA': 66358,
'GOTHIC LETTER JER': 66366,
'GOTHIC LETTER KUSMA': 66362,
'GOTHIC LETTER LAGUS': 66363,
'GOTHIC LETTER MANNA': 66364,
'GOTHIC LETTER NAUTHS': 66365,
'GOTHIC LETTER NINE HUNDRED': 66378,
'GOTHIC LETTER NINETY': 66369,
'GOTHIC LETTER OTHAL': 66377,
'GOTHIC LETTER PAIRTHRA': 66368,
'GOTHIC LETTER QAIRTHRA': 66357,
'GOTHIC LETTER RAIDA': 66370,
'GOTHIC LETTER SAUIL': 66371,
'GOTHIC LETTER TEIWS': 66372,
'GOTHIC LETTER THIUTH': 66360,
'GOTHIC LETTER URUS': 66367,
'GOTHIC LETTER WINJA': 66373,
'GRAVE ACCENT': 96,
'GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN': 10892,
'GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL': 10898,
'GREATER-THAN ABOVE RIGHTWARDS ARROW': 10616,
'GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN': 10896,
'GREATER-THAN ABOVE SIMILAR OR EQUAL': 10894,
'GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL': 10900,
'GREATER-THAN AND NOT APPROXIMATE': 10890,
'GREATER-THAN AND SINGLE-LINE NOT EQUAL TO': 10888,
'GREATER-THAN BESIDE LESS-THAN': 10917,
'GREATER-THAN BUT NOT EQUAL TO': 8809,
'GREATER-THAN BUT NOT EQUIVALENT TO': 8935,
'GREATER-THAN CLOSED BY CURVE': 10919,
'GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL': 10921,
'GREATER-THAN EQUAL TO OR LESS-THAN': 8923,
'GREATER-THAN OR APPROXIMATE': 10886,
'GREATER-THAN OR EQUAL TO': 8805,
'GREATER-THAN OR EQUIVALENT TO': 8819,
'GREATER-THAN OR LESS-THAN': 8823,
'GREATER-THAN OR SLANTED EQUAL TO': 10878,
'GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE': 10882,
'GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT': 10884,
'GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE': 10880,
'GREATER-THAN OVER EQUAL TO': 8807,
'GREATER-THAN OVERLAPPING LESS-THAN': 10916,
'GREATER-THAN SIGN': 62,
'GREATER-THAN WITH CIRCLE INSIDE': 10874,
'GREATER-THAN WITH DOT': 8919,
'GREATER-THAN WITH QUESTION MARK ABOVE': 10876,
'GREEK ANO TELEIA': 903,
'GREEK BETA SYMBOL': 976,
'GREEK CAPITAL LETTER ALPHA': 913,
'GREEK CAPITAL LETTER ALPHA WITH DASIA': 7945,
'GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA': 7949,
'GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI': 8077,
'GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI': 7951,
'GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI': 8079,
'GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI': 8073,
'GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA': 7947,
'GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI': 8075,
'GREEK CAPITAL LETTER ALPHA WITH MACRON': 8121,
'GREEK CAPITAL LETTER ALPHA WITH OXIA': 8123,
'GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI': 8124,
'GREEK CAPITAL LETTER ALPHA WITH PSILI': 7944,
'GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA': 7948,
'GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI': 8076,
'GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI': 7950,
'GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI': 8078,
'GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI': 8072,
'GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA': 7946,
'GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI': 8074,
'GREEK CAPITAL LETTER ALPHA WITH TONOS': 902,
'GREEK CAPITAL LETTER ALPHA WITH VARIA': 8122,
'GREEK CAPITAL LETTER ALPHA WITH VRACHY': 8120,
'GREEK CAPITAL LETTER BETA': 914,
'GREEK CAPITAL LETTER CHI': 935,
'GREEK CAPITAL LETTER DELTA': 916,
'GREEK CAPITAL LETTER EPSILON': 917,
'GREEK CAPITAL LETTER EPSILON WITH DASIA': 7961,
'GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA': 7965,
'GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA': 7963,
'GREEK CAPITAL LETTER EPSILON WITH OXIA': 8137,
'GREEK CAPITAL LETTER EPSILON WITH PSILI': 7960,
'GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA': 7964,
'GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA': 7962,
'GREEK CAPITAL LETTER EPSILON WITH TONOS': 904,
'GREEK CAPITAL LETTER EPSILON WITH VARIA': 8136,
'GREEK CAPITAL LETTER ETA': 919,
'GREEK CAPITAL LETTER ETA WITH DASIA': 7977,
'GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA': 7981,
'GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI': 8093,
'GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI': 7983,
'GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI': 8095,
'GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI': 8089,
'GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA': 7979,
'GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI': 8091,
'GREEK CAPITAL LETTER ETA WITH OXIA': 8139,
'GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI': 8140,
'GREEK CAPITAL LETTER ETA WITH PSILI': 7976,
'GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA': 7980,
'GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI': 8092,
'GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI': 7982,
'GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI': 8094,
'GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI': 8088,
'GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA': 7978,
'GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI': 8090,
'GREEK CAPITAL LETTER ETA WITH TONOS': 905,
'GREEK CAPITAL LETTER ETA WITH VARIA': 8138,
'GREEK CAPITAL LETTER GAMMA': 915,
'GREEK CAPITAL LETTER IOTA': 921,
'GREEK CAPITAL LETTER IOTA WITH DASIA': 7993,
'GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA': 7997,
'GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI': 7999,
'GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA': 7995,
'GREEK CAPITAL LETTER IOTA WITH DIALYTIKA': 938,
'GREEK CAPITAL LETTER IOTA WITH MACRON': 8153,
'GREEK CAPITAL LETTER IOTA WITH OXIA': 8155,
'GREEK CAPITAL LETTER IOTA WITH PSILI': 7992,
'GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA': 7996,
'GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI': 7998,
'GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA': 7994,
'GREEK CAPITAL LETTER IOTA WITH TONOS': 906,
'GREEK CAPITAL LETTER IOTA WITH VARIA': 8154,
'GREEK CAPITAL LETTER IOTA WITH VRACHY': 8152,
'GREEK CAPITAL LETTER KAPPA': 922,
'GREEK CAPITAL LETTER LAMDA': 923,
'GREEK CAPITAL LETTER MU': 924,
'GREEK CAPITAL LETTER NU': 925,
'GREEK CAPITAL LETTER OMEGA': 937,
'GREEK CAPITAL LETTER OMEGA WITH DASIA': 8041,
'GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA': 8045,
'GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI': 8109,
'GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI': 8047,
'GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI': 8111,
'GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI': 8105,
'GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA': 8043,
'GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI': 8107,
'GREEK CAPITAL LETTER OMEGA WITH OXIA': 8187,
'GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI': 8188,
'GREEK CAPITAL LETTER OMEGA WITH PSILI': 8040,
'GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA': 8044,
'GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI': 8108,
'GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI': 8046,
'GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI': 8110,
'GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI': 8104,
'GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA': 8042,
'GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI': 8106,
'GREEK CAPITAL LETTER OMEGA WITH TONOS': 911,
'GREEK CAPITAL LETTER OMEGA WITH VARIA': 8186,
'GREEK CAPITAL LETTER OMICRON': 927,
'GREEK CAPITAL LETTER OMICRON WITH DASIA': 8009,
'GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA': 8013,
'GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA': 8011,
'GREEK CAPITAL LETTER OMICRON WITH OXIA': 8185,
'GREEK CAPITAL LETTER OMICRON WITH PSILI': 8008,
'GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA': 8012,
'GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA': 8010,
'GREEK CAPITAL LETTER OMICRON WITH TONOS': 908,
'GREEK CAPITAL LETTER OMICRON WITH VARIA': 8184,
'GREEK CAPITAL LETTER PHI': 934,
'GREEK CAPITAL LETTER PI': 928,
'GREEK CAPITAL LETTER PSI': 936,
'GREEK CAPITAL LETTER RHO': 929,
'GREEK CAPITAL LETTER RHO WITH DASIA': 8172,
'GREEK CAPITAL LETTER SIGMA': 931,
'GREEK CAPITAL LETTER TAU': 932,
'GREEK CAPITAL LETTER THETA': 920,
'GREEK CAPITAL LETTER UPSILON': 933,
'GREEK CAPITAL LETTER UPSILON WITH DASIA': 8025,
'GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA': 8029,
'GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI': 8031,
'GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA': 8027,
'GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA': 939,
'GREEK CAPITAL LETTER UPSILON WITH MACRON': 8169,
'GREEK CAPITAL LETTER UPSILON WITH OXIA': 8171,
'GREEK CAPITAL LETTER UPSILON WITH TONOS': 910,
'GREEK CAPITAL LETTER UPSILON WITH VARIA': 8170,
'GREEK CAPITAL LETTER UPSILON WITH VRACHY': 8168,
'GREEK CAPITAL LETTER XI': 926,
'GREEK CAPITAL LETTER ZETA': 918,
'GREEK CAPITAL THETA SYMBOL': 1012,
'GREEK DASIA': 8190,
'GREEK DASIA AND OXIA': 8158,
'GREEK DASIA AND PERISPOMENI': 8159,
'GREEK DASIA AND VARIA': 8157,
'GREEK DIALYTIKA AND OXIA': 8174,
'GREEK DIALYTIKA AND PERISPOMENI': 8129,
'GREEK DIALYTIKA AND VARIA': 8173,
'GREEK DIALYTIKA TONOS': 901,
'GREEK KAI SYMBOL': 983,
'GREEK KAPPA SYMBOL': 1008,
'GREEK KORONIS': 8125,
'GREEK LETTER ARCHAIC KOPPA': 984,
'GREEK LETTER DIGAMMA': 988,
'GREEK LETTER KOPPA': 990,
'GREEK LETTER SAMPI': 992,
'GREEK LETTER STIGMA': 986,
'GREEK LETTER YOT': 1011,
'GREEK LOWER NUMERAL SIGN': 885,
'GREEK LUNATE EPSILON SYMBOL': 1013,
'GREEK LUNATE SIGMA SYMBOL': 1010,
'GREEK NUMERAL SIGN': 884,
'GREEK OXIA': 8189,
'GREEK PERISPOMENI': 8128,
'GREEK PHI SYMBOL': 981,
'GREEK PI SYMBOL': 982,
'GREEK PROSGEGRAMMENI': 8126,
'GREEK PSILI': 8127,
'GREEK PSILI AND OXIA': 8142,
'GREEK PSILI AND PERISPOMENI': 8143,
'GREEK PSILI AND VARIA': 8141,
'GREEK QUESTION MARK': 894,
'GREEK REVERSED LUNATE EPSILON SYMBOL': 1014,
'GREEK RHO SYMBOL': 1009,
'GREEK SMALL LETTER ALPHA': 945,
'GREEK SMALL LETTER ALPHA WITH DASIA': 7937,
'GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA': 7941,
'GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI': 8069,
'GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI': 7943,
'GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI': 8071,
'GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA': 7939,
'GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI': 8067,
'GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI': 8065,
'GREEK SMALL LETTER ALPHA WITH MACRON': 8113,
'GREEK SMALL LETTER ALPHA WITH OXIA': 8049,
'GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI': 8116,
'GREEK SMALL LETTER ALPHA WITH PERISPOMENI': 8118,
'GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI': 8119,
'GREEK SMALL LETTER ALPHA WITH PSILI': 7936,
'GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA': 7940,
'GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI': 8068,
'GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI': 7942,
'GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI': 8070,
'GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA': 7938,
'GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI': 8066,
'GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI': 8064,
'GREEK SMALL LETTER ALPHA WITH TONOS': 940,
'GREEK SMALL LETTER ALPHA WITH VARIA': 8048,
'GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI': 8114,
'GREEK SMALL LETTER ALPHA WITH VRACHY': 8112,
'GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI': 8115,
'GREEK SMALL LETTER ARCHAIC KOPPA': 985,
'GREEK SMALL LETTER BETA': 946,
'GREEK SMALL LETTER CHI': 967,
'GREEK SMALL LETTER DELTA': 948,
'GREEK SMALL LETTER DIGAMMA': 989,
'GREEK SMALL LETTER EPSILON': 949,
'GREEK SMALL LETTER EPSILON WITH DASIA': 7953,
'GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA': 7957,
'GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA': 7955,
'GREEK SMALL LETTER EPSILON WITH OXIA': 8051,
'GREEK SMALL LETTER EPSILON WITH PSILI': 7952,
'GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA': 7956,
'GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA': 7954,
'GREEK SMALL LETTER EPSILON WITH TONOS': 941,
'GREEK SMALL LETTER EPSILON WITH VARIA': 8050,
'GREEK SMALL LETTER ETA': 951,
'GREEK SMALL LETTER ETA WITH DASIA': 7969,
'GREEK SMALL LETTER ETA WITH DASIA AND OXIA': 7973,
'GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI': 8085,
'GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI': 7975,
'GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI': 8087,
'GREEK SMALL LETTER ETA WITH DASIA AND VARIA': 7971,
'GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI': 8083,
'GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI': 8081,
'GREEK SMALL LETTER ETA WITH OXIA': 8053,
'GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI': 8132,
'GREEK SMALL LETTER ETA WITH PERISPOMENI': 8134,
'GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI': 8135,
'GREEK SMALL LETTER ETA WITH PSILI': 7968,
'GREEK SMALL LETTER ETA WITH PSILI AND OXIA': 7972,
'GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI': 8084,
'GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI': 7974,
'GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI': 8086,
'GREEK SMALL LETTER ETA WITH PSILI AND VARIA': 7970,
'GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI': 8082,
'GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI': 8080,
'GREEK SMALL LETTER ETA WITH TONOS': 942,
'GREEK SMALL LETTER ETA WITH VARIA': 8052,
'GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI': 8130,
'GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI': 8131,
'GREEK SMALL LETTER FINAL SIGMA': 962,
'GREEK SMALL LETTER GAMMA': 947,
'GREEK SMALL LETTER IOTA': 953,
'GREEK SMALL LETTER IOTA WITH DASIA': 7985,
'GREEK SMALL LETTER IOTA WITH DASIA AND OXIA': 7989,
'GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI': 7991,
'GREEK SMALL LETTER IOTA WITH DASIA AND VARIA': 7987,
'GREEK SMALL LETTER IOTA WITH DIALYTIKA': 970,
'GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA': 8147,
'GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI': 8151,
'GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS': 912,
'GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA': 8146,
'GREEK SMALL LETTER IOTA WITH MACRON': 8145,
'GREEK SMALL LETTER IOTA WITH OXIA': 8055,
'GREEK SMALL LETTER IOTA WITH PERISPOMENI': 8150,
'GREEK SMALL LETTER IOTA WITH PSILI': 7984,
'GREEK SMALL LETTER IOTA WITH PSILI AND OXIA': 7988,
'GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI': 7990,
'GREEK SMALL LETTER IOTA WITH PSILI AND VARIA': 7986,
'GREEK SMALL LETTER IOTA WITH TONOS': 943,
'GREEK SMALL LETTER IOTA WITH VARIA': 8054,
'GREEK SMALL LETTER IOTA WITH VRACHY': 8144,
'GREEK SMALL LETTER KAPPA': 954,
'GREEK SMALL LETTER KOPPA': 991,
'GREEK SMALL LETTER LAMDA': 955,
'GREEK SMALL LETTER MU': 956,
'GREEK SMALL LETTER NU': 957,
'GREEK SMALL LETTER OMEGA': 969,
'GREEK SMALL LETTER OMEGA WITH DASIA': 8033,
'GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA': 8037,
'GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI': 8101,
'GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI': 8039,
'GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI': 8103,
'GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA': 8035,
'GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI': 8099,
'GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI': 8097,
'GREEK SMALL LETTER OMEGA WITH OXIA': 8061,
'GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI': 8180,
'GREEK SMALL LETTER OMEGA WITH PERISPOMENI': 8182,
'GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI': 8183,
'GREEK SMALL LETTER OMEGA WITH PSILI': 8032,
'GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA': 8036,
'GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI': 8100,
'GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI': 8038,
'GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI': 8102,
'GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA': 8034,
'GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI': 8098,
'GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI': 8096,
'GREEK SMALL LETTER OMEGA WITH TONOS': 974,
'GREEK SMALL LETTER OMEGA WITH VARIA': 8060,
'GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI': 8178,
'GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI': 8179,
'GREEK SMALL LETTER OMICRON': 959,
'GREEK SMALL LETTER OMICRON WITH DASIA': 8001,
'GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA': 8005,
'GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA': 8003,
'GREEK SMALL LETTER OMICRON WITH OXIA': 8057,
'GREEK SMALL LETTER OMICRON WITH PSILI': 8000,
'GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA': 8004,
'GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA': 8002,
'GREEK SMALL LETTER OMICRON WITH TONOS': 972,
'GREEK SMALL LETTER OMICRON WITH VARIA': 8056,
'GREEK SMALL LETTER PHI': 966,
'GREEK SMALL LETTER PI': 960,
'GREEK SMALL LETTER PSI': 968,
'GREEK SMALL LETTER RHO': 961,
'GREEK SMALL LETTER RHO WITH DASIA': 8165,
'GREEK SMALL LETTER RHO WITH PSILI': 8164,
'GREEK SMALL LETTER SAMPI': 993,
'GREEK SMALL LETTER SIGMA': 963,
'GREEK SMALL LETTER STIGMA': 987,
'GREEK SMALL LETTER TAU': 964,
'GREEK SMALL LETTER THETA': 952,
'GREEK SMALL LETTER UPSILON': 965,
'GREEK SMALL LETTER UPSILON WITH DASIA': 8017,
'GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA': 8021,
'GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI': 8023,
'GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA': 8019,
'GREEK SMALL LETTER UPSILON WITH DIALYTIKA': 971,
'GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA': 8163,
'GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI': 8167,
'GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS': 944,
'GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA': 8162,
'GREEK SMALL LETTER UPSILON WITH MACRON': 8161,
'GREEK SMALL LETTER UPSILON WITH OXIA': 8059,
'GREEK SMALL LETTER UPSILON WITH PERISPOMENI': 8166,
'GREEK SMALL LETTER UPSILON WITH PSILI': 8016,
'GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA': 8020,
'GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI': 8022,
'GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA': 8018,
'GREEK SMALL LETTER UPSILON WITH TONOS': 973,
'GREEK SMALL LETTER UPSILON WITH VARIA': 8058,
'GREEK SMALL LETTER UPSILON WITH VRACHY': 8160,
'GREEK SMALL LETTER XI': 958,
'GREEK SMALL LETTER ZETA': 950,
'GREEK THETA SYMBOL': 977,
'GREEK TONOS': 900,
'GREEK UPSILON WITH ACUTE AND HOOK SYMBOL': 979,
'GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL': 980,
'GREEK UPSILON WITH HOOK SYMBOL': 978,
'GREEK VARIA': 8175,
'GREEK YPOGEGRAMMENI': 890,
'GUJARATI DIGIT EIGHT': 2798,
'GUJARATI DIGIT FIVE': 2795,
'GUJARATI DIGIT FOUR': 2794,
'GUJARATI DIGIT NINE': 2799,
'GUJARATI DIGIT ONE': 2791,
'GUJARATI DIGIT SEVEN': 2797,
'GUJARATI DIGIT SIX': 2796,
'GUJARATI DIGIT THREE': 2793,
'GUJARATI DIGIT TWO': 2792,
'GUJARATI DIGIT ZERO': 2790,
'GUJARATI LETTER A': 2693,
'GUJARATI LETTER AA': 2694,
'GUJARATI LETTER AI': 2704,
'GUJARATI LETTER AU': 2708,
'GUJARATI LETTER BA': 2732,
'GUJARATI LETTER BHA': 2733,
'GUJARATI LETTER CA': 2714,
'GUJARATI LETTER CHA': 2715,
'GUJARATI LETTER DA': 2726,
'GUJARATI LETTER DDA': 2721,
'GUJARATI LETTER DDHA': 2722,
'GUJARATI LETTER DHA': 2727,
'GUJARATI LETTER E': 2703,
'GUJARATI LETTER GA': 2711,
'GUJARATI LETTER GHA': 2712,
'GUJARATI LETTER HA': 2745,
'GUJARATI LETTER I': 2695,
'GUJARATI LETTER II': 2696,
'GUJARATI LETTER JA': 2716,
'GUJARATI LETTER JHA': 2717,
'GUJARATI LETTER KA': 2709,
'GUJARATI LETTER KHA': 2710,
'GUJARATI LETTER LA': 2738,
'GUJARATI LETTER LLA': 2739,
'GUJARATI LETTER MA': 2734,
'GUJARATI LETTER NA': 2728,
'GUJARATI LETTER NGA': 2713,
'GUJARATI LETTER NNA': 2723,
'GUJARATI LETTER NYA': 2718,
'GUJARATI LETTER O': 2707,
'GUJARATI LETTER PA': 2730,
'GUJARATI LETTER PHA': 2731,
'GUJARATI LETTER RA': 2736,
'GUJARATI LETTER SA': 2744,
'GUJARATI LETTER SHA': 2742,
'GUJARATI LETTER SSA': 2743,
'GUJARATI LETTER TA': 2724,
'GUJARATI LETTER THA': 2725,
'GUJARATI LETTER TTA': 2719,
'GUJARATI LETTER TTHA': 2720,
'GUJARATI LETTER U': 2697,
'GUJARATI LETTER UU': 2698,
'GUJARATI LETTER VA': 2741,
'GUJARATI LETTER VOCALIC R': 2699,
'GUJARATI LETTER VOCALIC RR': 2784,
'GUJARATI LETTER YA': 2735,
'GUJARATI OM': 2768,
'GUJARATI SIGN ANUSVARA': 2690,
'GUJARATI SIGN AVAGRAHA': 2749,
'GUJARATI SIGN CANDRABINDU': 2689,
'GUJARATI SIGN NUKTA': 2748,
'GUJARATI SIGN VIRAMA': 2765,
'GUJARATI SIGN VISARGA': 2691,
'GUJARATI VOWEL CANDRA E': 2701,
'GUJARATI VOWEL CANDRA O': 2705,
'GUJARATI VOWEL SIGN AA': 2750,
'GUJARATI VOWEL SIGN AI': 2760,
'GUJARATI VOWEL SIGN AU': 2764,
'GUJARATI VOWEL SIGN CANDRA E': 2757,
'GUJARATI VOWEL SIGN CANDRA O': 2761,
'GUJARATI VOWEL SIGN E': 2759,
'GUJARATI VOWEL SIGN I': 2751,
'GUJARATI VOWEL SIGN II': 2752,
'GUJARATI VOWEL SIGN O': 2763,
'GUJARATI VOWEL SIGN U': 2753,
'GUJARATI VOWEL SIGN UU': 2754,
'GUJARATI VOWEL SIGN VOCALIC R': 2755,
'GUJARATI VOWEL SIGN VOCALIC RR': 2756,
'GURMUKHI ADDAK': 2673,
'GURMUKHI DIGIT EIGHT': 2670,
'GURMUKHI DIGIT FIVE': 2667,
'GURMUKHI DIGIT FOUR': 2666,
'GURMUKHI DIGIT NINE': 2671,
'GURMUKHI DIGIT ONE': 2663,
'GURMUKHI DIGIT SEVEN': 2669,
'GURMUKHI DIGIT SIX': 2668,
'GURMUKHI DIGIT THREE': 2665,
'GURMUKHI DIGIT TWO': 2664,
'GURMUKHI DIGIT ZERO': 2662,
'GURMUKHI EK ONKAR': 2676,
'GURMUKHI IRI': 2674,
'GURMUKHI LETTER A': 2565,
'GURMUKHI LETTER AA': 2566,
'GURMUKHI LETTER AI': 2576,
'GURMUKHI LETTER AU': 2580,
'GURMUKHI LETTER BA': 2604,
'GURMUKHI LETTER BHA': 2605,
'GURMUKHI LETTER CA': 2586,
'GURMUKHI LETTER CHA': 2587,
'GURMUKHI LETTER DA': 2598,
'GURMUKHI LETTER DDA': 2593,
'GURMUKHI LETTER DDHA': 2594,
'GURMUKHI LETTER DHA': 2599,
'GURMUKHI LETTER EE': 2575,
'GURMUKHI LETTER FA': 2654,
'GURMUKHI LETTER GA': 2583,
'GURMUKHI LETTER GHA': 2584,
'GURMUKHI LETTER GHHA': 2650,
'GURMUKHI LETTER HA': 2617,
'GURMUKHI LETTER I': 2567,
'GURMUKHI LETTER II': 2568,
'GURMUKHI LETTER JA': 2588,
'GURMUKHI LETTER JHA': 2589,
'GURMUKHI LETTER KA': 2581,
'GURMUKHI LETTER KHA': 2582,
'GURMUKHI LETTER KHHA': 2649,
'GURMUKHI LETTER LA': 2610,
'GURMUKHI LETTER LLA': 2611,
'GURMUKHI LETTER MA': 2606,
'GURMUKHI LETTER NA': 2600,
'GURMUKHI LETTER NGA': 2585,
'GURMUKHI LETTER NNA': 2595,
'GURMUKHI LETTER NYA': 2590,
'GURMUKHI LETTER OO': 2579,
'GURMUKHI LETTER PA': 2602,
'GURMUKHI LETTER PHA': 2603,
'GURMUKHI LETTER RA': 2608,
'GURMUKHI LETTER RRA': 2652,
'GURMUKHI LETTER SA': 2616,
'GURMUKHI LETTER SHA': 2614,
'GURMUKHI LETTER TA': 2596,
'GURMUKHI LETTER THA': 2597,
'GURMUKHI LETTER TTA': 2591,
'GURMUKHI LETTER TTHA': 2592,
'GURMUKHI LETTER U': 2569,
'GURMUKHI LETTER UU': 2570,
'GURMUKHI LETTER VA': 2613,
'GURMUKHI LETTER YA': 2607,
'GURMUKHI LETTER ZA': 2651,
'GURMUKHI SIGN BINDI': 2562,
'GURMUKHI SIGN NUKTA': 2620,
'GURMUKHI SIGN VIRAMA': 2637,
'GURMUKHI TIPPI': 2672,
'GURMUKHI URA': 2675,
'GURMUKHI VOWEL SIGN AA': 2622,
'GURMUKHI VOWEL SIGN AI': 2632,
'GURMUKHI VOWEL SIGN AU': 2636,
'GURMUKHI VOWEL SIGN EE': 2631,
'GURMUKHI VOWEL SIGN I': 2623,
'GURMUKHI VOWEL SIGN II': 2624,
'GURMUKHI VOWEL SIGN OO': 2635,
'GURMUKHI VOWEL SIGN U': 2625,
'GURMUKHI VOWEL SIGN UU': 2626,
'HAIR SPACE': 8202,
'HALFWIDTH BLACK SQUARE': 65517,
'HALFWIDTH DOWNWARDS ARROW': 65516,
'HALFWIDTH FORMS LIGHT VERTICAL': 65512,
'HALFWIDTH HANGUL FILLER': 65440,
'HALFWIDTH HANGUL LETTER A': 65474,
'HALFWIDTH HANGUL LETTER AE': 65475,
'HALFWIDTH HANGUL LETTER CHIEUCH': 65466,
'HALFWIDTH HANGUL LETTER CIEUC': 65464,
'HALFWIDTH HANGUL LETTER E': 65479,
'HALFWIDTH HANGUL LETTER EO': 65478,
'HALFWIDTH HANGUL LETTER EU': 65498,
'HALFWIDTH HANGUL LETTER HIEUH': 65470,
'HALFWIDTH HANGUL LETTER I': 65500,
'HALFWIDTH HANGUL LETTER IEUNG': 65463,
'HALFWIDTH HANGUL LETTER KHIEUKH': 65467,
'HALFWIDTH HANGUL LETTER KIYEOK': 65441,
'HALFWIDTH HANGUL LETTER KIYEOK-SIOS': 65443,
'HALFWIDTH HANGUL LETTER MIEUM': 65457,
'HALFWIDTH HANGUL LETTER NIEUN': 65444,
'HALFWIDTH HANGUL LETTER NIEUN-CIEUC': 65445,
'HALFWIDTH HANGUL LETTER NIEUN-HIEUH': 65446,
'HALFWIDTH HANGUL LETTER O': 65484,
'HALFWIDTH HANGUL LETTER OE': 65487,
'HALFWIDTH HANGUL LETTER PHIEUPH': 65469,
'HALFWIDTH HANGUL LETTER PIEUP': 65458,
'HALFWIDTH HANGUL LETTER PIEUP-SIOS': 65460,
'HALFWIDTH HANGUL LETTER RIEUL': 65449,
'HALFWIDTH HANGUL LETTER RIEUL-HIEUH': 65456,
'HALFWIDTH HANGUL LETTER RIEUL-KIYEOK': 65450,
'HALFWIDTH HANGUL LETTER RIEUL-MIEUM': 65451,
'HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH': 65455,
'HALFWIDTH HANGUL LETTER RIEUL-PIEUP': 65452,
'HALFWIDTH HANGUL LETTER RIEUL-SIOS': 65453,
'HALFWIDTH HANGUL LETTER RIEUL-THIEUTH': 65454,
'HALFWIDTH HANGUL LETTER SIOS': 65461,
'HALFWIDTH HANGUL LETTER SSANGCIEUC': 65465,
'HALFWIDTH HANGUL LETTER SSANGKIYEOK': 65442,
'HALFWIDTH HANGUL LETTER SSANGPIEUP': 65459,
'HALFWIDTH HANGUL LETTER SSANGSIOS': 65462,
'HALFWIDTH HANGUL LETTER SSANGTIKEUT': 65448,
'HALFWIDTH HANGUL LETTER THIEUTH': 65468,
'HALFWIDTH HANGUL LETTER TIKEUT': 65447,
'HALFWIDTH HANGUL LETTER U': 65491,
'HALFWIDTH HANGUL LETTER WA': 65485,
'HALFWIDTH HANGUL LETTER WAE': 65486,
'HALFWIDTH HANGUL LETTER WE': 65493,
'HALFWIDTH HANGUL LETTER WEO': 65492,
'HALFWIDTH HANGUL LETTER WI': 65494,
'HALFWIDTH HANGUL LETTER YA': 65476,
'HALFWIDTH HANGUL LETTER YAE': 65477,
'HALFWIDTH HANGUL LETTER YE': 65483,
'HALFWIDTH HANGUL LETTER YEO': 65482,
'HALFWIDTH HANGUL LETTER YI': 65499,
'HALFWIDTH HANGUL LETTER YO': 65490,
'HALFWIDTH HANGUL LETTER YU': 65495,
'HALFWIDTH IDEOGRAPHIC COMMA': 65380,
'HALFWIDTH IDEOGRAPHIC FULL STOP': 65377,
'HALFWIDTH KATAKANA LETTER A': 65393,
'HALFWIDTH KATAKANA LETTER E': 65396,
'HALFWIDTH KATAKANA LETTER HA': 65418,
'HALFWIDTH KATAKANA LETTER HE': 65421,
'HALFWIDTH KATAKANA LETTER HI': 65419,
'HALFWIDTH KATAKANA LETTER HO': 65422,
'HALFWIDTH KATAKANA LETTER HU': 65420,
'HALFWIDTH KATAKANA LETTER I': 65394,
'HALFWIDTH KATAKANA LETTER KA': 65398,
'HALFWIDTH KATAKANA LETTER KE': 65401,
'HALFWIDTH KATAKANA LETTER KI': 65399,
'HALFWIDTH KATAKANA LETTER KO': 65402,
'HALFWIDTH KATAKANA LETTER KU': 65400,
'HALFWIDTH KATAKANA LETTER MA': 65423,
'HALFWIDTH KATAKANA LETTER ME': 65426,
'HALFWIDTH KATAKANA LETTER MI': 65424,
'HALFWIDTH KATAKANA LETTER MO': 65427,
'HALFWIDTH KATAKANA LETTER MU': 65425,
'HALFWIDTH KATAKANA LETTER N': 65437,
'HALFWIDTH KATAKANA LETTER NA': 65413,
'HALFWIDTH KATAKANA LETTER NE': 65416,
'HALFWIDTH KATAKANA LETTER NI': 65414,
'HALFWIDTH KATAKANA LETTER NO': 65417,
'HALFWIDTH KATAKANA LETTER NU': 65415,
'HALFWIDTH KATAKANA LETTER O': 65397,
'HALFWIDTH KATAKANA LETTER RA': 65431,
'HALFWIDTH KATAKANA LETTER RE': 65434,
'HALFWIDTH KATAKANA LETTER RI': 65432,
'HALFWIDTH KATAKANA LETTER RO': 65435,
'HALFWIDTH KATAKANA LETTER RU': 65433,
'HALFWIDTH KATAKANA LETTER SA': 65403,
'HALFWIDTH KATAKANA LETTER SE': 65406,
'HALFWIDTH KATAKANA LETTER SI': 65404,
'HALFWIDTH KATAKANA LETTER SMALL A': 65383,
'HALFWIDTH KATAKANA LETTER SMALL E': 65386,
'HALFWIDTH KATAKANA LETTER SMALL I': 65384,
'HALFWIDTH KATAKANA LETTER SMALL O': 65387,
'HALFWIDTH KATAKANA LETTER SMALL TU': 65391,
'HALFWIDTH KATAKANA LETTER SMALL U': 65385,
'HALFWIDTH KATAKANA LETTER SMALL YA': 65388,
'HALFWIDTH KATAKANA LETTER SMALL YO': 65390,
'HALFWIDTH KATAKANA LETTER SMALL YU': 65389,
'HALFWIDTH KATAKANA LETTER SO': 65407,
'HALFWIDTH KATAKANA LETTER SU': 65405,
'HALFWIDTH KATAKANA LETTER TA': 65408,
'HALFWIDTH KATAKANA LETTER TE': 65411,
'HALFWIDTH KATAKANA LETTER TI': 65409,
'HALFWIDTH KATAKANA LETTER TO': 65412,
'HALFWIDTH KATAKANA LETTER TU': 65410,
'HALFWIDTH KATAKANA LETTER U': 65395,
'HALFWIDTH KATAKANA LETTER WA': 65436,
'HALFWIDTH KATAKANA LETTER WO': 65382,
'HALFWIDTH KATAKANA LETTER YA': 65428,
'HALFWIDTH KATAKANA LETTER YO': 65430,
'HALFWIDTH KATAKANA LETTER YU': 65429,
'HALFWIDTH KATAKANA MIDDLE DOT': 65381,
'HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK': 65439,
'HALFWIDTH KATAKANA VOICED SOUND MARK': 65438,
'HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK': 65392,
'HALFWIDTH LEFT CORNER BRACKET': 65378,
'HALFWIDTH LEFTWARDS ARROW': 65513,
'HALFWIDTH RIGHT CORNER BRACKET': 65379,
'HALFWIDTH RIGHTWARDS ARROW': 65515,
'HALFWIDTH UPWARDS ARROW': 65514,
'HALFWIDTH WHITE CIRCLE': 65518,
'HAMMER AND SICKLE': 9773,
'HANGUL CHOSEONG CEONGCHIEUMCHIEUCH': 4437,
'HANGUL CHOSEONG CEONGCHIEUMCIEUC': 4432,
'HANGUL CHOSEONG CEONGCHIEUMSIOS': 4414,
'HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC': 4433,
'HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS': 4415,
'HANGUL CHOSEONG CHIEUCH': 4366,
'HANGUL CHOSEONG CHIEUCH-HIEUH': 4435,
'HANGUL CHOSEONG CHIEUCH-KHIEUKH': 4434,
'HANGUL CHOSEONG CHITUEUMCHIEUCH': 4436,
'HANGUL CHOSEONG CHITUEUMCIEUC': 4430,
'HANGUL CHOSEONG CHITUEUMSIOS': 4412,
'HANGUL CHOSEONG CHITUEUMSSANGCIEUC': 4431,
'HANGUL CHOSEONG CHITUEUMSSANGSIOS': 4413,
'HANGUL CHOSEONG CIEUC': 4364,
'HANGUL CHOSEONG CIEUC-IEUNG': 4429,
'HANGUL CHOSEONG FILLER': 4447,
'HANGUL CHOSEONG HIEUH': 4370,
'HANGUL CHOSEONG IEUNG': 4363,
'HANGUL CHOSEONG IEUNG-CHIEUCH': 4425,
'HANGUL CHOSEONG IEUNG-CIEUC': 4424,
'HANGUL CHOSEONG IEUNG-KIYEOK': 4417,
'HANGUL CHOSEONG IEUNG-MIEUM': 4419,
'HANGUL CHOSEONG IEUNG-PANSIOS': 4422,
'HANGUL CHOSEONG IEUNG-PHIEUPH': 4427,
'HANGUL CHOSEONG IEUNG-PIEUP': 4420,
'HANGUL CHOSEONG IEUNG-SIOS': 4421,
'HANGUL CHOSEONG IEUNG-THIEUTH': 4426,
'HANGUL CHOSEONG IEUNG-TIKEUT': 4418,
'HANGUL CHOSEONG KAPYEOUNMIEUM': 4381,
'HANGUL CHOSEONG KAPYEOUNPHIEUPH': 4439,
'HANGUL CHOSEONG KAPYEOUNPIEUP': 4395,
'HANGUL CHOSEONG KAPYEOUNRIEUL': 4379,
'HANGUL CHOSEONG KAPYEOUNSSANGPIEUP': 4396,
'HANGUL CHOSEONG KHIEUKH': 4367,
'HANGUL CHOSEONG KIYEOK': 4352,
'HANGUL CHOSEONG MIEUM': 4358,
'HANGUL CHOSEONG MIEUM-PIEUP': 4380,
'HANGUL CHOSEONG NIEUN': 4354,
'HANGUL CHOSEONG NIEUN-KIYEOK': 4371,
'HANGUL CHOSEONG NIEUN-PIEUP': 4374,
'HANGUL CHOSEONG NIEUN-TIKEUT': 4373,
'HANGUL CHOSEONG PANSIOS': 4416,
'HANGUL CHOSEONG PHIEUPH': 4369,
'HANGUL CHOSEONG PHIEUPH-PIEUP': 4438,
'HANGUL CHOSEONG PIEUP': 4359,
'HANGUL CHOSEONG PIEUP-CHIEUCH': 4392,
'HANGUL CHOSEONG PIEUP-CIEUC': 4391,
'HANGUL CHOSEONG PIEUP-KIYEOK': 4382,
'HANGUL CHOSEONG PIEUP-NIEUN': 4383,
'HANGUL CHOSEONG PIEUP-PHIEUPH': 4394,
'HANGUL CHOSEONG PIEUP-SIOS': 4385,
'HANGUL CHOSEONG PIEUP-SIOS-CIEUC': 4390,
'HANGUL CHOSEONG PIEUP-SIOS-KIYEOK': 4386,
'HANGUL CHOSEONG PIEUP-SIOS-PIEUP': 4388,
'HANGUL CHOSEONG PIEUP-SIOS-TIKEUT': 4387,
'HANGUL CHOSEONG PIEUP-SSANGSIOS': 4389,
'HANGUL CHOSEONG PIEUP-THIEUTH': 4393,
'HANGUL CHOSEONG PIEUP-TIKEUT': 4384,
'HANGUL CHOSEONG RIEUL': 4357,
'HANGUL CHOSEONG RIEUL-HIEUH': 4378,
'HANGUL CHOSEONG RIEUL-NIEUN': 4376,
'HANGUL CHOSEONG SIOS': 4361,
'HANGUL CHOSEONG SIOS-CHIEUCH': 4407,
'HANGUL CHOSEONG SIOS-CIEUC': 4406,
'HANGUL CHOSEONG SIOS-HIEUH': 4411,
'HANGUL CHOSEONG SIOS-IEUNG': 4405,
'HANGUL CHOSEONG SIOS-KHIEUKH': 4408,
'HANGUL CHOSEONG SIOS-KIYEOK': 4397,
'HANGUL CHOSEONG SIOS-MIEUM': 4401,
'HANGUL CHOSEONG SIOS-NIEUN': 4398,
'HANGUL CHOSEONG SIOS-PHIEUPH': 4410,
'HANGUL CHOSEONG SIOS-PIEUP': 4402,
'HANGUL CHOSEONG SIOS-PIEUP-KIYEOK': 4403,
'HANGUL CHOSEONG SIOS-RIEUL': 4400,
'HANGUL CHOSEONG SIOS-SSANGSIOS': 4404,
'HANGUL CHOSEONG SIOS-THIEUTH': 4409,
'HANGUL CHOSEONG SIOS-TIKEUT': 4399,
'HANGUL CHOSEONG SSANGCIEUC': 4365,
'HANGUL CHOSEONG SSANGHIEUH': 4440,
'HANGUL CHOSEONG SSANGIEUNG': 4423,
'HANGUL CHOSEONG SSANGKIYEOK': 4353,
'HANGUL CHOSEONG SSANGNIEUN': 4372,
'HANGUL CHOSEONG SSANGPIEUP': 4360,
'HANGUL CHOSEONG SSANGRIEUL': 4377,
'HANGUL CHOSEONG SSANGSIOS': 4362,
'HANGUL CHOSEONG SSANGTIKEUT': 4356,
'HANGUL CHOSEONG THIEUTH': 4368,
'HANGUL CHOSEONG TIKEUT': 4355,
'HANGUL CHOSEONG TIKEUT-KIYEOK': 4375,
'HANGUL CHOSEONG YEORINHIEUH': 4441,
'HANGUL CHOSEONG YESIEUNG': 4428,
'HANGUL DOUBLE DOT TONE MARK': 12335,
'HANGUL FILLER': 12644,
'HANGUL JONGSEONG CHIEUCH': 4542,
'HANGUL JONGSEONG CIEUC': 4541,
'HANGUL JONGSEONG HIEUH': 4546,
'HANGUL JONGSEONG HIEUH-MIEUM': 4599,
'HANGUL JONGSEONG HIEUH-NIEUN': 4597,
'HANGUL JONGSEONG HIEUH-PIEUP': 4600,
'HANGUL JONGSEONG HIEUH-RIEUL': 4598,
'HANGUL JONGSEONG IEUNG': 4540,
'HANGUL JONGSEONG IEUNG-KHIEUKH': 4591,
'HANGUL JONGSEONG IEUNG-KIYEOK': 4588,
'HANGUL JONGSEONG IEUNG-SSANGKIYEOK': 4589,
'HANGUL JONGSEONG KAPYEOUNMIEUM': 4578,
'HANGUL JONGSEONG KAPYEOUNPHIEUPH': 4596,
'HANGUL JONGSEONG KAPYEOUNPIEUP': 4582,
'HANGUL JONGSEONG KHIEUKH': 4543,
'HANGUL JONGSEONG KIYEOK': 4520,
'HANGUL JONGSEONG KIYEOK-RIEUL': 4547,
'HANGUL JONGSEONG KIYEOK-SIOS': 4522,
'HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK': 4548,
'HANGUL JONGSEONG MIEUM': 4535,
'HANGUL JONGSEONG MIEUM-CHIEUCH': 4576,
'HANGUL JONGSEONG MIEUM-HIEUH': 4577,
'HANGUL JONGSEONG MIEUM-KIYEOK': 4570,
'HANGUL JONGSEONG MIEUM-PANSIOS': 4575,
'HANGUL JONGSEONG MIEUM-PIEUP': 4572,
'HANGUL JONGSEONG MIEUM-RIEUL': 4571,
'HANGUL JONGSEONG MIEUM-SIOS': 4573,
'HANGUL JONGSEONG MIEUM-SSANGSIOS': 4574,
'HANGUL JONGSEONG NIEUN': 4523,
'HANGUL JONGSEONG NIEUN-CIEUC': 4524,
'HANGUL JONGSEONG NIEUN-HIEUH': 4525,
'HANGUL JONGSEONG NIEUN-KIYEOK': 4549,
'HANGUL JONGSEONG NIEUN-PANSIOS': 4552,
'HANGUL JONGSEONG NIEUN-SIOS': 4551,
'HANGUL JONGSEONG NIEUN-THIEUTH': 4553,
'HANGUL JONGSEONG NIEUN-TIKEUT': 4550,
'HANGUL JONGSEONG PANSIOS': 4587,
'HANGUL JONGSEONG PHIEUPH': 4545,
'HANGUL JONGSEONG PHIEUPH-PIEUP': 4595,
'HANGUL JONGSEONG PIEUP': 4536,
'HANGUL JONGSEONG PIEUP-HIEUH': 4581,
'HANGUL JONGSEONG PIEUP-PHIEUPH': 4580,
'HANGUL JONGSEONG PIEUP-RIEUL': 4579,
'HANGUL JONGSEONG PIEUP-SIOS': 4537,
'HANGUL JONGSEONG RIEUL': 4527,
'HANGUL JONGSEONG RIEUL-HIEUH': 4534,
'HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP': 4565,
'HANGUL JONGSEONG RIEUL-KHIEUKH': 4568,
'HANGUL JONGSEONG RIEUL-KIYEOK': 4528,
'HANGUL JONGSEONG RIEUL-KIYEOK-SIOS': 4556,
'HANGUL JONGSEONG RIEUL-MIEUM': 4529,
'HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK': 4561,
'HANGUL JONGSEONG RIEUL-MIEUM-SIOS': 4562,
'HANGUL JONGSEONG RIEUL-NIEUN': 4557,
'HANGUL JONGSEONG RIEUL-PANSIOS': 4567,
'HANGUL JONGSEONG RIEUL-PHIEUPH': 4533,
'HANGUL JONGSEONG RIEUL-PIEUP': 4530,
'HANGUL JONGSEONG RIEUL-PIEUP-HIEUH': 4564,
'HANGUL JONGSEONG RIEUL-PIEUP-SIOS': 4563,
'HANGUL JONGSEONG RIEUL-SIOS': 4531,
'HANGUL JONGSEONG RIEUL-SSANGSIOS': 4566,
'HANGUL JONGSEONG RIEUL-THIEUTH': 4532,
'HANGUL JONGSEONG RIEUL-TIKEUT': 4558,
'HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH': 4559,
'HANGUL JONGSEONG RIEUL-YEORINHIEUH': 4569,
'HANGUL JONGSEONG SIOS': 4538,
'HANGUL JONGSEONG SIOS-KIYEOK': 4583,
'HANGUL JONGSEONG SIOS-PIEUP': 4586,
'HANGUL JONGSEONG SIOS-RIEUL': 4585,
'HANGUL JONGSEONG SIOS-TIKEUT': 4584,
'HANGUL JONGSEONG SSANGIEUNG': 4590,
'HANGUL JONGSEONG SSANGKIYEOK': 4521,
'HANGUL JONGSEONG SSANGRIEUL': 4560,
'HANGUL JONGSEONG SSANGSIOS': 4539,
'HANGUL JONGSEONG THIEUTH': 4544,
'HANGUL JONGSEONG TIKEUT': 4526,
'HANGUL JONGSEONG TIKEUT-KIYEOK': 4554,
'HANGUL JONGSEONG TIKEUT-RIEUL': 4555,
'HANGUL JONGSEONG YEORINHIEUH': 4601,
'HANGUL JONGSEONG YESIEUNG': 4592,
'HANGUL JONGSEONG YESIEUNG-PANSIOS': 4594,
'HANGUL JONGSEONG YESIEUNG-SIOS': 4593,
'HANGUL JUNGSEONG A': 4449,
'HANGUL JUNGSEONG A-O': 4470,
'HANGUL JUNGSEONG A-U': 4471,
'HANGUL JUNGSEONG AE': 4450,
'HANGUL JUNGSEONG ARAEA': 4510,
'HANGUL JUNGSEONG ARAEA-EO': 4511,
'HANGUL JUNGSEONG ARAEA-I': 4513,
'HANGUL JUNGSEONG ARAEA-U': 4512,
'HANGUL JUNGSEONG E': 4454,
'HANGUL JUNGSEONG EO': 4453,
'HANGUL JUNGSEONG EO-EU': 4476,
'HANGUL JUNGSEONG EO-O': 4474,
'HANGUL JUNGSEONG EO-U': 4475,
'HANGUL JUNGSEONG EU': 4467,
'HANGUL JUNGSEONG EU-EU': 4502,
'HANGUL JUNGSEONG EU-U': 4501,
'HANGUL JUNGSEONG FILLER': 4448,
'HANGUL JUNGSEONG I': 4469,
'HANGUL JUNGSEONG I-A': 4504,
'HANGUL JUNGSEONG I-ARAEA': 4509,
'HANGUL JUNGSEONG I-EU': 4508,
'HANGUL JUNGSEONG I-O': 4506,
'HANGUL JUNGSEONG I-U': 4507,
'HANGUL JUNGSEONG I-YA': 4505,
'HANGUL JUNGSEONG O': 4457,
'HANGUL JUNGSEONG O-E': 4480,
'HANGUL JUNGSEONG O-EO': 4479,
'HANGUL JUNGSEONG O-O': 4482,
'HANGUL JUNGSEONG O-U': 4483,
'HANGUL JUNGSEONG O-YE': 4481,
'HANGUL JUNGSEONG OE': 4460,
'HANGUL JUNGSEONG SSANGARAEA': 4514,
'HANGUL JUNGSEONG U': 4462,
'HANGUL JUNGSEONG U-A': 4489,
'HANGUL JUNGSEONG U-AE': 4490,
'HANGUL JUNGSEONG U-EO-EU': 4491,
'HANGUL JUNGSEONG U-U': 4493,
'HANGUL JUNGSEONG U-YE': 4492,
'HANGUL JUNGSEONG WA': 4458,
'HANGUL JUNGSEONG WAE': 4459,
'HANGUL JUNGSEONG WE': 4464,
'HANGUL JUNGSEONG WEO': 4463,
'HANGUL JUNGSEONG WI': 4465,
'HANGUL JUNGSEONG YA': 4451,
'HANGUL JUNGSEONG YA-O': 4472,
'HANGUL JUNGSEONG YA-YO': 4473,
'HANGUL JUNGSEONG YAE': 4452,
'HANGUL JUNGSEONG YE': 4456,
'HANGUL JUNGSEONG YEO': 4455,
'HANGUL JUNGSEONG YEO-O': 4477,
'HANGUL JUNGSEONG YEO-U': 4478,
'HANGUL JUNGSEONG YI': 4468,
'HANGUL JUNGSEONG YI-U': 4503,
'HANGUL JUNGSEONG YO': 4461,
'HANGUL JUNGSEONG YO-I': 4488,
'HANGUL JUNGSEONG YO-O': 4487,
'HANGUL JUNGSEONG YO-YA': 4484,
'HANGUL JUNGSEONG YO-YAE': 4485,
'HANGUL JUNGSEONG YO-YEO': 4486,
'HANGUL JUNGSEONG YU': 4466,
'HANGUL JUNGSEONG YU-A': 4494,
'HANGUL JUNGSEONG YU-E': 4496,
'HANGUL JUNGSEONG YU-EO': 4495,
'HANGUL JUNGSEONG YU-I': 4500,
'HANGUL JUNGSEONG YU-U': 4499,
'HANGUL JUNGSEONG YU-YE': 4498,
'HANGUL JUNGSEONG YU-YEO': 4497,
'HANGUL LETTER A': 12623,
'HANGUL LETTER AE': 12624,
'HANGUL LETTER ARAEA': 12685,
'HANGUL LETTER ARAEAE': 12686,
'HANGUL LETTER CHIEUCH': 12618,
'HANGUL LETTER CIEUC': 12616,
'HANGUL LETTER E': 12628,
'HANGUL LETTER EO': 12627,
'HANGUL LETTER EU': 12641,
'HANGUL LETTER HIEUH': 12622,
'HANGUL LETTER I': 12643,
'HANGUL LETTER IEUNG': 12615,
'HANGUL LETTER KAPYEOUNMIEUM': 12657,
'HANGUL LETTER KAPYEOUNPHIEUPH': 12676,
'HANGUL LETTER KAPYEOUNPIEUP': 12664,
'HANGUL LETTER KAPYEOUNSSANGPIEUP': 12665,
'HANGUL LETTER KHIEUKH': 12619,
'HANGUL LETTER KIYEOK': 12593,
'HANGUL LETTER KIYEOK-SIOS': 12595,
'HANGUL LETTER MIEUM': 12609,
'HANGUL LETTER MIEUM-PANSIOS': 12656,
'HANGUL LETTER MIEUM-PIEUP': 12654,
'HANGUL LETTER MIEUM-SIOS': 12655,
'HANGUL LETTER NIEUN': 12596,
'HANGUL LETTER NIEUN-CIEUC': 12597,
'HANGUL LETTER NIEUN-HIEUH': 12598,
'HANGUL LETTER NIEUN-PANSIOS': 12648,
'HANGUL LETTER NIEUN-SIOS': 12647,
'HANGUL LETTER NIEUN-TIKEUT': 12646,
'HANGUL LETTER O': 12631,
'HANGUL LETTER OE': 12634,
'HANGUL LETTER PANSIOS': 12671,
'HANGUL LETTER PHIEUPH': 12621,
'HANGUL LETTER PIEUP': 12610,
'HANGUL LETTER PIEUP-CIEUC': 12662,
'HANGUL LETTER PIEUP-KIYEOK': 12658,
'HANGUL LETTER PIEUP-SIOS': 12612,
'HANGUL LETTER PIEUP-SIOS-KIYEOK': 12660,
'HANGUL LETTER PIEUP-SIOS-TIKEUT': 12661,
'HANGUL LETTER PIEUP-THIEUTH': 12663,
'HANGUL LETTER PIEUP-TIKEUT': 12659,
'HANGUL LETTER RIEUL': 12601,
'HANGUL LETTER RIEUL-HIEUH': 12608,
'HANGUL LETTER RIEUL-KIYEOK': 12602,
'HANGUL LETTER RIEUL-KIYEOK-SIOS': 12649,
'HANGUL LETTER RIEUL-MIEUM': 12603,
'HANGUL LETTER RIEUL-PANSIOS': 12652,
'HANGUL LETTER RIEUL-PHIEUPH': 12607,
'HANGUL LETTER RIEUL-PIEUP': 12604,
'HANGUL LETTER RIEUL-PIEUP-SIOS': 12651,
'HANGUL LETTER RIEUL-SIOS': 12605,
'HANGUL LETTER RIEUL-THIEUTH': 12606,
'HANGUL LETTER RIEUL-TIKEUT': 12650,
'HANGUL LETTER RIEUL-YEORINHIEUH': 12653,
'HANGUL LETTER SIOS': 12613,
'HANGUL LETTER SIOS-CIEUC': 12670,
'HANGUL LETTER SIOS-KIYEOK': 12666,
'HANGUL LETTER SIOS-NIEUN': 12667,
'HANGUL LETTER SIOS-PIEUP': 12669,
'HANGUL LETTER SIOS-TIKEUT': 12668,
'HANGUL LETTER SSANGCIEUC': 12617,
'HANGUL LETTER SSANGHIEUH': 12677,
'HANGUL LETTER SSANGIEUNG': 12672,
'HANGUL LETTER SSANGKIYEOK': 12594,
'HANGUL LETTER SSANGNIEUN': 12645,
'HANGUL LETTER SSANGPIEUP': 12611,
'HANGUL LETTER SSANGSIOS': 12614,
'HANGUL LETTER SSANGTIKEUT': 12600,
'HANGUL LETTER THIEUTH': 12620,
'HANGUL LETTER TIKEUT': 12599,
'HANGUL LETTER U': 12636,
'HANGUL LETTER WA': 12632,
'HANGUL LETTER WAE': 12633,
'HANGUL LETTER WE': 12638,
'HANGUL LETTER WEO': 12637,
'HANGUL LETTER WI': 12639,
'HANGUL LETTER YA': 12625,
'HANGUL LETTER YAE': 12626,
'HANGUL LETTER YE': 12630,
'HANGUL LETTER YEO': 12629,
'HANGUL LETTER YEORINHIEUH': 12678,
'HANGUL LETTER YESIEUNG': 12673,
'HANGUL LETTER YESIEUNG-PANSIOS': 12675,
'HANGUL LETTER YESIEUNG-SIOS': 12674,
'HANGUL LETTER YI': 12642,
'HANGUL LETTER YO': 12635,
'HANGUL LETTER YO-I': 12681,
'HANGUL LETTER YO-YA': 12679,
'HANGUL LETTER YO-YAE': 12680,
'HANGUL LETTER YU': 12640,
'HANGUL LETTER YU-I': 12684,
'HANGUL LETTER YU-YE': 12683,
'HANGUL LETTER YU-YEO': 12682,
'HANGUL SINGLE DOT TONE MARK': 12334,
'HANGZHOU NUMERAL EIGHT': 12328,
'HANGZHOU NUMERAL FIVE': 12325,
'HANGZHOU NUMERAL FOUR': 12324,
'HANGZHOU NUMERAL NINE': 12329,
'HANGZHOU NUMERAL ONE': 12321,
'HANGZHOU NUMERAL SEVEN': 12327,
'HANGZHOU NUMERAL SIX': 12326,
'HANGZHOU NUMERAL TEN': 12344,
'HANGZHOU NUMERAL THIRTY': 12346,
'HANGZHOU NUMERAL THREE': 12323,
'HANGZHOU NUMERAL TWENTY': 12345,
'HANGZHOU NUMERAL TWO': 12322,
'HANUNOO LETTER A': 5920,
'HANUNOO LETTER BA': 5930,
'HANUNOO LETTER DA': 5927,
'HANUNOO LETTER GA': 5924,
'HANUNOO LETTER HA': 5937,
'HANUNOO LETTER I': 5921,
'HANUNOO LETTER KA': 5923,
'HANUNOO LETTER LA': 5934,
'HANUNOO LETTER MA': 5931,
'HANUNOO LETTER NA': 5928,
'HANUNOO LETTER NGA': 5925,
'HANUNOO LETTER PA': 5929,
'HANUNOO LETTER RA': 5933,
'HANUNOO LETTER SA': 5936,
'HANUNOO LETTER TA': 5926,
'HANUNOO LETTER U': 5922,
'HANUNOO LETTER WA': 5935,
'HANUNOO LETTER YA': 5932,
'HANUNOO SIGN PAMUDPOD': 5940,
'HANUNOO VOWEL SIGN I': 5938,
'HANUNOO VOWEL SIGN U': 5939,
'HEAVY ASTERISK': 10033,
'HEAVY BALLOT X': 10008,
'HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW': 10149,
'HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW': 10150,
'HEAVY BLACK HEART': 10084,
'HEAVY BLACK-FEATHERED NORTH EAST ARROW': 10169,
'HEAVY BLACK-FEATHERED RIGHTWARDS ARROW': 10168,
'HEAVY BLACK-FEATHERED SOUTH EAST ARROW': 10167,
'HEAVY CHECK MARK': 10004,
'HEAVY CHEVRON SNOWFLAKE': 10054,
'HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW': 10152,
'HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW': 10144,
'HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT': 10078,
'HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT': 10077,
'HEAVY EIGHT POINTED RECTILINEAR BLACK STAR': 10040,
'HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK': 10059,
'HEAVY EXCLAMATION MARK ORNAMENT': 10082,
'HEAVY FOUR BALLOON-SPOKED ASTERISK': 10020,
'HEAVY GREEK CROSS': 10010,
'HEAVY HEART EXCLAMATION MARK ORNAMENT': 10083,
'HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT': 10096,
'HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT': 10094,
'HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW': 10157,
'HEAVY MULTIPLICATION X': 10006,
'HEAVY NORTH EAST ARROW': 10138,
'HEAVY OPEN CENTRE CROSS': 10012,
'HEAVY OUTLINED BLACK STAR': 10030,
'HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT': 10097,
'HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT': 10095,
'HEAVY RIGHTWARDS ARROW': 10137,
'HEAVY ROUND-TIPPED RIGHTWARDS ARROW': 10140,
'HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT': 10076,
'HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT': 10075,
'HEAVY SOUTH EAST ARROW': 10136,
'HEAVY SPARKLE': 10056,
'HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW': 10171,
'HEAVY TEARDROP-SPOKED ASTERISK': 10045,
'HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK': 10051,
'HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW': 10142,
'HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW': 10158,
'HEAVY VERTICAL BAR': 10074,
'HEAVY WEDGE-TAILED RIGHTWARDS ARROW': 10173,
'HEAVY WIDE-HEADED RIGHTWARDS ARROW': 10132,
'HEBREW ACCENT DARGA': 1447,
'HEBREW ACCENT DEHI': 1453,
'HEBREW ACCENT ETNAHTA': 1425,
'HEBREW ACCENT GERESH': 1436,
'HEBREW ACCENT GERESH MUQDAM': 1437,
'HEBREW ACCENT GERSHAYIM': 1438,
'HEBREW ACCENT ILUY': 1452,
'HEBREW ACCENT MAHAPAKH': 1444,
'HEBREW ACCENT MERKHA': 1445,
'HEBREW ACCENT MERKHA KEFULA': 1446,
'HEBREW ACCENT MUNAH': 1443,
'HEBREW ACCENT OLE': 1451,
'HEBREW ACCENT PASHTA': 1433,
'HEBREW ACCENT PAZER': 1441,
'HEBREW ACCENT QADMA': 1448,
'HEBREW ACCENT QARNEY PARA': 1439,
'HEBREW ACCENT REVIA': 1431,
'HEBREW ACCENT SEGOL': 1426,
'HEBREW ACCENT SHALSHELET': 1427,
'HEBREW ACCENT TELISHA GEDOLA': 1440,
'HEBREW ACCENT TELISHA QETANA': 1449,
'HEBREW ACCENT TEVIR': 1435,
'HEBREW ACCENT TIPEHA': 1430,
'HEBREW ACCENT YERAH BEN YOMO': 1450,
'HEBREW ACCENT YETIV': 1434,
'HEBREW ACCENT ZAQEF GADOL': 1429,
'HEBREW ACCENT ZAQEF QATAN': 1428,
'HEBREW ACCENT ZARQA': 1432,
'HEBREW ACCENT ZINOR': 1454,
'HEBREW LETTER ALEF': 1488,
'HEBREW LETTER ALEF WITH MAPIQ': 64304,
'HEBREW LETTER ALEF WITH PATAH': 64302,
'HEBREW LETTER ALEF WITH QAMATS': 64303,
'HEBREW LETTER ALTERNATIVE AYIN': 64288,
'HEBREW LETTER ALTERNATIVE PLUS SIGN': 64297,
'HEBREW LETTER AYIN': 1506,
'HEBREW LETTER BET': 1489,
'HEBREW LETTER BET WITH DAGESH': 64305,
'HEBREW LETTER BET WITH RAFE': 64332,
'HEBREW LETTER DALET': 1491,
'HEBREW LETTER DALET WITH DAGESH': 64307,
'HEBREW LETTER FINAL KAF': 1498,
'HEBREW LETTER FINAL KAF WITH DAGESH': 64314,
'HEBREW LETTER FINAL MEM': 1501,
'HEBREW LETTER FINAL NUN': 1503,
'HEBREW LETTER FINAL PE': 1507,
'HEBREW LETTER FINAL PE WITH DAGESH': 64323,
'HEBREW LETTER FINAL TSADI': 1509,
'HEBREW LETTER GIMEL': 1490,
'HEBREW LETTER GIMEL WITH DAGESH': 64306,
'HEBREW LETTER HE': 1492,
'HEBREW LETTER HE WITH MAPIQ': 64308,
'HEBREW LETTER HET': 1495,
'HEBREW LETTER KAF': 1499,
'HEBREW LETTER KAF WITH DAGESH': 64315,
'HEBREW LETTER KAF WITH RAFE': 64333,
'HEBREW LETTER LAMED': 1500,
'HEBREW LETTER LAMED WITH DAGESH': 64316,
'HEBREW LETTER MEM': 1502,
'HEBREW LETTER MEM WITH DAGESH': 64318,
'HEBREW LETTER NUN': 1504,
'HEBREW LETTER NUN WITH DAGESH': 64320,
'HEBREW LETTER PE': 1508,
'HEBREW LETTER PE WITH DAGESH': 64324,
'HEBREW LETTER PE WITH RAFE': 64334,
'HEBREW LETTER QOF': 1511,
'HEBREW LETTER QOF WITH DAGESH': 64327,
'HEBREW LETTER RESH': 1512,
'HEBREW LETTER RESH WITH DAGESH': 64328,
'HEBREW LETTER SAMEKH': 1505,
'HEBREW LETTER SAMEKH WITH DAGESH': 64321,
'HEBREW LETTER SHIN': 1513,
'HEBREW LETTER SHIN WITH DAGESH': 64329,
'HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT': 64300,
'HEBREW LETTER SHIN WITH DAGESH AND SIN DOT': 64301,
'HEBREW LETTER SHIN WITH SHIN DOT': 64298,
'HEBREW LETTER SHIN WITH SIN DOT': 64299,
'HEBREW LETTER TAV': 1514,
'HEBREW LETTER TAV WITH DAGESH': 64330,
'HEBREW LETTER TET': 1496,
'HEBREW LETTER TET WITH DAGESH': 64312,
'HEBREW LETTER TSADI': 1510,
'HEBREW LETTER TSADI WITH DAGESH': 64326,
'HEBREW LETTER VAV': 1493,
'HEBREW LETTER VAV WITH DAGESH': 64309,
'HEBREW LETTER VAV WITH HOLAM': 64331,
'HEBREW LETTER WIDE ALEF': 64289,
'HEBREW LETTER WIDE DALET': 64290,
'HEBREW LETTER WIDE FINAL MEM': 64294,
'HEBREW LETTER WIDE HE': 64291,
'HEBREW LETTER WIDE KAF': 64292,
'HEBREW LETTER WIDE LAMED': 64293,
'HEBREW LETTER WIDE RESH': 64295,
'HEBREW LETTER WIDE TAV': 64296,
'HEBREW LETTER YOD': 1497,
'HEBREW LETTER YOD WITH DAGESH': 64313,
'HEBREW LETTER YOD WITH HIRIQ': 64285,
'HEBREW LETTER ZAYIN': 1494,
'HEBREW LETTER ZAYIN WITH DAGESH': 64310,
'HEBREW LIGATURE ALEF LAMED': 64335,
'HEBREW LIGATURE YIDDISH DOUBLE VAV': 1520,
'HEBREW LIGATURE YIDDISH DOUBLE YOD': 1522,
'HEBREW LIGATURE YIDDISH VAV YOD': 1521,
'HEBREW LIGATURE YIDDISH YOD YOD PATAH': 64287,
'HEBREW MARK MASORA CIRCLE': 1455,
'HEBREW MARK UPPER DOT': 1476,
'HEBREW POINT DAGESH OR MAPIQ': 1468,
'HEBREW POINT HATAF PATAH': 1458,
'HEBREW POINT HATAF QAMATS': 1459,
'HEBREW POINT HATAF SEGOL': 1457,
'HEBREW POINT HIRIQ': 1460,
'HEBREW POINT HOLAM': 1465,
'HEBREW POINT JUDEO-SPANISH VARIKA': 64286,
'HEBREW POINT METEG': 1469,
'HEBREW POINT PATAH': 1463,
'HEBREW POINT QAMATS': 1464,
'HEBREW POINT QUBUTS': 1467,
'HEBREW POINT RAFE': 1471,
'HEBREW POINT SEGOL': 1462,
'HEBREW POINT SHEVA': 1456,
'HEBREW POINT SHIN DOT': 1473,
'HEBREW POINT SIN DOT': 1474,
'HEBREW POINT TSERE': 1461,
'HEBREW PUNCTUATION GERESH': 1523,
'HEBREW PUNCTUATION GERSHAYIM': 1524,
'HEBREW PUNCTUATION MAQAF': 1470,
'HEBREW PUNCTUATION PASEQ': 1472,
'HEBREW PUNCTUATION SOF PASUQ': 1475,
'HELM SYMBOL': 9096,
'HERMITIAN CONJUGATE MATRIX': 8889,
'HIRAGANA DIGRAPH YORI': 12447,
'HIRAGANA ITERATION MARK': 12445,
'HIRAGANA LETTER A': 12354,
'HIRAGANA LETTER BA': 12400,
'HIRAGANA LETTER BE': 12409,
'HIRAGANA LETTER BI': 12403,
'HIRAGANA LETTER BO': 12412,
'HIRAGANA LETTER BU': 12406,
'HIRAGANA LETTER DA': 12384,
'HIRAGANA LETTER DE': 12391,
'HIRAGANA LETTER DI': 12386,
'HIRAGANA LETTER DO': 12393,
'HIRAGANA LETTER DU': 12389,
'HIRAGANA LETTER E': 12360,
'HIRAGANA LETTER GA': 12364,
'HIRAGANA LETTER GE': 12370,
'HIRAGANA LETTER GI': 12366,
'HIRAGANA LETTER GO': 12372,
'HIRAGANA LETTER GU': 12368,
'HIRAGANA LETTER HA': 12399,
'HIRAGANA LETTER HE': 12408,
'HIRAGANA LETTER HI': 12402,
'HIRAGANA LETTER HO': 12411,
'HIRAGANA LETTER HU': 12405,
'HIRAGANA LETTER I': 12356,
'HIRAGANA LETTER KA': 12363,
'HIRAGANA LETTER KE': 12369,
'HIRAGANA LETTER KI': 12365,
'HIRAGANA LETTER KO': 12371,
'HIRAGANA LETTER KU': 12367,
'HIRAGANA LETTER MA': 12414,
'HIRAGANA LETTER ME': 12417,
'HIRAGANA LETTER MI': 12415,
'HIRAGANA LETTER MO': 12418,
'HIRAGANA LETTER MU': 12416,
'HIRAGANA LETTER N': 12435,
'HIRAGANA LETTER NA': 12394,
'HIRAGANA LETTER NE': 12397,
'HIRAGANA LETTER NI': 12395,
'HIRAGANA LETTER NO': 12398,
'HIRAGANA LETTER NU': 12396,
'HIRAGANA LETTER O': 12362,
'HIRAGANA LETTER PA': 12401,
'HIRAGANA LETTER PE': 12410,
'HIRAGANA LETTER PI': 12404,
'HIRAGANA LETTER PO': 12413,
'HIRAGANA LETTER PU': 12407,
'HIRAGANA LETTER RA': 12425,
'HIRAGANA LETTER RE': 12428,
'HIRAGANA LETTER RI': 12426,
'HIRAGANA LETTER RO': 12429,
'HIRAGANA LETTER RU': 12427,
'HIRAGANA LETTER SA': 12373,
'HIRAGANA LETTER SE': 12379,
'HIRAGANA LETTER SI': 12375,
'HIRAGANA LETTER SMALL A': 12353,
'HIRAGANA LETTER SMALL E': 12359,
'HIRAGANA LETTER SMALL I': 12355,
'HIRAGANA LETTER SMALL KA': 12437,
'HIRAGANA LETTER SMALL KE': 12438,
'HIRAGANA LETTER SMALL O': 12361,
'HIRAGANA LETTER SMALL TU': 12387,
'HIRAGANA LETTER SMALL U': 12357,
'HIRAGANA LETTER SMALL WA': 12430,
'HIRAGANA LETTER SMALL YA': 12419,
'HIRAGANA LETTER SMALL YO': 12423,
'HIRAGANA LETTER SMALL YU': 12421,
'HIRAGANA LETTER SO': 12381,
'HIRAGANA LETTER SU': 12377,
'HIRAGANA LETTER TA': 12383,
'HIRAGANA LETTER TE': 12390,
'HIRAGANA LETTER TI': 12385,
'HIRAGANA LETTER TO': 12392,
'HIRAGANA LETTER TU': 12388,
'HIRAGANA LETTER U': 12358,
'HIRAGANA LETTER VU': 12436,
'HIRAGANA LETTER WA': 12431,
'HIRAGANA LETTER WE': 12433,
'HIRAGANA LETTER WI': 12432,
'HIRAGANA LETTER WO': 12434,
'HIRAGANA LETTER YA': 12420,
'HIRAGANA LETTER YO': 12424,
'HIRAGANA LETTER YU': 12422,
'HIRAGANA LETTER ZA': 12374,
'HIRAGANA LETTER ZE': 12380,
'HIRAGANA LETTER ZI': 12376,
'HIRAGANA LETTER ZO': 12382,
'HIRAGANA LETTER ZU': 12378,
'HIRAGANA VOICED ITERATION MARK': 12446,
'HOMOTHETIC': 8763,
'HORIZONTAL BAR': 8213,
'HORIZONTAL ELLIPSIS': 8230,
'HORIZONTAL LINE EXTENSION': 9135,
'HORIZONTAL SCAN LINE-1': 9146,
'HORIZONTAL SCAN LINE-3': 9147,
'HORIZONTAL SCAN LINE-7': 9148,
'HORIZONTAL SCAN LINE-9': 9149,
'HOT SPRINGS': 9832,
'HOURGLASS': 8987,
'HOUSE': 8962,
'HYPHEN': 8208,
'HYPHEN BULLET': 8259,
'HYPHEN-MINUS': 45,
'HYPHENATION POINT': 8231,
'HYSTERESIS SYMBOL': 9102,
'IDENTICAL TO': 8801,
'IDENTICAL TO AND SLANTED PARALLEL': 10725,
'IDENTICAL WITH DOT ABOVE': 10855,
'IDEOGRAPHIC ANNOTATION BOTTOM MARK': 12696,
'IDEOGRAPHIC ANNOTATION EARTH MARK': 12702,
'IDEOGRAPHIC ANNOTATION FIRST MARK': 12697,
'IDEOGRAPHIC ANNOTATION FOUR MARK': 12693,
'IDEOGRAPHIC ANNOTATION FOURTH MARK': 12700,
'IDEOGRAPHIC ANNOTATION HEAVEN MARK': 12701,
'IDEOGRAPHIC ANNOTATION LINKING MARK': 12688,
'IDEOGRAPHIC ANNOTATION MAN MARK': 12703,
'IDEOGRAPHIC ANNOTATION MIDDLE MARK': 12695,
'IDEOGRAPHIC ANNOTATION ONE MARK': 12690,
'IDEOGRAPHIC ANNOTATION REVERSE MARK': 12689,
'IDEOGRAPHIC ANNOTATION SECOND MARK': 12698,
'IDEOGRAPHIC ANNOTATION THIRD MARK': 12699,
'IDEOGRAPHIC ANNOTATION THREE MARK': 12692,
'IDEOGRAPHIC ANNOTATION TOP MARK': 12694,
'IDEOGRAPHIC ANNOTATION TWO MARK': 12691,
'IDEOGRAPHIC CLOSING MARK': 12294,
'IDEOGRAPHIC COMMA': 12289,
'IDEOGRAPHIC DEPARTING TONE MARK': 12332,
'IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW': 12273,
'IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW': 12275,
'IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND': 12276,
'IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT': 12274,
'IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT': 12272,
'IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID': 12283,
'IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE': 12277,
'IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW': 12278,
'IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT': 12279,
'IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT': 12282,
'IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT': 12280,
'IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT': 12281,
'IDEOGRAPHIC ENTERING TONE MARK': 12333,
'IDEOGRAPHIC FULL STOP': 12290,
'IDEOGRAPHIC HALF FILL SPACE': 12351,
'IDEOGRAPHIC ITERATION MARK': 12293,
'IDEOGRAPHIC LEVEL TONE MARK': 12330,
'IDEOGRAPHIC NUMBER ZERO': 12295,
'IDEOGRAPHIC RISING TONE MARK': 12331,
'IDEOGRAPHIC SPACE': 12288,
'IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL': 12343,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL': 12995,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST': 12999,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT': 13287,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN': 13297,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN': 13290,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN': 13294,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE': 13284,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR': 13283,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN': 13293,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE': 13288,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN': 13298,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE': 13280,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN': 13286,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN': 13296,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX': 13285,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN': 13295,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN': 13289,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN': 13292,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY': 13309,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE': 13310,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE': 13282,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE': 13291,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY': 13299,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT': 13307,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE': 13304,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR': 13303,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE': 13308,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE': 13300,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN': 13306,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX': 13305,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE': 13302,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO': 13301,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO': 13281,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER': 13003,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY': 12993,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT': 13152,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN': 13162,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN': 13155,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN': 13159,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE': 13149,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR': 13148,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN': 13158,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE': 13153,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN': 13163,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE': 13145,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN': 13151,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN': 13161,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX': 13150,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN': 13160,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN': 13154,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN': 13157,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE': 13147,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE': 13156,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY': 13164,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR': 13168,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE': 13165,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE': 13167,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO': 13166,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO': 13146,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO': 13144,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY': 12992,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY': 12998,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE': 12997,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH': 12994,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY': 12996,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER': 13002,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER': 13001,
'IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER': 13000,
'IDEOGRAPHIC VARIATION INDICATOR': 12350,
'IMAGE OF': 8887,
'IMAGE OF OR APPROXIMATELY EQUAL TO': 8787,
'INCOMPLETE INFINITY': 10716,
'INCREASES AS': 10721,
'INCREMENT': 8710,
'INFINITY': 8734,
'INFINITY NEGATED WITH VERTICAL BAR': 10718,
'INFORMATION SOURCE': 8505,
'INHIBIT ARABIC FORM SHAPING': 8300,
'INHIBIT SYMMETRIC SWAPPING': 8298,
'INSERTION SYMBOL': 9088,
'INTEGRAL': 8747,
'INTEGRAL AROUND A POINT OPERATOR': 10773,
'INTEGRAL AVERAGE WITH SLASH': 10767,
'INTEGRAL EXTENSION': 9134,
'INTEGRAL WITH DOUBLE STROKE': 10766,
'INTEGRAL WITH INTERSECTION': 10777,
'INTEGRAL WITH LEFTWARDS ARROW WITH HOOK': 10775,
'INTEGRAL WITH OVERBAR': 10779,
'INTEGRAL WITH TIMES SIGN': 10776,
'INTEGRAL WITH UNDERBAR': 10780,
'INTEGRAL WITH UNION': 10778,
'INTERCALATE': 8890,
'INTERIOR PRODUCT': 10812,
'INTERLINEAR ANNOTATION ANCHOR': 65529,
'INTERLINEAR ANNOTATION SEPARATOR': 65530,
'INTERLINEAR ANNOTATION TERMINATOR': 65531,
'INTERROBANG': 8253,
'INTERSECTION': 8745,
'INTERSECTION ABOVE BAR ABOVE UNION': 10825,
'INTERSECTION ABOVE UNION': 10823,
'INTERSECTION BESIDE AND JOINED WITH INTERSECTION': 10827,
'INTERSECTION WITH DOT': 10816,
'INTERSECTION WITH LOGICAL AND': 10820,
'INTERSECTION WITH OVERBAR': 10819,
'INVERSE BULLET': 9688,
'INVERSE WHITE CIRCLE': 9689,
'INVERTED EXCLAMATION MARK': 161,
'INVERTED LAZY S': 8766,
'INVERTED OHM SIGN': 8487,
'INVERTED QUESTION MARK': 191,
'INVISIBLE SEPARATOR': 8291,
'INVISIBLE TIMES': 8290,
'JAPANESE INDUSTRIAL STANDARD SYMBOL': 12292,
'JOIN': 10781,
'JUPITER': 9795,
'KANGXI RADICAL AGAIN': 12060,
'KANGXI RADICAL AND': 12157,
'KANGXI RADICAL ARRIVE': 12164,
'KANGXI RADICAL ARROW': 12142,
'KANGXI RADICAL AXE': 12100,
'KANGXI RADICAL BADGER': 12184,
'KANGXI RADICAL BAMBOO': 12149,
'KANGXI RADICAL BEAN': 12182,
'KANGXI RADICAL BIG': 12068,
'KANGXI RADICAL BIRD': 12227,
'KANGXI RADICAL BITTER': 12191,
'KANGXI RADICAL BLACK': 12234,
'KANGXI RADICAL BLOOD': 12174,
'KANGXI RADICAL BLUE': 12205,
'KANGXI RADICAL BOAT': 12168,
'KANGXI RADICAL BODY': 12189,
'KANGXI RADICAL BOLT OF CLOTH': 12134,
'KANGXI RADICAL BONE': 12219,
'KANGXI RADICAL BOW': 12088,
'KANGXI RADICAL BRANCH': 12096,
'KANGXI RADICAL BRISTLE': 12090,
'KANGXI RADICAL BRUSH': 12160,
'KANGXI RADICAL CART': 12190,
'KANGXI RADICAL CAULDRON': 12224,
'KANGXI RADICAL CAVE': 12147,
'KANGXI RADICAL CHILD': 12070,
'KANGXI RADICAL CITY': 12194,
'KANGXI RADICAL CLAN': 12114,
'KANGXI RADICAL CLAW': 12118,
'KANGXI RADICAL CLIFF': 12058,
'KANGXI RADICAL CLOTHES': 12176,
'KANGXI RADICAL COLOR': 12170,
'KANGXI RADICAL COMPARE': 12112,
'KANGXI RADICAL CORPSE': 12075,
'KANGXI RADICAL COVER': 12045,
'KANGXI RADICAL COW': 12124,
'KANGXI RADICAL DEATH': 12109,
'KANGXI RADICAL DEER': 12229,
'KANGXI RADICAL DIPPER': 12099,
'KANGXI RADICAL DISH': 12139,
'KANGXI RADICAL DISTINGUISH': 12196,
'KANGXI RADICAL DIVINATION': 12056,
'KANGXI RADICAL DO NOT': 12111,
'KANGXI RADICAL DOG': 12125,
'KANGXI RADICAL DOOR': 12094,
'KANGXI RADICAL DOT': 12034,
'KANGXI RADICAL DOTTED CLIFF': 12084,
'KANGXI RADICAL DOTTED TENT': 12136,
'KANGXI RADICAL DOUBLE X': 12120,
'KANGXI RADICAL DOWN BOX': 12044,
'KANGXI RADICAL DRAGON': 12243,
'KANGXI RADICAL DRUM': 12238,
'KANGXI RADICAL DRY': 12082,
'KANGXI RADICAL EAR': 12159,
'KANGXI RADICAL EARTH': 12063,
'KANGXI RADICAL EAT': 12215,
'KANGXI RADICAL EIGHT': 12043,
'KANGXI RADICAL EMBROIDERY': 12235,
'KANGXI RADICAL ENCLOSURE': 12062,
'KANGXI RADICAL ENTER': 12042,
'KANGXI RADICAL EVEN': 12241,
'KANGXI RADICAL EVENING': 12067,
'KANGXI RADICAL EYE': 12140,
'KANGXI RADICAL FACE': 12207,
'KANGXI RADICAL FANG': 12123,
'KANGXI RADICAL FATHER': 12119,
'KANGXI RADICAL FEATHER': 12155,
'KANGXI RADICAL FIELD': 12133,
'KANGXI RADICAL FIGHT': 12222,
'KANGXI RADICAL FIRE': 12117,
'KANGXI RADICAL FISH': 12226,
'KANGXI RADICAL FLUTE': 12245,
'KANGXI RADICAL FLY': 12214,
'KANGXI RADICAL FOOT': 12188,
'KANGXI RADICAL FRAGRANT': 12217,
'KANGXI RADICAL FROG': 12236,
'KANGXI RADICAL FUR': 12113,
'KANGXI RADICAL GATE': 12200,
'KANGXI RADICAL GHOST': 12225,
'KANGXI RADICAL GO': 12065,
'KANGXI RADICAL GO SLOWLY': 12066,
'KANGXI RADICAL GOLD': 12198,
'KANGXI RADICAL GRAIN': 12146,
'KANGXI RADICAL GRASS': 12171,
'KANGXI RADICAL HAIR': 12221,
'KANGXI RADICAL HALBERD': 12093,
'KANGXI RADICAL HALF TREE TRUNK': 12121,
'KANGXI RADICAL HAND': 12095,
'KANGXI RADICAL HEAD': 12216,
'KANGXI RADICAL HEART': 12092,
'KANGXI RADICAL HEMP': 12231,
'KANGXI RADICAL HIDING ENCLOSURE': 12054,
'KANGXI RADICAL HOOK': 12037,
'KANGXI RADICAL HORN': 12179,
'KANGXI RADICAL HORSE': 12218,
'KANGXI RADICAL ICE': 12046,
'KANGXI RADICAL INCH': 12072,
'KANGXI RADICAL INSECT': 12173,
'KANGXI RADICAL JADE': 12127,
'KANGXI RADICAL JAR': 12152,
'KANGXI RADICAL KNIFE': 12049,
'KANGXI RADICAL LACK': 12107,
'KANGXI RADICAL LAME': 12074,
'KANGXI RADICAL LEAF': 12212,
'KANGXI RADICAL LEATHER': 12208,
'KANGXI RADICAL LEEK': 12210,
'KANGXI RADICAL LEGS': 12041,
'KANGXI RADICAL LID': 12039,
'KANGXI RADICAL LIFE': 12131,
'KANGXI RADICAL LINE': 12033,
'KANGXI RADICAL LONG': 12199,
'KANGXI RADICAL LONG STRIDE': 12085,
'KANGXI RADICAL MAN': 12040,
'KANGXI RADICAL MEAT': 12161,
'KANGXI RADICAL MELON': 12128,
'KANGXI RADICAL MILLET': 12233,
'KANGXI RADICAL MINISTER': 12162,
'KANGXI RADICAL MOON': 12105,
'KANGXI RADICAL MORNING': 12192,
'KANGXI RADICAL MORTAR': 12165,
'KANGXI RADICAL MOUND': 12201,
'KANGXI RADICAL MOUNTAIN': 12077,
'KANGXI RADICAL MOUTH': 12061,
'KANGXI RADICAL NET': 12153,
'KANGXI RADICAL NOSE': 12240,
'KANGXI RADICAL NOT': 12102,
'KANGXI RADICAL OLD': 12156,
'KANGXI RADICAL ONE': 12032,
'KANGXI RADICAL ONESELF': 12080,
'KANGXI RADICAL OPEN BOX': 12048,
'KANGXI RADICAL OPPOSE': 12167,
'KANGXI RADICAL PIG': 12183,
'KANGXI RADICAL PLOW': 12158,
'KANGXI RADICAL POWER': 12050,
'KANGXI RADICAL PRIVATE': 12059,
'KANGXI RADICAL PROFOUND': 12126,
'KANGXI RADICAL RAIN': 12204,
'KANGXI RADICAL RAP': 12097,
'KANGXI RADICAL RAT': 12239,
'KANGXI RADICAL RED': 12186,
'KANGXI RADICAL RICE': 12150,
'KANGXI RADICAL RIGHT OPEN BOX': 12053,
'KANGXI RADICAL RIVER': 12078,
'KANGXI RADICAL ROOF': 12071,
'KANGXI RADICAL RUN': 12187,
'KANGXI RADICAL SACRIFICIAL WINE': 12223,
'KANGXI RADICAL SALT': 12228,
'KANGXI RADICAL SAY': 12104,
'KANGXI RADICAL SCHOLAR': 12064,
'KANGXI RADICAL SCRIPT': 12098,
'KANGXI RADICAL SEAL': 12057,
'KANGXI RADICAL SECOND': 12036,
'KANGXI RADICAL SEE': 12178,
'KANGXI RADICAL SELF': 12163,
'KANGXI RADICAL SHEEP': 12154,
'KANGXI RADICAL SHELL': 12185,
'KANGXI RADICAL SHOOT': 12087,
'KANGXI RADICAL SHORT TAILED BIRD': 12203,
'KANGXI RADICAL SHORT THREAD': 12083,
'KANGXI RADICAL SICKNESS': 12135,
'KANGXI RADICAL SILK': 12151,
'KANGXI RADICAL SKIN': 12138,
'KANGXI RADICAL SLASH': 12035,
'KANGXI RADICAL SLAVE': 12202,
'KANGXI RADICAL SLICE': 12122,
'KANGXI RADICAL SMALL': 12073,
'KANGXI RADICAL SNOUT': 12089,
'KANGXI RADICAL SOUND': 12211,
'KANGXI RADICAL SPEAR': 12141,
'KANGXI RADICAL SPEECH': 12180,
'KANGXI RADICAL SPIRIT': 12144,
'KANGXI RADICAL SPOON': 12052,
'KANGXI RADICAL SPROUT': 12076,
'KANGXI RADICAL SQUARE': 12101,
'KANGXI RADICAL STAND': 12148,
'KANGXI RADICAL STEAM': 12115,
'KANGXI RADICAL STEP': 12091,
'KANGXI RADICAL STONE': 12143,
'KANGXI RADICAL STOP': 12108,
'KANGXI RADICAL STOPPING': 12169,
'KANGXI RADICAL SUN': 12103,
'KANGXI RADICAL SWEET': 12130,
'KANGXI RADICAL TABLE': 12047,
'KANGXI RADICAL TALL': 12220,
'KANGXI RADICAL TANNED LEATHER': 12209,
'KANGXI RADICAL TEN': 12055,
'KANGXI RADICAL TIGER': 12172,
'KANGXI RADICAL TILE': 12129,
'KANGXI RADICAL TONGUE': 12166,
'KANGXI RADICAL TOOTH': 12242,
'KANGXI RADICAL TRACK': 12145,
'KANGXI RADICAL TREE': 12106,
'KANGXI RADICAL TRIPOD': 12237,
'KANGXI RADICAL TURBAN': 12081,
'KANGXI RADICAL TURTLE': 12244,
'KANGXI RADICAL TWO': 12038,
'KANGXI RADICAL TWO HANDS': 12086,
'KANGXI RADICAL USE': 12132,
'KANGXI RADICAL VALLEY': 12181,
'KANGXI RADICAL VILLAGE': 12197,
'KANGXI RADICAL WALK': 12193,
'KANGXI RADICAL WALK ENCLOSURE': 12175,
'KANGXI RADICAL WATER': 12116,
'KANGXI RADICAL WEAPON': 12110,
'KANGXI RADICAL WEST': 12177,
'KANGXI RADICAL WHEAT': 12230,
'KANGXI RADICAL WHITE': 12137,
'KANGXI RADICAL WIND': 12213,
'KANGXI RADICAL WINE': 12195,
'KANGXI RADICAL WOMAN': 12069,
'KANGXI RADICAL WORK': 12079,
'KANGXI RADICAL WRAP': 12051,
'KANGXI RADICAL WRONG': 12206,
'KANGXI RADICAL YELLOW': 12232,
'KANNADA AI LENGTH MARK': 3286,
'KANNADA DIGIT EIGHT': 3310,
'KANNADA DIGIT FIVE': 3307,
'KANNADA DIGIT FOUR': 3306,
'KANNADA DIGIT NINE': 3311,
'KANNADA DIGIT ONE': 3303,
'KANNADA DIGIT SEVEN': 3309,
'KANNADA DIGIT SIX': 3308,
'KANNADA DIGIT THREE': 3305,
'KANNADA DIGIT TWO': 3304,
'KANNADA DIGIT ZERO': 3302,
'KANNADA LENGTH MARK': 3285,
'KANNADA LETTER A': 3205,
'KANNADA LETTER AA': 3206,
'KANNADA LETTER AI': 3216,
'KANNADA LETTER AU': 3220,
'KANNADA LETTER BA': 3244,
'KANNADA LETTER BHA': 3245,
'KANNADA LETTER CA': 3226,
'KANNADA LETTER CHA': 3227,
'KANNADA LETTER DA': 3238,
'KANNADA LETTER DDA': 3233,
'KANNADA LETTER DDHA': 3234,
'KANNADA LETTER DHA': 3239,
'KANNADA LETTER E': 3214,
'KANNADA LETTER EE': 3215,
'KANNADA LETTER FA': 3294,
'KANNADA LETTER GA': 3223,
'KANNADA LETTER GHA': 3224,
'KANNADA LETTER HA': 3257,
'KANNADA LETTER I': 3207,
'KANNADA LETTER II': 3208,
'KANNADA LETTER JA': 3228,
'KANNADA LETTER JHA': 3229,
'KANNADA LETTER KA': 3221,
'KANNADA LETTER KHA': 3222,
'KANNADA LETTER LA': 3250,
'KANNADA LETTER LLA': 3251,
'KANNADA LETTER MA': 3246,
'KANNADA LETTER NA': 3240,
'KANNADA LETTER NGA': 3225,
'KANNADA LETTER NNA': 3235,
'KANNADA LETTER NYA': 3230,
'KANNADA LETTER O': 3218,
'KANNADA LETTER OO': 3219,
'KANNADA LETTER PA': 3242,
'KANNADA LETTER PHA': 3243,
'KANNADA LETTER RA': 3248,
'KANNADA LETTER RRA': 3249,
'KANNADA LETTER SA': 3256,
'KANNADA LETTER SHA': 3254,
'KANNADA LETTER SSA': 3255,
'KANNADA LETTER TA': 3236,
'KANNADA LETTER THA': 3237,
'KANNADA LETTER TTA': 3231,
'KANNADA LETTER TTHA': 3232,
'KANNADA LETTER U': 3209,
'KANNADA LETTER UU': 3210,
'KANNADA LETTER VA': 3253,
'KANNADA LETTER VOCALIC L': 3212,
'KANNADA LETTER VOCALIC LL': 3297,
'KANNADA LETTER VOCALIC R': 3211,
'KANNADA LETTER VOCALIC RR': 3296,
'KANNADA LETTER YA': 3247,
'KANNADA SIGN ANUSVARA': 3202,
'KANNADA SIGN VIRAMA': 3277,
'KANNADA SIGN VISARGA': 3203,
'KANNADA VOWEL SIGN AA': 3262,
'KANNADA VOWEL SIGN AI': 3272,
'KANNADA VOWEL SIGN AU': 3276,
'KANNADA VOWEL SIGN E': 3270,
'KANNADA VOWEL SIGN EE': 3271,
'KANNADA VOWEL SIGN I': 3263,
'KANNADA VOWEL SIGN II': 3264,
'KANNADA VOWEL SIGN O': 3274,
'KANNADA VOWEL SIGN OO': 3275,
'KANNADA VOWEL SIGN U': 3265,
'KANNADA VOWEL SIGN UU': 3266,
'KANNADA VOWEL SIGN VOCALIC R': 3267,
'KANNADA VOWEL SIGN VOCALIC RR': 3268,
'KATAKANA DIGRAPH KOTO': 12543,
'KATAKANA ITERATION MARK': 12541,
'KATAKANA LETTER A': 12450,
'KATAKANA LETTER BA': 12496,
'KATAKANA LETTER BE': 12505,
'KATAKANA LETTER BI': 12499,
'KATAKANA LETTER BO': 12508,
'KATAKANA LETTER BU': 12502,
'KATAKANA LETTER DA': 12480,
'KATAKANA LETTER DE': 12487,
'KATAKANA LETTER DI': 12482,
'KATAKANA LETTER DO': 12489,
'KATAKANA LETTER DU': 12485,
'KATAKANA LETTER E': 12456,
'KATAKANA LETTER GA': 12460,
'KATAKANA LETTER GE': 12466,
'KATAKANA LETTER GI': 12462,
'KATAKANA LETTER GO': 12468,
'KATAKANA LETTER GU': 12464,
'KATAKANA LETTER HA': 12495,
'KATAKANA LETTER HE': 12504,
'KATAKANA LETTER HI': 12498,
'KATAKANA LETTER HO': 12507,
'KATAKANA LETTER HU': 12501,
'KATAKANA LETTER I': 12452,
'KATAKANA LETTER KA': 12459,
'KATAKANA LETTER KE': 12465,
'KATAKANA LETTER KI': 12461,
'KATAKANA LETTER KO': 12467,
'KATAKANA LETTER KU': 12463,
'KATAKANA LETTER MA': 12510,
'KATAKANA LETTER ME': 12513,
'KATAKANA LETTER MI': 12511,
'KATAKANA LETTER MO': 12514,
'KATAKANA LETTER MU': 12512,
'KATAKANA LETTER N': 12531,
'KATAKANA LETTER NA': 12490,
'KATAKANA LETTER NE': 12493,
'KATAKANA LETTER NI': 12491,
'KATAKANA LETTER NO': 12494,
'KATAKANA LETTER NU': 12492,
'KATAKANA LETTER O': 12458,
'KATAKANA LETTER PA': 12497,
'KATAKANA LETTER PE': 12506,
'KATAKANA LETTER PI': 12500,
'KATAKANA LETTER PO': 12509,
'KATAKANA LETTER PU': 12503,
'KATAKANA LETTER RA': 12521,
'KATAKANA LETTER RE': 12524,
'KATAKANA LETTER RI': 12522,
'KATAKANA LETTER RO': 12525,
'KATAKANA LETTER RU': 12523,
'KATAKANA LETTER SA': 12469,
'KATAKANA LETTER SE': 12475,
'KATAKANA LETTER SI': 12471,
'KATAKANA LETTER SMALL A': 12449,
'KATAKANA LETTER SMALL E': 12455,
'KATAKANA LETTER SMALL HA': 12789,
'KATAKANA LETTER SMALL HE': 12792,
'KATAKANA LETTER SMALL HI': 12790,
'KATAKANA LETTER SMALL HO': 12793,
'KATAKANA LETTER SMALL HU': 12791,
'KATAKANA LETTER SMALL I': 12451,
'KATAKANA LETTER SMALL KA': 12533,
'KATAKANA LETTER SMALL KE': 12534,
'KATAKANA LETTER SMALL KU': 12784,
'KATAKANA LETTER SMALL MU': 12794,
'KATAKANA LETTER SMALL NU': 12788,
'KATAKANA LETTER SMALL O': 12457,
'KATAKANA LETTER SMALL RA': 12795,
'KATAKANA LETTER SMALL RE': 12798,
'KATAKANA LETTER SMALL RI': 12796,
'KATAKANA LETTER SMALL RO': 12799,
'KATAKANA LETTER SMALL RU': 12797,
'KATAKANA LETTER SMALL SI': 12785,
'KATAKANA LETTER SMALL SU': 12786,
'KATAKANA LETTER SMALL TO': 12787,
'KATAKANA LETTER SMALL TU': 12483,
'KATAKANA LETTER SMALL U': 12453,
'KATAKANA LETTER SMALL WA': 12526,
'KATAKANA LETTER SMALL YA': 12515,
'KATAKANA LETTER SMALL YO': 12519,
'KATAKANA LETTER SMALL YU': 12517,
'KATAKANA LETTER SO': 12477,
'KATAKANA LETTER SU': 12473,
'KATAKANA LETTER TA': 12479,
'KATAKANA LETTER TE': 12486,
'KATAKANA LETTER TI': 12481,
'KATAKANA LETTER TO': 12488,
'KATAKANA LETTER TU': 12484,
'KATAKANA LETTER U': 12454,
'KATAKANA LETTER VA': 12535,
'KATAKANA LETTER VE': 12537,
'KATAKANA LETTER VI': 12536,
'KATAKANA LETTER VO': 12538,
'KATAKANA LETTER VU': 12532,
'KATAKANA LETTER WA': 12527,
'KATAKANA LETTER WE': 12529,
'KATAKANA LETTER WI': 12528,
'KATAKANA LETTER WO': 12530,
'KATAKANA LETTER YA': 12516,
'KATAKANA LETTER YO': 12520,
'KATAKANA LETTER YU': 12518,
'KATAKANA LETTER ZA': 12470,
'KATAKANA LETTER ZE': 12476,
'KATAKANA LETTER ZI': 12472,
'KATAKANA LETTER ZO': 12478,
'KATAKANA LETTER ZU': 12474,
'KATAKANA MIDDLE DOT': 12539,
'KATAKANA VOICED ITERATION MARK': 12542,
'KATAKANA-HIRAGANA DOUBLE HYPHEN': 12448,
'KATAKANA-HIRAGANA PROLONGED SOUND MARK': 12540,
'KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK': 12444,
'KATAKANA-HIRAGANA VOICED SOUND MARK': 12443,
'KELVIN SIGN': 8490,
'KEYBOARD': 9000,
'KHMER CURRENCY SYMBOL RIEL': 6107,
'KHMER DIGIT EIGHT': 6120,
'KHMER DIGIT FIVE': 6117,
'KHMER DIGIT FOUR': 6116,
'KHMER DIGIT NINE': 6121,
'KHMER DIGIT ONE': 6113,
'KHMER DIGIT SEVEN': 6119,
'KHMER DIGIT SIX': 6118,
'KHMER DIGIT THREE': 6115,
'KHMER DIGIT TWO': 6114,
'KHMER DIGIT ZERO': 6112,
'KHMER INDEPENDENT VOWEL LY': 6061,
'KHMER INDEPENDENT VOWEL LYY': 6062,
'KHMER INDEPENDENT VOWEL QAA': 6052,
'KHMER INDEPENDENT VOWEL QAI': 6064,
'KHMER INDEPENDENT VOWEL QAQ': 6051,
'KHMER INDEPENDENT VOWEL QAU': 6067,
'KHMER INDEPENDENT VOWEL QE': 6063,
'KHMER INDEPENDENT VOWEL QI': 6053,
'KHMER INDEPENDENT VOWEL QII': 6054,
'KHMER INDEPENDENT VOWEL QOO TYPE ONE': 6065,
'KHMER INDEPENDENT VOWEL QOO TYPE TWO': 6066,
'KHMER INDEPENDENT VOWEL QU': 6055,
'KHMER INDEPENDENT VOWEL QUK': 6056,
'KHMER INDEPENDENT VOWEL QUU': 6057,
'KHMER INDEPENDENT VOWEL QUUV': 6058,
'KHMER INDEPENDENT VOWEL RY': 6059,
'KHMER INDEPENDENT VOWEL RYY': 6060,
'KHMER LETTER BA': 6036,
'KHMER LETTER CA': 6021,
'KHMER LETTER CHA': 6022,
'KHMER LETTER CHO': 6024,
'KHMER LETTER CO': 6023,
'KHMER LETTER DA': 6026,
'KHMER LETTER DO': 6028,
'KHMER LETTER HA': 6048,
'KHMER LETTER KA': 6016,
'KHMER LETTER KHA': 6017,
'KHMER LETTER KHO': 6019,
'KHMER LETTER KO': 6018,
'KHMER LETTER LA': 6049,
'KHMER LETTER LO': 6043,
'KHMER LETTER MO': 6040,
'KHMER LETTER NGO': 6020,
'KHMER LETTER NNO': 6030,
'KHMER LETTER NO': 6035,
'KHMER LETTER NYO': 6025,
'KHMER LETTER PHA': 6037,
'KHMER LETTER PHO': 6039,
'KHMER LETTER PO': 6038,
'KHMER LETTER QA': 6050,
'KHMER LETTER RO': 6042,
'KHMER LETTER SA': 6047,
'KHMER LETTER SHA': 6045,
'KHMER LETTER SSO': 6046,
'KHMER LETTER TA': 6031,
'KHMER LETTER THA': 6032,
'KHMER LETTER THO': 6034,
'KHMER LETTER TO': 6033,
'KHMER LETTER TTHA': 6027,
'KHMER LETTER TTHO': 6029,
'KHMER LETTER VO': 6044,
'KHMER LETTER YO': 6041,
'KHMER SIGN AHSDA': 6095,
'KHMER SIGN AVAKRAHASANYA': 6108,
'KHMER SIGN BANTOC': 6091,
'KHMER SIGN BARIYOOSAN': 6101,
'KHMER SIGN BATHAMASAT': 6099,
'KHMER SIGN BEYYAL': 6104,
'KHMER SIGN CAMNUC PII KUUH': 6102,
'KHMER SIGN COENG': 6098,
'KHMER SIGN KAKABAT': 6094,
'KHMER SIGN KHAN': 6100,
'KHMER SIGN KOOMUUT': 6106,
'KHMER SIGN LEK TOO': 6103,
'KHMER SIGN MUUSIKATOAN': 6089,
'KHMER SIGN NIKAHIT': 6086,
'KHMER SIGN PHNAEK MUAN': 6105,
'KHMER SIGN REAHMUK': 6087,
'KHMER SIGN ROBAT': 6092,
'KHMER SIGN SAMYOK SANNYA': 6096,
'KHMER SIGN TOANDAKHIAT': 6093,
'KHMER SIGN TRIISAP': 6090,
'KHMER SIGN VIRIAM': 6097,
'KHMER SIGN YUUKALEAPINTU': 6088,
'KHMER VOWEL INHERENT AA': 6069,
'KHMER VOWEL INHERENT AQ': 6068,
'KHMER VOWEL SIGN AA': 6070,
'KHMER VOWEL SIGN AE': 6082,
'KHMER VOWEL SIGN AI': 6083,
'KHMER VOWEL SIGN AU': 6085,
'KHMER VOWEL SIGN E': 6081,
'KHMER VOWEL SIGN I': 6071,
'KHMER VOWEL SIGN IE': 6080,
'KHMER VOWEL SIGN II': 6072,
'KHMER VOWEL SIGN OE': 6078,
'KHMER VOWEL SIGN OO': 6084,
'KHMER VOWEL SIGN U': 6075,
'KHMER VOWEL SIGN UA': 6077,
'KHMER VOWEL SIGN UU': 6076,
'KHMER VOWEL SIGN Y': 6073,
'KHMER VOWEL SIGN YA': 6079,
'KHMER VOWEL SIGN YY': 6074,
'KIP SIGN': 8365,
'KOREAN STANDARD SYMBOL': 12927,
'L B BAR SYMBOL': 8468,
'LANGUAGE TAG': 917505,
'LAO CANCELLATION MARK': 3788,
'LAO DIGIT EIGHT': 3800,
'LAO DIGIT FIVE': 3797,
'LAO DIGIT FOUR': 3796,
'LAO DIGIT NINE': 3801,
'LAO DIGIT ONE': 3793,
'LAO DIGIT SEVEN': 3799,
'LAO DIGIT SIX': 3798,
'LAO DIGIT THREE': 3795,
'LAO DIGIT TWO': 3794,
'LAO DIGIT ZERO': 3792,
'LAO ELLIPSIS': 3759,
'LAO HO MO': 3805,
'LAO HO NO': 3804,
'LAO KO LA': 3782,
'LAO LETTER BO': 3738,
'LAO LETTER CO': 3720,
'LAO LETTER DO': 3732,
'LAO LETTER FO SUNG': 3743,
'LAO LETTER FO TAM': 3741,
'LAO LETTER HO SUNG': 3755,
'LAO LETTER HO TAM': 3758,
'LAO LETTER KHO SUNG': 3714,
'LAO LETTER KHO TAM': 3716,
'LAO LETTER KO': 3713,
'LAO LETTER LO LING': 3747,
'LAO LETTER LO LOOT': 3749,
'LAO LETTER MO': 3745,
'LAO LETTER NGO': 3719,
'LAO LETTER NO': 3737,
'LAO LETTER NYO': 3725,
'LAO LETTER O': 3757,
'LAO LETTER PHO SUNG': 3740,
'LAO LETTER PHO TAM': 3742,
'LAO LETTER PO': 3739,
'LAO LETTER SO SUNG': 3754,
'LAO LETTER SO TAM': 3722,
'LAO LETTER THO SUNG': 3734,
'LAO LETTER THO TAM': 3735,
'LAO LETTER TO': 3733,
'LAO LETTER WO': 3751,
'LAO LETTER YO': 3746,
'LAO NIGGAHITA': 3789,
'LAO SEMIVOWEL SIGN LO': 3772,
'LAO SEMIVOWEL SIGN NYO': 3773,
'LAO TONE MAI CATAWA': 3787,
'LAO TONE MAI EK': 3784,
'LAO TONE MAI THO': 3785,
'LAO TONE MAI TI': 3786,
'LAO VOWEL SIGN A': 3760,
'LAO VOWEL SIGN AA': 3762,
'LAO VOWEL SIGN AI': 3780,
'LAO VOWEL SIGN AM': 3763,
'LAO VOWEL SIGN AY': 3779,
'LAO VOWEL SIGN E': 3776,
'LAO VOWEL SIGN EI': 3777,
'LAO VOWEL SIGN I': 3764,
'LAO VOWEL SIGN II': 3765,
'LAO VOWEL SIGN MAI KAN': 3761,
'LAO VOWEL SIGN MAI KON': 3771,
'LAO VOWEL SIGN O': 3778,
'LAO VOWEL SIGN U': 3768,
'LAO VOWEL SIGN UU': 3769,
'LAO VOWEL SIGN Y': 3766,
'LAO VOWEL SIGN YY': 3767,
'LARGE CIRCLE': 9711,
'LARGE DOWN TACK': 10201,
'LARGE LEFT TRIANGLE OPERATOR': 10782,
'LARGE TRIPLE VERTICAL BAR OPERATOR': 11004,
'LARGE UP TACK': 10200,
'LARGER THAN': 10923,
'LARGER THAN OR EQUAL TO': 10925,
'LAST QUARTER MOON': 9790,
'LATIN CAPITAL LETTER A': 65,
'LATIN CAPITAL LETTER A WITH ACUTE': 193,
'LATIN CAPITAL LETTER A WITH BREVE': 258,
'LATIN CAPITAL LETTER A WITH BREVE AND ACUTE': 7854,
'LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW': 7862,
'LATIN CAPITAL LETTER A WITH BREVE AND GRAVE': 7856,
'LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE': 7858,
'LATIN CAPITAL LETTER A WITH BREVE AND TILDE': 7860,
'LATIN CAPITAL LETTER A WITH CARON': 461,
'LATIN CAPITAL LETTER A WITH CIRCUMFLEX': 194,
'LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE': 7844,
'LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW': 7852,
'LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE': 7846,
'LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE': 7848,
'LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE': 7850,
'LATIN CAPITAL LETTER A WITH DIAERESIS': 196,
'LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON': 478,
'LATIN CAPITAL LETTER A WITH DOT ABOVE': 550,
'LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON': 480,
'LATIN CAPITAL LETTER A WITH DOT BELOW': 7840,
'LATIN CAPITAL LETTER A WITH DOUBLE GRAVE': 512,
'LATIN CAPITAL LETTER A WITH GRAVE': 192,
'LATIN CAPITAL LETTER A WITH HOOK ABOVE': 7842,
'LATIN CAPITAL LETTER A WITH INVERTED BREVE': 514,
'LATIN CAPITAL LETTER A WITH MACRON': 256,
'LATIN CAPITAL LETTER A WITH OGONEK': 260,
'LATIN CAPITAL LETTER A WITH RING ABOVE': 197,
'LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE': 506,
'LATIN CAPITAL LETTER A WITH RING BELOW': 7680,
'LATIN CAPITAL LETTER A WITH TILDE': 195,
'LATIN CAPITAL LETTER AE': 198,
'LATIN CAPITAL LETTER AE WITH ACUTE': 508,
'LATIN CAPITAL LETTER AE WITH MACRON': 482,
'LATIN CAPITAL LETTER AFRICAN D': 393,
'LATIN CAPITAL LETTER B': 66,
'LATIN CAPITAL LETTER B WITH DOT ABOVE': 7682,
'LATIN CAPITAL LETTER B WITH DOT BELOW': 7684,
'LATIN CAPITAL LETTER B WITH HOOK': 385,
'LATIN CAPITAL LETTER B WITH LINE BELOW': 7686,
'LATIN CAPITAL LETTER B WITH TOPBAR': 386,
'LATIN CAPITAL LETTER C': 67,
'LATIN CAPITAL LETTER C WITH ACUTE': 262,
'LATIN CAPITAL LETTER C WITH CARON': 268,
'LATIN CAPITAL LETTER C WITH CEDILLA': 199,
'LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE': 7688,
'LATIN CAPITAL LETTER C WITH CIRCUMFLEX': 264,
'LATIN CAPITAL LETTER C WITH DOT ABOVE': 266,
'LATIN CAPITAL LETTER C WITH HOOK': 391,
'LATIN CAPITAL LETTER D': 68,
'LATIN CAPITAL LETTER D WITH CARON': 270,
'LATIN CAPITAL LETTER D WITH CEDILLA': 7696,
'LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW': 7698,
'LATIN CAPITAL LETTER D WITH DOT ABOVE': 7690,
'LATIN CAPITAL LETTER D WITH DOT BELOW': 7692,
'LATIN CAPITAL LETTER D WITH HOOK': 394,
'LATIN CAPITAL LETTER D WITH LINE BELOW': 7694,
'LATIN CAPITAL LETTER D WITH SMALL LETTER Z': 498,
'LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON': 453,
'LATIN CAPITAL LETTER D WITH STROKE': 272,
'LATIN CAPITAL LETTER D WITH TOPBAR': 395,
'LATIN CAPITAL LETTER DZ': 497,
'LATIN CAPITAL LETTER DZ WITH CARON': 452,
'LATIN CAPITAL LETTER E': 69,
'LATIN CAPITAL LETTER E WITH ACUTE': 201,
'LATIN CAPITAL LETTER E WITH BREVE': 276,
'LATIN CAPITAL LETTER E WITH CARON': 282,
'LATIN CAPITAL LETTER E WITH CEDILLA': 552,
'LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE': 7708,
'LATIN CAPITAL LETTER E WITH CIRCUMFLEX': 202,
'LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE': 7870,
'LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW': 7878,
'LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE': 7872,
'LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE': 7874,
'LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE': 7876,
'LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW': 7704,
'LATIN CAPITAL LETTER E WITH DIAERESIS': 203,
'LATIN CAPITAL LETTER E WITH DOT ABOVE': 278,
'LATIN CAPITAL LETTER E WITH DOT BELOW': 7864,
'LATIN CAPITAL LETTER E WITH DOUBLE GRAVE': 516,
'LATIN CAPITAL LETTER E WITH GRAVE': 200,
'LATIN CAPITAL LETTER E WITH HOOK ABOVE': 7866,
'LATIN CAPITAL LETTER E WITH INVERTED BREVE': 518,
'LATIN CAPITAL LETTER E WITH MACRON': 274,
'LATIN CAPITAL LETTER E WITH MACRON AND ACUTE': 7702,
'LATIN CAPITAL LETTER E WITH MACRON AND GRAVE': 7700,
'LATIN CAPITAL LETTER E WITH OGONEK': 280,
'LATIN CAPITAL LETTER E WITH TILDE': 7868,
'LATIN CAPITAL LETTER E WITH TILDE BELOW': 7706,
'LATIN CAPITAL LETTER ENG': 330,
'LATIN CAPITAL LETTER ESH': 425,
'LATIN CAPITAL LETTER ETH': 208,
'LATIN CAPITAL LETTER EZH': 439,
'LATIN CAPITAL LETTER EZH REVERSED': 440,
'LATIN CAPITAL LETTER EZH WITH CARON': 494,
'LATIN CAPITAL LETTER F': 70,
'LATIN CAPITAL LETTER F WITH DOT ABOVE': 7710,
'LATIN CAPITAL LETTER F WITH HOOK': 401,
'LATIN CAPITAL LETTER G': 71,
'LATIN CAPITAL LETTER G WITH ACUTE': 500,
'LATIN CAPITAL LETTER G WITH BREVE': 286,
'LATIN CAPITAL LETTER G WITH CARON': 486,
'LATIN CAPITAL LETTER G WITH CEDILLA': 290,
'LATIN CAPITAL LETTER G WITH CIRCUMFLEX': 284,
'LATIN CAPITAL LETTER G WITH DOT ABOVE': 288,
'LATIN CAPITAL LETTER G WITH HOOK': 403,
'LATIN CAPITAL LETTER G WITH MACRON': 7712,
'LATIN CAPITAL LETTER G WITH STROKE': 484,
'LATIN CAPITAL LETTER GAMMA': 404,
'LATIN CAPITAL LETTER H': 72,
'LATIN CAPITAL LETTER H WITH BREVE BELOW': 7722,
'LATIN CAPITAL LETTER H WITH CARON': 542,
'LATIN CAPITAL LETTER H WITH CEDILLA': 7720,
'LATIN CAPITAL LETTER H WITH CIRCUMFLEX': 292,
'LATIN CAPITAL LETTER H WITH DIAERESIS': 7718,
'LATIN CAPITAL LETTER H WITH DOT ABOVE': 7714,
'LATIN CAPITAL LETTER H WITH DOT BELOW': 7716,
'LATIN CAPITAL LETTER H WITH STROKE': 294,
'LATIN CAPITAL LETTER HWAIR': 502,
'LATIN CAPITAL LETTER I': 73,
'LATIN CAPITAL LETTER I WITH ACUTE': 205,
'LATIN CAPITAL LETTER I WITH BREVE': 300,
'LATIN CAPITAL LETTER I WITH CARON': 463,
'LATIN CAPITAL LETTER I WITH CIRCUMFLEX': 206,
'LATIN CAPITAL LETTER I WITH DIAERESIS': 207,
'LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE': 7726,
'LATIN CAPITAL LETTER I WITH DOT ABOVE': 304,
'LATIN CAPITAL LETTER I WITH DOT BELOW': 7882,
'LATIN CAPITAL LETTER I WITH DOUBLE GRAVE': 520,
'LATIN CAPITAL LETTER I WITH GRAVE': 204,
'LATIN CAPITAL LETTER I WITH HOOK ABOVE': 7880,
'LATIN CAPITAL LETTER I WITH INVERTED BREVE': 522,
'LATIN CAPITAL LETTER I WITH MACRON': 298,
'LATIN CAPITAL LETTER I WITH OGONEK': 302,
'LATIN CAPITAL LETTER I WITH STROKE': 407,
'LATIN CAPITAL LETTER I WITH TILDE': 296,
'LATIN CAPITAL LETTER I WITH TILDE BELOW': 7724,
'LATIN CAPITAL LETTER IOTA': 406,
'LATIN CAPITAL LETTER J': 74,
'LATIN CAPITAL LETTER J WITH CIRCUMFLEX': 308,
'LATIN CAPITAL LETTER K': 75,
'LATIN CAPITAL LETTER K WITH ACUTE': 7728,
'LATIN CAPITAL LETTER K WITH CARON': 488,
'LATIN CAPITAL LETTER K WITH CEDILLA': 310,
'LATIN CAPITAL LETTER K WITH DOT BELOW': 7730,
'LATIN CAPITAL LETTER K WITH HOOK': 408,
'LATIN CAPITAL LETTER K WITH LINE BELOW': 7732,
'LATIN CAPITAL LETTER L': 76,
'LATIN CAPITAL LETTER L WITH ACUTE': 313,
'LATIN CAPITAL LETTER L WITH CARON': 317,
'LATIN CAPITAL LETTER L WITH CEDILLA': 315,
'LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW': 7740,
'LATIN CAPITAL LETTER L WITH DOT BELOW': 7734,
'LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON': 7736,
'LATIN CAPITAL LETTER L WITH LINE BELOW': 7738,
'LATIN CAPITAL LETTER L WITH MIDDLE DOT': 319,
'LATIN CAPITAL LETTER L WITH SMALL LETTER J': 456,
'LATIN CAPITAL LETTER L WITH STROKE': 321,
'LATIN CAPITAL LETTER LJ': 455,
'LATIN CAPITAL LETTER M': 77,
'LATIN CAPITAL LETTER M WITH ACUTE': 7742,
'LATIN CAPITAL LETTER M WITH DOT ABOVE': 7744,
'LATIN CAPITAL LETTER M WITH DOT BELOW': 7746,
'LATIN CAPITAL LETTER N': 78,
'LATIN CAPITAL LETTER N WITH ACUTE': 323,
'LATIN CAPITAL LETTER N WITH CARON': 327,
'LATIN CAPITAL LETTER N WITH CEDILLA': 325,
'LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW': 7754,
'LATIN CAPITAL LETTER N WITH DOT ABOVE': 7748,
'LATIN CAPITAL LETTER N WITH DOT BELOW': 7750,
'LATIN CAPITAL LETTER N WITH GRAVE': 504,
'LATIN CAPITAL LETTER N WITH LEFT HOOK': 413,
'LATIN CAPITAL LETTER N WITH LINE BELOW': 7752,
'LATIN CAPITAL LETTER N WITH LONG RIGHT LEG': 544,
'LATIN CAPITAL LETTER N WITH SMALL LETTER J': 459,
'LATIN CAPITAL LETTER N WITH TILDE': 209,
'LATIN CAPITAL LETTER NJ': 458,
'LATIN CAPITAL LETTER O': 79,
'LATIN CAPITAL LETTER O WITH ACUTE': 211,
'LATIN CAPITAL LETTER O WITH BREVE': 334,
'LATIN CAPITAL LETTER O WITH CARON': 465,
'LATIN CAPITAL LETTER O WITH CIRCUMFLEX': 212,
'LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE': 7888,
'LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW': 7896,
'LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE': 7890,
'LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE': 7892,
'LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE': 7894,
'LATIN CAPITAL LETTER O WITH DIAERESIS': 214,
'LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON': 554,
'LATIN CAPITAL LETTER O WITH DOT ABOVE': 558,
'LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON': 560,
'LATIN CAPITAL LETTER O WITH DOT BELOW': 7884,
'LATIN CAPITAL LETTER O WITH DOUBLE ACUTE': 336,
'LATIN CAPITAL LETTER O WITH DOUBLE GRAVE': 524,
'LATIN CAPITAL LETTER O WITH GRAVE': 210,
'LATIN CAPITAL LETTER O WITH HOOK ABOVE': 7886,
'LATIN CAPITAL LETTER O WITH HORN': 416,
'LATIN CAPITAL LETTER O WITH HORN AND ACUTE': 7898,
'LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW': 7906,
'LATIN CAPITAL LETTER O WITH HORN AND GRAVE': 7900,
'LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE': 7902,
'LATIN CAPITAL LETTER O WITH HORN AND TILDE': 7904,
'LATIN CAPITAL LETTER O WITH INVERTED BREVE': 526,
'LATIN CAPITAL LETTER O WITH MACRON': 332,
'LATIN CAPITAL LETTER O WITH MACRON AND ACUTE': 7762,
'LATIN CAPITAL LETTER O WITH MACRON AND GRAVE': 7760,
'LATIN CAPITAL LETTER O WITH MIDDLE TILDE': 415,
'LATIN CAPITAL LETTER O WITH OGONEK': 490,
'LATIN CAPITAL LETTER O WITH OGONEK AND MACRON': 492,
'LATIN CAPITAL LETTER O WITH STROKE': 216,
'LATIN CAPITAL LETTER O WITH STROKE AND ACUTE': 510,
'LATIN CAPITAL LETTER O WITH TILDE': 213,
'LATIN CAPITAL LETTER O WITH TILDE AND ACUTE': 7756,
'LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS': 7758,
'LATIN CAPITAL LETTER O WITH TILDE AND MACRON': 556,
'LATIN CAPITAL LETTER OI': 418,
'LATIN CAPITAL LETTER OPEN E': 400,
'LATIN CAPITAL LETTER OPEN O': 390,
'LATIN CAPITAL LETTER OU': 546,
'LATIN CAPITAL LETTER P': 80,
'LATIN CAPITAL LETTER P WITH ACUTE': 7764,
'LATIN CAPITAL LETTER P WITH DOT ABOVE': 7766,
'LATIN CAPITAL LETTER P WITH HOOK': 420,
'LATIN CAPITAL LETTER Q': 81,
'LATIN CAPITAL LETTER R': 82,
'LATIN CAPITAL LETTER R WITH ACUTE': 340,
'LATIN CAPITAL LETTER R WITH CARON': 344,
'LATIN CAPITAL LETTER R WITH CEDILLA': 342,
'LATIN CAPITAL LETTER R WITH DOT ABOVE': 7768,
'LATIN CAPITAL LETTER R WITH DOT BELOW': 7770,
'LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON': 7772,
'LATIN CAPITAL LETTER R WITH DOUBLE GRAVE': 528,
'LATIN CAPITAL LETTER R WITH INVERTED BREVE': 530,
'LATIN CAPITAL LETTER R WITH LINE BELOW': 7774,
'LATIN CAPITAL LETTER REVERSED E': 398,
'LATIN CAPITAL LETTER S': 83,
'LATIN CAPITAL LETTER S WITH ACUTE': 346,
'LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE': 7780,
'LATIN CAPITAL LETTER S WITH CARON': 352,
'LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE': 7782,
'LATIN CAPITAL LETTER S WITH CEDILLA': 350,
'LATIN CAPITAL LETTER S WITH CIRCUMFLEX': 348,
'LATIN CAPITAL LETTER S WITH COMMA BELOW': 536,
'LATIN CAPITAL LETTER S WITH DOT ABOVE': 7776,
'LATIN CAPITAL LETTER S WITH DOT BELOW': 7778,
'LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE': 7784,
'LATIN CAPITAL LETTER SCHWA': 399,
'LATIN CAPITAL LETTER T': 84,
'LATIN CAPITAL LETTER T WITH CARON': 356,
'LATIN CAPITAL LETTER T WITH CEDILLA': 354,
'LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW': 7792,
'LATIN CAPITAL LETTER T WITH COMMA BELOW': 538,
'LATIN CAPITAL LETTER T WITH DOT ABOVE': 7786,
'LATIN CAPITAL LETTER T WITH DOT BELOW': 7788,
'LATIN CAPITAL LETTER T WITH HOOK': 428,
'LATIN CAPITAL LETTER T WITH LINE BELOW': 7790,
'LATIN CAPITAL LETTER T WITH RETROFLEX HOOK': 430,
'LATIN CAPITAL LETTER T WITH STROKE': 358,
'LATIN CAPITAL LETTER THORN': 222,
'LATIN CAPITAL LETTER TONE FIVE': 444,
'LATIN CAPITAL LETTER TONE SIX': 388,
'LATIN CAPITAL LETTER TONE TWO': 423,
'LATIN CAPITAL LETTER TURNED M': 412,
'LATIN CAPITAL LETTER U': 85,
'LATIN CAPITAL LETTER U WITH ACUTE': 218,
'LATIN CAPITAL LETTER U WITH BREVE': 364,
'LATIN CAPITAL LETTER U WITH CARON': 467,
'LATIN CAPITAL LETTER U WITH CIRCUMFLEX': 219,
'LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW': 7798,
'LATIN CAPITAL LETTER U WITH DIAERESIS': 220,
'LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE': 471,
'LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON': 473,
'LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE': 475,
'LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON': 469,
'LATIN CAPITAL LETTER U WITH DIAERESIS BELOW': 7794,
'LATIN CAPITAL LETTER U WITH DOT BELOW': 7908,
'LATIN CAPITAL LETTER U WITH DOUBLE ACUTE': 368,
'LATIN CAPITAL LETTER U WITH DOUBLE GRAVE': 532,
'LATIN CAPITAL LETTER U WITH GRAVE': 217,
'LATIN CAPITAL LETTER U WITH HOOK ABOVE': 7910,
'LATIN CAPITAL LETTER U WITH HORN': 431,
'LATIN CAPITAL LETTER U WITH HORN AND ACUTE': 7912,
'LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW': 7920,
'LATIN CAPITAL LETTER U WITH HORN AND GRAVE': 7914,
'LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE': 7916,
'LATIN CAPITAL LETTER U WITH HORN AND TILDE': 7918,
'LATIN CAPITAL LETTER U WITH INVERTED BREVE': 534,
'LATIN CAPITAL LETTER U WITH MACRON': 362,
'LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS': 7802,
'LATIN CAPITAL LETTER U WITH OGONEK': 370,
'LATIN CAPITAL LETTER U WITH RING ABOVE': 366,
'LATIN CAPITAL LETTER U WITH TILDE': 360,
'LATIN CAPITAL LETTER U WITH TILDE AND ACUTE': 7800,
'LATIN CAPITAL LETTER U WITH TILDE BELOW': 7796,
'LATIN CAPITAL LETTER UPSILON': 433,
'LATIN CAPITAL LETTER V': 86,
'LATIN CAPITAL LETTER V WITH DOT BELOW': 7806,
'LATIN CAPITAL LETTER V WITH HOOK': 434,
'LATIN CAPITAL LETTER V WITH TILDE': 7804,
'LATIN CAPITAL LETTER W': 87,
'LATIN CAPITAL LETTER W WITH ACUTE': 7810,
'LATIN CAPITAL LETTER W WITH CIRCUMFLEX': 372,
'LATIN CAPITAL LETTER W WITH DIAERESIS': 7812,
'LATIN CAPITAL LETTER W WITH DOT ABOVE': 7814,
'LATIN CAPITAL LETTER W WITH DOT BELOW': 7816,
'LATIN CAPITAL LETTER W WITH GRAVE': 7808,
'LATIN CAPITAL LETTER WYNN': 503,
'LATIN CAPITAL LETTER X': 88,
'LATIN CAPITAL LETTER X WITH DIAERESIS': 7820,
'LATIN CAPITAL LETTER X WITH DOT ABOVE': 7818,
'LATIN CAPITAL LETTER Y': 89,
'LATIN CAPITAL LETTER Y WITH ACUTE': 221,
'LATIN CAPITAL LETTER Y WITH CIRCUMFLEX': 374,
'LATIN CAPITAL LETTER Y WITH DIAERESIS': 376,
'LATIN CAPITAL LETTER Y WITH DOT ABOVE': 7822,
'LATIN CAPITAL LETTER Y WITH DOT BELOW': 7924,
'LATIN CAPITAL LETTER Y WITH GRAVE': 7922,
'LATIN CAPITAL LETTER Y WITH HOOK': 435,
'LATIN CAPITAL LETTER Y WITH HOOK ABOVE': 7926,
'LATIN CAPITAL LETTER Y WITH MACRON': 562,
'LATIN CAPITAL LETTER Y WITH TILDE': 7928,
'LATIN CAPITAL LETTER YOGH': 540,
'LATIN CAPITAL LETTER Z': 90,
'LATIN CAPITAL LETTER Z WITH ACUTE': 377,
'LATIN CAPITAL LETTER Z WITH CARON': 381,
'LATIN CAPITAL LETTER Z WITH CIRCUMFLEX': 7824,
'LATIN CAPITAL LETTER Z WITH DOT ABOVE': 379,
'LATIN CAPITAL LETTER Z WITH DOT BELOW': 7826,
'LATIN CAPITAL LETTER Z WITH HOOK': 548,
'LATIN CAPITAL LETTER Z WITH LINE BELOW': 7828,
'LATIN CAPITAL LETTER Z WITH STROKE': 437,
'LATIN CAPITAL LIGATURE IJ': 306,
'LATIN CAPITAL LIGATURE OE': 338,
'LATIN CROSS': 10013,
'LATIN LETTER ALVEOLAR CLICK': 450,
'LATIN LETTER BIDENTAL PERCUSSIVE': 685,
'LATIN LETTER BILABIAL CLICK': 664,
'LATIN LETTER BILABIAL PERCUSSIVE': 684,
'LATIN LETTER DENTAL CLICK': 448,
'LATIN LETTER GLOTTAL STOP': 660,
'LATIN LETTER GLOTTAL STOP WITH STROKE': 673,
'LATIN LETTER INVERTED GLOTTAL STOP': 662,
'LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE': 446,
'LATIN LETTER LATERAL CLICK': 449,
'LATIN LETTER PHARYNGEAL VOICED FRICATIVE': 661,
'LATIN LETTER RETROFLEX CLICK': 451,
'LATIN LETTER REVERSED ESH LOOP': 426,
'LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE': 674,
'LATIN LETTER SMALL CAPITAL B': 665,
'LATIN LETTER SMALL CAPITAL G': 610,
'LATIN LETTER SMALL CAPITAL G WITH HOOK': 667,
'LATIN LETTER SMALL CAPITAL H': 668,
'LATIN LETTER SMALL CAPITAL I': 618,
'LATIN LETTER SMALL CAPITAL INVERTED R': 641,
'LATIN LETTER SMALL CAPITAL L': 671,
'LATIN LETTER SMALL CAPITAL N': 628,
'LATIN LETTER SMALL CAPITAL OE': 630,
'LATIN LETTER SMALL CAPITAL R': 640,
'LATIN LETTER SMALL CAPITAL Y': 655,
'LATIN LETTER STRETCHED C': 663,
'LATIN LETTER TWO WITH STROKE': 443,
'LATIN LETTER WYNN': 447,
'LATIN LETTER YR': 422,
'LATIN SMALL LETTER A': 97,
'LATIN SMALL LETTER A WITH ACUTE': 225,
'LATIN SMALL LETTER A WITH BREVE': 259,
'LATIN SMALL LETTER A WITH BREVE AND ACUTE': 7855,
'LATIN SMALL LETTER A WITH BREVE AND DOT BELOW': 7863,
'LATIN SMALL LETTER A WITH BREVE AND GRAVE': 7857,
'LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE': 7859,
'LATIN SMALL LETTER A WITH BREVE AND TILDE': 7861,
'LATIN SMALL LETTER A WITH CARON': 462,
'LATIN SMALL LETTER A WITH CIRCUMFLEX': 226,
'LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE': 7845,
'LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW': 7853,
'LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE': 7847,
'LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE': 7849,
'LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE': 7851,
'LATIN SMALL LETTER A WITH DIAERESIS': 228,
'LATIN SMALL LETTER A WITH DIAERESIS AND MACRON': 479,
'LATIN SMALL LETTER A WITH DOT ABOVE': 551,
'LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON': 481,
'LATIN SMALL LETTER A WITH DOT BELOW': 7841,
'LATIN SMALL LETTER A WITH DOUBLE GRAVE': 513,
'LATIN SMALL LETTER A WITH GRAVE': 224,
'LATIN SMALL LETTER A WITH HOOK ABOVE': 7843,
'LATIN SMALL LETTER A WITH INVERTED BREVE': 515,
'LATIN SMALL LETTER A WITH MACRON': 257,
'LATIN SMALL LETTER A WITH OGONEK': 261,
'LATIN SMALL LETTER A WITH RIGHT HALF RING': 7834,
'LATIN SMALL LETTER A WITH RING ABOVE': 229,
'LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE': 507,
'LATIN SMALL LETTER A WITH RING BELOW': 7681,
'LATIN SMALL LETTER A WITH TILDE': 227,
'LATIN SMALL LETTER AE': 230,
'LATIN SMALL LETTER AE WITH ACUTE': 509,
'LATIN SMALL LETTER AE WITH MACRON': 483,
'LATIN SMALL LETTER ALPHA': 593,
'LATIN SMALL LETTER B': 98,
'LATIN SMALL LETTER B WITH DOT ABOVE': 7683,
'LATIN SMALL LETTER B WITH DOT BELOW': 7685,
'LATIN SMALL LETTER B WITH HOOK': 595,
'LATIN SMALL LETTER B WITH LINE BELOW': 7687,
'LATIN SMALL LETTER B WITH STROKE': 384,
'LATIN SMALL LETTER B WITH TOPBAR': 387,
'LATIN SMALL LETTER BARRED O': 629,
'LATIN SMALL LETTER C': 99,
'LATIN SMALL LETTER C WITH ACUTE': 263,
'LATIN SMALL LETTER C WITH CARON': 269,
'LATIN SMALL LETTER C WITH CEDILLA': 231,
'LATIN SMALL LETTER C WITH CEDILLA AND ACUTE': 7689,
'LATIN SMALL LETTER C WITH CIRCUMFLEX': 265,
'LATIN SMALL LETTER C WITH CURL': 597,
'LATIN SMALL LETTER C WITH DOT ABOVE': 267,
'LATIN SMALL LETTER C WITH HOOK': 392,
'LATIN SMALL LETTER CLOSED OMEGA': 631,
'LATIN SMALL LETTER CLOSED OPEN E': 666,
'LATIN SMALL LETTER CLOSED REVERSED OPEN E': 606,
'LATIN SMALL LETTER D': 100,
'LATIN SMALL LETTER D WITH CARON': 271,
'LATIN SMALL LETTER D WITH CEDILLA': 7697,
'LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW': 7699,
'LATIN SMALL LETTER D WITH DOT ABOVE': 7691,
'LATIN SMALL LETTER D WITH DOT BELOW': 7693,
'LATIN SMALL LETTER D WITH HOOK': 599,
'LATIN SMALL LETTER D WITH LINE BELOW': 7695,
'LATIN SMALL LETTER D WITH STROKE': 273,
'LATIN SMALL LETTER D WITH TAIL': 598,
'LATIN SMALL LETTER D WITH TOPBAR': 396,
'LATIN SMALL LETTER DEZH DIGRAPH': 676,
'LATIN SMALL LETTER DOTLESS I': 305,
'LATIN SMALL LETTER DOTLESS J WITH STROKE': 607,
'LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK': 644,
'LATIN SMALL LETTER DZ': 499,
'LATIN SMALL LETTER DZ DIGRAPH': 675,
'LATIN SMALL LETTER DZ DIGRAPH WITH CURL': 677,
'LATIN SMALL LETTER DZ WITH CARON': 454,
'LATIN SMALL LETTER E': 101,
'LATIN SMALL LETTER E WITH ACUTE': 233,
'LATIN SMALL LETTER E WITH BREVE': 277,
'LATIN SMALL LETTER E WITH CARON': 283,
'LATIN SMALL LETTER E WITH CEDILLA': 553,
'LATIN SMALL LETTER E WITH CEDILLA AND BREVE': 7709,
'LATIN SMALL LETTER E WITH CIRCUMFLEX': 234,
'LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE': 7871,
'LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW': 7879,
'LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE': 7873,
'LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE': 7875,
'LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE': 7877,
'LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW': 7705,
'LATIN SMALL LETTER E WITH DIAERESIS': 235,
'LATIN SMALL LETTER E WITH DOT ABOVE': 279,
'LATIN SMALL LETTER E WITH DOT BELOW': 7865,
'LATIN SMALL LETTER E WITH DOUBLE GRAVE': 517,
'LATIN SMALL LETTER E WITH GRAVE': 232,
'LATIN SMALL LETTER E WITH HOOK ABOVE': 7867,
'LATIN SMALL LETTER E WITH INVERTED BREVE': 519,
'LATIN SMALL LETTER E WITH MACRON': 275,
'LATIN SMALL LETTER E WITH MACRON AND ACUTE': 7703,
'LATIN SMALL LETTER E WITH MACRON AND GRAVE': 7701,
'LATIN SMALL LETTER E WITH OGONEK': 281,
'LATIN SMALL LETTER E WITH TILDE': 7869,
'LATIN SMALL LETTER E WITH TILDE BELOW': 7707,
'LATIN SMALL LETTER ENG': 331,
'LATIN SMALL LETTER ESH': 643,
'LATIN SMALL LETTER ESH WITH CURL': 646,
'LATIN SMALL LETTER ETH': 240,
'LATIN SMALL LETTER EZH': 658,
'LATIN SMALL LETTER EZH REVERSED': 441,
'LATIN SMALL LETTER EZH WITH CARON': 495,
'LATIN SMALL LETTER EZH WITH CURL': 659,
'LATIN SMALL LETTER EZH WITH TAIL': 442,
'LATIN SMALL LETTER F': 102,
'LATIN SMALL LETTER F WITH DOT ABOVE': 7711,
'LATIN SMALL LETTER F WITH HOOK': 402,
'LATIN SMALL LETTER FENG DIGRAPH': 681,
'LATIN SMALL LETTER G': 103,
'LATIN SMALL LETTER G WITH ACUTE': 501,
'LATIN SMALL LETTER G WITH BREVE': 287,
'LATIN SMALL LETTER G WITH CARON': 487,
'LATIN SMALL LETTER G WITH CEDILLA': 291,
'LATIN SMALL LETTER G WITH CIRCUMFLEX': 285,
'LATIN SMALL LETTER G WITH DOT ABOVE': 289,
'LATIN SMALL LETTER G WITH HOOK': 608,
'LATIN SMALL LETTER G WITH MACRON': 7713,
'LATIN SMALL LETTER G WITH STROKE': 485,
'LATIN SMALL LETTER GAMMA': 611,
'LATIN SMALL LETTER H': 104,
'LATIN SMALL LETTER H WITH BREVE BELOW': 7723,
'LATIN SMALL LETTER H WITH CARON': 543,
'LATIN SMALL LETTER H WITH CEDILLA': 7721,
'LATIN SMALL LETTER H WITH CIRCUMFLEX': 293,
'LATIN SMALL LETTER H WITH DIAERESIS': 7719,
'LATIN SMALL LETTER H WITH DOT ABOVE': 7715,
'LATIN SMALL LETTER H WITH DOT BELOW': 7717,
'LATIN SMALL LETTER H WITH HOOK': 614,
'LATIN SMALL LETTER H WITH LINE BELOW': 7830,
'LATIN SMALL LETTER H WITH STROKE': 295,
'LATIN SMALL LETTER HENG WITH HOOK': 615,
'LATIN SMALL LETTER HV': 405,
'LATIN SMALL LETTER I': 105,
'LATIN SMALL LETTER I WITH ACUTE': 237,
'LATIN SMALL LETTER I WITH BREVE': 301,
'LATIN SMALL LETTER I WITH CARON': 464,
'LATIN SMALL LETTER I WITH CIRCUMFLEX': 238,
'LATIN SMALL LETTER I WITH DIAERESIS': 239,
'LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE': 7727,
'LATIN SMALL LETTER I WITH DOT BELOW': 7883,
'LATIN SMALL LETTER I WITH DOUBLE GRAVE': 521,
'LATIN SMALL LETTER I WITH GRAVE': 236,
'LATIN SMALL LETTER I WITH HOOK ABOVE': 7881,
'LATIN SMALL LETTER I WITH INVERTED BREVE': 523,
'LATIN SMALL LETTER I WITH MACRON': 299,
'LATIN SMALL LETTER I WITH OGONEK': 303,
'LATIN SMALL LETTER I WITH STROKE': 616,
'LATIN SMALL LETTER I WITH TILDE': 297,
'LATIN SMALL LETTER I WITH TILDE BELOW': 7725,
'LATIN SMALL LETTER IOTA': 617,
'LATIN SMALL LETTER J': 106,
'LATIN SMALL LETTER J WITH CARON': 496,
'LATIN SMALL LETTER J WITH CIRCUMFLEX': 309,
'LATIN SMALL LETTER J WITH CROSSED-TAIL': 669,
'LATIN SMALL LETTER K': 107,
'LATIN SMALL LETTER K WITH ACUTE': 7729,
'LATIN SMALL LETTER K WITH CARON': 489,
'LATIN SMALL LETTER K WITH CEDILLA': 311,
'LATIN SMALL LETTER K WITH DOT BELOW': 7731,
'LATIN SMALL LETTER K WITH HOOK': 409,
'LATIN SMALL LETTER K WITH LINE BELOW': 7733,
'LATIN SMALL LETTER KRA': 312,
'LATIN SMALL LETTER L': 108,
'LATIN SMALL LETTER L WITH ACUTE': 314,
'LATIN SMALL LETTER L WITH BAR': 410,
'LATIN SMALL LETTER L WITH BELT': 620,
'LATIN SMALL LETTER L WITH CARON': 318,
'LATIN SMALL LETTER L WITH CEDILLA': 316,
'LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW': 7741,
'LATIN SMALL LETTER L WITH DOT BELOW': 7735,
'LATIN SMALL LETTER L WITH DOT BELOW AND MACRON': 7737,
'LATIN SMALL LETTER L WITH LINE BELOW': 7739,
'LATIN SMALL LETTER L WITH MIDDLE DOT': 320,
'LATIN SMALL LETTER L WITH MIDDLE TILDE': 619,
'LATIN SMALL LETTER L WITH RETROFLEX HOOK': 621,
'LATIN SMALL LETTER L WITH STROKE': 322,
'LATIN SMALL LETTER LAMBDA WITH STROKE': 411,
'LATIN SMALL LETTER LEZH': 622,
'LATIN SMALL LETTER LJ': 457,
'LATIN SMALL LETTER LONG S': 383,
'LATIN SMALL LETTER LONG S WITH DOT ABOVE': 7835,
'LATIN SMALL LETTER LS DIGRAPH': 682,
'LATIN SMALL LETTER LZ DIGRAPH': 683,
'LATIN SMALL LETTER M': 109,
'LATIN SMALL LETTER M WITH ACUTE': 7743,
'LATIN SMALL LETTER M WITH DOT ABOVE': 7745,
'LATIN SMALL LETTER M WITH DOT BELOW': 7747,
'LATIN SMALL LETTER M WITH HOOK': 625,
'LATIN SMALL LETTER N': 110,
'LATIN SMALL LETTER N PRECEDED BY APOSTROPHE': 329,
'LATIN SMALL LETTER N WITH ACUTE': 324,
'LATIN SMALL LETTER N WITH CARON': 328,
'LATIN SMALL LETTER N WITH CEDILLA': 326,
'LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW': 7755,
'LATIN SMALL LETTER N WITH DOT ABOVE': 7749,
'LATIN SMALL LETTER N WITH DOT BELOW': 7751,
'LATIN SMALL LETTER N WITH GRAVE': 505,
'LATIN SMALL LETTER N WITH LEFT HOOK': 626,
'LATIN SMALL LETTER N WITH LINE BELOW': 7753,
'LATIN SMALL LETTER N WITH LONG RIGHT LEG': 414,
'LATIN SMALL LETTER N WITH RETROFLEX HOOK': 627,
'LATIN SMALL LETTER N WITH TILDE': 241,
'LATIN SMALL LETTER NJ': 460,
'LATIN SMALL LETTER O': 111,
'LATIN SMALL LETTER O WITH ACUTE': 243,
'LATIN SMALL LETTER O WITH BREVE': 335,
'LATIN SMALL LETTER O WITH CARON': 466,
'LATIN SMALL LETTER O WITH CIRCUMFLEX': 244,
'LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE': 7889,
'LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW': 7897,
'LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE': 7891,
'LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE': 7893,
'LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE': 7895,
'LATIN SMALL LETTER O WITH DIAERESIS': 246,
'LATIN SMALL LETTER O WITH DIAERESIS AND MACRON': 555,
'LATIN SMALL LETTER O WITH DOT ABOVE': 559,
'LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON': 561,
'LATIN SMALL LETTER O WITH DOT BELOW': 7885,
'LATIN SMALL LETTER O WITH DOUBLE ACUTE': 337,
'LATIN SMALL LETTER O WITH DOUBLE GRAVE': 525,
'LATIN SMALL LETTER O WITH GRAVE': 242,
'LATIN SMALL LETTER O WITH HOOK ABOVE': 7887,
'LATIN SMALL LETTER O WITH HORN': 417,
'LATIN SMALL LETTER O WITH HORN AND ACUTE': 7899,
'LATIN SMALL LETTER O WITH HORN AND DOT BELOW': 7907,
'LATIN SMALL LETTER O WITH HORN AND GRAVE': 7901,
'LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE': 7903,
'LATIN SMALL LETTER O WITH HORN AND TILDE': 7905,
'LATIN SMALL LETTER O WITH INVERTED BREVE': 527,
'LATIN SMALL LETTER O WITH MACRON': 333,
'LATIN SMALL LETTER O WITH MACRON AND ACUTE': 7763,
'LATIN SMALL LETTER O WITH MACRON AND GRAVE': 7761,
'LATIN SMALL LETTER O WITH OGONEK': 491,
'LATIN SMALL LETTER O WITH OGONEK AND MACRON': 493,
'LATIN SMALL LETTER O WITH STROKE': 248,
'LATIN SMALL LETTER O WITH STROKE AND ACUTE': 511,
'LATIN SMALL LETTER O WITH TILDE': 245,
'LATIN SMALL LETTER O WITH TILDE AND ACUTE': 7757,
'LATIN SMALL LETTER O WITH TILDE AND DIAERESIS': 7759,
'LATIN SMALL LETTER O WITH TILDE AND MACRON': 557,
'LATIN SMALL LETTER OI': 419,
'LATIN SMALL LETTER OPEN E': 603,
'LATIN SMALL LETTER OPEN O': 596,
'LATIN SMALL LETTER OU': 547,
'LATIN SMALL LETTER P': 112,
'LATIN SMALL LETTER P WITH ACUTE': 7765,
'LATIN SMALL LETTER P WITH DOT ABOVE': 7767,
'LATIN SMALL LETTER P WITH HOOK': 421,
'LATIN SMALL LETTER PHI': 632,
'LATIN SMALL LETTER Q': 113,
'LATIN SMALL LETTER Q WITH HOOK': 672,
'LATIN SMALL LETTER R': 114,
'LATIN SMALL LETTER R WITH ACUTE': 341,
'LATIN SMALL LETTER R WITH CARON': 345,
'LATIN SMALL LETTER R WITH CEDILLA': 343,
'LATIN SMALL LETTER R WITH DOT ABOVE': 7769,
'LATIN SMALL LETTER R WITH DOT BELOW': 7771,
'LATIN SMALL LETTER R WITH DOT BELOW AND MACRON': 7773,
'LATIN SMALL LETTER R WITH DOUBLE GRAVE': 529,
'LATIN SMALL LETTER R WITH FISHHOOK': 638,
'LATIN SMALL LETTER R WITH INVERTED BREVE': 531,
'LATIN SMALL LETTER R WITH LINE BELOW': 7775,
'LATIN SMALL LETTER R WITH LONG LEG': 636,
'LATIN SMALL LETTER R WITH TAIL': 637,
'LATIN SMALL LETTER RAMS HORN': 612,
'LATIN SMALL LETTER REVERSED E': 600,
'LATIN SMALL LETTER REVERSED OPEN E': 604,
'LATIN SMALL LETTER REVERSED OPEN E WITH HOOK': 605,
'LATIN SMALL LETTER REVERSED R WITH FISHHOOK': 639,
'LATIN SMALL LETTER S': 115,
'LATIN SMALL LETTER S WITH ACUTE': 347,
'LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE': 7781,
'LATIN SMALL LETTER S WITH CARON': 353,
'LATIN SMALL LETTER S WITH CARON AND DOT ABOVE': 7783,
'LATIN SMALL LETTER S WITH CEDILLA': 351,
'LATIN SMALL LETTER S WITH CIRCUMFLEX': 349,
'LATIN SMALL LETTER S WITH COMMA BELOW': 537,
'LATIN SMALL LETTER S WITH DOT ABOVE': 7777,
'LATIN SMALL LETTER S WITH DOT BELOW': 7779,
'LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE': 7785,
'LATIN SMALL LETTER S WITH HOOK': 642,
'LATIN SMALL LETTER SCHWA': 601,
'LATIN SMALL LETTER SCHWA WITH HOOK': 602,
'LATIN SMALL LETTER SCRIPT G': 609,
'LATIN SMALL LETTER SHARP S': 223,
'LATIN SMALL LETTER SQUAT REVERSED ESH': 645,
'LATIN SMALL LETTER T': 116,
'LATIN SMALL LETTER T WITH CARON': 357,
'LATIN SMALL LETTER T WITH CEDILLA': 355,
'LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW': 7793,
'LATIN SMALL LETTER T WITH COMMA BELOW': 539,
'LATIN SMALL LETTER T WITH DIAERESIS': 7831,
'LATIN SMALL LETTER T WITH DOT ABOVE': 7787,
'LATIN SMALL LETTER T WITH DOT BELOW': 7789,
'LATIN SMALL LETTER T WITH HOOK': 429,
'LATIN SMALL LETTER T WITH LINE BELOW': 7791,
'LATIN SMALL LETTER T WITH PALATAL HOOK': 427,
'LATIN SMALL LETTER T WITH RETROFLEX HOOK': 648,
'LATIN SMALL LETTER T WITH STROKE': 359,
'LATIN SMALL LETTER TC DIGRAPH WITH CURL': 680,
'LATIN SMALL LETTER TESH DIGRAPH': 679,
'LATIN SMALL LETTER THORN': 254,
'LATIN SMALL LETTER TONE FIVE': 445,
'LATIN SMALL LETTER TONE SIX': 389,
'LATIN SMALL LETTER TONE TWO': 424,
'LATIN SMALL LETTER TS DIGRAPH': 678,
'LATIN SMALL LETTER TURNED A': 592,
'LATIN SMALL LETTER TURNED ALPHA': 594,
'LATIN SMALL LETTER TURNED DELTA': 397,
'LATIN SMALL LETTER TURNED E': 477,
'LATIN SMALL LETTER TURNED H': 613,
'LATIN SMALL LETTER TURNED K': 670,
'LATIN SMALL LETTER TURNED M': 623,
'LATIN SMALL LETTER TURNED M WITH LONG LEG': 624,
'LATIN SMALL LETTER TURNED R': 633,
'LATIN SMALL LETTER TURNED R WITH HOOK': 635,
'LATIN SMALL LETTER TURNED R WITH LONG LEG': 634,
'LATIN SMALL LETTER TURNED T': 647,
'LATIN SMALL LETTER TURNED V': 652,
'LATIN SMALL LETTER TURNED W': 653,
'LATIN SMALL LETTER TURNED Y': 654,
'LATIN SMALL LETTER U': 117,
'LATIN SMALL LETTER U BAR': 649,
'LATIN SMALL LETTER U WITH ACUTE': 250,
'LATIN SMALL LETTER U WITH BREVE': 365,
'LATIN SMALL LETTER U WITH CARON': 468,
'LATIN SMALL LETTER U WITH CIRCUMFLEX': 251,
'LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW': 7799,
'LATIN SMALL LETTER U WITH DIAERESIS': 252,
'LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE': 472,
'LATIN SMALL LETTER U WITH DIAERESIS AND CARON': 474,
'LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE': 476,
'LATIN SMALL LETTER U WITH DIAERESIS AND MACRON': 470,
'LATIN SMALL LETTER U WITH DIAERESIS BELOW': 7795,
'LATIN SMALL LETTER U WITH DOT BELOW': 7909,
'LATIN SMALL LETTER U WITH DOUBLE ACUTE': 369,
'LATIN SMALL LETTER U WITH DOUBLE GRAVE': 533,
'LATIN SMALL LETTER U WITH GRAVE': 249,
'LATIN SMALL LETTER U WITH HOOK ABOVE': 7911,
'LATIN SMALL LETTER U WITH HORN': 432,
'LATIN SMALL LETTER U WITH HORN AND ACUTE': 7913,
'LATIN SMALL LETTER U WITH HORN AND DOT BELOW': 7921,
'LATIN SMALL LETTER U WITH HORN AND GRAVE': 7915,
'LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE': 7917,
'LATIN SMALL LETTER U WITH HORN AND TILDE': 7919,
'LATIN SMALL LETTER U WITH INVERTED BREVE': 535,
'LATIN SMALL LETTER U WITH MACRON': 363,
'LATIN SMALL LETTER U WITH MACRON AND DIAERESIS': 7803,
'LATIN SMALL LETTER U WITH OGONEK': 371,
'LATIN SMALL LETTER U WITH RING ABOVE': 367,
'LATIN SMALL LETTER U WITH TILDE': 361,
'LATIN SMALL LETTER U WITH TILDE AND ACUTE': 7801,
'LATIN SMALL LETTER U WITH TILDE BELOW': 7797,
'LATIN SMALL LETTER UPSILON': 650,
'LATIN SMALL LETTER V': 118,
'LATIN SMALL LETTER V WITH DOT BELOW': 7807,
'LATIN SMALL LETTER V WITH HOOK': 651,
'LATIN SMALL LETTER V WITH TILDE': 7805,
'LATIN SMALL LETTER W': 119,
'LATIN SMALL LETTER W WITH ACUTE': 7811,
'LATIN SMALL LETTER W WITH CIRCUMFLEX': 373,
'LATIN SMALL LETTER W WITH DIAERESIS': 7813,
'LATIN SMALL LETTER W WITH DOT ABOVE': 7815,
'LATIN SMALL LETTER W WITH DOT BELOW': 7817,
'LATIN SMALL LETTER W WITH GRAVE': 7809,
'LATIN SMALL LETTER W WITH RING ABOVE': 7832,
'LATIN SMALL LETTER X': 120,
'LATIN SMALL LETTER X WITH DIAERESIS': 7821,
'LATIN SMALL LETTER X WITH DOT ABOVE': 7819,
'LATIN SMALL LETTER Y': 121,
'LATIN SMALL LETTER Y WITH ACUTE': 253,
'LATIN SMALL LETTER Y WITH CIRCUMFLEX': 375,
'LATIN SMALL LETTER Y WITH DIAERESIS': 255,
'LATIN SMALL LETTER Y WITH DOT ABOVE': 7823,
'LATIN SMALL LETTER Y WITH DOT BELOW': 7925,
'LATIN SMALL LETTER Y WITH GRAVE': 7923,
'LATIN SMALL LETTER Y WITH HOOK': 436,
'LATIN SMALL LETTER Y WITH HOOK ABOVE': 7927,
'LATIN SMALL LETTER Y WITH MACRON': 563,
'LATIN SMALL LETTER Y WITH RING ABOVE': 7833,
'LATIN SMALL LETTER Y WITH TILDE': 7929,
'LATIN SMALL LETTER YOGH': 541,
'LATIN SMALL LETTER Z': 122,
'LATIN SMALL LETTER Z WITH ACUTE': 378,
'LATIN SMALL LETTER Z WITH CARON': 382,
'LATIN SMALL LETTER Z WITH CIRCUMFLEX': 7825,
'LATIN SMALL LETTER Z WITH CURL': 657,
'LATIN SMALL LETTER Z WITH DOT ABOVE': 380,
'LATIN SMALL LETTER Z WITH DOT BELOW': 7827,
'LATIN SMALL LETTER Z WITH HOOK': 549,
'LATIN SMALL LETTER Z WITH LINE BELOW': 7829,
'LATIN SMALL LETTER Z WITH RETROFLEX HOOK': 656,
'LATIN SMALL LETTER Z WITH STROKE': 438,
'LATIN SMALL LIGATURE FF': 64256,
'LATIN SMALL LIGATURE FFI': 64259,
'LATIN SMALL LIGATURE FFL': 64260,
'LATIN SMALL LIGATURE FI': 64257,
'LATIN SMALL LIGATURE FL': 64258,
'LATIN SMALL LIGATURE IJ': 307,
'LATIN SMALL LIGATURE LONG S T': 64261,
'LATIN SMALL LIGATURE OE': 339,
'LATIN SMALL LIGATURE ST': 64262,
'LEFT AND RIGHT DOUBLE TURNSTILE': 10202,
'LEFT AND RIGHT TACK': 10203,
'LEFT ANGLE BRACKET': 12296,
'LEFT ANGLE BRACKET WITH DOT': 10641,
'LEFT ARC LESS-THAN BRACKET': 10643,
'LEFT BARB DOWN RIGHT BARB DOWN HARPOON': 10576,
'LEFT BARB DOWN RIGHT BARB UP HARPOON': 10571,
'LEFT BARB UP RIGHT BARB DOWN HARPOON': 10570,
'LEFT BARB UP RIGHT BARB UP HARPOON': 10574,
'LEFT BLACK LENTICULAR BRACKET': 12304,
'LEFT BLACK TORTOISE SHELL BRACKET': 10647,
'LEFT CEILING': 8968,
'LEFT CORNER BRACKET': 12300,
'LEFT CURLY BRACKET': 123,
'LEFT CURLY BRACKET LOWER HOOK': 9129,
'LEFT CURLY BRACKET MIDDLE PIECE': 9128,
'LEFT CURLY BRACKET UPPER HOOK': 9127,
'LEFT DOUBLE ANGLE BRACKET': 12298,
'LEFT DOUBLE QUOTATION MARK': 8220,
'LEFT DOUBLE WIGGLY FENCE': 10714,
'LEFT FISH TAIL': 10620,
'LEFT FIVE EIGHTHS BLOCK': 9611,
'LEFT FLOOR': 8970,
'LEFT HALF BLACK CIRCLE': 9686,
'LEFT HALF BLOCK': 9612,
'LEFT MULTIMAP': 10204,
'LEFT NORMAL FACTOR SEMIDIRECT PRODUCT': 8905,
'LEFT ONE EIGHTH BLOCK': 9615,
'LEFT ONE QUARTER BLOCK': 9614,
'LEFT OUTER JOIN': 10197,
'LEFT PARENTHESIS': 40,
'LEFT PARENTHESIS EXTENSION': 9116,
'LEFT PARENTHESIS LOWER HOOK': 9117,
'LEFT PARENTHESIS UPPER HOOK': 9115,
'LEFT RIGHT ARROW': 8596,
'LEFT RIGHT ARROW THROUGH SMALL CIRCLE': 10568,
'LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE': 8700,
'LEFT RIGHT ARROW WITH STROKE': 8622,
'LEFT RIGHT ARROW WITH VERTICAL STROKE': 8697,
'LEFT RIGHT DOUBLE ARROW': 8660,
'LEFT RIGHT DOUBLE ARROW WITH STROKE': 8654,
'LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE': 10500,
'LEFT RIGHT OPEN-HEADED ARROW': 8703,
'LEFT RIGHT WAVE ARROW': 8621,
'LEFT SEMIDIRECT PRODUCT': 8907,
'LEFT SEVEN EIGHTHS BLOCK': 9609,
'LEFT SINGLE QUOTATION MARK': 8216,
'LEFT SQUARE BRACKET': 91,
'LEFT SQUARE BRACKET EXTENSION': 9122,
'LEFT SQUARE BRACKET LOWER CORNER': 9123,
'LEFT SQUARE BRACKET UPPER CORNER': 9121,
'LEFT SQUARE BRACKET WITH QUILL': 8261,
'LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER': 10639,
'LEFT SQUARE BRACKET WITH TICK IN TOP CORNER': 10637,
'LEFT SQUARE BRACKET WITH UNDERBAR': 10635,
'LEFT TACK': 8867,
'LEFT THREE EIGHTHS BLOCK': 9613,
'LEFT THREE QUARTERS BLOCK': 9610,
'LEFT TORTOISE SHELL BRACKET': 12308,
'LEFT TRIANGLE BESIDE VERTICAL BAR': 10703,
'LEFT VERTICAL BOX LINE': 9144,
'LEFT WHITE CORNER BRACKET': 12302,
'LEFT WHITE CURLY BRACKET': 10627,
'LEFT WHITE LENTICULAR BRACKET': 12310,
'LEFT WHITE PARENTHESIS': 10629,
'LEFT WHITE SQUARE BRACKET': 12314,
'LEFT WHITE TORTOISE SHELL BRACKET': 12312,
'LEFT WIGGLY FENCE': 10712,
'LEFT-POINTING ANGLE BRACKET': 9001,
'LEFT-POINTING CURVED ANGLE BRACKET': 10748,
'LEFT-POINTING DOUBLE ANGLE QUOTATION MARK': 171,
'LEFT-SHADED WHITE RIGHTWARDS ARROW': 10154,
'LEFT-SIDE ARC ANTICLOCKWISE ARROW': 10553,
'LEFT-TO-RIGHT EMBEDDING': 8234,
'LEFT-TO-RIGHT MARK': 8206,
'LEFT-TO-RIGHT OVERRIDE': 8237,
'LEFTWARDS ARROW': 8592,
'LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW': 10563,
'LEFTWARDS ARROW ABOVE TILDE OPERATOR': 10611,
'LEFTWARDS ARROW FROM BAR': 8612,
'LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND': 10527,
'LEFTWARDS ARROW OVER RIGHTWARDS ARROW': 8646,
'LEFTWARDS ARROW THROUGH LESS-THAN': 10615,
'LEFTWARDS ARROW THROUGH SUBSET': 10618,
'LEFTWARDS ARROW TO BAR': 8676,
'LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR': 8633,
'LEFTWARDS ARROW TO BLACK DIAMOND': 10525,
'LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE': 8698,
'LEFTWARDS ARROW WITH HOOK': 8617,
'LEFTWARDS ARROW WITH LOOP': 8619,
'LEFTWARDS ARROW WITH PLUS BELOW': 10566,
'LEFTWARDS ARROW WITH STROKE': 8602,
'LEFTWARDS ARROW WITH TAIL': 8610,
'LEFTWARDS ARROW WITH VERTICAL STROKE': 8695,
'LEFTWARDS ARROW-TAIL': 10521,
'LEFTWARDS DASHED ARROW': 8672,
'LEFTWARDS DOUBLE ARROW': 8656,
'LEFTWARDS DOUBLE ARROW FROM BAR': 10502,
'LEFTWARDS DOUBLE ARROW WITH STROKE': 8653,
'LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE': 10498,
'LEFTWARDS DOUBLE ARROW-TAIL': 10523,
'LEFTWARDS DOUBLE DASH ARROW': 10508,
'LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON': 8651,
'LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN': 10599,
'LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH': 10603,
'LEFTWARDS HARPOON WITH BARB DOWN FROM BAR': 10590,
'LEFTWARDS HARPOON WITH BARB DOWN TO BAR': 10582,
'LEFTWARDS HARPOON WITH BARB DOWNWARDS': 8637,
'LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN': 10594,
'LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH': 10602,
'LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP': 10598,
'LEFTWARDS HARPOON WITH BARB UP FROM BAR': 10586,
'LEFTWARDS HARPOON WITH BARB UP TO BAR': 10578,
'LEFTWARDS HARPOON WITH BARB UPWARDS': 8636,
'LEFTWARDS OPEN-HEADED ARROW': 8701,
'LEFTWARDS PAIRED ARROWS': 8647,
'LEFTWARDS SQUIGGLE ARROW': 8668,
'LEFTWARDS TRIPLE ARROW': 8666,
'LEFTWARDS TRIPLE DASH ARROW': 10510,
'LEFTWARDS TWO HEADED ARROW': 8606,
'LEFTWARDS WAVE ARROW': 8604,
'LEFTWARDS WHITE ARROW': 8678,
'LEO': 9804,
'LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN': 10891,
'LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL': 10897,
'LESS-THAN ABOVE LEFTWARDS ARROW': 10614,
'LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN': 10895,
'LESS-THAN ABOVE SIMILAR OR EQUAL': 10893,
'LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL': 10899,
'LESS-THAN AND NOT APPROXIMATE': 10889,
'LESS-THAN AND SINGLE-LINE NOT EQUAL TO': 10887,
'LESS-THAN BUT NOT EQUAL TO': 8808,
'LESS-THAN BUT NOT EQUIVALENT TO': 8934,
'LESS-THAN CLOSED BY CURVE': 10918,
'LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL': 10920,
'LESS-THAN EQUAL TO OR GREATER-THAN': 8922,
'LESS-THAN OR APPROXIMATE': 10885,
'LESS-THAN OR EQUAL TO': 8804,
'LESS-THAN OR EQUIVALENT TO': 8818,
'LESS-THAN OR GREATER-THAN': 8822,
'LESS-THAN OR SLANTED EQUAL TO': 10877,
'LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE': 10881,
'LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT': 10883,
'LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE': 10879,
'LESS-THAN OVER EQUAL TO': 8806,
'LESS-THAN SIGN': 60,
'LESS-THAN WITH CIRCLE INSIDE': 10873,
'LESS-THAN WITH DOT': 8918,
'LESS-THAN WITH QUESTION MARK ABOVE': 10875,
'LIBRA': 9806,
'LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT': 10098,
'LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT': 10099,
'LIGHT SHADE': 9617,
'LIGHT VERTICAL BAR': 10072,
'LIGHTNING': 9735,
'LINE INTEGRATION NOT INCLUDING THE POLE': 10772,
'LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE': 10770,
'LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE': 10771,
'LINE SEPARATOR': 8232,
'LIRA SIGN': 8356,
'LOGICAL AND': 8743,
'LOGICAL AND WITH DOT ABOVE': 10833,
'LOGICAL AND WITH DOUBLE OVERBAR': 10846,
'LOGICAL AND WITH DOUBLE UNDERBAR': 10848,
'LOGICAL AND WITH HORIZONTAL DASH': 10844,
'LOGICAL AND WITH MIDDLE STEM': 10842,
'LOGICAL AND WITH UNDERBAR': 10847,
'LOGICAL OR': 8744,
'LOGICAL OR OVERLAPPING LOGICAL AND': 10841,
'LOGICAL OR WITH DOT ABOVE': 10834,
'LOGICAL OR WITH DOUBLE OVERBAR': 10850,
'LOGICAL OR WITH DOUBLE UNDERBAR': 10851,
'LOGICAL OR WITH HORIZONTAL DASH': 10845,
'LOGICAL OR WITH MIDDLE STEM': 10843,
'LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL': 10982,
'LONG LEFT RIGHT ARROW': 10231,
'LONG LEFT RIGHT DOUBLE ARROW': 10234,
'LONG LEFT TACK': 10206,
'LONG LEFTWARDS ARROW': 10229,
'LONG LEFTWARDS ARROW FROM BAR': 10235,
'LONG LEFTWARDS DOUBLE ARROW': 10232,
'LONG LEFTWARDS DOUBLE ARROW FROM BAR': 10237,
'LONG RIGHT TACK': 10205,
'LONG RIGHTWARDS ARROW': 10230,
'LONG RIGHTWARDS ARROW FROM BAR': 10236,
'LONG RIGHTWARDS DOUBLE ARROW': 10233,
'LONG RIGHTWARDS DOUBLE ARROW FROM BAR': 10238,
'LONG RIGHTWARDS SQUIGGLE ARROW': 10239,
'LOW ASTERISK': 8270,
'LOW DOUBLE PRIME QUOTATION MARK': 12319,
'LOW LINE': 95,
'LOWER BLADE SCISSORS': 9987,
'LOWER FIVE EIGHTHS BLOCK': 9605,
'LOWER HALF BLOCK': 9604,
'LOWER HALF CIRCLE': 9697,
'LOWER HALF INVERSE WHITE CIRCLE': 9691,
'LOWER LEFT QUADRANT CIRCULAR ARC': 9695,
'LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW': 10559,
'LOWER LEFT TRIANGLE': 9722,
'LOWER ONE EIGHTH BLOCK': 9601,
'LOWER ONE QUARTER BLOCK': 9602,
'LOWER RIGHT CORNER WITH DOT': 10195,
'LOWER RIGHT DROP-SHADOWED WHITE SQUARE': 10063,
'LOWER RIGHT PENCIL': 9998,
'LOWER RIGHT QUADRANT CIRCULAR ARC': 9694,
'LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW': 10558,
'LOWER RIGHT SHADOWED WHITE SQUARE': 10065,
'LOWER RIGHT TRIANGLE': 9727,
'LOWER SEVEN EIGHTHS BLOCK': 9607,
'LOWER THREE EIGHTHS BLOCK': 9603,
'LOWER THREE QUARTERS BLOCK': 9606,
'LOZENGE': 9674,
'LOZENGE DIVIDED BY HORIZONTAL RULE': 10208,
'MACRON': 175,
'MALAYALAM AU LENGTH MARK': 3415,
'MALAYALAM DIGIT EIGHT': 3438,
'MALAYALAM DIGIT FIVE': 3435,
'MALAYALAM DIGIT FOUR': 3434,
'MALAYALAM DIGIT NINE': 3439,
'MALAYALAM DIGIT ONE': 3431,
'MALAYALAM DIGIT SEVEN': 3437,
'MALAYALAM DIGIT SIX': 3436,
'MALAYALAM DIGIT THREE': 3433,
'MALAYALAM DIGIT TWO': 3432,
'MALAYALAM DIGIT ZERO': 3430,
'MALAYALAM LETTER A': 3333,
'MALAYALAM LETTER AA': 3334,
'MALAYA