##
#    Copyright (c) 2012-2013 Cyrus Daboo. All rights reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.
##

import unittest
from pycalendar.stringutils import strduptokenstr


class TestStringUtils(unittest.TestCase):

    def test_strduptokenstr(self):
        """
        Make sure L{strduptokenstr} copes with all possibilities.
        """

        data = (
            # Leading space
            ("  abc:def", ":;", ("abc", ":def")),
            ("  \"abc\":def", ":;", ("abc", ":def")),
            ("   ", ":;", (None, "")),

            # Quoted
            ("\"abc\":def", ":;", ("abc", ":def")),
            ("\"ab\\c\":def", ":;", ("ab\\c", ":def")),
            ("\"ab\\c:def", ":;", (None, "\"ab\\c:def")),
            ("\"abc\":", ":;", ("abc", ":")),
            ("\"abc\"", ":;", ("abc", "")),

            # Unuoted
            ("abc:def", ":;", ("abc", ":def")),
            ("abc:", ":;", ("abc", ":")),
            ("abc", ":;", ("abc", "")),
        )

        for txt, tokens, result in data:
            self.assertEqual(strduptokenstr(txt, tokens), result)
