require 'spec_helper'

describe 'glance::backend::file' do
  let :facts do
      @default_facts.merge({
        :osfamily       => 'Debian',
      })
  end

  it 'configures glance-api.conf' do
    is_expected.to contain_glance_api_config('glance_store/default_store').with_value('file')
    is_expected.to contain_glance_api_config('glance_store/filesystem_store_datadir').with_value('/var/lib/glance/images/')
  end

  it 'configures glance-cache.conf' do
    is_expected.to contain_glance_cache_config('glance_store/filesystem_store_datadir').with_value('/var/lib/glance/images/')
  end

  describe 'when overriding datadir' do
    let :params do
      {:filesystem_store_datadir => '/tmp/'}
    end

    it 'configures glance-api.conf' do
      is_expected.to contain_glance_api_config('glance_store/filesystem_store_datadir').with_value('/tmp/')
    end

    it 'configures glance-cache.conf' do
      is_expected.to contain_glance_cache_config('glance_store/filesystem_store_datadir').with_value('/tmp/')
    end
  end
end
