/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class ClassPool {
    private final Map classes = new TreeMap();

    public void clear() {
        this.classes.clear();
    }

    public void addClass(Clazz clazz) {
        this.classes.put(clazz.getName(), clazz);
    }

    public void removeClass(Clazz clazz) {
        this.removeClass(clazz.getName());
    }

    public void removeClass(String string) {
        this.classes.remove(string);
    }

    public Clazz getClass(String string) {
        return (Clazz)this.classes.get(string);
    }

    public Iterator classNames() {
        return this.classes.keySet().iterator();
    }

    public int size() {
        return this.classes.size();
    }

    public void accept(ClassPoolVisitor classPoolVisitor) {
        classPoolVisitor.visitClassPool(this);
    }

    public void classesAccept(ClassVisitor classVisitor) {
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            clazz.accept(classVisitor);
        }
    }

    public void classesAcceptAlphabetically(ClassVisitor classVisitor) {
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            Clazz clazz = (Clazz)iterator.next();
            clazz.accept(classVisitor);
        }
    }

    public void classAccept(String string, ClassVisitor classVisitor) {
        Clazz clazz = this.getClass(string);
        if (clazz != null) {
            clazz.accept(classVisitor);
        }
    }
}

