------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--          P O L Y O R B . D S A _ P . R E M O T E _ L A U N C H           --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2006-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

--  This package is in charge of launching the remote partitions when Ada
--  starter is used. It is a stripped down version of System.Garlic.Remote in
--  the GLADE distribution.

package PolyORB.DSA_P.Remote_Launch is

   procedure Launch_Partition
     (Host     : String;
      Command  : String;
      Env_Vars : String);
   --  Launch a partition with Command on Host. This can be configured with
   --  parameters [dsa]rsh_command and [dsa]rsh_options. Env_Vars is a space-
   --  separated list of environment variables to pass from the current context
   --  to the remote partition.

end PolyORB.DSA_P.Remote_Launch;
