//
// MD2Engine.h
//
// $Id: //poco/1.3/Foundation/include/Poco/MD2Engine.h#2 $
//
// Library: Foundation
// Package: Crypt
// Module:  MD2Engine
//
// Definition of class MD2Engine.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//
//
// MD2 (RFC 1319) algorithm:
// Copyright (C) 1990-2, RSA Data Security, Inc. Created 1990. All
// rights reserved.
//
// License to copy and use this software is granted for
// non-commercial Internet Privacy-Enhanced Mail provided that it is
// identified as the "RSA Data Security, Inc. MD2 Message Digest
// Algorithm" in all material mentioning or referencing this software
// or this function.
//
// RSA Data Security, Inc. makes no representations concerning either
// the merchantability of this software or the suitability of this
// software for any particular purpose. It is provided "as is"
// without express or implied warranty of any kind.
//
// These notices must be retained in any copies of any part of this
// documentation and/or software.
//


#ifndef Foundation_MD2Engine_INCLUDED
#define Foundation_MD2Engine_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/DigestEngine.h"


namespace Poco {


class Foundation_API MD2Engine: public DigestEngine
	/// This class implementes the MD2 message digest algorithm,
	/// described in RFC 1319.
{
public:
	enum
	{
		BLOCK_SIZE  = 16,
		DIGEST_SIZE = 16
	};
	
	MD2Engine();
	~MD2Engine();
		
	unsigned digestLength() const;
	void reset();
	const DigestEngine::Digest& digest();

protected:
	void updateImpl(const void* data, unsigned length);

private:
	static void transform(unsigned char state[16], unsigned char checksum[16], const unsigned char block[16]);

	struct Context
	{
		unsigned char state[16];    // state
		unsigned char checksum[16]; // checksum
		unsigned int  count;        // number of bytes, modulo 16
		unsigned char buffer[16];   // input buffer
	};

	Context _context;
	DigestEngine::Digest _digest;

	MD2Engine(const MD2Engine&);
	MD2Engine& operator = (const MD2Engine&);
};


} // namespace Poco


#endif // Foundation_MD2Engine_INCLUDED
