/*
Copyright (c) 2008-2009 Jaagup Rep�n

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef PLASMA_TVPROGRAMME_H
#define PLASMA_TVPROGRAMME_H

#include "ui_tvprogrammeXmltvsConfig.h"
#include "ui_tvprogrammeChannelsConfig.h"
#include "ui_tvprogrammeAppearanceConfig.h"
#include <string>
#include <QStringList>
#include <QImage>
#include <QtXml>
#include <KIcon>
#include <KDialog>
#include <KConfig>
#include <Plasma/Applet>
#include <Plasma/Svg>
#include <Plasma/DataEngine>

typedef struct
{
	QString name;
	std::string time;
	int channel;
} Program;

typedef struct
{
	QString name;
	QString id;
	QList<Program> programs;
	QImage icon;
} Channel;

class PlasmaTvProgramme : public Plasma::Applet
{
    Q_OBJECT
    public:
        PlasmaTvProgramme(QObject *parent, const QVariantList &args);
        ~PlasmaTvProgramme();
        void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem*, const QRect& contentsRect);
        void init();
    protected slots:
        void configAccepted();
		void dataUpdated(QString, Plasma::DataEngine::Data) { update(); }
    protected:
		void reparse();
        void createConfigurationInterface(KConfigDialog *parent);
    private:
		QString text(int channel, int program, bool tryAgain = true);
		Ui::tvprogrammeXmltvsConfig uiXmltvs;
		Ui::tvprogrammeChannelsConfig uiChannels;
		Ui::tvprogrammeAppearanceConfig uiAppearance;
		QColor textColor;
		QColor titleColor;
		QColor gridColor;
		bool boldTitle;
		bool verticalGrid;
		bool horizontalGrid;
		bool showIcons;
		bool showAllChannels;
		QStringList xmltvs;
		QStringList channelsToShow;
		QList<Channel> channels;
		QMap<QString, QList<QString> > icons;
		QString dataDir;
};

K_EXPORT_PLASMA_APPLET(tvprogramme, PlasmaTvProgramme)

#endif
