# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python.

# Embedded icon is designed by Alexandre Moore (http://nuovext.pwsp.net/).

# Follows PEP8

import os

from core import config
from core import ct, models
from lib.reverse_translation import _t
from lib import system

COMMANDS = [
    'convert file_in.tif -bordercolor snow -background black '\
        + '+polaroid file_out.png',
    'convert -blur 0x5 file_in.tif file_out.png']

try:
    COMMANDS = [l.strip() for l in open(config.USER_GEEK_PATH).readlines()]
except IndexError:
    pass


class Action(models.Action):
    """Defined variables: <filename> <type> <folder> <width> <height>"""

    label = _t('Geek')
    author = 'Stani'
    email = 'spe.stani.be@gmail.com'
    version = '0.1'
    tags = [_t('plugin')]
    __doc__ = _t('Execute external command')

    def init(self):
        command = self.get_field_string('Command')
        exe = command
        #check if exists
        if not os.path.isfile(exe):
            exe = system.find_exe(exe, raise_exception=True)

    def get_relevant_field_labels(self):
        field = self._get_field('Command')
        #for validation on user input
        field.needs_exe = self.is_field_true('Verify Program')
        field.needs_in = self.is_field_true('Verify Input')
        field.needs_out = self.is_field_true('Verify Output')
        self.valid_last = self.is_field_true('Allow as last action')
        return ['Command', 'Verify Program', 'Verify Input',
            'Verify Output', 'Allow as last action']

    def interface(self, fields):
        fields[_t('Command')] = \
            self.CommandLineField(choices=COMMANDS)
        fields[_t('Verify Program')] = self.BooleanField(True)
        fields[_t('Verify Input')] = self.BooleanField(True)
        fields[_t('Verify Output')] = self.BooleanField(True)
        fields[_t('Allow as last action')] = self.BooleanField(False)

    def apply(self, photo, setting, cache):
        info = photo.info
        command = self.get_field('Command', info)
        photo.call(command)
        return photo

    def is_overwrite_existing_images_forced(self):
        return False

    icon = \
'x\xda\x01\'\t\xd8\xf6\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x08\xdeIDATh\x81\xedY[l\x14\xd7\x19\xfe\xfes\xce\xcc\
\xac\xbd6\xeb\x1b\x06\x1b\xb0+\x01\x0e\xc2\xa0\x12c\xb0\xebT\xa2\x8a\x9a\x88\
\xd6\xa2\xe1\xa9QT\xf5\xadR%\xde\xaaJ}I[Uj\xaa\x8a\xa7J}\xa1j\xa5\x80,\xf1\
\x02i\x15#\xd2\xa6\x105P\x95&\x94\x00-\xa0\xaa)\x11\xc5\xb1\xa3\xac1\xb6Yg\
\xef;\xe7\x9c>\xcc}vvm\x12\x05Z\x89#\x8dfv\xce\x9c3\xdf\xf7\xff\xdf\x7f\x19\
\x9b\xb4\xd6\xf8\x7f\x1e\xecq\x03\xf8\xac\xe3\t\x81\xc7=\x9e\x10x\xdc\xe3\t\
\x81\xc7=D\xfc\xc6\xd1_\x1c\xb3J\xf9\xd2\x84\xd6\xba\xfbq\x00j2l\xce\xd9\xdf\
\x7f\xfc\xf2\xf7\xee\x86oR\xb8\x90\xbd\xf2\xf3_v\xa6,\xeb\x8d]\xc3\xdb\xbf\
\xb4n];\xd2\xe94\n\x85<\xd2\xe96\x94JE\x98\xa6\x05\xd34\x1f5p\xd4jU<x\x90\
\xc3\xec\\\xb6|\xe7?3\xdf\xf9\xc9\x8f\xbe\x7f\xd2\x9b\x8bH\xc8\xae\xd5\x9e\
\x1f\x1e\x1e\x1aOY&\xa4\x94X\\\xbc\x0f\xc1\x05\xb2\xd9\x8f!m\x89\x95\x95\x1c\
\x88\xe8\x91\x1f\xb9\x079\x08!\xb0\xe3\xa9\xad\xa9\xae\xce\xce\x1f\x841G$DD}\
\xe9\xd6\x16\xd2Z\xa1X,"\x9dNciy\x19\xe9t\x1a\xf9B\x01\x96e\xa1T*}\xbe\xe6N\
\x18\xc4\x18\x8a\xc5"L\xd3D:\xdd\xd2\x17\x9e\x8b\xc6\x00\x01\xc5b\x19\n\x1c5\
\x9b\xa3\xfc\xa0\x0c@\xa0\x92\xab\x00\xe0(\xd7l\xe4\xf2\x0f\x1e!\xf4\x104&\
\xb0\x92/C\xaah\xef\x16\xf5\x00\x08+\x85*\x94&L\x1d\xff\x15\xe6\xb3\x1f!\xb9\
\xd7{\xb4\r \xe7\x1c\x87^x\x11\xc3\xbb\xbf\x08)\x9b\x100\xad\x14\x00\x8e\x99\
\xbb\xb7\xf1\xd6\xb9\xb3\xd0\xd0.V\xed\x13\t\x82^\xc7~\x07\xe3\xf3\xe8p\xb9\
\x10\x18\xde\xbd\x07\xc2\xb0"\xf7#\x04\x84a\x80q\x0e)%\x0c\xd3\xf0\r\xed\x01\
J$TwO{?\x11\'\x19&\x16\xdc\x0b\x9ek6j\xd5\x1a\x18c`,Z\xba"\x04\x18\x11\x18#0\
\xc6`\x18f\x00,\x04( \xe3\xbf\xbd9@\x9f\xa0w/\xd8\xefa\xc8{\xe0\x9b\x12 \xff\
!\x0e\xd30}\xbbx/\x0e\xb0\x04D\xc2\xe0t\\V\x89\xe0b\xa4\x9b\x18"L^\x08\x0e\
\xc6\x18\x88\xa81\x01\x8f!\xe7\x0c\x86W\xb0\xb4\x86\x10\x02\x96e!\x9f/@G\xc0\
\xfb\x90\x03r\r@\xe8\xa4g\x10\xda\'B(j$\r\x80\x0b\xc3!\xd0TB\x8c\x81\x88\x81\
\x11\x87iZ\xfe\x06\xbd\xbd\xeb\xf1\xb3W~\x8ak\xd7\xae\xe1\x8d\xdf\xff\x01\
\xb3\xb3\xb3\x90\xb6\x8c\x82\n\x13\xf3\x08\xc4,\x1f\x07\x1f\xe4\x83\xb8!\xa2\
g\xc7\x03\xc2\xc5\xd64\x06\\\tq7\x06\xdc\xd5\x86a\xa2\xbb\xbb\x0b\x87\x0f\
\xbf\x80\xc9\xc9\xaf\xe3\xc6\xcd[x\xf3\xcd?\xe2\x9dw\xde\x85\x942bq$\x00\xab\
\x9f\x8b>\x13\x10\xaa\x97\xa0GM\xac\xd5\x03^\x10\x07=\x8f\x86i\x98\x00\xc8%c\
`\xef\xc8\xd3\xd8;2\x82\xfb\xf7\xef\xe3\xfc\xf9\xb7p\xe1\xe2\x9f\x91\xcdf\
\x9b\x00p\x01\xfb\x96\xf6\xaeC\x99(I\x8e!RB\x08\x1f[\x13\x02\x1c\xc48\x18w$\
\xe4\xbd\xbeZ\xab\xe1/\x97.al\xff>ttt\xf8\xc4zz\xba\xf1\xd2K/\xe2\xf0\xe1o\
\xe0\xda\xf5\x7f\xe0\xfc\xb9\xf3x\xff\xdf\xb7Q\xadVbZ\x8e\x9d=\x02\x91l\x13\
\x9d\x0b\x1bBk\r!\x0c\x07[\xd3,D\xe4\xca(J\xc0\xb6%~\xfd\x9bWq\xfc\xd5\xe3\
\x18\x19\xd9\x83C\x87\x0ea\xc7\x8e\x1d~Fhii\xc13\x13\xe3\x98\x98\x18\xc7\xcc\
\xcc\x87\xf8\xed\xef^\xc7\x95+\xef\xd5\xeb>\x9e:\xebRlR\x06r\x88\na8\xd8\x9a\
\xc6\x00w\x18r\xc6`Zf\xc4\x12^V\xfa\xe7\xbf>\xc0\xa5\xbf\xfe\x10==]x\xfe\xb9\
\xaf\xe2\xc0\x81\x03\xd8\xb8q\xa3\xaf\xe9\x81-\x03\xd8=\xbc\x13\xd7\xaf]\x07\
c<18=P\x91`m@\xd4\x9b3\x0cOBM\xd2(\x85\x8a\x85i\x9a\x89YBk\x13}\xfd-\x10\x82\
\xe3\xfd\xdbw\xb0qc\x1f\xd6\xaf\xef\x05\xb9\x96\xd1\x1a\x90RB\x18&\xf6\xef\
\xdb\x87L&\x03\xadU\x00\n\xc0\x8d\x1b7\xb0\xb8\xb8\xe8\x00lP\x17\x02\xcf\x85\
<\xc0\x18\x88\xf1&\x1e \'\xca\xbd\x18H\xd2c[[\x1b\xc6\xf6\x8fb\xdf\xbe\xbd\
\xd8\xbc\xa9\x1fRJ(\x15\xed\x95\xe6\xe7\xe7aY)\x1c\xfc\xdaA\x0cl\xd9\xe2\x80\
\xd7\x81\xd5\xef\xde\xbd\x8bO>\xc9G\x80\x06\xb6\x8a\'\x02Gj\xc2\x10\xbe\x81\
\x1b\x13`\x8e\xc68\xe3\xb0\xacT\xa8\x8c\x13\x86\x86\x860>6\x8a]\xbbvBk\r\xbb\
f\xa3Z\xb3}\r;\x19\xe9\x1c\xce\x9c\x99F\xa9\\\xc5\xb6\xedO9\xcf\xd9\xb6K \
\xc8\xfd\xd2\xb6\xdd\x18\xf3\xeaEB\xd1\x8b\x90\x01\x840\xd7\x10\x03\xae\xc6\
\x1c\x0f\x98\xfe\xe2\x8e\x8e\x0c\xbe\xfd\xadoB\x18\x06j\xd5\x9a\x9fajv\r\x1f\
\xdc\xbe\x8d\xe9\xe9\xd7\xf1\xee\xe5\xbfa\xdd\xbaNl\x1e\xd8\xe6\xaf\xbdwo\
\x01\xe5r\xd9\x97\x8ar\xd3e\xb9\\\x0e\x92DBSW\'+\xad\xdd\x18X\xd5\x03\x1c\
\x8cqp\xc6|\x0fhhX\x96\x05[*0\xe6h\xb9Z\xab\xe2\xe2\x85\x0bx\xed\xb5\xd3X\
\xb8\xbf\x84\xcd\x9b\x07\xf1\xf4\xc8\x18\x88(\x92\x0e\xa7\xa6\xa6po>\xeb\xef\
\xefY6\x93\xe9D_\xdf\xa6\x84&\xb0\xbe\xd0y\x18\xd6\\\xc8\xc8k\xe6B\x122M\x0b\
\xd0\xc0\xec\xec\x87\x98\x9e>\x83?\xbd\xfd6\xda\xda2\xd8\xb6}\x07\xb6n\x0fI\
\xc1\xb5\xa1w\xdd\xbfi\x00\xfd\x9b\x06\x10\xeduB\xa0c\x19(\xa8\x7f\xd1\xac\
\xa5\xa1a\x18\xc6\xea1\xe0g!\xc1aY\x010\r\xe0\xe8\xd1\xa3\xb8q\xf3&\x06\xbe\
\xb0\x15\x13_~\x16B\x18Hry\xd8r>\xb0&\xd2\x887vI\x1e\x80v\x08\xac*!\xeeu\xa3\
1\t)\r\xa43=x\xf6\xb9IxY8\x11\xb4\xdb6$\xa6\xc7\xc8\xb9\xd1\\\x08|\x8c\x98\'\
\xa1U<@N\xc7\xc78L\xd7\x03^.\xb6L+\xe4\xd2\x84\x17%T\xd2\xb0\x17\x1a\x01N\
\xfaDM\x0eb\xd3\xc5\xb6j\x10;i4e\xa5\xea\x8aJ\xa4.\xa0\xfeE\x81\xe5\xe3k\x02\
\xef4%\x1dZ\xab\x83\x85.\x815x\xc0\xffl\xe3\x0cV*\x95\xfc\x82\xba\x9c\x1d\
\xd7\xbbw\xf6\\\x95\xdc6$\xee\x19o%B{\x1a\xa6\xe9\x7f\xaf4&@\xde\x17\x99W\
\xc8|\xa8\xbe\x94\xe2:\x8d\xc8)!{4\xba\x1f\x90\x8bW\xe3\xf03\xc1z\xc30}\xe36\
$@n\xa3DD\xa1BV\x1f`\xf5\xcdW\xb2n#^\x89\x90O\x0e\xdeH\xf0\xc7\xc8r\xe1@%4i\
\xe6\x94\x945\xad\x142\x99N\xc7m\xc2\x08\xac\x93\x98\xc7W\xcf&\xf5y^\xd7\xef\
\x99\x98r\x03RJ+tvt9\x18\x95\xb4\x1b\x12\xd0\xd0W\x96\x97\x17K=\xeb7\xb4L<\
\xf3\x15\x14\xf2y|\xda\x11\xfa\xf6\xfa\xcc\x831\x86\xae\xae\x1e\x94JE\x14\
\x8b\x85\x8b\xe1\xb9\x08\x81\xbe\r\xeb\xdf\x9b_X\xfan\xa5R9b\x9afw\xc4]Q\xcf\
}\xfa\xb1\xea>q\x91\x00R)d?\xfe\xc8\xaeT*\x97\xb5R/G\x9e^\xcb\x9f\x01O\x9e<I\
W\xaf^\xa5l6\x8b\x85\x85\x05*\x95J\x94\xcf\xe7\xa9Z\xad\xa2R\xa90\xdb\xb6\
\xa1\x94")%\x01\xbe$\xfc\xbd\x89H\xbbg\x10\x118\xe7\x9as\xae\x85\x10\xda4M\
\xdd\xd2\xd2\xa2\xdb\xdb\xdbukk+\xba\xbb\xbb\xf5\xd0\xd0\x90>x\xf0\xa0\x1e\
\x1d\x1d]\xdd\x1e\xdeKN\x9f>Mg\xcf\x9e\xa5;w\xee\xb0\xc5\xc5EZYY\x11\x95J\
\x85\xdb\xb6\xcd\x94R\\)\xc5\xb4\xd6Lk\xcd\x95R\x0c\xce\xff\x16X\xf8\x1a\x81\
}\xc3\xd7\xde\xd0\x00\x94{\xad\xbc\xdf\x8c1\x05@\x11\x91""ID\x8a1\xa6\x88Hr\
\xce\xa5a\x18\xca\xb2,\xd9\xd9\xd9)7l\xd8\xa0\xc6\xc7\xc7\xd5\xe4\xe4\xa4\
\x1e\x1b\x1bs\x08\x9c:u\x8a\x8e\x1d;\xc6\xe6\xe6\xe6\xf8\xca\xca\x8a\xa8\xd5\
j\xdc\xb6m\xae\x94\x12.p\x0e\x80k\xad\xb9\xd6\x9a\x03\x10\xa1\xeb\xf8\xc1\
\x000w>L"\x0cV\xba\x04d\xe8\xb0]\x026\x00ID\xb6KF\x12\x91d\x8cI\xce\xb9-\x84\
\x90\xa9TJvtt\xd8\xa3\xa3\xa3\xf2\xc4\x89\x13J\xec\xdc\xb9So\xd9\xb2E\xe7r9U\
*\x95\x94R\x8a\x94R\xa4\xb5VDD\x8c1RJ\x91\x0b\x86\\k\x85\xa5\xe2\x01\xd4\x1e\
\x01\x17LdM\xc8\x03*D@\xb9\x80\x15\x11\xc9\x90\'4\x00\xed^+\xcf+B\x08eY\x96\
\xea\xe9\xe9Q{\xf6\xec\x89\xea\xd4\x1bSSS4==Msss,\x97\xcb\xb1B\xa1\xc0j\xb5\
\x1a\xb3m\x9bI)\x99\x94\x92\xbbR\n\x1f\x1eP\xaf\xca4\nU\x1d><\xb01\xd9(\xefH\
\xa5R\xb2\xb5\xb5U\xf5\xf6\xf6\xaa\xb1\xb11u\xe4\xc8\x11=88\x18\xd9pMA\xec\
\x8d\xcb\x97/\xe3\xd6\xad[\xb4\xbc\xbc\x8cr\xb9\x8c\x99\x99\x19*\x95J\x90Rbi\
i\x89\x9c\xcfG\x8dB\xa1@\x00\xa0\x94\xf2\x03\xd7\xfd\xfb\xaa\x16B\xc04M\xb4\
\xb7\xb7k\xcb\xb2\xd0\xde\xde\x8e\xfe\xfe~\x9d\xc9d088\x88\xc9\xc9\xc9\x87\
\xca\xbf\x0fE\xe0\x7fq\xfc\x17\xb0\xba\x93\x04U\x8fD3\x00\x00\x00\x00IEND\
\xaeB`\x82\xca\xb1[\xfc'
