############## mysql-test\t\max_heap_table_size_basic.test ###############
#                                                                             #
# Variable Name: max_heap_table_size                                          #
# Scope: GLOBAL | SESSION                                                     #
# Access Type: Dynamic                                                        #
# Data Type: numeric                                                          #
# Default Value:  16777216                                                    #
# Range:  16384-4294967295                                                    #
#                                                                             #
#                                                                             #
# Creation Date: 2008-02-07                                                   #
# Author:  Salman                                                             #
#                                                                             #
# Description: Test Cases of Dynamic System Variable max_heap_table_size      #
#              that checks the behavior of this variable in the following ways#
#              * Default Value                                                #
#              * Valid & Invalid values                                       #
#              * Scope & Access method                                        #
#              * Data Integrity                                               #
#                                                                             #
# Reference: http://dev.mysql.com/doc/refman/5.1/en/                          #
#  server-system-variables.html                                               #
#                                                                             #
###############################################################################

--source include/load_sysvars.inc

###############################################################
#           START OF max_heap_table_size TESTS                #
###############################################################


#############################################################
#                 Save initial value                        #
#############################################################

SET @start_global_value = @@global.max_heap_table_size;
SELECT @start_global_value;
SET @start_session_value = @@session.max_heap_table_size;
SELECT @start_session_value;


--echo '#--------------------FN_DYNVARS_077_01-------------------------#'
###############################################################
#     Display the DEFAULT value of max_heap_table_size        #
###############################################################

SET @@global.max_heap_table_size = 1677721610;
SET @@global.max_heap_table_size = DEFAULT;
SELECT @@global.max_heap_table_size;

SET @@session.max_heap_table_size = 1677721610;
SET @@session.max_heap_table_size = DEFAULT;
SELECT @@session.max_heap_table_size;


--echo '#--------------------FN_DYNVARS_077_02-------------------------#'
##################################################################
#     Check the DEFAULT value of max_heap_table_size             #
##################################################################

SET @@global.max_heap_table_size = DEFAULT;
SELECT @@global.max_heap_table_size = 16777216;

SET @@session.max_heap_table_size = DEFAULT;
SELECT @@session.max_heap_table_size = 16777216;


--echo '#--------------------FN_DYNVARS_077_03-------------------------#'
############################################################################
# Change the value of max_heap_table_size to a valid value for GLOBAL Scope #
############################################################################

SET @@global.max_heap_table_size = 16384;
SELECT @@global.max_heap_table_size;
SET @@global.max_heap_table_size = 16385;
SELECT @@global.max_heap_table_size;
SET @@global.max_heap_table_size = 65535;
SELECT @@global.max_heap_table_size;
SET @@global.max_heap_table_size = 4294967294;
SELECT @@global.max_heap_table_size;
SET @@global.max_heap_table_size = 4294967295;
SELECT @@global.max_heap_table_size;
--echo 'Bug# 34877: Invalid Values are coming in variable on assigning valid values';


--echo '#--------------------FN_DYNVARS_077_04-------------------------#'
#############################################################################
# Change the value of max_heap_table_size to a valid value for SESSION Scope #
#############################################################################
 
SET @@session.max_heap_table_size = 16384;
SELECT @@session.max_heap_table_size;
SET @@session.max_heap_table_size = 16385;
SELECT @@session.max_heap_table_size;
SET @@session.max_heap_table_size = 65535;
SELECT @@session.max_heap_table_size;
SET @@session.max_heap_table_size = 4294967294;
SELECT @@session.max_heap_table_size;
SET @@session.max_heap_table_size = 4294967295;
SELECT @@session.max_heap_table_size;
--echo 'Bug# 34877: Invalid Values are coming in variable on assigning valid values';


--echo '#------------------FN_DYNVARS_077_05-----------------------#'
##############################################################
# Change the value of max_heap_table_size to an invalid value #
##############################################################

SET @@global.max_heap_table_size = -1;
SELECT @@global.max_heap_table_size;
SET @@global.max_heap_table_size = -1024;
SELECT @@global.max_heap_table_size;
SET @@global.max_heap_table_size = 1024;
SELECT @@global.max_heap_table_size;
SET @@global.max_heap_table_size = 16383;
SELECT @@global.max_heap_table_size;
SET @@global.max_heap_table_size = 4294967296;
SELECT @@global.max_heap_table_size;
--Error ER_PARSE_ERROR
SET @@global.max_heap_table_size = 65530.34.;
SELECT @@global.max_heap_table_size;
--Error ER_WRONG_TYPE_FOR_VAR
SET @@global.max_heap_table_size = test;
SELECT @@global.max_heap_table_size;

SET @@session.max_heap_table_size = -1;
SELECT @@session.max_heap_table_size;
SET @@session.max_heap_table_size = 16383;
SELECT @@session.max_heap_table_size;
SET @@session.max_heap_table_size = 4294967296;
SELECT @@session.max_heap_table_size;
--Error ER_PARSE_ERROR
SET @@session.max_heap_table_size = 65530.34.;
SET @@session.max_heap_table_size = 10737418241;
SELECT @@session.max_heap_table_size;
--echo 'Bug # 34837: Errors are not coming on assigning invalid values to variable';

--Error ER_WRONG_TYPE_FOR_VAR
SET @@session.max_heap_table_size = test;
SELECT @@session.max_heap_table_size;


--echo '#------------------FN_DYNVARS_077_06-----------------------#'
####################################################################
#   Check if the value in GLOBAL Table matches value in variable   #
####################################################################


SELECT @@global.max_heap_table_size = VARIABLE_VALUE 
FROM INFORMATION_SCHEMA.GLOBAL_VARIABLES 
WHERE VARIABLE_NAME='max_heap_table_size';

--echo '#------------------FN_DYNVARS_077_07-----------------------#'
####################################################################
#  Check if the value in SESSION Table matches value in variable   #
####################################################################

SELECT @@session.max_heap_table_size = VARIABLE_VALUE 
FROM INFORMATION_SCHEMA.SESSION_VARIABLES 
WHERE VARIABLE_NAME='max_heap_table_size';


--echo '#------------------FN_DYNVARS_077_08-----------------------#'
####################################################################
#     Check if TRUE and FALSE values can be used on variable       #
####################################################################

SET @@global.max_heap_table_size = TRUE;
SELECT @@global.max_heap_table_size;
SET @@global.max_heap_table_size = FALSE;
SELECT @@global.max_heap_table_size;


--echo '#---------------------FN_DYNVARS_077_09----------------------#'
#################################################################################
#  Check if accessing variable with and without GLOBAL point to same variable   #
#################################################################################

SET @@global.max_heap_table_size = 163845;
SELECT @@max_heap_table_size = @@global.max_heap_table_size;


--echo '#---------------------FN_DYNVARS_077_10----------------------#'
########################################################################################################
#    Check if accessing variable with SESSION,LOCAL and without SCOPE points to same session variable  #
########################################################################################################

SET @@max_heap_table_size = 16777216;
SELECT @@max_heap_table_size = @@local.max_heap_table_size;
SELECT @@local.max_heap_table_size = @@session.max_heap_table_size;


--echo '#---------------------FN_DYNVARS_077_11----------------------#'
#############################################################################
#   Check if max_heap_table_size can be accessed with and without @@ sign    #
#############################################################################

SET max_heap_table_size = 316777216;
SELECT @@max_heap_table_size;
--Error ER_UNKNOWN_TABLE
SELECT local.max_heap_table_size;
--Error ER_UNKNOWN_TABLE
SELECT session.max_heap_table_size;
--Error ER_BAD_FIELD_ERROR
SELECT max_heap_table_size = @@session.max_heap_table_size;


####################################
#     Restore initial value        #
####################################

SET @@global.max_heap_table_size = @start_global_value;
SELECT @@global.max_heap_table_size;
SET @@session.max_heap_table_size = @start_session_value;
SELECT @@session.max_heap_table_size;


#######################################################
#                 END OF max_heap_table_size TESTS     #
#######################################################

