/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PlotInfoAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: PlotInfoAttributes::PlotInfoAttributes
//
// Purpose: 
//   Init utility for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PlotInfoAttributes::Init()
{

    PlotInfoAttributes::SelectAll();
}

// ****************************************************************************
// Method: PlotInfoAttributes::PlotInfoAttributes
//
// Purpose: 
//   Copy utility for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PlotInfoAttributes::Copy(const PlotInfoAttributes &obj)
{
    data = obj.data;

    PlotInfoAttributes::SelectAll();
}

// Type map format string
const char *PlotInfoAttributes::TypeMapFormatString = PLOTINFOATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t PlotInfoAttributes::TmfsStruct = {PLOTINFOATTRIBUTES_TMFS};


// ****************************************************************************
// Method: PlotInfoAttributes::PlotInfoAttributes
//
// Purpose: 
//   Default constructor for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotInfoAttributes::PlotInfoAttributes() : 
    AttributeSubject(PlotInfoAttributes::TypeMapFormatString)
{
    PlotInfoAttributes::Init();
}

// ****************************************************************************
// Method: PlotInfoAttributes::PlotInfoAttributes
//
// Purpose: 
//   Constructor for the derived classes of PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotInfoAttributes::PlotInfoAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PlotInfoAttributes::Init();
}

// ****************************************************************************
// Method: PlotInfoAttributes::PlotInfoAttributes
//
// Purpose: 
//   Copy constructor for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotInfoAttributes::PlotInfoAttributes(const PlotInfoAttributes &obj) : 
    AttributeSubject(PlotInfoAttributes::TypeMapFormatString)
{
    PlotInfoAttributes::Copy(obj);
}

// ****************************************************************************
// Method: PlotInfoAttributes::PlotInfoAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotInfoAttributes::PlotInfoAttributes(const PlotInfoAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PlotInfoAttributes::Copy(obj);
}

// ****************************************************************************
// Method: PlotInfoAttributes::~PlotInfoAttributes
//
// Purpose: 
//   Destructor for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotInfoAttributes::~PlotInfoAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: PlotInfoAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PlotInfoAttributes& 
PlotInfoAttributes::operator = (const PlotInfoAttributes &obj)
{
    if (this == &obj) return *this;

    PlotInfoAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: PlotInfoAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotInfoAttributes::operator == (const PlotInfoAttributes &obj) const
{
    // Create the return value
    return ((data == obj.data));
}

// ****************************************************************************
// Method: PlotInfoAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotInfoAttributes::operator != (const PlotInfoAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PlotInfoAttributes::TypeName
//
// Purpose: 
//   Type name method for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
PlotInfoAttributes::TypeName() const
{
    return "PlotInfoAttributes";
}

// ****************************************************************************
// Method: PlotInfoAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotInfoAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PlotInfoAttributes *tmp = (const PlotInfoAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PlotInfoAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PlotInfoAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PlotInfoAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PlotInfoAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the PlotInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PlotInfoAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PlotInfoAttributes(*this);
    else
        retval = new PlotInfoAttributes;

    return retval;
}

// ****************************************************************************
// Method: PlotInfoAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PlotInfoAttributes::SelectAll()
{
    Select(ID_data, (void *)&data);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
PlotInfoAttributes::SetData(const MapNode &data_)
{
    data = data_;
    Select(ID_data, (void *)&data);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const MapNode &
PlotInfoAttributes::GetData() const
{
    return data;
}

MapNode &
PlotInfoAttributes::GetData()
{
    return data;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
PlotInfoAttributes::SelectData()
{
    Select(ID_data, (void *)&data);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PlotInfoAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PlotInfoAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_data: return "data";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PlotInfoAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PlotInfoAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_data: return FieldType_MapNode;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PlotInfoAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PlotInfoAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_data: return "MapNode";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PlotInfoAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PlotInfoAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const PlotInfoAttributes &obj = *((const PlotInfoAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_data:
        {  // new scope
        retval = (data == obj.data);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
PlotInfoAttributes::PrintSelf(ostream &os)
{
    os << "Data:\n" ;
    os << data.ToXML(); 
}

void
PlotInfoAttributes::Reset()
{
    data.Reset();
    SelectData();
}

void
PlotInfoAttributes::Merge(const PlotInfoAttributes &obj)
{
    data.Merge(obj.GetData());
    SelectData();
}

