/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SILArrayAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SILArrayAttributes::SILArrayAttributes
//
// Purpose: 
//   Init utility for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SILArrayAttributes::Init()
{
    numSets = 0;
    firstSetName = 0;
    useUniqueIDs = false;
    firstSet = 0;
    colIndex = 0;
    role = 0;
    colParent = 0;

    SILArrayAttributes::SelectAll();
}

// ****************************************************************************
// Method: SILArrayAttributes::SILArrayAttributes
//
// Purpose: 
//   Copy utility for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SILArrayAttributes::Copy(const SILArrayAttributes &obj)
{
    prefix = obj.prefix;
    numSets = obj.numSets;
    firstSetName = obj.firstSetName;
    useUniqueIDs = obj.useUniqueIDs;
    firstSet = obj.firstSet;
    colIndex = obj.colIndex;
    category = obj.category;
    role = obj.role;
    colParent = obj.colParent;
    names = obj.names;
    namescheme = obj.namescheme;

    SILArrayAttributes::SelectAll();
}

// Type map format string
const char *SILArrayAttributes::TypeMapFormatString = SILARRAYATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t SILArrayAttributes::TmfsStruct = {SILARRAYATTRIBUTES_TMFS};


// ****************************************************************************
// Method: SILArrayAttributes::SILArrayAttributes
//
// Purpose: 
//   Default constructor for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILArrayAttributes::SILArrayAttributes() : 
    AttributeSubject(SILArrayAttributes::TypeMapFormatString)
{
    SILArrayAttributes::Init();
}

// ****************************************************************************
// Method: SILArrayAttributes::SILArrayAttributes
//
// Purpose: 
//   Constructor for the derived classes of SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILArrayAttributes::SILArrayAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SILArrayAttributes::Init();
}

// ****************************************************************************
// Method: SILArrayAttributes::SILArrayAttributes
//
// Purpose: 
//   Copy constructor for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILArrayAttributes::SILArrayAttributes(const SILArrayAttributes &obj) : 
    AttributeSubject(SILArrayAttributes::TypeMapFormatString)
{
    SILArrayAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SILArrayAttributes::SILArrayAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILArrayAttributes::SILArrayAttributes(const SILArrayAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SILArrayAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SILArrayAttributes::~SILArrayAttributes
//
// Purpose: 
//   Destructor for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILArrayAttributes::~SILArrayAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SILArrayAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILArrayAttributes& 
SILArrayAttributes::operator = (const SILArrayAttributes &obj)
{
    if (this == &obj) return *this;

    SILArrayAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SILArrayAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILArrayAttributes::operator == (const SILArrayAttributes &obj) const
{
    // Create the return value
    return ((prefix == obj.prefix) &&
            (numSets == obj.numSets) &&
            (firstSetName == obj.firstSetName) &&
            (useUniqueIDs == obj.useUniqueIDs) &&
            (firstSet == obj.firstSet) &&
            (colIndex == obj.colIndex) &&
            (category == obj.category) &&
            (role == obj.role) &&
            (colParent == obj.colParent) &&
            (names == obj.names) &&
            (namescheme == obj.namescheme));
}

// ****************************************************************************
// Method: SILArrayAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILArrayAttributes::operator != (const SILArrayAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SILArrayAttributes::TypeName
//
// Purpose: 
//   Type name method for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SILArrayAttributes::TypeName() const
{
    return "SILArrayAttributes";
}

// ****************************************************************************
// Method: SILArrayAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILArrayAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SILArrayAttributes *tmp = (const SILArrayAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SILArrayAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SILArrayAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SILArrayAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SILArrayAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SILArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SILArrayAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SILArrayAttributes(*this);
    else
        retval = new SILArrayAttributes;

    return retval;
}

// ****************************************************************************
// Method: SILArrayAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILArrayAttributes::SelectAll()
{
    Select(ID_prefix,       (void *)&prefix);
    Select(ID_numSets,      (void *)&numSets);
    Select(ID_firstSetName, (void *)&firstSetName);
    Select(ID_useUniqueIDs, (void *)&useUniqueIDs);
    Select(ID_firstSet,     (void *)&firstSet);
    Select(ID_colIndex,     (void *)&colIndex);
    Select(ID_category,     (void *)&category);
    Select(ID_role,         (void *)&role);
    Select(ID_colParent,    (void *)&colParent);
    Select(ID_names,        (void *)&names);
    Select(ID_namescheme,   (void *)&namescheme);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SILArrayAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILArrayAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SILArrayAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SILArrayAttributes.
    DataNode *node = new DataNode("SILArrayAttributes");

    if(completeSave || !FieldsEqual(ID_prefix, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("prefix", prefix));
    }

    if(completeSave || !FieldsEqual(ID_numSets, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numSets", numSets));
    }

    if(completeSave || !FieldsEqual(ID_firstSetName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("firstSetName", firstSetName));
    }

    if(completeSave || !FieldsEqual(ID_useUniqueIDs, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useUniqueIDs", useUniqueIDs));
    }

    if(completeSave || !FieldsEqual(ID_firstSet, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("firstSet", firstSet));
    }

    if(completeSave || !FieldsEqual(ID_colIndex, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colIndex", colIndex));
    }

    if(completeSave || !FieldsEqual(ID_category, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("category", category));
    }

    if(completeSave || !FieldsEqual(ID_role, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("role", role));
    }

    if(completeSave || !FieldsEqual(ID_colParent, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colParent", colParent));
    }

    if(completeSave || !FieldsEqual(ID_names, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("names", names));
    }

    if(completeSave || !FieldsEqual(ID_namescheme, &defaultObject))
    {
        DataNode *nameschemeNode = new DataNode("namescheme");
        if(namescheme.CreateNode(nameschemeNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(nameschemeNode);
        }
        else
            delete nameschemeNode;
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SILArrayAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILArrayAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SILArrayAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("prefix")) != 0)
        SetPrefix(node->AsString());
    if((node = searchNode->GetNode("numSets")) != 0)
        SetNumSets(node->AsInt());
    if((node = searchNode->GetNode("firstSetName")) != 0)
        SetFirstSetName(node->AsInt());
    if((node = searchNode->GetNode("useUniqueIDs")) != 0)
        SetUseUniqueIDs(node->AsBool());
    if((node = searchNode->GetNode("firstSet")) != 0)
        SetFirstSet(node->AsInt());
    if((node = searchNode->GetNode("colIndex")) != 0)
        SetColIndex(node->AsInt());
    if((node = searchNode->GetNode("category")) != 0)
        SetCategory(node->AsString());
    if((node = searchNode->GetNode("role")) != 0)
        SetRole(node->AsInt());
    if((node = searchNode->GetNode("colParent")) != 0)
        SetColParent(node->AsInt());
    if((node = searchNode->GetNode("names")) != 0)
        SetNames(node->AsStringVector());
    if((node = searchNode->GetNode("namescheme")) != 0)
        namescheme.SetFromNode(node);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SILArrayAttributes::SetPrefix(const std::string &prefix_)
{
    prefix = prefix_;
    Select(ID_prefix, (void *)&prefix);
}

void
SILArrayAttributes::SetNumSets(int numSets_)
{
    numSets = numSets_;
    Select(ID_numSets, (void *)&numSets);
}

void
SILArrayAttributes::SetFirstSetName(int firstSetName_)
{
    firstSetName = firstSetName_;
    Select(ID_firstSetName, (void *)&firstSetName);
}

void
SILArrayAttributes::SetUseUniqueIDs(bool useUniqueIDs_)
{
    useUniqueIDs = useUniqueIDs_;
    Select(ID_useUniqueIDs, (void *)&useUniqueIDs);
}

void
SILArrayAttributes::SetFirstSet(int firstSet_)
{
    firstSet = firstSet_;
    Select(ID_firstSet, (void *)&firstSet);
}

void
SILArrayAttributes::SetColIndex(int colIndex_)
{
    colIndex = colIndex_;
    Select(ID_colIndex, (void *)&colIndex);
}

void
SILArrayAttributes::SetCategory(const std::string &category_)
{
    category = category_;
    Select(ID_category, (void *)&category);
}

void
SILArrayAttributes::SetRole(int role_)
{
    role = role_;
    Select(ID_role, (void *)&role);
}

void
SILArrayAttributes::SetColParent(int colParent_)
{
    colParent = colParent_;
    Select(ID_colParent, (void *)&colParent);
}

void
SILArrayAttributes::SetNames(const stringVector &names_)
{
    names = names_;
    Select(ID_names, (void *)&names);
}

void
SILArrayAttributes::SetNamescheme(const NameschemeAttributes &namescheme_)
{
    namescheme = namescheme_;
    Select(ID_namescheme, (void *)&namescheme);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
SILArrayAttributes::GetPrefix() const
{
    return prefix;
}

std::string &
SILArrayAttributes::GetPrefix()
{
    return prefix;
}

int
SILArrayAttributes::GetNumSets() const
{
    return numSets;
}

int
SILArrayAttributes::GetFirstSetName() const
{
    return firstSetName;
}

bool
SILArrayAttributes::GetUseUniqueIDs() const
{
    return useUniqueIDs;
}

int
SILArrayAttributes::GetFirstSet() const
{
    return firstSet;
}

int
SILArrayAttributes::GetColIndex() const
{
    return colIndex;
}

const std::string &
SILArrayAttributes::GetCategory() const
{
    return category;
}

std::string &
SILArrayAttributes::GetCategory()
{
    return category;
}

int
SILArrayAttributes::GetRole() const
{
    return role;
}

int
SILArrayAttributes::GetColParent() const
{
    return colParent;
}

const stringVector &
SILArrayAttributes::GetNames() const
{
    return names;
}

stringVector &
SILArrayAttributes::GetNames()
{
    return names;
}

const NameschemeAttributes &
SILArrayAttributes::GetNamescheme() const
{
    return namescheme;
}

NameschemeAttributes &
SILArrayAttributes::GetNamescheme()
{
    return namescheme;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SILArrayAttributes::SelectPrefix()
{
    Select(ID_prefix, (void *)&prefix);
}

void
SILArrayAttributes::SelectCategory()
{
    Select(ID_category, (void *)&category);
}

void
SILArrayAttributes::SelectNames()
{
    Select(ID_names, (void *)&names);
}

void
SILArrayAttributes::SelectNamescheme()
{
    Select(ID_namescheme, (void *)&namescheme);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SILArrayAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SILArrayAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_prefix:       return "prefix";
    case ID_numSets:      return "numSets";
    case ID_firstSetName: return "firstSetName";
    case ID_useUniqueIDs: return "useUniqueIDs";
    case ID_firstSet:     return "firstSet";
    case ID_colIndex:     return "colIndex";
    case ID_category:     return "category";
    case ID_role:         return "role";
    case ID_colParent:    return "colParent";
    case ID_names:        return "names";
    case ID_namescheme:   return "namescheme";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SILArrayAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SILArrayAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_prefix:       return FieldType_string;
    case ID_numSets:      return FieldType_int;
    case ID_firstSetName: return FieldType_int;
    case ID_useUniqueIDs: return FieldType_bool;
    case ID_firstSet:     return FieldType_int;
    case ID_colIndex:     return FieldType_int;
    case ID_category:     return FieldType_string;
    case ID_role:         return FieldType_int;
    case ID_colParent:    return FieldType_int;
    case ID_names:        return FieldType_stringVector;
    case ID_namescheme:   return FieldType_att;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SILArrayAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SILArrayAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_prefix:       return "string";
    case ID_numSets:      return "int";
    case ID_firstSetName: return "int";
    case ID_useUniqueIDs: return "bool";
    case ID_firstSet:     return "int";
    case ID_colIndex:     return "int";
    case ID_category:     return "string";
    case ID_role:         return "int";
    case ID_colParent:    return "int";
    case ID_names:        return "stringVector";
    case ID_namescheme:   return "att";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SILArrayAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILArrayAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SILArrayAttributes &obj = *((const SILArrayAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_prefix:
        {  // new scope
        retval = (prefix == obj.prefix);
        }
        break;
    case ID_numSets:
        {  // new scope
        retval = (numSets == obj.numSets);
        }
        break;
    case ID_firstSetName:
        {  // new scope
        retval = (firstSetName == obj.firstSetName);
        }
        break;
    case ID_useUniqueIDs:
        {  // new scope
        retval = (useUniqueIDs == obj.useUniqueIDs);
        }
        break;
    case ID_firstSet:
        {  // new scope
        retval = (firstSet == obj.firstSet);
        }
        break;
    case ID_colIndex:
        {  // new scope
        retval = (colIndex == obj.colIndex);
        }
        break;
    case ID_category:
        {  // new scope
        retval = (category == obj.category);
        }
        break;
    case ID_role:
        {  // new scope
        retval = (role == obj.role);
        }
        break;
    case ID_colParent:
        {  // new scope
        retval = (colParent == obj.colParent);
        }
        break;
    case ID_names:
        {  // new scope
        retval = (names == obj.names);
        }
        break;
    case ID_namescheme:
        {  // new scope
        retval = (namescheme == obj.namescheme);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

