###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openoffice_rtl_allocateMemory_bof_vuln_lin.nasl 0295 2008-10-01 11:35:10:16Z oct $
#
# OpenOffice rtl_allocateMemory Heap Based BOF Vulnerability (Linux)
#
# Authors:      Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800010);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-2152");
  script_bugtraq_id(29622);
  script_xref(name:"CB-A", value:"08-0095");
  script_name("OpenOffice rtl_allocateMemory Heap Based BOF Vulnerability (Linux)");
  desc = "

  Overview : The host has OpenOffice installed which is prone to heap based
  buffer overflow vulnerability.

  Vulnerability Insight:
  The flaw is in alloc_global.c file in which rtl_allocateMemory function
  rounding up allocation requests to be aligned on a 8 byte boundary without
  checking the rounding results in an integer overflow condition.

  Impact:
  Exploitation will result in buffer overflows via a specially crafted document
  and allow remote unprivileged user who provides a OpenOffice.org document that
  is opened by a local user to execute arbitrary commands on the system with the
  privileges of the user running OpenOffice.org.

  Impact Level : System

  Affected Software/OS:
  OpenOffice.org 2.x on Linux (Any).

  Fix : Upgrade to OpenOffice 2.4.1
  http://download.openoffice.org/index.html

  References:
  http://secunia.com/advisories/30599
  http://www.openoffice.org/security/cves/CVE-2008-2152.html
  http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=714

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/uname");
  exit(0);
}


if("Linux" >!< get_kb_item("ssh/login/uname")){
  exit(0);
}

release = get_kb_item("ssh/login/release");
foreach item (get_kb_list("ssh/*/rpms"))
{
  # Exit if advisory based local check is available as they perform complete
  # rpm package comparision.
  # FixMe: Advisory local check is yet to be released for Fedora
  if((release =~ "FC(7|8|9)") && (item =~ "(O|o)pen(O|o)ffice.*")){
    report = string("Fedora advisory based local check is available to " +
                    "verify if the package is\nup-to-date as per the vendor " +
                    "advisory.\nPlease run the Fedora Local Checks to confirm.");
    security_note(data:report);
    exit(0);
  }

  if(egrep(pattern:"^(O|o)pen(O|o)ffice.*?~([01]\..*|2\.([0-3][^0-9]" +
                   "|4(\.0)?[^.0-9]))", string:item))
  {
     security_hole(0);
     exit(0);
  }
}
