###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_koschtit_image_gallery_dir_trav_vuln.nasl 2113 2009-05-21 20:38:56Z may $
#
# KoschtIT Image Gallery Multiple Directory Traversal Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800803);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1510");
  script_bugtraq_id(34335);
  script_name("KoschtIT Image Gallery Multiple Directory Traversal Vulnerabilities");
  desc = "

  Overview: This host is running KoschtIT Image Gallery and is prone to multiple
  Directory Traversal vulnerabilities.

  Vulnerability Insight:
  Improper validation check while processing user supplied input in the file
  parameter for the files 'ki_makepic.php' and 'ki_nojsdisplayimage.php' under
  ki_base directory.

  Impact:
  Successful exploitation will let the attacker execute arbitrary commands to
  retrieve local system related files and gain sensitive information.

  Impact Level: Application

  Affected Software/OS:
  KoschtIT Image Gallery version 1.82 and prior

  Fix: Upgrade to KoschtIT Image Gallery version 2.0 Beta 1
  http://koschtit.tabere.net/en

  References:
  http://www.milw0rm.com/exploits/8334
  http://en.securitylab.ru/nvd/378734.php
  http://koschtit.tabere.net/forum/showthread.php?tid=6

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of KoschtIT Image Gallery");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

koschITPort = get_http_port(default:80);
if(!koschITPort){
  koschITPort = 80;
}

if(!get_port_state(koschITPort)){
  exit(0);
}

foreach dir (make_list("/kos2", "/koschtit", "/koschtit2", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir + "/changelog.txt"), port:koschITPort);
  rcvRes = http_send_recv(port:koschITPort, data:sndReq);

  if("KoschtIT Image Gallery" >< rcvRes)
  {
    # Match for KoschtIT Image Gallery Version
    ver = eregmatch(pattern:"Gallery ([0-9.]+)(beta)?([0-9]+)?", string:rcvRes);
    if(ver[1] != NULL)
    {
      if(ver[1] != NULL && ver[3] != NULL){
        version = ver[1] + "." + ver[3]; # ver[3] points to beta version.
      }
      else
        version = ver[1];
    }

    if(version != NULL)
    {
      if(version_is_less_equal(version:version, test_version:"1.82"))
      {
        security_hole(koschITPort);
        exit(0);
      }
    }
  }
}
