###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_flashchat_sec_bypass_vuln.nasl 2009-05-11 15:30:29Z may $
#
# FlashChat Role Filter Security Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800616);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-6799");
  script_bugtraq_id(31800);
  script_name("FlashChat Role Filter Security Bypass Vulnerability");
  desc = "

  Overview: This host is installed with FlashChat and is prone to Security
  Bypass Vulnerability.

  Vulnerability Insight:
  This flaw is due to an error in the connection.php script. By setting
  the 's' parameter to a value of '7' a remote attacker could bypass the
  role filtering mechanism.

  Impact:
  Successful exploitation will let the attacker bypass certain security
  restrictions and gain unauthorized administrative access to the
  affected application.

  Affected Software/OS:
  FlashChat Version 5.0.8 and prior

  Fix: No solution or patch is available as on 13th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,http://www.tufat.com/s_flash_chat_chatroom.htm

  References:
  http://www.osvdb.org/49337
  http://secunia.com/advisories/32350
  http://xforce.iss.net/xforce/xfdb/45974

  CVSS Score:
   CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
   CVSS Temporal Score : 6.7
  Risk factor:High";

  script_description(desc);
  script_summary("Check for the version of FlashChat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_flashchat_detect.nasl");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

flashport = get_http_port(default:80);
if(!flashport){
  exit(0);
}

if(!get_port_state(flashport)){
  exit(0);
}

fcVer = get_kb_item("www/" + flashport + "/FlashChat");
fcVer = eregmatch(pattern:"([0-9.]+)" ,string:fcVer);
if(fcVer[1] != NULL)
{
  if(version_is_less_equal(version:fcVer[1], test_version:"5.0.8")){
    security_hole(0);
  }
}
