##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/05/18
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from parser import gentoo


class GentooParserTestCase(unittest.TestCase):

    ## Initial Setup
    gentoo_parser_obj = gentoo.Parser()

    def setUp(self):
        ptr = open('./test/unit_test/work/input/glsa-200804-30.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.gentoo_parser_obj, 'Html_content', self.Html_content)


    def test_getCVE(self):
        print "\nTesting Gentoo Parser Test Suite ..."
        req_out_put = 'CVE-2008-1671'

        out_put = self.gentoo_parser_obj.getCVE()
        self.assertEquals(out_put, req_out_put)


    def test_getAdvID(self):
        req_out_put = 'GLSA 200804-30'

        out_put = self.gentoo_parser_obj.getAdvID()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage(self):
        req_out_put = 'kdelibs'

        out_put = self.gentoo_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription(self):
        req_out_put = "Vulnerabilities have been reported in the processing of user-controlled data \n  by start_kdeinit, which is setuid root by default." 

        out_put = self.gentoo_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct1(self):
        req_out_put = 'All supported architectures'

        out_put = self.gentoo_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct2(self):
        req_out_put = 'Intel compatible'
        ptr = open('./test/unit_test/work/input/glsa-200704-13.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.gentoo_parser_obj, 'Html_content', self.Html_content)

        out_put = self.gentoo_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct3(self):
        req_out_put = 'x86 ppc hppa'
        ptr = open('./test/unit_test/work/input/glsa-200703-23.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.gentoo_parser_obj, 'Html_content', self.Html_content)

        out_put = self.gentoo_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getRPM1(self):
        req_out_put = {'All supported architectures': {'kde-base/kdelibs': ['lt', '4.0', 'rge', '3.5.8-r4', 'rge', '3.5.9-r3', 'gt', '4.0', 'lt', '3.5.5', 'rge', '3.5.10-r2']}}

        prod = 'All supported architectures' 
        out_put = self.gentoo_parser_obj.getRPM(prod)
        self.assertEquals(out_put, req_out_put)


    def test_getRPM2(self):
        req_out_put = {'x86 ppc hppa': {'www-apps/wordpress': ['le', '2.1.2']}}

        ptr = open('./test/unit_test/work/input/glsa-200703-23.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.gentoo_parser_obj, 'Html_content', self.Html_content)

        prod = 'x86 ppc hppa' 
        out_put = self.gentoo_parser_obj.getRPM(prod)
        self.assertEquals(out_put, req_out_put)


    def test_getRPM3(self):
        req_out_put = {'Intel compatible': {'sys-apps/file': ['eq', '4.21', 'ge', '4.21-r1']}}

        ptr = open('./test/unit_test/work/input/glsa-200704-13.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.gentoo_parser_obj, 'Html_content', self.Html_content)

        prod = 'Intel compatible' 
        out_put = self.gentoo_parser_obj.getRPM(prod)
        self.assertEquals(out_put, req_out_put)


    def test_getRPM4(self):
        req_out_put = {'All supported architectures': {'app-text/ghostscript-gnu': ['lt', '8.62.0', 'ge', '8.62.0'], 'app-text/ghostscript-gpl': ['lt', '8.64-r2', 'ge', '8.64-r2'], 'app-text/ghostscript-esp': ['le', '8.15.4-r1']}}

        ptr = open('./test/unit_test/work/input/glsa-200903-37.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.gentoo_parser_obj, 'Html_content', self.Html_content)

        prod = 'All supported architectures' 
        out_put = self.gentoo_parser_obj.getRPM(prod)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference1(self):
        req_out_put = 'http://www.gentoo.org/security/en/glsa/glsa-200903-37.xml'

        main_url = 'http://www.gentoo.org/security/en/glsa/'
        file_name = 'glsa-200903-37.html'
        out_put = self.gentoo_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference2(self):
        req_out_put = 'http://www.gentoo.org/security/en/glsa/glsa-200905-01.xml'

        main_url = 'http://www.gentoo.org/security/en/glsa/'
        file_name = 'glsa-200905-01.html'
        out_put = self.gentoo_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_parser(self):
        req_out_put = True

        out_put = self.gentoo_parser_obj.parser(self.Html_content)
        self.assertEquals(out_put, req_out_put)


    def test_getYearLinks(self):
        req_out_put = ['http://www.gentoo.org/security/en/glsa/glsa-200905-01.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-20.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-19.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-18.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-17.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-16.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-15.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-14.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-13.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-12.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-11.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-10.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-09.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-08.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-07.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-06.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-05.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-04.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-03.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-02.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200904-01.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-41.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-40.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-39.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-38.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-37.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-36.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-35.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-34.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-33.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-32.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-31.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-30.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-29.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-28.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-27.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-26.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-25.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-24.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-23.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-22.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-21.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-20.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-19.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-18.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-17.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-16.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-15.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-14.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-13.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-12.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-11.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-10.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-09.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-08.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-07.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-06.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-05.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-04.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-03.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-02.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200903-01.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200902-06.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200902-05.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200902-04.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200902-03.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200902-02.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200902-01.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-15.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-14.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-13.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-12.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-11.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-10.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-09.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-08.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-07.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-06.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-05.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-04.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-03.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-02.xml', 'http://www.gentoo.org/security/en/glsa/glsa-200901-01.xml']

        link = './test/unit_test/work/input/gentoo-advisory-main.html'
        year = '2009'
        out_put = self.gentoo_parser_obj._getYearLinks(link, year)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()

