/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.util.converters.FormatException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Element;

public class Matrix {
    protected int mNRows = 0;
    protected int mNColumns = 0;
    protected Vector mMatrix = new Vector();

    public Matrix(int rows, int columns) {
        this.mNRows = rows;
        this.mNColumns = columns;
        int size = rows * columns;
        for (int idx = 0; idx < size; ++idx) {
            this.mMatrix.add("0.0");
        }
    }

    public Matrix(Element matrix) throws FormatException {
        String rowStr = matrix.getAttributeValue("rows");
        String colStr = matrix.getAttributeValue("columns");
        if (rowStr == null || colStr == null) {
            throw new FormatException("Unable to determine matrix dimensions");
        }
        try {
            this.mNRows = Integer.parseInt(rowStr);
            this.mNColumns = Integer.parseInt(colStr);
        }
        catch (Exception ex) {
            throw new FormatException("Unable to parse matrix dimensions");
        }
        String text = matrix.getText();
        StringTokenizer tokenizer = new StringTokenizer(text, " \t\n");
        boolean row = false;
        boolean col = false;
        while (tokenizer.hasMoreElements()) {
            this.mMatrix.add(tokenizer.nextElement());
        }
    }

    public int getNumRows() {
        return this.mNRows;
    }

    public int getNumColumns() {
        return this.mNColumns;
    }

    public String getValue(int row, int col) throws IndexOutOfBoundsException {
        if (row >= this.mNRows || col >= this.mNColumns) {
            throw new IndexOutOfBoundsException("Matrix index out of range.  Matrix is [" + this.mNRows + "x" + this.mNColumns + "]");
        }
        return (String)this.mMatrix.get(row * this.mNColumns + col);
    }

    public float getAsFloat(int row, int col) throws IndexOutOfBoundsException {
        if (row >= this.mNRows || col >= this.mNColumns) {
            throw new IndexOutOfBoundsException("Matrix index out of range.  Matrix is [" + this.mNRows + "x" + this.mNColumns + "]");
        }
        String value = (String)this.mMatrix.get(row * this.mNColumns + col);
        return Integer.parseInt(value);
    }

    public void setValue(int row, int col, String value) throws IndexOutOfBoundsException {
        if (row >= this.mNRows || col >= this.mNColumns) {
            throw new IndexOutOfBoundsException("Matrix index out of range.  Matrix is [" + this.mNRows + "x" + this.mNColumns + "]");
        }
        this.mMatrix.set(row * this.mNColumns + col, value);
    }

    protected boolean checkIdenticalExponents(Matrix toMerge) {
        boolean ret = true;
        if (this.mNRows != toMerge.mNRows) {
            ret = false;
            System.out.println("NOT MERGEING - different number of rows");
        } else {
            for (int rdx = 0; rdx < this.mNRows; ++rdx) {
                if (this.getValue(rdx, 0).equals(toMerge.getValue(rdx, 0))) continue;
                System.out.println("NOT MERGEING - value mismatch");
                ret = false;
                break;
            }
        }
        return ret;
    }

    public Matrix merge(Matrix toMerge) {
        Matrix ret = null;
        if (this.checkIdenticalExponents(toMerge)) {
            int cdx;
            int rdx;
            ret = new Matrix(this.mNRows, this.mNColumns + 1);
            for (rdx = 0; rdx < this.mNRows; ++rdx) {
                for (cdx = 0; cdx < this.mNColumns; ++cdx) {
                    ret.setValue(rdx, cdx, this.getValue(rdx, cdx));
                }
            }
            for (rdx = 0; rdx < this.mNRows; ++rdx) {
                for (cdx = 1; cdx < toMerge.getNumColumns(); ++cdx) {
                    ret.setValue(rdx, this.mNColumns + cdx - 1, toMerge.getValue(rdx, cdx));
                }
            }
        } else {
            ret = new Matrix(this.mNRows + toMerge.getNumRows(), this.mNColumns + toMerge.getNumColumns() - 1);
            for (int rdx = 0; rdx < this.mNRows; ++rdx) {
                for (int cdx = 0; cdx < this.mNColumns; ++cdx) {
                    ret.setValue(rdx, cdx, this.getValue(rdx, cdx));
                }
            }
            for (int rdx = 0; rdx < toMerge.getNumRows(); ++rdx) {
                int row = rdx + this.mNRows;
                ret.setValue(row, 0, toMerge.getValue(rdx, 0));
                for (int cdx = 1; cdx < toMerge.getNumColumns(); ++cdx) {
                    ret.setValue(row, this.mNColumns + cdx - 1, toMerge.getValue(rdx, cdx));
                }
            }
        }
        return ret;
    }

    public Matrix mergeSP(Matrix toMerge) {
        Matrix ret = new Matrix(this.getNumRows(), this.getNumColumns() + toMerge.getNumColumns() - 1);
        for (int rdx = 0; rdx < this.mNRows; ++rdx) {
            for (int cdx = 0; cdx < this.mNColumns; ++cdx) {
                ret.setValue(rdx, cdx, this.getValue(rdx, cdx));
            }
        }
        for (int rdx = 0; rdx < toMerge.getNumRows(); ++rdx) {
            for (int cdx = 1; cdx < toMerge.getNumColumns(); ++cdx) {
                ret.setValue(rdx, this.mNColumns + cdx - 1, toMerge.getValue(rdx, cdx));
            }
        }
        return ret;
    }

    public Matrix appendContraction(int loc, String value) {
        Matrix ret = new Matrix(this.getNumRows(), this.getNumColumns() + 1);
        for (int rdx = 0; rdx < this.mNRows; ++rdx) {
            for (int cdx = 0; cdx < this.mNColumns; ++cdx) {
                ret.setValue(rdx, cdx, this.getValue(rdx, cdx));
            }
        }
        ret.setValue(loc, ret.getNumColumns() - 1, value);
        return ret;
    }

    public boolean matchesExponentsExact(Matrix rhs) {
        boolean ret = false;
        if (this.getNumRows() == rhs.getNumRows() && this.getNumColumns() == rhs.getNumColumns()) {
            ret = true;
            for (int rdx = 0; rdx < this.getNumRows(); ++rdx) {
                if (this.getValue(rdx, 0).equals(rhs.getValue(rdx, 0))) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("\n");
        for (int idx = 0; idx < this.mMatrix.size(); ++idx) {
            buf.append((String)this.mMatrix.get(idx));
            if ((idx + 1) % this.mNColumns == 0) {
                buf.append("\n");
                continue;
            }
            if (idx != this.mMatrix.size() - 1) {
                buf.append(" ");
                continue;
            }
            buf.append("\n");
        }
        return new String(buf);
    }
}

