/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToNWChemLibraryEcpInput
extends AbstractBasisSetXmlToText {
    protected boolean specifics = true;
    protected Element root = null;

    public BasisXmlToNWChemLibraryEcpInput() {
    }

    public BasisXmlToNWChemLibraryEcpInput(boolean includeSpecifics) {
        this.specifics = includeSpecifics;
    }

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readECP(data, elementList);
    }

    @Override
    protected void addHeaderECP(StringBuffer output, Element root) {
        this.root = root;
    }

    @Override
    protected void addFooterECP(StringBuffer output) {
    }

    @Override
    protected void addElementDescriptionECP(StringBuffer output, Element potentials, String element) {
        String nelec = potentials.getAttributeValue("numElectronsReplaced");
        String title = this.root.getChildText("title", BSEProperties.mDcNs);
        output.append("ecp \"" + element + "_" + title + "\"\n");
        output.append(element + " nelec " + nelec + "\n");
        this.mGlobalShellCounter = 0;
    }

    @Override
    protected void addElementFooter(StringBuffer output, String element, Element contractions) {
        output.append("end\n");
    }

    @Override
    protected void readCmlMatrixECP(StringBuffer output, Matrix matrix, String element, String shell, String potentialType) throws FormatException {
        int rows = matrix.getNumRows();
        int columns = matrix.getNumColumns();
        if (this.mGlobalShellCounter == 0 && this.specifics) {
            output.append(element + " ul\n");
        } else {
            output.append(element + " " + shell.toUpperCase() + "\n");
        }
        ++this.mGlobalShellCounter;
        try {
            for (int i = 0; i < rows; ++i) {
                output.append(matrix.getValue(i, 0));
                for (int j = 1; j < columns; ++j) {
                    String value = this.formattedValue(matrix.getValue(i, j));
                    output.append(value);
                }
                output.append("\n");
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
    }
}

