// generated from test/fixtures/dep-missing-resolved
module.exports = t => {
  const path = t.testdir({
  "README.md": `Honestly still not exactly sure how this happened.  I was switching back
and forth between installing and removing a variety of things with npm v6
and v7, and somehow ended up in a case where it was trying to fetch a dep
that somehow did not have a resolved value.

My best guess is that it has something to do with the fact that mkdirp and
minimist are bundled in tap 14, but not in tap 12, and npm v6 isn't as
aggressive about re-optimizing the tree for nested deps, but arborist did
pluck off the \`bundled: true\` when setting back to tap 12.

Anyway, saved as a test case so we can verify that the defensive handling
of this brokenness works as intended.
`,
  "package-lock.json": JSON.stringify({
    "name": "foo",
    "version": "1.0.0",
    "lockfileVersion": 2,
    "requires": true,
    "packages": {
      "": {
        "dependencies": {
          "tap": "12"
        }
      },
      "node_modules/@babel/code-frame": {
        "version": "7.8.3",
        "resolved": "https://registry.npmjs.org/@babel/code-frame/-/code-frame-7.8.3.tgz",
        "integrity": "sha512-a9gxpmdXtZEInkCSHUJDLHZVBgb1QS0jhss4cPP93EW7s+uC5bikET2twEF3KV+7rDblJcmNvTR7VJejqd2C2g==",
        "dependencies": {
          "@babel/highlight": "^7.8.3"
        }
      },
      "node_modules/@babel/generator": {
        "version": "7.9.4",
        "resolved": "https://registry.npmjs.org/@babel/generator/-/generator-7.9.4.tgz",
        "integrity": "sha512-rjP8ahaDy/ouhrvCoU1E5mqaitWrxwuNGU+dy1EpaoK48jZay4MdkskKGIMHLZNewg8sAsqpGSREJwP0zH3YQA==",
        "dependencies": {
          "@babel/types": "^7.9.0",
          "jsesc": "^2.5.1",
          "lodash": "^4.17.13",
          "source-map": "^0.5.0"
        }
      },
      "node_modules/@babel/generator/node_modules/source-map": {
        "version": "0.5.7",
        "resolved": "https://registry.npmjs.org/source-map/-/source-map-0.5.7.tgz",
        "integrity": "sha1-igOdLRAh0i0eoUyA2OpGi6LvP8w="
      },
      "node_modules/@babel/helper-function-name": {
        "version": "7.8.3",
        "resolved": "https://registry.npmjs.org/@babel/helper-function-name/-/helper-function-name-7.8.3.tgz",
        "integrity": "sha512-BCxgX1BC2hD/oBlIFUgOCQDOPV8nSINxCwM3o93xP4P9Fq6aV5sgv2cOOITDMtCfQ+3PvHp3l689XZvAM9QyOA==",
        "dependencies": {
          "@babel/helper-get-function-arity": "^7.8.3",
          "@babel/template": "^7.8.3",
          "@babel/types": "^7.8.3"
        }
      },
      "node_modules/@babel/helper-get-function-arity": {
        "version": "7.8.3",
        "resolved": "https://registry.npmjs.org/@babel/helper-get-function-arity/-/helper-get-function-arity-7.8.3.tgz",
        "integrity": "sha512-FVDR+Gd9iLjUMY1fzE2SR0IuaJToR4RkCDARVfsBBPSP53GEqSFjD8gNyxg246VUyc/ALRxFaAK8rVG7UT7xRA==",
        "dependencies": {
          "@babel/types": "^7.8.3"
        }
      },
      "node_modules/@babel/helper-split-export-declaration": {
        "version": "7.8.3",
        "resolved": "https://registry.npmjs.org/@babel/helper-split-export-declaration/-/helper-split-export-declaration-7.8.3.tgz",
        "integrity": "sha512-3x3yOeyBhW851hroze7ElzdkeRXQYQbFIb7gLK1WQYsw2GWDay5gAJNw1sWJ0VFP6z5J1whqeXH/WCdCjZv6dA==",
        "dependencies": {
          "@babel/types": "^7.8.3"
        }
      },
      "node_modules/@babel/helper-validator-identifier": {
        "version": "7.9.0",
        "resolved": "https://registry.npmjs.org/@babel/helper-validator-identifier/-/helper-validator-identifier-7.9.0.tgz",
        "integrity": "sha512-6G8bQKjOh+of4PV/ThDm/rRqlU7+IGoJuofpagU5GlEl29Vv0RGqqt86ZGRV8ZuSOY3o+8yXl5y782SMcG7SHw=="
      },
      "node_modules/@babel/highlight": {
        "version": "7.9.0",
        "resolved": "https://registry.npmjs.org/@babel/highlight/-/highlight-7.9.0.tgz",
        "integrity": "sha512-lJZPilxX7Op3Nv/2cvFdnlepPXDxi29wxteT57Q965oc5R9v86ztx0jfxVrTcBk8C2kcPkkDa2Z4T3ZsPPVWsQ==",
        "dependencies": {
          "@babel/helper-validator-identifier": "^7.9.0",
          "chalk": "^2.0.0",
          "js-tokens": "^4.0.0"
        }
      },
      "node_modules/@babel/parser": {
        "version": "7.9.4",
        "resolved": "https://registry.npmjs.org/@babel/parser/-/parser-7.9.4.tgz",
        "integrity": "sha512-bC49otXX6N0/VYhgOMh4gnP26E9xnDZK3TmbNpxYzzz9BQLBosQwfyOe9/cXUU3txYhTzLCbcqd5c8y/OmCjHA=="
      },
      "node_modules/@babel/template": {
        "version": "7.8.6",
        "resolved": "https://registry.npmjs.org/@babel/template/-/template-7.8.6.tgz",
        "integrity": "sha512-zbMsPMy/v0PWFZEhQJ66bqjhH+z0JgMoBWuikXybgG3Gkd/3t5oQ1Rw2WQhnSrsOmsKXnZOx15tkC4qON/+JPg==",
        "dependencies": {
          "@babel/code-frame": "^7.8.3",
          "@babel/parser": "^7.8.6",
          "@babel/types": "^7.8.6"
        }
      },
      "node_modules/@babel/traverse": {
        "version": "7.9.0",
        "resolved": "https://registry.npmjs.org/@babel/traverse/-/traverse-7.9.0.tgz",
        "integrity": "sha512-jAZQj0+kn4WTHO5dUZkZKhbFrqZE7K5LAQ5JysMnmvGij+wOdr+8lWqPeW0BcF4wFwrEXXtdGO7wcV6YPJcf3w==",
        "dependencies": {
          "@babel/code-frame": "^7.8.3",
          "@babel/generator": "^7.9.0",
          "@babel/helper-function-name": "^7.8.3",
          "@babel/helper-split-export-declaration": "^7.8.3",
          "@babel/parser": "^7.9.0",
          "@babel/types": "^7.9.0",
          "debug": "^4.1.0",
          "globals": "^11.1.0",
          "lodash": "^4.17.13"
        }
      },
      "node_modules/@babel/types": {
        "version": "7.9.0",
        "resolved": "https://registry.npmjs.org/@babel/types/-/types-7.9.0.tgz",
        "integrity": "sha512-BS9JKfXkzzJl8RluW4JGknzpiUV7ZrvTayM6yfqLTVBEnFtyowVIOu6rqxRd5cVO6yGoWf4T8u8dgK9oB+GCng==",
        "dependencies": {
          "@babel/helper-validator-identifier": "^7.9.0",
          "lodash": "^4.17.13",
          "to-fast-properties": "^2.0.0"
        }
      },
      "node_modules/ajv": {
        "version": "6.12.0",
        "resolved": "https://registry.npmjs.org/ajv/-/ajv-6.12.0.tgz",
        "integrity": "sha512-D6gFiFA0RRLyUbvijN74DWAjXSFxWKaWP7mldxkVhyhAV3+SWA9HEJPHQ2c9soIeTFJqcSdFDGFgdqs1iUU2Hw==",
        "dependencies": {
          "fast-deep-equal": "^3.1.1",
          "fast-json-stable-stringify": "^2.0.0",
          "json-schema-traverse": "^0.4.1",
          "uri-js": "^4.2.2"
        }
      },
      "node_modules/ansi-regex": {
        "name": "ansi-regex",
        "version": "2.1.1",
        "resolved": "https://registry.npmjs.org/ansi-regex/-/ansi-regex-2.1.1.tgz",
        "integrity": "sha1-w7M6te42DYbg5ijwRorn7yfWVN8=",
        "engines": {
          "node": ">=0.10.0"
        }
      },
      "node_modules/ansi-styles": {
        "version": "3.2.1",
        "resolved": "https://registry.npmjs.org/ansi-styles/-/ansi-styles-3.2.1.tgz",
        "integrity": "sha512-VT0ZI6kZRdTh8YyJw3SMbYm/u+NqfsAxEpWO0Pf9sq8/e94WxxOpPKx9FR1FlyCtOVDNOQ+8ntlqFxiRc+r5qA==",
        "dependencies": {
          "color-convert": "^1.9.0"
        }
      },
      "node_modules/append-transform": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/append-transform/-/append-transform-1.0.0.tgz",
        "integrity": "sha512-P009oYkeHyU742iSZJzZZywj4QRJdnTWffaKuJQLablCZ1uz6/cW4yaRgcDaoQ+uwOxxnt0gRUcwfsNP2ri0gw==",
        "dependencies": {
          "default-require-extensions": "^2.0.0"
        }
      },
      "node_modules/archy": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/archy/-/archy-1.0.0.tgz",
        "integrity": "sha1-+cjBN1fMHde8N5rHeyxipcKGjEA="
      },
      "node_modules/arg": {
        "version": "4.1.3",
        "resolved": "https://registry.npmjs.org/arg/-/arg-4.1.3.tgz",
        "integrity": "sha512-58S9QDqG0Xx27YwPSt9fJxivjYl432YCwfDMfZ+71RAqUrZef7LrKQZ3LHLOwCS4FLNBplP533Zx895SeOCHvA=="
      },
      "node_modules/argparse": {
        "version": "1.0.10",
        "resolved": "https://registry.npmjs.org/argparse/-/argparse-1.0.10.tgz",
        "integrity": "sha512-o5Roy6tNG4SL/FOkCAN6RzjiakZS25RLYFrcMttJqbdd8BWrnA+fGz57iN5Pb06pvBGvl5gQ0B48dJlslXvoTg==",
        "dependencies": {
          "sprintf-js": "~1.0.2"
        }
      },
      "node_modules/asn1": {
        "version": "0.2.4",
        "resolved": "https://registry.npmjs.org/asn1/-/asn1-0.2.4.tgz",
        "integrity": "sha512-jxwzQpLQjSmWXgwaCZE9Nz+glAG01yF1QnWgbhGwHI5A6FRIEY6IVqtHhIepHqI7/kyEyQEagBC5mBEFlIYvdg==",
        "dependencies": {
          "safer-buffer": "~2.1.0"
        }
      },
      "node_modules/assert-plus": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/assert-plus/-/assert-plus-1.0.0.tgz",
        "integrity": "sha1-8S4PPF13sLHN2RRpQuTpbB5N1SU="
      },
      "node_modules/asynckit": {
        "version": "0.4.0",
        "resolved": "https://registry.npmjs.org/asynckit/-/asynckit-0.4.0.tgz",
        "integrity": "sha1-x57Zf380y48robyXkLzDZkdLS3k="
      },
      "node_modules/aws-sign2": {
        "version": "0.7.0",
        "resolved": "https://registry.npmjs.org/aws-sign2/-/aws-sign2-0.7.0.tgz",
        "integrity": "sha1-tG6JCTSpWR8tL2+G1+ap8bP+dqg="
      },
      "node_modules/aws4": {
        "version": "1.9.1",
        "resolved": "https://registry.npmjs.org/aws4/-/aws4-1.9.1.tgz",
        "integrity": "sha512-wMHVg2EOHaMRxbzgFJ9gtjOOCrI80OHLG14rxi28XwOW8ux6IiEbRCGGGqCtdAIg4FQCbW20k9RsT4y3gJlFug=="
      },
      "node_modules/balanced-match": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/balanced-match/-/balanced-match-1.0.0.tgz",
        "integrity": "sha1-ibTRmasr7kneFk6gK4nORi1xt2c="
      },
      "node_modules/bcrypt-pbkdf": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/bcrypt-pbkdf/-/bcrypt-pbkdf-1.0.2.tgz",
        "integrity": "sha1-pDAdOJtqQ/m2f/PKEaP2Y342Dp4=",
        "dependencies": {
          "tweetnacl": "^0.14.3"
        }
      },
      "node_modules/bind-obj-methods": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/bind-obj-methods/-/bind-obj-methods-2.0.0.tgz",
        "integrity": "sha512-3/qRXczDi2Cdbz6jE+W3IflJOutRVica8frpBn14de1mBOkzDo+6tY33kNhvkw54Kn3PzRRD2VnGbGPcTAk4sw=="
      },
      "node_modules/brace-expansion": {
        "version": "1.1.11",
        "resolved": "https://registry.npmjs.org/brace-expansion/-/brace-expansion-1.1.11.tgz",
        "integrity": "sha512-iCuPHDFgrHX7H2vEI/5xpz07zSHB00TpugqhmYtVmMO6518mCuRMoOYFldEBl0g187ufozdaHgWKcYFb61qGiA==",
        "dependencies": {
          "balanced-match": "^1.0.0",
          "concat-map": "0.0.1"
        }
      },
      "node_modules/browser-process-hrtime": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/browser-process-hrtime/-/browser-process-hrtime-1.0.0.tgz",
        "integrity": "sha512-9o5UecI3GhkpM6DrXr69PblIuWxPKk9Y0jHBRhdocZ2y7YECBFCsHm79Pr3OyR2AvjhDkabFJaDJMYRazHgsow=="
      },
      "node_modules/buffer-from": {
        "version": "1.1.1",
        "resolved": "https://registry.npmjs.org/buffer-from/-/buffer-from-1.1.1.tgz",
        "integrity": "sha512-MQcXEUbCKtEo7bhqEs6560Hyd4XaovZlO/k9V3hjVUF/zwW7KBVdSK4gIt/bzwS9MbR5qob+F5jusZsb0YQK2A=="
      },
      "node_modules/caching-transform": {
        "version": "3.0.2",
        "resolved": "https://registry.npmjs.org/caching-transform/-/caching-transform-3.0.2.tgz",
        "integrity": "sha512-Mtgcv3lh3U0zRii/6qVgQODdPA4G3zhG+jtbCWj39RXuUFTMzH0vcdMtaJS1jPowd+It2Pqr6y3NJMQqOqCE2w==",
        "dependencies": {
          "hasha": "^3.0.0",
          "make-dir": "^2.0.0",
          "package-hash": "^3.0.0",
          "write-file-atomic": "^2.4.2"
        }
      },
      "node_modules/camelcase": {
        "version": "5.3.1",
        "resolved": "https://registry.npmjs.org/camelcase/-/camelcase-5.3.1.tgz",
        "integrity": "sha512-L28STB170nwWS63UjtlEOE3dldQApaJXZkOI1uMFfzf3rRuPegHaHesyee+YxQ+W6SvRDQV6UrdOdRiR153wJg=="
      },
      "node_modules/capture-stack-trace": {
        "name": "capture-stack-trace",
        "version": "1.0.1",
        "resolved": "https://registry.npmjs.org/capture-stack-trace/-/capture-stack-trace-1.0.1.tgz",
        "integrity": "sha512-mYQLZnx5Qt1JgB1WEiMCf2647plpGeQ2NMR/5L0HNZzGQo4fuSPnK+wjfPnKZV0aiJDgzmWqqkV/g7JD+DW0qw==",
        "engines": {
          "node": ">=0.10.0"
        }
      },
      "node_modules/caseless": {
        "version": "0.12.0",
        "resolved": "https://registry.npmjs.org/caseless/-/caseless-0.12.0.tgz",
        "integrity": "sha1-G2gcIf+EAzyCZUMJBolCDRhxUdw="
      },
      "node_modules/chalk": {
        "version": "2.4.2",
        "resolved": "https://registry.npmjs.org/chalk/-/chalk-2.4.2.tgz",
        "integrity": "sha512-Mti+f9lpJNcwF4tWV8/OrTTtF1gZi+f8FqlyAdouralcFWFQWF2+NgCHShjkCb+IFBLq9buZwE1xckQU4peSuQ==",
        "dependencies": {
          "ansi-styles": "^3.2.1",
          "escape-string-regexp": "^1.0.5",
          "supports-color": "^5.3.0"
        }
      },
      "node_modules/clean-yaml-object": {
        "name": "clean-yaml-object",
        "version": "0.1.0",
        "resolved": "https://registry.npmjs.org/clean-yaml-object/-/clean-yaml-object-0.1.0.tgz",
        "integrity": "sha1-Y/sRDcLOGoTcIfbZM0h20BCui2g=",
        "engines": {
          "node": ">=0.10.0"
        }
      },
      "node_modules/color-convert": {
        "version": "1.9.3",
        "resolved": "https://registry.npmjs.org/color-convert/-/color-convert-1.9.3.tgz",
        "integrity": "sha512-QfAUtd+vFdAtFQcC8CCyYt1fYWxSqAiK2cSD6zDB8N3cpsEBAvRxp9zOGg6G/SHHJYAT88/az/IuDGALsNVbGg==",
        "dependencies": {
          "color-name": "1.1.3"
        }
      },
      "node_modules/color-name": {
        "version": "1.1.3",
        "resolved": "https://registry.npmjs.org/color-name/-/color-name-1.1.3.tgz",
        "integrity": "sha1-p9BVi9icQveV3UIyj3QIMcpTvCU="
      },
      "node_modules/color-support": {
        "name": "color-support",
        "version": "1.1.3",
        "resolved": "https://registry.npmjs.org/color-support/-/color-support-1.1.3.tgz",
        "integrity": "sha512-qiBjkpbMLO/HL68y+lh4q0/O1MZFj2RX6X/KmMa3+gJD3z+WwI1ZzDHysvqHGS3mP6mznPckpXmw1nI9cJjyRg==",
        "bin": {
          "color-support": "bin.js"
        }
      },
      "node_modules/combined-stream": {
        "version": "1.0.8",
        "resolved": "https://registry.npmjs.org/combined-stream/-/combined-stream-1.0.8.tgz",
        "integrity": "sha512-FQN4MRfuJeHf7cBbBMJFXhKSDq+2kAArBlmRBvcvFE5BB1HZKXtSFASDhdlz9zOYwxh8lDdnvmMOe/+5cdoEdg==",
        "dependencies": {
          "delayed-stream": "~1.0.0"
        }
      },
      "node_modules/commondir": {
        "version": "1.0.1",
        "resolved": "https://registry.npmjs.org/commondir/-/commondir-1.0.1.tgz",
        "integrity": "sha1-3dgA2gxmEnOTzKWVDqloo6rxJTs="
      },
      "node_modules/concat-map": {
        "version": "0.0.1",
        "resolved": "https://registry.npmjs.org/concat-map/-/concat-map-0.0.1.tgz",
        "integrity": "sha1-2Klr13/Wjfd5OnMDajug1UBdR3s="
      },
      "node_modules/convert-source-map": {
        "version": "1.7.0",
        "resolved": "https://registry.npmjs.org/convert-source-map/-/convert-source-map-1.7.0.tgz",
        "integrity": "sha512-4FJkXzKXEDB1snCFZlLP4gpC3JILicCpGbzG9f9G7tGqGCzETQ2hWPrcinA9oU4wtf2biUaEH5065UnMeR33oA==",
        "dependencies": {
          "safe-buffer": "~5.1.1"
        }
      },
      "node_modules/convert-source-map/node_modules/safe-buffer": {
        "version": "5.1.2",
        "resolved": "https://registry.npmjs.org/safe-buffer/-/safe-buffer-5.1.2.tgz",
        "integrity": "sha512-Gd2UZBJDkXlY7GbJxfsE8/nvKkUEU1G38c1siN6QP6a9PT9MmHB8GnpscSmMJSoF8LOIrt8ud/wPtojys4G6+g=="
      },
      "node_modules/core-util-is": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/core-util-is/-/core-util-is-1.0.2.tgz",
        "integrity": "sha1-tf1UIgqivFq1eqtxQMlAdUUDwac="
      },
      "node_modules/coveralls": {
        "version": "3.0.11",
        "resolved": "https://registry.npmjs.org/coveralls/-/coveralls-3.0.11.tgz",
        "integrity": "sha512-LZPWPR2NyGKyaABnc49dR0fpeP6UqhvGq4B5nUrTQ1UBy55z96+ga7r+/ChMdMJUwBgyJDXBi88UBgz2rs9IiQ==",
        "dependencies": {
          "js-yaml": "^3.13.1",
          "lcov-parse": "^1.0.0",
          "log-driver": "^1.2.7",
          "minimist": "^1.2.5",
          "request": "^2.88.0"
        }
      },
      "node_modules/cp-file": {
        "version": "6.2.0",
        "resolved": "https://registry.npmjs.org/cp-file/-/cp-file-6.2.0.tgz",
        "integrity": "sha512-fmvV4caBnofhPe8kOcitBwSn2f39QLjnAnGq3gO9dfd75mUytzKNZB1hde6QHunW2Rt+OwuBOMc3i1tNElbszA==",
        "dependencies": {
          "graceful-fs": "^4.1.2",
          "make-dir": "^2.0.0",
          "nested-error-stacks": "^2.0.0",
          "pify": "^4.0.1",
          "safe-buffer": "^5.0.1"
        }
      },
      "node_modules/cross-spawn": {
        "version": "4.0.2",
        "resolved": "https://registry.npmjs.org/cross-spawn/-/cross-spawn-4.0.2.tgz",
        "integrity": "sha1-e5JHYhwjrf3ThWAEqCPL45dCTUE=",
        "dependencies": {
          "lru-cache": "^4.0.1",
          "which": "^1.2.9"
        }
      },
      "node_modules/cross-spawn/node_modules/which": {
        "version": "1.3.1",
        "resolved": "https://registry.npmjs.org/which/-/which-1.3.1.tgz",
        "integrity": "sha512-HxJdYWq1MTIQbJ3nw0cqssHoTNU267KlrDuGZ1WYlxDStUtKUhOaJmh112/TZmHxxUfuJqPXSOm7tDyas0OSIQ==",
        "dependencies": {
          "isexe": "^2.0.0"
        }
      },
      "node_modules/dashdash": {
        "version": "1.14.1",
        "resolved": "https://registry.npmjs.org/dashdash/-/dashdash-1.14.1.tgz",
        "integrity": "sha1-hTz6D3y+L+1d4gMmuN1YEDX24vA=",
        "dependencies": {
          "assert-plus": "^1.0.0"
        }
      },
      "node_modules/debug": {
        "version": "4.1.1",
        "resolved": "https://registry.npmjs.org/debug/-/debug-4.1.1.tgz",
        "integrity": "sha512-pYAIzeRo8J6KPEaJ0VWOh5Pzkbw/RetuzehGM7QRRX5he4fPHx2rdKMB256ehJCkX+XRQm16eZLqLNS8RSZXZw==",
        "dependencies": {
          "ms": "^2.1.1"
        }
      },
      "node_modules/decamelize": {
        "version": "1.2.0",
        "resolved": "https://registry.npmjs.org/decamelize/-/decamelize-1.2.0.tgz",
        "integrity": "sha1-9lNNFRSCabIDUue+4m9QH5oZEpA="
      },
      "node_modules/default-require-extensions": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/default-require-extensions/-/default-require-extensions-2.0.0.tgz",
        "integrity": "sha1-9fj7sYp9bVCyH2QfZJ67Uiz+JPc=",
        "dependencies": {
          "strip-bom": "^3.0.0"
        }
      },
      "node_modules/delayed-stream": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/delayed-stream/-/delayed-stream-1.0.0.tgz",
        "integrity": "sha1-3zrhmayt+31ECqrgsp4icrJOxhk="
      },
      "node_modules/diff": {
        "version": "4.0.2",
        "resolved": "https://registry.npmjs.org/diff/-/diff-4.0.2.tgz",
        "integrity": "sha512-58lmxKSA4BNyLz+HHMUzlOEpg09FV+ev6ZMe3vJihgdxzgcwZ8VoEEPmALCZG9LmqfVoNMMKpttIYTVG6uDY7A=="
      },
      "node_modules/domain-browser": {
        "name": "domain-browser",
        "version": "1.2.0",
        "resolved": "https://registry.npmjs.org/domain-browser/-/domain-browser-1.2.0.tgz",
        "integrity": "sha512-jnjyiM6eRyZl2H+W8Q/zLMA481hzi0eszAaBUzIVnmYVDBbnLxVNnfu1HgEBvCbL+71FrxMl3E6lpKH7Ge3OXA==",
        "engines": {
          "node": ">=0.4",
          "npm": ">=1.2"
        }
      },
      "node_modules/ecc-jsbn": {
        "version": "0.1.2",
        "resolved": "https://registry.npmjs.org/ecc-jsbn/-/ecc-jsbn-0.1.2.tgz",
        "integrity": "sha1-OoOpBOVDUyh4dMVkt1SThoSamMk=",
        "dependencies": {
          "jsbn": "~0.1.0",
          "safer-buffer": "^2.1.0"
        }
      },
      "node_modules/emoji-regex": {
        "version": "7.0.3",
        "resolved": "https://registry.npmjs.org/emoji-regex/-/emoji-regex-7.0.3.tgz",
        "integrity": "sha512-CwBLREIQ7LvYFB0WyRvwhq5N5qPhc6PMjD6bYggFlI5YyDgl+0vxq5VHbMOFqLg7hfWzmu8T5Z1QofhmTIhItA=="
      },
      "node_modules/error-ex": {
        "version": "1.3.2",
        "resolved": "https://registry.npmjs.org/error-ex/-/error-ex-1.3.2.tgz",
        "integrity": "sha512-7dFHNmqeFSEt2ZBsCriorKnn3Z2pj+fd9kmI6QoWw4//DL+icEBfc0U7qJCisqrTsKTjw4fNFy2pW9OqStD84g==",
        "dependencies": {
          "is-arrayish": "^0.2.1"
        }
      },
      "node_modules/es6-error": {
        "version": "4.1.1",
        "resolved": "https://registry.npmjs.org/es6-error/-/es6-error-4.1.1.tgz",
        "integrity": "sha512-Um/+FxMr9CISWh0bi5Zv0iOD+4cFh5qLeks1qhAopKVAJw3drgKbKySikp7wGhDL0HPeaja0P5ULZrxLkniUVg=="
      },
      "node_modules/escape-string-regexp": {
        "version": "1.0.5",
        "resolved": "https://registry.npmjs.org/escape-string-regexp/-/escape-string-regexp-1.0.5.tgz",
        "integrity": "sha1-G2HAViGQqN/2rjuyzwIAyhMLhtQ="
      },
      "node_modules/esm": {
        "version": "3.2.25",
        "resolved": "https://registry.npmjs.org/esm/-/esm-3.2.25.tgz",
        "integrity": "sha512-U1suiZ2oDVWv4zPO56S0NcR5QriEahGtdN2OR6FiOG4WJvcjBVFB0qI4+eKoWFH483PKGuLuu6V8Z4T5g63UVA=="
      },
      "node_modules/esprima": {
        "version": "4.0.1",
        "resolved": "https://registry.npmjs.org/esprima/-/esprima-4.0.1.tgz",
        "integrity": "sha512-eGuFFw7Upda+g4p+QHvnW0RyTX/SVeJBDM/gCtMARO0cLuT2HcEKnTPvhjV6aGeqrCB/sbNop0Kszm0jsaWU4A=="
      },
      "node_modules/events-to-array": {
        "name": "events-to-array",
        "version": "1.1.2",
        "resolved": "https://registry.npmjs.org/events-to-array/-/events-to-array-1.1.2.tgz",
        "integrity": "sha1-LUH1Y+H+QA7Uli/hpNXGp1Od9/Y="
      },
      "node_modules/extend": {
        "version": "3.0.2",
        "resolved": "https://registry.npmjs.org/extend/-/extend-3.0.2.tgz",
        "integrity": "sha512-fjquC59cD7CyW6urNXK0FBufkZcoiGG80wTuPujX590cB5Ttln20E2UB4S/WARVqhXffZl2LNgS+gQdPIIim/g=="
      },
      "node_modules/extsprintf": {
        "version": "1.3.0",
        "resolved": "https://registry.npmjs.org/extsprintf/-/extsprintf-1.3.0.tgz",
        "integrity": "sha1-lpGEQOMEGnpBT4xS48V06zw+HgU="
      },
      "node_modules/fast-deep-equal": {
        "version": "3.1.1",
        "resolved": "https://registry.npmjs.org/fast-deep-equal/-/fast-deep-equal-3.1.1.tgz",
        "integrity": "sha512-8UEa58QDLauDNfpbrX55Q9jrGHThw2ZMdOky5Gl1CDtVeJDPVrG4Jxx1N8jw2gkWaff5UUuX1KJd+9zGe2B+ZA=="
      },
      "node_modules/fast-json-stable-stringify": {
        "version": "2.1.0",
        "resolved": "https://registry.npmjs.org/fast-json-stable-stringify/-/fast-json-stable-stringify-2.1.0.tgz",
        "integrity": "sha512-lhd/wF+Lk98HZoTCtlVraHtfh5XYijIjalXck7saUtuanSDyLMxnHhSXEDJqHxD7msR8D0uCmqlkwjCV8xvwHw=="
      },
      "node_modules/find-cache-dir": {
        "version": "2.1.0",
        "resolved": "https://registry.npmjs.org/find-cache-dir/-/find-cache-dir-2.1.0.tgz",
        "integrity": "sha512-Tq6PixE0w/VMFfCgbONnkiQIVol/JJL7nRMi20fqzA4NRs9AfeqMGeRdPi3wIhYkxjeBaWh2rxwapn5Tu3IqOQ==",
        "dependencies": {
          "commondir": "^1.0.1",
          "make-dir": "^2.0.0",
          "pkg-dir": "^3.0.0"
        }
      },
      "node_modules/find-up": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/find-up/-/find-up-3.0.0.tgz",
        "integrity": "sha512-1yD6RmLI1XBfxugvORwlck6f75tYL+iR0jqwsOrOxMZyGYqUuDhJ0l4AXdO1iX/FTs9cBAMEk1gWSEx1kSbylg==",
        "dependencies": {
          "locate-path": "^3.0.0"
        }
      },
      "node_modules/foreground-child": {
        "version": "1.5.6",
        "resolved": "https://registry.npmjs.org/foreground-child/-/foreground-child-1.5.6.tgz",
        "integrity": "sha1-T9ca0t/elnibmApcCilZN8svXOk=",
        "dependencies": {
          "cross-spawn": "^4",
          "signal-exit": "^3.0.0"
        }
      },
      "node_modules/forever-agent": {
        "version": "0.6.1",
        "resolved": "https://registry.npmjs.org/forever-agent/-/forever-agent-0.6.1.tgz",
        "integrity": "sha1-+8cfDEGt6zf5bFd60e1C2P2sypE="
      },
      "node_modules/form-data": {
        "version": "2.3.3",
        "resolved": "https://registry.npmjs.org/form-data/-/form-data-2.3.3.tgz",
        "integrity": "sha512-1lLKB2Mu3aGP1Q/2eCOx0fNbRMe7XdwktwOruhfqqd0rIJWwN4Dh+E3hrPSlDCXnSR7UtZ1N38rVXm+6+MEhJQ==",
        "dependencies": {
          "asynckit": "^0.4.0",
          "combined-stream": "^1.0.6",
          "mime-types": "^2.1.12"
        }
      },
      "node_modules/fs-exists-cached": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/fs-exists-cached/-/fs-exists-cached-1.0.0.tgz",
        "integrity": "sha1-zyVVTKBQ3EmuZla0HeQiWJidy84="
      },
      "node_modules/fs.realpath": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/fs.realpath/-/fs.realpath-1.0.0.tgz",
        "integrity": "sha1-FQStJSMVjKpA20onh8sBQRmU6k8="
      },
      "node_modules/function-loop": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/function-loop/-/function-loop-1.0.2.tgz",
        "integrity": "sha512-Iw4MzMfS3udk/rqxTiDDCllhGwlOrsr50zViTOO/W6lS/9y6B1J0BD2VZzrnWUYBJsl3aeqjgR5v7bWWhZSYbA=="
      },
      "node_modules/get-caller-file": {
        "version": "2.0.5",
        "resolved": "https://registry.npmjs.org/get-caller-file/-/get-caller-file-2.0.5.tgz",
        "integrity": "sha512-DyFP3BM/3YHTQOCUL/w0OZHR0lpKeGrxotcHWcqNEdnltqFwXVfhEBQ94eIo34AfQpo0rGki4cyIiftY06h2Fg=="
      },
      "node_modules/getpass": {
        "version": "0.1.7",
        "resolved": "https://registry.npmjs.org/getpass/-/getpass-0.1.7.tgz",
        "integrity": "sha1-Xv+OPmhNVprkyysSgmBOi6YhSfo=",
        "dependencies": {
          "assert-plus": "^1.0.0"
        }
      },
      "node_modules/glob": {
        "version": "7.1.6",
        "resolved": "https://registry.npmjs.org/glob/-/glob-7.1.6.tgz",
        "integrity": "sha512-LwaxwyZ72Lk7vZINtNNrywX0ZuLyStrdDtabefZKAY5ZGJhVtgdznluResxNmPitE0SAO+O26sWTHeKSI2wMBA==",
        "dependencies": {
          "fs.realpath": "^1.0.0",
          "inflight": "^1.0.4",
          "inherits": "2",
          "minimatch": "^3.0.4",
          "once": "^1.3.0",
          "path-is-absolute": "^1.0.0"
        }
      },
      "node_modules/globals": {
        "version": "11.12.0",
        "resolved": "https://registry.npmjs.org/globals/-/globals-11.12.0.tgz",
        "integrity": "sha512-WOBp/EEGUiIsJSp7wcv/y6MO+lV9UoncWqxuFfm8eBwzWNgyfBd6Gz+IeKQ9jCmyhoH99g15M3T+QaVHFjizVA=="
      },
      "node_modules/graceful-fs": {
        "version": "4.2.3",
        "resolved": "https://registry.npmjs.org/graceful-fs/-/graceful-fs-4.2.3.tgz",
        "integrity": "sha512-a30VEBm4PEdx1dRB7MFK7BejejvCvBronbLjht+sHuGYj8PHs7M/5Z+rt5lw551vZ7yfTCj4Vuyy3mSJytDWRQ=="
      },
      "node_modules/har-schema": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/har-schema/-/har-schema-2.0.0.tgz",
        "integrity": "sha1-qUwiJOvKwEeCoNkDVSHyRzW37JI="
      },
      "node_modules/har-validator": {
        "version": "5.1.3",
        "resolved": "https://registry.npmjs.org/har-validator/-/har-validator-5.1.3.tgz",
        "integrity": "sha512-sNvOCzEQNr/qrvJgc3UG/kD4QtlHycrzwS+6mfTrrSq97BvaYcPZZI1ZSqGSPR73Cxn4LKTD4PttRwfU7jWq5g==",
        "dependencies": {
          "ajv": "^6.5.5",
          "har-schema": "^2.0.0"
        }
      },
      "node_modules/has-flag": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/has-flag/-/has-flag-3.0.0.tgz",
        "integrity": "sha1-tdRU3CGZriJWmfNGfloH87lVuv0="
      },
      "node_modules/hasha": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/hasha/-/hasha-3.0.0.tgz",
        "integrity": "sha1-UqMvq4Vp1BymmmH/GiFPjrfIvTk=",
        "dependencies": {
          "is-stream": "^1.0.1"
        }
      },
      "node_modules/hosted-git-info": {
        "version": "2.8.8",
        "resolved": "https://registry.npmjs.org/hosted-git-info/-/hosted-git-info-2.8.8.tgz",
        "integrity": "sha512-f/wzC2QaWBs7t9IYqB4T3sR1xviIViXJRJTWBlx2Gf3g0Xi5vI7Yy4koXQ1c9OYDGHN9sBy1DQ2AB8fqZBWhUg=="
      },
      "node_modules/html-escaper": {
        "version": "2.0.1",
        "resolved": "https://registry.npmjs.org/html-escaper/-/html-escaper-2.0.1.tgz",
        "integrity": "sha512-hNX23TjWwD3q56HpWjUHOKj1+4KKlnjv9PcmBUYKVpga+2cnb9nDx/B1o0yO4n+RZXZdiNxzx6B24C9aNMTkkQ=="
      },
      "node_modules/http-signature": {
        "version": "1.2.0",
        "resolved": "https://registry.npmjs.org/http-signature/-/http-signature-1.2.0.tgz",
        "integrity": "sha1-muzZJRFHcvPZW2WmCruPfBj7rOE=",
        "dependencies": {
          "assert-plus": "^1.0.0",
          "jsprim": "^1.2.2",
          "sshpk": "^1.7.0"
        }
      },
      "node_modules/imurmurhash": {
        "version": "0.1.4",
        "resolved": "https://registry.npmjs.org/imurmurhash/-/imurmurhash-0.1.4.tgz",
        "integrity": "sha1-khi5srkoojixPcT7a21XbyMUU+o="
      },
      "node_modules/inflight": {
        "version": "1.0.6",
        "resolved": "https://registry.npmjs.org/inflight/-/inflight-1.0.6.tgz",
        "integrity": "sha1-Sb1jMdfQLQwJvJEKEHW6gWW1bfk=",
        "dependencies": {
          "once": "^1.3.0",
          "wrappy": "1"
        }
      },
      "node_modules/inherits": {
        "version": "2.0.4",
        "resolved": "https://registry.npmjs.org/inherits/-/inherits-2.0.4.tgz",
        "integrity": "sha512-k/vGaX4/Yla3WzyMCvTQOXYeIHvqOKtnqBduzTHpzpQZzAskKMhZ2K+EnBiSM9zGSoIFeMpXKxa4dYeZIQqewQ=="
      },
      "node_modules/is-arrayish": {
        "version": "0.2.1",
        "resolved": "https://registry.npmjs.org/is-arrayish/-/is-arrayish-0.2.1.tgz",
        "integrity": "sha1-d8mYQFJ6qOyxqLppe4BkWnqSap0="
      },
      "node_modules/is-fullwidth-code-point": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/is-fullwidth-code-point/-/is-fullwidth-code-point-2.0.0.tgz",
        "integrity": "sha1-o7MKXE8ZkYMWeqq5O+764937ZU8="
      },
      "node_modules/is-stream": {
        "version": "1.1.0",
        "resolved": "https://registry.npmjs.org/is-stream/-/is-stream-1.1.0.tgz",
        "integrity": "sha1-EtSj3U5o4Lec6428hBc66A2RykQ="
      },
      "node_modules/is-typedarray": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/is-typedarray/-/is-typedarray-1.0.0.tgz",
        "integrity": "sha1-5HnICFjfDBsR3dppQPlgEfzaSpo="
      },
      "node_modules/isarray": {
        "name": "isarray",
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/isarray/-/isarray-1.0.0.tgz",
        "integrity": "sha1-u5NdSFgsuhaMBoNJV6VKPgcSTxE=",
        "optional": true
      },
      "node_modules/isexe": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/isexe/-/isexe-2.0.0.tgz",
        "integrity": "sha1-6PvzdNxVb/iUehDcsFctYz8s+hA="
      },
      "node_modules/isstream": {
        "version": "0.1.2",
        "resolved": "https://registry.npmjs.org/isstream/-/isstream-0.1.2.tgz",
        "integrity": "sha1-R+Y/evVa+m+S4VAOaQ64uFKcCZo="
      },
      "node_modules/istanbul-lib-coverage": {
        "version": "2.0.5",
        "resolved": "https://registry.npmjs.org/istanbul-lib-coverage/-/istanbul-lib-coverage-2.0.5.tgz",
        "integrity": "sha512-8aXznuEPCJvGnMSRft4udDRDtb1V3pkQkMMI5LI+6HuQz5oQ4J2UFn1H82raA3qJtyOLkkwVqICBQkjnGtn5mA=="
      },
      "node_modules/istanbul-lib-hook": {
        "version": "2.0.7",
        "resolved": "https://registry.npmjs.org/istanbul-lib-hook/-/istanbul-lib-hook-2.0.7.tgz",
        "integrity": "sha512-vrRztU9VRRFDyC+aklfLoeXyNdTfga2EI3udDGn4cZ6fpSXpHLV9X6CHvfoMCPtggg8zvDDmC4b9xfu0z6/llA==",
        "dependencies": {
          "append-transform": "^1.0.0"
        }
      },
      "node_modules/istanbul-lib-instrument": {
        "version": "3.3.0",
        "resolved": "https://registry.npmjs.org/istanbul-lib-instrument/-/istanbul-lib-instrument-3.3.0.tgz",
        "integrity": "sha512-5nnIN4vo5xQZHdXno/YDXJ0G+I3dAm4XgzfSVTPLQpj/zAV2dV6Juy0yaf10/zrJOJeHoN3fraFe+XRq2bFVZA==",
        "dependencies": {
          "@babel/generator": "^7.4.0",
          "@babel/parser": "^7.4.3",
          "@babel/template": "^7.4.0",
          "@babel/traverse": "^7.4.3",
          "@babel/types": "^7.4.0",
          "istanbul-lib-coverage": "^2.0.5",
          "semver": "^6.0.0"
        }
      },
      "node_modules/istanbul-lib-instrument/node_modules/semver": {
        "version": "6.3.0",
        "resolved": "https://registry.npmjs.org/semver/-/semver-6.3.0.tgz",
        "integrity": "sha512-b39TBaTSfV6yBrapU89p5fKekE2m/NwnDocOVruQFS1/veMgdzuPcnOM34M6CwxW8jH/lxEa5rBoDeUwu5HHTw=="
      },
      "node_modules/istanbul-lib-report": {
        "version": "2.0.8",
        "resolved": "https://registry.npmjs.org/istanbul-lib-report/-/istanbul-lib-report-2.0.8.tgz",
        "integrity": "sha512-fHBeG573EIihhAblwgxrSenp0Dby6tJMFR/HvlerBsrCTD5bkUuoNtn3gVh29ZCS824cGGBPn7Sg7cNk+2xUsQ==",
        "dependencies": {
          "istanbul-lib-coverage": "^2.0.5",
          "make-dir": "^2.1.0",
          "supports-color": "^6.1.0"
        }
      },
      "node_modules/istanbul-lib-report/node_modules/supports-color": {
        "version": "6.1.0",
        "resolved": "https://registry.npmjs.org/supports-color/-/supports-color-6.1.0.tgz",
        "integrity": "sha512-qe1jfm1Mg7Nq/NSh6XE24gPXROEVsWHxC1LIx//XNlD9iw7YZQGjZNjYN7xGaEG6iKdA8EtNFW6R0gjnVXp+wQ==",
        "dependencies": {
          "has-flag": "^3.0.0"
        }
      },
      "node_modules/istanbul-lib-source-maps": {
        "version": "3.0.6",
        "resolved": "https://registry.npmjs.org/istanbul-lib-source-maps/-/istanbul-lib-source-maps-3.0.6.tgz",
        "integrity": "sha512-R47KzMtDJH6X4/YW9XTx+jrLnZnscW4VpNN+1PViSYTejLVPWv7oov+Duf8YQSPyVRUvueQqz1TcsC6mooZTXw==",
        "dependencies": {
          "debug": "^4.1.1",
          "istanbul-lib-coverage": "^2.0.5",
          "make-dir": "^2.1.0",
          "rimraf": "^2.6.3",
          "source-map": "^0.6.1"
        }
      },
      "node_modules/istanbul-reports": {
        "version": "2.2.7",
        "resolved": "https://registry.npmjs.org/istanbul-reports/-/istanbul-reports-2.2.7.tgz",
        "integrity": "sha512-uu1F/L1o5Y6LzPVSVZXNOoD/KXpJue9aeLRd0sM9uMXfZvzomB0WxVamWb5ue8kA2vVWEmW7EG+A5n3f1kqHKg==",
        "dependencies": {
          "html-escaper": "^2.0.0"
        }
      },
      "node_modules/js-tokens": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/js-tokens/-/js-tokens-4.0.0.tgz",
        "integrity": "sha512-RdJUflcE3cUzKiMqQgsCu06FPu9UdIJO0beYbPhHN4k6apgJtifcoCtT9bcxOpYBtpD2kCM6Sbzg4CausW/PKQ=="
      },
      "node_modules/js-yaml": {
        "version": "3.13.1",
        "resolved": "https://registry.npmjs.org/js-yaml/-/js-yaml-3.13.1.tgz",
        "integrity": "sha512-YfbcO7jXDdyj0DGxYVSlSeQNHbD7XPWvrVWeVUujrQEoZzWJIRrCPoyk6kL6IAjAG2IolMK4T0hNUe0HOUs5Jw==",
        "dependencies": {
          "argparse": "^1.0.7",
          "esprima": "^4.0.0"
        }
      },
      "node_modules/jsbn": {
        "version": "0.1.1",
        "resolved": "https://registry.npmjs.org/jsbn/-/jsbn-0.1.1.tgz",
        "integrity": "sha1-peZUwuWi3rXyAdls77yoDA7y9RM="
      },
      "node_modules/jsesc": {
        "version": "2.5.2",
        "resolved": "https://registry.npmjs.org/jsesc/-/jsesc-2.5.2.tgz",
        "integrity": "sha512-OYu7XEzjkCQ3C5Ps3QIZsQfNpqoJyZZA99wd9aWd05NCtC5pWOkShK2mkL6HXQR6/Cy2lbNdPlZBpuQHXE63gA=="
      },
      "node_modules/json-parse-better-errors": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/json-parse-better-errors/-/json-parse-better-errors-1.0.2.tgz",
        "integrity": "sha512-mrqyZKfX5EhL7hvqcV6WG1yYjnjeuYDzDhhcAAUrq8Po85NBQBJP+ZDUT75qZQ98IkUoBqdkExkukOU7Ts2wrw=="
      },
      "node_modules/json-schema": {
        "version": "0.2.3",
        "resolved": "https://registry.npmjs.org/json-schema/-/json-schema-0.2.3.tgz",
        "integrity": "sha1-tIDIkuWaLwWVTOcnvT8qTogvnhM="
      },
      "node_modules/json-schema-traverse": {
        "version": "0.4.1",
        "resolved": "https://registry.npmjs.org/json-schema-traverse/-/json-schema-traverse-0.4.1.tgz",
        "integrity": "sha512-xbbCH5dCYU5T8LcEhhuh7HJ88HXuW3qsI3Y0zOZFKfZEHcpWiHU/Jxzk629Brsab/mMiHQti9wMP+845RPe3Vg=="
      },
      "node_modules/json-stringify-safe": {
        "version": "5.0.1",
        "resolved": "https://registry.npmjs.org/json-stringify-safe/-/json-stringify-safe-5.0.1.tgz",
        "integrity": "sha1-Epai1Y/UXxmg9s4B1lcB4sc1tus="
      },
      "node_modules/jsprim": {
        "version": "1.4.1",
        "resolved": "https://registry.npmjs.org/jsprim/-/jsprim-1.4.1.tgz",
        "integrity": "sha1-MT5mvB5cwG5Di8G3SZwuXFastqI=",
        "dependencies": {
          "assert-plus": "1.0.0",
          "extsprintf": "1.3.0",
          "json-schema": "0.2.3",
          "verror": "1.10.0"
        }
      },
      "node_modules/lcov-parse": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/lcov-parse/-/lcov-parse-1.0.0.tgz",
        "integrity": "sha1-6w1GtUER68VhrLTECO+TY73I9+A="
      },
      "node_modules/load-json-file": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/load-json-file/-/load-json-file-4.0.0.tgz",
        "integrity": "sha1-L19Fq5HjMhYjT9U62rZo607AmTs=",
        "dependencies": {
          "graceful-fs": "^4.1.2",
          "parse-json": "^4.0.0",
          "pify": "^3.0.0",
          "strip-bom": "^3.0.0"
        }
      },
      "node_modules/load-json-file/node_modules/pify": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/pify/-/pify-3.0.0.tgz",
        "integrity": "sha1-5aSs0sEB/fPZpNB/DbxNtJ3SgXY="
      },
      "node_modules/locate-path": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/locate-path/-/locate-path-3.0.0.tgz",
        "integrity": "sha512-7AO748wWnIhNqAuaty2ZWHkQHRSNfPVIsPIfwEOWO22AmaoVrWavlOcMR5nzTLNYvp36X220/maaRsrec1G65A==",
        "dependencies": {
          "p-locate": "^3.0.0",
          "path-exists": "^3.0.0"
        }
      },
      "node_modules/lodash": {
        "version": "4.17.15",
        "resolved": "https://registry.npmjs.org/lodash/-/lodash-4.17.15.tgz",
        "integrity": "sha512-8xOcRHvCjnocdS5cpwXQXVzmmh5e5+saE2QGoeQmbKmRS6J3VQppPOIt0MnmE+4xlZoumy0GPG0D0MVIQbNA1A=="
      },
      "node_modules/lodash.flattendeep": {
        "version": "4.4.0",
        "resolved": "https://registry.npmjs.org/lodash.flattendeep/-/lodash.flattendeep-4.4.0.tgz",
        "integrity": "sha1-+wMJF/hqMTTlvJvsDWngAT3f7bI="
      },
      "node_modules/log-driver": {
        "version": "1.2.7",
        "resolved": "https://registry.npmjs.org/log-driver/-/log-driver-1.2.7.tgz",
        "integrity": "sha512-U7KCmLdqsGHBLeWqYlFA0V0Sl6P08EE1ZrmA9cxjUE0WVqT9qnyVDPz1kzpFEP0jdJuFnasWIfSd7fsaNXkpbg=="
      },
      "node_modules/lru-cache": {
        "version": "4.1.5",
        "resolved": "https://registry.npmjs.org/lru-cache/-/lru-cache-4.1.5.tgz",
        "integrity": "sha512-sWZlbEP2OsHNkXrMl5GYk/jKk70MBng6UU4YI/qGDYbgf6YbP4EvmqISbXCoJiRKs+1bSpFHVgQxvJ17F2li5g==",
        "dependencies": {
          "pseudomap": "^1.0.2",
          "yallist": "^2.1.2"
        }
      },
      "node_modules/make-dir": {
        "version": "2.1.0",
        "resolved": "https://registry.npmjs.org/make-dir/-/make-dir-2.1.0.tgz",
        "integrity": "sha512-LS9X+dc8KLxXCb8dni79fLIIUA5VyZoyjSMCwTluaXA0o27cCK0bhXkpgw+sTXVpPy/lSO57ilRixqk0vDmtRA==",
        "dependencies": {
          "pify": "^4.0.1",
          "semver": "^5.6.0"
        }
      },
      "node_modules/make-error": {
        "version": "1.3.6",
        "resolved": "https://registry.npmjs.org/make-error/-/make-error-1.3.6.tgz",
        "integrity": "sha512-s8UhlNe7vPKomQhC1qFelMokr/Sc3AgNbso3n74mVPA5LTZwkB9NlXf4XPamLxJE8h0gh73rM94xvwRT2CVInw=="
      },
      "node_modules/merge-source-map": {
        "version": "1.1.0",
        "resolved": "https://registry.npmjs.org/merge-source-map/-/merge-source-map-1.1.0.tgz",
        "integrity": "sha512-Qkcp7P2ygktpMPh2mCQZaf3jhN6D3Z/qVZHSdWvQ+2Ef5HgRAPBO57A77+ENm0CPx2+1Ce/MYKi3ymqdfuqibw==",
        "dependencies": {
          "source-map": "^0.6.1"
        }
      },
      "node_modules/mime-db": {
        "version": "1.43.0",
        "resolved": "https://registry.npmjs.org/mime-db/-/mime-db-1.43.0.tgz",
        "integrity": "sha512-+5dsGEEovYbT8UY9yD7eE4XTc4UwJ1jBYlgaQQF38ENsKR3wj/8q8RFZrF9WIZpB2V1ArTVFUva8sAul1NzRzQ=="
      },
      "node_modules/mime-types": {
        "version": "2.1.26",
        "resolved": "https://registry.npmjs.org/mime-types/-/mime-types-2.1.26.tgz",
        "integrity": "sha512-01paPWYgLrkqAyrlDorC1uDwl2p3qZT7yl806vW7DvDoxwXi46jsjFbg+WdwotBIk6/MbEhO/dh5aZ5sNj/dWQ==",
        "dependencies": {
          "mime-db": "1.43.0"
        }
      },
      "node_modules/minimatch": {
        "version": "3.0.4",
        "resolved": "https://registry.npmjs.org/minimatch/-/minimatch-3.0.4.tgz",
        "integrity": "sha512-yJHVQEhyqPLUTgt9B83PXu6W3rx4MvvHvSUvToogpwoGDOUQ+yDrR0HRot+yOCdCO7u4hX3pWft6kWBBcqh0UA==",
        "dependencies": {
          "brace-expansion": "^1.1.7"
        }
      },
      "node_modules/minimist": {
        "version": "1.2.5",
        "resolved": "https://registry.npmjs.org/minimist/-/minimist-1.2.5.tgz",
        "integrity": "sha512-FM9nNUYrRBAELZQT3xeZQ7fmMOBg6nWNmJKTcgsJeaLstP/UODVpGsr5OhXhhXg6f+qtJ8uiZ+PUxkDWcgIXLw=="
      },
      "node_modules/minipass": {
        "name": "minipass",
        "version": "2.9.0",
        "resolved": "https://registry.npmjs.org/minipass/-/minipass-2.9.0.tgz",
        "integrity": "sha512-wxfUjg9WebH+CUDX/CdbRlh5SmfZiy/hpkxaRI16Y9W56Pa75sWgd/rvFilSgrauD9NyFymP/+JFV3KwzIsJeg==",
        "dependencies": {
          "safe-buffer": "^5.1.2",
          "yallist": "^3.0.0"
        }
      },
      "node_modules/minipass/node_modules/yallist": {
        "name": "yallist",
        "version": "3.1.1",
        "resolved": "https://registry.npmjs.org/yallist/-/yallist-3.1.1.tgz",
        "integrity": "sha512-a4UGQaWPH59mOXUYnAG2ewncQS4i4F43Tv3JoAM+s2VDAmS9NsK8GpDMLrCHPksFT7h3K6TOoUNn2pb7RoXx4g=="
      },
      "node_modules/ms": {
        "version": "2.1.2",
        "resolved": "https://registry.npmjs.org/ms/-/ms-2.1.2.tgz",
        "integrity": "sha512-sGkPx+VjMtmA6MX27oA4FBFELFCZZ4S4XqeGOXCv68tT+jb3vk/RyaKWP0PTKyWtmLSM0b+adUTEvbs1PEaH2w=="
      },
      "node_modules/nested-error-stacks": {
        "version": "2.1.0",
        "resolved": "https://registry.npmjs.org/nested-error-stacks/-/nested-error-stacks-2.1.0.tgz",
        "integrity": "sha512-AO81vsIO1k1sM4Zrd6Hu7regmJN1NSiAja10gc4bX3F0wd+9rQmcuHQaHVQCYIEC8iFXnE+mavh23GOt7wBgug=="
      },
      "node_modules/normalize-package-data": {
        "version": "2.5.0",
        "resolved": "https://registry.npmjs.org/normalize-package-data/-/normalize-package-data-2.5.0.tgz",
        "integrity": "sha512-/5CMN3T0R4XTj4DcGaexo+roZSdSFW/0AOOTROrjxzCG1wrWXEsGbRKevjlIL+ZDE4sZlJr5ED4YW0yqmkK+eA==",
        "dependencies": {
          "hosted-git-info": "^2.1.4",
          "resolve": "^1.10.0",
          "semver": "2 || 3 || 4 || 5",
          "validate-npm-package-license": "^3.0.1"
        }
      },
      "node_modules/nyc": {
        "version": "14.1.1",
        "resolved": "https://registry.npmjs.org/nyc/-/nyc-14.1.1.tgz",
        "integrity": "sha512-OI0vm6ZGUnoGZv/tLdZ2esSVzDwUC88SNs+6JoSOMVxA+gKMB8Tk7jBwgemLx4O40lhhvZCVw1C+OYLOBOPXWw==",
        "dependencies": {
          "archy": "^1.0.0",
          "caching-transform": "^3.0.2",
          "convert-source-map": "^1.6.0",
          "cp-file": "^6.2.0",
          "find-cache-dir": "^2.1.0",
          "find-up": "^3.0.0",
          "foreground-child": "^1.5.6",
          "glob": "^7.1.3",
          "istanbul-lib-coverage": "^2.0.5",
          "istanbul-lib-hook": "^2.0.7",
          "istanbul-lib-instrument": "^3.3.0",
          "istanbul-lib-report": "^2.0.8",
          "istanbul-lib-source-maps": "^3.0.6",
          "istanbul-reports": "^2.2.4",
          "js-yaml": "^3.13.1",
          "make-dir": "^2.1.0",
          "merge-source-map": "^1.1.0",
          "resolve-from": "^4.0.0",
          "rimraf": "^2.6.3",
          "signal-exit": "^3.0.2",
          "spawn-wrap": "^1.4.2",
          "test-exclude": "^5.2.3",
          "uuid": "^3.3.2",
          "yargs": "^13.2.2",
          "yargs-parser": "^13.0.0"
        }
      },
      "node_modules/oauth-sign": {
        "version": "0.9.0",
        "resolved": "https://registry.npmjs.org/oauth-sign/-/oauth-sign-0.9.0.tgz",
        "integrity": "sha512-fexhUFFPTGV8ybAtSIGbV6gOkSv8UtRbDBnAyLQw4QPKkgNlsH2ByPGtMUqdWkos6YCRmAqViwgZrJc/mRDzZQ=="
      },
      "node_modules/once": {
        "version": "1.4.0",
        "resolved": "https://registry.npmjs.org/once/-/once-1.4.0.tgz",
        "integrity": "sha1-WDsap3WWHUsROsF9nFC6753Xa9E=",
        "dependencies": {
          "wrappy": "1"
        }
      },
      "node_modules/opener": {
        "version": "1.5.1",
        "resolved": "https://registry.npmjs.org/opener/-/opener-1.5.1.tgz",
        "integrity": "sha512-goYSy5c2UXE4Ra1xixabeVh1guIX/ZV/YokJksb6q2lubWu6UbvPQ20p542/sFIll1nl8JnCyK9oBaOcCWXwvA=="
      },
      "node_modules/os-homedir": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/os-homedir/-/os-homedir-1.0.2.tgz",
        "integrity": "sha1-/7xJiDNuDoM94MFox+8VISGqf7M="
      },
      "node_modules/own-or": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/own-or/-/own-or-1.0.0.tgz",
        "integrity": "sha1-Tod/vtqaLsgAD7wLyuOWRe6L+Nw="
      },
      "node_modules/own-or-env": {
        "version": "1.0.1",
        "resolved": "https://registry.npmjs.org/own-or-env/-/own-or-env-1.0.1.tgz",
        "integrity": "sha512-y8qULRbRAlL6x2+M0vIe7jJbJx/kmUTzYonRAa2ayesR2qWLswninkVyeJe4x3IEXhdgoNodzjQRKAoEs6Fmrw==",
        "dependencies": {
          "own-or": "^1.0.0"
        }
      },
      "node_modules/p-limit": {
        "version": "2.2.2",
        "resolved": "https://registry.npmjs.org/p-limit/-/p-limit-2.2.2.tgz",
        "integrity": "sha512-WGR+xHecKTr7EbUEhyLSh5Dube9JtdiG78ufaeLxTgpudf/20KqyMioIUZJAezlTIi6evxuoUs9YXc11cU+yzQ==",
        "dependencies": {
          "p-try": "^2.0.0"
        }
      },
      "node_modules/p-locate": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/p-locate/-/p-locate-3.0.0.tgz",
        "integrity": "sha512-x+12w/To+4GFfgJhBEpiDcLozRJGegY+Ei7/z0tSLkMmxGZNybVMSfWj9aJn8Z5Fc7dBUNJOOVgPv2H7IwulSQ==",
        "dependencies": {
          "p-limit": "^2.0.0"
        }
      },
      "node_modules/p-try": {
        "version": "2.2.0",
        "resolved": "https://registry.npmjs.org/p-try/-/p-try-2.2.0.tgz",
        "integrity": "sha512-R4nPAVTAU0B9D35/Gk3uJf/7XYbQcyohSKdvAxIRSNghFl4e71hVoGnBNQz9cWaXxO2I10KTC+3jMdvvoKw6dQ=="
      },
      "node_modules/package-hash": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/package-hash/-/package-hash-3.0.0.tgz",
        "integrity": "sha512-lOtmukMDVvtkL84rJHI7dpTYq+0rli8N2wlnqUcBuDWCfVhRUfOmnR9SsoHFMLpACvEV60dX7rd0rFaYDZI+FA==",
        "dependencies": {
          "graceful-fs": "^4.1.15",
          "hasha": "^3.0.0",
          "lodash.flattendeep": "^4.4.0",
          "release-zalgo": "^1.0.0"
        }
      },
      "node_modules/parse-json": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/parse-json/-/parse-json-4.0.0.tgz",
        "integrity": "sha1-vjX1Qlvh9/bHRxhPmKeIy5lHfuA=",
        "dependencies": {
          "error-ex": "^1.3.1",
          "json-parse-better-errors": "^1.0.1"
        }
      },
      "node_modules/path-exists": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/path-exists/-/path-exists-3.0.0.tgz",
        "integrity": "sha1-zg6+ql94yxiSXqfYENe1mwEP1RU="
      },
      "node_modules/path-is-absolute": {
        "version": "1.0.1",
        "resolved": "https://registry.npmjs.org/path-is-absolute/-/path-is-absolute-1.0.1.tgz",
        "integrity": "sha1-F0uSaHNVNP+8es5r9TpanhtcX18="
      },
      "node_modules/path-parse": {
        "version": "1.0.6",
        "resolved": "https://registry.npmjs.org/path-parse/-/path-parse-1.0.6.tgz",
        "integrity": "sha512-GSmOT2EbHrINBf9SR7CDELwlJ8AENk3Qn7OikK4nFYAu3Ote2+JYNVvkpAEQm3/TLNEJFD/xZJjzyxg3KBWOzw=="
      },
      "node_modules/path-type": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/path-type/-/path-type-3.0.0.tgz",
        "integrity": "sha512-T2ZUsdZFHgA3u4e5PfPbjd7HDDpxPnQb5jN0SrDsjNSuVXHJqtwTnWqG0B1jZrgmJ/7lj1EmVIByWt1gxGkWvg==",
        "dependencies": {
          "pify": "^3.0.0"
        }
      },
      "node_modules/path-type/node_modules/pify": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/pify/-/pify-3.0.0.tgz",
        "integrity": "sha1-5aSs0sEB/fPZpNB/DbxNtJ3SgXY="
      },
      "node_modules/performance-now": {
        "version": "2.1.0",
        "resolved": "https://registry.npmjs.org/performance-now/-/performance-now-2.1.0.tgz",
        "integrity": "sha1-Ywn04OX6kT7BxpMHrjZLSzd8nns="
      },
      "node_modules/pify": {
        "version": "4.0.1",
        "resolved": "https://registry.npmjs.org/pify/-/pify-4.0.1.tgz",
        "integrity": "sha512-uB80kBFb/tfd68bVleG9T5GGsGPjJrLAUpR5PZIrhBnIaRTQRjqdJSsIKkOP6OAIFbj7GOrcudc5pNjZ+geV2g=="
      },
      "node_modules/pkg-dir": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/pkg-dir/-/pkg-dir-3.0.0.tgz",
        "integrity": "sha512-/E57AYkoeQ25qkxMj5PBOVgF8Kiu/h7cYS30Z5+R7WaiCCBfLq58ZI/dSeaEKb9WVJV5n/03QwrN3IeWIFllvw==",
        "dependencies": {
          "find-up": "^3.0.0"
        }
      },
      "node_modules/process-nextick-args": {
        "name": "process-nextick-args",
        "version": "2.0.1",
        "resolved": "https://registry.npmjs.org/process-nextick-args/-/process-nextick-args-2.0.1.tgz",
        "integrity": "sha512-3ouUOpQhtgrbOa17J7+uxOTpITYWaGP7/AhoR3+A+/1e9skrzelGi/dXzEYyvbxubEF6Wn2ypscTKiKJFFn1ag==",
        "optional": true
      },
      "node_modules/pseudomap": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/pseudomap/-/pseudomap-1.0.2.tgz",
        "integrity": "sha1-8FKijacOYYkX7wqKw0wa5aaChrM="
      },
      "node_modules/psl": {
        "version": "1.8.0",
        "resolved": "https://registry.npmjs.org/psl/-/psl-1.8.0.tgz",
        "integrity": "sha512-RIdOzyoavK+hA18OGGWDqUTsCLhtA7IcZ/6NCs4fFJaHBDab+pDDmDIByWFRQJq2Cd7r1OoQxBGKOaztq+hjIQ=="
      },
      "node_modules/punycode": {
        "version": "2.1.1",
        "resolved": "https://registry.npmjs.org/punycode/-/punycode-2.1.1.tgz",
        "integrity": "sha512-XRsRjdf+j5ml+y/6GKHPZbrF/8p2Yga0JPtdqTIY2Xe5ohJPD9saDJJLPvp9+NSBprVvevdXZybnj2cv8OEd0A=="
      },
      "node_modules/qs": {
        "version": "6.5.2",
        "resolved": "https://registry.npmjs.org/qs/-/qs-6.5.2.tgz",
        "integrity": "sha512-N5ZAX4/LxJmF+7wN74pUD6qAh9/wnvdQcjq9TZjevvXzSUo7bfmw91saqMjzGS2xq91/odN2dW/WOl7qQHNDGA=="
      },
      "node_modules/read-pkg": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/read-pkg/-/read-pkg-3.0.0.tgz",
        "integrity": "sha1-nLxoaXj+5l0WwA4rGcI3/Pbjg4k=",
        "dependencies": {
          "load-json-file": "^4.0.0",
          "normalize-package-data": "^2.3.2",
          "path-type": "^3.0.0"
        }
      },
      "node_modules/read-pkg-up": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/read-pkg-up/-/read-pkg-up-4.0.0.tgz",
        "integrity": "sha512-6etQSH7nJGsK0RbG/2TeDzZFa8shjQ1um+SwQQ5cwKy0dhSXdOncEhb1CPpvQG4h7FyOV6EB6YlV0yJvZQNAkA==",
        "dependencies": {
          "find-up": "^3.0.0",
          "read-pkg": "^3.0.0"
        }
      },
      "node_modules/readable-stream": {
        "name": "readable-stream",
        "version": "2.3.7",
        "resolved": "https://registry.npmjs.org/readable-stream/-/readable-stream-2.3.7.tgz",
        "integrity": "sha512-Ebho8K4jIbHAxnuxi7o42OrZgF/ZTNcsZj6nRKyUmkhLFq8CHItp/fy6hQZuZmP/n3yZ9VBUbp4zz/mX8hmYPw==",
        "optional": true,
        "dependencies": {
          "core-util-is": "~1.0.0",
          "inherits": "~2.0.3",
          "isarray": "~1.0.0",
          "process-nextick-args": "~2.0.0",
          "safe-buffer": "~5.1.1",
          "string_decoder": "~1.1.1",
          "util-deprecate": "~1.0.1"
        }
      },
      "node_modules/readable-stream/node_modules/safe-buffer": {
        "name": "safe-buffer",
        "version": "5.1.2",
        "resolved": "https://registry.npmjs.org/safe-buffer/-/safe-buffer-5.1.2.tgz",
        "integrity": "sha512-Gd2UZBJDkXlY7GbJxfsE8/nvKkUEU1G38c1siN6QP6a9PT9MmHB8GnpscSmMJSoF8LOIrt8ud/wPtojys4G6+g==",
        "optional": true
      },
      "node_modules/release-zalgo": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/release-zalgo/-/release-zalgo-1.0.0.tgz",
        "integrity": "sha1-CXALflB0Mpc5Mw5TXFqQ+2eFFzA=",
        "dependencies": {
          "es6-error": "^4.0.1"
        }
      },
      "node_modules/request": {
        "version": "2.88.2",
        "resolved": "https://registry.npmjs.org/request/-/request-2.88.2.tgz",
        "integrity": "sha512-MsvtOrfG9ZcrOwAW+Qi+F6HbD0CWXEh9ou77uOb7FM2WPhwT7smM833PzanhJLsgXjN89Ir6V2PczXNnMpwKhw==",
        "dependencies": {
          "aws-sign2": "~0.7.0",
          "aws4": "^1.8.0",
          "caseless": "~0.12.0",
          "combined-stream": "~1.0.6",
          "extend": "~3.0.2",
          "forever-agent": "~0.6.1",
          "form-data": "~2.3.2",
          "har-validator": "~5.1.3",
          "http-signature": "~1.2.0",
          "is-typedarray": "~1.0.0",
          "isstream": "~0.1.2",
          "json-stringify-safe": "~5.0.1",
          "mime-types": "~2.1.19",
          "oauth-sign": "~0.9.0",
          "performance-now": "^2.1.0",
          "qs": "~6.5.2",
          "safe-buffer": "^5.1.2",
          "tough-cookie": "~2.5.0",
          "tunnel-agent": "^0.6.0",
          "uuid": "^3.3.2"
        }
      },
      "node_modules/require-directory": {
        "version": "2.1.1",
        "resolved": "https://registry.npmjs.org/require-directory/-/require-directory-2.1.1.tgz",
        "integrity": "sha1-jGStX9MNqxyXbiNE/+f3kqam30I="
      },
      "node_modules/require-main-filename": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/require-main-filename/-/require-main-filename-2.0.0.tgz",
        "integrity": "sha512-NKN5kMDylKuldxYLSUfrbo5Tuzh4hd+2E8NPPX02mZtn1VuREQToYe/ZdlJy+J3uCpfaiGF05e7B8W0iXbQHmg=="
      },
      "node_modules/resolve": {
        "version": "1.15.1",
        "resolved": "https://registry.npmjs.org/resolve/-/resolve-1.15.1.tgz",
        "integrity": "sha512-84oo6ZTtoTUpjgNEr5SJyzQhzL72gaRodsSfyxC/AXRvwu0Yse9H8eF9IpGo7b8YetZhlI6v7ZQ6bKBFV/6S7w==",
        "dependencies": {
          "path-parse": "^1.0.6"
        }
      },
      "node_modules/resolve-from": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/resolve-from/-/resolve-from-4.0.0.tgz",
        "integrity": "sha512-pb/MYmXstAkysRFx8piNI1tGFNQIFA3vkE3Gq4EuA1dF6gHp/+vgZqsCGJapvy8N3Q+4o7FwvquPJcnZ7RYy4g=="
      },
      "node_modules/rimraf": {
        "version": "2.7.1",
        "resolved": "https://registry.npmjs.org/rimraf/-/rimraf-2.7.1.tgz",
        "integrity": "sha512-uWjbaKIK3T1OSVptzX7Nl6PvQ3qAGtKEtVRjRuazjfL3Bx5eI409VZSqgND+4UNnmzLVdPj9FqFJNPqBZFve4w==",
        "dependencies": {
          "glob": "^7.1.3"
        }
      },
      "node_modules/safe-buffer": {
        "version": "5.2.0",
        "resolved": "https://registry.npmjs.org/safe-buffer/-/safe-buffer-5.2.0.tgz",
        "integrity": "sha512-fZEwUGbVl7kouZs1jCdMLdt95hdIv0ZeHg6L7qPeciMZhZ+/gdesW4wgTARkrFWEpspjEATAzUGPG8N2jJiwbg=="
      },
      "node_modules/safer-buffer": {
        "version": "2.1.2",
        "resolved": "https://registry.npmjs.org/safer-buffer/-/safer-buffer-2.1.2.tgz",
        "integrity": "sha512-YZo3K82SD7Riyi0E1EQPojLz7kpepnSQI9IyPbHHg1XXXevb5dJI7tpyN2ADxGcQbHG7vcyRHk0cbwqcQriUtg=="
      },
      "node_modules/semver": {
        "version": "5.7.1",
        "resolved": "https://registry.npmjs.org/semver/-/semver-5.7.1.tgz",
        "integrity": "sha512-sauaDf/PZdVgrLTNYHRtpXa1iRiKcaebiKQ1BJdpQlWH2lCvexQdX55snPFyK7QzpudqbCI0qXFfOasHdyNDGQ=="
      },
      "node_modules/set-blocking": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/set-blocking/-/set-blocking-2.0.0.tgz",
        "integrity": "sha1-BF+XgtARrppoA93TgrJDkrPYkPc="
      },
      "node_modules/signal-exit": {
        "version": "3.0.3",
        "resolved": "https://registry.npmjs.org/signal-exit/-/signal-exit-3.0.3.tgz",
        "integrity": "sha512-VUJ49FC8U1OxwZLxIbTTrDvLnf/6TDgxZcK8wxR8zs13xpx7xbG60ndBlhNrFi2EMuFRoeDoJO7wthSLq42EjA=="
      },
      "node_modules/source-map": {
        "version": "0.6.1",
        "resolved": "https://registry.npmjs.org/source-map/-/source-map-0.6.1.tgz",
        "integrity": "sha512-UjgapumWlbMhkBgzT7Ykc5YXUT46F0iKu8SGXq0bcwP5dz/h0Plj6enJqjz1Zbq2l5WaqYnrVbwWOWMyF3F47g=="
      },
      "node_modules/source-map-support": {
        "version": "0.5.16",
        "resolved": "https://registry.npmjs.org/source-map-support/-/source-map-support-0.5.16.tgz",
        "integrity": "sha512-efyLRJDr68D9hBBNIPWFjhpFzURh+KJykQwvMyW5UiZzYwoF6l4YMMDIJJEyFWxWCqfyxLzz6tSfUFR+kXXsVQ==",
        "dependencies": {
          "buffer-from": "^1.0.0",
          "source-map": "^0.6.0"
        }
      },
      "node_modules/spawn-wrap": {
        "version": "1.4.3",
        "resolved": "https://registry.npmjs.org/spawn-wrap/-/spawn-wrap-1.4.3.tgz",
        "integrity": "sha512-IgB8md0QW/+tWqcavuFgKYR/qIRvJkRLPJDFaoXtLLUaVcCDK0+HeFTkmQHj3eprcYhc+gOl0aEA1w7qZlYezw==",
        "dependencies": {
          "foreground-child": "^1.5.6",
          "mkdirp": "^0.5.0",
          "os-homedir": "^1.0.1",
          "rimraf": "^2.6.2",
          "signal-exit": "^3.0.2",
          "which": "^1.3.0"
        }
      },
      "node_modules/spawn-wrap/node_modules/mkdirp": {
        "version": "0.5.4",
        "resolved": "https://registry.npmjs.org/mkdirp/-/mkdirp-0.5.4.tgz",
        "integrity": "sha512-iG9AK/dJLtJ0XNgTuDbSyNS3zECqDlAhnQW4CsNxBG3LQJBbHmRX1egw39DmtOdCAqY+dKXV+sgPgilNWUKMVw==",
        "dependencies": {
          "minimist": "^1.2.5"
        }
      },
      "node_modules/spawn-wrap/node_modules/which": {
        "version": "1.3.1",
        "resolved": "https://registry.npmjs.org/which/-/which-1.3.1.tgz",
        "integrity": "sha512-HxJdYWq1MTIQbJ3nw0cqssHoTNU267KlrDuGZ1WYlxDStUtKUhOaJmh112/TZmHxxUfuJqPXSOm7tDyas0OSIQ==",
        "dependencies": {
          "isexe": "^2.0.0"
        }
      },
      "node_modules/spdx-correct": {
        "version": "3.1.0",
        "resolved": "https://registry.npmjs.org/spdx-correct/-/spdx-correct-3.1.0.tgz",
        "integrity": "sha512-lr2EZCctC2BNR7j7WzJ2FpDznxky1sjfxvvYEyzxNyb6lZXHODmEoJeFu4JupYlkfha1KZpJyoqiJ7pgA1qq8Q==",
        "dependencies": {
          "spdx-expression-parse": "^3.0.0",
          "spdx-license-ids": "^3.0.0"
        }
      },
      "node_modules/spdx-exceptions": {
        "version": "2.2.0",
        "resolved": "https://registry.npmjs.org/spdx-exceptions/-/spdx-exceptions-2.2.0.tgz",
        "integrity": "sha512-2XQACfElKi9SlVb1CYadKDXvoajPgBVPn/gOQLrTvHdElaVhr7ZEbqJaRnJLVNeaI4cMEAgVCeBMKF6MWRDCRA=="
      },
      "node_modules/spdx-expression-parse": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/spdx-expression-parse/-/spdx-expression-parse-3.0.0.tgz",
        "integrity": "sha512-Yg6D3XpRD4kkOmTpdgbUiEJFKghJH03fiC1OPll5h/0sO6neh2jqRDVHOQ4o/LMea0tgCkbMgea5ip/e+MkWyg==",
        "dependencies": {
          "spdx-exceptions": "^2.1.0",
          "spdx-license-ids": "^3.0.0"
        }
      },
      "node_modules/spdx-license-ids": {
        "version": "3.0.5",
        "resolved": "https://registry.npmjs.org/spdx-license-ids/-/spdx-license-ids-3.0.5.tgz",
        "integrity": "sha512-J+FWzZoynJEXGphVIS+XEh3kFSjZX/1i9gFBaWQcB+/tmpe2qUsSBABpcxqxnAxFdiUFEgAX1bjYGQvIZmoz9Q=="
      },
      "node_modules/sprintf-js": {
        "version": "1.0.3",
        "resolved": "https://registry.npmjs.org/sprintf-js/-/sprintf-js-1.0.3.tgz",
        "integrity": "sha1-BOaSb2YolTVPPdAVIDYzuFcpfiw="
      },
      "node_modules/sshpk": {
        "version": "1.16.1",
        "resolved": "https://registry.npmjs.org/sshpk/-/sshpk-1.16.1.tgz",
        "integrity": "sha512-HXXqVUq7+pcKeLqqZj6mHFUMvXtOJt1uoUx09pFW6011inTMxqI8BA8PM95myrIyyKwdnzjdFjLiE6KBPVtJIg==",
        "dependencies": {
          "asn1": "~0.2.3",
          "assert-plus": "^1.0.0",
          "bcrypt-pbkdf": "^1.0.0",
          "dashdash": "^1.12.0",
          "ecc-jsbn": "~0.1.1",
          "getpass": "^0.1.1",
          "jsbn": "~0.1.0",
          "safer-buffer": "^2.0.2",
          "tweetnacl": "~0.14.0"
        }
      },
      "node_modules/stack-utils": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/stack-utils/-/stack-utils-1.0.2.tgz",
        "integrity": "sha512-MTX+MeG5U994cazkjd/9KNAapsHnibjMLnfXodlkXw76JEea0UiNzrqidzo1emMwk7w5Qhc9jd4Bn9TBb1MFwA=="
      },
      "node_modules/string_decoder": {
        "name": "string_decoder",
        "version": "1.1.1",
        "resolved": "https://registry.npmjs.org/string_decoder/-/string_decoder-1.1.1.tgz",
        "integrity": "sha512-n/ShnvDi6FHbbVfviro+WojiFzv+s8MPMHBczVePfUpDJLwoLT0ht1l4YwBCbi8pJAveEEdnkHyPyTP/mzRfwg==",
        "optional": true,
        "dependencies": {
          "safe-buffer": "~5.1.0"
        }
      },
      "node_modules/string_decoder/node_modules/safe-buffer": {
        "name": "safe-buffer",
        "version": "5.1.2",
        "resolved": "https://registry.npmjs.org/safe-buffer/-/safe-buffer-5.1.2.tgz",
        "integrity": "sha512-Gd2UZBJDkXlY7GbJxfsE8/nvKkUEU1G38c1siN6QP6a9PT9MmHB8GnpscSmMJSoF8LOIrt8ud/wPtojys4G6+g==",
        "optional": true
      },
      "node_modules/strip-ansi": {
        "name": "strip-ansi",
        "version": "3.0.1",
        "resolved": "https://registry.npmjs.org/strip-ansi/-/strip-ansi-3.0.1.tgz",
        "integrity": "sha1-ajhfuIU9lS1f8F0Oiq+UJ43GPc8=",
        "dependencies": {
          "ansi-regex": "^2.0.0"
        },
        "engines": {
          "node": ">=0.10.0"
        }
      },
      "node_modules/strip-bom": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/strip-bom/-/strip-bom-3.0.0.tgz",
        "integrity": "sha1-IzTBjpx1n3vdVv3vfprj1YjmjtM="
      },
      "node_modules/supports-color": {
        "version": "5.5.0",
        "resolved": "https://registry.npmjs.org/supports-color/-/supports-color-5.5.0.tgz",
        "integrity": "sha512-QjVjwdXIt408MIiAqCX4oUKsgU2EqAGzs2Ppkm4aQYbjm+ZEWEcW4SfFNTr4uMNZma0ey4f5lgLrkB0aX0QMow==",
        "dependencies": {
          "has-flag": "^3.0.0"
        }
      },
      "node_modules/tap": {
        "name": "tap",
        "version": "12.7.0",
        "resolved": "https://registry.npmjs.org/tap/-/tap-12.7.0.tgz",
        "integrity": "sha512-SjglJmRv0pqrQQ7d5ZBEY8ZOqv3nYDBXEX51oyycOH7piuhn82JKT/yDNewwmOsodTD/RZL9MccA96EjDgK+Eg==",
        "dependencies": {
          "bind-obj-methods": "^2.0.0",
          "browser-process-hrtime": "^1.0.0",
          "capture-stack-trace": "^1.0.0",
          "clean-yaml-object": "^0.1.0",
          "color-support": "^1.1.0",
          "coveralls": "^3.0.2",
          "domain-browser": "^1.2.0",
          "esm": "^3.2.5",
          "foreground-child": "^1.3.3",
          "fs-exists-cached": "^1.0.0",
          "function-loop": "^1.0.1",
          "glob": "^7.1.3",
          "isexe": "^2.0.0",
          "js-yaml": "^3.13.1",
          "minipass": "^2.3.5",
          "mkdirp": "^0.5.1",
          "nyc": "^14.0.0",
          "opener": "^1.5.1",
          "os-homedir": "^1.0.2",
          "own-or": "^1.0.0",
          "own-or-env": "^1.0.1",
          "rimraf": "^2.6.3",
          "signal-exit": "^3.0.0",
          "source-map-support": "^0.5.10",
          "stack-utils": "^1.0.2",
          "tap-mocha-reporter": "^3.0.9",
          "tap-parser": "^7.0.0",
          "tmatch": "^4.0.0",
          "trivial-deferred": "^1.0.1",
          "ts-node": "^8.0.2",
          "tsame": "^2.0.1",
          "typescript": "^3.3.3",
          "write-file-atomic": "^2.4.2",
          "yapool": "^1.0.0"
        },
        "bin": {
          "tap": "bin/run.js"
        },
        "engines": {
          "node": ">=4"
        }
      },
      "node_modules/tap-mocha-reporter": {
        "name": "tap-mocha-reporter",
        "version": "3.0.9",
        "resolved": "https://registry.npmjs.org/tap-mocha-reporter/-/tap-mocha-reporter-3.0.9.tgz",
        "integrity": "sha512-VO07vhC9EG27EZdOe7bWBj1ldbK+DL9TnRadOgdQmiQOVZjFpUEQuuqO7+rNSO2kfmkq5hWeluYXDWNG/ytXTQ==",
        "dependencies": {
          "color-support": "^1.1.0",
          "debug": "^2.1.3",
          "diff": "^1.3.2",
          "escape-string-regexp": "^1.0.3",
          "glob": "^7.0.5",
          "js-yaml": "^3.3.1",
          "readable-stream": "^2.1.5",
          "tap-parser": "^5.1.0",
          "unicode-length": "^1.0.0"
        },
        "bin": {
          "tap-mocha-reporter": "index.js"
        },
        "optionalDependencies": {
          "readable-stream": "^2.1.5"
        }
      },
      "node_modules/tap-mocha-reporter/node_modules/debug": {
        "name": "debug",
        "version": "2.6.9",
        "resolved": "https://registry.npmjs.org/debug/-/debug-2.6.9.tgz",
        "integrity": "sha512-bC7ElrdJaJnPbAP+1EotYvqZsb3ecl5wi6Bfi6BJTUcNowp6cvspg0jXznRTKDjm/E7AdgFBVeAPVMNcKGsHMA==",
        "dependencies": {
          "ms": "2.0.0"
        }
      },
      "node_modules/tap-mocha-reporter/node_modules/diff": {
        "name": "diff",
        "version": "1.4.0",
        "resolved": "https://registry.npmjs.org/diff/-/diff-1.4.0.tgz",
        "integrity": "sha1-fyjS657nsVqX79ic5j3P2qPMur8=",
        "engines": {
          "node": ">=0.3.1"
        }
      },
      "node_modules/tap-mocha-reporter/node_modules/ms": {
        "name": "ms",
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/ms/-/ms-2.0.0.tgz",
        "integrity": "sha1-VgiurfwAvmwpAd9fmGF4jeDVl8g="
      },
      "node_modules/tap-mocha-reporter/node_modules/tap-parser": {
        "name": "tap-parser",
        "version": "5.4.0",
        "resolved": "https://registry.npmjs.org/tap-parser/-/tap-parser-5.4.0.tgz",
        "integrity": "sha512-BIsIaGqv7uTQgTW1KLTMNPSEQf4zDDPgYOBRdgOfuB+JFOLRBfEu6cLa/KvMvmqggu1FKXDfitjLwsq4827RvA==",
        "dependencies": {
          "events-to-array": "^1.0.1",
          "js-yaml": "^3.2.7",
          "readable-stream": "^2"
        },
        "bin": {
          "tap-parser": "bin/cmd.js"
        },
        "optionalDependencies": {
          "readable-stream": "^2"
        }
      },
      "node_modules/tap-parser": {
        "name": "tap-parser",
        "version": "7.0.0",
        "resolved": "https://registry.npmjs.org/tap-parser/-/tap-parser-7.0.0.tgz",
        "integrity": "sha512-05G8/LrzqOOFvZhhAk32wsGiPZ1lfUrl+iV7+OkKgfofZxiceZWMHkKmow71YsyVQ8IvGBP2EjcIjE5gL4l5lA==",
        "dependencies": {
          "events-to-array": "^1.0.1",
          "js-yaml": "^3.2.7",
          "minipass": "^2.2.0"
        },
        "bin": {
          "tap-parser": "bin/cmd.js"
        }
      },
      "node_modules/tap/node_modules/minimist": {
        "version": "1.2.5"
      },
      "node_modules/tap/node_modules/completely-broken-witaf": {},
      "node_modules/tap/node_modules/mkdirp": {
        "version": "0.5.4",
        "resolved": "https://registry.npmjs.org/mkdirp/-/mkdirp-0.5.4.tgz",
        "integrity": "sha512-iG9AK/dJLtJ0XNgTuDbSyNS3zECqDlAhnQW4CsNxBG3LQJBbHmRX1egw39DmtOdCAqY+dKXV+sgPgilNWUKMVw==",
        "dependencies": {
          "minimist": "^1.2.5"
        }
      },
      "node_modules/test-exclude": {
        "version": "5.2.3",
        "resolved": "https://registry.npmjs.org/test-exclude/-/test-exclude-5.2.3.tgz",
        "integrity": "sha512-M+oxtseCFO3EDtAaGH7iiej3CBkzXqFMbzqYAACdzKui4eZA+pq3tZEwChvOdNfa7xxy8BfbmgJSIr43cC/+2g==",
        "dependencies": {
          "glob": "^7.1.3",
          "minimatch": "^3.0.4",
          "read-pkg-up": "^4.0.0",
          "require-main-filename": "^2.0.0"
        }
      },
      "node_modules/tmatch": {
        "name": "tmatch",
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/tmatch/-/tmatch-4.0.0.tgz",
        "integrity": "sha512-Ynn2Gsp+oCvYScQXeV+cCs7citRDilq0qDXA6tuvFwDgiYyyaq7D5vKUlAPezzZR5NDobc/QMeN6e5guOYmvxg=="
      },
      "node_modules/to-fast-properties": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/to-fast-properties/-/to-fast-properties-2.0.0.tgz",
        "integrity": "sha1-3F5pjL0HkmW8c+A3doGk5Og/YW4="
      },
      "node_modules/tough-cookie": {
        "version": "2.5.0",
        "resolved": "https://registry.npmjs.org/tough-cookie/-/tough-cookie-2.5.0.tgz",
        "integrity": "sha512-nlLsUzgm1kfLXSXfRZMc1KLAugd4hqJHDTvc2hDIwS3mZAfMEuMbc03SujMF+GEcpaX/qboeycw6iO8JwVv2+g==",
        "dependencies": {
          "psl": "^1.1.28",
          "punycode": "^2.1.1"
        }
      },
      "node_modules/trivial-deferred": {
        "version": "1.0.1",
        "resolved": "https://registry.npmjs.org/trivial-deferred/-/trivial-deferred-1.0.1.tgz",
        "integrity": "sha1-N21NKdlR1jaKb3oK6FwvTV4GWPM="
      },
      "node_modules/ts-node": {
        "version": "8.8.1",
        "resolved": "https://registry.npmjs.org/ts-node/-/ts-node-8.8.1.tgz",
        "integrity": "sha512-10DE9ONho06QORKAaCBpPiFCdW+tZJuY/84tyypGtl6r+/C7Asq0dhqbRZURuUlLQtZxxDvT8eoj8cGW0ha6Bg==",
        "dependencies": {
          "arg": "^4.1.0",
          "diff": "^4.0.1",
          "make-error": "^1.1.1",
          "source-map-support": "^0.5.6",
          "yn": "3.1.1"
        }
      },
      "node_modules/tsame": {
        "name": "tsame",
        "version": "2.0.1",
        "resolved": "https://registry.npmjs.org/tsame/-/tsame-2.0.1.tgz",
        "integrity": "sha512-jxyxgKVKa4Bh5dPcO42TJL22lIvfd9LOVJwdovKOnJa4TLLrHxquK+DlGm4rkGmrcur+GRx+x4oW00O2pY/fFw=="
      },
      "node_modules/tunnel-agent": {
        "version": "0.6.0",
        "resolved": "https://registry.npmjs.org/tunnel-agent/-/tunnel-agent-0.6.0.tgz",
        "integrity": "sha1-J6XeoGs2sEoKmWZ3SykIaPD8QP0=",
        "dependencies": {
          "safe-buffer": "^5.0.1"
        }
      },
      "node_modules/tweetnacl": {
        "version": "0.14.5",
        "resolved": "https://registry.npmjs.org/tweetnacl/-/tweetnacl-0.14.5.tgz",
        "integrity": "sha1-WuaBd/GS1EViadEIr6k/+HQ/T2Q="
      },
      "node_modules/typescript": {
        "version": "3.8.3",
        "resolved": "https://registry.npmjs.org/typescript/-/typescript-3.8.3.tgz",
        "integrity": "sha512-MYlEfn5VrLNsgudQTVJeNaQFUAI7DkhnOjdpAp4T+ku1TfQClewlbSuTVHiA+8skNBgaf02TL/kLOvig4y3G8w=="
      },
      "node_modules/unicode-length": {
        "name": "unicode-length",
        "version": "1.0.3",
        "resolved": "https://registry.npmjs.org/unicode-length/-/unicode-length-1.0.3.tgz",
        "integrity": "sha1-Wtp6f+1RhBpBijKM8UlHisg1irs=",
        "dependencies": {
          "punycode": "^1.3.2",
          "strip-ansi": "^3.0.1"
        }
      },
      "node_modules/unicode-length/node_modules/punycode": {
        "name": "punycode",
        "version": "1.4.1",
        "resolved": "https://registry.npmjs.org/punycode/-/punycode-1.4.1.tgz",
        "integrity": "sha1-wNWmOycYgArY4esPpSachN1BhF4="
      },
      "node_modules/uri-js": {
        "version": "4.2.2",
        "resolved": "https://registry.npmjs.org/uri-js/-/uri-js-4.2.2.tgz",
        "integrity": "sha512-KY9Frmirql91X2Qgjry0Wd4Y+YTdrdZheS8TFwvkbLWf/G5KNJDCh6pKL5OZctEW4+0Baa5idK2ZQuELRwPznQ==",
        "dependencies": {
          "punycode": "^2.1.0"
        }
      },
      "node_modules/util-deprecate": {
        "name": "util-deprecate",
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/util-deprecate/-/util-deprecate-1.0.2.tgz",
        "integrity": "sha1-RQ1Nyfpw3nMnYvvS1KKJgUGaDM8=",
        "optional": true
      },
      "node_modules/uuid": {
        "version": "3.4.0",
        "resolved": "https://registry.npmjs.org/uuid/-/uuid-3.4.0.tgz",
        "integrity": "sha512-HjSDRw6gZE5JMggctHBcjVak08+KEVhSIiDzFnT9S9aegmp85S/bReBVTb4QTFaRNptJ9kuYaNhnbNEOkbKb/A=="
      },
      "node_modules/validate-npm-package-license": {
        "version": "3.0.4",
        "resolved": "https://registry.npmjs.org/validate-npm-package-license/-/validate-npm-package-license-3.0.4.tgz",
        "integrity": "sha512-DpKm2Ui/xN7/HQKCtpZxoRWBhZ9Z0kqtygG8XCgNQ8ZlDnxuQmWhj566j8fN4Cu3/JmbhsDo7fcAJq4s9h27Ew==",
        "dependencies": {
          "spdx-correct": "^3.0.0",
          "spdx-expression-parse": "^3.0.0"
        }
      },
      "node_modules/verror": {
        "version": "1.10.0",
        "resolved": "https://registry.npmjs.org/verror/-/verror-1.10.0.tgz",
        "integrity": "sha1-OhBcoXBTr1XW4nDB+CiGguGNpAA=",
        "dependencies": {
          "assert-plus": "^1.0.0",
          "core-util-is": "1.0.2",
          "extsprintf": "^1.2.0"
        }
      },
      "node_modules/which-module": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/which-module/-/which-module-2.0.0.tgz",
        "integrity": "sha1-2e8H3Od7mQK4o6j6SzHD4/fm6Ho="
      },
      "node_modules/wrappy": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/wrappy/-/wrappy-1.0.2.tgz",
        "integrity": "sha1-tSQ9jz7BqjXxNkYFvA0QNuMKtp8="
      },
      "node_modules/write-file-atomic": {
        "name": "write-file-atomic",
        "version": "2.4.3",
        "resolved": "https://registry.npmjs.org/write-file-atomic/-/write-file-atomic-2.4.3.tgz",
        "integrity": "sha512-GaETH5wwsX+GcnzhPgKcKjJ6M2Cq3/iZp1WyY/X1CSqrW+jVNM9Y7D8EC2sM4ZG/V8wZlSniJnCKWPmBYAucRQ==",
        "dependencies": {
          "graceful-fs": "^4.1.11",
          "imurmurhash": "^0.1.4",
          "signal-exit": "^3.0.2"
        }
      },
      "node_modules/y18n": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/y18n/-/y18n-4.0.0.tgz",
        "integrity": "sha512-r9S/ZyXu/Xu9q1tYlpsLIsa3EeLXXk0VwlxqTcFRfg9EhMW+17kbt9G0NrgCmhGb5vT2hyhJZLfDGx+7+5Uj/w=="
      },
      "node_modules/yallist": {
        "version": "2.1.2",
        "resolved": "https://registry.npmjs.org/yallist/-/yallist-2.1.2.tgz",
        "integrity": "sha1-HBH5IY8HYImkfdUS+TxmmaaoHVI="
      },
      "node_modules/yapool": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/yapool/-/yapool-1.0.0.tgz",
        "integrity": "sha1-9pPymjFbUNmp2iZGp6ZkXJaYW2o="
      },
      "node_modules/yargs": {
        "version": "13.3.2",
        "resolved": "https://registry.npmjs.org/yargs/-/yargs-13.3.2.tgz",
        "integrity": "sha512-AX3Zw5iPruN5ie6xGRIDgqkT+ZhnRlZMLMHAs8tg7nRruy2Nb+i5o9bwghAogtM08q1dpr2LVoS8KSTMYpWXUw==",
        "dependencies": {
          "cliui": "^5.0.0",
          "find-up": "^3.0.0",
          "get-caller-file": "^2.0.1",
          "require-directory": "^2.1.1",
          "require-main-filename": "^2.0.0",
          "set-blocking": "^2.0.0",
          "string-width": "^3.0.0",
          "which-module": "^2.0.0",
          "y18n": "^4.0.0",
          "yargs-parser": "^13.1.2"
        }
      },
      "node_modules/yargs-parser": {
        "version": "13.1.2",
        "resolved": "https://registry.npmjs.org/yargs-parser/-/yargs-parser-13.1.2.tgz",
        "integrity": "sha512-3lbsNRf/j+A4QuSZfDRA7HRSfWrzO0YjqTJd5kjAq37Zep1CEgaYmrH9Q3GwPiB9cHyd1Y1UwggGhJGoxipbzg==",
        "dependencies": {
          "camelcase": "^5.0.0",
          "decamelize": "^1.2.0"
        }
      },
      "node_modules/yargs/node_modules/ansi-regex": {
        "version": "4.1.0",
        "resolved": "https://registry.npmjs.org/ansi-regex/-/ansi-regex-4.1.0.tgz",
        "integrity": "sha512-1apePfXM1UOSqw0o9IiFAovVz9M5S1Dg+4TrDwfMewQ6p/rmMueb7tWZjQ1rx4Loy1ArBggoqGpfqqdI4rondg=="
      },
      "node_modules/yargs/node_modules/cliui": {
        "version": "5.0.0",
        "resolved": "https://registry.npmjs.org/cliui/-/cliui-5.0.0.tgz",
        "integrity": "sha512-PYeGSEmmHM6zvoef2w8TPzlrnNpXIjTipYK780YswmIP9vjxmd6Y2a3CB2Ks6/AU8NHjZugXvo8w3oWM2qnwXA==",
        "dependencies": {
          "string-width": "^3.1.0",
          "strip-ansi": "^5.2.0",
          "wrap-ansi": "^5.1.0"
        }
      },
      "node_modules/yargs/node_modules/string-width": {
        "version": "3.1.0",
        "resolved": "https://registry.npmjs.org/string-width/-/string-width-3.1.0.tgz",
        "integrity": "sha512-vafcv6KjVZKSgz06oM/H6GDBrAtz8vdhQakGjFIvNrHA6y3HCF1CInLy+QLq8dTJPQ1b+KDUqDFctkdRW44e1w==",
        "dependencies": {
          "emoji-regex": "^7.0.1",
          "is-fullwidth-code-point": "^2.0.0",
          "strip-ansi": "^5.1.0"
        }
      },
      "node_modules/yargs/node_modules/strip-ansi": {
        "version": "5.2.0",
        "resolved": "https://registry.npmjs.org/strip-ansi/-/strip-ansi-5.2.0.tgz",
        "integrity": "sha512-DuRs1gKbBqsMKIZlrffwlug8MHkcnpjs5VPmL1PAh+mA30U0DTotfDZ0d2UUsXpPmPmMMJ6W773MaA3J+lbiWA==",
        "dependencies": {
          "ansi-regex": "^4.1.0"
        }
      },
      "node_modules/yargs/node_modules/wrap-ansi": {
        "version": "5.1.0",
        "resolved": "https://registry.npmjs.org/wrap-ansi/-/wrap-ansi-5.1.0.tgz",
        "integrity": "sha512-QC1/iN/2/RPVJ5jYK8BGttj5z83LmSKmvbvrXPNCLZSEb32KKVDJDl/MOt2N01qU2H/FkzEa9PKto1BqDjtd7Q==",
        "dependencies": {
          "ansi-styles": "^3.2.0",
          "string-width": "^3.0.0",
          "strip-ansi": "^5.0.0"
        }
      },
      "node_modules/yn": {
        "version": "3.1.1",
        "resolved": "https://registry.npmjs.org/yn/-/yn-3.1.1.tgz",
        "integrity": "sha512-Ux4ygGWsu2c7isFWe8Yu1YluJmqVhxqK2cLXNQA5AcC3QfbGNpM7fu0Y8b/z16pXLnFxZYvWhd3fhBY9DLmC6Q=="
      }
    },
    "dependencies": {
      "@babel/code-frame": {
        "version": "7.8.3",
        "resolved": "https://registry.npmjs.org/@babel/code-frame/-/code-frame-7.8.3.tgz",
        "integrity": "sha512-a9gxpmdXtZEInkCSHUJDLHZVBgb1QS0jhss4cPP93EW7s+uC5bikET2twEF3KV+7rDblJcmNvTR7VJejqd2C2g==",
        "requires": {
          "@babel/highlight": "^7.8.3"
        }
      },
      "@babel/generator": {
        "version": "7.9.4",
        "resolved": "https://registry.npmjs.org/@babel/generator/-/generator-7.9.4.tgz",
        "integrity": "sha512-rjP8ahaDy/ouhrvCoU1E5mqaitWrxwuNGU+dy1EpaoK48jZay4MdkskKGIMHLZNewg8sAsqpGSREJwP0zH3YQA==",
        "requires": {
          "@babel/types": "^7.9.0",
          "jsesc": "^2.5.1",
          "lodash": "^4.17.13",
          "source-map": "^0.5.0"
        },
        "dependencies": {
          "source-map": {
            "version": "0.5.7",
            "resolved": "https://registry.npmjs.org/source-map/-/source-map-0.5.7.tgz",
            "integrity": "sha1-igOdLRAh0i0eoUyA2OpGi6LvP8w="
          }
        }
      },
      "@babel/helper-function-name": {
        "version": "7.8.3",
        "resolved": "https://registry.npmjs.org/@babel/helper-function-name/-/helper-function-name-7.8.3.tgz",
        "integrity": "sha512-BCxgX1BC2hD/oBlIFUgOCQDOPV8nSINxCwM3o93xP4P9Fq6aV5sgv2cOOITDMtCfQ+3PvHp3l689XZvAM9QyOA==",
        "requires": {
          "@babel/helper-get-function-arity": "^7.8.3",
          "@babel/template": "^7.8.3",
          "@babel/types": "^7.8.3"
        }
      },
      "@babel/helper-get-function-arity": {
        "version": "7.8.3",
        "resolved": "https://registry.npmjs.org/@babel/helper-get-function-arity/-/helper-get-function-arity-7.8.3.tgz",
        "integrity": "sha512-FVDR+Gd9iLjUMY1fzE2SR0IuaJToR4RkCDARVfsBBPSP53GEqSFjD8gNyxg246VUyc/ALRxFaAK8rVG7UT7xRA==",
        "requires": {
          "@babel/types": "^7.8.3"
        }
      },
      "@babel/helper-split-export-declaration": {
        "version": "7.8.3",
        "resolved": "https://registry.npmjs.org/@babel/helper-split-export-declaration/-/helper-split-export-declaration-7.8.3.tgz",
        "integrity": "sha512-3x3yOeyBhW851hroze7ElzdkeRXQYQbFIb7gLK1WQYsw2GWDay5gAJNw1sWJ0VFP6z5J1whqeXH/WCdCjZv6dA==",
        "requires": {
          "@babel/types": "^7.8.3"
        }
      },
      "@babel/helper-validator-identifier": {
        "version": "7.9.0",
        "resolved": "https://registry.npmjs.org/@babel/helper-validator-identifier/-/helper-validator-identifier-7.9.0.tgz",
        "integrity": "sha512-6G8bQKjOh+of4PV/ThDm/rRqlU7+IGoJuofpagU5GlEl29Vv0RGqqt86ZGRV8ZuSOY3o+8yXl5y782SMcG7SHw=="
      },
      "@babel/highlight": {
        "version": "7.9.0",
        "resolved": "https://registry.npmjs.org/@babel/highlight/-/highlight-7.9.0.tgz",
        "integrity": "sha512-lJZPilxX7Op3Nv/2cvFdnlepPXDxi29wxteT57Q965oc5R9v86ztx0jfxVrTcBk8C2kcPkkDa2Z4T3ZsPPVWsQ==",
        "requires": {
          "@babel/helper-validator-identifier": "^7.9.0",
          "chalk": "^2.0.0",
          "js-tokens": "^4.0.0"
        }
      },
      "@babel/parser": {
        "version": "7.9.4",
        "resolved": "https://registry.npmjs.org/@babel/parser/-/parser-7.9.4.tgz",
        "integrity": "sha512-bC49otXX6N0/VYhgOMh4gnP26E9xnDZK3TmbNpxYzzz9BQLBosQwfyOe9/cXUU3txYhTzLCbcqd5c8y/OmCjHA=="
      },
      "@babel/template": {
        "version": "7.8.6",
        "resolved": "https://registry.npmjs.org/@babel/template/-/template-7.8.6.tgz",
        "integrity": "sha512-zbMsPMy/v0PWFZEhQJ66bqjhH+z0JgMoBWuikXybgG3Gkd/3t5oQ1Rw2WQhnSrsOmsKXnZOx15tkC4qON/+JPg==",
        "requires": {
          "@babel/code-frame": "^7.8.3",
          "@babel/parser": "^7.8.6",
          "@babel/types": "^7.8.6"
        }
      },
      "@babel/traverse": {
        "version": "7.9.0",
        "resolved": "https://registry.npmjs.org/@babel/traverse/-/traverse-7.9.0.tgz",
        "integrity": "sha512-jAZQj0+kn4WTHO5dUZkZKhbFrqZE7K5LAQ5JysMnmvGij+wOdr+8lWqPeW0BcF4wFwrEXXtdGO7wcV6YPJcf3w==",
        "requires": {
          "@babel/code-frame": "^7.8.3",
          "@babel/generator": "^7.9.0",
          "@babel/helper-function-name": "^7.8.3",
          "@babel/helper-split-export-declaration": "^7.8.3",
          "@babel/parser": "^7.9.0",
          "@babel/types": "^7.9.0",
          "debug": "^4.1.0",
          "globals": "^11.1.0",
          "lodash": "^4.17.13"
        }
      },
      "@babel/types": {
        "version": "7.9.0",
        "resolved": "https://registry.npmjs.org/@babel/types/-/types-7.9.0.tgz",
        "integrity": "sha512-BS9JKfXkzzJl8RluW4JGknzpiUV7ZrvTayM6yfqLTVBEnFtyowVIOu6rqxRd5cVO6yGoWf4T8u8dgK9oB+GCng==",
        "requires": {
          "@babel/helper-validator-identifier": "^7.9.0",
          "lodash": "^4.17.13",
          "to-fast-properties": "^2.0.0"
        }
      },
      "ajv": {
        "version": "6.12.0",
        "resolved": "https://registry.npmjs.org/ajv/-/ajv-6.12.0.tgz",
        "integrity": "sha512-D6gFiFA0RRLyUbvijN74DWAjXSFxWKaWP7mldxkVhyhAV3+SWA9HEJPHQ2c9soIeTFJqcSdFDGFgdqs1iUU2Hw==",
        "requires": {
          "fast-deep-equal": "^3.1.1",
          "fast-json-stable-stringify": "^2.0.0",
          "json-schema-traverse": "^0.4.1",
          "uri-js": "^4.2.2"
        }
      },
      "ansi-regex": {
        "version": "2.1.1",
        "resolved": "https://registry.npmjs.org/ansi-regex/-/ansi-regex-2.1.1.tgz",
        "integrity": "sha1-w7M6te42DYbg5ijwRorn7yfWVN8="
      },
      "ansi-styles": {
        "version": "3.2.1",
        "resolved": "https://registry.npmjs.org/ansi-styles/-/ansi-styles-3.2.1.tgz",
        "integrity": "sha512-VT0ZI6kZRdTh8YyJw3SMbYm/u+NqfsAxEpWO0Pf9sq8/e94WxxOpPKx9FR1FlyCtOVDNOQ+8ntlqFxiRc+r5qA==",
        "requires": {
          "color-convert": "^1.9.0"
        }
      },
      "append-transform": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/append-transform/-/append-transform-1.0.0.tgz",
        "integrity": "sha512-P009oYkeHyU742iSZJzZZywj4QRJdnTWffaKuJQLablCZ1uz6/cW4yaRgcDaoQ+uwOxxnt0gRUcwfsNP2ri0gw==",
        "requires": {
          "default-require-extensions": "^2.0.0"
        }
      },
      "archy": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/archy/-/archy-1.0.0.tgz",
        "integrity": "sha1-+cjBN1fMHde8N5rHeyxipcKGjEA="
      },
      "arg": {
        "version": "4.1.3",
        "resolved": "https://registry.npmjs.org/arg/-/arg-4.1.3.tgz",
        "integrity": "sha512-58S9QDqG0Xx27YwPSt9fJxivjYl432YCwfDMfZ+71RAqUrZef7LrKQZ3LHLOwCS4FLNBplP533Zx895SeOCHvA=="
      },
      "argparse": {
        "version": "1.0.10",
        "resolved": "https://registry.npmjs.org/argparse/-/argparse-1.0.10.tgz",
        "integrity": "sha512-o5Roy6tNG4SL/FOkCAN6RzjiakZS25RLYFrcMttJqbdd8BWrnA+fGz57iN5Pb06pvBGvl5gQ0B48dJlslXvoTg==",
        "requires": {
          "sprintf-js": "~1.0.2"
        }
      },
      "asn1": {
        "version": "0.2.4",
        "resolved": "https://registry.npmjs.org/asn1/-/asn1-0.2.4.tgz",
        "integrity": "sha512-jxwzQpLQjSmWXgwaCZE9Nz+glAG01yF1QnWgbhGwHI5A6FRIEY6IVqtHhIepHqI7/kyEyQEagBC5mBEFlIYvdg==",
        "requires": {
          "safer-buffer": "~2.1.0"
        }
      },
      "assert-plus": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/assert-plus/-/assert-plus-1.0.0.tgz",
        "integrity": "sha1-8S4PPF13sLHN2RRpQuTpbB5N1SU="
      },
      "asynckit": {
        "version": "0.4.0",
        "resolved": "https://registry.npmjs.org/asynckit/-/asynckit-0.4.0.tgz",
        "integrity": "sha1-x57Zf380y48robyXkLzDZkdLS3k="
      },
      "aws-sign2": {
        "version": "0.7.0",
        "resolved": "https://registry.npmjs.org/aws-sign2/-/aws-sign2-0.7.0.tgz",
        "integrity": "sha1-tG6JCTSpWR8tL2+G1+ap8bP+dqg="
      },
      "aws4": {
        "version": "1.9.1",
        "resolved": "https://registry.npmjs.org/aws4/-/aws4-1.9.1.tgz",
        "integrity": "sha512-wMHVg2EOHaMRxbzgFJ9gtjOOCrI80OHLG14rxi28XwOW8ux6IiEbRCGGGqCtdAIg4FQCbW20k9RsT4y3gJlFug=="
      },
      "balanced-match": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/balanced-match/-/balanced-match-1.0.0.tgz",
        "integrity": "sha1-ibTRmasr7kneFk6gK4nORi1xt2c="
      },
      "bcrypt-pbkdf": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/bcrypt-pbkdf/-/bcrypt-pbkdf-1.0.2.tgz",
        "integrity": "sha1-pDAdOJtqQ/m2f/PKEaP2Y342Dp4=",
        "requires": {
          "tweetnacl": "^0.14.3"
        }
      },
      "bind-obj-methods": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/bind-obj-methods/-/bind-obj-methods-2.0.0.tgz",
        "integrity": "sha512-3/qRXczDi2Cdbz6jE+W3IflJOutRVica8frpBn14de1mBOkzDo+6tY33kNhvkw54Kn3PzRRD2VnGbGPcTAk4sw=="
      },
      "brace-expansion": {
        "version": "1.1.11",
        "resolved": "https://registry.npmjs.org/brace-expansion/-/brace-expansion-1.1.11.tgz",
        "integrity": "sha512-iCuPHDFgrHX7H2vEI/5xpz07zSHB00TpugqhmYtVmMO6518mCuRMoOYFldEBl0g187ufozdaHgWKcYFb61qGiA==",
        "requires": {
          "balanced-match": "^1.0.0",
          "concat-map": "0.0.1"
        }
      },
      "browser-process-hrtime": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/browser-process-hrtime/-/browser-process-hrtime-1.0.0.tgz",
        "integrity": "sha512-9o5UecI3GhkpM6DrXr69PblIuWxPKk9Y0jHBRhdocZ2y7YECBFCsHm79Pr3OyR2AvjhDkabFJaDJMYRazHgsow=="
      },
      "buffer-from": {
        "version": "1.1.1",
        "resolved": "https://registry.npmjs.org/buffer-from/-/buffer-from-1.1.1.tgz",
        "integrity": "sha512-MQcXEUbCKtEo7bhqEs6560Hyd4XaovZlO/k9V3hjVUF/zwW7KBVdSK4gIt/bzwS9MbR5qob+F5jusZsb0YQK2A=="
      },
      "caching-transform": {
        "version": "3.0.2",
        "resolved": "https://registry.npmjs.org/caching-transform/-/caching-transform-3.0.2.tgz",
        "integrity": "sha512-Mtgcv3lh3U0zRii/6qVgQODdPA4G3zhG+jtbCWj39RXuUFTMzH0vcdMtaJS1jPowd+It2Pqr6y3NJMQqOqCE2w==",
        "requires": {
          "hasha": "^3.0.0",
          "make-dir": "^2.0.0",
          "package-hash": "^3.0.0",
          "write-file-atomic": "^2.4.2"
        }
      },
      "camelcase": {
        "version": "5.3.1",
        "resolved": "https://registry.npmjs.org/camelcase/-/camelcase-5.3.1.tgz",
        "integrity": "sha512-L28STB170nwWS63UjtlEOE3dldQApaJXZkOI1uMFfzf3rRuPegHaHesyee+YxQ+W6SvRDQV6UrdOdRiR153wJg=="
      },
      "capture-stack-trace": {
        "version": "1.0.1",
        "resolved": "https://registry.npmjs.org/capture-stack-trace/-/capture-stack-trace-1.0.1.tgz",
        "integrity": "sha512-mYQLZnx5Qt1JgB1WEiMCf2647plpGeQ2NMR/5L0HNZzGQo4fuSPnK+wjfPnKZV0aiJDgzmWqqkV/g7JD+DW0qw=="
      },
      "caseless": {
        "version": "0.12.0",
        "resolved": "https://registry.npmjs.org/caseless/-/caseless-0.12.0.tgz",
        "integrity": "sha1-G2gcIf+EAzyCZUMJBolCDRhxUdw="
      },
      "chalk": {
        "version": "2.4.2",
        "resolved": "https://registry.npmjs.org/chalk/-/chalk-2.4.2.tgz",
        "integrity": "sha512-Mti+f9lpJNcwF4tWV8/OrTTtF1gZi+f8FqlyAdouralcFWFQWF2+NgCHShjkCb+IFBLq9buZwE1xckQU4peSuQ==",
        "requires": {
          "ansi-styles": "^3.2.1",
          "escape-string-regexp": "^1.0.5",
          "supports-color": "^5.3.0"
        }
      },
      "clean-yaml-object": {
        "version": "0.1.0",
        "resolved": "https://registry.npmjs.org/clean-yaml-object/-/clean-yaml-object-0.1.0.tgz",
        "integrity": "sha1-Y/sRDcLOGoTcIfbZM0h20BCui2g="
      },
      "color-convert": {
        "version": "1.9.3",
        "resolved": "https://registry.npmjs.org/color-convert/-/color-convert-1.9.3.tgz",
        "integrity": "sha512-QfAUtd+vFdAtFQcC8CCyYt1fYWxSqAiK2cSD6zDB8N3cpsEBAvRxp9zOGg6G/SHHJYAT88/az/IuDGALsNVbGg==",
        "requires": {
          "color-name": "1.1.3"
        }
      },
      "color-name": {
        "version": "1.1.3",
        "resolved": "https://registry.npmjs.org/color-name/-/color-name-1.1.3.tgz",
        "integrity": "sha1-p9BVi9icQveV3UIyj3QIMcpTvCU="
      },
      "color-support": {
        "version": "1.1.3",
        "resolved": "https://registry.npmjs.org/color-support/-/color-support-1.1.3.tgz",
        "integrity": "sha512-qiBjkpbMLO/HL68y+lh4q0/O1MZFj2RX6X/KmMa3+gJD3z+WwI1ZzDHysvqHGS3mP6mznPckpXmw1nI9cJjyRg=="
      },
      "combined-stream": {
        "version": "1.0.8",
        "resolved": "https://registry.npmjs.org/combined-stream/-/combined-stream-1.0.8.tgz",
        "integrity": "sha512-FQN4MRfuJeHf7cBbBMJFXhKSDq+2kAArBlmRBvcvFE5BB1HZKXtSFASDhdlz9zOYwxh8lDdnvmMOe/+5cdoEdg==",
        "requires": {
          "delayed-stream": "~1.0.0"
        }
      },
      "commondir": {
        "version": "1.0.1",
        "resolved": "https://registry.npmjs.org/commondir/-/commondir-1.0.1.tgz",
        "integrity": "sha1-3dgA2gxmEnOTzKWVDqloo6rxJTs="
      },
      "concat-map": {
        "version": "0.0.1",
        "resolved": "https://registry.npmjs.org/concat-map/-/concat-map-0.0.1.tgz",
        "integrity": "sha1-2Klr13/Wjfd5OnMDajug1UBdR3s="
      },
      "convert-source-map": {
        "version": "1.7.0",
        "resolved": "https://registry.npmjs.org/convert-source-map/-/convert-source-map-1.7.0.tgz",
        "integrity": "sha512-4FJkXzKXEDB1snCFZlLP4gpC3JILicCpGbzG9f9G7tGqGCzETQ2hWPrcinA9oU4wtf2biUaEH5065UnMeR33oA==",
        "requires": {
          "safe-buffer": "~5.1.1"
        },
        "dependencies": {
          "safe-buffer": {
            "version": "5.1.2",
            "resolved": "https://registry.npmjs.org/safe-buffer/-/safe-buffer-5.1.2.tgz",
            "integrity": "sha512-Gd2UZBJDkXlY7GbJxfsE8/nvKkUEU1G38c1siN6QP6a9PT9MmHB8GnpscSmMJSoF8LOIrt8ud/wPtojys4G6+g=="
          }
        }
      },
      "core-util-is": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/core-util-is/-/core-util-is-1.0.2.tgz",
        "integrity": "sha1-tf1UIgqivFq1eqtxQMlAdUUDwac="
      },
      "coveralls": {
        "version": "3.0.11",
        "resolved": "https://registry.npmjs.org/coveralls/-/coveralls-3.0.11.tgz",
        "integrity": "sha512-LZPWPR2NyGKyaABnc49dR0fpeP6UqhvGq4B5nUrTQ1UBy55z96+ga7r+/ChMdMJUwBgyJDXBi88UBgz2rs9IiQ==",
        "requires": {
          "js-yaml": "^3.13.1",
          "lcov-parse": "^1.0.0",
          "log-driver": "^1.2.7",
          "minimist": "^1.2.5",
          "request": "^2.88.0"
        }
      },
      "cp-file": {
        "version": "6.2.0",
        "resolved": "https://registry.npmjs.org/cp-file/-/cp-file-6.2.0.tgz",
        "integrity": "sha512-fmvV4caBnofhPe8kOcitBwSn2f39QLjnAnGq3gO9dfd75mUytzKNZB1hde6QHunW2Rt+OwuBOMc3i1tNElbszA==",
        "requires": {
          "graceful-fs": "^4.1.2",
          "make-dir": "^2.0.0",
          "nested-error-stacks": "^2.0.0",
          "pify": "^4.0.1",
          "safe-buffer": "^5.0.1"
        }
      },
      "cross-spawn": {
        "version": "4.0.2",
        "resolved": "https://registry.npmjs.org/cross-spawn/-/cross-spawn-4.0.2.tgz",
        "integrity": "sha1-e5JHYhwjrf3ThWAEqCPL45dCTUE=",
        "requires": {
          "lru-cache": "^4.0.1",
          "which": "^1.2.9"
        },
        "dependencies": {
          "which": {
            "version": "1.3.1",
            "resolved": "https://registry.npmjs.org/which/-/which-1.3.1.tgz",
            "integrity": "sha512-HxJdYWq1MTIQbJ3nw0cqssHoTNU267KlrDuGZ1WYlxDStUtKUhOaJmh112/TZmHxxUfuJqPXSOm7tDyas0OSIQ==",
            "requires": {
              "isexe": "^2.0.0"
            }
          }
        }
      },
      "dashdash": {
        "version": "1.14.1",
        "resolved": "https://registry.npmjs.org/dashdash/-/dashdash-1.14.1.tgz",
        "integrity": "sha1-hTz6D3y+L+1d4gMmuN1YEDX24vA=",
        "requires": {
          "assert-plus": "^1.0.0"
        }
      },
      "debug": {
        "version": "4.1.1",
        "resolved": "https://registry.npmjs.org/debug/-/debug-4.1.1.tgz",
        "integrity": "sha512-pYAIzeRo8J6KPEaJ0VWOh5Pzkbw/RetuzehGM7QRRX5he4fPHx2rdKMB256ehJCkX+XRQm16eZLqLNS8RSZXZw==",
        "requires": {
          "ms": "^2.1.1"
        }
      },
      "decamelize": {
        "version": "1.2.0",
        "resolved": "https://registry.npmjs.org/decamelize/-/decamelize-1.2.0.tgz",
        "integrity": "sha1-9lNNFRSCabIDUue+4m9QH5oZEpA="
      },
      "default-require-extensions": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/default-require-extensions/-/default-require-extensions-2.0.0.tgz",
        "integrity": "sha1-9fj7sYp9bVCyH2QfZJ67Uiz+JPc=",
        "requires": {
          "strip-bom": "^3.0.0"
        }
      },
      "delayed-stream": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/delayed-stream/-/delayed-stream-1.0.0.tgz",
        "integrity": "sha1-3zrhmayt+31ECqrgsp4icrJOxhk="
      },
      "diff": {
        "version": "4.0.2",
        "resolved": "https://registry.npmjs.org/diff/-/diff-4.0.2.tgz",
        "integrity": "sha512-58lmxKSA4BNyLz+HHMUzlOEpg09FV+ev6ZMe3vJihgdxzgcwZ8VoEEPmALCZG9LmqfVoNMMKpttIYTVG6uDY7A=="
      },
      "domain-browser": {
        "version": "1.2.0",
        "resolved": "https://registry.npmjs.org/domain-browser/-/domain-browser-1.2.0.tgz",
        "integrity": "sha512-jnjyiM6eRyZl2H+W8Q/zLMA481hzi0eszAaBUzIVnmYVDBbnLxVNnfu1HgEBvCbL+71FrxMl3E6lpKH7Ge3OXA=="
      },
      "ecc-jsbn": {
        "version": "0.1.2",
        "resolved": "https://registry.npmjs.org/ecc-jsbn/-/ecc-jsbn-0.1.2.tgz",
        "integrity": "sha1-OoOpBOVDUyh4dMVkt1SThoSamMk=",
        "requires": {
          "jsbn": "~0.1.0",
          "safer-buffer": "^2.1.0"
        }
      },
      "emoji-regex": {
        "version": "7.0.3",
        "resolved": "https://registry.npmjs.org/emoji-regex/-/emoji-regex-7.0.3.tgz",
        "integrity": "sha512-CwBLREIQ7LvYFB0WyRvwhq5N5qPhc6PMjD6bYggFlI5YyDgl+0vxq5VHbMOFqLg7hfWzmu8T5Z1QofhmTIhItA=="
      },
      "error-ex": {
        "version": "1.3.2",
        "resolved": "https://registry.npmjs.org/error-ex/-/error-ex-1.3.2.tgz",
        "integrity": "sha512-7dFHNmqeFSEt2ZBsCriorKnn3Z2pj+fd9kmI6QoWw4//DL+icEBfc0U7qJCisqrTsKTjw4fNFy2pW9OqStD84g==",
        "requires": {
          "is-arrayish": "^0.2.1"
        }
      },
      "es6-error": {
        "version": "4.1.1",
        "resolved": "https://registry.npmjs.org/es6-error/-/es6-error-4.1.1.tgz",
        "integrity": "sha512-Um/+FxMr9CISWh0bi5Zv0iOD+4cFh5qLeks1qhAopKVAJw3drgKbKySikp7wGhDL0HPeaja0P5ULZrxLkniUVg=="
      },
      "escape-string-regexp": {
        "version": "1.0.5",
        "resolved": "https://registry.npmjs.org/escape-string-regexp/-/escape-string-regexp-1.0.5.tgz",
        "integrity": "sha1-G2HAViGQqN/2rjuyzwIAyhMLhtQ="
      },
      "esm": {
        "version": "3.2.25",
        "resolved": "https://registry.npmjs.org/esm/-/esm-3.2.25.tgz",
        "integrity": "sha512-U1suiZ2oDVWv4zPO56S0NcR5QriEahGtdN2OR6FiOG4WJvcjBVFB0qI4+eKoWFH483PKGuLuu6V8Z4T5g63UVA=="
      },
      "esprima": {
        "version": "4.0.1",
        "resolved": "https://registry.npmjs.org/esprima/-/esprima-4.0.1.tgz",
        "integrity": "sha512-eGuFFw7Upda+g4p+QHvnW0RyTX/SVeJBDM/gCtMARO0cLuT2HcEKnTPvhjV6aGeqrCB/sbNop0Kszm0jsaWU4A=="
      },
      "events-to-array": {
        "version": "1.1.2",
        "resolved": "https://registry.npmjs.org/events-to-array/-/events-to-array-1.1.2.tgz",
        "integrity": "sha1-LUH1Y+H+QA7Uli/hpNXGp1Od9/Y="
      },
      "extend": {
        "version": "3.0.2",
        "resolved": "https://registry.npmjs.org/extend/-/extend-3.0.2.tgz",
        "integrity": "sha512-fjquC59cD7CyW6urNXK0FBufkZcoiGG80wTuPujX590cB5Ttln20E2UB4S/WARVqhXffZl2LNgS+gQdPIIim/g=="
      },
      "extsprintf": {
        "version": "1.3.0",
        "resolved": "https://registry.npmjs.org/extsprintf/-/extsprintf-1.3.0.tgz",
        "integrity": "sha1-lpGEQOMEGnpBT4xS48V06zw+HgU="
      },
      "fast-deep-equal": {
        "version": "3.1.1",
        "resolved": "https://registry.npmjs.org/fast-deep-equal/-/fast-deep-equal-3.1.1.tgz",
        "integrity": "sha512-8UEa58QDLauDNfpbrX55Q9jrGHThw2ZMdOky5Gl1CDtVeJDPVrG4Jxx1N8jw2gkWaff5UUuX1KJd+9zGe2B+ZA=="
      },
      "fast-json-stable-stringify": {
        "version": "2.1.0",
        "resolved": "https://registry.npmjs.org/fast-json-stable-stringify/-/fast-json-stable-stringify-2.1.0.tgz",
        "integrity": "sha512-lhd/wF+Lk98HZoTCtlVraHtfh5XYijIjalXck7saUtuanSDyLMxnHhSXEDJqHxD7msR8D0uCmqlkwjCV8xvwHw=="
      },
      "find-cache-dir": {
        "version": "2.1.0",
        "resolved": "https://registry.npmjs.org/find-cache-dir/-/find-cache-dir-2.1.0.tgz",
        "integrity": "sha512-Tq6PixE0w/VMFfCgbONnkiQIVol/JJL7nRMi20fqzA4NRs9AfeqMGeRdPi3wIhYkxjeBaWh2rxwapn5Tu3IqOQ==",
        "requires": {
          "commondir": "^1.0.1",
          "make-dir": "^2.0.0",
          "pkg-dir": "^3.0.0"
        }
      },
      "find-up": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/find-up/-/find-up-3.0.0.tgz",
        "integrity": "sha512-1yD6RmLI1XBfxugvORwlck6f75tYL+iR0jqwsOrOxMZyGYqUuDhJ0l4AXdO1iX/FTs9cBAMEk1gWSEx1kSbylg==",
        "requires": {
          "locate-path": "^3.0.0"
        }
      },
      "foreground-child": {
        "version": "1.5.6",
        "resolved": "https://registry.npmjs.org/foreground-child/-/foreground-child-1.5.6.tgz",
        "integrity": "sha1-T9ca0t/elnibmApcCilZN8svXOk=",
        "requires": {
          "cross-spawn": "^4",
          "signal-exit": "^3.0.0"
        }
      },
      "forever-agent": {
        "version": "0.6.1",
        "resolved": "https://registry.npmjs.org/forever-agent/-/forever-agent-0.6.1.tgz",
        "integrity": "sha1-+8cfDEGt6zf5bFd60e1C2P2sypE="
      },
      "form-data": {
        "version": "2.3.3",
        "resolved": "https://registry.npmjs.org/form-data/-/form-data-2.3.3.tgz",
        "integrity": "sha512-1lLKB2Mu3aGP1Q/2eCOx0fNbRMe7XdwktwOruhfqqd0rIJWwN4Dh+E3hrPSlDCXnSR7UtZ1N38rVXm+6+MEhJQ==",
        "requires": {
          "asynckit": "^0.4.0",
          "combined-stream": "^1.0.6",
          "mime-types": "^2.1.12"
        }
      },
      "fs-exists-cached": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/fs-exists-cached/-/fs-exists-cached-1.0.0.tgz",
        "integrity": "sha1-zyVVTKBQ3EmuZla0HeQiWJidy84="
      },
      "fs.realpath": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/fs.realpath/-/fs.realpath-1.0.0.tgz",
        "integrity": "sha1-FQStJSMVjKpA20onh8sBQRmU6k8="
      },
      "function-loop": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/function-loop/-/function-loop-1.0.2.tgz",
        "integrity": "sha512-Iw4MzMfS3udk/rqxTiDDCllhGwlOrsr50zViTOO/W6lS/9y6B1J0BD2VZzrnWUYBJsl3aeqjgR5v7bWWhZSYbA=="
      },
      "get-caller-file": {
        "version": "2.0.5",
        "resolved": "https://registry.npmjs.org/get-caller-file/-/get-caller-file-2.0.5.tgz",
        "integrity": "sha512-DyFP3BM/3YHTQOCUL/w0OZHR0lpKeGrxotcHWcqNEdnltqFwXVfhEBQ94eIo34AfQpo0rGki4cyIiftY06h2Fg=="
      },
      "getpass": {
        "version": "0.1.7",
        "resolved": "https://registry.npmjs.org/getpass/-/getpass-0.1.7.tgz",
        "integrity": "sha1-Xv+OPmhNVprkyysSgmBOi6YhSfo=",
        "requires": {
          "assert-plus": "^1.0.0"
        }
      },
      "glob": {
        "version": "7.1.6",
        "resolved": "https://registry.npmjs.org/glob/-/glob-7.1.6.tgz",
        "integrity": "sha512-LwaxwyZ72Lk7vZINtNNrywX0ZuLyStrdDtabefZKAY5ZGJhVtgdznluResxNmPitE0SAO+O26sWTHeKSI2wMBA==",
        "requires": {
          "fs.realpath": "^1.0.0",
          "inflight": "^1.0.4",
          "inherits": "2",
          "minimatch": "^3.0.4",
          "once": "^1.3.0",
          "path-is-absolute": "^1.0.0"
        }
      },
      "globals": {
        "version": "11.12.0",
        "resolved": "https://registry.npmjs.org/globals/-/globals-11.12.0.tgz",
        "integrity": "sha512-WOBp/EEGUiIsJSp7wcv/y6MO+lV9UoncWqxuFfm8eBwzWNgyfBd6Gz+IeKQ9jCmyhoH99g15M3T+QaVHFjizVA=="
      },
      "graceful-fs": {
        "version": "4.2.3",
        "resolved": "https://registry.npmjs.org/graceful-fs/-/graceful-fs-4.2.3.tgz",
        "integrity": "sha512-a30VEBm4PEdx1dRB7MFK7BejejvCvBronbLjht+sHuGYj8PHs7M/5Z+rt5lw551vZ7yfTCj4Vuyy3mSJytDWRQ=="
      },
      "har-schema": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/har-schema/-/har-schema-2.0.0.tgz",
        "integrity": "sha1-qUwiJOvKwEeCoNkDVSHyRzW37JI="
      },
      "har-validator": {
        "version": "5.1.3",
        "resolved": "https://registry.npmjs.org/har-validator/-/har-validator-5.1.3.tgz",
        "integrity": "sha512-sNvOCzEQNr/qrvJgc3UG/kD4QtlHycrzwS+6mfTrrSq97BvaYcPZZI1ZSqGSPR73Cxn4LKTD4PttRwfU7jWq5g==",
        "requires": {
          "ajv": "^6.5.5",
          "har-schema": "^2.0.0"
        }
      },
      "has-flag": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/has-flag/-/has-flag-3.0.0.tgz",
        "integrity": "sha1-tdRU3CGZriJWmfNGfloH87lVuv0="
      },
      "hasha": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/hasha/-/hasha-3.0.0.tgz",
        "integrity": "sha1-UqMvq4Vp1BymmmH/GiFPjrfIvTk=",
        "requires": {
          "is-stream": "^1.0.1"
        }
      },
      "hosted-git-info": {
        "version": "2.8.8",
        "resolved": "https://registry.npmjs.org/hosted-git-info/-/hosted-git-info-2.8.8.tgz",
        "integrity": "sha512-f/wzC2QaWBs7t9IYqB4T3sR1xviIViXJRJTWBlx2Gf3g0Xi5vI7Yy4koXQ1c9OYDGHN9sBy1DQ2AB8fqZBWhUg=="
      },
      "html-escaper": {
        "version": "2.0.1",
        "resolved": "https://registry.npmjs.org/html-escaper/-/html-escaper-2.0.1.tgz",
        "integrity": "sha512-hNX23TjWwD3q56HpWjUHOKj1+4KKlnjv9PcmBUYKVpga+2cnb9nDx/B1o0yO4n+RZXZdiNxzx6B24C9aNMTkkQ=="
      },
      "http-signature": {
        "version": "1.2.0",
        "resolved": "https://registry.npmjs.org/http-signature/-/http-signature-1.2.0.tgz",
        "integrity": "sha1-muzZJRFHcvPZW2WmCruPfBj7rOE=",
        "requires": {
          "assert-plus": "^1.0.0",
          "jsprim": "^1.2.2",
          "sshpk": "^1.7.0"
        }
      },
      "imurmurhash": {
        "version": "0.1.4",
        "resolved": "https://registry.npmjs.org/imurmurhash/-/imurmurhash-0.1.4.tgz",
        "integrity": "sha1-khi5srkoojixPcT7a21XbyMUU+o="
      },
      "inflight": {
        "version": "1.0.6",
        "resolved": "https://registry.npmjs.org/inflight/-/inflight-1.0.6.tgz",
        "integrity": "sha1-Sb1jMdfQLQwJvJEKEHW6gWW1bfk=",
        "requires": {
          "once": "^1.3.0",
          "wrappy": "1"
        }
      },
      "inherits": {
        "version": "2.0.4",
        "resolved": "https://registry.npmjs.org/inherits/-/inherits-2.0.4.tgz",
        "integrity": "sha512-k/vGaX4/Yla3WzyMCvTQOXYeIHvqOKtnqBduzTHpzpQZzAskKMhZ2K+EnBiSM9zGSoIFeMpXKxa4dYeZIQqewQ=="
      },
      "is-arrayish": {
        "version": "0.2.1",
        "resolved": "https://registry.npmjs.org/is-arrayish/-/is-arrayish-0.2.1.tgz",
        "integrity": "sha1-d8mYQFJ6qOyxqLppe4BkWnqSap0="
      },
      "is-fullwidth-code-point": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/is-fullwidth-code-point/-/is-fullwidth-code-point-2.0.0.tgz",
        "integrity": "sha1-o7MKXE8ZkYMWeqq5O+764937ZU8="
      },
      "is-stream": {
        "version": "1.1.0",
        "resolved": "https://registry.npmjs.org/is-stream/-/is-stream-1.1.0.tgz",
        "integrity": "sha1-EtSj3U5o4Lec6428hBc66A2RykQ="
      },
      "is-typedarray": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/is-typedarray/-/is-typedarray-1.0.0.tgz",
        "integrity": "sha1-5HnICFjfDBsR3dppQPlgEfzaSpo="
      },
      "isarray": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/isarray/-/isarray-1.0.0.tgz",
        "integrity": "sha1-u5NdSFgsuhaMBoNJV6VKPgcSTxE=",
        "optional": true
      },
      "isexe": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/isexe/-/isexe-2.0.0.tgz",
        "integrity": "sha1-6PvzdNxVb/iUehDcsFctYz8s+hA="
      },
      "isstream": {
        "version": "0.1.2",
        "resolved": "https://registry.npmjs.org/isstream/-/isstream-0.1.2.tgz",
        "integrity": "sha1-R+Y/evVa+m+S4VAOaQ64uFKcCZo="
      },
      "istanbul-lib-coverage": {
        "version": "2.0.5",
        "resolved": "https://registry.npmjs.org/istanbul-lib-coverage/-/istanbul-lib-coverage-2.0.5.tgz",
        "integrity": "sha512-8aXznuEPCJvGnMSRft4udDRDtb1V3pkQkMMI5LI+6HuQz5oQ4J2UFn1H82raA3qJtyOLkkwVqICBQkjnGtn5mA=="
      },
      "istanbul-lib-hook": {
        "version": "2.0.7",
        "resolved": "https://registry.npmjs.org/istanbul-lib-hook/-/istanbul-lib-hook-2.0.7.tgz",
        "integrity": "sha512-vrRztU9VRRFDyC+aklfLoeXyNdTfga2EI3udDGn4cZ6fpSXpHLV9X6CHvfoMCPtggg8zvDDmC4b9xfu0z6/llA==",
        "requires": {
          "append-transform": "^1.0.0"
        }
      },
      "istanbul-lib-instrument": {
        "version": "3.3.0",
        "resolved": "https://registry.npmjs.org/istanbul-lib-instrument/-/istanbul-lib-instrument-3.3.0.tgz",
        "integrity": "sha512-5nnIN4vo5xQZHdXno/YDXJ0G+I3dAm4XgzfSVTPLQpj/zAV2dV6Juy0yaf10/zrJOJeHoN3fraFe+XRq2bFVZA==",
        "requires": {
          "@babel/generator": "^7.4.0",
          "@babel/parser": "^7.4.3",
          "@babel/template": "^7.4.0",
          "@babel/traverse": "^7.4.3",
          "@babel/types": "^7.4.0",
          "istanbul-lib-coverage": "^2.0.5",
          "semver": "^6.0.0"
        },
        "dependencies": {
          "semver": {
            "version": "6.3.0",
            "resolved": "https://registry.npmjs.org/semver/-/semver-6.3.0.tgz",
            "integrity": "sha512-b39TBaTSfV6yBrapU89p5fKekE2m/NwnDocOVruQFS1/veMgdzuPcnOM34M6CwxW8jH/lxEa5rBoDeUwu5HHTw=="
          }
        }
      },
      "istanbul-lib-report": {
        "version": "2.0.8",
        "resolved": "https://registry.npmjs.org/istanbul-lib-report/-/istanbul-lib-report-2.0.8.tgz",
        "integrity": "sha512-fHBeG573EIihhAblwgxrSenp0Dby6tJMFR/HvlerBsrCTD5bkUuoNtn3gVh29ZCS824cGGBPn7Sg7cNk+2xUsQ==",
        "requires": {
          "istanbul-lib-coverage": "^2.0.5",
          "make-dir": "^2.1.0",
          "supports-color": "^6.1.0"
        },
        "dependencies": {
          "supports-color": {
            "version": "6.1.0",
            "resolved": "https://registry.npmjs.org/supports-color/-/supports-color-6.1.0.tgz",
            "integrity": "sha512-qe1jfm1Mg7Nq/NSh6XE24gPXROEVsWHxC1LIx//XNlD9iw7YZQGjZNjYN7xGaEG6iKdA8EtNFW6R0gjnVXp+wQ==",
            "requires": {
              "has-flag": "^3.0.0"
            }
          }
        }
      },
      "istanbul-lib-source-maps": {
        "version": "3.0.6",
        "resolved": "https://registry.npmjs.org/istanbul-lib-source-maps/-/istanbul-lib-source-maps-3.0.6.tgz",
        "integrity": "sha512-R47KzMtDJH6X4/YW9XTx+jrLnZnscW4VpNN+1PViSYTejLVPWv7oov+Duf8YQSPyVRUvueQqz1TcsC6mooZTXw==",
        "requires": {
          "debug": "^4.1.1",
          "istanbul-lib-coverage": "^2.0.5",
          "make-dir": "^2.1.0",
          "rimraf": "^2.6.3",
          "source-map": "^0.6.1"
        }
      },
      "istanbul-reports": {
        "version": "2.2.7",
        "resolved": "https://registry.npmjs.org/istanbul-reports/-/istanbul-reports-2.2.7.tgz",
        "integrity": "sha512-uu1F/L1o5Y6LzPVSVZXNOoD/KXpJue9aeLRd0sM9uMXfZvzomB0WxVamWb5ue8kA2vVWEmW7EG+A5n3f1kqHKg==",
        "requires": {
          "html-escaper": "^2.0.0"
        }
      },
      "js-tokens": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/js-tokens/-/js-tokens-4.0.0.tgz",
        "integrity": "sha512-RdJUflcE3cUzKiMqQgsCu06FPu9UdIJO0beYbPhHN4k6apgJtifcoCtT9bcxOpYBtpD2kCM6Sbzg4CausW/PKQ=="
      },
      "js-yaml": {
        "version": "3.13.1",
        "resolved": "https://registry.npmjs.org/js-yaml/-/js-yaml-3.13.1.tgz",
        "integrity": "sha512-YfbcO7jXDdyj0DGxYVSlSeQNHbD7XPWvrVWeVUujrQEoZzWJIRrCPoyk6kL6IAjAG2IolMK4T0hNUe0HOUs5Jw==",
        "requires": {
          "argparse": "^1.0.7",
          "esprima": "^4.0.0"
        }
      },
      "jsbn": {
        "version": "0.1.1",
        "resolved": "https://registry.npmjs.org/jsbn/-/jsbn-0.1.1.tgz",
        "integrity": "sha1-peZUwuWi3rXyAdls77yoDA7y9RM="
      },
      "jsesc": {
        "version": "2.5.2",
        "resolved": "https://registry.npmjs.org/jsesc/-/jsesc-2.5.2.tgz",
        "integrity": "sha512-OYu7XEzjkCQ3C5Ps3QIZsQfNpqoJyZZA99wd9aWd05NCtC5pWOkShK2mkL6HXQR6/Cy2lbNdPlZBpuQHXE63gA=="
      },
      "json-parse-better-errors": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/json-parse-better-errors/-/json-parse-better-errors-1.0.2.tgz",
        "integrity": "sha512-mrqyZKfX5EhL7hvqcV6WG1yYjnjeuYDzDhhcAAUrq8Po85NBQBJP+ZDUT75qZQ98IkUoBqdkExkukOU7Ts2wrw=="
      },
      "json-schema": {
        "version": "0.2.3",
        "resolved": "https://registry.npmjs.org/json-schema/-/json-schema-0.2.3.tgz",
        "integrity": "sha1-tIDIkuWaLwWVTOcnvT8qTogvnhM="
      },
      "json-schema-traverse": {
        "version": "0.4.1",
        "resolved": "https://registry.npmjs.org/json-schema-traverse/-/json-schema-traverse-0.4.1.tgz",
        "integrity": "sha512-xbbCH5dCYU5T8LcEhhuh7HJ88HXuW3qsI3Y0zOZFKfZEHcpWiHU/Jxzk629Brsab/mMiHQti9wMP+845RPe3Vg=="
      },
      "json-stringify-safe": {
        "version": "5.0.1",
        "resolved": "https://registry.npmjs.org/json-stringify-safe/-/json-stringify-safe-5.0.1.tgz",
        "integrity": "sha1-Epai1Y/UXxmg9s4B1lcB4sc1tus="
      },
      "jsprim": {
        "version": "1.4.1",
        "resolved": "https://registry.npmjs.org/jsprim/-/jsprim-1.4.1.tgz",
        "integrity": "sha1-MT5mvB5cwG5Di8G3SZwuXFastqI=",
        "requires": {
          "assert-plus": "1.0.0",
          "extsprintf": "1.3.0",
          "json-schema": "0.2.3",
          "verror": "1.10.0"
        }
      },
      "lcov-parse": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/lcov-parse/-/lcov-parse-1.0.0.tgz",
        "integrity": "sha1-6w1GtUER68VhrLTECO+TY73I9+A="
      },
      "load-json-file": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/load-json-file/-/load-json-file-4.0.0.tgz",
        "integrity": "sha1-L19Fq5HjMhYjT9U62rZo607AmTs=",
        "requires": {
          "graceful-fs": "^4.1.2",
          "parse-json": "^4.0.0",
          "pify": "^3.0.0",
          "strip-bom": "^3.0.0"
        },
        "dependencies": {
          "pify": {
            "version": "3.0.0",
            "resolved": "https://registry.npmjs.org/pify/-/pify-3.0.0.tgz",
            "integrity": "sha1-5aSs0sEB/fPZpNB/DbxNtJ3SgXY="
          }
        }
      },
      "locate-path": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/locate-path/-/locate-path-3.0.0.tgz",
        "integrity": "sha512-7AO748wWnIhNqAuaty2ZWHkQHRSNfPVIsPIfwEOWO22AmaoVrWavlOcMR5nzTLNYvp36X220/maaRsrec1G65A==",
        "requires": {
          "p-locate": "^3.0.0",
          "path-exists": "^3.0.0"
        }
      },
      "lodash": {
        "version": "4.17.15",
        "resolved": "https://registry.npmjs.org/lodash/-/lodash-4.17.15.tgz",
        "integrity": "sha512-8xOcRHvCjnocdS5cpwXQXVzmmh5e5+saE2QGoeQmbKmRS6J3VQppPOIt0MnmE+4xlZoumy0GPG0D0MVIQbNA1A=="
      },
      "lodash.flattendeep": {
        "version": "4.4.0",
        "resolved": "https://registry.npmjs.org/lodash.flattendeep/-/lodash.flattendeep-4.4.0.tgz",
        "integrity": "sha1-+wMJF/hqMTTlvJvsDWngAT3f7bI="
      },
      "log-driver": {
        "version": "1.2.7",
        "resolved": "https://registry.npmjs.org/log-driver/-/log-driver-1.2.7.tgz",
        "integrity": "sha512-U7KCmLdqsGHBLeWqYlFA0V0Sl6P08EE1ZrmA9cxjUE0WVqT9qnyVDPz1kzpFEP0jdJuFnasWIfSd7fsaNXkpbg=="
      },
      "lru-cache": {
        "version": "4.1.5",
        "resolved": "https://registry.npmjs.org/lru-cache/-/lru-cache-4.1.5.tgz",
        "integrity": "sha512-sWZlbEP2OsHNkXrMl5GYk/jKk70MBng6UU4YI/qGDYbgf6YbP4EvmqISbXCoJiRKs+1bSpFHVgQxvJ17F2li5g==",
        "requires": {
          "pseudomap": "^1.0.2",
          "yallist": "^2.1.2"
        }
      },
      "make-dir": {
        "version": "2.1.0",
        "resolved": "https://registry.npmjs.org/make-dir/-/make-dir-2.1.0.tgz",
        "integrity": "sha512-LS9X+dc8KLxXCb8dni79fLIIUA5VyZoyjSMCwTluaXA0o27cCK0bhXkpgw+sTXVpPy/lSO57ilRixqk0vDmtRA==",
        "requires": {
          "pify": "^4.0.1",
          "semver": "^5.6.0"
        }
      },
      "make-error": {
        "version": "1.3.6",
        "resolved": "https://registry.npmjs.org/make-error/-/make-error-1.3.6.tgz",
        "integrity": "sha512-s8UhlNe7vPKomQhC1qFelMokr/Sc3AgNbso3n74mVPA5LTZwkB9NlXf4XPamLxJE8h0gh73rM94xvwRT2CVInw=="
      },
      "merge-source-map": {
        "version": "1.1.0",
        "resolved": "https://registry.npmjs.org/merge-source-map/-/merge-source-map-1.1.0.tgz",
        "integrity": "sha512-Qkcp7P2ygktpMPh2mCQZaf3jhN6D3Z/qVZHSdWvQ+2Ef5HgRAPBO57A77+ENm0CPx2+1Ce/MYKi3ymqdfuqibw==",
        "requires": {
          "source-map": "^0.6.1"
        }
      },
      "mime-db": {
        "version": "1.43.0",
        "resolved": "https://registry.npmjs.org/mime-db/-/mime-db-1.43.0.tgz",
        "integrity": "sha512-+5dsGEEovYbT8UY9yD7eE4XTc4UwJ1jBYlgaQQF38ENsKR3wj/8q8RFZrF9WIZpB2V1ArTVFUva8sAul1NzRzQ=="
      },
      "mime-types": {
        "version": "2.1.26",
        "resolved": "https://registry.npmjs.org/mime-types/-/mime-types-2.1.26.tgz",
        "integrity": "sha512-01paPWYgLrkqAyrlDorC1uDwl2p3qZT7yl806vW7DvDoxwXi46jsjFbg+WdwotBIk6/MbEhO/dh5aZ5sNj/dWQ==",
        "requires": {
          "mime-db": "1.43.0"
        }
      },
      "minimatch": {
        "version": "3.0.4",
        "resolved": "https://registry.npmjs.org/minimatch/-/minimatch-3.0.4.tgz",
        "integrity": "sha512-yJHVQEhyqPLUTgt9B83PXu6W3rx4MvvHvSUvToogpwoGDOUQ+yDrR0HRot+yOCdCO7u4hX3pWft6kWBBcqh0UA==",
        "requires": {
          "brace-expansion": "^1.1.7"
        }
      },
      "minimist": {
        "version": "1.2.5",
        "resolved": "https://registry.npmjs.org/minimist/-/minimist-1.2.5.tgz",
        "integrity": "sha512-FM9nNUYrRBAELZQT3xeZQ7fmMOBg6nWNmJKTcgsJeaLstP/UODVpGsr5OhXhhXg6f+qtJ8uiZ+PUxkDWcgIXLw=="
      },
      "minipass": {
        "version": "2.9.0",
        "resolved": "https://registry.npmjs.org/minipass/-/minipass-2.9.0.tgz",
        "integrity": "sha512-wxfUjg9WebH+CUDX/CdbRlh5SmfZiy/hpkxaRI16Y9W56Pa75sWgd/rvFilSgrauD9NyFymP/+JFV3KwzIsJeg==",
        "requires": {
          "safe-buffer": "^5.1.2",
          "yallist": "^3.0.0"
        },
        "dependencies": {
          "yallist": {
            "version": "3.1.1",
            "resolved": "https://registry.npmjs.org/yallist/-/yallist-3.1.1.tgz",
            "integrity": "sha512-a4UGQaWPH59mOXUYnAG2ewncQS4i4F43Tv3JoAM+s2VDAmS9NsK8GpDMLrCHPksFT7h3K6TOoUNn2pb7RoXx4g=="
          }
        }
      },
      "ms": {
        "version": "2.1.2",
        "resolved": "https://registry.npmjs.org/ms/-/ms-2.1.2.tgz",
        "integrity": "sha512-sGkPx+VjMtmA6MX27oA4FBFELFCZZ4S4XqeGOXCv68tT+jb3vk/RyaKWP0PTKyWtmLSM0b+adUTEvbs1PEaH2w=="
      },
      "nested-error-stacks": {
        "version": "2.1.0",
        "resolved": "https://registry.npmjs.org/nested-error-stacks/-/nested-error-stacks-2.1.0.tgz",
        "integrity": "sha512-AO81vsIO1k1sM4Zrd6Hu7regmJN1NSiAja10gc4bX3F0wd+9rQmcuHQaHVQCYIEC8iFXnE+mavh23GOt7wBgug=="
      },
      "normalize-package-data": {
        "version": "2.5.0",
        "resolved": "https://registry.npmjs.org/normalize-package-data/-/normalize-package-data-2.5.0.tgz",
        "integrity": "sha512-/5CMN3T0R4XTj4DcGaexo+roZSdSFW/0AOOTROrjxzCG1wrWXEsGbRKevjlIL+ZDE4sZlJr5ED4YW0yqmkK+eA==",
        "requires": {
          "hosted-git-info": "^2.1.4",
          "resolve": "^1.10.0",
          "semver": "2 || 3 || 4 || 5",
          "validate-npm-package-license": "^3.0.1"
        }
      },
      "nyc": {
        "version": "14.1.1",
        "resolved": "https://registry.npmjs.org/nyc/-/nyc-14.1.1.tgz",
        "integrity": "sha512-OI0vm6ZGUnoGZv/tLdZ2esSVzDwUC88SNs+6JoSOMVxA+gKMB8Tk7jBwgemLx4O40lhhvZCVw1C+OYLOBOPXWw==",
        "requires": {
          "archy": "^1.0.0",
          "caching-transform": "^3.0.2",
          "convert-source-map": "^1.6.0",
          "cp-file": "^6.2.0",
          "find-cache-dir": "^2.1.0",
          "find-up": "^3.0.0",
          "foreground-child": "^1.5.6",
          "glob": "^7.1.3",
          "istanbul-lib-coverage": "^2.0.5",
          "istanbul-lib-hook": "^2.0.7",
          "istanbul-lib-instrument": "^3.3.0",
          "istanbul-lib-report": "^2.0.8",
          "istanbul-lib-source-maps": "^3.0.6",
          "istanbul-reports": "^2.2.4",
          "js-yaml": "^3.13.1",
          "make-dir": "^2.1.0",
          "merge-source-map": "^1.1.0",
          "resolve-from": "^4.0.0",
          "rimraf": "^2.6.3",
          "signal-exit": "^3.0.2",
          "spawn-wrap": "^1.4.2",
          "test-exclude": "^5.2.3",
          "uuid": "^3.3.2",
          "yargs": "^13.2.2",
          "yargs-parser": "^13.0.0"
        }
      },
      "oauth-sign": {
        "version": "0.9.0",
        "resolved": "https://registry.npmjs.org/oauth-sign/-/oauth-sign-0.9.0.tgz",
        "integrity": "sha512-fexhUFFPTGV8ybAtSIGbV6gOkSv8UtRbDBnAyLQw4QPKkgNlsH2ByPGtMUqdWkos6YCRmAqViwgZrJc/mRDzZQ=="
      },
      "once": {
        "version": "1.4.0",
        "resolved": "https://registry.npmjs.org/once/-/once-1.4.0.tgz",
        "integrity": "sha1-WDsap3WWHUsROsF9nFC6753Xa9E=",
        "requires": {
          "wrappy": "1"
        }
      },
      "opener": {
        "version": "1.5.1",
        "resolved": "https://registry.npmjs.org/opener/-/opener-1.5.1.tgz",
        "integrity": "sha512-goYSy5c2UXE4Ra1xixabeVh1guIX/ZV/YokJksb6q2lubWu6UbvPQ20p542/sFIll1nl8JnCyK9oBaOcCWXwvA=="
      },
      "os-homedir": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/os-homedir/-/os-homedir-1.0.2.tgz",
        "integrity": "sha1-/7xJiDNuDoM94MFox+8VISGqf7M="
      },
      "own-or": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/own-or/-/own-or-1.0.0.tgz",
        "integrity": "sha1-Tod/vtqaLsgAD7wLyuOWRe6L+Nw="
      },
      "own-or-env": {
        "version": "1.0.1",
        "resolved": "https://registry.npmjs.org/own-or-env/-/own-or-env-1.0.1.tgz",
        "integrity": "sha512-y8qULRbRAlL6x2+M0vIe7jJbJx/kmUTzYonRAa2ayesR2qWLswninkVyeJe4x3IEXhdgoNodzjQRKAoEs6Fmrw==",
        "requires": {
          "own-or": "^1.0.0"
        }
      },
      "p-limit": {
        "version": "2.2.2",
        "resolved": "https://registry.npmjs.org/p-limit/-/p-limit-2.2.2.tgz",
        "integrity": "sha512-WGR+xHecKTr7EbUEhyLSh5Dube9JtdiG78ufaeLxTgpudf/20KqyMioIUZJAezlTIi6evxuoUs9YXc11cU+yzQ==",
        "requires": {
          "p-try": "^2.0.0"
        }
      },
      "p-locate": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/p-locate/-/p-locate-3.0.0.tgz",
        "integrity": "sha512-x+12w/To+4GFfgJhBEpiDcLozRJGegY+Ei7/z0tSLkMmxGZNybVMSfWj9aJn8Z5Fc7dBUNJOOVgPv2H7IwulSQ==",
        "requires": {
          "p-limit": "^2.0.0"
        }
      },
      "p-try": {
        "version": "2.2.0",
        "resolved": "https://registry.npmjs.org/p-try/-/p-try-2.2.0.tgz",
        "integrity": "sha512-R4nPAVTAU0B9D35/Gk3uJf/7XYbQcyohSKdvAxIRSNghFl4e71hVoGnBNQz9cWaXxO2I10KTC+3jMdvvoKw6dQ=="
      },
      "package-hash": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/package-hash/-/package-hash-3.0.0.tgz",
        "integrity": "sha512-lOtmukMDVvtkL84rJHI7dpTYq+0rli8N2wlnqUcBuDWCfVhRUfOmnR9SsoHFMLpACvEV60dX7rd0rFaYDZI+FA==",
        "requires": {
          "graceful-fs": "^4.1.15",
          "hasha": "^3.0.0",
          "lodash.flattendeep": "^4.4.0",
          "release-zalgo": "^1.0.0"
        }
      },
      "parse-json": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/parse-json/-/parse-json-4.0.0.tgz",
        "integrity": "sha1-vjX1Qlvh9/bHRxhPmKeIy5lHfuA=",
        "requires": {
          "error-ex": "^1.3.1",
          "json-parse-better-errors": "^1.0.1"
        }
      },
      "path-exists": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/path-exists/-/path-exists-3.0.0.tgz",
        "integrity": "sha1-zg6+ql94yxiSXqfYENe1mwEP1RU="
      },
      "path-is-absolute": {
        "version": "1.0.1",
        "resolved": "https://registry.npmjs.org/path-is-absolute/-/path-is-absolute-1.0.1.tgz",
        "integrity": "sha1-F0uSaHNVNP+8es5r9TpanhtcX18="
      },
      "path-parse": {
        "version": "1.0.6",
        "resolved": "https://registry.npmjs.org/path-parse/-/path-parse-1.0.6.tgz",
        "integrity": "sha512-GSmOT2EbHrINBf9SR7CDELwlJ8AENk3Qn7OikK4nFYAu3Ote2+JYNVvkpAEQm3/TLNEJFD/xZJjzyxg3KBWOzw=="
      },
      "path-type": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/path-type/-/path-type-3.0.0.tgz",
        "integrity": "sha512-T2ZUsdZFHgA3u4e5PfPbjd7HDDpxPnQb5jN0SrDsjNSuVXHJqtwTnWqG0B1jZrgmJ/7lj1EmVIByWt1gxGkWvg==",
        "requires": {
          "pify": "^3.0.0"
        },
        "dependencies": {
          "pify": {
            "version": "3.0.0",
            "resolved": "https://registry.npmjs.org/pify/-/pify-3.0.0.tgz",
            "integrity": "sha1-5aSs0sEB/fPZpNB/DbxNtJ3SgXY="
          }
        }
      },
      "performance-now": {
        "version": "2.1.0",
        "resolved": "https://registry.npmjs.org/performance-now/-/performance-now-2.1.0.tgz",
        "integrity": "sha1-Ywn04OX6kT7BxpMHrjZLSzd8nns="
      },
      "pify": {
        "version": "4.0.1",
        "resolved": "https://registry.npmjs.org/pify/-/pify-4.0.1.tgz",
        "integrity": "sha512-uB80kBFb/tfd68bVleG9T5GGsGPjJrLAUpR5PZIrhBnIaRTQRjqdJSsIKkOP6OAIFbj7GOrcudc5pNjZ+geV2g=="
      },
      "pkg-dir": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/pkg-dir/-/pkg-dir-3.0.0.tgz",
        "integrity": "sha512-/E57AYkoeQ25qkxMj5PBOVgF8Kiu/h7cYS30Z5+R7WaiCCBfLq58ZI/dSeaEKb9WVJV5n/03QwrN3IeWIFllvw==",
        "requires": {
          "find-up": "^3.0.0"
        }
      },
      "process-nextick-args": {
        "version": "2.0.1",
        "resolved": "https://registry.npmjs.org/process-nextick-args/-/process-nextick-args-2.0.1.tgz",
        "integrity": "sha512-3ouUOpQhtgrbOa17J7+uxOTpITYWaGP7/AhoR3+A+/1e9skrzelGi/dXzEYyvbxubEF6Wn2ypscTKiKJFFn1ag==",
        "optional": true
      },
      "pseudomap": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/pseudomap/-/pseudomap-1.0.2.tgz",
        "integrity": "sha1-8FKijacOYYkX7wqKw0wa5aaChrM="
      },
      "psl": {
        "version": "1.8.0",
        "resolved": "https://registry.npmjs.org/psl/-/psl-1.8.0.tgz",
        "integrity": "sha512-RIdOzyoavK+hA18OGGWDqUTsCLhtA7IcZ/6NCs4fFJaHBDab+pDDmDIByWFRQJq2Cd7r1OoQxBGKOaztq+hjIQ=="
      },
      "punycode": {
        "version": "2.1.1",
        "resolved": "https://registry.npmjs.org/punycode/-/punycode-2.1.1.tgz",
        "integrity": "sha512-XRsRjdf+j5ml+y/6GKHPZbrF/8p2Yga0JPtdqTIY2Xe5ohJPD9saDJJLPvp9+NSBprVvevdXZybnj2cv8OEd0A=="
      },
      "qs": {
        "version": "6.5.2",
        "resolved": "https://registry.npmjs.org/qs/-/qs-6.5.2.tgz",
        "integrity": "sha512-N5ZAX4/LxJmF+7wN74pUD6qAh9/wnvdQcjq9TZjevvXzSUo7bfmw91saqMjzGS2xq91/odN2dW/WOl7qQHNDGA=="
      },
      "read-pkg": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/read-pkg/-/read-pkg-3.0.0.tgz",
        "integrity": "sha1-nLxoaXj+5l0WwA4rGcI3/Pbjg4k=",
        "requires": {
          "load-json-file": "^4.0.0",
          "normalize-package-data": "^2.3.2",
          "path-type": "^3.0.0"
        }
      },
      "read-pkg-up": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/read-pkg-up/-/read-pkg-up-4.0.0.tgz",
        "integrity": "sha512-6etQSH7nJGsK0RbG/2TeDzZFa8shjQ1um+SwQQ5cwKy0dhSXdOncEhb1CPpvQG4h7FyOV6EB6YlV0yJvZQNAkA==",
        "requires": {
          "find-up": "^3.0.0",
          "read-pkg": "^3.0.0"
        }
      },
      "readable-stream": {
        "version": "2.3.7",
        "resolved": "https://registry.npmjs.org/readable-stream/-/readable-stream-2.3.7.tgz",
        "integrity": "sha512-Ebho8K4jIbHAxnuxi7o42OrZgF/ZTNcsZj6nRKyUmkhLFq8CHItp/fy6hQZuZmP/n3yZ9VBUbp4zz/mX8hmYPw==",
        "optional": true,
        "requires": {
          "core-util-is": "~1.0.0",
          "inherits": "~2.0.3",
          "isarray": "~1.0.0",
          "process-nextick-args": "~2.0.0",
          "safe-buffer": "~5.1.1",
          "string_decoder": "~1.1.1",
          "util-deprecate": "~1.0.1"
        },
        "dependencies": {
          "safe-buffer": {
            "version": "5.1.2",
            "resolved": "https://registry.npmjs.org/safe-buffer/-/safe-buffer-5.1.2.tgz",
            "integrity": "sha512-Gd2UZBJDkXlY7GbJxfsE8/nvKkUEU1G38c1siN6QP6a9PT9MmHB8GnpscSmMJSoF8LOIrt8ud/wPtojys4G6+g==",
            "optional": true
          }
        }
      },
      "release-zalgo": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/release-zalgo/-/release-zalgo-1.0.0.tgz",
        "integrity": "sha1-CXALflB0Mpc5Mw5TXFqQ+2eFFzA=",
        "requires": {
          "es6-error": "^4.0.1"
        }
      },
      "request": {
        "version": "2.88.2",
        "resolved": "https://registry.npmjs.org/request/-/request-2.88.2.tgz",
        "integrity": "sha512-MsvtOrfG9ZcrOwAW+Qi+F6HbD0CWXEh9ou77uOb7FM2WPhwT7smM833PzanhJLsgXjN89Ir6V2PczXNnMpwKhw==",
        "requires": {
          "aws-sign2": "~0.7.0",
          "aws4": "^1.8.0",
          "caseless": "~0.12.0",
          "combined-stream": "~1.0.6",
          "extend": "~3.0.2",
          "forever-agent": "~0.6.1",
          "form-data": "~2.3.2",
          "har-validator": "~5.1.3",
          "http-signature": "~1.2.0",
          "is-typedarray": "~1.0.0",
          "isstream": "~0.1.2",
          "json-stringify-safe": "~5.0.1",
          "mime-types": "~2.1.19",
          "oauth-sign": "~0.9.0",
          "performance-now": "^2.1.0",
          "qs": "~6.5.2",
          "safe-buffer": "^5.1.2",
          "tough-cookie": "~2.5.0",
          "tunnel-agent": "^0.6.0",
          "uuid": "^3.3.2"
        }
      },
      "require-directory": {
        "version": "2.1.1",
        "resolved": "https://registry.npmjs.org/require-directory/-/require-directory-2.1.1.tgz",
        "integrity": "sha1-jGStX9MNqxyXbiNE/+f3kqam30I="
      },
      "require-main-filename": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/require-main-filename/-/require-main-filename-2.0.0.tgz",
        "integrity": "sha512-NKN5kMDylKuldxYLSUfrbo5Tuzh4hd+2E8NPPX02mZtn1VuREQToYe/ZdlJy+J3uCpfaiGF05e7B8W0iXbQHmg=="
      },
      "resolve": {
        "version": "1.15.1",
        "resolved": "https://registry.npmjs.org/resolve/-/resolve-1.15.1.tgz",
        "integrity": "sha512-84oo6ZTtoTUpjgNEr5SJyzQhzL72gaRodsSfyxC/AXRvwu0Yse9H8eF9IpGo7b8YetZhlI6v7ZQ6bKBFV/6S7w==",
        "requires": {
          "path-parse": "^1.0.6"
        }
      },
      "resolve-from": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/resolve-from/-/resolve-from-4.0.0.tgz",
        "integrity": "sha512-pb/MYmXstAkysRFx8piNI1tGFNQIFA3vkE3Gq4EuA1dF6gHp/+vgZqsCGJapvy8N3Q+4o7FwvquPJcnZ7RYy4g=="
      },
      "rimraf": {
        "version": "2.7.1",
        "resolved": "https://registry.npmjs.org/rimraf/-/rimraf-2.7.1.tgz",
        "integrity": "sha512-uWjbaKIK3T1OSVptzX7Nl6PvQ3qAGtKEtVRjRuazjfL3Bx5eI409VZSqgND+4UNnmzLVdPj9FqFJNPqBZFve4w==",
        "requires": {
          "glob": "^7.1.3"
        }
      },
      "safe-buffer": {
        "version": "5.2.0",
        "resolved": "https://registry.npmjs.org/safe-buffer/-/safe-buffer-5.2.0.tgz",
        "integrity": "sha512-fZEwUGbVl7kouZs1jCdMLdt95hdIv0ZeHg6L7qPeciMZhZ+/gdesW4wgTARkrFWEpspjEATAzUGPG8N2jJiwbg=="
      },
      "safer-buffer": {
        "version": "2.1.2",
        "resolved": "https://registry.npmjs.org/safer-buffer/-/safer-buffer-2.1.2.tgz",
        "integrity": "sha512-YZo3K82SD7Riyi0E1EQPojLz7kpepnSQI9IyPbHHg1XXXevb5dJI7tpyN2ADxGcQbHG7vcyRHk0cbwqcQriUtg=="
      },
      "semver": {
        "version": "5.7.1",
        "resolved": "https://registry.npmjs.org/semver/-/semver-5.7.1.tgz",
        "integrity": "sha512-sauaDf/PZdVgrLTNYHRtpXa1iRiKcaebiKQ1BJdpQlWH2lCvexQdX55snPFyK7QzpudqbCI0qXFfOasHdyNDGQ=="
      },
      "set-blocking": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/set-blocking/-/set-blocking-2.0.0.tgz",
        "integrity": "sha1-BF+XgtARrppoA93TgrJDkrPYkPc="
      },
      "signal-exit": {
        "version": "3.0.3",
        "resolved": "https://registry.npmjs.org/signal-exit/-/signal-exit-3.0.3.tgz",
        "integrity": "sha512-VUJ49FC8U1OxwZLxIbTTrDvLnf/6TDgxZcK8wxR8zs13xpx7xbG60ndBlhNrFi2EMuFRoeDoJO7wthSLq42EjA=="
      },
      "source-map": {
        "version": "0.6.1",
        "resolved": "https://registry.npmjs.org/source-map/-/source-map-0.6.1.tgz",
        "integrity": "sha512-UjgapumWlbMhkBgzT7Ykc5YXUT46F0iKu8SGXq0bcwP5dz/h0Plj6enJqjz1Zbq2l5WaqYnrVbwWOWMyF3F47g=="
      },
      "source-map-support": {
        "version": "0.5.16",
        "resolved": "https://registry.npmjs.org/source-map-support/-/source-map-support-0.5.16.tgz",
        "integrity": "sha512-efyLRJDr68D9hBBNIPWFjhpFzURh+KJykQwvMyW5UiZzYwoF6l4YMMDIJJEyFWxWCqfyxLzz6tSfUFR+kXXsVQ==",
        "requires": {
          "buffer-from": "^1.0.0",
          "source-map": "^0.6.0"
        }
      },
      "spawn-wrap": {
        "version": "1.4.3",
        "resolved": "https://registry.npmjs.org/spawn-wrap/-/spawn-wrap-1.4.3.tgz",
        "integrity": "sha512-IgB8md0QW/+tWqcavuFgKYR/qIRvJkRLPJDFaoXtLLUaVcCDK0+HeFTkmQHj3eprcYhc+gOl0aEA1w7qZlYezw==",
        "requires": {
          "foreground-child": "^1.5.6",
          "mkdirp": "^0.5.0",
          "os-homedir": "^1.0.1",
          "rimraf": "^2.6.2",
          "signal-exit": "^3.0.2",
          "which": "^1.3.0"
        },
        "dependencies": {
          "mkdirp": {
            "version": "0.5.4",
            "resolved": "https://registry.npmjs.org/mkdirp/-/mkdirp-0.5.4.tgz",
            "integrity": "sha512-iG9AK/dJLtJ0XNgTuDbSyNS3zECqDlAhnQW4CsNxBG3LQJBbHmRX1egw39DmtOdCAqY+dKXV+sgPgilNWUKMVw==",
            "requires": {
              "minimist": "^1.2.5"
            }
          },
          "which": {
            "version": "1.3.1",
            "resolved": "https://registry.npmjs.org/which/-/which-1.3.1.tgz",
            "integrity": "sha512-HxJdYWq1MTIQbJ3nw0cqssHoTNU267KlrDuGZ1WYlxDStUtKUhOaJmh112/TZmHxxUfuJqPXSOm7tDyas0OSIQ==",
            "requires": {
              "isexe": "^2.0.0"
            }
          }
        }
      },
      "spdx-correct": {
        "version": "3.1.0",
        "resolved": "https://registry.npmjs.org/spdx-correct/-/spdx-correct-3.1.0.tgz",
        "integrity": "sha512-lr2EZCctC2BNR7j7WzJ2FpDznxky1sjfxvvYEyzxNyb6lZXHODmEoJeFu4JupYlkfha1KZpJyoqiJ7pgA1qq8Q==",
        "requires": {
          "spdx-expression-parse": "^3.0.0",
          "spdx-license-ids": "^3.0.0"
        }
      },
      "spdx-exceptions": {
        "version": "2.2.0",
        "resolved": "https://registry.npmjs.org/spdx-exceptions/-/spdx-exceptions-2.2.0.tgz",
        "integrity": "sha512-2XQACfElKi9SlVb1CYadKDXvoajPgBVPn/gOQLrTvHdElaVhr7ZEbqJaRnJLVNeaI4cMEAgVCeBMKF6MWRDCRA=="
      },
      "spdx-expression-parse": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/spdx-expression-parse/-/spdx-expression-parse-3.0.0.tgz",
        "integrity": "sha512-Yg6D3XpRD4kkOmTpdgbUiEJFKghJH03fiC1OPll5h/0sO6neh2jqRDVHOQ4o/LMea0tgCkbMgea5ip/e+MkWyg==",
        "requires": {
          "spdx-exceptions": "^2.1.0",
          "spdx-license-ids": "^3.0.0"
        }
      },
      "spdx-license-ids": {
        "version": "3.0.5",
        "resolved": "https://registry.npmjs.org/spdx-license-ids/-/spdx-license-ids-3.0.5.tgz",
        "integrity": "sha512-J+FWzZoynJEXGphVIS+XEh3kFSjZX/1i9gFBaWQcB+/tmpe2qUsSBABpcxqxnAxFdiUFEgAX1bjYGQvIZmoz9Q=="
      },
      "sprintf-js": {
        "version": "1.0.3",
        "resolved": "https://registry.npmjs.org/sprintf-js/-/sprintf-js-1.0.3.tgz",
        "integrity": "sha1-BOaSb2YolTVPPdAVIDYzuFcpfiw="
      },
      "sshpk": {
        "version": "1.16.1",
        "resolved": "https://registry.npmjs.org/sshpk/-/sshpk-1.16.1.tgz",
        "integrity": "sha512-HXXqVUq7+pcKeLqqZj6mHFUMvXtOJt1uoUx09pFW6011inTMxqI8BA8PM95myrIyyKwdnzjdFjLiE6KBPVtJIg==",
        "requires": {
          "asn1": "~0.2.3",
          "assert-plus": "^1.0.0",
          "bcrypt-pbkdf": "^1.0.0",
          "dashdash": "^1.12.0",
          "ecc-jsbn": "~0.1.1",
          "getpass": "^0.1.1",
          "jsbn": "~0.1.0",
          "safer-buffer": "^2.0.2",
          "tweetnacl": "~0.14.0"
        }
      },
      "stack-utils": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/stack-utils/-/stack-utils-1.0.2.tgz",
        "integrity": "sha512-MTX+MeG5U994cazkjd/9KNAapsHnibjMLnfXodlkXw76JEea0UiNzrqidzo1emMwk7w5Qhc9jd4Bn9TBb1MFwA=="
      },
      "string_decoder": {
        "version": "1.1.1",
        "resolved": "https://registry.npmjs.org/string_decoder/-/string_decoder-1.1.1.tgz",
        "integrity": "sha512-n/ShnvDi6FHbbVfviro+WojiFzv+s8MPMHBczVePfUpDJLwoLT0ht1l4YwBCbi8pJAveEEdnkHyPyTP/mzRfwg==",
        "optional": true,
        "requires": {
          "safe-buffer": "~5.1.0"
        },
        "dependencies": {
          "safe-buffer": {
            "version": "5.1.2",
            "resolved": "https://registry.npmjs.org/safe-buffer/-/safe-buffer-5.1.2.tgz",
            "integrity": "sha512-Gd2UZBJDkXlY7GbJxfsE8/nvKkUEU1G38c1siN6QP6a9PT9MmHB8GnpscSmMJSoF8LOIrt8ud/wPtojys4G6+g==",
            "optional": true
          }
        }
      },
      "strip-ansi": {
        "version": "3.0.1",
        "resolved": "https://registry.npmjs.org/strip-ansi/-/strip-ansi-3.0.1.tgz",
        "integrity": "sha1-ajhfuIU9lS1f8F0Oiq+UJ43GPc8=",
        "requires": {
          "ansi-regex": "^2.0.0"
        }
      },
      "strip-bom": {
        "version": "3.0.0",
        "resolved": "https://registry.npmjs.org/strip-bom/-/strip-bom-3.0.0.tgz",
        "integrity": "sha1-IzTBjpx1n3vdVv3vfprj1YjmjtM="
      },
      "supports-color": {
        "version": "5.5.0",
        "resolved": "https://registry.npmjs.org/supports-color/-/supports-color-5.5.0.tgz",
        "integrity": "sha512-QjVjwdXIt408MIiAqCX4oUKsgU2EqAGzs2Ppkm4aQYbjm+ZEWEcW4SfFNTr4uMNZma0ey4f5lgLrkB0aX0QMow==",
        "requires": {
          "has-flag": "^3.0.0"
        }
      },
      "tap": {
        "version": "12.7.0",
        "resolved": "https://registry.npmjs.org/tap/-/tap-12.7.0.tgz",
        "integrity": "sha512-SjglJmRv0pqrQQ7d5ZBEY8ZOqv3nYDBXEX51oyycOH7piuhn82JKT/yDNewwmOsodTD/RZL9MccA96EjDgK+Eg==",
        "requires": {
          "bind-obj-methods": "^2.0.0",
          "browser-process-hrtime": "^1.0.0",
          "capture-stack-trace": "^1.0.0",
          "clean-yaml-object": "^0.1.0",
          "color-support": "^1.1.0",
          "coveralls": "^3.0.2",
          "domain-browser": "^1.2.0",
          "esm": "^3.2.5",
          "foreground-child": "^1.3.3",
          "fs-exists-cached": "^1.0.0",
          "function-loop": "^1.0.1",
          "glob": "^7.1.3",
          "isexe": "^2.0.0",
          "js-yaml": "^3.13.1",
          "minipass": "^2.3.5",
          "mkdirp": "^0.5.1",
          "nyc": "^14.0.0",
          "opener": "^1.5.1",
          "os-homedir": "^1.0.2",
          "own-or": "^1.0.0",
          "own-or-env": "^1.0.1",
          "rimraf": "^2.6.3",
          "signal-exit": "^3.0.0",
          "source-map-support": "^0.5.10",
          "stack-utils": "^1.0.2",
          "tap-mocha-reporter": "^3.0.9",
          "tap-parser": "^7.0.0",
          "tmatch": "^4.0.0",
          "trivial-deferred": "^1.0.1",
          "ts-node": "^8.0.2",
          "tsame": "^2.0.1",
          "typescript": "^3.3.3",
          "write-file-atomic": "^2.4.2",
          "yapool": "^1.0.0"
        },
        "dependencies": {
          "minimist": {
            "version": "1.2.5"
          },
          "mkdirp": {
            "version": "0.5.4",
            "resolved": "https://registry.npmjs.org/mkdirp/-/mkdirp-0.5.4.tgz",
            "integrity": "sha512-iG9AK/dJLtJ0XNgTuDbSyNS3zECqDlAhnQW4CsNxBG3LQJBbHmRX1egw39DmtOdCAqY+dKXV+sgPgilNWUKMVw==",
            "requires": {
              "minimist": "^1.2.5"
            }
          }
        }
      },
      "tap-mocha-reporter": {
        "version": "3.0.9",
        "resolved": "https://registry.npmjs.org/tap-mocha-reporter/-/tap-mocha-reporter-3.0.9.tgz",
        "integrity": "sha512-VO07vhC9EG27EZdOe7bWBj1ldbK+DL9TnRadOgdQmiQOVZjFpUEQuuqO7+rNSO2kfmkq5hWeluYXDWNG/ytXTQ==",
        "requires": {
          "color-support": "^1.1.0",
          "debug": "^2.1.3",
          "diff": "^1.3.2",
          "escape-string-regexp": "^1.0.3",
          "glob": "^7.0.5",
          "js-yaml": "^3.3.1",
          "readable-stream": "^2.1.5",
          "tap-parser": "^5.1.0",
          "unicode-length": "^1.0.0"
        },
        "dependencies": {
          "debug": {
            "version": "2.6.9",
            "resolved": "https://registry.npmjs.org/debug/-/debug-2.6.9.tgz",
            "integrity": "sha512-bC7ElrdJaJnPbAP+1EotYvqZsb3ecl5wi6Bfi6BJTUcNowp6cvspg0jXznRTKDjm/E7AdgFBVeAPVMNcKGsHMA==",
            "requires": {
              "ms": "2.0.0"
            }
          },
          "diff": {
            "version": "1.4.0",
            "resolved": "https://registry.npmjs.org/diff/-/diff-1.4.0.tgz",
            "integrity": "sha1-fyjS657nsVqX79ic5j3P2qPMur8="
          },
          "ms": {
            "version": "2.0.0",
            "resolved": "https://registry.npmjs.org/ms/-/ms-2.0.0.tgz",
            "integrity": "sha1-VgiurfwAvmwpAd9fmGF4jeDVl8g="
          },
          "tap-parser": {
            "version": "5.4.0",
            "resolved": "https://registry.npmjs.org/tap-parser/-/tap-parser-5.4.0.tgz",
            "integrity": "sha512-BIsIaGqv7uTQgTW1KLTMNPSEQf4zDDPgYOBRdgOfuB+JFOLRBfEu6cLa/KvMvmqggu1FKXDfitjLwsq4827RvA==",
            "requires": {
              "events-to-array": "^1.0.1",
              "js-yaml": "^3.2.7",
              "readable-stream": "^2"
            }
          }
        }
      },
      "tap-parser": {
        "version": "7.0.0",
        "resolved": "https://registry.npmjs.org/tap-parser/-/tap-parser-7.0.0.tgz",
        "integrity": "sha512-05G8/LrzqOOFvZhhAk32wsGiPZ1lfUrl+iV7+OkKgfofZxiceZWMHkKmow71YsyVQ8IvGBP2EjcIjE5gL4l5lA==",
        "requires": {
          "events-to-array": "^1.0.1",
          "js-yaml": "^3.2.7",
          "minipass": "^2.2.0"
        }
      },
      "test-exclude": {
        "version": "5.2.3",
        "resolved": "https://registry.npmjs.org/test-exclude/-/test-exclude-5.2.3.tgz",
        "integrity": "sha512-M+oxtseCFO3EDtAaGH7iiej3CBkzXqFMbzqYAACdzKui4eZA+pq3tZEwChvOdNfa7xxy8BfbmgJSIr43cC/+2g==",
        "requires": {
          "glob": "^7.1.3",
          "minimatch": "^3.0.4",
          "read-pkg-up": "^4.0.0",
          "require-main-filename": "^2.0.0"
        }
      },
      "tmatch": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/tmatch/-/tmatch-4.0.0.tgz",
        "integrity": "sha512-Ynn2Gsp+oCvYScQXeV+cCs7citRDilq0qDXA6tuvFwDgiYyyaq7D5vKUlAPezzZR5NDobc/QMeN6e5guOYmvxg=="
      },
      "to-fast-properties": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/to-fast-properties/-/to-fast-properties-2.0.0.tgz",
        "integrity": "sha1-3F5pjL0HkmW8c+A3doGk5Og/YW4="
      },
      "tough-cookie": {
        "version": "2.5.0",
        "resolved": "https://registry.npmjs.org/tough-cookie/-/tough-cookie-2.5.0.tgz",
        "integrity": "sha512-nlLsUzgm1kfLXSXfRZMc1KLAugd4hqJHDTvc2hDIwS3mZAfMEuMbc03SujMF+GEcpaX/qboeycw6iO8JwVv2+g==",
        "requires": {
          "psl": "^1.1.28",
          "punycode": "^2.1.1"
        }
      },
      "trivial-deferred": {
        "version": "1.0.1",
        "resolved": "https://registry.npmjs.org/trivial-deferred/-/trivial-deferred-1.0.1.tgz",
        "integrity": "sha1-N21NKdlR1jaKb3oK6FwvTV4GWPM="
      },
      "ts-node": {
        "version": "8.8.1",
        "resolved": "https://registry.npmjs.org/ts-node/-/ts-node-8.8.1.tgz",
        "integrity": "sha512-10DE9ONho06QORKAaCBpPiFCdW+tZJuY/84tyypGtl6r+/C7Asq0dhqbRZURuUlLQtZxxDvT8eoj8cGW0ha6Bg==",
        "requires": {
          "arg": "^4.1.0",
          "diff": "^4.0.1",
          "make-error": "^1.1.1",
          "source-map-support": "^0.5.6",
          "yn": "3.1.1"
        }
      },
      "tsame": {
        "version": "2.0.1",
        "resolved": "https://registry.npmjs.org/tsame/-/tsame-2.0.1.tgz",
        "integrity": "sha512-jxyxgKVKa4Bh5dPcO42TJL22lIvfd9LOVJwdovKOnJa4TLLrHxquK+DlGm4rkGmrcur+GRx+x4oW00O2pY/fFw=="
      },
      "tunnel-agent": {
        "version": "0.6.0",
        "resolved": "https://registry.npmjs.org/tunnel-agent/-/tunnel-agent-0.6.0.tgz",
        "integrity": "sha1-J6XeoGs2sEoKmWZ3SykIaPD8QP0=",
        "requires": {
          "safe-buffer": "^5.0.1"
        }
      },
      "tweetnacl": {
        "version": "0.14.5",
        "resolved": "https://registry.npmjs.org/tweetnacl/-/tweetnacl-0.14.5.tgz",
        "integrity": "sha1-WuaBd/GS1EViadEIr6k/+HQ/T2Q="
      },
      "typescript": {
        "version": "3.8.3",
        "resolved": "https://registry.npmjs.org/typescript/-/typescript-3.8.3.tgz",
        "integrity": "sha512-MYlEfn5VrLNsgudQTVJeNaQFUAI7DkhnOjdpAp4T+ku1TfQClewlbSuTVHiA+8skNBgaf02TL/kLOvig4y3G8w=="
      },
      "unicode-length": {
        "version": "1.0.3",
        "resolved": "https://registry.npmjs.org/unicode-length/-/unicode-length-1.0.3.tgz",
        "integrity": "sha1-Wtp6f+1RhBpBijKM8UlHisg1irs=",
        "requires": {
          "punycode": "^1.3.2",
          "strip-ansi": "^3.0.1"
        },
        "dependencies": {
          "punycode": {
            "version": "1.4.1",
            "resolved": "https://registry.npmjs.org/punycode/-/punycode-1.4.1.tgz",
            "integrity": "sha1-wNWmOycYgArY4esPpSachN1BhF4="
          }
        }
      },
      "uri-js": {
        "version": "4.2.2",
        "resolved": "https://registry.npmjs.org/uri-js/-/uri-js-4.2.2.tgz",
        "integrity": "sha512-KY9Frmirql91X2Qgjry0Wd4Y+YTdrdZheS8TFwvkbLWf/G5KNJDCh6pKL5OZctEW4+0Baa5idK2ZQuELRwPznQ==",
        "requires": {
          "punycode": "^2.1.0"
        }
      },
      "util-deprecate": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/util-deprecate/-/util-deprecate-1.0.2.tgz",
        "integrity": "sha1-RQ1Nyfpw3nMnYvvS1KKJgUGaDM8=",
        "optional": true
      },
      "uuid": {
        "version": "3.4.0",
        "resolved": "https://registry.npmjs.org/uuid/-/uuid-3.4.0.tgz",
        "integrity": "sha512-HjSDRw6gZE5JMggctHBcjVak08+KEVhSIiDzFnT9S9aegmp85S/bReBVTb4QTFaRNptJ9kuYaNhnbNEOkbKb/A=="
      },
      "validate-npm-package-license": {
        "version": "3.0.4",
        "resolved": "https://registry.npmjs.org/validate-npm-package-license/-/validate-npm-package-license-3.0.4.tgz",
        "integrity": "sha512-DpKm2Ui/xN7/HQKCtpZxoRWBhZ9Z0kqtygG8XCgNQ8ZlDnxuQmWhj566j8fN4Cu3/JmbhsDo7fcAJq4s9h27Ew==",
        "requires": {
          "spdx-correct": "^3.0.0",
          "spdx-expression-parse": "^3.0.0"
        }
      },
      "verror": {
        "version": "1.10.0",
        "resolved": "https://registry.npmjs.org/verror/-/verror-1.10.0.tgz",
        "integrity": "sha1-OhBcoXBTr1XW4nDB+CiGguGNpAA=",
        "requires": {
          "assert-plus": "^1.0.0",
          "core-util-is": "1.0.2",
          "extsprintf": "^1.2.0"
        }
      },
      "which-module": {
        "version": "2.0.0",
        "resolved": "https://registry.npmjs.org/which-module/-/which-module-2.0.0.tgz",
        "integrity": "sha1-2e8H3Od7mQK4o6j6SzHD4/fm6Ho="
      },
      "wrappy": {
        "version": "1.0.2",
        "resolved": "https://registry.npmjs.org/wrappy/-/wrappy-1.0.2.tgz",
        "integrity": "sha1-tSQ9jz7BqjXxNkYFvA0QNuMKtp8="
      },
      "write-file-atomic": {
        "version": "2.4.3",
        "resolved": "https://registry.npmjs.org/write-file-atomic/-/write-file-atomic-2.4.3.tgz",
        "integrity": "sha512-GaETH5wwsX+GcnzhPgKcKjJ6M2Cq3/iZp1WyY/X1CSqrW+jVNM9Y7D8EC2sM4ZG/V8wZlSniJnCKWPmBYAucRQ==",
        "requires": {
          "graceful-fs": "^4.1.11",
          "imurmurhash": "^0.1.4",
          "signal-exit": "^3.0.2"
        }
      },
      "y18n": {
        "version": "4.0.0",
        "resolved": "https://registry.npmjs.org/y18n/-/y18n-4.0.0.tgz",
        "integrity": "sha512-r9S/ZyXu/Xu9q1tYlpsLIsa3EeLXXk0VwlxqTcFRfg9EhMW+17kbt9G0NrgCmhGb5vT2hyhJZLfDGx+7+5Uj/w=="
      },
      "yallist": {
        "version": "2.1.2",
        "resolved": "https://registry.npmjs.org/yallist/-/yallist-2.1.2.tgz",
        "integrity": "sha1-HBH5IY8HYImkfdUS+TxmmaaoHVI="
      },
      "yapool": {
        "version": "1.0.0",
        "resolved": "https://registry.npmjs.org/yapool/-/yapool-1.0.0.tgz",
        "integrity": "sha1-9pPymjFbUNmp2iZGp6ZkXJaYW2o="
      },
      "yargs": {
        "version": "13.3.2",
        "resolved": "https://registry.npmjs.org/yargs/-/yargs-13.3.2.tgz",
        "integrity": "sha512-AX3Zw5iPruN5ie6xGRIDgqkT+ZhnRlZMLMHAs8tg7nRruy2Nb+i5o9bwghAogtM08q1dpr2LVoS8KSTMYpWXUw==",
        "requires": {
          "cliui": "^5.0.0",
          "find-up": "^3.0.0",
          "get-caller-file": "^2.0.1",
          "require-directory": "^2.1.1",
          "require-main-filename": "^2.0.0",
          "set-blocking": "^2.0.0",
          "string-width": "^3.0.0",
          "which-module": "^2.0.0",
          "y18n": "^4.0.0",
          "yargs-parser": "^13.1.2"
        },
        "dependencies": {
          "ansi-regex": {
            "version": "4.1.0",
            "resolved": "https://registry.npmjs.org/ansi-regex/-/ansi-regex-4.1.0.tgz",
            "integrity": "sha512-1apePfXM1UOSqw0o9IiFAovVz9M5S1Dg+4TrDwfMewQ6p/rmMueb7tWZjQ1rx4Loy1ArBggoqGpfqqdI4rondg=="
          },
          "cliui": {
            "version": "5.0.0",
            "resolved": "https://registry.npmjs.org/cliui/-/cliui-5.0.0.tgz",
            "integrity": "sha512-PYeGSEmmHM6zvoef2w8TPzlrnNpXIjTipYK780YswmIP9vjxmd6Y2a3CB2Ks6/AU8NHjZugXvo8w3oWM2qnwXA==",
            "requires": {
              "string-width": "^3.1.0",
              "strip-ansi": "^5.2.0",
              "wrap-ansi": "^5.1.0"
            }
          },
          "string-width": {
            "version": "3.1.0",
            "resolved": "https://registry.npmjs.org/string-width/-/string-width-3.1.0.tgz",
            "integrity": "sha512-vafcv6KjVZKSgz06oM/H6GDBrAtz8vdhQakGjFIvNrHA6y3HCF1CInLy+QLq8dTJPQ1b+KDUqDFctkdRW44e1w==",
            "requires": {
              "emoji-regex": "^7.0.1",
              "is-fullwidth-code-point": "^2.0.0",
              "strip-ansi": "^5.1.0"
            }
          },
          "strip-ansi": {
            "version": "5.2.0",
            "resolved": "https://registry.npmjs.org/strip-ansi/-/strip-ansi-5.2.0.tgz",
            "integrity": "sha512-DuRs1gKbBqsMKIZlrffwlug8MHkcnpjs5VPmL1PAh+mA30U0DTotfDZ0d2UUsXpPmPmMMJ6W773MaA3J+lbiWA==",
            "requires": {
              "ansi-regex": "^4.1.0"
            }
          },
          "wrap-ansi": {
            "version": "5.1.0",
            "resolved": "https://registry.npmjs.org/wrap-ansi/-/wrap-ansi-5.1.0.tgz",
            "integrity": "sha512-QC1/iN/2/RPVJ5jYK8BGttj5z83LmSKmvbvrXPNCLZSEb32KKVDJDl/MOt2N01qU2H/FkzEa9PKto1BqDjtd7Q==",
            "requires": {
              "ansi-styles": "^3.2.0",
              "string-width": "^3.0.0",
              "strip-ansi": "^5.0.0"
            }
          }
        }
      },
      "yargs-parser": {
        "version": "13.1.2",
        "resolved": "https://registry.npmjs.org/yargs-parser/-/yargs-parser-13.1.2.tgz",
        "integrity": "sha512-3lbsNRf/j+A4QuSZfDRA7HRSfWrzO0YjqTJd5kjAq37Zep1CEgaYmrH9Q3GwPiB9cHyd1Y1UwggGhJGoxipbzg==",
        "requires": {
          "camelcase": "^5.0.0",
          "decamelize": "^1.2.0"
        }
      },
      "yn": {
        "version": "3.1.1",
        "resolved": "https://registry.npmjs.org/yn/-/yn-3.1.1.tgz",
        "integrity": "sha512-Ux4ygGWsu2c7isFWe8Yu1YluJmqVhxqK2cLXNQA5AcC3QfbGNpM7fu0Y8b/z16pXLnFxZYvWhd3fhBY9DLmC6Q=="
      }
    }
  }),
  "package.json": JSON.stringify({
    "dependencies": {
      "tap": "12"
    }
  })
})
  return path
}
