module.exports = function getLocation(source, search) {
	var lines = source.split('\n');
	var len = lines.length;

	var lineStart = 0;
	var i;

	const charIndex = typeof search === 'number' ? search : source.indexOf(search);

	for (i = 0; i < len; i += 1) {
		var line = lines[i];
		var lineEnd = lineStart + line.length + 1; // +1 for newline

		if (lineEnd > charIndex) {
			return { line: i + 1, column: charIndex - lineStart };
		}

		lineStart = lineEnd;
	}

	throw new Error('Could not determine location of character');
};
