/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;

public class SingletonComparison
extends BinaryExpression
implements ComparisonExpression {
    private AtomicComparer comparer;
    private boolean needsRuntimeCheck = true;

    public SingletonComparison(Expression p1, int operator, Expression p2, boolean checkTypes) {
        super(p1, operator, p2);
        this.needsRuntimeCheck = checkTypes;
    }

    public void setAtomicComparer(AtomicComparer comp) {
        this.comparer = comp;
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public boolean convertsUntypedToOther() {
        return true;
    }

    public int computeCardinality() {
        return 16384;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public Expression copy() {
        SingletonComparison sc = new SingletonComparison(this.operand0.copy(), this.operator, this.operand1.copy(), this.needsRuntimeCheck);
        sc.comparer = this.comparer;
        return sc;
    }

    public boolean needsRuntimeComparabilityCheck() {
        return this.needsRuntimeCheck;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        AtomicValue v1 = (AtomicValue)this.operand0.evaluateItem(context);
        if (v1 == null) {
            return false;
        }
        AtomicValue v2 = (AtomicValue)this.operand1.evaluateItem(context);
        if (v2 == null) {
            return false;
        }
        try {
            return GeneralComparison.compare(v1, this.operator, v2, this.comparer, this.needsRuntimeCheck, context);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    protected void explainExtraAttributes(ExpressionPresenter out) {
        out.emitAttribute("cardinality", "singleton");
    }
}

