/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2012 Sun Microsystems, Inc.
 */
package org.netbeans.modules.cordova.project;

import java.io.IOException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cordova.CordovaPerformer;
import org.netbeans.modules.cordova.updatetask.SourceConfig;
import org.netbeans.modules.cordova.wizard.CordovaTemplate;
import org.openide.util.NbBundle;

/**
 *
 * @author Jan Becicka
 */
public class CordovaPanel extends javax.swing.JPanel {

    private CordovaTemplate.CordovaExtender ext;
    
    public static String PROP_EXT_ENABLED = "PROP_EXT_ENABLED";//NOI18N

    /**
     * Creates new form CordovaPanel
     */
    public CordovaPanel(CordovaTemplate.CordovaExtender ext) {
        this.ext = ext;
        setName(NbBundle.getMessage(CordovaPanel.class, "LBL_CordovaSetup"));//NOI18N
        initComponents();
        update();
        platformsPane.setVisible(false);
        packageTextField.getDocument().addDocumentListener(new DocumentListener() {

            @Override
            public void insertUpdate(DocumentEvent e) {
                fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                fireChange();
            }
       });
    }
    
    private void fireChange() {
        firePropertyChange("id", null, packageTextField.getText());
    }
    
    public CordovaPanel() {
        this(null);
        platformsPane.setVisible(true);
    }
    
    public void setControlsEnabled(boolean enabled) {
        androidTarget.setEnabled(enabled);
        androidTargetCombo.setEnabled(enabled);
        iosTarget.setEnabled(enabled);
        iosTargetCombo.setEnabled(enabled);
        packageLabel.setEnabled(enabled);
        packageTextField.setEnabled(enabled);
        this.setEnabled(enabled);
    }    
    
    public void update() {
        androidTarget.setVisible(false);
        iosTarget.setVisible(false);
        androidTargetCombo.setVisible(false);
        iosTargetCombo.setVisible(false);
   }


    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        phoneGapCheckBox = new javax.swing.JCheckBox();
        platformsPane = new javax.swing.JTabbedPane();
        androidPanel = new javax.swing.JPanel();
        androidTarget = new javax.swing.JLabel();
        androidTargetCombo = new javax.swing.JComboBox();
        labXhdpiIcon = new javax.swing.JLabel();
        labLdpiSplashLandscape = new javax.swing.JLabel();
        labLdpiSplashPortrait = new javax.swing.JLabel();
        labMdpiSplashLandscape = new javax.swing.JLabel();
        labMdpiSplashPortrait = new javax.swing.JLabel();
        labHdpiSplashLandscape = new javax.swing.JLabel();
        labHdpiSplashPortrait = new javax.swing.JLabel();
        labXhdpiSplashLandscape = new javax.swing.JLabel();
        labXhdpiSplashPortrait = new javax.swing.JLabel();
        tfXhdpiIcon = new javax.swing.JTextField();
        tfLdpiSplashLandscape = new javax.swing.JTextField();
        tfLdpiSplashPortrait = new javax.swing.JTextField();
        tfMdpiSplashLandscape = new javax.swing.JTextField();
        tfMdpiSplashPortrait = new javax.swing.JTextField();
        tfHdpiSplashLandscape = new javax.swing.JTextField();
        tfHdpiSplashPortrait = new javax.swing.JTextField();
        tfXhdpiSplashLandscape = new javax.swing.JTextField();
        tfXHdpiSplashPortrait = new javax.swing.JTextField();
        iOSPanel = new javax.swing.JPanel();
        iosTarget = new javax.swing.JLabel();
        iosTargetCombo = new javax.swing.JComboBox();
        labRetinaIcon = new javax.swing.JLabel();
        labiPhoneSplashLandscape = new javax.swing.JLabel();
        labiPhoneSplashPortrait = new javax.swing.JLabel();
        labiPhoneSplashRetLandscape = new javax.swing.JLabel();
        labPhoneSplashRetPortrait = new javax.swing.JLabel();
        labiPadSplashLandscape = new javax.swing.JLabel();
        labiPadSplashPortrait = new javax.swing.JLabel();
        labiPadSplashRetLandscape = new javax.swing.JLabel();
        labiPadSplashRetPortrait = new javax.swing.JLabel();
        tfRetinaIcon = new javax.swing.JTextField();
        tfiPhoneSplashLandscape = new javax.swing.JTextField();
        tfiPhoneSplashPortrait = new javax.swing.JTextField();
        tfiPhoneSplashRetLandscape = new javax.swing.JTextField();
        tfiPhoneSplashRetPortrait = new javax.swing.JTextField();
        tfiPadSplashLandscape = new javax.swing.JTextField();
        tfiPadSplashPortrait = new javax.swing.JTextField();
        tfiPadSplashRetLandscape = new javax.swing.JTextField();
        tfiPadSplashRetPortrait = new javax.swing.JTextField();
        packageTextField = new javax.swing.JTextField();
        packageLabel = new javax.swing.JLabel();
        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        versionTextField = new javax.swing.JTextField();
        versionLabel = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(phoneGapCheckBox, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.phoneGapCheckBox.text")); // NOI18N
        phoneGapCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                phoneGapCheckBoxStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(androidTarget, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.androidTarget.text")); // NOI18N

        androidTargetCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "API Level 14 (Android 4.0+)", "API Level 8 (Android 2.2+)" }));

        org.openide.awt.Mnemonics.setLocalizedText(labXhdpiIcon, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labXhdpiIcon.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labLdpiSplashLandscape, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labLdpiSplashLandscape.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labLdpiSplashPortrait, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labLdpiSplashPortrait.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labMdpiSplashLandscape, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labMdpiSplashLandscape.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labMdpiSplashPortrait, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labMdpiSplashPortrait.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labHdpiSplashLandscape, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labHdpiSplashLandscape.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labHdpiSplashPortrait, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labHdpiSplashPortrait.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labXhdpiSplashLandscape, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labXhdpiSplashLandscape.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labXhdpiSplashPortrait, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labXhdpiSplashPortrait.text")); // NOI18N

        javax.swing.GroupLayout androidPanelLayout = new javax.swing.GroupLayout(androidPanel);
        androidPanel.setLayout(androidPanelLayout);
        androidPanelLayout.setHorizontalGroup(
            androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(androidPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(androidPanelLayout.createSequentialGroup()
                        .addComponent(androidTarget)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(androidTargetCombo, 0, 312, Short.MAX_VALUE))
                    .addGroup(androidPanelLayout.createSequentialGroup()
                        .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(labXhdpiSplashLandscape)
                            .addComponent(labXhdpiSplashPortrait)
                            .addComponent(labHdpiSplashPortrait)
                            .addComponent(labHdpiSplashLandscape)
                            .addComponent(labMdpiSplashPortrait)
                            .addComponent(labMdpiSplashLandscape)
                            .addComponent(labLdpiSplashPortrait)
                            .addComponent(labLdpiSplashLandscape)
                            .addComponent(labXhdpiIcon))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(tfXhdpiIcon)
                            .addComponent(tfLdpiSplashLandscape)
                            .addComponent(tfLdpiSplashPortrait)
                            .addComponent(tfMdpiSplashLandscape)
                            .addComponent(tfMdpiSplashPortrait)
                            .addComponent(tfHdpiSplashLandscape)
                            .addComponent(tfHdpiSplashPortrait)
                            .addComponent(tfXHdpiSplashPortrait)
                            .addComponent(tfXhdpiSplashLandscape)))))
        );
        androidPanelLayout.setVerticalGroup(
            androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(androidPanelLayout.createSequentialGroup()
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(androidTarget)
                    .addComponent(androidTargetCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, 0)
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labXhdpiIcon)
                    .addComponent(tfXhdpiIcon, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labLdpiSplashLandscape)
                    .addComponent(tfLdpiSplashLandscape, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labLdpiSplashPortrait)
                    .addComponent(tfLdpiSplashPortrait, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labMdpiSplashLandscape)
                    .addComponent(tfMdpiSplashLandscape, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labMdpiSplashPortrait)
                    .addComponent(tfMdpiSplashPortrait, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labHdpiSplashLandscape)
                    .addComponent(tfHdpiSplashLandscape, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labHdpiSplashPortrait)
                    .addComponent(tfHdpiSplashPortrait, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labXhdpiSplashLandscape)
                    .addComponent(tfXhdpiSplashLandscape, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(androidPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labXhdpiSplashPortrait)
                    .addComponent(tfXHdpiSplashPortrait, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, Short.MAX_VALUE))
        );

        platformsPane.addTab(org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.androidPanel.TabConstraints.tabTitle"), androidPanel); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(iosTarget, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.iosTarget.text")); // NOI18N

        iosTargetCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "iOS 5.1", "iOS 5.0" }));

        org.openide.awt.Mnemonics.setLocalizedText(labRetinaIcon, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labRetinaIcon.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labiPhoneSplashLandscape, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labiPhoneSplashLandscape.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labiPhoneSplashPortrait, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labiPhoneSplashPortrait.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labiPhoneSplashRetLandscape, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labiPhoneSplashRetLandscape.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labPhoneSplashRetPortrait, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labPhoneSplashRetPortrait.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labiPadSplashLandscape, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labiPadSplashLandscape.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labiPadSplashPortrait, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labiPadSplashPortrait.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labiPadSplashRetLandscape, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labiPadSplashRetLandscape.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(labiPadSplashRetPortrait, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.labiPadSplashRetPortrait.text")); // NOI18N

        javax.swing.GroupLayout iOSPanelLayout = new javax.swing.GroupLayout(iOSPanel);
        iOSPanel.setLayout(iOSPanelLayout);
        iOSPanelLayout.setHorizontalGroup(
            iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(iOSPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(iOSPanelLayout.createSequentialGroup()
                        .addComponent(iosTarget)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(iosTargetCombo, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(iOSPanelLayout.createSequentialGroup()
                        .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(labiPadSplashRetLandscape)
                            .addComponent(labiPadSplashRetPortrait)
                            .addComponent(labiPadSplashPortrait)
                            .addComponent(labiPadSplashLandscape)
                            .addComponent(labPhoneSplashRetPortrait)
                            .addComponent(labiPhoneSplashRetLandscape)
                            .addComponent(labiPhoneSplashPortrait)
                            .addComponent(labiPhoneSplashLandscape)
                            .addComponent(labRetinaIcon))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(tfRetinaIcon, javax.swing.GroupLayout.DEFAULT_SIZE, 190, Short.MAX_VALUE)
                            .addComponent(tfiPhoneSplashLandscape)
                            .addComponent(tfiPhoneSplashPortrait)
                            .addComponent(tfiPhoneSplashRetLandscape)
                            .addComponent(tfiPhoneSplashRetPortrait)
                            .addComponent(tfiPadSplashLandscape)
                            .addComponent(tfiPadSplashPortrait)
                            .addComponent(tfiPadSplashRetPortrait)
                            .addComponent(tfiPadSplashRetLandscape)))))
        );
        iOSPanelLayout.setVerticalGroup(
            iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(iOSPanelLayout.createSequentialGroup()
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(iosTarget)
                    .addComponent(iosTargetCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, 0)
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labRetinaIcon)
                    .addComponent(tfRetinaIcon, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labiPhoneSplashLandscape)
                    .addComponent(tfiPhoneSplashLandscape, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labiPhoneSplashPortrait)
                    .addComponent(tfiPhoneSplashPortrait, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labiPhoneSplashRetLandscape)
                    .addComponent(tfiPhoneSplashRetLandscape, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labPhoneSplashRetPortrait)
                    .addComponent(tfiPhoneSplashRetPortrait, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labiPadSplashLandscape)
                    .addComponent(tfiPadSplashLandscape, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labiPadSplashPortrait)
                    .addComponent(tfiPadSplashPortrait, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labiPadSplashRetLandscape)
                    .addComponent(tfiPadSplashRetLandscape, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(iOSPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labiPadSplashRetPortrait)
                    .addComponent(tfiPadSplashRetPortrait, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, Short.MAX_VALUE))
        );

        platformsPane.addTab(org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.iOSPanel.TabConstraints.tabTitle"), iOSPanel); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(packageLabel, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.packageLabel.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(nameLabel, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.nameLabel.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(versionLabel, org.openide.util.NbBundle.getMessage(CordovaPanel.class, "CordovaPanel.versionLabel.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(packageLabel)
                    .addComponent(nameLabel)
                    .addComponent(versionLabel))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(packageTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 309, Short.MAX_VALUE)
                    .addComponent(nameTextField)
                    .addComponent(versionTextField)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(packageLabel)
                    .addComponent(packageTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(nameLabel)
                    .addComponent(nameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(versionTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(versionLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void phoneGapCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_phoneGapCheckBoxStateChanged
        setControlsEnabled(phoneGapCheckBox.isSelected());
        firePropertyChange(PROP_EXT_ENABLED, !phoneGapCheckBox.isSelected(), phoneGapCheckBox.isSelected());
        
    }//GEN-LAST:event_phoneGapCheckBoxStateChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel androidPanel;
    private javax.swing.JLabel androidTarget;
    private javax.swing.JComboBox androidTargetCombo;
    private javax.swing.JPanel iOSPanel;
    private javax.swing.JLabel iosTarget;
    private javax.swing.JComboBox iosTargetCombo;
    private javax.swing.JLabel labHdpiSplashLandscape;
    private javax.swing.JLabel labHdpiSplashPortrait;
    private javax.swing.JLabel labLdpiSplashLandscape;
    private javax.swing.JLabel labLdpiSplashPortrait;
    private javax.swing.JLabel labMdpiSplashLandscape;
    private javax.swing.JLabel labMdpiSplashPortrait;
    private javax.swing.JLabel labPhoneSplashRetPortrait;
    private javax.swing.JLabel labRetinaIcon;
    private javax.swing.JLabel labXhdpiIcon;
    private javax.swing.JLabel labXhdpiSplashLandscape;
    private javax.swing.JLabel labXhdpiSplashPortrait;
    private javax.swing.JLabel labiPadSplashLandscape;
    private javax.swing.JLabel labiPadSplashPortrait;
    private javax.swing.JLabel labiPadSplashRetLandscape;
    private javax.swing.JLabel labiPadSplashRetPortrait;
    private javax.swing.JLabel labiPhoneSplashLandscape;
    private javax.swing.JLabel labiPhoneSplashPortrait;
    private javax.swing.JLabel labiPhoneSplashRetLandscape;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JLabel packageLabel;
    private javax.swing.JTextField packageTextField;
    private javax.swing.JCheckBox phoneGapCheckBox;
    private javax.swing.JTabbedPane platformsPane;
    private javax.swing.JTextField tfHdpiSplashLandscape;
    private javax.swing.JTextField tfHdpiSplashPortrait;
    private javax.swing.JTextField tfLdpiSplashLandscape;
    private javax.swing.JTextField tfLdpiSplashPortrait;
    private javax.swing.JTextField tfMdpiSplashLandscape;
    private javax.swing.JTextField tfMdpiSplashPortrait;
    private javax.swing.JTextField tfRetinaIcon;
    private javax.swing.JTextField tfXHdpiSplashPortrait;
    private javax.swing.JTextField tfXhdpiIcon;
    private javax.swing.JTextField tfXhdpiSplashLandscape;
    private javax.swing.JTextField tfiPadSplashLandscape;
    private javax.swing.JTextField tfiPadSplashPortrait;
    private javax.swing.JTextField tfiPadSplashRetLandscape;
    private javax.swing.JTextField tfiPadSplashRetPortrait;
    private javax.swing.JTextField tfiPhoneSplashLandscape;
    private javax.swing.JTextField tfiPhoneSplashPortrait;
    private javax.swing.JTextField tfiPhoneSplashRetLandscape;
    private javax.swing.JTextField tfiPhoneSplashRetPortrait;
    private javax.swing.JLabel versionLabel;
    private javax.swing.JTextField versionTextField;
    // End of variables declaration//GEN-END:variables

    public void setPanelEnabled(boolean b) {
        phoneGapCheckBox.setSelected(b);
    }
    
    public boolean isPanelEnabled() {
        return phoneGapCheckBox.isSelected();
    }
    
    public String getPackageName() {
        return packageTextField.getText();
    }

    void setPackageName(String pkg) {
        packageTextField.setText(pkg);
    }
    
    public void save(SourceConfig config) throws IOException {
        if (config == null) {
            //nothing to save
            //config not created
            return;
        }
        final String pkg = packageTextField.getText();
        if (!pkg.trim().isEmpty()) {
            config.setId(pkg);
        }
        final String name = nameTextField.getText();
        if (!name.trim().isEmpty()) {
            config.setName(name);
        }
        
        final String version = versionTextField.getText();
        if (!version.trim().isEmpty()) {
            config.setVersion(version);
        }
        
//        config.setIcon(SourceConfig.ANDROID_PLATFORM, tfXhdpiIcon.getText());
//        config.setIcon(SourceConfig.IOS_PLATFORM, tfRetinaIcon.getText());
//        
//        config.setSplash(SourceConfig.ANDROID_PLATFORM, 800, 480, tfHdpiSplashLandscape.getText());
//        config.setSplash(SourceConfig.ANDROID_PLATFORM, 480, 800, tfHdpiSplashPortrait.getText());
//        
//        config.setSplash(SourceConfig.ANDROID_PLATFORM, 1280, 720, tfXhdpiSplashLandscape.getText());
//        config.setSplash(SourceConfig.ANDROID_PLATFORM, 720, 1280, tfXHdpiSplashPortrait.getText());
//
//        config.setSplash(SourceConfig.ANDROID_PLATFORM, 480, 320, tfMdpiSplashLandscape.getText());
//        config.setSplash(SourceConfig.ANDROID_PLATFORM, 320, 480, tfMdpiSplashPortrait.getText());
//
//        config.setSplash(SourceConfig.ANDROID_PLATFORM, 320, 200, tfLdpiSplashLandscape.getText());
//        config.setSplash(SourceConfig.ANDROID_PLATFORM, 200, 320, tfLdpiSplashPortrait.getText());
//        
//        config.setSplash(SourceConfig.IOS_PLATFORM, 480, 320, tfiPhoneSplashLandscape.getText());
//        config.setSplash(SourceConfig.IOS_PLATFORM, 320, 480, tfiPhoneSplashPortrait.getText());
//
//        config.setSplash(SourceConfig.IOS_PLATFORM, 960, 640, tfiPhoneSplashRetLandscape.getText());
//        config.setSplash(SourceConfig.IOS_PLATFORM, 640, 960, tfiPhoneSplashRetPortrait.getText());
//
//        config.setSplash(SourceConfig.IOS_PLATFORM, 1024, 768, tfiPadSplashLandscape.getText());
//        config.setSplash(SourceConfig.IOS_PLATFORM, 768, 1024, tfiPadSplashPortrait.getText());
//
//        config.setSplash(SourceConfig.IOS_PLATFORM, 2048, 1536, tfiPadSplashRetLandscape.getText());
//        config.setSplash(SourceConfig.IOS_PLATFORM, 1536, 2048, tfiPadSplashRetPortrait.getText());
        
        config.save();
    }
    
    public void load(SourceConfig config) {
        packageTextField.setText(config.getId());
        nameTextField.setText(config.getName());
        versionTextField.setText(config.getVersion());
        
//        tfXhdpiIcon.setText(config.getIcon(SourceConfig.ANDROID_PLATFORM));
//        tfRetinaIcon.setText(config.getIcon(SourceConfig.IOS_PLATFORM));
//        
//        tfHdpiSplashLandscape.setText(config.getSplash(SourceConfig.ANDROID_PLATFORM, 800, 480));
//        tfHdpiSplashPortrait.setText(config.getSplash(SourceConfig.ANDROID_PLATFORM, 480, 800));
//        
//        tfXhdpiSplashLandscape.setText(config.getSplash(SourceConfig.ANDROID_PLATFORM, 1280, 720));
//        tfXHdpiSplashPortrait.setText(config.getSplash(SourceConfig.ANDROID_PLATFORM, 720, 1280));
//
//        tfMdpiSplashLandscape.setText(config.getSplash(SourceConfig.ANDROID_PLATFORM, 480, 320));
//        tfMdpiSplashPortrait.setText(config.getSplash(SourceConfig.ANDROID_PLATFORM, 320, 480));
//
//        tfLdpiSplashLandscape.setText(config.getSplash(SourceConfig.ANDROID_PLATFORM, 320, 200));
//        tfLdpiSplashPortrait.setText(config.getSplash(SourceConfig.ANDROID_PLATFORM, 200, 320));
//        
//        tfiPhoneSplashLandscape.setText(config.getSplash(SourceConfig.IOS_PLATFORM, 480, 320));
//        tfiPhoneSplashPortrait.setText(config.getSplash(SourceConfig.IOS_PLATFORM, 320, 480));
//
//        tfiPhoneSplashRetLandscape.setText(config.getSplash(SourceConfig.IOS_PLATFORM, 960, 640));
//        tfiPhoneSplashRetPortrait.setText(config.getSplash(SourceConfig.IOS_PLATFORM, 640, 960));
//
//        tfiPadSplashLandscape.setText(config.getSplash(SourceConfig.IOS_PLATFORM, 1024, 768));
//        tfiPadSplashPortrait.setText(config.getSplash(SourceConfig.IOS_PLATFORM, 768, 1024));
//
//        tfiPadSplashRetLandscape.setText(config.getSplash(SourceConfig.IOS_PLATFORM, 2048, 1536));
//        tfiPadSplashRetPortrait.setText(config.getSplash(SourceConfig.IOS_PLATFORM, 1536, 2048));
    }

    public void setProjectName(String name) {
        packageTextField.setText(CordovaPerformer.DEFAULT_ID_PREFIX + "." + name.replaceAll(" ", "")); // NOI18N
        nameTextField.setText(name);
    }

    public void setVersion(String string) {
        versionTextField.setText(string);
    }
}
