/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.debugger.common2.debugger.assembly;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.accessibility.AccessibleContext;
import javax.swing.table.DefaultTableModel;

import org.openide.util.HelpCtx;

import org.netbeans.spi.viewmodel.Models;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;


public final class RegistersWindow extends TopComponent
    implements ActionListener
{

    private static final String preferredID = "RegistersWindow";	// NOI18N
    private static RegistersWindow DEFAULT;

    private transient JComponent tree = null;
    private String name;
    private String view_name;
    private NativeDebugger debugger = null;
    private DefaultTableModel dataModel;
    private JMenuItem menuItemHide;
    private JPopupMenu popup;
    private JPanel hp;
    private JTable tab;
    private JTextArea ta;
    private JScrollPane ta_sp;
    private JScrollPane tab_sp;
    private List<String> previous_regs;
    private List<String> current_regs;
    private List<String> hidden_regs;
    private PopupListener popupListener;
    private boolean needInitData=true;
    private boolean seen_sparc_regs=false;
    private String selected_text = null;
    private int selected_area_start = 0;
    private int selected_area_end = 0;
    private int view_model = 1; // 0 - JTextArea, 1 - JTable

    public static synchronized RegistersWindow getDefault() {
        if (DEFAULT == null) {
            DEFAULT = (RegistersWindow) WindowManager.getDefault().findTopComponent(preferredID);

            if (DEFAULT == null) {
                DEFAULT = new RegistersWindow();
            }
        }
        return DEFAULT;
    }
    
    public RegistersWindow() {
	name = Catalog.get("TITLE_RegistersWindow");    // NOI18N
	view_name = Catalog.get("TITLE_RegistersView"); // NOI18N
	super.setName(name);
	final String iconDir = "org/netbeans/modules/cnd/debugger/common2/icons/";//NOI18N
	setIcon(org.openide.util.ImageUtilities.loadImage
	    (iconDir + "registers.png")); // NOI18N
    }

    @Override
    protected String preferredID() {
        return this.getClass().getName();
    }

    @Override
    protected void componentHidden () {
	if (debugger != null) {
	    debugger.registerRegistersWindow(null);
	}
        super.componentHidden();
    }

    @Override
    protected void componentShowing () {
        super.componentShowing ();
	connectToDebugger(DebuggerManager.get().currentDebugger());
        needInitData=true;
        updateWindow();
    }

    @Override
    protected void componentClosed () {
	if (debugger != null) {
	    debugger.registerRegistersWindow(null);
	}
        super.componentClosed();
    }

    private void connectToDebugger (NativeDebugger debugger) {
	this.debugger = debugger;
	if (debugger == null) return;
	debugger.registerRegistersWindow(this);
    }

    @Override
    public void requestActive() {
        super.requestActive();
        tab.requestFocusInWindow();
    }
    
    private void updateWindow() {
        //int hsbv, vsbv;
        int i, j, k, l, m, n, carpos;
        String s;
        
        if (tree == null) {
	    // Temporary (the real name will come from the engine)
            String symbol = "\"main()\"";		// NOI18N
            ta = new JTextArea();
            ta_sp = new JScrollPane(ta);
            // Create table
            Object[] columnNames = {
		Catalog.get("LBL_NameCol"),		// NOI18N
		Catalog.get("LBL_ValueCol")		// NOI18N
	    };

            dataModel = new DefaultTableModel(columnNames, 0);
            tab = new JTable(dataModel);
	    // You need to set preferredWidth on all columns for it to take
	    tab.getColumnModel().getColumn(0).setPreferredWidth(40);
	    tab.getColumnModel().getColumn(1).setPreferredWidth(300);
            tab.setGridColor(Color.LIGHT_GRAY);
            tab_sp = new JScrollPane(tab);
            
            previous_regs = new ArrayList<String>();
            current_regs = new ArrayList<String>();
            hidden_regs = new ArrayList<String>();
            setLayout (new BorderLayout ());
            tree = Models.createView (Models.EMPTY_MODEL);
            // Models.setModelsToView (tree, Models.createCompoundModel(regs1));
            tree.setName (view_name);
            
            ta.setEditable(false);
            ta.setWrapStyleWord(false);
            Font f = ta.getFont();
            ta.setFont(new Font("Monospaced", f.getStyle(), f.getSize())); //NOI18N
            f = tab.getFont();
            tab.setFont(new Font("Monospaced", f.getStyle(), f.getSize())); //NOI18N
            
            BorderLayout bl = new BorderLayout();
            bl.setHgap(118);
            hp = new JPanel(bl);
            JLabel hp_name = new JLabel(Catalog.get("RegisterName")); // NOI18N
            JLabel hp_value = new JLabel(Catalog.get("RegisterValue"));     // NOI18N
            hp_name.setToolTipText(Catalog.get("LBL_RegisterName"));   // NOI18N
            hp_value.setToolTipText(Catalog.get("LBL_RegisterValue")); // NOI18N
            hp.add(hp_name, BorderLayout.WEST);
            hp.add(hp_value, BorderLayout.CENTER);
            hp.setToolTipText(Catalog.get("LBL_RegisterName"));		// NOI18N
            
            if (view_model == 0) {
		tree.add(hp, BorderLayout.NORTH);
		tree.add(ta_sp, BorderLayout.CENTER);
            } else {
		tree.add(tab_sp, BorderLayout.CENTER);
            }
            // OLD tree.add(cp, BorderLayout.SOUTH);
            AccessibleContext ac = tree.getAccessibleContext();
            ac.setAccessibleDescription(Catalog.get("ACSD_RegisterView")); // NOI18N
            ac.setAccessibleName(Catalog.get("TITLE_RegistersView")); // NOI18N
            add (tree, "Center");  //NOI18N
            
            //Create the popup menu.
            popup = new JPopupMenu();
            popup.add(new ShowAllRegistersAction());
            menuItemHide = new JMenuItem(new HideSelectedRegistersAction());
            popup.add(menuItemHide);
            //popup.addSeparator();
            //popup.add(new ShowDynamicHelpPageAction());
            // popup.addSeparator();
            // popup.add(new ChangeViewAction());
            //Add listener
            popupListener = new PopupListener(popup);
          //if (view_model == 0) {
            ta.addMouseListener(popupListener);
          //} else {
            tab.addMouseListener(popupListener);
          //}
            ta.setText(null);
            ta.setCaretPosition(0);

            //Hide section registers
            hidden_regs.add("cs\t");	// NOI18N
            hidden_regs.add("ds\t");	// NOI18N
            hidden_regs.add("es\t");	// NOI18N
            hidden_regs.add("fs\t");	// NOI18N
            hidden_regs.add("gs\t");	// NOI18N
            hidden_regs.add("ss\t");	// NOI18N
        }
        if (needInitData) {
            // Init page
            needInitData=false;
            // initRegs();
        }
        //hsbv = ta_sp.getHorizontalScrollBar().getValue();
        //vsbv = ta_sp.getVerticalScrollBar().getValue();
        carpos = ta.getCaretPosition();
        ta.setText(null);
        // Clean Table
        dataModel.setRowCount(0);
       	k = current_regs.size();
       	for (i = 0; i < k; i++) {
       	    s = current_regs.get(i);
       	    l = hidden_regs.size();
       	    for (j=0; j < l; j++) {
       	        if (s.startsWith("   " + hidden_regs.get(j))) break; // NOI18N
       	    }
       	    if (j == l) {
       	        if (i < previous_regs.size()) {
       	            try {
       	                String prev_s=previous_regs.get(i);
       	                if (prev_s.equals(s)) {
//System.out.println("RegistersWindow.updateWindow() previous_regs.getItem("+i+") == current_regs.getItem("+i+") == "+s);
       	                } else {
//System.out.println("RegistersWindow.updateWindow() previous_regs.getItem("+i+") != current_regs.getItem("+i+") : "+prev_s+"!="+s);
       	                }
       	            } catch (java.lang.Exception e) {
       	                System.err.println("RegistersWindow.updateWindow(): exception: "+e);
       	            }
       	        }
                ta.append(s);
                // Update Table
                Object [] row = { "", "" }; // NOI18N
       	        n=0;
       	        for (m=0; m < s.length(); m++) {
       	            if (s.charAt(m) == ' ') continue;
       	            if (s.charAt(m) == '\t') continue;
       	            for (n=m+1; n < s.length(); n++) {
       	                if (s.charAt(n) == ' ') break;
       	                if (s.charAt(n) == '\t') break;
       	            }
       	            break;
       	        }
       	        if ((m < s.length()) && (m < n)) { 
                    row[0]=s.substring(m, n);
       	            //m=n;
       	            for (++n; n < s.length(); n++) {
       	                if (s.charAt(n) == ' ') continue;
       	                if (s.charAt(n) == '\t') continue;
       	                break;
       	            }
		    if (n > s.length())   n = s.length();
                    row[1]=s.substring(n, s.length());
                }
       	        dataModel.addRow(row);
       	    }
       	    if (i < previous_regs.size()) {
       	        previous_regs.set(i, s);
       	    } else {
       	        previous_regs.add(s);
       	    }
        }
        try {
            ta.setCaretPosition(carpos);
        } catch (java.lang.IllegalArgumentException e) {
            // bad position carpos
            ta.setCaretPosition(0);
        }
        //ta_sp.getHorizontalScrollBar().setValue(hsbv);
        //ta_sp.getVerticalScrollBar().setValue(vsbv);
        invalidate();
        // Update view
        dataModel.fireTableDataChanged();
    }

    class ShowAllRegistersAction extends AbstractAction {
        public ShowAllRegistersAction() {
            super(Catalog.get("Reg_ACT_Show_All_Registers"), 	// NOI18N
                null);
        }
        public void actionPerformed(ActionEvent ev) {
            ShowAllRegisters();
        }
    }

    class HideSelectedRegistersAction extends AbstractAction {
        public HideSelectedRegistersAction() {
            super(Catalog.get("Reg_ACT_Hide"), 			// NOI18N
                null);
        }

        public void actionPerformed(ActionEvent ev) {
            if (view_model == 0) {
                selected_text = ta.getSelectedText();
            } else {
                if (tab.getSelectedRowCount() <= 0)  return;
                int[] rows = tab.getSelectedRows();
                selected_text = "";
                for (int i=0; i < rows.length; i++) {
                    selected_text += tab.getValueAt(rows[i], 0) +
				     "\t " + // NOI18N
				     tab.getValueAt(rows[i], 1) +
				     " \n"; // NOI18N
                }
            }
            HideSelectedRegisters(selected_text);
        }
    }

    /* LATER
    class ShowDynamicHelpPageAction extends AbstractAction {
        public ShowDynamicHelpPageAction() {
            super(Catalog.get("Reg_ACT_More_Info"),
                new ImageIcon("help.gif"));
        }
        public void actionPerformed(ActionEvent ev) {
//System.out.println("ShowDynamicHelpPageAction.ActionPerformed(More Info)");
            ShowDynamicHelpPage();
        }
    }

    class ChangeViewAction extends AbstractAction {
        public ChangeViewAction() {
            super("Change View", 
                new ImageIcon("help.gif"));
        }
        public void actionPerformed(ActionEvent ev) {
//System.out.println("ChangeViewAction.ActionPerformed(Change View)");
            ChangeView();
        }
    }
    */
    
    class PopupListener extends MouseAdapter
                           implements ActionListener, 
                                      PopupMenuListener
    {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            maybeShowPopup(e);
        }
        
        private void selectCurrentLine(int x, int y) {
            // This is just temporary placeholder code
            int ln = ta.getLineCount(); 
            if (ln > 0) {
                try {
                    selected_area_start = ta.getLineStartOffset(ln);
                    selected_area_end = ta.getLineEndOffset(ln);
                    ta.select(selected_area_start, selected_area_end);
                } catch (javax.swing.text.BadLocationException e) {
                    //selected_area_start = 0;
                    //selected_area_end = 0;
                }
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                boolean selected = false;
                if (view_model == 0) {
                    selected_text = ta.getSelectedText();
                    if (selected_text != null) selected = true;
                } else {
                    if (tab.getSelectedRowCount() > 0)  selected = true;
                }
                if (selected) {
                    menuItemHide.setEnabled(true);
                } else {
                    menuItemHide.setEnabled(false);
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
        public void actionPerformed(ActionEvent ev) {
        }
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    @Override
    public int getPersistenceType () {
        return PERSISTENCE_ALWAYS;
    }
        
    @Override
    public String getName () {
        return name;
    }
    
    @Override
    public String getToolTipText () {
        return view_name;
    }
    
    public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
	// super.actionPerformed(actionEvent);
    }

    public void updateData(List<String> regs) {
        current_regs.clear();
        current_regs.addAll(regs);
        
        updateWindow();
    }
    
    protected void HideSelectedRegisters(String regs) {
        int i, j, k, l;
        String s, regname;

        if (regs == null) return;
        l = regs.length();
       	for (i = 0; i < l; i++) {
       	    k = regs.indexOf('\n', i);
       	    if (k < 0) k = l - 1;
       	    if (k <= i) break;
       	    s = regs.substring(i, k + 1);
            i = k;
            regname = null;
       	    for (j=0, k=0; j < s.length(); j++) {
       	        if (s.charAt(j) != ' ') {
       	            if (k == 0) {
       	                k = s.indexOf(' ', j);
       	                if (k < 0) {
       	                    k = s.length();
       	                }
       	                if (k < j) break;
       	                regname = s.substring(j, k);
       	                j = k;
                    } else {
       	                k = s.indexOf('\n', j);
       	                if (k < j) break;
       	                break;
                    }
       	        }
            }
       	    if (regname != null) {
       	        k = hidden_regs.size();
       	        for (j=0; j < k; j++) {
       	            s = hidden_regs.get(j);
       	            if (s.compareTo(regname) == 0) break;
       	        }
       	        if (j == k) {
                    hidden_regs.add(regname);
       	        }
            }
        }
        updateWindow();
    }

    protected void ShowAllRegisters() {
        hidden_regs.clear();
        updateWindow();
    }

    protected void ChangeView() {
        view_model++;
        if (view_model > 1) view_model = 0;
        if (view_model == 0) {
            tree.remove(tab_sp);
            tree.add(hp, BorderLayout.NORTH);
            tree.add(ta_sp, BorderLayout.CENTER);
        } else {
            tree.remove(hp);
            tree.remove(ta_sp);
            tree.add(tab_sp, BorderLayout.CENTER);
        }
        updateWindow();
    }
    
    @Override
    public HelpCtx getHelpCtx() {
	return new HelpCtx("RegistersWindow");
    }

}
