#!/usr/bin/ksh
#---------------------------------------------------------
#  NCL Doc Examples: NCL_cdo_remap_bilinear_CMIP5_grid_to_1x1deg_grid.ksh
#  Regrid CMIP5 grid to world grid 1x1 degrees - bilinear
#
#  weights_bilinear.nc:  weights file generated by 'cdo genbil'
#
#  KMF 30.10.14
#---------------------------------------------------------
t1=$(date +%s)

dir="./"
fin="$dir/thetao_ocean_rectilinear_grid_2D.nc"
fout="remap_bilinear_CMIP5_thetao.nc"
wgts="weights_bilinear.nc"

#-- generate bilinear interpolation weights
cdo genbil,r360x180 ${fin} ${wgts}

#-- remap to 1x1 degree grid using the weights file
cdo remap,r360x180,${wgts} ${fin} ${fout}

#-- following call will give the same result and elapsed time
#-- as 'cdo genbil' and 'cdo remap', but won't save the weights file
#cdo remapbil,r360x180 ${fin} ${fout}

t2=$(date +%s)
td=$(expr $t2 - $t1)
echo "Elapsed time:  ${td}s"

exit
