/* 
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _EDITOR_USER_ROLE_H_
#define _EDITOR_USER_ROLE_H_

#include "grtdb/editor_dbobject.h"
#include "role_tree_model.h"

#include "grts/structs.db.h"

#include "wbpublic_public_interface.h"

#define UserRoleEditorBE_VERSION 1


namespace bec {

  class RoleEditorBE;

  class WBPUBLICBACKEND_PUBLIC_FUNC RolePrivilegeListBE : public ListModel
  {
  public:
    enum Columns {
      Name,
      Enabled
    };

    RolePrivilegeListBE(RoleEditorBE *owner);

    virtual void refresh();

    virtual int count();

    void remove_all();

    virtual bool set_field(const NodeId &node, int column, int value);

  protected:
    RoleEditorBE *_owner;
    db_RolePrivilegeRef _role_privilege;
    grt::StringListRef _privileges;

    virtual bool get_field_grt(const NodeId &node, int column, grt::ValueRef &value);
  };

  //!
  //! Wraps in ListModel way operations with db_Role::privileges()
  //! Role is obtained from RoleEditorBE owner. 
  //!
  class WBPUBLICBACKEND_PUBLIC_FUNC RoleObjectListBE : public ListModel
  {
  public:
    enum Columns {
      Name
    };

    RoleObjectListBE(RoleEditorBE *owner);

    void set_selected_node(const NodeId &node);
    db_RolePrivilegeRef get_selected_object_info();

    virtual int count();
    virtual void refresh() {};

    virtual MenuItemList get_popup_items_for_nodes(const std::vector<NodeId> &nodes);
    virtual bool activate_popup_item_for_nodes(const std::string &name, const std::vector<NodeId> &nodes);

  protected:
    RoleEditorBE *_owner;
    NodeId _selection;

    virtual IconId get_field_icon(const NodeId &node, int column, IconSize size);
    virtual bool get_field_grt(const NodeId &node, int column, grt::ValueRef &value);
  };
  
  //!
  //! Represents Roles, their objects and assigned privileges.
  //! The set of classes: RoleEditorBE, RoleObjectListBE and RolePrivilegeListBE
  //! works using RoleEditorBE::_role field.
  class WBPUBLICBACKEND_PUBLIC_FUNC RoleEditorBE : public BaseEditor 
  {
  protected:
    db_RoleRef _role;                      //!< Selected role
    db_mgmt_RdbmsRef _rdbms;
    RoleTreeBE _tree;                      //!< List of roles in a schema
    RolePrivilegeListBE _privilege_list;   //!< Serves as a source of role's objects privileges for the UIs
    RoleObjectListBE _object_list;         //!< Serves as a source of role's objects for the UI.

  public:
    RoleEditorBE(GRTManager *grtm, const db_RoleRef &role, const db_mgmt_RdbmsRef &rdbms);

    db_RoleRef get_role() { return _role; }
    virtual GrtObjectRef get_object() { return get_role(); }

    const db_mgmt_RdbmsRef& get_rdbms() { return _rdbms; }

    virtual std::string get_title();
    
    void set_name(const std::string &name);
    std::string get_name();

    void set_parent_role(const std::string &name);
    std::string get_parent_role();
    std::vector<std::string> get_role_list();

    RoleTreeBE* get_role_tree() { return &_tree; }

    RolePrivilegeListBE *get_privilege_list() { return &_privilege_list; }
    RoleObjectListBE *get_object_list() { return &_object_list; }

    bool add_dropped_objectdata(const std::string &data);
    bool add_object(const std::string &type, const std::string &name);
    bool add_object(db_DatabaseObjectRef object);
    void remove_object(const bec::NodeId& object_node_id);
  };
};


#endif /* _EDITOR_USER_ROLE_H_ */
