/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.ResultTreeFragment;
import com.jclark.xsl.tr.Result;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public abstract class ResultBase
implements Result,
AttributeList {
    private DocumentHandler documentHandler;
    private CommentHandler commentHandler;
    private static final int INITIAL_BUF_SIZE = 8192;
    private char[] buf = new char[8192];
    private int bufUsed = 0;
    private Name[] attributeNames = new Name[10];
    private String[] attributeValues = new String[10];
    private int nAttributes;
    private Name pendingElementType;
    private NamespacePrefixMap pendingNamespacePrefixMap;

    private static final String fixProcessingInstruction(String string) {
        int n = string.indexOf(63);
        while (n++ >= 0) {
            int n2 = string.length();
            if (n == n2) break;
            if (string.charAt(n) == '>') {
                string = string.substring(0, n) + " " + string.substring(n);
            }
            n = string.indexOf(63, n);
        }
        return string;
    }

    protected void throwXSLException(SAXException sAXException) throws XSLException {
        Exception exception = sAXException.getException();
        if (exception != null) {
            throw new XSLException(exception);
        }
        throw new XSLException(sAXException.getMessage());
    }

    public void startElement(Name name, NamespacePrefixMap namespacePrefixMap) throws XSLException {
        this.flush();
        this.pendingElementType = name;
        this.pendingNamespacePrefixMap = namespacePrefixMap;
        this.nAttributes = 0;
    }

    public void end() throws XSLException {
        try {
            this.flush();
            this.documentHandler.endDocument();
            return;
        }
        catch (SAXException sAXException) {
            this.throwXSLException(sAXException);
            return;
        }
    }

    public String getValue(int n) {
        return this.attributeValues[n];
    }

    public String getValue(String string) {
        int n = this.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(this.getName(n2))) {
                return this.getValue(n2);
            }
            ++n2;
        }
        return null;
    }

    protected abstract void startElementContent(Name var1, NamespacePrefixMap var2) throws XSLException;

    public void endElement(Name name) throws XSLException {
        this.flush();
        this.endElementContent(name);
    }

    protected ResultBase(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
        this.setCommentHandler();
    }

    protected abstract void endElementContent(Name var1) throws XSLException;

    public abstract void resultTreeFragment(ResultTreeFragment var1) throws XSLException;

    protected final DocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public void comment(String string) throws XSLException {
        if (this.commentHandler != null) {
            try {
                this.flush();
                this.commentHandler.comment(ResultBase.fixComment(string));
                return;
            }
            catch (SAXException sAXException) {
                this.throwXSLException(sAXException);
            }
        }
    }

    public void start() throws XSLException {
        try {
            this.documentHandler.startDocument();
            return;
        }
        catch (SAXException sAXException) {
            this.throwXSLException(sAXException);
            return;
        }
    }

    private void setCommentHandler() {
        if (this.documentHandler instanceof CommentHandler) {
            this.commentHandler = (CommentHandler)((Object)this.documentHandler);
            return;
        }
        this.commentHandler = null;
    }

    public abstract String getName(int var1);

    public String getType(int n) {
        return "CDATA";
    }

    public String getType(String string) {
        return "CDATA";
    }

    protected final Name getAttributeName(int n) {
        return this.attributeNames[n];
    }

    protected void flush() throws XSLException {
        if (this.pendingElementType != null) {
            this.startElementContent(this.pendingElementType, this.pendingNamespacePrefixMap);
            this.pendingElementType = null;
            return;
        }
        if (this.bufUsed > 0) {
            try {
                this.documentHandler.characters(this.buf, 0, this.bufUsed);
                this.bufUsed = 0;
                return;
            }
            catch (SAXException sAXException) {
                this.throwXSLException(sAXException);
            }
        }
    }

    public void characters(String string) throws XSLException {
        int n;
        if (this.pendingElementType != null) {
            this.flush();
        }
        if (this.bufUsed + (n = string.length()) > this.buf.length) {
            char[] cArray = this.buf;
            int n2 = cArray.length * 2;
            while (n2 < this.bufUsed + n) {
                n2 *= 2;
            }
            this.buf = new char[n2];
            if (this.bufUsed > 0) {
                System.arraycopy(cArray, 0, this.buf, 0, this.bufUsed);
            }
        }
        string.getChars(0, n, this.buf, this.bufUsed);
        this.bufUsed += n;
    }

    public void attribute(Name name, String string) throws XSLException {
        if (this.pendingElementType == null) {
            return;
        }
        int n = 0;
        while (n < this.nAttributes) {
            if (this.attributeNames[n].equals(name)) {
                this.attributeValues[n] = string;
                return;
            }
            ++n;
        }
        if (this.nAttributes == this.attributeNames.length) {
            this.attributeNames = ResultBase.grow(this.attributeNames);
            this.attributeValues = ResultBase.grow(this.attributeValues);
        }
        this.attributeNames[this.nAttributes] = name;
        this.attributeValues[this.nAttributes] = string;
        ++this.nAttributes;
    }

    private static final String fixComment(String string) {
        int n = string.indexOf(45);
        while (n++ >= 0) {
            int n2 = string.length();
            if (n == n2) {
                return string + " ";
            }
            if (string.charAt(n) == '-') {
                string = string.substring(0, n) + " " + string.substring(n);
            }
            n = string.indexOf(45, n);
        }
        return string;
    }

    static String[] grow(String[] stringArray) {
        String[] stringArray2 = stringArray;
        stringArray = new String[stringArray2.length * 2];
        System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        return stringArray;
    }

    static Name[] grow(Name[] nameArray) {
        Name[] nameArray2 = nameArray;
        nameArray = new Name[nameArray2.length * 2];
        System.arraycopy(nameArray2, 0, nameArray, 0, nameArray2.length);
        return nameArray;
    }

    public int getLength() {
        return this.nAttributes;
    }

    public void processingInstruction(String string, String string2) throws XSLException {
        try {
            this.flush();
            this.documentHandler.processingInstruction(string, ResultBase.fixProcessingInstruction(string2));
            return;
        }
        catch (SAXException sAXException) {
            this.throwXSLException(sAXException);
            return;
        }
    }
}

