using NUnit.Framework;
using System.IO;
using System.Text;
using System.Xml;
using MonoDevelop.Xml.Editor;

namespace MonoDevelop.Xml.Tests.Schema
{
	[TestFixture]
	public class SchemaAssociationTests
	{
		StringBuilder xml;
		XmlWriter writer;
		
		[SetUp]
		public void Init ()
		{
			xml = new StringBuilder ();
			XmlWriterSettings settings = new XmlWriterSettings ();
			settings.Indent = true;
			settings.OmitXmlDeclaration = true;
			settings.IndentChars = "\t";
			writer = XmlWriter.Create (xml, settings);
		}
				
		[Test]
		public void ToXml()
		{
			XmlFileAssociation schema = new XmlFileAssociation (".xml", "http://mono-project.com", null);
			schema.WriteTo(writer);
			writer.Close ();
			
			string expectedXml = "<SchemaAssociation extension=\".xml\" namespace=\"http://mono-project.com\" prefix=\"\" />";
			Assert.AreEqual(expectedXml, xml.ToString());
		}
		
		[Test]
		public void FromXml()
		{
			XmlFileAssociation expectedSchema = new XmlFileAssociation (".xml", "http://mono-project.com", null);
			expectedSchema.WriteTo(writer);
			writer.Close ();

			string propertiesXml = "<SerializedNode>" + xml.ToString() + "</SerializedNode>";
			XmlTextReader reader = new XmlTextReader (new StringReader(propertiesXml));
			XmlFileAssociation schema = new XmlFileAssociation ();
			schema = (XmlFileAssociation)schema.ReadFrom (reader);
			
			Assert.AreEqual(expectedSchema.Extension, schema.Extension);
			Assert.AreEqual(expectedSchema.NamespacePrefix, schema.NamespacePrefix);
			Assert.AreEqual(expectedSchema.NamespaceUri, schema.NamespaceUri);
		}
		
		[Test]
		public void FromXmlMissingSchemaAssociation()
		{
			string propertiesXml = "<SerializedNode/>";
			XmlTextReader reader = new XmlTextReader(new StringReader(propertiesXml));
			XmlFileAssociation schema = new XmlFileAssociation();
			Assert.IsNull(schema.ReadFrom (reader));
		}		
	}
}
