# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1ContainerStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'state': 'V1ContainerState',
            'last_state': 'V1ContainerState',
            'ready': 'bool',
            'restart_count': 'int',
            'image': 'str',
            'image_id': 'str',
            'container_id': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'state': 'state',
            'last_state': 'lastState',
            'ready': 'ready',
            'restart_count': 'restartCount',
            'image': 'image',
            'image_id': 'imageID',
            'container_id': 'containerID'
        }

        self._name = None
        self._state = None
        self._last_state = None
        self._ready = None
        self._restart_count = None
        self._image = None
        self._image_id = None
        self._container_id = None

    @property
    def name(self):
        """
        Gets the name of this V1ContainerStatus.
        name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated

        :return: The name of this V1ContainerStatus.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this V1ContainerStatus.
        name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated

        :param name: The name of this V1ContainerStatus.
        :type: str
        """
        self._name = name

    @property
    def state(self):
        """
        Gets the state of this V1ContainerStatus.
        details about the container's current condition

        :return: The state of this V1ContainerStatus.
        :rtype: V1ContainerState
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this V1ContainerStatus.
        details about the container's current condition

        :param state: The state of this V1ContainerStatus.
        :type: V1ContainerState
        """
        self._state = state

    @property
    def last_state(self):
        """
        Gets the last_state of this V1ContainerStatus.
        details about the container's last termination condition

        :return: The last_state of this V1ContainerStatus.
        :rtype: V1ContainerState
        """
        return self._last_state

    @last_state.setter
    def last_state(self, last_state):
        """
        Sets the last_state of this V1ContainerStatus.
        details about the container's last termination condition

        :param last_state: The last_state of this V1ContainerStatus.
        :type: V1ContainerState
        """
        self._last_state = last_state

    @property
    def ready(self):
        """
        Gets the ready of this V1ContainerStatus.
        specifies whether the container has passed its readiness probe

        :return: The ready of this V1ContainerStatus.
        :rtype: bool
        """
        return self._ready

    @ready.setter
    def ready(self, ready):
        """
        Sets the ready of this V1ContainerStatus.
        specifies whether the container has passed its readiness probe

        :param ready: The ready of this V1ContainerStatus.
        :type: bool
        """
        self._ready = ready

    @property
    def restart_count(self):
        """
        Gets the restart_count of this V1ContainerStatus.
        the number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed

        :return: The restart_count of this V1ContainerStatus.
        :rtype: int
        """
        return self._restart_count

    @restart_count.setter
    def restart_count(self, restart_count):
        """
        Sets the restart_count of this V1ContainerStatus.
        the number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed

        :param restart_count: The restart_count of this V1ContainerStatus.
        :type: int
        """
        self._restart_count = restart_count

    @property
    def image(self):
        """
        Gets the image of this V1ContainerStatus.
        image of the container; see http://releases.k8s.io/v1.0.4/docs/images.md

        :return: The image of this V1ContainerStatus.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """
        Sets the image of this V1ContainerStatus.
        image of the container; see http://releases.k8s.io/v1.0.4/docs/images.md

        :param image: The image of this V1ContainerStatus.
        :type: str
        """
        self._image = image

    @property
    def image_id(self):
        """
        Gets the image_id of this V1ContainerStatus.
        ID of the container's image

        :return: The image_id of this V1ContainerStatus.
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """
        Sets the image_id of this V1ContainerStatus.
        ID of the container's image

        :param image_id: The image_id of this V1ContainerStatus.
        :type: str
        """
        self._image_id = image_id

    @property
    def container_id(self):
        """
        Gets the container_id of this V1ContainerStatus.
        container's ID in the format 'docker://<container_id>'; see http://releases.k8s.io/v1.0.4/docs/container-environment.md#container-information

        :return: The container_id of this V1ContainerStatus.
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """
        Sets the container_id of this V1ContainerStatus.
        container's ID in the format 'docker://<container_id>'; see http://releases.k8s.io/v1.0.4/docs/container-environment.md#container-information

        :param container_id: The container_id of this V1ContainerStatus.
        :type: str
        """
        self._container_id = container_id

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
