#include <config.h>
#include <stdio.h>
#include <stdlib.h>

#include <pcapnav.h>

pcap_dumper_t *dumper;

void 
pcapnav_callback(u_char *user,
		 const struct pcap_pkthdr *pkthdr,
		 const u_char *packet)
{
  printf("Writing packet\n");
  pcap_dump((u_char*)dumper, pkthdr, packet);
}


void
test_timeframe(pcapnav_t *pn)
{
  struct bpf_timeval start, end;

  pcapnav_get_timespan(pn, &start, &end);
  
  printf("File spans %u.%u seconds starting at %s",
	 end.tv_sec-start.tv_sec,
	 end.tv_usec-start.tv_usec,
	 ctime((time_t *)&start.tv_sec));
}


int 
main(int argc, char** argv)
{
  int n;
  pcapnav_t *pn;

  if (argc < 3)
    {
      printf("USAGE: %s <input tracefile> <output tracefile>\n", argv[0]);
      exit(0);
    }

  if ((pn = pcapnav_open_offline(argv[1])) == NULL)
    {
      printf("Could not open source trace file %s\n", argv[1]);
      exit(-1);
    }

  if ((dumper = pcap_dump_open(pcapnav_pcap(pn), argv[2])) == NULL)
    {
      printf("Could not open destination trace file %s\n", argv[2]);
      exit(-1);
    }

  pcapnav_goto_fraction(pn, 0.5);

  n = pcapnav_loop(pn, -1, pcapnav_callback, NULL);

  if (n < 0)
    printf("An error occured: %s\n", pcapnav_geterr(pn));
  else if (n == 0)
    printf("Successfully read up to end of trace\n");
  else
    printf("Handled %i packets.\n", n);

  pcap_dump_close(dumper);

  test_timeframe(pn);
  
  pcapnav_close(pn);

  return 0;
}
