#include "osl/move_order/promotion.h"
#include "osl/move_order/moveSorter.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::move_order;

class MoveOrderPromotionTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(MoveOrderPromotionTest);
  CPPUNIT_TEST(testSort);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSort() 
  { 
    const Square from = Square(2,8);
    const Square to   = Square(2,2);
    
    const Move m1 = Move(from, to, ROOK, PTYPE_EMPTY, false, BLACK);
    const Move m2 = Move(from, to, PROOK, PTYPE_EMPTY, true, BLACK);
    MoveVector moves;
    moves.push_back(m1);
    moves.push_back(m2);
    MoveSorter::sort(moves, Promotion());
    CPPUNIT_ASSERT(moves[0] == m2); 
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(MoveOrderPromotionTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
