/*
  libnzb

  Copyright (C) 2004 Mattias Nordstrom <matta at ftlight net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


  Authors:
    Mattias Nordstrom <matta at ftlight net>

  $Id: nntp.cpp,v 1.5 2004/09/13 15:51:13 mnordstr Exp $
    This file provides the NNTP class.

*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "nntp.h"

#include <iostream>
#include <stdio.h>

#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>

using namespace std;

extern "C" NNTP::NNTP()
{
	bytes = 0;
}

extern "C" NNTP::~NNTP()
{

}

extern "C" int NNTP::initialize(string host, int port, string user, string pass)
{
	string rdata;
	struct hostent *he;
	struct sockaddr_in their_addr; // connector's address information

	if ((he=gethostbyname(host.c_str())) == NULL) {  // get the host info
		perror("gethostbyname");
		return 1;
	}

	if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		perror("socket");
		return 1;
	}

	their_addr.sin_family = AF_INET;    // host byte order
	their_addr.sin_port = htons(port);  // short, network byte order
	their_addr.sin_addr = *((struct in_addr *)he->h_addr);
	memset(&(their_addr.sin_zero), '\0', 8);  // zero the rest of the struct

	if (connect(sockfd, (struct sockaddr *)&their_addr, sizeof(struct sockaddr)) == -1) {
		perror("connect");
		return 1;
	}
	
	rdata = net_recv();
	
	if (rdata[0] == '2') {
		string sendstr = "AUTHINFO USER " + user;
		sendstr += "\r\n";
		net_send(sendstr);
		
		net_recv();
		
		sendstr = "AUTHINFO PASS " + pass;
		sendstr += "\r\n";
		net_send(sendstr);
		
		rdata = net_recv();
		if (rdata[0] == '2') {
			return 0;
		} else {
			return 1;
		}
	} else {
		return 1;
	}		
}

extern "C" int NNTP::terminate()
{
	net_send("quit\r\n");
	net_recv();
	close(sockfd);

	return 0;
}

string NNTP::net_recv()
{
	int numbytes;
	string buffer;
	char buf[MAXDATASIZE];
	
	numbytes = recv(sockfd, buf, MAXDATASIZE-1, 0);
	
	if (numbytes < 1) {
		return "";
	}
	
	bytes += numbytes;
	
	buf[numbytes] = '\0';
	
	#ifdef DEBUG
		cerr << "recv [" << numbytes << "]: " << buf;
	#endif
	
	buffer = buf;
	return buffer;
}

int NNTP::net_send(string data)
{
	#ifdef DEBUG
		cerr << "send: " << data;
	#endif

	return send(sockfd, data.c_str(), data.length(), 0);
}

extern "C" string NNTP::get_article(string msgid)
{
	string rdata, sendstr, tmp;
	string::size_type pos;
	
	sendstr = "ARTICLE ";
	sendstr += msgid;
	sendstr += "\r\n";

	net_send(sendstr);

	rdata = net_recv();
	if (rdata[0] != '2') {
		return "";
	}
	
	while (rdata.substr(rdata.length()-5, 5) != "\r\n.\r\n") {
		rdata += net_recv();
	}
	
	rdata = rdata.substr(0, rdata.length() - 3);

	pos = rdata.find("\r\n\r\n", 0);
	rdata = rdata.substr(pos + 4, rdata.length() - (pos + 4));

	if (rdata.substr(0, 2) == "..") {
		rdata.erase(0, 1);
	}
		
	pos = 0;
	while ((pos = rdata.find("\r\n..", pos+3)) != string::npos) {
		rdata.erase(pos + 2, 1);
	}
	
	return rdata;
}
