/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Character
implements Serializable,
Comparable {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final Class TYPE = Class.getPrimitiveClass("char");
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte INITIAL_QUOTE_PUNCTUATION = 29;
    public static final byte FINAL_QUOTE_PUNCTUATION = 30;
    static final char CHAR_ERROR = '\uffff';
    public static final byte DIRECTIONALITY_UNDEFINED = -1;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT = 0;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT = 1;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC = 2;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER = 3;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR = 4;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR = 5;
    public static final byte DIRECTIONALITY_ARABIC_NUMBER = 6;
    public static final byte DIRECTIONALITY_COMMON_NUMBER_SEPARATOR = 7;
    public static final byte DIRECTIONALITY_NONSPACING_MARK = 8;
    public static final byte DIRECTIONALITY_BOUNDARY_NEUTRAL = 9;
    public static final byte DIRECTIONALITY_PARAGRAPH_SEPARATOR = 10;
    public static final byte DIRECTIONALITY_SEGMENT_SEPARATOR = 11;
    public static final byte DIRECTIONALITY_WHITESPACE = 12;
    public static final byte DIRECTIONALITY_OTHER_NEUTRALS = 13;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING = 14;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE = 15;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING = 16;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE = 17;
    public static final byte DIRECTIONALITY_POP_DIRECTIONAL_FORMAT = 18;
    private static final int FAST_PATH_MAX = 255;
    private char value;
    private static final long serialVersionUID = 3786198910865385080L;
    static char[] sharpsMap = new char[]{'S', 'S'};

    public Character(char c) {
        this.value = c;
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Character) {
            return this.value == ((Character)object).charValue();
        }
        return false;
    }

    public String toString() {
        char[] cArray = new char[]{this.value};
        return String.valueOf(cArray);
    }

    public static String toString(char c) {
        return String.valueOf(c);
    }

    public static boolean isLowerCase(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isLowerCase(c);
        }
        return CharacterData.isLowerCase(c);
    }

    public static boolean isUpperCase(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isUpperCase(c);
        }
        return CharacterData.isUpperCase(c);
    }

    public static boolean isTitleCase(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isTitleCase(c);
        }
        return CharacterData.isTitleCase(c);
    }

    public static boolean isDigit(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isDigit(c);
        }
        return CharacterData.isDigit(c);
    }

    public static boolean isDefined(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isDefined(c);
        }
        return CharacterData.isDefined(c);
    }

    public static boolean isLetter(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isLetter(c);
        }
        return CharacterData.isLetter(c);
    }

    public static boolean isLetterOrDigit(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isLetterOrDigit(c);
        }
        return CharacterData.isLetterOrDigit(c);
    }

    public static boolean isJavaIdentifierStart(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isJavaIdentifierStart(c);
        }
        return CharacterData.isJavaIdentifierStart(c);
    }

    public static boolean isJavaIdentifierPart(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isJavaIdentifierPart(c);
        }
        return CharacterData.isJavaIdentifierPart(c);
    }

    public static boolean isUnicodeIdentifierStart(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isUnicodeIdentifierStart(c);
        }
        return CharacterData.isUnicodeIdentifierStart(c);
    }

    public static boolean isUnicodeIdentifierPart(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isUnicodeIdentifierPart(c);
        }
        return CharacterData.isUnicodeIdentifierPart(c);
    }

    public static boolean isIdentifierIgnorable(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isIdentifierIgnorable(c);
        }
        return CharacterData.isIdentifierIgnorable(c);
    }

    public static char toLowerCase(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.toLowerCase(c);
        }
        return CharacterData.toLowerCase(c);
    }

    public static char toUpperCase(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.toUpperCase(c);
        }
        return CharacterData.toUpperCase(c);
    }

    public static char toTitleCase(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.toTitleCase(c);
        }
        return CharacterData.toTitleCase(c);
    }

    public static int digit(char c, int n) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.digit(c, n);
        }
        return CharacterData.digit(c, n);
    }

    public static int getNumericValue(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.getNumericValue(c);
        }
        return CharacterData.getNumericValue(c);
    }

    public static boolean isSpaceChar(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isSpaceChar(c);
        }
        return CharacterData.isSpaceChar(c);
    }

    public static boolean isWhitespace(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isWhitespace(c);
        }
        return CharacterData.isWhitespace(c);
    }

    public static boolean isISOControl(char c) {
        return c <= '\u009f' && (c <= '\u001f' || c >= '\u007f');
    }

    public static int getType(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.getType(c);
        }
        return CharacterData.getType(c);
    }

    public static char forDigit(int n, int n2) {
        if (n >= n2 || n < 0) {
            return '\u0000';
        }
        if (n2 < 2 || n2 > 36) {
            return '\u0000';
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(87 + n);
    }

    public static byte getDirectionality(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.getDirectionality(c);
        }
        return CharacterData.getDirectionality(c);
    }

    public static boolean isMirrored(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.isMirrored(c);
        }
        return CharacterData.isMirrored(c);
    }

    public int compareTo(Character c) {
        return this.value - c.value;
    }

    public int compareTo(Object object) {
        return this.compareTo((Character)object);
    }

    static char toUpperCaseEx(char c) {
        if (c <= '\u00ff') {
            return CharacterDataLatin1.toUpperCaseEx(c);
        }
        return CharacterData.toUpperCaseEx(c);
    }

    static char[] toUpperCaseCharArray(char c) {
        char[] cArray = new char[]{c};
        if (c <= '\u00ff') {
            if (c == '\u00df') {
                cArray = sharpsMap;
            }
        } else {
            int n = Character.findInCharMap(c);
            if (n != -1) {
                cArray = CharacterData.charMap[n][1];
            }
        }
        return cArray;
    }

    static int findInCharMap(char c) {
        int n = 0;
        int n2 = CharacterData.charMap.length;
        int n3 = n2 / 2;
        while (n2 - n > 1) {
            if (c >= CharacterData.charMap[n3][0][0]) {
                n = n3;
            } else {
                n2 = n3;
            }
            n3 = (n2 + n) / 2;
        }
        if (c == CharacterData.charMap[n3][0][0]) {
            return n3;
        }
        return -1;
    }

    public static final class UnicodeBlock
    extends Subset {
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock("BASIC_LATIN");
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock("LATIN_1_SUPPLEMENT");
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock("LATIN_EXTENDED_A");
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock("LATIN_EXTENDED_B");
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock("IPA_EXTENSIONS");
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock("SPACING_MODIFIER_LETTERS");
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS");
        public static final UnicodeBlock GREEK = new UnicodeBlock("GREEK");
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock("CYRILLIC");
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock("ARMENIAN");
        public static final UnicodeBlock HEBREW = new UnicodeBlock("HEBREW");
        public static final UnicodeBlock ARABIC = new UnicodeBlock("ARABIC");
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock("DEVANAGARI");
        public static final UnicodeBlock BENGALI = new UnicodeBlock("BENGALI");
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock("GURMUKHI");
        public static final UnicodeBlock GUJARATI = new UnicodeBlock("GUJARATI");
        public static final UnicodeBlock ORIYA = new UnicodeBlock("ORIYA");
        public static final UnicodeBlock TAMIL = new UnicodeBlock("TAMIL");
        public static final UnicodeBlock TELUGU = new UnicodeBlock("TELUGU");
        public static final UnicodeBlock KANNADA = new UnicodeBlock("KANNADA");
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock("MALAYALAM");
        public static final UnicodeBlock THAI = new UnicodeBlock("THAI");
        public static final UnicodeBlock LAO = new UnicodeBlock("LAO");
        public static final UnicodeBlock TIBETAN = new UnicodeBlock("TIBETAN");
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock("GEORGIAN");
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock("HANGUL_JAMO");
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock("LATIN_EXTENDED_ADDITIONAL");
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock("GREEK_EXTENDED");
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock("GENERAL_PUNCTUATION");
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock("SUPERSCRIPTS_AND_SUBSCRIPTS");
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock("CURRENCY_SYMBOLS");
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock("COMBINING_MARKS_FOR_SYMBOLS");
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock("LETTERLIKE_SYMBOLS");
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock("NUMBER_FORMS");
        public static final UnicodeBlock ARROWS = new UnicodeBlock("ARROWS");
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock("MATHEMATICAL_OPERATORS");
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock("MISCELLANEOUS_TECHNICAL");
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock("CONTROL_PICTURES");
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock("OPTICAL_CHARACTER_RECOGNITION");
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock("ENCLOSED_ALPHANUMERICS");
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock("BOX_DRAWING");
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock("BLOCK_ELEMENTS");
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock("GEOMETRIC_SHAPES");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS");
        public static final UnicodeBlock DINGBATS = new UnicodeBlock("DINGBATS");
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("CJK_SYMBOLS_AND_PUNCTUATION");
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock("HIRAGANA");
        public static final UnicodeBlock KATAKANA = new UnicodeBlock("KATAKANA");
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock("BOPOMOFO");
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock("HANGUL_COMPATIBILITY_JAMO");
        public static final UnicodeBlock KANBUN = new UnicodeBlock("KANBUN");
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock("ENCLOSED_CJK_LETTERS_AND_MONTHS");
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock("CJK_COMPATIBILITY");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS");
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock("HANGUL_SYLLABLES");
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock("SURROGATES_AREA");
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock("PRIVATE_USE_AREA");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS");
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock("ALPHABETIC_PRESENTATION_FORMS");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_A");
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock("COMBINING_HALF_MARKS");
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock("CJK_COMPATIBILITY_FORMS");
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock("SMALL_FORM_VARIANTS");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_B");
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock("HALFWIDTH_AND_FULLWIDTH_FORMS");
        public static final UnicodeBlock SPECIALS = new UnicodeBlock("SPECIALS");
        public static final UnicodeBlock SYRIAC = new UnicodeBlock("SYRIAC");
        public static final UnicodeBlock THAANA = new UnicodeBlock("THAANA");
        public static final UnicodeBlock SINHALA = new UnicodeBlock("SINHALA");
        public static final UnicodeBlock MYANMAR = new UnicodeBlock("MYANMAR");
        public static final UnicodeBlock ETHIOPIC = new UnicodeBlock("ETHIOPIC");
        public static final UnicodeBlock CHEROKEE = new UnicodeBlock("CHEROKEE");
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock("UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS");
        public static final UnicodeBlock OGHAM = new UnicodeBlock("OGHAM");
        public static final UnicodeBlock RUNIC = new UnicodeBlock("RUNIC");
        public static final UnicodeBlock KHMER = new UnicodeBlock("KHMER");
        public static final UnicodeBlock MONGOLIAN = new UnicodeBlock("MONGOLIAN");
        public static final UnicodeBlock BRAILLE_PATTERNS = new UnicodeBlock("BRAILLE_PATTERNS");
        public static final UnicodeBlock CJK_RADICALS_SUPPLEMENT = new UnicodeBlock("CJK_RADICALS_SUPPLEMENT");
        public static final UnicodeBlock KANGXI_RADICALS = new UnicodeBlock("KANGXI_RADICALS");
        public static final UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock("IDEOGRAPHIC_DESCRIPTION_CHARACTERS");
        public static final UnicodeBlock BOPOMOFO_EXTENDED = new UnicodeBlock("BOPOMOFO_EXTENDED");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A");
        public static final UnicodeBlock YI_SYLLABLES = new UnicodeBlock("YI_SYLLABLES");
        public static final UnicodeBlock YI_RADICALS = new UnicodeBlock("YI_RADICALS");
        private static final char[] blockStarts = new char[]{'\u0000', '\u0080', '\u0100', '\u0180', '\u0250', '\u02b0', '\u0300', '\u0370', '\u0400', '\u0500', '\u0530', '\u0590', '\u0600', '\u0700', '\u0750', '\u0780', '\u07c0', '\u0900', '\u0980', '\u0a00', '\u0a80', '\u0b00', '\u0b80', '\u0c00', '\u0c80', '\u0d00', '\u0d80', '\u0e00', '\u0e80', '\u0f00', '\u1000', '\u10a0', '\u1100', '\u1200', '\u1380', '\u13a0', '\u1400', '\u1680', '\u16a0', '\u1700', '\u1780', '\u1800', '\u18b0', '\u1e00', '\u1f00', '\u2000', '\u2070', '\u20a0', '\u20d0', '\u2100', '\u2150', '\u2190', '\u2200', '\u2300', '\u2400', '\u2440', '\u2460', '\u2500', '\u2580', '\u25a0', '\u2600', '\u2700', '\u27c0', '\u2800', '\u2900', '\u2e80', '\u2f00', '\u2fe0', '\u2ff0', '\u3000', '\u3040', '\u30a0', '\u3100', '\u3130', '\u3190', '\u31a0', '\u31c0', '\u3200', '\u3300', '\u3400', '\u4db6', '\u4e00', '\ua000', '\ua490', '\ua4d0', '\uac00', '\ud7a4', '\ud800', '\ue000', '\uf900', '\ufb00', '\ufb50', '\ufe00', '\ufe20', '\ufe30', '\ufe50', '\ufe70', '\ufeff', '\uff00', '\ufff0', '\ufffe'};
        private static final UnicodeBlock[] blocks = new UnicodeBlock[]{BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, null, ARMENIAN, HEBREW, ARABIC, SYRIAC, null, THAANA, null, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR, GEORGIAN, HANGUL_JAMO, ETHIOPIC, null, CHEROKEE, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, OGHAM, RUNIC, null, KHMER, MONGOLIAN, null, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, null, BRAILLE_PATTERNS, null, CJK_RADICALS_SUPPLEMENT, KANGXI_RADICALS, null, IDEOGRAPHIC_DESCRIPTION_CHARACTERS, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, BOPOMOFO_EXTENDED, null, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, null, CJK_UNIFIED_IDEOGRAPHS, YI_SYLLABLES, YI_RADICALS, null, HANGUL_SYLLABLES, null, SURROGATES_AREA, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, null, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, SPECIALS, HALFWIDTH_AND_FULLWIDTH_FORMS, SPECIALS, null};

        private UnicodeBlock(String string) {
            super(string);
        }

        public static UnicodeBlock of(char c) {
            int n = 0;
            int n2 = blockStarts.length;
            int n3 = n2 / 2;
            while (n2 - n > 1) {
                if (c >= blockStarts[n3]) {
                    n = n3;
                } else {
                    n2 = n3;
                }
                n3 = (n2 + n) / 2;
            }
            return blocks[n3];
        }
    }

    public static class Subset {
        private String name;

        protected Subset(String string) {
            if (string == null) {
                throw new NullPointerException("name");
            }
            this.name = string;
        }

        public final boolean equals(Object object) {
            return this == object;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

