/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class PDFObject
implements Serializable {
    private final String type;
    protected int objser;
    protected PDFDocument pdfDocument;

    public PDFObject(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public final int getSerialID() {
        return this.objser;
    }

    public final PDFDocument getPDFDocument() {
        return this.pdfDocument;
    }

    public abstract void write(OutputStream var1) throws IOException;

    public final void writeStart(OutputStream outputStream) throws IOException {
        outputStream.write(Integer.toString(this.objser).getBytes());
        outputStream.write(" 0 obj\n<<\n".getBytes());
        if (this.type != null) {
            outputStream.write("/Type ".getBytes());
            outputStream.write(this.type.getBytes());
            outputStream.write("\n".getBytes());
        }
    }

    public final void writeEnd(OutputStream outputStream) throws IOException {
        outputStream.write(">>\nendobj\n".getBytes());
    }

    public String toString() {
        return "" + this.objser + " 0 R";
    }

    public static String toArray(Vector<? extends PDFObject> vector) {
        if (vector.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "[";
        for (PDFObject pDFObject : vector) {
            stringBuilder.append(string);
            stringBuilder.append(pDFObject.toString());
            string = " ";
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

