/*
 * JLaTeXMath ( http://forge.scilab.org/jlatexmath ) - This file is part of JLaTeXMath
 *
 * Copyright (C) 2012 - Calixte DENIZET & Sylvestre LEDRU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 *
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Linking this library statically or dynamically with other modules 
 * is making a combined work based on this library. Thus, the terms 
 * and conditions of the GNU General Public License cover the whole 
 * combination.
 * 
 * As a special exception, the copyright holders of this library give you 
 * permission to link this library with independent modules to produce 
 * an executable, regardless of the license terms of these independent 
 * modules, and to copy and distribute the resulting executable under terms 
 * of your choice, provided that you also meet, for each linked independent 
 * module, the terms and conditions of the license of that module. 
 * An independent module is a module which is not derived from or based 
 * on this library. If you modify this library, you may extend this exception 
 * to your version of the library, but you are not obliged to do so. 
 * If you do not wish to do so, delete this exception statement from your 
 * version.
 * 
 */

#include "LaTeXGenerator.hxx"
#include <jni.h>

JavaVM* create_vm() {
    JavaVM* jvm; JNIEnv* env;

    JavaVMInitArgs args;
    JavaVMOption options[2];

    args.version = JNI_VERSION_1_4;

    args.nOptions = 2;

#ifndef _MSC_VER
    options[0].optionString = const_cast<char*>("-Djava.class.path=./dist/GiwsExample.jar:/usr/share/java/jlatexmath.jar");
#else
    options[0].optionString = const_cast<char*>("-Djava.class.path=./dist/GiwsExample.jar;../../dist/jlatexmath-1.0.3.jar");
#endif

    options[1].optionString = const_cast<char*>("-Xcheck:jni");
    args.options = options;

    args.ignoreUnrecognized = JNI_FALSE;

    JNI_CreateJavaVM(&jvm, (void **)&env, &args);

    return jvm;
}

int main(int argc, char ** argv)
{
    if (argc == 3)
    {
	JavaVM* jvm = create_vm();
	org_scilab_forge_example_giws::LaTeXGenerator * latex = new org_scilab_forge_example_giws::LaTeXGenerator(jvm);
	latex->generate(argv[1], argv[2]);
	
	delete latex;
    }

    return 0;
}
