/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.reflect.spi;

import java.lang.annotation.Annotation;
import java.util.Map;


/**
 * An annotation value
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 */
public interface AnnotationValue extends Value
{
   /**
    * Get the annotation type
    * 
    * @return the annotation type
    */
   AnnotationInfo getAnnotationType();
   
   /**
    * Get an attribute value
    * 
    * @param attributeName the attribute name
    * @return the value
    */
   Value getValue(String attributeName);
   
   /**
    * Get the values
    * 
    * @return the values
    */
   Map<String, Value> getValues();
   
   /**
    * Get the underlying annotation
    *
    * @return the annotation
    */
   Annotation getUnderlyingAnnotation();
   
   /**
    * Get the underlying annotation
    *
    * @param <T> the annotation type
    * @param annotationType the annotationType
    * @return the annotation
    */
   <T extends Annotation> T getUnderlyingAnnotation(Class<T> annotationType);
}
