/*
 * @(#)ArrayClassLoaderUTest.java      0.9.0 23-May-2001 - 14:40
 *
 * Copyright (C) 2001,2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1.jdk0;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Just like util.http.tests, this uses the Sourceforge account to ensure
 * that the URLs work correctly.  It loads the sample applet "BeliefOfTheDay"
 * to make sure that this is able to load classes remotely.
 * As insurance, this also tests to make sure that the same applet is not
 * in the current classpath.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:39 $
 * @since     May 23, 2001
 */
public class ArrayClassLoaderUTest extends TestCase
{
    private static final Class THIS_CLASS = ArrayClassLoaderUTest.class;
    
    public ArrayClassLoaderUTest( String name )
    {
        super( name );
    }
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }

    
    public void testInstantiate()
    {
        new ArrayClassLoader();
    }
    
    private class NullBytecodeSource implements BytecodeSource
    {
        public byte[] getBytecode( String classname )
        {
            return null;
        }
    }
    
    
    public void testSetBytecodeSource()
    {
        ArrayClassLoader acl = new ArrayClassLoader();
        acl.setBytecodeSource( new NullBytecodeSource() );
    }
    
    
    public void testSetBytecodeSourceNull()
    {
        ArrayClassLoader acl = new ArrayClassLoader();
        acl.setBytecodeSource( null ); // should not throw an exception
    }
    
    
    public void testAddClassNull1()
    {
        ArrayClassLoader acl = new ArrayClassLoader();
        try
        {
            acl.addClass( null, null );
        }
        catch (IllegalArgumentException iae)
        {
            return;
        }
        assertTrue( "Did not throw an IllegalArgumentException with null args.",
            true );
    }
    
    
    public void testAddClassNull2()
    {
        ArrayClassLoader acl = new ArrayClassLoader();
        try
        {
            acl.addClass( "SomeClass", null );
        }
        catch (IllegalArgumentException iae)
        {
            return;
        }
        assertTrue( "Did not throw an IllegalArgumentException with null args.",
            true );
    }
    
    
    public void testAddClassNull3()
    {
        ArrayClassLoader acl = new ArrayClassLoader();
        try
        {
            acl.addClass( null, new byte[0] );
        }
        catch (IllegalArgumentException iae)
        {
            return;
        }
        assertTrue( "Did not throw an IllegalArgumentException with null args.",
            true );
    }
    
    
    public void testLoadClassNull1() throws ClassNotFoundException
    {
        ArrayClassLoader acl = new ArrayClassLoader();
        try
        {
            acl.loadClass( null, true );
            fail( "Did not throw an IllegalArgumentException with null args." );
        }
        catch (IllegalArgumentException iae)
        {
            // check error
            return;
        }
    }
    
    
    public void testLoadClassBad1()
    {
        ArrayClassLoader acl = setupLoader();
        try
        {
            acl.loadClass( BAD_CLASS, true );
            fail("Did not throw an Exception with a bad class.");
        }
        catch (ClassFormatError cfe)
        {
            // check error?
        }
        catch (ClassNotFoundException cnfe)
        {
            // check error?
        }
    }
    
    
    protected static final String BAD_CLASS = "BadClass";
    
    protected ArrayClassLoader setupLoader()
    {
        ArrayClassLoader acl = new ArrayClassLoader();
        acl.addClass( BAD_CLASS, new byte[0] );
        
        return acl;
    }
}
