/*
 * @(#)ServerUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1.testserver;

import net.sourceforge.groboutils.autodoc.v1.*;

//import net.sourceforge.groboutils.testing.junitlog.v1.*;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the Server interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     March 27, 2002
 * @version   $Date: 2003/02/10 22:52:17 $
 */
public class ServerUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = ServerUTestI.class;
//    private static final IJUnitDocumentor LOG = (new JUnitLog(THIS_CLASS)).getDocumentor();
    
    public ServerUTestI( String name, ImplFactory f )
    {
        super( name, Server.class, f );
    }

    
    public Server createServer()
    {
        return (Server)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testAddTestData1()
    {
        Server s = createServer();
        
        // must run w/o exception.
        s.addTestData( null );
    }
    
    
    public void testAddTestData2()
    {
        TestData td = new TestData() {
            public TestInfo getTestInfo() {
                return null;
            }
        };
        
        
        Server s = createServer();
        
        // must run w/o exception.
        s.addTestData( td );
    }
    
    
    public void testAddTestData3()
    {
        final TestInfo ti = new DefaultTestInfo( "a", "b" );
        TestData td = new TestData() {
            public TestInfo getTestInfo() {
                return ti;
            }
        };
        
        
        Server s = createServer();
        
        // must run w/o exception.
        s.addTestData( td );
    }
    
    
    public void testAddTestData4()
    {
        final TestInfo ti = new DefaultTestInfo();
        TestData td = new TestData() {
            public TestInfo getTestInfo() {
                return ti;
            }
        };
        
        
        Server s = createServer();
        
        // must run w/o exception.
        s.addTestData( td );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

