------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2009-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.IO;                use GNAT.IO;
with GNATCOLL.GMP.Integers;  use GNATCOLL.GMP.Integers;

procedure Test_Image is

   N : Big_Integer;

   Input : constant String := "14000000000000000000000" &
                              "000000000000000000000001";

   Negated_Input : constant String := '-' & Input;

   Input_Base_2 : constant String :=
      "1001110011110010000001111001000111010111100010000101010100011010011" &
      "0000111101110001100000010011011111001001100000000000000000000000000" &
      "00000000000000000001";

begin
   Set (N, Input);
   if Image (N) /= Input then
      Put_Line ("test_image failed: basic Image call");
      return;
   end if;

   Negate (N);
   if Image (N) /= Negated_Input then
      Put_Line ("test_image failed: negated image is incorrect");
      return;
   end if;

   Set (N, Input);
   if Image (N, Base => 2) /= Input_Base_2 then
      Put_Line ("test_image failed: wrong image in base 2");
      return;
   end if;

   Put_Line ("test_image passed");
end Test_Image;
