------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                     Copyright (C) 2005-2009, AdaCore                     --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Calendar;

with AWS.Resources;

package Templates_Parser.Configuration is

   subtype Time_Stamp is Ada.Calendar.Time;

   pragma Style_Checks (Off);
   --  Kill bogus style check on missing overriding keyword with old GNAT
   --  versions.
   function "="
     (T1, T2 : Time_Stamp)
      return Boolean
      renames Ada.Calendar."=";
   pragma Style_Checks (All_Checks);

   function Is_Regular_File
     (Filename : String)
      return Boolean
      renames AWS.Resources.Is_Regular_File;

   function File_Time_Stamp
     (Filename : String)
      return Time_Stamp
      renames AWS.Resources.File_Timestamp;

end Templates_Parser.Configuration;
