/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.kawa.xml.KDocument;
import gnu.lists.Consumer;
import gnu.lists.XConsumer;
import gnu.mapping.Environment;
import gnu.mapping.NamedLocation;
import gnu.mapping.Symbol;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xml.NodeTree;
import gnu.xml.XMLParser;

public class Document {
    public static final Document document = new Document();
    static String docNamespace = "http://gnu.org/kawa/cached-documents";

    public static void parse(Object name, Consumer out) throws Throwable {
        SourceMessages messages = new SourceMessages();
        if (out instanceof XConsumer) {
            ((XConsumer)out).beginEntity(name);
        }
        XMLParser.parse(name, messages, out);
        if (messages.seenErrors()) {
            throw new SyntaxException("document function read invalid XML", messages);
        }
        if (out instanceof XConsumer) {
            ((XConsumer)out).endEntity();
        }
    }

    public static KDocument parse(Object uri) throws Throwable {
        NodeTree doc = new NodeTree();
        Document.parse(uri, doc);
        return new KDocument(doc, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseCached(Object uri) throws Throwable {
        Symbol sym = Symbol.make(docNamespace, uri.toString());
        Environment env = Environment.getCurrent();
        Symbol symbol = sym;
        synchronized (symbol) {
            NamedLocation loc = env.getLocation(sym, null, true);
            Object val = loc.get(null);
            if (val != null) {
                return val;
            }
            NodeTree tree = new NodeTree();
            SourceMessages messages = new SourceMessages();
            tree.beginEntity(uri);
            XMLParser.parse(uri, messages, (Consumer)tree);
            if (messages.seenErrors()) {
                throw new SyntaxException("document function read invalid XML", messages);
            }
            tree.endEntity();
            val = new KDocument(tree, 10);
            loc.set(val);
            return val;
        }
    }
}

