# Lumino

[![Build Status](https://github.com/jupyterlab/lumino/workflows/Tests/badge.svg?branch=main)](https://github.com/jupyterlab/lumino/actions?query=branch%3Amain+workflow%3A%22Tests%22)
[![Documentation Status](https://readthedocs.org/projects/jupyterlab/badge/?version=latest)](https://lumino.readthedocs.io/en/latest/)
[![GitHub](https://img.shields.io/badge/issue_tracking-github-blue.svg)](https://github.com/jupyterlab/lumino/issues)
[![Discourse](https://img.shields.io/badge/help_forum-discourse-blue.svg)](https://discourse.jupyter.org/c/jupyterlab)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/jupyterlab/lumino/main?urlpath=lab/tree/examples)

Lumino is a set of JavaScript packages, written in TypeScript, that provide
a rich toolkit of widgets, layouts, events, and data structures. These enable
developers to construct extensible high-performance desktop-like web
applications, such as JupyterLab. Lumino was formerly known as PhosphorJS.

Lumino is Jupyter project and follows the Jupyter
[Community Guides and Code of Conduct](https://jupyter.readthedocs.io/en/latest/community/content-community.html).

## Examples

### JupyterLab

[JupyterLab](https://github.com/jupyterlab/jupyterlab) is an extensible environment for interactive and reproducible computing.

You can try it live in a web browser (without installing anything) by clicking on the link below:

[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/jupyterlab/lumino/main?urlpath=lab/tree/examples)

![jupyterlab](https://user-images.githubusercontent.com/591645/133745885-8905be8e-afc0-466d-afda-21ed3cf0d813.png)

### Examples in the repository

This repository contains several examples making use of Lumino Widgets such as the `DockPanel` and the `DataGrid`.

The example can be interacted with live in the browser by following this link:

[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/jupyterlab/lumino/main?urlpath=lab/tree/examples)

![examples-binder](https://user-images.githubusercontent.com/591645/133746521-ca0debce-f453-417b-bca3-60d10044857f.gif)

### External Examples

- [Using Lumino in a Vue.js application](https://github.com/kinow/vue-lumino)
- [wasmboy: Game Boy / Game Boy Color Emulator Library, written for WebAssembly using AssemblyScript](https://github.com/torch2424/wasmboy)
- [Web Components (Docking, Split and Tab Panels)](http://hpcc-systems.github.io/Visualization/components/README.html)

## Usage

To learn more on how to use Lumino, check out the documentation: https://lumino.readthedocs.io/en/latest/

## Development

See [CONTRIBUTING.md](./CONTRIBUTING.md) to know how to contribute and set up
a development environment.

## Learning Resources

- [PhosphorJS 2019 Mentor Sessions on YouTube](https://www.youtube.com/channel/UCejhDXmzOrxhsTsQBWe-pww/videos).
