; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi ilp32f < %s | FileCheck -check-prefixes=CHECKIZFH,RV32IZFH %s
; RUN: llc -mtriple=riscv64 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi lp64f < %s | FileCheck -check-prefixes=CHECKIZFH,RV64IZFH %s
; RUN: llc -mtriple=riscv32 -mattr=+zfhmin -verify-machineinstrs \
; RUN:   -target-abi ilp32f < %s | FileCheck -check-prefixes=CHECKIZFHMIN,RV32IZFHMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zfhmin -verify-machineinstrs \
; RUN:   -target-abi lp64f < %s | FileCheck -check-prefixes=CHECKIZFHMIN,RV64IZFHMIN %s

define half @flh(ptr %a) nounwind {
; CHECKIZFH-LABEL: flh:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    flh ft0, 0(a0)
; CHECKIZFH-NEXT:    flh ft1, 6(a0)
; CHECKIZFH-NEXT:    fadd.h fa0, ft0, ft1
; CHECKIZFH-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: flh:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    flh ft0, 6(a0)
; CHECKIZFHMIN-NEXT:    flh ft1, 0(a0)
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, ft1
; CHECKIZFHMIN-NEXT:    fadd.s ft0, ft1, ft0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; CHECKIZFHMIN-NEXT:    ret
  %1 = load half, ptr %a
  %2 = getelementptr half, ptr %a, i32 3
  %3 = load half, ptr %2
; Use both loaded values in an FP op to ensure an flh is used, even for the
; soft half ABI
  %4 = fadd half %1, %3
  ret half %4
}

define dso_local void @fsh(ptr %a, half %b, half %c) nounwind {
; Use %b and %c in an FP op to ensure half precision floating point registers
; are used, even for the soft half ABI
; CHECKIZFH-LABEL: fsh:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fadd.h ft0, fa0, fa1
; CHECKIZFH-NEXT:    fsh ft0, 0(a0)
; CHECKIZFH-NEXT:    fsh ft0, 16(a0)
; CHECKIZFH-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fsh:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, fa0
; CHECKIZFHMIN-NEXT:    fadd.s ft0, ft1, ft0
; CHECKIZFHMIN-NEXT:    fcvt.h.s ft0, ft0
; CHECKIZFHMIN-NEXT:    fsh ft0, 0(a0)
; CHECKIZFHMIN-NEXT:    fsh ft0, 16(a0)
; CHECKIZFHMIN-NEXT:    ret
  %1 = fadd half %b, %c
  store half %1, ptr %a
  %2 = getelementptr half, ptr %a, i32 8
  store half %1, ptr %2
  ret void
}

; Check load and store to a global
@G = dso_local global half 0.0

define half @flh_fsh_global(half %a, half %b) nounwind {
; Use %a and %b in an FP op to ensure half precision floating point registers
; are used, even for the soft half ABI
; CHECKIZFH-LABEL: flh_fsh_global:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fadd.h fa0, fa0, fa1
; CHECKIZFH-NEXT:    lui a0, %hi(G)
; CHECKIZFH-NEXT:    flh ft0, %lo(G)(a0)
; CHECKIZFH-NEXT:    addi a1, a0, %lo(G)
; CHECKIZFH-NEXT:    fsh fa0, %lo(G)(a0)
; CHECKIZFH-NEXT:    flh ft0, 18(a1)
; CHECKIZFH-NEXT:    fsh fa0, 18(a1)
; CHECKIZFH-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: flh_fsh_global:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft0, fa1
; CHECKIZFHMIN-NEXT:    fcvt.s.h ft1, fa0
; CHECKIZFHMIN-NEXT:    fadd.s ft0, ft1, ft0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; CHECKIZFHMIN-NEXT:    lui a0, %hi(G)
; CHECKIZFHMIN-NEXT:    flh ft0, %lo(G)(a0)
; CHECKIZFHMIN-NEXT:    addi a1, a0, %lo(G)
; CHECKIZFHMIN-NEXT:    fsh fa0, %lo(G)(a0)
; CHECKIZFHMIN-NEXT:    flh ft0, 18(a1)
; CHECKIZFHMIN-NEXT:    fsh fa0, 18(a1)
; CHECKIZFHMIN-NEXT:    ret
  %1 = fadd half %a, %b
  %2 = load volatile half, ptr @G
  store half %1, ptr @G
  %3 = getelementptr half, ptr @G, i32 9
  %4 = load volatile half, ptr %3
  store half %1, ptr %3
  ret half %1
}

; Ensure that 1 is added to the high 20 bits if bit 11 of the low part is 1
define half @flh_fsh_constant(half %a) nounwind {
; RV32IZFH-LABEL: flh_fsh_constant:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, 912092
; RV32IZFH-NEXT:    flh ft0, -273(a0)
; RV32IZFH-NEXT:    fadd.h fa0, fa0, ft0
; RV32IZFH-NEXT:    fsh fa0, -273(a0)
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: flh_fsh_constant:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    lui a0, 228023
; RV64IZFH-NEXT:    slli a0, a0, 2
; RV64IZFH-NEXT:    flh ft0, -273(a0)
; RV64IZFH-NEXT:    fadd.h fa0, fa0, ft0
; RV64IZFH-NEXT:    fsh fa0, -273(a0)
; RV64IZFH-NEXT:    ret
;
; RV32IZFHMIN-LABEL: flh_fsh_constant:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    lui a0, 912092
; RV32IZFHMIN-NEXT:    flh ft0, -273(a0)
; RV32IZFHMIN-NEXT:    fcvt.s.h ft1, fa0
; RV32IZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; RV32IZFHMIN-NEXT:    fadd.s ft0, ft1, ft0
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; RV32IZFHMIN-NEXT:    fsh fa0, -273(a0)
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: flh_fsh_constant:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    lui a0, 228023
; RV64IZFHMIN-NEXT:    slli a0, a0, 2
; RV64IZFHMIN-NEXT:    flh ft0, -273(a0)
; RV64IZFHMIN-NEXT:    fcvt.s.h ft1, fa0
; RV64IZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; RV64IZFHMIN-NEXT:    fadd.s ft0, ft1, ft0
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; RV64IZFHMIN-NEXT:    fsh fa0, -273(a0)
; RV64IZFHMIN-NEXT:    ret
  %1 = inttoptr i32 3735928559 to ptr
  %2 = load volatile half, ptr %1
  %3 = fadd half %a, %2
  store half %3, ptr %1
  ret half %3
}

declare void @notdead(ptr)

define half @flh_stack(half %a) nounwind {
; RV32IZFH-LABEL: flh_stack:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fsw fs0, 8(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fmv.h fs0, fa0
; RV32IZFH-NEXT:    addi a0, sp, 4
; RV32IZFH-NEXT:    call notdead@plt
; RV32IZFH-NEXT:    flh ft0, 4(sp)
; RV32IZFH-NEXT:    fadd.h fa0, ft0, fs0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    flw fs0, 8(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: flh_stack:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV64IZFH-NEXT:    fmv.h fs0, fa0
; RV64IZFH-NEXT:    mv a0, sp
; RV64IZFH-NEXT:    call notdead@plt
; RV64IZFH-NEXT:    flh ft0, 0(sp)
; RV64IZFH-NEXT:    fadd.h fa0, ft0, fs0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZFHMIN-LABEL: flh_stack:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fsw fs0, 8(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fmv.s fs0, fa0
; RV32IZFHMIN-NEXT:    addi a0, sp, 4
; RV32IZFHMIN-NEXT:    call notdead@plt
; RV32IZFHMIN-NEXT:    flh ft0, 4(sp)
; RV32IZFHMIN-NEXT:    fcvt.s.h ft1, fs0
; RV32IZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; RV32IZFHMIN-NEXT:    fadd.s ft0, ft0, ft1
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    flw fs0, 8(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: flh_stack:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV64IZFHMIN-NEXT:    fmv.s fs0, fa0
; RV64IZFHMIN-NEXT:    mv a0, sp
; RV64IZFHMIN-NEXT:    call notdead@plt
; RV64IZFHMIN-NEXT:    flh ft0, 0(sp)
; RV64IZFHMIN-NEXT:    fcvt.s.h ft1, fs0
; RV64IZFHMIN-NEXT:    fcvt.s.h ft0, ft0
; RV64IZFHMIN-NEXT:    fadd.s ft0, ft0, ft1
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
  %1 = alloca half, align 4
  call void @notdead(ptr %1)
  %2 = load half, ptr %1
  %3 = fadd half %2, %a ; force load in to FPR16
  ret half %3
}

define dso_local void @fsh_stack(half %a, half %b) nounwind {
; RV32IZFH-LABEL: fsh_stack:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fadd.h ft0, fa0, fa1
; RV32IZFH-NEXT:    fsh ft0, 8(sp)
; RV32IZFH-NEXT:    addi a0, sp, 8
; RV32IZFH-NEXT:    call notdead@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fsh_stack:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fadd.h ft0, fa0, fa1
; RV64IZFH-NEXT:    fsh ft0, 4(sp)
; RV64IZFH-NEXT:    addi a0, sp, 4
; RV64IZFH-NEXT:    call notdead@plt
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZFHMIN-LABEL: fsh_stack:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    fcvt.s.h ft0, fa1
; RV32IZFHMIN-NEXT:    fcvt.s.h ft1, fa0
; RV32IZFHMIN-NEXT:    fadd.s ft0, ft1, ft0
; RV32IZFHMIN-NEXT:    fcvt.h.s ft0, ft0
; RV32IZFHMIN-NEXT:    fsh ft0, 8(sp)
; RV32IZFHMIN-NEXT:    addi a0, sp, 8
; RV32IZFHMIN-NEXT:    call notdead@plt
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: fsh_stack:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    addi sp, sp, -16
; RV64IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFHMIN-NEXT:    fcvt.s.h ft0, fa1
; RV64IZFHMIN-NEXT:    fcvt.s.h ft1, fa0
; RV64IZFHMIN-NEXT:    fadd.s ft0, ft1, ft0
; RV64IZFHMIN-NEXT:    fcvt.h.s ft0, ft0
; RV64IZFHMIN-NEXT:    fsh ft0, 4(sp)
; RV64IZFHMIN-NEXT:    addi a0, sp, 4
; RV64IZFHMIN-NEXT:    call notdead@plt
; RV64IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFHMIN-NEXT:    addi sp, sp, 16
; RV64IZFHMIN-NEXT:    ret
  %1 = fadd half %a, %b ; force store from FPR16
  %2 = alloca half, align 4
  store half %1, ptr %2
  call void @notdead(ptr %2)
  ret void
}
