/*****************************************************************************
 * Copyright (C) 2005-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef DEBUGOUTPUTTEXTEDIT_H
#define DEBUGOUTPUTTEXTEDIT_H

#include <QtGui/QMenu>
#include <QtCore/QPoint>

#include <ktextbrowser.h>

/**
 * This class is used for showing log content
 */
class DebugOutputTextEdit : public KTextBrowser
{
    Q_OBJECT

public:
    DebugOutputTextEdit(QWidget *parent = 0, const char* name = 0);
    ~DebugOutputTextEdit();

public slots:
    void contextMenuEvent(QContextMenuEvent * event);
    void append(const QString & text);

private:
    QMenu *popup;
};

#endif
