// SPDX-FileCopyrightText: 2025 Devin Lin <devin@kde.org>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include <QDBusArgument>
#include <QList>

class VibrationEvent
{
public:
    double amplitude;
    quint64 duration;
};

typedef QList<VibrationEvent> VibrationEventList;

Q_DECLARE_METATYPE(VibrationEvent)
Q_DECLARE_METATYPE(VibrationEventList)

inline QDBusArgument &operator<<(QDBusArgument &argument, const VibrationEvent &e)
{
    argument << e.amplitude;
    argument << e.duration;
    return argument;
}

inline const QDBusArgument &operator>>(const QDBusArgument &argument, VibrationEvent &e)
{
    argument >> e.amplitude;
    argument >> e.duration;
    return argument;
}
