/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.kapt.cli.test;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/kapt3/kapt3-cli/testData/integration")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class KaptToolIntegrationTestGenerated extends AbstractKaptToolIntegrationTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInIntegration() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("plugins/kapt3/kapt3-cli/testData/integration"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, false);
    }

    @TestMetadata("argfile")
    public void testArgfile() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/integration/argfile/");
    }

    @TestMetadata("correctErrorTypesOff")
    public void testCorrectErrorTypesOff() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/integration/correctErrorTypesOff/");
    }

    @TestMetadata("correctErrorTypesOn")
    public void testCorrectErrorTypesOn() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/integration/correctErrorTypesOn/");
    }

    @TestMetadata("separateStubAptCompilation")
    public void testSeparateStubAptCompilation() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/integration/separateStubAptCompilation/");
    }

    @TestMetadata("simple")
    public void testSimple() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/integration/simple/");
    }

    @TestMetadata("withoutService")
    public void testWithoutService() throws Exception {
        runTest("plugins/kapt3/kapt3-cli/testData/integration/withoutService/");
    }
}
