/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "connection.h"
#include "sharedfolder_filtermodel.h"

#include "sharedfolder_listingmodel.h"

void SharedFolderListingModel::doQuery( const QString &userFilter )
{
  QString filter = QString( "(&(cn=*)%1(objectClass=kolabSharedFolder))" ).arg( userFilter );

  mData = Connection::self()->search( QString(), QLdap::Sub, filter );

  emit layoutChanged();
}

int SharedFolderListingModel::columnCount( const QModelIndex &parent ) const
{
  if ( parent.isValid() )
    return 0;

  return 2;
}

int SharedFolderListingModel::rowCount( const QModelIndex &parent ) const
{
  if ( parent.isValid() )
    return 0;

  return mData.entries().count();
}

QVariant SharedFolderListingModel::data( const QModelIndex &index, int role ) const
{
  if ( !index.isValid() )
    return QVariant();

  const QLdapEntry entry = mData.entries()[ index.row() ];

  if ( role == Qt::DisplayRole ) {
    switch ( index.column() ) {
      case 0:
        return entry.value( "cn" );
        break;
      case 1:
        return entry.value( "kolabHomeServer" );
        break;
      default:
        return QVariant();
    }
  } else if ( role == HasModifyActionRole ) {
    return true;
  } else if ( role == HasDeleteActionRole ) {
    if ( entry.values( "kolabDeleteflag" ).isEmpty() )
      return true;
    else
      return false;
  } else if ( role == ModifyActionLabelRole ) {
    if ( entry.values( "kolabDeleteflag" ).isEmpty() )
      return tr( "Modify" );
    else
      return tr( "Shared folder deleted, awaiting cleanup..." );
  } else if ( role == DeleteActionLabelRole ) {
    return tr( "Delete" );
  } else if ( role == ModifyActionIdRole ) {
    if ( entry.values( "kolabDeleteflag" ).isEmpty() )
      return mData.entries()[ index.row() ].dn();
    else
      return QString();
  } else if ( role == DeleteActionIdRole ) {
    return mData.entries()[ index.row() ].dn();
  }

  return QVariant();
}

QVariant SharedFolderListingModel::headerData( int section, Qt::Orientation, int role ) const
{
  if ( role != Qt::DisplayRole )
    return QVariant();

  switch ( section ) {
    case 0:
      return tr( "Name" );
      break;
    case 1:
      return tr( "Server" );
      break;
    default:
      return QVariant();
  }
}

FilterModel* SharedFolderListingModel::filterModel()
{
  return new SharedFolderFilterModel( this );
}
