
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQVideoWindowControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QVideoWindowControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QRect>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QVideoWindowControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QVideoWindowControl::staticMetaObject);
}


// Qt::AspectRatioMode QVideoWindowControl::aspectRatioMode()


static void _init_f_aspectRatioMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::AspectRatioMode>::target_type > ();
}

static void _call_f_aspectRatioMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::AspectRatioMode>::target_type > ((qt_gsi::Converter<Qt::AspectRatioMode>::target_type)qt_gsi::CppToQtAdaptor<Qt::AspectRatioMode>(((QVideoWindowControl *)cls)->aspectRatioMode ()));
}


// int QVideoWindowControl::brightness()


static void _init_f_brightness_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_brightness_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoWindowControl *)cls)->brightness ());
}


// int QVideoWindowControl::contrast()


static void _init_f_contrast_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_contrast_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoWindowControl *)cls)->contrast ());
}


// QRect QVideoWindowControl::displayRect()


static void _init_f_displayRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_displayRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QVideoWindowControl *)cls)->displayRect ());
}


// int QVideoWindowControl::hue()


static void _init_f_hue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_hue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoWindowControl *)cls)->hue ());
}


// bool QVideoWindowControl::isFullScreen()


static void _init_f_isFullScreen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFullScreen_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QVideoWindowControl *)cls)->isFullScreen ());
}


// QSize QVideoWindowControl::nativeSize()


static void _init_f_nativeSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_nativeSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QVideoWindowControl *)cls)->nativeSize ());
}


// void QVideoWindowControl::repaint()


static void _init_f_repaint_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_repaint_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl *)cls)->repaint ();
}


// int QVideoWindowControl::saturation()


static void _init_f_saturation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_saturation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoWindowControl *)cls)->saturation ());
}


// void QVideoWindowControl::setAspectRatioMode(Qt::AspectRatioMode mode)


static void _init_f_setAspectRatioMode_2257 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAspectRatioMode_2257 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl *)cls)->setAspectRatioMode (qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg1).cref());
}


// void QVideoWindowControl::setBrightness(int brightness)


static void _init_f_setBrightness_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brightness");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBrightness_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl *)cls)->setBrightness (arg1);
}


// void QVideoWindowControl::setContrast(int contrast)


static void _init_f_setContrast_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("contrast");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContrast_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl *)cls)->setContrast (arg1);
}


// void QVideoWindowControl::setDisplayRect(const QRect &rect)


static void _init_f_setDisplayRect_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDisplayRect_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl *)cls)->setDisplayRect (arg1);
}


// void QVideoWindowControl::setFullScreen(bool fullScreen)


static void _init_f_setFullScreen_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fullScreen");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFullScreen_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl *)cls)->setFullScreen (arg1);
}


// void QVideoWindowControl::setHue(int hue)


static void _init_f_setHue_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hue");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHue_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl *)cls)->setHue (arg1);
}


// void QVideoWindowControl::setSaturation(int saturation)


static void _init_f_setSaturation_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("saturation");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSaturation_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl *)cls)->setSaturation (arg1);
}


// void QVideoWindowControl::setWinId(WId id)


static void _init_f_setWinId_696 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWinId_696 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl *)cls)->setWinId (qt_gsi::QtToCppAdaptor<WId>(arg1).cref());
}


// WId QVideoWindowControl::winId()


static void _init_f_winId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<WId>::target_type > ();
}

static void _call_f_winId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<WId>::target_type > ((qt_gsi::Converter<WId>::target_type)qt_gsi::CppToQtAdaptor<WId>(((QVideoWindowControl *)cls)->winId ()));
}


// static QString QVideoWindowControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QVideoWindowControl::tr (arg1, arg2, arg3));
}


// static QString QVideoWindowControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QVideoWindowControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QVideoWindowControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":aspectRatioMode", "@brief Method Qt::AspectRatioMode QVideoWindowControl::aspectRatioMode()\n", true, &_init_f_aspectRatioMode_c0, &_call_f_aspectRatioMode_c0);
  methods += new qt_gsi::GenericMethod (":brightness", "@brief Method int QVideoWindowControl::brightness()\n", true, &_init_f_brightness_c0, &_call_f_brightness_c0);
  methods += new qt_gsi::GenericMethod (":contrast", "@brief Method int QVideoWindowControl::contrast()\n", true, &_init_f_contrast_c0, &_call_f_contrast_c0);
  methods += new qt_gsi::GenericMethod (":displayRect", "@brief Method QRect QVideoWindowControl::displayRect()\n", true, &_init_f_displayRect_c0, &_call_f_displayRect_c0);
  methods += new qt_gsi::GenericMethod (":hue", "@brief Method int QVideoWindowControl::hue()\n", true, &_init_f_hue_c0, &_call_f_hue_c0);
  methods += new qt_gsi::GenericMethod ("isFullScreen?|:fullScreen", "@brief Method bool QVideoWindowControl::isFullScreen()\n", true, &_init_f_isFullScreen_c0, &_call_f_isFullScreen_c0);
  methods += new qt_gsi::GenericMethod ("nativeSize", "@brief Method QSize QVideoWindowControl::nativeSize()\n", true, &_init_f_nativeSize_c0, &_call_f_nativeSize_c0);
  methods += new qt_gsi::GenericMethod ("repaint", "@brief Method void QVideoWindowControl::repaint()\n", false, &_init_f_repaint_0, &_call_f_repaint_0);
  methods += new qt_gsi::GenericMethod (":saturation", "@brief Method int QVideoWindowControl::saturation()\n", true, &_init_f_saturation_c0, &_call_f_saturation_c0);
  methods += new qt_gsi::GenericMethod ("setAspectRatioMode|aspectRatioMode=", "@brief Method void QVideoWindowControl::setAspectRatioMode(Qt::AspectRatioMode mode)\n", false, &_init_f_setAspectRatioMode_2257, &_call_f_setAspectRatioMode_2257);
  methods += new qt_gsi::GenericMethod ("setBrightness|brightness=", "@brief Method void QVideoWindowControl::setBrightness(int brightness)\n", false, &_init_f_setBrightness_767, &_call_f_setBrightness_767);
  methods += new qt_gsi::GenericMethod ("setContrast|contrast=", "@brief Method void QVideoWindowControl::setContrast(int contrast)\n", false, &_init_f_setContrast_767, &_call_f_setContrast_767);
  methods += new qt_gsi::GenericMethod ("setDisplayRect|displayRect=", "@brief Method void QVideoWindowControl::setDisplayRect(const QRect &rect)\n", false, &_init_f_setDisplayRect_1792, &_call_f_setDisplayRect_1792);
  methods += new qt_gsi::GenericMethod ("setFullScreen|fullScreen=", "@brief Method void QVideoWindowControl::setFullScreen(bool fullScreen)\n", false, &_init_f_setFullScreen_864, &_call_f_setFullScreen_864);
  methods += new qt_gsi::GenericMethod ("setHue|hue=", "@brief Method void QVideoWindowControl::setHue(int hue)\n", false, &_init_f_setHue_767, &_call_f_setHue_767);
  methods += new qt_gsi::GenericMethod ("setSaturation|saturation=", "@brief Method void QVideoWindowControl::setSaturation(int saturation)\n", false, &_init_f_setSaturation_767, &_call_f_setSaturation_767);
  methods += new qt_gsi::GenericMethod ("setWinId|winId=", "@brief Method void QVideoWindowControl::setWinId(WId id)\n", false, &_init_f_setWinId_696, &_call_f_setWinId_696);
  methods += new qt_gsi::GenericMethod (":winId", "@brief Method WId QVideoWindowControl::winId()\n", true, &_init_f_winId_c0, &_call_f_winId_c0);
  methods += gsi::qt_signal<int > ("brightnessChanged(int)", "brightnessChanged", gsi::arg("brightness"), "@brief Signal declaration for QVideoWindowControl::brightnessChanged(int brightness)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("contrastChanged(int)", "contrastChanged", gsi::arg("contrast"), "@brief Signal declaration for QVideoWindowControl::contrastChanged(int contrast)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QVideoWindowControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("fullScreenChanged(bool)", "fullScreenChanged", gsi::arg("fullScreen"), "@brief Signal declaration for QVideoWindowControl::fullScreenChanged(bool fullScreen)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("hueChanged(int)", "hueChanged", gsi::arg("hue"), "@brief Signal declaration for QVideoWindowControl::hueChanged(int hue)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("nativeSizeChanged()", "nativeSizeChanged", "@brief Signal declaration for QVideoWindowControl::nativeSizeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QVideoWindowControl::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("saturationChanged(int)", "saturationChanged", gsi::arg("saturation"), "@brief Signal declaration for QVideoWindowControl::saturationChanged(int saturation)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QVideoWindowControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QVideoWindowControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QVideoWindowControl> decl_QVideoWindowControl (qtdecl_QMediaControl (), "QtMultimedia", "QVideoWindowControl_Native",
  methods_QVideoWindowControl (),
  "@hide\n@alias QVideoWindowControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QVideoWindowControl> &qtdecl_QVideoWindowControl () { return decl_QVideoWindowControl; }

}


class QVideoWindowControl_Adaptor : public QVideoWindowControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QVideoWindowControl_Adaptor();

  //  [adaptor ctor] QVideoWindowControl::QVideoWindowControl()
  QVideoWindowControl_Adaptor() : QVideoWindowControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QVideoWindowControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QVideoWindowControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QVideoWindowControl::isSignalConnected(signal);
  }

  //  [expose] int QVideoWindowControl::receivers(const char *signal)
  int fp_QVideoWindowControl_receivers_c1731 (const char *signal) const {
    return QVideoWindowControl::receivers(signal);
  }

  //  [expose] QObject *QVideoWindowControl::sender()
  QObject * fp_QVideoWindowControl_sender_c0 () const {
    return QVideoWindowControl::sender();
  }

  //  [expose] int QVideoWindowControl::senderSignalIndex()
  int fp_QVideoWindowControl_senderSignalIndex_c0 () const {
    return QVideoWindowControl::senderSignalIndex();
  }

  //  [adaptor impl] Qt::AspectRatioMode QVideoWindowControl::aspectRatioMode()
  qt_gsi::Converter<Qt::AspectRatioMode>::target_type cbs_aspectRatioMode_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("aspectRatioMode");
  }

  virtual Qt::AspectRatioMode aspectRatioMode() const
  {
    if (cb_aspectRatioMode_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(cb_aspectRatioMode_c0_0.issue<QVideoWindowControl_Adaptor, qt_gsi::Converter<Qt::AspectRatioMode>::target_type>(&QVideoWindowControl_Adaptor::cbs_aspectRatioMode_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("aspectRatioMode");
    }
  }

  //  [adaptor impl] int QVideoWindowControl::brightness()
  int cbs_brightness_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("brightness");
  }

  virtual int brightness() const
  {
    if (cb_brightness_c0_0.can_issue()) {
      return cb_brightness_c0_0.issue<QVideoWindowControl_Adaptor, int>(&QVideoWindowControl_Adaptor::cbs_brightness_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("brightness");
    }
  }

  //  [emitter impl] void QVideoWindowControl::brightnessChanged(int brightness)
  void emitter_QVideoWindowControl_brightnessChanged_767(int brightness)
  {
    emit QVideoWindowControl::brightnessChanged(brightness);
  }

  //  [adaptor impl] int QVideoWindowControl::contrast()
  int cbs_contrast_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("contrast");
  }

  virtual int contrast() const
  {
    if (cb_contrast_c0_0.can_issue()) {
      return cb_contrast_c0_0.issue<QVideoWindowControl_Adaptor, int>(&QVideoWindowControl_Adaptor::cbs_contrast_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("contrast");
    }
  }

  //  [emitter impl] void QVideoWindowControl::contrastChanged(int contrast)
  void emitter_QVideoWindowControl_contrastChanged_767(int contrast)
  {
    emit QVideoWindowControl::contrastChanged(contrast);
  }

  //  [emitter impl] void QVideoWindowControl::destroyed(QObject *)
  void emitter_QVideoWindowControl_destroyed_1302(QObject *arg1)
  {
    emit QVideoWindowControl::destroyed(arg1);
  }

  //  [adaptor impl] QRect QVideoWindowControl::displayRect()
  QRect cbs_displayRect_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("displayRect");
  }

  virtual QRect displayRect() const
  {
    if (cb_displayRect_c0_0.can_issue()) {
      return cb_displayRect_c0_0.issue<QVideoWindowControl_Adaptor, QRect>(&QVideoWindowControl_Adaptor::cbs_displayRect_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("displayRect");
    }
  }

  //  [adaptor impl] bool QVideoWindowControl::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QVideoWindowControl::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QVideoWindowControl_Adaptor, bool, QEvent *>(&QVideoWindowControl_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QVideoWindowControl::event(_event);
    }
  }

  //  [adaptor impl] bool QVideoWindowControl::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QVideoWindowControl::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QVideoWindowControl_Adaptor, bool, QObject *, QEvent *>(&QVideoWindowControl_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QVideoWindowControl::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QVideoWindowControl::fullScreenChanged(bool fullScreen)
  void emitter_QVideoWindowControl_fullScreenChanged_864(bool fullScreen)
  {
    emit QVideoWindowControl::fullScreenChanged(fullScreen);
  }

  //  [adaptor impl] int QVideoWindowControl::hue()
  int cbs_hue_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("hue");
  }

  virtual int hue() const
  {
    if (cb_hue_c0_0.can_issue()) {
      return cb_hue_c0_0.issue<QVideoWindowControl_Adaptor, int>(&QVideoWindowControl_Adaptor::cbs_hue_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("hue");
    }
  }

  //  [emitter impl] void QVideoWindowControl::hueChanged(int hue)
  void emitter_QVideoWindowControl_hueChanged_767(int hue)
  {
    emit QVideoWindowControl::hueChanged(hue);
  }

  //  [adaptor impl] bool QVideoWindowControl::isFullScreen()
  bool cbs_isFullScreen_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isFullScreen");
  }

  virtual bool isFullScreen() const
  {
    if (cb_isFullScreen_c0_0.can_issue()) {
      return cb_isFullScreen_c0_0.issue<QVideoWindowControl_Adaptor, bool>(&QVideoWindowControl_Adaptor::cbs_isFullScreen_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isFullScreen");
    }
  }

  //  [adaptor impl] QSize QVideoWindowControl::nativeSize()
  QSize cbs_nativeSize_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("nativeSize");
  }

  virtual QSize nativeSize() const
  {
    if (cb_nativeSize_c0_0.can_issue()) {
      return cb_nativeSize_c0_0.issue<QVideoWindowControl_Adaptor, QSize>(&QVideoWindowControl_Adaptor::cbs_nativeSize_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("nativeSize");
    }
  }

  //  [emitter impl] void QVideoWindowControl::nativeSizeChanged()
  void emitter_QVideoWindowControl_nativeSizeChanged_0()
  {
    emit QVideoWindowControl::nativeSizeChanged();
  }

  //  [emitter impl] void QVideoWindowControl::objectNameChanged(const QString &objectName)
  void emitter_QVideoWindowControl_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QVideoWindowControl::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QVideoWindowControl::repaint()
  void cbs_repaint_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("repaint");
  }

  virtual void repaint()
  {
    if (cb_repaint_0_0.can_issue()) {
      cb_repaint_0_0.issue<QVideoWindowControl_Adaptor>(&QVideoWindowControl_Adaptor::cbs_repaint_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("repaint");
    }
  }

  //  [adaptor impl] int QVideoWindowControl::saturation()
  int cbs_saturation_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("saturation");
  }

  virtual int saturation() const
  {
    if (cb_saturation_c0_0.can_issue()) {
      return cb_saturation_c0_0.issue<QVideoWindowControl_Adaptor, int>(&QVideoWindowControl_Adaptor::cbs_saturation_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("saturation");
    }
  }

  //  [emitter impl] void QVideoWindowControl::saturationChanged(int saturation)
  void emitter_QVideoWindowControl_saturationChanged_767(int saturation)
  {
    emit QVideoWindowControl::saturationChanged(saturation);
  }

  //  [adaptor impl] void QVideoWindowControl::setAspectRatioMode(Qt::AspectRatioMode mode)
  void cbs_setAspectRatioMode_2257_0(const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & mode)
  {
    __SUPPRESS_UNUSED_WARNING (mode);
    throw qt_gsi::AbstractMethodCalledException("setAspectRatioMode");
  }

  virtual void setAspectRatioMode(Qt::AspectRatioMode mode)
  {
    if (cb_setAspectRatioMode_2257_0.can_issue()) {
      cb_setAspectRatioMode_2257_0.issue<QVideoWindowControl_Adaptor, const qt_gsi::Converter<Qt::AspectRatioMode>::target_type &>(&QVideoWindowControl_Adaptor::cbs_setAspectRatioMode_2257_0, qt_gsi::CppToQtAdaptor<Qt::AspectRatioMode>(mode));
    } else {
      throw qt_gsi::AbstractMethodCalledException("setAspectRatioMode");
    }
  }

  //  [adaptor impl] void QVideoWindowControl::setBrightness(int brightness)
  void cbs_setBrightness_767_0(int brightness)
  {
    __SUPPRESS_UNUSED_WARNING (brightness);
    throw qt_gsi::AbstractMethodCalledException("setBrightness");
  }

  virtual void setBrightness(int brightness)
  {
    if (cb_setBrightness_767_0.can_issue()) {
      cb_setBrightness_767_0.issue<QVideoWindowControl_Adaptor, int>(&QVideoWindowControl_Adaptor::cbs_setBrightness_767_0, brightness);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setBrightness");
    }
  }

  //  [adaptor impl] void QVideoWindowControl::setContrast(int contrast)
  void cbs_setContrast_767_0(int contrast)
  {
    __SUPPRESS_UNUSED_WARNING (contrast);
    throw qt_gsi::AbstractMethodCalledException("setContrast");
  }

  virtual void setContrast(int contrast)
  {
    if (cb_setContrast_767_0.can_issue()) {
      cb_setContrast_767_0.issue<QVideoWindowControl_Adaptor, int>(&QVideoWindowControl_Adaptor::cbs_setContrast_767_0, contrast);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setContrast");
    }
  }

  //  [adaptor impl] void QVideoWindowControl::setDisplayRect(const QRect &rect)
  void cbs_setDisplayRect_1792_0(const QRect &rect)
  {
    __SUPPRESS_UNUSED_WARNING (rect);
    throw qt_gsi::AbstractMethodCalledException("setDisplayRect");
  }

  virtual void setDisplayRect(const QRect &rect)
  {
    if (cb_setDisplayRect_1792_0.can_issue()) {
      cb_setDisplayRect_1792_0.issue<QVideoWindowControl_Adaptor, const QRect &>(&QVideoWindowControl_Adaptor::cbs_setDisplayRect_1792_0, rect);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setDisplayRect");
    }
  }

  //  [adaptor impl] void QVideoWindowControl::setFullScreen(bool fullScreen)
  void cbs_setFullScreen_864_0(bool fullScreen)
  {
    __SUPPRESS_UNUSED_WARNING (fullScreen);
    throw qt_gsi::AbstractMethodCalledException("setFullScreen");
  }

  virtual void setFullScreen(bool fullScreen)
  {
    if (cb_setFullScreen_864_0.can_issue()) {
      cb_setFullScreen_864_0.issue<QVideoWindowControl_Adaptor, bool>(&QVideoWindowControl_Adaptor::cbs_setFullScreen_864_0, fullScreen);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setFullScreen");
    }
  }

  //  [adaptor impl] void QVideoWindowControl::setHue(int hue)
  void cbs_setHue_767_0(int hue)
  {
    __SUPPRESS_UNUSED_WARNING (hue);
    throw qt_gsi::AbstractMethodCalledException("setHue");
  }

  virtual void setHue(int hue)
  {
    if (cb_setHue_767_0.can_issue()) {
      cb_setHue_767_0.issue<QVideoWindowControl_Adaptor, int>(&QVideoWindowControl_Adaptor::cbs_setHue_767_0, hue);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setHue");
    }
  }

  //  [adaptor impl] void QVideoWindowControl::setSaturation(int saturation)
  void cbs_setSaturation_767_0(int saturation)
  {
    __SUPPRESS_UNUSED_WARNING (saturation);
    throw qt_gsi::AbstractMethodCalledException("setSaturation");
  }

  virtual void setSaturation(int saturation)
  {
    if (cb_setSaturation_767_0.can_issue()) {
      cb_setSaturation_767_0.issue<QVideoWindowControl_Adaptor, int>(&QVideoWindowControl_Adaptor::cbs_setSaturation_767_0, saturation);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setSaturation");
    }
  }

  //  [adaptor impl] void QVideoWindowControl::setWinId(WId id)
  void cbs_setWinId_696_0(const qt_gsi::Converter<WId>::target_type & id)
  {
    __SUPPRESS_UNUSED_WARNING (id);
    throw qt_gsi::AbstractMethodCalledException("setWinId");
  }

  virtual void setWinId(WId id)
  {
    if (cb_setWinId_696_0.can_issue()) {
      cb_setWinId_696_0.issue<QVideoWindowControl_Adaptor, const qt_gsi::Converter<WId>::target_type &>(&QVideoWindowControl_Adaptor::cbs_setWinId_696_0, qt_gsi::CppToQtAdaptor<WId>(id));
    } else {
      throw qt_gsi::AbstractMethodCalledException("setWinId");
    }
  }

  //  [adaptor impl] WId QVideoWindowControl::winId()
  qt_gsi::Converter<WId>::target_type cbs_winId_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("winId");
  }

  virtual WId winId() const
  {
    if (cb_winId_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<WId>(cb_winId_c0_0.issue<QVideoWindowControl_Adaptor, qt_gsi::Converter<WId>::target_type>(&QVideoWindowControl_Adaptor::cbs_winId_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("winId");
    }
  }

  //  [adaptor impl] void QVideoWindowControl::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QVideoWindowControl::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QVideoWindowControl_Adaptor, QChildEvent *>(&QVideoWindowControl_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QVideoWindowControl::childEvent(event);
    }
  }

  //  [adaptor impl] void QVideoWindowControl::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QVideoWindowControl::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QVideoWindowControl_Adaptor, QEvent *>(&QVideoWindowControl_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QVideoWindowControl::customEvent(event);
    }
  }

  //  [adaptor impl] void QVideoWindowControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QVideoWindowControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QVideoWindowControl_Adaptor, const QMetaMethod &>(&QVideoWindowControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QVideoWindowControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QVideoWindowControl::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QVideoWindowControl::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QVideoWindowControl_Adaptor, QTimerEvent *>(&QVideoWindowControl_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QVideoWindowControl::timerEvent(event);
    }
  }

  gsi::Callback cb_aspectRatioMode_c0_0;
  gsi::Callback cb_brightness_c0_0;
  gsi::Callback cb_contrast_c0_0;
  gsi::Callback cb_displayRect_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_hue_c0_0;
  gsi::Callback cb_isFullScreen_c0_0;
  gsi::Callback cb_nativeSize_c0_0;
  gsi::Callback cb_repaint_0_0;
  gsi::Callback cb_saturation_c0_0;
  gsi::Callback cb_setAspectRatioMode_2257_0;
  gsi::Callback cb_setBrightness_767_0;
  gsi::Callback cb_setContrast_767_0;
  gsi::Callback cb_setDisplayRect_1792_0;
  gsi::Callback cb_setFullScreen_864_0;
  gsi::Callback cb_setHue_767_0;
  gsi::Callback cb_setSaturation_767_0;
  gsi::Callback cb_setWinId_696_0;
  gsi::Callback cb_winId_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QVideoWindowControl_Adaptor::~QVideoWindowControl_Adaptor() { }

//  Constructor QVideoWindowControl::QVideoWindowControl() (adaptor class)

static void _init_ctor_QVideoWindowControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QVideoWindowControl_Adaptor> ();
}

static void _call_ctor_QVideoWindowControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVideoWindowControl_Adaptor *> (new QVideoWindowControl_Adaptor ());
}


// Qt::AspectRatioMode QVideoWindowControl::aspectRatioMode()

static void _init_cbs_aspectRatioMode_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::AspectRatioMode>::target_type > ();
}

static void _call_cbs_aspectRatioMode_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::AspectRatioMode>::target_type > ((qt_gsi::Converter<Qt::AspectRatioMode>::target_type)((QVideoWindowControl_Adaptor *)cls)->cbs_aspectRatioMode_c0_0 ());
}

static void _set_callback_cbs_aspectRatioMode_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_aspectRatioMode_c0_0 = cb;
}


// int QVideoWindowControl::brightness()

static void _init_cbs_brightness_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_brightness_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoWindowControl_Adaptor *)cls)->cbs_brightness_c0_0 ());
}

static void _set_callback_cbs_brightness_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_brightness_c0_0 = cb;
}


// emitter void QVideoWindowControl::brightnessChanged(int brightness)

static void _init_emitter_brightnessChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brightness");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_brightnessChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QVideoWindowControl_Adaptor *)cls)->emitter_QVideoWindowControl_brightnessChanged_767 (arg1);
}


// void QVideoWindowControl::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// int QVideoWindowControl::contrast()

static void _init_cbs_contrast_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_contrast_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoWindowControl_Adaptor *)cls)->cbs_contrast_c0_0 ());
}

static void _set_callback_cbs_contrast_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_contrast_c0_0 = cb;
}


// emitter void QVideoWindowControl::contrastChanged(int contrast)

static void _init_emitter_contrastChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("contrast");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_contrastChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QVideoWindowControl_Adaptor *)cls)->emitter_QVideoWindowControl_contrastChanged_767 (arg1);
}


// void QVideoWindowControl::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QVideoWindowControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QVideoWindowControl_Adaptor *)cls)->emitter_QVideoWindowControl_destroyed_1302 (arg1);
}


// void QVideoWindowControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// QRect QVideoWindowControl::displayRect()

static void _init_cbs_displayRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_displayRect_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QVideoWindowControl_Adaptor *)cls)->cbs_displayRect_c0_0 ());
}

static void _set_callback_cbs_displayRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_displayRect_c0_0 = cb;
}


// bool QVideoWindowControl::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QVideoWindowControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QVideoWindowControl::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QVideoWindowControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QVideoWindowControl::fullScreenChanged(bool fullScreen)

static void _init_emitter_fullScreenChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fullScreen");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_fullScreenChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QVideoWindowControl_Adaptor *)cls)->emitter_QVideoWindowControl_fullScreenChanged_864 (arg1);
}


// int QVideoWindowControl::hue()

static void _init_cbs_hue_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_hue_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoWindowControl_Adaptor *)cls)->cbs_hue_c0_0 ());
}

static void _set_callback_cbs_hue_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_hue_c0_0 = cb;
}


// emitter void QVideoWindowControl::hueChanged(int hue)

static void _init_emitter_hueChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hue");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_hueChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QVideoWindowControl_Adaptor *)cls)->emitter_QVideoWindowControl_hueChanged_767 (arg1);
}


// bool QVideoWindowControl::isFullScreen()

static void _init_cbs_isFullScreen_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isFullScreen_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QVideoWindowControl_Adaptor *)cls)->cbs_isFullScreen_c0_0 ());
}

static void _set_callback_cbs_isFullScreen_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_isFullScreen_c0_0 = cb;
}


// exposed bool QVideoWindowControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QVideoWindowControl_Adaptor *)cls)->fp_QVideoWindowControl_isSignalConnected_c2394 (arg1));
}


// QSize QVideoWindowControl::nativeSize()

static void _init_cbs_nativeSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_nativeSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QVideoWindowControl_Adaptor *)cls)->cbs_nativeSize_c0_0 ());
}

static void _set_callback_cbs_nativeSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_nativeSize_c0_0 = cb;
}


// emitter void QVideoWindowControl::nativeSizeChanged()

static void _init_emitter_nativeSizeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_nativeSizeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QVideoWindowControl_Adaptor *)cls)->emitter_QVideoWindowControl_nativeSizeChanged_0 ();
}


// emitter void QVideoWindowControl::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QVideoWindowControl_Adaptor *)cls)->emitter_QVideoWindowControl_objectNameChanged_4567 (arg1);
}


// exposed int QVideoWindowControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QVideoWindowControl_Adaptor *)cls)->fp_QVideoWindowControl_receivers_c1731 (arg1));
}


// void QVideoWindowControl::repaint()

static void _init_cbs_repaint_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_repaint_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_repaint_0_0 ();
}

static void _set_callback_cbs_repaint_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_repaint_0_0 = cb;
}


// int QVideoWindowControl::saturation()

static void _init_cbs_saturation_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_saturation_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoWindowControl_Adaptor *)cls)->cbs_saturation_c0_0 ());
}

static void _set_callback_cbs_saturation_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_saturation_c0_0 = cb;
}


// emitter void QVideoWindowControl::saturationChanged(int saturation)

static void _init_emitter_saturationChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("saturation");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_saturationChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QVideoWindowControl_Adaptor *)cls)->emitter_QVideoWindowControl_saturationChanged_767 (arg1);
}


// exposed QObject *QVideoWindowControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QVideoWindowControl_Adaptor *)cls)->fp_QVideoWindowControl_sender_c0 ());
}


// exposed int QVideoWindowControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoWindowControl_Adaptor *)cls)->fp_QVideoWindowControl_senderSignalIndex_c0 ());
}


// void QVideoWindowControl::setAspectRatioMode(Qt::AspectRatioMode mode)

static void _init_cbs_setAspectRatioMode_2257_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setAspectRatioMode_2257_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_setAspectRatioMode_2257_0 (arg1);
}

static void _set_callback_cbs_setAspectRatioMode_2257_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_setAspectRatioMode_2257_0 = cb;
}


// void QVideoWindowControl::setBrightness(int brightness)

static void _init_cbs_setBrightness_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brightness");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setBrightness_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_setBrightness_767_0 (arg1);
}

static void _set_callback_cbs_setBrightness_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_setBrightness_767_0 = cb;
}


// void QVideoWindowControl::setContrast(int contrast)

static void _init_cbs_setContrast_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("contrast");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setContrast_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_setContrast_767_0 (arg1);
}

static void _set_callback_cbs_setContrast_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_setContrast_767_0 = cb;
}


// void QVideoWindowControl::setDisplayRect(const QRect &rect)

static void _init_cbs_setDisplayRect_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setDisplayRect_1792_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_setDisplayRect_1792_0 (arg1);
}

static void _set_callback_cbs_setDisplayRect_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_setDisplayRect_1792_0 = cb;
}


// void QVideoWindowControl::setFullScreen(bool fullScreen)

static void _init_cbs_setFullScreen_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fullScreen");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFullScreen_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_setFullScreen_864_0 (arg1);
}

static void _set_callback_cbs_setFullScreen_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_setFullScreen_864_0 = cb;
}


// void QVideoWindowControl::setHue(int hue)

static void _init_cbs_setHue_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hue");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setHue_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_setHue_767_0 (arg1);
}

static void _set_callback_cbs_setHue_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_setHue_767_0 = cb;
}


// void QVideoWindowControl::setSaturation(int saturation)

static void _init_cbs_setSaturation_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("saturation");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSaturation_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_setSaturation_767_0 (arg1);
}

static void _set_callback_cbs_setSaturation_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_setSaturation_767_0 = cb;
}


// void QVideoWindowControl::setWinId(WId id)

static void _init_cbs_setWinId_696_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setWinId_696_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args.read<const qt_gsi::Converter<WId>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_setWinId_696_0 (arg1);
}

static void _set_callback_cbs_setWinId_696_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_setWinId_696_0 = cb;
}


// void QVideoWindowControl::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoWindowControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// WId QVideoWindowControl::winId()

static void _init_cbs_winId_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<WId>::target_type > ();
}

static void _call_cbs_winId_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<WId>::target_type > ((qt_gsi::Converter<WId>::target_type)((QVideoWindowControl_Adaptor *)cls)->cbs_winId_c0_0 ());
}

static void _set_callback_cbs_winId_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoWindowControl_Adaptor *)cls)->cb_winId_c0_0 = cb;
}


namespace gsi
{

gsi::Class<QVideoWindowControl> &qtdecl_QVideoWindowControl ();

static gsi::Methods methods_QVideoWindowControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVideoWindowControl::QVideoWindowControl()\nThis method creates an object of class QVideoWindowControl.", &_init_ctor_QVideoWindowControl_Adaptor_0, &_call_ctor_QVideoWindowControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("aspectRatioMode", "@brief Virtual method Qt::AspectRatioMode QVideoWindowControl::aspectRatioMode()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_aspectRatioMode_c0_0, &_call_cbs_aspectRatioMode_c0_0);
  methods += new qt_gsi::GenericMethod ("aspectRatioMode", "@hide", true, &_init_cbs_aspectRatioMode_c0_0, &_call_cbs_aspectRatioMode_c0_0, &_set_callback_cbs_aspectRatioMode_c0_0);
  methods += new qt_gsi::GenericMethod ("brightness", "@brief Virtual method int QVideoWindowControl::brightness()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_brightness_c0_0, &_call_cbs_brightness_c0_0);
  methods += new qt_gsi::GenericMethod ("brightness", "@hide", true, &_init_cbs_brightness_c0_0, &_call_cbs_brightness_c0_0, &_set_callback_cbs_brightness_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_brightnessChanged", "@brief Emitter for signal void QVideoWindowControl::brightnessChanged(int brightness)\nCall this method to emit this signal.", false, &_init_emitter_brightnessChanged_767, &_call_emitter_brightnessChanged_767);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QVideoWindowControl::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("contrast", "@brief Virtual method int QVideoWindowControl::contrast()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contrast_c0_0, &_call_cbs_contrast_c0_0);
  methods += new qt_gsi::GenericMethod ("contrast", "@hide", true, &_init_cbs_contrast_c0_0, &_call_cbs_contrast_c0_0, &_set_callback_cbs_contrast_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_contrastChanged", "@brief Emitter for signal void QVideoWindowControl::contrastChanged(int contrast)\nCall this method to emit this signal.", false, &_init_emitter_contrastChanged_767, &_call_emitter_contrastChanged_767);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QVideoWindowControl::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QVideoWindowControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QVideoWindowControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("displayRect", "@brief Virtual method QRect QVideoWindowControl::displayRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_displayRect_c0_0, &_call_cbs_displayRect_c0_0);
  methods += new qt_gsi::GenericMethod ("displayRect", "@hide", true, &_init_cbs_displayRect_c0_0, &_call_cbs_displayRect_c0_0, &_set_callback_cbs_displayRect_c0_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QVideoWindowControl::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QVideoWindowControl::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_fullScreenChanged", "@brief Emitter for signal void QVideoWindowControl::fullScreenChanged(bool fullScreen)\nCall this method to emit this signal.", false, &_init_emitter_fullScreenChanged_864, &_call_emitter_fullScreenChanged_864);
  methods += new qt_gsi::GenericMethod ("hue", "@brief Virtual method int QVideoWindowControl::hue()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hue_c0_0, &_call_cbs_hue_c0_0);
  methods += new qt_gsi::GenericMethod ("hue", "@hide", true, &_init_cbs_hue_c0_0, &_call_cbs_hue_c0_0, &_set_callback_cbs_hue_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_hueChanged", "@brief Emitter for signal void QVideoWindowControl::hueChanged(int hue)\nCall this method to emit this signal.", false, &_init_emitter_hueChanged_767, &_call_emitter_hueChanged_767);
  methods += new qt_gsi::GenericMethod ("isFullScreen", "@brief Virtual method bool QVideoWindowControl::isFullScreen()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isFullScreen_c0_0, &_call_cbs_isFullScreen_c0_0);
  methods += new qt_gsi::GenericMethod ("isFullScreen", "@hide", true, &_init_cbs_isFullScreen_c0_0, &_call_cbs_isFullScreen_c0_0, &_set_callback_cbs_isFullScreen_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QVideoWindowControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("nativeSize", "@brief Virtual method QSize QVideoWindowControl::nativeSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_nativeSize_c0_0, &_call_cbs_nativeSize_c0_0);
  methods += new qt_gsi::GenericMethod ("nativeSize", "@hide", true, &_init_cbs_nativeSize_c0_0, &_call_cbs_nativeSize_c0_0, &_set_callback_cbs_nativeSize_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_nativeSizeChanged", "@brief Emitter for signal void QVideoWindowControl::nativeSizeChanged()\nCall this method to emit this signal.", false, &_init_emitter_nativeSizeChanged_0, &_call_emitter_nativeSizeChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QVideoWindowControl::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QVideoWindowControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("repaint", "@brief Virtual method void QVideoWindowControl::repaint()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_repaint_0_0, &_call_cbs_repaint_0_0);
  methods += new qt_gsi::GenericMethod ("repaint", "@hide", false, &_init_cbs_repaint_0_0, &_call_cbs_repaint_0_0, &_set_callback_cbs_repaint_0_0);
  methods += new qt_gsi::GenericMethod ("saturation", "@brief Virtual method int QVideoWindowControl::saturation()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_saturation_c0_0, &_call_cbs_saturation_c0_0);
  methods += new qt_gsi::GenericMethod ("saturation", "@hide", true, &_init_cbs_saturation_c0_0, &_call_cbs_saturation_c0_0, &_set_callback_cbs_saturation_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_saturationChanged", "@brief Emitter for signal void QVideoWindowControl::saturationChanged(int saturation)\nCall this method to emit this signal.", false, &_init_emitter_saturationChanged_767, &_call_emitter_saturationChanged_767);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QVideoWindowControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QVideoWindowControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setAspectRatioMode", "@brief Virtual method void QVideoWindowControl::setAspectRatioMode(Qt::AspectRatioMode mode)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setAspectRatioMode_2257_0, &_call_cbs_setAspectRatioMode_2257_0);
  methods += new qt_gsi::GenericMethod ("setAspectRatioMode", "@hide", false, &_init_cbs_setAspectRatioMode_2257_0, &_call_cbs_setAspectRatioMode_2257_0, &_set_callback_cbs_setAspectRatioMode_2257_0);
  methods += new qt_gsi::GenericMethod ("setBrightness", "@brief Virtual method void QVideoWindowControl::setBrightness(int brightness)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setBrightness_767_0, &_call_cbs_setBrightness_767_0);
  methods += new qt_gsi::GenericMethod ("setBrightness", "@hide", false, &_init_cbs_setBrightness_767_0, &_call_cbs_setBrightness_767_0, &_set_callback_cbs_setBrightness_767_0);
  methods += new qt_gsi::GenericMethod ("setContrast", "@brief Virtual method void QVideoWindowControl::setContrast(int contrast)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setContrast_767_0, &_call_cbs_setContrast_767_0);
  methods += new qt_gsi::GenericMethod ("setContrast", "@hide", false, &_init_cbs_setContrast_767_0, &_call_cbs_setContrast_767_0, &_set_callback_cbs_setContrast_767_0);
  methods += new qt_gsi::GenericMethod ("setDisplayRect", "@brief Virtual method void QVideoWindowControl::setDisplayRect(const QRect &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setDisplayRect_1792_0, &_call_cbs_setDisplayRect_1792_0);
  methods += new qt_gsi::GenericMethod ("setDisplayRect", "@hide", false, &_init_cbs_setDisplayRect_1792_0, &_call_cbs_setDisplayRect_1792_0, &_set_callback_cbs_setDisplayRect_1792_0);
  methods += new qt_gsi::GenericMethod ("setFullScreen", "@brief Virtual method void QVideoWindowControl::setFullScreen(bool fullScreen)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFullScreen_864_0, &_call_cbs_setFullScreen_864_0);
  methods += new qt_gsi::GenericMethod ("setFullScreen", "@hide", false, &_init_cbs_setFullScreen_864_0, &_call_cbs_setFullScreen_864_0, &_set_callback_cbs_setFullScreen_864_0);
  methods += new qt_gsi::GenericMethod ("setHue", "@brief Virtual method void QVideoWindowControl::setHue(int hue)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHue_767_0, &_call_cbs_setHue_767_0);
  methods += new qt_gsi::GenericMethod ("setHue", "@hide", false, &_init_cbs_setHue_767_0, &_call_cbs_setHue_767_0, &_set_callback_cbs_setHue_767_0);
  methods += new qt_gsi::GenericMethod ("setSaturation", "@brief Virtual method void QVideoWindowControl::setSaturation(int saturation)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSaturation_767_0, &_call_cbs_setSaturation_767_0);
  methods += new qt_gsi::GenericMethod ("setSaturation", "@hide", false, &_init_cbs_setSaturation_767_0, &_call_cbs_setSaturation_767_0, &_set_callback_cbs_setSaturation_767_0);
  methods += new qt_gsi::GenericMethod ("setWinId", "@brief Virtual method void QVideoWindowControl::setWinId(WId id)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setWinId_696_0, &_call_cbs_setWinId_696_0);
  methods += new qt_gsi::GenericMethod ("setWinId", "@hide", false, &_init_cbs_setWinId_696_0, &_call_cbs_setWinId_696_0, &_set_callback_cbs_setWinId_696_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QVideoWindowControl::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("winId", "@brief Virtual method WId QVideoWindowControl::winId()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_winId_c0_0, &_call_cbs_winId_c0_0);
  methods += new qt_gsi::GenericMethod ("winId", "@hide", true, &_init_cbs_winId_c0_0, &_call_cbs_winId_c0_0, &_set_callback_cbs_winId_c0_0);
  return methods;
}

gsi::Class<QVideoWindowControl_Adaptor> decl_QVideoWindowControl_Adaptor (qtdecl_QVideoWindowControl (), "QtMultimedia", "QVideoWindowControl",
  methods_QVideoWindowControl_Adaptor (),
  "@qt\n@brief Binding of QVideoWindowControl");

}

