# generated by gen-config.py DO NOT edit
# vim:fileencoding=utf-8

import typing
from kitty.conf.utils import KeyAction, KittensKeyMap
import kitty.conf.utils
from kitty.rgb import Color
import kitty.rgb
from kitty.types import ParsedShortcut
import kitty.types


option_names = (  # {{{
 'added_bg',
 'added_margin_bg',
 'background',
 'diff_cmd',
 'filler_bg',
 'foreground',
 'highlight_added_bg',
 'highlight_removed_bg',
 'hunk_bg',
 'hunk_margin_bg',
 'map',
 'margin_bg',
 'margin_fg',
 'margin_filler_bg',
 'num_context_lines',
 'pygments_style',
 'removed_bg',
 'removed_margin_bg',
 'replace_tab_by',
 'search_bg',
 'search_fg',
 'select_bg',
 'select_fg',
 'syntax_aliases',
 'title_bg',
 'title_fg')  # }}}


class Options:
    added_bg: Color = Color(red=230, green=255, blue=237)
    added_margin_bg: Color = Color(red=205, green=255, blue=216)
    background: Color = Color(red=255, green=255, blue=255)
    diff_cmd: str = 'auto'
    filler_bg: Color = Color(red=250, green=251, blue=252)
    foreground: Color = Color(red=0, green=0, blue=0)
    highlight_added_bg: Color = Color(red=172, green=242, blue=189)
    highlight_removed_bg: Color = Color(red=253, green=184, blue=192)
    hunk_bg: Color = Color(red=241, green=248, blue=255)
    hunk_margin_bg: Color = Color(red=219, green=237, blue=255)
    margin_bg: Color = Color(red=250, green=251, blue=252)
    margin_fg: Color = Color(red=170, green=170, blue=170)
    margin_filler_bg: typing.Optional[kitty.rgb.Color] = None
    num_context_lines: int = 3
    pygments_style: str = 'default'
    removed_bg: Color = Color(red=255, green=238, blue=240)
    removed_margin_bg: Color = Color(red=255, green=220, blue=224)
    replace_tab_by: str = '    '
    search_bg: Color = Color(red=68, green=68, blue=68)
    search_fg: Color = Color(red=255, green=255, blue=255)
    select_bg: Color = Color(red=180, green=213, blue=254)
    select_fg: typing.Optional[kitty.rgb.Color] = Color(red=0, green=0, blue=0)
    syntax_aliases: typing.Dict[str, str] = {'pyj': 'py', 'pyi': 'py', 'recipe': 'py'}
    title_bg: Color = Color(red=255, green=255, blue=255)
    title_fg: Color = Color(red=0, green=0, blue=0)
    map: typing.List[typing.Tuple[kitty.types.ParsedShortcut, kitty.conf.utils.KeyAction]] = []
    key_definitions: KittensKeyMap = {}
    config_paths: typing.Tuple[str, ...] = ()
    config_overrides: typing.Tuple[str, ...] = ()

    def __init__(self, options_dict: typing.Optional[typing.Dict[str, typing.Any]] = None) -> None:
        if options_dict is not None:
            for key in option_names:
                setattr(self, key, options_dict[key])

    @property
    def _fields(self) -> typing.Tuple[str, ...]:
        return option_names

    def __iter__(self) -> typing.Iterator[str]:
        return iter(self._fields)

    def __len__(self) -> int:
        return len(self._fields)

    def _copy_of_val(self, name: str) -> typing.Any:
        ans = getattr(self, name)
        if isinstance(ans, dict):
            ans = ans.copy()
        elif isinstance(ans, list):
            ans = ans[:]
        return ans

    def _asdict(self) -> typing.Dict[str, typing.Any]:
        return {k: self._copy_of_val(k) for k in self}

    def _replace(self, **kw: typing.Any) -> "Options":
        ans = Options()
        for name in self:
            setattr(ans, name, self._copy_of_val(name))
        for name, val in kw.items():
            setattr(ans, name, val)
        return ans

    def __getitem__(self, key: typing.Union[int, str]) -> typing.Any:
        k = option_names[key] if isinstance(key, int) else key
        try:
            return getattr(self, k)
        except AttributeError:
            pass
        raise KeyError(f"No option named: {k}")


defaults = Options()
defaults.map = [
    # quit
    (ParsedShortcut(mods=0, key_name='q'), KeyAction('quit')),
    # quit
    (ParsedShortcut(mods=0, key_name='ESCAPE'), KeyAction('quit')),
    # scroll_down
    (ParsedShortcut(mods=0, key_name='j'), KeyAction('scroll_by', (1,))),
    # scroll_down
    (ParsedShortcut(mods=0, key_name='DOWN'), KeyAction('scroll_by', (1,))),
    # scroll_up
    (ParsedShortcut(mods=0, key_name='k'), KeyAction('scroll_by', (-1,))),
    # scroll_up
    (ParsedShortcut(mods=0, key_name='UP'), KeyAction('scroll_by', (-1,))),
    # scroll_top
    (ParsedShortcut(mods=0, key_name='HOME'), KeyAction('scroll_to', ('start',))),
    # scroll_bottom
    (ParsedShortcut(mods=0, key_name='END'), KeyAction('scroll_to', ('end',))),
    # scroll_page_down
    (ParsedShortcut(mods=0, key_name='PAGE_DOWN'), KeyAction('scroll_to', ('next-page',))),
    # scroll_page_down
    (ParsedShortcut(mods=0, key_name=' '), KeyAction('scroll_to', ('next-page',))),
    # scroll_page_up
    (ParsedShortcut(mods=0, key_name='PAGE_UP'), KeyAction('scroll_to', ('prev-page',))),
    # next_change
    (ParsedShortcut(mods=0, key_name='n'), KeyAction('scroll_to', ('next-change',))),
    # prev_change
    (ParsedShortcut(mods=0, key_name='p'), KeyAction('scroll_to', ('prev-change',))),
    # all_context
    (ParsedShortcut(mods=0, key_name='a'), KeyAction('change_context', ('all',))),
    # default_context
    (ParsedShortcut(mods=0, key_name='='), KeyAction('change_context', ('default',))),
    # increase_context
    (ParsedShortcut(mods=0, key_name='+'), KeyAction('change_context', (5,))),
    # decrease_context
    (ParsedShortcut(mods=0, key_name='-'), KeyAction('change_context', (-5,))),
    # search_forward
    (ParsedShortcut(mods=0, key_name='/'), KeyAction('start_search', (True, False))),
    # search_backward
    (ParsedShortcut(mods=0, key_name='?'), KeyAction('start_search', (True, True))),
    # next_match
    (ParsedShortcut(mods=0, key_name='.'), KeyAction('scroll_to', ('next-match',))),
    # next_match
    (ParsedShortcut(mods=0, key_name='>'), KeyAction('scroll_to', ('next-match',))),
    # prev_match
    (ParsedShortcut(mods=0, key_name=','), KeyAction('scroll_to', ('prev-match',))),
    # prev_match
    (ParsedShortcut(mods=0, key_name='<'), KeyAction('scroll_to', ('prev-match',))),
    # search_forward_simple
    (ParsedShortcut(mods=0, key_name='f'), KeyAction('start_search', (False, False))),
    # search_backward_simple
    (ParsedShortcut(mods=0, key_name='b'), KeyAction('start_search', (False, True))),
]
