/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionBeanContextFactory;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.Log;

public class DefaultActionBeanContextFactory
implements ActionBeanContextFactory {
    private static final Log log = Log.getInstance(DefaultActionBeanContextFactory.class);
    public static final String CONTEXT_CLASS_NAME = "ActionBeanContext.Class";
    private Configuration configuration;
    private Class<? extends ActionBeanContext> contextClass;

    public void init(Configuration configuration) throws Exception {
        this.setConfiguration(configuration);
        Class<ActionBeanContext> clazz = configuration.getBootstrapPropertyResolver().getClassProperty(CONTEXT_CLASS_NAME, ActionBeanContext.class);
        if (clazz == null) {
            clazz = ActionBeanContext.class;
        } else {
            log.info(DefaultActionBeanContextFactory.class.getSimpleName(), " will use ", ActionBeanContext.class.getSimpleName(), " subclass ", clazz.getName());
        }
        this.contextClass = clazz;
    }

    public ActionBeanContext getContextInstance(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            ActionBeanContext context = this.contextClass.newInstance();
            context.setRequest(request);
            context.setResponse(response);
            return context;
        }
        catch (Exception e) {
            throw new StripesServletException("Could not instantiate configured ActionBeanContext class: " + this.contextClass, e);
        }
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

