/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;

public class RegularGroupFormatter
extends NumericGroupFormatter {
    private int groupSize;
    private String groupSeparator;

    public RegularGroupFormatter(int grpSize, String grpSep) {
        this.groupSize = grpSize;
        this.groupSeparator = grpSep;
    }

    public String format(FastStringBuffer value) {
        int[] valueEx = StringValue.expand(value);
        int[] groupSeparatorVal = StringValue.expand(this.groupSeparator);
        FastStringBuffer temp = new FastStringBuffer(16);
        if (this.groupSize > 0) {
            int i = valueEx.length - 1;
            int j = 0;
            while (i >= 0) {
                if (j != 0 && j % this.groupSize == 0) {
                    temp.prependWideChar(groupSeparatorVal[0]);
                }
                temp.prependWideChar(valueEx[i]);
                --i;
                ++j;
            }
            return temp.toString();
        }
        return value.toString();
    }

    public String getSeparator() {
        return this.groupSeparator;
    }
}

