/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.globus.gram.internal;

public interface GRAMConstants {
    
    /** The job is waiting for resources to become available to run. */
    public static final int STATUS_PENDING     = 1;

    /** The job has received resources and the application is executing. */
    public static final int STATUS_ACTIVE      = 2;

    /* The job terminated before completion because an error, user-triggered
       cancel, or system-triggered cancel. */
    public static final int STATUS_FAILED      = 4;

    /** The job completed successfully */
    public static final int STATUS_DONE        = 8;

    /** The job has been suspended. Resources which were allocated for
     * this job may have been released due to some scheduler-specific
     * reason.
     */
    public static final int STATUS_SUSPENDED   = 16;

    /** The job has not been submitted to the scheduler yet, pending the
     * reception of the GLOBUS_GRAM_PROTOCOL_JOB_SIGNAL_COMMIT_REQUEST
     * signal from a client. 
     */
    public static final int STATUS_UNSUBMITTED = 32;

    /** The job manager is staging in files to run the job. */
    public static final int STATUS_STAGE_IN    = 64;

    /** The job manager is staging out files generated by the job. */
    public static final int STATUS_STAGE_OUT   = 128;
    
    /** A mask of all job states. */
    public static final int STATUS_ALL         = 0xFFFF;

    /** Cancel a job */
    public static final int SIGNAL_CANCEL         = 1;

    /** Suspend a job */
    public static final int SIGNAL_SUSPEND        = 2;

    /** Resume a previously suspended job */
    public static final int SIGNAL_RESUME         = 3;

    /** Change the priority of a job */
    public static final int SIGNAL_PRIORITY       = 4;
    

    /** Signal the job manager to commence with a job submission if the job
     * request was accompanied by the (two_state=yes) RSL attribute. 
     */
    public static final int SIGNAL_COMMIT_REQUEST = 5;
    
    /** Signal the job manager to wait an additional number of seconds
     * (specified by an integer value string as the signal's argument) before
     * timing out a two-phase job commit. 
     */
    public static final int SIGNAL_COMMIT_EXTEND  = 6;
    
    /** Signal the job manager to change the way it is currently handling
     * standard output and/or standard error. The argument for this
     * signal is an RSL containing new stdout, stderr, stdout_position,
     * stderr_position, or remote_io_url relations. 
     */
    public static final int SIGNAL_STDIO_UPDATE   = 7;
    
    /** Signal the job manager to verify  that streamed I/O has been completely
     * received. The argument to this signal contains the number of bytes of stdout
     * and stderr received, seperated by a space. The reply to this signal
     * will be a SUCCESS message if these matched the amount sent by the
     * job manager. Otherwise, an error reply indicating
     * GLOBUS_GRAM_PROTOCOL_ERROR_STDIO_SIZE is returned.
     * If standard output and standard error are merged, only one number should be
     * sent as an argument to this signal. An argument of -1 for either stream
     * size indicates that the client is not interested in the size of that
     * stream. 
     */
    public static final int SIGNAL_STDIO_SIZE     = 8;
    
    /** Signal the job manager to stop managing the current job and terminate.
     * The job continues to run as normal. The job manager will send a
     * state change callback with the job status being FAILED and the error
     * GLOBUS_GRAM_PROTOCOL_ERROR_JM_STOPPED. 
     */
    public static final int SIGNAL_STOP_MANAGER   = 9;
    
    /** Signal the job manager to clean up after the completion of the job if
     * the job RSL contained the (two-phase = yes) relation. 
     */
    public static final int SIGNAL_COMMIT_END     = 10;
    
}
